       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04419.                                     
COB303 DATE-WRITTEN.  JAN 25,2011                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM CALLING CSR02084,CSR00125,CSR02122 & CSR02072.   *        
      *  CSR02084 - THIS PROCEDURE CREATES DPP.                        *        
      *  CSR00125 - THIS PROCEDURE CANCELS ALL PENDING DNP ORDERS.     *        
      *  CSR02122 - THIS PROCEDURE UPDATES VALUES IN CSS_ACCOUNT AND   *        
      *             CSS_CREDIT PROFILE TABLE.                          *        
      *  CSR02072 - THIS PROCEDURE INSERTS DEPOSIT RECORDS.            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00464*  01/25/11  SV95326    PROCEDURE ORIGINALLY CODED.              *        
A03300*  04/21/11  SV95326    CALL CSR02122 WHEN CSR00125 SUCCESSFUL TO*        
A03300*                       UPDATE CSS_ACCOUNT & CSS_CREDIT_PROFILE  *        
A03300*                       TABLE .                                  *        
P00726*  01/23/14  AA97148    CREDIT ARRANGEMENTS - RELEASE 2 CHANGES. *        
P00726*                       CANCEL ACTIVE CREDIT ARRANGEMENTS AND    *        
P00726*                       REPLACED BUSINESS RULE ID.               *        
P0726A*  11/11/14  VV94890    ADDED CRED ARNG HIST ROW WHEN ACTIVE ARNG*        
P0726A*                       IS BEING REPLACED WITH DPP.              *        
P00948*  07/14/16  VENKAT.P   FIX APPL STATUS CODE LENGTH ISSUES.      *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04419'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                           PIC X(40) VALUE            
            'WORKING STORAGE FOR CSR04419 STARTS HERE'.                 
      *                                                                         
       01 WORK-VARIABLES.                                               
          05 PROGRAM-NAME                    PIC X(08) VALUE 'CSR04419'.
          05 WS-INSERT                       PIC X(01) VALUE 'I'.       
          05 WS-SQLSTATE                     PIC X(05) VALUE SPACES.    
          05 WS-UPDATE                       PIC X(01) VALUE 'U'.       
          05 WS-PANEL-NO                     PIC X(04) VALUE '164S'.    
          05 WS-DEPOST-STATUS-CD             PIC X(01) VALUE 'A'.       
          05 WS-SERVICE-TYPE-CD              PIC X(01) VALUE 'U'.       
          05 WS-PANEL-NUMBER                 PIC X(08) VALUE 'PANEL164'.
      *                                                                         
          05 WS-AMT-PYMT-CHAR                PIC X(11).                 
          05 WS-AMT-PYMT-NUM REDEFINES WS-AMT-PYMT-CHAR                 
                                             PIC 9(09)V99.              
COB305    05 WS-AMT-PYMT-DEC        PIC 9(09)V99 COMP-3 VALUE 0.       
      *                                                                         
          05 WS-NO-PYMTS-NUM                 PIC 9(03) VALUE ZERO.      
          05 WS-NO-PYMTS REDEFINES WS-NO-PYMTS-NUM                      
                                             PIC X(03).                 
A03300    05 WS-UPDATE-PROFILE               PIC X(01) VALUE SPACES.    
      *                                                                         
          05  WS-DATABASE                    PIC 9(01) VALUE 0.         
              88 CSR-DATABASE                          VALUE 1.         
              88 SEB-DATABASE                          VALUE 2.         
      *                                                                         
          05 WS-REMARKS-TX.                                             
             49 WS-REMARKS-TX-LEN            PIC S9(4) USAGE COMP.      
             49 WS-REMARKS-TX-TEXT           PIC X(210).                
      *                                                                         
       01 SWITCHES.                                                     
          05 SEND-DONE-SW                    PIC X(01) VALUE 'Y'.       
             88 SEND-DONE-ERROR                        VALUE 'N'.       
             88 SEND-DONE-OK                           VALUE 'Y'.       
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                        PIC S9(09) COMP VALUE 0.   
      * CSR02084 RETURN AREA                                                    
       01 WS-CSR02084-RET-AREA.                                         
          05 WS-RETURN-CODE                  PIC S9(09) COMP VALUE +0.  
          05 WS-CANCELDNP-FLAG               PIC X(01) VALUE SPACES.    
          05 WS-AR-LOCKOUT-IND               PIC X(01) VALUE SPACES.    
          05 WS-ACCT-XFER-TO                 PIC X(13) VALUE SPACES.    
          05 WS-CANCELNOT-FLAG               PIC X(01) VALUE SPACES.    
      * CSR00125 RETURN AREA                                                    
       01  WS-CSR00125-RET-AREA.                                        
           05  WS-SO-RETURN-CD-BD            PIC S9(04) COMP VALUE 0.   
           05  WS-SERV-ORDER-CHAR-BD         PIC X(13) VALUE SPACES.    
           05  WS-ORDER-REASON-BD            PIC X(01) VALUE SPACES.    
           05  WS-RESP-AREA-ID-BD            PIC X(03) VALUE SPACES.    
           05  WS-PENDING-DNP-FLAG-BD        PIC X(01) VALUE SPACES.    
           05  WS-INSERT-WORK-QUEUE-BD       PIC X(01) VALUE SPACES.    
           05  WS-AMOUNT-DISC-BAL            PIC X(12) VALUE SPACES.    
           05  WS-ORDER-TYPE-CD-BD           PIC X(05) VALUE SPACES.    
A03300* CSR02122 RETURN AREA                                                    
A03300 01  WS-CSR02122-RET-AREA.                                        
A03300     05  WS-2122-RETURN-CODE       PIC S9(04) COMP VALUE 0.       
      * CSR02072 RETURN AREA                                                    
       01  WS-CSR02072-RET-AREA.                                        
           05  WS-2072-ERROR-CODE        PIC X(50) VALUE SPACES.        
           05  WS-2072-RETURN-CODE       PIC S9(09) USAGE COMP          
                                                       VALUE ZEROES.    
           05  WS-2072-AR-LOCKOUT-IND    PIC X(01) VALUE SPACES.        
           05  WS-2072-ACCT-XFER-TO      PIC X(13) VALUE SPACES.        
           05  WS-2072-ABEND-PROGRAM     PIC X(20) VALUE SPACES.        
           05  WS-2072-ACTIVE-PARAGRAPH  PIC X(20) VALUE SPACES.        
           05  WS-2072-ABEND-FUNCTION    PIC X(20) VALUE SPACES.        
           05  WS-2072-TABLE-1           PIC X(20) VALUE SPACES.        
           05  WS-2072-TABLE-ELEMENT-1   PIC X(20) VALUE SPACES.        
           05  WS-2072-HOSTVAR-ELEMENT-1 PIC X(20) VALUE SPACES.        
           05  WS-2072-TABLE-ELEMENT-2   PIC X(20) VALUE SPACES.        
           05  WS-2072-HOSTVAR-ELEMENT-2 PIC X(20) VALUE SPACES.        
           05  WS-2072-TABLE-ELEMENT-3   PIC X(20) VALUE SPACES.        
           05  WS-2072-HOSTVAR-ELEMENT-3 PIC X(20) VALUE SPACES.        
           05  WS-2072-TABLE-ELEMENT-4   PIC X(20) VALUE SPACES.        
           05  WS-2072-HOSTVAR-ELEMENT-4 PIC X(20) VALUE SPACES.        
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                   PIC S9(04) COMP VALUE 0.   
P00948    05 S-APPL-STATUS-CODE              PIC X(10) VALUE SPACES.    
          05 S-APPL-PARMS                    PIC X(20) VALUE SPACES.    
      * RESULT SET LOCATOR                                                      
      *01 LOC1 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *01 LOC2 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *01 LOC3 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.            
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_ACCOUNT        - AT                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      **   CSS_DELINQUENCY (C8)                                                 
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBDELQ                                                      
           END-EXEC.                                                            
                                                                        
P00726******************************************************************        
P00726* CSS_CRED_ARNGMENT   - X1                                       *        
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE TBCRARNG                                                  
P00726     END-EXEC.                                                            
P00726                                                                  
P0726A*                                                                         
P0726A******************************************************************06330000
P0726A* CSS_CRED_ARNG_HIST - WY                                        *06340000
P0726A******************************************************************06350000
P0726A*                                                                         
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBCRARHS                                                  
P0726A     END-EXEC.                                                            
P0726A*                                                                         
P00726******************************************************************06330000
P00726* CSS_MNT_TRANS_HIS   - MH                                       *06340000
P00726******************************************************************06350000
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE TBMNHIST                                                  
P00726     END-EXEC.                                                            
P00726                                                                  
P00726******************************************************************        
P00726*  CSS_MT_TRN_HST_DET - MI                                       *        
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE TBMNHDT                                                   
P00726     END-EXEC.                                                            
P00726                                                                  
P00726******************************************************************        
P00726* WORKING STORAGE FOR CPDKR360                                   *00022000
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE CWSKR360                                                  
P00726     END-EXEC.                                                            
P00726                                                                  
P00726******************************************************************06330000
P00726* WORKING STORAGE WS-CODES-DATA-PRESENT                          *06340000
P00726******************************************************************06350000
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE CWS00056                                                  
P00726     END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE DPP_CUR CURSOR
MSQ001          FOR CALL CSR02084( :PARM-PANEL-NAME
                  , :PARM-ACCOUNT-NO
                  , :PARM-AGREEMENT-NO
                  , :PARM-DPP-TYPE
                  , :PARM-DPP-STATUS
                  , :PARM-USER-ID
                  , :PARM-RESP-AREA-ID
                  , :PARM-DPP-REASON
                  , :PARM-DPP-CANCEL-RESN
                  , :PARM-AMT-MO-PYMT
                  , :PARM-PYMT-START-DATE
                  , :PARM-NO-PYMTS
                  , :PARM-AMT-ORIG-ENTERED
                  , :PARM-AMT-UNDEFER-RECV
                  , :PARM-DNP-DATE
                  , :PARM-AMT-EXTRA-DEPOSIT
                  , :PARM-1ST-ERNST-AMT
                  , :PARM-1ST-ERNST-DATE
                  , :PARM-2ND-ERNST-AMT
                  , :PARM-2ND-ERNST-DATE
                  , :PARM-DNP-MINUS1
                  , :PARM-DNP-MINUS-DELINQ
                  , :PARM-TRANS-COMMENTS
                  , :PARM-TRANS-CMTS-LEN
                  , :PARM-PYMT-ARR-CMTS
                  , :PARM-PYMT-ARR-CMTS-LEN
                  , :PARM-DPP-TIMESTAMP
                  , :PARM-LAST-UPDATE-TS
                  , :PARM-DPP-RECV-1
                  , :PARM-DPP-RECV-1-AMT
                  , :PARM-DPP-RECV-1-TS
                  , :PARM-DPP-RECV-1-ID
                  , :PARM-DPP-RECV-2
                  , :PARM-DPP-RECV-2-AMT
                  , :PARM-DPP-RECV-2-TS
                  , :PARM-DPP-RECV-2-ID
                  , :PARM-DPP-RECV-3
                  , :PARM-DPP-RECV-3-AMT
                  , :PARM-DPP-RECV-3-TS
                  , :PARM-DPP-RECV-3-ID
                  , :PARM-DPP-RECV-4
                  , :PARM-DPP-RECV-4-AMT
                  , :PARM-DPP-RECV-4-TS
                  , :PARM-DPP-RECV-4-ID
                  , :PARM-DPP-RECV-5
                  , :PARM-DPP-RECV-5-AMT
                  , :PARM-DPP-RECV-5-TS
                  , :PARM-DPP-RECV-5-ID
                  , :PARM-DPP-RECV-6
                  , :PARM-DPP-RECV-6-AMT
                  , :PARM-DPP-RECV-6-TS
                  , :PARM-DPP-RECV-6-ID
                  , :PARM-DPP-RECV-7
                  , :PARM-DPP-RECV-7-AMT
                  , :PARM-DPP-RECV-7-TS
                  , :PARM-DPP-RECV-7-ID
                  , :PARM-DPP-RECV-8
                  , :PARM-DPP-RECV-8-AMT
                  , :PARM-DPP-RECV-8-TS
                  , :PARM-DPP-RECV-8-ID
                  , :PARM-DPP-RECV-9
                  , :PARM-DPP-RECV-9-AMT
                  , :PARM-DPP-RECV-9-TS
                  , :PARM-DPP-RECV-9-ID
                  , :PARM-DPP-RECV-10
                  , :PARM-DPP-RECV-10-AMT
                  , :PARM-DPP-RECV-10-TS
                  , :PARM-DPP-RECV-10-ID
                  , :PARM-DPP-RECV-11
                  , :PARM-DPP-RECV-11-AMT
                  , :PARM-DPP-RECV-11-TS
                  , :PARM-DPP-RECV-11-ID
                  , :PARM-DPP-RECV-12
                  , :PARM-DPP-RECV-12-AMT
                  , :PARM-DPP-RECV-12-TS
                  , :PARM-DPP-RECV-12-ID
                  , :PARM-DPP-RECV-13
                  , :PARM-DPP-RECV-13-AMT
                  , :PARM-DPP-RECV-13-TS
                  , :PARM-DPP-RECV-13-ID
                  , :PARM-DPP-RECV-14
                  , :PARM-DPP-RECV-14-AMT
                  , :PARM-DPP-RECV-14-TS
                  , :PARM-DPP-RECV-14-ID
                  , :PARM-DPP-RECV-15
                  , :PARM-DPP-RECV-15-AMT
                  , :PARM-DPP-RECV-15-TS
                  , :PARM-DPP-RECV-15-ID
                  , :PARM-DPP-RECV-16
                  , :PARM-DPP-RECV-16-AMT
                  , :PARM-DPP-RECV-16-TS
                  , :PARM-DPP-RECV-16-ID
                  , :PARM-DPP-RECV-17
                  , :PARM-DPP-RECV-17-AMT
                  , :PARM-DPP-RECV-17-TS
                  , :PARM-DPP-RECV-17-ID
                  , :PARM-DPP-RECV-18
                  , :PARM-DPP-RECV-18-AMT
                  , :PARM-DPP-RECV-18-TS
                  , :PARM-DPP-RECV-18-ID
                  , :PARM-DPP-RECV-19
                  , :PARM-DPP-RECV-19-AMT
                  , :PARM-DPP-RECV-19-TS
                  , :PARM-DPP-RECV-19-ID
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CANCEL_DNP CURSOR
MSQ001          FOR CALL CSR00125                                       
                       ( :PARM-ACCOUNT-NO
                  , :PARM-PREMISE-NO
                  , :PARM-USER-ID
                  , :WS-REMARKS-TX
                  , :PARM-UPDATE-REMARKS
                  , :WS-UPDATE
                  , :WS-PANEL-NO
                  , :PARM-ORDER-TYPE-FLAG
                  , :PARM-DNP-CANCEL-REASON
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE DEPOSIT_CUR CURSOR
MSQ001          FOR CALL CSR02072                                       
                 ( :WS-INSERT
                  , :PARM-ACCOUNT-NO
                  , :PARM-AMT-EXTRA-DEPOSIT
                  , :WS-DEPOST-STATUS-CD
                  , :WS-SERVICE-TYPE-CD
                  , :PARM-DEPOSIT-CERT-NO
                  , :PARM-DEP-ACTION-CODE
                  , :PARM-USER-ID
                  , :PARM-COMMENTS
                  , :PARM-COMMENTS-LEN
                  , :PARM-PANEL-COMMENTS
                  , :PARM-PANEL-COMM-LEN
                  , :PARM-BILL-OPTION-CD
                  , :PARM-ORIG-BILL-OPTN
                  , :WS-NO-PYMTS
                  , :PARM-AMT-MONTH-PYMT
                  , :PARM-CODE-DEP-TYPE
                  , :PARM-CUT-DATE
                  , :PARM-PROJECT-CR-DT
                  , :PARM-DUE-DATE
                  , :WS-PANEL-NUMBER
                  , :PARM-LAST-UPDATE-TS
                  , :PARM-CODE-REFUND-ELIG
                  , :PARM-ERROR-SWITCH
                  , :PARM-AUTO-DEP-LETTER-IND
                  , :PARM-AUTO-DEP-LTR-DT
                  , :PARM-AUTO-DEP-NOT-AMT
                  , :PARM-AUTO-DEP-RECALC-AMT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE UPDATE_ACCT_TB CURSOR
MSQ001          FOR CALL CSR02122                                       
A03300                 ( :PARM-ACCOUNT-NO
                  , :PARM-PREMISE-NO
                  , :WS-ORDER-REASON-BD
                  , :PARM-DNP-CANCEL-REASON
                  , :WS-PENDING-DNP-FLAG-BD
                  , :WS-UPDATE-PROFILE
                  , :WS-AMOUNT-DISC-BAL
                  , :WS-PANEL-NO
                  , :WS-ORDER-TYPE-CD-BD
                  , :WS-REMARKS-TX
                  )
MSQ001        END-EXEC.
                  
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-APPL-ID                PIC  X(08).                      
       01  PARM-PANEL-NAME             PIC  X(08).                      
       01  PARM-ACCOUNT-NO             PIC  X(13).                      
       01  PARM-AGREEMENT-NO           PIC  S9(09) COMP.                
       01  PARM-DPP-TYPE               PIC  X(01).                      
       01  PARM-DPP-STATUS             PIC  X(01).                      
       01  PARM-USER-ID                PIC  X(07).                      
       01  PARM-RESP-AREA-ID           PIC  X(03).                      
       01  PARM-DPP-REASON             PIC  X(01).                      
       01  PARM-DPP-CANCEL-RESN        PIC  X(50).                      
       01  PARM-AMT-MO-PYMT            PIC  X(09).                      
       01  PARM-PYMT-START-DATE        PIC  X(10).                      
       01  PARM-NO-PYMTS               PIC  S9(04) COMP.                
       01  PARM-AMT-ORIG-ENTERED       PIC  X(11).                      
       01  PARM-AMT-UNDEFER-RECV       PIC  X(11).                      
       01  PARM-DNP-DATE               PIC  X(10).                      
       01  PARM-AMT-EXTRA-DEPOSIT      PIC  X(11).                      
       01  PARM-1ST-ERNST-AMT          PIC  X(11).                      
       01  PARM-1ST-ERNST-DATE         PIC  X(10).                      
       01  PARM-2ND-ERNST-AMT          PIC  X(11).                      
       01  PARM-2ND-ERNST-DATE         PIC  X(10).                      
       01  PARM-DNP-MINUS1             PIC  X(10).                      
       01  PARM-DNP-MINUS-DELINQ       PIC  X(10).                      
       01  PARM-TRANS-COMMENTS         PIC  X(255).                     
       01  PARM-TRANS-CMTS-LEN         PIC  S9(04) COMP.                
       01  PARM-PYMT-ARR-CMTS          PIC  X(255).                     
       01  PARM-PYMT-ARR-CMTS-LEN      PIC  S9(04) COMP.                
       01  PARM-DPP-TIMESTAMP          PIC  X(26).                      
       01  PARM-LAST-UPDATE-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-1             PIC  X(03).                      
       01  PARM-DPP-RECV-1-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-1-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-1-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-2             PIC  X(03).                      
       01  PARM-DPP-RECV-2-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-2-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-2-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-3             PIC  X(03).                      
       01  PARM-DPP-RECV-3-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-3-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-3-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-4             PIC  X(03).                      
       01  PARM-DPP-RECV-4-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-4-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-4-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-5             PIC  X(03).                      
       01  PARM-DPP-RECV-5-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-5-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-5-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-6             PIC  X(03).                      
       01  PARM-DPP-RECV-6-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-6-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-6-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-7             PIC  X(03).                      
       01  PARM-DPP-RECV-7-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-7-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-7-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-8             PIC  X(03).                      
       01  PARM-DPP-RECV-8-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-8-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-8-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-9             PIC  X(03).                      
       01  PARM-DPP-RECV-9-AMT         PIC  X(11).                      
       01  PARM-DPP-RECV-9-TS          PIC  X(26).                      
       01  PARM-DPP-RECV-9-ID          PIC  X(09).                      
       01  PARM-DPP-RECV-10            PIC  X(03).                      
       01  PARM-DPP-RECV-10-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-10-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-10-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-11            PIC  X(03).                      
       01  PARM-DPP-RECV-11-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-11-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-11-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-12            PIC  X(03).                      
       01  PARM-DPP-RECV-12-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-12-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-12-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-13            PIC  X(03).                      
       01  PARM-DPP-RECV-13-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-13-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-13-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-14            PIC  X(03).                      
       01  PARM-DPP-RECV-14-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-14-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-14-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-15            PIC  X(03).                      
       01  PARM-DPP-RECV-15-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-15-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-15-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-16            PIC  X(03).                      
       01  PARM-DPP-RECV-16-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-16-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-16-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-17            PIC  X(03).                      
       01  PARM-DPP-RECV-17-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-17-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-17-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-18            PIC  X(03).                      
       01  PARM-DPP-RECV-18-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-18-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-18-ID         PIC  X(09).                      
       01  PARM-DPP-RECV-19            PIC  X(03).                      
       01  PARM-DPP-RECV-19-AMT        PIC  X(11).                      
       01  PARM-DPP-RECV-19-TS         PIC  X(26).                      
       01  PARM-DPP-RECV-19-ID         PIC  X(09).                      
      *                                                                         
       01  PARM-PREMISE-NO             PIC  X(10).                      
       01  PARM-REMARK-TX              PIC  X(210).                     
       01  PARM-REMARK-TX-LEN          PIC  S9(04) COMP.                
       01  PARM-UPDATE-REMARKS         PIC  X(01).                      
       01  PARM-ORDER-TYPE-FLAG        PIC  X(01).                      
       01  PARM-DNP-CANCEL-REASON      PIC  X(01).                      
      *                                                                         
       01  PARM-DEPOSIT-CERT-NO        PIC X(09).                       
       01  PARM-DEP-ACTION-CODE        PIC X(01).                       
       01  PARM-COMMENTS               PIC X(210).                      
       01  PARM-COMMENTS-LEN           PIC X(04).                       
       01  PARM-PANEL-COMMENTS         PIC X(72).                       
       01  PARM-PANEL-COMM-LEN         PIC X(04).                       
       01  PARM-BILL-OPTION-CD         PIC X(01).                       
       01  PARM-ORIG-BILL-OPTN         PIC X(01).                       
       01  PARM-AMT-MONTH-PYMT         PIC X(11).                       
       01  PARM-CODE-DEP-TYPE          PIC X(01).                       
       01  PARM-CUT-DATE               PIC X(10).                       
       01  PARM-PROJECT-CR-DT          PIC X(10).                       
       01  PARM-DUE-DATE               PIC X(10).                       
       01  PARM-CODE-REFUND-ELIG       PIC X(01).                       
       01  PARM-ERROR-SWITCH           PIC X(01).                       
       01  PARM-AUTO-DEP-LETTER-IND    PIC X(01).                       
       01  PARM-AUTO-DEP-LTR-DT        PIC X(10).                       
COB305 01 PARM-AUTO-DEP-NOT-AMT        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305 01 PARM-AUTO-DEP-RECALC-AMT        PIC S9(09)V99 COMP-3 VALUE 0.         
      *                                                                         
       PROCEDURE DIVISION USING  PARM-APPL-ID                           
                               , PARM-PANEL-NAME                        
                               , PARM-ACCOUNT-NO                        
                               , PARM-AGREEMENT-NO                      
                               , PARM-DPP-TYPE                          
                               , PARM-DPP-STATUS                        
                               , PARM-USER-ID                           
                               , PARM-RESP-AREA-ID                      
                               , PARM-DPP-REASON                        
                               , PARM-DPP-CANCEL-RESN                   
                               , PARM-AMT-MO-PYMT                       
                               , PARM-PYMT-START-DATE                   
                               , PARM-NO-PYMTS                          
                               , PARM-AMT-ORIG-ENTERED                  
                               , PARM-AMT-UNDEFER-RECV                  
                               , PARM-DNP-DATE                          
                               , PARM-AMT-EXTRA-DEPOSIT                 
                               , PARM-1ST-ERNST-AMT                     
                               , PARM-1ST-ERNST-DATE                    
                               , PARM-2ND-ERNST-AMT                     
                               , PARM-2ND-ERNST-DATE                    
                               , PARM-DNP-MINUS1                        
                               , PARM-DNP-MINUS-DELINQ                  
                               , PARM-TRANS-COMMENTS                    
                               , PARM-TRANS-CMTS-LEN                    
                               , PARM-PYMT-ARR-CMTS                     
                               , PARM-PYMT-ARR-CMTS-LEN                 
                               , PARM-DPP-TIMESTAMP                     
                               , PARM-LAST-UPDATE-TS                    
                               , PARM-DPP-RECV-1                        
                               , PARM-DPP-RECV-1-AMT                    
                               , PARM-DPP-RECV-1-TS                     
                               , PARM-DPP-RECV-1-ID                     
                               , PARM-DPP-RECV-2                        
                               , PARM-DPP-RECV-2-AMT                    
                               , PARM-DPP-RECV-2-TS                     
                               , PARM-DPP-RECV-2-ID                     
                               , PARM-DPP-RECV-3                        
                               , PARM-DPP-RECV-3-AMT                    
                               , PARM-DPP-RECV-3-TS                     
                               , PARM-DPP-RECV-3-ID                     
                               , PARM-DPP-RECV-4                        
                               , PARM-DPP-RECV-4-AMT                    
                               , PARM-DPP-RECV-4-TS                     
                               , PARM-DPP-RECV-4-ID                     
                               , PARM-DPP-RECV-5                        
                               , PARM-DPP-RECV-5-AMT                    
                               , PARM-DPP-RECV-5-TS                     
                               , PARM-DPP-RECV-5-ID                     
                               , PARM-DPP-RECV-6                        
                               , PARM-DPP-RECV-6-AMT                    
                               , PARM-DPP-RECV-6-TS                     
                               , PARM-DPP-RECV-6-ID                     
                               , PARM-DPP-RECV-7                        
                               , PARM-DPP-RECV-7-AMT                    
                               , PARM-DPP-RECV-7-TS                     
                               , PARM-DPP-RECV-7-ID                     
                               , PARM-DPP-RECV-8                        
                               , PARM-DPP-RECV-8-AMT                    
                               , PARM-DPP-RECV-8-TS                     
                               , PARM-DPP-RECV-8-ID                     
                               , PARM-DPP-RECV-9                        
                               , PARM-DPP-RECV-9-AMT                    
                               , PARM-DPP-RECV-9-TS                     
                               , PARM-DPP-RECV-9-ID                     
                               , PARM-DPP-RECV-10                       
                               , PARM-DPP-RECV-10-AMT                   
                               , PARM-DPP-RECV-10-TS                    
                               , PARM-DPP-RECV-10-ID                    
                               , PARM-DPP-RECV-11                       
                               , PARM-DPP-RECV-11-AMT                   
                               , PARM-DPP-RECV-11-TS                    
                               , PARM-DPP-RECV-11-ID                    
                               , PARM-DPP-RECV-12                       
                               , PARM-DPP-RECV-12-AMT                   
                               , PARM-DPP-RECV-12-TS                    
                               , PARM-DPP-RECV-12-ID                    
                               , PARM-DPP-RECV-13                       
                               , PARM-DPP-RECV-13-AMT                   
                               , PARM-DPP-RECV-13-TS                    
                               , PARM-DPP-RECV-13-ID                    
                               , PARM-DPP-RECV-14                       
                               , PARM-DPP-RECV-14-AMT                   
                               , PARM-DPP-RECV-14-TS                    
                               , PARM-DPP-RECV-14-ID                    
                               , PARM-DPP-RECV-15                       
                               , PARM-DPP-RECV-15-AMT                   
                               , PARM-DPP-RECV-15-TS                    
                               , PARM-DPP-RECV-15-ID                    
                               , PARM-DPP-RECV-16                       
                               , PARM-DPP-RECV-16-AMT                   
                               , PARM-DPP-RECV-16-TS                    
                               , PARM-DPP-RECV-16-ID                    
                               , PARM-DPP-RECV-17                       
                               , PARM-DPP-RECV-17-AMT                   
                               , PARM-DPP-RECV-17-TS                    
                               , PARM-DPP-RECV-17-ID                    
                               , PARM-DPP-RECV-18                       
                               , PARM-DPP-RECV-18-AMT                   
                               , PARM-DPP-RECV-18-TS                    
                               , PARM-DPP-RECV-18-ID                    
                               , PARM-DPP-RECV-19                       
                               , PARM-DPP-RECV-19-AMT                   
                               , PARM-DPP-RECV-19-TS                    
                               , PARM-DPP-RECV-19-ID                    
                               , PARM-PREMISE-NO                        
                               , PARM-REMARK-TX                         
                               , PARM-REMARK-TX-LEN                     
                               , PARM-UPDATE-REMARKS                    
                               , PARM-ORDER-TYPE-FLAG                   
                               , PARM-DNP-CANCEL-REASON                 
                               , PARM-DEPOSIT-CERT-NO                   
                               , PARM-DEP-ACTION-CODE                   
                               , PARM-COMMENTS                          
                               , PARM-COMMENTS-LEN                      
                               , PARM-PANEL-COMMENTS                    
                               , PARM-PANEL-COMM-LEN                    
                               , PARM-BILL-OPTION-CD                    
                               , PARM-ORIG-BILL-OPTN                    
                               , PARM-AMT-MONTH-PYMT                    
                               , PARM-CODE-DEP-TYPE                     
                               , PARM-CUT-DATE                          
                               , PARM-PROJECT-CR-DT                     
                               , PARM-DUE-DATE                          
                               , PARM-CODE-REFUND-ELIG                  
                               , PARM-ERROR-SWITCH                      
                               , PARM-AUTO-DEP-LETTER-IND               
                               , PARM-AUTO-DEP-LTR-DT                   
                               , PARM-AUTO-DEP-NOT-AMT                  
                               , PARM-AUTO-DEP-RECALC-AMT.              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
      *                                                                         
           MOVE PARM-REMARK-TX-LEN        TO WS-REMARKS-TX-LEN.         
           MOVE PARM-REMARK-TX            TO WS-REMARKS-TX-TEXT.        
           MOVE 'DATABASE'                TO C8-DELINQ-CD               
           MOVE '01'                      TO C8-COMPANY-NO              
           PERFORM 7005-GET-INIT-DELINQ   THRU 7005-EXIT.               
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * DECLARE GLOBAL TEMPORARY TABLE.                                *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04419_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04419_R1
              (                                                          
               RETURN_CODE              INT                         
P00948        ,APPL_STATUS_CODE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,APPL_PARMS CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00000300
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04419_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                   RETURN_CODE                                          
P00948            ,LTRIM(RTRIM(APPL_STATUS_CODE)) AS APPL_STATUS_CODE           
                  ,APPL_PARMS                                           
               FROM #CSR04419_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,TRIM(APPL_STATUS_CODE) AS APPL_STATUS_CODE                   
MFA-TR*           ,APPL_PARMS                                                   
MFA-TR*        FROM SESSION.CSR04419_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
      *                                                                         
      *                                                                         
       0100A-EXIT.                                                      
               EXIT.                                                    
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO               TO AT-ACCOUNT-NO.         
           IF PARM-PREMISE-NO > SPACES                                  
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 7000-GET-PREMISE-NO     THRU 7000-EXIT            
              MOVE AT-PREMISE-NO              TO PARM-PREMISE-NO        
           END-IF.                                                      
      *                                                                         
           MOVE PARM-NO-PYMTS                 TO WS-NO-PYMTS-NUM.       
A03300     MOVE 'R'                           TO PARM-DNP-CANCEL-REASON.
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
P00726     PERFORM 7010-GET-TIMESTAMP      THRU 7010-EXIT.              
           PERFORM 2100-CREATE-DPP         THRU 2100-EXIT.              
           PERFORM 2200-CANCEL-DNP         THRU 2200-EXIT.              
      *                                                                         
           MOVE PARM-AMT-EXTRA-DEPOSIT     TO WS-AMT-PYMT-CHAR.         
           MOVE WS-AMT-PYMT-NUM            TO WS-AMT-PYMT-DEC.          
           IF WS-AMT-PYMT-DEC > 0                                       
              PERFORM 2300-INSERT-DEPOSIT  THRU 2300-EXIT               
           END-IF.                                                      
P00726     PERFORM 7015-GET-CODES-DATA-PRESENT   THRU 7015-EXIT.        
P00726     MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT.    
P00726     PERFORM 2400-CANCEL-CRED-ARRANGEMENTS THRU 2400-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-CREATE-DPP.                                               *        
      ******************************************************************        
      *                                                                         
       2100-CREATE-DPP.                                                 
      *                                                                         
           PERFORM 5100-CALL-CSR02084        THRU 5100-EXIT.            
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC1)                                                  
      *        WITH PROCEDURE CSR02084                                  
      *    END-EXEC                                                     
      *                                                                         
      *    EXEC SQL                                                     
      *        ALLOCATE DPP_CUR CURSOR FOR RESULT SET                   
      *        :LOC1                                                    
      *    END-EXEC                                                     
      *                                                                         
           PERFORM 5150-FETCH-CSR02084       THRU 5150-EXIT.            
           EVALUATE WS-RETURN-CODE                                      
              WHEN 0                                                    
                   MOVE WS-RETURN-CODE       TO S-RETURN-CODE           
      * DPP SUCCESSFULLY CREATED                                                
P00726             MOVE 'CRDARNG073'         TO S-APPL-STATUS-CODE      
                   MOVE PARM-AGREEMENT-NO    TO S-APPL-PARMS            
                   PERFORM 8100-INSERT-GTT   THRU 8100-EXIT             
              WHEN 100                                                  
                   MOVE WS-RETURN-CODE       TO S-RETURN-CODE           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9999-END-PROGRAM  THRU 9999-EXIT             
              WHEN 5000                                                 
                   MOVE 0                    TO S-RETURN-CODE           
                   IF WS-ACCT-XFER-TO > 0                               
      * ACCT HAS 'XFER' FORWARD FLAG ON                                         
P00726                MOVE 'CRDARNG071'      TO S-APPL-STATUS-CODE      
                      MOVE WS-ACCT-XFER-TO   TO S-APPL-PARMS            
                   ELSE                                                 
      * AR LOCK-OUT IS ON                                                       
P00726                MOVE 'CRDARNG069'      TO S-APPL-STATUS-CODE      
                      MOVE SPACES            TO S-APPL-PARMS            
                   END-IF                                               
                   PERFORM 8100-INSERT-GTT   THRU 8100-EXIT             
                   PERFORM 9999-END-PROGRAM  THRU 9999-EXIT             
              WHEN 5272                                                 
                   MOVE 0                    TO S-RETURN-CODE           
      * ACCT MODIFIED SINCE LAST RETRIEVE                                       
P00726             MOVE 'CRDARNG070'         TO S-APPL-STATUS-CODE      
                   MOVE SPACES               TO S-APPL-PARMS            
                   PERFORM 8100-INSERT-GTT   THRU 8100-EXIT             
                   PERFORM 9999-END-PROGRAM  THRU 9999-EXIT             
              WHEN OTHER                                                
                   MOVE WS-RETURN-CODE       TO S-RETURN-CODE           
                   MOVE SPACES               TO S-APPL-STATUS-CODE      
                   MOVE SPACES               TO S-APPL-PARMS            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9999-END-PROGRAM  THRU 9999-EXIT             
           END-EVALUATE                                                 
      *                                                                         
           PERFORM 5200-CLOSE-CSR02084       THRU 5200-EXIT.            
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-CANCEL-DNP.                                               *        
      ******************************************************************        
      *                                                                         
        2200-CANCEL-DNP.                                                
      *                                                                         
           PERFORM 5250-CALL-CSR00125      THRU 5250-EXIT.              
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC2)                                                  
      *        WITH PROCEDURE CSR00125                                  
      *    END-EXEC                                                     
      *                                                                         
      *    EXEC SQL                                                     
      *        ALLOCATE CANCEL_DNP CURSOR FOR RESULT SET                
      *        :LOC2                                                    
      *    END-EXEC                                                     
      *                                                                         
           PERFORM 5300-FETCH-CSR00125     THRU 5300-EXIT.              
           EVALUATE WS-SO-RETURN-CD-BD                                  
              WHEN 0                                                    
                   IF CSR-DATABASE                                      
A03300                PERFORM 2250-UPD-ACCT-CRED-PROF-TB THRU 2250-EXIT 
                      MOVE 0                  TO S-RETURN-CODE          
      * DNP CANCELLED SUCCESSFULLY                                              
                      MOVE 'BP0005'           TO S-APPL-STATUS-CODE     
                      MOVE SPACES             TO S-APPL-PARMS           
                      PERFORM 8100-INSERT-GTT     THRU 8100-EXIT        
                   END-IF                                               
              WHEN 5000                                                 
                   IF CSR-DATABASE                                      
                      MOVE 0                      TO S-RETURN-CODE      
      * DNP IS IN ROUTE                                                         
                      MOVE 'BP0006'               TO S-APPL-STATUS-CODE 
                      MOVE SPACES                 TO S-APPL-PARMS       
                      PERFORM 8100-INSERT-GTT     THRU 8100-EXIT        
                   END-IF                                               
              WHEN 100                                                  
                   CONTINUE                                             
              WHEN OTHER                                                
                   MOVE WS-SO-RETURN-CD-BD TO S-RETURN-CODE             
                   MOVE SPACES             TO S-APPL-STATUS-CODE        
                   MOVE SPACES             TO S-APPL-PARMS              
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9999-END-PROGRAM       THRU 9999-EXIT        
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 5350-CLOSE-CSR00125     THRU 5350-EXIT.              
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03300******************************************************************        
A03300* 2250-UPD-ACCT-CRED-PROF-TB.                                             
A03300******************************************************************        
A03300*                                                                         
A03300  2250-UPD-ACCT-CRED-PROF-TB.                                     
A03300*                                                                         
A03300     IF WS-ORDER-TYPE-CD-BD = 'DNPFB'                             
A03300         MOVE 'N'                    TO WS-UPDATE-PROFILE         
A03300     ELSE                                                         
A03300         MOVE 'Y'                    TO WS-UPDATE-PROFILE         
A03300     END-IF.                                                      
A03300     PERFORM 5550-CALL-CSR02122      THRU 5550-EXIT.              
A03300*                                                                         
A03300*    EXEC SQL                                                     
A03300*        ASSOCIATE LOCATORS                                       
A03300*        (:LOC2)                                                  
A03300*        WITH PROCEDURE CSR02122                                  
A03300*    END-EXEC                                                     
A03300*                                                                         
A03300*    EXEC SQL                                                     
A03300*        ALLOCATE UPDATE_ACCT_TB CURSOR FOR RESULT SET            
A03300*        :LOC2                                                    
A03300*    END-EXEC                                                     
A03300*                                                                         
A03300     PERFORM 5600-FETCH-CSR02122     THRU 5600-EXIT.              
A03300     EVALUATE WS-2122-RETURN-CODE                                 
A03300        WHEN 0                                                    
A03300             CONTINUE                                             
A03300        WHEN 1000                                                 
A03300             CONTINUE                                             
A03300        WHEN OTHER                                                
A03300             MOVE WS-2122-RETURN-CODE TO S-RETURN-CODE            
A03300             MOVE SPACES              TO S-APPL-STATUS-CODE       
A03300             MOVE SPACES              TO S-APPL-PARMS             
A03300             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A03300             PERFORM 9999-END-PROGRAM       THRU 9999-EXIT        
A03300     END-EVALUATE.                                                
A03300*                                                                         
A03300     PERFORM 5650-CLOSE-CSR02122     THRU 5650-EXIT.              
A03300*                                                                         
A03300 2250-EXIT.                                                       
A03300     EXIT.                                                        
A03300*                                                                         
      ******************************************************************        
      * 2300-INSERT-DEPOSIT.                                           *        
      ******************************************************************        
      *                                                                         
        2300-INSERT-DEPOSIT.                                            
      *                                                                         
           PERFORM 5400-CALL-CSR02072      THRU 5400-EXIT.              
      *                                                                         
      *    EXEC SQL                                                     
      *        ASSOCIATE LOCATORS                                       
      *        (:LOC3)                                                  
      *        WITH PROCEDURE CSR02072                                  
      *    END-EXEC                                                     
      *                                                                         
      *    EXEC SQL                                                     
      *        ALLOCATE DEPOSIT_CUR CURSOR FOR RESULT SET               
      *        :LOC3                                                    
      *    END-EXEC                                                     
      *                                                                         
           PERFORM 5450-FETCH-CSR02072     THRU 5450-EXIT.              
           EVALUATE WS-2072-RETURN-CODE                                 
              WHEN 0                                                    
                 EVALUATE WS-2072-ERROR-CODE                            
                   WHEN SPACES                                          
                      MOVE 0                   TO S-RETURN-CODE         
      * DEPOSIT CREATED SUCCESSFULLY                                            
                      MOVE 'BP0008'            TO S-APPL-STATUS-CODE    
                      MOVE PARM-DEPOSIT-CERT-NO TO S-APPL-PARMS         
                      PERFORM 8100-INSERT-GTT THRU 8100-EXIT            
                   WHEN 'A'                                             
                      MOVE 0                   TO S-RETURN-CODE         
      * DNP EXISTS                                                              
                      MOVE 'BP0009'            TO S-APPL-STATUS-CODE    
                      MOVE SPACES              TO S-APPL-PARMS          
                      PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT     
                      PERFORM 9999-END-PROGRAM THRU 9999-EXIT           
                   WHEN 'IMMED-DEP-FOUND'                               
                      MOVE 0                   TO S-RETURN-CODE         
      * BILL IMMEDIATE DEPOSIT FOUND                                            
                      MOVE 'BP0010'            TO S-APPL-STATUS-CODE    
                      MOVE SPACES              TO S-APPL-PARMS          
                      PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT     
                      PERFORM 9999-END-PROGRAM THRU 9999-EXIT           
                   WHEN OTHER                                           
                      MOVE WS-2072-ERROR-CODE  TO S-RETURN-CODE         
      * INVALID ERROR CODE IN DEPOSIT                                           
                      MOVE 'BP0013'            TO S-APPL-STATUS-CODE    
                      MOVE SPACES              TO S-APPL-PARMS          
                      PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT     
                      PERFORM 9999-END-PROGRAM THRU 9999-EXIT           
                 END-EVALUATE                                           
              WHEN 5000                                                 
                   MOVE 0                    TO S-RETURN-CODE           
                   IF WS-ACCT-XFER-TO > 0                               
      * ACCT HAS 'XFER' FORWARD FLAG ON                                         
                      MOVE 'BP0002'          TO S-APPL-STATUS-CODE      
                      MOVE WS-ACCT-XFER-TO   TO S-APPL-PARMS            
                   ELSE                                                 
      * AR LOCK-OUT IS ON                                                       
                      MOVE 'BP0003'          TO S-APPL-STATUS-CODE      
                      MOVE SPACES            TO S-APPL-PARMS            
                   END-IF                                               
                   PERFORM 8100-INSERT-GTT   THRU 8100-EXIT             
                   PERFORM 9999-END-PROGRAM  THRU 9999-EXIT             
              WHEN 5272                                                 
                  MOVE 0                 TO S-RETURN-CODE               
      * ACCT MODIFIED SINCE LAST RETRIEVE                                       
                  MOVE 'BP0004'          TO S-APPL-STATUS-CODE          
                  MOVE SPACES            TO S-APPL-PARMS                
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT               
              WHEN OTHER                                                
                  MOVE WS-RETURN-CODE    TO S-RETURN-CODE               
                  MOVE SPACES            TO S-APPL-STATUS-CODE          
                  MOVE SPACES            TO S-APPL-PARMS                
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT               
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 5500-CLOSE-CSR02072     THRU 5500-EXIT.              
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00726******************************************************************        
P00726* 2400-CANCEL-CRED-ARRANGEMENTS                                  *        
P00726******************************************************************        
P00726                                                                  
P00726 2400-CANCEL-CRED-ARRANGEMENTS.                                   
P00726                                                                  
P00726     MOVE AT-ACCOUNT-NO             TO WS-KR360-ACCOUNT-NO.       
P00726     MOVE 0                         TO WS-KR360-PREMISE-NO        
P00726                                       WS-KR360-CUSTOMER-NO.      
P00726     MOVE PARM-RESP-AREA-ID         TO WS-KR360-RESP-AREA-ID.     
P00726     MOVE PARM-USER-ID              TO WS-KR360-USER-ID.          
P00726     MOVE 'F'                       TO WS-KR360-CODE-TRAN-TYPE.   
P00726     MOVE 'Y'                       TO WS-KR360-OVERRIDE-FLAG.    
P00726     STRING 'ACTIVE CREDIT ARRANGEMENT WAS CANCELLED AND NE'      
P0726A            'W DEFERRED PAYMENT PLAN HAS BEEN SETUP.'             
P00726                                       DELIMITED BY SIZE          
P00726                                       INTO WS-KR360-COMMENT-TEXT.
P0726A     MOVE +85                       TO WS-KR360-COMMENT-LEN.      
P00726     PERFORM 5100-CNCL-CRED-ARNG-PROCESS THRU 5100-CPD360-EXIT.   
P00726                                                                  
P00726 2400-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************        
      * 5100-CALL-CSR02084.                                            *        
      ******************************************************************        
      *                                                                         
       5100-CALL-CSR02084.                                              
      *                                                                         
           INITIALIZE WS-CSR02084-RET-AREA.                             
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR02084(:PARM-PANEL-NAME                          
      *                      ,:PARM-ACCOUNT-NO                          
      *                      ,:PARM-AGREEMENT-NO                        
      *                      ,:PARM-DPP-TYPE                            
      *                      ,:PARM-DPP-STATUS                          
      *                      ,:PARM-USER-ID                             
      *                      ,:PARM-RESP-AREA-ID                        
      *                      ,:PARM-DPP-REASON                          
      *                      ,:PARM-DPP-CANCEL-RESN                     
      *                      ,:PARM-AMT-MO-PYMT                         
      *                      ,:PARM-PYMT-START-DATE                     
      *                      ,:PARM-NO-PYMTS                            
      *                      ,:PARM-AMT-ORIG-ENTERED                    
      *                      ,:PARM-AMT-UNDEFER-RECV                    
      *                      ,:PARM-DNP-DATE                            
      *                      ,:PARM-AMT-EXTRA-DEPOSIT                   
      *                      ,:PARM-1ST-ERNST-AMT                       
      *                      ,:PARM-1ST-ERNST-DATE                      
      *                      ,:PARM-2ND-ERNST-AMT                       
      *                      ,:PARM-2ND-ERNST-DATE                      
      *                      ,:PARM-DNP-MINUS1                          
      *                      ,:PARM-DNP-MINUS-DELINQ                    
      *                      ,:PARM-TRANS-COMMENTS                      
      *                      ,:PARM-TRANS-CMTS-LEN                      
      *                      ,:PARM-PYMT-ARR-CMTS                       
      *                      ,:PARM-PYMT-ARR-CMTS-LEN                   
      *                      ,:PARM-DPP-TIMESTAMP                       
      *                      ,:PARM-LAST-UPDATE-TS                      
      *                      ,:PARM-DPP-RECV-1                          
      *                      ,:PARM-DPP-RECV-1-AMT                      
      *                      ,:PARM-DPP-RECV-1-TS                       
      *                      ,:PARM-DPP-RECV-1-ID                       
      *                      ,:PARM-DPP-RECV-2                          
      *                      ,:PARM-DPP-RECV-2-AMT                      
      *                      ,:PARM-DPP-RECV-2-TS                       
      *                      ,:PARM-DPP-RECV-2-ID                       
      *                      ,:PARM-DPP-RECV-3                          
      *                      ,:PARM-DPP-RECV-3-AMT                      
      *                      ,:PARM-DPP-RECV-3-TS                       
      *                      ,:PARM-DPP-RECV-3-ID                       
      *                      ,:PARM-DPP-RECV-4                          
      *                      ,:PARM-DPP-RECV-4-AMT                      
      *                      ,:PARM-DPP-RECV-4-TS                       
      *                      ,:PARM-DPP-RECV-4-ID                       
      *                      ,:PARM-DPP-RECV-5                          
      *                      ,:PARM-DPP-RECV-5-AMT                      
      *                      ,:PARM-DPP-RECV-5-TS                       
      *                      ,:PARM-DPP-RECV-5-ID                       
      *                      ,:PARM-DPP-RECV-6                          
      *                      ,:PARM-DPP-RECV-6-AMT                      
      *                      ,:PARM-DPP-RECV-6-TS                       
      *                      ,:PARM-DPP-RECV-6-ID                       
      *                      ,:PARM-DPP-RECV-7                          
      *                      ,:PARM-DPP-RECV-7-AMT                      
      *                      ,:PARM-DPP-RECV-7-TS                       
      *                      ,:PARM-DPP-RECV-7-ID                       
      *                      ,:PARM-DPP-RECV-8                          
      *                      ,:PARM-DPP-RECV-8-AMT                      
      *                      ,:PARM-DPP-RECV-8-TS                       
      *                      ,:PARM-DPP-RECV-8-ID                       
      *                      ,:PARM-DPP-RECV-9                          
      *                      ,:PARM-DPP-RECV-9-AMT                      
      *                      ,:PARM-DPP-RECV-9-TS                       
      *                      ,:PARM-DPP-RECV-9-ID                       
      *                      ,:PARM-DPP-RECV-10                         
      *                      ,:PARM-DPP-RECV-10-AMT                     
      *                      ,:PARM-DPP-RECV-10-TS                      
      *                      ,:PARM-DPP-RECV-10-ID                      
      *                      ,:PARM-DPP-RECV-11                         
      *                      ,:PARM-DPP-RECV-11-AMT                     
      *                      ,:PARM-DPP-RECV-11-TS                      
      *                      ,:PARM-DPP-RECV-11-ID                      
      *                      ,:PARM-DPP-RECV-12                         
      *                      ,:PARM-DPP-RECV-12-AMT                     
      *                      ,:PARM-DPP-RECV-12-TS                      
      *                      ,:PARM-DPP-RECV-12-ID                      
      *                      ,:PARM-DPP-RECV-13                         
      *                      ,:PARM-DPP-RECV-13-AMT                     
      *                      ,:PARM-DPP-RECV-13-TS                      
      *                      ,:PARM-DPP-RECV-13-ID                      
      *                      ,:PARM-DPP-RECV-14                         
      *                      ,:PARM-DPP-RECV-14-AMT                     
      *                      ,:PARM-DPP-RECV-14-TS                      
      *                      ,:PARM-DPP-RECV-14-ID                      
      *                      ,:PARM-DPP-RECV-15                         
      *                      ,:PARM-DPP-RECV-15-AMT                     
      *                      ,:PARM-DPP-RECV-15-TS                      
      *                      ,:PARM-DPP-RECV-15-ID                      
      *                      ,:PARM-DPP-RECV-16                         
      *                      ,:PARM-DPP-RECV-16-AMT                     
      *                      ,:PARM-DPP-RECV-16-TS                      
      *                      ,:PARM-DPP-RECV-16-ID                      
      *                      ,:PARM-DPP-RECV-17                         
      *                      ,:PARM-DPP-RECV-17-AMT                     
      *                      ,:PARM-DPP-RECV-17-TS                      
      *                      ,:PARM-DPP-RECV-17-ID                      
      *                      ,:PARM-DPP-RECV-18                         
      *                      ,:PARM-DPP-RECV-18-AMT                     
      *                      ,:PARM-DPP-RECV-18-TS                      
      *                      ,:PARM-DPP-RECV-18-ID                      
      *                      ,:PARM-DPP-RECV-19                         
      *                      ,:PARM-DPP-RECV-19-AMT                     
      *                      ,:PARM-DPP-RECV-19-TS                      
      *                      ,:PARM-DPP-RECV-19-ID                      
      *                      )                                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE DPP_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN DPP_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR DPP_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE.        
      *                                                                         
           IF SQLCODE = +466 THEN                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '5100'                       TO ACTIVE-PARAGRAPH     
              MOVE 'DB2SP'                      TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSR02084'                   TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00726******************************************************************        
P00726* 5100-CNCL-CRED-ARNG-PROCESS                                  ***00022000
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE CPDKR360                                                  
P00726     END-EXEC.                                                            
P00726                                                                  
      ******************************************************************        
      * 5150-FETCH-CSR02084.                                           *        
      ******************************************************************        
      *                                                                         
       5150-FETCH-CSR02084.                                             
      *                                                                         
           EXEC SQL                                                     
             FETCH DPP_CUR                                              
               INTO   :WS-RETURN-CODE                                   
                     ,:WS-CANCELDNP-FLAG                                
                     ,:WS-AR-LOCKOUT-IND                                
                     ,:WS-ACCT-XFER-TO                                  
                     ,:WS-CANCELNOT-FLAG                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '5150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR02084'                TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-CLOSE-CSR02084.                                           *        
      ******************************************************************        
      *                                                                         
       5200-CLOSE-CSR02084.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DPP_CUR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE SQLCODE                TO ABEND-SQLCODE              
              MOVE SQLSTATE               TO ABEND-SQLSTATE             
              MOVE '5200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR02084'             TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-2            
              MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5250-CALL-CSR00125.                                            *        
      ******************************************************************        
      *                                                                         
       5250-CALL-CSR00125.                                              
      *                                                                         
           INITIALIZE WS-CSR00125-RET-AREA.                             
      *                                                                         
      *    EXEC SQL CALL CSR00125                                       
      *                ( :PARM-ACCOUNT-NO                               
      *                 ,:PARM-PREMISE-NO                               
      *                 ,:PARM-USER-ID                                  
      *                 ,:WS-REMARKS-TX                                 
      *                 ,:PARM-UPDATE-REMARKS                           
      *                 ,:WS-UPDATE                                     
      *                 ,:WS-PANEL-NO                                   
      *                 ,:PARM-ORDER-TYPE-FLAG                          
      *                 ,:PARM-DNP-CANCEL-REASON                        
      *                )                                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CANCEL_DNP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CANCEL_DNP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CANCEL_DNP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
               MOVE -1                         TO S-RETURN-CODE         
               MOVE '5250'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
               MOVE 'CSR00125'                 TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
               MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       5250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5300-FETCH-CSR00125.                                           *        
      ******************************************************************        
      *                                                                         
       5300-FETCH-CSR00125.                                             
      *                                                                         
           EXEC SQL                                                     
           FETCH CANCEL_DNP INTO                                        
                    :WS-SO-RETURN-CD-BD                                 
                   ,:WS-SERV-ORDER-CHAR-BD                              
                   ,:WS-ORDER-REASON-BD                                 
                   ,:WS-RESP-AREA-ID-BD                                 
                   ,:WS-PENDING-DNP-FLAG-BD                             
                   ,:WS-INSERT-WORK-QUEUE-BD                            
                   ,:WS-AMOUNT-DISC-BAL                                 
                   ,:WS-ORDER-TYPE-CD-BD                                
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5300'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSR00125'                 TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5350-CLOSE-CSR00125.                                           *        
      ******************************************************************        
      *                                                                         
       5350-CLOSE-CSR00125.                                             
      *                                                                         
           EXEC SQL                                                     
             CLOSE CANCEL_DNP                                           
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '5350'                  TO ACTIVE-PARAGRAPH          
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE 'CSR00125'              TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
              MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5400-CALL-CSR02072.                                            *        
      ******************************************************************        
      *                                                                         
       5400-CALL-CSR02072.                                              
      *                                                                         
           INITIALIZE WS-CSR02072-RET-AREA.                             
      *                                                                         
      *    EXEC SQL CALL CSR02072                                       
      *          ( :WS-INSERT                                           
      *           ,:PARM-ACCOUNT-NO                                     
      *           ,:PARM-AMT-EXTRA-DEPOSIT                              
      *           ,:WS-DEPOST-STATUS-CD                                 
      *           ,:WS-SERVICE-TYPE-CD                                  
      *           ,:PARM-DEPOSIT-CERT-NO                                
      *           ,:PARM-DEP-ACTION-CODE                                
      *           ,:PARM-USER-ID                                        
      *           ,:PARM-COMMENTS                                       
      *           ,:PARM-COMMENTS-LEN                                   
      *           ,:PARM-PANEL-COMMENTS                                 
      *           ,:PARM-PANEL-COMM-LEN                                 
      *           ,:PARM-BILL-OPTION-CD                                 
      *           ,:PARM-ORIG-BILL-OPTN                                 
      *           ,:WS-NO-PYMTS                                         
      *           ,:PARM-AMT-MONTH-PYMT                                 
      *           ,:PARM-CODE-DEP-TYPE                                  
      *           ,:PARM-CUT-DATE                                       
      *           ,:PARM-PROJECT-CR-DT                                  
      *           ,:PARM-DUE-DATE                                       
      *           ,:WS-PANEL-NUMBER                                     
      *           ,:PARM-LAST-UPDATE-TS                                 
      *           ,:PARM-CODE-REFUND-ELIG                               
      *           ,:PARM-ERROR-SWITCH                                   
      *           ,:PARM-AUTO-DEP-LETTER-IND                            
      *           ,:PARM-AUTO-DEP-LTR-DT                                
      *           ,:PARM-AUTO-DEP-NOT-AMT                               
      *           ,:PARM-AUTO-DEP-RECALC-AMT)                           
      *    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE DEPOSIT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN DEPOSIT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR DEPOSIT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = +466                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                          TO WS-ACTIVE-RETURN-CODE 
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '5400'                      TO ACTIVE-PARAGRAPH      
              MOVE 'DB2SP'                     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSR02072'                  TO TABLE-1               
              MOVE 'SQLCODE'                   TO TABLE-ELEMENT-1       
              MOVE SQLCODE                     TO HOSTVAR-ELEMENT-1     
              MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-2       
              MOVE PARM-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5450-FETCH-CSR02072.                                           *        
      ******************************************************************        
      *                                                                         
       5450-FETCH-CSR02072.                                             
      *                                                                         
           EXEC SQL                                                     
             FETCH DEPOSIT_CUR                                          
             INTO :WS-2072-ERROR-CODE                                   
                 ,:WS-2072-RETURN-CODE                                  
                 ,:WS-2072-AR-LOCKOUT-IND                               
                 ,:WS-2072-ACCT-XFER-TO                                 
                 ,:WS-2072-ABEND-PROGRAM                                
                 ,:WS-2072-ACTIVE-PARAGRAPH                             
                 ,:WS-2072-ABEND-FUNCTION                               
                 ,:WS-2072-TABLE-1                                      
                 ,:WS-2072-TABLE-ELEMENT-1                              
                 ,:WS-2072-TABLE-ELEMENT-2                              
                 ,:WS-2072-TABLE-ELEMENT-3                              
                 ,:WS-2072-TABLE-ELEMENT-4                              
                 ,:WS-2072-HOSTVAR-ELEMENT-1                            
                 ,:WS-2072-HOSTVAR-ELEMENT-2                            
                 ,:WS-2072-HOSTVAR-ELEMENT-3                            
                 ,:WS-2072-HOSTVAR-ELEMENT-4                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '5450'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE SPACES                 TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR02072'             TO TABLE-1                   
               MOVE 'SQLCODE'              TO TABLE-ELEMENT-1           
               MOVE WS-ACTIVE-RETURN-CODE  TO HOSTVAR-ELEMENT-1         
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-2           
               MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2         
               PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       5450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5500-CLOSE-CSR02072.                                           *        
      ******************************************************************        
      *                                                                         
       5500-CLOSE-CSR02072.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DEPOSIT_CUR                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5500'                  TO ACTIVE-PARAGRAPH          
              MOVE 'CLOSE'                 TO ABEND-FUNCTION            
              MOVE 'CSR02072'              TO TABLE-1                   
              MOVE 'WS-ACTIVE-RETURN-CODE' TO TABLE-ELEMENT-1           
              MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-2           
              MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2         
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03300******************************************************************        
A03300* 5550-CALL-CSR02122.                                            *        
A03300******************************************************************        
A03300*                                                                         
A03300 5550-CALL-CSR02122.                                              
A03300*                                                                         
A03300     INITIALIZE WS-CSR02122-RET-AREA.                             
A03300*                                                                         
A03300*    EXEC SQL CALL CSR02122                                       
A03300*                ( :PARM-ACCOUNT-NO                               
A03300*                 ,:PARM-PREMISE-NO                               
A03300*                 ,:WS-ORDER-REASON-BD                            
A03300*                 ,:PARM-DNP-CANCEL-REASON                        
A03300*                 ,:WS-PENDING-DNP-FLAG-BD                        
A03300*                 ,:WS-UPDATE-PROFILE                             
A03300*                 ,:WS-AMOUNT-DISC-BAL                            
A03300*                 ,:WS-PANEL-NO                                   
A03300*                 ,:WS-ORDER-TYPE-CD-BD                           
A03300*                 ,:WS-REMARKS-TX                                 
A03300*                )                                                
A03300*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE UPDATE_ACCT_TB
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN UPDATE_ACCT_TB
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR UPDATE_ACCT_TB INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A03300*                                                                         
A03300     MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
A03300                                             S-RETURN-CODE.       
A03300*                                                                         
A03300     IF WS-ACTIVE-RETURN-CODE = +466                              
A03300        CONTINUE                                                  
A03300     ELSE                                                         
A03300         MOVE -1                         TO S-RETURN-CODE         
A03300         MOVE '5550'                     TO ACTIVE-PARAGRAPH      
A03300         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
A03300         MOVE 'DB2SP CALL'               TO ABEND-FUNCTION        
A03300         MOVE 'CSR02122'                 TO TABLE-1               
A03300         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
A03300         MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
A03300         MOVE 'SQLCODE'                  TO TABLE-ELEMENT-2       
A03300         MOVE SQLCODE                    TO HOSTVAR-ELEMENT-2     
A03300         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
A03300     END-IF.                                                      
A03300*                                                                         
A03300 5550-EXIT.                                                       
A03300     EXIT.                                                        
A03300*                                                                         
A03300******************************************************************        
A03300* 5600-FETCH-CSR02122.                                           *        
A03300******************************************************************        
A03300*                                                                         
A03300 5600-FETCH-CSR02122.                                             
A03300*                                                                         
A03300     EXEC SQL                                                     
A03300     FETCH UPDATE_ACCT_TB INTO                                    
A03300              :WS-2122-RETURN-CODE                                
A03300     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03300*                                                                         
A03300     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
A03300                                          S-RETURN-CODE.          
A03300*                                                                         
A03300     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03300        CONTINUE                                                  
A03300     ELSE                                                         
A03300        MOVE '5600'                     TO ACTIVE-PARAGRAPH       
A03300        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A03300        MOVE 'FETCH'                    TO ABEND-FUNCTION         
A03300        MOVE 'CSR02122'                 TO TABLE-1                
A03300        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A03300        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
A03300        MOVE 'SQLCODE '                 TO TABLE-ELEMENT-2        
A03300        MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-2      
A03300        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A03300     END-IF.                                                      
A03300*                                                                         
A03300 5600-EXIT.                                                       
A03300     EXIT.                                                        
A03300*                                                                         
A03300******************************************************************        
A03300* 5650-CLOSE-CSR02122.                                           *        
A03300******************************************************************        
A03300*                                                                         
A03300 5650-CLOSE-CSR02122.                                             
A03300*                                                                         
A03300     EXEC SQL                                                     
A03300       CLOSE UPDATE_ACCT_TB                                       
A03300     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03300*                                                                         
A03300     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A03300                                         S-RETURN-CODE.           
A03300*                                                                         
A03300     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A03300        CONTINUE                                                  
A03300     ELSE                                                         
A03300        MOVE '5650'                  TO ACTIVE-PARAGRAPH          
A03300        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
A03300        MOVE 'CLOSE'                 TO ABEND-FUNCTION            
A03300        MOVE 'CSR02122'              TO TABLE-1                   
A03300        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
A03300        MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
A03300        MOVE 'SQLCODE '              TO TABLE-ELEMENT-1           
A03300        MOVE WS-ACTIVE-RETURN-CODE   TO HOSTVAR-ELEMENT-1         
A03300        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
A03300     END-IF.                                                      
A03300*                                                                         
A03300 5650-EXIT.                                                       
A03300     EXIT.                                                        
A03300*                                                                         
P00726******************************************************************        
P00726* 6530-LOAD-MNT-TRANS-HIST.                                      *        
P00726* 6540-INSERT-MNT-TRANS-HIST.                                    *        
P00726* 6550-INSERT-MT-TRN-HST-DET.                                    *        
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726         INCLUDE CPD00067                                                 
P00726     END-EXEC.                                                            
P00726                                                                  
      ******************************************************************        
      *  7000-GET-PREMISE-NO.                                          *        
      ******************************************************************        
      *                                                                         
       7000-GET-PREMISE-NO.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT AT.PREMISE_NO                                     
                 INTO :AT-PREMISE-NO                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.PREMISE_NO                                             
MFA-TR*          INTO :AT-PREMISE-NO                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **     7005-GET-INIT-DELINQ.                                    **        
      **                                                              **        
      ******************************************************************        
       7005-GET-INIT-DELINQ.                                            
      *---------------------*                                                   
             MOVE '7005'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE COMPANY_NO           = :C8-COMPANY-NO              
                 AND DELINQ_CD            = :C8-DELINQ-CD               
                                                                 
                                                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE COMPANY_NO           = :C8-COMPANY-NO                      
MFA-TR*          AND DELINQ_CD            = :C8-DELINQ-CD                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7005'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
               MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1         
               MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00726******************************************************************        
P00726* 7010-GET-TIMESTAMP                                             *        
P00726******************************************************************        
P00726                                                                  
P00726 7010-GET-TIMESTAMP.                                              
P00726                                                                  
P00726     MOVE '7010'                       TO WS-ACTIVE-PARAGRAPH.    
P00726                                                                  
P00726     EXEC SQL                                                     
P00726         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-KR360-CURR-TIMESTAMP,
              :WS-KR360-CURRENT-DATE              
P00726     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-KR360-CURR-TIMESTAMP = CURRENT TIMESTAMP                 
MFA-TR*           ,:WS-KR360-CURRENT-DATE   = CURRENT DATE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00726                                                                  
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00726        MOVE '7010'                    TO ACTIVE-PARAGRAPH        
P00726        MOVE 'SET'                     TO ABEND-FUNCTION          
P00726        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00726        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00726     END-IF.                                                      
P00726                                                                  
P00726 7010-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
P00726******************************************************************        
P00726*  7015-GET-CODES-DATA-PRESENT                                   *        
P00726******************************************************************        
P00726                                                                  
P00726 7015-GET-CODES-DATA-PRESENT.                                     
P00726                                                                  
P00726     MOVE '7015'                       TO WS-ACTIVE-PARAGRAPH.    
P00726                                                                  
P00726     EXEC SQL                                                     
P00726         SELECT AT.CODES_DATA_PRESENT                             
P00726           INTO :AT-CODES-DATA-PRESENT                            
P00726           FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
P00726          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
P00726                                                           
P00726                                                      
P00726     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CODES_DATA_PRESENT                                     
MFA-TR*          INTO :AT-CODES-DATA-PRESENT                                    
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00726                                                                  
P00726     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00726                                                                  
P00726     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00726        CONTINUE                                                  
P00726     ELSE                                                         
P00726        MOVE SPACES                    TO ABEND-TABLES            
P00726        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00726        MOVE '7015'                    TO ACTIVE-PARAGRAPH        
P00726        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00726        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00726        MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
P00726        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00726        MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00726        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00726     END-IF.                                                      
P00726                                                                  
P00726 7015-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************00000100
      * 8000A-DELETE-GTT-ROWS.                                         *00000200
      ******************************************************************00000300
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00000500
            EXEC SQL                                                    
                DELETE FROM #CSR04419_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04419_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            S-RETURN-CODE.                              
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04419_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************00000100
      * 8100-INSERT-GTT.                                               *00000200
      ******************************************************************00000300
      *                                                                         
       8100-INSERT-GTT.                                                 
           EXEC SQL                                                     
             INSERT INTO #CSR04419_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_STATUS_CODE                                          
             ,APPL_PARMS                                                
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-APPL-STATUS-CODE                                       
             ,:S-APPL-PARMS                                             
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04419_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_STATUS_CODE                                                  
MFA-TR*      ,APPL_PARMS                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-APPL-STATUS-CODE                                               
MFA-TR*      ,:S-APPL-PARMS                                                     
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 00000200
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE SQLSTATE            TO ABEND-SQLSTATE                
              MOVE '8100'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSR04419_R1'       TO TABLE-1                       
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT            
           END-IF.                                                      
      *                                                                 00001700
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *   9100-SEND-ERROR-RESULT.                                               
      ******************************************************************        
      *                                                                         
       9100-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           MOVE WS-ACTIVE-RETURN-CODE TO ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
           PERFORM 8100-INSERT-GTT    THRU 8100-EXIT.                   
      *                                                                         
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9700-PROCESS-ABENDG / ABEND PROCESSING                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       9900 - JOURNALING / ERROR HANDLING ROUTINE               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
