       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04412.                                         
COB303 DATE-WRITTEN.  JANUARY 07, 2011.                                 
       DATE-COMPILED.                                                   
                                                                        
      ***************************************************************** 00060000
      *                                                               * 00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00080000
      *                                                               * 00090000
      ***************************************************************** 00160000
      *                P R O G R A M  S U M M A R Y                   * 00170000
      *                                                               * 00180000
      *  THIS PROGRAM UPDATES & INSERTS NECESSARY ROWS FOR PRP ACCTS  * 00190000
      ***************************************************************** 00200000
      *                                                               * 00210000
      *                     PROGRAM MODIFICATION LOG                  * 00220000
      *                                                               * 00230000
      *    DATE    INITIALS   COMMENTS                                * 00240000
      *  --------  --------   --------------------------------------- * 00250000
      *  01/07/11    SMS      STORED PROCEDURE ORIGINALLY CODED.      * 00260000
      *                       UPDATE CREDIT GROUP, CODES DATA PRESENT * 00260000
      *                       IN CSS_ACCOUNT; CREATE NEW SUMMARY AND  * 00260000
      *                       DETAIL ROW IN CSS_AR_CNTL; AND INSERT   * 00260000
      *                       ROW INTO CSS_PREPAY_HIST                * 00260000
      *  05/12/11    SMS      CHANGED NAME FROM PAY AND GO TO PRE-PAY * 00260000
      *                       PLAN (PRP)                              * 00260000
      ***************************************************************** 00650000
      ***************************************************************** 00660000
      *                                                               * 00670000
      *                ---- BASIC SEQUENCE STRUCTURE ----             * 00680000
      *                                                               * 00690000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            * 00700000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   * 00710000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  * 00720000
      *  3000 - 4999  NOT USED                                        * 00730000
      *  5000 - 5999  COMMON PROGRAM MODULES                          * 00740000
      *  6000 - 6999  COMMON SYSTEM MODULES                           * 00750000
      *  7000 - 7999  INPUT MODULES                                   * 00760000
      *  8000 - 8999  OUTPUT MODULES                                  * 00770000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES           * 00780000
      *                                                               * 00790000
      ***************************************************************** 00800000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04412'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S054 STARTS HERE'.                  
                                                                        
      ******************************************************************00890000
      *    DB2 INCLUDES                                                *00900000
      ******************************************************************00910000
                                                                        
      *---< ERROR PROCESSING >                                          00930000
           EXEC SQL                                                     00940000
              INCLUDE SQLCA                                             00950000
           END-EXEC.                                                    00960000
                                                                        
      *---< CSS_ACCOUNT      >                                          00980000
           EXEC SQL                                                     00990000
              INCLUDE TBACCT                                            01000000
           END-EXEC.                                                    01010000
                                                                        
           EXEC SQL                                                     01380000
              INCLUDE TBMODEL                                           01390000
           END-EXEC.                                                    01400000
                                                                        
      *---< CSS_AR_CNTL >                                               01420000
           EXEC SQL                                                     01430000
              INCLUDE TBARCNTL                                          01440000
           END-EXEC.                                                    01450000
                                                                        
      *---< CSS_PREPAY_HIST >                                           01570000
           EXEC SQL                                                     01580000
              INCLUDE TBPREHST                                          01590000
           END-EXEC.                                                    01600000
                                                                        
      ******************************************************************01630000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01640000
      ******************************************************************01650000
                                                                        
           COPY CCA00001.                                               01690000
           COPY CWS00056.                                               01720000
           COPY CWS00303.                                               01730000
                                                                        
      ******************************************************************01840000
      *    WORK AREAS                                                  *01850000
      ******************************************************************01860000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE          PIC S9(9) COMP.              
                                                                        
       01  FILLER                          PIC X(11) VALUE              
                                               'PARM FIELDS'.           
       01  PARM-FIELDS.                                                 
           05  PARM-L                      PIC S9(9) COMP.              
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WS-CURRENT-DATE             PIC X(10).                   
           05  WS-TRANS-HIST-SEQ-NO        PIC X(26).                   
           05  WS-ACCOUNT-NO               PIC X(13).                   
           05  WS-ACCOUNT-NO-NUM  REDEFINES WS-ACCOUNT-NO               
                                           PIC 9(13).                   
           05  WS-REVENUE-MONTH            PIC X(06).                   
           05  WS-REVENUE-MONTH-NUM REDEFINES WS-REVENUE-MONTH          
                                           PIC 9(06).                   
           05  WS-EST-METHOD-CD            PIC X(01).                   
           05  WS-ESTMT-CONSUMPT           PIC X(06).                   
           05  WS-ESTMT-CONSUMPT-NUM REDEFINES WS-ESTMT-CONSUMPT        
                                           PIC 9(06).                   
           05  WS-THERM-PRICE              PIC X(09).                   
           05  WS-THERM-PRICE-NUM REDEFINES WS-THERM-PRICE              
                                           PIC 9(04)V9(05).             
           05  WS-CSC-AMOUNT               PIC X(11).                   
           05  WS-CSC-AMOUNT-NUM REDEFINES WS-CSC-AMOUNT                
                                           PIC 9(05)V9(06).             
           05  WS-OTHER-CHARGES            PIC X(11).                   
           05  WS-OTHER-CHARGES-NUM REDEFINES WS-OTHER-CHARGES          
                                           PIC 9(09)V99.                
           05  WS-ESTMT-AMOUNT             PIC X(11).                   
           05  WS-ESTMT-AMOUNT-NUM REDEFINES WS-ESTMT-AMOUNT            
                                           PIC 9(09)V99.                
           05  WS-USERID                   PIC X(07).                   
           05  WS-AGL-PASS-CHARGE          PIC X(11).                   
           05  WS-AGL-PASS-CHARGE-NUM REDEFINES WS-AGL-PASS-CHARGE      
                                           PIC 9(09)V99.                
           05  WS-CONNECT-CHARGE           PIC X(11).                   
           05  WS-CONNECT-CHARGE-NUM REDEFINES WS-CONNECT-CHARGE        
                                           PIC 9(09)V99.                
           05  WRK-DONE-STATUS             PIC S9(9) COMP.              
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE              PIC S9(9) COMP VALUE 0.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                 PIC X(01) VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  PROGRAM-NAME                PIC X(08)  VALUE 'CSR04412'. 
                                                                        
HPCCDM*EJECT                                                            02800000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13)                .          
       01  LINK-REVENUE-MONTH       PIC X(06)                .          
       01  LINK-EST-METHOD-CD       PIC X(01)                .          
       01  LINK-ESTMT-CONSUMPT      PIC X(06)                .          
       01  LINK-THERM-PRICE         PIC X(09)                .          
       01  LINK-CSC-AMOUNT          PIC X(11)                .          
       01  LINK-OTHER-CHARGES       PIC X(11)                .          
       01  LINK-ESTMT-AMOUNT        PIC X(11)                .          
       01  LINK-USERID              PIC X(07)                .          
       01  LINK-AGL-PASS-CHARGE     PIC X(11)                .          
       01  LINK-CONNECT-CHARGE      PIC X(11)                .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO                                         
              , LINK-REVENUE-MONTH                                      
              , LINK-EST-METHOD-CD                                      
              , LINK-ESTMT-CONSUMPT                                     
              , LINK-THERM-PRICE                                        
              , LINK-CSC-AMOUNT                                         
              , LINK-OTHER-CHARGES                                      
              , LINK-ESTMT-AMOUNT                                       
              , LINK-USERID                                             
              , LINK-AGL-PASS-CHARGE                                    
              , LINK-CONNECT-CHARGE                                     
               .                                                        
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
      *PROCEDURE DIVISION.                                              02810000
                                                                        
      ******************************************************************02830000
      * 0000-MAINLINE                                                  *02840000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02850000
      ******************************************************************02860000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02980000
      * 0100-INITIALIZE                                                *02990000
      *     1. ESTABLISH RETURN CURSOR                                 *03010000
      ******************************************************************03060000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :RS-RETURN-CODE              AS    RETURN_CODE            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           INITIALIZE DCLCSS-PREPAY-HIST.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03340000
      * 1000-PROCESS-INPUT                                             *03350000
      *                                                                *03360000
      *     MOVE LINKAGE VARIABLES TO WORKING STORAGE.                 *03370000
      *                                                                *03380000
      ******************************************************************03390000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO      TO WS-ACCOUNT-NO.                  
           MOVE LINK-REVENUE-MONTH   TO WS-REVENUE-MONTH.               
           MOVE LINK-EST-METHOD-CD   TO WS-EST-METHOD-CD.               
           MOVE LINK-ESTMT-CONSUMPT  TO WS-ESTMT-CONSUMPT.              
           MOVE LINK-THERM-PRICE     TO WS-THERM-PRICE.                 
           MOVE LINK-CSC-AMOUNT      TO WS-CSC-AMOUNT.                  
           MOVE LINK-OTHER-CHARGES   TO WS-OTHER-CHARGES.               
           MOVE LINK-ESTMT-AMOUNT    TO WS-ESTMT-AMOUNT.                
           MOVE LINK-USERID          TO WS-USERID.                      
           MOVE LINK-AGL-PASS-CHARGE TO WS-AGL-PASS-CHARGE.             
           MOVE LINK-CONNECT-CHARGE  TO WS-CONNECT-CHARGE.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      04090000
      *   2000-PROCESS-OUTPUT                                    *      04100000
      *                                                          *      04110000
      *   1. SEND RESULT SET                                     *      04140000
      ************************************************************      04160000
       2000-PROCESS-OUTPUT.                                             
                                                                        
            MOVE '2000'                       TO ACTIVE-PARAGRAPH.      
            PERFORM 2100-PRP-ACCT-VALUES      THRU 2100-EXIT.           
            PERFORM 7100-GET-CURR-DATE-TIME   THRU 7100-EXIT.           
            PERFORM 2200-PRP-ARCNTL-VALUES    THRU 2200-EXIT.           
            PERFORM 2300-PRP-PREHST-VALUES    THRU 2300-EXIT.           
            PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      04090000
      *   2100-PRP-ACCT-VALUES                                   *      04100000
      *                                                          *      04110000
      *   1. UPDATE CREDIT-GROUP                                 *      04140000
      *   2. UPDATE CODES-DATA-PRESENT                           *      04150000
      ************************************************************      04160000
       2100-PRP-ACCT-VALUES.                                            
                                                                        
            MOVE '2100'                    TO ACTIVE-PARAGRAPH.         
            MOVE 'B'                       TO AT-CREDIT-GROUP.          
            MOVE WS-ACCOUNT-NO-NUM         TO AT-ACCOUNT-NO.            
            PERFORM 7000-RETRIEVE-CDP      THRU 7000-EXIT.              
            MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT.    
            MOVE 'A'                       TO WS-CODE-PRE-PAY-PLAN.     
            MOVE WS-CODES-DATA-PRESENT     TO AT-CODES-DATA-PRESENT.    
            PERFORM 8000-UPDATE-CSS-ACCOUNT    THRU 8000-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      04090000
      *   2200-PRP-ARCNTL-VALUES                                 *      04100000
      *   1. INSERT NEW SUMMARY                                  *      04140000
      *   2. INSERT DETAIL ROW                                   *      04150000
      ************************************************************      04160000
       2200-PRP-ARCNTL-VALUES.                                          
                                                                        
            MOVE '2200'                      TO ACTIVE-PARAGRAPH.       
                                                                        
            MOVE WS-ACCOUNT-NO-NUM           TO AC-ACCOUNT-NO.          
            MOVE 50                          TO AC-PYMT-PRIORITY-LVL.   
            MOVE 0                           TO AC-ITEM-ID              
                                                AC-AMT-AR-DAY-00        
                                                AC-AMT-AR-DAY-30        
                                                AC-AMT-AR-DAY-60        
                                                AC-AMT-AR-DAY-90        
                                                AC-AMT-UNUSED-CR        
                                                AC-AMT-TRAN-BALANCE     
                                                AC-TOT-SUMM-UNBILLED.   
            MOVE WS-TRANS-HIST-SEQ-NO        TO AC-LAST-UPDATE-TS.      
            PERFORM 8010-INSERT-ARCNTL       THRU 8010-EXIT.            
            MOVE 1                           TO AC-ITEM-ID.             
            PERFORM 8010-INSERT-ARCNTL       THRU 8010-EXIT.            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      04090000
      *   2300-PRP-PREHST-VALUES                                 *      04100000
      *   1. INSERT DETAIL ROW INTO CSS_PREPAY_HIST              *      04110000
      ************************************************************      04160000
       2300-PRP-PREHST-VALUES.                                          
                                                                        
            MOVE '2300'                      TO ACTIVE-PARAGRAPH.       
                                                                        
            MOVE WS-ACCOUNT-NO-NUM           TO PK-ACCOUNT-NO.          
            MOVE WS-TRANS-HIST-SEQ-NO        TO PK-PREPAY-HIST-SEQ-TS.  
            MOVE WS-REVENUE-MONTH-NUM        TO PK-REVENUE-MONTH.       
            MOVE WS-EST-METHOD-CD            TO PK-EST-METHOD-CD.       
            MOVE WS-ESTMT-CONSUMPT-NUM       TO PK-EST-NO-UNITS.        
            MOVE WS-THERM-PRICE-NUM          TO PK-EST-UNIT-PRICE-AM.   
            MOVE WS-AGL-PASS-CHARGE-NUM      TO PK-EST-ADDL-CHARGE-AM.  
            MOVE 0                           TO PK-NET-BILL-ADJ-AM      
                                                PK-ARREARS-AMT          
                                                PK-BILLED-AMT.          
            MOVE WS-CSC-AMOUNT-NUM           TO PK-EST-CUSTSVC-CHG-AM.  
            MOVE WS-OTHER-CHARGES-NUM        TO PK-EST-MISC-CHARGE-AM.  
            MOVE WS-CONNECT-CHARGE-NUM       TO PK-EST-CONNECT-CHG-AM.  
            MOVE WS-ESTMT-AMOUNT-NUM         TO PK-EST-BILL-AM.         
            MOVE 'CREATED THROUGH CRM'       TO PK-REMARKS-TEXT.        
            MOVE 19                          TO PK-REMARKS-LEN.         
            MOVE WS-USERID                   TO PK-LAST-UPDATE-USERID.  
            PERFORM 8020-INSERT-PREPAY       THRU 8020-EXIT.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7000-RETRIEVE-CDP                                            *        
      ******************************************************************        
       7000-RETRIEVE-CDP.                                               
                                                                        
           MOVE '7000'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               SELECT CODES_DATA_PRESENT                                
                 INTO :AT-CODES-DATA-PRESENT                            
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODES_DATA_PRESENT                                        
MFA-TR*          INTO :AT-CODES-DATA-PRESENT                                    
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                    TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-CURR-DATE-TIME.                                       *        
      ******************************************************************        
                                                                        
       7100-GET-CURR-DATE-TIME.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*          ,:WS-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8000-UPDATE-CSS-ACCOUNT                                      *        
      ******************************************************************        
       8000-UPDATE-CSS-ACCOUNT.                                         
                                                                        
           MOVE '8000'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                 SET CREDIT_GROUP       = :AT-CREDIT-GROUP,             
                     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                    TO RS-RETURN-CODE         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *  8010-INSERT-ARCNTL.                                         *  04220000
      ****************************************************************          
       8010-INSERT-ARCNTL.                                              
                                                                        
           MOVE '8010'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_AR_CNTL                                  
                  (ACCOUNT_NO       ,                                   
                   PYMT_PRIORITY_LVL,                                   
                   ITEM_ID          ,                                   
                   AMT_AR_DAY_00    ,                                   
                   AMT_AR_DAY_30    ,                                   
                   AMT_AR_DAY_60    ,                                   
                   AMT_AR_DAY_90    ,                                   
                   AMT_UNUSED_CR    ,                                   
                   AMT_TRAN_BALANCE ,                                   
                   TOT_SUMM_UNBILLED,                                   
                   LAST_UPDATE_TS)                                      
                 VALUES(                                                
                   :AC-ACCOUNT-NO       ,                               
                   :AC-PYMT-PRIORITY-LVL,                               
                   :AC-ITEM-ID          ,                               
                   :AC-AMT-AR-DAY-00    ,                               
                   :AC-AMT-AR-DAY-30    ,                               
                   :AC-AMT-AR-DAY-60    ,                               
                   :AC-AMT-AR-DAY-90    ,                               
                   :AC-AMT-UNUSED-CR    ,                               
                   :AC-AMT-TRAN-BALANCE ,                               
                   :AC-TOT-SUMM-UNBILLED,                               
                   CIS.CHAR2TIMESTAMP(:AC-LAST-UPDATE-TS))                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_AR_CNTL                                          
MFA-TR*           (ACCOUNT_NO       ,                                           
MFA-TR*            PYMT_PRIORITY_LVL,                                           
MFA-TR*            ITEM_ID          ,                                           
MFA-TR*            AMT_AR_DAY_00    ,                                           
MFA-TR*            AMT_AR_DAY_30    ,                                           
MFA-TR*            AMT_AR_DAY_60    ,                                           
MFA-TR*            AMT_AR_DAY_90    ,                                           
MFA-TR*            AMT_UNUSED_CR    ,                                           
MFA-TR*            AMT_TRAN_BALANCE ,                                           
MFA-TR*            TOT_SUMM_UNBILLED,                                           
MFA-TR*            LAST_UPDATE_TS)                                              
MFA-TR*          VALUES(                                                        
MFA-TR*            :AC-ACCOUNT-NO       ,                                       
MFA-TR*            :AC-PYMT-PRIORITY-LVL,                                       
MFA-TR*            :AC-ITEM-ID          ,                                       
MFA-TR*            :AC-AMT-AR-DAY-00    ,                                       
MFA-TR*            :AC-AMT-AR-DAY-30    ,                                       
MFA-TR*            :AC-AMT-AR-DAY-60    ,                                       
MFA-TR*            :AC-AMT-AR-DAY-90    ,                                       
MFA-TR*            :AC-AMT-UNUSED-CR    ,                                       
MFA-TR*            :AC-AMT-TRAN-BALANCE ,                                       
MFA-TR*            :AC-TOT-SUMM-UNBILLED,                                       
MFA-TR*            :AC-LAST-UPDATE-TS)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                    TO RS-RETURN-CODE         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_AR_CNTL'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *  8020-INSERT-PREPAY.                                         *  04220000
      ****************************************************************          
       8020-INSERT-PREPAY.                                              
                                                                        
           MOVE '8020'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_PREPAY_HIST                              
                  (ACCOUNT_NO        ,                                  
                   PREPAY_HIST_SEQ_TS,                                  
                   REVENUE_MONTH     ,                                  
                   EST_METHOD_CD     ,                                  
                   EST_NO_UNITS      ,                                  
                   EST_UNIT_PRICE_AM ,                                  
                   EST_ADDL_CHARGE_AM,                                  
                   EST_CUSTSVC_CHG_AM,                                  
                   EST_MISC_CHARGE_AM,                                  
                   EST_BILL_AM       ,                                  
                   NET_BILL_ADJ_AM   ,                                  
                   ARREARS_AMT       ,                                  
                   BILLED_AMT        ,                                  
                   REMARKS           ,                                  
                   EST_CONNECT_CHG_AM,                                  
                   LAST_UPDATE_USERID)                                  
                 VALUES(                                                
                   :PK-ACCOUNT-NO        ,                              
                   CIS.CHAR2TIMESTAMP(:PK-PREPAY-HIST-SEQ-TS),                  
                   :PK-REVENUE-MONTH     ,                              
                   :PK-EST-METHOD-CD     ,                              
                   :PK-EST-NO-UNITS      ,                              
                   :PK-EST-UNIT-PRICE-AM ,                              
                   :PK-EST-ADDL-CHARGE-AM,                              
                   :PK-EST-CUSTSVC-CHG-AM,                              
                   :PK-EST-MISC-CHARGE-AM,                              
                   :PK-EST-BILL-AM       ,                              
                   :PK-NET-BILL-ADJ-AM   ,                              
                   :PK-ARREARS-AMT       ,                              
                   :PK-BILLED-AMT        ,                              
                   :PK-REMARKS           ,                              
                   :PK-EST-CONNECT-CHG-AM,                              
                   :PK-LAST-UPDATE-USERID)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_PREPAY_HIST                                      
MFA-TR*           (ACCOUNT_NO        ,                                          
MFA-TR*            PREPAY_HIST_SEQ_TS,                                          
MFA-TR*            REVENUE_MONTH     ,                                          
MFA-TR*            EST_METHOD_CD     ,                                          
MFA-TR*            EST_NO_UNITS      ,                                          
MFA-TR*            EST_UNIT_PRICE_AM ,                                          
MFA-TR*            EST_ADDL_CHARGE_AM,                                          
MFA-TR*            EST_CUSTSVC_CHG_AM,                                          
MFA-TR*            EST_MISC_CHARGE_AM,                                          
MFA-TR*            EST_BILL_AM       ,                                          
MFA-TR*            NET_BILL_ADJ_AM   ,                                          
MFA-TR*            ARREARS_AMT       ,                                          
MFA-TR*            BILLED_AMT        ,                                          
MFA-TR*            REMARKS           ,                                          
MFA-TR*            EST_CONNECT_CHG_AM,                                          
MFA-TR*            LAST_UPDATE_USERID)                                          
MFA-TR*          VALUES(                                                        
MFA-TR*            :PK-ACCOUNT-NO        ,                                      
MFA-TR*            :PK-PREPAY-HIST-SEQ-TS,                                      
MFA-TR*            :PK-REVENUE-MONTH     ,                                      
MFA-TR*            :PK-EST-METHOD-CD     ,                                      
MFA-TR*            :PK-EST-NO-UNITS      ,                                      
MFA-TR*            :PK-EST-UNIT-PRICE-AM ,                                      
MFA-TR*            :PK-EST-ADDL-CHARGE-AM,                                      
MFA-TR*            :PK-EST-CUSTSVC-CHG-AM,                                      
MFA-TR*            :PK-EST-MISC-CHARGE-AM,                                      
MFA-TR*            :PK-EST-BILL-AM       ,                                      
MFA-TR*            :PK-NET-BILL-ADJ-AM   ,                                      
MFA-TR*            :PK-ARREARS-AMT       ,                                      
MFA-TR*            :PK-BILLED-AMT        ,                                      
MFA-TR*            :PK-REMARKS           ,                                      
MFA-TR*            :PK-EST-CONNECT-CHG-AM,                                      
MFA-TR*            :PK-LAST-UPDATE-USERID)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                    TO RS-RETURN-CODE         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PREPAY_HIST'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PK-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15390000
      *       END PROGRAM COPYLIB                                      *15400000
      ******************************************************************15410000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
           EXEC SQL                                                     00000100
               INCLUDE CPDSP300                                         00000200
           END-EXEC.                                                    00000300
