       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04402.                                     
COB303 DATE-WRITTEN.  DEC 17,2010                                       
       DATE-COMPILED.                                                   
      *                                                                 00050018
      ******************************************************************00060018
      *                                                                *00070018
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080018
      *                                                                *00090018
      *                                                                *00100018
      ******************************************************************00110018
      *                 P R O G R A M  S U M M A R Y                   *00120018
      *                                                                *00130018
      *  THIS PROGRAM RETURNS BBP BPA DATA FOR SEB                     *00140018
      *  RESULT SETS:                                                  *00150018
      *         1. Budget Billing Plan Details                         *00160018
      *         2. Monthly Charges/Contracts                           *00170018
      *         3. Actual/Estimated Usage For Plan Duration            *00180018
      *         4. Remarks For Each Change Of Budget Billing Amount    *00190018
      *         5. Anniversary Opitons.                                *00200018
      *                                                                *00210018
      ******************************************************************00220018
      *                                                                *00230018
      *                     PROGRAM MODIFICATION LOG                   *00240018
      *                                                                *00250018
      *    DATE    INITIALS   COMMENTS                                 *00260018
      *  --------  --------   ---------------------------------------  *00270018
P00464*  12/17/10  AA97148    PROCEDURE ORIGINALLY CODED.              *00280018
P00506** 05/11/11  VV94890    SEB - ROLL CREDIT ACCOUNT BALANCE INTO   *00290018
P00506**                      BUDGET BILLING ANNIVERSARY.              *00300018
A03300** 04/15/11  RC41079    CHANGE TO PARA 2100- TO MOVE BG-REV-MTH- *00310018
A03300**                      ORIG-BILL OR BG-REVENUE-MONTH TO S-REV-  *00320018
A03300**                      MTH INSTEAD OF BI-DATE-BILLED. SUM OF 00-*00330018
A03300**                      30-60-90 DAY = BBP-BILD-BAL-AMT WHICH IS *00340018
A03300**                      THEN SUBTRACTED TO COMPUTE S-BAL-AT-ANNIV*00350018
TASK01** 07/08/11  VV94890  1)CHANGE TO DISPLAY ANNIVERSARY OPTION/S   *00360018
      ** ****A03300******     LITERAL/S ACCORDINGLY.                   *00370018
TASK02*                     2)ADDED NEW COL BI-DATE-BILLED TO RES SET-3*00380018
P00473*  03/03/12  MS93554    CHANGES ADDED TO PULL APPROVED CRM VRSN  *00390018
A03925** 04/10/12  VV94890   ADDED NEW COL "NO OF DAYS" TO RESULT SET-3*00400018
ACT080** 07/31/12  NS75440   ADDED 'E' TO CT.CNT_STATUS_CD IN          *00410018
      ** A03967              7600-GET-CNT-DET  PARA.                  * 00420018
P00694** 01/18/13  EM19682   ADDED CODE TO RETRIEVE EXEMPT FROM REVIEW *00430018
P00694**                     ON BBP ACCOUNTS.                          *00440018
P00694** 02/05/13  VV94890   CHANGED CALLING FROM CSR02322 TO CSR04600.*00450018
P0694A**                     ADDED BBP FULL BALANCE TO RESULT SET-1.   *00460018
P0694B** 02/09/13  GOKUL     CHANGE LOGIC TO COMPUTE BBP-REMAINING-MTHS*00470018
P0694C** 04/12/13  VV94890   MOVED PROJECTED BAL LOGIC TO CORRECT PLACE*00480018
ACT186** 11/03/13  VIJAY     FIX BBP-REMAINING-MTHS DISPLAY.           *00490018
ACT186** A04527              (USED PANEL CODE AS MODEL)                *00500018
ACT228** 07/28/14  VIJAY     FIX BBP-REMAINING-MTHS DISPLAY.WHEN ACCOUNT00510018
ACT228** A04880              IS IN PENDING STATUS AND WITH NO BILL CYCLE00520018
ACT228**                     NOT DISPLAYING PROPERLY.                   00530018
P00836** 11/25/15  VV7M728   ADDED BBP_TOTAL_CHRGS TO RS1.              00560018
      ******************************************************************00570018
      ******************************************************************00580018
      *                                                                *00590018
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00600018
      *                                                                *00610018
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00620018
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00630018
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00640018
      *  3000 - 4999  NOT USED                                         *00650018
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00660018
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00670018
      *  7000 - 7999  INPUT MODULES                                    *00680018
      *  8000 - 8999  OUTPUT MODULES                                   *00690018
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00700018
      *                                                                *00710018
      ******************************************************************00720018
      *                                                                 00730018
       ENVIRONMENT DIVISION.                                            
      *                                                                 00750018
       DATA DIVISION.                                                   
      *                                                                 00770018
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04402'.
MSQ017     COPY MFASQLM.
      *                                                                 00790018
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04402 STARTS HERE'.                 
      *                                                                 00820018
       01 WS-CONSTANTS.                                                 
          05 WS-TWELVE               PIC S9(09) COMP VALUE 12.          
      *                                                                 00850018
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME            PIC X(08)  VALUE 'CSR04402'.       
          05 MCSCB063                PIC X(08)  VALUE 'MCSCB063' .      
          05 WS-PCT-ESTRATEINCR-GAS  PIC X(19)  VALUE                   
                                     'PCT-ESTRATEINCR-GAS'.             
          05 WS-EPP-DEFAULT-DDDC     PIC X(16)  VALUE                   
                                     'EPP-DEFAULT-DDDC'.                
          05 WS-EPP-DEFAULT-THERMS   PIC X(18)  VALUE                   
                                     'EPP-DEFAULT-THERMS'.              
          05 WS-AGL-METER-CHRG-TX    PIC X(18)  VALUE                   
                                     'AGL-METER-CHARGE'.                
          05 WS-OPTION-DESC-1        PIC X(30)  VALUE                   
                                     'If Paid Account Billed Balance'.  
          05 WS-OPTION-DESC-2        PIC X(29)  VALUE                   
                                     'If Paid Account Total Balance'.   
TASK01    05 WS-OPTION-DESC-3        PIC X(32) VALUE                    
TASK01                               'If Paid Account Bal with BBP Amt'.
          05 WS-EST-BBP-AMT-TX       PIC X(24)  VALUE                   
                                     'Estimated New BBP Amount'.        
          05 WS-ACT-ACCT-BAL-TX      PIC X(22)  VALUE                   
                                     'Actual Account Balance'.          
          05 WS-ACCT-BAL-BBP-TX      PIC X(24)  VALUE                   
                                     'Account Bal with BBP Amt'.        
      *                                                                 01090018
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-DET              PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-CHGS             PIC S9(09) COMP VALUE 0.           
          05 WS-UTIL-CHGS            PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-HIST             PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-ANNIV            PIC S9(09) COMP VALUE 0.           
P00694    05 WS-BBP-CNSMPT           PIC S9(09) COMP VALUE 0.           
          05 WS-MNTHS-CTR            PIC S9(09) COMP VALUE 0.           
          05 WS-ACT-COUNT            PIC S9(09) COMP VALUE 0.           
          05 WS-EST-COUNT            PIC S9(09) COMP VALUE 0.           
          05 WS-RET-COUNT            PIC S9(09) COMP VALUE 0.           
P0694B    05 WS-BBP-TERM             PIC S9(09) COMP VALUE 0.           
P00694    05 WS-ACCT-WNT-SUM-USE-ELEC PIC 9(04) VALUE 0.                
P00694    05 WS-ACCT-WNT-SUM-USE-GAS PIC 9(04) VALUE 0.                 
      *                                                                 01250018
       01 WS-FLAGS.                                                     
          05 WS-SENIOR-FLAG          PIC X(01) VALUE SPACES.            
          05 WS-1ST-TIME             PIC X(01) VALUE 'Y'.               
          05 WS-GTT-IND-R1           PIC X(01) VALUE 'N'.               
          05 WS-GTT-IND-R2           PIC X(01) VALUE 'N'.               
          05 WS-GTT-IND-R3           PIC X(01) VALUE 'N'.               
          05 WS-GTT-IND-R4           PIC X(01) VALUE 'N'.               
          05 WS-GTT-IND-R5           PIC X(01) VALUE 'N'.               
P00694    05 WS-GTT-IND-R6           PIC X(01) VALUE 'N'.               
          05 WS-ERR-INST-R1          PIC X(01) VALUE 'N'.               
          05 WS-ERR-INST-R2          PIC X(01) VALUE 'N'.               
          05 WS-ERR-INST-R3          PIC X(01) VALUE 'N'.               
          05 WS-ERR-INST-R4          PIC X(01) VALUE 'N'.               
          05 WS-ERR-INST-R5          PIC X(01) VALUE 'N'.               
P00694    05 WS-ERR-INST-R6          PIC X(01) VALUE 'N'.               
          05 WS-INCR-YEAR            PIC X(01) VALUE 'N'.               
P00694    05 WS-EXEMPT-REVIEW        PIC X(01) VALUE 'N'.               
      *                                                                 01430018
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.               
             88 SEND-DONE-ERROR                VALUE 'N'.               
             88 SEND-DONE-OK                   VALUE 'Y'.               
          05 WS-EOF-CURSOR           PIC X(01) VALUE 'N'.               
             88 NO-MORE-DATA                   VALUE 'Y'.               
          05 WS-CURSOR-SW            PIC X(01) VALUE 'N'.               
             88 NO-MORE-ROWS                   VALUE 'Y'.               
          05 WS-BILLED-SW            PIC X(01) VALUE ' '.               
             88 ADJ-AMT-BILD                   VALUE 'Y'.               
             88 ADJ-AMT-NOT-BILD               VALUE 'N'.               
          05 WS-RESULT-TYPE          PIC 9(01) VALUE 0.                 
             88 WS-PLAN-DET                    VALUE 1.                 
             88 WS-MTHLY-CHGS                  VALUE 2.                 
             88 WS-USAGE                       VALUE 3.                 
             88 WS-REMARKS                     VALUE 4.                 
             88 WS-ANNIV                       VALUE 5.                 
P00694       88 WS-CNSMPT                      VALUE 6.                 
      *                                                                 01620018
       01 WS-MISC.                                                      
          05 WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                     PIC 9(13).                         
          05 WS-PREMISE-NO           PIC X(10) VALUE SPACES.            
          05 WS-PREMISE-NUM REDEFINES WS-PREMISE-NO                     
                                     PIC 9(10).                         
          05 WS-REV-MNTH-DT          PIC X(10) VALUE SPACES.            
          05 WS-REV-MNTH-C           PIC 9(06) VALUE 0.                 
ACT186    05 WS-ANNIVERSARY-DATE.                                       
ACT186       10 WS-ANNIVERSARY-DATE-YR  PIC 9(04).                      
ACT186       10 WS-ANNIVERSARY-DATE-MM  PIC 9(02).                      
COB305    05 WS-REV-MTH-LST-NRML        PIC S9(6) COMP-3 VALUE 0.           
ACT186    05 WS-REV-MTH-LST-NRML-NUM    PIC 9(06).                      
ACT186    05 WS-REV-MTH-LST-NRML-YM.                                    
ACT186       10 WS-REV-MTH-LST-NRML-YR  PIC 9(04).                      
ACT186       10 WS-REV-MTH-LST-NRML-MM  PIC 9(02).                      
ACT186    05 WS-REV-MTH-LST-NRML-NULL   PIC S9(4)     COMP.             
A03300    05 WS-REV-MNTH-2           PIC 9(06).                         
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-GTT-NAME             PIC X(19) VALUE SPACES.            
          05 WS-PREV-YEAR            PIC X(04) VALUE SPACES.            
          05 WS-OLD-TRAN-TS          PIC X(26) VALUE SPACES.            
          05 WS-NEW-TRAN-TS          PIC X(26) VALUE SPACES.            
          05 WS-ZIP-CODE             PIC X(05) VALUE SPACES.            
          05 WS-RATE-PLAN-NO         PIC X(03) VALUE SPACES.            
          05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.            
          05 WS-END-OF-PTC           PIC X(01) VALUE SPACES.            
          05 WS-COMPUTE-PTC          PIC X(01) VALUE SPACES.            
          05 WS-HOLD-DATE-DDAY       PIC X(10) VALUE SPACES.            
          05 WS-HOLD-DATE-DDDC       PIC X(10) VALUE SPACES.            
          05 WS-HOLD-YEAR            PIC 9(04) VALUE 0.                 
          05 WS-HOLD-MONTH           PIC 9(02) VALUE 0.                 
          05 WS-LAST-ACT-MNTH        PIC 9(02) VALUE 0.                 
          05 WS-LAST-ACT-YR          PIC 9(04) VALUE 0.                 
          05 WS-MONTHS-TO-EST        PIC 9(02) VALUE 0.                 
          05 WS-STR-TYPE             PIC X(01) VALUE SPACE.             
          05 WS-TO-REV-MTH           PIC S9(06)V      COMP-3 VALUE +0.  
          05 WS-FROM-REV-MTH         PIC S9(06)V      COMP-3 VALUE +0.  
          05 WS-EST-SUB              PIC S9(04)       COMP VALUE 0.     
          05 WS-RETURN-CODE-1        PIC S9(04)       COMP VALUE 0.     
          05 WS-RETURN-CODE-2        PIC S9(04)       COMP VALUE 0.     
          05 WS-RETURN-CODE-3        PIC S9(04)       COMP VALUE 0.     
          05 WS-RETURN-CODE-4        PIC S9(04)       COMP VALUE 0.     
          05 WS-RETURN-CODE-5        PIC S9(04)       COMP VALUE 0.     
P00694    05 WS-RETURN-CODE-6        PIC S9(04)       COMP VALUE 0.     
          05 WS-SUB1                 PIC S9(09)       COMP VALUE 0.     
          05 WS-SUB2                 PIC S9(09)       COMP VALUE 0.     
          05 RS-RETURN-CODE          PIC S9(09)       COMP VALUE 0.     
          05 WS-PREV-BILD-BBP-AM     PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-BUFFER-AMT           PIC S9(9)V9(2)   COMP-3 VALUE 0.   
          05 WS-MAX-RECV-AMT         PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-CUR-BILD-BBP-AM      PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-BBP-CUR-BAL-AMT      PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-BBP-BILD-BAL-AMT     PIC S9(09)V99    COMP-3 VALUE 0.   
A03300    05 WS-TOT-00-30-60-90      PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-EST-MTHLY-DIFF       PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-AMT-MO-PYMT-RND      PIC S9(11)       COMP-3 VALUE 0.   
          05 WS-NEW-CHARGE           PIC S9(09)V9(02) COMP-3 VALUE 0.   
          05 WS-DEFAULT-DDDC         PIC S9(04)V9(05) COMP-3 VALUE 0.   
          05 WS-DEFAULT-THERMS       PIC S9(04)V9(05) COMP-3 VALUE 0.   
          05 WS-AGL-METER-CHARGE     PIC S9(04)V9(05) COMP-3 VALUE 0.   
          05 WS-PVT-LGHT-TOT         PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-SUB-LGHT-TOT         PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-UNITS                PIC S9(09)       COMP-3 VALUE 0.   
          05 WS-DDDC                 PIC S9(09)V9(04) COMP-3 VALUE 0.   
          05 WS-RATE-PRICE           PIC S9(05)V9(06) COMP-3 VALUE 0.   
          05 WS-DDDC-EDIT            PIC 9(02).9(04).                   
          05 WS-RATE-PRICE-EDIT      PIC 9(05).9(06).                   
          05 WS-GAS-RATE-INCR        PIC S9(01)V9(7)  COMP-3 VALUE +0.  
          05 WS-CURR-REVENUE-MONTH   PIC S9(06)       COMP-3 VALUE 0.   
          05 WS-BBP-DEC-AMT          PIC 9(09).9(02).                   
P00506    05 WS-CIA-AMT              PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-BBP-CUR-BAL-ED       PIC -Z(8)9.9(02).                  
          05 WS-EST-MTHLY-DIFF-ED    PIC -Z(8)9.9(02).                  
          05 WS-BAL-AT-ANNIV-ED      PIC -Z(8)9.9(02).                  
          05 WS-BBP-BILD-BAL-ED      PIC -Z(8)9.9(02).                  
          05 WS-BBP-BILD-AMT-ED      PIC -Z(8)9.9(02).                  
          05 WS-BBP-AMT-ED           PIC -Z(8)9.9(02).                  
          05 WS-CIA-AMT-ED           PIC -Z(8)9.9(02).                  
          05 WS-PREV-CHAR            PIC X(01) VALUE SPACES.            
P00694    05 WS-CUST-SVC-CHRG-EDIT   PIC 9(02).9(02).                   
          05 WS-HOLD-DATE-DDDC-R.                                       
             10 WS-HOLD-YEAR-DDDC    PIC X(04) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-HOLD-MONTH-DDDC   PIC X(02) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-HOLD-FIRST-DAY    PIC X(02) VALUE '01'.              
          05 WS-HOLD-DATE-DDAY-R.                                       
             10 WS-HOLD-YEAR-DDAY    PIC X(04) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-HOLD-MONTH-DDAY   PIC X(02) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-HOLD-FIRST-DDAY   PIC X(02) VALUE '01'.              
          05 WS-REVENUE-DATE.                                           
             10 WS-YEAR              PIC X(04) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-MONTH             PIC X(02) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-DAY               PIC X(02) VALUE '01'.              
          05 WS-REV-MNTH.                                               
             10 WS-YEAR-NUM          PIC 9(04) VALUE 0.                 
             10 WS-MONTH-NUM         PIC 9(02) VALUE 0.                 
          05 WS-DT-CHAR.                                                
             10 WS-YEAR-CHAR         PIC X(04) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-MONTH-CHAR        PIC X(02) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-DATE-CHAR         PIC X(02) VALUE '01'.              
          05 WS-PREV-BILD-TS.                                           
             10 WS-PREV-BILD-DT-TRAN PIC X(10) VALUE SPACES.            
             10 FILLER               PIC X(16) VALUE                    
                                               '-00.00.00.000000'.      
          05 WS-CUR-BILD-TS.                                            
             10 WS-CUR-BILD-DT-TRAN  PIC X(10) VALUE SPACES.            
             10 FILLER               PIC X(16) VALUE                    
                                               '-00.00.00.000000'.      
      *                                                                 02800018
P00694    05 WS-04600-AREA.                                             
P00694       10 WS-04600-CHANNEL     PIC X(03) VALUE SPACES.            
P00694       10 WS-04600-ACCOUNT-NO  PIC X(13) VALUE SPACES.            
P00694       10 WS-04600-OPTION-CD   PIC X(12) VALUE SPACES.            
P00694       10 WS-04600-RATE-PRICE  PIC X(12) VALUE SPACES.            
P00694       10 WS-04600-DDDC        PIC X(07) VALUE SPACES.            
P00694       10 WS-04600-CUST-SVC-FEE PIC X(05) VALUE SPACES.           
P00694       10 WS-04600-ZIP-CODE    PIC X(05) VALUE SPACES.            
P00694*                                                                 02890018
A03300    05 WS-REV-MNTH-DT-2.                                          
A03300       10 WS-YEAR-2            PIC X(04) VALUE SPACES.            
A03300       10 FILLER               PIC X(01) VALUE '-'.               
A03300       10 WS-MONTH-2           PIC X(02) VALUE SPACES.            
A03300       10 FILLER               PIC X(01) VALUE '-'.               
A03300       10 WS-DAY-2             PIC X(02) VALUE '01'.              
      *                                                                 02960018
P00694*01  LOC1            USAGE IS SQL TYPE IS                         
P00694*                    RESULT-SET-LOCATOR VARYING.                  
P00694*01  LOC2            USAGE IS SQL TYPE IS                         
P00694*                    RESULT-SET-LOCATOR VARYING.                  
      *                                                                 03010018
       01 WS-MONTHLY-PASS-THRU.                                         
          05 WS-MNTH-PTC             PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-MNTH-PTC-DDDC        PIC S9(09)V99    COMP-3 VALUE 0.   
          05 WS-MONTH-DDAY-FACTOR    PIC S9(09)V9(06) COMP-3 VALUE 0.   
      *                                                                 03060018
          05 WS-REMARKS-TEXT.                                           
             10 WS-REMARKS-TXT       OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-1.               
                15 WS-REMARKS-CHAR   PIC X(01).                         
      *                                                                 03110018
          05 WS-RESULT-TEXT.                                            
             10 WS-RESULT            OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-2.               
                15 WS-RESULT-CHAR    PIC X(01).                         
      *                                                                 03160018
       01 WS-DDDC-SCULP-PERCENT.                                        
          05 WS-DDDC-SCULP OCCURS 12 TIMES                              
             INDEXED BY WS-SC-INDX.                                     
             10 WS-DDDC-SCULP-MTH    PIC 9(02).                         
COB305       10 WS-DDDC-SCULP-VALUE        PIC 9(04)V9(05) USAGE COMP-3 
COB305          VALUE 0.      
       01 WS-HOLD-AREA.                                                 
          05 WS-HOLD-ROWS.                                              
             10 FILLER               PIC X(10)     VALUE SPACES.        
             10 FILLER               PIC S9(09)V99 COMP-3 VALUE 0.      
A03925       10 FILLER               PIC S9(04)    COMP VALUE 0.        
      *                                                                 03270018
       01 WS-BBP-USAGE.                                                 
          05 WS-BBP-EST-TB  OCCURS 15 TIMES.                            
             10 WS-REV-MNTH-EST      PIC X(10)     VALUE SPACES.        
             10 WS-NEW-CHG-EST       PIC S9(09)V99 COMP-3 VALUE 0.      
A03925       10 WS-NO-OF-DAYS        PIC S9(04)    COMP VALUE 0.        
      *                                                                 03330018
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1      PIC S9(04)    COMP VALUE 0.        
             10 S-APPL-RETURN-CODE-1 PIC X(06)     VALUE SPACES.        
             10 S-ANIVERSARY-DATE    PIC X(10)     VALUE SPACES.        
             10 S-START-DATE         PIC X(10)     VALUE SPACES.        
             10 S-MTHLY-CNT-TOT-AMT  PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-BBP-MNTHS-REMAIN   PIC S9(04)    COMP VALUE 0.        
             10 S-BBP-NEW-SUGG-AMT   PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-BAL-AT-ANNIV       PIC S9(09)V99 COMP-3 VALUE 0.      
P00836       10 S-BBP-TOTAL-CHRGS    PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-BAL-REMARKS        PIC X(210)   VALUE SPACES.         
      * 'P'-Premise/'C'-Customer's Consumption                          03460018
             10 S-CNSMPTN-USED       PIC X(01)     VALUE 'C'.           
P00694       10 S-EXEMPT-REVIEW      PIC X(01)     VALUE 'N'.           
P0694A       10 S-BBP-CUR-BAL-AMT    PIC S9(09)V99 COMP-3 VALUE +0.     
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2      PIC S9(04)    COMP VALUE 0.        
             10 S-CNT-NAME-DESC      PIC X(30)     VALUE SPACES.        
             10 S-CNT-AMT-MO-PYMT    PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-CNT-PYMTS-REMAIN   PIC S9(09)    COMP VALUE 0.        
             10 S-CNT-EXPIRY-DT      PIC X(10)     VALUE SPACES.        
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3      PIC S9(04)    COMP VALUE 0.        
             10 S-REV-MONTH          PIC X(10)     VALUE SPACES.        
A03925       10 S-NO-OF-DAYS         PIC S9(04)    COMP VALUE 0.        
             10 S-UTIL-CHRG-AMT      PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-BBP-AMT            PIC S9(09)V99 COMP-3 VALUE 0.      
      * 'A'-Actual/'E'-Estimated for current plan year                  03620018
             10 S-USAGE-TYPE         PIC X(01)     VALUE SPACES.        
TASK02       10 S-DATE-BILLED        PIC X(10)     VALUE SPACES.        
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4      PIC S9(04)    COMP VALUE 0.        
             10 S-REV-MNTH           PIC X(10)     VALUE SPACES.        
             10 S-ADJUSTMENT-DATE    PIC X(10)     VALUE SPACES.        
             10 S-ADJUSTMENT-AMT     PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-REMARKS-TEXT       PIC X(210)    VALUE SPACES.        
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5      PIC S9(04)    COMP VALUE 0.        
             10 S-OPTION-SEQ-NO      PIC X(01)     VALUE SPACES.        
             10 S-OPTION-DESC        PIC X(60)     VALUE SPACES.        
             10 S-AMT-BALANCE-DUE-TX PIC X(60)     VALUE SPACES.        
             10 S-AMT-BALANCE-DUE    PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-EST-BBP-AMT-TX     PIC X(60)     VALUE SPACES.        
             10 S-EST-BBP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.      
          05 GTT-RETURN-FIELDS-6.                                       
P00694       10 S-RETURN-CODE-6      PIC S9(9)     COMP VALUE 0.        
             10 S-REVENUE-MONTH      PIC X(10)     VALUE SPACES.        
             10 S-DAYS               PIC S9(4)     COMP VALUE 0.        
             10 S-UNITS              PIC S9(9)     COMP-3 VALUE 0.      
             10 S-CODE-UTIL-TYPE     PIC X(01)     VALUE SPACES.        
             10 S-CUSTOMER-NO        PIC S9(10)    COMP-3 VALUE 0.      
             10 S-NEW-CHARGE         PIC S9(9)V99  COMP-3 VALUE 0.      
             10 S-RATE-PLAN-NO       PIC X(03)     VALUE SPACES.        
             10 S-CALC-ERROR         PIC X(08)     VALUE SPACES.        
             10 S-HTG-CLG-SW         PIC S9(03)    COMP-3 VALUE 0.      
             10 S-BPP-CATEGORY       PIC X(01)     VALUE SPACES.        
P00694       10 S-ELEC-BUFFER        PIC S9(4)V9(5)                     
P00694                                             COMP-3 VALUE 0.      
P00694       10 S-GAS-BUFFER         PIC S9(4)V9(5)                     
P00694                                             COMP-3 VALUE 0.      
      *                                                                 03950018
      ******************************************************************03960018
      *               COBOL WORKING STORAGE COPY BOOKS                 *03970018
      ******************************************************************03980018
      *                                                                 03990018
      ******************************************************************04000018
      *    ERROR HANDLING                                               04010018
      ******************************************************************04020018
      *                                                                 04030018
           EXEC SQL                                                     04040018
              INCLUDE CWSX0010                                          04050018
           END-EXEC.                                                    04060018
      *                                                                 04070018
      ******************************************************************04080018
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *04090018
      ******************************************************************04100018
      *                                                                 04110018
           COPY CWS00303.                                               04120018
      *                                                                 04130018
P00836******************************************************************04140018
P00836*    WORKING STORAGE FOR BBP CHARGES                             *04150018
P00836******************************************************************04160018
P00836*                                                                 04170018
P00836     EXEC SQL                                                     04180018
P00836         INCLUDE CWS00168                                         04190018
P00836     END-EXEC.                                                    04200018
P00836*                                                                 04210018
      ******************************************************************04220018
      *   SQL COMMUNICATION AREA                                       *04230018
      ******************************************************************04240018
      *                                                                 04250018
           EXEC SQL                                                     04260018
               INCLUDE SQLCA                                            04270018
           END-EXEC.                                                    04280018
      *                                                                 04290018
      ******************************************************************04300018
      *    CODES-DATA-PRESENT LAYOUT                                   *04310018
      ******************************************************************04320018
      *                                                                 04330018
           COPY CWS00056.                                               04340018
                                                                        
      *                                                                 04360018
      ******************************************************************04370018
      *    CSS_ACCOUNT  - AT                                           *04380018
      ******************************************************************04390018
      *                                                                 04400018
           EXEC SQL                                                     04410018
                INCLUDE TBACCT                                          04420018
           END-EXEC.                                                    04430018
      *                                                                 04440018
      ******************************************************************04450018
      *    CSS_ACCT_RTPK_AGR - DF                                       04460018
      ******************************************************************04470018
      *                                                                 04480018
           EXEC SQL                                                     04490018
               INCLUDE TBACCTRG                                         04500018
           END-EXEC.                                                    04510018
      *                                                                 04520018
      ******************************************************************04530018
      *    CSS_ADDR_FORMATTED - DY                                     *04540018
      ******************************************************************04550018
      *                                                                 04560018
           EXEC SQL                                                     04570018
               INCLUDE TBADRFMT                                         04580018
           END-EXEC.                                                    04590018
      *                                                                 04600018
      ******************************************************************04610018
      *    CSS_AR_CNTL  - AC                                           *04620018
      ******************************************************************04630018
      *                                                                 04640018
           EXEC SQL                                                     04650018
               INCLUDE TBARCNTL                                         04660018
           END-EXEC.                                                    04670018
      *                                                                 04680018
      ******************************************************************04690018
      *    CSS_AR_TRANS_HIST  - AR                                     *04700018
      ******************************************************************04710018
      *                                                                 04720018
           EXEC SQL                                                     04730018
               INCLUDE TBARHIST                                         04740018
           END-EXEC.                                                    04750018
      *                                                                 04760018
      ******************************************************************04770018
      *    CSS_AR_TRN_HST_DET - AU                                     *04780018
      ******************************************************************04790018
      *                                                                 04800018
           EXEC SQL                                                     04810018
               INCLUDE TBARHDT                                          04820018
           END-EXEC.                                                    04830018
      *                                                                 04840018
      ******************************************************************04850018
      *    CSS_AR_TYPE  - L5                                           *04860018
      ******************************************************************04870018
      *                                                                 04880018
           EXEC SQL                                                     04890018
               INCLUDE TBARTYPE                                         04900018
           END-EXEC.                                                    04910018
      *                                                                 04920018
      ******************************************************************04930018
      *    CSS_BILLING_HDR - BI                                        *04940018
      ******************************************************************04950018
      *                                                                 04960018
           EXEC SQL                                                     04970018
              INCLUDE TBBLLHDR                                          04980018
           END-EXEC.                                                    04990018
      *                                                                 05000018
      ******************************************************************05010018
      *    CSS_BILLING_DET - BG                                        *05020018
      ******************************************************************05030018
      *                                                                 05040018
           EXEC SQL                                                     05050018
              INCLUDE TBBLLDET                                          05060018
           END-EXEC.                                                    05070018
      *                                                                 05080018
      ******************************************************************05090018
      *    CSS_BILL_WINDOW - BN                                        *05100018
      ******************************************************************05110018
      *                                                                 05120018
           EXEC SQL                                                     05130018
               INCLUDE TBBILWDW                                         05140018
           END-EXEC.                                                    05150018
      *                                                                 05160018
      ******************************************************************05170018
      *    CSS_BUDGET_HIST - BH                                        *05180018
      ******************************************************************05190018
      *                                                                 05200018
           EXEC SQL                                                     05210018
               INCLUDE TBBGTHST                                         05220018
           END-EXEC.                                                    05230018
      *                                                                 05240018
      ******************************************************************05250018
      *    CSS_BUDGET_PLAN - BU                                        *05260018
      ******************************************************************05270018
      *                                                                 05280018
           EXEC SQL                                                     05290018
               INCLUDE TBBGTPLN                                         05300018
           END-EXEC.                                                    05310018
      *                                                                 05320018
      ******************************************************************05330018
      *    CSS_CONTRACT - CT                                           *05340018
      ******************************************************************05350018
      *                                                                 05360018
           EXEC SQL                                                     05370018
               INCLUDE TBCNTRCT                                         05380018
           END-EXEC.                                                    05390018
      *                                                                 05400018
      ******************************************************************05410018
      *    CSS_CONTRACT_INFO - K6                                      *05420018
      ******************************************************************05430018
      *                                                                 05440018
           EXEC SQL                                                     05450018
               INCLUDE TBCNTINF                                         05460018
           END-EXEC.                                                    05470018
      *                                                                 05480018
      ******************************************************************05490018
      *    CSS_DELINQUENCY - C8                                        *05500018
      ******************************************************************05510018
      *                                                                 05520018
           EXEC SQL                                                     05530018
              INCLUDE TBDELQ                                            05540018
           END-EXEC.                                                    05550018
      *                                                                 05560018
      ******************************************************************05570018
      *    CSS_DEP_REQ - DR                                            *05580018
      ******************************************************************05590018
      *                                                                 05600018
           EXEC SQL                                                     05610018
               INCLUDE TBDEPREQ                                         05620018
           END-EXEC.                                                    05630018
      *                                                                 05640018
      ******************************************************************05650018
      *    CSS_DFA_ACCT - DA                                           *05660018
      ******************************************************************05670018
      *                                                                 05680018
           EXEC SQL                                                     05690018
               INCLUDE TBDFAACT                                         05700018
           END-EXEC.                                                    05710018
      *                                                                 05720018
      ******************************************************************05730018
      *    CSS_FIXED_FCTR - FF                                         *05740018
      ******************************************************************05750018
      *                                                                 05760018
           EXEC SQL                                                     05770018
               INCLUDE TBFXDFCT                                         05780018
           END-EXEC.                                                    05790018
                                                                        
      *                                                                 05810018
      ******************************************************************05820018
      *    CSS_NAME_ACCT_XREF - HT                                     *05830018
      ******************************************************************05840018
      *                                                                 05850018
           EXEC SQL                                                     05860018
               INCLUDE TBNMACTX                                         05870018
           END-EXEC.                                                    05880018
      *                                                                 05890018
      ******************************************************************05900018
      *    CSS_PREMISE - PR                                            *05910018
      ******************************************************************05920018
      *                                                                 05930018
           EXEC SQL                                                     05940018
              INCLUDE TBPREM                                            05950018
           END-EXEC.                                                    05960018
      *                                                                 05970018
      ******************************************************************05980018
      *    CRM_RT_PKG_OPTION - FI                                      *05990018
      ******************************************************************06000018
      *                                                                 06010018
           EXEC SQL                                                     06020018
               INCLUDE TBRTPKGO                                         06030018
           END-EXEC.                                                    06040018
      *                                                                 06050018
      ******************************************************************06060018
      *    CSS_PROJ_SHARE - PJ                                         *06070018
      ******************************************************************06080018
      *                                                                 06090018
           EXEC SQL                                                     06100018
                INCLUDE TBPRJSHR                                        06110018
           END-EXEC.                                                    06120018
      *                                                                 06130018
      ******************************************************************06140018
      *    CSS_RATE_CREATOR - RT                                       *06150018
      ******************************************************************06160018
      *                                                                 06170018
           EXEC SQL                                                     06180018
              INCLUDE TBRTCRTR                                          06190018
           END-EXEC.                                                    06200018
      *                                                                 06210018
      ******************************************************************06220018
      *    CSS_SPCL_FCTR - SF                                          *06230018
      ******************************************************************06240018
      *                                                                 06250018
           EXEC SQL                                                     06260018
               INCLUDE TBSPLFTR                                         06270018
           END-EXEC.                                                    06280018
      *                                                                 06290018
      ******************************************************************06300018
      *    CSS_SPCL_FCTR_APPL - SA                                     *06310018
      ******************************************************************06320018
      *                                                                 06330018
           EXEC SQL                                                     06340018
               INCLUDE TBSPLAPL                                         06350018
           END-EXEC.                                                    06360018
      *                                                                 06370018
      ******************************************************************06380018
      *    CSS_UTL_ENVRMNT - UT                                        *06390018
      ******************************************************************06400018
      *                                                                 06410018
           EXEC SQL                                                     06420018
              INCLUDE TBUTLENV                                          06430018
           END-EXEC.                                                    06440018
      *                                                                 06450018
P00836******************************************************************06460018
P00836*    CSS_GL_ACCT_NO GL                                           *06470018
P00836******************************************************************06480018
P00836*                                                                 06490018
P00836     EXEC SQL                                                     06500018
P00836        INCLUDE TBGLATNO                                          06510018
P00836     END-EXEC.                                                    06520018
P00836*                                                                 06530018
      ******************************************************************06540018
      *   CSS_ACCT_ATTRIBUTE - YP                                      *06550018
      ******************************************************************06560018
      *                                                                 06570018
P00694     EXEC SQL                                                     06580018
P00694        INCLUDE TBACTATT                                          06590018
P00694     END-EXEC.                                                    06600018
P00694*                                                                 06610018
      ******************************************************************06620018
      *    COPYBOOK FOR MCSCB063                                       *06630018
      ******************************************************************06640018
      *                                                                 06650018
           EXEC SQL                                                     06660018
              INCLUDE CWS00063                                          06670018
           END-EXEC.                                                    06680018
      *                                                                 06690018
P00836******************************************************************06700018
P00836*    WORKING STORAGE FOR GL ACCOUNT                              *06710018
P00836******************************************************************06720018
P00836*                                                                 06730018
P00836     COPY CWS00096.                                               06740018
P00836*                                                                 06750018
P00836******************************************************************06760018
P00836*    CURSOR FOR BBP CHARGES                                      *06770018
P00836******************************************************************06780018
P00836*                                                                 06790018
P00836     EXEC SQL                                                     06800018
P00836         INCLUDE CWS0168A                                         06810018
P00836     END-EXEC.                                                    06820018
      *                                                                 06830018
      ******************************************************************06840018
      *    DECLARE CURSOR TO GET ALL RECEIVABLES                       *06850018
      ******************************************************************06860018
      *                                                                 06870018
           EXEC SQL                                                     
              DECLARE AR_CURSOR CURSOR FOR                              
                 SELECT AC.AMT_AR_DAY_00                                
                       ,AC.AMT_AR_DAY_30                                
                       ,AC.AMT_AR_DAY_60                                
                       ,AC.AMT_AR_DAY_90                                
                       ,AC.AMT_UNUSED_CR                                
                       ,AC.AMT_TRAN_BALANCE                             
                       ,AC.TOT_SUMM_UNBILLED                            
                       ,AC.PYMT_PRIORITY_LVL                            
                       ,L5.AR_TYPE_LONG_DESC                            
                       ,AC.ITEM_ID                                      
                   FROM CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                   
                       ,CSS_AR_TYPE  L5 WITH(READUNCOMMITTED)                   
                  WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           
                    AND AC.PYMT_PRIORITY_LVL = L5.PYMT_PRIORITY_LVL     
P00506              AND AC.PYMT_PRIORITY_LVL IN (50,70,80,90,100,129)   
                    AND AC.ITEM_ID           > 0                        
                  ORDER BY  PYMT_PRIORITY_LVL ASC                       
                           ,ITEM_ID DESC                                
              FOR READ ONLY                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06880018
MFA-TR*       DECLARE AR_CURSOR CURSOR FOR                              06890018
MFA-TR*          SELECT AC.AMT_AR_DAY_00                                06900018
MFA-TR*                ,AC.AMT_AR_DAY_30                                06910018
MFA-TR*                ,AC.AMT_AR_DAY_60                                06920018
MFA-TR*                ,AC.AMT_AR_DAY_90                                06930018
MFA-TR*                ,AC.AMT_UNUSED_CR                                06940018
MFA-TR*                ,AC.AMT_TRAN_BALANCE                             06950018
MFA-TR*                ,AC.TOT_SUMM_UNBILLED                            06960018
MFA-TR*                ,AC.PYMT_PRIORITY_LVL                            06970018
MFA-TR*                ,L5.AR_TYPE_LONG_DESC                            06980018
MFA-TR*                ,AC.ITEM_ID                                      06990018
MFA-TR*            FROM CSS_AR_CNTL  AC                                 07000018
MFA-TR*                ,CSS_AR_TYPE  L5                                 07010018
MFA-TR*           WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           07020018
MFA-TR*             AND AC.PYMT_PRIORITY_LVL = L5.PYMT_PRIORITY_LVL     07030018
MFA-TR*             AND AC.PYMT_PRIORITY_LVL IN (50,70,80,90,100,129)   07040018
MFA-TR*             AND AC.ITEM_ID           > 0                        07050018
MFA-TR*           ORDER BY  PYMT_PRIORITY_LVL ASC                       07060018
MFA-TR*                    ,ITEM_ID DESC                                07070018
MFA-TR*       FOR FETCH ONLY                                            07080018
MFA-TR*            WITH UR                                              07090018
MFA-TR*         QUERYNO 7200                                            07100018
MFA-TR*    END-EXEC.                                                    07110018
      *                                                                 07120018
      ******************************************************************07130018
      *    DECLARE CURSOR TO GET ACTUAL BILL AMOUNTS.                  *07140018
      ******************************************************************07150018
      *                                                                 07160018
           EXEC SQL                                                     
              DECLARE ACT_BILL CURSOR FOR                               
                 SELECT                                                 
                        COALESCE(SUM(BG.AMT_BILL_ITEM),0)               
                       ,BI.DATE_BILLED                                  
                       ,BG.REVENUE_MONTH                                
                       ,BG.REV_MTH_ORIG_BILL                            
A03925                 ,BG.NO_OF_CONS_DAYS                              
                   FROM                                                 
                        CSS_BILLING_HDR BI WITH(READUNCOMMITTED),               
                        CSS_BILLING_DET BG WITH(READUNCOMMITTED)                
                  WHERE                                                 
                        BG.ACCOUNT_NO           = :BG-ACCOUNT-NO        
                    AND BI.ACCOUNT_NO           = :BI-ACCOUNT-NO        
                    AND BI.BILL_NO              = BG.BILL_NO            
                    AND BG.CODE_BILL_ITM_TYPE   = 'C'                   
                    AND BG.CODE_BILL_ITM_IND    = 'A'                   
                    AND BG.CODE_BILL_CALC       = 'A'                   
                    AND BI.DATE_BILLED          IS NOT NULL             
                    AND ((BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MTH 
                        AND :WS-TO-REV-MTH )                            
                         OR (BG.REV_MTH_ORIG_BILL = 0 AND               
                            BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MTH   
                        AND :WS-TO-REV-MTH ))                           
                  GROUP BY BI.DATE_BILLED                               
                          ,BG.REVENUE_MONTH                             
                          ,BG.REV_MTH_ORIG_BILL                         
A03925                    ,BG.NO_OF_CONS_DAYS                           
              FOR READ ONLY                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07170018
MFA-TR*       DECLARE ACT_BILL CURSOR FOR                               07180018
MFA-TR*          SELECT                                                 07190018
MFA-TR*                 COALESCE(SUM(BG.AMT_BILL_ITEM),0)               07200018
MFA-TR*                ,BI.DATE_BILLED                                  07210018
MFA-TR*                ,BG.REVENUE_MONTH                                07220018
MFA-TR*                ,BG.REV_MTH_ORIG_BILL                            07230018
MFA-TR*                ,BG.NO_OF_CONS_DAYS                              07240018
MFA-TR*            FROM                                                 07250018
MFA-TR*                 CSS_BILLING_HDR BI,                             07260018
MFA-TR*                 CSS_BILLING_DET BG                              07270018
MFA-TR*           WHERE                                                 07280018
MFA-TR*                 BG.ACCOUNT_NO           = :BG-ACCOUNT-NO        07290018
MFA-TR*             AND BI.ACCOUNT_NO           = :BI-ACCOUNT-NO        07300018
MFA-TR*             AND BI.BILL_NO              = BG.BILL_NO            07310018
MFA-TR*             AND BG.CODE_BILL_ITM_TYPE   = 'C'                   07320018
MFA-TR*             AND BG.CODE_BILL_ITM_IND    = 'A'                   07330018
MFA-TR*             AND BG.CODE_BILL_CALC       = 'A'                   07340018
MFA-TR*             AND BI.DATE_BILLED          IS NOT NULL             07350018
MFA-TR*             AND ((BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MTH 07360018
MFA-TR*                 AND :WS-TO-REV-MTH )                            07370018
MFA-TR*                  OR (BG.REV_MTH_ORIG_BILL = 0 AND               07380018
MFA-TR*                     BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MTH   07390018
MFA-TR*                 AND :WS-TO-REV-MTH ))                           07400018
MFA-TR*           GROUP BY BI.DATE_BILLED                               07410018
MFA-TR*                   ,BG.REVENUE_MONTH                             07420018
MFA-TR*                   ,BG.REV_MTH_ORIG_BILL                         07430018
MFA-TR*                   ,BG.NO_OF_CONS_DAYS                           07440018
MFA-TR*       FOR FETCH ONLY                                            07450018
MFA-TR*            WITH UR                                              07460018
MFA-TR*         QUERYNO 7300                                            07470018
MFA-TR*    END-EXEC.                                                    07480018
      *                                                                 07490018
      ******************************************************************07500018
      *    DECLARE CURSOR TO GET ALL THE ADJUSTED BBP AMOUNTS.         *07510018
      ******************************************************************07520018
      *                                                                 07530018
           EXEC SQL                                                     
              DECLARE BBP_HIST CURSOR FOR                               
                 SELECT CAST(BH.BUD_HIST_SEQ_NO AS DATE)                        
                       ,BH.AMT_MO_PYMT                                  
                       ,BH.REMARKS                                      
                   FROM CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                
                  WHERE BH.ACCOUNT_NO      = :BH-ACCOUNT-NO             
                    AND BH.BUD_HIST_SEQ_NO BETWEEN                      
                          CIS.CHAR2TIMESTAMP(:WS-OLD-TRAN-TS) AND 
              CIS.CHAR2TIMESTAMP(:WS-NEW-TRAN-TS)           
                    AND BH.CHANGE_REASON   IN ('M','C')                 
                    AND BH.AMT_MO_PYMT     <> :WS-PREV-BILD-BBP-AM      
                  ORDER BY BH.BUD_HIST_SEQ_NO ASC                       
              FOR READ ONLY                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     07540018
MFA-TR*       DECLARE BBP_HIST CURSOR FOR                               07550018
MFA-TR*          SELECT DATE(BH.BUD_HIST_SEQ_NO)                        07560018
MFA-TR*                ,BH.AMT_MO_PYMT                                  07570018
MFA-TR*                ,BH.REMARKS                                      07580018
MFA-TR*            FROM CSS_BUDGET_HIST BH                              07590018
MFA-TR*           WHERE BH.ACCOUNT_NO      = :BH-ACCOUNT-NO             07600018
MFA-TR*             AND BH.BUD_HIST_SEQ_NO BETWEEN                      07610018
MFA-TR*                   :WS-OLD-TRAN-TS AND :WS-NEW-TRAN-TS           07620018
MFA-TR*             AND BH.CHANGE_REASON   IN ('M','C')                 07630018
MFA-TR*             AND BH.AMT_MO_PYMT     <> :WS-PREV-BILD-BBP-AM      07640018
MFA-TR*           ORDER BY BH.BUD_HIST_SEQ_NO ASC                       07650018
MFA-TR*       FOR FETCH ONLY                                            07660018
MFA-TR*            WITH UR                                              07670018
MFA-TR*         QUERYNO 7500                                            07680018
MFA-TR*    END-EXEC.                                                    07690018
      *                                                                 07700018
      *01 LOC-RESLTSET USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.    
MSQ001        EXEC SQL
MSQ001          DECLARE CNSMPT_CUR CURSOR
MSQ001          FOR CALL CSR04600( ' '
                  , :WS-04600-ACCOUNT-NO
                  , :WS-04600-OPTION-CD
                  , :WS-04600-RATE-PRICE
                  , :WS-04600-DDDC
                  , :WS-04600-CUST-SVC-FEE
                  , :WS-04600-ZIP-CODE
                  )
MSQ001        END-EXEC.
    
      *                                                                 07720018
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC  X(13).                    
       01  PARM-APPL-PROGRAM-ID          PIC  X(03).                    
      *                                                                 07750018
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                ,PARM-APPL-PROGRAM-ID.                  
      *                                                                 07770019
      ******************************************************************07780018
      * 0000-MAINLINE                                                  *07790018
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *07800018
      ******************************************************************07810018
      *                                                                 07820018
       0000-MAINLINE.                                                   
      *                                                                 07840018
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                 07890018
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07920018
      ******************************************************************07930018
      * 0100-INITIALIZE                                                *07940018
      ******************************************************************07950018
      *                                                                 07960018
       0100-INITIALIZE.                                                 
      *                                                                 07980018
           PERFORM 7650-GET-CUR-DATE        THRU 7650-EXIT.             
           MOVE 0                           TO WS-BBP-DEC-AMT.          
      *                                                                 08010018
      * Get meter read charge                                           08020018
      *                                                                 08030018
           MOVE '01'                        TO C8-COMPANY-NO.           
           MOVE WS-AGL-METER-CHRG-TX        TO C8-DELINQ-CD.            
           PERFORM 7660-GET-DELINQ-VALUE    THRU 7660-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-AGL-METER-CHARGE.     
      *                                                                 08080018
      * Calculate rate increase %                                       08090018
      *                                                                 08100018
           MOVE WS-PCT-ESTRATEINCR-GAS      TO C8-DELINQ-CD.            
           PERFORM 7660-GET-DELINQ-VALUE    THRU 7660-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-GAS-RATE-INCR.        
           COMPUTE WS-GAS-RATE-INCR  = (C8-DELINQ-VALUE * 0.01) + 1.    
      *                                                                 08150018
      * Get default DDDC                                                08160018
      *                                                                 08170018
           MOVE WS-EPP-DEFAULT-DDDC         TO C8-DELINQ-CD.            
           PERFORM 7660-GET-DELINQ-VALUE    THRU 7660-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DEFAULT-DDDC.         
      *                                                                 08210018
      * Get default annual therms                                       08220018
      *                                                                 08230018
           MOVE WS-EPP-DEFAULT-THERMS       TO C8-DELINQ-CD.            
           PERFORM 7660-GET-DELINQ-VALUE    THRU 7660-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DEFAULT-THERMS.       
      *                                                                 08270018
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08300018
      ******************************************************************08310018
      * 0100A-DECLARE-GTT-R1                                           *08320018
      ******************************************************************08330018
      *                                                                 08340018
       0100A-DECLARE-GTT-R1.                                            
      *                                                                 08360018
           MOVE 'SESSION.CSR04402_R1'       TO WS-GTT-NAME.             
           SET  WS-PLAN-DET                 TO TRUE.                    
      *                                                                 08390018
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04402_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04402_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE CHAR(06)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ANNIVERSARY_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,MTHLY_CNT_TOT_AMT    DECIMAL(11,2)                  
                   ,BBP_NO_MNTHS_LEFT    INT                        
                   ,BBP_NEW_SUG_AMT      DECIMAL(11,2)                  
                   ,BAL_AT_ANNIV         DECIMAL(11,2)                  
                   ,BAL_REMARKS CHAR(210)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,CNSMPTN_USED CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,EXEMPT_REVIEW CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P0694A             ,BBP_CUR_BAL_AMT      DECIMAL(11,2)                  
P00836             ,BBP_TOTAL_CHRGS      DECIMAL(11,2)                  
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08590018
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                 08630018
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08830018
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04402_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     08840018
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            08850018
MFA-TR*                          WITH ROWSET POSITIONING FOR            08860018
MFA-TR*        SELECT                                                   08870018
MFA-TR*           *                                                     08880018
MFA-TR*        FROM                                                     08890018
MFA-TR*            SESSION.CSR04402_R1                                  08900018
MFA-TR*    END-EXEC.                                                    08910018
      *                                                                 08920018
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 08950018
      ******************************************************************08960018
      * 0100B-DECLARE-GTT-R2                                           *08970018
      ******************************************************************08980018
      *                                                                 08990018
       0100B-DECLARE-GTT-R2.                                            
      *                                                                 09010018
           MOVE 'SESSION.CSR04402_R2'       TO WS-GTT-NAME.             
           SET WS-MTHLY-CHGS                TO TRUE.                    
      *                                                                 09040018
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04402_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04402_R2
              (                                                       
                    RETURN_CODE          INT                        
                   ,CNT_NAME_DESC CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CNT_AMT_MO_PYMT      DECIMAL(11,2)                  
                   ,CNT_PYMTS_REMAIN     INT                        
                   ,CNT_EXPIRY_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09160018
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
      *                                                                 09200018
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09400018
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04402_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     09410018
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            09420018
MFA-TR*                          WITH ROWSET POSITIONING FOR            09430018
MFA-TR*        SELECT                                                   09440018
MFA-TR*           *                                                     09450018
MFA-TR*        FROM                                                     09460018
MFA-TR*            SESSION.CSR04402_R2                                  09470018
MFA-TR*    END-EXEC.                                                    09480018
      *                                                                 09490018
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 09520018
      ******************************************************************09530018
      * 0100C-DECLARE-GTT-R3                                           *09540018
      ******************************************************************09550018
      *                                                                 09560018
       0100C-DECLARE-GTT-R3.                                            
      *                                                                 09580018
           MOVE 'SESSION.CSR04402_R3'       TO WS-GTT-NAME.             
           SET  WS-USAGE                    TO TRUE.                    
      *                                                                 09610018
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04402_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04402_R3
              (                                                       
                    RETURN_CODE          INT                        
                   ,REV_MONTH CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
A03925             ,NO_OF_DAYS           INT                        
                   ,UTIL_CHRG_AMT        DECIMAL(11,2)                  
                   ,BBP_AMT              DECIMAL(11,2)                  
                   ,USAGE_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
TASK02             ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09750018
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
      *                                                                 09790018
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09990018
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04402_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     10000018
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                            10010018
MFA-TR*                          WITH ROWSET POSITIONING FOR            10020018
MFA-TR*        SELECT                                                   10030018
MFA-TR*           *                                                     10040018
MFA-TR*        FROM                                                     10050018
MFA-TR*            SESSION.CSR04402_R3                                  10060018
MFA-TR*    END-EXEC.                                                    10070018
      *                                                                 10080018
       0100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 10110018
      ******************************************************************10120018
      * 0100D-DECLARE-GTT-R4                                           *10130018
      ******************************************************************10140018
      *                                                                 10150018
       0100D-DECLARE-GTT-R4.                                            
      *                                                                 10170018
           MOVE 'SESSION.CSR04402_R4'       TO WS-GTT-NAME.             
           SET  WS-REMARKS                  TO TRUE.                    
      *                                                                 10200018
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04402_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04402_R4
              (                                                       
                    RETURN_CODE          INT                        
                   ,REV_MNTH CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,ADJUSTMENT_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ADJUSTMENT_AMT       DECIMAL(11,2)                  
                   ,REMARKS_TEXT CHAR(210)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10320018
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
      *                                                                 10360018
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 10560018
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04402_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     10570018
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                            10580018
MFA-TR*                          WITH ROWSET POSITIONING FOR            10590018
MFA-TR*        SELECT                                                   10600018
MFA-TR*           *                                                     10610018
MFA-TR*        FROM                                                     10620018
MFA-TR*            SESSION.CSR04402_R4                                  10630018
MFA-TR*    END-EXEC.                                                    10640018
      *                                                                 10650018
       0100D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 10680018
      ******************************************************************10690018
      * 0100E-DECLARE-GTT-R5                                           *10700018
      ******************************************************************10710018
      *                                                                 10720018
       0100E-DECLARE-GTT-R5.                                            
      *                                                                 10740018
           MOVE 'SESSION.CSR04402_R5'       TO WS-GTT-NAME.             
           SET  WS-ANNIV                    TO TRUE.                    
      *                                                                 10770018
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04402_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04402_R5
              (                                                       
                    RETURN_CODE          INT                        
                   ,OPTION_SEQ_NO CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,OPTION_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AMT_BALANCE_DUE_TX CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AMT_BALANCE_DUE      DECIMAL(11,2)                  
                   ,EST_BBP_AMT_TX CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,EST_BBP_AMT          DECIMAL(11,2)                  
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10910018
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5.         
      *                                                                 10950018
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS    THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100E'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11150018
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04402_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     11160018
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                            11170018
MFA-TR*                          WITH ROWSET POSITIONING FOR            11180018
MFA-TR*        SELECT                                                   11190018
MFA-TR*           *                                                     11200018
MFA-TR*        FROM                                                     11210018
MFA-TR*            SESSION.CSR04402_R5                                  11220018
MFA-TR*    END-EXEC.                                                    11230018
      *                                                                 11240018
       0100E-EXIT.                                                      
            EXIT.                                                       
      *                                                                 11270018
      ******************************************************************11280018
      * 0100F-DECLARE-GTT-R6                                           *11290018
      ******************************************************************11300018
P00694*                                                                 11310018
P00694 0100F-DECLARE-GTT-R6.                                            
P00694*                                                                 11330018
P00694     MOVE 'SESSION.CSR04402_R6'       TO WS-GTT-NAME.             
P00694     SET  WS-CNSMPT                   TO TRUE.                    
P00694*                                                                 11360018
P00694     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04402_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04402_R6
              (                                                       
P00694              RETURN_CODE       INT                           
P00694             ,REVENUE_MONTH CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,DAYS              SMALLINT                          
P00694             ,UNITS             DECIMAL(9,0)                      
P00694             ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,CUSTOMER_NO       DECIMAL(10,0)                     
P00694             ,NEW_CHARGE        DECIMAL(11,2)                     
P00694             ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,CALC_ERROR CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
P00694             ,HTG_CLG_SW        DECIMAL(3,0)                      
P00694             ,EPP_CATEGORY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,ELEC_BUFFER       DECIMAL(9,5)                      
P00694             ,GAS_BUFFER        DECIMAL(9,5)                      
P00694          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 11560018
P00694     MOVE SQLSTATE                    TO WS-SQLSTATE.             
P00694     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00694                                         S-RETURN-CODE-6.         
P00694*                                                                 11600018
P00694     IF WS-SQLSTATE = '42710'                                     
P00694        PERFORM 8000F-DEL-GTT-ROWS    THRU 8000F-EXIT             
P00694     ELSE                                                         
P00694        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00694           CONTINUE                                               
P00694        ELSE                                                      
P00694           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
P00694           MOVE '0100F'               TO ACTIVE-PARAGRAPH         
P00694           MOVE SQLCODE               TO ABEND-SQLCODE            
P00694           MOVE SQLSTATE              TO ABEND-SQLSTATE           
P00694           MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
P00694           MOVE SPACES                TO ABEND-SQL-PREDICATES     
P00694                                         ABEND-TABLES             
P00694           MOVE WS-GTT-NAME           TO TABLE-1                  
P00694           MOVE SPACES                TO TABLE-ELEMENT-1          
P00694           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
P00694           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00694        END-IF                                                    
P00694     END-IF.                                                      
P00694*                                                                 11800018
P00694     EXEC SQL                                                     
P00694         DECLARE C6 CURSOR                             
P00694                           WITH ROWSET POSITIONING FOR            
P00694         SELECT                                                   
P00694            *                                                     
P00694         FROM                                                     
P00694             #CSR04402_R6                                  
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     11810018
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                            11820018
MFA-TR*                          WITH ROWSET POSITIONING FOR            11830018
MFA-TR*        SELECT                                                   11840018
MFA-TR*           *                                                     11850018
MFA-TR*        FROM                                                     11860018
MFA-TR*            SESSION.CSR04402_R6                                  11870018
MFA-TR*    END-EXEC.                                                    11880018
P00694*                                                                 11890018
P00694 0100F-EXIT.                                                      
P00694      EXIT.                                                       
      ******************************************************************11920018
      * 1000-PROCESS-INPUT                                             *11930018
      ******************************************************************11940018
      *                                                                 11950018
       1000-PROCESS-INPUT.                                              
      *                                                                 11970018
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NUM              TO AC-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               BH-ACCOUNT-NO            
                                               CT-ACCOUNT-NO            
                                               DA-ACCOUNT-NO            
                                               PJ-ACCOUNT-NO            
                                               BU-ACCOUNT-NO            
                                               AR-ACCOUNT-NO            
                                               AU-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               BI-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               FF-ACCOUNT-NO            
P00694                                         YP-ACCOUNT-NO            
P00836                                         WS-CA168-ACCOUNT-NO.     
      *                                                                 12140018
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12170018
      ******************************************************************12180018
      * 2000-PROCESS-OUTPUT                                            *12190018
      ******************************************************************12200018
      *                                                                 12210018
       2000-PROCESS-OUTPUT.                                             
      *                                                                 12230018
P00836     INITIALIZE  WS-TOTAL-BBP-CHARGE.                             
           MOVE 'N'                         TO WS-EOF-CURSOR.           
      *                                                                 12260018
      * Get Account Details                                             12270018
      *                                                                 12280018
           PERFORM 7000-GET-ACCT-DET        THRU 7000-EXIT.             
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
      *                                                                 12310018
      * Get BBP Payment start date & Revenue month                      12320018
      *                                                                 12330018
           SET WS-PLAN-DET                  TO TRUE.                    
           PERFORM 7100-GET-BBP-DET         THRU 7100-EXIT.             
           MOVE BU-DATE-PYMT-STRT           TO S-START-DATE.            
           MOVE BU-ANNIVERSARY-DATE         TO S-ANIVERSARY-DATE.       
                                                                        
P00836     IF PARM-APPL-PROGRAM-ID = 'WEB'                              
P00836        PERFORM 4000B-CALC-TOTAL-BBP-CHRG                         
P00836                                      THRU 4000B-EXIT             
P00836        MOVE WS-TOTAL-BBP-CHARGE      TO S-BBP-TOTAL-CHRGS        
P00836     END-IF.                                                      
                                                                        
ACT186     STRING BU-ANNIVERSARY-DATE (1:4)                             
ACT186            BU-ANNIVERSARY-DATE (6:2) DELIMITED BY SIZE           
ACT186       INTO WS-REV-MNTH-C.                                        
ACT186     MOVE WS-REV-MNTH-C               TO WS-ANNIVERSARY-DATE.     
                                                                        
      *                                                                 12500018
      * Compute 'Monthly Charge' Contracts                              12510018
      *                                                                 12520018
           SET WS-MTHLY-CHGS                TO TRUE.                    
           PERFORM 7200-OPEN-AR-CURSOR      THRU 7200-EXIT.             
           PERFORM 7210-FETCH-AR-CURSOR     THRU 7210-EXIT.             
           PERFORM 2100-GET-AR-BALANCE      THRU 2100-EXIT              
             UNTIL NO-MORE-DATA.                                        
           PERFORM 7220-CLOSE-AR-CURSOR     THRU 7220-EXIT.             
      *                                                                 12590018
      * Get Actual Usage From Billing Header/Detail (BI/BG)             12600018
      *                                                                 12610018
           MOVE 1                           TO WS-RET-COUNT             
                                               WS-MNTHS-CTR.            
           SET WS-USAGE                     TO TRUE.                    
           STRING BU-DATE-PYMT-STRT (1:4)                               
                  BU-DATE-PYMT-STRT (6:2) DELIMITED BY SIZE             
             INTO WS-REV-MNTH-C.                                        
           MOVE WS-REV-MNTH-C               TO WS-FROM-REV-MTH.         
           MOVE AT-REV-MTH-LST-NRML         TO WS-TO-REV-MTH.           
           PERFORM 2200-PROCESS-ACT-USAGE   THRU 2200-EXIT.             
ACT186     IF AT-REV-MTH-LST-NRML = 0                                   
ACT228        MOVE 12 TO S-BBP-MNTHS-REMAIN                             
ACT186     ELSE                                                         
ACT186        MOVE AT-REV-MTH-LST-NRML TO WS-REV-MTH-LST-NRML           
ACT186        MOVE WS-REV-MTH-LST-NRML     TO WS-REV-MTH-LST-NRML-NUM   
ACT186        MOVE WS-REV-MTH-LST-NRML-NUM TO WS-REV-MTH-LST-NRML-YM    
                                                                        
ACT186        IF WS-REV-MTH-LST-NRML-MM = 12 AND                        
ACT186                       WS-ANNIVERSARY-DATE-YR =                   
ACT186                           WS-REV-MTH-LST-NRML-YR + 2             
ACT186           ADD  1  TO WS-REV-MTH-LST-NRML-MM                      
ACT186        END-IF                                                    
ACT186        IF WS-REV-MTH-LST-NRML-MM > 12                            
ACT186           COMPUTE WS-REV-MTH-LST-NRML-MM =                       
ACT186                                WS-REV-MTH-LST-NRML-MM - 12       
ACT186           COMPUTE WS-REV-MTH-LST-NRML-YR  =                      
ACT186                                WS-REV-MTH-LST-NRML-YR + 1        
ACT186        END-IF                                                    
ACT186        IF WS-ANNIVERSARY-DATE-YR > WS-REV-MTH-LST-NRML-YR        
ACT186           ADD +12 TO WS-ANNIVERSARY-DATE-MM                      
ACT186        END-IF                                                    
ACT186                                                                  
ACT186        COMPUTE S-BBP-MNTHS-REMAIN = WS-ANNIVERSARY-DATE-MM -     
ACT186                                   WS-REV-MTH-LST-NRML-MM         
ACT228     END-IF.                                                      
      *                                                                 12960018
           MOVE AT-PREMISE-NO               TO WS-PREMISE-NUM.          
           SET WS-USAGE                     TO TRUE.                    
      *       Get Therm Price & Service Charge Fee                      12990018
           PERFORM 2400-GET-THERM-PRICE     THRU 2400-EXIT.             
           MOVE WS-THERM-PRICE              TO WS-RATE-PRICE            
P00694                                         WS-RATE-PRICE-EDIT.      
P00694     MOVE WS-RATE-PRICE-EDIT          TO WS-04600-RATE-PRICE.     
      *    Get DDDC                                                     13040018
           PERFORM 7690-GET-DDDC            THRU 7690-EXIT.             
           MOVE FF-FACTOR                   TO WS-DDDC                  
P00694                                         WS-DDDC-EDIT.            
P00694     MOVE WS-DDDC-EDIT                TO WS-04600-DDDC.           
      *    Check for Senior indicator                                   13090018
           PERFORM 7840-CHECK-SR-CITIZEN    THRU 7840-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                      TO WS-SENIOR-FLAG           
           ELSE                                                         
              MOVE 'N'                      TO WS-SENIOR-FLAG           
           END-IF.                                                      
      *    Get ZIP code                                                 13160018
           PERFORM 7710-GET-ZIP-CODE        THRU 7710-EXIT.             
           MOVE DY-ZIP-CODE                 TO WS-ZIP-CODE              
P00694                                         WS-04600-ZIP-CODE.       
      *                                                                 13200018
      * CHECK FOR EXEMPT FROM BBP REVIEW                                13210018
      *                                                                 13220018
P00694     PERFORM 7850-CHECK-EXEMPT-REVIEW THRU 7850-EXIT.             
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00694        MOVE WS-EXEMPT-REVIEW     TO S-EXEMPT-REVIEW              
P00694     ELSE                                                         
P00694        MOVE 'N'                  TO S-EXEMPT-REVIEW              
P00694     END-IF.                                                      
P00694*                                                                 13290018
P00694     PERFORM 5500-CALL-CSR04600       THRU 5500-EXIT.             
P00694*                                                                 13310018
           IF WS-EST-COUNT > 0                                          
              PERFORM 2300-PROCESS-EST-USAGE                            
                                            THRU 2300-EXIT              
           END-IF.                                                      
P0694C* Compute Projected Balance at Anniversary                        13360018
      *                                                                 13370018
           PERFORM 2600-COMPUTE-PROJ-BAL    THRU 2600-EXIT.             
           MOVE S-BAL-AT-ANNIV              TO WS-BAL-AT-ANNIV-ED.      
           PERFORM 2700-FORMAT-REMARKS      THRU 2700-EXIT.             
           MOVE WS-RESULT-TEXT              TO S-BAL-REMARKS.           
      *                                                                 13420018
      * Compute suggested BBP Amount                                    13430018
      *                                                                 13440018
           IF S-BBP-MNTHS-REMAIN = 12                                   
              MOVE BU-AMT-MO-PYMT           TO S-BBP-NEW-SUGG-AMT       
           ELSE                                                         
              COMPUTE S-BBP-NEW-SUGG-AMT = S-BBP-AMT       +            
                                          (S-BAL-AT-ANNIV /             
                                           S-BBP-MNTHS-REMAIN)          
              IF S-BBP-NEW-SUGG-AMT < 0                                 
                 MOVE 0                     TO S-BBP-NEW-SUGG-AMT       
              ELSE                                                      
                 COMPUTE WS-AMT-MO-PYMT-RND ROUNDED = S-BBP-NEW-SUGG-AMT
                 IF S-BBP-NEW-SUGG-AMT > WS-AMT-MO-PYMT-RND             
                    COMPUTE S-BBP-NEW-SUGG-AMT = WS-AMT-MO-PYMT-RND + 1 
                 ELSE                                                   
                    MOVE WS-AMT-MO-PYMT-RND TO S-BBP-NEW-SUGG-AMT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 13620018
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
      *                                                                 13640018
      * Show Anniversary Options b/w Anniversary thru Pymt received     13650018
      *                                                                 13660018
           IF  S-BBP-MNTHS-REMAIN = 12 AND                              
               AT-LAST-PYMT-DATE <= AT-DATE-BILL-DAY-00                 
               PERFORM 2800-COMPUTE-ANNIV-OPTNS                         
                                            THRU 2800-EXIT              
           END-IF.                                                      
      *                                                                 13720018
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13750018
      ******************************************************************13760018
      * 2100-GET-AR-BALANCE                                            *13770018
      ******************************************************************13780018
      *                                                                 13790018
       2100-GET-AR-BALANCE.                                             
                                                                        
           MOVE AC-AMT-TRAN-BALANCE            TO WS-MAX-RECV-AMT.      
      *                                                                 13830018
           EVALUATE AC-PYMT-PRIORITY-LVL                                
               WHEN 50                                                  
      *             Budget Billing                                      13860018
                    MOVE WS-MAX-RECV-AMT       TO WS-BBP-CUR-BAL-AMT    
A03300              COMPUTE WS-TOT-00-30-60-90 = AC-AMT-AR-DAY-00 +     
A03300                                           AC-AMT-AR-DAY-30 +     
A03300                                           AC-AMT-AR-DAY-60 +     
A03300                                           AC-AMT-AR-DAY-90       
A03300              MOVE WS-TOT-00-30-60-90    TO WS-BBP-BILD-BAL-AMT   
               WHEN 70                                                  
      *             Credit In Advance(CIA)                              13940018
                    MOVE AC-AMT-UNUSED-CR      TO WS-CIA-AMT            
               WHEN 80                                                  
      *             Deposits                                            13970018
                    MOVE AC-ACCOUNT-NO         TO DR-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DR-DEP-ITEM-ID        
                    PERFORM 7620-GET-DEP-REQ   THRU 7620-EXIT           
                    MOVE DR-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                  DR-AMT-MO-PYMT        
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DR-AMT-MO-PYMT            
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DR-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                            14090018
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +          14100018
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                 14110018
MFA-TR*             END-EXEC                                            14120018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    MOVE 'Deposit'             TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-2       
                    PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT           
               WHEN 90                                                  
      *             DFA's (DPP is not allowed on BBP Accounts)          14170018
                    IF AC-ITEM-ID > 40000000                            
                       CONTINUE                                         
                    ELSE                                                
                       GO TO 2100-EXIT                                  
                    END-IF                                              
                    MOVE AC-ACCOUNT-NO         TO DA-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DA-DFA-ITEM-ID        
                    PERFORM 7630-GET-DFA-DET   THRU 7630-EXIT           
                    MOVE DA-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DA-AMT-MO-PYMT            
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DA-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                            14320018
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +          14330018
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                 14340018
MFA-TR*             END-EXEC                                            14350018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                  DA-AMT-MO-PYMT        
                    MOVE 'DFA'                 TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-2       
                    PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT           
               WHEN 100                                                 
      *             Contracts                                           14420018
                    MOVE AC-ACCOUNT-NO         TO CT-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO CT-CNT-ITEM-ID        
                    PERFORM 7600-GET-CNT-DET   THRU 7600-EXIT           
      *                                                                 14460018
                    IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND               
ACT080                 PERFORM 7210-FETCH-AR-CURSOR     THRU 7210-EXIT  
                       GO TO 2100-EXIT                                  
                    END-IF                                              
      *                                                                 14510018
                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                  CT-AMT-MO-PYMT        
                    MOVE K6-CNT-NAME-DESC      TO S-CNT-NAME-DESC       
                    MOVE CT-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    IF CT-CODE-BILL-TYPE = 'C'                          
                       COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =             
                               WS-MAX-RECV-AMT / CT-AMT-MO-PYMT         
                       IF S-CNT-PYMTS-REMAIN = 0                        
                          MOVE CT-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN 
                       END-IF                                           
                       EXEC SQL                                         
                            SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT              
                       END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*                EXEC SQL                                         14620018
MFA-TR*                     SET :S-CNT-EXPIRY-DT = CURRENT DATE +       14630018
MFA-TR*                         :S-CNT-PYMTS-REMAIN MONTHS              14640018
MFA-TR*                END-EXEC                                         14650018
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                         
                    ELSE                                                
                       MOVE SPACES             TO S-CNT-EXPIRY-DT       
                       MOVE 0                  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    MOVE ZERO                  TO S-RETURN-CODE-2       
                    PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT           
               WHEN 129                                                 
      *             Project Share                                       14730018
                    PERFORM 7610-GET-PJS-AMT   THRU 7610-EXIT           
                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                PJ-MONTHLY-BILL-AM      
                    IF PJ-MONTHLY-BILL-AM > 0                           
                       MOVE 'Project Share'    TO S-CNT-NAME-DESC       
                       MOVE PJ-MONTHLY-BILL-AM TO S-CNT-AMT-MO-PYMT     
                       MOVE 0                  TO S-RETURN-CODE-2       
                       PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT        
                    END-IF                                              
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
      *                                                                 14860018
           PERFORM 7210-FETCH-AR-CURSOR        THRU 7210-EXIT.          
      *                                                                 14880018
       2100-EXIT.                                                       
      *                                                                 14900018
      ******************************************************************14910018
      * 2200-PROCESS-ACT-USAGE                                         *14920018
      ******************************************************************14930018
      *                                                                 14940018
       2200-PROCESS-ACT-USAGE.                                          
      *                                                                 14960018
      * Get Actual Utility Amount Billed & Billed Date                  14970018
           MOVE 'N'                            TO WS-EOF-CURSOR.        
           PERFORM 7300-OPEN-ACT-BILL-CURSOR   THRU 7300-EXIT.          
           PERFORM 7310-FETCH-ACT-BILL-CURSOR  THRU 7310-EXIT.          
           PERFORM 2210-PROCESS-BILL-AMT       THRU 2210-EXIT           
             UNTIL NO-MORE-DATA.                                        
           PERFORM 7320-CLOSE-ACT-BILL-CURSOR  THRU 7320-EXIT.          
      * If BBP amt adjusted and not yet billed                          15040018
           IF WS-ACT-COUNT > 0                                          
              IF WS-CUR-BILD-BBP-AM = BU-AMT-MO-PYMT                    
                 CONTINUE                                               
              ELSE                                                      
                 SET ADJ-AMT-NOT-BILD          TO TRUE                  
                 MOVE WS-CURRENT-DATE          TO WS-CUR-BILD-DT-TRAN   
                 MOVE WS-CUR-BILD-TS           TO WS-NEW-TRAN-TS        
                PERFORM 2211-GET-ADJ-BBP-AMT   THRU 2211-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 15150018
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15180018
      ******************************************************************15190018
      * 2210-PROCESS-BILL-AMT                                          *15200018
      ******************************************************************15210018
      *                                                                 15220018
       2210-PROCESS-BILL-AMT.                                           
      *                                                                 15240018
           MOVE BI-DATE-BILLED             TO AR-DATE-TRANS             
           MOVE BG-AMT-BILL-ITEM           TO S-UTIL-CHRG-AMT           
      * Get BBP amount Billed from Trans Hist. When Customer accepts BBP15270018
      * offer by sending a payment get BBP Amt from Budget Hist.        15280018
           PERFORM 7740-GET-ACT-BBP-AMT    THRU 7740-EXIT               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE AR-ACCOUNT-NO           TO BH-ACCOUNT-NO             
              MOVE BU-DATE-PYMT-STRT       TO BH-DATE-PYMT-STRT         
              MOVE '01'                    TO BH-DATE-PYMT-STRT(9:2)    
              MOVE 'S'                     TO BH-CHANGE-REASON          
              PERFORM 7800-GET-BBP-AMT     THRU 7800-EXIT               
              MOVE BI-DATE-BILLED          TO WS-CUR-BILD-DT-TRAN       
              MOVE BH-AMT-MO-PYMT          TO WS-CUR-BILD-BBP-AM        
           ELSE                                                         
              MOVE AR-DATE-TRANS           TO WS-CUR-BILD-DT-TRAN       
              MOVE AU-AMT-POSTED           TO WS-CUR-BILD-BBP-AM        
           END-IF                                                       
           MOVE WS-CUR-BILD-TS             TO WS-NEW-TRAN-TS            
           IF WS-1ST-TIME = 'Y'                                         
              MOVE WS-CUR-BILD-BBP-AM      TO WS-PREV-BILD-BBP-AM       
              MOVE 'N'                     TO WS-1ST-TIME               
           END-IF                                                       
      *                                                                 15470018
      * If BBP amt changed, then get remarks                            15480018
           IF WS-CUR-BILD-BBP-AM = WS-PREV-BILD-BBP-AM                  
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2211-GET-ADJ-BBP-AMT THRU 2211-EXIT               
           END-IF.                                                      
           IF BG-REV-MTH-ORIG-BILL > 0                                  
              MOVE BG-REV-MTH-ORIG-BILL    TO WS-REV-MNTH-C             
A03300                                        WS-REV-MNTH-2             
           ELSE                                                         
              MOVE BG-REVENUE-MONTH        TO WS-REV-MNTH-C             
A03300                                        WS-REV-MNTH-2             
           END-IF.                                                      
           STRING WS-REV-MNTH-C (1:4) '-'                               
                  WS-REV-MNTH-C (5:2) '-01'                             
                       DELIMITED BY SIZE INTO S-REV-MONTH.              
           MOVE WS-CUR-BILD-BBP-AM         TO WS-PREV-BILD-BBP-AM       
                                              S-BBP-AMT                 
           MOVE WS-CUR-BILD-DT-TRAN        TO WS-PREV-BILD-DT-TRAN      
           MOVE WS-PREV-BILD-TS            TO WS-OLD-TRAN-TS            
A03925     MOVE BG-NO-OF-CONS-DAYS         TO S-NO-OF-DAYS              
           MOVE 'A'                        TO S-USAGE-TYPE              
TASK02     MOVE BI-DATE-BILLED             TO S-DATE-BILLED             
           MOVE WS-REV-MNTH-C(1:4)         TO WS-PREV-YEAR              
                                              WS-LAST-ACT-YR            
           MOVE WS-REV-MNTH-C(5:2)         TO WS-LAST-ACT-MNTH          
      *                                                                 15740018
           ADD +1                          TO WS-RET-COUNT              
           ADD +1                          TO WS-MNTHS-CTR              
           PERFORM 8030-INSERT-GTT-R3      THRU 8030-EXIT               
      *                                                                 15780018
           PERFORM 7310-FETCH-ACT-BILL-CURSOR  THRU 7310-EXIT.          
      *                                                                 15800018
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15830018
      ******************************************************************15840018
      * 2211-GET-ADJ-BBP-AMT                                           *15850018
      ******************************************************************15860018
      *                                                                 15870018
       2211-GET-ADJ-BBP-AMT.                                            
      *                                                                 15890018
           INITIALIZE  WS-BBP-DEC-AMT.                                  
           MOVE WS-PREV-BILD-BBP-AM           TO WS-BBP-DEC-AMT.        
           SET  WS-REMARKS                    TO TRUE.                  
           MOVE 'N'                           TO WS-CURSOR-SW.          
           PERFORM 7500-OPEN-BBP-HIST         THRU 7500-EXIT.           
           PERFORM 7510-FETCH-BBP-HIST        THRU 7510-EXIT.           
      *                                                                 15960018
           PERFORM UNTIL NO-MORE-ROWS                                   
              IF WS-PREV-BILD-BBP-AM = BH-AMT-MO-PYMT                   
                 CONTINUE                                               
              ELSE                                                      
                 MOVE BH-AMT-MO-PYMT          TO S-ADJUSTMENT-AMT       
                                                 S-BBP-AMT              
A03300           MOVE WS-REV-MNTH-2(1:4)        TO WS-YEAR-2            
A03300           MOVE WS-REV-MNTH-2(5:2)        TO WS-MONTH-2           
A03300           MOVE WS-REV-MNTH-DT-2          TO S-REV-MNTH           
                 MOVE BH-BUD-HIST-SEQ-NO      TO S-ADJUSTMENT-DATE      
                 MOVE SPACES                  TO S-REMARKS-TEXT         
                 MOVE BH-REMARKS-TEXT(1:BH-REMARKS-LEN)                 
                                              TO S-REMARKS-TEXT         
                 MOVE BH-AMT-MO-PYMT          TO WS-PREV-BILD-BBP-AM    
                 PERFORM 8040-INSERT-GTT-R4   THRU 8040-EXIT            
              END-IF                                                    
              PERFORM 7510-FETCH-BBP-HIST     THRU 7510-EXIT            
           END-PERFORM.                                                 
      *                                                                 16150018
           PERFORM 7520-CLOSE-BBP-HIST        THRU 7520-EXIT.           
      *                                                                 16170018
       2211-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16200018
      ***************************************************************** 16210018
      *  2300-PROCESS-EST-USAGE                                       * 16220018
      ***************************************************************** 16230018
      *                                                                 16240018
       2300-PROCESS-EST-USAGE.                                          
      *                                                                 16260018
           PERFORM 2310-SORT-EST-USAGE         THRU 2310-EXIT.          
      *                                                                 16280018
           INITIALIZE  WS-REV-MNTH-DT.                                  
      *                                                                 16300018
           PERFORM VARYING WS-EST-SUB FROM 1 BY 1                       
                     UNTIL WS-EST-SUB > WS-EST-COUNT                    
P00694               OR    WS-RET-COUNT > 12                            
              MOVE WS-REV-MNTH-EST(WS-EST-SUB) TO WS-REV-MNTH-DT        
              MOVE WS-NEW-CHG-EST(WS-EST-SUB)  TO S-UTIL-CHRG-AMT       
A03925        MOVE WS-NO-OF-DAYS(WS-EST-SUB)   TO S-NO-OF-DAYS          
      *                                                                 16370018
              MOVE WS-REV-MNTH-DT (1:4)        TO WS-YEAR-CHAR          
                                                  WS-YEAR-NUM           
              MOVE WS-REV-MNTH-DT (6:2)        TO WS-MONTH-CHAR         
      *                                                                 16410018
              IF WS-MONTH-CHAR = '01' OR                                
                  WS-YEAR-CHAR NOT = WS-PREV-YEAR OR                    
                 (WS-YEAR-CHAR = WS-PREV-YEAR AND                       
                  WS-REV-MNTH-DT < BU-DATE-PYMT-STRT)                   
                 MOVE 'Y'                   TO WS-INCR-YEAR             
              END-IF                                                    
      *                                                                 16480018
              IF WS-YEAR-CHAR IS NUMERIC                                
                 IF WS-INCR-YEAR = 'Y'                                  
                    COMPUTE WS-YEAR-NUM  = WS-YEAR-NUM + 1              
                 END-IF                                                 
                 MOVE WS-YEAR-NUM              TO WS-YEAR-CHAR          
                                                  WS-PREV-YEAR          
              END-IF                                                    
      *                                                                 16560018
              MOVE WS-DT-CHAR                  TO S-REV-MONTH           
              MOVE 'E'                         TO S-USAGE-TYPE          
TASK02        MOVE SPACES                      TO S-DATE-BILLED         
              MOVE BU-AMT-MO-PYMT              TO S-BBP-AMT             
              COMPUTE WS-EST-MTHLY-DIFF = WS-EST-MTHLY-DIFF +           
                       (S-UTIL-CHRG-AMT - S-BBP-AMT)                    
              ADD +1                           TO WS-RET-COUNT          
                                                  WS-MNTHS-CTR          
      *                                                                 16650018
              PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT           
           END-PERFORM.                                                 
      *                                                                 16680018
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16710018
      ******************************************************************16720018
      * 2310-SORT-EST-USAGE                                            *16730018
      ******************************************************************16740018
      *                                                                 16750018
       2310-SORT-EST-USAGE.                                             
      * Sort by Revenue Month in Ascending order                        16770018
           PERFORM VARYING  WS-SUB1 FROM 1 BY 1                         
                                    UNTIL WS-SUB1 = WS-EST-COUNT        
              PERFORM VARYING  WS-SUB2 FROM WS-SUB1 BY 1                
                                       UNTIL WS-SUB2 > WS-EST-COUNT     
                 IF WS-REV-MNTH-EST(WS-SUB2) < WS-REV-MNTH-EST(WS-SUB1) 
                    MOVE WS-BBP-EST-TB(WS-SUB1) TO WS-HOLD-ROWS         
                    MOVE WS-BBP-EST-TB(WS-SUB2) TO                      
                                         WS-BBP-EST-TB(WS-SUB1)         
                    MOVE WS-HOLD-ROWS           TO                      
                                         WS-BBP-EST-TB(WS-SUB2)         
                 END-IF                                                 
               END-PERFORM                                              
           END-PERFORM.                                                 
      *                                                                 16910018
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16940018
      ******************************************************************16950018
      * 2400-GET-THERM-PRICE.                                          *16960018
      ******************************************************************16970018
      *                                                                 16980018
       2400-GET-THERM-PRICE.                                            
      *                                                                 17000018
           PERFORM 7670-GET-UTILITY-DETAILS THRU 7670-EXIT.             
      *                                                                 17020018
           MOVE DF-OPTION-CD                TO WS-OPTION-CD             
P00694                                         WS-04600-OPTION-CD.      
           MOVE UT-RATE-PLAN-NO             TO WS-RATE-PLAN-NO          
                                               RT-RATE-PLAN-NO.         
           MOVE UT-IC-NO                    TO FF-IC-NO                 
                                               WS-IC-NO-063.            
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO-063        
P00694                                         WS-04600-ACCOUNT-NO.     
           MOVE 'G'                         TO WS-CODE-UTIL-TYPE-063.   
           MOVE PROGRAM-NAME                TO WS-CPD063-CALLING-PGM.   
           MOVE 'Y'                         TO WS-THERM-CSC-ACCT-FL.    
           MOVE 'Y'                         TO WS-PENDING-OPTION-FL-063.
           MOVE SPACES                      TO ABEND-FUNCTION.          
      *                                                                 17160018
           CALL MCSCB063 USING CWS00063-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE.                          
           MOVE RS-RETURN-CODE              TO  WS-ACTIVE-RETURN-CODE.  
      *                                                                 17210018
           IF ABEND-FUNCTION > SPACES OR RETURN-CODE > 0                
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPCODE ERROR'           TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMNT'      TO TABLE-ELEMENT-1          
              MOVE +100                     TO WS-ACTIVE-RETURN-CODE    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 17300018
           IF WS-PEND063-THERM-PRICE > 0                                
              MOVE WS-PEND063-THERM-PRICE   TO WS-THERM-PRICE           
           END-IF.                                                      
      *                                                                 17340018
P00694     MOVE WS-CSC-AMT                  TO WS-CUST-SVC-CHRG-EDIT.   
P00694     MOVE WS-CUST-SVC-CHRG-EDIT       TO WS-04600-CUST-SVC-FEE.   
      *                                                                 17370018
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17400018
      ******************************************************************17410018
      * 2600-COMPUTE-PROJ-BAL.                                         *17420018
      ******************************************************************17430018
      *                                                                 17440018
       2600-COMPUTE-PROJ-BAL.                                           
      *                                                                 17460018
           MOVE SPACES                      TO WS-REMARKS-TEXT.         
           MOVE WS-BBP-CUR-BAL-AMT          TO WS-BBP-CUR-BAL-ED        
P0694A                                         S-BBP-CUR-BAL-AMT.       
           MOVE WS-EST-MTHLY-DIFF           TO WS-EST-MTHLY-DIFF-ED.    
           EVALUATE TRUE                                                
      * Pymt received since anniversary bill& not yet billed            17520018
               WHEN AT-LAST-PYMT-DATE > AT-DATE-BILL-DAY-00 AND         
                    S-BBP-MNTHS-REMAIN = 12                             
                    MOVE '1'                TO WS-STR-TYPE              
                    COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +       
P00506                                       WS-EST-MTHLY-DIFF  +       
P00506                                       WS-CIA-AMT -               
A03300                                       WS-BBP-BILD-BAL-AMT        
      * Pymt received since last bill (non-anniversary bills)           17600018
               WHEN AT-LAST-PYMT-DATE > AT-DATE-BILL-DAY-00 AND         
                    S-BBP-MNTHS-REMAIN < 12                             
                    MOVE '2'                TO WS-STR-TYPE              
                    COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +       
                                             WS-EST-MTHLY-DIFF -        
A03300                                       WS-BBP-BILD-BAL-AMT        
      * No Pymt received since anniversary bill& not yet billed         17670018
               WHEN AT-LAST-PYMT-DATE <= AT-DATE-BILL-DAY-00 AND        
                    S-BBP-MNTHS-REMAIN = 12                             
      * At anniversary/Setup Next-Bill, expected pymt is billed balance 17700018
                    MOVE '3'                TO WS-STR-TYPE              
                    COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +       
                                             WS-EST-MTHLY-DIFF -        
                                             WS-BBP-BILD-BAL-AMT        
      * No Pymt received since last bill (non-anniversary bills)        17750018
               WHEN AT-LAST-PYMT-DATE <= AT-DATE-BILL-DAY-00 AND        
                    S-BBP-MNTHS-REMAIN < 12                             
      * For non-anniversary bills, expected pymt is BBP Amt             17780018
                    IF ADJ-AMT-NOT-BILD                                 
      * If BBP Amt adjusted and not billed at least once                17800018
                      MOVE '4'              TO WS-STR-TYPE              
                      COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +     
                                               WS-EST-MTHLY-DIFF -      
                                               WS-CUR-BILD-BBP-AM       
                    ELSE                                                
                      MOVE '5'              TO WS-STR-TYPE              
                      COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +     
                                               WS-EST-MTHLY-DIFF -      
                                               S-BBP-AMT                
                    END-IF                                              
               WHEN OTHER                                               
                    MOVE 0                  TO S-BAL-AT-ANNIV           
           END-EVALUATE.                                                
      *                                                                 17940018
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17970018
      ******************************************************************17980018
      * 2700-FORMAT-REMARKS                                            *17990018
      ******************************************************************18000018
      *                                                                 18010018
       2700-FORMAT-REMARKS.                                             
      *                                                                 18030018
           EVALUATE WS-STR-TYPE                                         
               WHEN '1'                                                 
                    MOVE WS-CIA-AMT              TO WS-CIA-AMT-ED       
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - UNUSED CR $'      DELIMITED BY SIZE      
                           WS-CIA-AMT-ED         DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '2'                                                 
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '3'                                                 
                    MOVE WS-BBP-BILD-BAL-AMT     TO WS-BBP-BILD-BAL-ED  
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - BILD BAL $'       DELIMITED BY SIZE      
                           WS-BBP-BILD-BAL-ED    DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '4'                                                 
                    MOVE WS-CUR-BILD-BBP-AM      TO WS-BBP-BILD-AMT-ED  
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - BILD BBP AMT $'   DELIMITED BY SIZE      
                           WS-BBP-BILD-AMT-ED    DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '5'                                                 
                    MOVE S-BBP-AMT               TO WS-BBP-AMT-ED       
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - BBP AMT $'        DELIMITED BY SIZE      
                           WS-BBP-AMT-ED         DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
           END-EVALUATE.                                                
      *                                                                 18630018
           MOVE SPACES                      TO WS-RESULT-TEXT           
                                               WS-PREV-CHAR.            
           SET WS-IDX-1                     TO 1.                       
           SET WS-IDX-2                     TO 1.                       
      *                                                                 18680018
           PERFORM 210 TIMES                                            
              IF WS-REMARKS-CHAR(WS-IDX-1) = SPACES AND                 
                 WS-PREV-CHAR              = SPACES                     
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-REMARKS-CHAR(WS-IDX-1)                         
                                         TO WS-RESULT-CHAR(WS-IDX-2)    
                                            WS-PREV-CHAR                
                 SET WS-IDX-2            UP BY 1                        
              END-IF                                                    
                 SET WS-IDX-1            UP BY 1                        
           END-PERFORM.                                                 
      *                                                                 18810018
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18840018
      ******************************************************************18850018
      * 2800-COMPUTE-ANNIV-OPTNS.                                      *18860018
      ******************************************************************18870018
      *                                                                 18880018
       2800-COMPUTE-ANNIV-OPTNS.                                        
      *                                                                 18900018
           MOVE S-START-DATE            TO BH-DATE-PYMT-STRT            
           MOVE 'A'                     TO BH-CHANGE-REASON             
           PERFORM 7800-GET-BBP-AMT     THRU 7800-EXIT                  
      * If account set-up on BBP for the 1st time& not gone thru billing18940018
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 2000-EXIT                                           
           END-IF                                                       
      *                                                                 18980018
      * Option 1 - If Paid 'Billed Account Balance'                     18990018
      *                                                                 19000018
           MOVE 0                       TO S-RETURN-CODE-5              
           MOVE '1'                     TO S-OPTION-SEQ-NO              
           MOVE WS-OPTION-DESC-1        TO S-OPTION-DESC                
           MOVE AT-TOTAL-AR-BALANCE     TO S-AMT-BALANCE-DUE            
TASK01     IF AC-AMT-AR-DAY-00  =  BH-BUDG-BILL-PREV-AMT                
              MOVE WS-ACCT-BAL-BBP-TX   TO S-AMT-BALANCE-DUE-TX         
           ELSE                                                         
              MOVE WS-ACT-ACCT-BAL-TX   TO S-AMT-BALANCE-DUE-TX         
           END-IF                                                       
           MOVE WS-EST-BBP-AMT-TX       TO S-EST-BBP-AMT-TX             
           MOVE BH-AMT-MO-PYMT          TO S-EST-BBP-AMT                
           PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT                  
      *                                                                 19130018
           IF WS-CODE-BANK-EFT = 'A' OR                                 
              AT-TOTAL-AR-BALANCE = AT-EPP-OFFER-AMOUNT                 
              CONTINUE                                                  
           ELSE                                                         
      * Option 2 - If Paid 'Total Account Balance'                      19180018
               MOVE 0                    TO S-RETURN-CODE-5             
               MOVE '2'                  TO S-OPTION-SEQ-NO             
               MOVE WS-OPTION-DESC-2     TO S-OPTION-DESC               
               MOVE AT-EPP-OFFER-AMOUNT  TO S-AMT-BALANCE-DUE           
TASK01        IF WS-ACT-ACCT-BAL-TX = S-AMT-BALANCE-DUE-TX              
TASK01            MOVE WS-OPTION-DESC-3   TO S-OPTION-DESC              
                  MOVE WS-ACCT-BAL-BBP-TX TO S-AMT-BALANCE-DUE-TX       
               ELSE                                                     
                  MOVE WS-ACT-ACCT-BAL-TX  TO S-AMT-BALANCE-DUE-TX      
               END-IF                                                   
               MOVE WS-EST-BBP-AMT-TX    TO S-EST-BBP-AMT-TX            
               MOVE BH-EPP-ESTIMATE      TO S-EST-BBP-AMT               
               PERFORM 8050-INSERT-GTT-R5                               
                                         THRU 8050-EXIT                 
           END-IF.                                                      
      *                                                                 19340018
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19370018
P00836******************************************************************19380018
P00836* 4000B-CALC-TOTAL-BBP-CHRG                                      *19390018
P00836******************************************************************19400018
P00836*                                                                 19410018
P00836     EXEC SQL                                                     19420018
P00836         INCLUDE CPD00168                                         19430018
P00836     END-EXEC.                                                    19440018
      ******************************************************************19450018
      * 5500-CALL-CSR04600                                             *19460018
      ******************************************************************19470018
P00694*                                                                 19480018
P00694 5500-CALL-CSR04600.                                              
P00694*                                                                 19500018
P00694*    EXEC SQL                                                     
P00694*         CALL CSR04600(' '                                       
P00694*                      ,:WS-04600-ACCOUNT-NO                      
P00694*                      ,:WS-04600-OPTION-CD                       
P00694*                      ,:WS-04600-RATE-PRICE                      
P00694*                      ,:WS-04600-DDDC                            
P00694*                      ,:WS-04600-CUST-SVC-FEE                    
P00694*                      ,:WS-04600-ZIP-CODE                        
P00694*                      )                                          
P00694*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CNSMPT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CNSMPT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CNSMPT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00694*                                                                 19610018
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 19640018
P00694     IF  WS-ACTIVE-RETURN-CODE = +466                             
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE '5500'                TO ACTIVE-PARAGRAPH            
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE 'SPCB CALL'           TO ABEND-FUNCTION              
P00694        MOVE 'CSR04600'            TO TABLE-1                     
P00694        MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
P00694        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
P00694        MOVE 'RATE_PRICE'          TO TABLE-ELEMENT-3             
P00694        MOVE 'DDDC'                TO TABLE-ELEMENT-4             
P00694        MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
P00694        MOVE WS-04600-OPTION-CD    TO HOSTVAR-ELEMENT-2           
P00694        MOVE WS-04600-RATE-PRICE   TO HOSTVAR-ELEMENT-3           
P00694        MOVE WS-04600-DDDC         TO HOSTVAR-ELEMENT-4           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 19820018
P00694*    EXEC SQL                                                     
P00694*         ASSOCIATE LOCATORS (:LOC1, :LOC2)                       
P00694*         WITH PROCEDURE CSR04600                                 
P00694*    END-EXEC.                                                    
P00694*                                                                 19870018
P00694*    EXEC SQL                                                     
P00694*      ALLOCATE CNSMPT_CUR CURSOR FOR RESULT SET :LOC2            
P00694*    END-EXEC.                                                    
P00694*                                                                 19910018
MSQ001     EXEC SQL
MSQ001        GET NEXT RESULT SET
MSQ001        FOR CNSMPT_CUR
MSQ001     END-EXEC. 
P00694     MOVE 'N'                      TO WS-EOF-CURSOR.              
P00694     PERFORM 5600-FETCH-CSR04600   THRU 5600-EXIT                 
P00694                                   UNTIL NO-MORE-DATA.            
P00694*                                                                 19950018
P00694     EXEC SQL                                                     
P00694       CLOSE CNSMPT_CUR                                           
P00694     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 19990018
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 20020018
P00694     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE '5500'                TO ACTIVE-PARAGRAPH            
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE 'CLOSE'               TO ABEND-FUNCTION              
P00694        MOVE 'CSR04600'            TO TABLE-1                     
P00694        MOVE 'ACCT NO'             TO TABLE-ELEMENT-1             
P00694        MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
P00694        MOVE 'OPTION CD'           TO TABLE-ELEMENT-2             
P00694        MOVE WS-04600-OPTION-CD    TO HOSTVAR-ELEMENT-2           
P00694        MOVE 'RATE PRICE'          TO TABLE-ELEMENT-3             
P00694        MOVE WS-04600-RATE-PRICE   TO HOSTVAR-ELEMENT-3           
P00694        MOVE 'DDDC'                TO TABLE-ELEMENT-4             
P00694        MOVE WS-04600-DDDC         TO HOSTVAR-ELEMENT-4           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 20200018
P00694 5500-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 20230018
P00694******************************************************************20240018
P00694* 5600-FETCH-CSR04600                                            *20250018
P00694******************************************************************20260018
P00694*                                                                 20270018
P00694 5600-FETCH-CSR04600.                                             
P00694*                                                                 20290018
P00694     EXEC SQL                                                     
P00694       FETCH CNSMPT_CUR                                           
P00694        INTO  :S-RETURN-CODE-6                                    
P00694             ,:S-REVENUE-MONTH                                    
P00694             ,:S-DAYS                                             
P00694             ,:S-UNITS                                            
 00694             ,:S-NEW-CHARGE                                       
P00694             ,:S-GAS-BUFFER                                       
P00694     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 20390018
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694*                                                                 20410018
P00694     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00694         WHEN SUCCESSFUL-CALL                                     
      *                                                                 20440018
P00694              PERFORM 5610-LOAD-WS-TABLE-FOR-EST THRU 5610-EXIT   
P00694              PERFORM 5700-PROCESS-CSR04600-DATA THRU 5700-EXIT   
      *                                                                 20470018
P00694         WHEN NOT-FOUND                                           
P00694              SET NO-MORE-DATA           TO TRUE                  
P00694              MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
P00694                                            S-RETURN-CODE-6       
P00694         WHEN OTHER                                               
P00694              MOVE '5600'                TO ACTIVE-PARAGRAPH      
P00694              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
P00694              MOVE 'FETCH'               TO ABEND-FUNCTION        
P00694              MOVE 'CSR04600'            TO TABLE-1               
P00694              MOVE 'ACCT NO'             TO TABLE-ELEMENT-1       
P00694              MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1     
P00694              MOVE 'OPTION CD'           TO TABLE-ELEMENT-2       
P00694              MOVE WS-04600-OPTION-CD    TO HOSTVAR-ELEMENT-2     
P00694              MOVE 'RATE PRICE'          TO TABLE-ELEMENT-3       
P00694              MOVE WS-04600-RATE-PRICE   TO HOSTVAR-ELEMENT-3     
P00694              MOVE 'DDDC'                TO TABLE-ELEMENT-4       
P00694              MOVE WS-04600-DDDC         TO HOSTVAR-ELEMENT-4     
P00694              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P00694     END-EVALUATE.                                                
P00694*                                                                 20670018
P00694 5600-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 20700018
P00694 5610-LOAD-WS-TABLE-FOR-EST.                                      
P00694*                                                                 20720018
P00694     IF S-RETURN-CODE-6 = 0                                       
P00694        IF S-REVENUE-MONTH = WS-REV-MNTH-DT                       
P00694           CONTINUE                                               
P00694        ELSE                                                      
P00694           IF S-REVENUE-MONTH > LOW-VALUES AND SPACES             
P00694              MOVE S-REVENUE-MONTH TO WS-REV-MNTH-DT              
P00694           END-IF                                                 
P00694        END-IF                                                    
P00694        COMPUTE WS-EST-SUB            = WS-EST-SUB + 1            
P00694        MOVE S-REVENUE-MONTH (1:4)      TO WS-YEAR-CHAR           
P00694        MOVE S-REVENUE-MONTH (5:2)      TO WS-MONTH-CHAR          
P00694        MOVE WS-DT-CHAR      TO WS-REV-MNTH-EST(WS-EST-SUB)       
P00694        COMPUTE WS-NEW-CHG-EST(WS-EST-SUB) =                      
P00694                     S-NEW-CHARGE                                 
P00694        MOVE S-DAYS           TO WS-NO-OF-DAYS(WS-EST-SUB)        
P00694        COMPUTE WS-EST-COUNT = WS-EST-COUNT + 1                   
P00694     END-IF.                                                      
P00694*                                                                 20900018
P00694 5610-EXIT.                                                       
P00694     EXIT.                                                        
P00694******************************************************************20930018
P00694** VALIDATE & PROCESS  RESULT SET DATA OF CSR04600              **20940018
P00694******************************************************************20950018
P00694*                                                                 20960018
P00694 5700-PROCESS-CSR04600-DATA.                                      
P00694*                                                                 20980018
P00694     IF S-REVENUE-MONTH > LOW-VALUES AND SPACES                   
P00694        MOVE 'G'                           TO S-CODE-UTIL-TYPE    
P00694        MOVE S-REVENUE-MONTH (1:4)         TO WS-YEAR             
P00694        MOVE S-REVENUE-MONTH (5:2)         TO WS-MONTH            
P00694        MOVE WS-REVENUE-DATE               TO S-REVENUE-MONTH     
P00694        PERFORM 8060-INSERT-GTT-R6         THRU 8060-EXIT         
P00694     END-IF.                                                      
P00694*                                                                 21060018
P00694 5700-EXIT.                                                       
P00694     EXIT.                                                        
      ******************************************************************21090018
      * 7000-GET-ACCT-DET.                                             *21100018
      ******************************************************************21110018
      *                                                                 21120018
       7000-GET-ACCT-DET.                                               
      *                                                                 21140018
           EXEC SQL                                                     
              SELECT AT.BILL_CYCLE                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                    ,AT.COMPANY_NO                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
                    ,COALESCE(AT.DATE_BILL_DAY_00,IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))           
                    ,AT.TOTAL_AR_BALANCE                                
                    ,COALESCE(AT.LAST_PYMT_DATE,IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))             
                    ,AT.EPP_OFFER_AMOUNT                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.REV_MTH_LST_NRML                                
                INTO :AT-BILL-CYCLE                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:WS-CURRENT-DATE                                   
                    ,:AT-DATE-BILL-DAY-00                               
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-LAST-PYMT-DATE                                 
                    ,:AT-EPP-OFFER-AMOUNT                               
                    ,:AT-ACCT-CREATE-DT                                 
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-REV-MTH-LST-NRML                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     21150018
MFA-TR*       SELECT AT.BILL_CYCLE                                      21160018
MFA-TR*             ,AT.CUSTOMER_NO                                     21170018
MFA-TR*             ,AT.PREMISE_NO                                      21180018
MFA-TR*             ,AT.COMPANY_NO                                      21190018
MFA-TR*             ,AT.LOCAL_OFFICE                                    21200018
MFA-TR*             ,CURRENT DATE                                       21210018
MFA-TR*             ,IFNULL(AT.DATE_BILL_DAY_00,'0001-01-01')           21220018
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                21230018
MFA-TR*             ,IFNULL(AT.LAST_PYMT_DATE,'0001-01-01')             21240018
MFA-TR*             ,AT.EPP_OFFER_AMOUNT                                21250018
MFA-TR*             ,AT.ACCT_CREATE_DT                                  21260018
MFA-TR*             ,AT.CODES_DATA_PRESENT                              21270018
MFA-TR*             ,AT.REV_MTH_LST_NRML                                21280018
MFA-TR*         INTO :AT-BILL-CYCLE                                     21290018
MFA-TR*             ,:AT-CUSTOMER-NO                                    21300018
MFA-TR*             ,:AT-PREMISE-NO                                     21310018
MFA-TR*             ,:AT-COMPANY-NO                                     21320018
MFA-TR*             ,:AT-LOCAL-OFFICE                                   21330018
MFA-TR*             ,:WS-CURRENT-DATE                                   21340018
MFA-TR*             ,:AT-DATE-BILL-DAY-00                               21350018
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                               21360018
MFA-TR*             ,:AT-LAST-PYMT-DATE                                 21370018
MFA-TR*             ,:AT-EPP-OFFER-AMOUNT                               21380018
MFA-TR*             ,:AT-ACCT-CREATE-DT                                 21390018
MFA-TR*             ,:AT-CODES-DATA-PRESENT                             21400018
MFA-TR*             ,:AT-REV-MTH-LST-NRML                               21410018
MFA-TR*         FROM CSS_ACCOUNT AT                                     21420018
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     21430018
MFA-TR*         WITH UR                                                 21440018
MFA-TR*      QUERYNO 7000                                               21450018
MFA-TR*    END-EXEC.                                                    21460018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21470018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 21500018
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 21640018
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21670018
      ******************************************************************21680018
      * 7100-GET-BBP-DET                                               *21690018
      ******************************************************************21700018
      *                                                                 21710018
       7100-GET-BBP-DET.                                                
      *                                                                 21730018
           EXEC SQL                                                     
              SELECT COALESCE(BU.DATE_PYMT_STRT, IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))            
                    ,COALESCE(BU.ANNIVERSARY_DATE, 
              IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))          
                    ,BU.AMT_MO_PYMT                                     
                INTO :BU-DATE-PYMT-STRT                                 
                    ,:BU-ANNIVERSARY-DATE                               
                    ,:BU-AMT-MO-PYMT                                    
                FROM CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :BU-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21740018
MFA-TR*       SELECT IFNULL(BU.DATE_PYMT_STRT, '0001-01-01')            21750018
MFA-TR*             ,IFNULL(BU.ANNIVERSARY_DATE, '0001-01-01')          21760018
MFA-TR*             ,BU.AMT_MO_PYMT                                     21770018
MFA-TR*         INTO :BU-DATE-PYMT-STRT                                 21780018
MFA-TR*             ,:BU-ANNIVERSARY-DATE                               21790018
MFA-TR*             ,:BU-AMT-MO-PYMT                                    21800018
MFA-TR*         FROM CSS_BUDGET_PLAN BU                                 21810018
MFA-TR*        WHERE ACCOUNT_NO = :BU-ACCOUNT-NO                        21820018
MFA-TR*         WITH UR                                                 21830018
MFA-TR*      QUERYNO 7100                                               21840018
MFA-TR*    END-EXEC.                                                    21850018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21860018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 21890018
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_PLAN'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 22030018
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22060018
      ******************************************************************22070018
      * 7200-OPEN-AR-CURSOR                                            *22080018
      ******************************************************************22090018
      *                                                                 22100018
       7200-OPEN-AR-CURSOR.                                             
      *                                                                 22120018
           EXEC SQL                                                     
                OPEN AR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22160018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 22190018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 22330018
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22360018
      ******************************************************************22370018
      * 7210-FETCH-AR-CURSOR                                           *22380018
      ******************************************************************22390018
      *                                                                 22400018
       7210-FETCH-AR-CURSOR.                                            
      *                                                                 22420018
           EXEC SQL                                                     
              FETCH                                                     
                     AR_CURSOR                                          
              INTO                                                      
                    :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-UNUSED-CR                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-PYMT-PRIORITY-LVL                               
                   ,:L5-AR-TYPE-LONG-DESC                               
                   ,:AC-ITEM-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22580018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 22610018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA     TO TRUE                        
                    MOVE 0               TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE '7210'          TO ACTIVE-PARAGRAPH            
                    MOVE 'FETCH'         TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSS_AR_CNTL'   TO TABLE-1                     
                    MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1             
                    MOVE AC-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 22800018
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22830018
      ******************************************************************22840018
      * 7220-CLOSE-AR-CURSOR                                           *22850018
      ******************************************************************22860018
      *                                                                 22870018
       7220-CLOSE-AR-CURSOR.                                            
      *                                                                 22890018
           EXEC SQL                                                     
                CLOSE AR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22930018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 22960018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7220'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 23100018
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23130018
      ******************************************************************23140018
      * 7300-OPEN-ACT-BILL-CURSOR                                      *23150018
      ******************************************************************23160018
      *                                                                 23170018
       7300-OPEN-ACT-BILL-CURSOR.                                       
      *                                                                 23190018
           EXEC SQL                                                     
                OPEN ACT_BILL                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23230018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 23260018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE 'CSS_BILLING_DET'     TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'WS-FROM-REV-MTH'     TO TABLE-ELEMENT-2             
              MOVE WS-FROM-REV-MTH       TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-TO-REV-MTH'       TO TABLE-ELEMENT-3             
              MOVE WS-TO-REV-MTH         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 23450018
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23480018
      ******************************************************************23490018
      * 7310-FETCH-ACT-BILL-CURSOR                                     *23500018
      ******************************************************************23510018
      *                                                                 23520018
       7310-FETCH-ACT-BILL-CURSOR.                                      
      *                                                                 23540018
           EXEC SQL                                                     
              FETCH                                                     
                     ACT_BILL                                           
              INTO                                                      
                    :BG-AMT-BILL-ITEM                                   
                   ,:BI-DATE-BILLED                                     
                   ,:BG-REVENUE-MONTH                                   
                   ,:BG-REV-MTH-ORIG-BILL                               
A03925             ,:BG-NO-OF-CONS-DAYS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23650018
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-3.      
      *                                                                 23680018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-3       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7310'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_BILLING_DET'     TO TABLE-2               
                    MOVE 'CSS_BILLING_HDR'     TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'WS-FROM-REV-MTH'     TO TABLE-ELEMENT-2       
                    MOVE WS-FROM-REV-MTH       TO HOSTVAR-ELEMENT-2     
                    MOVE 'WS-TO-REV-MTH'       TO TABLE-ELEMENT-3       
                    MOVE WS-TO-REV-MTH         TO HOSTVAR-ELEMENT-3     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 23920018
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23950018
      ******************************************************************23960018
      * 7320-CLOSE-ACT-BILL-CURSOR                                     *23970018
      ******************************************************************23980018
      *                                                                 23990018
       7320-CLOSE-ACT-BILL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE ACT_BILL                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24050018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 24080018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7320'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE 'CSS_BILLING_DET'     TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'WS-FROM-REV-MTH'     TO TABLE-ELEMENT-2             
              MOVE WS-FROM-REV-MTH       TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-TO-REV-MTH'       TO TABLE-ELEMENT-3             
              MOVE WS-TO-REV-MTH         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24270018
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24300018
      ******************************************************************24310018
      * 7500-OPEN-BBP-HIST                                             *24320018
      ******************************************************************24330018
      *                                                                 24340018
       7500-OPEN-BBP-HIST.                                              
      *                                                                 24360018
           EXEC SQL                                                     
                OPEN BBP_HIST                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24400018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 24430018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'EPP_ESTIMATE'        TO TABLE-ELEMENT-2             
              MOVE WS-BBP-DEC-AMT        TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-OLD-TRAN-TS'      TO TABLE-ELEMENT-3             
              MOVE WS-OLD-TRAN-TS        TO HOSTVAR-ELEMENT-3           
              MOVE 'WS-NEW-TRAN-TS'      TO TABLE-ELEMENT-4             
              MOVE WS-NEW-TRAN-TS        TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24630018
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24660018
      ******************************************************************24670018
      * 7510-FETCH-BBP-HIST                                            *24680018
      ******************************************************************24690018
      *                                                                 24700018
       7510-FETCH-BBP-HIST.                                             
      *                                                                 24720018
           EXEC SQL                                                     
              FETCH                                                     
                     BBP_HIST                                           
              INTO                                                      
                    :BH-BUD-HIST-SEQ-NO                                 
                   ,:BH-AMT-MO-PYMT                                     
                   ,:BH-REMARKS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24810018
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-4.      
      *                                                                 24840018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-ROWS           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-4       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7510'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_BUDGET_HIST'     TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'EPP_ESTIMATE'        TO TABLE-ELEMENT-2       
                    MOVE WS-BBP-DEC-AMT        TO HOSTVAR-ELEMENT-2     
                    MOVE 'WS-OLD-TRAN-TS'      TO TABLE-ELEMENT-3       
                    MOVE WS-OLD-TRAN-TS        TO HOSTVAR-ELEMENT-3     
                    MOVE 'WS-NEW-TRAN-TS'      TO TABLE-ELEMENT-4       
                    MOVE WS-NEW-TRAN-TS        TO HOSTVAR-ELEMENT-4     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 25090018
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25120018
      ******************************************************************25130018
      * 7520-CLOSE-BBP-HIST                                            *25140018
      ******************************************************************25150018
      *                                                                 25160018
       7520-CLOSE-BBP-HIST.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE BBP_HIST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25220018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 25250018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7520'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'EPP_ESTIMATE'        TO TABLE-ELEMENT-2             
              MOVE WS-BBP-DEC-AMT        TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-OLD-TRAN-TS'      TO TABLE-ELEMENT-3             
              MOVE WS-OLD-TRAN-TS        TO HOSTVAR-ELEMENT-3           
              MOVE 'WS-NEW-TRAN-TS'      TO TABLE-ELEMENT-4             
              MOVE WS-NEW-TRAN-TS        TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25450018
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25480018
      ******************************************************************25490018
      * 7600-GET-CNT-DET.                                              *25500018
      ******************************************************************25510018
      *                                                                 25520018
       7600-GET-CNT-DET.                                                
      *                                                                 25540018
           EXEC SQL                                                     
                SELECT K6.CNT_NAME_DESC                                 
                      ,CT.CODE_BILL_TYPE                                
                      ,CT.AMT_MO_PYMT                                   
                      ,CT.DATE_PYMT_START                               
                      ,CT.NO_SCHED_PYMTS                                
                  INTO :K6-CNT-NAME-DESC                                
                      ,:CT-CODE-BILL-TYPE                               
                      ,:CT-AMT-MO-PYMT                                  
                      ,:CT-DATE-PYMT-START                              
                      ,:CT-NO-SCHED-PYMTS                               
                  FROM CSS_CONTRACT      CT WITH(READUNCOMMITTED)               
                      ,CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)               
                 WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            
                   AND CT.PYMT_PRIORITY_LVL = 100                       
                   AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID           
                   AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD            
ACT080             AND CT.CNT_STATUS_CD     IN ('B','E')                
                   AND CT.CODE_BILL_TYPE    IN ('B','C')                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25550018
MFA-TR*         SELECT K6.CNT_NAME_DESC                                 25560018
MFA-TR*               ,CT.CODE_BILL_TYPE                                25570018
MFA-TR*               ,CT.AMT_MO_PYMT                                   25580018
MFA-TR*               ,CT.DATE_PYMT_START                               25590018
MFA-TR*               ,CT.NO_SCHED_PYMTS                                25600018
MFA-TR*           INTO :K6-CNT-NAME-DESC                                25610018
MFA-TR*               ,:CT-CODE-BILL-TYPE                               25620018
MFA-TR*               ,:CT-AMT-MO-PYMT                                  25630018
MFA-TR*               ,:CT-DATE-PYMT-START                              25640018
MFA-TR*               ,:CT-NO-SCHED-PYMTS                               25650018
MFA-TR*           FROM CSS_CONTRACT      CT                             25660018
MFA-TR*               ,CSS_CONTRACT_INFO K6                             25670018
MFA-TR*          WHERE CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            25680018
MFA-TR*            AND CT.PYMT_PRIORITY_LVL = 100                       25690018
MFA-TR*            AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID           25700018
MFA-TR*            AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD            25710018
MFA-TR*            AND CT.CNT_STATUS_CD     IN ('B','E')                25720018
MFA-TR*            AND CT.CODE_BILL_TYPE    IN ('B','C')                25730018
MFA-TR*           WITH UR                                               25740018
MFA-TR*        QUERYNO 7600                                             25750018
MFA-TR*    END-EXEC.                                                    25760018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25770018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 25800018
ACT080     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CNT_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE CT-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25960018
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25990018
      ******************************************************************26000018
      * 7610-GET-PJS-AMT.                                              *26010018
      ******************************************************************26020018
      *                                                                 26030018
       7610-GET-PJS-AMT.                                                
      *                                                                 26050018
           EXEC SQL                                                     
                SELECT PJ.MONTHLY_BILL_AM                               
                  INTO :PJ-MONTHLY-BILL-AM                              
                  FROM CSS_PROJ_SHARE PJ WITH(READUNCOMMITTED)                  
                 WHERE PJ.ACCOUNT_NO        = :PJ-ACCOUNT-NO            
                   AND PJ.PYMT_PRIORITY_LVL = 129                       
                   AND PJ.ITEM_ID           = 1                         
                   AND PJ.SHARE_STATUS_CD   = 'A'                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26060018
MFA-TR*         SELECT PJ.MONTHLY_BILL_AM                               26070018
MFA-TR*           INTO :PJ-MONTHLY-BILL-AM                              26080018
MFA-TR*           FROM CSS_PROJ_SHARE PJ                                26090018
MFA-TR*          WHERE PJ.ACCOUNT_NO        = :PJ-ACCOUNT-NO            26100018
MFA-TR*            AND PJ.PYMT_PRIORITY_LVL = 129                       26110018
MFA-TR*            AND PJ.ITEM_ID           = 1                         26120018
MFA-TR*            AND PJ.SHARE_STATUS_CD   = 'A'                       26130018
MFA-TR*           WITH UR                                               26140018
MFA-TR*        QUERYNO 7610                                             26150018
MFA-TR*    END-EXEC.                                                    26160018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26170018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 26200018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
                 MOVE 0.0                TO PJ-MONTHLY-BILL-AM          
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROJ_SHARE'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PJ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26400018
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26430018
      ******************************************************************26440018
      * 7620-GET-DEP-REQ.                                              *26450018
      ******************************************************************26460018
      *                                                                 26470018
       7620-GET-DEP-REQ.                                                
      *                                                                 26490018
           EXEC SQL                                                     
                SELECT DR.AMT_MO_PYMT                                   
                      ,DR.NO_SCHED_PYMTS                                
                  INTO :DR-AMT-MO-PYMT                                  
                      ,:DR-NO-SCHED-PYMTS                               
                  FROM CSS_DEP_REQ DR WITH(READUNCOMMITTED)                     
                 WHERE DR.ACCOUNT_NO        = :DR-ACCOUNT-NO            
                   AND DR.PYMT_PRIORITY_LVL = 80                        
                   AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26500018
MFA-TR*         SELECT DR.AMT_MO_PYMT                                   26510018
MFA-TR*               ,DR.NO_SCHED_PYMTS                                26520018
MFA-TR*           INTO :DR-AMT-MO-PYMT                                  26530018
MFA-TR*               ,:DR-NO-SCHED-PYMTS                               26540018
MFA-TR*           FROM CSS_DEP_REQ DR                                   26550018
MFA-TR*          WHERE DR.ACCOUNT_NO        = :DR-ACCOUNT-NO            26560018
MFA-TR*            AND DR.PYMT_PRIORITY_LVL = 80                        26570018
MFA-TR*            AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID           26580018
MFA-TR*           WITH UR                                               26590018
MFA-TR*        QUERYNO 7620                                             26600018
MFA-TR*    END-EXEC.                                                    26610018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26620018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 26650018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7620'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DR-DEP-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26810018
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26840018
      ******************************************************************26850018
      * 7630-GET-DFA-DET.                                              *26860018
      ******************************************************************26870018
      *                                                                 26880018
       7630-GET-DFA-DET.                                                
      *                                                                 26900018
           EXEC SQL                                                     
                SELECT DA.AMT_MO_PYMT                                   
                      ,DA.NO_SCHED_PYMTS                                
                  INTO :DA-AMT-MO-PYMT                                  
                      ,:DA-NO-SCHED-PYMTS                               
                  FROM CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                    
                 WHERE DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            
                   AND DA.PYMT_PRIORITY_LVL = 90                        
                   AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26910018
MFA-TR*         SELECT DA.AMT_MO_PYMT                                   26920018
MFA-TR*               ,DA.NO_SCHED_PYMTS                                26930018
MFA-TR*           INTO :DA-AMT-MO-PYMT                                  26940018
MFA-TR*               ,:DA-NO-SCHED-PYMTS                               26950018
MFA-TR*           FROM CSS_DFA_ACCT DA                                  26960018
MFA-TR*          WHERE DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            26970018
MFA-TR*            AND DA.PYMT_PRIORITY_LVL = 90                        26980018
MFA-TR*            AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID           26990018
MFA-TR*           WITH UR                                               27000018
MFA-TR*        QUERYNO 7630                                             27010018
MFA-TR*    END-EXEC.                                                    27020018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27030018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 27060018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7630'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DFA_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DA-DFA-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 27220018
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27250018
      *                                                                 27260018
      ******************************************************************27270018
      * 7650-GET-CUR-DATE.                                             *27280018
      ******************************************************************27290018
      *                                                                 27300018
       7650-GET-CUR-DATE.                                               
      *                                                                 27320018
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     27330018
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       27340018
MFA-TR*    END-EXEC.                                                    27350018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27360018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 27390018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7650'                TO ACTIVE-PARAGRAPH            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 27480018
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27510018
      ****************************************************************  27520018
      * 7660-GET-DELINQ-VALUE                                        *  27530018
      ****************************************************************  27540018
      *                                                                 27550018
       7660-GET-DELINQ-VALUE.                                           
      *                                                                 27570018
           EXEC SQL                                                     
               SELECT  C8.DELINQ_VALUE                                  
                 INTO :C8-DELINQ-VALUE                                  
                 FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
                 WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    
                   AND C8.COMPANY_NO = :C8-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27580018
MFA-TR*        SELECT  C8.DELINQ_VALUE                                  27590018
MFA-TR*          INTO :C8-DELINQ-VALUE                                  27600018
MFA-TR*          FROM  CSS_DELINQUENCY C8                               27610018
MFA-TR*          WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                    27620018
MFA-TR*            AND C8.COMPANY_NO = :C8-COMPANY-NO                   27630018
MFA-TR*           WITH UR                                               27640018
MFA-TR*          QUERYNO 7660                                           27650018
MFA-TR*    END-EXEC.                                                    27660018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27670018
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3.        
      *                                                                 27700018
           IF  WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL           
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7660'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD '              TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                 27860018
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27890018
      ******************************************************************27900018
      * 7670-GET-UTILITY-DETAILS                                       *27910018
      ******************************************************************27920018
      *                                                                 27930018
       7670-GET-UTILITY-DETAILS.                                        
      *                                                                 27950018
           EXEC SQL                                                     
              SELECT UT.PREMISE_NO                                      
                    ,UT.IC_NO                                           
                    ,UT.RATE_PLAN_NO                                    
                    ,DF.OPTION_CD                                       
                    ,UT.RT_PKG_OPT_SEQ_NO                               
                    ,FI.OPT_DESC_INT                                    
                    ,FI.OPT_DESC_INT_LONG                               
                INTO :UT-PREMISE-NO                                     
                    ,:UT-IC-NO                                          
                    ,:UT-RATE-PLAN-NO                                   
                    ,:DF-OPTION-CD                                      
                    ,:UT-RT-PKG-OPT-SEQ-NO                              
                    ,:FI-OPT-DESC-INT                                   
                    ,:FI-OPT-DESC-INT-LONG                              
                FROM CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
                    ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
                    ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              
                 AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO               
                 AND UT.CODE_UTIL_TYPE    = 'G'                         
                 AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE           
                 AND UT.IC_NO             = DF.IC_NO                    
                 AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO        
                 AND DF.OPTION_CD         = FI.OPTION_CD                
P00473           AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()           
P00473           AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()           
P00473           AND FI.PROC_STATUS_CD    = 'AC'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     27960018
MFA-TR*       SELECT UT.PREMISE_NO                                      27970018
MFA-TR*             ,UT.IC_NO                                           27980018
MFA-TR*             ,UT.RATE_PLAN_NO                                    27990018
MFA-TR*             ,DF.OPTION_CD                                       28000018
MFA-TR*             ,UT.RT_PKG_OPT_SEQ_NO                               28010018
MFA-TR*             ,FI.OPT_DESC_INT                                    28020018
MFA-TR*             ,FI.OPT_DESC_INT_LONG                               28030018
MFA-TR*         INTO :UT-PREMISE-NO                                     28040018
MFA-TR*             ,:UT-IC-NO                                          28050018
MFA-TR*             ,:UT-RATE-PLAN-NO                                   28060018
MFA-TR*             ,:DF-OPTION-CD                                      28070018
MFA-TR*             ,:UT-RT-PKG-OPT-SEQ-NO                              28080018
MFA-TR*             ,:FI-OPT-DESC-INT                                   28090018
MFA-TR*             ,:FI-OPT-DESC-INT-LONG                              28100018
MFA-TR*         FROM CSS_UTIL_ENVRNMT  UT                               28110018
MFA-TR*             ,CSS_ACCT_RTPK_AGR DF                               28120018
MFA-TR*             ,CRM_RT_PKG_OPTION FI                               28130018
MFA-TR*        WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              28140018
MFA-TR*          AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO               28150018
MFA-TR*          AND UT.CODE_UTIL_TYPE    = 'G'                         28160018
MFA-TR*          AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE           28170018
MFA-TR*          AND UT.IC_NO             = DF.IC_NO                    28180018
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO        28190018
MFA-TR*          AND DF.OPTION_CD         = FI.OPTION_CD                28200018
MFA-TR*          AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP           28210018
MFA-TR*          AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP           28220018
MFA-TR*          AND FI.PROC_STATUS_CD    = 'AC'                        28230018
MFA-TR*         WITH UR                                                 28240018
MFA-TR*     QUERYNO 7670                                                28250018
MFA-TR*    END-EXEC.                                                    28260018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28270018
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-3.        
      *                                                                 28300018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE UT-PREMISE-NO             TO PR-PREMISE-NO           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7670'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                 28440018
       7670-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28470018
      ******************************************************************28480018
      * 7690-GET-DDDC                                                  *28490018
      ******************************************************************28500018
      *                                                                 28510018
       7690-GET-DDDC.                                                   
      *                                                                 28530018
           EXEC SQL                                                     
            SELECT FF.FACTOR                                            
              INTO :FF-FACTOR                                           
              FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                      
             WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                   
               AND IC_NO             = :FF-IC-NO                        
               AND FACTOR_ID         = 'DDC'                            
               AND CODE_UTIL_TYPE    = 'G'                              
               AND EFF_DATE_FROM    <= CAST(SYSDATETIMEOFFSET() AS DATE)        
               AND EFF_DATE_TO      >= CAST(SYSDATETIMEOFFSET() AS DATE)        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     28540018
MFA-TR*     SELECT FF.FACTOR                                            28550018
MFA-TR*       INTO :FF-FACTOR                                           28560018
MFA-TR*       FROM CSS_FIXED_FCTR FF                                    28570018
MFA-TR*      WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                   28580018
MFA-TR*        AND IC_NO             = :FF-IC-NO                        28590018
MFA-TR*        AND FACTOR_ID         = 'DDC'                            28600018
MFA-TR*        AND CODE_UTIL_TYPE    = 'G'                              28610018
MFA-TR*        AND EFF_DATE_FROM    <= CURRENT DATE                     28620018
MFA-TR*        AND EFF_DATE_TO      >= CURRENT DATE                     28630018
MFA-TR*       WITH UR                                                   28640018
MFA-TR*      QUERYNO 7690                                               28650018
MFA-TR*    END-EXEC.                                                    28660018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28670018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 28700018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'EPP-DEFAULT-DDDC' TO C8-DELINQ-CD                
                 PERFORM 7660-GET-DELINQ-VALUE                          
                                         THRU 7660-EXIT                 
                 MOVE C8-DELINQ-VALUE    TO FF-FACTOR                   
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7690'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSS_FIXED_FCTR'   TO TABLE-1                     
                 MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1             
                 MOVE 'IC_NO'            TO TABLE-ELEMENT-2             
                 MOVE FF-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1           
                 MOVE FF-IC-NO           TO HOSTVAR-ELEMENT-2           
                 PERFORM 9700-PROCESS-ABEND                             
                                         THRU 9700-EXIT                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 28940018
       7690-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28970018
      ***************************************************************** 28980018
      * 7710-GET-ZIP-CODE                                             * 28990018
      ***************************************************************** 29000018
      *                                                                 29010018
       7710-GET-ZIP-CODE.                                               
      *                                                                 29030018
           EXEC SQL                                                     
              SELECT TOP(1) PR.LOCAL_OFFICE,
              PR.COMPANY_NO,
              DY.ZIP_CODE,
              DY.ZIP_CODE_TOKEN,
              HT.TOWN                                           
                INTO :PR-LOCAL-OFFICE                                   
                     ,:PR-COMPANY-NO                                    
                     ,:DY-ZIP-CODE                                      
                     ,:DY-ZIP-CODE-TOKEN                                
                     ,:HT-TOWN                                          
                FROM CSS_PREMISE        PR WITH(READUNCOMMITTED),               
                     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
               WHERE PR.PREMISE_NO =:PR-PREMISE-NO                      
                 AND DY.ADDRESS_ID = PR.ADDRESS_ID                      
                 AND HT.ADDRESS_ID = PR.ADDRESS_ID                      
                 AND HT.PREMISE_NO =:PR-PREMISE-NO                      
                                                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     29040018
MFA-TR*       SELECT PR.LOCAL_OFFICE                                    29050018
MFA-TR*              ,PR.COMPANY_NO                                     29060018
MFA-TR*              ,DY.ZIP_CODE                                       29070018
MFA-TR*              ,DY.ZIP_CODE_TOKEN                                 29080018
MFA-TR*              ,HT.TOWN                                           29090018
MFA-TR*         INTO :PR-LOCAL-OFFICE                                   29100018
MFA-TR*              ,:PR-COMPANY-NO                                    29110018
MFA-TR*              ,:DY-ZIP-CODE                                      29120018
MFA-TR*              ,:DY-ZIP-CODE-TOKEN                                29130018
MFA-TR*              ,:HT-TOWN                                          29140018
MFA-TR*         FROM CSS_PREMISE        PR,                             29150018
MFA-TR*              CSS_ADDR_FORMATTED DY,                             29160018
MFA-TR*              CSS_NAME_ACCT_XREF HT                              29170018
MFA-TR*        WHERE PR.PREMISE_NO =:PR-PREMISE-NO                      29180018
MFA-TR*          AND DY.ADDRESS_ID = PR.ADDRESS_ID                      29190018
MFA-TR*          AND HT.ADDRESS_ID = PR.ADDRESS_ID                      29200018
MFA-TR*          AND HT.PREMISE_NO =:PR-PREMISE-NO                      29210018
MFA-TR*        FETCH FIRST ROW ONLY                                     29220018
MFA-TR*         WITH UR                                                 29230018
MFA-TR*     QUERYNO 7710                                                29240018
MFA-TR*    END-EXEC                                                     29250018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29260018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 29290018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7710'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 29430018
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29460018
      ******************************************************************29470018
      * 7740-GET-ACT-BBP-AMT                                           *29480018
      ******************************************************************29490018
      *                                                                 29500018
       7740-GET-ACT-BBP-AMT.                                            
      *                                                                 29520018
           EXEC SQL                                                     
              SELECT TOP(1) AU.AMT_POSTED,
              AR.DATE_TRANS                                      
                INTO :AU-AMT-POSTED                                     
                    ,:AR-DATE-TRANS                                     
                FROM CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED),               
                     CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED),               
                     CSS_BUDGET_PLAN    BU WITH(READUNCOMMITTED)                
               WHERE AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        
                 AND AR.ACCOUNT_NO        = :AR-ACCOUNT-NO              
                 AND AU.ACCOUNT_NO        = :AU-ACCOUNT-NO              
                 AND BU.ACCOUNT_NO        = :BU-ACCOUNT-NO              
                 AND AR.DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )              
                 AND AR.CODE_TRAN_TYPE    = 'B'                         
                 AND AU.GL_ACCT_CREDIT    = 142.0400                    
                 AND AU.GL_ACCT_DEBIT     = 142.0400                    
               ORDER BY AR.TRANS_HIST_SEQ_NO DESC                       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     29530018
MFA-TR*       SELECT AU.AMT_POSTED                                      29540018
MFA-TR*             ,AR.DATE_TRANS                                      29550018
MFA-TR*         INTO :AU-AMT-POSTED                                     29560018
MFA-TR*             ,:AR-DATE-TRANS                                     29570018
MFA-TR*         FROM CSS_AR_TRANS_HIST  AR,                             29580018
MFA-TR*              CSS_AR_TRN_HST_DET AU,                             29590018
MFA-TR*              CSS_BUDGET_PLAN    BU                              29600018
MFA-TR*        WHERE AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        29610018
MFA-TR*          AND AR.ACCOUNT_NO        = :AR-ACCOUNT-NO              29620018
MFA-TR*          AND AU.ACCOUNT_NO        = :AU-ACCOUNT-NO              29630018
MFA-TR*          AND BU.ACCOUNT_NO        = :BU-ACCOUNT-NO              29640018
MFA-TR*          AND AR.DATE_TRANS        = :AR-DATE-TRANS              29650018
MFA-TR*          AND AR.CODE_TRAN_TYPE    = 'B'                         29660018
MFA-TR*          AND AU.GL_ACCT_CREDIT    = 142.0400                    29670018
MFA-TR*          AND AU.GL_ACCT_DEBIT     = 142.0400                    29680018
MFA-TR*        ORDER BY AR.TRANS_HIST_SEQ_NO DESC                       29690018
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             29700018
MFA-TR*      QUERYNO 7740                                               29710018
MFA-TR*    END-EXEC.                                                    29720018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29730018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 29760018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7740'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1               
                    MOVE 'CSS_AR_TRN_HST_DET'  TO TABLE-2               
                    MOVE 'CSS_BUDGET_PLAN'     TO TABLE-3               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'DATE_TRANS'          TO TABLE-ELEMENT-2       
                    MOVE AR-DATE-TRANS         TO HOSTVAR-ELEMENT-2     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 29970018
       7740-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************30000018
      * 7800-GET-BBP-AMT.                                              *30010018
      ******************************************************************30020018
      *                                                                 30030018
       7800-GET-BBP-AMT.                                                
      *                                                                 30050018
           EXEC SQL                                                     
              SELECT TOP(1) BH.AMT_MO_PYMT,
              BH.EPP_ESTIMATE,
              BH.BUDG_BILL_PREV_AMT                              
                INTO :BH-AMT-MO-PYMT                                    
                    ,:BH-EPP-ESTIMATE                                   
                    ,:BH-BUDG-BILL-PREV-AMT                             
                FROM CSS_BUDGET_HIST    BH WITH(READUNCOMMITTED)                
               WHERE BH.ACCOUNT_NO         = :BH-ACCOUNT-NO             
                 AND BH.PYMT_PRIORITY_LVL  = 50                         
                 AND BH.ITEM_ID            = 1                          
                 AND BH.DATE_PYMT_STRT     = IIF(TRY_CONVERT(DATE, 
                                                     :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )         
                 AND BH.CHANGE_REASON      = :BH-CHANGE-REASON          
               ORDER BY BH.BUD_HIST_SEQ_NO DESC                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     30060018
MFA-TR*       SELECT BH.AMT_MO_PYMT                                     30070018
MFA-TR*             ,BH.EPP_ESTIMATE                                    30080018
MFA-TR*             ,BH.BUDG_BILL_PREV_AMT                              30090018
MFA-TR*         INTO :BH-AMT-MO-PYMT                                    30100018
MFA-TR*             ,:BH-EPP-ESTIMATE                                   30110018
MFA-TR*             ,:BH-BUDG-BILL-PREV-AMT                             30120018
MFA-TR*         FROM CSS_BUDGET_HIST    BH                              30130018
MFA-TR*        WHERE BH.ACCOUNT_NO         = :BH-ACCOUNT-NO             30140018
MFA-TR*          AND BH.PYMT_PRIORITY_LVL  = 50                         30150018
MFA-TR*          AND BH.ITEM_ID            = 1                          30160018
MFA-TR*          AND BH.DATE_PYMT_STRT     = :BH-DATE-PYMT-STRT         30170018
MFA-TR*          AND BH.CHANGE_REASON      = :BH-CHANGE-REASON          30180018
MFA-TR*        ORDER BY BH.BUD_HIST_SEQ_NO DESC                         30190018
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             30200018
MFA-TR*      QUERYNO 7800                                               30210018
MFA-TR*    END-EXEC.                                                    30220018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30230018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 30260018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                     TO BH-AMT-MO-PYMT        
                                                  BH-EPP-ESTIMATE       
                                                  BH-BUDG-BILL-PREV-AMT 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7800'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_BUDGET_HIST'     TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'DATE_PYMT_STRT'      TO TABLE-ELEMENT-3       
                    MOVE BH-DATE-PYMT-STRT     TO HOSTVAR-ELEMENT-2     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 30470018
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30500018
      ***************************************************************** 30510018
      * 7840-CHECK-SR-CITIZEN.                                        * 30520018
      ***************************************************************** 30530018
      *                                                                 30540018
       7840-CHECK-SR-CITIZEN.                                           
      *                                                                 30560018
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SENIOR-FLAG                                    
                FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
               WHERE YP.ACCOUNT_NO         = :UT-ACCOUNT-NO             
                 AND YP.ATTRIBUTE_DESC     = 'AGL LOW INCOME SR'        
                 AND YP.ATTRIBUTE_VALUE_CD = 'Y'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30570018
MFA-TR*       SELECT 'Y'                                                30580018
MFA-TR*         INTO :WS-SENIOR-FLAG                                    30590018
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                              30600018
MFA-TR*        WHERE YP.ACCOUNT_NO         = :UT-ACCOUNT-NO             30610018
MFA-TR*          AND YP.ATTRIBUTE_DESC     = 'AGL LOW INCOME SR'        30620018
MFA-TR*          AND YP.ATTRIBUTE_VALUE_CD = 'Y'                        30630018
MFA-TR*         WITH UR                                                 30640018
MFA-TR*      QUERYNO 7840                                               30650018
MFA-TR*    END-EXEC.                                                    30660018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30670018
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE-3.              
      *                                                                 30700018
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7840'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_ACCT_ATTRIBUTE'        TO TABLE-1               
              MOVE 'UT-ACCOUNT-NO'             TO TABLE-ELEMENT-1       
              MOVE UT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 30840018
       7840-EXIT.                                                       
           EXIT.                                                        
      *                                                                 30870018
      ***************************************************************** 30880018
      * 7850-CHECK-EXEMPT-REVIEW.                                     * 30890018
      ***************************************************************** 30900018
      *                                                                 30910018
P00694 7850-CHECK-EXEMPT-REVIEW.                                        
P00694*                                                                 30930018
P00694     EXEC SQL                                                     
P00694        SELECT 'Y'                                                
P00694          INTO :WS-EXEMPT-REVIEW                                  
P00694          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P00694         WHERE YP.ACCOUNT_NO         = :YP-ACCOUNT-NO             
P00694           AND YP.ATTRIBUTE_DESC     = 'BBP_REVIEW_EXEMPT'        
P00694           AND YP.ATTRIBUTE_VALUE_CD = 'Y'                        
P00694                                                           
P00694                                                      
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30940018
MFA-TR*       SELECT 'Y'                                                30950018
MFA-TR*         INTO :WS-EXEMPT-REVIEW                                  30960018
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                              30970018
MFA-TR*        WHERE YP.ACCOUNT_NO         = :YP-ACCOUNT-NO             30980018
MFA-TR*          AND YP.ATTRIBUTE_DESC     = 'BBP_REVIEW_EXEMPT'        30990018
MFA-TR*          AND YP.ATTRIBUTE_VALUE_CD = 'Y'                        31000018
MFA-TR*         WITH UR                                                 31010018
MFA-TR*      QUERYNO 7850                                               31020018
MFA-TR*    END-EXEC.                                                    31030018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 31040018
P00694     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
P00694                                    S-RETURN-CODE-1.              
P00694*                                                                 31070018
P00694     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
P00694        MOVE '7850'                      TO ACTIVE-PARAGRAPH      
P00694        MOVE 'SELECT'                    TO ABEND-FUNCTION        
P00694        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
P00694                                            ABEND-TABLES          
P00694        MOVE 'CSS_ACCT_ATTRIBUTE'        TO TABLE-1               
P00694        MOVE 'YP-ACCOUNT-NO'             TO TABLE-ELEMENT-1       
P00694        MOVE YP-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
P00694        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00694     END-IF.                                                      
P00694*                                                                 31210018
P00694 7850-EXIT.                                                       
P00694     EXIT.                                                        
      *                                                                 31240018
      ******************************************************************31250018
      * 8000A-DEL-GTT-ROWS.                                            *31260018
      ******************************************************************31270018
      *                                                                 31280018
       8000A-DEL-GTT-ROWS.                                              
      *                                                                 31300018
           EXEC SQL                                                     
               DELETE FROM #CSR04402_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     31310018
MFA-TR*        DELETE FROM SESSION.CSR04402_R1                          31320018
MFA-TR*    END-EXEC.                                                    31330018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31340018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 31370018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04402_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 31570018
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 31600018
      ******************************************************************31610018
      * 8000B-DEL-GTT-ROWS.                                            *31620018
      ******************************************************************31630018
      *                                                                 31640018
       8000B-DEL-GTT-ROWS.                                              
      *                                                                 31660018
           EXEC SQL                                                     
               DELETE FROM #CSR04402_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     31670018
MFA-TR*        DELETE FROM SESSION.CSR04402_R2                          31680018
MFA-TR*    END-EXEC.                                                    31690018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31700018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 31730018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04402_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 31930018
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 31960018
      ******************************************************************31970018
      * 8000C-DEL-GTT-ROWS.                                            *31980018
      ******************************************************************31990018
      *                                                                 32000018
       8000C-DEL-GTT-ROWS.                                              
      *                                                                 32020018
           EXEC SQL                                                     
               DELETE FROM #CSR04402_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     32030018
MFA-TR*        DELETE FROM SESSION.CSR04402_R3                          32040018
MFA-TR*    END-EXEC.                                                    32050018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32060018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 32090018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04402_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 32290018
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 32320018
      ******************************************************************32330018
      * 8000D-DEL-GTT-ROWS.                                            *32340018
      ******************************************************************32350018
      *                                                                 32360018
       8000D-DEL-GTT-ROWS.                                              
      *                                                                 32380018
           EXEC SQL                                                     
               DELETE FROM #CSR04402_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     32390018
MFA-TR*        DELETE FROM SESSION.CSR04402_R4                          32400018
MFA-TR*    END-EXEC.                                                    32410018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32420018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 32450018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04402_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 32650018
       8000D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 32680018
      ******************************************************************32690018
      * 8000E-DEL-GTT-ROWS.                                            *32700018
      ******************************************************************32710018
      *                                                                 32720018
       8000E-DEL-GTT-ROWS.                                              
      *                                                                 32740018
           EXEC SQL                                                     
               DELETE FROM #CSR04402_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     32750018
MFA-TR*        DELETE FROM SESSION.CSR04402_R5                          32760018
MFA-TR*    END-EXEC.                                                    32770018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32780018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 32810018
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000E'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04402_R5'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 33010018
       8000E-EXIT.                                                      
            EXIT.                                                       
      *                                                                 33040018
P00694******************************************************************33050018
P00694* 8000F-DEL-GTT-ROWS.                                            *33060018
P00694******************************************************************33070018
P00694*                                                                 33080018
P00694 8000F-DEL-GTT-ROWS.                                              
P00694*                                                                 33100018
P00694     EXEC SQL                                                     
P00694         DELETE FROM #CSR04402_R6                          
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     33110018
MFA-TR*        DELETE FROM SESSION.CSR04402_R6                          33120018
MFA-TR*    END-EXEC.                                                    33130018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 33140018
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 33170018
P00694     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00694         WHEN SUCCESSFUL-CALL                                     
P00694              CONTINUE                                            
P00694         WHEN NOT-FOUND                                           
P00694              MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6             
P00694         WHEN OTHER                                               
P00694              MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
P00694              MOVE SQLCODE         TO ABEND-SQLCODE               
P00694              MOVE SQLSTATE        TO ABEND-SQLSTATE              
P00694              MOVE '8000F'         TO ACTIVE-PARAGRAPH            
P00694              MOVE 'DELETE'        TO ABEND-FUNCTION              
P00694              MOVE SPACES          TO ABEND-SQL-PREDICATES        
P00694                                      ABEND-TABLES                
P00694              MOVE 'CSR04402_R6'   TO TABLE-1                     
P00694              MOVE SPACES          TO TABLE-ELEMENT-1             
P00694              MOVE SPACES          TO HOSTVAR-ELEMENT-1           
P00694              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P00694     END-EVALUATE.                                                
P00694*                                                                 33370018
P00694 8000F-EXIT.                                                      
P00694      EXIT.                                                       
P00694*                                                                 33400018
      ******************************************************************33410018
      * 8010-INSERT-GTT-R1.                                            *33420018
      ******************************************************************33430018
      *                                                                 33440018
       8010-INSERT-GTT-R1.                                              
      *                                                                 33460018
           IF WS-GTT-IND-R1 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100A-DECLARE-GTT-R1    THRU 0100A-EXIT           
              MOVE 'Y'                        TO WS-GTT-IND-R1          
           END-IF                                                       
           MOVE WS-RETURN-CODE-1              TO S-RETURN-CODE-1.       
      *                                                                 33540018
           EXEC SQL                                                     
              INSERT INTO #CSR04402_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ANNIVERSARY_DATE                                     
                  ,START_DATE                                           
                  ,MTHLY_CNT_TOT_AMT                                    
                  ,BBP_NO_MNTHS_LEFT                                    
                  ,BBP_NEW_SUG_AMT                                      
                  ,BAL_AT_ANNIV                                         
                  ,BAL_REMARKS                                          
                  ,CNSMPTN_USED                                         
P00694            ,EXEMPT_REVIEW                                        
P0694A            ,BBP_CUR_BAL_AMT                                      
P00836            ,BBP_TOTAL_CHRGS                                      
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-ANIVERSARY-DATE                                   
                  ,:S-START-DATE                                        
                  ,:S-MTHLY-CNT-TOT-AMT                                 
                  ,:S-BBP-MNTHS-REMAIN                                  
                  ,:S-BBP-NEW-SUGG-AMT                                  
                  ,:S-BAL-AT-ANNIV                                      
                  ,:S-BAL-REMARKS                                       
                  ,:S-CNSMPTN-USED                                      
P00694            ,:S-EXEMPT-REVIEW                                     
P0694A            ,:S-BBP-CUR-BAL-AMT                                   
P00836            ,:S-BBP-TOTAL-CHRGS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     33550018
MFA-TR*       INSERT INTO SESSION.CSR04402_R1                           33560018
MFA-TR*          (                                                      33570018
MFA-TR*            RETURN_CODE                                          33580018
MFA-TR*           ,APPL_RETURN_CODE                                     33590018
MFA-TR*           ,ANNIVERSARY_DATE                                     33600018
MFA-TR*           ,START_DATE                                           33610018
MFA-TR*           ,MTHLY_CNT_TOT_AMT                                    33620018
MFA-TR*           ,BBP_NO_MNTHS_LEFT                                    33630018
MFA-TR*           ,BBP_NEW_SUG_AMT                                      33640018
MFA-TR*           ,BAL_AT_ANNIV                                         33650018
MFA-TR*           ,BAL_REMARKS                                          33660018
MFA-TR*           ,CNSMPTN_USED                                         33670018
MFA-TR*           ,EXEMPT_REVIEW                                        33680018
MFA-TR*           ,BBP_CUR_BAL_AMT                                      33690018
MFA-TR*           ,BBP_TOTAL_CHRGS                                      33700018
MFA-TR*          )                                                      33710018
MFA-TR*       VALUES                                                    33720018
MFA-TR*          (                                                      33730018
MFA-TR*            :S-RETURN-CODE-1                                     33740018
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                33750018
MFA-TR*           ,:S-ANIVERSARY-DATE                                   33760018
MFA-TR*           ,:S-START-DATE                                        33770018
MFA-TR*           ,:S-MTHLY-CNT-TOT-AMT                                 33780018
MFA-TR*           ,:S-BBP-MNTHS-REMAIN                                  33790018
MFA-TR*           ,:S-BBP-NEW-SUGG-AMT                                  33800018
MFA-TR*           ,:S-BAL-AT-ANNIV                                      33810018
MFA-TR*           ,:S-BAL-REMARKS                                       33820018
MFA-TR*           ,:S-CNSMPTN-USED                                      33830018
MFA-TR*           ,:S-EXEMPT-REVIEW                                     33840018
MFA-TR*           ,:S-BBP-CUR-BAL-AMT                                   33850018
MFA-TR*           ,:S-BBP-TOTAL-CHRGS                                   33860018
MFA-TR*          )                                                      33870018
MFA-TR*    END-EXEC.                                                    33880018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33890018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 33920018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INST-R1  = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-DET                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INST-R1             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04402_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34100018
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                 34130018
      ******************************************************************34140018
      * 8020-INSERT-GTT-R2.                                            *34150018
      ******************************************************************34160018
      *                                                                 34170018
       8020-INSERT-GTT-R2.                                              
      *                                                                 34190018
           IF WS-GTT-IND-R2 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100B-DECLARE-GTT-R2    THRU 0100B-EXIT           
              MOVE 'Y'                        TO WS-GTT-IND-R2          
           END-IF                                                       
           MOVE WS-RETURN-CODE-2              TO S-RETURN-CODE-2.       
      *                                                                 34270018
           EXEC SQL                                                     
              INSERT INTO #CSR04402_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,CNT_NAME_DESC                                        
                  ,CNT_AMT_MO_PYMT                                      
                  ,CNT_PYMTS_REMAIN                                     
                  ,CNT_EXPIRY_DT                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-CNT-NAME-DESC                                     
                  ,:S-CNT-AMT-MO-PYMT                                   
                  ,:S-CNT-PYMTS-REMAIN                                  
                  ,:S-CNT-EXPIRY-DT                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     34280018
MFA-TR*       INSERT INTO SESSION.CSR04402_R2                           34290018
MFA-TR*          (                                                      34300018
MFA-TR*            RETURN_CODE                                          34310018
MFA-TR*           ,CNT_NAME_DESC                                        34320018
MFA-TR*           ,CNT_AMT_MO_PYMT                                      34330018
MFA-TR*           ,CNT_PYMTS_REMAIN                                     34340018
MFA-TR*           ,CNT_EXPIRY_DT                                        34350018
MFA-TR*          )                                                      34360018
MFA-TR*       VALUES                                                    34370018
MFA-TR*          (                                                      34380018
MFA-TR*            :S-RETURN-CODE-2                                     34390018
MFA-TR*           ,:S-CNT-NAME-DESC                                     34400018
MFA-TR*           ,:S-CNT-AMT-MO-PYMT                                   34410018
MFA-TR*           ,:S-CNT-PYMTS-REMAIN                                  34420018
MFA-TR*           ,:S-CNT-EXPIRY-DT                                     34430018
MFA-TR*          )                                                      34440018
MFA-TR*    END-EXEC.                                                    34450018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34460018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 34490018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INST-R2  = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-CHGS                
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INST-R2             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04402_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34670018
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                 34700018
      ******************************************************************34710018
      * 8030-INSERT-GTT-R3.                                            *34720018
      ******************************************************************34730018
      *                                                                 34740018
       8030-INSERT-GTT-R3.                                              
      *                                                                 34760018
           IF WS-GTT-IND-R3 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100C-DECLARE-GTT-R3    THRU 0100C-EXIT           
              MOVE 'Y'                        TO WS-GTT-IND-R3          
           END-IF                                                       
           MOVE WS-RETURN-CODE-3              TO S-RETURN-CODE-3.       
      *                                                                 34840018
           EXEC SQL                                                     
              INSERT INTO #CSR04402_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,REV_MONTH                                            
A03925            ,NO_OF_DAYS                                           
                  ,UTIL_CHRG_AMT                                        
                  ,BBP_AMT                                              
                  ,USAGE_TYPE                                           
TASK02            ,DATE_BILLED                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-REV-MONTH                                         
A03925            ,:S-NO-OF-DAYS                                        
                  ,:S-UTIL-CHRG-AMT                                     
                  ,:S-BBP-AMT                                           
                  ,:S-USAGE-TYPE                                        
TASK02            ,:S-DATE-BILLED                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     34850018
MFA-TR*       INSERT INTO SESSION.CSR04402_R3                           34860018
MFA-TR*          (                                                      34870018
MFA-TR*            RETURN_CODE                                          34880018
MFA-TR*           ,REV_MONTH                                            34890018
MFA-TR*           ,NO_OF_DAYS                                           34900018
MFA-TR*           ,UTIL_CHRG_AMT                                        34910018
MFA-TR*           ,BBP_AMT                                              34920018
MFA-TR*           ,USAGE_TYPE                                           34930018
MFA-TR*           ,DATE_BILLED                                          34940018
MFA-TR*          )                                                      34950018
MFA-TR*       VALUES                                                    34960018
MFA-TR*          (                                                      34970018
MFA-TR*            :S-RETURN-CODE-3                                     34980018
MFA-TR*           ,:S-REV-MONTH                                         34990018
MFA-TR*           ,:S-NO-OF-DAYS                                        35000018
MFA-TR*           ,:S-UTIL-CHRG-AMT                                     35010018
MFA-TR*           ,:S-BBP-AMT                                           35020018
MFA-TR*           ,:S-USAGE-TYPE                                        35030018
MFA-TR*           ,:S-DATE-BILLED                                       35040018
MFA-TR*          )                                                      35050018
MFA-TR*    END-EXEC.                                                    35060018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 35070018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 35100018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INST-R3  = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-UTIL-CHGS               
                                             WS-ACT-COUNT               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INST-R3             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04402_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 35290018
        8030-EXIT.                                                      
            EXIT.                                                       
      *                                                                 35320018
      ******************************************************************35330018
      * 8040-INSERT-GTT-R4.                                            *35340018
      ******************************************************************35350018
      *                                                                 35360018
       8040-INSERT-GTT-R4.                                              
      *                                                                 35380018
           IF WS-GTT-IND-R4 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100D-DECLARE-GTT-R4    THRU 0100D-EXIT           
              MOVE 'Y'                        TO WS-GTT-IND-R4          
           END-IF                                                       
           MOVE WS-RETURN-CODE-4              TO S-RETURN-CODE-4.       
     *                                                                  
           EXEC SQL                                                     
              INSERT INTO #CSR04402_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,REV_MNTH                                             
                  ,ADJUSTMENT_DATE                                      
                  ,ADJUSTMENT_AMT                                       
                  ,REMARKS_TEXT                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-REV-MNTH                                          
                  ,:S-ADJUSTMENT-DATE                                   
                  ,:S-ADJUSTMENT-AMT                                    
                  ,:S-REMARKS-TEXT                                      
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     35470018
MFA-TR*       INSERT INTO SESSION.CSR04402_R4                           35480018
MFA-TR*          (                                                      35490018
MFA-TR*            RETURN_CODE                                          35500018
MFA-TR*           ,REV_MNTH                                             35510018
MFA-TR*           ,ADJUSTMENT_DATE                                      35520018
MFA-TR*           ,ADJUSTMENT_AMT                                       35530018
MFA-TR*           ,REMARKS_TEXT                                         35540018
MFA-TR*          )                                                      35550018
MFA-TR*       VALUES                                                    35560018
MFA-TR*          (                                                      35570018
MFA-TR*            :S-RETURN-CODE-4                                     35580018
MFA-TR*           ,:S-REV-MNTH                                          35590018
MFA-TR*           ,:S-ADJUSTMENT-DATE                                   35600018
MFA-TR*           ,:S-ADJUSTMENT-AMT                                    35610018
MFA-TR*           ,:S-REMARKS-TEXT                                      35620018
MFA-TR*          )                                                      35630018
MFA-TR*    END-EXEC.                                                    35640018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 35650018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 35680018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INST-R4  = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-HIST                
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INST-R4             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04402_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 35860018
        8040-EXIT.                                                      
            EXIT.                                                       
      *                                                                 35890018
      ******************************************************************35900018
      * 8050-INSERT-GTT-R5.                                            *35910018
      ******************************************************************35920018
      *                                                                 35930018
       8050-INSERT-GTT-R5.                                              
      *                                                                 35950018
           IF WS-GTT-IND-R5 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100E-DECLARE-GTT-R5    THRU 0100E-EXIT           
              MOVE 'Y'                        TO WS-GTT-IND-R5          
           END-IF                                                       
           MOVE WS-RETURN-CODE-5              TO S-RETURN-CODE-5.       
      *                                                                 36030018
           EXEC SQL                                                     
              INSERT INTO #CSR04402_R5                           
                 (                                                      
                   RETURN_CODE                                          
                  ,OPTION_SEQ_NO                                        
                  ,OPTION_DESC                                          
                  ,AMT_BALANCE_DUE_TX                                   
                  ,AMT_BALANCE_DUE                                      
                  ,EST_BBP_AMT_TX                                       
                  ,EST_BBP_AMT                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-5                                     
                  ,:S-OPTION-SEQ-NO                                     
                  ,:S-OPTION-DESC                                       
                  ,:S-AMT-BALANCE-DUE-TX                                
                  ,:S-AMT-BALANCE-DUE                                   
                  ,:S-EST-BBP-AMT-TX                                    
                  ,:S-EST-BBP-AMT                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     36040018
MFA-TR*       INSERT INTO SESSION.CSR04402_R5                           36050018
MFA-TR*          (                                                      36060018
MFA-TR*            RETURN_CODE                                          36070018
MFA-TR*           ,OPTION_SEQ_NO                                        36080018
MFA-TR*           ,OPTION_DESC                                          36090018
MFA-TR*           ,AMT_BALANCE_DUE_TX                                   36100018
MFA-TR*           ,AMT_BALANCE_DUE                                      36110018
MFA-TR*           ,EST_BBP_AMT_TX                                       36120018
MFA-TR*           ,EST_BBP_AMT                                          36130018
MFA-TR*          )                                                      36140018
MFA-TR*       VALUES                                                    36150018
MFA-TR*          (                                                      36160018
MFA-TR*            :S-RETURN-CODE-5                                     36170018
MFA-TR*           ,:S-OPTION-SEQ-NO                                     36180018
MFA-TR*           ,:S-OPTION-DESC                                       36190018
MFA-TR*           ,:S-AMT-BALANCE-DUE-TX                                36200018
MFA-TR*           ,:S-AMT-BALANCE-DUE                                   36210018
MFA-TR*           ,:S-EST-BBP-AMT-TX                                    36220018
MFA-TR*           ,:S-EST-BBP-AMT                                       36230018
MFA-TR*          )                                                      36240018
MFA-TR*    END-EXEC.                                                    36250018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36260018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 36290018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INST-R5  = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-ANNIV               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INST-R4             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04402_R5'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 36470018
        8050-EXIT.                                                      
            EXIT.                                                       
      *                                                                 36500018
      ******************************************************************36510018
      * 8060-INSERT-GTT-R6.                                            *36520018
      ******************************************************************36530018
P00694*                                                                 36540018
P00694 8060-INSERT-GTT-R6.                                              
P00694*                                                                 36560018
P00694     IF WS-GTT-IND-R6 = 'Y'                                       
P00694        CONTINUE                                                  
P00694     ELSE                                                         
P00694        PERFORM 0100F-DECLARE-GTT-R6    THRU 0100F-EXIT           
P00694        MOVE 'Y'                        TO WS-GTT-IND-R6          
P00694     END-IF                                                       
P00694     MOVE WS-RETURN-CODE-6              TO S-RETURN-CODE-6.       
P00694*                                                                 36640018
P00694     EXEC SQL                                                     
P00694        INSERT INTO #CSR04402_R6                           
P00694           (                                                      
P00694              RETURN_CODE                                         
P00694             ,REVENUE_MONTH                                       
P00694             ,DAYS                                                
P00694             ,UNITS                                               
P00694             ,CODE_UTIL_TYPE                                      
P00694             ,CUSTOMER_NO                                         
P00694             ,NEW_CHARGE                                          
P00694             ,RATE_PLAN_NO                                        
P00694             ,CALC_ERROR                                          
P00694             ,HTG_CLG_SW                                          
P00694             ,EPP_CATEGORY                                        
P00694             ,ELEC_BUFFER                                         
P00694             ,GAS_BUFFER                                          
P00694            )                                                     
P00694         VALUES                                                   
P00694            (                                                     
P00694              :S-RETURN-CODE-6                                    
P00694             ,:S-REVENUE-MONTH                                    
P00694             ,:S-DAYS                                             
P00694             ,:S-UNITS                                            
P00694             ,:S-CODE-UTIL-TYPE                                   
P00694             ,:S-CUSTOMER-NO                                      
P00694             ,:S-NEW-CHARGE                                       
P00694             ,:S-RATE-PLAN-NO                                     
P00694             ,:S-CALC-ERROR                                       
P00694             ,:S-HTG-CLG-SW                                       
P00694             ,:S-BPP-CATEGORY                                     
P00694             ,:S-ELEC-BUFFER                                      
P00694             ,:S-GAS-BUFFER                                       
P00694           )                                                      
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     36650018
MFA-TR*       INSERT INTO SESSION.CSR04402_R6                           36660018
MFA-TR*          (                                                      36670018
MFA-TR*             RETURN_CODE                                         36680018
MFA-TR*            ,REVENUE_MONTH                                       36690018
MFA-TR*            ,DAYS                                                36700018
MFA-TR*            ,UNITS                                               36710018
MFA-TR*            ,CODE_UTIL_TYPE                                      36720018
MFA-TR*            ,CUSTOMER_NO                                         36730018
MFA-TR*            ,NEW_CHARGE                                          36740018
MFA-TR*            ,RATE_PLAN_NO                                        36750018
MFA-TR*            ,CALC_ERROR                                          36760018
MFA-TR*            ,HTG_CLG_SW                                          36770018
MFA-TR*            ,EPP_CATEGORY                                        36780018
MFA-TR*            ,ELEC_BUFFER                                         36790018
MFA-TR*            ,GAS_BUFFER                                          36800018
MFA-TR*           )                                                     36810018
MFA-TR*        VALUES                                                   36820018
MFA-TR*           (                                                     36830018
MFA-TR*             :S-RETURN-CODE-6                                    36840018
MFA-TR*            ,:S-REVENUE-MONTH                                    36850018
MFA-TR*            ,:S-DAYS                                             36860018
MFA-TR*            ,:S-UNITS                                            36870018
MFA-TR*            ,:S-CODE-UTIL-TYPE                                   36880018
MFA-TR*            ,:S-CUSTOMER-NO                                      36890018
MFA-TR*            ,:S-NEW-CHARGE                                       36900018
MFA-TR*            ,:S-RATE-PLAN-NO                                     36910018
MFA-TR*            ,:S-CALC-ERROR                                       36920018
MFA-TR*            ,:S-HTG-CLG-SW                                       36930018
MFA-TR*            ,:S-BPP-CATEGORY                                     36940018
MFA-TR*            ,:S-ELEC-BUFFER                                      36950018
MFA-TR*            ,:S-GAS-BUFFER                                       36960018
MFA-TR*          )                                                      36970018
MFA-TR*    END-EXEC.                                                    36980018

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 36990018
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 37020018
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
P00694                                WS-ERR-INST-R6 = 'Y'              
P00694        ADD +1                     TO  CTR-ROWS                   
P00694                                       WS-BBP-CNSMPT              
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
P00694        MOVE '8060'                TO  ACTIVE-PARAGRAPH           
P00694        MOVE SQLCODE               TO  ABEND-SQLCODE              
P00694        MOVE 'INSERT'              TO  ABEND-FUNCTION             
P00694        MOVE 'Y'                   TO  WS-ERR-INST-R6             
P00694        MOVE SPACES                TO  ABEND-SQL-PREDICATES       
P00694                                       ABEND-TABLES               
P00694        MOVE 'CSR04402_R6'         TO  TABLE-1                    
P00694        MOVE SPACES                TO  TABLE-ELEMENT-1            
P00694        MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 37200018
P00694  8060-EXIT.                                                      
P00694      EXIT.                                                       
      ******************************************************************37230018
      * 8800-CHECK-RESULTS.                                            *37240018
      ******************************************************************37250018
      *                                                                 37260018
       8800-CHECK-RESULTS.                                              
      *                                                                 37280018
           IF WS-BBP-DET   = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO WS-RETURN-CODE-1        
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                 37340018
           IF WS-BBP-CHGS  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO WS-RETURN-CODE-2        
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                 37400018
           IF WS-UTIL-CHGS = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO WS-RETURN-CODE-3        
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                 37460018
           IF WS-BBP-HIST  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                       TO WS-RETURN-CODE-4        
              PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT             
           END-IF.                                                      
      *                                                                 37520018
           IF WS-BBP-ANNIV = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 100                       TO WS-RETURN-CODE-5        
              PERFORM 8050-INSERT-GTT-R5     THRU 8050-EXIT             
           END-IF.                                                      
      *                                                                 37580018
P00694     IF WS-BBP-CNSMPT = 0                                         
P00694        INITIALIZE GTT-RETURN-FIELDS-6                            
P00694        MOVE 100                       TO WS-RETURN-CODE-6        
P00694        PERFORM 8060-INSERT-GTT-R6     THRU 8060-EXIT             
P00694     END-IF.                                                      
      *                                                                 37640018
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37670018
      ******************************************************************37680018
      * 8900-SEND-DONE.                                                *37690018
      ******************************************************************37700018
      *                                                                 37710018
       8900-SEND-DONE.                                                  
      *                                                                 37730018
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 37770018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 37800018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04402_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 37920018
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 37960018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 37990018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04402_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38110018
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 38150018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 38180018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04402_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38300018
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 38340018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 38370018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04402_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38490018
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 38530018
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 38560018
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04402_R5'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 38680018
P00694     EXEC SQL                                                     
P00694         OPEN C6                                                  
P00694     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00694*                                                                 38720018
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 38750018
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00694        CONTINUE                                                  
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE SQLCODE               TO ABEND-SQLCODE               
P00694        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P00694        MOVE '8900'                TO ACTIVE-PARAGRAPH            
P00694        MOVE 'OPEN'                TO ABEND-FUNCTION              
P00694        MOVE 'CSR04402_R6'         TO TABLE-1                     
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
      *                                                                 38870018
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 38900018
      ******************************************************************38910018
      * 9000-SEND-ERROR-RESULT                                         *38920018
      ******************************************************************38930018
      *                                                                 38940018
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 38960018
           EVALUATE TRUE                                                
               WHEN WS-PLAN-DET                                         
                    MOVE S-RETURN-CODE-1    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
P00694                                         WS-RETURN-CODE-6         
               WHEN WS-MTHLY-CHGS                                       
                    MOVE S-RETURN-CODE-2    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
P00694                                         WS-RETURN-CODE-6         
               WHEN WS-USAGE                                            
                    MOVE S-RETURN-CODE-3    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
P00694                                         WS-RETURN-CODE-6         
               WHEN WS-REMARKS                                          
                    MOVE S-RETURN-CODE-4    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
P00694                                         WS-RETURN-CODE-6         
               WHEN WS-ANNIV                                            
                    MOVE S-RETURN-CODE-5    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
                                               WS-RETURN-CODE-5         
P00694                                         WS-RETURN-CODE-6         
P00694         WHEN WS-CNSMPT                                           
P00694              MOVE S-RETURN-CODE-6    TO WS-RETURN-CODE-1         
P00694                                         WS-RETURN-CODE-2         
P00694                                         WS-RETURN-CODE-3         
P00694                                         WS-RETURN-CODE-4         
P00694                                         WS-RETURN-CODE-5         
P00694                                         WS-RETURN-CODE-6         
           END-EVALUATE.                                                
      *                                                                 39440018
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE ' '                         TO S-APPL-RETURN-CODE-1     
           MOVE 'N'                         TO SEND-DONE-SW.            
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE.           
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
      *                                                                 39500018
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 39540018
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
      *                                                                 39600018
           MOVE 'N'                         TO WS-GTT-IND-R1            
                                               WS-GTT-IND-R2            
                                               WS-GTT-IND-R3            
                                               WS-GTT-IND-R4            
                                               WS-GTT-IND-R5            
P00694                                         WS-GTT-IND-R6.           
      *                                                                 39670018
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
           PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT.             
           PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT.             
           PERFORM 8050-INSERT-GTT-R5       THRU 8050-EXIT.             
P00694     PERFORM 8060-INSERT-GTT-R6       THRU 8060-EXIT.             
      *                                                                 39740018
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39770018
      ******************************************************************39780018
      * 9700-ABEND-PROCESSING.                                         *39790018
      ******************************************************************39800018
      *                                                                 39810018
       9700-PROCESS-ABEND.                                              
      *                                                                 39830018
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                 39860018
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39890018
      ******************************************************************39900018
      * 9900-SQL-ERROR-ROUTINE.                                        *39910018
      ******************************************************************39920018
      *                                                                 39930018
           EXEC SQL                                                     39940018
              INCLUDE CPDSP300                                          39950018
           END-EXEC.                                                    39960018
      *                                                                 39970018
      ******************************************************************39980018
      * 9999-END-PROGRAM.                                      *        39990018
      ******************************************************************40000018
      *                                                                 40010018
       9999-END-PROGRAM.                                                
      *                                                                 40030018
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                 
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT                 
           END-IF.                                                      
      *                                                                 40160018
           
MSQ016        GOBACK.                                                    
      *                                                                 40180018
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *40210018
      **********************End Of Program *****************************40220018
      *                                                                *40230018
