       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04397.                                            
       DATE-WRITTEN. 11/08/10.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM CHECKS IF AN ACCOUNT MEETS ALL CRITERIA REQUIRED *        
      *  FOR REGISTERING/REPORTING OUTAGES VIA TEXTING.                *        
      *  THE PROGRAM CKECKS CODE_REVENUE_CLASS AND RATE_PLAN_NO TO     *        
      *  FILTER OUT THE LARGER COMMERCIAL ELECTRIC CUSTOMERS           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00455*  11/08/10    PK98692  PROCEDURE ORIGINALLY CODED.              *        
A05460*  09/30/16    MR7E794  REMOVED THE TABLE NAME ACCOUNT TYPE.     *        
      *              ACT282                                            *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04397'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      *    EXEC SQL                                                             
      *       INCLUDE TBADRFMT                                                  
      *    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04397_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                 PIC S9(9) COMP.                 
           05  MSG-SEVERITY             PIC S9(9) COMP VALUE 11.        
           05  MSG-NR                   PIC S9(9) COMP VALUE  2.        
           05  MSG-RPC                  PIC X(8)  VALUE 'CSR04397'.     
           05  MSG-RPC-L                PIC S9(9) COMP.                 
           05  MSG-TEXT                 PIC X(100).                     
           05  MSG-TEXT-L               PIC S9(9) COMP.                 
           05  MSG-SQL-ERROR.                                           
               10  FILLER               PIC X(10)                       
                                        VALUE 'SQLCODE = '.             
               10  MSG-SQL-ERROR-C      PIC -9(3) DISPLAY.              
               10  FILLER               PIC X(16)                       
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K      PIC X(70).                      
               10  MSG-SQL-ERROR-K-CHARS                                
                                        REDEFINES MSG-SQL-ERROR-K       
                                        OCCURS 70 TIMES PIC X.          
           05  MSG-SQL-ERROR-SS         PIC S9(4) COMP.                 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-ID1                     PIC S9(9) COMP VALUE 1.     
           05  PARM-SELECT-METHOD           PIC X(3).                   
               88  SEL-METH-ACC             VALUE 'ACC'.                
               88  SEL-METH-CUS             VALUE 'CUS'.                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-ACCOUNT-NO                PIC X(13).                  
           05  RS-CUSTOMER-NO               PIC X(10).                  
           05  RS-TEXT-REGISTER-CD          PIC X(01).                  
           05  RS-TEXT-REPORT-CD            PIC X(01).                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE               PIC S9(9) COMP.              
           05  S-ACCOUNT-NO                PIC X(13).                   
           05  S-CUSTOMER-NO               PIC X(10).                   
           05  S-TEXT-REGISTER-CD          PIC X(01).                   
           05  S-TEXT-REPORT-CD            PIC X(01).                   
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
       01  WS-PARM-CRITERIA.                                            
                                                                        
           05  WS-ACC-PARM-CRITERIA.                                    
               10  ACC-ACCT-NO              PIC X(13)                   
                                            JUSTIFIED RIGHT.            
               10  ACC-ACCT-NO-NUM          REDEFINES ACC-ACCT-NO       
                                            PIC 9(13).                  
                                                                        
           05  WS-CUS-PARM-CRITERIA.                                    
               10  CUS-CUST-NO              PIC X(10)                   
                                            JUSTIFIED RIGHT.            
               10  CUS-CUST-NO-NUM          REDEFINES CUS-CUST-NO       
                                            PIC 9(10).                  
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR04397'.  
           05  WS-ROW-FOUND                 PIC X(01) VALUE 'N'.        
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-ARCHIVE-FL                PIC X(01) VALUE SPACES.     
           05  WS-UTILITY-SOURCE-CD         PIC X(01) VALUE SPACES.     
           05  WS-UTIL-SRC-CD-NULL-IND      PIC S9(04) COMP VALUE 0.    
           05  WS-TEXT-REGISTER-CD          PIC X(01)  VALUE SPACES.    
           05  WS-TEXT-REPORT-CD            PIC X(01) VALUE SPACES.     
           05  WS-ELEC-SUPPLIED             PIC X(01) VALUE SPACES.     
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 20.    
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-SELECT-METHOD-TEMP PIC X(03).                           
       01  PARM-CRITERIA           PIC X(15).                           
                                                                        
      ******************************************************************        
      *    AT-CURSOR USED TO SEARCH FOR ACCOUNT NUMBER.                *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE AT-CURSOR CURSOR FOR                        
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.COMPANY_NO                                     
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.ACCOUNT_NO        = :HT-ACCOUNT-NO             
                  AND HT.NAME_ID           = DQ.NAME_ID                 
                  AND DQ.NAME_TYPE         = 'CN'                       
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE AT-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.ACCOUNT_NO        = :HT-ACCOUNT-NO                     
MFA-TR*           AND HT.NAME_ID           = DQ.NAME_ID                         
MFA-TR*           AND DQ.NAME_TYPE         = 'CN'                               
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CU-CURSOR USED TO SEARCH FOR CUSTOMER NUMBER.               *        
      ******************************************************************        
           EXEC SQL DECLARE CUS-CURSOR CURSOR FOR                       
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.COMPANY_NO                                     
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.CUSTOMER_NO       = :HT-CUSTOMER-NO            
                  AND HT.NAME_ID           = DQ.NAME_ID                 
                  AND DQ.NAME_TYPE         = 'CN'                       
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
             ORDER BY HT.CUSTOMER_NO                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CUS-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.COMPANY_NO                                             
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.CUSTOMER_NO       = :HT-CUSTOMER-NO                    
MFA-TR*           AND HT.NAME_ID           = DQ.NAME_ID                         
MFA-TR*           AND DQ.NAME_TYPE         = 'CN'                               
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      ORDER BY HT.CUSTOMER_NO                                            
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*     WITH UR                                                             
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING PARM-SELECT-METHOD-TEMP                 
                                PARM-CRITERIA.                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           MOVE PARM-SELECT-METHOD-TEMP TO PARM-SELECT-METHOD.          
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           IF  SEL-METH-ACC                                             
               
MSQ016        GOBACK                                                 
           ELSE                                                         
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           IF  PARM-SELECT-METHOD-TEMP   NOT = 'ACC'                    
                 PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT              
                 EXEC SQL DECLARE C1 CURSOR  FOR             
                     SELECT                                             
                        RETURN_CODE               AS RETURN_CODE        
                       ,LTRIM(RTRIM(ACCOUNT_NO))         AS 
           ACCOUNT_NUMBER     
                       ,LTRIM(RTRIM(CUSTOMER_NO))        AS 
           CUSTOMER_NUMBER    
                       ,LTRIM(RTRIM(TEXT_REGISTER_CD))   AS 
           TEXT_REGISTER_CD   
                       ,LTRIM(RTRIM(TEXT_REPORT_CD))     AS 
           TEXT_REPORT_CD     
                     FROM #CSR04397_R1                           
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*          EXEC SQL DECLARE C1 CURSOR WITH RETURN FOR                     
MFA-TR*              SELECT                                                     
MFA-TR*                 RETURN_CODE               AS RETURN_CODE                
MFA-TR*                ,STRIP(ACCOUNT_NO)         AS ACCOUNT_NUMBER             
MFA-TR*                ,STRIP(CUSTOMER_NO)        AS CUSTOMER_NUMBER            
MFA-TR*                ,STRIP(TEXT_REGISTER_CD)   AS TEXT_REGISTER_CD           
MFA-TR*                ,STRIP(TEXT_REPORT_CD)     AS TEXT_REPORT_CD             
MFA-TR*              FROM SESSION.CSR04397_R1                                   
MFA-TR*          END-EXEC                                                       
             ELSE                                                       
                 EXEC SQL DECLARE C2 CURSOR  FOR             
                     SELECT                                             
                        :S-RETURN-CODE              AS RETURN_CODE      
                        ,LTRIM(RTRIM(:S-ACCOUNT-NO))       AS 
           ACCOUNT_NUMBER   
                        ,LTRIM(RTRIM(:S-CUSTOMER-NO))      AS 
           CUSTOMER_NUMBER  
                        ,LTRIM(RTRIM(:S-TEXT-REGISTER-CD)) AS 
           TEXT_REGISTER_CD 
                        ,LTRIM(RTRIM(:S-TEXT-REPORT-CD))   AS 
           TEXT_REPORT_CD   
                     FROM CIS.SYSDUMMY1                              
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*          EXEC SQL DECLARE C2 CURSOR WITH RETURN FOR                     
MFA-TR*              SELECT                                                     
MFA-TR*                 :S-RETURN-CODE              AS RETURN_CODE              
MFA-TR*                 ,STRIP(:S-ACCOUNT-NO)       AS ACCOUNT_NUMBER           
MFA-TR*                 ,STRIP(:S-CUSTOMER-NO)      AS CUSTOMER_NUMBER          
MFA-TR*                 ,STRIP(:S-TEXT-REGISTER-CD) AS TEXT_REGISTER_CD         
MFA-TR*                 ,STRIP(:S-TEXT-REPORT-CD)   AS TEXT_REPORT_CD           
MFA-TR*              FROM SYSIBM.SYSDUMMY1                                      
MFA-TR*          END-EXEC                                                       
                 NEXT SENTENCE                                          
             END-IF.                                                    
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04397_R1' TO        
                 S-SQL-STATEMENT-V.                                     
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04397_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04397_R1
               (  RETURN_CODE              INT                     
                  ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,TEXT_REGISTER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,TEXT_REPORT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 0120-DELETE-GTT-ROWS THRU 0120-EXIT              
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '0100A'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DECLARE GTT'    TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSR04397_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
               END-IF
            END-IF.       
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0120-DELETE-GTT-ROWS.                                            
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04397_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04397_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '0120'                TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04397_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
            END-IF.           
                                                                        
       0120-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           EVALUATE TRUE                                                
               WHEN SEL-METH-ACC                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO ACC-ACCT-NO                                 
                   IF ACC-ACCT-NO NOT = SPACES                          
                      INSPECT ACC-ACCT-NO REPLACING ALL SPACES BY '0'   
                   END-IF                                               
                   MOVE ACC-ACCT-NO-NUM TO HT-ACCOUNT-NO                
               WHEN SEL-METH-CUS                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO CUS-CUST-NO                                 
                   IF CUS-CUST-NO NOT = SPACES                          
                       INSPECT CUS-CUST-NO REPLACING ALL SPACES BY '0'  
                   END-IF                                               
                   MOVE CUS-CUST-NO-NUM TO HT-CUSTOMER-NO               
           END-EVALUATE.                                                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
               WHEN SEL-METH-ACC                                        
                   PERFORM 2100-SEARCH-VIA-ACC-CURSOR THRU 2100-EXIT    
               WHEN SEL-METH-CUS                                        
                   PERFORM 2400-SEARCH-VIA-CUS-CURSOR THRU 2400-EXIT    
           END-EVALUATE.                                                
                                                                        
           IF SEL-METH-ACC                                              
               IF CTR-ROWS = ZERO                                       
                   MOVE NOT-FOUND TO RS-RETURN-CODE                     
                   PERFORM 2005-MOVE-RESULT THRU 2005-EXIT              
               END-IF                                                   
                  EXEC SQL                                              
                       OPEN C2                                          
                  END-EXEC                                              

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
               GO TO 2000-EXIT                                          
           END-IF.                                                      
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               PERFORM 2005-MOVE-RESULT THRU 2005-EXIT                  
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2005-MOVE-RESULT.                                                
                                                                        
           MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
           MOVE RS-ACCOUNT-NO         TO S-ACCOUNT-NO.                  
           MOVE RS-CUSTOMER-NO        TO S-CUSTOMER-NO.                 
           MOVE RS-TEXT-REGISTER-CD   TO S-TEXT-REGISTER-CD.            
           MOVE RS-TEXT-REPORT-CD     TO S-TEXT-REPORT-CD.              
                                                                        
       2005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-SEARCH-VIA-ACC-CURSOR.                                      
                                                                        
           PERFORM 7000-OPEN-AT-CURSOR  THRU 7000-EXIT.                 
           PERFORM 7010-FETCH-AT-CURSOR THRU 7010-EXIT.                 
                                                                        
           PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND)            
               PERFORM 2500-PROCESS-ROW     THRU 2500-EXIT              
               PERFORM 7010-FETCH-AT-CURSOR THRU 7010-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7020-CLOSE-AT-CURSOR THRU 7020-EXIT.                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-SEARCH-VIA-CUS-CURSOR.                                      
                                                                        
           PERFORM 7100-OPEN-CUS-CURSOR  THRU 7100-EXIT.                
           PERFORM 7110-FETCH-CUS-CURSOR THRU 7110-EXIT.                
                                                                        
           PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND)            
               PERFORM 2500-PROCESS-ROW      THRU 2500-EXIT             
               PERFORM 7110-FETCH-CUS-CURSOR THRU 7110-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7120-CLOSE-CUS-CURSOR THRU 7120-EXIT.                
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE 'N' TO WS-ARCHIVE-FL.                                   
           MOVE SPACES TO WS-TEXT-REGISTER-CD WS-TEXT-REPORT-CD.        
                                                                        
           IF HT-COMPANY-NO NOT = '01'                                  
              MOVE 'C' TO WS-TEXT-REGISTER-CD WS-TEXT-REPORT-CD         
           ELSE                                                         
              PERFORM 2600-REGISTER-ELIGIBLE    THRU 2600-EXIT          
              MOVE WS-TEXT-REGISTER-CD  TO  WS-TEXT-REPORT-CD           
              IF WS-TEXT-REPORT-CD = SPACES                             
                 PERFORM 2700-REPORT-ELIGIBLE   THRU 2700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE HT-ACCOUNT-NO        TO RS-ACCOUNT-NO.                  
           MOVE HT-CUSTOMER-NO       TO RS-CUSTOMER-NO.                 
           MOVE WS-TEXT-REGISTER-CD  TO RS-TEXT-REGISTER-CD             
           MOVE WS-TEXT-REPORT-CD    TO RS-TEXT-REPORT-CD               
                                                                        
           PERFORM 2005-MOVE-RESULT THRU 2005-EXIT.                     
                                                                        
           IF  SEL-METH-ACC                                             
               MOVE 1 TO CTR-ROWS                                       
           ELSE                                                         
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-REGISTER-ELIGIBLE.                                          
                                                                        
           IF HT-ACCOUNT-NO > 0                                         
              PERFORM 7200-GET-ACCOUNT-DETAILS    THRU 7200-EXIT        
              IF WS-TEXT-REGISTER-CD = SPACES                           
                 PERFORM 7300-ELECTRIC-AVAILABLE  THRU 7300-EXIT        
                 IF WS-ELEC-SUPPLIED = 'E'                              
                    PERFORM 7320-UTILITY-SOURCE   THRU 7320-EXIT        
                 END-IF                                                 
                 IF WS-TEXT-REGISTER-CD = SPACES                        
                    PERFORM  7400-CHECK-INDUSTRIAL-RATE THRU 7400-EXIT  
                 END-IF                                                 
                 IF WS-TEXT-REGISTER-CD = SPACES                        
                    PERFORM 7420-CHECK-REVENUE-CLASS THRU 7420-EXIT     
                 END-IF                                                 
              END-IF                                                    
              IF WS-TEXT-REGISTER-CD = SPACES                           
                  PERFORM 7500-CUST-MISC-INFO  THRU 7500-EXIT           
              END-IF                                                    
           ELSE                                                         
              IF WS-TEXT-REGISTER-CD = SPACES                           
                 MOVE 'A' TO WS-TEXT-REGISTER-CD                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2700-REPORT-ELIGIBLE.                                            
                                                                        
           PERFORM 7600-POINT-ID         THRU 7600-EXIT.                
           IF WS-TEXT-REPORT-CD = SPACES                                
              PERFORM 7700-DNP              THRU 7700-EXIT              
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-OPEN-AT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN AT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7000'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-FETCH-AT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH AT-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-COMPANY-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7010'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CLOSE-AT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE AT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7020'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-CUS-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN CUS-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE  HT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-FETCH-CUS-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH CUS-CURSOR                                          
              INTO :HT-CUSTOMER-NO,                                     
                   :HT-ACCOUNT-NO,                                      
                   :HT-PREMISE-NO,                                      
                   :HT-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7110'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-CUS-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
             CLOSE CUS-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7120'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-ACCOUNT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_TYPE_CODE,
              CUSTOMER_NO,
              CODE_ACCT_STAT,
              CODE_CRIT_OUTAGE                                  
                INTO :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-STAT,                                
                     :AT-CODE-CRIT-OUTAGE                               
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_TYPE_CODE,                                        
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               CODE_CRIT_OUTAGE                                          
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-CODE-CRIT-OUTAGE                                       
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF AT-CODE-ACCT-STAT NOT = 'A'                       
                      MOVE 'A' TO WS-TEXT-REGISTER-CD                   
                   ELSE                                                 
                      IF AT-CODE-CRIT-OUTAGE NOT = 'WC' AND             
                         AT-CODE-CRIT-OUTAGE NOT = 'WP' AND             
                         AT-CODE-CRIT-OUTAGE NOT = 'WX' AND             
                         AT-CODE-CRIT-OUTAGE NOT = SPACES               
                         MOVE 'B' TO WS-TEXT-REGISTER-CD                
                      END-IF                                            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   PERFORM 7210-ARCHIVE-ACCT THRU 7210-EXIT             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7200'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ACCOUNT'          TO TABLE-1               
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
                   MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-ARCHIVE-ACCT.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                INTO :HA-ACCOUNT-NO                                     
                FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*         INTO :HA-ACCOUNT-NO                                             
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ARCHIVE-FL                            
                   MOVE 'D' TO WS-TEXT-REGISTER-CD                      
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ARCHIVE-FL                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7210'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'HST_ACCOUNT'          TO TABLE-1               
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
                   MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-ELECTRIC-AVAILABLE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'E' TO WS-ELEC-SUPPLIED                         
                   GO TO 7300-EXIT                                      
               WHEN NOT-FOUND                                           
                   MOVE 'E' TO WS-TEXT-REGISTER-CD                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7300'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7320-UTILITY-SOURCE.                                             
                                                                        
           EXEC SQL                                                     
                SELECT MAX(UTILITY_SOURCE_CD)                           
                  INTO :WS-UTILITY-SOURCE-CD :WS-UTIL-SRC-CD-NULL-IND    
                  FROM CSS_MTRD_ENVRNMT                                 
                 WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                      
                   AND CODE_UTIL_TYPE = 'E'                             
                   AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')   
                 GROUP BY ACCOUNT_NO                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(UTILITY_SOURCE_CD)                                   
MFA-TR*           INTO :WS-UTILITY-SOURCE-CD:WS-UTIL-SRC-CD-NULL-IND            
MFA-TR*           FROM CSS_MTRD_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                              
MFA-TR*            AND CODE_UTIL_TYPE = 'E'                                     
MFA-TR*            AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')           
MFA-TR*          GROUP BY ACCOUNT_NO                                            
MFA-TR*          QUERYNO 7320                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-UTIL-SRC-CD-NULL-IND < 0                           
                  MOVE SPACES TO WS-UTILITY-SOURCE-CD                   
               ELSE                                                     
                  IF WS-UTILITY-SOURCE-CD = 'T'                         
                     MOVE 'F' TO WS-TEXT-REGISTER-CD                    
                  END-IF                                                
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7320'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
                END-IF
           END-IF.           
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *RATE_PLAN_NO AND CODE_REVENUE_CLASS ARE CHECKED TO VERIFY IF THE*        
      *CUSTOMER IS A LARGE COMMERCIAL/INDUSTRIAL ELECTRIC CUSTOMER.    *        
      *ACCOUNT_TYPE_CODE IS NOT CHECKED AS WE NEED ONLY THE CUSTOMERS  *        
      *WITH THESE RATES TO BE FILTERED OUT & ALSO A CUSTOMER CAN HAVE  *        
      *COMMERCIAL FOR LIGHTING BUT NOT FOR ELECTRIC.                   *        
      ******************************************************************        
       7400-CHECK-INDUSTRIAL-RATE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) UT.RATE_PLAN_NO,
              UT.CODE_REVENUE_CLASS                              
                INTO :UT-RATE-PLAN-NO                                   
                    ,:UT-CODE-REVENUE-CLASS                             
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
               WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                     
                 AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                      
                 AND MN.IC_NO = UT.IC_NO                                
                 AND UT.CODE_UTIL_TYPE = 'E'                            
                 AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE              
      *          AND MN.CODE_METER_STATUS = 'A'                                 
                 AND MN.CODE_METER_STATUS NOT IN ('K', 'J')             
                 AND UT.RATE_PLAN_NO IN                                 
                             ('024', '027', '060', '065', '066')        
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*             ,UT.CODE_REVENUE_CLASS                                      
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*             ,:UT-CODE-REVENUE-CLASS                                     
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                             
MFA-TR*          AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                              
MFA-TR*          AND MN.IC_NO = UT.IC_NO                                        
MFA-TR*          AND UT.CODE_UTIL_TYPE = 'E'                                    
MFA-TR*          AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                      
MFA-TR*          AND MN.CODE_METER_STATUS = 'A'                                 
MFA-TR*          AND MN.CODE_METER_STATUS NOT IN ('K', 'J')                     
MFA-TR*          AND UT.RATE_PLAN_NO IN                                         
MFA-TR*                      ('024', '027', '060', '065', '066')                
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  MOVE 'G' TO WS-TEXT-REGISTER-CD                       
              WHEN NOT-FOUND                                            
                  MOVE SPACES TO UT-RATE-PLAN-NO                        
                  MOVE SPACES TO UT-CODE-REVENUE-CLASS                  
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE '7400'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                
                  MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
                  MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
            END-EVALUATE.                                               
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7420-CHECK-REVENUE-CLASS.                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) UT.CODE_REVENUE_CLASS                            
                  INTO :UT-CODE-REVENUE-CLASS                           
                  FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                      ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                
                 WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                   
                   AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                    
                   AND MN.IC_NO = UT.IC_NO                              
                   AND UT.CODE_UTIL_TYPE = 'E'                          
                   AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE            
                   AND MN.CODE_METER_STATUS NOT IN ('J', 'K')           
      *            AND UT.CODE_REVENUE_CLASS  NOT LIKE '%1%'                    
      *            AND UT.CODE_REVENUE_CLASS  NOT LIKE '%2%'                    
                   AND CIS.SUBSTR3(UT.CODE_REVENUE_CLASS,2,1)                
                                               NOT IN ('1', '2')        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT UT.CODE_REVENUE_CLASS                                    
MFA-TR*           INTO :UT-CODE-REVENUE-CLASS                                   
MFA-TR*           FROM CSS_UTIL_ENVRNMT UT                                      
MFA-TR*               ,CSS_MTRD_ENVRNMT MN                                      
MFA-TR*          WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                           
MFA-TR*            AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                            
MFA-TR*            AND MN.IC_NO = UT.IC_NO                                      
MFA-TR*            AND UT.CODE_UTIL_TYPE = 'E'                                  
MFA-TR*            AND UT.CODE_UTIL_TYPE = MN.CODE_UTIL_TYPE                    
MFA-TR*            AND MN.CODE_METER_STATUS NOT IN ('J', 'K')                   
MFA-TR*            AND UT.CODE_REVENUE_CLASS  NOT LIKE '%1%'                    
MFA-TR*            AND UT.CODE_REVENUE_CLASS  NOT LIKE '%2%'                    
MFA-TR*            AND SUBSTR(UT.CODE_REVENUE_CLASS,2,1)                        
MFA-TR*                                        NOT IN ('1', '2')                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7420                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  MOVE 'H' TO WS-TEXT-REGISTER-CD                       
              WHEN NOT-FOUND                                            
                  CONTINUE                                              
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE '7420'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                
                  MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
                  MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
            END-EVALUATE.                                               
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7500-CUST-MISC-INFO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT KEY_CUSTOMER                                      
                INTO :LQ-KEY-CUSTOMER                                   
                FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KEY_CUSTOMER                                              
MFA-TR*         INTO :LQ-KEY-CUSTOMER                                           
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF LQ-KEY-CUSTOMER NOT = SPACES                      
                      MOVE 'I' TO WS-TEXT-REGISTER-CD                   
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACE TO LQ-KEY-CUSTOMER                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7500'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_CUST_MISC_INFO'   TO TABLE-1               
                   MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1       
                   MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-POINT-ID.                                                   
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) GIS_POINT_ID                                     
                  INTO :MN-GIS-POINT-ID                                 
                  FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                   
                 WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                      
                   AND CODE_UTIL_TYPE = 'E'                             
                   AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')   
                   AND GIS_POINT_ID > 0                                 
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT GIS_POINT_ID                                             
MFA-TR*           INTO :MN-GIS-POINT-ID                                         
MFA-TR*           FROM CSS_MTRD_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                              
MFA-TR*            AND CODE_UTIL_TYPE = 'E'                                     
MFA-TR*            AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')           
MFA-TR*            AND GIS_POINT_ID > 0                                         
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7943                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  CONTINUE                                              
              WHEN NOT-FOUND                                            
                  MOVE 'J' TO WS-TEXT-REPORT-CD                         
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE '7600'                 TO ACTIVE-PARAGRAPH       
                  MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                
                  MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
                  MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
            END-EVALUATE.                                               
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-DNP.                                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                INTO :VO-SERV-ORDER-NO                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :HT-PREMISE-NO                        
                 AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D')             
                 AND ORDER_TYPE_CD = 'DNP01'                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*         INTO :VO-SERV-ORDER-NO                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                                
MFA-TR*          AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D')                     
MFA-TR*          AND ORDER_TYPE_CD = 'DNP01'                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'K' TO WS-TEXT-REPORT-CD                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7700'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_SO_DATA'          TO TABLE-1               
                   MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1       
                   MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.       
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR04397_R1                        
                 (    RETURN_CODE                                       
                     ,ACCOUNT_NO                                        
                     ,CUSTOMER_NO                                       
                     ,TEXT_REGISTER_CD                                  
                     ,TEXT_REPORT_CD)                                   
                 VALUES                                                 
                 (    :S-RETURN-CODE                                    
                     ,:S-ACCOUNT-NO                                     
                     ,:S-CUSTOMER-NO                                    
                     ,:S-TEXT-REGISTER-CD                               
                     ,:S-TEXT-REPORT-CD)                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04397_R1                                
MFA-TR*          (    RETURN_CODE                                               
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,TEXT_REGISTER_CD                                          
MFA-TR*              ,TEXT_REPORT_CD)                                           
MFA-TR*          VALUES                                                         
MFA-TR*          (    :S-RETURN-CODE                                            
MFA-TR*              ,:S-ACCOUNT-NO                                             
MFA-TR*              ,:S-CUSTOMER-NO                                            
MFA-TR*              ,:S-TEXT-REGISTER-CD                                       
MFA-TR*              ,:S-TEXT-REPORT-CD)                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                ADD +1                    TO  CTR-ROWS                  
            ELSE                                                        
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04397_R1'        TO  TABLE-1                   
                MOVE 'CUSTOMER NO'        TO  TABLE-ELEMENT-1           
                MOVE S-CUSTOMER-NO        TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
            END-IF.         
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
