       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04393.                                     
COB303 DATE-WRITTEN.  DEC 08,2010                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ALL THE REQUIRED INFORMATION FOR THE   *        
      *  PRP PANEL.                                                    *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00453*  12/08/10  SP95538    PROCEDURE ORIGINALLY CODED.              *        
P00453*  05/18/11  AA97148    1)REPLACED 'PAG' WITH 'PRP AND           *        
P00453*                         'PAY-AND-GO' WITH 'PRE-PAY-PLAN'.      *        
P00453*                       2)REPLACED CONSUMPTION START DATE WITH   *        
P00453*                         REVENUE MONTH.                         *        
P00453*  08/11/11  VENKATP    MODIFIED CURSOR TO SELECT ALL THE ROWS,  *        
P00453*                       NEED TO ADDRESS CAN/RE-BILLS SEPERATELY. *        
P00785*  08/30/13  MC95456    CHANGES TO RETURN TWO RESULT SETS WHEN   *        
P00785*                       PARM-PRP-FLAG= 'A'                       *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04393'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                      PIC X(40) VALUE                 
            'WORKING STORAGE FOR CSR04393 STARTS HERE'.                 
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04391'.     
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-ACCOUNT-NO              PIC S9(13) COMP-3 VALUE 0.      
          05 WS-GTT-NAME                PIC X(19)  VALUE SPACE.         
P00785    05 WS-SQLSTATE                PIC X(05)  VALUE SPACES.        
      *                                                                         
       01  WS-FLAG.                                                     
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
      *                                                                         
P00785 01  WS-ERR-FLAGS.                                                
P00785     05  WS-ERR-INSRT-R1              PIC X(01) VALUE 'N'.        
P00785     05  WS-ERR-INSRT-R2              PIC X(01) VALUE 'N'.        
      *                                                                         
       01 WS-COUNTERS.                                                  
P00785    05 CTR-ROWS-RS1             PIC S9(09) COMP VALUE 0.          
P00785    05 CTR-ROWS-RS2             PIC S9(09) COMP VALUE 0.          
      *                                                                         
P00785 01 GTT-RETURN-FIELDS-1.                                          
P00785    05 S-RETURN-CODE-1        PIC S9(9) COMP VALUE 0.             
          05 S-TRANS-DATE           PIC X(26) VALUE SPACE.              
          05 S-PRP-EST-AMT          PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-PRP-BILLED-AMT       PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-TOT-BILLED-AMT       PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-ESTMT-THERMS         PIC S9(9)V USAGE COMP-3 VALUE 0.    
          05 S-PRICE-PER-THERM      PIC S9(5)V9(6) USAGE COMP-3 VALUE 0.
          05 S-CSC                  PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-AGL-PASSTHROUGH      PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-ESTABLISHMT-FEE      PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-ADDL-PRP-CHG         PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-PRIOR-BILL-TRUE      PIC S9(7)V9(2) USAGE COMP-3 VALUE 0.
          05 S-REMARKS.                                                 
             49 S-CASE-LENGTH       PIC S9(4)   COMP VALUE +0.          
             49 S-CASE-TEXT         PIC X(250)  VALUE SPACE.            
      *                                                                         
P00785 01 GTT-RETURN-FIELDS-2.                                          
P00785    05 S-RETURN-CODE-2        PIC S9(9) COMP VALUE 0.             
          05 S-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.    
          05 S-NO-DAYS              PIC S9(4) COMP VALUE +0.            
          05 S-NO-UNITS             PIC S9(9) USAGE COMP-3 VALUE 0.     
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WORKING STORAGE TO GET JOB PARM DATA                        *        
      ******************************************************************        
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ******************************************************************        
      *    WORKING STORAGE FOR ABEND SWITCH                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************00010700
      *    SQL COMMUNICATION AREA                                      *00010800
      ******************************************************************00010900
      *                                                                 00011000
           EXEC SQL                                                     00011100
              INCLUDE SQLCA                                             00011200
           END-EXEC.                                                    00011300
                                                                        
      *                                                                         
      ******************************************************************        
      *    CSS_PREPAY_HIST - PK                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CNSMPTN_NONCIS - PX                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNSMPN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************12232440
      *                      CURSOR DECLARATIONS                       *12232450
      ******************************************************************12232460
      *                                                                *12232490
      ******************************************************************12232460
      *    PRP-HIST-CUR CURSOR                                         *12232480
      ******************************************************************12232460
      *                                                                 12232490
           EXEC SQL DECLARE PRP-HIST-CUR CURSOR FOR                     
             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           PK.PREPAY_HIST_SEQ_TS, 121), ' ', '-'), ':', '.') 
           PREPAY_HIST_SEQ_TS                               
                   ,PK.REVENUE_MONTH                                    
                   ,PK.EST_METHOD_CD                                    
                   ,PK.EST_NO_UNITS                                     
                   ,PK.EST_UNIT_PRICE_AM                                
                   ,PK.EST_ADDL_CHARGE_AM                               
                   ,PK.EST_CUSTSVC_CHG_AM                               
                   ,PK.EST_MISC_CHARGE_AM                               
                   ,PK.EST_CONNECT_CHG_AM                               
                   ,PK.EST_BILL_AM                                      
                   ,PK.NET_BILL_ADJ_AM                                  
                   ,PK.ARREARS_AMT                                      
                   ,PK.BILLED_AMT                                       
                   ,PK.BILL_VARIANCE_AM                                 
                   ,PK.REMARKS                                          
             FROM   CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                    
             WHERE  PK.ACCOUNT_NO        =:PK-ACCOUNT-NO                
             ORDER BY PK.REVENUE_MONTH DESC                             
                     ,PREPAY_HIST_SEQ_TS DESC                        
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE PRP-HIST-CUR CURSOR FOR                     12232500
MFA-TR*      SELECT PK.PREPAY_HIST_SEQ_TS                               12232600
MFA-TR*            ,PK.REVENUE_MONTH                                    12232700
MFA-TR*            ,PK.EST_METHOD_CD                                    12233000
MFA-TR*            ,PK.EST_NO_UNITS                                     12233100
MFA-TR*            ,PK.EST_UNIT_PRICE_AM                                12233200
MFA-TR*            ,PK.EST_ADDL_CHARGE_AM                               12233500
MFA-TR*            ,PK.EST_CUSTSVC_CHG_AM                               12233900
MFA-TR*            ,PK.EST_MISC_CHARGE_AM                               12234000
MFA-TR*            ,PK.EST_CONNECT_CHG_AM                                       
MFA-TR*            ,PK.EST_BILL_AM                                              
MFA-TR*            ,PK.NET_BILL_ADJ_AM                                          
MFA-TR*            ,PK.ARREARS_AMT                                              
MFA-TR*            ,PK.BILLED_AMT                                               
MFA-TR*            ,PK.BILL_VARIANCE_AM                                         
MFA-TR*            ,PK.REMARKS                                                  
MFA-TR*      FROM   CSS_PREPAY_HIST PK                                  12234300
MFA-TR*      WHERE  PK.ACCOUNT_NO        =:PK-ACCOUNT-NO                12234400
MFA-TR*      ORDER BY PK.REVENUE_MONTH DESC                                     
MFA-TR*              ,PK.PREPAY_HIST_SEQ_TS DESC                                
MFA-TR*        FOR FETCH ONLY WITH UR                                   12234500
MFA-TR*    QUERYNO 7000                                                         
MFA-TR*    END-EXEC.                                                    12234600
      *                                                                         
      ******************************************************************12232460
      *    CNSMPTN-CUR CURSOR                                          *12232480
      ******************************************************************12232460
      *                                                                 12232490
           EXEC SQL DECLARE CNSMPTN-CUR CURSOR FOR                      
             SELECT PX.REVENUE_MONTH                                    
                   ,PX.NO_DAYS                                          
                   ,PX.NO_UNITS                                         
             FROM   CSS_CNSMPTN_NONCIS PX WITH(READUNCOMMITTED)                 
             WHERE  PX.ACCOUNT_NO       = :PX-ACCOUNT-NO                
             ORDER BY REVENUE_MONTH     DESC                            
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CNSMPTN-CUR CURSOR FOR                      12232500
MFA-TR*      SELECT PX.REVENUE_MONTH                                    12232600
MFA-TR*            ,PX.NO_DAYS                                          12232700
MFA-TR*            ,PX.NO_UNITS                                         12233000
MFA-TR*      FROM   CSS_CNSMPTN_NONCIS PX                               12234300
MFA-TR*      WHERE  PX.ACCOUNT_NO       = :PX-ACCOUNT-NO                12234400
MFA-TR*      ORDER BY REVENUE_MONTH     DESC                                    
MFA-TR*      FOR FETCH ONLY WITH UR                                     12234500
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                    12234600
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR04393 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.              
       01  PARM-PRP-FLAG                PIC X(01).                      
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-PRP-FLAG.                          
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           IF PARM-PRP-FLAG = 'N'                                       
              PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT          
           ELSE                                                         
P00785        IF PARM-PRP-FLAG = 'Y'                                    
P00785           PERFORM 2300-PROCESS-AGL-USAGE   THRU 2300-EXIT        
P00785        ELSE                                                      
P00785           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT        
P00785           PERFORM 2300-PROCESS-AGL-USAGE   THRU 2300-EXIT        
P00785        END-IF                                                    
           END-IF.                                                      
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
P00785     PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
P00785     PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
               WITH ROWSET POSITIONING FOR                              
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04393_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04393_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P00785     EXEC SQL                                                     
P00785         DECLARE C2 CURSOR                             
P00785         WITH ROWSET POSITIONING FOR                              
P00785         SELECT                                                   
P00785            *                                                     
P00785         FROM                                                     
P00785             #CSR04393_R2                                  
P00785     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04393_R2                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
P00785* 0100A-DECLARE-GTT-R1.                                          *        
      ******************************************************************        
      *                                                                         
P00785 0100A-DECLARE-GTT-R1.                                            
      *                                                                         
           MOVE 'SESSION.CSR04393_R1'       TO WS-GTT-NAME.             
      *                                                                         
              EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR04393_R1')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR04393_R1
                 (                                                    
                     RETURN_CODE           INT                      
P00453              ,TRANS_DATE CHAR(26)  COLLATE 
                                     LATIN1_GENERAL_100_BIN2                   
                    ,PRP_EST_AMT           DECIMAL(09,2)                
                    ,PRP_BILLED_AMT        DECIMAL(09,2)                
                    ,TOT_BILLED_AMT        DECIMAL(09,2)                
                    ,ESTMT_THERMS          DECIMAL(09,0)                
                    ,PRICE_PER_THERM       DECIMAL(11,6)                
                    ,CSC                   DECIMAL(09,2)                
                    ,AGL_PASSTHROUGH       DECIMAL(09,2)                
                    ,ESTABLISHMT_FEE       DECIMAL(09,2)                
                    ,ADDL_PRP_CHG          DECIMAL(09,2)                
                    ,PRICE_BILL_TRUE       DECIMAL(09,2)                
                    ,REMARKS VARCHAR(250)  COLLATE 
                                     LATIN1_GENERAL_100_BIN2                 
                   )
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
P00785     MOVE SQLSTATE                    TO WS-SQLSTATE.             
P00785     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
P00785     IF WS-SQLSTATE = '42710'                                     
P00785        PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
P00785     ELSE                                                         
P00785        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00785           CONTINUE                                               
P00785        ELSE                                                      
P00785           MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
P00785           MOVE '0100A'                  TO ACTIVE-PARAGRAPH      
P00785           MOVE SQLCODE                  TO ABEND-SQLCODE         
P00785           MOVE SQLSTATE                 TO ABEND-SQLSTATE        
P00785           MOVE 'DECLARE GTT'            TO ABEND-FUNCTION        
P00785           MOVE SPACES                   TO ABEND-SQL-PREDICATES  
P00785                                            ABEND-TABLES          
P00785           MOVE WS-GTT-NAME              TO TABLE-1               
P00785           MOVE SPACES                   TO TABLE-ELEMENT-1       
P00785           MOVE SPACES                   TO HOSTVAR-ELEMENT-1     
P00785           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00785        END-IF                                                    
P00785     END-IF.                                                      
      *                                                                 12256100
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 12256100
P00785******************************************************************        
P00785* 0100B-DECLARE-GTT-R2.                                          *        
P00785******************************************************************        
P00785*                                                                         
P00785 0100B-DECLARE-GTT-R2.                                            
      *                                                                         
P00785     MOVE 'SESSION.CSR04393_R2'       TO WS-GTT-NAME.             
      *                                                                         
P00785        EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR04393_R2')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR04393_R2
                 (                                                    
P00785               RETURN_CODE           INT                      
P00785              ,REVENUE_MONTH         DECIMAL(6,0)                
P00785              ,NO_DAYS               INT                      
P00785              ,NO_UNITS              DECIMAL(09,0)                
P00785             )
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00785*                                                                         
P00785     MOVE SQLSTATE                    TO WS-SQLSTATE.             
P00785     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
P00785     IF WS-SQLSTATE = '42710'                                     
P00785        PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
P00785     ELSE                                                         
P00785        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00785           CONTINUE                                               
P00785        ELSE                                                      
P00785           MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
P00785           MOVE '0100B'                  TO ACTIVE-PARAGRAPH      
P00785           MOVE SQLCODE                  TO ABEND-SQLCODE         
P00785           MOVE SQLSTATE                 TO ABEND-SQLSTATE        
P00785           MOVE 'DECLARE GTT'            TO ABEND-FUNCTION        
P00785           MOVE SPACES                   TO ABEND-SQL-PREDICATES  
P00785                                            ABEND-TABLES          
P00785           MOVE WS-GTT-NAME              TO TABLE-1               
P00785           MOVE SPACES                   TO TABLE-ELEMENT-1       
P00785           MOVE SPACES                   TO HOSTVAR-ELEMENT-1     
P00785           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00785        END-IF                                                    
P00785     END-IF.                                                      
      *                                                                 12256100
P00785 0100B-EXIT.                                                      
P00785      EXIT.                                                       
      *                                                                 12256100
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                 12256500
           MOVE PARM-ACCOUNT-NO             TO PK-ACCOUNT-NO            
                                               PX-ACCOUNT-NO.           
      *                                                                 12256500
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7000-OPEN-PRP-HIST         THRU 7000-EXIT.           
           PERFORM 7050-FETCH-PRP-HIST        THRU 7050-EXIT.           
      *                                                                 23101400
           PERFORM 2100-PROCESS-PRP-ACCT      THRU 2100-EXIT            
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                 23101400
           PERFORM 7100-CLOSE-PRP-HIST        THRU 7100-EXIT.           
      *                                                                 23101400
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************23099900
      * 2100-PROCESS-PRP-ACCT                                          *23100000
      ******************************************************************23100800
      *                                                                 23100900
       2100-PROCESS-PRP-ACCT.                                           
      *                                                                 23101100
           PERFORM 2200-MOVE-VALUES           THRU 2200-EXIT.           
P00785     PERFORM 8100-INSERT-GTT-R1         THRU 8100-EXIT.           
      *                                                                 23125000
           PERFORM 7050-FETCH-PRP-HIST        THRU 7050-EXIT.           
      *                                                                 23125000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50410005
      ******************************************************************12265200
      *2200-MOVE-VALUES.                                               *12265300
      ******************************************************************12265400
      *                                                                         
       2200-MOVE-VALUES.                                                
      *                                                                 12265600
P00453     MOVE PK-PREPAY-HIST-SEQ-TS       TO S-TRANS-DATE             
           MOVE PK-EST-BILL-AM              TO S-PRP-EST-AMT            
           MOVE PK-NET-BILL-ADJ-AM          TO S-PRP-BILLED-AMT         
           MOVE PK-BILLED-AMT               TO S-TOT-BILLED-AMT         
           MOVE PK-EST-NO-UNITS             TO S-ESTMT-THERMS           
           MOVE PK-EST-UNIT-PRICE-AM        TO S-PRICE-PER-THERM        
           MOVE PK-EST-CUSTSVC-CHG-AM       TO S-CSC                    
           MOVE PK-EST-ADDL-CHARGE-AM       TO S-AGL-PASSTHROUGH        
           MOVE PK-EST-CONNECT-CHG-AM       TO S-ESTABLISHMT-FEE        
           MOVE PK-EST-MISC-CHARGE-AM       TO S-ADDL-PRP-CHG           
           MOVE PK-BILL-VARIANCE-AM         TO S-PRIOR-BILL-TRUE        
           MOVE PK-REMARKS                  TO S-REMARKS.               
      *                                                                 12270300
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23099800
      ******************************************************************        
      * 2300-PROCESS-AGL-USAGE.                                        *        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-AGL-USAGE.                                          
      *                                                                         
           PERFORM 7150-OPEN-CONSUMPTION      THRU 7150-EXIT.           
           PERFORM 7200-FETCH-CONSUMPTION     THRU 7200-EXIT.           
      *                                                                 23101400
           PERFORM 2400-PROCESS-CONSUMPTION   THRU 2400-EXIT            
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                 23101400
           PERFORM 7250-CLOSE-CONSUMPTION     THRU 7250-EXIT.           
      *                                                                 23101400
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************23099900
      * 2400-PROCESS-CONSUMPTION                                       *23100000
      ******************************************************************23100800
      *                                                                 23100900
       2400-PROCESS-CONSUMPTION.                                        
      *                                                                 23101100
           MOVE PX-REVENUE-MONTH            TO S-REVENUE-MONTH.         
           MOVE PX-NO-DAYS                  TO S-NO-DAYS.               
           MOVE PX-NO-UNITS                 TO S-NO-UNITS.              
P00785     PERFORM 8200-INSERT-GTT-R2     THRU 8200-EXIT.               
      *                                                                 23125000
           PERFORM 7200-FETCH-CONSUMPTION     THRU 7200-EXIT.           
      *                                                                 23125000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23125000
      ******************************************************************50410006
      * 7000-OPEN-PRP-HIST                                             *50410007
      ******************************************************************50410050
      *                                                                 50410060
       7000-OPEN-PRP-HIST.                                              
      *                                                                 50410080
           EXEC SQL                                                     
              OPEN PRP-HIST-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50410500
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-1.            
      *                                                                 50410700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREPAY_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 50412300
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50412600
      ******************************************************************50416400
      * 7050-FETCH-PRP-HIST                                            *50416500
      ******************************************************************50417200
      *                                                                 50417300
       7050-FETCH-PRP-HIST.                                             
      *                                                                 50417500
           EXEC SQL                                                     
              FETCH  PRP-HIST-CUR                                       
              INTO  :PK-PREPAY-HIST-SEQ-TS                              
                   ,:PK-REVENUE-MONTH                                   
                   ,:PK-EST-METHOD-CD                                   
                   ,:PK-EST-NO-UNITS                                    
                   ,:PK-EST-UNIT-PRICE-AM                               
                   ,:PK-EST-ADDL-CHARGE-AM                              
                   ,:PK-EST-CUSTSVC-CHG-AM                              
                   ,:PK-EST-MISC-CHARGE-AM                              
                   ,:PK-EST-CONNECT-CHG-AM                              
                   ,:PK-EST-BILL-AM                                     
                   ,:PK-NET-BILL-ADJ-AM                                 
                   ,:PK-ARREARS-AMT                                     
                   ,:PK-BILLED-AMT                                      
                   ,:PK-BILL-VARIANCE-AM                                
                   ,:PK-REMARKS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50420200
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREPAY_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 50422100
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50422400
      ******************************************************************50442700
      * 7100-CLOSE-PRP-HIST.                                           *50442800
      ******************************************************************50443500
      *                                                                 50443600
       7100-CLOSE-PRP-HIST.                                             
      *                                                                 50443800
           EXEC SQL                                                     
              CLOSE  PRP-HIST-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50444400
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-1.            
      *                                                                 50444600
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREPAY_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 50446200
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************50410006
      * 7150-OPEN-CONSUMPTION                                          *50410007
      ******************************************************************50410050
      *                                                                 50410060
       7150-OPEN-CONSUMPTION.                                           
      *                                                                 50410080
           EXEC SQL                                                     
              OPEN CNSMPTN-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50410500
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-2.            
      *                                                                 50410700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CNSMPTN_NONCIS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PX-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 50412300
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50412600
      ******************************************************************50416400
      * 7200-FETCH-CONSUMPTION                                         *50416500
      ******************************************************************50417200
      *                                                                 50417300
       7200-FETCH-CONSUMPTION.                                          
      *                                                                 50417500
           EXEC SQL                                                     
              FETCH  CNSMPTN-CUR                                        
              INTO  :PX-REVENUE-MONTH                                   
                   ,:PX-NO-DAYS                                         
                   ,:PX-NO-UNITS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50420200
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CNSMPTN_NONCIS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PX-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
     *                                                                  
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50422400
      ******************************************************************50442700
      * 7250-CLOSE-CONSUMPTION.                                        *50442800
      ******************************************************************50443500
      *                                                                 50443600
       7250-CLOSE-CONSUMPTION.                                          
      *                                                                 50443800
           EXEC SQL                                                     
              CLOSE  CNSMPTN-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50444400
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-2.            
      *                                                                 50444600
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CNSMPTN_NONCIS'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 50446200
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50446200
P00785*****************************************************************         
P00785*                                                               *         
P00785* 8000A-DEL-GTT-ROWS.                                           *         
P00785*****************************************************************         
P00785 8000A-DEL-GTT-ROWS.                                              
                                                                        
P00785     EXEC SQL                                                     
P00785         DELETE FROM #CSR04393_R1                          
P00785     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04393_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00785     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00785                                         S-RETURN-CODE-1.         
                                                                        
P00785     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00785         WHEN SUCCESSFUL-CALL                                     
P00785              CONTINUE                                            
P00785         WHEN NOT-FOUND                                           
P00785              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
P00785                                         S-RETURN-CODE-1          
P00785         WHEN OTHER                                               
P00785              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P00785              MOVE SQLCODE            TO ABEND-SQLCODE            
P00785              MOVE SQLSTATE           TO ABEND-SQLSTATE           
P00785              MOVE '8000A'            TO ACTIVE-PARAGRAPH         
P00785              MOVE 'DELETE'           TO ABEND-FUNCTION           
P00785              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P00785                                         ABEND-TABLES             
P00785              MOVE 'CSR04393_R1'      TO TABLE-1                  
P00785              MOVE SPACES             TO TABLE-ELEMENT-1          
P00785              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
P00785              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P00785     END-EVALUATE.                                                
                                                                        
P00785 8000A-EXIT.                                                      
P00785      EXIT.                                                       
                                                                        
P00785*****************************************************************         
P00785*                                                               *         
P00785* 8000B-DEL-GTT-ROWS.                                           *         
P00785*****************************************************************         
P00785 8000B-DEL-GTT-ROWS.                                              
                                                                        
P00785     EXEC SQL                                                     
P00785         DELETE FROM #CSR04393_R2                          
P00785     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04393_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00785     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00785                                         S-RETURN-CODE-2.         
                                                                        
P00785     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00785         WHEN SUCCESSFUL-CALL                                     
P00785              CONTINUE                                            
P00785         WHEN NOT-FOUND                                           
P00785              MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
P00785                                         S-RETURN-CODE-2          
P00785         WHEN OTHER                                               
P00785              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
P00785              MOVE SQLCODE            TO ABEND-SQLCODE            
P00785              MOVE SQLSTATE           TO ABEND-SQLSTATE           
P00785              MOVE '8000B'            TO ACTIVE-PARAGRAPH         
P00785              MOVE 'DELETE'           TO ABEND-FUNCTION           
P00785              MOVE SPACES             TO ABEND-SQL-PREDICATES     
P00785                                         ABEND-TABLES             
P00785              MOVE 'CSR04393_R2'      TO TABLE-1                  
P00785              MOVE SPACES             TO TABLE-ELEMENT-1          
P00785              MOVE SPACES             TO HOSTVAR-ELEMENT-1        
P00785              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P00785     END-EVALUATE.                                                
                                                                        
P00785 8000B-EXIT.                                                      
P00785      EXIT.                                                       
      ******************************************************************        
P00785* 8100-INSERT-GTT-R1                                                      
      ******************************************************************        
      *                                                                         
P00785 8100-INSERT-GTT-R1.                                              
      *                                                                         
             EXEC SQL                                                   
                INSERT INTO #CSR04393_R1                         
                  (                                                     
                       RETURN_CODE                                      
                      ,TRANS_DATE                                       
                      ,PRP_EST_AMT                                      
                      ,PRP_BILLED_AMT                                   
                      ,TOT_BILLED_AMT                                   
                      ,ESTMT_THERMS                                     
                      ,PRICE_PER_THERM                                  
                      ,CSC                                              
                      ,AGL_PASSTHROUGH                                  
                      ,ESTABLISHMT_FEE                                  
                      ,ADDL_PRP_CHG                                     
                      ,PRICE_BILL_TRUE                                  
                      ,REMARKS                                          
                  )                                                     
                VALUES                                                  
                  (                                                     
                       :S-RETURN-CODE-1                                 
                      ,:S-TRANS-DATE                                    
                      ,:S-PRP-EST-AMT                                   
                      ,:S-PRP-BILLED-AMT                                
                      ,:S-TOT-BILLED-AMT                                
                      ,:S-ESTMT-THERMS                                  
                      ,:S-PRICE-PER-THERM                               
                      ,:S-CSC                                           
                      ,:S-AGL-PASSTHROUGH                               
                      ,:S-ESTABLISHMT-FEE                               
                      ,:S-ADDL-PRP-CHG                                  
                      ,:S-PRIOR-BILL-TRUE                               
                      ,:S-REMARKS                                       
                  )                                                     
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*      EXEC SQL                                                           
MFA-TR*         INSERT INTO SESSION.CSR04393_R1                                 
MFA-TR*           (                                                             
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,TRANS_DATE                                               
MFA-TR*               ,PRP_EST_AMT                                              
MFA-TR*               ,PRP_BILLED_AMT                                           
MFA-TR*               ,TOT_BILLED_AMT                                           
MFA-TR*               ,ESTMT_THERMS                                             
MFA-TR*               ,PRICE_PER_THERM                                          
MFA-TR*               ,CSC                                                      
MFA-TR*               ,AGL_PASSTHROUGH                                          
MFA-TR*               ,ESTABLISHMT_FEE                                          
MFA-TR*               ,ADDL_PRP_CHG                                             
MFA-TR*               ,PRICE_BILL_TRUE                                          
MFA-TR*               ,REMARKS                                                  
MFA-TR*           )                                                             
MFA-TR*         VALUES                                                          
MFA-TR*           (                                                             
MFA-TR*                :S-RETURN-CODE-1                                         
MFA-TR*               ,:S-TRANS-DATE                                            
MFA-TR*               ,:S-PRP-EST-AMT                                           
MFA-TR*               ,:S-PRP-BILLED-AMT                                        
MFA-TR*               ,:S-TOT-BILLED-AMT                                        
MFA-TR*               ,:S-ESTMT-THERMS                                          
MFA-TR*               ,:S-PRICE-PER-THERM                                       
MFA-TR*               ,:S-CSC                                                   
MFA-TR*               ,:S-AGL-PASSTHROUGH                                       
MFA-TR*               ,:S-ESTABLISHMT-FEE                                       
MFA-TR*               ,:S-ADDL-PRP-CHG                                          
MFA-TR*               ,:S-PRIOR-BILL-TRUE                                       
MFA-TR*               ,:S-REMARKS                                               
MFA-TR*           )                                                             
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
P00785     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
P00785                                      WS-ERR-INSRT-R1 = 'Y'       
P00785        ADD +1                        TO  CTR-ROWS-RS1            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
P00785        MOVE 'Y'                      TO  WS-ERR-INSRT-R1         
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04393_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
P00785******************************************************************        
P00785* 8200-INSERT-GTT-R2                                                      
P00785******************************************************************        
      *                                                                         
P00785 8200-INSERT-GTT-R2.                                              
      *                                                                         
P00785      EXEC SQL                                                    
P00785          INSERT INTO #CSR04393_R2                         
P00785            (                                                     
P00785                 RETURN_CODE                                      
P00785                ,REVENUE_MONTH                                    
P00785                ,NO_DAYS                                          
P00785                ,NO_UNITS                                         
P00785            )                                                     
P00785          VALUES                                                  
P00785            (                                                     
P00785                 :S-RETURN-CODE-2                                 
P00785                ,:S-REVENUE-MONTH                                 
P00785                ,:S-NO-DAYS                                       
P00785                ,:S-NO-UNITS                                      
P00785            )                                                     
P00785       END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         INSERT INTO SESSION.CSR04393_R2                                 
MFA-TR*           (                                                             
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,NO_DAYS                                                  
MFA-TR*               ,NO_UNITS                                                 
MFA-TR*           )                                                             
MFA-TR*         VALUES                                                          
MFA-TR*           (                                                             
MFA-TR*                :S-RETURN-CODE-2                                         
MFA-TR*               ,:S-REVENUE-MONTH                                         
MFA-TR*               ,:S-NO-DAYS                                               
MFA-TR*               ,:S-NO-UNITS                                              
MFA-TR*           )                                                             
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
P00785     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00785                                         S-RETURN-CODE-2.         
      *                                                                         
P00785     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
P00785                                       WS-ERR-INSRT-R2 = 'Y'      
P00785        ADD +1                        TO  CTR-ROWS-RS2            
P00785     ELSE                                                         
P00785        MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
P00785        MOVE '8200'                   TO  ACTIVE-PARAGRAPH        
P00785        MOVE SQLCODE                  TO  ABEND-SQLCODE           
P00785        MOVE 'INSERT'                 TO  ABEND-FUNCTION          
P00785        MOVE 'Y'                      TO  WS-ERR-INSRT-R2         
P00785        MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
P00785                                          ABEND-TABLES            
P00785        MOVE 'CSR04393_R2'            TO  TABLE-1                 
P00785        MOVE SPACES                   TO  TABLE-ELEMENT-1         
P00785        MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00785     END-IF.                                                      
      *                                                                         
P00785  8200-EXIT.                                                      
P00785      EXIT.                                                       
      *                                                                         
P00785*****************************************************************         
P00785*                                                               *         
P00785* 8800-CHECK-RESULTS.                                           *         
P00785*****************************************************************         
P00785 8800-CHECK-RESULTS.                                              
                                                                        
P00785     IF CTR-ROWS-RS1  < 1                                         
P00785        INITIALIZE GTT-RETURN-FIELDS-1                            
P00785        MOVE   100                     TO S-RETURN-CODE-1         
P00785        PERFORM 8100-INSERT-GTT-R1     THRU 8100-EXIT             
P00785     END-IF.                                                      
                                                                        
P00785     IF CTR-ROWS-RS2  < 1                                         
P00785        INITIALIZE GTT-RETURN-FIELDS-2                            
P00785        MOVE   100                     TO S-RETURN-CODE-2         
P00785        PERFORM 8200-INSERT-GTT-R2     THRU 8200-EXIT             
P00785     END-IF.                                                      
                                                                        
P00785 8800-EXIT.                                                       
P00785     EXIT.                                                        
                                                                        
P00785******************************************************************        
P00785*                                                                *        
P00785* 8900-SEND-DONE.                                                *        
P00785******************************************************************        
P00785 8900-SEND-DONE.                                                  
                                                                        
P00785     MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
P00785     MOVE '8900'                TO ACTIVE-PARAGRAPH               
P00785     MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
P00785     EXEC SQL                                                     
P00785         OPEN C1                                                  
P00785     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
P00785     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-1.            
                                                                        
P00785     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00785        CONTINUE                                                  
P00785     ELSE                                                         
P00785        MOVE SQLCODE               TO ABEND-SQLCODE               
P00785        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P00785        MOVE 'CSR04393_R1'         TO TABLE-1                     
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00785     END-IF.                                                      
                                                                        
P00785     EXEC SQL                                                     
P00785         OPEN C2                                                  
P00785     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
P00785     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00785                                      S-RETURN-CODE-2.            
                                                                        
P00785     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00785        CONTINUE                                                  
P00785     ELSE                                                         
P00785        MOVE SQLCODE               TO ABEND-SQLCODE               
P00785        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P00785        MOVE 'CSR04393_R2'         TO TABLE-1                     
P00785        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00785     END-IF.                                                      
                                                                        
P00785 8900-EXIT.                                                       
P00785     EXIT.                                                        
                                                                        
P00785******************************************************************        
P00785*                                                                *        
P00785* 9000-SEND-ERROR-RESULT                                         *        
P00785******************************************************************        
P00785 9000-SEND-ERROR-RESULT.                                          
                                                                        
P00785     INITIALIZE GTT-RETURN-FIELDS-1.                              
P00785     MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
P00785                                         S-RETURN-CODE-1          
P00785                                         S-RETURN-CODE-2.         
                                                                        
P00785     MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
P00785     EXEC SQL                                                     
P00785         ROLLBACK                                                 
P00785     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00785     IF SQLCODE = 0                                               
P00785        CONTINUE                                                  
P00785     ELSE                                                         
P00785        MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
P00785     END-IF.                                                      
                                                                        
P00785     PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
P00785     PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
P00785     PERFORM 8100-INSERT-GTT-R1          THRU 8100-EXIT.          
P00785     PERFORM 8200-INSERT-GTT-R2          THRU 8200-EXIT.          
                                                                        
P00785 9000-EXIT.                                                       
P00785     EXIT.                                                        
                                                                        
P00785******************************************************************        
P00785* 9700-ABEND-PROCESSING.                                         *        
P00785******************************************************************        
P00785 9700-PROCESS-ABEND.                                              
                                                                        
P00785     PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
P00785     PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
P00785 9700-EXIT.                                                       
P00785     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
P00785******************************************************************        
P00785* 9999-END-PROGRAM.                                              *        
P00785******************************************************************        
P00785 9999-END-PROGRAM.                                                
P00785                                                                  
P00785      PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
P00785      PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
P00785     
MSQ016        GOBACK.                                                    
                                                                        
P00785 9999-EXIT.                                                       
P00785     EXIT.                                                        
