       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04392.                                     
COB303 DATE-WRITTEN.  OCT 18,2010                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM LOGS CONSUMPTION HIST INTO 'CIS' THAT WE GET THRU*        
      *  'CHIS' FROM AGL.                                              *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00453*  10/18/10  SP95538    PROCEDURE ORIGINALLY CODED.              *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04392'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                      PIC X(40) VALUE                 
            'WORKING STORAGE FOR CSR04392 STARTS HERE'.                 
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04392'.     
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-CONSMPTN-DET-ROW.                                       
             10 WS-READ-MONTH           PIC X(06).                      
             10 FILLER                  PIC X(06).                      
             10 WS-CNSMPTN-CCF          PIC X(09).                      
             10 WS-BEGIN-DT             PIC X(10).                      
             10 WS-END-DT               PIC X(10).                      
             10 WS-DAYS-IN-PERIOD       PIC X(04).                      
          05 WS-REV-MONTH               PIC X(06).                      
          05 WS-READ-MONTH1 REDEFINES WS-REV-MONTH                      
                                        PIC 9(06).                      
          05 WS-CNSMPTN-CCF1            PIC X(09).                      
          05 WS-CNSMPTN-CCF2 REDEFINES WS-CNSMPTN-CCF1                  
                                        PIC 9(09).                      
          05 WS-NO-DAYS1                PIC X(04).                      
          05 WS-NO-DAYS2 REDEFINES WS-NO-DAYS1                          
                                        PIC 9(04).                      
      *                                                                         
       01 WS-CONSMPTN-TABLE.                                            
          05  WS-CONSMPTN-ROW OCCURS 13 TIMES                           
                              INDEXED BY WD-INDX.                       
              10 WS-CONSMPTN-DET    PIC X(45).                          
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE              PIC S9(9) COMP VALUE 0.         
      *                                                                         
       01 WS-FLAG.                                                      
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                   PIC S9(09) COMP VALUE 0.        
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_CNSMPTN_NONCIS - PX                                     *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBCNSMPN                                                 
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_MKT_XREF_ACCT - XM                                      *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBMRKXR                                                  
           END-EXEC.                                                            
      *                                                                 04094000
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR04392 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-DIST-ACCT               PIC X(20).                      
       01  PARM-CONSMPTN-DET-1          PIC X(45).                      
       01  PARM-CONSMPTN-DET-2          PIC X(45).                      
       01  PARM-CONSMPTN-DET-3          PIC X(45).                      
       01  PARM-CONSMPTN-DET-4          PIC X(45).                      
       01  PARM-CONSMPTN-DET-5          PIC X(45).                      
       01  PARM-CONSMPTN-DET-6          PIC X(45).                      
       01  PARM-CONSMPTN-DET-7          PIC X(45).                      
       01  PARM-CONSMPTN-DET-8          PIC X(45).                      
       01  PARM-CONSMPTN-DET-9          PIC X(45).                      
       01  PARM-CONSMPTN-DET-10         PIC X(45).                      
       01  PARM-CONSMPTN-DET-11         PIC X(45).                      
       01  PARM-CONSMPTN-DET-12         PIC X(45).                      
       01  PARM-CONSMPTN-DET-13         PIC X(45).                      
      *                                                                         
       PROCEDURE DIVISION USING PARM-DIST-ACCT                          
                                PARM-CONSMPTN-DET-1                     
                                PARM-CONSMPTN-DET-2                     
                                PARM-CONSMPTN-DET-3                     
                                PARM-CONSMPTN-DET-4                     
                                PARM-CONSMPTN-DET-5                     
                                PARM-CONSMPTN-DET-6                     
                                PARM-CONSMPTN-DET-7                     
                                PARM-CONSMPTN-DET-8                     
                                PARM-CONSMPTN-DET-9                     
                                PARM-CONSMPTN-DET-10                    
                                PARM-CONSMPTN-DET-11                    
                                PARM-CONSMPTN-DET-12                    
                                PARM-CONSMPTN-DET-13.                   
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS  RETURN_CODE              
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                 12256500
           MOVE PARM-DIST-ACCT              TO XM-DIST-ACCT-NO.         
           PERFORM 7000-GET-ACCT-NO             THRU 7000-EXIT.         
           MOVE XM-ACCOUNT-NO               TO PX-ACCOUNT-NO.           
           PERFORM 1200-LOAD-INPUT              THRU 1200-EXIT.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1200-LOAD-INPUT.                                               *        
      ******************************************************************        
      *                                                                         
       1200-LOAD-INPUT.                                                 
      *                                                                 12256500
           SET WD-INDX TO 1                                             
           MOVE PARM-CONSMPTN-DET-1         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-2         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-3         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-4         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-5         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-6         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-7         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-8         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-9         TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-10        TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-11        TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-12        TO WS-CONSMPTN-DET(WD-INDX) 
           SET WD-INDX UP BY 1                                          
           MOVE PARM-CONSMPTN-DET-13        TO WS-CONSMPTN-DET(WD-INDX).
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
      * Inserts record into css_cnsmptn_noncis table                            
      *                                                                         
           SET WD-INDX  TO 1                                            
           PERFORM UNTIL WD-INDX > 13                                   
              INITIALIZE      WS-CONSMPTN-DET-ROW                       
              MOVE WS-CONSMPTN-DET(WD-INDX)  TO WS-CONSMPTN-DET-ROW     
              IF WS-CONSMPTN-DET-ROW > SPACES                           
                 MOVE WS-READ-MONTH          TO WS-REV-MONTH            
                 MOVE WS-READ-MONTH1         TO PX-REVENUE-MONTH        
                 MOVE WS-CNSMPTN-CCF         TO WS-CNSMPTN-CCF1         
                 MOVE WS-CNSMPTN-CCF2        TO PX-NO-UNITS             
                 MOVE WS-DAYS-IN-PERIOD      TO WS-NO-DAYS1             
                 MOVE WS-NO-DAYS2            TO PX-NO-DAYS              
                 MOVE WS-BEGIN-DT            TO PX-CNSMPTN-START-DT     
                 MOVE WS-END-DT              TO PX-CNSMPTN-END-DT       
                 PERFORM 8000-INSERT-CNSMPTN    THRU 8000-EXIT          
              END-IF                                                    
              SET WD-INDX UP BY 1                                       
           END-PERFORM.                                                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           ADD +1                           TO CTR-ROWS.                
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 7000-GET-ACCT-NO.                                              *        
      ******************************************************************        
      *                                                                         
       7000-GET-ACCT-NO.                                                
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       XM.ACCOUNT_NO                                    
                  INTO                                                  
                       :XM-ACCOUNT-NO                                   
                  FROM                                                  
                       CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       XM.DIST_ACCT_NO  = :XM-DIST-ACCT-NO              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                XM.ACCOUNT_NO                                            
MFA-TR*           INTO                                                          
MFA-TR*                :XM-ACCOUNT-NO                                           
MFA-TR*           FROM                                                          
MFA-TR*                CSS_MKT_XREF_ACCT XM                                     
MFA-TR*          WHERE                                                          
MFA-TR*                XM.DIST_ACCT_NO  = :XM-DIST-ACCT-NO                      
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MKT_XREF_ACCT'      TO TABLE-1                  
              MOVE 'DIST_ACCT_NO'           TO TABLE-ELEMENT-1          
              MOVE XM-DIST-ACCT-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-INSERT-CNSMPTN.                                           *        
      ******************************************************************        
      *                                                                         
       8000-INSERT-CNSMPTN.                                             
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO CSS_CNSMPTN_NONCIS                           
                     ( ACCOUNT_NO                                       
                     , CNSMPTN_START_DT                                 
                     , NO_UNITS                                         
                     , REVENUE_MONTH                                    
                     , CNSMPTN_END_DT                                   
                     , NO_DAYS)                                         
               VALUES (:PX-ACCOUNT-NO                                   
                     , IIF(TRY_CONVERT(DATE, :PX-CNSMPTN-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PX-CNSMPTN-START-DT
              ) <> 0) OR (LEN(:PX-CNSMPTN-START-DT
              ) <> 10), CIS.CHAR2DATE(:PX-CNSMPTN-START-DT
              ), CONVERT(DATE, :PX-CNSMPTN-START-DT) )                         
                     , :PX-NO-UNITS                                     
                     , :PX-REVENUE-MONTH                                
                     , IIF(TRY_CONVERT(DATE, :PX-CNSMPTN-END-DT
              ) IS NULL OR (PATINDEX('%.%', :PX-CNSMPTN-END-DT
              ) <> 0) OR (LEN(:PX-CNSMPTN-END-DT
              ) <> 10), CIS.CHAR2DATE(:PX-CNSMPTN-END-DT
              ), CONVERT(DATE, :PX-CNSMPTN-END-DT) )                           
                     , :PX-NO-DAYS)                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO CSS_CNSMPTN_NONCIS                                   
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*              , CNSMPTN_START_DT                                         
MFA-TR*              , NO_UNITS                                                 
MFA-TR*              , REVENUE_MONTH                                            
MFA-TR*              , CNSMPTN_END_DT                                           
MFA-TR*              , NO_DAYS)                                                 
MFA-TR*        VALUES (:PX-ACCOUNT-NO                                           
MFA-TR*              , :PX-CNSMPTN-START-DT                                     
MFA-TR*              , :PX-NO-UNITS                                             
MFA-TR*              , :PX-REVENUE-MONTH                                        
MFA-TR*              , :PX-CNSMPTN-END-DT                                       
MFA-TR*              , :PX-NO-DAYS)                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR -803          
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8000'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CNSMPTN_NONCIS'     TO  TABLE-1                 
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
              MOVE 'CNSMPTN_START_DT'       TO  TABLE-ELEMENT-2         
              MOVE PX-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
              MOVE PX-CNSMPTN-START-DT      TO  HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
        8000-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABENDG                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************50520500
      *       END PROGRAM COPYLIB                                      *50520600
      ******************************************************************50520700
      *                                                                 50521200
           EXEC SQL                                                     50520900
              INCLUDE CPD00321                                          50521000
           END-EXEC.                                                    50521100
      *                                                                 50521200
