       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04391.                                     
COB303 DATE-WRITTEN.  SEP 30,2010                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM CALCULATES INITIAL ESTIMATION AMOUNT FOR THE     *        
      *  PRP and BBP CUSTOMER TO FURTHER USE IN CRM.                   *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00453*  09/30/10  SP95538    PROCEDURE ORIGINALLY CODED.              *        
P00453*  03/30/11  AA97148    1.ADDED ORDER TYPE AS NEW PARAMETER.     *        
P00453*                       2.REPLACED 'PAG' WITH 'PRP.              *        
P00453*  12/12/11  VP43661    USE THE COMMON DATE WHILE COMPUTING AGL  *        
P00453*                       PASSTHRU CHARGES IN BATCH                *        
P00453*  01/03/12  SP95538    SET CALL TYPE TO ONLINE.                 *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04391'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                      PIC X(40) VALUE                 
            'WORKING STORAGE FOR CSR04391 STARTS HERE'.                 
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04391'.     
          05 MCSCB063                   PIC X(08) VALUE 'MCSCB063'.     
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-ACCOUNT-NO              PIC S9(13) COMP-3 VALUE 0.      
          05 WS-REVENUE-MONTH           PIC 9(06) VALUE 0.              
          05 WS-GTT-NAME                PIC X(19) VALUE SPACES.         
          05 RS-RETURN-CODE             PIC S9(04) COMP VALUE 0.        
          05 WS-COMMON-DATE             PIC X(10) VALUE SPACES.         
      * Revenue month redefination                                              
       01 WS-REVENUE-MONTH-REDEFINITION.                                
          05 WS-REV-MONTH1              PIC X(06).                      
          05 WS-REV-MNTH-RED   REDEFINES WS-REV-MONTH1                  
                                        PIC 9(06).                      
       01  WS-FLAG.                                                     
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                   PIC S9(09) COMP VALUE 0.        
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE              PIC S9(9) COMP VALUE 0.         
          05 S-APPL-RETURN-CODE         PIC S9(9) COMP VALUE 0.         
          05 S-ESTMT-AMOUNT             PIC S9(9)V99 COMP-3 VALUE +0.   
          05 S-REVENUE-MONTH            PIC S9(06) COMP-3 VALUE +0.     
          05 S-THERM-PRICE              PIC S9(4)V9(5) USAGE COMP-3     
                                                            VALUE 0.    
          05 S-AGL-PASS-CHARGE          PIC X(13) VALUE SPACES.         
          05 S-ESTMT-CONSUMPT           PIC S9(9) COMP-3 VALUE 0.       
          05 S-CSC-AMOUNT               PIC S9(5)V9(6) USAGE COMP-3     
                                                           VALUE 0.     
          05 S-CONNECT-CHG              PIC S9(4)V9(2) USAGE COMP-3     
                                                           VALUE 0.     
          05 S-OTHER-CHARGES            PIC S9(4)V9(2) USAGE COMP-3     
                                                           VALUE 0.     
          05 S-EST-METHOD-CD            PIC X(01) VALUE SPACES.         
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WORKING STORAGE FIELDS FOR CPD04391                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS04391                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    WORKING STORAGE TO GET JOB PARM DATA                        *        
      ******************************************************************        
      *                                                                         
           COPY FIOJC01.                                                        
      *                                                                         
      ******************************************************************        
      *    WORKING STORAGE FOR ABEND SWITCH                            *        
      ******************************************************************        
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************07910800
      *   WORKING STORAGE AREA FOR READING CSS_JOB_PARM TABLE          *07910900
      ******************************************************************07911000
      *                                                                 07912000
           COPY CWS00038.                                               07913000
      *                                                                 07914000
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR MCSCB063                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00063                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_DELINQUENCY - C8                                        *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_ACCOUNT - AT                                            *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_JOB_PARM - G6                                           *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_TAX_RATE - TR                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     03250000
               INCLUDE TBTXRATE                                         03260000
           END-EXEC.                                                    03270000
      *                                                                         
      ******************************************************************        
      *    CSS_LOCAL_OFFICE - B1                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBLOCOFC                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR - SF                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL - SA                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLAPL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ZIPCODE_LO_RT - ZT                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPRTE                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR04391 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-TRANS-IND               PIC X(03).                      
COB305 01 PARM-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.              
COB305 01 PARM-CUTOMER-NO        PIC S9(10) COMP-3 VALUE 0.              
COB305 01 PARM-REV-MONTH        PIC S9(06) COMP-3 VALUE 0.              
COB305 01 PARM-ESTMT-CONSUMPT        PIC S9(09) COMP-3 VALUE 0.              
COB305 01 PARM-DDDC        PIC S9(02)V9(04) COMP-3 VALUE 0.        
       01  PARM-OPTION-CD               PIC X(12).                      
       01  PARM-ZIP-CD                  PIC X(05).                      
P00453 01  PARM-ORDER-TYPE              PIC X(04).                      
COB305 01 PARM-CNSMPTN-NO-DAYS        PIC S9(4) COMP-3 VALUE 0.               
      *                                                                         
       PROCEDURE DIVISION USING PARM-TRANS-IND                          
                                PARM-ACCOUNT-NO                         
                                PARM-CUTOMER-NO                         
                                PARM-REV-MONTH                          
                                PARM-ESTMT-CONSUMPT                     
                                PARM-DDDC                               
                                PARM-OPTION-CD                          
P00453                          PARM-ZIP-CD                             
P00453                          PARM-ORDER-TYPE                         
P00453                          PARM-CNSMPTN-NO-DAYS.                   
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT            THRU 0100A-EXIT.        
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
               WITH ROWSET POSITIONING FOR                              
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04391_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04391_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04391_R1'       TO WS-GTT-NAME.             
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04391_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04391_R1
              (                                                       
                  RETURN_CODE           INT                         
                 ,APPL_RETURN_CODE      INT                         
                 ,ESTMT_AMT             DECIMAL(11,2)                   
                 ,REV_MONTH             DECIMAL(06,0)                   
                 ,THERM_PRICE           DECIMAL(09,5)                   
                 ,AGL_PASS_CHARGE CHAR(13)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,ESTMT_CONSUMPT        DECIMAL(09,0)                   
                 ,CSC_AMT               DECIMAL(11,6)                   
                 ,CONNECT_CHG           DECIMAL(09,2)                   
                 ,OTHER_CHARGES         DECIMAL(09,2)                   
                 ,EST_METHOD_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '0100A'                  TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'DECLARE GTT'            TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE WS-GTT-NAME              TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT            
           END-IF.                                                      
      *                                                                 12256100
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                 12256500
P00453     SET  ONLINE-CALL                 TO TRUE.                    
           MOVE PARM-TRANS-IND              TO WS-TRANS-IND.            
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE PARM-ZIP-CD                 TO WS-ZIP-CD.               
           MOVE PARM-DDDC                   TO WS-DDDC.                 
           MOVE PARM-ESTMT-CONSUMPT         TO WS-ESTMT-CONSUMPT.       
P00453     MOVE PARM-ORDER-TYPE             TO WS-ORDER-TYPE.           
P00453     MOVE PARM-CNSMPTN-NO-DAYS        TO WS-CNSMPTN-NO-DAYS.      
           IF PARM-TRANS-IND = 'PRP'                                    
              PERFORM 6250-GET-REVENUE-MONTH    THRU 6250-EXIT          
              IF PARM-REV-MONTH > 0                                     
                 MOVE WS-REV-MNTH-RED       TO WS-REVENUE-MONTH         
                 MOVE WS-REVENUE-MONTH      TO S-REVENUE-MONTH          
                 MOVE PARM-REV-MONTH        TO WS-REVENUE-MONTH         
              ELSE                                                      
                                                                        
                 MOVE WS-REV-MNTH-RED       TO WS-REVENUE-MONTH         
                 MOVE WS-REVENUE-MONTH      TO S-REVENUE-MONTH          
              END-IF                                                    
           END-IF                                                       
      *                                                                 12256500
           IF PARM-TRANS-IND = 'BBP' OR  'PRP'                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5001                     TO S-APPL-RETURN-CODE       
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
      *                                                                 12256500
           IF PARM-TRANS-IND = 'PRP'                                    
              IF PARM-ESTMT-CONSUMPT >=0                                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 5002                  TO S-APPL-RETURN-CODE       
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF PARM-OPTION-CD > SPACES                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5003                     TO S-APPL-RETURN-CODE       
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
      *                                                                 12256500
           IF PARM-ZIP-CD > SPACES                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5004                     TO S-APPL-RETURN-CODE       
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
      * Call MCSCB063 to get Therm Price and Customer service Charge            
      *                                                                         
           MOVE PROGRAM-NAME                TO WS-CPD063-CALLING-PGM.   
           MOVE SPACES                      TO ABEND-FUNCTION.          
           MOVE PARM-OPTION-CD              TO WS-OPTION-CD.            
           MOVE WS-ACCOUNT-NO               TO WS-ACCOUNT-NO-063        
           MOVE 1                           TO WS-IC-NO-063             
           MOVE 'G'                         TO WS-CODE-UTIL-TYPE-063    
           MOVE 'Y'                         TO WS-THERM-CSC-ACCT-FL     
           MOVE 'N'                         TO WS-PENDING-OPTION-FL-063 
      *                                                                         
           CALL MCSCB063  USING   CWS00063-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE > 0             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPCODE ERROR'           TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMNT'      TO TABLE-ELEMENT-1          
              MOVE +100                     TO WS-ACTIVE-RETURN-CODE    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF                                                       
           IF PARM-TRANS-IND = 'PRP'                                    
              MOVE WS-THERM-PRICE           TO WS-RATE-PRICE            
              MOVE WS-REVENUE-MONTH         TO WS-REV-MONTH-C           
              MOVE WS-THERM-PRICE           TO S-THERM-PRICE            
              MOVE WS-CSC-AMT               TO S-CSC-AMOUNT             
              PERFORM 6000-PRP-ESTIMATE         THRU 6000-EXIT          
              MOVE WS-ESTMT-AMOUNT          TO S-ESTMT-AMOUNT           
              MOVE WS-ESTMT-CONSUMPT        TO S-ESTMT-CONSUMPT         
              COMPUTE WS-AGL-PASS-CHARGE = WS-AGL-PASS-CHARGE +         
                                           WS-AGL-METER-CHARGE          
              MOVE WS-AGL-PASS-CHARGE       TO WS-AGL-PASS-AMT-NUM      
              MOVE WS-AGL-PASS-AMT-NUM      TO WS-AGL-PASS-AMT-EDIT     
              MOVE WS-AGL-PASS-AMT-CHAR     TO S-AGL-PASS-CHARGE        
              COMPUTE S-OTHER-CHARGES = WS-BUFFER-AMT                   
              MOVE WS-CONNECT-CHARGE        TO S-CONNECT-CHG            
              MOVE WS-EST-METHOD-CD         TO S-EST-METHOD-CD          
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           ELSE                                                         
              IF PARM-TRANS-IND = 'BBP'                                 
                 MOVE WS-THERM-PRICE        TO WS-RATE-PRICE            
                 MOVE WS-THERM-PRICE        TO S-THERM-PRICE            
                 MOVE WS-CSC-AMT            TO S-CSC-AMOUNT             
                 PERFORM 6100-BBP-ESTIMATE      THRU 6100-EXIT          
                 MOVE WS-NEW-CHARGE         TO S-ESTMT-AMOUNT           
                 MOVE WS-ESTMT-CONSUMPT     TO S-ESTMT-CONSUMPT         
                 MOVE WS-AGL-PASS-CHARGE    TO WS-AGL-PASS-AMT-NUM      
                 MOVE WS-AGL-PASS-AMT-NUM   TO WS-AGL-PASS-AMT-EDIT     
                 MOVE WS-AGL-PASS-AMT-CHAR  TO S-AGL-PASS-CHARGE        
                 MOVE ZERO                  TO S-OTHER-CHARGES          
                                               S-CONNECT-CHG            
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  6250-GET-REVENUE-MONTH                                    **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       6250-GET-REVENUE-MONTH.                                          
      *                                                                         
           MOVE '01'                        TO G6-COMPANY-NO.           
           MOVE SPACES                      TO WS-SYSIPT                
           MOVE 'COMMON'                    TO WS-PROGRAM               
           MOVE WS-DATE                     TO WS-COMMAND               
           MOVE ZEROS                       TO WS-SEQUENCE              
           MOVE WS-KEY-AREA                 TO E-FJC01-KEY              
      *                                                                         
           PERFORM 7600-START-FCSJC01           THRU  7600-EXIT         
      *                                                                         
           PERFORM 7610-READ-FCSJC01            THRU  7610-EXIT         
              UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                    
                    OR END-OF-SYSIPT                                    
      *                                                                         
           IF REVENUE-MONTH AND INPUT-ACTIVE                            
              MOVE WS-REVENUE-MONTH-PARM    TO WS-REV-MONTH1            
              PERFORM 7611-CLOSE                THRU  7611-EXIT         
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-2          
              MOVE 'STATUS'                 TO TABLE-ELEMENT-3          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-4          
              MOVE WS-PROGRAM               TO HOSTVAR-ELEMENT-1        
              MOVE 'DATE'                   TO HOSTVAR-ELEMENT-2        
              MOVE 'A'                      TO HOSTVAR-ELEMENT-3        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       6250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04391_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,APPL_RETURN_CODE                                    
                   ,ESTMT_AMT                                           
                   ,REV_MONTH                                           
                   ,THERM_PRICE                                         
                   ,AGL_PASS_CHARGE                                     
                   ,ESTMT_CONSUMPT                                      
                   ,CSC_AMT                                             
                   ,CONNECT_CHG                                         
                   ,OTHER_CHARGES                                       
                   ,EST_METHOD_CD                                       
                  )                                                     
               VALUES                                                   
                  (                                                     
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-ESTMT-AMOUNT                                      
                  ,:S-REVENUE-MONTH                                     
                  ,:S-THERM-PRICE                                       
                  ,:S-AGL-PASS-CHARGE                                   
                  ,:S-ESTMT-CONSUMPT                                    
                  ,:S-CSC-AMOUNT                                        
                  ,:S-CONNECT-CHG                                       
                  ,:S-OTHER-CHARGES                                     
                  ,:S-EST-METHOD-CD                                     
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04391_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_RETURN_CODE                                            
MFA-TR*            ,ESTMT_AMT                                                   
MFA-TR*            ,REV_MONTH                                                   
MFA-TR*            ,THERM_PRICE                                                 
MFA-TR*            ,AGL_PASS_CHARGE                                             
MFA-TR*            ,ESTMT_CONSUMPT                                              
MFA-TR*            ,CSC_AMT                                                     
MFA-TR*            ,CONNECT_CHG                                                 
MFA-TR*            ,OTHER_CHARGES                                               
MFA-TR*            ,EST_METHOD_CD                                               
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-ESTMT-AMOUNT                                              
MFA-TR*           ,:S-REVENUE-MONTH                                             
MFA-TR*           ,:S-THERM-PRICE                                               
MFA-TR*           ,:S-AGL-PASS-CHARGE                                           
MFA-TR*           ,:S-ESTMT-CONSUMPT                                            
MFA-TR*           ,:S-CSC-AMOUNT                                                
MFA-TR*           ,:S-CONNECT-CHG                                               
MFA-TR*           ,:S-OTHER-CHARGES                                             
MFA-TR*           ,:S-EST-METHOD-CD                                             
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS                
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8100'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04391_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU  9900-EXIT         
           END-IF.                                                      
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************26210000
      *  7600-START-FCSJC01                                            *26220000
      ******************************************************************26230000
      *                                                                 26240000
           EXEC SQL                                                     26250000
              INCLUDE CPDCA038                                          26260000
           END-EXEC.                                                    26270000
      *                                                                 26280000
      ******************************************************************        
      * 6000-PRP-ESTIMATE                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD04391                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************50520500
      *  9900-SQL-ERROR-ROUTINE.                                       *50520600
      ******************************************************************50520700
      *                                                                 50521200
           EXEC SQL                                                     50521200
               INCLUDE CPDSP300                                         50520900
           END-EXEC.                                                    50521000
      *                                                                 50521200
      ******************************************************************50520500
      *       END PROGRAM COPYLIB                                      *50520600
      ******************************************************************50520700
      *                                                                 50521200
           COPY CPD0023C.                                                       
      *                                                                 50521200
           EXEC SQL                                                     50520900
              INCLUDE CPD00320                                          50521000
           END-EXEC.                                                    50521100
      *                                                                 50521200
