       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04385.                                     
COB303 DATE-WRITTEN.  OCT 01,2010                                       
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00100000
      ******************************************************************00110000
      *                 P R O G R A M  S U M M A R Y                   *00120000
      *                                                                *00130000
      *  THIS PROGRAM RETURNS BBP BPA DATA.                            *00140000
      *  RESULT SETS:                                                  *00150000
      *         1. Budget Billing Plan Details                         *00160000
      *         2. Monthly Charges/Contracts                           *00170000
      *         3. Actual/Estimated Usage For Plan Duration            *00180000
      *         4. Remarks For Each Change Of Budget Billing Amount    *00190000
      *         5. Anniversary Opitons                                 *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
P00424*  10/01/10  AA97148    PROCEDURE ORIGINALLY CODED.              *00280000
A03300*  04/15/11  RC41079    CHANGE TO PARA 2221- TO MOVE BG-REV-MTH- *00290000
A03300*                       ORIG-BILL OR BG-REVENUE-MONTH TO S-REV-  *00300000
A03300*                       MTH INSTEAD OF BI-DATE-BILLED. SUM OF 00-*00310000
A03300**                      30-60-90 DAY = BBP-BILD-BAL-AMT WHICH IS *00320000
A03300**                      THEN SUBTRACTED TO COMPUTE S-BAL-AT-ANNIV*00330000
TASK01** 07/08/11  VV94890  1)CHANGE TO DISPLAY ANNIVERSARY OPTION/S   *00340000
      ** ****A03300******     LITERAL/S ACCORDINGLY.                   *00350000
TASK02*                     2)ADDED NEW COL BI-DATE-BILLED TO RES SET-3*00360000
A03925** 04/04/12  VV94890   ADDED NEW COL "NO OF DAYS" TO RESULT SET-3*00370000
P00694** 01/16/13  SV95326   REMOVE BUFFER VALUES FROM THIS PROCEDURE  *00380000
P00694**                     BECAUSE ALL BUFFER PART CALCULATION DID ON*00390000
P00694**                     CSR02322 CALLED PROGRAM.                  *00400000
P00694** 01/18/13  EM19682   ADDED CODE TO RETRIEVE EXEMPT FROM REVIEW *00410000
P00694**                     ON BBP ACCOUNTS.                          *00420000
P0694A** 02/05/13  VV94890   ADDED BBP FULL BALANCE TO RESULT SET-1.   *00430000
P0694B** 02/09/13  GOKUL     CHANGE LOGIC TO COMPUTE BBP-REMAINING-MTHS*00440000
ACT139** 08/29/13  VIJAY     FIX BBP-REMAINING-MTHS DISPLAY.           *00441000
ACT139** A04527              (USED PANEL CODE AS MODEL)                *00442000
ACT148** 09/13/13  VIJAY     MOVE BBP MONTHLY AMOUNT TO SUGGESTED BBP  *00443000
ACT148** A04527              AMOUNT WHEN REMAINING MONTHS ARE 12 AND   *00444000
ACT148**                     BBP AMOUNT = 0.                           *00445000
ACT169** 10/10/13  VIJAY     S0C7 ISSUE DUE TO MORE ROWS RETURNED FROM *00446001
ACT169** A04527              CSR02322(BILLED TWICE IN SAME REVENUE MON-*00447001
ACT169**                     TH).                                      *00448001
ACT099** 05/12/14  VIJAY     GET MAX(BG.NO_OF_CONS_DAYS)               *00448002
ACT099** A04880                                                        *00448003
ACT207** 06/18/14  VIJAY     FIX PRIVATE/SUB DIVISION LIGHTING CHARGES.*00448002
ACT207** A04880                                                        *00448003
ACT230** 07/30/14  VIJAY     FIX BBP-REMAINING-MTHS DISPLAY.WHEN ACCOUNT        
ACT230** A04880              IS IN PENDING STATUS NOT DISPLAY PROPERLY.*        
ACT237** 11/18/15  VIJAY     S0C7 ISSUE DUE TO MORE ROWS RETURNED FROM *00446001
ACT237** A05136              CSR02322.INCREASED WS-BBP-EST-TB TO 40.   *00447001
ACT237** 12/07/15  VIJAY     BACK OUT ACT237 CHANGES.                  *00446001
P00836** 11/25/15  VV7M728   ADDED BBP_TOTAL_CHRGS TO RS1.                      
ACT359** 11/23/16  VIJAY     S0C7 ISSUE DUE TO MORE ROWS RETURNED FROM *00446001
ACT359** A05460              CSR02322.                                 *00447001
ACT011** 01/19/17  VIJAY     RETURN ALL MONTHS PROPERLY. IT WAS RETUR- *00446001
ACT011** A05744              NING ONE MONTH LESS DATA.                 *00447001
      ******************************************************************00450000
      ******************************************************************00460000
      *                                                                *00470000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00480000
      *                                                                *00490000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00500000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00510000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00520000
      *  3000 - 4999  NOT USED                                         *00530000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00540000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00550000
      *  7000 - 7999  INPUT MODULES                                    *00560000
      *  8000 - 8999  OUTPUT MODULES                                   *00570000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00580000
      *                                                                *00590000
      ******************************************************************00600000
      *                                                                 00610000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00630000
       DATA DIVISION.                                                   
      *                                                                 00650000
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04385'.
MSQ017     COPY MFASQLM.
      *                                                                 00670000
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04385 STARTS HERE'.                 
      *                                                                 00700000
       01 WS-CONSTANTS.                                                 
      *                                                                 00720000
          05 WS-PPL-NSC              PIC S9(04) COMP VALUE +019.        
          05 WS-PPL-LPC              PIC S9(04) COMP VALUE +030.        
          05 WS-PPL-UTE              PIC S9(04) COMP VALUE +040.        
          05 WS-PPL-UTG              PIC S9(04) COMP VALUE +045.        
          05 WS-PPL-RCC              PIC S9(04) COMP VALUE +060.        
          05 WS-PPL-CIA              PIC S9(04) COMP VALUE +070.        
          05 WS-PPL-DEP              PIC S9(04) COMP VALUE +080.        
          05 WS-PPL-DFA              PIC S9(04) COMP VALUE +090.        
          05 WS-PPL-CNT              PIC S9(04) COMP VALUE +100.        
          05 WS-PPL-PJS              PIC S9(04) COMP VALUE +120.        
      *                                                                 00830000
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04385'.        
          05 WS-TWELVE               PIC S9(09) COMP VALUE 12.          
          05 WS-OPTION-DESC-1        PIC X(30) VALUE                    
                                     'If Paid Account Billed Balance'.  
          05 WS-OPTION-DESC-2        PIC X(29) VALUE                    
                                     'If Paid Account Total Balance'.   
TASK01    05 WS-OPTION-DESC-3        PIC X(32) VALUE                    
TASK01                               'If Paid Account Bal with BBP Amt'.
          05 WS-EST-BBP-AMT-TX       PIC X(24) VALUE                    
                                     'Estimated New BBP Amount'.        
          05 WS-ACT-ACCT-BAL-TX      PIC X(22) VALUE                    
                                     'Actual Account Balance'.          
          05 WS-ACCT-BAL-BBP-TX      PIC X(24) VALUE                    
                                     'Account Bal with BBP Amt'.        
      *                                                                 00990000
       01 WS-FLAGS.                                                     
          05 WS-1ST-TIME             PIC X(01) VALUE 'Y'.               
          05 WS-CRE-GTT-R1           PIC X(01) VALUE 'N'.               
          05 WS-CRE-GTT-R2           PIC X(01) VALUE 'N'.               
          05 WS-CRE-GTT-R3           PIC X(01) VALUE 'N'.               
          05 WS-CRE-GTT-R4           PIC X(01) VALUE 'N'.               
          05 WS-CRE-GTT-R5           PIC X(01) VALUE 'N'.               
P00694    05 WS-CRE-GTT-R6           PIC X(01) VALUE 'N'.               
          05 WS-ERR-INSRT-R1         PIC X(01) VALUE 'N'.               
          05 WS-ERR-INSRT-R2         PIC X(01) VALUE 'N'.               
          05 WS-ERR-INSRT-R3         PIC X(01) VALUE 'N'.               
          05 WS-ERR-INSRT-R4         PIC X(01) VALUE 'N'.               
          05 WS-ERR-INSRT-R5         PIC X(01) VALUE 'N'.               
          05 WS-ERR-INSRT-R6         PIC X(01) VALUE 'N'.               
          05 WS-INCR-YEAR            PIC X(01) VALUE 'N'.               
          05 WS-STR-TYPE             PIC X(01) VALUE SPACES.            
          05 WS-PREV-CHAR            PIC X(01) VALUE SPACES.            
P00694    05 WS-EXEMPT-REVIEW        PIC X(01) VALUE 'N'.               
      *                                                                 01180000
       01 WS-MISC.                                                      
          05 WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                     PIC 9(13).                         
          05 WS-PREMISE-NO           PIC X(10) VALUE SPACES.            
          05 WS-PREMISE-NUM REDEFINES WS-PREMISE-NO                     
                                     PIC 9(10).                         
          05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.            
          05 WS-REV-MNTH-DT          PIC X(10) VALUE SPACES.            
          05 WS-REV-MNTH-C           PIC 9(06).                         
ACT139    05 WS-ANNIVERSARY-DATE.                                       
ACT139       10 WS-ANNIVERSARY-DATE-YR  PIC 9(04).                      
ACT139       10 WS-ANNIVERSARY-DATE-MM  PIC 9(02).                      
COB305    05 WS-REV-MTH-LST-NRML        PIC S9(6) COMP-3 VALUE 0.           
ACT139    05 WS-REV-MTH-LST-NRML-NUM    PIC 9(06).                      
ACT139    05 WS-REV-MTH-LST-NRML-YM.                                    
ACT139       10 WS-REV-MTH-LST-NRML-YR  PIC 9(04).                      
ACT139       10 WS-REV-MTH-LST-NRML-MM  PIC 9(02).                      
ACT139    05 WS-REV-MTH-LST-NRML-NULL   PIC S9(4)     COMP.             
A03300    05 WS-REV-MNTH-2           PIC 9(06).                         
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-GTT-NAME             PIC X(19) VALUE SPACES.            
          05 WS-FROM-REV-MTH         PIC S9(06)V COMP-3 VALUE +0.       
          05 WS-TO-REV-MTH           PIC S9(06)V COMP-3 VALUE +0.       
          05 WS-OLD-TRAN-TS          PIC X(26) VALUE SPACES.            
          05 WS-NEW-TRAN-TS          PIC X(26) VALUE SPACES.            
          05 WS-PREV-YEAR            PIC X(04) VALUE SPACES.            
          05 WS-PREV-BILD-BBP-AM     PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-BBP-DEC-AMT          PIC 9(09).9(02).                   
          05 WS-PVT-LGHT-TOT         PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-SUB-LGHT-TOT         PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-UNMTRD-AMT-MO-PYMT   PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-MAX-RECV-AMT         PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-BBP-CUR-BAL-AMT      PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-BBP-BILD-BAL-AMT     PIC S9(09)V99 COMP-3 VALUE +0.     
A03300    05 WS-TOT-00-30-60-90      PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-EST-MTHLY-DIFF       PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-AMT-MO-PYMT-RND      PIC S9(11)    COMP-3 VALUE +0.     
          05 WS-UTIL-CHGS-TOT        PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-CUR-BILD-BBP-AM      PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-CIA-AMT              PIC S9(09)V99 COMP-3 VALUE +0.     
          05 WS-BBP-CUR-BAL-ED       PIC -Z(8)9.9(02).                  
          05 WS-EST-MTHLY-DIFF-ED    PIC -Z(8)9.9(02).                  
          05 WS-BAL-AT-ANNIV-ED      PIC -Z(8)9.9(02).                  
          05 WS-BBP-BILD-BAL-ED      PIC -Z(8)9.9(02).                  
          05 WS-BBP-BILD-AMT-ED      PIC -Z(8)9.9(02).                  
          05 WS-BBP-AMT-ED           PIC -Z(8)9.9(02).                  
          05 WS-CIA-AMT-ED           PIC  Z(8)9.9(02).                  
A03925    05 WS-NO-DAYS              PIC S9(04)    COMP VALUE 0.        
P00694    05 WS-REVENUE-MONTH        PIC X(10) VALUE SPACES.            
      *                                                                 01600000
          05 WS-02322-CALL-AREA.                                        
             10 WS-02322-APPL-ID     PIC X(08) VALUE SPACES.            
             10 WS-02322-PREMISE     PIC X(10) VALUE SPACES.            
             10 WS-02322-TO-DATE     PIC X(10) VALUE SPACES.            
             10 WS-02322-FROM-REV-MTH                                   
                                     PIC X(06) VALUE SPACES.            
      *                                                                 01670000
          05 WS-REV-MNTH-DT-1.                                          
             10 WS-YEAR-CHAR         PIC X(04) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-MONTH-CHAR        PIC X(02) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-DATE-CHAR         PIC X(02) VALUE '01'.              
      *                                                                 01740000
          05 WS-REV-MNTH-DT-2.                                          
             10 WS-YEAR-2            PIC X(04) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-MONTH-2           PIC X(02) VALUE SPACES.            
             10 FILLER               PIC X(01) VALUE '-'.               
             10 WS-DAY-2             PIC X(02) VALUE '01'.              
      *                                                                 01810000
          05 WS-REV-MNTH-NUM.                                           
             10 WS-YEAR-NUM          PIC 9(04) VALUE 0.                 
             10 WS-MONTH-NUM         PIC 9(02) VALUE 0.                 
      *                                                                 01850000
          05 WS-PREV-BILD-TS.                                           
             10 WS-PREV-BILD-DT-TRAN PIC X(10) VALUE SPACES.            
             10 FILLER               PIC X(16) VALUE                    
                                               '-00.00.00.000000'.      
          05 WS-REMARKS-TEXT.                                           
             10 WS-REMARKS-TXT       OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-1.               
                15 WS-REMARKS-CHAR   PIC X(01).                         
      *                                                                 01940000
          05 WS-RESULT-TEXT.                                            
             10 WS-RESULT            OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-2.               
                15 WS-RESULT-CHAR    PIC X(01).                         
      *                                                                 01990000
          05 WS-CUR-BILD-TS.                                            
             10 WS-CUR-BILD-DT-TRAN  PIC X(10) VALUE SPACES.            
             10 FILLER               PIC X(16) VALUE                    
                                               '-23.59.59.999999'.      
      *                                                                 02040000
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-DET              PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-CHGS             PIC S9(09) COMP VALUE 0.           
          05 WS-UTIL-CHGS            PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-HIST             PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-ANNIV            PIC S9(09) COMP VALUE 0.           
          05 WS-BBP-CNSMPT           PIC S9(09) COMP VALUE 0.           
          05 WS-SUB1                 PIC S9(09) COMP VALUE 0.           
          05 WS-SUB2                 PIC S9(09) COMP VALUE 0.           
          05 WS-EST-SUB              PIC S9(04) COMP VALUE 0.           
P0694B    05 WS-BBP-TERM             PIC S9(09) COMP VALUE 0.           
          05 WS-ACT-COUNT            PIC S9(09) COMP VALUE 0.           
          05 WS-EST-COUNT            PIC S9(09) COMP VALUE 0.           
P00694    05 WS-ACCT-WNT-SUM-USE-ELEC PIC 9(04) VALUE 0.                
P00694    05 WS-ACCT-WNT-SUM-USE-GAS PIC 9(04) VALUE 0.                 
      *                                                                 02210000
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.               
             88 SEND-DONE-ERROR                VALUE 'N'.               
             88 SEND-DONE-OK                   VALUE 'Y'.               
          05 BILLED-SW               PIC X(01) VALUE ' '.               
             88 ADJ-AMT-BILD                   VALUE 'Y'.               
             88 ADJ-AMT-NOT-BILD               VALUE 'N'.               
          05 WS-EOF-CURSOR           PIC X(01) VALUE 'N'.               
             88 NO-MORE-DATA                   VALUE 'Y'.               
          05 WS-CURSOR-SW            PIC X(01) VALUE 'N'.               
             88 NO-MORE-ROWS                   VALUE 'Y'.               
          05 WS-RESULT-TYPE          PIC 9(01) VALUE ZERO.              
             88 WS-PLAN-DET                    VALUE 1.                 
             88 WS-MTHLY-CHGS                  VALUE 2.                 
             88 WS-USAGE                       VALUE 3.                 
             88 WS-REMARKS                     VALUE 4.                 
             88 WS-ANNIV                       VALUE 5.                 
P00694       88 WS-CNSMPT                      VALUE 6.                 
      *                                                                 02400000
          05 WS-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.           
          05 WS-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.           
          05 WS-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.           
          05 WS-RETURN-CODE-4        PIC S9(04) COMP VALUE 0.           
          05 WS-RETURN-CODE-5        PIC S9(04) COMP VALUE 0.           
          05 WS-RETURN-CODE-6        PIC S9(04) COMP VALUE 0.           
      *                                                                 02470000
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE           PIC S9(04)    COMP VALUE 0.        
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1      PIC S9(04)    COMP VALUE 0.        
             10 S-APPL-RETURN-CODE-1 PIC X(06)     VALUE SPACES.        
             10 S-ANIVERSARY-DATE    PIC X(10)     VALUE SPACES.        
             10 S-START-DATE         PIC X(10)     VALUE SPACES.        
             10 S-MTHLY-CNT-TOT-AMT  PIC S9(09)V99 COMP-3 VALUE +0.     
             10 S-BBP-MNTHS-REMAIN   PIC S9(04)    COMP VALUE 0.        
             10 S-BBP-NEW-SUGG-AMT   PIC S9(09)V99 COMP-3 VALUE +0.     
             10 S-BAL-AT-ANNIV       PIC S9(09)V99 COMP-3 VALUE +0.     
P00836       10 S-BBP-TOTAL-CHRGS    PIC S9(09)V99 COMP-3 VALUE 0.      
             10 S-BAL-REMARKS        PIC X(210)    VALUE SPACES.        
      * 'P'-Premise/'C'-Customer's Consumption                          02600000
             10 S-CNSMPTN-USED       PIC X(01)     VALUE 'C'.           
P00694       10 S-EXEMPT-REVIEW      PIC X(01)     VALUE 'N'.           
P0694A       10 S-BBP-CUR-BAL-AMT    PIC S9(09)V99 COMP-3 VALUE +0.     
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2      PIC S9(04)    COMP VALUE 0.        
             10 S-CNT-NAME-DESC      PIC X(30)     VALUE SPACES.        
             10 S-CNT-AMT-MO-PYMT    PIC S9(09)V99 COMP-3 VALUE +0.     
             10 S-CNT-PYMTS-REMAIN   PIC S9(09)    COMP VALUE 0.        
             10 S-CNT-EXPIRY-DT      PIC X(10)     VALUE SPACES.        
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3      PIC S9(04)    COMP VALUE 0.        
             10 S-REV-MONTH          PIC X(10)     VALUE SPACES.        
A03925       10 S-NO-OF-DAYS         PIC S9(04)    COMP VALUE 0.        
             10 S-UTIL-CHRG-AMT      PIC S9(09)V99 COMP-3 VALUE +0.     
             10 S-BBP-AMT            PIC S9(09)V99 COMP-3 VALUE +0.     
      * 'A'-Actual/'E'-Estimated for current plan year                  02760000
             10 S-USAGE-TYPE         PIC X(01)     VALUE SPACES.        
TASK02       10 S-DATE-BILLED        PIC X(10)     VALUE SPACES.        
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4      PIC S9(04)    COMP VALUE 0.        
             10 S-REV-MNTH           PIC X(10)     VALUE SPACES.        
             10 S-ADJUSTMENT-DATE    PIC X(10)     VALUE SPACES.        
             10 S-ADJUSTMENT-AMT     PIC S9(09)V99 COMP-3 VALUE +0.     
             10 S-REMARKS-TEXT       PIC X(210)    VALUE SPACES.        
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5      PIC S9(04)    COMP VALUE +0.       
             10 S-OPTION-SEQ-NO      PIC X(01)     VALUE SPACES.        
             10 S-OPTION-DESC        PIC X(60)     VALUE SPACES.        
             10 S-AMT-BALANCE-DUE-TX PIC X(60)     VALUE SPACES.        
             10 S-AMT-BALANCE-DUE    PIC S9(9)V99  COMP-3 VALUE +0.     
             10 S-EST-BBP-AMT-TX     PIC X(60)     VALUE SPACES.        
             10 S-EST-BBP-AMT        PIC S9(9)V99  COMP-3 VALUE +0.     
      *                                                                 02930000
          05 GTT-RETURN-FIELDS-6.                                       
P00694       10 S-RETURN-CODE-6      PIC S9(9)     COMP VALUE 0.        
             10 S-REVENUE-MONTH      PIC X(10)     VALUE SPACES.        
             10 S-DAYS               PIC S9(4)     COMP VALUE 0.        
             10 S-UNITS              PIC S9(9)     COMP-3 VALUE 0.      
             10 S-CODE-UTIL-TYPE     PIC X(01)     VALUE SPACES.        
             10 S-CUSTOMER-NO        PIC S9(10)    COMP-3 VALUE 0.      
             10 S-NEW-CHARGE         PIC S9(9)V99  COMP-3 VALUE 0.      
             10 S-RATE-PLAN-NO       PIC X(03)     VALUE SPACES.        
             10 S-CALC-ERROR         PIC X(08)     VALUE SPACES.        
             10 S-HTG-CLG-SW         PIC S9(03)    COMP-3 VALUE 0.      
             10 S-BPP-CATEGORY       PIC X(01)     VALUE SPACES.        
P00694       10 S-ELEC-BUFFER        PIC S9(4)V9(5)                     
P00694                                             COMP-3 VALUE 0.      
P00694       10 S-GAS-BUFFER         PIC S9(4)V9(5)                     
P00694                                             COMP-3 VALUE 0.      
      *                                                                 03100000
       01 WS-HOLD-AREA.                                                 
          05 WS-HOLD-ROWS.                                              
             10 FILLER               PIC X(10)     VALUE SPACES.        
             10 FILLER               PIC S9(09)V99 COMP-3 VALUE 0.      
             10 FILLER               PIC X(01)     VALUE SPACES.        
A03925       10 FILLER               PIC S9(04)    COMP VALUE 0.        
      *                                                                 03170000
       01 WS-BBP-USAGE.                                                 
ACT169    05 WS-BBP-EST-TB  OCCURS 29 TIMES.                            
             10 WS-REV-MNTH-EST      PIC X(10)     VALUE SPACES.        
             10 WS-NEW-CHG-EST       PIC S9(09)V99 COMP-3 VALUE 0.      
             10 WS-CD-UTIL-TYP-EST   PIC X(01)     VALUE SPACES.        
A03925       10 WS-NO-OF-DAYS        PIC S9(04)    COMP VALUE 0.        
      *                                                                 03240000
      ******************************************************************03250000
      *               COBOL WORKING STORAGE COPY BOOKS                 *03260000
      ******************************************************************03270000
      *                                                                 03280000
      ******************************************************************03290000
      *    ERROR HANDLING                                               03300000
      ******************************************************************03310000
      *                                                                 03320000
           EXEC SQL                                                     03330000
              INCLUDE CWSX0010                                          03340000
           END-EXEC.                                                    03350000
      *                                                                 03360000
P00836******************************************************************        
P00836*    WORKING STORAGE FOR BBP CHARGES                             *        
P00836******************************************************************        
P00836*                                                                         
P00836     EXEC SQL                                                             
P00836         INCLUDE CWS00168                                                 
P00836     END-EXEC.                                                            
P00836*                                                                         
      ******************************************************************03370000
      *    CODES-DATA-PRESENT LAYOUT                                   *03380000
      ******************************************************************03390000
      *                                                                 03400000
           COPY CWS00056.                                               03410000
                                                                        
      *                                                                 03430000
      ******************************************************************03440000
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *03450000
      ******************************************************************03460000
      *                                                                 03470000
           COPY CWS00303.                                               03480000
                                                                        
      *                                                                 03500000
      ******************************************************************03510000
      *   SQL COMMUNICATION AREA                                       *03520000
      ******************************************************************03530000
      *                                                                 03540000
           EXEC SQL                                                     03550000
               INCLUDE SQLCA                                            03560000
           END-EXEC.                                                    03570000
      *                                                                 03580000
      ******************************************************************03590000
      *    CSS_ACCOUNT  - AT                                           *03600000
      ******************************************************************03610000
      *                                                                 03620000
           EXEC SQL                                                     03630000
                INCLUDE TBACCT                                          03640000
           END-EXEC.                                                    03650000
      *                                                                 03660000
      ******************************************************************03670000
      *    CSS_AR_CNTL  - AC                                           *03680000
      ******************************************************************03690000
      *                                                                 03700000
           EXEC SQL                                                     03710000
               INCLUDE TBARCNTL                                         03720000
           END-EXEC.                                                    03730000
      *                                                                 03740000
      ******************************************************************03750000
      *    CSS_AR_TRANS_HIST  - AR                                     *03760000
      ******************************************************************03770000
      *                                                                 03780000
           EXEC SQL                                                     03790000
               INCLUDE TBARHIST                                         03800000
           END-EXEC.                                                    03810000
      *                                                                 03820000
      ******************************************************************03830000
      *    CSS_AR_TRN_HST_DET - AU                                     *03840000
      ******************************************************************03850000
      *                                                                 03860000
           EXEC SQL                                                     03870000
               INCLUDE TBARHDT                                          03880000
           END-EXEC.                                                    03890000
      *                                                                 03900000
      ******************************************************************03910000
      *    CSS_AR_TYPE  - L5                                           *03920000
      ******************************************************************03930000
      *                                                                 03940000
           EXEC SQL                                                     03950000
               INCLUDE TBARTYPE                                         03960000
           END-EXEC.                                                    03970000
      *                                                                 03980000
      ******************************************************************03990000
      *    CSS_BILL_WINDOW - BN                                        *04000000
      ******************************************************************04010000
      *                                                                 04020000
           EXEC SQL                                                     04030000
               INCLUDE TBBILWDW                                         04040000
           END-EXEC.                                                    04050000
      *                                                                 04060000
      ******************************************************************04070000
      *    CSS_BILLING_HDR - BI                                        *04080000
      ******************************************************************04090000
      *                                                                 04100000
           EXEC SQL                                                     04110000
              INCLUDE TBBLLHDR                                          04120000
           END-EXEC.                                                    04130000
      *                                                                 04140000
      ******************************************************************04150000
      *    CSS_BILLING_DET - BG                                        *04160000
      ******************************************************************04170000
      *                                                                 04180000
           EXEC SQL                                                     04190000
              INCLUDE TBBLLDET                                          04200000
           END-EXEC.                                                    04210000
      *                                                                 04220000
      *                                                                 04230000
      ******************************************************************04240000
      *    CSS_BUDGET_HIST - BH                                        *04250000
      ******************************************************************04260000
      *                                                                 04270000
           EXEC SQL                                                     04280000
               INCLUDE TBBGTHST                                         04290000
           END-EXEC.                                                    04300000
      *                                                                 04310000
      ******************************************************************04320000
      *    CSS_BUDGET_PLAN - BU                                        *04330000
      ******************************************************************04340000
      *                                                                 04350000
           EXEC SQL                                                     04360000
               INCLUDE TBBGTPLN                                         04370000
           END-EXEC.                                                    04380000
      *                                                                 04390000
      ******************************************************************04400000
      *    CSS_CONTRACT - CT                                           *04410000
      ******************************************************************04420000
      *                                                                 04430000
           EXEC SQL                                                     04440000
               INCLUDE TBCNTRCT                                         04450000
           END-EXEC.                                                    04460000
      *                                                                 04470000
      ******************************************************************04480000
      *    CSS_CONTRACT_INFO - K6                                      *04490000
      ******************************************************************04500000
      *                                                                 04510000
           EXEC SQL                                                     04520000
               INCLUDE TBCNTINF                                         04530000
           END-EXEC.                                                    04540000
      *                                                                 04550000
      ******************************************************************04560000
      *    CSS_DEP_REQ - DR                                            *04570000
      ******************************************************************04580000
      *                                                                 04590000
           EXEC SQL                                                     04600000
               INCLUDE TBDEPREQ                                         04610000
           END-EXEC.                                                    04620000
      *                                                                 04630000
      ******************************************************************04640000
      *    CSS_DFA_ACCT - DA                                            04650000
      ******************************************************************04660000
      *                                                                 04670000
           EXEC SQL                                                     04680000
               INCLUDE TBDFAACT                                         04690000
           END-EXEC.                                                    04700000
      *                                                                 04710000
      ******************************************************************04720000
      *    CSS_PROJ_SHARE - PJ                                         *04730000
      ******************************************************************04740000
      *                                                                 04750000
           EXEC SQL                                                     04760000
                INCLUDE TBPRJSHR                                        04770000
           END-EXEC.                                                    04780000
      *                                                                 04790000
      ******************************************************************04800000
      *   CSS_ACCT_ATTRIBUTE - YP                                      *04810000
      ******************************************************************04820000
      *                                                                 04830000
P00694     EXEC SQL                                                     04840000
P00694        INCLUDE TBACTATT                                          04850000
P00694     END-EXEC.                                                    04860000
P00694*                                                                 04870000
P00836******************************************************************        
P00836*    CSS_DELINQUENCY - C8                                        *        
P00836******************************************************************        
P00836*                                                                         
P00836     EXEC SQL                                                             
P00836        INCLUDE TBDELQ                                                    
P00836     END-EXEC.                                                            
P00836*                                                                         
P00836******************************************************************        
P00836*    CSS_UTL_ENVRMNT - UT                                        *        
P00836******************************************************************        
P00836*                                                                         
P00836     EXEC SQL                                                             
P00836        INCLUDE TBUTLENV                                                  
P00836     END-EXEC.                                                            
P00836*                                                                         
P00836******************************************************************        
P00836*    CSS_GL_ACCT_NO GL                                           *        
P00836******************************************************************        
P00836*                                                                         
P00836     EXEC SQL                                                             
P00836        INCLUDE TBGLATNO                                                  
P00836     END-EXEC.                                                            
P00836*                                                                         
P00836******************************************************************        
P00836*    WORKING STORAGE FOR GL ACCOUNT                              *        
P00836******************************************************************        
P00836*                                                                         
P00836     COPY CWS00096.                                                       
P00836*                                                                         
P00836******************************************************************        
P00836*    CURSOR FOR BBP CHARGES                                      *        
P00836******************************************************************        
P00836*                                                                         
P00836     EXEC SQL                                                             
P00836         INCLUDE CWS0168A                                                 
P00836     END-EXEC.                                                            
      *                                                                         
      ******************************************************************04880000
      *    DECLARE CURSOR TO GET ALL RECEIVABLES                       *04890000
      ******************************************************************04900000
      *                                                                 04910000
           EXEC SQL                                                     
              DECLARE AR_CURSOR CURSOR FOR                              
                 SELECT                                                 
                        AC.AMT_AR_DAY_00                                
                       ,AC.AMT_AR_DAY_30                                
                       ,AC.AMT_AR_DAY_60                                
                       ,AC.AMT_AR_DAY_90                                
                       ,AC.AMT_UNUSED_CR                                
                       ,AC.AMT_TRAN_BALANCE                             
                       ,AC.TOT_SUMM_UNBILLED                            
                       ,AC.PYMT_PRIORITY_LVL                            
                       ,L5.AR_TYPE_LONG_DESC                            
                       ,AC.ITEM_ID                                      
                   FROM                                                 
                        CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                   
                       ,CSS_AR_TYPE  L5 WITH(READUNCOMMITTED)                   
                  WHERE                                                 
                        AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           
                    AND AC.PYMT_PRIORITY_LVL = L5.PYMT_PRIORITY_LVL     
                    AND AC.PYMT_PRIORITY_LVL IN (50,70,80,90,100,129)   
                    AND AC.ITEM_ID           > 0                        
                  ORDER BY  PYMT_PRIORITY_LVL ASC                       
                           ,ITEM_ID DESC                                
              FOR READ ONLY                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04920000
MFA-TR*       DECLARE AR_CURSOR CURSOR FOR                              04930000
MFA-TR*          SELECT                                                 04940000
MFA-TR*                 AC.AMT_AR_DAY_00                                04950000
MFA-TR*                ,AC.AMT_AR_DAY_30                                04960000
MFA-TR*                ,AC.AMT_AR_DAY_60                                04970000
MFA-TR*                ,AC.AMT_AR_DAY_90                                04980000
MFA-TR*                ,AC.AMT_UNUSED_CR                                04990000
MFA-TR*                ,AC.AMT_TRAN_BALANCE                             05000000
MFA-TR*                ,AC.TOT_SUMM_UNBILLED                            05010000
MFA-TR*                ,AC.PYMT_PRIORITY_LVL                            05020000
MFA-TR*                ,L5.AR_TYPE_LONG_DESC                            05030000
MFA-TR*                ,AC.ITEM_ID                                      05040000
MFA-TR*            FROM                                                 05050000
MFA-TR*                 CSS_AR_CNTL  AC                                 05060000
MFA-TR*                ,CSS_AR_TYPE  L5                                 05070000
MFA-TR*           WHERE                                                 05080000
MFA-TR*                 AC.ACCOUNT_NO        = :AC-ACCOUNT-NO           05090000
MFA-TR*             AND AC.PYMT_PRIORITY_LVL = L5.PYMT_PRIORITY_LVL     05100000
MFA-TR*             AND AC.PYMT_PRIORITY_LVL IN (50,70,80,90,100,129)   05110000
MFA-TR*             AND AC.ITEM_ID           > 0                        05120000
MFA-TR*           ORDER BY  PYMT_PRIORITY_LVL ASC                       05130000
MFA-TR*                    ,ITEM_ID DESC                                05140000
MFA-TR*       FOR FETCH ONLY                                            05150000
MFA-TR*            WITH UR                                              05160000
MFA-TR*         QUERYNO 7200                                            05170000
MFA-TR*    END-EXEC.                                                    05180000
      *                                                                 05190000
      ******************************************************************05200000
      *    DECLARE CURSOR TO GET ALL THE ADJUSTED BBP AMOUNTS.         *05210000
      ******************************************************************05220000
      *                                                                 05230000
           EXEC SQL                                                     
              DECLARE BBP_HIST CURSOR FOR                               
                 SELECT                                                 
                        CAST(BH.BUD_HIST_SEQ_NO AS DATE)                        
                       ,BH.AMT_MO_PYMT                                  
                       ,BH.REMARKS                                      
                   FROM                                                 
                        CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                
                  WHERE                                                 
                        BH.ACCOUNT_NO      = :BH-ACCOUNT-NO             
                    AND BH.BUD_HIST_SEQ_NO BETWEEN                      
                          CIS.CHAR2TIMESTAMP(:WS-OLD-TRAN-TS) AND 
              CIS.CHAR2TIMESTAMP(:WS-NEW-TRAN-TS)           
                    AND BH.CHANGE_REASON   IN ('M','C')                 
                    AND BH.AMT_MO_PYMT     <> :WS-PREV-BILD-BBP-AM      
                  ORDER BY BH.BUD_HIST_SEQ_NO ASC                       
              FOR READ ONLY                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05240000
MFA-TR*       DECLARE BBP_HIST CURSOR FOR                               05250000
MFA-TR*          SELECT                                                 05260000
MFA-TR*                 DATE(BH.BUD_HIST_SEQ_NO)                        05270000
MFA-TR*                ,BH.AMT_MO_PYMT                                  05280000
MFA-TR*                ,BH.REMARKS                                      05290000
MFA-TR*            FROM                                                 05300000
MFA-TR*                 CSS_BUDGET_HIST BH                              05310000
MFA-TR*           WHERE                                                 05320000
MFA-TR*                 BH.ACCOUNT_NO      = :BH-ACCOUNT-NO             05330000
MFA-TR*             AND BH.BUD_HIST_SEQ_NO BETWEEN                      05340000
MFA-TR*                   :WS-OLD-TRAN-TS AND :WS-NEW-TRAN-TS           05350000
MFA-TR*             AND BH.CHANGE_REASON   IN ('M','C')                 05360000
MFA-TR*             AND BH.AMT_MO_PYMT     <> :WS-PREV-BILD-BBP-AM      05370000
MFA-TR*           ORDER BY BH.BUD_HIST_SEQ_NO ASC                       05380000
MFA-TR*       FOR FETCH ONLY                                            05390000
MFA-TR*            WITH UR                                              05400000
MFA-TR*         QUERYNO 7500                                            05410000
MFA-TR*    END-EXEC.                                                    05420000
      *                                                                 05430000
      ******************************************************************05440000
      *    DECLARE CURSOR TO GET ACTUAL BILL AMOUNTS.                  *05450000
      ******************************************************************05460000
      *                                                                 05470000
           EXEC SQL                                                     
              DECLARE ACT_BILL CURSOR FOR                               
                 SELECT                                                 
                        COALESCE(SUM(BG.AMT_BILL_ITEM),0)               
                       ,BI.DATE_BILLED                                  
                       ,BG.REVENUE_MONTH                                
                       ,BG.REV_MTH_ORIG_BILL                            
ACT099                 ,MAX(BG.NO_OF_CONS_DAYS)                         
                   FROM                                                 
                        CSS_BILLING_HDR BI WITH(READUNCOMMITTED),               
                        CSS_BILLING_DET BG WITH(READUNCOMMITTED)                
                  WHERE                                                 
                        BG.ACCOUNT_NO           = :BG-ACCOUNT-NO        
                    AND BI.ACCOUNT_NO           = :BI-ACCOUNT-NO        
                    AND BI.BILL_NO              = BG.BILL_NO            
                    AND BI.DATE_BILLED          IS NOT NULL             
                    AND BG.CODE_BILL_ITM_TYPE   = 'C'                   
                    AND BG.CODE_BILL_ITM_IND    = 'A'                   
                    AND BG.CODE_BILL_CALC       = 'A'                   
                    AND ((BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MTH 
                        AND :WS-TO-REV-MTH )                            
                         OR (BG.REV_MTH_ORIG_BILL = 0 AND               
                            BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MTH   
                        AND :WS-TO-REV-MTH ))                           
                  GROUP BY BI.DATE_BILLED                               
                          ,BG.REVENUE_MONTH                             
                          ,BG.REV_MTH_ORIG_BILL                         
              FOR READ ONLY                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05480000
MFA-TR*       DECLARE ACT_BILL CURSOR FOR                               05490000
MFA-TR*          SELECT                                                 05500000
MFA-TR*                 COALESCE(SUM(BG.AMT_BILL_ITEM),0)               05510000
MFA-TR*                ,BI.DATE_BILLED                                  05520000
MFA-TR*                ,BG.REVENUE_MONTH                                05530000
MFA-TR*                ,BG.REV_MTH_ORIG_BILL                            05540000
MFA-TR*                ,MAX(BG.NO_OF_CONS_DAYS)                         05550000
MFA-TR*            FROM                                                 05560000
MFA-TR*                 CSS_BILLING_HDR BI,                             05570000
MFA-TR*                 CSS_BILLING_DET BG                              05580000
MFA-TR*           WHERE                                                 05590000
MFA-TR*                 BG.ACCOUNT_NO           = :BG-ACCOUNT-NO        05600000
MFA-TR*             AND BI.ACCOUNT_NO           = :BI-ACCOUNT-NO        05610000
MFA-TR*             AND BI.BILL_NO              = BG.BILL_NO            05620000
MFA-TR*             AND BI.DATE_BILLED          IS NOT NULL             05630000
MFA-TR*             AND BG.CODE_BILL_ITM_TYPE   = 'C'                   05640000
MFA-TR*             AND BG.CODE_BILL_ITM_IND    = 'A'                   05650000
MFA-TR*             AND BG.CODE_BILL_CALC       = 'A'                   05660000
MFA-TR*             AND ((BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MTH 05670000
MFA-TR*                 AND :WS-TO-REV-MTH )                            05680000
MFA-TR*                  OR (BG.REV_MTH_ORIG_BILL = 0 AND               05690000
MFA-TR*                     BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MTH   05700000
MFA-TR*                 AND :WS-TO-REV-MTH ))                           05710000
MFA-TR*           GROUP BY BI.DATE_BILLED                               05720000
MFA-TR*                   ,BG.REVENUE_MONTH                             05730000
MFA-TR*                   ,BG.REV_MTH_ORIG_BILL                         05740000
MFA-TR*       FOR FETCH ONLY                                            05760000
MFA-TR*            WITH UR                                              05770000
MFA-TR*         QUERYNO 7700                                            05780000
MFA-TR*    END-EXEC.                                                    05790000
      *                                                                 05800000
      *01 LOC-RESLTSET USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.    
MSQ001        EXEC SQL
MSQ001          DECLARE USER_CUR CURSOR
MSQ001          FOR CALL CSR02322( :WS-02322-APPL-ID
                  , :WS-02322-PREMISE
                  , :WS-02322-TO-DATE
                  , :WS-02322-FROM-REV-MTH
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE CNSMPT_CUR CURSOR
MSQ001          FOR CALL CSR02322( ' '
                  , :WS-02322-PREMISE
                  , :WS-02322-TO-DATE
                  , ' '
                  )
MSQ001        END-EXEC.
    
      *                                                                 05820000
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC  X(13).                    
       01  PARM-APPL-PROGRAM-ID          PIC  X(03).                    
      *                                                                 05850000
       PROCEDURE DIVISION USING   PARM-ACCOUNT-NO                       
                                 ,PARM-APPL-PROGRAM-ID.                 
      *                                                                 05870000
      ******************************************************************05880000
      * 0000-MAINLINE                                                  *05890000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *05900000
      ******************************************************************05910000
      *                                                                 05920000
       0000-MAINLINE.                                                   
      *                                                                 05940000
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                 05990000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06020000
      ******************************************************************06030000
      * 0100-INITIALIZE                                                *06040000
      ******************************************************************06050000
      *                                                                 06060000
       0100-INITIALIZE.                                                 
      *                                                                 06080000
           PERFORM 7000-GET-CUR-DATE        THRU 7000-EXIT.             
      *                                                                 06100000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06130000
      ******************************************************************06140000
      * 0100A-DECLARE-GTT-R1                                           *06150000
      ******************************************************************06160000
      *                                                                 06170000
       0100A-DECLARE-GTT-R1.                                            
      *                                                                 06190000
           MOVE 'SESSION.CSR04385_R1'       TO WS-GTT-NAME.             
           SET  WS-PLAN-DET                 TO TRUE.                    
      *                                                                 06220000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04385_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04385_R1
              (                                                       
                    RETURN_CODE          INT                        
                   ,APPL_RETURN_CODE CHAR(06)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ANNIVERSARY_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,MTHLY_CNT_TOT_AMT    DECIMAL(11,2)                  
                   ,BBP_NO_MNTHS_LEFT    INT                        
                   ,BBP_NEW_SUG_AMT      DECIMAL(11,2)                  
                   ,BAL_AT_ANNIV         DECIMAL(11,2)                  
                   ,BAL_REMARKS CHAR(210)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                   ,CNSMPTN_USED CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,EXEMPT_REVIEW CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P0694A             ,BBP_CUR_BAL_AMT      DECIMAL(11,2)                  
P00836             ,BBP_TOTAL_CHRGS      DECIMAL(11,2)                  
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06410000
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                 06450000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 06650000
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04385_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     06660000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            06670000
MFA-TR*                          WITH ROWSET POSITIONING FOR            06680000
MFA-TR*        SELECT                                                   06690000
MFA-TR*           *                                                     06700000
MFA-TR*        FROM                                                     06710000
MFA-TR*            SESSION.CSR04385_R1                                  06720000
MFA-TR*    END-EXEC.                                                    06730000
      *                                                                 06740000
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 06770000
      ******************************************************************06780000
      * 0100B-DECLARE-GTT-R2                                           *06790000
      ******************************************************************06800000
      *                                                                 06810000
       0100B-DECLARE-GTT-R2.                                            
      *                                                                 06830000
           MOVE 'SESSION.CSR04385_R2'       TO WS-GTT-NAME.             
           SET WS-MTHLY-CHGS                TO TRUE.                    
      *                                                                 06860000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04385_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04385_R2
              (                                                       
                    RETURN_CODE          INT                        
                   ,CNT_NAME_DESC CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CNT_AMT_MO_PYMT      DECIMAL(11,2)                  
                   ,CNT_PYMTS_REMAIN     INT                        
                   ,CNT_EXPIRY_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06980000
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
      *                                                                 07020000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 07220000
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04385_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07230000
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            07240000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07250000
MFA-TR*        SELECT                                                   07260000
MFA-TR*           *                                                     07270000
MFA-TR*        FROM                                                     07280000
MFA-TR*            SESSION.CSR04385_R2                                  07290000
MFA-TR*    END-EXEC.                                                    07300000
      *                                                                 07310000
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 07340000
      ******************************************************************07350000
      * 0100C-DECLARE-GTT-R3                                           *07360000
      ******************************************************************07370000
      *                                                                 07380000
       0100C-DECLARE-GTT-R3.                                            
      *                                                                 07400000
           MOVE 'SESSION.CSR04385_R3'       TO WS-GTT-NAME.             
           SET  WS-USAGE                    TO TRUE.                    
      *                                                                 07430000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04385_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04385_R3
              (                                                       
                    RETURN_CODE          INT                        
                   ,REV_MONTH CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
A03925             ,NO_OF_DAYS           INT                        
                   ,UTIL_CHRG_AMT        DECIMAL(11,2)                  
                   ,BBP_AMT              DECIMAL(11,2)                  
                   ,USAGE_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
TASK02             ,DATE_BILLED CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07570000
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
      *                                                                 07610000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 07810000
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                      R3.RETURN_CODE                                    
                     ,R3.REV_MONTH                                      
A03925               ,SUM(R3.NO_OF_DAYS) AS NO_OF_DAYS                  
                     ,SUM(R3.UTIL_CHRG_AMT) AS UTIL_CHRG_AMT            
                     ,SUM(R3.BBP_AMT)  AS BBP_AMT                       
                     ,R3.USAGE_TYPE                                     
TASK02               ,R3.DATE_BILLED                                    
               FROM                                                     
                   #CSR04385_R3 R3                               
               GROUP BY  R3.RETURN_CODE                                 
                        ,R3.REV_MONTH                                   
                        ,R3.USAGE_TYPE                                  
TASK02                  ,R3.DATE_BILLED                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07820000
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                            07830000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07840000
MFA-TR*        SELECT                                                   07850000
MFA-TR*               R3.RETURN_CODE                                    07860000
MFA-TR*              ,R3.REV_MONTH                                      07870000
MFA-TR*              ,SUM(R3.NO_OF_DAYS) AS NO_OF_DAYS                  07880000
MFA-TR*              ,SUM(R3.UTIL_CHRG_AMT) AS UTIL_CHRG_AMT            07890000
MFA-TR*              ,SUM(R3.BBP_AMT)  AS BBP_AMT                       07900000
MFA-TR*              ,R3.USAGE_TYPE                                     07910000
MFA-TR*              ,R3.DATE_BILLED                                    07920000
MFA-TR*        FROM                                                     07930000
MFA-TR*            SESSION.CSR04385_R3 R3                               07940000
MFA-TR*        GROUP BY  R3.RETURN_CODE                                 07950000
MFA-TR*                 ,R3.REV_MONTH                                   07960000
MFA-TR*                 ,R3.USAGE_TYPE                                  07970000
MFA-TR*                 ,R3.DATE_BILLED                                 07980000
MFA-TR*    END-EXEC.                                                    07990000
      *                                                                 08000000
       0100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 08030000
      ******************************************************************08040000
      * 0100D-DECLARE-GTT-R4                                           *08050000
      ******************************************************************08060000
      *                                                                 08070000
       0100D-DECLARE-GTT-R4.                                            
      *                                                                 08090000
           MOVE 'SESSION.CSR04385_R4'       TO WS-GTT-NAME.             
           SET  WS-REMARKS                  TO TRUE.                    
      *                                                                 08120000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04385_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04385_R4
              (                                                       
                    RETURN_CODE          INT                        
                   ,REV_MNTH CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,ADJUSTMENT_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ADJUSTMENT_AMT       DECIMAL(11,2)                  
                   ,REMARKS_TEXT CHAR(210)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                      
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08240000
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
      *                                                                 08280000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08480000
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04385_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     08490000
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                            08500000
MFA-TR*                          WITH ROWSET POSITIONING FOR            08510000
MFA-TR*        SELECT                                                   08520000
MFA-TR*           *                                                     08530000
MFA-TR*        FROM                                                     08540000
MFA-TR*            SESSION.CSR04385_R4                                  08550000
MFA-TR*    END-EXEC.                                                    08560000
      *                                                                 08570000
       0100D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 08600000
      ******************************************************************08610000
      * 0100E-DECLARE-GTT-R5                                           *08620000
      ******************************************************************08630000
      *                                                                 08640000
       0100E-DECLARE-GTT-R5.                                            
      *                                                                 08660000
           MOVE 'SESSION.CSR04385_R5'       TO WS-GTT-NAME.             
           SET  WS-ANNIV                    TO TRUE.                    
      *                                                                 08690000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04385_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04385_R5
              (                                                       
                    RETURN_CODE          INT                        
                   ,OPTION_SEQ_NO CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,OPTION_DESC CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AMT_BALANCE_DUE_TX CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AMT_BALANCE_DUE      DECIMAL(11,2)                  
                   ,EST_BBP_AMT_TX CHAR(60)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,EST_BBP_AMT          DECIMAL(11,2)                  
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08830000
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5.         
      *                                                                 08870000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS    THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100E'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09070000
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04385_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     09080000
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                            09090000
MFA-TR*                          WITH ROWSET POSITIONING FOR            09100000
MFA-TR*        SELECT                                                   09110000
MFA-TR*           *                                                     09120000
MFA-TR*        FROM                                                     09130000
MFA-TR*            SESSION.CSR04385_R5                                  09140000
MFA-TR*    END-EXEC.                                                    09150000
      *                                                                 09160000
       0100E-EXIT.                                                      
            EXIT.                                                       
      *                                                                 09190000
      ******************************************************************09200000
      * 0100F-DECLARE-GTT-R6                                           *09210000
      ******************************************************************09220000
P00694*                                                                 09230000
P00694 0100F-DECLARE-GTT-R6.                                            
P00694*                                                                 09250000
P00694     MOVE 'SESSION.CSR04385_R6'       TO WS-GTT-NAME.             
P00694     SET  WS-CNSMPT                   TO TRUE.                    
P00694*                                                                 09280000
P00694     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04385_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04385_R6
              (                                                       
P00694              RETURN_CODE       INT                           
P00694             ,REVENUE_MONTH CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,DAYS              SMALLINT                          
P00694             ,UNITS             DECIMAL(9,0)                      
P00694             ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,CUSTOMER_NO       DECIMAL(10,0)                     
P00694             ,NEW_CHARGE        DECIMAL(11,2)                     
P00694             ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,CALC_ERROR CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
P00694             ,HTG_CLG_SW        DECIMAL(3,0)                      
P00694             ,EPP_CATEGORY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00694             ,ELEC_BUFFER       DECIMAL(9,5)                      
P00694             ,GAS_BUFFER        DECIMAL(9,5)                      
P00694          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 09480000
P00694     MOVE SQLSTATE                    TO WS-SQLSTATE.             
P00694     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00694                                         S-RETURN-CODE-6.         
P00694*                                                                 09520000
P00694     IF WS-SQLSTATE = '42710'                                     
P00694        PERFORM 8000F-DEL-GTT-ROWS    THRU 8000F-EXIT             
P00694     ELSE                                                         
P00694        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00694           CONTINUE                                               
P00694        ELSE                                                      
P00694           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
P00694           MOVE '0100E'               TO ACTIVE-PARAGRAPH         
P00694           MOVE SQLCODE               TO ABEND-SQLCODE            
P00694           MOVE SQLSTATE              TO ABEND-SQLSTATE           
P00694           MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
P00694           MOVE SPACES                TO ABEND-SQL-PREDICATES     
P00694                                         ABEND-TABLES             
P00694           MOVE WS-GTT-NAME           TO TABLE-1                  
P00694           MOVE SPACES                TO TABLE-ELEMENT-1          
P00694           MOVE SPACES                TO HOSTVAR-ELEMENT-1        
P00694           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00694        END-IF                                                    
P00694     END-IF.                                                      
P00694*                                                                 09720000
P00694     EXEC SQL                                                     
P00694         DECLARE C6 CURSOR                             
P00694                           WITH ROWSET POSITIONING FOR            
P00694         SELECT                                                   
P00694            *                                                     
P00694         FROM                                                     
P00694             #CSR04385_R6                                  
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     09730000
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                            09740000
MFA-TR*                          WITH ROWSET POSITIONING FOR            09750000
MFA-TR*        SELECT                                                   09760000
MFA-TR*           *                                                     09770000
MFA-TR*        FROM                                                     09780000
MFA-TR*            SESSION.CSR04385_R6                                  09790000
MFA-TR*    END-EXEC.                                                    09800000
P00694*                                                                 09810000
P00694 0100F-EXIT.                                                      
P00694      EXIT.                                                       
      ******************************************************************09840000
      * 1000-PROCESS-INPUT                                             *09850000
      ******************************************************************09860000
      *                                                                 09870000
       1000-PROCESS-INPUT.                                              
      *                                                                 09890000
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NUM              TO AC-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               BH-ACCOUNT-NO            
                                               CT-ACCOUNT-NO            
                                               DA-ACCOUNT-NO            
                                               PJ-ACCOUNT-NO            
                                               BU-ACCOUNT-NO            
                                               AR-ACCOUNT-NO            
                                               AU-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               BI-ACCOUNT-NO            
                                               BH-ACCOUNT-NO            
P00694                                         YP-ACCOUNT-NO            
P00836                                         WS-CA168-ACCOUNT-NO.     
      *                                                                 10040000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10070000
      ******************************************************************10080000
      * 2000-PROCESS-OUTPUT                                            *10090000
      ******************************************************************10100000
      *                                                                 10110000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 10130000
P00836     INITIALIZE  WS-TOTAL-BBP-CHARGE.                             
           MOVE 'N'                         TO WS-EOF-CURSOR.           
      *                                                                 10150000
           PERFORM 7300-GET-ACCT-DET        THRU 7300-EXIT.             
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
      *                                                                 10180000
      * Get BBP Payment start date & Revenue month                      10190000
      *                                                                 10200000
           SET WS-PLAN-DET                  TO TRUE.                    
           PERFORM 7100-GET-BBP-DET         THRU 7100-EXIT.             
           MOVE BU-DATE-PYMT-STRT           TO S-START-DATE.            
           MOVE BU-ANNIVERSARY-DATE         TO S-ANIVERSARY-DATE.       
                                                                        
P00836     IF PARM-APPL-PROGRAM-ID = 'WEB'                              
P00836        PERFORM 4000B-CALC-TOTAL-BBP-CHRG                         
P00836                                      THRU 4000B-EXIT             
P00836        MOVE WS-TOTAL-BBP-CHARGE  TO S-BBP-TOTAL-CHRGS            
P00836     END-IF.                                                      
                                                                        
ACT139     STRING BU-ANNIVERSARY-DATE (1:4)                             
ACT139            BU-ANNIVERSARY-DATE (6:2) DELIMITED BY SIZE           
ACT139       INTO WS-REV-MNTH-C.                                        
ACT139     MOVE WS-REV-MNTH-C               TO WS-ANNIVERSARY-DATE.     
                                                                        
      *                                                                 10250000
      * CHECK FOR EXEMPT FROM BBP REVIEW                                10260000
      *                                                                 10270000
P00694     PERFORM 7400-CHECK-EXEMPT-REVIEW THRU 7400-EXIT.             
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00694        MOVE WS-EXEMPT-REVIEW     TO S-EXEMPT-REVIEW              
P00694     ELSE                                                         
P00694        MOVE 'N'                  TO S-EXEMPT-REVIEW              
P00694     END-IF.                                                      
      *                                                                 10340000
      * Compute 'Monthly Charge' Contracts                              10350000
      *                                                                 10360000
           SET WS-MTHLY-CHGS                TO TRUE.                    
           PERFORM 7200-OPEN-AR-CURSOR      THRU 7200-EXIT.             
           PERFORM 7210-FETCH-AR-CURSOR     THRU 7210-EXIT.             
           PERFORM 2100-GET-AR-BALANCE      THRU 2100-EXIT              
             UNTIL NO-MORE-DATA.                                        
           PERFORM 7220-CLOSE-AR-CURSOR     THRU 7220-EXIT.             
      *                                                                 10430000
      * Get Actual Usage From Billing Header/Detail (BI/BG)             10440000
      *                                                                 10450000
           STRING BU-DATE-PYMT-STRT (1:4)                               
                  BU-DATE-PYMT-STRT (6:2) DELIMITED BY SIZE             
             INTO WS-REV-MNTH-C.                                        
           MOVE WS-REV-MNTH-C               TO WS-FROM-REV-MTH          
      *                                                                 10500000
           MOVE AT-REV-MTH-LST-NRML         TO WS-TO-REV-MTH.           
      *                                                                 10510100
           PERFORM 2200-PROCESS-ACT-USAGE   THRU 2200-EXIT.             
                                                                        
ACT139     IF AT-REV-MTH-LST-NRML = 0                                   
ACT230******  PERFORM 7230-READ-BILL-WINDOW THRU 7230-EXIT              10512000
ACT230        MOVE 12 TO S-BBP-MNTHS-REMAIN                             
ACT139     ELSE                                                         
ACT139        MOVE AT-REV-MTH-LST-NRML     TO WS-REV-MTH-LST-NRML       
ACT139        MOVE WS-REV-MTH-LST-NRML     TO WS-REV-MTH-LST-NRML-NUM   
ACT139        MOVE WS-REV-MTH-LST-NRML-NUM TO WS-REV-MTH-LST-NRML-YM    
      *                                                                 10520000
ACT139        IF WS-REV-MTH-LST-NRML-MM = 12 AND                        
ACT139                       WS-ANNIVERSARY-DATE-YR =                   
ACT139                           WS-REV-MTH-LST-NRML-YR + 2             
ACT139           ADD  1  TO WS-REV-MTH-LST-NRML-MM                      
ACT139        END-IF                                                    
ACT139        IF WS-REV-MTH-LST-NRML-MM > 12                            
ACT139          COMPUTE WS-REV-MTH-LST-NRML-MM =                        
ACT139                                WS-REV-MTH-LST-NRML-MM - 12       
ACT139          COMPUTE WS-REV-MTH-LST-NRML-YR  =                       
ACT139                                WS-REV-MTH-LST-NRML-YR + 1        
ACT139        END-IF                                                    
ACT139        IF WS-ANNIVERSARY-DATE-YR > WS-REV-MTH-LST-NRML-YR        
ACT139           ADD +12 TO WS-ANNIVERSARY-DATE-MM                      
ACT139        END-IF                                                    
ACT139        COMPUTE S-BBP-MNTHS-REMAIN = WS-ANNIVERSARY-DATE-MM -     
ACT139                                   WS-REV-MTH-LST-NRML-MM         
ACT230     END-IF.                                                      
      *                                                                 10560000
      * Get Estimated Usage from CSR02322                               10570000
      *                                                                 10580000
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, -1, IIF(TRY_CONVERT(DATE, 
                                                     :BU-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BU-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BU-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BU-DATE-PYMT-STRT
              ), CONVERT(DATE, :BU-DATE-PYMT-STRT) ) )
            INTO
              :WS-02322-TO-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     10590000
MFA-TR*         SET :WS-02322-TO-DATE = DATE(:BU-DATE-PYMT-STRT) -      10600000
MFA-TR*                                 1 MONTH                         10610000
MFA-TR*    END-EXEC.                                                    10620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF AT-REV-MTH-LST-NRML > 0                                   
              MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MNTH-C            
              STRING WS-REV-MNTH-C (1:4) '-'                            
                     WS-REV-MNTH-C (5:2) '-01'  DELIMITED BY SIZE       
                INTO WS-REV-MNTH-DT                                     
           ELSE                                                         
              MOVE WS-02322-TO-DATE         TO WS-REV-MNTH-DT           
           END-IF.                                                      
      * Get 11 months prior to last revenue month normal bill           10710000
           PERFORM 7050-GET-REV-DATE       THRU 7050-EXIT.              
      *                                                                 10730000
           STRING WS-REV-MNTH-DT (1:4)                                  
                  WS-REV-MNTH-DT (6:2) DELIMITED BY SIZE                
             INTO WS-REV-MNTH-C.                                        
           MOVE WS-REV-MNTH-C               TO WS-02322-FROM-REV-MTH.   
      *                                                                 10780000
           MOVE AT-PREMISE-NO               TO WS-PREMISE-NUM.          
           MOVE 'BPAMAINT'                  TO WS-02322-APPL-ID         
           MOVE WS-PREMISE-NO               TO WS-02322-PREMISE.        
           MOVE 0                           TO WS-EST-SUB.              
           SET WS-USAGE                     TO TRUE.                    
           PERFORM 5000-CALL-CSR02322       THRU 5000-EXIT.             
           COMPUTE WS-UNMTRD-AMT-MO-PYMT    = WS-PVT-LGHT-TOT +         
                                              WS-SUB-LGHT-TOT.          
P00694     PERFORM 5500-CALL-CNSMPT-HIST    THRU 5500-EXIT.             
      *                                                                 10870000
           IF WS-EST-COUNT > 0                                          
              PERFORM 2300-PROCESS-EST-USAGE                            
                                            THRU 2300-EXIT              
           END-IF.                                                      
      *                                                                 10920000
      * Compute Projected Balance at Anniversary                        10930000
      *                                                                 10940000
           PERFORM 2600-COMPUTE-PROJ-BAL    THRU 2600-EXIT.             
      *                                                                 10960000
           MOVE S-BAL-AT-ANNIV              TO WS-BAL-AT-ANNIV-ED.      
           PERFORM 2700-FORMAT-REMARKS      THRU 2700-EXIT.             
           MOVE WS-RESULT-TEXT              TO S-BAL-REMARKS.           
      *                                                                 11000000
      * Compute Suggested BBP Amt                                       11010000
      *                                                                 11020000
           COMPUTE S-BBP-NEW-SUGG-AMT = S-BBP-AMT          +            
                                       (S-BAL-AT-ANNIV  /               
                                        S-BBP-MNTHS-REMAIN).            
      *                                                                 11060000
ACT148     IF S-BBP-MNTHS-REMAIN = 12 AND BU-AMT-MO-PYMT > 0            
              MOVE BU-AMT-MO-PYMT           TO S-BBP-NEW-SUGG-AMT       
           ELSE                                                         
              COMPUTE S-BBP-NEW-SUGG-AMT = S-BBP-AMT       +            
                                          (S-BAL-AT-ANNIV /             
                                           S-BBP-MNTHS-REMAIN)          
              IF S-BBP-NEW-SUGG-AMT < 0                                 
                 MOVE 0                     TO S-BBP-NEW-SUGG-AMT       
              ELSE                                                      
                 COMPUTE WS-AMT-MO-PYMT-RND ROUNDED = S-BBP-NEW-SUGG-AMT
                 IF S-BBP-NEW-SUGG-AMT > WS-AMT-MO-PYMT-RND             
                    COMPUTE S-BBP-NEW-SUGG-AMT = WS-AMT-MO-PYMT-RND + 1 
                 ELSE                                                   
                    MOVE WS-AMT-MO-PYMT-RND TO S-BBP-NEW-SUGG-AMT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11240000
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
      *                                                                 11260000
      * Show Anniversary Options b/w Anniversary thru Pymt received     11270000
      *                                                                 11280000
           IF  S-BBP-MNTHS-REMAIN = 12 AND                              
               AT-LAST-PYMT-DATE <= AT-DATE-BILL-DAY-00                 
               PERFORM 2800-COMPUTE-ANNIV-OPTNS                         
                                            THRU 2800-EXIT              
           END-IF.                                                      
      *                                                                 11340000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11370000
      ******************************************************************11380000
      *2000A-MOVE-RESULT.                                               11390000
      ******************************************************************11400000
      *                                                                 11410000
       2000A-MOVE-RESULT.                                               
      *                                                                 11430000
           ADD +1                           TO CTR-ROWS.                
      *                                                                 11450000
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 11480000
      ******************************************************************11490000
      * 2100-GET-AR-BALANCE.                                           *11500000
      ******************************************************************11510000
      *                                                                 11520000
       2100-GET-AR-BALANCE.                                             
      *                                                                 11540000
           MOVE AC-AMT-TRAN-BALANCE            TO WS-MAX-RECV-AMT.      
      *                                                                 11560000
           EVALUATE AC-PYMT-PRIORITY-LVL                                
               WHEN 50                                                  
      *             Budget Billing                                      11590000
                    MOVE WS-MAX-RECV-AMT       TO WS-BBP-CUR-BAL-AMT    
A03300              COMPUTE WS-TOT-00-30-60-90 = AC-AMT-AR-DAY-00 +     
A03300                                           AC-AMT-AR-DAY-30 +     
A03300                                           AC-AMT-AR-DAY-60 +     
A03300                                           AC-AMT-AR-DAY-90       
                    MOVE WS-TOT-00-30-60-90    TO WS-BBP-BILD-BAL-AMT   
               WHEN 70                                                  
      *             Budget Billing                                      11670000
                    MOVE AC-AMT-UNUSED-CR      TO WS-CIA-AMT            
               WHEN 80                                                  
      *             Deposits                                            11700000
                    MOVE AC-ACCOUNT-NO         TO DR-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DR-DEP-ITEM-ID        
                    PERFORM 7610-GET-DEP-REQ   THRU 7610-EXIT           
                    MOVE DR-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                  DR-AMT-MO-PYMT        
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DR-AMT-MO-PYMT            
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DR-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
      *                                                                 11820000
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                            11830000
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +          11840000
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                 11850000
MFA-TR*             END-EXEC                                            11860000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11870000
                    MOVE 'Deposit'             TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-2       
                    PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT           
               WHEN 90                                                  
      *             DFA's (DPP is not allowed on BBP Accounts)          11920000
                    IF AC-ITEM-ID > 40000000                            
                       CONTINUE                                         
                    ELSE                                                
                       PERFORM 7210-FETCH-AR-CURSOR                     
                                               THRU 7210-EXIT           
                       GO TO 2100-EXIT                                  
                    END-IF                                              
                    MOVE AC-ACCOUNT-NO         TO DA-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DA-DFA-ITEM-ID        
                    PERFORM 7620-GET-DFA-DET   THRU 7620-EXIT           
                    MOVE DA-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DA-AMT-MO-PYMT            
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DA-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
      *                                                                 12090000
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                            12100000
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +          12110000
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                 12120000
MFA-TR*             END-EXEC                                            12130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12140000
                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                  DA-AMT-MO-PYMT        
                    MOVE 'DFA'                 TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-2       
                    PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT           
               WHEN 100                                                 
      *             Contracts                                           12210000
                    MOVE AC-ACCOUNT-NO         TO CT-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO CT-CNT-ITEM-ID        
                    PERFORM 7630-GET-CNT-DET   THRU 7630-EXIT           
      *                                                                 12250000
                    IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND               
                       PERFORM 7210-FETCH-AR-CURSOR                     
                                               THRU 7210-EXIT           
                       GO TO 2100-EXIT                                  
                    ELSE                                                
                       CONTINUE                                         
                    END-IF                                              
      *                                                                 12330000
                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                  CT-AMT-MO-PYMT        
                    MOVE K6-CNT-NAME-DESC      TO S-CNT-NAME-DESC       
                    MOVE CT-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    IF CT-CODE-BILL-TYPE = 'C'                          
                       COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =             
                               WS-MAX-RECV-AMT / CT-AMT-MO-PYMT         
                       IF S-CNT-PYMTS-REMAIN = 0                        
                          MOVE CT-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN 
                       END-IF                                           
      *                                                                 12440000
                       EXEC SQL                                         
                            SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT              
                       END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*                EXEC SQL                                         12450000
MFA-TR*                     SET :S-CNT-EXPIRY-DT = CURRENT DATE +       12460000
MFA-TR*                         :S-CNT-PYMTS-REMAIN MONTHS              12470000
MFA-TR*                END-EXEC                                         12480000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                         
      *                                                                 12490000
                    ELSE                                                
                       MOVE SPACES             TO S-CNT-EXPIRY-DT       
                       MOVE 0                  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    MOVE ZERO                  TO S-RETURN-CODE-2       
                    PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT           
               WHEN 129                                                 
      *             Project Share                                       12570000
                    PERFORM 7600-GET-PJS-AMT   THRU 7600-EXIT           
                    COMPUTE S-MTHLY-CNT-TOT-AMT = S-MTHLY-CNT-TOT-AMT + 
                                                PJ-MONTHLY-BILL-AM      
                    IF PJ-MONTHLY-BILL-AM > 0                           
                       MOVE 'Project Share'    TO S-CNT-NAME-DESC       
                       MOVE PJ-MONTHLY-BILL-AM TO S-CNT-AMT-MO-PYMT     
                       MOVE 0                  TO S-RETURN-CODE-2       
                       PERFORM 8020-INSERT-GTT-R2 THRU 8020-EXIT        
                    END-IF                                              
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
      *                                                                 12700000
           PERFORM 7210-FETCH-AR-CURSOR     THRU 7210-EXIT.             
      *                                                                 12720000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12750000
      ***************************************************************** 12760000
      * 2200-PROCESS-ACT-USAGE.                                       * 12770000
      ***************************************************************** 12780000
      *                                                                 12790000
       2200-PROCESS-ACT-USAGE.                                          
      *                                                                 12810000
      * Get Actual Utility Amount Billed & Billed Date                  12820000
           MOVE 'N'                            TO WS-EOF-CURSOR.        
           PERFORM 7700-OPEN-ACT-BILL-CURSOR   THRU 7700-EXIT.          
           PERFORM 7710-FETCH-ACT-BILL-CURSOR  THRU 7710-EXIT.          
           PERFORM 2210-PROCESS-BILL-AMT       THRU 2210-EXIT           
             UNTIL NO-MORE-DATA.                                        
           PERFORM 7720-CLOSE-ACT-BILL-CURSOR  THRU 7720-EXIT.          
      * If BBP amt adjusted and not yet billed                          12890000
           IF WS-ACT-COUNT > 0                                          
              IF WS-CUR-BILD-BBP-AM = BU-AMT-MO-PYMT                    
                 CONTINUE                                               
              ELSE                                                      
                 SET ADJ-AMT-NOT-BILD      TO TRUE                      
                 MOVE WS-CURRENT-DATE      TO WS-CUR-BILD-DT-TRAN       
                 MOVE WS-CUR-BILD-TS       TO WS-NEW-TRAN-TS            
                PERFORM 2220-GET-ADJ-BBP-AMT  THRU 2220-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                 13000000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13030000
      ******************************************************************13040000
      * 2210-PROCESS-BILL-AMT                                          *13050000
      ******************************************************************13060000
      *                                                                 13070000
       2210-PROCESS-BILL-AMT.                                           
      *                                                                 13090000
           MOVE BI-DATE-BILLED             TO AR-DATE-TRANS             
           MOVE BG-AMT-BILL-ITEM           TO S-UTIL-CHRG-AMT           
      * Get BBP amount Billed from Trans Hist. When Customer accepts BBP13120000
      * offer by sending a payment get BBP Amt from Budget Hist.        13130000
           PERFORM 7750-GET-ACT-BBP-AMT    THRU 7750-EXIT               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE AR-ACCOUNT-NO           TO BH-ACCOUNT-NO             
              MOVE BU-DATE-PYMT-STRT       TO BH-DATE-PYMT-STRT         
              MOVE '01'                    TO BH-DATE-PYMT-STRT(9:2)    
              MOVE 'S'                     TO BH-CHANGE-REASON          
              PERFORM 7800-GET-BBP-AMT     THRU 7800-EXIT               
              MOVE BI-DATE-BILLED          TO WS-CUR-BILD-DT-TRAN       
              MOVE BH-AMT-MO-PYMT          TO WS-CUR-BILD-BBP-AM        
           ELSE                                                         
              MOVE AR-DATE-TRANS           TO WS-CUR-BILD-DT-TRAN       
              MOVE AU-AMT-POSTED           TO WS-CUR-BILD-BBP-AM        
           END-IF                                                       
           MOVE WS-CUR-BILD-TS             TO WS-NEW-TRAN-TS            
           IF WS-1ST-TIME = 'Y'                                         
              MOVE WS-CUR-BILD-BBP-AM      TO WS-PREV-BILD-BBP-AM       
              MOVE 'N'                     TO WS-1ST-TIME               
           END-IF                                                       
      * If BBP amt changed, then get remarks                            13320000
           IF WS-CUR-BILD-BBP-AM = WS-PREV-BILD-BBP-AM                  
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2220-GET-ADJ-BBP-AMT THRU 2220-EXIT               
           END-IF                                                       
           MOVE WS-CUR-BILD-BBP-AM         TO WS-PREV-BILD-BBP-AM       
                                              S-BBP-AMT                 
           MOVE WS-CUR-BILD-DT-TRAN        TO WS-PREV-BILD-DT-TRAN      
           MOVE WS-PREV-BILD-TS            TO WS-OLD-TRAN-TS            
A03925     MOVE BG-NO-OF-CONS-DAYS         TO S-NO-OF-DAYS              
           MOVE 'A'                        TO S-USAGE-TYPE              
TASK02     MOVE BI-DATE-BILLED             TO S-DATE-BILLED             
           IF BG-REV-MTH-ORIG-BILL > 0                                  
              MOVE BG-REV-MTH-ORIG-BILL    TO WS-REV-MNTH-C             
A03300                                        WS-REV-MNTH-2             
           ELSE                                                         
              MOVE BG-REVENUE-MONTH        TO WS-REV-MNTH-C             
A03300                                        WS-REV-MNTH-2             
           END-IF                                                       
           MOVE WS-REV-MNTH-C(5:2)         TO WS-PREV-YEAR              
           STRING WS-REV-MNTH-C (1:4) '-'                               
                  WS-REV-MNTH-C (5:2) '-01'                             
                  DELIMITED BY SIZE INTO S-REV-MONTH.                   
           PERFORM 8030-INSERT-GTT-R3      THRU 8030-EXIT               
      *                                                                 13570000
           PERFORM 7710-FETCH-ACT-BILL-CURSOR  THRU 7710-EXIT.          
      *                                                                 13590000
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13620000
      ******************************************************************13630000
      * 2220-GET-ADJ-BBP-AMT                                           *13640000
      ******************************************************************13650000
      *                                                                 13660000
       2220-GET-ADJ-BBP-AMT.                                            
      *                                                                 13680000
           INITIALIZE  WS-BBP-DEC-AMT.                                  
           MOVE WS-PREV-BILD-BBP-AM           TO WS-BBP-DEC-AMT.        
           SET  WS-REMARKS                    TO TRUE.                  
           MOVE 'N'                           TO WS-CURSOR-SW.          
           PERFORM 7500-OPEN-BBP-HIST         THRU 7500-EXIT.           
           PERFORM 7510-FETCH-BBP-HIST        THRU 7510-EXIT.           
           PERFORM 2221-PROCESS-BBP-HIST      THRU 2221-EXIT            
                                              UNTIL NO-MORE-ROWS.       
           PERFORM 7520-CLOSE-BBP-HIST        THRU 7520-EXIT.           
      *                                                                 13780000
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13810000
      ******************************************************************13820000
      * 2221-PROCESS-BBP-HIST                                          *13830000
      ******************************************************************13840000
      *                                                                 13850000
       2221-PROCESS-BBP-HIST.                                           
      *                                                                 13870000
           IF WS-PREV-BILD-BBP-AM = BH-AMT-MO-PYMT                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE BH-AMT-MO-PYMT              TO S-ADJUSTMENT-AMT      
                                                  S-BBP-AMT             
A03300           MOVE WS-REV-MNTH-2(1:4)        TO WS-YEAR-2            
A03300           MOVE WS-REV-MNTH-2(5:2)        TO WS-MONTH-2           
A03300           MOVE WS-REV-MNTH-DT-2          TO S-REV-MNTH           
              MOVE BH-BUD-HIST-SEQ-NO           TO S-ADJUSTMENT-DATE    
              MOVE SPACES                       TO S-REMARKS-TEXT       
              MOVE BH-REMARKS-TEXT(1:BH-REMARKS-LEN)                    
                                                TO S-REMARKS-TEXT       
              MOVE BH-AMT-MO-PYMT               TO WS-PREV-BILD-BBP-AM  
              PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT           
           END-IF.                                                      
      *                                                                 14030000
           PERFORM 7510-FETCH-BBP-HIST         THRU 7510-EXIT.          
      *                                                                 14050000
       2221-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14080000
      ***************************************************************** 14090000
      * 2300-PROCESS-EST-USAGE.                                       * 14100000
      ***************************************************************** 14110000
      *                                                                 14120000
       2300-PROCESS-EST-USAGE.                                          
      *                                                                 14140000
           PERFORM 2310-SORT-EST-USAGE      THRU 2310-EXIT.             
      *                                                                 14160000
           INITIALIZE  WS-REV-MNTH-DT                                   
                       WS-UTIL-CHGS-TOT.                                
           MOVE 'Y'                            TO WS-1ST-TIME.          
           MOVE 1                              TO WS-EST-SUB.           
           PERFORM VARYING WS-EST-SUB FROM 1 BY 1                       
ACT011               UNTIL WS-EST-SUB > WS-EST-COUNT + 1                
ACT011                  OR WS-EST-SUB > 29                              
              IF WS-1ST-TIME = 'Y'                                      
                   MOVE WS-REV-MNTH-EST(WS-EST-SUB) TO WS-REV-MNTH-DT   
                   MOVE 'N' TO WS-1ST-TIME                              
              END-IF                                                    
      * Compute Electric & Gas utility charges                          14270000
              IF WS-REV-MNTH-EST(WS-EST-SUB) = WS-REV-MNTH-DT           
                 IF WS-CD-UTIL-TYP-EST(WS-EST-SUB) = 'E' OR 'G'         
                    COMPUTE WS-UTIL-CHGS-TOT = WS-UTIL-CHGS-TOT +       
                            WS-NEW-CHG-EST(WS-EST-SUB)                  
A03925              MOVE WS-NO-OF-DAYS(WS-EST-SUB) TO WS-NO-DAYS        
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-REV-MNTH-DT (1:4)     TO WS-YEAR-CHAR          
                                                  WS-YEAR-NUM           
                 MOVE WS-REV-MNTH-DT (6:2)     TO WS-MONTH-CHAR         
                 IF WS-MONTH-CHAR = '01' OR                             
                     WS-YEAR-CHAR NOT = WS-PREV-YEAR OR                 
                    (WS-YEAR-CHAR = WS-PREV-YEAR AND                    
                     WS-REV-MNTH-DT < BU-DATE-PYMT-STRT)                
                    MOVE 'Y'                   TO WS-INCR-YEAR          
                 END-IF                                                 
      * Return past consumptions as estimated future consumption        14440000
                 IF WS-YEAR-CHAR IS NUMERIC                             
                    IF WS-INCR-YEAR = 'Y'                               
                       COMPUTE WS-YEAR-NUM  = WS-YEAR-NUM + 1           
                    END-IF                                              
                    MOVE WS-YEAR-NUM           TO WS-YEAR-CHAR          
                                                  WS-PREV-YEAR          
                    MOVE WS-REV-MNTH-DT-1      TO S-REV-MONTH           
                 END-IF                                                 
      *                                                                 14530000
                 MOVE WS-REV-MNTH-EST(WS-EST-SUB)                       
                                               TO WS-REV-MNTH-DT        
                 MOVE BU-AMT-MO-PYMT           TO S-BBP-AMT             
      *                                                                 14570000
      * Compute Total Utility & Unmeterd Charges.                       14580000
                 COMPUTE S-UTIL-CHRG-AMT    = WS-UTIL-CHGS-TOT +        
                                              WS-UNMTRD-AMT-MO-PYMT     
      * Compute Monthly & Total Diff                                    14610000
                 COMPUTE WS-EST-MTHLY-DIFF = WS-EST-MTHLY-DIFF +        
                                           (S-UTIL-CHRG-AMT - S-BBP-AMT)
      *                                                                 14640000
                 MOVE ZEROS                    TO WS-UTIL-CHGS-TOT      
                 MOVE WS-NEW-CHG-EST(WS-EST-SUB)                        
                                               TO WS-UTIL-CHGS-TOT      
A03925           MOVE WS-NO-DAYS               TO S-NO-OF-DAYS          
                 MOVE 'E'                      TO S-USAGE-TYPE          
TASK02           MOVE SPACES                   TO S-DATE-BILLED         
A03925           MOVE WS-NO-OF-DAYS(WS-EST-SUB) TO WS-NO-DAYS           
                 PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT           
              END-IF                                                    
      *                                                                 14740000
           END-PERFORM.                                                 
      *                                                                 14760000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14790000
      ******************************************************************14800000
      * 2310-SORT-EST-USAGE                                            *14810000
      ******************************************************************14820000
      *                                                                 14830000
       2310-SORT-EST-USAGE.                                             
      *                                                                 14850000
           PERFORM VARYING  WS-SUB1 FROM 1 BY 1                         
                                    UNTIL WS-SUB1 = WS-EST-COUNT        
              PERFORM VARYING  WS-SUB2 FROM WS-SUB1 BY 1                
                                       UNTIL WS-SUB2 > WS-EST-COUNT     
                 IF WS-REV-MNTH-EST(WS-SUB2) < WS-REV-MNTH-EST(WS-SUB1) 
                    MOVE WS-BBP-EST-TB(WS-SUB1) TO WS-HOLD-ROWS         
                    MOVE WS-BBP-EST-TB(WS-SUB2) TO                      
                                         WS-BBP-EST-TB(WS-SUB1)         
                    MOVE WS-HOLD-ROWS           TO                      
                                         WS-BBP-EST-TB(WS-SUB2)         
                 END-IF                                                 
               END-PERFORM                                              
           END-PERFORM.                                                 
      *                                                                 14990000
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15020000
      ******************************************************************15030000
      * 2600-COMPUTE-PROJ-BAL                                          *15040000
      ******************************************************************15050000
      *                                                                 15060000
       2600-COMPUTE-PROJ-BAL.                                           
      *                                                                 15080000
           MOVE SPACES                      TO WS-REMARKS-TEXT.         
           MOVE WS-BBP-CUR-BAL-AMT          TO WS-BBP-CUR-BAL-ED        
P0694A                                         S-BBP-CUR-BAL-AMT.       
           MOVE WS-EST-MTHLY-DIFF           TO WS-EST-MTHLY-DIFF-ED.    
           EVALUATE TRUE                                                
      * Pymt received since anniversary bill& not yet billed            15140000
               WHEN AT-LAST-PYMT-DATE > AT-DATE-BILL-DAY-00 AND         
                    S-BBP-MNTHS-REMAIN = 12                             
                    MOVE '1'                TO WS-STR-TYPE              
                    COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +       
                                             WS-EST-MTHLY-DIFF  +       
                                             WS-CIA-AMT -               
A03300                                       WS-BBP-BILD-BAL-AMT        
      * Pymt received since last bill (non-anniversary bills)           15220000
               WHEN AT-LAST-PYMT-DATE > AT-DATE-BILL-DAY-00 AND         
                    S-BBP-MNTHS-REMAIN < 12                             
                    MOVE '2'                TO WS-STR-TYPE              
                    COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +       
                                             WS-EST-MTHLY-DIFF -        
A03300                                       WS-BBP-BILD-BAL-AMT        
      * NO PYMT RECEIVED SINCE ANNIVERSARY BILL& NOT YET BILLED         15290000
               WHEN AT-LAST-PYMT-DATE <= AT-DATE-BILL-DAY-00 AND        
                    S-BBP-MNTHS-REMAIN = 12                             
      * At anniversary/Setup Next-Bill, expected pymt is billed balance 15320000
                    MOVE '3'                TO WS-STR-TYPE              
                    COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +       
                                             WS-EST-MTHLY-DIFF -        
                                             WS-BBP-BILD-BAL-AMT        
      * No Pymt received since last bill (non-anniversary bills)        15370000
               WHEN AT-LAST-PYMT-DATE <= AT-DATE-BILL-DAY-00 AND        
                    S-BBP-MNTHS-REMAIN < 12                             
      * For non-anniversary bills, expected pymt is BBP Amt             15400000
                    IF ADJ-AMT-NOT-BILD                                 
      * If BBP Amt adjusted and not billed at least once                15420000
                      MOVE '4'              TO WS-STR-TYPE              
                      COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +     
                                               WS-EST-MTHLY-DIFF -      
                                               WS-BBP-BILD-BAL-AMT      
                    ELSE                                                
                      MOVE '5'              TO WS-STR-TYPE              
                      COMPUTE S-BAL-AT-ANNIV = WS-BBP-CUR-BAL-AMT +     
                                               WS-EST-MTHLY-DIFF -      
                                               WS-BBP-BILD-BAL-AMT      
                    END-IF                                              
               WHEN OTHER                                               
                    MOVE 0                  TO S-BAL-AT-ANNIV           
           END-EVALUATE.                                                
      *                                                                 15560000
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15590000
      ******************************************************************15600000
      * 2700-FORMAT-REMARKS                                            *15610000
      ******************************************************************15620000
      *                                                                 15630000
       2700-FORMAT-REMARKS.                                             
      *                                                                 15650000
           EVALUATE WS-STR-TYPE                                         
               WHEN '1'                                                 
                    MOVE WS-CIA-AMT              TO WS-CIA-AMT-ED       
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - UNUSED CR $'      DELIMITED BY SIZE      
                           WS-CIA-AMT-ED         DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '2'                                                 
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '3'                                                 
                    MOVE WS-BBP-BILD-BAL-AMT     TO WS-BBP-BILD-BAL-ED  
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - BILD BAL $'       DELIMITED BY SIZE      
                           WS-BBP-BILD-BAL-ED    DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '4'                                                 
                    MOVE WS-CUR-BILD-BBP-AM      TO WS-BBP-BILD-AMT-ED  
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - BILD BBP AMT $'   DELIMITED BY SIZE      
                           WS-BBP-BILD-AMT-ED    DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN '5'                                                 
                    MOVE S-BBP-AMT               TO WS-BBP-AMT-ED       
                    STRING 'BBP BAL $'           DELIMITED BY SIZE      
                           WS-BBP-CUR-BAL-ED     DELIMITED BY SIZE      
                           ' + EST MTHLY DIFF $' DELIMITED BY SIZE      
                           WS-EST-MTHLY-DIFF-ED  DELIMITED BY SIZE      
                           ' - BBP AMT $'        DELIMITED BY SIZE      
                           WS-BBP-AMT-ED         DELIMITED BY SIZE      
                           ' = $'                DELIMITED BY SIZE      
                           WS-BAL-AT-ANNIV-ED    DELIMITED BY SIZE      
                           ';'                   DELIMITED BY SIZE      
                      INTO WS-REMARKS-TEXT                              
               WHEN OTHER                                               
                    MOVE SPACES        TO WS-REMARKS-TEXT               
           END-EVALUATE.                                                
      *                                                                 16270000
           MOVE SPACES                 TO WS-RESULT-TEXT                
                                          WS-PREV-CHAR.                 
           SET WS-IDX-1                TO 1.                            
           SET WS-IDX-2                TO 1.                            
      *                                                                 16320000
           PERFORM 210 TIMES                                            
              IF WS-REMARKS-CHAR(WS-IDX-1) = SPACES AND                 
                 WS-PREV-CHAR              = SPACES                     
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-REMARKS-CHAR(WS-IDX-1)                         
                                         TO WS-RESULT-CHAR(WS-IDX-2)    
                                            WS-PREV-CHAR                
                 SET WS-IDX-2            UP BY 1                        
              END-IF                                                    
                 SET WS-IDX-1            UP BY 1                        
           END-PERFORM.                                                 
      *                                                                 16450000
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16480000
      ******************************************************************16490000
      * 2800-COMPUTE-ANNIV-OPTNS                                       *16500000
      ******************************************************************16510000
      *                                                                 16520000
       2800-COMPUTE-ANNIV-OPTNS.                                        
      *                                                                 16540000
           MOVE S-START-DATE             TO BH-DATE-PYMT-STRT.          
           MOVE 'A'                      TO BH-CHANGE-REASON.           
           PERFORM 7800-GET-BBP-AMT      THRU 7800-EXIT.                
      * If account set-up on BBP for the 1st time                       16580000
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      * Option 1 - If Paid 'Billed Account Balance'                     16620000
           MOVE 0                        TO S-RETURN-CODE-5.            
           MOVE 1                        TO S-OPTION-SEQ-NO.            
           MOVE WS-OPTION-DESC-1         TO S-OPTION-DESC.              
           MOVE AT-TOTAL-AR-BALANCE   TO S-AMT-BALANCE-DUE.             
TASK01     IF AC-AMT-AR-DAY-00  =  BH-BUDG-BILL-PREV-AMT                
              MOVE WS-ACCT-BAL-BBP-TX    TO S-AMT-BALANCE-DUE-TX        
           ELSE                                                         
              MOVE WS-ACT-ACCT-BAL-TX    TO S-AMT-BALANCE-DUE-TX        
           END-IF.                                                      
           MOVE WS-EST-BBP-AMT-TX        TO S-EST-BBP-AMT-TX.           
           MOVE BH-AMT-MO-PYMT           TO S-EST-BBP-AMT.              
           PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT.                
      *                                                                 16750000
           IF WS-CODE-BANK-EFT = 'A' OR                                 
              AT-TOTAL-AR-BALANCE = AT-EPP-OFFER-AMOUNT                 
              CONTINUE                                                  
           ELSE                                                         
      * Option 2 - If Paid 'Total Account Balance'                      16800000
              MOVE 0                     TO S-RETURN-CODE-5             
              MOVE 2                     TO S-OPTION-SEQ-NO             
              MOVE WS-OPTION-DESC-2      TO S-OPTION-DESC               
              MOVE AT-EPP-OFFER-AMOUNT   TO S-AMT-BALANCE-DUE           
TASK01        IF WS-ACT-ACCT-BAL-TX = S-AMT-BALANCE-DUE-TX              
TASK01           MOVE WS-OPTION-DESC-3   TO S-OPTION-DESC               
                 MOVE WS-ACCT-BAL-BBP-TX TO S-AMT-BALANCE-DUE-TX        
              ELSE                                                      
                 MOVE WS-ACT-ACCT-BAL-TX TO S-AMT-BALANCE-DUE-TX        
              END-IF                                                    
              MOVE WS-EST-BBP-AMT-TX     TO S-EST-BBP-AMT-TX            
              MOVE BH-EPP-ESTIMATE       TO S-EST-BBP-AMT               
              PERFORM 8050-INSERT-GTT-R5 THRU 8050-EXIT                 
           END-IF.                                                      
       2800-EXIT.                                                       
           EXIT.                                                        
P00836******************************************************************        
P00836* 4000B-CALC-TOTAL-BBP-CHRG                                      *        
P00836******************************************************************        
P00836*                                                                         
P00836     EXEC SQL                                                             
P00836         INCLUDE CPD00168                                                 
P00836     END-EXEC.                                                            
      ******************************************************************16970000
      * 5000-CALL-CSR04322                                             *16980000
      ******************************************************************16990000
      *                                                                 17000000
       5000-CALL-CSR02322.                                              
      *                                                                 17020000
      *    EXEC SQL                                                     
      *         CALL CSR02322(:WS-02322-APPL-ID                         
      *                      ,:WS-02322-PREMISE                         
      *                      ,:WS-02322-TO-DATE                         
      *                      ,:WS-02322-FROM-REV-MTH                    
      *                      )                                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE USER_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN USER_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR USER_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                 17100000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
      *                                                                 17130000
           IF  WS-ACTIVE-RETURN-CODE = +466                             
               CONTINUE                                                 
           ELSE                                                         
              MOVE '5000'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
              MOVE 'CSR02322'            TO TABLE-1                     
              MOVE 'APPL_ID'             TO TABLE-ELEMENT-1             
              MOVE WS-02322-APPL-ID      TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-02322-TO-DATE'    TO TABLE-ELEMENT-3             
              MOVE WS-02322-TO-DATE      TO HOSTVAR-ELEMENT-3           
              MOVE 'WS-02322-FROM-REV'   TO TABLE-ELEMENT-4             
              MOVE WS-02322-FROM-REV-MTH TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 17310000
      *    EXEC SQL                                                     
      *         ASSOCIATE LOCATORS                                      
      *         (:LOC-RESLTSET)                                         
      *         WITH PROCEDURE CSR02322                                 
      *    END-EXEC.                                                    
      *                                                                 17370000
      *    EXEC SQL                                                     
      *      ALLOCATE USER_CUR CURSOR FOR RESULT SET                    
      *      :LOC-RESLTSET                                              
      *    END-EXEC.                                                    
      *                                                                 17420000
           MOVE 'N'                      TO WS-EOF-CURSOR.              
           MOVE 0                        TO WS-PVT-LGHT-TOT             
                                            WS-SUB-LGHT-TOT.            
           PERFORM 5100-FETCH-CSR02322 THRU 5100-EXIT                   
                                         UNTIL NO-MORE-DATA.            
      *                                                                 17480000
           EXEC SQL                                                     
             CLOSE USER_CUR                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17520000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
      *                                                                 17550000
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              MOVE '5000'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSR02322'            TO TABLE-1                     
              MOVE 'APPL_ID'             TO TABLE-ELEMENT-1             
              MOVE WS-02322-APPL-ID      TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-02322-TO-DATE'    TO TABLE-ELEMENT-3             
              MOVE WS-02322-TO-DATE      TO HOSTVAR-ELEMENT-3           
              MOVE 'WS-02322-FROM-REV'   TO TABLE-ELEMENT-4             
              MOVE WS-02322-FROM-REV-MTH TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 17730000
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17760000
      ******************************************************************17770000
      * 5100-FETCH-CSR02322                                            *17780000
      ******************************************************************17790000
      *                                                                 17800000
       5100-FETCH-CSR02322.                                             
      *                                                                 17820000
           EXEC SQL                                                     
             FETCH USER_CUR                                             
              INTO  :S-RETURN-CODE-3                                    
                   ,:S-REVENUE-MONTH                                    
                   ,:S-DAYS                                             
                   ,:S-UNITS                                            
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-CUSTOMER-NO                                      
                   ,:S-NEW-CHARGE                                       
                   ,:S-RATE-PLAN-NO                                     
                   ,:S-CALC-ERROR                                       
                   ,:S-HTG-CLG-SW                                       
                   ,:S-BPP-CATEGORY                                     
P00694             ,:S-ELEC-BUFFER                                      
P00694             ,:S-GAS-BUFFER                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17990000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
      *                                                                 18010000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF S-RETURN-CODE-3 = 0                              
                       IF AT-CUSTOMER-NO NOT = S-CUSTOMER-NO            
                          MOVE 'P'             TO S-CNSMPTN-USED        
                       END-IF                                           
                       IF S-REVENUE-MONTH = WS-REV-MNTH-DT              
                          CONTINUE                                      
                       ELSE                                             
                          IF S-REVENUE-MONTH > LOW-VALUES AND SPACES    
                             MOVE S-REVENUE-MONTH TO WS-REV-MNTH-DT     
                          END-IF                                        
                       END-IF                                           
ACT207                 IF S-BPP-CATEGORY = 'E' OR 'G'                   
                          COMPUTE WS-EST-SUB   = WS-EST-SUB + 1         
                          MOVE S-REVENUE-MONTH                          
                                       TO WS-REV-MNTH-EST(WS-EST-SUB)   
      * Apply Gas Rate Increase Buffer                                  18190000
                          COMPUTE WS-NEW-CHG-EST(WS-EST-SUB) =          
                                     S-NEW-CHARGE                       
                          MOVE S-CODE-UTIL-TYPE                         
                                       TO WS-CD-UTIL-TYP-EST(WS-EST-SUB)
A03925                    MOVE S-DAYS  TO WS-NO-OF-DAYS(WS-EST-SUB)     
                          COMPUTE WS-EST-COUNT = WS-EST-COUNT + 1       
                       END-IF                                           
      * Accumulate Unmetered charges                                    18270000
ACT207                 EVALUATE S-BPP-CATEGORY                          
ACT207                     WHEN 'P'                                     
                                COMPUTE WS-PVT-LGHT-TOT =               
                                           WS-PVT-LGHT-TOT              
                                         + S-NEW-CHARGE                 
ACT207                     WHEN 'S'                                     
                                COMPUTE WS-SUB-LGHT-TOT =               
                                           WS-SUB-LGHT-TOT              
                                         + S-NEW-CHARGE                 
                       END-EVALUATE                                     
                    ELSE                                                
                       IF S-RETURN-CODE-3 = 100                         
                          SET NO-MORE-DATA     TO TRUE                  
                          MOVE 0               TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-3       
                       ELSE                                             
                          MOVE S-RETURN-CODE-3 TO WS-ACTIVE-RETURN-CODE 
                          PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT   
                       END-IF                                           
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-6       
               WHEN OTHER                                               
                    MOVE '5100'                TO ACTIVE-PARAGRAPH      
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE 'CSR02322'            TO TABLE-1               
                    MOVE 'APPL_ID'             TO TABLE-ELEMENT-1       
                    MOVE WS-02322-APPL-ID      TO HOSTVAR-ELEMENT-1     
                    MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2       
                    MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-2     
                    MOVE 'WS-02322-TO-DATE'    TO TABLE-ELEMENT-3       
                    MOVE WS-02322-TO-DATE      TO HOSTVAR-ELEMENT-3     
                    MOVE 'WS-02322-FROM-REV'   TO TABLE-ELEMENT-4       
                    MOVE WS-02322-FROM-REV-MTH TO HOSTVAR-ELEMENT-4     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 18730000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18760000
P00694******************************************************************19311000
P00694* 5500-CALL-CNSMPT-HIST                                          *19312000
P00694******************************************************************19313000
P00694*                                                                 19314000
P00694 5500-CALL-CNSMPT-HIST.                                           
P00694*                                                                 19316000
P00694     MOVE WS-CURRENT-DATE          TO WS-02322-TO-DATE.           
P00694*                                                                 19316300
P00694*    EXEC SQL                                                     
P00694*         CALL CSR02322(' '                                       
P00694*                      ,:WS-02322-PREMISE                         
P00694*                      ,:WS-02322-TO-DATE                         
P00694*                      ,' '                                       
P00694*                      )                                          
P00694*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CNSMPT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CNSMPT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CNSMPT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00694*                                                                 19319500
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 19319800
P00694     IF  WS-ACTIVE-RETURN-CODE = +466                             
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE '5500'                TO ACTIVE-PARAGRAPH            
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
P00694        MOVE 'CSR02322'            TO TABLE-1                     
P00694        MOVE 'APPL_ID'             TO TABLE-ELEMENT-1             
P00694        MOVE WS-02322-APPL-ID      TO HOSTVAR-ELEMENT-1           
P00694        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
P00694        MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-2           
P00694        MOVE 'WS-02322-TO-DATE'    TO TABLE-ELEMENT-3             
P00694        MOVE WS-02322-TO-DATE      TO HOSTVAR-ELEMENT-3           
P00694        MOVE 'WS-02322-FROM-REV'   TO TABLE-ELEMENT-4             
P00694        MOVE WS-02322-FROM-REV-MTH TO HOSTVAR-ELEMENT-4           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 19321600
P00694*    EXEC SQL                                                     
P00694*         ASSOCIATE LOCATORS                                      
P00694*         (:LOC-RESLTSET)                                         
P00694*         WITH PROCEDURE CSR02322                                 
P00694*    END-EXEC.                                                    
P00694*                                                                 19322200
P00694*    EXEC SQL                                                     
P00694*      ALLOCATE CNSMPT_CUR CURSOR FOR RESULT SET                  
P00694*      :LOC-RESLTSET                                              
P00694*    END-EXEC.                                                    
P00694*                                                                 19322700
P00694     MOVE 'N'                      TO WS-EOF-CURSOR.              
P00694     MOVE 0                        TO WS-PVT-LGHT-TOT             
P00694                                      WS-SUB-LGHT-TOT.            
P00694     PERFORM 5600-FETCH-CSR02322 THRU 5600-EXIT                   
P00694                                   UNTIL NO-MORE-DATA.            
P00694*                                                                 19323300
P00694     EXEC SQL                                                     
P00694       CLOSE CNSMPT_CUR                                           
P00694     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 19323700
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 19324000
P00694     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE '5000'                TO ACTIVE-PARAGRAPH            
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE 'CLOSE'               TO ABEND-FUNCTION              
P00694        MOVE 'CSR02322'            TO TABLE-1                     
P00694        MOVE 'APPL_ID'             TO TABLE-ELEMENT-1             
P00694        MOVE WS-02322-APPL-ID      TO HOSTVAR-ELEMENT-1           
P00694        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
P00694        MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-2           
P00694        MOVE 'WS-02322-TO-DATE'    TO TABLE-ELEMENT-3             
P00694        MOVE WS-02322-TO-DATE      TO HOSTVAR-ELEMENT-3           
P00694        MOVE 'WS-02322-FROM-REV'   TO TABLE-ELEMENT-4             
P00694        MOVE WS-02322-FROM-REV-MTH TO HOSTVAR-ELEMENT-4           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 19325800
P00694 5500-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 19326100
P00694******************************************************************19326200
P00694* 5600-FETCH-CSR02322                                            *19326300
P00694******************************************************************19326400
P00694*                                                                 19326500
P00694 5600-FETCH-CSR02322.                                             
P00694*                                                                 19326700
P00694     EXEC SQL                                                     
P00694       FETCH CNSMPT_CUR                                           
P00694        INTO  :S-RETURN-CODE-6                                    
P00694             ,:S-REVENUE-MONTH                                    
P00694             ,:S-DAYS                                             
P00694             ,:S-UNITS                                            
P00694             ,:S-CODE-UTIL-TYPE                                   
P00694             ,:S-CUSTOMER-NO                                      
P00694             ,:S-NEW-CHARGE                                       
P00694             ,:S-RATE-PLAN-NO                                     
P00694             ,:S-CALC-ERROR                                       
P00694             ,:S-HTG-CLG-SW                                       
P00694             ,:S-BPP-CATEGORY                                     
P00694             ,:S-ELEC-BUFFER                                      
P00694             ,:S-GAS-BUFFER                                       
P00694     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 19328400
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694*                                                                 19328600
P00694     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00694         WHEN SUCCESSFUL-CALL                                     
P00694              PERFORM 5700-PROCESS-CSR02322-DATA THRU 5700-EXIT   
P00694         WHEN NOT-FOUND                                           
P00694              SET NO-MORE-DATA           TO TRUE                  
P00694              MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
P00694                                            S-RETURN-CODE-6       
P00694         WHEN OTHER                                               
P00694              MOVE '5600'                TO ACTIVE-PARAGRAPH      
P00694              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
P00694              MOVE 'FETCH'               TO ABEND-FUNCTION        
P00694              MOVE 'CSR02322'            TO TABLE-1               
P00694              MOVE 'APPL_ID'             TO TABLE-ELEMENT-1       
P00694              MOVE WS-02322-APPL-ID      TO HOSTVAR-ELEMENT-1     
P00694              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2       
P00694              MOVE WS-02322-PREMISE      TO HOSTVAR-ELEMENT-2     
P00694              MOVE 'WS-02322-TO-DATE'    TO TABLE-ELEMENT-3       
P00694              MOVE WS-02322-TO-DATE      TO HOSTVAR-ELEMENT-3     
P00694              MOVE 'WS-02322-FROM-REV'   TO TABLE-ELEMENT-4       
P00694              MOVE WS-02322-FROM-REV-MTH TO HOSTVAR-ELEMENT-4     
P00694              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P00694     END-EVALUATE.                                                
P00694*                                                                 19335800
P00694 5600-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 19336100
P00694******************************************************************19336200
P00694** VALIDATE & PROCESS  RESULT SET DATA OF CSR02322              **19336300
P00694******************************************************************19336400
P00694*                                                                 19336500
P00694 5700-PROCESS-CSR02322-DATA.                                      
P00694*                                                                 19336700
ACT207     EVALUATE S-BPP-CATEGORY                                      
P00694         WHEN 'E'                                                 
P00694              PERFORM 8060-INSERT-GTT-R6 THRU 8060-EXIT           
P00694              IF S-HTG-CLG-SW = 1                                 
P00694                 IF S-CUSTOMER-NO = AT-CUSTOMER-NO                
P00694                    ADD +1         TO WS-ACCT-WNT-SUM-USE-ELEC    
P00694                 END-IF                                           
P00694              END-IF                                              
P00694         WHEN 'G'                                                 
P00694              PERFORM 8060-INSERT-GTT-R6 THRU 8060-EXIT           
P00694              IF S-HTG-CLG-SW = 1                                 
P00694                 IF S-CUSTOMER-NO = AT-CUSTOMER-NO                
P00694                    ADD +1         TO WS-ACCT-WNT-SUM-USE-GAS     
P00694                 END-IF                                           
P00694              END-IF                                              
ACT207         WHEN 'P'                                                 
ACT207         WHEN 'S'                                                 
P00694              PERFORM 8060-INSERT-GTT-R6 THRU 8060-EXIT           
P00694              IF S-HTG-CLG-SW = 1                                 
P00694                 IF S-CUSTOMER-NO = AT-CUSTOMER-NO                
P00694                    ADD +1         TO WS-ACCT-WNT-SUM-USE-GAS     
P00694                 END-IF                                           
P00694              END-IF                                              
P00694     END-EVALUATE.                                                
P00694*                                                                 19341800
P00694 5700-EXIT.                                                       
P00694     EXIT.                                                        
      ******************************************************************19342100
      * 7000-GET-CUR-DATE.                                             *19342200
      ******************************************************************19343000
      *                                                                 19350000
       7000-GET-CUR-DATE.                                               
      *                                                                 19370000
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     19380000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       19390000
MFA-TR*    END-EXEC.                                                    19400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19410000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 19440000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 19530000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19560000
      ******************************************************************19570000
      * 7050-GET-REV-DATE.                                             *19580000
      ******************************************************************19590000
      *                                                                 19600000
       7050-GET-REV-DATE.                                               
      *                                                                 19620000
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -11, IIF(TRY_CONVERT(DATE, :WS-REV-MNTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-MNTH-DT
              ) <> 0) OR (LEN(:WS-REV-MNTH-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-REV-MNTH-DT
              ), CONVERT(DATE, :WS-REV-MNTH-DT) ) )
            INTO
              :WS-REV-MNTH-DT                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     19630000
MFA-TR*       SET :WS-REV-MNTH-DT = DATE(:WS-REV-MNTH-DT) -             19640000
MFA-TR*                               11 MONTHS                         19650000
MFA-TR*    END-EXEC.                                                    19660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19670000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 19700000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'WS-REV-MNTH-DT'      TO TABLE-ELEMENT-1             
              MOVE WS-REV-MNTH-DT        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 19810000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19840000
      ******************************************************************19850000
      * 7100-GET-BBP-DET                                               *19860000
      ******************************************************************19870000
      *                                                                 19880000
       7100-GET-BBP-DET.                                                
      *                                                                 19900000
           EXEC SQL                                                     
              SELECT                                                    
                     BU.DATE_PYMT_STRT                                  
                    ,BU.ANNIVERSARY_DATE                                
                    ,BU.AMT_MO_PYMT                                     
                INTO                                                    
                     :BU-DATE-PYMT-STRT                                 
                    ,:BU-ANNIVERSARY-DATE                               
                    ,:BU-AMT-MO-PYMT                                    
                FROM                                                    
                     CSS_BUDGET_PLAN BU WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     ACCOUNT_NO = :BU-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19910000
MFA-TR*       SELECT                                                    19920000
MFA-TR*              BU.DATE_PYMT_STRT                                  19930000
MFA-TR*             ,BU.ANNIVERSARY_DATE                                19940000
MFA-TR*             ,BU.AMT_MO_PYMT                                     19950000
MFA-TR*         INTO                                                    19960000
MFA-TR*              :BU-DATE-PYMT-STRT                                 19970000
MFA-TR*             ,:BU-ANNIVERSARY-DATE                               19980000
MFA-TR*             ,:BU-AMT-MO-PYMT                                    19990000
MFA-TR*         FROM                                                    20000000
MFA-TR*              CSS_BUDGET_PLAN BU                                 20010000
MFA-TR*        WHERE                                                    20020000
MFA-TR*              ACCOUNT_NO = :BU-ACCOUNT-NO                        20030000
MFA-TR*         WITH UR                                                 20040000
MFA-TR*      QUERYNO 7100                                               20050000
MFA-TR*    END-EXEC.                                                    20060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20070000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 20100000
      *                                                                 20110000
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_PLAN'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 20250000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20280000
      ******************************************************************20290000
      * 7200-OPEN-AR-CURSOR                                            *20300000
      ******************************************************************20310000
      *                                                                 20320000
       7200-OPEN-AR-CURSOR.                                             
      *                                                                 20340000
           EXEC SQL                                                     
                OPEN AR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20380000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 20410000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 20590000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20620000
      ******************************************************************20630000
      * 7210-FETCH-AR-CURSOR                                           *20640000
      ******************************************************************20650000
      *                                                                 20660000
       7210-FETCH-AR-CURSOR.                                            
      *                                                                 20680000
           EXEC SQL                                                     
              FETCH                                                     
                     AR_CURSOR                                          
              INTO                                                      
                    :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-UNUSED-CR                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-PYMT-PRIORITY-LVL                               
                   ,:L5-AR-TYPE-LONG-DESC                               
                   ,:AC-ITEM-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20840000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 20870000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA     TO TRUE                        
                    MOVE 0               TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE '7210'          TO ACTIVE-PARAGRAPH            
                    MOVE 'FETCH'         TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSS_AR_CNTL'   TO TABLE-1                     
                    MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1             
                    MOVE AC-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                    MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2       
                    MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2     
                    MOVE 'ITEM_ID'       TO TABLE-ELEMENT-3             
                    MOVE AC-ITEM-ID      TO HOSTVAR-ELEMENT-3           
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 21100000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21130000
      ******************************************************************21140000
      * 7220-CLOSE-AR-CURSOR                                           *21150000
      ******************************************************************21160000
      *                                                                 21170000
       7220-CLOSE-AR-CURSOR.                                            
      *                                                                 21190000
           EXEC SQL                                                     
                CLOSE AR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21230000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 21260000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7220'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 21440000
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT139**************************************************************    21460200
ACT139*  GET REVENUE MONTH                                              21460300
ACT139**************************************************************    21460400
ACT139 7230-READ-BILL-WINDOW.                                           
ACT139                                                                  
ACT139     EXEC SQL                                                     
ACT139      SELECT MAX(REVENUE_MONTH)                                   
ACT139       INTO  :WS-REV-MTH-LST-NRML :WS-REV-MTH-LST-NRML-NULL       
ACT139       FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
ACT139       WHERE DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() AS DATE)            
ACT139       AND BILL_CYCLE      = :AT-BILL-CYCLE                       
ACT139                                                           
ACT139     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     21463000
MFA-TR*     SELECT MAX(REVENUE_MONTH)                                   21464000
MFA-TR*      INTO  :WS-REV-MTH-LST-NRML :WS-REV-MTH-LST-NRML-NULL       21465000
MFA-TR*      FROM CSS_BILL_WINDOW                                       21466000
MFA-TR*      WHERE DATE_EXTRACT <= CURRENT DATE                         21467000
MFA-TR*      AND BILL_CYCLE      = :AT-BILL-CYCLE                       21468000
MFA-TR*      WITH UR                                                    21469000
MFA-TR*    END-EXEC.                                                    21469100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT139                                                                  
ACT139     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT139                                                                  
ACT139     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT139        IF WS-REV-MTH-LST-NRML-NULL < 0                           
ACT139           MOVE +0              TO WS-REV-MTH-LST-NRML            
ACT139        END-IF                                                    
ACT139     ELSE                                                         
ACT139        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT139        MOVE '7230'                TO ACTIVE-PARAGRAPH            
ACT139        MOVE 'SELECT'              TO ABEND-FUNCTION              
ACT139        MOVE SPACES                TO ABEND-SQL-PREDICATES        
ACT139                                      ABEND-TABLES                
ACT139        MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
ACT139        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
ACT139        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
ACT139        MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
ACT139        MOVE AT-BILL-CYCLE         TO HOSTVAR-ELEMENT-2           
ACT139        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
ACT139     END-IF.                                                      
ACT139                                                                  
ACT139 7230-EXIT.                                                       
ACT139     EXIT.                                                        
      *                                                                 21473000
      ******************************************************************21480000
      * 7300-GET-ACCT-DET.                                             *21490000
      ******************************************************************21500000
      *                                                                 21510000
       7300-GET-ACCT-DET.                                               
      *                                                                 21530000
           EXEC SQL                                                     
              SELECT                                                    
                     AT.BILL_CYCLE                                      
                    ,AT.COMPANY_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.DATE_BILL_DAY_00                                
                    ,COALESCE(AT.LAST_PYMT_DATE,IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))             
                    ,AT.EPP_OFFER_AMOUNT                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.REV_MTH_LST_NRML                                
                INTO                                                    
                     :AT-BILL-CYCLE                                     
                    ,:AT-COMPANY-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-DATE-BILL-DAY-00                               
                    ,:AT-LAST-PYMT-DATE                                 
                    ,:AT-EPP-OFFER-AMOUNT                               
                    ,:AT-ACCT-CREATE-DT                                 
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-REV-MTH-LST-NRML                               
                FROM                                                    
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE                                                    
                     ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     21540000
MFA-TR*       SELECT                                                    21550000
MFA-TR*              AT.BILL_CYCLE                                      21560000
MFA-TR*             ,AT.COMPANY_NO                                      21570000
MFA-TR*             ,AT.CUSTOMER_NO                                     21580000
MFA-TR*             ,AT.PREMISE_NO                                      21590000
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                21600000
MFA-TR*             ,AT.DATE_BILL_DAY_00                                21610000
MFA-TR*             ,IFNULL(AT.LAST_PYMT_DATE,'0001-01-01')             21620000
MFA-TR*             ,AT.EPP_OFFER_AMOUNT                                21630000
MFA-TR*             ,AT.ACCT_CREATE_DT                                  21640000
MFA-TR*             ,AT.CODES_DATA_PRESENT                              21650000
MFA-TR*             ,AT.REV_MTH_LST_NRML                                21660000
MFA-TR*         INTO                                                    21670000
MFA-TR*              :AT-BILL-CYCLE                                     21680000
MFA-TR*             ,:AT-COMPANY-NO                                     21690000
MFA-TR*             ,:AT-CUSTOMER-NO                                    21700000
MFA-TR*             ,:AT-PREMISE-NO                                     21710000
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                               21720000
MFA-TR*             ,:AT-DATE-BILL-DAY-00                               21730000
MFA-TR*             ,:AT-LAST-PYMT-DATE                                 21740000
MFA-TR*             ,:AT-EPP-OFFER-AMOUNT                               21750000
MFA-TR*             ,:AT-ACCT-CREATE-DT                                 21760000
MFA-TR*             ,:AT-CODES-DATA-PRESENT                             21770000
MFA-TR*             ,:AT-REV-MTH-LST-NRML                               21780000
MFA-TR*         FROM                                                    21790000
MFA-TR*              CSS_ACCOUNT AT                                     21800000
MFA-TR*        WHERE                                                    21810000
MFA-TR*              ACCOUNT_NO = :AT-ACCOUNT-NO                        21820000
MFA-TR*         WITH UR                                                 21830000
MFA-TR*      QUERYNO 7300                                               21840000
MFA-TR*    END-EXEC.                                                    21850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21860000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 21890000
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 22030000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22060000
      ***************************************************************** 22070000
      * 7400-CHECK-EXEMPT-REVIEW.                                     * 22080000
      ***************************************************************** 22090000
      *                                                                 22100000
P00694 7400-CHECK-EXEMPT-REVIEW.                                        
P00694*                                                                 22120000
P00694     EXEC SQL                                                     
P00694        SELECT 'Y'                                                
P00694          INTO :WS-EXEMPT-REVIEW                                  
P00694          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P00694         WHERE YP.ACCOUNT_NO         = :YP-ACCOUNT-NO             
P00694           AND YP.ATTRIBUTE_DESC     = 'BBP_REVIEW_EXEMPT'        
P00694           AND YP.ATTRIBUTE_VALUE_CD = 'Y'                        
P00694                                                           
P00694                                                      
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22130000
MFA-TR*       SELECT 'Y'                                                22140000
MFA-TR*         INTO :WS-EXEMPT-REVIEW                                  22150000
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                              22160000
MFA-TR*        WHERE YP.ACCOUNT_NO         = :YP-ACCOUNT-NO             22170000
MFA-TR*          AND YP.ATTRIBUTE_DESC     = 'BBP_REVIEW_EXEMPT'        22180000
MFA-TR*          AND YP.ATTRIBUTE_VALUE_CD = 'Y'                        22190000
MFA-TR*         WITH UR                                                 22200000
MFA-TR*      QUERYNO 7400                                               22210000
MFA-TR*    END-EXEC.                                                    22220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 22230000
P00694     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
P00694                                    S-RETURN-CODE-1.              
P00694*                                                                 22260000
P00694     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
P00694        MOVE '7400'                      TO ACTIVE-PARAGRAPH      
P00694        MOVE 'SELECT'                    TO ABEND-FUNCTION        
P00694        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
P00694                                            ABEND-TABLES          
P00694        MOVE 'CSS_ACCT_ATTRIBUTE'        TO TABLE-1               
P00694        MOVE 'YP-ACCOUNT-NO'             TO TABLE-ELEMENT-1       
P00694        MOVE YP-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
P00694        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
P00694     END-IF.                                                      
P00694*                                                                 22400000
P00694 7400-EXIT.                                                       
P00694     EXIT.                                                        
      *                                                                 22430000
      ******************************************************************22440000
      * 7500-OPEN-BBP-HIST                                             *22450000
      ******************************************************************22460000
      *                                                                 22470000
       7500-OPEN-BBP-HIST.                                              
      *                                                                 22490000
           EXEC SQL                                                     
                OPEN BBP_HIST                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22530000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 22560000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'EPP_ESTIMATE'        TO TABLE-ELEMENT-2             
              MOVE WS-BBP-DEC-AMT        TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-OLD-TRAN-TS'      TO TABLE-ELEMENT-3             
              MOVE WS-OLD-TRAN-TS        TO HOSTVAR-ELEMENT-3           
              MOVE 'WS-NEW-TRAN-TS'      TO TABLE-ELEMENT-4             
              MOVE WS-NEW-TRAN-TS        TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 22760000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22790000
      ******************************************************************22800000
      * 7510-FETCH-BBP-HIST                                            *22810000
      ******************************************************************22820000
      *                                                                 22830000
       7510-FETCH-BBP-HIST.                                             
      *                                                                 22850000
           EXEC SQL                                                     
              FETCH                                                     
                     BBP_HIST                                           
              INTO                                                      
                    :BH-BUD-HIST-SEQ-NO                                 
                   ,:BH-AMT-MO-PYMT                                     
                   ,:BH-REMARKS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22940000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-4.      
      *                                                                 22970000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-ROWS           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-4       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7510'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_BUDGET_HIST'     TO TABLE-1               
                    MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'EPP_ESTIMATE'        TO TABLE-ELEMENT-2       
                    MOVE WS-BBP-DEC-AMT        TO HOSTVAR-ELEMENT-2     
                    MOVE 'WS-OLD-TRAN-TS'      TO TABLE-ELEMENT-3       
                    MOVE WS-OLD-TRAN-TS        TO HOSTVAR-ELEMENT-3     
                    MOVE 'WS-NEW-TRAN-TS'      TO TABLE-ELEMENT-4       
                    MOVE WS-NEW-TRAN-TS        TO HOSTVAR-ELEMENT-4     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 23210000
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23240000
      ******************************************************************23250000
      * 7520-CLOSE-BBP-HIST                                            *23260000
      ******************************************************************23270000
      *                                                                 23280000
       7520-CLOSE-BBP-HIST.                                             
                                                                        
           EXEC SQL                                                     
                CLOSE BBP_HIST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23340000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 23370000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7520'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'EPP_ESTIMATE'        TO TABLE-ELEMENT-2             
              MOVE WS-BBP-DEC-AMT        TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-OLD-TRAN-TS'      TO TABLE-ELEMENT-3             
              MOVE WS-OLD-TRAN-TS        TO HOSTVAR-ELEMENT-3           
              MOVE 'WS-NEW-TRAN-TS'      TO TABLE-ELEMENT-4             
              MOVE WS-NEW-TRAN-TS        TO HOSTVAR-ELEMENT-4           
              MOVE WS-NEW-TRAN-TS        TO HOSTVAR-ELEMENT-4           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 23580000
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23610000
      ******************************************************************23620000
      * 7600-GET-PJS-AMT.                                              *23630000
      ******************************************************************23640000
      *                                                                 23650000
       7600-GET-PJS-AMT.                                                
      *                                                                 23670000
           EXEC SQL                                                     
                SELECT                                                  
                       COALESCE(PJ.MONTHLY_BILL_AM,0)                   
                  INTO                                                  
                       :PJ-MONTHLY-BILL-AM                              
                  FROM                                                  
                       CSS_PROJ_SHARE PJ WITH(READUNCOMMITTED)                  
                 WHERE                                                  
                       PJ.ACCOUNT_NO        = :PJ-ACCOUNT-NO            
                   AND PJ.PYMT_PRIORITY_LVL = 129                       
                   AND PJ.ITEM_ID           = 1                         
                   AND PJ.SHARE_STATUS_CD   = 'A'                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23680000
MFA-TR*         SELECT                                                  23690000
MFA-TR*                COALESCE(PJ.MONTHLY_BILL_AM,0)                   23700000
MFA-TR*           INTO                                                  23710000
MFA-TR*                :PJ-MONTHLY-BILL-AM                              23720000
MFA-TR*           FROM                                                  23730000
MFA-TR*                CSS_PROJ_SHARE PJ                                23740000
MFA-TR*          WHERE                                                  23750000
MFA-TR*                PJ.ACCOUNT_NO        = :PJ-ACCOUNT-NO            23760000
MFA-TR*            AND PJ.PYMT_PRIORITY_LVL = 129                       23770000
MFA-TR*            AND PJ.ITEM_ID           = 1                         23780000
MFA-TR*            AND PJ.SHARE_STATUS_CD   = 'A'                       23790000
MFA-TR*           WITH UR                                               23800000
MFA-TR*        QUERYNO 7600                                             23810000
MFA-TR*    END-EXEC.                                                    23820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23830000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 23860000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
                 MOVE 0.0                TO PJ-MONTHLY-BILL-AM          
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROJ_SHARE'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PJ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24060000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24090000
      ******************************************************************24100000
      * 7610-GET-DEP-REQ.                                              *24110000
      ******************************************************************24120000
      *                                                                 24130000
       7610-GET-DEP-REQ.                                                
      *                                                                 24150000
           EXEC SQL                                                     
                SELECT                                                  
                       DR.AMT_MO_PYMT                                   
                      ,DR.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :DR-AMT-MO-PYMT                                  
                      ,:DR-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_DEP_REQ DR WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       DR.ACCOUNT_NO        = :DR-ACCOUNT-NO            
                   AND DR.PYMT_PRIORITY_LVL = 80                        
                   AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24160000
MFA-TR*         SELECT                                                  24170000
MFA-TR*                DR.AMT_MO_PYMT                                   24180000
MFA-TR*               ,DR.NO_SCHED_PYMTS                                24190000
MFA-TR*           INTO                                                  24200000
MFA-TR*                :DR-AMT-MO-PYMT                                  24210000
MFA-TR*               ,:DR-NO-SCHED-PYMTS                               24220000
MFA-TR*           FROM                                                  24230000
MFA-TR*                CSS_DEP_REQ DR                                   24240000
MFA-TR*          WHERE                                                  24250000
MFA-TR*                DR.ACCOUNT_NO        = :DR-ACCOUNT-NO            24260000
MFA-TR*            AND DR.PYMT_PRIORITY_LVL = 80                        24270000
MFA-TR*            AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID           24280000
MFA-TR*           WITH UR                                               24290000
MFA-TR*        QUERYNO 7610                                             24300000
MFA-TR*    END-EXEC.                                                    24310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24320000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 24350000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DR-DEP-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24510000
       7610-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24540000
      ******************************************************************24550000
      * 7620-GET-DFA-DET.                                              *24560000
      ******************************************************************24570000
      *                                                                 24580000
       7620-GET-DFA-DET.                                                
      *                                                                 24600000
           EXEC SQL                                                     
                SELECT                                                  
                       DA.AMT_MO_PYMT                                   
                      ,DA.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :DA-AMT-MO-PYMT                                  
                      ,:DA-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                    
                 WHERE                                                  
                       DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            
                   AND DA.PYMT_PRIORITY_LVL = 90                        
                   AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24610000
MFA-TR*         SELECT                                                  24620000
MFA-TR*                DA.AMT_MO_PYMT                                   24630000
MFA-TR*               ,DA.NO_SCHED_PYMTS                                24640000
MFA-TR*           INTO                                                  24650000
MFA-TR*                :DA-AMT-MO-PYMT                                  24660000
MFA-TR*               ,:DA-NO-SCHED-PYMTS                               24670000
MFA-TR*           FROM                                                  24680000
MFA-TR*                CSS_DFA_ACCT DA                                  24690000
MFA-TR*          WHERE                                                  24700000
MFA-TR*                DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            24710000
MFA-TR*            AND DA.PYMT_PRIORITY_LVL = 90                        24720000
MFA-TR*            AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID           24730000
MFA-TR*           WITH UR                                               24740000
MFA-TR*        QUERYNO 7620                                             24750000
MFA-TR*    END-EXEC.                                                    24760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24770000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 24800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7620'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DFA_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DA-DFA-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24960000
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24990000
      ******************************************************************25000000
      * 7630-GET-CNT-DET.                                              *25010000
      ******************************************************************25020000
      *                                                                 25030000
       7630-GET-CNT-DET.                                                
      *                                                                 25050000
           EXEC SQL                                                     
                SELECT                                                  
                       K6.CNT_NAME_DESC                                 
                      ,CT.CODE_BILL_TYPE                                
                      ,CT.AMT_MO_PYMT                                   
                      ,CT.DATE_PYMT_START                               
                      ,CT.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :K6-CNT-NAME-DESC                                
                      ,:CT-CODE-BILL-TYPE                               
                      ,:CT-AMT-MO-PYMT                                  
                      ,:CT-DATE-PYMT-START                              
                      ,:CT-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_CONTRACT      CT WITH(READUNCOMMITTED)               
                      ,CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            
                   AND CT.PYMT_PRIORITY_LVL = 100                       
                   AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID           
                   AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD            
                   AND CT.CNT_STATUS_CD     = 'B'                       
                   AND CT.CODE_BILL_TYPE    IN ('B','C')                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25060000
MFA-TR*         SELECT                                                  25070000
MFA-TR*                K6.CNT_NAME_DESC                                 25080000
MFA-TR*               ,CT.CODE_BILL_TYPE                                25090000
MFA-TR*               ,CT.AMT_MO_PYMT                                   25100000
MFA-TR*               ,CT.DATE_PYMT_START                               25110000
MFA-TR*               ,CT.NO_SCHED_PYMTS                                25120000
MFA-TR*           INTO                                                  25130000
MFA-TR*                :K6-CNT-NAME-DESC                                25140000
MFA-TR*               ,:CT-CODE-BILL-TYPE                               25150000
MFA-TR*               ,:CT-AMT-MO-PYMT                                  25160000
MFA-TR*               ,:CT-DATE-PYMT-START                              25170000
MFA-TR*               ,:CT-NO-SCHED-PYMTS                               25180000
MFA-TR*           FROM                                                  25190000
MFA-TR*                CSS_CONTRACT      CT                             25200000
MFA-TR*               ,CSS_CONTRACT_INFO K6                             25210000
MFA-TR*          WHERE                                                  25220000
MFA-TR*                CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            25230000
MFA-TR*            AND CT.PYMT_PRIORITY_LVL = 100                       25240000
MFA-TR*            AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID           25250000
MFA-TR*            AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD            25260000
MFA-TR*            AND CT.CNT_STATUS_CD     = 'B'                       25270000
MFA-TR*            AND CT.CODE_BILL_TYPE    IN ('B','C')                25280000
MFA-TR*           WITH UR                                               25290000
MFA-TR*        QUERYNO 7630                                             25300000
MFA-TR*    END-EXEC.                                                    25310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25320000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 25350000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7630'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CNT_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE CT-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25510000
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25540000
      ******************************************************************25550000
      * 7700-OPEN-ACT-BILL-CURSOR                                      *25560000
      ******************************************************************25570000
      *                                                                 25580000
       7700-OPEN-ACT-BILL-CURSOR.                                       
      *                                                                 25600000
           EXEC SQL                                                     
                OPEN ACT_BILL                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25640000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 25670000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE 'CSS_BILLING_DET'     TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'WS-FROM-REV-MTH'     TO TABLE-ELEMENT-2             
              MOVE WS-FROM-REV-MTH       TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-TO-REV-MTH'       TO TABLE-ELEMENT-3             
              MOVE WS-TO-REV-MTH         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25860000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25890000
      ******************************************************************25900000
      * 7710-FETCH-ACT-BILL-CURSOR                                     *25910000
      ******************************************************************25920000
      *                                                                 25930000
       7710-FETCH-ACT-BILL-CURSOR.                                      
      *                                                                 25950000
           EXEC SQL                                                     
              FETCH                                                     
                     ACT_BILL                                           
              INTO                                                      
                    :BG-AMT-BILL-ITEM                                   
                   ,:BI-DATE-BILLED                                     
                   ,:BG-REVENUE-MONTH                                   
                   ,:BG-REV-MTH-ORIG-BILL                               
A03925             ,:BG-NO-OF-CONS-DAYS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26060000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-3.      
      *                                                                 26090000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-3       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7710'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_BILLING_HDR'     TO TABLE-1               
                    MOVE 'CSS_BILLING_DET'     TO TABLE-2               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'WS-FROM-REV-MTH'     TO TABLE-ELEMENT-2       
                    MOVE WS-FROM-REV-MTH       TO HOSTVAR-ELEMENT-2     
                    MOVE 'WS-TO-REV-MTH'       TO TABLE-ELEMENT-3       
                    MOVE WS-TO-REV-MTH         TO HOSTVAR-ELEMENT-3     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 26330000
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26360000
      ******************************************************************26370000
      * 7720-CLOSE-ACT-BILL-CURSOR                                     *26380000
      ******************************************************************26390000
      *                                                                 26400000
       7720-CLOSE-ACT-BILL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE ACT_BILL                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26460000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 26490000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7720'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILLING_HDR'     TO TABLE-1                     
              MOVE 'CSS_BILLING_DET'     TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'WS-FROM-REV-MTH'     TO TABLE-ELEMENT-2             
              MOVE WS-FROM-REV-MTH       TO HOSTVAR-ELEMENT-2           
              MOVE 'WS-TO-REV-MTH'       TO TABLE-ELEMENT-3             
              MOVE WS-TO-REV-MTH         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26680000
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26710000
      ******************************************************************26720000
      * 7750-GET-ACT-BBP-AMT                                           *26730000
      ******************************************************************26740000
      *                                                                 26750000
       7750-GET-ACT-BBP-AMT.                                            
      *                                                                 26770000
           EXEC SQL                                                     
              SELECT TOP(1) AU.AMT_POSTED,
              AR.DATE_TRANS                                      
                INTO :AU-AMT-POSTED                                     
                    ,:AR-DATE-TRANS                                     
                FROM CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED),               
                     CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED),               
                     CSS_BUDGET_PLAN    BU WITH(READUNCOMMITTED)                
               WHERE AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        
                 AND AR.ACCOUNT_NO        = :AR-ACCOUNT-NO              
                 AND AU.ACCOUNT_NO        = :AU-ACCOUNT-NO              
                 AND BU.ACCOUNT_NO        = :BU-ACCOUNT-NO              
                 AND AR.DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )              
                 AND AR.CODE_TRAN_TYPE    = 'B'                         
                 AND AU.GL_ACCT_CREDIT    = 142.0400                    
                 AND AU.GL_ACCT_DEBIT     = 142.0400                    
               ORDER BY AR.TRANS_HIST_SEQ_NO DESC                       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     26780000
MFA-TR*       SELECT AU.AMT_POSTED                                      26790000
MFA-TR*             ,AR.DATE_TRANS                                      26800000
MFA-TR*         INTO :AU-AMT-POSTED                                     26810000
MFA-TR*             ,:AR-DATE-TRANS                                     26820000
MFA-TR*         FROM CSS_AR_TRANS_HIST  AR,                             26830000
MFA-TR*              CSS_AR_TRN_HST_DET AU,                             26840000
MFA-TR*              CSS_BUDGET_PLAN    BU                              26850000
MFA-TR*        WHERE AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO        26860000
MFA-TR*          AND AR.ACCOUNT_NO        = :AR-ACCOUNT-NO              26870000
MFA-TR*          AND AU.ACCOUNT_NO        = :AU-ACCOUNT-NO              26880000
MFA-TR*          AND BU.ACCOUNT_NO        = :BU-ACCOUNT-NO              26890000
MFA-TR*          AND AR.DATE_TRANS        = :AR-DATE-TRANS              26900000
MFA-TR*          AND AR.CODE_TRAN_TYPE    = 'B'                         26910000
MFA-TR*          AND AU.GL_ACCT_CREDIT    = 142.0400                    26920000
MFA-TR*          AND AU.GL_ACCT_DEBIT     = 142.0400                    26930000
MFA-TR*        ORDER BY AR.TRANS_HIST_SEQ_NO DESC                       26940000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             26950000
MFA-TR*      QUERYNO 7750                                               26960000
MFA-TR*    END-EXEC.                                                    26970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26980000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 27010000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7750'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1               
                    MOVE 'CSS_AR_TRN_HST_DET'  TO TABLE-2               
                    MOVE 'CSS_BUDGET_PLAN'     TO TABLE-3               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'DATE_TRANS'          TO TABLE-ELEMENT-2       
                    MOVE AR-DATE-TRANS         TO HOSTVAR-ELEMENT-2     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 27220000
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27250000
      ******************************************************************27610000
      * 7800-GET-BBP-AMT.                                              *27620000
      ******************************************************************27630000
      *                                                                 27640000
       7800-GET-BBP-AMT.                                                
      *                                                                 27660000
           EXEC SQL                                                     
              SELECT TOP(1) BH.AMT_MO_PYMT,
              BH.EPP_ESTIMATE,
              BH.BUDG_BILL_PREV_AMT                              
                INTO                                                    
                     :BH-AMT-MO-PYMT                                    
                    ,:BH-EPP-ESTIMATE                                   
                    ,:BH-BUDG-BILL-PREV-AMT                             
                FROM                                                    
                     CSS_BUDGET_HIST    BH WITH(READUNCOMMITTED)                
               WHERE                                                    
                     BH.ACCOUNT_NO         = :BH-ACCOUNT-NO             
                 AND BH.PYMT_PRIORITY_LVL  = 50                         
                 AND BH.ITEM_ID            = 1                          
                 AND BH.DATE_PYMT_STRT     = IIF(TRY_CONVERT(DATE, 
                                                     :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )         
                 AND BH.CHANGE_REASON      = :BH-CHANGE-REASON          
               ORDER BY BH.BUD_HIST_SEQ_NO DESC                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     27670000
MFA-TR*       SELECT                                                    27680000
MFA-TR*              BH.AMT_MO_PYMT                                     27690000
MFA-TR*             ,BH.EPP_ESTIMATE                                    27700000
MFA-TR*             ,BH.BUDG_BILL_PREV_AMT                              27710000
MFA-TR*         INTO                                                    27720000
MFA-TR*              :BH-AMT-MO-PYMT                                    27730000
MFA-TR*             ,:BH-EPP-ESTIMATE                                   27740000
MFA-TR*             ,:BH-BUDG-BILL-PREV-AMT                             27750000
MFA-TR*         FROM                                                    27760000
MFA-TR*              CSS_BUDGET_HIST    BH                              27770000
MFA-TR*        WHERE                                                    27780000
MFA-TR*              BH.ACCOUNT_NO         = :BH-ACCOUNT-NO             27790000
MFA-TR*          AND BH.PYMT_PRIORITY_LVL  = 50                         27800000
MFA-TR*          AND BH.ITEM_ID            = 1                          27810000
MFA-TR*          AND BH.DATE_PYMT_STRT     = :BH-DATE-PYMT-STRT         27820000
MFA-TR*          AND BH.CHANGE_REASON      = :BH-CHANGE-REASON          27830000
MFA-TR*        ORDER BY BH.BUD_HIST_SEQ_NO DESC                         27840000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             27850000
MFA-TR*      QUERYNO 7800                                               27860000
MFA-TR*    END-EXEC.                                                    27870000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27880000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 27910000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 0                     TO BH-AMT-MO-PYMT        
                                                  BH-EPP-ESTIMATE       
                                                  BH-BUDG-BILL-PREV-AMT 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7800'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_BUDGET_HIST'     TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    MOVE 'DATE_PYMT_STRT'      TO TABLE-ELEMENT-3       
                    MOVE BH-DATE-PYMT-STRT     TO HOSTVAR-ELEMENT-2     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 28120000
       7800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************28150000
      * 8000A-DEL-GTT-ROWS.                                            *28160000
      ******************************************************************28170000
      *                                                                 28180000
       8000A-DEL-GTT-ROWS.                                              
      *                                                                 28200000
           EXEC SQL                                                     
               DELETE FROM #CSR04385_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     28210000
MFA-TR*        DELETE FROM SESSION.CSR04385_R1                          28220000
MFA-TR*    END-EXEC.                                                    28230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28240000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 28270000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04385_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 28470000
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 28500000
      ******************************************************************28510000
      * 8000B-DEL-GTT-ROWS.                                            *28520000
      ******************************************************************28530000
      *                                                                 28540000
       8000B-DEL-GTT-ROWS.                                              
      *                                                                 28560000
           EXEC SQL                                                     
               DELETE FROM #CSR04385_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     28570000
MFA-TR*        DELETE FROM SESSION.CSR04385_R2                          28580000
MFA-TR*    END-EXEC.                                                    28590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28600000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 28630000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04385_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 28830000
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 28860000
      ******************************************************************28870000
      * 8000C-DEL-GTT-ROWS.                                            *28880000
      ******************************************************************28890000
      *                                                                 28900000
       8000C-DEL-GTT-ROWS.                                              
      *                                                                 28920000
           EXEC SQL                                                     
               DELETE FROM #CSR04385_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     28930000
MFA-TR*        DELETE FROM SESSION.CSR04385_R3                          28940000
MFA-TR*    END-EXEC.                                                    28950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28960000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 28990000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04385_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 29190000
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 29220000
      ******************************************************************29230000
      * 8000D-DEL-GTT-ROWS.                                            *29240000
      ******************************************************************29250000
      *                                                                 29260000
       8000D-DEL-GTT-ROWS.                                              
      *                                                                 29280000
           EXEC SQL                                                     
               DELETE FROM #CSR04385_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     29290000
MFA-TR*        DELETE FROM SESSION.CSR04385_R4                          29300000
MFA-TR*    END-EXEC.                                                    29310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29320000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 29350000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04385_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 29550000
       8000D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 29580000
      ******************************************************************29590000
      * 8000E-DEL-GTT-ROWS.                                            *29600000
      ******************************************************************29610000
      *                                                                 29620000
       8000E-DEL-GTT-ROWS.                                              
      *                                                                 29640000
           EXEC SQL                                                     
               DELETE FROM #CSR04385_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     29650000
MFA-TR*        DELETE FROM SESSION.CSR04385_R5                          29660000
MFA-TR*    END-EXEC.                                                    29670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29680000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 29710000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000E'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04385_R5'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 29910000
       8000E-EXIT.                                                      
            EXIT.                                                       
      *                                                                 29940000
P00694******************************************************************29950000
P00694* 8000F-DEL-GTT-ROWS.                                            *29960000
P00694******************************************************************29970000
P00694*                                                                 29980000
P00694 8000F-DEL-GTT-ROWS.                                              
P00694*                                                                 30000000
P00694     EXEC SQL                                                     
P00694         DELETE FROM #CSR04385_R6                          
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     30010000
MFA-TR*        DELETE FROM SESSION.CSR04385_R6                          30020000
MFA-TR*    END-EXEC.                                                    30030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 30040000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 30070000
P00694     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00694         WHEN SUCCESSFUL-CALL                                     
P00694              CONTINUE                                            
P00694         WHEN NOT-FOUND                                           
P00694              MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6             
P00694         WHEN OTHER                                               
P00694              MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
P00694              MOVE SQLCODE         TO ABEND-SQLCODE               
P00694              MOVE SQLSTATE        TO ABEND-SQLSTATE              
P00694              MOVE '8000F'         TO ACTIVE-PARAGRAPH            
P00694              MOVE 'DELETE'        TO ABEND-FUNCTION              
P00694              MOVE SPACES          TO ABEND-SQL-PREDICATES        
P00694                                      ABEND-TABLES                
P00694              MOVE 'CSR04385_R6'   TO TABLE-1                     
P00694              MOVE SPACES          TO TABLE-ELEMENT-1             
P00694              MOVE SPACES          TO HOSTVAR-ELEMENT-1           
P00694              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P00694     END-EVALUATE.                                                
P00694*                                                                 30270000
P00694 8000F-EXIT.                                                      
P00694      EXIT.                                                       
P00694*                                                                 30300000
      ******************************************************************30310000
      * 8010-INSERT-GTT-R1.                                            *30320000
      ******************************************************************30330000
      *                                                                 30340000
       8010-INSERT-GTT-R1.                                              
      *                                                                 30360000
           IF WS-CRE-GTT-R1 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100A-DECLARE-GTT-R1    THRU 0100A-EXIT           
              MOVE 'Y'                        TO WS-CRE-GTT-R1          
           END-IF                                                       
           MOVE WS-RETURN-CODE-1              TO S-RETURN-CODE-1.       
      *                                                                 30440000
           EXEC SQL                                                     
              INSERT INTO #CSR04385_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,ANNIVERSARY_DATE                                     
                  ,START_DATE                                           
                  ,MTHLY_CNT_TOT_AMT                                    
                  ,BBP_NO_MNTHS_LEFT                                    
                  ,BBP_NEW_SUG_AMT                                      
                  ,BAL_AT_ANNIV                                         
                  ,BAL_REMARKS                                          
                  ,CNSMPTN_USED                                         
P00694            ,EXEMPT_REVIEW                                        
P0694A            ,BBP_CUR_BAL_AMT                                      
P00836            ,BBP_TOTAL_CHRGS                                      
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-ANIVERSARY-DATE                                   
                  ,:S-START-DATE                                        
                  ,:S-MTHLY-CNT-TOT-AMT                                 
                  ,:S-BBP-MNTHS-REMAIN                                  
                  ,:S-BBP-NEW-SUGG-AMT                                  
                  ,:S-BAL-AT-ANNIV                                      
                  ,:S-BAL-REMARKS                                       
                  ,:S-CNSMPTN-USED                                      
P00694            ,:S-EXEMPT-REVIEW                                     
P0694A            ,:S-BBP-CUR-BAL-AMT                                   
P00836            ,:S-BBP-TOTAL-CHRGS                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     30450000
MFA-TR*       INSERT INTO SESSION.CSR04385_R1                           30460000
MFA-TR*          (                                                      30470000
MFA-TR*            RETURN_CODE                                          30480000
MFA-TR*           ,APPL_RETURN_CODE                                     30490000
MFA-TR*           ,ANNIVERSARY_DATE                                     30500000
MFA-TR*           ,START_DATE                                           30510000
MFA-TR*           ,MTHLY_CNT_TOT_AMT                                    30520000
MFA-TR*           ,BBP_NO_MNTHS_LEFT                                    30530000
MFA-TR*           ,BBP_NEW_SUG_AMT                                      30540000
MFA-TR*           ,BAL_AT_ANNIV                                         30550000
MFA-TR*           ,BAL_REMARKS                                          30560000
MFA-TR*           ,CNSMPTN_USED                                         30570000
MFA-TR*           ,EXEMPT_REVIEW                                        30580000
MFA-TR*           ,BBP_CUR_BAL_AMT                                      30590000
MFA-TR*           ,BBP_TOTAL_CHRGS                                              
MFA-TR*          )                                                      30600000
MFA-TR*       VALUES                                                    30610000
MFA-TR*          (                                                      30620000
MFA-TR*            :S-RETURN-CODE-1                                     30630000
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                30640000
MFA-TR*           ,:S-ANIVERSARY-DATE                                   30650000
MFA-TR*           ,:S-START-DATE                                        30660000
MFA-TR*           ,:S-MTHLY-CNT-TOT-AMT                                 30670000
MFA-TR*           ,:S-BBP-MNTHS-REMAIN                                  30680000
MFA-TR*           ,:S-BBP-NEW-SUGG-AMT                                  30690000
MFA-TR*           ,:S-BAL-AT-ANNIV                                      30700000
MFA-TR*           ,:S-BAL-REMARKS                                       30710000
MFA-TR*           ,:S-CNSMPTN-USED                                      30720000
MFA-TR*           ,:S-EXEMPT-REVIEW                                     30730000
MFA-TR*           ,:S-BBP-CUR-BAL-AMT                                   30740000
MFA-TR*           ,:S-BBP-TOTAL-CHRGS                                           
MFA-TR*          )                                                      30750000
MFA-TR*    END-EXEC.                                                    30760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30770000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 30800000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-DET                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04385_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 30980000
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                 31010000
      ******************************************************************31020000
      * 8020-INSERT-GTT-R2.                                            *31030000
      ******************************************************************31040000
      *                                                                 31050000
       8020-INSERT-GTT-R2.                                              
      *                                                                 31070000
           IF WS-CRE-GTT-R2 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100B-DECLARE-GTT-R2    THRU 0100B-EXIT           
              MOVE 'Y'                        TO WS-CRE-GTT-R2          
           END-IF                                                       
           MOVE WS-RETURN-CODE-2              TO S-RETURN-CODE-2.       
      *                                                                 31150000
           EXEC SQL                                                     
              INSERT INTO #CSR04385_R2                           
                 (                                                      
                   RETURN_CODE                                          
                  ,CNT_NAME_DESC                                        
                  ,CNT_AMT_MO_PYMT                                      
                  ,CNT_PYMTS_REMAIN                                     
                  ,CNT_EXPIRY_DT                                        
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-CNT-NAME-DESC                                     
                  ,:S-CNT-AMT-MO-PYMT                                   
                  ,:S-CNT-PYMTS-REMAIN                                  
                  ,:S-CNT-EXPIRY-DT                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     31160000
MFA-TR*       INSERT INTO SESSION.CSR04385_R2                           31170000
MFA-TR*          (                                                      31180000
MFA-TR*            RETURN_CODE                                          31190000
MFA-TR*           ,CNT_NAME_DESC                                        31200000
MFA-TR*           ,CNT_AMT_MO_PYMT                                      31210000
MFA-TR*           ,CNT_PYMTS_REMAIN                                     31220000
MFA-TR*           ,CNT_EXPIRY_DT                                        31230000
MFA-TR*          )                                                      31240000
MFA-TR*       VALUES                                                    31250000
MFA-TR*          (                                                      31260000
MFA-TR*            :S-RETURN-CODE-2                                     31270000
MFA-TR*           ,:S-CNT-NAME-DESC                                     31280000
MFA-TR*           ,:S-CNT-AMT-MO-PYMT                                   31290000
MFA-TR*           ,:S-CNT-PYMTS-REMAIN                                  31300000
MFA-TR*           ,:S-CNT-EXPIRY-DT                                     31310000
MFA-TR*          )                                                      31320000
MFA-TR*    END-EXEC.                                                    31330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31340000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 31370000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-CHGS                
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04385_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 31550000
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                 31580000
      ******************************************************************31590000
      * 8030-INSERT-GTT-R3.                                            *31600000
      ******************************************************************31610000
      *                                                                 31620000
       8030-INSERT-GTT-R3.                                              
      *                                                                 31640000
           IF WS-CRE-GTT-R3 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100C-DECLARE-GTT-R3    THRU 0100C-EXIT           
              MOVE 'Y'                        TO WS-CRE-GTT-R3          
           END-IF                                                       
           MOVE WS-RETURN-CODE-3              TO S-RETURN-CODE-3.       
      *                                                                 31720000
           EXEC SQL                                                     
              INSERT INTO #CSR04385_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,REV_MONTH                                            
A03925            ,NO_OF_DAYS                                           
                  ,UTIL_CHRG_AMT                                        
                  ,BBP_AMT                                              
                  ,USAGE_TYPE                                           
TASK02            ,DATE_BILLED                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-REV-MONTH                                         
A03925            ,:S-NO-OF-DAYS                                        
                  ,:S-UTIL-CHRG-AMT                                     
                  ,:S-BBP-AMT                                           
                  ,:S-USAGE-TYPE                                        
TASK02            ,:S-DATE-BILLED                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     31730000
MFA-TR*       INSERT INTO SESSION.CSR04385_R3                           31740000
MFA-TR*          (                                                      31750000
MFA-TR*            RETURN_CODE                                          31760000
MFA-TR*           ,REV_MONTH                                            31770000
MFA-TR*           ,NO_OF_DAYS                                           31780000
MFA-TR*           ,UTIL_CHRG_AMT                                        31790000
MFA-TR*           ,BBP_AMT                                              31800000
MFA-TR*           ,USAGE_TYPE                                           31810000
MFA-TR*           ,DATE_BILLED                                          31820000
MFA-TR*          )                                                      31830000
MFA-TR*       VALUES                                                    31840000
MFA-TR*          (                                                      31850000
MFA-TR*            :S-RETURN-CODE-3                                     31860000
MFA-TR*           ,:S-REV-MONTH                                         31870000
MFA-TR*           ,:S-NO-OF-DAYS                                        31880000
MFA-TR*           ,:S-UTIL-CHRG-AMT                                     31890000
MFA-TR*           ,:S-BBP-AMT                                           31900000
MFA-TR*           ,:S-USAGE-TYPE                                        31910000
MFA-TR*           ,:S-DATE-BILLED                                       31920000
MFA-TR*          )                                                      31930000
MFA-TR*    END-EXEC.                                                    31940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31950000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 31980000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-UTIL-CHGS               
                                             WS-ACT-COUNT               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04385_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 32170000
        8030-EXIT.                                                      
            EXIT.                                                       
      *                                                                 32200000
      ******************************************************************32210000
      * 8040-INSERT-GTT-R4.                                            *32220000
      ******************************************************************32230000
      *                                                                 32240000
       8040-INSERT-GTT-R4.                                              
      *                                                                 32260000
           IF WS-CRE-GTT-R4 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100D-DECLARE-GTT-R4    THRU 0100D-EXIT           
              MOVE 'Y'                        TO WS-CRE-GTT-R4          
           END-IF                                                       
           MOVE WS-RETURN-CODE-4              TO S-RETURN-CODE-4.       
      *                                                                 32340000
           EXEC SQL                                                     
              INSERT INTO #CSR04385_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,REV_MNTH                                             
                  ,ADJUSTMENT_DATE                                      
                  ,ADJUSTMENT_AMT                                       
                  ,REMARKS_TEXT                                         
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-REV-MNTH                                          
                  ,:S-ADJUSTMENT-DATE                                   
                  ,:S-ADJUSTMENT-AMT                                    
                  ,:S-REMARKS-TEXT                                      
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     32350000
MFA-TR*       INSERT INTO SESSION.CSR04385_R4                           32360000
MFA-TR*          (                                                      32370000
MFA-TR*            RETURN_CODE                                          32380000
MFA-TR*           ,REV_MNTH                                             32390000
MFA-TR*           ,ADJUSTMENT_DATE                                      32400000
MFA-TR*           ,ADJUSTMENT_AMT                                       32410000
MFA-TR*           ,REMARKS_TEXT                                         32420000
MFA-TR*          )                                                      32430000
MFA-TR*       VALUES                                                    32440000
MFA-TR*          (                                                      32450000
MFA-TR*            :S-RETURN-CODE-4                                     32460000
MFA-TR*           ,:S-REV-MNTH                                          32470000
MFA-TR*           ,:S-ADJUSTMENT-DATE                                   32480000
MFA-TR*           ,:S-ADJUSTMENT-AMT                                    32490000
MFA-TR*           ,:S-REMARKS-TEXT                                      32500000
MFA-TR*          )                                                      32510000
MFA-TR*    END-EXEC.                                                    32520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32530000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 32560000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R4 = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-HIST                
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R4            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04385_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 32740000
        8040-EXIT.                                                      
            EXIT.                                                       
      *                                                                 32770000
      ******************************************************************32780000
      * 8050-INSERT-GTT-R5.                                            *32790000
      ******************************************************************32800000
      *                                                                 32810000
       8050-INSERT-GTT-R5.                                              
      *                                                                 32830000
           IF WS-CRE-GTT-R5 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100E-DECLARE-GTT-R5    THRU 0100E-EXIT           
              MOVE 'Y'                        TO WS-CRE-GTT-R5          
           END-IF                                                       
           MOVE WS-RETURN-CODE-5              TO S-RETURN-CODE-5.       
      *                                                                 32910000
           EXEC SQL                                                     
              INSERT INTO #CSR04385_R5                           
                 (                                                      
                   RETURN_CODE                                          
                  ,OPTION_SEQ_NO                                        
                  ,OPTION_DESC                                          
                  ,AMT_BALANCE_DUE_TX                                   
                  ,AMT_BALANCE_DUE                                      
                  ,EST_BBP_AMT_TX                                       
                  ,EST_BBP_AMT                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-5                                     
                  ,:S-OPTION-SEQ-NO                                     
                  ,:S-OPTION-DESC                                       
                  ,:S-AMT-BALANCE-DUE-TX                                
                  ,:S-AMT-BALANCE-DUE                                   
                  ,:S-EST-BBP-AMT-TX                                    
                  ,:S-EST-BBP-AMT                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     32920000
MFA-TR*       INSERT INTO SESSION.CSR04385_R5                           32930000
MFA-TR*          (                                                      32940000
MFA-TR*            RETURN_CODE                                          32950000
MFA-TR*           ,OPTION_SEQ_NO                                        32960000
MFA-TR*           ,OPTION_DESC                                          32970000
MFA-TR*           ,AMT_BALANCE_DUE_TX                                   32980000
MFA-TR*           ,AMT_BALANCE_DUE                                      32990000
MFA-TR*           ,EST_BBP_AMT_TX                                       33000000
MFA-TR*           ,EST_BBP_AMT                                          33010000
MFA-TR*          )                                                      33020000
MFA-TR*       VALUES                                                    33030000
MFA-TR*          (                                                      33040000
MFA-TR*            :S-RETURN-CODE-5                                     33050000
MFA-TR*           ,:S-OPTION-SEQ-NO                                     33060000
MFA-TR*           ,:S-OPTION-DESC                                       33070000
MFA-TR*           ,:S-AMT-BALANCE-DUE-TX                                33080000
MFA-TR*           ,:S-AMT-BALANCE-DUE                                   33090000
MFA-TR*           ,:S-EST-BBP-AMT-TX                                    33100000
MFA-TR*           ,:S-EST-BBP-AMT                                       33110000
MFA-TR*          )                                                      33120000
MFA-TR*    END-EXEC.                                                    33130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33140000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 33170000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R5 = 'Y'             
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-ANNIV               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R5            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04385_R5'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 33350000
        8050-EXIT.                                                      
            EXIT.                                                       
      *                                                                 33380000
      ******************************************************************33390000
      * 8060-INSERT-GTT-R6.                                            *33400000
      ******************************************************************33410000
P00694*                                                                 33420000
P00694 8060-INSERT-GTT-R6.                                              
P00694*                                                                 33440000
P00694     IF WS-CRE-GTT-R6 = 'Y'                                       
P00694        CONTINUE                                                  
P00694     ELSE                                                         
P00694        PERFORM 0100F-DECLARE-GTT-R6    THRU 0100F-EXIT           
P00694        MOVE 'Y'                        TO WS-CRE-GTT-R6          
P00694     END-IF                                                       
P00694     MOVE WS-RETURN-CODE-6              TO S-RETURN-CODE-6.       
P00694*                                                                 33520000
P00694     EXEC SQL                                                     
P00694        INSERT INTO #CSR04385_R6                           
P00694           (                                                      
P00694              RETURN_CODE                                         
P00694             ,REVENUE_MONTH                                       
P00694             ,DAYS                                                
P00694             ,UNITS                                               
P00694             ,CODE_UTIL_TYPE                                      
P00694             ,CUSTOMER_NO                                         
P00694             ,NEW_CHARGE                                          
P00694             ,RATE_PLAN_NO                                        
P00694             ,CALC_ERROR                                          
P00694             ,HTG_CLG_SW                                          
P00694             ,EPP_CATEGORY                                        
P00694             ,ELEC_BUFFER                                         
P00694             ,GAS_BUFFER                                          
P00694            )                                                     
P00694         VALUES                                                   
P00694            (                                                     
P00694              :S-RETURN-CODE-6                                    
P00694             ,:S-REVENUE-MONTH                                    
P00694             ,:S-DAYS                                             
P00694             ,:S-UNITS                                            
P00694             ,:S-CODE-UTIL-TYPE                                   
P00694             ,:S-CUSTOMER-NO                                      
P00694             ,:S-NEW-CHARGE                                       
P00694             ,:S-RATE-PLAN-NO                                     
P00694             ,:S-CALC-ERROR                                       
P00694             ,:S-HTG-CLG-SW                                       
P00694             ,:S-BPP-CATEGORY                                     
P00694             ,:S-ELEC-BUFFER                                      
P00694             ,:S-GAS-BUFFER                                       
P00694           )                                                      
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     33530000
MFA-TR*       INSERT INTO SESSION.CSR04385_R6                           33540000
MFA-TR*          (                                                      33550000
MFA-TR*             RETURN_CODE                                         33560000
MFA-TR*            ,REVENUE_MONTH                                       33570000
MFA-TR*            ,DAYS                                                33580000
MFA-TR*            ,UNITS                                               33590000
MFA-TR*            ,CODE_UTIL_TYPE                                      33600000
MFA-TR*            ,CUSTOMER_NO                                         33610000
MFA-TR*            ,NEW_CHARGE                                          33620000
MFA-TR*            ,RATE_PLAN_NO                                        33630000
MFA-TR*            ,CALC_ERROR                                          33640000
MFA-TR*            ,HTG_CLG_SW                                          33650000
MFA-TR*            ,EPP_CATEGORY                                        33660000
MFA-TR*            ,ELEC_BUFFER                                         33670000
MFA-TR*            ,GAS_BUFFER                                          33680000
MFA-TR*           )                                                     33690000
MFA-TR*        VALUES                                                   33700000
MFA-TR*           (                                                     33710000
MFA-TR*             :S-RETURN-CODE-6                                    33720000
MFA-TR*            ,:S-REVENUE-MONTH                                    33730000
MFA-TR*            ,:S-DAYS                                             33740000
MFA-TR*            ,:S-UNITS                                            33750000
MFA-TR*            ,:S-CODE-UTIL-TYPE                                   33760000
MFA-TR*            ,:S-CUSTOMER-NO                                      33770000
MFA-TR*            ,:S-NEW-CHARGE                                       33780000
MFA-TR*            ,:S-RATE-PLAN-NO                                     33790000
MFA-TR*            ,:S-CALC-ERROR                                       33800000
MFA-TR*            ,:S-HTG-CLG-SW                                       33810000
MFA-TR*            ,:S-BPP-CATEGORY                                     33820000
MFA-TR*            ,:S-ELEC-BUFFER                                      33830000
MFA-TR*            ,:S-GAS-BUFFER                                       33840000
MFA-TR*          )                                                      33850000
MFA-TR*    END-EXEC.                                                    33860000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 33870000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 33900000
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
P00694                                WS-ERR-INSRT-R6 = 'Y'             
P00694        ADD +1                     TO  CTR-ROWS                   
P00694                                       WS-BBP-CNSMPT              
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
P00694        MOVE '8060'                TO  ACTIVE-PARAGRAPH           
P00694        MOVE SQLCODE               TO  ABEND-SQLCODE              
P00694        MOVE 'INSERT'              TO  ABEND-FUNCTION             
P00694        MOVE 'Y'                   TO  WS-ERR-INSRT-R6            
P00694        MOVE SPACES                TO  ABEND-SQL-PREDICATES       
P00694                                       ABEND-TABLES               
P00694        MOVE 'CSR04385_R6'         TO  TABLE-1                    
P00694        MOVE SPACES                TO  TABLE-ELEMENT-1            
P00694        MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 34080000
P00694  8060-EXIT.                                                      
P00694      EXIT.                                                       
      *                                                                 34110000
      ******************************************************************34120000
      * 8800-CHECK-RESULTS.                                            *34130000
      ******************************************************************34140000
      *                                                                 34150000
       8800-CHECK-RESULTS.                                              
      *                                                                 34170000
           IF WS-BBP-DET   = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO WS-RETURN-CODE-1        
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                 34230000
           IF WS-BBP-CHGS  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                       TO WS-RETURN-CODE-2        
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                 34290000
           IF WS-UTIL-CHGS = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                       TO WS-RETURN-CODE-3        
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                 34350000
           IF WS-BBP-HIST  = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                       TO WS-RETURN-CODE-4        
              PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT             
           END-IF.                                                      
      *                                                                 34410000
           IF WS-BBP-ANNIV = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 100                       TO WS-RETURN-CODE-5        
              PERFORM 8050-INSERT-GTT-R5     THRU 8050-EXIT             
           END-IF.                                                      
      *                                                                 34470000
P00694     IF WS-BBP-CNSMPT = 0                                         
P00694        INITIALIZE GTT-RETURN-FIELDS-6                            
P00694        MOVE 100                       TO WS-RETURN-CODE-6        
P00694        PERFORM 8060-INSERT-GTT-R6     THRU 8060-EXIT             
P00694     END-IF.                                                      
      *                                                                 34530000
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34560000
      ******************************************************************34570000
      * 8900-SEND-DONE.                                                *34580000
      ******************************************************************34590000
      *                                                                 34600000
       8900-SEND-DONE.                                                  
      *                                                                 34620000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34660000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 34690000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04385_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34810000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34850000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 34880000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04385_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 35000000
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 35040000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 35070000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04385_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 35190000
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 35230000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 35260000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04385_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 35380000
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 35420000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 35450000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04385_R5'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 35570000
P00694     EXEC SQL                                                     
P00694         OPEN C6                                                  
P00694     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00694*                                                                 35610000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-6.            
P00694*                                                                 35640000
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00694        CONTINUE                                                  
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE SQLCODE               TO ABEND-SQLCODE               
P00694        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P00694        MOVE '8900'                TO ACTIVE-PARAGRAPH            
P00694        MOVE 'OPEN'                TO ABEND-FUNCTION              
P00694        MOVE 'CSR04385_R6'         TO TABLE-1                     
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
      *                                                                 35760000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35790000
      ******************************************************************35800000
      * 9000-SEND-ERROR-RESULT                                         *35810000
      ******************************************************************35820000
      *                                                                 35830000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 35850000
           EVALUATE TRUE                                                
               WHEN WS-PLAN-DET                                         
                    MOVE S-RETURN-CODE-1    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
                                               WS-RETURN-CODE-5         
P00694                                         WS-RETURN-CODE-6         
               WHEN WS-MTHLY-CHGS                                       
                    MOVE S-RETURN-CODE-2    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
                                               WS-RETURN-CODE-5         
P00694                                         WS-RETURN-CODE-6         
               WHEN WS-USAGE                                            
                    MOVE S-RETURN-CODE-3    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
                                               WS-RETURN-CODE-5         
P00694                                         WS-RETURN-CODE-6         
               WHEN WS-REMARKS                                          
                    MOVE S-RETURN-CODE-4    TO WS-RETURN-CODE-1         
                                               WS-RETURN-CODE-2         
                                               WS-RETURN-CODE-3         
                                               WS-RETURN-CODE-4         
                                               WS-RETURN-CODE-5         
P00694                                         WS-RETURN-CODE-6         
P00694         WHEN WS-CNSMPT                                           
P00694              MOVE S-RETURN-CODE-6    TO WS-RETURN-CODE-1         
P00694                                         WS-RETURN-CODE-2         
P00694                                         WS-RETURN-CODE-3         
P00694                                         WS-RETURN-CODE-4         
P00694                                         WS-RETURN-CODE-5         
P00694                                         WS-RETURN-CODE-6         
           END-EVALUATE.                                                
      *                                                                 36230000
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE ' '                         TO S-APPL-RETURN-CODE-1     
           MOVE 'N'                         TO SEND-DONE-SW.            
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE.           
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
      *                                                                 36290000
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36330000
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
      *                                                                 36390000
           MOVE 'N'                         TO WS-CRE-GTT-R1            
                                               WS-CRE-GTT-R2            
                                               WS-CRE-GTT-R3            
                                               WS-CRE-GTT-R4            
                                               WS-CRE-GTT-R5            
P00694                                         WS-CRE-GTT-R6.           
      *                                                                 36460000
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
           PERFORM 8030-INSERT-GTT-R3       THRU 8030-EXIT.             
           PERFORM 8040-INSERT-GTT-R4       THRU 8040-EXIT.             
           PERFORM 8050-INSERT-GTT-R5       THRU 8050-EXIT.             
P00694     PERFORM 8060-INSERT-GTT-R6       THRU 8060-EXIT.             
      *                                                                 36530000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36560000
      ******************************************************************36570000
      * 9700-ABEND-PROCESSING.                                         *36580000
      ******************************************************************36590000
      *                                                                 36600000
       9700-PROCESS-ABEND.                                              
      *                                                                 36620000
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                 36650000
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36680000
      ******************************************************************36690000
      * 9900-SQL-ERROR-ROUTINE.                                        *36700000
      ******************************************************************36710000
      *                                                                 36720000
           EXEC SQL                                                     36730000
              INCLUDE CPDSP300                                          36740000
           END-EXEC.                                                    36750000
      *                                                                 36760000
      ******************************************************************36770000
      * 9999-END-PROGRAM.                                      *        36780000
      ******************************************************************36790000
      *                                                                 36800000
       9999-END-PROGRAM.                                                
      *                                                                 36820000
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                 
              PERFORM 8900-SEND-DONE     THRU 8900-EXIT                 
           END-IF.                                                      
      *                                                                 36950000
           
MSQ016        GOBACK.                                                    
      *                                                                 36970000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *37000000
      **********************End Of Program *****************************37010000
      *                                                                *37020000
