       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04383.                                     
COB303 DATE-WRITTEN.  AUG 18,2010                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS STA BPA DATA.                            *        
      *  RESULT SETS:                                                  *        
      *         1. STA Plan Details                                    *        
      *         2. Forecast notices                                    *        
      *                                                                *        
      *  All the Business Rules for STA being validated in CSR04366 &  *        
      *  this SPCB is call upon Account is eligible for STA.           *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00464*  08/18/10  AA97148    PROCEDURE ORIGINALLY CODED .             *        
      *                                                                *        
A03300*  05/20/11  SS42021    POPULATE FORCST-DNP-DATE ONLY IF         *        
      *                       VO-WANTED-BY-DATETIME IS VALID.          *        
A03300*  06/14/11  AA97148    NEXT READ DATE REPLACED WITH BILL CYCLE  *        
      *                       CLOSE DATE WHILE CALCULATING THE NEXT    *        
      *                       DNP DATE.                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04383'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                     PIC X(40) VALUE                  
            'WORKING STORAGE FOR CSR04383 STARTS HERE'.                 
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME              PIC X(08) VALUE 'CSR04383'.      
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-SQLSTATE               PIC X(05) VALUE SPACES.          
          05 WS-GTT-NAME               PIC X(19) VALUE SPACES.          
          05 WS-ADJ-DAY                PIC S9(9) COMP  VALUE +0.        
          05 WS-DAY-DNP-CD             PIC X(07) VALUE 'DAY-DNP'.       
          05 WS-DAY-DUE-CD             PIC X(07) VALUE 'DAY-DUE'.       
          05 WS-DAY-SECOND-MAIL-CD     PIC X(15) VALUE                  
                                                 'DAY-SECOND-MAIL'.     
          05 WS-DAY-STA-SECOND-MAIL-CD PIC X(19) VALUE                  
                                                 'DAY-STA-SECOND-MAIL'. 
          05 WS-WORK-DATE              PIC X(10) VALUE SPACES.          
          05 WS-CURRENT-DATE           PIC X(10) VALUE SPACES.          
          05 WS-TARGET-DATE            PIC X(10) VALUE SPACES.          
          05 WS-GUARNTR-TRSFR-DT       PIC X(10) VALUE SPACES.          
          05 WS-WRITE-OFF-DT           PIC X(10) VALUE SPACES.          
          05 WS-MIN-DATE-EXTRACT       PIC X(10) VALUE SPACES.          
          05 WS-MAX-DATE-EXTRACT       PIC X(10) VALUE SPACES.          
          05 WS-FIRST-NOTICE-DATE      PIC X(10) VALUE SPACES.          
          05 MCSCB068                  PIC X(08) VALUE 'MCSCB068'.      
          05 WS-GTT-IND-R1             PIC X(01) VALUE 'N'.             
          05 WS-GTT-IND-R2             PIC X(01) VALUE 'N'.             
          05 WS-NEW-DNP-FL             PIC X(01) VALUE SPACES.          
          05 WS-NULL-1                 PIC S9(04) COMP.                 
          05 WS-PSNC-COMP              PIC X(02) VALUE '26'.            
          05 WS-BILL-CYCLE             PIC X(02) VALUE SPACES.          
          05 WS-RETURN-CODE            PIC S9(04) COMP VALUE +0.        
          05 WS-REV-MONTH-NO           PIC 9(06) VALUE 0.               
          05 WS-HOLD-NEXT-REV-MONTH    PIC 9(06) VALUE 0.               
          05 WS-PREV-REVENUE-MONTH     PIC 9(06) VALUE 0.               
          05 WS-NEXT-REVENUE-MONTH     PIC 9(06) VALUE 0.               
          05 WS-NEXT-REV-MONTH REDEFINES WS-NEXT-REVENUE-MONTH.         
             10 WS-NEXT-REV-YR         PIC 9(04).                       
             10 WS-NEXT-REV-MTH        PIC 9(02).                       
          05 WS-DATE-CCYY-MM-DD.                                        
             10 WS-DATE-CCYY           PIC X(04) VALUE SPACES.          
             10 FILLER                 PIC X(01) VALUE SPACES.          
             10 WS-DATE-MM             PIC X(02) VALUE SPACES.          
             10 FILLER                 PIC X(01) VALUE SPACES.          
             10 WS-DATE-DD             PIC X(02) VALUE SPACES.          
          05 WS-YEAR-MONTH.                                             
             10 WS-YEAR                PIC 9(04) VALUE 0.               
             10 WS-MONTH               PIC 9(02) VALUE 0.               
          05 WS-CRED-ACTION-DT OCCURS 04 TIMES INDEXED BY CRED-INDX.    
             10 IN-CRED-ACTION-DT      PIC X(10).                       
             10 IN-DNP-TYPE            PIC X(01).                       
          05 WS-CRED-ACT-ROWS          PIC S9(4) COMP VALUE 0.          
          05 WS-NO-CRED-ACT-ROWS       PIC S9(4) COMP VALUE 0.          
          05 WS-CRED-FL                PIC X(01) VALUE 'N'.             
          05 WS-YES                    PIC X(01) VALUE 'Y'.             
          05 WS-NO                     PIC X(01) VALUE 'N'.             
          05 WS-NXT-DNP-TYPE           PIC X(01) VALUE SPACES.          
          05 WS-DNP-TYPE               PIC X(01) VALUE SPACES.          
          05 WS-NEAREST-DNP-DT         PIC X(10) VALUE SPACES.          
          05 WS-NXT-NEAR-DNP-DT        PIC X(10) VALUE SPACES.          
          05 WS-ZERO                   PIC 9(01) VALUE 0.               
          05 WS-NULL-IND-CPD           PIC S9(4) COMP VALUE 0.          
          05 WS-CPD310-NULL-IND        PIC S9(4) COMP VALUE 0.          
          05 RS-RETURN-CODE            PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01 WS-DELINQUENCY-WS USAGE COMP-3.                               
          05 WS-DAY-DUE                PIC S9(05) COMP-3 VALUE +0.      
          05 WS-DAY-DNP                PIC S9(05) COMP-3 VALUE +0.      
          05 WS-DAY-SECOND-MAIL        PIC S9(05) COMP-3 VALUE +0.      
          05 WS-DAY-STA-SECOND-MAIL    PIC S9(05) COMP-3 VALUE +0.      
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                  PIC S9(09) COMP VALUE 0.         
          05 WS-PLAN-DTLS              PIC S9(09) COMP VALUE 0.         
          05 WS-FRCST-DTLS             PIC S9(09) COMP VALUE 0.         
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01) VALUE 'Y'.             
             88 SEND-DONE-ERROR                  VALUE 'N'.             
             88 SEND-DONE-OK                     VALUE 'Y'.             
          05 WS-DATABASE               PIC 9(01) VALUE ZERO.            
             88 CSR-DATABASE                     VALUE 1.               
             88 SEB-DATABASE                     VALUE 2.               
          05 WS-COMPANY                PIC 9(02) VALUE ZERO.            
             88 WS-SCEG                          VALUE 01.              
             88 WS-PSNC                          VALUE 26.              
          05 WS-REG-GROUP              PIC X(01) VALUE SPACES.          
             88 WS-REG                           VALUE 'Y'.             
             88 WS-DEREG                         VALUE 'N'.             
          05 WS-PREV-BUS-DAY-FLAG      PIC X(01) VALUE 'N'.             
             88 PREV-BUS-DAY-FOUND               VALUE 'Y'.             
      *                                                                         
       01 WS-WORK-DAY-TABLE.                                            
          05 WS-WORK-DAY-LIST                                           
                  OCCURS 120 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
             10 WS-WORK-DAY            PIC X(10).                       
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09)      COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1        PIC S9(09)      COMP VALUE 0.    
             10 S-STA-AMOUNT           PIC S9(09)V99   COMP-3 VALUE +0. 
             10 S-NEW-STA-DUE-DATE     PIC X(10)       VALUE SPACES.    
             10 S-NEW-STA-DNP-DATE     PIC X(10)       VALUE SPACES.    
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(09)      COMP VALUE 0.    
             10 S-APPL-PGM-ID          PIC X(07)       VALUE SPACES.    
             10 S-SSN                  PIC X(09)       VALUE SPACES.    
             10 S-FORCST-DNP-DATE      PIC X(10)       VALUE SPACES.    
             10 S-DATE-FRST-NOTICE     PIC X(10)       VALUE SPACES.    
             10 S-DATE-SCND-NOTICE     PIC X(10)       VALUE SPACES.    
             10 S-DNP-TYPE             PIC X(01)       VALUE SPACES.    
             10 S-NON-UTIL-PAST-DUE    PIC S9(09)V9(2) COMP-3 VALUE 0.  
             10 S-DATE-PYMNT-CUST      PIC X(10)       VALUE SPACES.    
             10 S-PYMNT-METHOD         PIC X(25)       VALUE SPACES.    
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      * ERROR WORK AREA                                                *        
      ******************************************************************        
      *                                                                         
           COPY CWS00027.                                                       
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT  - AT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BILL_WINDOW - BN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DELINQUENCY - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_HOLIDAY - J8                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM - G6                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_READ_WINDOW - RW                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_REG_PROFILE - LR                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CRED_FORECAST - CM                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRFCST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_FIN_WO_ACTION - KD                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFWACTN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SO_DATA       - VO                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT  - UT                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00068                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00309                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00309                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00068                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00056.                                                       
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00315                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR CSR04383 ENDS HERE  '.            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO             PIC  9(13).                      
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '01'                         TO C8-COMPANY-NO.          
           MOVE 'DATABASE'                   TO C8-DELINQ-CD.           
           MOVE ZERO                         TO WS-DATABASE.            
           PERFORM 7250-SELECT-DELINQ        THRU 7250-EXIT.            
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1                                           *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-R1.                                            
      *                                                                         
           MOVE 'SESSION.CSR04383_R1'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04383_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04383_R1
              (                                                       
                  RETURN_CODE           INT                         
                 ,STA_AMOUNT            DECIMAL(11,2)                   
                 ,NEW_STA_DUE_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,NEW_STA_DNP_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS     THRU 8000A-EXIT            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04383_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04383_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2.                                          *        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-R2.                                            
      *                                                                         
           MOVE 'SESSION.CSR04383_R2'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04383_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04383_R2
              (                                                       
                  RETURN_CODE             INT                       
                 ,APPL_PGM_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2                 
                 ,FORCST_DNP_DATE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                 ,DATE_FRST_NOTICE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                 ,DATE_SCND_NOTICE CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                 ,DNP_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,NON_UTIL_PAST_DUE       DECIMAL(11,2)                 
                 ,DATE_PYMNT_CUST CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                 ,PYMNT_METHOD CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-RETURN-CODE.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS     THRU 8000B-EXIT            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04383_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04383_R2                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO              TO AT-ACCOUNT-NO           
                                                LR-ACCOUNT-NO           
                                                KD-ACCOUNT-NO           
                                                VO-ACCOUNT-NO.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7100-SELECT-ACCOUNT       THRU 7100-EXIT.            
           MOVE AT-COMPANY-NO                TO WS-COMPANY              
                                                CM-COMPANY-NO.          
      *                                                                         
           IF SEB-DATABASE                                              
              PERFORM 7300-GET-REG-PROFILE   THRU 7300-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 7400-GET-CURRENT-DATE     THRU 7400-EXIT.            
      *                                                                         
      * Select Total billed balance & Next DNP date.                            
      *                                                                         
           PERFORM 2100-CALL-MCSCB068        THRU 2100-EXIT.            
           PERFORM 2150-LOAD-CRED-ACT-DT     THRU 2150-EXIT             
           IF WS-NEW-DNP-FL = 'Y'                                       
              IF WS-NO-CRED-ACT-ROWS = 1                                
                 MOVE WS-DNP-TYPE                  TO S-DNP-TYPE        
                 MOVE WS-NEAREST-DNP-DT            TO S-FORCST-DNP-DATE 
              ELSE                                                      
                 PERFORM 7800-GET-FORCST-DT-SO     THRU 7800-EXIT       
                 MOVE SPACES                       TO S-DNP-TYPE        
A03300           IF VO-WANTED-BY-DATETIME > SPACES                      
                    MOVE VO-WANTED-BY-DATETIME(1:10)                    
                      TO S-FORCST-DNP-DATE                              
A03300           ELSE                                                   
A03300              MOVE SPACES  TO S-FORCST-DNP-DATE                   
A03300           END-IF                                                 
              END-IF                                                    
              PERFORM 5100-GET-DELINQ-VALUES THRU 5100-EXIT             
              MOVE AT-BILL-CYCLE             TO WS-BILL-CYCLE           
                                                CM-BILL-CYCLE           
      * Get Next Revenue Month                                                  
              MOVE AT-REV-MTH-LST-NRML       TO WS-PREV-REVENUE-MONTH   
                                                WS-REV-MONTH-NO         
                                                CM-REVENUE-MONTH        
              PERFORM 5000-LOAD-WORK-DAYS    THRU 5000-EXIT             
              PERFORM 5900-NEXT-BILL-DATE    THRU                       
                                             5900-NEXT-BILL-DATE-EXIT   
              MOVE BN-REVENUE-MONTH          TO WS-NEXT-REVENUE-MONTH   
                                                WS-HOLD-NEXT-REV-MONTH  
           END-IF.                                                      
           MOVE WS-AMT-PAST-DUE-NONUTL       TO S-NON-UTIL-PAST-DUE.    
      *                                                                         
      * Evaluate STA process based on company                                   
      *                                                                         
           EVALUATE TRUE                                                
              WHEN CSR-DATABASE AND WS-SCEG                             
                   PERFORM 2200-PROCESS-SCEG-ACCTS  THRU 2200-EXIT      
              WHEN CSR-DATABASE AND WS-PSNC                             
                   PERFORM 2300-PROCESS-PSNC-ACCTS  THRU 2300-EXIT      
              WHEN SEB-DATABASE AND WS-REG                              
                   PERFORM 2400-PROCESS-REG-ACCTS   THRU 2400-EXIT      
              WHEN SEB-DATABASE AND WS-DEREG                            
                   PERFORM 2500-PROCESS-DEREG-ACCTS THRU 2500-EXIT      
              WHEN OTHER                                                
                   MOVE -1                   TO WS-ACTIVE-RETURN-CODE   
                                                WS-RETURN-CODE          
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '2000'               TO ACTIVE-PARAGRAPH        
                   MOVE 'COMPNYER'           TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT      
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-CALL-MCSCB068.                                            *        
      ******************************************************************        
      *                                                                         
       2100-CALL-MCSCB068.                                              
      *                                                                         
      * Set CPD00068 Switches that are needed                                   
      *                                                                         
           MOVE 'Y' TO CALC-BALANCE-SW                                  
                       CALC-ARREARS-SW                                  
                       LOAD-DNP-DATE-SW                                 
                       LOAD-DUE-DATES-SW                                
                       CALC-PAST-DUE-SW.                                
      *                                                                         
           MOVE PROGRAM-NAME                 TO WS-CPD00068-CALLING-PGM.
           MOVE SPACES                       TO ABEND-FUNCTION.         
           PERFORM 5200-CALL-MCSCB068        THRU 5200-EXIT.            
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2150-LOAD-CRED-ACT-DT.                                         *        
      ******************************************************************        
      *                                                                         
       2150-LOAD-CRED-ACT-DT.                                           
      *                                                                         
           MOVE WS-DATE-CREDIT-ACTION-D    TO IN-CRED-ACTION-DT(1).     
           MOVE 'D'                        TO IN-DNP-TYPE(1).           
           MOVE WS-DATE-CREDIT-ACTION-G    TO IN-CRED-ACTION-DT(2).     
           MOVE 'G'                        TO IN-DNP-TYPE(2).           
           MOVE WS-DATE-CREDIT-ACTION-H    TO IN-CRED-ACTION-DT(3).     
           MOVE 'H'                        TO IN-DNP-TYPE(3).           
           MOVE WS-DATE-CREDIT-ACTION-I    TO IN-CRED-ACTION-DT(4).     
           MOVE 'I'                        TO IN-DNP-TYPE(4).           
      *                                                                         
           MOVE 4                          TO WS-CRED-ACT-ROWS.         
           PERFORM VARYING CRED-INDX FROM 1 BY 1                        
              UNTIL CRED-INDX > WS-CRED-ACT-ROWS                        
              IF IN-CRED-ACTION-DT(CRED-INDX) = SPACES                  
                 MOVE '1900-01-01'       TO IN-CRED-ACTION-DT(CRED-INDX)
                 MOVE SPACES             TO IN-DNP-TYPE(CRED-INDX)      
              END-IF                                                    
              IF WS-CRED-FL = 'N'                                       
                 IF IN-CRED-ACTION-DT(CRED-INDX) > WS-CURRENT-DATE      
                    MOVE IN-CRED-ACTION-DT(CRED-INDX) TO                
                                                  WS-NEAREST-DNP-DT     
                    MOVE IN-DNP-TYPE(CRED-INDX)       TO WS-DNP-TYPE    
                    MOVE 'Y'                          TO WS-CRED-FL     
                    ADD +1                        TO WS-NO-CRED-ACT-ROWS
                 END-IF                                                 
              ELSE                                                      
                 IF IN-CRED-ACTION-DT(CRED-INDX) > WS-CURRENT-DATE      
                    IF IN-CRED-ACTION-DT(CRED-INDX) < WS-NEAREST-DNP-DT 
                       MOVE IN-CRED-ACTION-DT(CRED-INDX) TO             
                                                    WS-NEAREST-DNP-DT   
                       MOVE IN-DNP-TYPE(CRED-INDX)       TO WS-DNP-TYPE 
                    END-IF                                              
                    ADD +1                        TO WS-NO-CRED-ACT-ROWS
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           IF WS-NO-CRED-ACT-ROWS > 1                                   
              MOVE 'N'                        TO WS-NEW-DNP-FL          
              MOVE 'N'                        TO WS-CRED-FL             
              SET  WS-ZERO                    TO CRED-INDX              
              PERFORM VARYING CRED-INDX FROM 1 BY 1                     
                UNTIL CRED-INDX > WS-CRED-ACT-ROWS                      
                 IF IN-CRED-ACTION-DT(CRED-INDX) = SPACES               
                    MOVE '1900-01-01'    TO IN-CRED-ACTION-DT(CRED-INDX)
                    MOVE SPACES             TO IN-DNP-TYPE(CRED-INDX)   
                 END-IF                                                 
                 IF WS-CRED-FL = 'N'                                    
                    IF IN-CRED-ACTION-DT(CRED-INDX) > WS-NEAREST-DNP-DT 
                       MOVE IN-CRED-ACTION-DT(CRED-INDX) TO             
                                                      WS-NXT-NEAR-DNP-DT
                       MOVE IN-DNP-TYPE(CRED-INDX)   TO WS-NXT-DNP-TYPE 
                       MOVE 'Y'                      TO WS-CRED-FL      
                    END-IF                                              
                 ELSE                                                   
                    IF IN-CRED-ACTION-DT(CRED-INDX) < WS-NXT-NEAR-DNP-DT
                    AND IN-CRED-ACTION-DT(CRED-INDX) > WS-NEAREST-DNP-DT
                        MOVE IN-CRED-ACTION-DT(CRED-INDX) TO            
                                                  WS-NXT-NEAR-DNP-DT    
                        MOVE IN-DNP-TYPE(CRED-INDX)  TO WS-NXT-DNP-TYPE 
                    END-IF                                              
                 END-IF                                                 
              END-PERFORM                                               
              EVALUATE WS-NXT-DNP-TYPE                                  
                  WHEN 'D'                                              
                      MOVE WS-DATE-NOTICE-MAIL-B   TO S-DATE-FRST-NOTICE
                      MOVE WS-DATE-NOTICE-MAIL-C   TO S-DATE-SCND-NOTICE
                  WHEN 'G'                                              
                      MOVE WS-DATE-NOTICE-MAIL-E   TO S-DATE-FRST-NOTICE
                      MOVE WS-DATE-NOTICE-MAIL-F   TO S-DATE-SCND-NOTICE
                  WHEN 'H'                                              
                      MOVE SPACES                  TO S-DATE-FRST-NOTICE
                      MOVE WS-DATE-NOTICE-MAIL-N   TO S-DATE-SCND-NOTICE
                  WHEN 'I'                                              
                      MOVE SPACES                  TO S-DATE-FRST-NOTICE
                      MOVE WS-DATE-NOTICE-MAIL-O   TO S-DATE-SCND-NOTICE
              END-EVALUATE                                              
              MOVE WS-RETURN-CODE                  TO S-RETURN-CODE-1   
                                                      S-RETURN-CODE-2   
              MOVE WS-NEAREST-DNP-DT               TO S-FORCST-DNP-DATE 
              MOVE WS-NXT-NEAR-DNP-DT              TO S-NEW-STA-DNP-DATE
              MOVE WS-NXT-NEAR-DNP-DT             TO WS-NEW-BUSINESS-DAY
              PERFORM 6525-PREV-BUSINESS-DAY       THRU                 
               6525-PREV-BUSINESS-DAY-EXIT UNTIL NEXT-BUSINESS-DAY-FOUND
              MOVE WS-NEW-BUSINESS-DAY             TO S-NEW-STA-DUE-DATE
              MOVE 'BPA'                           TO S-APPL-PGM-ID     
              MOVE WS-DNP-TYPE                     TO S-DNP-TYPE        
              MOVE WS-AMT-PAST-DUE-NONUTL         TO S-NON-UTIL-PAST-DUE
              IF AT-CODE-ACCT-STAT = 'B'                                
                 MOVE WS-TOTAL-BALANCE             TO S-STA-AMOUNT      
              ELSE                                                      
                 IF SEB-DATABASE AND WS-REG AND AT-CREDIT-GROUP = 'B'   
                    MOVE WS-TOTAL-BALANCE-UTL      TO S-STA-AMOUNT      
                 ELSE                                                   
                    MOVE WS-AMT-PAST-DUE-UTL       TO S-STA-AMOUNT      
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
              GO TO 2000-EXIT                                           
           ELSE                                                         
              MOVE 'Y'                          TO WS-NEW-DNP-FL        
           END-IF.                                                      
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-SCEG-ACCTS                                        *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-SCEG-ACCTS.                                         
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'B'                                   
               PERFORM 2600-PROCESS-FINAL-BILL    THRU 2600-EXIT        
           ELSE                                                         
              PERFORM 5901-NEXT-READ-DATE THRU 5901-NEXT-READ-DATE-EXIT 
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF RW-THIRD-PTY-READ-DT > SPACES                       
                    MOVE RW-THIRD-PTY-READ-DT TO WS-TARGET-DATE         
                 ELSE                                                   
                    MOVE RW-OPTIMUM-READ-DATE TO WS-TARGET-DATE         
                 END-IF                                                 
              ELSE                                                      
                 MOVE SPACES                  TO WS-TARGET-DATE         
              END-IF                                                    
      *                                                                         
              PERFORM 2800-SEARCH-FOR-DATE       THRU 2800-EXIT         
      *                                                                         
              IF CSR-DATABASE AND AT-COMPANY-NO  = WS-PSNC-COMP         
                  SET WD-INDX UP BY WS-DAY-DUE                          
              END-IF                                                    
      *                                                                         
              MOVE WS-WORK-DAY (WD-INDX)         TO S-NEW-STA-DNP-DATE  
              SET WD-INDX DOWN BY WS-DAY-STA-SECOND-MAIL                
              MOVE WS-WORK-DAY (WD-INDX)         TO S-DATE-SCND-NOTICE  
              MOVE SPACES                        TO S-DATE-FRST-NOTICE  
      *                                                                         
              SET WD-INDX UP BY WS-DAY-STA-SECOND-MAIL                  
              SET WD-INDX DOWN BY 1                                     
              MOVE WS-WORK-DAY (WD-INDX)         TO S-NEW-STA-DUE-DATE  
              IF S-NEW-STA-DUE-DATE < WS-CURRENT-DATE                   
                 MOVE WS-HOLD-NEXT-REV-MONTH     TO WS-YEAR-MONTH       
                 ADD 1                           TO WS-MONTH            
                 IF WS-MONTH = 13                                       
                    MOVE 1                       TO WS-MONTH            
                    ADD  1                       TO WS-YEAR             
                 END-IF                                                 
                 MOVE WS-YEAR-MONTH            TO WS-HOLD-NEXT-REV-MONTH
                 MOVE 'N'                        TO WS-PREV-BUS-DAY-FLAG
                 GO TO 2200-PROCESS-SCEG-ACCTS                          
              END-IF                                                    
              MOVE WS-AMT-PAST-DUE-UTL           TO S-STA-AMOUNT        
           END-IF.                                                      
           MOVE 'BPA'                       TO S-APPL-PGM-ID.           
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-PSNC-ACCTS.                                       *        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-PSNC-ACCTS.                                         
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'B'                                   
               PERFORM 2600-PROCESS-FINAL-BILL    THRU 2600-EXIT        
           ELSE                                                         
               PERFORM 5901-NEXT-READ-DATE THRU 5901-NEXT-READ-DATE-EXIT
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF RW-THIRD-PTY-READ-DT > SPACES                      
                     MOVE RW-THIRD-PTY-READ-DT TO WS-TARGET-DATE        
                  ELSE                                                  
                     MOVE RW-OPTIMUM-READ-DATE TO WS-TARGET-DATE        
                  END-IF                                                
               ELSE                                                     
                  MOVE SPACES                  TO WS-TARGET-DATE        
               END-IF                                                   
               PERFORM 2800-SEARCH-FOR-DATE    THRU 2800-EXIT           
      *                                                                         
               SET WD-INDX UP BY WS-DAY-DUE                             
      *                                                                         
               MOVE WS-WORK-DAY (WD-INDX)         TO S-NEW-STA-DNP-DATE 
               SET WD-INDX DOWN BY WS-DAY-STA-SECOND-MAIL               
               MOVE WS-WORK-DAY (WD-INDX)         TO S-DATE-SCND-NOTICE 
               MOVE SPACES                        TO S-DATE-FRST-NOTICE 
      *                                                                         
               SET WD-INDX UP BY WS-DAY-STA-SECOND-MAIL                 
               SET WD-INDX DOWN BY 1                                    
               MOVE WS-WORK-DAY (WD-INDX)         TO S-NEW-STA-DUE-DATE 
               IF S-NEW-STA-DUE-DATE < WS-CURRENT-DATE                  
                  MOVE WS-HOLD-NEXT-REV-MONTH  TO WS-YEAR-MONTH         
                  ADD 1                        TO WS-MONTH              
                  IF WS-MONTH = 13                                      
                     MOVE 1                    TO WS-MONTH              
                     ADD  1                    TO WS-YEAR               
                  END-IF                                                
                  MOVE WS-YEAR-MONTH           TO WS-HOLD-NEXT-REV-MONTH
                  MOVE 'N'                     TO WS-PREV-BUS-DAY-FLAG  
                  GO TO 2300-PROCESS-PSNC-ACCTS                         
               END-IF                                                   
               MOVE WS-AMT-PAST-DUE-UTL           TO S-STA-AMOUNT       
           END-IF.                                                      
           MOVE 'BPA'                       TO S-APPL-PGM-ID.           
           PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT.             
           PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT.             
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-PROCESS-REG-ACCTS.                                        *        
      ******************************************************************        
      *                                                                         
       2400-PROCESS-REG-ACCTS.                                          
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'B'                                   
               PERFORM 2600-PROCESS-FINAL-BILL   THRU 2600-EXIT         
           ELSE                                                         
               MOVE WS-NEXT-REVENUE-MONTH        TO BN-REVENUE-MONTH    
               PERFORM 7450-SELECT-BILL-CYCLE-DT THRU 7450-EXIT         
               IF WS-MIN-DATE-EXTRACT < WS-CURRENT-DATE                 
                  MOVE WS-HOLD-NEXT-REV-MONTH    TO WS-YEAR-MONTH       
                  ADD 1                          TO WS-MONTH            
                  IF WS-MONTH = 13                                      
                     MOVE 1                      TO WS-MONTH            
                     ADD  1                      TO WS-YEAR             
                  END-IF                                                
                  MOVE WS-YEAR-MONTH          TO WS-HOLD-NEXT-REV-MONTH 
                  MOVE WS-HOLD-NEXT-REV-MONTH    TO BN-REVENUE-MONTH    
                  PERFORM 7450-SELECT-BILL-CYCLE-DT THRU 7450-EXIT      
               END-IF                                                   
               MOVE WS-MIN-DATE-EXTRACT          TO S-NEW-STA-DUE-DATE  
               MOVE WS-MAX-DATE-EXTRACT          TO WS-TARGET-DATE      
               PERFORM 2800-SEARCH-FOR-DATE      THRU 2800-EXIT         
               SET WD-INDX UP BY WS-DAY-DUE                             
               MOVE WS-WORK-DAY (WD-INDX)        TO WS-FIRST-NOTICE-DATE
A03300*   TARGET DATE CONTAINS BILL CLOSE DATE                                  
A03300         SET WD-INDX DOWN BY WS-DAY-DUE                           
               SET WD-INDX UP BY WS-DAY-DNP                             
               MOVE WS-WORK-DAY (WD-INDX)        TO S-NEW-STA-DNP-DATE  
               IF AT-CREDIT-GROUP = 'B'                                 
                   MOVE CM-REVENUE-MONTH     TO WS-HOLD-NEXT-REV-MONTH  
                   MOVE WS-HOLD-NEXT-REV-MONTH    TO WS-YEAR-MONTH      
                   ADD 1                          TO WS-MONTH           
                   IF WS-MONTH = 13                                     
                       MOVE 1                      TO WS-MONTH          
                       ADD  1                      TO WS-YEAR           
                   END-IF                                               
                   MOVE WS-YEAR-MONTH         TO WS-HOLD-NEXT-REV-MONTH 
                   MOVE WS-HOLD-NEXT-REV-MONTH    TO CM-REVENUE-MONTH   
                   PERFORM 7600-SELECT-CRED-FORECAST THRU 7600-EXIT     
                   MOVE CM-DNP-DT                 TO S-NEW-STA-DNP-DATE 
                   MOVE WS-TOTAL-BALANCE-UTL      TO S-STA-AMOUNT       
               ELSE                                                     
                  MOVE WS-AMT-PAST-DUE-UTL       TO S-STA-AMOUNT        
               END-IF                                                   
           END-IF.                                                      
           MOVE SPACES                       TO S-DATE-FRST-NOTICE.     
           MOVE SPACES                       TO S-DATE-SCND-NOTICE.     
           MOVE 'BPA'                        TO S-APPL-PGM-ID.          
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
           PERFORM 8020-INSERT-GTT-R2        THRU 8020-EXIT.            
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-PROCESS-DEREG-ACCTS.                                      *        
      ******************************************************************        
      *                                                                         
       2500-PROCESS-DEREG-ACCTS.                                        
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'B'                                   
               PERFORM 2600-PROCESS-FINAL-BILL   THRU 2600-EXIT         
           ELSE                                                         
               MOVE WS-NEXT-REVENUE-MONTH        TO BN-REVENUE-MONTH    
                                                    RW-REVENUE-MONTH    
               PERFORM 7450-SELECT-BILL-CYCLE-DT THRU 7450-EXIT         
               IF WS-MIN-DATE-EXTRACT < WS-CURRENT-DATE                 
                  MOVE WS-HOLD-NEXT-REV-MONTH    TO WS-YEAR-MONTH       
                  ADD 1                          TO WS-MONTH            
                  IF WS-MONTH = 13                                      
                     MOVE 1                      TO WS-MONTH            
                     ADD  1                      TO WS-YEAR             
                  END-IF                                                
                  MOVE WS-YEAR-MONTH        TO WS-HOLD-NEXT-REV-MONTH   
                  MOVE WS-HOLD-NEXT-REV-MONTH    TO BN-REVENUE-MONTH    
                  PERFORM 7450-SELECT-BILL-CYCLE-DT THRU 7450-EXIT      
               END-IF                                                   
               MOVE WS-MIN-DATE-EXTRACT          TO S-NEW-STA-DUE-DATE  
               MOVE WS-MAX-DATE-EXTRACT          TO WS-TARGET-DATE      
               PERFORM 2800-SEARCH-FOR-DATE      THRU 2800-EXIT         
               SET WD-INDX UP BY WS-DAY-DUE                             
               MOVE WS-WORK-DAY (WD-INDX)    TO WS-FIRST-NOTICE-DATE    
A03300*   TARGET DATE CONTAINS BILL CLOSE DATE                                  
A03300         SET WD-INDX DOWN BY WS-DAY-DUE                           
               SET WD-INDX UP BY WS-DAY-DNP                             
               MOVE WS-WORK-DAY (WD-INDX)        TO S-NEW-STA-DNP-DATE  
               IF AT-CREDIT-GROUP = 'B'                                 
                  MOVE CM-REVENUE-MONTH      TO WS-HOLD-NEXT-REV-MONTH  
                  MOVE WS-HOLD-NEXT-REV-MONTH    TO WS-YEAR-MONTH       
                  ADD 1                          TO WS-MONTH            
                  IF WS-MONTH = 13                                      
                     MOVE 1                      TO WS-MONTH            
                     ADD  1                      TO WS-YEAR             
                  END-IF                                                
                  MOVE WS-YEAR-MONTH         TO WS-HOLD-NEXT-REV-MONTH  
                  MOVE WS-HOLD-NEXT-REV-MONTH    TO CM-REVENUE-MONTH    
                  PERFORM 7600-SELECT-CRED-FORECAST  THRU 7600-EXIT     
                  MOVE CM-DNP-DT             TO S-NEW-STA-DNP-DATE      
               END-IF                                                   
               MOVE WS-AMT-PAST-DUE-UTL      TO S-STA-AMOUNT            
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                       TO S-DATE-FRST-NOTICE.     
           MOVE SPACES                       TO S-DATE-SCND-NOTICE.     
           MOVE 'BPA'                        TO S-APPL-PGM-ID.          
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
           PERFORM 8020-INSERT-GTT-R2        THRU 8020-EXIT.            
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-PROCESS-FINAL-BILL.                                       *        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-FINAL-BILL.                                         
      *                                                                         
           IF CSR-DATABASE                                              
              MOVE 'GAXF'                      TO KD-FW-ACTION-TYPE-CD  
              PERFORM 7700-SELECT-FW-ACTION-DT THRU 7700-EXIT           
              MOVE KD-FW-ACTION-DT             TO WS-GUARNTR-TRSFR-DT   
           END-IF.                                                      
           MOVE 'WO'                       TO KD-FW-ACTION-TYPE-CD.     
           PERFORM 7700-SELECT-FW-ACTION-DT   THRU 7700-EXIT.           
           MOVE KD-FW-ACTION-DT            TO WS-WRITE-OFF-DT.          
           IF WS-GUARNTR-TRSFR-DT > SPACES                              
               MOVE WS-GUARNTR-TRSFR-DT    TO S-NEW-STA-DUE-DATE        
           ELSE                                                         
               MOVE WS-WRITE-OFF-DT        TO S-NEW-STA-DUE-DATE        
           END-IF.                                                      
           MOVE SPACES                     TO S-DNP-TYPE.               
           MOVE WS-WRITE-OFF-DT            TO S-NEW-STA-DNP-DATE.       
           MOVE WS-TOTAL-BALANCE           TO S-STA-AMOUNT.             
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2800-SEARCH-FOR-DATE.                                        *          
      ****************************************************************          
      *                                                                         
       2800-SEARCH-FOR-DATE.                                            
      *                                                                         
           SET WD-INDX TO 1.                                            
                                                                        
           SEARCH WS-WORK-DAY-LIST                                      
              AT END                                                    
                MOVE -1                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-RETURN-CODE          
                MOVE 'CSR04383'              TO ABEND-PROGRAM           
                MOVE '2500'                  TO ACTIVE-PARAGRAPH        
                MOVE 'SEARCH'                TO ABEND-FUNCTION          
                MOVE 'WORK DAY  '            TO TABLE-1                 
                MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1         
                MOVE WS-TARGET-DATE          TO HOSTVAR-ELEMENT-1       
                PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT             
                                                                        
              WHEN WS-WORK-DAY (WD-INDX) = WS-TARGET-DATE               
                CONTINUE                                                
           END-SEARCH.                                                  
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-LOAD-WORK-DAYS.                                           *        
      * LOAD NEXT 4 MONTHS WORK DAYS INTO TABLE FROM FIRST DATE        *        
      * OF REVENUE MONTH.  NEEDED FOR FORECASTING. ENTRY 001 IS        *        
      * THE OPEN DAY OF THE REVENUE MONTH.  1 THROUGH 120 ENTRIES      *        
      * WILL EXIST.                                                    *        
      ******************************************************************        
      *                                                                         
       5000-LOAD-WORK-DAYS.                                             
      *                                                                         
           MOVE WS-REV-MONTH-NO                TO BN-REVENUE-MONTH      
           PERFORM 7150-SELECT-MIN-DT-EXTRACT  THRU 7150-EXIT.          
           SET WD-INDX                         TO 1.                    
           MOVE WS-MIN-DATE-EXTRACT            TO WS-DATE-CCYY-MM-DD.   
           MOVE WS-DATE-CCYY-MM-DD             TO WS-WORK-DAY (WD-INDX).
           SET WD-INDX                         TO 2.                    
           MOVE 1                              TO WS-ADJ-DAY.           
      *                                                                         
           PERFORM UNTIL WD-INDX > 120                                  
              OR WS-ADJ-DAY > 365                                       
              PERFORM 7200-GET-NEXT-WORK-DAY   THRU 7200-EXIT           
           END-PERFORM.                                                 
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-GET-DELINQ-VALUES                                         *        
      ******************************************************************        
      *                                                                         
       5100-GET-DELINQ-VALUES.                                          
      *                                                                         
           MOVE  AT-COMPANY-NO               TO C8-COMPANY-NO.          
           MOVE  WS-DAY-SECOND-MAIL-CD       TO C8-DELINQ-CD            
           PERFORM 7250-SELECT-DELINQ        THRU 7250-EXIT.            
           MOVE  C8-DELINQ-VALUE             TO WS-DAY-SECOND-MAIL.     
      *                                                                         
           MOVE  WS-DAY-STA-SECOND-MAIL-CD   TO C8-DELINQ-CD            
           PERFORM 7250-SELECT-DELINQ        THRU 7250-EXIT.            
           MOVE  C8-DELINQ-VALUE             TO WS-DAY-STA-SECOND-MAIL. 
      *                                                                         
           MOVE  WS-DAY-DNP-CD               TO C8-DELINQ-CD.           
           PERFORM 7250-SELECT-DELINQ        THRU 7250-EXIT.            
           MOVE  C8-DELINQ-VALUE             TO WS-DAY-DNP.             
      *                                                                         
           MOVE  WS-DAY-DUE-CD               TO C8-DELINQ-CD.           
           PERFORM 7250-SELECT-DELINQ        THRU 7250-EXIT.            
           MOVE  C8-DELINQ-VALUE             TO WS-DAY-DUE.             
      *                                                                         
      * Validate Delinquency Values                                             
      *                                                                         
           IF WS-DAY-DUE         > ZERO AND                             
              WS-DAY-SECOND-MAIL > ZERO                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE -1                        TO WS-ACTIVE-RETURN-CODE   
                                                WS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELINQER'                TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-CALL-MCSCB068.                                            *        
      ******************************************************************        
      *                                                                         
       5200-CALL-MCSCB068.                                              
      *                                                                         
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 S-RETURN-CODE.                         
      *                                                                         
           MOVE S-RETURN-CODE               TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                    TO WS-RETURN-CODE           
                                               WS-ACTIVE-RETURN-CODE    
              END-IF                                                    
              ADD +1 TO CTR-ROWS                                        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5900-NEXT-BILL-DATE.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00309                                                 
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * 5901-NEXT-READ-DATE.                                                    
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE CPD00310                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6525-PREV-BUSINESS-DAY                                    **         
      *                                                              **         
      *    FINDS THE PREVIOUS BUSINESS DAY, SKIPPING OVER WEEKENDS   **         
      *    AND HOLIDAYS (FOUND IN CSS_HOLIDAY), FROM THE CURRENT     **         
      *    VALUE IN WS-NEW-BUSINESS-DAY WHEN 6500 WAS CALLED.        **         
      *****************************************************************         
       6525-PREV-BUSINESS-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) )) -     
                       CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-NEW-BUSINESS-DAY,
              :WS-DAY-OF-WEEK 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-NEW-BUSINESS-DAY                                          
MFA-TR*              = DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS                      
MFA-TR*          ,:WS-DAY-OF-WEEK                                               
MFA-TR*              = (DAYS(DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS) -             
MFA-TR*                DAYS(DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS)/7*7)+1         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6525'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 6550-WKND-HLDY-CHECK   THRU                          
                                            6550-WKND-HLDY-CHECK-EXIT.  
                                                                        
       6525-PREV-BUSINESS-DAY-EXIT.                                     
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *    6550-WKND-HLDY-CHECK                                       *         
      *    CHECK TO SEE IF IT IS A WEEKEND OR HOLIDAY                 *         
      *****************************************************************         
       6550-WKND-HLDY-CHECK.                                            
                                                                        
           IF WS-DAY-OF-WEEK NOT EQUAL WS-SATURDAY AND                  
              WS-DAY-OF-WEEK NOT EQUAL WS-SUNDAY                        
                                                                        
              MOVE WS-NEW-BUSINESS-DAY       TO J8-HOLIDAY-DT           
              MOVE WS-NO                     TO WS-HOLIDAY-EXISTS       
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLIDAY            
              EXEC SQL                                                  
                  SELECT DISTINCT('Y')                                  
                  INTO   :WS-HOLIDAY-EXISTS                             
                  FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                      
                  WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                    
                                                                 
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT DISTINCT('Y')                                          
MFA-TR*           INTO   :WS-HOLIDAY-EXISTS                                     
MFA-TR*           FROM   CSS_HOLIDAY                                            
MFA-TR*           WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                            
MFA-TR*           WITH UR                                                       
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                  CONTINUE                                              
              ELSE                                                      
                  IF SQLCODE NOT EQUAL NOT-FOUND                        
                     MOVE PROGRAM-NAME             TO ABEND-PROGRAM     
                     MOVE '6550'                   TO ACTIVE-PARAGRAPH  
                     MOVE 'SELECT'                 TO ABEND-FUNCTION    
                     MOVE SPACES                 TO ABEND-SQL-PREDICATES
                                                      ABEND-TABLES      
                     MOVE 'CSS_HOLIDAY'            TO TABLE-1           
                     MOVE 'HOLIDAY_DT'             TO TABLE-ELEMENT-1   
                     MOVE J8-HOLIDAY-DT            TO HOSTVAR-ELEMENT-1 
                     PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT       
                  END-IF                                                
              END-IF                                                    
                                                                        
              IF HOLIDAY-EXISTS-NO                                      
                  MOVE WS-YES                TO WS-NEXT-BUSINESS-DAY    
              ELSE                                                      
                  MOVE WS-NO                 TO WS-NEXT-BUSINESS-DAY    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6550-WKND-HLDY-CHECK-EXIT.                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-SELECT-ACCOUNT.                                           *        
      ******************************************************************        
      *                                                                         
       7100-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     AT.COMPANY_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.BILL_CYCLE                                      
                    ,AT.CREDIT_GROUP                                    
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.CODES_DATA_PRESENT                              
                    ,COALESCE(AT.LAST_PYMT_DATE,IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))             
                    ,AT.LAST_PYMT_AMOUNT                                
                    ,AT.CODE_BILL_FREQ                                  
                    ,AT.CUSTOMER_NO                                     
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.IVR_EXEMPT_CD                                   
                    ,AT.CODE_DISC_OK                                    
                    ,AT.BANKRUPTCY_IND                                  
                    ,AT.NOTICE_EXEMPT_CD                                
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.DATE_BILL_DAY_00                                
                    ,AT.DATE_BILL_DAY_30                                
                    ,AT.DATE_BILL_DAY_60                                
                    ,AT.DATE_BILL_DAY_90                                
                INTO                                                    
                     :AT-COMPANY-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-LAST-PYMT-DATE                                 
                    ,:AT-LAST-PYMT-AMOUNT                               
                    ,:AT-CODE-BILL-FREQ                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-DATE-BILL-DAY-00                               
                    ,:AT-DATE-BILL-DAY-30                               
                    ,:AT-DATE-BILL-DAY-60                               
                    ,:AT-DATE-BILL-DAY-90                               
                FROM                                                    
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE                                                    
                     ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              AT.COMPANY_NO                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,IFNULL(AT.LAST_PYMT_DATE,'0001-01-01')                     
MFA-TR*             ,AT.LAST_PYMT_AMOUNT                                        
MFA-TR*             ,AT.CODE_BILL_FREQ                                          
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*         INTO                                                            
MFA-TR*              :AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-LAST-PYMT-DATE                                         
MFA-TR*             ,:AT-LAST-PYMT-AMOUNT                                       
MFA-TR*             ,:AT-CODE-BILL-FREQ                                         
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-30                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-60                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-90                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE                                                            
MFA-TR*              ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-SELECT-MIN-DT-EXTRACT.                                    *        
      ******************************************************************        
      *                                                                         
       7150-SELECT-MIN-DT-EXTRACT.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     COALESCE(MIN(BN.DATE_EXTRACT),
              IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))          
                INTO                                                    
                     :WS-MIN-DATE-EXTRACT                               
                FROM                                                    
                     CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     BN.REVENUE_MONTH   = :BN-REVENUE-MONTH             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              IFNULL(MIN(BN.DATE_EXTRACT),'0001-01-01')                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-MIN-DATE-EXTRACT                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE                                                            
MFA-TR*              BN.REVENUE_MONTH   = :BN-REVENUE-MONTH                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              WS-MIN-DATE-EXTRACT NOT = '0001-01-01'                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7150'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'REVENUE_MONTH'          TO TABLE-ELEMENT-1          
              MOVE  BN-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-GET-NEXT-WORK-DAY.                                       *         
      *****************************************************************         
      *                                                                         
       7200-GET-NEXT-WORK-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     DATEADD( DAY, :WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                   :WS-MIN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-MIN-DATE-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:WS-MIN-DATE-EXTRACT
              ), CONVERT(DATE, :WS-MIN-DATE-EXTRACT) ) )      
                INTO                                                    
                     :WS-WORK-DATE                                      
                FROM                                                    
                     CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                        
               WHERE                                                    
                     CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-MIN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-MIN-DATE-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:WS-MIN-DATE-EXTRACT
              ), CONVERT(DATE, :WS-MIN-DATE-EXTRACT) ) )) -                    
                        (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-MIN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-MIN-DATE-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:WS-MIN-DATE-EXTRACT
              ), CONVERT(DATE, :WS-MIN-DATE-EXTRACT
              ) ) )) / 7 * 7) BETWEEN 1 AND 5  
                 AND NOT EXISTS                                         
                       (SELECT                                          
                            HOLIDAY_DT                                  
                        FROM                                            
                            CSS_HOLIDAY WITH(READUNCOMMITTED)                   
                        WHERE                                           
                            COMPANY_NO = '01'                           
                        AND HOLIDAY_DT = DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-MIN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-MIN-DATE-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:WS-MIN-DATE-EXTRACT
              ), CONVERT(DATE, :WS-MIN-DATE-EXTRACT) ) ))         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              DATE(:WS-MIN-DATE-EXTRACT) + :WS-ADJ-DAY DAYS              
MFA-TR*         INTO                                                            
MFA-TR*              :WS-WORK-DATE                                              
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*        WHERE                                                            
MFA-TR*              DAYS(DATE(:WS-MIN-DATE-EXTRACT)                            
MFA-TR*                      + :WS-ADJ-DAY DAYS) -                              
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-MIN-DATE-EXTRACT)                
MFA-TR*                  + :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5          
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*                (SELECT                                                  
MFA-TR*                     HOLIDAY_DT                                          
MFA-TR*                 FROM                                                    
MFA-TR*                     CSS_HOLIDAY                                         
MFA-TR*                 WHERE                                                   
MFA-TR*                     COMPANY_NO = '01'                                   
MFA-TR*                 AND HOLIDAY_DT = DATE(:WS-MIN-DATE-EXTRACT) +           
MFA-TR*                                       :WS-ADJ-DAY DAYS)                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  MOVE WS-WORK-DATE         TO WS-DATE-CCYY-MM-DD       
                  MOVE WS-DATE-CCYY-MM-DD   TO WS-WORK-DAY (WD-INDX)    
                  ADD 1                     TO WS-ADJ-DAY               
                  SET WD-INDX UP BY 1                                   
              ELSE                                                      
                  ADD 1 TO WS-ADJ-DAY                                   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_HOLIDAY'            TO TABLE-1                  
              MOVE 'WS-MIN-DATE-EXTRACT'    TO TABLE-ELEMENT-1          
              MOVE  WS-MIN-DATE-EXTRACT     TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-GET-DELINQ-VALUE.                                         *        
      ******************************************************************        
      *                                                                         
       7250-SELECT-DELINQ.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     C8.DELINQ_VALUE                                    
                INTO                                                    
                     :C8-DELINQ-VALUE                                   
                FROM                                                    
                     CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                  
               WHERE                                                    
                     C8.COMPANY_NO  =  :C8-COMPANY-NO                   
                 AND C8.DELINQ_CD   =  :C8-DELINQ-CD                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              C8.DELINQ_VALUE                                            
MFA-TR*         INTO                                                            
MFA-TR*              :C8-DELINQ-VALUE                                           
MFA-TR*         FROM                                                            
MFA-TR*              CSS_DELINQUENCY  C8                                        
MFA-TR*        WHERE                                                            
MFA-TR*              C8.COMPANY_NO  =  :C8-COMPANY-NO                           
MFA-TR*          AND C8.DELINQ_CD   =  :C8-DELINQ-CD                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'COMPANY_NO '            TO TABLE-ELEMENT-1          
              MOVE 'DELINQ_CD '             TO TABLE-ELEMENT-2          
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-REG-PROFILE.                                          *        
      ******************************************************************        
      *                                                                         
       7300-GET-REG-PROFILE.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                      LR.REG_GROUP_CD                                   
                 INTO                                                   
                      :LR-REG-GROUP-CD                                  
                 FROM                                                   
                      CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                  
                WHERE                                                   
                      LR.ACCOUNT_NO = :LR-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               LR.REG_GROUP_CD                                           
MFA-TR*          INTO                                                           
MFA-TR*               :LR-REG-GROUP-CD                                          
MFA-TR*          FROM                                                           
MFA-TR*               CSS_REG_PROFILE LR                                        
MFA-TR*         WHERE                                                           
MFA-TR*               LR.ACCOUNT_NO = :LR-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL OR NOT-FOUND
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE 'Y'                   TO WS-REG-GROUP             
              ELSE                                                      
                 MOVE 'N'                   TO WS-REG-GROUP             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_REG_PROFILE'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE  LR-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-GET-CURRENT-DATE.                                                  
      ******************************************************************        
      *                                                                         
       7400-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7450-SELECT-BILL-CYCLE-DT.                                     *        
      ******************************************************************        
      *                                                                         
       7450-SELECT-BILL-CYCLE-DT.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     COALESCE(MIN(BN.DATE_EXTRACT),
              IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))          
                    ,COALESCE(MAX(BN.DATE_EXTRACT),
              IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))          
                INTO                                                    
                     :WS-MIN-DATE-EXTRACT                               
                    ,:WS-MAX-DATE-EXTRACT                               
                FROM                                                    
                     CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     BN.REVENUE_MONTH = :BN-REVENUE-MONTH               
                 AND BN.BILL_CYCLE    = :WS-BILL-CYCLE                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              IFNULL(MIN(BN.DATE_EXTRACT),'0001-01-01')                  
MFA-TR*             ,IFNULL(MAX(BN.DATE_EXTRACT),'0001-01-01')                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-MIN-DATE-EXTRACT                                       
MFA-TR*             ,:WS-MAX-DATE-EXTRACT                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE                                                            
MFA-TR*              BN.REVENUE_MONTH = :BN-REVENUE-MONTH                       
MFA-TR*          AND BN.BILL_CYCLE    = :WS-BILL-CYCLE                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              WS-MIN-DATE-EXTRACT NOT = '0001-01-01'  AND               
              WS-MAX-DATE-EXTRACT NOT = '0001-01-01'                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7450'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'REVENUE_MONTH'          TO TABLE-ELEMENT-1          
              MOVE  BN-REVENUE-MONTH        TO HOSTVAR-ELEMENT-1        
              MOVE 'BILL_CYCLE'             TO TABLE-ELEMENT-2          
              MOVE  WS-BILL-CYCLE           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7600-SELECT-CRED-FORECAST.                                              
      *    SELECT DATES FROM CSS_CRED_FORECAST.                                 
      *****************************************************************         
      *                                                                         
       7600-SELECT-CRED-FORECAST.                                       
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) COALESCE(CM.DNP_DT,IIF(TRY_CONVERT(DATE, 
              '0001-01-01') IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))                    
                 INTO :CM-DNP-DT                                        
                 FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)                
                WHERE CM.REVENUE_MONTH    = :CM-REVENUE-MONTH           
                  AND CM.BILL_CYCLE       = :CM-BILL-CYCLE              
                  AND CM.CRED_FORECAST_CD = 'A'                         
                  AND CM.COMPANY_NO       = :CM-COMPANY-NO              
                ORDER BY CM.BILL_DT                                     
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(CM.DNP_DT,'0001-01-01')                            
MFA-TR*          INTO :CM-DNP-DT                                                
MFA-TR*          FROM CSS_CRED_FORECAST CM                                      
MFA-TR*         WHERE CM.REVENUE_MONTH    = :CM-REVENUE-MONTH                   
MFA-TR*           AND CM.BILL_CYCLE       = :CM-BILL-CYCLE                      
MFA-TR*           AND CM.CRED_FORECAST_CD = 'A'                                 
MFA-TR*           AND CM.COMPANY_NO       = :CM-COMPANY-NO                      
MFA-TR*         ORDER BY CM.BILL_DT                                             
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7600'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
              MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
              MOVE CM-REVENUE-MONTH       TO HOSTVAR-ELEMENT-1          
              MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2            
              MOVE CM-BILL-CYCLE          TO HOSTVAR-ELEMENT-2          
              MOVE 'CRED_FORECAST_CD'     TO TABLE-ELEMENT-3            
              MOVE CM-CRED-FORECAST-CD    TO HOSTVAR-ELEMENT-3          
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-4            
              MOVE CM-COMPANY-NO          TO HOSTVAR-ELEMENT-4          
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7700-SELECT-FW-ACTION-DT                                                
      *****************************************************************         
      *                                                                         
       7700-SELECT-FW-ACTION-DT.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) COALESCE(KD.FW_ACTION_DT,
              IIF(TRY_CONVERT(DATE, '0001-01-01'
              ) IS NULL OR (PATINDEX('%.%', '0001-01-01'
              ) <> 0) OR (LEN('0001-01-01') <> 10), CIS.CHAR2DATE(
              '0001-01-01'), CONVERT(DATE, '0001-01-01') ))              
                 INTO :KD-FW-ACTION-DT                                  
                 FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
                WHERE KD.ACCOUNT_NO       = :KD-ACCOUNT-NO              
                  AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD       
                ORDER BY KD.FW_SEQ_NO DESC                              
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(KD.FW_ACTION_DT,'0001-01-01')                      
MFA-TR*          INTO :KD-FW-ACTION-DT                                          
MFA-TR*          FROM CSS_FIN_WO_ACTION KD                                      
MFA-TR*         WHERE KD.ACCOUNT_NO       = :KD-ACCOUNT-NO                      
MFA-TR*           AND FW_ACTION_TYPE_CD   = :KD-FW-ACTION-TYPE-CD               
MFA-TR*         ORDER BY KD.FW_SEQ_NO DESC                                      
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7700'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_FIN_WO_ACTION'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE KD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7800-GET-FORCST-DT-SO.                                        *         
      *****************************************************************         
      *                                                                         
       7800-GET-FORCST-DT-SO.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME                             
                 INTO :VO-WANTED-BY-DATETIME                            
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE VO.ACCOUNT_NO_PRIOR     = :VO-ACCOUNT-NO          
                  AND VO.ORDER_STATE_CD       = 'A'                     
                  AND VO.SERV_ORDER_STATUS    < '60'                    
                  AND VO.ORDER_TYPE_CD        = 'DNP01'                 
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO.WANTED_BY_DATETIME                                     
MFA-TR*          INTO :VO-WANTED-BY-DATETIME                                    
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE VO.ACCOUNT_NO_PRIOR     = :VO-ACCOUNT-NO                  
MFA-TR*           AND VO.ORDER_STATE_CD       = 'A'                             
MFA-TR*           AND VO.SERV_ORDER_STATUS    < '60'                            
MFA-TR*           AND VO.ORDER_TYPE_CD        = 'DNP01'                         
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7800'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_SO_DATA'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE VO-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04383_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04383_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE 'CSR04383_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000B-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000B-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04383_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04383_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE 'CSR04383_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8010-INSERT-GTT-R1.                                              
      *                                                                         
           IF WS-GTT-IND-R1 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100A-DECLARE-GTT-R1  THRU 0100A-EXIT             
              MOVE 'Y'                      TO WS-GTT-IND-R1            
           END-IF.                                                      
           MOVE WS-RETURN-CODE              TO S-RETURN-CODE-1.         
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04383_R1                           
                  (                                                     
                    RETURN_CODE                                         
                   ,STA_AMOUNT                                          
                   ,NEW_STA_DUE_DATE                                    
                   ,NEW_STA_DNP_DATE                                    
                  )                                                     
              VALUES                                                    
                  (                                                     
                    :S-RETURN-CODE-1                                    
                   ,:S-STA-AMOUNT                                       
                   ,:S-NEW-STA-DUE-DATE                                 
                   ,:S-NEW-STA-DNP-DATE                                 
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04383_R1                                   
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,STA_AMOUNT                                                  
MFA-TR*            ,NEW_STA_DUE_DATE                                            
MFA-TR*            ,NEW_STA_DNP_DATE                                            
MFA-TR*           )                                                             
MFA-TR*       VALUES                                                            
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-1                                            
MFA-TR*            ,:S-STA-AMOUNT                                               
MFA-TR*            ,:S-NEW-STA-DUE-DATE                                         
MFA-TR*            ,:S-NEW-STA-DNP-DATE                                         
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS                
                                                WS-PLAN-DTLS            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8010'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04383_R1'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8020-INSERT-GTT-R2                                             *        
      ******************************************************************        
      *                                                                         
       8020-INSERT-GTT-R2.                                              
      *                                                                         
           IF WS-GTT-IND-R2 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 0100B-DECLARE-GTT-R2  THRU 0100B-EXIT             
              MOVE 'Y'                      TO WS-GTT-IND-R2            
           END-IF.                                                      
           MOVE WS-RETURN-CODE              TO S-RETURN-CODE-2.         
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04383_R2                           
                  (                                                     
                    RETURN_CODE                                         
                   ,APPL_PGM_ID                                         
                   ,SSN                                                 
                   ,FORCST_DNP_DATE                                     
                   ,DATE_FRST_NOTICE                                    
                   ,DATE_SCND_NOTICE                                    
                   ,DNP_TYPE                                            
                   ,NON_UTIL_PAST_DUE                                   
                   ,DATE_PYMNT_CUST                                     
                   ,PYMNT_METHOD                                        
                  )                                                     
              VALUES                                                    
                  (                                                     
                    :S-RETURN-CODE-2                                    
                   ,:S-APPL-PGM-ID                                      
                   ,:S-SSN                                              
                   ,:S-FORCST-DNP-DATE                                  
                   ,:S-DATE-FRST-NOTICE                                 
                   ,:S-DATE-SCND-NOTICE                                 
                   ,:S-DNP-TYPE                                         
                   ,:S-NON-UTIL-PAST-DUE                                
                   ,:S-DATE-PYMNT-CUST                                  
                   ,:S-PYMNT-METHOD                                     
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04383_R2                                   
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,APPL_PGM_ID                                                 
MFA-TR*            ,SSN                                                         
MFA-TR*            ,FORCST_DNP_DATE                                             
MFA-TR*            ,DATE_FRST_NOTICE                                            
MFA-TR*            ,DATE_SCND_NOTICE                                            
MFA-TR*            ,DNP_TYPE                                                    
MFA-TR*            ,NON_UTIL_PAST_DUE                                           
MFA-TR*            ,DATE_PYMNT_CUST                                             
MFA-TR*            ,PYMNT_METHOD                                                
MFA-TR*           )                                                             
MFA-TR*       VALUES                                                            
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-2                                            
MFA-TR*            ,:S-APPL-PGM-ID                                              
MFA-TR*            ,:S-SSN                                                      
MFA-TR*            ,:S-FORCST-DNP-DATE                                          
MFA-TR*            ,:S-DATE-FRST-NOTICE                                         
MFA-TR*            ,:S-DATE-SCND-NOTICE                                         
MFA-TR*            ,:S-DNP-TYPE                                                 
MFA-TR*            ,:S-NON-UTIL-PAST-DUE                                        
MFA-TR*            ,:S-DATE-PYMNT-CUST                                          
MFA-TR*            ,:S-PYMNT-METHOD                                             
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               WS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                        TO  CTR-ROWS                
                                                WS-FRCST-DTLS           
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8020'                   TO  ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'CSR04383_R2'            TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF WS-PLAN-DTLS  = 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT            
           END-IF.                                                      
      *                                                                         
           IF WS-FRCST-DTLS = 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              PERFORM 8020-INSERT-GTT-R2      THRU 8020-EXIT            
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
              OPEN C1                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8900'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE SQLSTATE                TO ABEND-SQLSTATE            
              MOVE 'CSR04383_R1'           TO TABLE-1                   
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
              OPEN C2                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
                                              WS-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8900'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE SQLSTATE                TO ABEND-SQLSTATE            
              MOVE 'CSR04383_R2'           TO TABLE-1                   
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
      *                                                                         
        8900-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                        TO SEND-DONE-SW.             
           MOVE WS-ACTIVE-RETURN-CODE      TO ABEND-SQLCODE.            
           MOVE SQLERRMC                   TO ABEND-SQLERRMC.           
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'              TO ABEND-FUNCTION            
           END-IF.                                                      
      *                                                                         
           PERFORM 8010-INSERT-GTT-R1      THRU 8010-EXIT.              
           PERFORM 8020-INSERT-GTT-R2      THRU 8020-EXIT.              
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND.                                            *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS    THRU 8800-EXIT              
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      **********************End Of Program *****************************        
