       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04380.                                            
       DATE-WRITTEN. 08/17/2010.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO RETRIEVE THE ADDRESS, COUNTY ,      *        
      *  COMPLETED-DATE WORK-AREA & WORK-TYPE FOR AN ORDER             *        
      *                 PANEL090                                       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/17/2010  SC41135  PROCEDURE ORIGINALLY CODED               *        
      *  01/25/2011  SC41135  A03078 - ADDED SUBDIVISION DESC TO RESULT*        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04380'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    VO - CSS_SO_DATA                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    VI - CSS_SO_ORDER_INST                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    L4 - CSS_WORK_TYPE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    I2 - CSS_WORK_AREA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWKAR                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    PR - CSS_PREMISE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    SC - CSS_STATE_COUNTY                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSTCNTY                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *   A4 - CSS_ZIP_CODE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
A03078******************************************************************        
A03078*   B0 - CSS_SUBDIVISION                                         *        
A03078******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR ERROR-HANDLING                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE             PIC S9(9) COMP.               
           05  RS-ADDRESS                 PIC X(120).                   
           05  RS-BLOCK                   PIC X(05).                    
           05  RS-COUNTY-DESC             PIC X(22).                    
           05  RS-COMPLETED-DATE          PIC X(10).                    
           05  RS-LOT                     PIC X(05).                    
           05  RS-WORK-AREA-TX            PIC X(40).                    
           05  RS-WORK-TYPE-DESC          PIC X(25).                    
A03078     05  RS-SUBDIVISION-DESC        PIC X(26).                    
           05  RS-ERROR-DESC              PIC X(40) VALUE SPACES.       
      *                                                                         
      ******************************************************************        
      *    BETWEEN FIELD WORK AREAS                                    *        
      ******************************************************************        
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-FROM.                                                 
               10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04380'. 
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X             OCCURS 80 TIMES             
                                            INDEXED BY WS-ADD-SUB.      
                   15  FILLER               PIC X.                      
           05  WS-CITY                      PIC X(20).                  
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-NULL-COMP-DATETIME   PIC S9(04)    COMP   VALUE +0.   
           05  S-RETURN-CODE           PIC S9(9)     COMP   VALUE 0.    
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 100.   
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       01  WS-MISC.                                                     
COB305     05 WS-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.
           05  WS-ORDER-NO                    PIC X(13) JUSTIFIED RIGHT.
       01  PARM-FIELDS.                                                 
           05  PARM-SERV-ORDER-NO      PIC X(13) VALUE SPACES.          
           05  PARM-SERV-ORDER-NO-RED  PIC  9(13).                      
                                                                        
           05  PARM-SERV-ORDER-NO-NUM  PIC S9(13)V COMP-3 VALUE 0.      
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SERV-ORDER-NO        PIC X(13).                         
                                                                        
      ******************************************************************        
                                                                        
       PROCEDURE DIVISION USING LINK-SERV-ORDER-NO.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
               EXEC SQL                                                 
                   DECLARE C1 CURSOR  FOR                    
                   SELECT                                               
                     :RS-RETURN-CODE               AS RETURN_CODE       
                    ,LTRIM(RTRIM(:RS-ADDRESS))            AS ADDRESS           
                    ,LTRIM(RTRIM(:RS-BLOCK))              AS BLOCK             
                    ,LTRIM(RTRIM(:RS-COUNTY-DESC))        AS COUNTY_DESC       
                    ,LTRIM(RTRIM(:RS-COMPLETED-DATE))     AS 
           [COMPLETED-DATE]    
                    ,LTRIM(RTRIM(:RS-LOT))                AS LOT               
                    ,LTRIM(RTRIM(:RS-WORK-AREA-TX))       AS 
           WORK_AREA_TX      
                    ,LTRIM(RTRIM(:RS-WORK-TYPE-DESC))     AS 
           WORK_TYPE_DESC    
A03078              ,LTRIM(RTRIM(:RS-SUBDIVISION-DESC))   AS 
           SUBDIVISION_DESC  
                   FROM                                                 
                       CIS.SYSDUMMY1                                 
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT                                                       
MFA-TR*              :RS-RETURN-CODE               AS RETURN_CODE               
MFA-TR*             ,STRIP(:RS-ADDRESS)            AS ADDRESS                   
MFA-TR*             ,STRIP(:RS-BLOCK)              AS BLOCK                     
MFA-TR*             ,STRIP(:RS-COUNTY-DESC)        AS COUNTY_DESC               
MFA-TR*             ,STRIP(:RS-COMPLETED-DATE)     AS COMPLETED-DATE            
MFA-TR*             ,STRIP(:RS-LOT)                AS LOT                       
MFA-TR*             ,STRIP(:RS-WORK-AREA-TX)       AS WORK_AREA_TX              
MFA-TR*             ,STRIP(:RS-WORK-TYPE-DESC)     AS WORK_TYPE_DESC            
MFA-TR*             ,STRIP(:RS-SUBDIVISION-DESC)   AS SUBDIVISION_DESC          
MFA-TR*            FROM                                                         
MFA-TR*                SYSIBM.SYSDUMMY1                                         
MFA-TR*        END-EXEC.                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *     2. SPLIT OUT PARM STRING INFORMATION                       *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
           MOVE LINK-SERV-ORDER-NO       TO PARM-SERV-ORDER-NO          
           UNSTRING PARM-SERV-ORDER-NO DELIMITED BY ' '                 
                                         INTO WS-ORDER-NO.              
                                                                        
           MOVE WS-ORDER-NO       TO PARM-SERV-ORDER-NO-RED             
           MOVE PARM-SERV-ORDER-NO-RED    TO  PARM-SERV-ORDER-NO-NUM.   
           MOVE PARM-SERV-ORDER-NO-NUM    TO  WS-SERV-ORDER-NO.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *     BUILD THE RESULT SET.                                      *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
             MOVE '2000'                 TO ACTIVE-PARAGRAPH            
             MOVE WS-SERV-ORDER-NO       TO VO-SERV-ORDER-NO            
               PERFORM 7200-GET-ORDER-DATA  THRU 7200-EXIT              
                                                                        
           IF CTR-ROWS = ZERO                                           
             MOVE NOT-FOUND              TO RS-RETURN-CODE              
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
            ADD 1                    TO  CTR-ROWS.                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-ORDER-DATA                                   *                 
      *     GET THE DATA FOR THE ORDER                                 *        
      ******************************************************************        
                                                                        
       7200-GET-ORDER-DATA.                                             
                                                                        
             EXEC SQL                                                   
              SELECT TOP(1) VO.ACCOUNT_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.COMPLETED_DATETIME
           , 121), ' ', '-'), ':', '.') COMPLETED_DATETIME,
              I2.WORK_AREA_TX,
              L4.WORK_TYPE_DESC,
              SC.COUNTY_DESC,
              PR.ADDRESS_ID,
              PR.BLOCK,
              PR.LOT,
              SC.STATE,
              B0.SUBDIVISION_DESC                               
                 INTO                                                   
                      :VO-ACCOUNT-NO                                    
                     ,:VO-COMPLETED-DATETIME :WS-NULL-COMP-DATETIME      
                     ,:I2-WORK-AREA-TX                                  
                     ,:L4-WORK-TYPE-DESC                                
                     ,:SC-COUNTY-DESC                                   
                     ,:PR-ADDRESS-ID                                    
                     ,:PR-BLOCK                                         
                     ,:PR-LOT                                           
                     ,:SC-STATE                                         
A03078               ,:B0-SUBDIVISION-DESC                              
                 FROM CSS_SO_DATA VO,                                   
                      CSS_SO_ORDER_INST VI,                             
                      CSS_PREMISE PR,                                   
                      CSS_STATE_COUNTY SC,                              
                      CSS_WORK_AREA I2,                                 
                      CSS_WORK_TYPE L4,                                 
A03078                CSS_SUBDIVISION B0                                
                WHERE VO.SERV_ORDER_NO   = :VO-SERV-ORDER-NO            
                  AND VO.SERV_ORDER_NO   = VI.SERV_ORDER_NO             
                  AND VI.WORK_TYPE_CD <> ''                             
                  AND PR.PREMISE_NO = VO.PREMISE_NO                     
                  AND VO.COMPANY_NO = SC.COMPANY_NO                     
                  AND PR.COUNTY     = SC.COUNTY                         
A03078            AND PR.COMPANY_NO = B0.COMPANY_NO                     
A03078            AND PR.SUBDIVISION_ID = B0.SUBDIVISION_ID             
                  AND VO.WORK_AREA_ID   = I2.WORK_AREA_ID               
                  AND VI.WORK_TYPE_CD  =  L4.WORK_TYPE_CD               
                                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*       SELECT  VO.ACCOUNT_NO                                             
MFA-TR*              ,VO.COMPLETED_DATETIME                                     
MFA-TR*              ,I2.WORK_AREA_TX                                           
MFA-TR*              ,L4.WORK_TYPE_DESC                                         
MFA-TR*              ,SC.COUNTY_DESC                                            
MFA-TR*              ,PR.ADDRESS_ID                                             
MFA-TR*              ,PR.BLOCK                                                  
MFA-TR*              ,PR.LOT                                                    
MFA-TR*              ,SC.STATE                                                  
MFA-TR*              ,B0.SUBDIVISION_DESC                                       
MFA-TR*          INTO                                                           
MFA-TR*               :VO-ACCOUNT-NO                                            
MFA-TR*              ,:VO-COMPLETED-DATETIME:WS-NULL-COMP-DATETIME              
MFA-TR*              ,:I2-WORK-AREA-TX                                          
MFA-TR*              ,:L4-WORK-TYPE-DESC                                        
MFA-TR*              ,:SC-COUNTY-DESC                                           
MFA-TR*              ,:PR-ADDRESS-ID                                            
MFA-TR*              ,:PR-BLOCK                                                 
MFA-TR*              ,:PR-LOT                                                   
MFA-TR*              ,:SC-STATE                                                 
MFA-TR*              ,:B0-SUBDIVISION-DESC                                      
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_STATE_COUNTY SC,                                      
MFA-TR*               CSS_WORK_AREA I2,                                         
MFA-TR*               CSS_WORK_TYPE L4,                                         
MFA-TR*               CSS_SUBDIVISION B0                                        
MFA-TR*         WHERE VO.SERV_ORDER_NO   = :VO-SERV-ORDER-NO                    
MFA-TR*           AND VO.SERV_ORDER_NO   = VI.SERV_ORDER_NO                     
MFA-TR*           AND VI.WORK_TYPE_CD <> ''                                     
MFA-TR*           AND PR.PREMISE_NO = VO.PREMISE_NO                             
MFA-TR*           AND VO.COMPANY_NO = SC.COMPANY_NO                             
MFA-TR*           AND PR.COUNTY     = SC.COUNTY                                 
MFA-TR*           AND PR.COMPANY_NO = B0.COMPANY_NO                             
MFA-TR*           AND PR.SUBDIVISION_ID = B0.SUBDIVISION_ID                     
MFA-TR*           AND VO.WORK_AREA_ID   = I2.WORK_AREA_ID                       
MFA-TR*           AND VI.WORK_TYPE_CD  =  L4.WORK_TYPE_CD                       
MFA-TR*      FETCH FIRST 1 ROW ONLY                                             
MFA-TR*      QUERYNO 7290                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 2500-PROCESS-ROW            THRU 2500-EXIT       
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   CONTINUE                                             
           ELSE                                                         
               MOVE 'PARA -7290 ,SELECT CSS_SO_DATA'                    
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7290'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_SO_DATA'          TO TABLE-1                   
               MOVE 'CSS_SO_ORDER_INST'    TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'SERV_ORDER_NO'        TO TABLE-ELEMENT-1           
               MOVE  WS-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
            END-IF                                                      
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-ROW                                               *        
      *     GET ANY MISSING DATA NOT FOUND IN THE ORIGINAL CURSORS.    *        
      *     FORMAT RESULT SET AND SEND DATA.                           *        
      ******************************************************************        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
      *      MOVE SC-COUNTY-DESC         TO RS-COUNTY-DESC                      
             STRING SC-COUNTY-DESC DELIMITED BY ' '                     
                  INTO RS-COUNTY-DESC                                   
                 IF WS-NULL-COMP-DATETIME < 0                           
                    MOVE SPACES                TO  RS-COMPLETED-DATE    
                 ELSE                                                   
                   MOVE VO-COMPLETED-DATETIME  TO  RS-COMPLETED-DATE    
                 END-IF                                                 
             MOVE I2-WORK-AREA-TX         TO RS-WORK-AREA-TX            
             MOVE L4-WORK-TYPE-DESC       TO RS-WORK-TYPE-DESC          
             MOVE PR-ADDRESS-ID           TO DY-ADDRESS-ID              
             MOVE PR-BLOCK                TO RS-BLOCK                   
             MOVE PR-LOT                  TO RS-LOT                     
A03078       MOVE B0-SUBDIVISION-DESC     TO RS-SUBDIVISION-DESC        
                                                                        
           IF DY-ADDRESS-ID NOT EQUAL TO ZERO                           
               PERFORM 7900-GET-ADDRESS          THRU 7900-EXIT         
               PERFORM 7925-GET-CITY             THRU 7925-EXIT         
           ELSE                                                         
               MOVE SPACE TO DY-HOUSE-NO                                
                             DY-ADDR-PREFIX-1                           
                             DY-ADDR-PREFIX-2                           
                             DY-STREET-NAME                             
                             DY-ADDRESS-OVERFLOW                        
                             DY-ADDR-USAGE-CD                           
                             DY-STREET-SUFFIX                           
                             DY-STREET-LOCATION-1                       
                             DY-STREET-LOCATION-2                       
                             DY-ZIP-CODE                                
                             DY-ZIP-CODE-TOKEN                          
                             A4-TOWN                                    
                             DY-ADDR-SUFFIX                             
           END-IF.                                                      
                                                                        
             MOVE SPACE                  TO WS-ADDRESS.                 
                                                                        
           SET WS-ADD-SUB TO 1.                                         
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-SUFFIX NOT = SPACE                            
                   MOVE DY-ADDR-SUFFIX                 TO WS-FROM       
                   MOVE LENGTH OF DY-ADDR-SUFFIX       TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-1 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-1      TO WS-FROM            
                   MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-2 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-2      TO WS-FROM            
                   MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS        TO RS-ADDRESS.                        
           MOVE A4-TOWN           TO WS-CITY.                           
                                                                        
           STRING RS-ADDRESS DELIMITED BY '  '                          
                  ' '        DELIMITED BY SIZE                          
                  WS-CITY    DELIMITED BY '  '                          
                  ' '        DELIMITED BY SIZE                          
                  SC-STATE   DELIMITED BY ' '                           
                  ' '        DELIMITED BY SIZE                          
                  DY-ZIP-CODE DELIMITED BY SIZE                         
              INTO RS-ADDRESS.                                          
                                                                        
           PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.            
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2540-ACCUMULATE-ADDRESS                                        *        
      *     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *        
      *     THE FORMATTED ADDRESS FIELD.                               *        
      ******************************************************************        
                                                                        
       2540-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH                               
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE.                                      *        
      ******************************************************************        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-GET-ADDRESS                                               *        
      *     GET COLUMNS FROM FORMATTED ADDRESS TABLE.                  *        
      ******************************************************************        
                                                                        
       7900-GET-ADDRESS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              ADDRESS_OVERFLOW,
              ADDR_USAGE_CD,
              STREET_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              ZIP_CODE,
              ZIP_CODE_TOKEN,
              ADDR_SUFFIX                                       
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX                                   
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               ADDR_SUFFIX                                               
MFA-TR*        INTO   :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-ADDR-SUFFIX                                           
MFA-TR*          FROM CSS_ADDR_FORMATTED                                        
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7920                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE        TO WS-ACTIVE-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7920 ,SELECT CSS_ADDR_FORMATTED'             
                  TO RS-ERROR-DESC                                      
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7920'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'ADDRESS_ID'           TO TABLE-ELEMENT-1           
               MOVE DY-ADDRESS-ID          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7925-GET-CITY                                                  *        
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
      ******************************************************************        
                                                                        
       7925-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TOWN                                              
                 INTO :A4-TOWN                                          
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN                                                      
MFA-TR*          INTO :A4-TOWN                                                  
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                             
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7925                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO A4-TOWN                                
               ELSE                                                     
                   MOVE 'PARA -7925 ,SELECT CSS_ZIP_CODE      '         
                      TO RS-ERROR-DESC                                  
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7925'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7925-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                      *          
      * JOURNALING / ERROR HANDLING INCLUDE                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                           *             
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
