       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04367.                                         
COB303 DATE-WRITTEN.  AUG 02,2010                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETUNS ALL POSSIBLE DPP OPTIONS TO BPA'S FOR ALL *        
      *  COMPANIES.                                                    *        
      *  RESULT SETS:                                                  *        
      *         1. DPP OPTIONS                                         *        
      *         2. DEFERRED RECEIVABLES                                *        
      *         3. UNDEFERRED RECEIVABLES                              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00220*  08/02/10  AA97148    PROCEDURE ORIGINALLY CODED.              *        
A03300*  05/13/11  SS42021    CHANGES TO RETURN SUMMARY ROW FOR RCC.   *        
A03301*  05/25/11  SP95538    ADD THREE FIELDS TO THE OPTION RESULT SET*        
A03301*  07/05/11  AA97148    1.ADD NEW PARAMETER TO ACCEPT NORMAL DPP *        
A03301*                         OR SEASONAL DPP.                       *        
A03301*                       2.REMOVED SETTING UP SEASONAL DPP LOGIC. *        
A03536*  09/26/11  VV94890    CHANGED EARNEST AMOUNT CALCULATIONS FOR  *        
A03536*                       SCE&G - PLAN 1 & PLAN 2 FROM 20% TO 30% &*        
A03536*                       PLAN 3 FROM 30% TO 50%.                  *        
P00471*  09/26/11  VV94890    FOR SCANA ENERGY, CALCULATE DPP EARNEST  *        
P00471*                       DNP DATE AS NEXT BILL DT, JUST LIKE SCEG.*        
A03118*  01/25/12  VV94890    FOR SCE&G, SHOW ONLY EDITABLE OPTION,    *        
A03118*                       WHEN UNPAID DEPOSIT AMT IS > DNP LIMIT.  *        
P00594*  03/04/13  AA97148    REMOVE HARD CODING OF OPTION-SEQ-NO AND  *        
P00594*                       REPLACE WITH A RUNNING TOTAL.            *        
P00726*  12/16/13  AA97148    CREDIT ARRANGEMENTS RELEASE 2 CHANGES -  *        
P00726*                       POPULATE SEASONAL DPP ALONG WITH NORMAL  *        
P00726*                       DPP OPTIONS.                             *        
ACT239*  08/14/14  RB19957    ADDED NEW PARM FIELD FOR CSR03515 CHANGE.*        
A05201*  03/19/15  AA97148    1.Re-Order DPP options for SCE&G AND PSNC*        
A05201*                       2.Removed CSS_UTIL_ENVRNMT DCLGEN.       *        
P0726A*  08/17/15  AA97148    Change PSNC DPP Downpayment Disconnect   *        
P0726A*                       date to equal same calculation of SCEG.  *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04367'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04367 STARTS HERE'.                 
      *                                                                         
       01 WS-CONSTANTS.                                                 
      *                                                                         
          05 WS-PPL-NSA                 PIC S9(04) COMP VALUE +020.     
          05 WS-PPL-LPC                 PIC S9(04) COMP VALUE +030.     
          05 WS-PPL-UTE                 PIC S9(04) COMP VALUE +040.     
          05 WS-PPL-UTG                 PIC S9(04) COMP VALUE +045.     
          05 WS-PPL-RCC                 PIC S9(04) COMP VALUE +060.     
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04367'.     
          05 CSR03515                   PIC X(08) VALUE 'CSR03515'.     
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-DPP-MNTHLY-TOT          PIC S9(07)V99   COMP-3 VALUE +0.
          05 WS-DPP-AMT-MO-PYMT         PIC S9(10)V9(6) COMP-3 VALUE +0.
          05 WS-DPP-AMT-MO-PYMT1        PIC 9(12)V9(6).                 
          05 WS-DPP-AMT-MO-PYMT2        PIC 9(12).9(6).                 
          05 WS-DPP-MO-PYMT.                                            
             10 WS-DPP-AMT              PIC 9(12).                      
             10 FILLER                  PIC X(01) VALUE '.'.            
             10 WS-DECIMAL-AMT          PIC 9(06).                      
          05 WS-RECV-AMT-HOLD           PIC S9(09)V99  COMP-3 VALUE +0. 
          05 WS-UTILITY-BALANCE         PIC S9(09)V99  COMP-3 VALUE +0. 
          05 WS-UNDEFR-UTL-BAL          PIC S9(09)V99  COMP-3 VALUE +0. 
          05 WS-DEP-AMT-MO-PYMT         PIC S9(07)V99  COMP-3 VALUE +0. 
          05 WS-SEAS-DPP-STRT-DT        PIC S9(04)V9(5) USAGE DISPLAY.  
          05 WS-SEAS-DPP-END-DT         PIC S9(04)V9(5) USAGE DISPLAY.  
          05 WS-DPP-DEP-BPA             PIC S9(04)V9(5) USAGE DISPLAY.  
          05 WS-UNPAID-DEP-AMT          PIC S9(07)V99 COMP-3 VALUE +0.  
A03118    05 WS-DEPOSIT-AMOUNT          PIC S9(07)V99 COMP-3 VALUE +0.  
A03118    05 WS-SCEG-DNP-LIMIT          PIC S9(05) COMP-3 VALUE +0.     
A03118    05 WS-GAS-ONLY-OFFICE         PIC X(01) VALUE 'N'.            
          05 WS-DEP-TOT-AMT             PIC S9(07)V99 COMP-3 VALUE +0.  
          05 WS-CURRENT-DATE            PIC X(10) VALUE SPACES.         
          05 WS-PYMT-END-DT             PIC X(10) VALUE SPACES.         
          05 WS-SQLSTATE                PIC X(05) VALUE SPACES.         
          05 WS-GTT-NAME                PIC X(19) VALUE SPACES.         
          05 WS-PYMT-STRT-DT            PIC X(10) VALUE SPACES.         
          05 WS-NEXT-BILL-DT            PIC X(10) VALUE SPACES.         
          05 WS-WORK-DATE               PIC X(10) VALUE SPACES.         
          05 WS-CUR-MNTH-AND-DAY        PIC X(04) VALUE SPACES.         
          05 WS-DPP-STRT-MTH-AND-DAY    PIC X(04) VALUE ZERO.           
          05 WS-DPP-END-MTH-AND-DAY     PIC X(04) VALUE ZERO.           
          05 WS-ADJUSTED-DT             PIC X(10) VALUE SPACES.         
          05 WS-SEARCH-DATE             PIC X(10) VALUE SPACES.         
          05 WS-DAY-DPP-ERNST           PIC S9(04) VALUE 0.             
          05 WS-MAX-AGREEMENT-NO        PIC S9(09) COMP VALUE 0.        
          05 WS-NULL-ITEM-IND           PIC S9(04) COMP VALUE 0.        
          05 WS-RETURN-CODE-1           PIC S9(04) COMP VALUE 0.        
          05 WS-RETURN-CODE-2           PIC S9(04) COMP VALUE 0.        
          05 WS-RETURN-CODE-3           PIC S9(04) COMP VALUE 0.        
          05 WS-HOLD-TS                 PIC X(26) VALUE SPACES.         
          05 WS-ACCOUNT-NO              PIC X(13) VALUE SPACES.         
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                        PIC 9(13).                      
          05 WS-NO-SCHED-PYMTS          PIC S9(04) COMP VALUE +0.       
          05 WS-NO-OF-DAYS              PIC S9(04) COMP VALUE +0.       
          05 WS-ADJ-DAY                 PIC S9(09) COMP VALUE +0.       
          05 WS-REFORMAT-DT.                                            
             10 WS-YYYY                 PIC X(04) VALUE ZERO.           
             10 WS-YYYY-N  REDEFINES WS-YYYY                            
                                        PIC  9(4).                      
             10 FILLER                  PIC X(01) VALUE '-'.            
             10 WS-MM                   PIC X(02) VALUE ZERO.           
             10 FILLER                  PIC X(01) VALUE '-'.            
             10 WS-DD                   PIC X(02) VALUE ZERO.           
      *   05 WS-DPP-END-DT.                                                     
      *      10 WS-DPP-END-YEAR         PIC X(04) VALUE ZERO.                   
      *      10 FILLER                  PIC X(01) VALUE '-'.            01150000
      *      10 WS-DPP-END-MONTH        PIC X(02) VALUE ZERO.                   
      *      10 FILLER                  PIC X(01) VALUE '-'.            01150000
      *      10 WS-DPP-END-DAY          PIC X(02) VALUE ZERO.                   
      *                                                                         
       01 WS-TABLES.                                                    
          05 WS-WORK-DAY-TABLE.                                         
             10 WS-WORK-DAY-LIST        OCCURS 121 TIMES                
                                        ASCENDING KEY WS-WORK-DAY       
                                        INDEXED BY WD-INDX.             
                15 WS-WORK-DAY          PIC X(10).                      
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                   PIC S9(09) COMP VALUE 0.        
          05 WS-OPTION-CNT              PIC S9(09) COMP VALUE 0.        
          05 WS-RECVBLE-DEFR-CNT        PIC S9(09) COMP VALUE 0.        
          05 WS-RECVBLE-UNDEFR-CNT      PIC S9(09) COMP VALUE 0.        
P00594    05 WS-OPTION-SEQ-NO-CNT       PIC 9(01)  COMP VALUE 0.        
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-EOF-CURSOR              PIC X(01) VALUE 'N'.            
             88 NO-MORE-DATA                      VALUE 'Y'.            
          05 WS-DATABASE                PIC 9(01) VALUE ZERO.           
             88 CSR-DATABASE                      VALUE 1.              
             88 SEB-DATABASE                      VALUE 2.              
          05 WS-COMPANY                 PIC X(02) VALUE ZERO.           
             88 WS-SCEG                           VALUE '01'.           
             88 WS-PSNC                           VALUE '26'.           
          05 WS-REG-GROUP               PIC X(01) VALUE SPACES.         
             88 WS-REG                            VALUE 'Y'.            
             88 WS-DEREG                          VALUE 'N'.            
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
          05 WS-RESULT-TYPE             PIC 9(01) VALUE ZERO.           
             88 WS-OPTIONS                        VALUE 1.              
             88 WS-RECVBLE-DEFR                   VALUE 2.              
             88 WS-RECVBLE-UNDEFR                 VALUE 3.              
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1         PIC S9(9) COMP VALUE 0.         
             10 S-DPP-TYPE              PIC X(04) VALUE SPACES.         
             10 S-OPTION-SEQ-NO         PIC X(01) VALUE SPACES.         
             10 S-CONTRACT-TOT-AMT      PIC S9(9)V99 COMP-3 VALUE +0.   
             10 S-1ST-ERNST-AMT         PIC S9(09) COMP-3 VALUE +0.     
             10 S-2ND-ERNST-AMT         PIC S9(09) COMP-3 VALUE +0.     
             10 S-ERNST-PYMT-LST-DT     PIC X(10) VALUE SPACES.         
             10 S-NO-SCHED-PYMTS        PIC S9(04) COMP VALUE +0.       
             10 S-DPP-AMT-MO-PYMT       PIC S9(07)V99 COMP-3 VALUE +0.  
             10 S-DEP-TOT-AMT           PIC S9(07)V99 COMP-3 VALUE +0.  
             10 S-DEP-AMT-MO-PYMT       PIC S9(07)V99 COMP-3 VALUE +0.  
             10 S-PYMT-STRT-DT          PIC X(10) VALUE SPACES.         
             10 S-PYMT-END-DT           PIC X(10) VALUE SPACES.         
             10 S-DNP-DATE              PIC X(10) VALUE SPACES.         
             10 S-DNP-MINUS1            PIC X(10) VALUE SPACES.         
             10 S-DNP-MINUS-DELINQ      PIC X(10) VALUE SPACES.         
             10 S-UNDEFER-RECV-AMT      PIC S9(9)V99 COMP-3 VALUE +0.   
             10 S-UNPAID-DEP-AMT        PIC S9(07)V99 COMP-3 VALUE +0.  
             10 S-PLS-PAY-AMT           PIC S9(09)V99 COMP-3 VALUE +0.  
             10 S-AGREEMENT-NO          PIC S9(09) COMP VALUE 0.        
             10 S-DFA-TYPE              PIC X(01) VALUE SPACES.         
             10 S-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
             10 S-AT-LAST-UPDATE-TS     PIC X(26) VALUE SPACES.         
             10 S-OPTN-EDIT-FLAG        PIC X(01) VALUE SPACES.         
A03301       10 S-CONT-BAL-AT-SETUP     PIC S9(09)V99 COMP-3 VALUE +0.  
A03301       10 S-DPP-AMT-MO-PYMT-LAST  PIC S9(09)V99 COMP-3 VALUE +0.  
A03301       10 S-DEP-AMT-MO-PYMT-LAST  PIC S9(09)V99 COMP-3 VALUE +0.  
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2         PIC S9(09) COMP VALUE 0.        
             10 S-AR-TYPE-DEFR          PIC X(25) VALUE SPACES.         
             10 S-AR-TYPE-DEFR-SHORT    PIC X(03) VALUE SPACES.         
             10 S-PYMT-PRTY-LVL-DEFR    PIC S9(04) COMP VALUE 0.        
             10 S-RECV-AMT-DEFR         PIC S9(09)V99 COMP-3 VALUE +0.  
             10 S-AC-LAST-UPD-TS-DEFR   PIC X(26) VALUE SPACES.         
             10 S-ITEM-ID               PIC S9(09) COMP VALUE 0.        
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3         PIC S9(09) COMP VALUE 0.        
             10 S-AR-TYPE-UNDEFR        PIC X(25) VALUE SPACES.         
             10 S-PYMT-PRTY-LVL-UNDEFR  PIC S9(04) COMP VALUE 0.        
             10 S-RECV-AMT-UNDEFR       PIC S9(09)V99 COMP-3 VALUE +0.  
      *                                                                         
       01 WS-03515-IN-PARM.                                             
          05 WS-03515-ACCOUNT-NO        PIC X(13) VALUE SPACES.         
          05 WS-03515-CALLING-PGM       PIC X(09) VALUE SPACES.         
          05 WS-03515-AUTO-DEP-TYPE     PIC X(01) VALUE SPACES.         
          05 WS-03515-DL-AUTO-DEP-AMT   PIC S9(09)V99 USAGE COMP-3      
                                                  VALUE 0.              
          05 WS-03515-USER-ID           PIC X(07) VALUE SPACES.         
          05 WS-03515-ERROR-SW          PIC X(01) VALUE SPACES.         
ACT239    05 WS-03515-BATCH-DATE        PIC X(10) VALUE SPACES.         
      *                                                                         
       01 WS-03515-OUT-PARM.                                            
          05 WS-03515-RETURN-CODE       PIC S9(09) COMP VALUE 0.        
          05 WS-03515-AUTO-DEP-AMT      PIC S9(09)V99 COMP-3            
                                                      VALUE 0.          
          05 WS-03515-DEP-SUCCESS       PIC X(01) VALUE SPACES.         
          05 WS-03515-DEP-CERT-NO       PIC S9(09) COMP VALUE 0.        
          05 WS-03515-MAX-DEP-ZERO-WQ   PIC X(01) VALUE SPACES.         
          05 WS-03515-AMT-SECURED       PIC S9(09)V99 COMP-3            
                                                      VALUE 0.          
          05 WS-03515-ABEND-PROGRAM     PIC X(20) VALUE SPACES.         
          05 WS-03515-ACTIVE-PARAGRAPH  PIC X(20) VALUE SPACES.         
          05 WS-03515-ABEND-FUNCTION    PIC X(20) VALUE SPACES.         
          05 WS-03515-TABLE-1           PIC X(20) VALUE SPACES.         
          05 WS-03515-TABLE-ELEMENT-1   PIC X(20) VALUE SPACES.         
          05 WS-03515-HOSTVAR-ELEMENT-1 PIC X(20) VALUE SPACES.         
          05 WS-03515-TABLE-ELEMENT-2   PIC X(20) VALUE SPACES.         
          05 WS-03515-HOSTVAR-ELEMENT-2 PIC X(20) VALUE SPACES.         
          05 WS-03515-TABLE-ELEMENT-3   PIC X(20) VALUE SPACES.         
          05 WS-03515-HOSTVAR-ELEMENT-3 PIC X(20) VALUE SPACES.         
          05 WS-03515-TABLE-ELEMENT-4   PIC X(20) VALUE SPACES.         
          05 WS-03515-HOSTVAR-ELEMENT-4 PIC X(20) VALUE SPACES.         
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_ACCOUNT  - AT                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_CNTL  - AC                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_AR_TYPE  - L5                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARTYPE                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BILL_WINDOW - BN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_DELINQUENCY - C8                                        *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_DFA_ACCT - DA                                           *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_HOLIDAY - J8                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     03250000
               INCLUDE TBHLDAY                                          03260000
           END-EXEC.                                                    03270000
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM - G6                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     03250000
               INCLUDE TBJBPARM                                         03260000
           END-EXEC.                                                    03270000
      *                                                                         
      ******************************************************************        
      *    CSS_REG_PROFILE - LR                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_USER_PROFILE - PF                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00309                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00309                                                 
           END-EXEC.                                                            
      *                                                                         
A03118*01  WS-CODES-DATA-PRESENT.                                               
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
      *                                                                         
A03118*----< CSS_LOCAL_OFFICE - B1 >                                            
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DECLARE CURSOR TO GET ALL RECEIVABLES                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE AR_CURSOR CURSOR FOR                             
                       SELECT                                           
                              AC.AMT_AR_DAY_00                          
                             ,AC.AMT_AR_DAY_30                          
                             ,AC.AMT_AR_DAY_60                          
                             ,AC.AMT_AR_DAY_90                          
                             ,AC.AMT_UNUSED_CR                          
                             ,AC.AMT_TRAN_BALANCE                       
                             ,AC.TOT_SUMM_UNBILLED                      
                             ,AC.PYMT_PRIORITY_LVL                      
                             ,AC.ITEM_ID                                
                             ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                             ,L5.AR_TYPE_LONG_DESC                      
                             ,L5.AR_TYPE_SHORT_DESC                     
                         FROM                                           
                              CSS_AR_CNTL  AC WITH(READUNCOMMITTED)             
                             ,CSS_AR_TYPE  L5 WITH(READUNCOMMITTED)             
                        WHERE                                           
                              AC.ACCOUNT_NO = :AC-ACCOUNT-NO            
                          AND AC.PYMT_PRIORITY_LVL                      
                                            = L5.PYMT_PRIORITY_LVL      
                          AND AC.PYMT_PRIORITY_LVL IN                   
                              (19,20,29,30,39,40,45,60,80,90,100,129)   
                     ORDER BY                                           
                              PYMT_PRIORITY_LVL                         
                             ,ITEM_ID                                   
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AR_CURSOR CURSOR FOR                                     
MFA-TR*                SELECT                                                   
MFA-TR*                       AC.AMT_AR_DAY_00                                  
MFA-TR*                      ,AC.AMT_AR_DAY_30                                  
MFA-TR*                      ,AC.AMT_AR_DAY_60                                  
MFA-TR*                      ,AC.AMT_AR_DAY_90                                  
MFA-TR*                      ,AC.AMT_UNUSED_CR                                  
MFA-TR*                      ,AC.AMT_TRAN_BALANCE                               
MFA-TR*                      ,AC.TOT_SUMM_UNBILLED                              
MFA-TR*                      ,AC.PYMT_PRIORITY_LVL                              
MFA-TR*                      ,AC.ITEM_ID                                        
MFA-TR*                      ,AC.LAST_UPDATE_TS                                 
MFA-TR*                      ,L5.AR_TYPE_LONG_DESC                              
MFA-TR*                      ,L5.AR_TYPE_SHORT_DESC                             
MFA-TR*                  FROM                                                   
MFA-TR*                       CSS_AR_CNTL  AC                                   
MFA-TR*                      ,CSS_AR_TYPE  L5                                   
MFA-TR*                 WHERE                                                   
MFA-TR*                       AC.ACCOUNT_NO = :AC-ACCOUNT-NO                    
MFA-TR*                   AND AC.PYMT_PRIORITY_LVL                              
MFA-TR*                                     = L5.PYMT_PRIORITY_LVL              
MFA-TR*                   AND AC.PYMT_PRIORITY_LVL IN                           
MFA-TR*                       (19,20,29,30,39,40,45,60,80,90,100,129)           
MFA-TR*              ORDER BY                                                   
MFA-TR*                       PYMT_PRIORITY_LVL                                 
MFA-TR*                      ,ITEM_ID                                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*               QUERYNO 7300                                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *01 LOC-RESLTSET USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.    
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR CSR04367 ENDS HERE  '.
MSQ001        EXEC SQL
MSQ001          DECLARE AUTO_DEP CURSOR
MSQ001          FOR CALL CSR03515 ( :WS-03515-ACCOUNT-NO
                  , :WS-03515-CALLING-PGM
                  , :WS-03515-AUTO-DEP-TYPE
                  , :WS-03515-DL-AUTO-DEP-AMT
                  , :WS-03515-USER-ID
                  , :WS-03515-ERROR-SW
                  , :WS-03515-BATCH-DATE
                  )
MSQ001        END-EXEC.
            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO              PIC  X(13).                     
       01  PARM-USER-ID                 PIC  X(07).                     
A03301 01  PARM-TYPE                    PIC  X(04).                     
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-USER-ID                            
A03301                          PARM-TYPE.                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 0110-GTT-DECLARE-R1      THRU 0110-EXIT.             
           PERFORM 0120-GTT-DECLARE-R2      THRU 0120-EXIT              
           PERFORM 0130-GTT-DECLARE-R3      THRU 0130-EXIT              
           MOVE '01'                        TO C8-COMPANY-NO.           
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           MOVE ZERO                        TO WS-DATABASE.             
           PERFORM 7050-SELECT-DELINQ       THRU 7050-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                         
      * Get Seasonal start & end dates                                          
      *                                                                         
           IF SEB-DATABASE                                              
              MOVE '01'                     TO C8-COMPANY-NO            
              MOVE 'DATE-SEAS-DPP-START'    TO C8-DELINQ-CD             
              PERFORM 7050-SELECT-DELINQ    THRU 7050-EXIT              
              MOVE C8-DELINQ-VALUE          TO WS-SEAS-DPP-STRT-DT      
      *                                                                         
              MOVE 'DATE-SEAS-DPP-END'      TO C8-DELINQ-CD             
              PERFORM 7050-SELECT-DELINQ    THRU 7050-EXIT              
              MOVE C8-DELINQ-VALUE          TO WS-SEAS-DPP-END-DT       
           END-IF.                                                      
      *                                                                         
           MOVE '01'                        TO C8-COMPANY-NO.           
           MOVE 'DAY-DPPEARNEST'            TO C8-DELINQ-CD.            
           PERFORM 7050-SELECT-DELINQ       THRU 7050-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DAY-DPP-ERNST.        
           PERFORM 7000-GET-CUR-DATE        THRU 7000-EXIT.             
           PERFORM 0140-LOAD-WORK-DAYS      THRU 0140-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04367_R1'       TO WS-GTT-NAME.             
           SET  WS-OPTIONS                  TO TRUE.                    
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04367_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04367_R1
              (                                                       
                  RETURN_CODE           INT                         
                 ,DPP_TYPE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,OPTION_SEQ_NO CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,CONTRACT_TOT_AMT      DECIMAL(11,2)                   
                 ,S_1ST_ERNST_AMT       DECIMAL(11,2)                   
                 ,S_2ND_ERNST_AMT       DECIMAL(11,2)                   
                 ,ERNST_PYMT_LST_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,NO_SCHED_PYMTS        SMALLINT                        
                 ,DPP_AMT_MO_PYMT       DECIMAL(09,2)                   
                 ,DEP_TOT_AMT           DECIMAL(09,2)                   
                 ,DEP_AMT_MO_PYMT       DECIMAL(09,2)                   
                 ,PYMT_STRT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,PYMT_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,DNP_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,DNP_MINUS1 CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,DNP_MINUS_DELINQ CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,UNDEFER_RECV_AMT      DECIMAL(11,2)                   
                 ,UNPAID_DEP_AMT        DECIMAL(09,2)                   
                 ,PLS_PAY_AMT           DECIMAL(11,2)                   
                 ,AGREEMENT_NO          INT                         
                 ,DFA_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,RESP_AREA_ID CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,AT_LAST_UPDATE_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
                 ,OPTN_EDIT_FLAG CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                        
A03301           ,CONT_BAL_AT_SETUP     DECIMAL(09,2)                   
A03301           ,DPP_AMT_MO_PYMT_LAST  DECIMAL(09,2)                   
A03301           ,DEP_AMT_MO_PYMT_LAST  DECIMAL(09,2)                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12256100
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100B-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04367_R2'       TO WS-GTT-NAME.             
           SET  WS-RECVBLE-DEFR             TO TRUE.                    
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04367_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04367_R2
              (                                                       
                    RETURN_CODE          INT                        
                   ,AR_TYPE_DEFR CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AR_TYPE_DEFR_SHORT CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,PYMT_PRTY_LVL_DEFR   SMALLINT                       
                   ,RECV_AMT_DEFR        DECIMAL(11,2)                  
                   ,AC_LAST_UPD_TS_DEFR CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,ITEM_ID              INT                        
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100C-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100C-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04367_R3'       TO WS-GTT-NAME.             
           SET  WS-RECVBLE-UNDEFR           TO TRUE.                    
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04367_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04367_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,AR_TYPE_UNDEFR CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PYMT_PRTY_LVL_UNDEFR    SMALLINT                    
                   ,RECV_AMT_UNDEFR         DECIMAL(11,2)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0110-GTT-DECLARE-R1                                            *        
      ******************************************************************        
      *                                                                         
       0110-GTT-DECLARE-R1.                                             
      *                                                                         
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04367_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04367_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0120-GTT-DECLARE-R2                                            *        
      ******************************************************************        
      *                                                                         
       0120-GTT-DECLARE-R2.                                             
      *                                                                         
           PERFORM 0100B-DECLARE-GTT        THRU 0100B-EXIT.            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04367_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04367_R2                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0130-GTT-DECLARE-R3                                        *            
      ******************************************************************        
      *                                                                         
       0130-GTT-DECLARE-R3.                                             
      *                                                                         
           PERFORM 0100C-DECLARE-GTT        THRU 0100C-EXIT.            
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04367_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           *                                                             
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04367_R3                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0140-LOAD-WORK-DAYS                                            *        
      * LOAD WORKING DAYS IN PAST 8 WEEKS & FUTURE 8 WEEKS.            *        
      * ENTRY 61 HOLDS CURENT DATE, 1-60 ARE PAST & 62-121 FUTUE       *        
      ******************************************************************        
      *                                                                         
       0140-LOAD-WORK-DAYS.                                             
      *                                                                         
           MOVE '01'                         TO J8-COMPANY-NO.          
           MOVE WS-CURRENT-DATE              TO WS-WORK-DAY (61).       
      *                                                                         
           SET WD-INDX                       TO 62.                     
           MOVE 1                            TO WS-ADJ-DAY.             
      *                                                                         
           PERFORM UNTIL WD-INDX > 121 OR WS-ADJ-DAY > 90               
              PERFORM 7010-GET-NEXT-WORK-DAY THRU 7010-EXIT             
              IF SQLCODE = SUCCESSFUL-CALL                              
                 MOVE WS-WORK-DATE           TO WS-WORK-DAY (WD-INDX)   
                 ADD 1                       TO WS-ADJ-DAY              
                 SET WD-INDX                 UP BY 1                    
              ELSE                                                      
                 ADD 1                       TO WS-ADJ-DAY              
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
           SET WD-INDX                       TO 60.                     
           MOVE 1                            TO WS-ADJ-DAY.             
      *                                                                         
           PERFORM UNTIL WD-INDX < 1 OR WS-ADJ-DAY > 90                 
              PERFORM 7020-GET-PREV-WORK-DAY THRU 7020-EXIT             
              IF SQLCODE = SUCCESSFUL-CALL                              
                 MOVE WS-WORK-DATE           TO WS-WORK-DAY (WD-INDX)   
                 ADD 1                       TO WS-ADJ-DAY              
                 SET WD-INDX                 DOWN BY 1                  
              ELSE                                                      
                 ADD 1                       TO WS-ADJ-DAY              
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       0140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                 12256500
           MOVE PARM-USER-ID               TO PF-USER-ID.               
           MOVE PARM-ACCOUNT-NO            TO WS-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NUM             TO AC-ACCOUNT-NO             
                                              AT-ACCOUNT-NO             
                                              DA-ACCOUNT-NO.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
      * Compute deferred receivables                                            
      *                                                                         
           MOVE 'N'                        TO WS-EOF-CURSOR.            
           PERFORM 7300-OPEN-AR-CURSOR     THRU 7300-EXIT.              
           PERFORM 7310-FETCH-AR-CURSOR    THRU 7310-EXIT.              
           PERFORM 2100-GET-AR-BALANCE     THRU 2100-EXIT               
                                           UNTIL NO-MORE-DATA.          
           PERFORM 7320-CLOSE-AR-CURSOR    THRU 7320-EXIT.              
           MOVE WS-UTILITY-BALANCE         TO S-CONTRACT-TOT-AMT.       
      *                                                                         
           SET  WS-OPTIONS                 TO TRUE.                     
           PERFORM 7060-GET-ACCT-DET       THRU 7060-EXIT.              
           MOVE AT-COMPANY-NO              TO WS-COMPANY.               
           MOVE AT-LAST-UPDATE-TS          TO S-AT-LAST-UPDATE-TS.      
A03118     MOVE AT-LOCAL-OFFICE            TO B1-LOCAL-OFFICE.          
A03118     MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT.    
           PERFORM 7090-SEL-RESP-AREA-ID   THRU 7090-EXIT.              
           MOVE PF-RESP-AREA-ID            TO S-RESP-AREA-ID.           
      *                                                                         
      * Compute Undeferred receivables                                          
      *                                                                         
      *    COMPUTE S-UNDEFER-RECV-AMT       = AT-TOTAL-AR-BALANCE -             
      *                                       WS-UTILITY-BALANCE                
           MOVE WS-UNDEFR-UTL-BAL          TO S-UNDEFER-RECV-AMT.       
      *                                                                         
      *                                                                         
      * Get payment start date & Earnest date                                   
      *                                                                         
           PERFORM 2600-SEL-BILL-DATES     THRU 2600-EXIT.              
           MOVE WS-NEXT-BILL-DT            TO WS-SEARCH-DATE.           
      *                                                                         
      * Get Billed Unpaid Deposit Amount                                        
      *                                                                         
           PERFORM 7080-GET-UNPAID-DEP     THRU 7080-EXIT.              
           MOVE WS-UNPAID-DEP-AMT          TO S-UNPAID-DEP-AMT.         
      *                                                                         
      * Get DFA Item id form CSR02083                                           
      *                                                                         
           MOVE 'B'                        TO S-DFA-TYPE.               
           PERFORM 7040-GET-MAX-ITEM-ID    THRU 7040-EXIT.              
      *                                                                         
      * Evaluate DPP options                                                    
      *                                                                         
           EVALUATE TRUE                                                
               WHEN CSR-DATABASE                                        
                    IF WS-SCEG                                          
                       MOVE '01'                  TO C8-COMPANY-NO      
A03118                                               B1-COMPANY-NO      
                       MOVE 'DPP-DEP-CALC-FLAG'   TO C8-DELINQ-CD       
                       PERFORM 7050-SELECT-DELINQ THRU 7050-EXIT        
                       MOVE C8-DELINQ-VALUE       TO WS-DPP-DEP-BPA     
                       IF WS-DPP-DEP-BPA = 1                            
                          INITIALIZE WS-03515-IN-PARM                   
                          MOVE WS-ACCOUNT-NO   TO WS-03515-ACCOUNT-NO   
                          MOVE 'PCSCA132'      TO WS-03515-CALLING-PGM  
                          MOVE 'B'             TO WS-03515-AUTO-DEP-TYPE
                          MOVE ZERO            TO                       
                                                WS-03515-DL-AUTO-DEP-AMT
                          MOVE 'SYSTEM'        TO WS-03515-USER-ID      
                          MOVE 'N'             TO WS-03515-ERROR-SW     
ACT239                    MOVE SPACES          TO WS-03515-BATCH-DATE   
      * Get Auto deposit amount form CSR03515                                   
                          PERFORM 5000-CALL-CSR03515     THRU 5000-EXIT 
                          MOVE WS-DEP-TOT-AMT  TO S-DEP-TOT-AMT         
                       ELSE                                             
                          MOVE 0               TO S-DEP-TOT-AMT         
                       END-IF                                           
      *                                                                         
A03118                 PERFORM 7400-SEL-GAS-ONLY-LOC-OFF THRU 7400-EXIT 
A03118                 IF WS-GAS-ONLY-OFFICE = 'Y'                      
A03118                    MOVE 'AMT-SECONDDNPGASL'  TO C8-DELINQ-CD     
A03118                 ELSE                                             
A03118                   IF WS-CODE-DPP-ACCT = 'A'                      
A03118                      MOVE 'AMT-DNPDFALIMIT'  TO C8-DELINQ-CD     
A03118                   ELSE                                           
A03118                      MOVE 'AMT-SECONDDNPL'   TO C8-DELINQ-CD     
A03118                   END-IF                                         
A03118                 END-IF                                           
A03118                 PERFORM 7050-SELECT-DELINQ   THRU 7050-EXIT      
A03118                 MOVE C8-DELINQ-VALUE         TO WS-SCEG-DNP-LIMIT
A03118*                                                                         
A03118                 IF WS-DEPOSIT-AMOUNT > WS-SCEG-DNP-LIMIT         
A03118                    PERFORM 2220-GET-SCEG-OPTION THRU 2220-EXIT   
A03118                 ELSE                                             
                          PERFORM 2200-GET-SCEG-OPTNS  THRU 2200-EXIT   
A03118                 END-IF                                           
                    ELSE                                                
                       PERFORM 2300-GET-PSNC-OPTNS  THRU 2300-EXIT      
                    END-IF                                              
               WHEN SEB-DATABASE                                        
                    PERFORM 7070-SEL-REG-PROFILE    THRU 7070-EXIT      
A03301              MOVE WS-SEAS-DPP-STRT-DT(1:4) TO                    
A03301                                          WS-DPP-STRT-MTH-AND-DAY 
A03301              MOVE WS-SEAS-DPP-END-DT(1:4)  TO                    
A03301                                          WS-DPP-END-MTH-AND-DAY  
                    IF WS-REG                                           
                       PERFORM 2400-GET-REG-OPTNS   THRU 2400-EXIT      
                    ELSE                                                
                       PERFORM 2500-GET-DREG-OPTNS  THRU 2500-EXIT      
                   END-IF                                               
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-GET-AR-BALANCE.                                           *        
      ******************************************************************        
      *                                                                         
       2100-GET-AR-BALANCE.                                             
      *                                                                         
           IF ((AC-PYMT-PRIORITY-LVL = WS-PPL-NSA OR WS-PPL-LPC  OR     
                                       WS-PPL-UTE OR WS-PPL-UTG) AND    
               AC-ITEM-ID = 0)                                          
A03300     OR (AC-PYMT-PRIORITY-LVL = WS-PPL-RCC AND AC-ITEM-ID = 0 AND 
               (AC-AMT-AR-DAY-00 + AC-AMT-AR-DAY-30 + AC-AMT-AR-DAY-60 +
                AC-AMT-AR-DAY-90 + AC-AMT-UNUSED-CR) > 0)               
                 COMPUTE WS-UTILITY-BALANCE    = WS-UTILITY-BALANCE +   
                                                 AC-AMT-AR-DAY-00   +   
                                                 AC-AMT-AR-DAY-30   +   
                                                 AC-AMT-AR-DAY-60   +   
                                                 AC-AMT-AR-DAY-90   +   
                                                 AC-AMT-UNUSED-CR       
                 COMPUTE WS-RECV-AMT-HOLD      = AC-AMT-AR-DAY-00   +   
                                                 AC-AMT-AR-DAY-30   +   
                                                 AC-AMT-AR-DAY-60   +   
                                                 AC-AMT-AR-DAY-90   +   
                                                 AC-AMT-UNUSED-CR       
      *                                                                         
              SET  WS-RECVBLE-DEFR            TO TRUE                   
              MOVE AC-PYMT-PRIORITY-LVL       TO S-PYMT-PRTY-LVL-DEFR   
              MOVE WS-RECV-AMT-HOLD           TO S-RECV-AMT-DEFR        
              MOVE AC-LAST-UPDATE-TS          TO S-AC-LAST-UPD-TS-DEFR  
              MOVE AC-ITEM-ID                 TO S-ITEM-ID              
              MOVE L5-AR-TYPE-LONG-DESC       TO S-AR-TYPE-DEFR         
              MOVE L5-AR-TYPE-SHORT-DESC      TO S-AR-TYPE-DEFR-SHORT   
              PERFORM 8020-INSERT-GTT-R2      THRU 8020-EXIT            
           ELSE                                                         
                                                                        
              IF AC-ITEM-ID = 0                                         
                 COMPUTE WS-UNDEFR-UTL-BAL    = WS-UNDEFR-UTL-BAL +     
                                                AC-AMT-AR-DAY-00  +     
                                                AC-AMT-AR-DAY-30  +     
                                                AC-AMT-AR-DAY-60  +     
                                                AC-AMT-AR-DAY-90        
                 COMPUTE WS-RECV-AMT-HOLD     = AC-AMT-AR-DAY-00  +     
                                                AC-AMT-AR-DAY-30  +     
                                                AC-AMT-AR-DAY-60  +     
                                                AC-AMT-AR-DAY-90        
                 IF AC-TOT-SUMM-UNBILLED > 0                            
                    COMPUTE WS-UNDEFR-UTL-BAL = WS-UNDEFR-UTL-BAL  +    
                                                AC-TOT-SUMM-UNBILLED    
                    COMPUTE WS-RECV-AMT-HOLD  = WS-RECV-AMT-HOLD +      
                                                AC-TOT-SUMM-UNBILLED    
                 END-IF                                                 
                 SET WS-RECVBLE-UNDEFR        TO TRUE                   
                 MOVE AC-PYMT-PRIORITY-LVL    TO S-PYMT-PRTY-LVL-UNDEFR 
                 MOVE WS-RECV-AMT-HOLD        TO S-RECV-AMT-UNDEFR      
                 MOVE L5-AR-TYPE-LONG-DESC    TO S-AR-TYPE-UNDEFR       
                 PERFORM 8030-INSERT-GTT-R3   THRU 8030-EXIT            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7310-FETCH-AR-CURSOR       THRU 7310-EXIT.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2200-GET-SCEG-OPTNS.                                           *        
      ******************************************************************        
      *                                                                         
       2200-GET-SCEG-OPTNS.                                             
      *                                                                         
      * Option#1                                                        11670000
      *                                                                 11670000
P00594     ADD 1                             TO WS-OPTION-SEQ-NO-CNT.   
P00594     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO.        
      * Earnest amount = 50% of the Util Bal                            11670000
A03536     COMPUTE S-1ST-ERNST-AMT  ROUNDED = WS-UTILITY-BALANCE * 0.5. 
A05201     PERFORM 5710-COMMON-SCEG-OPTION-VAL THRU 5710-EXIT.          
           MOVE 4                            TO S-NO-SCHED-PYMTS.       
           PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT.            
           MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT.      
           PERFORM 5400-CALC-DEP-AMT-MO-PYMT THRU 5400-EXIT.            
           MOVE WS-DEP-AMT-MO-PYMT           TO S-DEP-AMT-MO-PYMT.      
           PERFORM 5100-GET-END-DATE         THRU 5100-EXIT.            
           MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT.          
A03301     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT.            
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
A05201*                                                                         
A05201* Option#2 - Edit Option (Manual Arrangement)                     11670000
      *                                                                 11670000
A05201     PERFORM 2220-GET-SCEG-OPTION      THRU 2220-EXIT.            
      *                                                                         
      * Option#3                                                        11670000
      *                                                                         
P00594     ADD 1                             TO WS-OPTION-SEQ-NO-CNT.   
P00594     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO.        
A03536     COMPUTE S-1ST-ERNST-AMT  ROUNDED = WS-UTILITY-BALANCE * 0.3. 
A05201     PERFORM 5710-COMMON-SCEG-OPTION-VAL THRU 5710-EXIT.          
           MOVE 3                            TO S-NO-SCHED-PYMTS.       
           PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT.            
           MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT.      
           PERFORM 5400-CALC-DEP-AMT-MO-PYMT THRU 5400-EXIT.            
                                                                        
           MOVE WS-DEP-AMT-MO-PYMT           TO S-DEP-AMT-MO-PYMT.      
           PERFORM 5100-GET-END-DATE         THRU 5100-EXIT.            
           MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT.          
A03301     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT.            
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
      *                                                                 11670000
      * Option#4                                                        11670000
      *                                                                 11670000
P00594     ADD 1                             TO WS-OPTION-SEQ-NO-CNT.   
P00594     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO.        
           MOVE 4                            TO S-NO-SCHED-PYMTS.       
           PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT.            
           MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT.      
           PERFORM 5400-CALC-DEP-AMT-MO-PYMT THRU 5400-EXIT.            
           MOVE WS-DEP-AMT-MO-PYMT           TO S-DEP-AMT-MO-PYMT.      
           PERFORM 5100-GET-END-DATE         THRU 5100-EXIT.            
           MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT.          
A03301     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT.            
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
A03118******************************************************************        
A03118* 2220-GET-SCEG-OPTION.                                          *        
A03118******************************************************************        
A03118*                                                                         
A03118 2220-GET-SCEG-OPTION.                                            
A03118*                                                                         
A03118* Option#4 - Edit Option                                          11670000
A03118*                                                                 11670000
A03118     MOVE 'NDPP'                       TO S-DPP-TYPE              
A03118     MOVE 'Y'                          TO S-OPTN-EDIT-FLAG        
P00594     ADD 1                             TO WS-OPTION-SEQ-NO-CNT    
P00594     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO         
A03118     MOVE SPACES                       TO S-PYMT-END-DT           
A03118     MOVE ZEROS                        TO S-1ST-ERNST-AMT         
A03118                                          S-2ND-ERNST-AMT         
A03118                                          S-NO-SCHED-PYMTS        
A03118                                          S-DPP-AMT-MO-PYMT       
A03118                                          S-DEP-AMT-MO-PYMT       
A03118* DPP DNP/Pymt Start Dt = 'Next Bill Dt'                                  
A03118     MOVE WS-NEXT-BILL-DT              TO S-PYMT-STRT-DT          
A03118                                          S-DNP-DATE              
A03118* Ernst Amt Last Dt = Next DNP Dt - 1 Day                                 
A03118     MOVE 1                            TO WS-ADJ-DAY              
A03118     PERFORM 5200-GET-BUSINESS-DAY     THRU 5200-EXIT             
A03118     MOVE WS-ADJUSTED-DT               TO S-DNP-MINUS1            
A03118                                          S-ERNST-PYMT-LST-DT     
A03118* Notice Mail Dt = Next DNP Dt - 'DAY-DPPEARNEST' Days                    
A03118     MOVE WS-DAY-DPP-ERNST             TO WS-ADJ-DAY              
A03118     PERFORM 5200-GET-BUSINESS-DAY     THRU 5200-EXIT             
A03118     MOVE WS-ADJUSTED-DT               TO S-DNP-MINUS-DELINQ      
A03118*                                                                         
A03118     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT             
A03118     PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
A03118*                                                                         
A03118 2220-EXIT.                                                       
A03118     EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2300-GET-PSNC-OPTNS.                                           *        
      ******************************************************************        
      *                                                                         
       2300-GET-PSNC-OPTNS.                                             
      *                                                                 11670000
      * Option#1                                                        11670000
      *                                                                 11670000
      * Earnest amount = 50 % of the Util Bal                           11670000
A05201     COMPUTE S-1ST-ERNST-AMT ROUNDED = WS-UTILITY-BALANCE * 0.5.  
A05201     PERFORM 5720-COMMON-PSNC-OPTION-VAL THRU 5720-EXIT.          
P00594     ADD 1                             TO WS-OPTION-SEQ-NO-CNT.   
P00594     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO.        
A05201     MOVE 4                            TO S-NO-SCHED-PYMTS.       
           PERFORM 5100-GET-END-DATE         THRU 5100-EXIT.            
           MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT.          
           PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT.            
           MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT.      
A03301     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT.            
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
      *                                                                 11670000
A05201* Option#2 - Edit Option (Manual Arrangement)                     11670000
      *                                                                 11670000
P00594     ADD 1                             TO WS-OPTION-SEQ-NO-CNT.   
P00594     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO.        
           MOVE 'Y'                          TO S-OPTN-EDIT-FLAG.       
           MOVE SPACES                       TO S-PYMT-END-DT.          
           MOVE ZEROS                        TO S-1ST-ERNST-AMT         
                                                S-2ND-ERNST-AMT         
                                                S-NO-SCHED-PYMTS        
                                                S-DPP-AMT-MO-PYMT       
                                                S-DEP-AMT-MO-PYMT.      
A03301     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT.            
           PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
A05201*                                                                         
A05201* Option#3                                                        11670000
A05201*                                                                 11670000
A05201* Earnest amount = 30 % of the Util Bal with 3 Installment        11670000
A05201     COMPUTE S-1ST-ERNST-AMT ROUNDED = WS-UTILITY-BALANCE * 0.3.  
A05201     PERFORM 5720-COMMON-PSNC-OPTION-VAL THRU 5720-EXIT.          
A05201     ADD 1                             TO WS-OPTION-SEQ-NO-CNT.   
A05201     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO.        
A05201     MOVE 3                            TO S-NO-SCHED-PYMTS.       
A05201     PERFORM 5100-GET-END-DATE         THRU 5100-EXIT.            
A05201     MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT.          
A05201     PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT.            
A05201     MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT.      
A05201     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT.            
A05201     PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
A05201*                                                                         
A05201* Option#4                                                        11670000
A05201*                                                                 11670000
A05201* Earnest amount = 30 % of the Util Bal with 4 Installment        11670000
A05201     ADD 1                             TO WS-OPTION-SEQ-NO-CNT.   
A05201     MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO.        
A05201     MOVE 4                            TO S-NO-SCHED-PYMTS.       
A05201     PERFORM 5100-GET-END-DATE         THRU 5100-EXIT.            
A05201     MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT.          
A05201     PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT.            
A05201     MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT.      
A05201     PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT.            
A05201     PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT.            
      *                                                                 11670000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 2400-GET-REG-OPTNS                                             *        
      ******************************************************************        
      *                                                                         
       2400-GET-REG-OPTNS.                                              
      *                                                                 11670000
           MOVE 'NDPP'                       TO S-DPP-TYPE.             
           MOVE 'N'                          TO S-OPTN-EDIT-FLAG.       
           MOVE 0                            TO S-DEP-TOT-AMT.          
           MOVE 0                            TO S-DEP-AMT-MO-PYMT.      
      * DPP DNP/Pymt Start Dt = 'Next Bill Dt'                                  
           MOVE WS-NEXT-BILL-DT              TO S-PYMT-STRT-DT          
P00471                                          S-DNP-DATE.             
      * Earnest amount = 20% of the Util Bal                            11670000
           COMPUTE S-1ST-ERNST-AMT ROUNDED  = WS-UTILITY-BALANCE * 0.2. 
           IF S-1ST-ERNST-AMT > 0                                       
      * Ernst Amt Last Dt = Next Bill Dt - 1 Day                                
              MOVE 1                         TO WS-ADJ-DAY              
              PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
              MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS1            
                                                S-ERNST-PYMT-LST-DT     
      * Notice Mail Dt = Next Bill Dt - 'DAY-DPPEARNEST' Days                   
              MOVE WS-DAY-DPP-ERNST          TO WS-ADJ-DAY              
              PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
              MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS-DELINQ      
           END-IF.                                                      
      *                                                                         
      * Option#1                                                        11670000
      *                                                                 11670000
P00726     IF PARM-TYPE = 'NDPP' OR 'DPP'                               
              IF S-CONTRACT-TOT-AMT <= 500                              
P00594           ADD 1                          TO WS-OPTION-SEQ-NO-CNT 
P00594           MOVE WS-OPTION-SEQ-NO-CNT      TO S-OPTION-SEQ-NO      
                 MOVE 2                         TO S-NO-SCHED-PYMTS     
                 PERFORM 5100-GET-END-DATE      THRU 5100-EXIT          
                 MOVE WS-PYMT-END-DT            TO S-PYMT-END-DT        
                 PERFORM 5300-CALC-AMT-MO-PYMT  THRU 5300-EXIT          
                 MOVE WS-DPP-AMT-MO-PYMT        TO S-DPP-AMT-MO-PYMT    
A03301           PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT       
                 PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT          
              END-IF                                                    
      *                                                                    11670
      * Option#2                                                           11670
      *                                                                    11670
P00594        ADD 1                             TO WS-OPTION-SEQ-NO-CNT 
P00594        MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO      
              MOVE 3                            TO S-NO-SCHED-PYMTS     
              PERFORM 5100-GET-END-DATE         THRU 5100-EXIT          
              MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT        
              PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT          
              MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT    
A03301        PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT          
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
      *                                                                  11670  
      * Option#3                                                         11670  
      *                                                                  11670  
P00594        ADD 1                             TO WS-OPTION-SEQ-NO-CNT 
P00594        MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO      
              MOVE 4                            TO S-NO-SCHED-PYMTS     
              PERFORM 5100-GET-END-DATE         THRU 5100-EXIT          
              MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT        
              PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT          
              MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT    
A03301        PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT          
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
      *                                                                    11670
      * Option#4                                                           11670
      *                                                                    11670
              IF S-CONTRACT-TOT-AMT > 500                               
P00594           ADD 1                          TO WS-OPTION-SEQ-NO-CNT 
P00594           MOVE WS-OPTION-SEQ-NO-CNT      TO S-OPTION-SEQ-NO      
                 MOVE 6                         TO S-NO-SCHED-PYMTS     
                 PERFORM 5100-GET-END-DATE      THRU 5100-EXIT          
                 MOVE WS-PYMT-END-DT            TO S-PYMT-END-DT        
                 PERFORM 5300-CALC-AMT-MO-PYMT  THRU 5300-EXIT          
                 MOVE WS-DPP-AMT-MO-PYMT        TO S-DPP-AMT-MO-PYMT    
A03301           PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT       
                 PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT          
              END-IF                                                    
      *                                                                    11670
      * Option#5 - Edit Option                                             11670
      *                                                                    11670
              MOVE 'Y'                          TO S-OPTN-EDIT-FLAG     
P00594        ADD 1                             TO WS-OPTION-SEQ-NO-CNT 
P00594        MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO      
              MOVE SPACES                       TO S-PYMT-END-DT        
              MOVE ZEROS                        TO S-1ST-ERNST-AMT      
                                                   S-2ND-ERNST-AMT      
                                                   S-NO-SCHED-PYMTS     
                                                   S-DPP-AMT-MO-PYMT    
                                                   S-DEP-AMT-MO-PYMT    
A03301        PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT          
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
P00726* Option#6                                                        11670000
P00726        IF PARM-TYPE = 'DPP'                                      
P00726           PERFORM 2410-REG-SDPP-DTLS     THRU 2410-EXIT          
P00726        END-IF                                                    
A03301     ELSE                                                         
A03301        IF PARM-TYPE = 'SDPP'                                     
      * Option#6                                                        11670000
P00726           PERFORM 2410-REG-SDPP-DTLS     THRU 2410-EXIT          
A03301        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
P00726******************************************************************        
P00726* 2410-REG-SDPP-DTLS                                             *        
P00726******************************************************************        
P00726                                                                  
P00726 2410-REG-SDPP-DTLS.                                              
P00726                                                                  
P00726     ADD 1                                TO WS-OPTION-SEQ-NO-CNT.
P00726     MOVE WS-OPTION-SEQ-NO-CNT            TO S-OPTION-SEQ-NO.     
P00726     MOVE 7                               TO S-NO-SCHED-PYMTS.    
P00726     MOVE 'SDPP'                          TO S-DPP-TYPE.          
P00726     MOVE 0                               TO S-1ST-ERNST-AMT.     
P00726     MOVE SPACES                          TO S-ERNST-PYMT-LST-DT. 
P00726     MOVE 0                               TO S-2ND-ERNST-AMT.     
P00726     MOVE 'N'                             TO S-OPTN-EDIT-FLAG.    
P00726     PERFORM 5600-GET-SEAS-BILL-DT        THRU 5600-EXIT.         
P00726     MOVE BN-DATE-EXTRACT                 TO S-PYMT-STRT-DT.      
P00726     PERFORM 5100-GET-END-DATE            THRU 5100-EXIT.         
P00726     MOVE WS-PYMT-END-DT                  TO S-PYMT-END-DT.       
P00726     PERFORM 5300-CALC-AMT-MO-PYMT        THRU 5300-EXIT.         
P00726     MOVE WS-DPP-AMT-MO-PYMT              TO S-DPP-AMT-MO-PYMT.   
P00726     PERFORM 5700-CALC-AMT-MO-PYMT-LST    THRU 5700-EXIT.         
P00726     PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
P00726                                                                  
P00726 2410-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************        
      ******************************************************************        
      * 2500-GET-DREG-OPTNS                                            *        
      ******************************************************************        
      *                                                                         
       2500-GET-DREG-OPTNS.                                             
      *                                                                 11670000
           MOVE 'NDPP'                       TO S-DPP-TYPE.             
           MOVE 'N'                          TO S-OPTN-EDIT-FLAG.       
           MOVE 0                            TO S-DEP-TOT-AMT.          
           MOVE 0                            TO S-DEP-AMT-MO-PYMT.      
      * DPP DNP/Pymt Start Dt = 'Next Bill Dt'                                  
           MOVE WS-NEXT-BILL-DT              TO S-PYMT-STRT-DT          
P00471                                          S-DNP-DATE.             
      * Earnest amount = 20% of the Util Bal                            11670000
           COMPUTE S-1ST-ERNST-AMT ROUNDED  = WS-UTILITY-BALANCE * 0.2. 
           IF S-1ST-ERNST-AMT > 0                                       
      * Ernst Amt Last Dt = Next Bill Dt - 1 Day                                
              MOVE 1                         TO WS-ADJ-DAY              
              PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
              MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS1            
                                                S-ERNST-PYMT-LST-DT     
      * Notice Mail Dt = Next Bill Dt - 'DAY-DPPEARNEST' Days                   
              MOVE WS-DAY-DPP-ERNST          TO WS-ADJ-DAY              
              PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
              MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS-DELINQ      
           END-IF.                                                      
      *                                                                         
      * Option#1                                                        11670000
      *                                                                 11670000
P00726     IF PARM-TYPE = 'NDPP' OR 'DPP'                               
              IF S-CONTRACT-TOT-AMT <= 500                              
P00594           ADD 1                          TO WS-OPTION-SEQ-NO-CNT 
P00594           MOVE WS-OPTION-SEQ-NO-CNT      TO S-OPTION-SEQ-NO      
                 MOVE 2                         TO S-NO-SCHED-PYMTS     
                 PERFORM 5100-GET-END-DATE      THRU 5100-EXIT          
                 MOVE WS-PYMT-END-DT            TO S-PYMT-END-DT        
                 PERFORM 5300-CALC-AMT-MO-PYMT  THRU 5300-EXIT          
                 MOVE WS-DPP-AMT-MO-PYMT        TO S-DPP-AMT-MO-PYMT    
A03301           PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT       
                 PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT          
              END-IF                                                    
      *                                                                    11670
      * Option#2                                                           11670
      *                                                                    11670
P00594        ADD 1                             TO WS-OPTION-SEQ-NO-CNT 
P00594        MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO      
              MOVE 3                            TO S-NO-SCHED-PYMTS     
              PERFORM 5100-GET-END-DATE         THRU 5100-EXIT          
              MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT        
              PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT          
              MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT    
A03301        PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT          
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
      *                                                                    11670
      * Option#3                                                           11670
      *                                                                    11670
P00594        ADD 1                             TO WS-OPTION-SEQ-NO-CNT 
P00594        MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO      
              MOVE 4                            TO S-NO-SCHED-PYMTS     
              PERFORM 5100-GET-END-DATE         THRU 5100-EXIT          
              MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT        
              PERFORM 5300-CALC-AMT-MO-PYMT     THRU 5300-EXIT          
              MOVE WS-DPP-AMT-MO-PYMT           TO S-DPP-AMT-MO-PYMT    
A03301        PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT          
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
      *                                                                    11670
      * Option#4                                                           11670
      *                                                                    11670
              IF S-CONTRACT-TOT-AMT > 500                               
P00594           ADD 1                          TO WS-OPTION-SEQ-NO-CNT 
P00594           MOVE WS-OPTION-SEQ-NO-CNT      TO S-OPTION-SEQ-NO      
                 MOVE 6                         TO S-NO-SCHED-PYMTS     
                 PERFORM 5100-GET-END-DATE      THRU 5100-EXIT          
                 MOVE WS-PYMT-END-DT            TO S-PYMT-END-DT        
                 PERFORM 5300-CALC-AMT-MO-PYMT  THRU 5300-EXIT          
                 MOVE WS-DPP-AMT-MO-PYMT        TO S-DPP-AMT-MO-PYMT    
A03301           PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT       
                 PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT          
              END-IF                                                    
      *                                                                    11670
      * Option#5 - Edit Option                                             11670
      *                                                                    11670
              MOVE 'Y'                          TO S-OPTN-EDIT-FLAG     
P00594        ADD 1                             TO WS-OPTION-SEQ-NO-CNT 
P00594        MOVE WS-OPTION-SEQ-NO-CNT         TO S-OPTION-SEQ-NO      
              MOVE SPACES                       TO S-PYMT-END-DT        
              MOVE ZEROS                        TO S-1ST-ERNST-AMT      
                                                   S-2ND-ERNST-AMT      
                                                   S-NO-SCHED-PYMTS     
                                                   S-DPP-AMT-MO-PYMT    
                                                   S-DEP-AMT-MO-PYMT    
A03301        PERFORM 5700-CALC-AMT-MO-PYMT-LST THRU 5700-EXIT          
              PERFORM 8010-INSERT-GTT-R1        THRU 8010-EXIT          
P00726* option#6                                                                
P00726        IF PARM-TYPE = 'DPP'                                      
P00726           PERFORM 2510-DREG-SDPP-DTLS    THRU 2510-EXIT          
P00726        END-IF                                                    
A03301     ELSE                                                         
      * Option#6                                                        11670000
A03301        IF PARM-TYPE = 'SDPP'                                     
P00726           PERFORM 2510-DREG-SDPP-DTLS    THRU 2510-EXIT          
A03301        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
P00726******************************************************************        
P00726* 2510-DREG-SDPP-DTLS                                            *        
P00726******************************************************************        
P00726                                                                  
P00726 2510-DREG-SDPP-DTLS.                                             
P00726                                                                  
P00726     MOVE 'N'                             TO S-OPTN-EDIT-FLAG.    
P00726     ADD 1                                TO WS-OPTION-SEQ-NO-CNT.
P00726     MOVE WS-OPTION-SEQ-NO-CNT            TO S-OPTION-SEQ-NO.     
P00726     MOVE 7                               TO S-NO-SCHED-PYMTS.    
P00726     MOVE 'SDPP'                          TO S-DPP-TYPE.          
P00726     MOVE 0                               TO S-1ST-ERNST-AMT.     
P00726     MOVE SPACES                          TO S-ERNST-PYMT-LST-DT. 
P00726     MOVE 0                               TO S-2ND-ERNST-AMT.     
P00726     MOVE 'N'                             TO S-OPTN-EDIT-FLAG.    
P00726     PERFORM 5600-GET-SEAS-BILL-DT        THRU 5600-EXIT.         
P00726     MOVE BN-DATE-EXTRACT                 TO S-PYMT-STRT-DT.      
P00726     PERFORM 5100-GET-END-DATE            THRU 5100-EXIT.         
P00726     MOVE WS-PYMT-END-DT                  TO S-PYMT-END-DT.       
P00726     PERFORM 5300-CALC-AMT-MO-PYMT        THRU 5300-EXIT.         
P00726     MOVE WS-DPP-AMT-MO-PYMT              TO S-DPP-AMT-MO-PYMT.   
P00726     PERFORM 5700-CALC-AMT-MO-PYMT-LST    THRU 5700-EXIT.         
P00726     PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
P00726                                                                  
P00726 2510-EXIT.                                                       
P00726     EXIT.                                                        
P00726                                                                  
      ******************************************************************        
      * 2600-SEL-BILL-DATES                                            *        
      ******************************************************************        
      *                                                                         
       2600-SEL-BILL-DATES.                                             
      *                                                                         
           PERFORM 5900-NEXT-BILL-DATE    THRU 5900-NEXT-BILL-DATE-EXIT.
      *                                                                         
           IF WS-NULL-DATE-EXTRACT = 0                                  
              MOVE BN-DATE-EXTRACT        TO WS-NEXT-BILL-DT            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-1            
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '5900'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-CALL-CSR03515.                                            *        
      *      GET AUTO DEPOSIT AMOUNT                                   *        
      ******************************************************************        
      *                                                                         
       5000-CALL-CSR03515.                                              
      *                                                                         
           INITIALIZE WS-03515-OUT-PARM.                                
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR03515 (                                         
      *                        :WS-03515-ACCOUNT-NO                     
      *                       ,:WS-03515-CALLING-PGM                    
      *                       ,:WS-03515-AUTO-DEP-TYPE                  
      *                       ,:WS-03515-DL-AUTO-DEP-AMT                
      *                       ,:WS-03515-USER-ID                        
      *                       ,:WS-03515-ERROR-SW                       
ACT239*                       ,:WS-03515-BATCH-DATE                     
      *                       )                                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE AUTO_DEP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN AUTO_DEP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR AUTO_DEP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL                                                  
      *           ASSOCIATE LOCATORS                                    
      *           (:LOC-RESLTSET)                                       
      *           WITH PROCEDURE CSR03515                               
      *       END-EXEC                                                  
      *                                                                         
      *       EXEC SQL                                                  
      *           ALLOCATE AUTO_DEP CURSOR FOR RESULT SET               
      *           :LOC-RESLTSET                                         
      *       END-EXEC                                                  
      *                                                                         
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
      *                                                                         
              EXEC SQL                                                  
                FETCH AUTO_DEP                                          
                 INTO        :WS-03515-RETURN-CODE                      
                            ,:WS-03515-AUTO-DEP-AMT                     
                            ,:WS-03515-DEP-SUCCESS                      
                            ,:WS-03515-DEP-CERT-NO                      
                            ,:WS-03515-MAX-DEP-ZERO-WQ                  
                            ,:WS-03515-AMT-SECURED                      
                            ,:WS-03515-ABEND-PROGRAM                    
                            ,:WS-03515-ACTIVE-PARAGRAPH                 
                            ,:WS-03515-ABEND-FUNCTION                   
                            ,:WS-03515-TABLE-1                          
                            ,:WS-03515-TABLE-ELEMENT-1                  
                            ,:WS-03515-HOSTVAR-ELEMENT-1                
                            ,:WS-03515-TABLE-ELEMENT-2                  
                            ,:WS-03515-HOSTVAR-ELEMENT-2                
                            ,:WS-03515-TABLE-ELEMENT-3                  
                            ,:WS-03515-HOSTVAR-ELEMENT-3                
                            ,:WS-03515-TABLE-ELEMENT-4                  
                            ,:WS-03515-HOSTVAR-ELEMENT-4                
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 EVALUATE WS-03515-RETURN-CODE                          
                     WHEN 0                                             
                          MOVE WS-03515-AUTO-DEP-AMT                    
                                             TO WS-DEP-TOT-AMT          
                     WHEN 100                                           
                          MOVE ZERO          TO WS-DEP-TOT-AMT          
                     WHEN OTHER                                         
                          MOVE WS-03515-RETURN-CODE                     
                                             TO WS-ACTIVE-RETURN-CODE   
                          ADD +1             TO CTR-ROWS                
                          PERFORM 9999-END-PROGRAM     THRU 9999-EXIT   
                 END-EVALUATE                                           
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '5000'                 TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR03515'             TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE WS-03515-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
              END-IF                                                    
      *                                                                         
              EXEC SQL                                                  
                 CLOSE AUTO_DEP                                         
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '5000'                 TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'CLOSE'                TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR03515'             TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE WS-03515-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5000'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'DB2SP'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR03515'                TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE WS-03515-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-GET-END-DATE                                              *        
      ******************************************************************        
      *                                                                         
       5100-GET-END-DATE.                                               
      *                                                                 11670000
           MOVE S-PYMT-STRT-DT               TO WS-PYMT-STRT-DT.        
           MOVE S-NO-SCHED-PYMTS             TO WS-NO-SCHED-PYMTS.      
           COMPUTE WS-NO-OF-DAYS ROUNDED = (WS-NO-SCHED-PYMTS - 1) *    
                                             30.5.                      
           IF WS-NO-OF-DAYS > 0                                         
              PERFORM 7030-GET-END-DATE      THRU 7030-EXIT             
           ELSE                                                         
              MOVE S-PYMT-STRT-DT            TO WS-PYMT-END-DT          
           END-IF.                                                      
      *                                                                 11670000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 5200-GET-BUSINESS-DAY                                          *        
      ******************************************************************        
      *                                                                 11670000
       5200-GET-BUSINESS-DAY.                                           
      *                                                                 11670000
           SET WD-INDX TO 1.                                            
      *                                                                 11670000
           SEARCH WS-WORK-DAY-LIST                                      
             AT END                                                     
                MOVE 100                     TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE-1         
                MOVE 'CSR04367'              TO ABEND-PROGRAM           
                MOVE '5200'                  TO ACTIVE-PARAGRAPH        
                MOVE 'SEARCH'                TO ABEND-FUNCTION          
                MOVE 'WORK DAY  '            TO TABLE-1                 
                MOVE WS-SEARCH-DATE          TO HOSTVAR-ELEMENT-1       
                MOVE 'AT-ACCOUNT-NO'         TO TABLE-2                 
                MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2       
                PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT             
             WHEN WS-WORK-DAY (WD-INDX) = WS-SEARCH-DATE                
                  SET WD-INDX DOWN BY WS-ADJ-DAY                        
                  MOVE WS-WORK-DAY (WD-INDX) TO WS-ADJUSTED-DT          
           END-SEARCH.                                                  
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 5300-CALC-AMT-MO-PYMT                                          *        
      ******************************************************************        
      *                                                                         
       5300-CALC-AMT-MO-PYMT.                                           
      *                                                                 11670000
           MOVE ZERO                         TO WS-DPP-MNTHLY-TOT       
                                                WS-DPP-AMT-MO-PYMT.     
           MOVE S-NO-SCHED-PYMTS             TO WS-NO-SCHED-PYMTS.      
           COMPUTE WS-DPP-MNTHLY-TOT  = WS-UTILITY-BALANCE -            
                                    (S-1ST-ERNST-AMT + S-2ND-ERNST-AMT).
           COMPUTE WS-DPP-AMT-MO-PYMT    = (WS-DPP-MNTHLY-TOT /         
                                            WS-NO-SCHED-PYMTS) * 100.   
           MOVE WS-DPP-AMT-MO-PYMT           TO WS-DPP-AMT-MO-PYMT1.    
           MOVE WS-DPP-AMT-MO-PYMT1          TO WS-DPP-AMT-MO-PYMT2.    
           MOVE WS-DPP-AMT-MO-PYMT2          TO WS-DPP-MO-PYMT.         
           IF WS-DECIMAL-AMT > 0                                        
              COMPUTE WS-DPP-AMT-MO-PYMT = WS-DPP-AMT-MO-PYMT + 1       
           END-IF                                                       
           COMPUTE WS-DPP-AMT-MO-PYMT    = WS-DPP-AMT-MO-PYMT / 100.    
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      * 5400-CALC-DEP-AMT-MO-PYMT                                      *        
      ******************************************************************        
      *                                                                         
       5400-CALC-DEP-AMT-MO-PYMT.                                       
      *                                                                 11670000
           MOVE S-NO-SCHED-PYMTS         TO WS-NO-SCHED-PYMTS .         
           COMPUTE WS-DEP-AMT-MO-PYMT     = WS-DEP-TOT-AMT /            
                                            WS-NO-SCHED-PYMTS.          
      *                                                                 11670000
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5600-GET-SEAS-BILL-DT                                          *        
      ******************************************************************        
      *                                                                         
       5600-GET-SEAS-BILL-DT.                                           
      *                                                                         
           MOVE AT-BILL-CYCLE            TO BN-BILL-CYCLE.              
           MOVE AT-REV-MTH-LST-NRML      TO BN-REVENUE-MONTH.           
           MOVE WS-CURRENT-DATE(6:2)     TO WS-CUR-MNTH-AND-DAY(1:2).   
           MOVE WS-CURRENT-DATE(8:2)     TO WS-CUR-MNTH-AND-DAY(3:2).   
           IF WS-CUR-MNTH-AND-DAY > WS-DPP-END-MTH-AND-DAY              
              MOVE WS-CURRENT-DATE(1:4)  TO WS-YYYY                     
              COMPUTE WS-YYYY-N = WS-YYYY-N + 1                         
           ELSE                                                         
              MOVE WS-CURRENT-DATE(1:4)  TO WS-YYYY                     
           END-IF.                                                      
           MOVE WS-SEAS-DPP-END-DT(1:2)  TO WS-MM.                      
           MOVE WS-SEAS-DPP-END-DT(3:2)  TO WS-DD.                      
           MOVE WS-REFORMAT-DT           TO BN-DATE-EXTRACT.            
      *                                                                         
           PERFORM 7100-GET-SEAS-BILL-DT THRU 7100-EXIT.                
      *                                                                         
       5600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03301******************************************************************        
A03301* 5700-CALC-AMT-MO-PYMT-LST                                      *        
A03301******************************************************************        
A03301*                                                                         
A03301 5700-CALC-AMT-MO-PYMT-LST.                                       
A03301*                                                                 11670000
A03301     COMPUTE S-CONT-BAL-AT-SETUP = S-CONTRACT-TOT-AMT -           
A03301                           S-1ST-ERNST-AMT - S-2ND-ERNST-AMT.     
A03301     COMPUTE S-DPP-AMT-MO-PYMT-LAST = S-CONT-BAL-AT-SETUP -       
A03301                     (S-DPP-AMT-MO-PYMT * (S-NO-SCHED-PYMTS - 1)).
A03301     COMPUTE S-DEP-AMT-MO-PYMT-LAST = S-DEP-TOT-AMT -             
A03301                     (S-DEP-AMT-MO-PYMT * (S-NO-SCHED-PYMTS - 1)).
A03301*                                                                 11670000
A03301 5700-EXIT.                                                       
A03301     EXIT.                                                        
      *                                                                         
A05201******************************************************************        
A05201* 5710-COMMON-SCEG-OPTION-VAL                                    *        
A05201******************************************************************        
A05201                                                                  
A05201 5710-COMMON-SCEG-OPTION-VAL.                                     
A05201                                                                  
A05201     MOVE 'NDPP'                       TO S-DPP-TYPE.             
A05201     MOVE 'N'                          TO S-OPTN-EDIT-FLAG.       
A05201     MOVE 0                            TO S-2ND-ERNST-AMT.        
A05201* DPP DNP/Pymt Start Dt = 'Next Bill Dt'                                  
A05201     MOVE WS-NEXT-BILL-DT              TO S-PYMT-STRT-DT          
A05201                                          S-DNP-DATE.             
A05201     PERFORM 5100-GET-END-DATE         THRU 5100-EXIT.            
A05201     MOVE WS-PYMT-END-DT               TO S-PYMT-END-DT.          
A05201* Ernst Amt Last Dt = Next DNP Dt - 1 Day                                 
A05201     IF S-1ST-ERNST-AMT > 0                                       
A05201        MOVE 1                         TO WS-ADJ-DAY              
A05201        PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
A05201        MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS1            
A05201                                          S-ERNST-PYMT-LST-DT     
A05201* Notice Mail Dt = Next DNP Dt - 'DAY-DPPEARNEST' Days                    
A05201        MOVE WS-DAY-DPP-ERNST          TO WS-ADJ-DAY              
A05201        PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
A05201        MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS-DELINQ      
A05201     END-IF.                                                      
A05201                                                                  
A05201 5710-EXIT.                                                       
A05201     EXIT.                                                        
A05201                                                                  
A05201******************************************************************        
A05201* 5720-COMMON-PSNC-OPTION-VAL                                    *        
A05201******************************************************************        
A05201                                                                  
A05201 5720-COMMON-PSNC-OPTION-VAL.                                     
A05201                                                                  
A05201     MOVE 'NDPP'                       TO S-DPP-TYPE.             
A05201     MOVE 'N'                          TO S-OPTN-EDIT-FLAG.       
A05201     COMPUTE S-PLS-PAY-AMT   ROUNDED = S-UNDEFER-RECV-AMT +       
A05201                                       S-1ST-ERNST-AMT.           
A05201     MOVE 0                            TO S-DEP-TOT-AMT           
A05201                                          S-DEP-AMT-MO-PYMT.      
A05201* Pymt Start Dt = 'Next Bill Dt'                                          
A05201     MOVE WS-NEXT-BILL-DT              TO S-PYMT-STRT-DT          
A05201                                          WS-SEARCH-DATE          
P0726A                                          S-DNP-DATE.             
A05201*                                                                         
A05201     IF S-1ST-ERNST-AMT > 0                                       
A05201* Ernst Amt Last Dt = Next DNP Dt - 1 Day                                 
A05201        MOVE 1                         TO WS-ADJ-DAY              
A05201        PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
A05201        MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS1            
A05201                                          S-ERNST-PYMT-LST-DT     
A05201* Notice Mail Dt = Next DNP Dt - 'DAY-DPPEARNEST' Days                    
A05201        MOVE WS-DAY-DPP-ERNST          TO WS-ADJ-DAY              
A05201        PERFORM 5200-GET-BUSINESS-DAY  THRU 5200-EXIT             
A05201        MOVE WS-ADJUSTED-DT            TO S-DNP-MINUS-DELINQ      
A05201     END-IF.                                                      
A05201                                                                  
A05201 5720-EXIT.                                                       
A05201     EXIT.                                                        
A05201                                                                  
      ******************************************************************        
      * 5900-NEXT-BILL-DATE                                            *        
      ******************************************************************        
      *                                                                 11670000
           EXEC SQL                                                             
              INCLUDE CPD00309                                                  
           END-EXEC.                                                            
      *                                                                 11670000
      ******************************************************************27520000
      * 7000-GET-CUR-DATE                                              *27530000
      ******************************************************************27560000
      *                                                                 27590000
       7000-GET-CUR-DATE.                                               
      *                                                                 27590000
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     27600000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       27610000
MFA-TR*    END-EXEC                                                     27720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27730000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 27870000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27870000
      ******************************************************************        
      * 7010-GET-NEXT-WORK-DAY                                         *        
      ******************************************************************        
      *                                                                         
       7010-GET-NEXT-WORK-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
                 SELECT                                                 
                        DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )       
                   INTO                                                 
                        :WS-WORK-DATE                                   
                   FROM                                                 
                        CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                     
                  WHERE                                                 
                        CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) 
                        - (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE
              ) ) )) / 7 * 7) BETWEEN 1 AND 5
                    AND NOT EXISTS                                      
                        (                                               
                         SELECT                                         
                                HOLIDAY_DT                              
                           FROM                                         
                                CSS_HOLIDAY WITH(READUNCOMMITTED)               
                           WHERE                                        
                                 COMPANY_NO = :J8-COMPANY-NO            
                             AND HOLIDAY_DT = DATEADD( DAY, 
                                                          :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )     
                                                                        
                        )                                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT                                                         
MFA-TR*                 DATE(:WS-CURRENT-DATE) + :WS-ADJ-DAY DAYS               
MFA-TR*            INTO                                                         
MFA-TR*                 :WS-WORK-DATE                                           
MFA-TR*            FROM                                                         
MFA-TR*                 SYSIBM.SYSDUMMY1                                        
MFA-TR*           WHERE                                                         
MFA-TR*                 DAYS(DATE(:WS-CURRENT-DATE) + :WS-ADJ-DAY DAYS)         
MFA-TR*                 - (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                  
MFA-TR*                    + :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5        
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*                 (                                                       
MFA-TR*                  SELECT                                                 
MFA-TR*                         HOLIDAY_DT                                      
MFA-TR*                    FROM                                                 
MFA-TR*                         CSS_HOLIDAY                                     
MFA-TR*                    WHERE                                                
MFA-TR*                          COMPANY_NO = :J8-COMPANY-NO                    
MFA-TR*                      AND HOLIDAY_DT = DATE(:WS-CURRENT-DATE) +          
MFA-TR*                                            :WS-ADJ-DAY DAYS             
MFA-TR*                                                                         
MFA-TR*                 )                                                       
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACTION-DATE'         TO TABLE-ELEMENT-1             
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-1           
              MOVE 'ADJ-BY'              TO TABLE-ELEMENT-2             
              MOVE WS-ADJ-DAY            TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-GET-PREV-WORK-DAY.                                        *        
      ******************************************************************        
      *                                                                         
       7020-GET-PREV-WORK-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )        
                  INTO                                                  
                       :WS-WORK-DATE                                    
                  FROM                                                  
                       CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                      
                 WHERE                                                  
                       CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))  
                                                                        
                       - (CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )
               )) / 7 * 7) BETWEEN 1 AND 5 
                   AND NOT EXISTS                                       
                        (                                               
                         SELECT                                         
                                HOLIDAY_DT                              
                           FROM                                         
                                CSS_HOLIDAY WITH(READUNCOMMITTED)               
                          WHERE                                         
                                COMPANY_NO = :J8-COMPANY-NO             
                            AND HOLIDAY_DT = DATEADD( DAY, -:WS-ADJ-DAY
              , IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )      
                        )                                               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS                
MFA-TR*           INTO                                                          
MFA-TR*                :WS-WORK-DATE                                            
MFA-TR*           FROM                                                          
MFA-TR*                SYSIBM.SYSDUMMY1                                         
MFA-TR*          WHERE                                                          
MFA-TR*                DAYS(DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS)          
MFA-TR*                                                                         
MFA-TR*                - (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                   
MFA-TR*                   - :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5         
MFA-TR*            AND NOT EXISTS                                               
MFA-TR*                 (                                                       
MFA-TR*                  SELECT                                                 
MFA-TR*                         HOLIDAY_DT                                      
MFA-TR*                    FROM                                                 
MFA-TR*                         CSS_HOLIDAY                                     
MFA-TR*                   WHERE                                                 
MFA-TR*                         COMPANY_NO = :J8-COMPANY-NO                     
MFA-TR*                     AND HOLIDAY_DT = DATE(:WS-CURRENT-DATE) -           
MFA-TR*                                           :WS-ADJ-DAY DAYS              
MFA-TR*                 )                                                       
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACTION-DATE'         TO TABLE-ELEMENT-1             
              MOVE WS-CURRENT-DATE       TO HOSTVAR-ELEMENT-1           
              MOVE 'ADJ-BY'              TO TABLE-ELEMENT-2             
              MOVE WS-ADJ-DAY            TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-GET-END-DATE.                                             *        
      ******************************************************************        
      *                                                                         
       7030-GET-END-DATE.                                               
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, :WS-NO-OF-DAYS, IIF(TRY_CONVERT(DATE, 
                                                       :WS-PYMT-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-PYMT-STRT-DT
              ) <> 0) OR (LEN(:WS-PYMT-STRT-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-PYMT-STRT-DT
              ), CONVERT(DATE, :WS-PYMT-STRT-DT) ) )
            INTO
              :WS-PYMT-END-DT               
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-PYMT-END-DT = DATE(:WS-PYMT-STRT-DT) +                  
MFA-TR*                               :WS-NO-OF-DAYS DAYS                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************21260000
      * 7040-GET-MAX-ITEM-ID                                           *21270000
      ******************************************************************21350000
      *                                                                 02338214
       7040-GET-MAX-ITEM-ID.                                            
      *                                                                 02338214
           EXEC SQL                                                     
              SELECT MAX(DA.DFA_ITEM_ID)                                
                INTO :WS-MAX-AGREEMENT-NO :WS-NULL-ITEM-IND              
                FROM CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                      
               WHERE DA.ACCOUNT_NO        = :DA-ACCOUNT-NO              
                 AND DA.PYMT_PRIORITY_LVL = 90                          
                 AND DA.CODE_DFA_TYPE     = 'B'                         
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02338214
MFA-TR*       SELECT MAX(DA.DFA_ITEM_ID)                                02338214
MFA-TR*         INTO :WS-MAX-AGREEMENT-NO:WS-NULL-ITEM-IND                    14
MFA-TR*         FROM CSS_DFA_ACCT DA                                    02338214
MFA-TR*        WHERE DA.ACCOUNT_NO        = :DA-ACCOUNT-NO              02338214
MFA-TR*          AND DA.PYMT_PRIORITY_LVL = 90                          02338214
MFA-TR*          AND DA.CODE_DFA_TYPE     = 'B'                         02338214
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                     02338214

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 02338214
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-1.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-MAX-AGREEMENT-NO = 0                                
                 MOVE 30000000                 TO WS-MAX-AGREEMENT-NO   
              END-IF                                                    
              COMPUTE S-AGREEMENT-NO = WS-MAX-AGREEMENT-NO + 1          
           ELSE                                                         
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE '7040'                    TO ACTIVE-PARAGRAPH      
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE SPACES                    TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                MOVE 'CSS_DFA_ACCT'            TO TABLE-1               
                MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1       
                MOVE DA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
                PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT
           END-IF.          
      *                                                                 02354600
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02354600
      ******************************************************************        
      * 7050-GET-DELINQ-VALUE                                          *        
      ******************************************************************        
      *                                                                         
       7050-SELECT-DELINQ.                                              
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       C8.DELINQ_VALUE                                  
                  INTO                                                  
                       :C8-DELINQ-VALUE                                 
                  FROM                                                  
                       CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                       C8.COMPANY_NO = :C8-COMPANY-NO                   
                   AND C8.DELINQ_CD  = :C8-DELINQ-CD                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                C8.DELINQ_VALUE                                          
MFA-TR*           INTO                                                          
MFA-TR*                :C8-DELINQ-VALUE                                         
MFA-TR*           FROM                                                          
MFA-TR*                CSS_DELINQUENCY C8                                       
MFA-TR*          WHERE                                                          
MFA-TR*                C8.COMPANY_NO = :C8-COMPANY-NO                           
MFA-TR*            AND C8.DELINQ_CD  = :C8-DELINQ-CD                            
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'COMPANY_NO '         TO TABLE-ELEMENT-1             
              MOVE 'DELINQ_CD '          TO TABLE-ELEMENT-2             
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7060-GET-ACCT-DET.                                             *        
      ******************************************************************        
      *                                                                         
       7060-GET-ACCT-DET.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     AT.BILL_CYCLE                                      
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.COMPANY_NO                                      
A03118              ,AT.LOCAL_OFFICE                                    
A03118              ,AT.CODES_DATA_PRESENT                              
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                INTO                                                    
                     :AT-BILL-CYCLE                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-COMPANY-NO                                     
A03118              ,:AT-LOCAL-OFFICE                                   
A03118              ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-LAST-UPDATE-TS                                 
                FROM                                                    
                     CSS_ACCOUNT AT                                     
               WHERE                                                    
                     AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              AT.BILL_CYCLE                                              
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.LAST_UPDATE_TS                                          
MFA-TR*         INTO                                                            
MFA-TR*              :AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-LAST-UPDATE-TS                                         
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE                                                            
MFA-TR*              AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7070-SEL-REG-PROFILE                                           *        
      ******************************************************************        
      *                                                                         
       7070-SEL-REG-PROFILE.                                            
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                       LR.REG_GROUP_CD                                  
                  INTO                                                  
                       :LR-REG-GROUP-CD                                 
                  FROM                                                  
                       CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                       LR.ACCOUNT_NO = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                LR.REG_GROUP_CD                                          
MFA-TR*           INTO                                                          
MFA-TR*                :LR-REG-GROUP-CD                                         
MFA-TR*           FROM                                                          
MFA-TR*                CSS_REG_PROFILE LR                                       
MFA-TR*          WHERE                                                          
MFA-TR*                LR.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-1.      
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'Y'                   TO WS-REG-GROUP          
               WHEN NOT-FOUND                                           
                    MOVE 'N'                   TO WS-REG-GROUP          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7070'                TO ACTIVE-PARAGRAPH      
                    MOVE 'SELECT'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_REG_PROFILE'     TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                 41260000
      ******************************************************************        
      * 7080-GET-UNPAID-DEP                                            *        
      ******************************************************************        
      *                                                                         
       7080-GET-UNPAID-DEP.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                      COALESCE(SUM(AC.AMT_TRAN_BALANCE),0)              
A03118               ,COALESCE(SUM(AC.AMT_AR_DAY_00 + AMT_AR_DAY_30 +   
A03118                        AC.AMT_AR_DAY_60 + AMT_AR_DAY_90 ), 0)    
                 INTO                                                   
                      :WS-UNPAID-DEP-AMT                                
A03118               ,:WS-DEPOSIT-AMOUNT                                
                 FROM                                                   
                      CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                WHERE                                                   
                      AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
                  AND AC.ITEM_ID           > 0                          
                  AND AC.PYMT_PRIORITY_LVL = 80                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               COALESCE(SUM(AC.AMT_TRAN_BALANCE),0)                      
MFA-TR*              ,COALESCE(SUM(AC.AMT_AR_DAY_00 + AMT_AR_DAY_30 +           
MFA-TR*                       AC.AMT_AR_DAY_60 + AMT_AR_DAY_90 ), 0)            
MFA-TR*          INTO                                                           
MFA-TR*               :WS-UNPAID-DEP-AMT                                        
MFA-TR*              ,:WS-DEPOSIT-AMOUNT                                        
MFA-TR*          FROM                                                           
MFA-TR*               CSS_AR_CNTL AC                                            
MFA-TR*         WHERE                                                           
MFA-TR*               AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                     
MFA-TR*           AND AC.ITEM_ID           > 0                                  
MFA-TR*           AND AC.PYMT_PRIORITY_LVL = 80                                 
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************21260000
      * 7090-SEL-RESP-AREA-ID                                          *21270000
      ******************************************************************21350000
      *                                                                 21360000
       7090-SEL-RESP-AREA-ID.                                           
      *                                                                 21400000
           EXEC SQL                                                     
              SELECT                                                    
                     PF.RESP_AREA_ID                                    
                INTO                                                    
                     :PF-RESP-AREA-ID                                   
                FROM                                                    
                     CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE                                                    
                     PF.USER_ID = :PF-USER-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21410000
MFA-TR*       SELECT                                                    21420000
MFA-TR*              PF.RESP_AREA_ID                                            
MFA-TR*         INTO                                                    21430000
MFA-TR*              :PF-RESP-AREA-ID                                           
MFA-TR*         FROM                                                    21440000
MFA-TR*              CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE                                                    21450000
MFA-TR*              PF.USER_ID = :PF-USER-ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                    21460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-1.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '7090'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SPACES                       TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
              MOVE 'CSS_USER_PROFILE'           TO TABLE-1              
              MOVE 'USER_ID'                    TO TABLE-ELEMENT-1      
              MOVE PF-USER-ID                   TO HOSTVAR-ELEMENT-1    
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21640000
      ******************************************************************        
      * 7100-GET-SEAS-BILLING-DATES.                                            
      ******************************************************************21350000
      *                                                                         
       7100-GET-SEAS-BILL-DT.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DATE_EXTRACT                                     
                 INTO                                                   
                      :BN-DATE-EXTRACT                                  
                 FROM                                                   
                      CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
                WHERE                                                   
                      BILL_CYCLE    = :BN-BILL-CYCLE                    
                  AND DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                  
                  AND REVENUE_MONTH > :BN-REVENUE-MONTH                 
                ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*                DATE_EXTRACT                                             
MFA-TR*          INTO                                                           
MFA-TR*               :BN-DATE-EXTRACT                                          
MFA-TR*          FROM                                                           
MFA-TR*               CSS_BILL_WINDOW                                           
MFA-TR*         WHERE                                                           
MFA-TR*               BILL_CYCLE    = :BN-BILL-CYCLE                            
MFA-TR*           AND DATE_EXTRACT >= :BN-DATE-EXTRACT                          
MFA-TR*           AND REVENUE_MONTH > :BN-REVENUE-MONTH                         
MFA-TR*         ORDER BY DATE_EXTRACT, REVENUE_MONTH ASC                        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE,      
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7925'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
              MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-2           
              MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-3             
              MOVE BN-DATE-EXTRACT       TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21640000
      ******************************************************************        
      * 7300-OPEN-AR-CURSOR                                            *        
      ******************************************************************        
      *                                                                         
       7300-OPEN-AR-CURSOR.                                             
      *                                                                         
           EXEC SQL                                                     
                OPEN AR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7310-FETCH-AR-CURSOR                                           *        
      ******************************************************************        
      *                                                                         
       7310-FETCH-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH AR_CURSOR                                           
               INTO                                                     
                    :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-UNUSED-CR                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-PYMT-PRIORITY-LVL                               
                   ,:AC-ITEM-ID                                         
                   ,:AC-LAST-UPDATE-TS                                  
                   ,:L5-AR-TYPE-LONG-DESC                               
                   ,:L5-AR-TYPE-SHORT-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-2.      
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-2       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '7310'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSS_AR_CNTL'         TO TABLE-1               
                    MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1       
                    MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7320-CLOSE-AR-CURSOR                                           *        
      ******************************************************************        
      *                                                                         
       7320-CLOSE-AR-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
                CLOSE AR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7320'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03118*****************************************************************         
A03118* SET THE GAS ONLY LOCAL OFFICE FLAG BY CHECKING THE            *         
A03118* CSS_LOCAL_OFFICE TABLE FOR THE LOCAL OFFICE OF THE ACCOUNT    *         
A03118* HAVING A DIVISION_NO > SPACES AND A DISTRICT_NO THAT IS NULL  *         
A03118*****************************************************************         
A03118*                                                                         
A03118 7400-SEL-GAS-ONLY-LOC-OFF.                                       
A03118*                                                                         
A03118     EXEC SQL                                                     
A03118       SELECT 'Y'                                                 
A03118       INTO :WS-GAS-ONLY-OFFICE                                   
A03118       FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                        
A03118        WHERE COMPANY_NO   = :B1-COMPANY-NO                       
A03118        AND   LOCAL_OFFICE = :B1-LOCAL-OFFICE                     
A03118        AND   DIVISION_NO  > ' '                                  
A03118        AND   DISTRICT_NO  = 'GAS'                                
A03118                                                           
A03118                                                      
A03118     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*      INTO :WS-GAS-ONLY-OFFICE                                           
MFA-TR*      FROM CSS_LOCAL_OFFICE                                              
MFA-TR*       WHERE COMPANY_NO   = :B1-COMPANY-NO                               
MFA-TR*       AND   LOCAL_OFFICE = :B1-LOCAL-OFFICE                             
MFA-TR*       AND   DIVISION_NO  > ' '                                          
MFA-TR*       AND   DISTRICT_NO  = 'GAS'                                        
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03118*                                                                         
A03118     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A03118                                      S-RETURN-CODE-1.            
A03118*                                                                         
A03118     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A03118         CONTINUE                                                 
A03118     ELSE                                                         
A03118        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A03118        MOVE '7400'                TO ACTIVE-PARAGRAPH            
A03118        MOVE 'SELECT'              TO ABEND-FUNCTION              
A03118        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A03118                                      ABEND-TABLES                
A03118        MOVE 'CSS_LOCAL_OFFICE'    TO TABLE-1                     
A03118        MOVE 'LOCAL-OFFICE'        TO TABLE-ELEMENT-1             
A03118        MOVE AT-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1           
A03118        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A03118     END-IF.                                                      
A03118*                                                                         
A03118 7400-EXIT.                                                       
A03118     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR04367_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04367_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-1.      
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES                TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-1       
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE SQLCODE               TO ABEND-SQLCODE         
                    MOVE SQLSTATE              TO ABEND-SQLSTATE        
                    MOVE '8000A'               TO ACTIVE-PARAGRAPH      
                    MOVE 'DELETE'              TO ABEND-FUNCTION        
                    MOVE SPACES                TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                    MOVE 'CSR04367_R1'         TO TABLE-1               
                    MOVE SPACES                TO TABLE-ELEMENT-1       
                    MOVE SPACES                TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000B-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000B-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04367_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04367_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04367_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000C-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000C-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04367_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04367_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04367_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-GTT-R1.                                            *        
      ******************************************************************        
      *                                                                         
       8010-INSERT-GTT-R1.                                              
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO #CSR04367_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,DPP_TYPE                                            
                   ,OPTION_SEQ_NO                                       
                   ,CONTRACT_TOT_AMT                                    
                   ,S_1ST_ERNST_AMT                                     
                   ,S_2ND_ERNST_AMT                                     
                   ,ERNST_PYMT_LST_DT                                   
                   ,NO_SCHED_PYMTS                                      
                   ,DPP_AMT_MO_PYMT                                     
                   ,DEP_TOT_AMT                                         
                   ,DEP_AMT_MO_PYMT                                     
                   ,PYMT_STRT_DT                                        
                   ,PYMT_END_DT                                         
                   ,DNP_DATE                                            
                   ,DNP_MINUS1                                          
                   ,DNP_MINUS_DELINQ                                    
                   ,UNDEFER_RECV_AMT                                    
                   ,UNPAID_DEP_AMT                                      
                   ,PLS_PAY_AMT                                         
                   ,AGREEMENT_NO                                        
                   ,DFA_TYPE                                            
                   ,RESP_AREA_ID                                        
                   ,AT_LAST_UPDATE_TS                                   
                   ,OPTN_EDIT_FLAG                                      
A03301             ,CONT_BAL_AT_SETUP                                   
A03301             ,DPP_AMT_MO_PYMT_LAST                                
A03301             ,DEP_AMT_MO_PYMT_LAST                                
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-1                                    
                   ,:S-DPP-TYPE                                         
                   ,:S-OPTION-SEQ-NO                                    
                   ,:S-CONTRACT-TOT-AMT                                 
                   ,:S-1ST-ERNST-AMT                                    
                   ,:S-2ND-ERNST-AMT                                    
                   ,:S-ERNST-PYMT-LST-DT                                
                   ,:S-NO-SCHED-PYMTS                                   
                   ,:S-DPP-AMT-MO-PYMT                                  
                   ,:S-DEP-TOT-AMT                                      
                   ,:S-DEP-AMT-MO-PYMT                                  
                   ,:S-PYMT-STRT-DT                                     
                   ,:S-PYMT-END-DT                                      
                   ,:S-DNP-DATE                                         
                   ,:S-DNP-MINUS1                                       
                   ,:S-DNP-MINUS-DELINQ                                 
                   ,:S-UNDEFER-RECV-AMT                                 
                   ,:S-UNPAID-DEP-AMT                                   
                   ,:S-PLS-PAY-AMT                                      
                   ,:S-AGREEMENT-NO                                     
                   ,:S-DFA-TYPE                                         
                   ,:S-RESP-AREA-ID                                     
                   ,:S-AT-LAST-UPDATE-TS                                
                   ,:S-OPTN-EDIT-FLAG                                   
A03301             ,:S-CONT-BAL-AT-SETUP                                
A03301             ,:S-DPP-AMT-MO-PYMT-LAST                             
A03301             ,:S-DEP-AMT-MO-PYMT-LAST                             
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04367_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,DPP_TYPE                                                    
MFA-TR*            ,OPTION_SEQ_NO                                               
MFA-TR*            ,CONTRACT_TOT_AMT                                            
MFA-TR*            ,S_1ST_ERNST_AMT                                             
MFA-TR*            ,S_2ND_ERNST_AMT                                             
MFA-TR*            ,ERNST_PYMT_LST_DT                                           
MFA-TR*            ,NO_SCHED_PYMTS                                              
MFA-TR*            ,DPP_AMT_MO_PYMT                                             
MFA-TR*            ,DEP_TOT_AMT                                                 
MFA-TR*            ,DEP_AMT_MO_PYMT                                             
MFA-TR*            ,PYMT_STRT_DT                                                
MFA-TR*            ,PYMT_END_DT                                                 
MFA-TR*            ,DNP_DATE                                                    
MFA-TR*            ,DNP_MINUS1                                                  
MFA-TR*            ,DNP_MINUS_DELINQ                                            
MFA-TR*            ,UNDEFER_RECV_AMT                                            
MFA-TR*            ,UNPAID_DEP_AMT                                              
MFA-TR*            ,PLS_PAY_AMT                                                 
MFA-TR*            ,AGREEMENT_NO                                                
MFA-TR*            ,DFA_TYPE                                                    
MFA-TR*            ,RESP_AREA_ID                                                
MFA-TR*            ,AT_LAST_UPDATE_TS                                           
MFA-TR*            ,OPTN_EDIT_FLAG                                              
MFA-TR*            ,CONT_BAL_AT_SETUP                                           
MFA-TR*            ,DPP_AMT_MO_PYMT_LAST                                        
MFA-TR*            ,DEP_AMT_MO_PYMT_LAST                                        
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-1                                            
MFA-TR*            ,:S-DPP-TYPE                                                 
MFA-TR*            ,:S-OPTION-SEQ-NO                                            
MFA-TR*            ,:S-CONTRACT-TOT-AMT                                         
MFA-TR*            ,:S-1ST-ERNST-AMT                                            
MFA-TR*            ,:S-2ND-ERNST-AMT                                            
MFA-TR*            ,:S-ERNST-PYMT-LST-DT                                        
MFA-TR*            ,:S-NO-SCHED-PYMTS                                           
MFA-TR*            ,:S-DPP-AMT-MO-PYMT                                          
MFA-TR*            ,:S-DEP-TOT-AMT                                              
MFA-TR*            ,:S-DEP-AMT-MO-PYMT                                          
MFA-TR*            ,:S-PYMT-STRT-DT                                             
MFA-TR*            ,:S-PYMT-END-DT                                              
MFA-TR*            ,:S-DNP-DATE                                                 
MFA-TR*            ,:S-DNP-MINUS1                                               
MFA-TR*            ,:S-DNP-MINUS-DELINQ                                         
MFA-TR*            ,:S-UNDEFER-RECV-AMT                                         
MFA-TR*            ,:S-UNPAID-DEP-AMT                                           
MFA-TR*            ,:S-PLS-PAY-AMT                                              
MFA-TR*            ,:S-AGREEMENT-NO                                             
MFA-TR*            ,:S-DFA-TYPE                                                 
MFA-TR*            ,:S-RESP-AREA-ID                                             
MFA-TR*            ,:S-AT-LAST-UPDATE-TS                                        
MFA-TR*            ,:S-OPTN-EDIT-FLAG                                           
MFA-TR*            ,:S-CONT-BAL-AT-SETUP                                        
MFA-TR*            ,:S-DPP-AMT-MO-PYMT-LAST                                     
MFA-TR*            ,:S-DEP-AMT-MO-PYMT-LAST                                     
MFA-TR*           )                                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-OPTION-CNT              
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04367_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8020-INSERT-GTT-R2.                                            *        
      ******************************************************************        
      *                                                                         
       8020-INSERT-GTT-R2.                                              
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO #CSR04367_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,AR_TYPE_DEFR                                        
                   ,AR_TYPE_DEFR_SHORT                                  
                   ,PYMT_PRTY_LVL_DEFR                                  
                   ,RECV_AMT_DEFR                                       
                   ,AC_LAST_UPD_TS_DEFR                                 
                   ,ITEM_ID                                             
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-2                                    
                   ,:S-AR-TYPE-DEFR                                     
                   ,:S-AR-TYPE-DEFR-SHORT                               
                   ,:S-PYMT-PRTY-LVL-DEFR                               
                   ,:S-RECV-AMT-DEFR                                    
                   ,:S-AC-LAST-UPD-TS-DEFR                              
                   ,:S-ITEM-ID                                          
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04367_R2                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,AR_TYPE_DEFR                                                
MFA-TR*            ,AR_TYPE_DEFR_SHORT                                          
MFA-TR*            ,PYMT_PRTY_LVL_DEFR                                          
MFA-TR*            ,RECV_AMT_DEFR                                               
MFA-TR*            ,AC_LAST_UPD_TS_DEFR                                         
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-2                                            
MFA-TR*            ,:S-AR-TYPE-DEFR                                             
MFA-TR*            ,:S-AR-TYPE-DEFR-SHORT                                       
MFA-TR*            ,:S-PYMT-PRTY-LVL-DEFR                                       
MFA-TR*            ,:S-RECV-AMT-DEFR                                            
MFA-TR*            ,:S-AC-LAST-UPD-TS-DEFR                                      
MFA-TR*            ,:S-ITEM-ID                                                  
MFA-TR*           )                                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-RECVBLE-DEFR-CNT        
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04367_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8030-INSERT-GTT-R3.                                            *        
      ******************************************************************        
      *                                                                         
       8030-INSERT-GTT-R3.                                              
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO #CSR04367_R3                          
                  (                                                     
                    RETURN_CODE                                         
                   ,AR_TYPE_UNDEFR                                      
                   ,PYMT_PRTY_LVL_UNDEFR                                
                   ,RECV_AMT_UNDEFR                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-3                                    
                   ,:S-AR-TYPE-UNDEFR                                   
                   ,:S-PYMT-PRTY-LVL-UNDEFR                             
                   ,:S-RECV-AMT-UNDEFR                                  
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04367_R3                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,AR_TYPE_UNDEFR                                              
MFA-TR*            ,PYMT_PRTY_LVL_UNDEFR                                        
MFA-TR*            ,RECV_AMT_UNDEFR                                             
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE-3                                            
MFA-TR*            ,:S-AR-TYPE-UNDEFR                                           
MFA-TR*            ,:S-PYMT-PRTY-LVL-UNDEFR                                     
MFA-TR*            ,:S-RECV-AMT-UNDEFR                                          
MFA-TR*           )                                                             
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-RECVBLE-UNDEFR-CNT      
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04367_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8030-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8800-CHECK-RESULTS.                                            *        
      ******************************************************************        
      *                                                                         
       8800-CHECK-RESULTS.                                              
      *                                                                         
           IF WS-OPTION-CNT = 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                       TO S-RETURN-CODE-1         
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF WS-RECVBLE-DEFR-CNT = 0                                   
              INITIALIZE GTT-RETURN-FIELDS-2                            
                 MOVE 100                    TO S-RETURN-CODE-2         
                 PERFORM 8020-INSERT-GTT-R2  THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
           IF WS-RECVBLE-UNDEFR-CNT = 0                                 
              INITIALIZE GTT-RETURN-FIELDS-3                            
                 MOVE 100                    TO S-RETURN-CODE-3         
                 PERFORM 8030-INSERT-GTT-R3  THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
                OPEN C1                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04367_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 00300000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04367_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 00300000
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04367_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-OPTIONS                                          
                    MOVE S-RETURN-CODE-1 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
               WHEN WS-RECVBLE-DEFR                                     
                    MOVE S-RETURN-CODE-2 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
               WHEN WS-RECVBLE-UNDEFR                                   
                    MOVE S-RETURN-CODE-3 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
           END-EVALUATE.                                                
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
           PERFORM 0100B-DECLARE-GTT     THRU 0100B-EXIT.               
           PERFORM 0100C-DECLARE-GTT     THRU 0100C-EXIT.               
           MOVE WS-RETURN-CODE-1         TO S-RETURN-CODE-1.            
           MOVE WS-RETURN-CODE-2         TO S-RETURN-CODE-2.            
           MOVE WS-RETURN-CODE-3         TO S-RETURN-CODE-3.            
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
           PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT.                
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
      *                                                                         
       9700-PROCESS-ABEND.                                              
      *                                                                         
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                         
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM.                                      *                
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                 00380000
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '9999-END-PROGRAM'       TO ABEND-FUNCTION           
              MOVE 'PROGRAMMER LOGIC'       TO TABLE-1                  
              MOVE 'FAILED TO SEND'         TO TABLE-ELEMENT-1          
              MOVE 'RESULT SET'             TO HOSTVAR-ELEMENT-1        
              MOVE -1                       TO WS-ACTIVE-RETURN-CODE    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8800-CHECK-RESULTS    THRU 8800-EXIT              
              PERFORM 8900-SEND-DONE        THRU 8900-EXIT              
           END-IF.                                                      
      *                                                                 00391000
           
MSQ016        GOBACK.                                                    
      *                                                                 00391000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      **********************End Of Program *****************************        
      *                                                                *        
