       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04366.                                         
COB303 DATE-WRITTEN.  JUNE 04, 2010.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE GETS THE PAYMENT ARRANGEMENT RULES(STA AND DPP)*        
      *  FOR BUSINESS PROCESS ADVISOR SCREENS(BPA).                    *        
      *  RULE DESCRIPTIONS ARE IN CSR04369.                                     
      *  -----------                                                            
      *  RULE-RESULT                                                            
      *  -----------                                                            
      *  R - RED    (HARD STOP)                                                 
      *  Y - YELLOW (WARNING)                                                   
      *  G - GREEN  (INFORMATIONAL)                                             
      *  --------------------------------------------------------------         
      *  THIS PROCEDURE IS CALLED FROM THE FOLLOWING BUSINESS OPERATION*        
      *  1. RequGetDppOptionsBusinessOp.                               *        
      *  2. RequGetStaOptionsBusinessOp.                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/04/10  SS42021    PROCEDURE ORIGINALLY CODED.              *        
A03300*  04/05/11  RC41079    ADDED RULES FOR FINAL BILLED ACCOUNTS    *        
A03300*                       (STA035)- SHOW NON-UTIL CHARGES TO BE    *        
A03300*                       PAID FOR STA ON FINAL BILL ACCOUNTS.     *        
A03301*  05/24/11  AA97148    1.MODIFIED BUS RULE RESULT FOR STA027.   *        
A03301*                         FOR SEB ONLY, STA027 WILL NOT DISPLAY. *        
A03301*                       2.MOVE SPACES TO THE BUS RULE RESULT AS  *        
A03301*                         IT IS NOT REQUIRED.                    *        
A03300*                       3.CSR CHANGES TO IN-ROUTE AND ON-SITE DNP*        
A03300*                         FOR PAYMENT ARRANGEMENTS.              *        
A03301*                       4.SKIP CHECK FOR RULE STA002 ON SEB FINAL*        
A03301*                         BILL ACCOUNTS.                         *        
P00453*                       5.ADDED SEB DEREGULATED RULES FOR        *        
P00453*                         PRE-PAY-PLAN ACCOUNTS (STA/DPP).       *        
A03300*                       6.ADDED SEPARATE MESSAGE BASED ON        *        
A03300*                         CREDIT GROUP FOR SEB.                  *        
A03300*                       7.AS STA004, STA025 & STA027 HAS THE SAME*        
A03300*                         MESSAGE WE NEED TO MAKE SURE IT IS     *        
A03300*                         APPEARING ONLY ONCE(SEB ONLY).         *        
P00453* 06/09/2011 SS42021    1.FOR SEB DEREGULATED BALANCE            *        
P00453*                         PRE-PAY-PLAN ACCOUNTS, REMOVED CREDIT  *        
P00453*                         GROUP MESSAGES STA002 AND DPP002       *        
P00471* 06/14/2011 AA97148    ADDED ADDITIONAL RESCHEDULED DNP TYPES   *        
P00471*                       'T' AND 'W' AS EXCEPTIONAL DNP TYPES.    *        
A03301* 07/05/2011 AA97148    1.SEASONAL DPP Changes.                  *        
A03301*                       2.MODIFIED PARM-TYPE TO 4 CHAR LEN TO    *        
A03301*                         ACCEPT NDPP, SDPP AND STA.             *        
P00471* 08/04/2011 MJ13662    IF MESSAGE STA026 (NO STA DUE TO EX CREDIT        
P00471*                       ACTION) IS SET DO NOT SET MESSAGE STA033 *        
P00471*                       (2ND NOTICE DATES).                      *        
TASK01* 08/10/2011 VV94890    CHANGED DPP COMPLIANCE RULE LOGIC FOR    *        
TASK01*  ***P00471***         DPP014 & STA018 MESSAGES 4 ALL COMPANIES.*        
A03118*  01/16/12  SP95538    FOR SCE&G, ADDED NEW WARNING MSG DPP023, *        
A03118*                       ACCT HAS A BILLED DEPOSIT IN THE BILLED  *        
A03118*                       BALANCE THAT IS > DNP LIMIT.             *        
A03898*  02/22/12  SV95326    DISABLE STA ON BILL IMMEDIATE DEPOSIT.   *        
A03898*            ACT001                                              *        
P00594*  03/04/13  AA97148    CHANGE DAYS COMPUTATION TO INCLUDE DAYS()*        
ACT017*  04/12/13  AA97148    APPL3118 - IF THE ACCOUNT HAS 60 DAYS    *        
ACT017*                       ARREARS THEN WE NEED TO PASS WARNING     *        
ACT017*                       MESSAGE INSTEAD HARD STOP.               *        
ACT158*  09/30/13  MC95456    STA IS NOT NOT ALLOWED FOR BILL IMMEDIATE*        
ACT158*  APPL4527-ACT158      DEPOSITS                                 *        
A04527*  11/14/13  MS93554  1.ADDED A CHANGES TO ENABLE THE SEASONAL   *        
      *                       DPP LINK WHEN DPP SEASONAL FLAG IS 'Y'.  *        
      *                       ERROR CODE IS DPP025 WITH RUL RESULT 'Y' *        
      *                     2.COMMNTD ALL THE DUPLICATE RULES FOR SDPP *        
PRDFIX*  03/17/14  AA97148    UNCOMMENT SEASONAL DPP BUSINESS RULES.   *        
P00726*  12/16/13  AA97148    CREDIT ARRANGEMENTS RELEASE 2 CHANGES -  *        
P00726*                       POPULATE SEASONAL DPP ALONG WITH NORMAL  *        
P00726*                       DPP OPTIONS WHEN PARM TYPE AS 'DPP'.     *        
A04880*  06/05/14 SK42147     BILL-IMMED DEP MESSAGE IS APPLICABLE FOR *        
A04880*                       CSR-ONLY.                                *        
P0726A*  06/06/14  AA97148    CREDIT ARRANGEMENTS RELEASE 2.1 CHANGES -*        
P0726A*                       ADDED NEW WARNING MESSAGES STA040 AND    *        
P0726A*                       SDPP23.                                  *        
P0726B*  08/06/14  GOKUL      UNCOMMENT SEASONAL DPP VALIDATIONS      -*        
P0726C*  08/21/14  AA97148    REMOVE ACTIVE STA CHECK TO FIX DPP SETUP *        
P0726C*                       LIMIT WHEN REPLACE ACTIVE STA WITH DPP.  *        
P0726D*  10/02/14  GOKUL      MOVE DPP RULES TO BUSINESS RULES TABLES. *        
P0726E*  10/28/14  AA97148    RELEASE 4.1 changes - Populate active    *        
P0726E*                       credit action flag.                      *        
P0726F*  01/22/15  AA97148    RELEASE 5.0 changes - Added verbal notifi*        
P0726F*                       1.Added verbal notification message about*        
P0726F*                         the CUT.                               *        
P0726F*                       2.Repalce CRDARNG216 business rule with  *        
P0726F*                         CRDARNG035 to avoid Unpaid deposit     *        
P0726F*                         duplicate message.(CSR ONLY)           *        
P0726G*  04/21/15  AA97148    Credit Arrangements - Release 5.1 changes*        
P0726G*                       1.New plan level message has been added  *        
P0726G*                         for Unpaid deposit validation.         *        
P0726G*                       2.Removed DNP limit check validation for *        
P0726G*                         SCE&G Company to sync with PSNC.       *        
P0726G*                       3.Deleted unused DCLGEN TBMODEL          *        
D03409*  05/10/16  AA97148    1.Modify existing Service Order Status to*        
D03409*                         display proper business rule message & *        
D03409*                         sync with CSR04628.                    *        
D03409*                       2.Modify CRDARNG045 hard stop message into        
D03409*                         warning.                               *        
D03409*                       Ref. HPALM Defect # D3409 & D7262        *        
A05460*  09/28/16  SM93554    REMOVED AMT-00-DAY-NSA AS PART OF AMOUNT *        
      *            Act-288    -NSA CALCULATION IN 2310 , 2320 PARA.    *        
ACT369*  12/05/16  ad7f921    Remove STA_SUMMARY & DETAIL tables and   *        
ACT369*       APPL00005460    its references.                          *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04366'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      **   CSS_DELINQUENCY (C8)                                                 
      ************************************************************              
           EXEC SQL                                                             
            INCLUDE TBDELQ                                                      
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_DEP_ON_HAND  (DO)                                                
      **************************************************************            
           EXEC SQL                                                             
            INCLUDE TBDEPHND                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_ACCOUNT (AT)                                                     
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_AR_CNTL (AC)                                                     
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_BUDGET_HIST (BH)                                                 
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_CUST_ALERT (CA)                                                  
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBCSTALT                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_DFA_ACCT (DA)                                                    
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_SO_DATA (VO)                                                     
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      **************************************************************            
      *    CSS_FINAL_WO (FW)                                                    
      **************************************************************            
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
      ************************************************************              
      **   CSS_REG_PROFILE (LR)                                                 
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ************************************************************              
      **   CSS_CATEGORY (F5)                                                    
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
      *                                                                         
P0726C******************************************************************        
P0726C*    CSS_CRED_ARNGMENT   - X1                                    *        
P0726C******************************************************************        
P0726C*                                                                         
P0726C     EXEC SQL                                                             
P0726C         INCLUDE TBCRARNG                                                 
P0726C     END-EXEC.                                                            
P0726C*                                                                         
P0726D******************************************************************        
P0726D*    CSS_BUS_RULE_XREF   - 1T                                    *        
P0726D******************************************************************        
P0726D*                                                                         
P0726D     EXEC SQL                                                             
P0726D         INCLUDE TBRULXRF                                                 
P0726D     END-EXEC.                                                            
P0726D*                                                                         
P0726D******************************************************************        
P0726D*    CSS_BUS_RULE        - 1R                                    *        
P0726D******************************************************************        
P0726D*                                                                         
P0726D     EXEC SQL                                                             
P0726D         INCLUDE TBBUSRUL                                                 
P0726D     END-EXEC.                                                            
P0726D*                                                                         
P0726F******************************************************************        
P0726F*    CSS_BILL_WINDOW     - BN                                    *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                     06460000
P0726F        INCLUDE TBBILWDW                                          06470000
P0726F     END-EXEC.                                                    06480000
P0726F                                                                  
      ************************************************************              
      **   CSS_AR_TRANS_HIST (AR)                                               
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_HOLIDAY - J8                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT - UT                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC - RD                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTDESC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_READ_WINDOW - RW                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
TASK01******************************************************************07690000
TASK01*    CSS_ACCT_ATTRIBUTE - YP                                     *07700000
TASK01******************************************************************07710000
TASK01*                                                                 07720000
TASK01     EXEC SQL                                                     07730000
TASK01        INCLUDE TBACTATT                                          07740000
TASK01     END-EXEC.                                                    07750000
TASK01*                                                                 07760000
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(8) VALUE 'CSR04366'.     
           05  WS-SQLSTATE               PIC X(5) VALUE SPACES.         
           05  ALL-DONE-SW               PIC X(1) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW              PIC X(1) VALUE 'Y'.            
               88  SEND-DONE-ERROR       VALUE 'N'.                     
               88  SEND-DONE-OK          VALUE 'Y'.                     
           05  WS-DATABASE               PIC 9(01) VALUE 0.             
               88 CSR-DATABASE                     VALUE 1.             
               88 SEB-DATABASE                     VALUE 2.             
           05  WS-ROW-COUNT              PIC S9(09) COMP.               
TASK01     05  WS-DPP-DROP-EXISTS        PIC X(01) VALUE 'N'.           
           05  WS-EXCPTNL-MSG            PIC X(01) VALUE 'N'.           
           05  WS-NULL-IND-CPD           PIC S9(4) COMP VALUE 0.        
           05  WS-CPD310-NULL-IND        PIC S9(4) COMP VALUE 0.        
           05  WS-DAYS-00                PIC S9(4) COMP VALUE 0.        
           05  WS-DAYS-30                PIC S9(4) COMP VALUE 0.        
           05  WS-DAYS-60                PIC S9(4) COMP VALUE 0.        
           05  WS-DAYS-90                PIC S9(4) COMP VALUE 0.        
           05  WS-SECURED-ACCOUNT         PIC X(01) VALUE SPACES.       
           05  WS-UNPAID-DEPOSIT          PIC X(01) VALUE SPACES.       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.     
           05  WS-ACCOUNT-NO-PARM         PIC X(13).                    
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO-PARM           
                                          PIC S9(13).                   
           05  RS-RETURN-CODE             PIC S9(9)      COMP VALUE 0.  
                                                                        
           05  P-RETURN-PARM              PIC S9(09) COMP VALUE +0.     
           05  WS-CURRENT-TIMESTAMP       PIC X(26).                    
           05  WS-CURRENT-DATE            PIC X(10).                    
           05  WS-CURRENT-DT              PIC X(10).                    
           05  WS-HOLD-CURRENT-DATE.                                    
               10  WS-CURRENT-YEAR     PIC  X(4).                       
               10  WS-CURRENT-YEAR-N REDEFINES WS-CURRENT-YEAR          
                                       PIC  9(4).                       
               10  FILLER              PIC  X(1).                       
               10  WS-CURRENT-MONTH    PIC  9(2).                       
               10  FILLER              PIC  X(1).                       
               10  WS-CURRENT-DAY      PIC  X(2).                       
           05  WS-CURRENT-MONTH-DAY    PIC  X(4).                       
           05  WS-CURRENT-TIME            PIC X(08).                    
           05  WS-CURR-TS-PAST-VAL       PIC X(26) VALUE SPACES.        
           05  WS-CURR-TS-PAST.                                         
               10  WS-CURR-TS-DT-PAST    PIC X(10) VALUE SPACES.        
               10  WS-CURR-TS-XX-PAST    PIC X(16) VALUE SPACES.        
           05  WS-DAYS-EXPIRE            PIC S9(04) COMP VALUE 0.       
           05  WS-RECENT-PYMT-DAYS       PIC S9(09) COMP VALUE 0.       
           05  WS-RECENT-STA-DAYS        PIC S9(09) COMP VALUE 0.       
           05  WS-RECENT-DPP-DAYS        PIC S9(09) COMP VALUE 0.       
           05  WS-RECENT-DPP-FL          PIC X(01) VALUE SPACES.        
               88 WS-RECENT-DPP-EXISTS   VALUE 'Y'.                     
           05  WS-RECENT-STA-FL          PIC X(01) VALUE SPACES.        
               88 WS-RECENT-STA-EXISTS   VALUE 'Y'.                     
           05  WS-RECENT-PAYMENT         PIC X(01) VALUE SPACES.        
           05  WS-PENDING-SO-FLAG        PIC X(01) VALUE SPACES.        
           05  WS-DNP-TYPE               PIC X(01) VALUE SPACES.        
P00471         88 EXCPTNL-DNP            VALUE 'D', 'M', 'Q', 'S', 'T', 
P00471                                         'W'.                     
           05  WS-EXCPTNL-DNP-DATE       PIC X(10) VALUE SPACES.        
           05  WS-NEXT-READ-DATE         PIC X(10) VALUE SPACES.        
           05  WS-DNP-FLAG               PIC X(01) VALUE SPACES.        
           05  WS-DNP-ACT-FLAG           PIC X(01) VALUE SPACES.        
           05  WS-DPP-CONTRACT-AMT       PIC S9(09)V99 COMP-3 VALUE 0.  
           05  MCSCB068                  PIC X(08)  VALUE 'MCSCB068'.   
           05  WS-COMPANY                PIC X(02) VALUE SPACES.        
               88 WS-SCEG                VALUE '01'.                    
               88 WS-PSNC                VALUE '26'.                    
           05  WS-REG-GROUP              PIC X(03) VALUE SPACES.        
               88 WS-DEREG               VALUE ' '.                     
               88 WS-REG                 VALUE '100', '200'.            
A03300     05  WS-STA004-DSP             PIC X(01) VALUE 'N'.           
A03300         88 STA004-DSP                       VALUE 'Y'.           
           05  WS-DATE-SEAS-DPP-START    PIC S9(4)V9(5) USAGE DISPLAY.  
           05  WS-DATE-SEAS-DPP-END      PIC S9(4)V9(5) USAGE DISPLAY.  
           05  WS-DPP-SEAS               PIC X(01) VALUE SPACES.        
           05  WS-GTT-NAME               PIC X(19) VALUE SPACES.        
           05  WS-RETURN-CODE            PIC S9(4) COMP VALUE 0.        
           05  WS-AMT-NSA                PIC S9(09)V99 USAGE COMP-3     
                                                 VALUE 0.               
           05 WS-60-DAY-ARREARS          PIC X(01) VALUE SPACES.        
           05 WS-AMT-ARREARS-GR-30       PIC S9(09)V99 USAGE COMP-3     
                                                 VALUE 0.               
           05 WS-AMT-ARREARS-GR-60       PIC S9(09)V99 USAGE COMP-3     
                                                 VALUE 0.               
           05 WS-CATEGORY-CD             PIC X(01) VALUE SPACES.        
           05 WS-60-DAY-AR-IND           PIC X(01) VALUE SPACES.        
           05 WS-SECURED-RATE-IND        PIC X(01) VALUE SPACES.        
           05 WS-STA-CTMTR-LMT           PIC S9(4)V9(5) USAGE COMP-3    
                                                 VALUE 0.               
           05 WS-STA-AMOUNT              PIC S9(9)V9(2) USAGE COMP-3    
                                                 VALUE 0.               
           05 WS-CRED-FL                 PIC X(01) VALUE 'N'.           
           05 WS-NEAREST-DNP-DT          PIC X(10) VALUE SPACES.        
           05 WS-NO-CRED-ACT-ROWS        PIC S9(4) COMP.                
           05 WS-CRED-ACTION-DT OCCURS 04 TIMES INDEXED BY CRED-INDX.   
              10 IN-CRED-ACTION-DT       PIC X(10).                     
           05 WS-BUD-HIST-DT             PIC X(10) VALUE SPACES.        
           05 WS-DFA-UPD-DT              PIC X(10) VALUE SPACES.        
           05 WS-3MNTHS-CHK-DT           PIC X(10) VALUE SPACES.        
           05 WS-DAY-STA-SECOND-MAIL-CD PIC X(19) VALUE                 
                                                 'DAY-STA-SECOND-MAIL'. 
          05 WS-DAY-STA-SECOND-MAIL    PIC S9(05) COMP-3 VALUE +0.      
          05 WS-STA-SCND-NOTC-DT       PIC X(10) VALUE SPACES.          
          05 WS-STA-DNP-DT             PIC X(10) VALUE SPACES.          
          05 WS-DAY-DUE-CD             PIC X(07) VALUE 'DAY-DUE'.       
          05 WS-DAY-DUE                PIC S9(05) COMP-3 VALUE +0.      
          05 WS-PREV-BUS-DAY-FLAG      PIC X(01) VALUE 'N'.             
             88 PREV-BUS-DAY-FOUND               VALUE 'Y'.             
A03898    05 WS-BILL-IMED-DEP          PIC X(01) VALUE SPACES.          
P0726C    05 WS-LAST-ARNG-DAYS         PIC S9(09) COMP VALUE 0.         
P0726C    05  ws-STA-ARNG-CMPLD-IND    PIC X(01)  VALUE SPACES.         
P0726E    05 WS-CREDIT-ACTION-FL       PIC X(01)  VALUE SPACES.         
P0726E    05 WS-GROUP1-TO-GROUP2-FL    PIC X(01)  VALUE 'N'.            
P0726E    05 WS-ACCT-ATTRIBUTE-FL      PIC X(01)  VALUE 'N'.            
P0726F    05 WS-NEXT-BILL-DATE         PIC X(10)  VALUE SPACES.         
P0726F    05 WS-DAY-DPP-ERNST          PIC S9(04) VALUE 0.              
P0726F    05 WS-DNP-MINUS-DELINQ-DT    PIC X(10)  VALUE SPACES.         
                                                                        
       01  WS-DPP-START-DATE.                                           
           05  WS-DPP-START-YEAR         PIC X(04) VALUE ZERO.          
           05  FILLER                    PIC X(01) VALUE '-'.           
           05  WS-DPP-START-MONTH        PIC X(02) VALUE ZERO.          
           05  FILLER                    PIC X(01) VALUE '-'.           
           05  WS-DPP-START-DAY          PIC X(02) VALUE ZERO.          
       01  WS-DPP-START-MONTH-DAY        PIC X(04) VALUE ZERO.          
       01  WS-DPP-END-DATE.                                             
           05  WS-DPP-END-YEAR           PIC X(04) VALUE ZERO.          
           05  FILLER                    PIC X(01) VALUE '-'.           
           05  WS-DPP-END-MONTH          PIC X(02) VALUE ZERO.          
           05  FILLER                    PIC X(01) VALUE '-'.           
           05  WS-DPP-END-DAY            PIC X(02) VALUE ZERO.          
       01  WS-DPP-END-MONTH-DAY          PIC X(04) VALUE ZERO.          
      *                                                                         
      *01 LOC-RESLTSET         USAGE SQL TYPE IS                        
      *                  RESULT-SET-LOCATOR VARYING.                    
                                                                        
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
      *                                                                         
      *                                                                         
      ***************************************************************   ****    
      *    DB2 COMMUNICATION REQUIREMENT *                                      
      ***************************************************************   ****    
      *01  LOC1                  USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
       01  ERROR-MESSAGE.                                               
           02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
           02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
                                 INDEXED BY ERROR-INDEX.                
       77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
       77  TRACE-MESSAGE-AREA    PIC X(256).                            
       77  OPENFN                PIC X(12).                             
       77  SSID                  PIC X(4).                              
       77  PLANNAME              PIC X(8).                              
       77  RETCODE               PIC S9(5).                             
       77  REASCODE              PIC S9(5).                             
       77  CLOSFN                PIC X(12).                             
       77  TERMOP                PIC X(4).                              
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE           PIC S9(09) COMP VALUE 0.          
P0726D     05 S-ARNG-TYPE             PIC X(05)  VALUE SPACES.          
P0726D     05 S-RULE-NOTIFY-TYPE-CD   PIC X(01)  VALUE SPACES.          
P0726D     05 S-BUS-RULE-ID           PIC X(10)  VALUE SPACES.          
P0726D     05 S-RULE-RESULT-CD        PIC X(01)  VALUE SPACES.          
P0726D     05 S-BUS-RULE-XREF-ID      PIC X(26)  VALUE SPACES.          
P0726D     05 S-MESSAGE-PARMS         PIC X(200) VALUE SPACES.          
P0726D     05 S-LINK-PARMS            PIC X(200) VALUE SPACES.          
P00726     05 S-SEASONAL-FLAG         PIC X(01)  VALUE 'N'.             
P0726E     05 S-CREDIT-ACTION-FL      PIC X(01)  VALUE SPACES.          
      *                                                                         
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
      *--------< WORKING STORAGE TO SUPPORT CPD00068 >                          
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
P0726F******************************************************************        
P0726F* WORKING STORAGE COPYBOOKS FOR CPD00309                         *        
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                     01720000
P0726F        INCLUDE CWS00309                                          01730000
P0726F     END-EXEC.                                                    01740000
P0726F                                                                  
      *--------< WORKING STORAGE WS-CODES-DATA-PRESENT >                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * WORKING STORAGE COPYBOOKS FOR CPD00315                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00315                                                 
AT4917     END-EXEC.                                                            
AT4917*                                                                         
                                                                        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-ACCOUNT-NO                 PIC X(13).                      
A03301 01  I-PARM-TYPE                  PIC X(04).                      
       01  I-USER-ID                    PIC X(07).                      
      *                                                                         
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION USING   I-ACCOUNT-NO                          
                                , I-PARM-TYPE                           
                                , I-USER-ID.                            
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                      THRU 0100-EXIT. 
           PERFORM 1000-PROCESS-INPUT                   THRU 1000-EXIT. 
           PERFORM 2000-PROCESS-OUTPUT                  THRU 2000-EXIT. 
           PERFORM 9999-END-PROGRAM                     THRU 9999-EXIT. 
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
               WITH ROWSET POSITIONING FOR                              
               SELECT                                                   
                   *                                                    
               FROM                                                     
                   #CSR04366_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT                                                           
MFA-TR*            *                                                            
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04366_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
P0726D     INITIALIZE                S-ARNG-TYPE                        
P0726D                               S-RULE-NOTIFY-TYPE-CD              
P0726D                               S-BUS-RULE-ID                      
P0726D                               S-RULE-RESULT-CD                   
P0726D                               S-BUS-RULE-XREF-ID                 
P0726D                               S-MESSAGE-PARMS                    
P0726D                               S-LINK-PARMS                       
P0726E                               S-CREDIT-ACTION-FL.                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR04366_R1'      TO WS-GTT-NAME.              
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04366_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04366_R1
              (                                                       
                    RETURN_CODE               INT                   
P0726D             ,ARNG_TYPE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2         
P0726D             ,RULE_NOTIFY_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
P0726D             ,BUS_RULE_ID CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
P0726D             ,RULE_RESULT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
P0726D             ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
P0726D             ,MESSAGE_PARMS CHAR(200)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
P0726D             ,LINK_PARMS CHAR(200)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
P00726             ,SEASONAL_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
P0726E             ,CREDIT_ACTION_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12256100
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
P0726E     MOVE 'N'                       TO WS-GROUP1-TO-GROUP2-FL.    
           IF  I-ACCOUNT-NO NOT NUMERIC                                 
               MOVE 200                   TO WS-ACTIVE-RETURN-CODE      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF                                                       
           IF  I-PARM-TYPE = SPACES OR LOW-VALUES                       
               MOVE 300                   TO WS-ACTIVE-RETURN-CODE      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF                                                       
           MOVE I-ACCOUNT-NO              TO WS-ACCOUNT-NO-PARM.        
           MOVE WS-ACCOUNT-NO-NUM         TO AT-ACCOUNT-NO              
                                             VO-ACCOUNT-NO              
                                             FW-ACCOUNT-NO              
                                             WS-ACCOUNT-NO              
                                             LR-ACCOUNT-NO              
                                             AR-ACCOUNT-NO              
TASK01                                       YP-ACCOUNT-NO.             
           MOVE '01'                      TO C8-COMPANY-NO              
           MOVE 'DATABASE'                TO C8-DELINQ-CD               
           PERFORM 7005-GET-DELINQ        THRU 7005-EXIT.               
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE                
P0726F*    Get DPP Earnest amount delinquency value                             
P0726F     MOVE '01'                      TO C8-COMPANY-NO.             
P0726F     MOVE 'DAY-DPPEARNEST'          TO C8-DELINQ-CD.              
P0726F     PERFORM 7005-GET-DELINQ        THRU 7005-EXIT.               
P0726F     MOVE C8-DELINQ-VALUE           TO WS-DAY-DPP-ERNST.          
           PERFORM 7100-SELECT-ACCOUNT    THRU 7100-EXIT.               
           PERFORM 7110-GET-CURRENT-DATE  THRU 7110-EXIT.               
           MOVE AT-COMPANY-NO             TO WS-COMPANY                 
           IF  SEB-DATABASE                                             
               PERFORM 7150-SELECT-REG-GROUP THRU 7150-EXIT             
               MOVE LR-REG-GROUP-CD       TO WS-REG-GROUP               
P0726E         IF WS-REG                                                
P0726E            MOVE 'FCST CR GP BALANCE' TO YP-ATTRIBUTE-DESC        
P0726E            PERFORM 7160-ACCOUNT-ATTRIBUTE THRU 7160-EXIT         
P0726E            IF WS-ACCT-ATTRIBUTE-FL = 'Y'                         
P0726E               MOVE 'Y' TO WS-GROUP1-TO-GROUP2-FL                 
P0726E            END-IF                                                
P0726E         END-IF                                                   
           ELSE                                                         
               MOVE  WS-DAY-STA-SECOND-MAIL-CD TO C8-DELINQ-CD          
               MOVE  AT-COMPANY-NO        TO C8-COMPANY-NO              
               PERFORM 7005-GET-DELINQ    THRU 7005-EXIT                
               MOVE  C8-DELINQ-VALUE      TO WS-DAY-STA-SECOND-MAIL     
           END-IF                                                       
           MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT      
           MOVE 'N' TO WS-DNP-FLAG                                      
                       WS-PENDING-SO-FLAG                               
                       WS-DNP-ACT-FLAG                                  
           IF  WS-CODE-PENDING-DNP = 'A'                                
               MOVE 'DNP01'  TO VO-ORDER-TYPE-CD                        
               PERFORM 7300-SELECT-PENDING-SO THRU 7300-EXIT            
               MOVE  VO-ORDER-REASON TO WS-DNP-TYPE                     
               IF WS-PENDING-SO-FLAG = 'Y'                              
                  MOVE 'Y'   TO WS-DNP-FLAG                             
               END-IF                                                   
           END-IF                                                       
           IF WS-DNP-FLAG = 'Y'                                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'FM006'  TO VO-ORDER-TYPE-CD                         
              PERFORM 7300-SELECT-PENDING-SO THRU 7300-EXIT             
               IF WS-PENDING-SO-FLAG = 'Y'                              
                  MOVE 'Y'   TO WS-DNP-ACT-FLAG                         
               END-IF                                                   
           END-IF                                                       
           MOVE 'Y' TO CALC-BALANCE-SW                                  
                       CALC-ARREARS-SW                                  
                       LOAD-DNP-DATE-SW                                 
                       CALC-PAST-DUE-SW.                                
           PERFORM 1500-CALL-MCSCB068    THRU 1500-EXIT.                
           PERFORM 1130-LOAD-CRED-ACT-DT THRU 1130-EXIT.                
           IF SEB-DATABASE AND AT-CREDIT-GROUP = 'B'                    
               MOVE WS-TOTAL-BALANCE-UTL TO WS-STA-AMOUNT               
           ELSE                                                         
               MOVE WS-AMT-PAST-DUE-UTL  TO WS-STA-AMOUNT               
           END-IF.                                                      
           MOVE AT-ACCOUNT-NO          TO DO-ACCOUNT-NO                 
                                          VO-ACCOUNT-NO                 
                                          AC-ACCOUNT-NO                 
                                          DA-ACCOUNT-NO                 
                                          BH-ACCOUNT-NO                 
                                          CA-ACCOUNT-NO                 
P0726C                                    X1-ACCOUNT-NO.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1130-LOAD-CRED-ACT-DT.                                         *        
      ******************************************************************        
      *                                                                         
       1130-LOAD-CRED-ACT-DT.                                           
      *                                                                         
           MOVE WS-DATE-CREDIT-ACTION-D    TO IN-CRED-ACTION-DT(1).     
           MOVE WS-DATE-CREDIT-ACTION-G    TO IN-CRED-ACTION-DT(2).     
           MOVE WS-DATE-CREDIT-ACTION-H    TO IN-CRED-ACTION-DT(3).     
           MOVE WS-DATE-CREDIT-ACTION-I    TO IN-CRED-ACTION-DT(4).     
      *                                                                         
           MOVE 4                          TO WS-NO-CRED-ACT-ROWS.      
           PERFORM VARYING CRED-INDX FROM 1 BY 1                        
              UNTIL CRED-INDX > WS-NO-CRED-ACT-ROWS                     
              IF IN-CRED-ACTION-DT(CRED-INDX) = SPACES                  
                 MOVE '1900-01-01'       TO IN-CRED-ACTION-DT(CRED-INDX)
              END-IF                                                    
              IF WS-CRED-FL = 'N'                                       
                 IF IN-CRED-ACTION-DT(CRED-INDX) > WS-CURRENT-DATE      
                    MOVE IN-CRED-ACTION-DT(CRED-INDX) TO                
                                                  WS-NEAREST-DNP-DT     
                    MOVE 'Y'                  TO WS-CRED-FL             
                 END-IF                                                 
              ELSE                                                      
                 IF IN-CRED-ACTION-DT(CRED-INDX) < WS-NEAREST-DNP-DT    
                    AND IN-CRED-ACTION-DT(CRED-INDX) > WS-CURRENT-DATE  
                    MOVE IN-CRED-ACTION-DT(CRED-INDX) TO                
                                                  WS-NEAREST-DNP-DT     
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       1130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1500-CALL-MCSCB068.                                            *        
      ******************************************************************        
      *                                                                         
       1500-CALL-MCSCB068.                                              
                                                                        
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
                                             S-RETURN-CODE,             
                                             SQLCODE.                   
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO RS-RETURN-CODE,            
                                             WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
              END-IF                                                    
              PERFORM 8010-INSERT-GTT       THRU 8010-EXIT              
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           5000-UPDATE                                          *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
P00726     MOVE 'N'                       TO S-SEASONAL-FLAG.           
P00726     MOVE ZEROES                    TO S-RETURN-CODE.             
                                                                        
P0726E     PERFORM 2405-VALIDATE-CREDIT-ACTION    THRU 2405-EXIT.       
P0726E     MOVE WS-CREDIT-ACTION-FL       TO S-CREDIT-ACTION-FL.        
                                                                        
P0726F* Get Next Bill date                                                      
P0726F     INITIALIZE WS-NEXT-BILL-DATE                                 
P0726F                                                                  
P0726F     PERFORM 5900-NEXT-BILL-DATE   THRU 5900-NEXT-BILL-DATE-EXIT. 
P0726F     IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                         
P0726F        IF BN-DATE-EXTRACT > SPACES                               
P0726F           MOVE BN-DATE-EXTRACT     TO WS-NEXT-BILL-DATE          
P0726F        END-IF                                                    
P0726F     END-IF.                                                      
P0726F* Notice Mail Date = DNP Date - 'DAY-DPPEARNEST' Days                     
P0726F     MOVE WS-NEXT-BILL-DATE         TO WS-NEW-BUSINESS-DAY        
P0726F     PERFORM WS-DAY-DPP-ERNST TIMES                               
P0726F     MOVE 'N'                       TO WS-PREV-BUS-DAY-FLAG       
P0726F     PERFORM 6525-PREV-BUSINESS-DAY                               
P0726F        THRU 6525-PREV-BUSINESS-DAY-EXIT                          
P0726F       UNTIL PREV-BUS-DAY-FOUND                                   
P0726F     END-PERFORM.                                                 
P0726F     MOVE WS-NEW-BUSINESS-DAY       TO WS-DNP-MINUS-DELINQ-DT.    
P0726F*                                                                         
           EVALUATE I-PARM-TYPE                                         
               WHEN 'STA'                                               
                   PERFORM 2100-GET-STA-BUS-RULES THRU 2100-EXIT        
ACT118             IF CSR-DATABASE                                      
A03898                PERFORM 2500-PROCESS-BILL-IMED-DEP-CUR            
A03898                   THRU 2500-EXIT                                 
ACT118             END-IF                                               
P0726A* Added Review Utility charges warning message                            
P0726A             PERFORM 2160-GET-60-DAY-OLD    THRU 2160-EXIT        
P0726A             IF WS-AMT-ARREARS-GR-60 > WS-NOTICE-DNP-LIMIT        
P0726A                MOVE ZEROES                 TO S-RETURN-CODE      
P0726A                MOVE 'STA040'               TO S-BUS-RULE-ID      
P0726A                MOVE 'Y'                    TO S-RULE-RESULT-CD   
P0726A                PERFORM 8010-INSERT-GTT     THRU 8010-EXIT        
P0726A             END-IF                                               
A03301         WHEN 'NDPP'                                              
                   PERFORM 2200-GET-DPP-BUS-RULES THRU 2200-EXIT        
A03301         WHEN 'SDPP'                                              
                   PERFORM 2300-GET-SEAS-DPP-BUS-RULES THRU 2300-EXIT   
P00726         WHEN 'DPP'                                               
P00726             PERFORM 2200-GET-DPP-BUS-RULES THRU 2200-EXIT        
P00726             IF SEB-DATABASE                                      
P00726                INITIALIZE GTT-RETURN-FIELDS                      
P00726                PERFORM 2300-GET-SEAS-DPP-BUS-RULES THRU 2300-EXIT
P00726             END-IF                                               
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS STA BUSINESS RULES/CRITERIA.                              *        
      ******************************************************************        
       2100-GET-STA-BUS-RULES.                                          
                                                                        
           EVALUATE TRUE ALSO TRUE                                      
              WHEN CSR-DATABASE ALSO WS-SCEG                            
                  PERFORM 2110-SCEG-STA-BUS                             
                     THRU 2110-EXIT                                     
              WHEN CSR-DATABASE ALSO WS-PSNC                            
                  PERFORM 2120-PSNC-STA-BUS                             
                     THRU 2120-EXIT                                     
              WHEN SEB-DATABASE ALSO WS-DEREG                           
                  PERFORM 2130-SEB-DREG-STA-BUS                         
                     THRU 2130-EXIT                                     
              WHEN SEB-DATABASE ALSO WS-REG                             
                  PERFORM 2140-SEB-REG-STA-BUS                          
                     THRU 2140-EXIT                                     
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-SCEG-STA-BUS.                                               
              PERFORM 2150-CTMTR-MAJOR-ACCT-CHK THRU 2150-EXIT.         
      * STA002 - CREDIT GROUP                                                   
              IF AT-CODE-ACCT-STAT = 'S'                                
                 NEXT SENTENCE                                          
A03300        ELSE                                                      
A03300* STA035 - NON-ULILITY CHARGES INCLUDED - STA                             
A03300           IF AT-CODE-ACCT-STAT = 'B'                             
A03300              MOVE ZEROES                TO S-RETURN-CODE         
A03300              MOVE 'STA035'              TO S-BUS-RULE-ID         
A03300              MOVE 'Y'                   TO S-RULE-RESULT-CD      
A03300              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300           ELSE                                                   
                    MOVE ZEROES                TO S-RETURN-CODE         
                    MOVE 'STA002'              TO S-BUS-RULE-ID         
                    EVALUATE AT-CREDIT-GROUP                            
                       WHEN 'B'                                         
                       WHEN 'A'                                         
                          MOVE 'G'             TO S-RULE-RESULT-CD      
                       WHEN 'N'                                         
                          MOVE 'G'             TO S-RULE-RESULT-CD      
                       WHEN 'C'                                         
                          MOVE 'R'             TO S-RULE-RESULT-CD      
                    END-EVALUATE                                        
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300           END-IF                                                 
              END-IF.                                                   
      * STA003 - ACCOUNT STATUS                                                 
              MOVE ZEROES                TO S-RETURN-CODE               
              MOVE 'STA003'              TO S-BUS-RULE-ID               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                        MOVE 'G'         TO S-RULE-RESULT-CD            
                 WHEN 'B'                                               
                    IF  AT-ACCT-FINALED-DT > SPACES                     
                        PERFORM 7510-SELECT-FINAL-WO                    
                           THRU 7510-EXIT                               
                        IF  FW-GUARANTEED-IND = 'Y'                     
                            MOVE 'Y'     TO S-RULE-RESULT-CD            
                        ELSE                                            
                            MOVE 'G'     TO S-RULE-RESULT-CD            
                        END-IF                                          
                    ELSE                                                
      ** STA024 - FINAL BILL HAS NOT BEEN GENERATED. UNABLE TO SETUP STA        
                        MOVE 'STA024'    TO S-BUS-RULE-ID               
                        MOVE 'R'         TO S-RULE-RESULT-CD            
                    END-IF                                              
                 WHEN OTHER                                             
                    MOVE 'R'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA025 - ACCOUNT WITH CREDIT BALANCE CANNOT BE SETUP ON STA.            
              MOVE 'STA025'           TO S-BUS-RULE-ID                  
              IF AT-TOTAL-AR-BALANCE < 0                                
                 MOVE 'R'               TO S-RULE-RESULT-CD             
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF.                                                   
      * STA004 - FORECASTED DNP  STA005 - ACTIVE DNP ORDER                      
      * STA006 - DNP ORDER WORKED                                               
              PERFORM 2115-CSR-STA-DNP-RULE                             
                 THRU 2115-EXIT                                         
      * STA008 - EXISTING PAYMENT ARRANGEMENT - STA                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA008'              TO S-BUS-RULE-ID               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA009 - EXISTING PAYMENT ARRANGEMENT - DPP                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA009'              TO S-BUS-RULE-ID               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA011 - EXISTING MEDICAL CERTIFICATE                                   
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA011'              TO S-BUS-RULE-ID               
              IF WS-CODE-MEDICAL = 'A'                                  
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA012 - UNPAID RETURN CHECKS                                           
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA012'              TO S-BUS-RULE-ID               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA014 - UNPAID DEPOSIT ON ACCOUNT                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA014'              TO S-BUS-RULE-ID               
              MOVE 'N' TO WS-UNPAID-DEPOSIT                             
              PERFORM 7210-SELECT-DEP-ON-HAND                           
                 THRU 7210-EXIT                                         
              IF WS-UNPAID-DEPOSIT = 'N'                                
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'Y'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA015 - RECENT PAYMENT IN LAST 60 DAYS                                 
              MOVE 'STA015'              TO S-BUS-RULE-ID               
              MOVE 'Y' TO WS-RECENT-PAYMENT                             
              IF WS-RECENT-PYMT-DAYS > 60                               
                 MOVE 'N'                TO WS-RECENT-PAYMENT           
              ELSE                                                      
                 MOVE 'Y'                TO WS-RECENT-PAYMENT           
              END-IF                                                    
              IF WS-RECENT-PAYMENT = 'N'                                
                 MOVE 'Y'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA016 - ARREARS GREATER THAN 60 DAYS                                   
              MOVE 'STA016'              TO S-BUS-RULE-ID               
              MOVE 'Y' TO WS-60-DAY-ARREARS                             
              IF WS-DAYS-60 > 60                                        
                 COMPUTE WS-AMT-ARREARS-UTL =                           
                         (WS-AMT-60-DAY-UTL + WS-AMT-90-DAY-UTL         
                         + WS-AMT-30-DAY-NSA)                           
              ELSE                                                      
                 IF AT-DATE-BILL-DAY-90 LESS THAN WS-DT-25-DAYS-AGO     
                    COMPUTE WS-AMT-ARREARS-UTL  =  (WS-AMT-90-DAY-UTL   
                                               + WS-AMT-30-DAY-NSA      
                                               + WS-AMT-60-DAY-NSA)     
                 END-IF                                                 
              END-IF                                                    
              COMPUTE WS-AMT-ARREARS-GR-30 = WS-AMT-ARREARS-UTL         
              IF WS-AMT-ARREARS-GR-30 > 0                               
                 MOVE 'Y'                TO WS-60-DAY-ARREARS           
              ELSE                                                      
                 MOVE 'N'                TO WS-60-DAY-ARREARS           
              END-IF                                                    
              IF WS-60-DAY-ARREARS = 'Y'                                
                 MOVE 'Y'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
TASK01* STA018 - DPP COMPLIANCE                                                 
TASK01        MOVE 0                     TO WS-RETURN-CODE              
TASK01                                      S-RETURN-CODE               
TASK01        MOVE 'STA018'              TO S-BUS-RULE-ID               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
TASK01            MOVE 'Y'              TO S-RULE-RESULT-CD             
TASK01            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
TASK01        END-IF                                                    
      * STA027 - ACCOUNT HAS NOT GONE THROUGH INITIAL BILLING.                  
              IF AT-REV-MTH-LST-NRML EQUAL ZEROES                       
                 MOVE 'R'                TO S-RULE-RESULT-CD            
                 MOVE 'STA027'           TO S-BUS-RULE-ID               
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF.                                                   
                                                                        
              PERFORM 7700-CHK-AR-TRAN-HIST THRU 7700-EXIT.             
              IF WS-60-DAY-AR-IND = 'Y'                                 
                 MOVE 'STA030'              TO S-BUS-RULE-ID            
                 MOVE 'Y'                   TO S-RULE-RESULT-CD         
                 PERFORM 8010-INSERT-GTT    THRU 8010-EXIT              
              END-IF.                                                   
                                                                        
              IF AT-CODE-ACCT-STAT = 'B' AND WS-TOTAL-BALANCE <= 0      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 MOVE 'STA031'              TO S-BUS-RULE-ID            
                 MOVE 'R'                   TO S-RULE-RESULT-CD         
                 PERFORM 8010-INSERT-GTT    THRU 8010-EXIT              
              END-IF.                                                   
              IF  WS-CODE-STA-ACCT NOT EQUAL 'A'                        
              AND AT-CODE-ACCT-STAT = 'A'                               
P00471        AND WS-EXCPTNL-MSG = 'N'                                  
                  PERFORM 2190-CHECK-DNP-SCND-NOTICE                    
                     THRU 2190-EXIT                                     
              END-IF.                                                   
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       2115-CSR-STA-DNP-RULE.                                           
      *                                                                         
              IF AT-CODE-ACCT-STAT = 'A'                                
                 MOVE ZEROES               TO S-RETURN-CODE             
A03300           MOVE SPACES               TO S-RULE-RESULT-CD          
                 MOVE 'STA004'             TO S-BUS-RULE-ID             
                 IF WS-NEAREST-DNP-DT > SPACES                          
                    IF WS-NEAREST-DNP-DT = WS-DATE-CREDIT-ACTION-G      
                       MOVE 'R'            TO S-RULE-RESULT-CD          
      * STA026 - STA CANNOT BE CREATED FOR AN EXCEPTIONAL DNP.                  
                       MOVE 'STA026'       TO S-BUS-RULE-ID             
                       MOVE 'Y'            TO WS-EXCPTNL-MSG            
                    ELSE                                                
                       MOVE 'G'         TO S-RULE-RESULT-CD             
                    END-IF                                              
                 ELSE                                                   
                     IF WS-DNP-FLAG = 'Y' AND VO-SERV-ORDER-STATUS < 26 
                        IF EXCPTNL-DNP                                  
                           MOVE 'R'         TO S-RULE-RESULT-CD         
                           MOVE 'STA026'    TO S-BUS-RULE-ID            
                           MOVE 'Y'         TO WS-EXCPTNL-MSG           
                        ELSE                                            
                           MOVE 'G'         TO S-RULE-RESULT-CD         
                        END-IF                                          
                     ELSE                                               
A03300                  IF VO-SERV-ORDER-STATUS = 30                    
A03300                  OR WS-DNP-FLAG = 'N'                            
A03300                     MOVE 'R'         TO S-RULE-RESULT-CD         
A03300                  END-IF                                          
                     END-IF                                             
                 END-IF                                                 
A03300           IF S-RULE-RESULT-CD > SPACES                           
A03300              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300           END-IF                                                 
      * STA005 - ACTIVE DNP - NOT WORKED                                        
                 IF WS-PENDING-SO-FLAG = 'Y'                            
                    MOVE ZEROES                TO S-RETURN-CODE         
                    MOVE 'STA005'              TO S-BUS-RULE-ID         
                    IF WS-DNP-FLAG  = 'Y'                               
                       IF  EXCPTNL-DNP                                  
                           IF WS-EXCPTNL-MSG = 'Y'                      
                              CONTINUE                                  
                           ELSE                                         
                               MOVE 'R'        TO S-RULE-RESULT-CD      
                               MOVE 'STA026'   TO S-BUS-RULE-ID         
                               PERFORM 8010-INSERT-GTT THRU 8010-EXIT   
                           END-IF                                       
                       ELSE                                             
A03300                     IF VO-SERV-ORDER-STATUS = 30                 
                              MOVE 'R'         TO S-RULE-RESULT-CD      
A03300                        PERFORM 8010-INSERT-GTT  THRU 8010-EXIT   
                           ELSE                                         
A03300                        IF VO-SERV-ORDER-STATUS = 26              
A03300                           MOVE 'Y'      TO S-RULE-RESULT-CD      
A03300                           PERFORM 8010-INSERT-GTT THRU 8010-EXIT 
A03300                        ELSE                                      
A03300* STA007 - Active DNP that is not yet 'in-route' or 'On-site'             
A03300                           MOVE 'STA007' TO S-BUS-RULE-ID         
A03300                           MOVE 'Y'      TO S-RULE-RESULT-CD      
A03300                           PERFORM 8010-INSERT-GTT THRU 8010-EXIT 
A03300                        END-IF                                    
                           END-IF                                       
                       END-IF                                           
                    ELSE                                                
      * STA006 - ACTIVE DNP - WORKED                                            
                        MOVE ZEROES            TO S-RETURN-CODE         
                        MOVE 'STA006'          TO S-BUS-RULE-ID         
                        IF WS-DNP-ACT-FLAG = 'Y'                        
                           MOVE 'R'            TO S-RULE-RESULT-CD      
                        ELSE                                            
                           MOVE 'G'            TO S-RULE-RESULT-CD      
                        END-IF                                          
                        PERFORM 8010-INSERT-GTT THRU 8010-EXIT          
                    END-IF                                              
                 END-IF                                                 
              END-IF.                                                   
      *                                                                         
       2115-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2120-PSNC-STA-BUS.                                               
              PERFORM 2150-CTMTR-MAJOR-ACCT-CHK THRU 2150-EXIT.         
      * STA002 - CREDIT GROUP                                                   
              IF AT-CODE-ACCT-STAT = 'S'                                
                 NEXT SENTENCE                                          
A03300        ELSE                                                      
A03300* STA035 - NON-ULILITY CHARGES INCLUDED - STA                             
A03300           IF AT-CODE-ACCT-STAT = 'B'                             
A03300              MOVE ZEROES                TO S-RETURN-CODE         
A03300              MOVE 'STA035'              TO S-BUS-RULE-ID         
A03300              MOVE 'Y'                   TO S-RULE-RESULT-CD      
A03300              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300           ELSE                                                   
                    MOVE ZEROES                TO S-RETURN-CODE         
                    MOVE 'STA002'              TO S-BUS-RULE-ID         
                    EVALUATE AT-CREDIT-GROUP                            
                       WHEN 'A'                                         
                       WHEN 'N'                                         
                          MOVE 'G'             TO S-RULE-RESULT-CD      
                       WHEN 'C'                                         
                          MOVE 'R'             TO S-RULE-RESULT-CD      
                       WHEN OTHER                                       
                          MOVE 'R'             TO S-RULE-RESULT-CD      
                    END-EVALUATE                                        
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300           END-IF                                                 
              END-IF.                                                   
      * STA003 - ACCOUNT STATUS                                                 
              MOVE ZEROES                TO S-RETURN-CODE               
              MOVE 'STA003'              TO S-BUS-RULE-ID               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                        MOVE 'G'         TO S-RULE-RESULT-CD            
                 WHEN 'B'                                               
                    IF  AT-ACCT-FINALED-DT > SPACES                     
                        PERFORM 7510-SELECT-FINAL-WO                    
                           THRU 7510-EXIT                               
                        IF  FW-GUARANTEED-IND = 'Y'                     
                            MOVE 'Y'     TO S-RULE-RESULT-CD            
                        ELSE                                            
                            MOVE 'G'     TO S-RULE-RESULT-CD            
                        END-IF                                          
                    ELSE                                                
      ** STA024 - FINAL BILL HAS NOT BEEN GENERATED. UNABLE TO SETUP STA        
                        MOVE 'STA024'    TO S-BUS-RULE-ID               
                        MOVE 'R'         TO S-RULE-RESULT-CD            
                    END-IF                                              
                 WHEN OTHER                                             
                    MOVE 'R'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA025 - ACCOUNT WITH CREDIT BALANCE CANNOT BE SETUP ON STA.            
              MOVE 'STA025'           TO S-BUS-RULE-ID                  
              IF AT-TOTAL-AR-BALANCE < 0                                
                 MOVE 'R'               TO S-RULE-RESULT-CD             
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * STA004 - FORECASTED DNP  STA005 - ACTIVE DNP ORDER                      
      * STA006 - DNP ORDER WORKED                                               
              PERFORM 2115-CSR-STA-DNP-RULE                             
                 THRU 2115-EXIT                                         
      * STA008 - EXISTING PAYMENT ARRANGEMENT - STA                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA008'              TO S-BUS-RULE-ID               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA009 - EXISTING PAYMENT ARRANGEMENT - DPP                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA009'              TO S-BUS-RULE-ID               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA011 - EXISTING MEDICAL CERTIFICATE                                   
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA011'              TO S-BUS-RULE-ID               
              IF WS-CODE-MEDICAL = 'A'                                  
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 PERFORM 7040-SELECT-MED-CERT                           
                    THRU 7040-EXIT                                      
                 IF  WS-DAYS-EXPIRE > 0 AND WS-DAYS-EXPIRE <= 30        
                     MOVE 'Y'                TO S-RULE-RESULT-CD        
                 ELSE                                                   
                     MOVE 'G'                TO S-RULE-RESULT-CD        
                 END-IF                                                 
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA012 - UNPAID RETURN CHECKS                                           
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA012'              TO S-BUS-RULE-ID               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA014 - UNPAID DEPOSIT ON ACCOUNT                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA014'              TO S-BUS-RULE-ID               
              MOVE 'N' TO WS-UNPAID-DEPOSIT                             
              PERFORM 7210-SELECT-DEP-ON-HAND                           
                 THRU 7210-EXIT                                         
              IF WS-UNPAID-DEPOSIT = 'N'                                
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'Y'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA015 - RECENT PAYMENT IN LAST 60 DAYS                                 
              MOVE 'STA015'              TO S-BUS-RULE-ID               
              MOVE 'Y' TO WS-RECENT-PAYMENT                             
              IF WS-RECENT-PYMT-DAYS > 60                               
                 MOVE 'N'                TO WS-RECENT-PAYMENT           
              ELSE                                                      
                 MOVE 'Y'                TO WS-RECENT-PAYMENT           
              END-IF                                                    
              IF WS-RECENT-PAYMENT = 'N'                                
                 MOVE 'Y'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA016 - ARREARS GREATER THAN 60 DAYS                                   
              MOVE 'STA016'              TO S-BUS-RULE-ID               
              MOVE 'Y' TO WS-60-DAY-ARREARS                             
              IF WS-DAYS-60 > 60                                        
                 COMPUTE WS-AMT-ARREARS-UTL =                           
                         (WS-AMT-60-DAY-UTL + WS-AMT-90-DAY-UTL         
                         + WS-AMT-30-DAY-NSA)                           
              ELSE                                                      
                  IF AT-DATE-BILL-DAY-90 LESS THAN WS-DT-25-DAYS-AGO    
                     COMPUTE WS-AMT-ARREARS-UTL   =  (WS-AMT-90-DAY-UTL 
                                              + WS-AMT-30-DAY-NSA       
                                              + WS-AMT-60-DAY-NSA)      
                  END-IF                                                
              END-IF                                                    
              COMPUTE WS-AMT-ARREARS-GR-30 = WS-AMT-ARREARS-UTL         
              IF WS-AMT-ARREARS-GR-30 > 0                               
                 MOVE 'Y'                TO WS-60-DAY-ARREARS           
              ELSE                                                      
                 MOVE 'N'                TO WS-60-DAY-ARREARS           
              END-IF                                                    
              IF WS-60-DAY-ARREARS = 'Y'                                
                 MOVE 'Y'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * STA017 - STA COMPLIANCE                                                 
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA017'              TO S-BUS-RULE-ID               
P0726C        PERFORM 7060-SEL-LAST-ARNG-DT-CMPLNCE THRU 7060-EXIT      
P0762C                                                                  
P0726C        MOVE X1-ARNG-COMPLIANCE-CD TO ws-STA-ARNG-CMPLD-IND       
P0762C                                                                  
P0726C        IF ws-STA-ARNG-CMPLD-IND = 'N' OR SPACES                  
P0726C*          IF SH-PYMNT-CMPLD-IND = 'N'                                    
                 MOVE 'Y'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * STA018 - DPP COMPLIANCE                                                 
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA018'              TO S-BUS-RULE-ID               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
                  MOVE 'Y'              TO S-RULE-RESULT-CD             
                  PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
              END-IF                                                    
      * STA019 - BBP COMPLIANCE                                                 
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA019'              TO S-BUS-RULE-ID               
              PERFORM 7030-SELECT-BBP-COMPLIANCE                        
                 THRU 7030-EXIT                                         
      *                                                                         
              MOVE BH-BUD-HIST-SEQ-NO(1:10) TO WS-BUD-HIST-DT           
              IF  BH-CHANGE-REASON = 'D'                                
              AND BH-REMARKS-TEXT(1:BH-REMARKS-LEN)                     
                                  = 'AUTOMATICALLY DROPPED FROM EPP'    
              AND WS-BUD-HIST-DT  > WS-3MNTHS-CHK-DT                    
                  MOVE 'Y'                TO S-RULE-RESULT-CD           
                  PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
              END-IF.                                                   
      * STA027 - ACCOUNT HAS NOT GONE THROUGH INITIAL BILLING.                  
              IF AT-REV-MTH-LST-NRML EQUAL ZEROES                       
                 MOVE 'R'                TO S-RULE-RESULT-CD            
                 MOVE 'STA027'           TO S-BUS-RULE-ID               
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF.                                                   
                                                                        
              PERFORM 7700-CHK-AR-TRAN-HIST THRU 7700-EXIT.             
              IF WS-60-DAY-AR-IND = 'Y'                                 
                 MOVE 'STA030'              TO S-BUS-RULE-ID            
                 MOVE 'Y'                   TO S-RULE-RESULT-CD         
                 PERFORM 8010-INSERT-GTT    THRU 8010-EXIT              
              END-IF.                                                   
                                                                        
              IF AT-CODE-ACCT-STAT = 'B' AND WS-TOTAL-BALANCE <= 0      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 MOVE 'STA031'              TO S-BUS-RULE-ID            
                 MOVE 'R'                   TO S-RULE-RESULT-CD         
                 PERFORM 8010-INSERT-GTT    THRU 8010-EXIT              
              END-IF.                                                   
              IF  WS-CODE-STA-ACCT NOT EQUAL 'A'                        
              AND AT-CODE-ACCT-STAT = 'A'                               
P00471        AND WS-EXCPTNL-MSG = 'N'                                  
                 PERFORM 2190-CHECK-DNP-SCND-NOTICE                     
                    THRU 2190-EXIT                                      
              END-IF.                                                   
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2130-SEB-DREG-STA-BUS.                                           
              PERFORM 2150-CTMTR-MAJOR-ACCT-CHK THRU 2150-EXIT.         
      * STA002 - CREDIT GROUP                                                   
A03301        IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
A03301           CONTINUE                                               
A03301        ELSE                                                      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 MOVE 'STA002'              TO S-BUS-RULE-ID            
                 EVALUATE AT-CREDIT-GROUP                               
                    WHEN 'A'                                            
A03301                 MOVE SPACES          TO S-RULE-RESULT-CD         
                    WHEN 'N'                                            
A03301                 MOVE 'STA037'        TO S-BUS-RULE-ID            
A03301                 MOVE 'G'             TO S-RULE-RESULT-CD         
A03301              WHEN 'D'                                            
A03301                 MOVE 'STA036'        TO S-BUS-RULE-ID            
A03301                 MOVE 'R'             TO S-RULE-RESULT-CD         
P00453              WHEN 'B'                                            
P00453                 MOVE SPACES          TO S-RULE-RESULT-CD         
                    WHEN 'C'                                            
                       MOVE 'R'             TO S-RULE-RESULT-CD         
                    WHEN OTHER                                          
                       MOVE 'R'             TO S-RULE-RESULT-CD         
                 END-EVALUATE                                           
A03301           IF S-RULE-RESULT-CD > SPACES                           
A03301              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03301           END-IF                                                 
A03301        END-IF.                                                   
      * STA003 - ACCOUNT STATUS                                                 
              MOVE ZEROES                TO S-RETURN-CODE               
A03300        MOVE SPACES                TO S-RULE-RESULT-CD            
              MOVE 'STA003'              TO S-BUS-RULE-ID               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                        MOVE 'G'         TO S-RULE-RESULT-CD            
                 WHEN 'B'                                               
                    IF  AT-ACCT-FINALED-DT > SPACES                     
                        MOVE 'G'         TO S-RULE-RESULT-CD            
                    ELSE                                                
      ** STA024 - FINAL BILL HAS NOT BEEN GENERATED. UNABLE TO SETUP STA        
                        MOVE 'STA024'    TO S-BUS-RULE-ID               
                        MOVE 'R'         TO S-RULE-RESULT-CD            
                    END-IF                                              
                 WHEN OTHER                                             
                    MOVE 'R'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA025 - ACCOUNT WITH CREDIT BALANCE CANNOT BE SETUP ON STA.            
A03300* As STA025 has the same message as STA004, we used STA004.               
A03300        MOVE 'STA004'           TO S-BUS-RULE-ID                  
A03300        MOVE SPACES             TO S-RULE-RESULT-CD               
A03300        IF AT-TOTAL-AR-BALANCE < 0 OR                             
A03300          (WS-DNP-ACT-FLAG = 'Y' AND WS-PENDING-SO-FLAG = 'Y')    
A03300           MOVE 'R'             TO S-RULE-RESULT-CD               
A03300           PERFORM 8010-INSERT-GTT                                
A03300                                THRU 8010-EXIT                    
A03300           MOVE 'Y'             TO WS-STA004-DSP                  
A03300        END-IF.                                                   
                                                                        
      * STA004 - FORECASTED DNP                                                 
A03300        IF AT-CODE-ACCT-STAT = 'A' AND NOT STA004-DSP             
                 MOVE ZEROES                TO S-RETURN-CODE            
                 MOVE 'STA004'              TO S-BUS-RULE-ID            
                 IF WS-NEAREST-DNP-DT > SPACES                          
A03301              IF VO-SERV-ORDER-STATUS < 26                        
                       MOVE 'G'             TO S-RULE-RESULT-CD         
                    END-IF                                              
                 ELSE                                                   
                     IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0         
                        MOVE 'G'            TO S-RULE-RESULT-CD         
                     ELSE                                               
                        MOVE 'R'            TO S-RULE-RESULT-CD         
                     END-IF                                             
                 END-IF                                                 
A03300           IF S-BUS-RULE-ID = 'STA004'                            
A03300              IF STA004-DSP                                       
A03300                 MOVE SPACES TO S-RULE-RESULT-CD                  
A03300              ELSE                                                
A03300                 MOVE 'Y'    TO WS-STA004-DSP                     
A03300              END-IF                                              
A03300           END-IF                                                 
A03300*                                                                         
A03300           IF S-RULE-RESULT-CD > SPACES                           
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300           END-IF                                                 
      ********                                                                  
                 IF WS-PENDING-SO-FLAG = 'Y'                            
      * STA005 - ACTIVE DNP - NOT WORKED                                        
                    MOVE ZEROES                TO S-RETURN-CODE         
                    MOVE 'STA005'              TO S-BUS-RULE-ID         
                    IF WS-DNP-FLAG  = 'Y' AND WS-STA-AMOUNT > 0         
                       IF  EXCPTNL-DNP                                  
                           IF WS-EXCPTNL-MSG = 'Y'                      
                              CONTINUE                                  
                           END-IF                                       
                       ELSE                                             
                           MOVE 'Y'            TO S-RULE-RESULT-CD      
                           PERFORM 8010-INSERT-GTT THRU 8010-EXIT       
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF.                                                   
      * STA008 - EXISTING PAYMENT ARRANGEMENT - STA                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA008'              TO S-BUS-RULE-ID               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA009 - EXISTING PAYMENT ARRANGEMENT - DPP                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA009'              TO S-BUS-RULE-ID               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA011 - EXISTING MEDICAL CERTIFICATE                                   
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA011'              TO S-BUS-RULE-ID               
              IF WS-CODE-MEDICAL = 'A'                                  
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA012 - UNPAID RETURN CHECKS                                           
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA012'              TO S-BUS-RULE-ID               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
                 MOVE 'R'                TO S-RULE-RESULT-CD            
A03301           PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
TASK01* STA018 - DPP COMPLIANCE                                                 
TASK01        MOVE 0                     TO WS-RETURN-CODE              
TASK01                                      S-RETURN-CODE               
TASK01        MOVE 'STA018'              TO S-BUS-RULE-ID               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
TASK01            MOVE 'Y'              TO S-RULE-RESULT-CD             
TASK01            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
TASK01        END-IF                                                    
      * STA020 - COMPLIANCE HISTORY                                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
P0726C        PERFORM 7060-SEL-LAST-ARNG-DT-CMPLNCE   THRU 7060-EXIT    
              PERFORM 7020-SELECT-DPP-COMPLIANCE                        
                 THRU 7020-EXIT                                         
P0726C                                                                  
P0726C           MOVE X1-ARNG-COMPLIANCE-CD  TO ws-STA-ARNG-CMPLD-IND   
P0726C           MOVE WS-LAST-ARNG-DAYS      TO WS-RECENT-STA-DAYS      
P0726C                                                                  
              MOVE 'DAYS-RECNT-ARRNGMT'  TO C8-DELINQ-CD                
              MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
              PERFORM 7005-GET-DELINQ                                   
                 THRU 7005-EXIT                                         
              IF  WS-RECENT-STA-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-STA-DAYS > 0                                
                  MOVE 'Y'                TO WS-RECENT-STA-FL           
              END-IF                                                    
              IF  WS-RECENT-DPP-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-DPP-DAYS > 0                                
                 MOVE 'Y'                TO WS-RECENT-DPP-FL            
              END-IF                                                    
              PERFORM 2160-GET-60-DAY-OLD THRU 2160-EXIT                
              IF WS-AMT-ARREARS-GR-60 > 0                               
              AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)        
ACT017           MOVE 'Y'             TO S-RULE-RESULT-CD               
ACT017           MOVE 'STA021'        TO S-BUS-RULE-ID                  
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              ELSE                                                      
                 PERFORM 2170-GET-30-DAY-OLD THRU 2170-EXIT             
                 IF  WS-AMT-ARREARS-GR-30 > 0                           
                 AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)     
                     MOVE  'Y'           TO S-RULE-RESULT-CD            
ACT017               MOVE 'STA020'       TO S-BUS-RULE-ID               
                     PERFORM 8010-INSERT-GTT THRU 8010-EXIT             
                 END-IF                                                 
              END-IF.                                                   
      * STA027 - ACCOUNT HAS NOT GONE THROUGH INITIAL BILLING.                  
A03300* As STA027 has the same message as STA004, we used STA004.               
              IF AT-REV-MTH-LST-NRML EQUAL ZEROES                       
                 MOVE 'R'                TO S-RULE-RESULT-CD            
A03300           MOVE 'STA004'           TO S-BUS-RULE-ID               
A03300           IF STA004-DSP                                          
A03300              CONTINUE                                            
A03300           ELSE                                                   
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300              MOVE 'Y' TO WS-STA004-DSP                           
A03300           END-IF                                                 
              END-IF.                                                   
                                                                        
              IF AT-CODE-ACCT-STAT = 'B'                                
                IF WS-TOTAL-BALANCE <= 0                                
                  MOVE ZEROES                TO S-RETURN-CODE           
                  MOVE 'STA031'              TO S-BUS-RULE-ID           
                  MOVE 'R'                   TO S-RULE-RESULT-CD        
                  PERFORM 8010-INSERT-GTT    THRU 8010-EXIT             
A03300          ELSE                                                    
A03300* STA035 - NON-ULILITY CHARGES INCLUDED - STA                             
A03300            MOVE ZEROES                TO S-RETURN-CODE           
A03300            MOVE 'STA035'              TO S-BUS-RULE-ID           
A03300            MOVE 'Y'                   TO S-RULE-RESULT-CD        
A03300            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
A03300          END-IF                                                  
              END-IF.                                                   
P00453* STA034 - PRE-PAY-PLAN ACCOUNTS.                                         
P00453        IF WS-CODE-PRE-PAY-PLAN = 'A'                             
P00453           MOVE 0                  TO WS-RETURN-CODE              
P00453                                      S-RETURN-CODE               
P00453           MOVE 'R'                TO S-RULE-RESULT-CD            
P00453           MOVE 'STA034'           TO S-BUS-RULE-ID               
P00453           PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
P00453        END-IF.                                                   
P00453*                                                                         
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2140-SEB-REG-STA-BUS.                                            
              PERFORM 2150-CTMTR-MAJOR-ACCT-CHK THRU 2150-EXIT.         
      * STA002 - ACCOUNT GROUP AND CREDIT GROUP                                 
A03301        IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
A03301           CONTINUE                                               
A03301        ELSE                                                      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 MOVE 'STA002'              TO S-BUS-RULE-ID            
                 EVALUATE AT-CREDIT-GROUP                               
                    WHEN 'A'                                            
                    WHEN 'B'                                            
A03301                 MOVE SPACES          TO S-RULE-RESULT-CD         
A03301              WHEN 'N'                                            
A03301                 MOVE 'STA037'        TO S-BUS-RULE-ID            
A03301                 MOVE 'G'             TO S-RULE-RESULT-CD         
                    WHEN OTHER                                          
                       MOVE 'R'             TO S-RULE-RESULT-CD         
                 END-EVALUATE                                           
A03301           IF S-RULE-RESULT-CD > SPACES                           
A03301              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03301           END-IF                                                 
A03301        END-IF.                                                   
      * STA003 - ACCOUNT STATUS                                                 
              MOVE ZEROES                TO S-RETURN-CODE               
A03301        MOVE SPACES                TO S-RULE-RESULT-CD            
              MOVE 'STA003'              TO S-BUS-RULE-ID               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                        MOVE 'G'         TO S-RULE-RESULT-CD            
                 WHEN 'B'                                               
                    IF  AT-ACCT-FINALED-DT > SPACES                     
                        MOVE 'G'         TO S-RULE-RESULT-CD            
                    ELSE                                                
      ** STA024 - FINAL BILL HAS NOT BEEN GENERATED. UNABLE TO SETUP STA        
                        MOVE 'STA024'    TO S-BUS-RULE-ID               
                        MOVE 'R'         TO S-RULE-RESULT-CD            
                    END-IF                                              
                 WHEN OTHER                                             
                    MOVE 'R'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA025 - ACCOUNT WITH CREDIT BALANCE CANNOT BE SETUP ON STA.            
A03300* As STA025 has the same message as STA004, we used STA004.               
A03300        MOVE 'STA004'           TO S-BUS-RULE-ID                  
A03301        MOVE SPACES             TO S-RULE-RESULT-CD               
A03300        IF AT-TOTAL-AR-BALANCE < 0 OR                             
A03300          (WS-DNP-ACT-FLAG = 'Y' AND WS-PENDING-SO-FLAG = 'Y')    
A03300           MOVE 'R'             TO S-RULE-RESULT-CD               
A03300           PERFORM 8010-INSERT-GTT                                
A03300                                THRU 8010-EXIT                    
A03300           MOVE 'Y'             TO WS-STA004-DSP                  
A03300        END-IF.                                                   
                                                                        
      * STA004 - FORECASTED DNP                                                 
A03300        IF AT-CODE-ACCT-STAT = 'A' AND NOT STA004-DSP             
                 MOVE ZEROES                TO S-RETURN-CODE            
                 MOVE 'STA004'              TO S-BUS-RULE-ID            
                 IF WS-NEAREST-DNP-DT > SPACES                          
A03301              IF VO-SERV-ORDER-STATUS < 26                        
                       MOVE 'G'             TO S-RULE-RESULT-CD         
                    END-IF                                              
                 ELSE                                                   
                     IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0         
                        MOVE 'G'            TO S-RULE-RESULT-CD         
                     ELSE                                               
                        MOVE 'R'            TO S-RULE-RESULT-CD         
                     END-IF                                             
                 END-IF                                                 
A03300           IF S-BUS-RULE-ID = 'STA004'                            
A03300              IF STA004-DSP                                       
A03300                 MOVE SPACES TO S-RULE-RESULT-CD                  
A03300              ELSE                                                
A03300                 MOVE 'Y'    TO WS-STA004-DSP                     
A03300              END-IF                                              
A03300           END-IF                                                 
A03300*                                                                         
A03300           IF S-RULE-RESULT-CD > SPACES                           
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300           END-IF                                                 
A03300*                                                                         
                 IF WS-PENDING-SO-FLAG = 'Y'                            
      * STA005 - ACTIVE DNP - NOT WORKED                                        
                    MOVE ZEROES                TO S-RETURN-CODE         
                    MOVE 'STA005'              TO S-BUS-RULE-ID         
                    IF WS-DNP-FLAG  = 'Y' AND WS-STA-AMOUNT > 0         
                       IF  EXCPTNL-DNP                                  
                           IF WS-EXCPTNL-MSG = 'Y'                      
                              CONTINUE                                  
                           END-IF                                       
                       ELSE                                             
                           MOVE 'Y'            TO S-RULE-RESULT-CD      
                           PERFORM 8010-INSERT-GTT THRU 8010-EXIT       
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF.                                                   
      * STA008 - EXISTING PAYMENT ARRANGEMENT - STA                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA008'              TO S-BUS-RULE-ID               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA009 - EXISTING PAYMENT ARRANGEMENT - DPP                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA009'              TO S-BUS-RULE-ID               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA011 - EXISTING MEDICAL CERTIFICATE                                   
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA011'              TO S-BUS-RULE-ID               
              IF WS-CODE-MEDICAL = 'A'                                  
                 MOVE 'R'                TO S-RULE-RESULT-CD            
              ELSE                                                      
                 MOVE 'G'                TO S-RULE-RESULT-CD            
              END-IF                                                    
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * STA012 - UNPAID RETURN CHECKS                                           
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'STA012'              TO S-BUS-RULE-ID               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
                 MOVE 'R'                TO S-RULE-RESULT-CD            
A03300           PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
TASK01* STA018 - DPP COMPLIANCE                                                 
TASK01        MOVE 0                     TO WS-RETURN-CODE              
TASK01                                      S-RETURN-CODE               
TASK01        MOVE 'STA018'              TO S-BUS-RULE-ID               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
TASK01            MOVE 'Y'              TO S-RULE-RESULT-CD             
TASK01            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
TASK01        END-IF                                                    
      * STA020 - COMPLIANCE HISTORY                                             
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
P0726C        PERFORM 7060-SEL-LAST-ARNG-DT-CMPLNCE   THRU 7060-EXIT    
              PERFORM 7020-SELECT-DPP-COMPLIANCE                        
                 THRU 7020-EXIT                                         
P0726C                                                                  
P0726C           MOVE X1-ARNG-COMPLIANCE-CD  TO ws-STA-ARNG-CMPLD-IND   
P0726C           MOVE WS-LAST-ARNG-DAYS      TO WS-RECENT-STA-DAYS      
P0726C                                                                  
              MOVE 'DAYS-RECNT-ARRNGMT'  TO C8-DELINQ-CD                
              MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
              PERFORM 7005-GET-DELINQ                                   
                 THRU 7005-EXIT                                         
              IF  WS-RECENT-STA-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-STA-DAYS > 0                                
                 MOVE 'Y'                TO WS-RECENT-STA-FL            
              END-IF                                                    
              IF  WS-RECENT-DPP-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-DPP-DAYS > 0                                
                 MOVE 'Y'                TO WS-RECENT-DPP-FL            
              END-IF                                                    
              PERFORM 2160-GET-60-DAY-OLD THRU 2160-EXIT                
              IF WS-AMT-ARREARS-GR-60 > 0                               
              AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)        
ACT017           MOVE 'Y'             TO S-RULE-RESULT-CD               
ACT017           MOVE 'STA021'        TO S-BUS-RULE-ID                  
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              ELSE                                                      
                 PERFORM 2170-GET-30-DAY-OLD THRU 2170-EXIT             
                 IF  WS-AMT-ARREARS-GR-30 > 0                           
                 AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)     
                     MOVE  'Y'           TO S-RULE-RESULT-CD            
ACT017               MOVE 'STA020'       TO S-BUS-RULE-ID               
                     PERFORM 8010-INSERT-GTT THRU 8010-EXIT             
                 END-IF                                                 
              END-IF.                                                   
      * STA027 - ACCOUNT HAS NOT GONE THROUGH INITIAL BILLING.                  
A03300* As STA027 has the same message as STA004, we used STA004.               
              IF AT-REV-MTH-LST-NRML EQUAL ZEROES                       
                 MOVE 'R'                TO S-RULE-RESULT-CD            
A03300           MOVE 'STA004'           TO S-BUS-RULE-ID               
A03300           IF STA004-DSP                                          
A03300              CONTINUE                                            
A03300           ELSE                                                   
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
A03300              MOVE 'Y' TO WS-STA004-DSP                           
A03300           END-IF                                                 
              END-IF.                                                   
                                                                        
              IF AT-CODE-ACCT-STAT = 'B'                                
                IF WS-TOTAL-BALANCE <= 0                                
                  MOVE ZEROES                TO S-RETURN-CODE           
                  MOVE 'STA031'              TO S-BUS-RULE-ID           
                  MOVE 'R'                   TO S-RULE-RESULT-CD        
                  PERFORM 8010-INSERT-GTT    THRU 8010-EXIT             
A03300          ELSE                                                    
A03300* STA035 - NON-ULILITY CHARGES INCLUDED - STA                             
A03300            MOVE ZEROES                TO S-RETURN-CODE           
A03300            MOVE 'STA035'              TO S-BUS-RULE-ID           
A03300            MOVE 'Y'                   TO S-RULE-RESULT-CD        
A03300            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
A03300          END-IF                                                  
              END-IF.                                                   
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2150-CTMTR-MAJOR-ACCT-CHK.                                     *        
      ******************************************************************        
      *                                                                         
       2150-CTMTR-MAJOR-ACCT-CHK.                                       
      *                                                                         
      * STA001 - ACCOUNT TYPE                                                   
              MOVE ZEROES                TO S-RETURN-CODE               
              IF AT-ACCOUNT-TYPE-CODE = 'R' AND                         
                 AT-CT-METER-RATED-IND NOT = 'Y'                        
                  MOVE 'STA001'              TO S-BUS-RULE-ID           
                  MOVE 'G'                   TO S-RULE-RESULT-CD        
                  PERFORM 8010-INSERT-GTT    THRU 8010-EXIT             
              ELSE                                                      
                 MOVE I-USER-ID         TO F5-USER-ID                   
                 PERFORM 7600-SELECT-CATEGORY-ID THRU 7600-EXIT         
                 IF WS-CATEGORY-CD = 'N'                                
                    IF AT-CODE-MAJOR-ACCT = 'Y'                         
                       MOVE 'STA022'             TO S-BUS-RULE-ID       
                       MOVE 'R'                  TO S-RULE-RESULT-CD    
                       PERFORM 8010-INSERT-GTT   THRU 8010-EXIT         
                    ELSE                                                
                       IF AT-CT-METER-RATED-IND = 'Y'                   
                          MOVE  AT-COMPANY-NO        TO C8-COMPANY-NO   
                          MOVE 'AMT-STA-CTMTR-LMT'     TO C8-DELINQ-CD  
                          PERFORM 7005-GET-DELINQ THRU 7005-EXIT        
                          MOVE C8-DELINQ-VALUE      TO WS-STA-CTMTR-LMT 
                          IF WS-STA-AMOUNT          <= WS-STA-CTMTR-LMT 
                             MOVE 'STA028'          TO S-BUS-RULE-ID    
                             MOVE 'Y'               TO S-RULE-RESULT-CD 
                          ELSE                                          
                             MOVE 'STA029'          TO S-BUS-RULE-ID    
                             MOVE 'R'               TO S-RULE-RESULT-CD 
                          END-IF                                        
                          PERFORM 8010-INSERT-GTT   THRU 8010-EXIT      
                       ELSE                                             
                          IF AT-ACCOUNT-TYPE-CODE = 'C'                 
                             MOVE 'STA001'          TO S-BUS-RULE-ID    
                             MOVE 'Y'               TO S-RULE-RESULT-CD 
                          ELSE                                          
                             MOVE 'STA001'          TO S-BUS-RULE-ID    
                             MOVE 'R'               TO S-RULE-RESULT-CD 
                          END-IF                                        
                          PERFORM 8010-INSERT-GTT   THRU 8010-EXIT      
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF.                                                   
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2160-GET-60-DAY-OLD.                                             
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-DAYS-60 > 60                                      
                COMPUTE WS-AMT-ARREARS-UTL =                            
                      (WS-AMT-60-DAY-UTL + WS-AMT-90-DAY-UTL            
                      + WS-AMT-30-DAY-NSA)                              
              WHEN WS-DAYS-90 > 60                                      
                COMPUTE WS-AMT-ARREARS-UTL       =  (WS-AMT-90-DAY-UTL  
                                           + WS-AMT-30-DAY-NSA          
                                           + WS-AMT-60-DAY-NSA)         
           END-EVALUATE.                                                
           COMPUTE WS-AMT-ARREARS-GR-60 = WS-AMT-ARREARS-UTL.           
      *                                                                         
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2170-GET-30-DAY-OLD.                                             
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-DAYS-30 > 30                                      
                COMPUTE WS-AMT-ARREARS-UTL =                            
                     (WS-AMT-30-DAY-UTL +                               
                      WS-AMT-60-DAY-UTL + WS-AMT-90-DAY-UTL             
                     + WS-AMT-00-DAY-NSA)                               
              WHEN WS-DAYS-60 > 30                                      
                COMPUTE WS-AMT-ARREARS-UTL =                            
                   (WS-AMT-60-DAY-UTL + WS-AMT-90-DAY-UTL               
                   + WS-AMT-30-DAY-NSA)                                 
              WHEN WS-DAYS-90 > 30                                      
                COMPUTE WS-AMT-ARREARS-UTL        =  (WS-AMT-90-DAY-UTL 
                                      + WS-AMT-30-DAY-NSA               
                                      + WS-AMT-60-DAY-NSA)              
           END-EVALUATE                                                 
           COMPUTE WS-AMT-ARREARS-GR-30 = WS-AMT-ARREARS-UTL.           
      *                                                                         
       2170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2180-GET-NEXT-READ-DATE.                                         
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'A'                                   
               PERFORM 5901-NEXT-READ-DATE                              
                  THRU 5901-NEXT-READ-DATE-EXIT                         
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF RW-THIRD-PTY-READ-DT > SPACES                      
                     MOVE RW-THIRD-PTY-READ-DT TO WS-NEXT-READ-DATE     
                  ELSE                                                  
                     MOVE RW-OPTIMUM-READ-DATE TO WS-NEXT-READ-DATE     
                  END-IF                                                
               ELSE                                                     
                  MOVE SPACES            TO WS-NEXT-READ-DATE           
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES TO WS-NEXT-READ-DATE                         
           END-IF.                                                      
      *                                                                         
       2180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2190-CHECK-DNP-SCND-NOTICE.                                      
      *                                                                         
           IF WS-DNP-FLAG = 'Y'                                         
           OR WS-NEAREST-DNP-DT > SPACES                                
              PERFORM 2180-GET-NEXT-READ-DATE                           
                 THRU 2180-EXIT                                         
              IF WS-NEXT-READ-DATE > SPACES                             
                 IF WS-PSNC                                             
                    MOVE WS-DAY-DUE-CD      TO C8-DELINQ-CD             
                    MOVE AT-COMPANY-NO      TO C8-COMPANY-NO            
                    PERFORM 7005-GET-DELINQ THRU 7005-EXIT              
                    MOVE C8-DELINQ-VALUE    TO WS-DAY-DUE               
                    MOVE WS-NEXT-READ-DATE  TO WS-NEW-BUSINESS-DAY      
                    PERFORM WS-DAY-DUE TIMES                            
                        MOVE 'N' TO WS-NEXT-BUSINESS-DAY                
                        PERFORM 6500-GET-NEXT-BUSINESS-DAY              
                           THRU 6500-NEXT-BUSINESS-DAY-EXIT             
                          UNTIL NEXT-BUSINESS-DAY-FOUND                 
                    END-PERFORM                                         
                    MOVE WS-NEW-BUSINESS-DAY TO WS-STA-DNP-DT           
                 ELSE                                                   
                    MOVE WS-NEXT-READ-DATE   TO WS-STA-DNP-DT           
                 END-IF                                                 
                 PERFORM 2195-GET-SCND-NOTC-DT                          
                    THRU 2195-EXIT                                      
                 IF WS-PSNC AND WS-STA-SCND-NOTC-DT > SPACES            
                    IF WS-STA-SCND-NOTC-DT <= WS-CURRENT-DATE           
                    AND WS-STA-SCND-NOTC-DT < WS-STA-DNP-DT             
                        MOVE 'STA032'       TO S-BUS-RULE-ID            
                        MOVE 'Y'           TO S-RULE-RESULT-CD          
                      PERFORM 8010-INSERT-GTT THRU 8010-EXIT            
                    END-IF                                              
                 END-IF                                                 
                 IF  WS-SCEG                                            
                     IF (WS-STA-SCND-NOTC-DT <= WS-CURRENT-DATE         
                     AND WS-STA-SCND-NOTC-DT < WS-STA-DNP-DT            
                     AND WS-STA-SCND-NOTC-DT > SPACES )                 
                     OR (WS-STA-DNP-DT = WS-NEAREST-DNP-DT)             
                     MOVE 'STA033'       TO S-BUS-RULE-ID               
                     MOVE 'R'            TO S-RULE-RESULT-CD            
                     PERFORM 8010-INSERT-GTT THRU 8010-EXIT             
                 END-IF                                                 
              END-IF                                                    
           END-IF
           END-IF.                                                      
      *                                                                         
       2190-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
       2195-GET-SCND-NOTC-DT.                                           
      *                                                                         
           MOVE WS-STA-DNP-DT TO WS-NEW-BUSINESS-DAY                    
           PERFORM WS-DAY-STA-SECOND-MAIL TIMES                         
           MOVE 'N'    TO WS-PREV-BUS-DAY-FLAG                          
           PERFORM 6525-PREV-BUSINESS-DAY                               
              THRU 6525-PREV-BUSINESS-DAY-EXIT                          
             UNTIL PREV-BUS-DAY-FOUND                                   
           END-PERFORM                                                  
           MOVE WS-NEW-BUSINESS-DAY       TO WS-STA-SCND-NOTC-DT.       
      *                                                                         
       2195-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GETS DPP BUSINESS RULES/CRITERIA.                              *        
      ******************************************************************        
       2200-GET-DPP-BUS-RULES.                                          
                                                                        
A04527*    GET DPP SEASONAL FLAG.                                               
A04527     IF SEB-DATABASE                                              
A04527        PERFORM 2315-GET-SEAS-DPP-DATES                           
A04527           THRU 2315-EXIT                                         
A04527     END-IF.                                                      
P0726F     MOVE 'DPP '          TO S-ARNG-TYPE.                         
           EVALUATE TRUE ALSO TRUE                                      
              WHEN CSR-DATABASE ALSO WS-SCEG                            
                  PERFORM 2210-SCEG-DPP-BUS                             
                     THRU 2210-EXIT                                     
              WHEN CSR-DATABASE ALSO WS-PSNC                            
                  PERFORM 2220-PSNC-DPP-BUS                             
                     THRU 2220-EXIT                                     
              WHEN SEB-DATABASE ALSO WS-DEREG                           
                  PERFORM 2230-SEB-DREG-DPP-BUS                         
                     THRU 2230-EXIT                                     
              WHEN SEB-DATABASE ALSO WS-REG                             
                  PERFORM 2240-SEB-REG-DPP-BUS                          
                     THRU 2240-EXIT                                     
           END-EVALUATE.                                                
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2210-SCEG-DPP-BUS.                                               
      * ACCOUNT TYPE VALIDATION                                                 
              PERFORM 2400-ACCT-TYPE-CD-CHK THRU 2400-EXIT.             
      * CREDIT GROUP VALIDATION                                                 
              IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 EVALUATE AT-CREDIT-GROUP                               
                    WHEN 'B'                                            
                    WHEN 'A'                                            
                    WHEN 'N'                                            
                       MOVE 'CRDARNG021'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'P'             TO S-RULE-RESULT-CD         
                    WHEN 'C'                                            
                       MOVE 'CRDARNG204'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                    WHEN OTHER                                          
                       MOVE 'CRDARNG204'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                 END-EVALUATE                                           
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF.                                                   
      * ACCOUNT STATUS VALIDATION                                               
              MOVE ZEROES                TO S-RETURN-CODE               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                    MOVE 'CRDARNG205'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                 WHEN OTHER                                             
                    MOVE 'CRDARNG206'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * DNP                                                                     
              IF WS-PENDING-SO-FLAG = 'Y'                               
      * ACTIVE DNP - NOT WORKED                                                 
                 MOVE ZEROES             TO S-RETURN-CODE               
                 IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0             
D03409              EVALUATE TRUE                                       
D03409               WHEN VO-SERV-ORDER-STATUS < 26                     
D03409                    MOVE 'CRDARNG034'    TO S-BUS-RULE-ID         
D03409                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD 
D03409                    MOVE 'P'             TO S-RULE-RESULT-CD      
D03409                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT        
D03409               WHEN VO-SERV-ORDER-STATUS = 26                     
D03409                    MOVE 'CRDARNG033'    TO S-BUS-RULE-ID         
D03409                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD 
D03409                    MOVE 'P'             TO S-RULE-RESULT-CD      
D03409                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT        
D03409               WHEN VO-SERV-ORDER-STATUS >= 30                    
D03409                    MOVE 'CRDARNG108'    TO S-BUS-RULE-ID         
D03409                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD 
D03409                    MOVE 'P'             TO S-RULE-RESULT-CD      
D03409                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT        
D03409              END-EVALUATE                                        
      * ACTIVE DNP - WORKED                                                     
                 ELSE                                                   
                    MOVE ZEROES         TO S-RETURN-CODE                
                    IF WS-DNP-ACT-FLAG = 'Y'                            
                       MOVE 'CRDARNG209'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                       PERFORM 8010-INSERT-GTT THRU 8010-EXIT           
                    END-IF                                              
                 END-IF                                                 
              END-IF.                                                   
      * EXISTING PAYMENT ARRANGEMENT - DPP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'CRDARNG212'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - BBP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-BUDGET = 'A'                                   
                 MOVE 'CRDARNG213'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * CONTRACT AMOUNT GREATER THAN $25                                        
                                                                        
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              PERFORM 7050-SELECT-DPP-RECV THRU 7050-EXIT               
              IF WS-DPP-CONTRACT-AMT > 25                               
                 MOVE 'CRDARNG214'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'P'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT      THRU 8010-EXIT            
              ELSE                                                      
                 IF WS-CODE-DPP-ACCT NOT EQUAL 'A'                      
                 AND WS-CODE-BUDGET NOT EQUAL 'A'                       
                     MOVE 'CRDARNG215'          TO S-BUS-RULE-ID        
                     MOVE 'A'                   TO S-RULE-NOTIFY-TYPE-CD
                     MOVE 'F'                   TO S-RULE-RESULT-CD     
                     PERFORM 8010-INSERT-GTT      THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * UNPAID DEPOSIT ON ACCOUNT                                               
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'N'                   TO WS-UNPAID-DEPOSIT           
              PERFORM 7210-SELECT-DEP-ON-HAND                           
                 THRU 7210-EXIT                                         
              IF WS-UNPAID-DEPOSIT = 'Y'                                
P0726G           MOVE 'CRDARNG225'          TO S-BUS-RULE-ID            
P0726G           MOVE 'P'                   TO S-RULE-NOTIFY-TYPE-CD    
                 MOVE 'P'                   TO S-RULE-RESULT-CD         
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * UNPAID RETURN CHECKS                                                    
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
                 MOVE 'CRDARNG217'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'P'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
P0726D* DPP COMPLIANCE                                                          
TASK01        MOVE 0                     TO WS-RETURN-CODE              
TASK01                                      S-RETURN-CODE               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
                  MOVE 'CRDARNG038'       TO S-BUS-RULE-ID              
                  MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD      
                  MOVE 'P'                TO S-RULE-RESULT-CD           
TASK01            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
TASK01        END-IF.                                                   
P0726F* verbal notification message about the CUT                               
P0726F        IF WS-DNP-MINUS-DELINQ-DT <= WS-CURRENT-DATE              
P0726F           MOVE 'CRDARNG040'        TO S-BUS-RULE-ID              
P0726F           MOVE 'P'                 TO S-RULE-NOTIFY-TYPE-CD      
P0726F           MOVE 'P'                 TO S-RULE-RESULT-CD           
P0726F           PERFORM 8010-INSERT-GTT  THRU 8010-EXIT                
P0726F        END-IF.                                                   
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       2220-PSNC-DPP-BUS.                                               
      * ACCOUNT TYPE                                                            
              PERFORM 2400-ACCT-TYPE-CD-CHK THRU 2400-EXIT.             
      * CREDIT GROUP                                                            
              IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 EVALUATE AT-CREDIT-GROUP                               
                    WHEN 'A'                                            
                    WHEN 'N'                                            
                       MOVE 'CRDARNG021'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'P'             TO S-RULE-RESULT-CD         
                    WHEN 'C'                                            
                       MOVE 'CRDARNG204'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                    WHEN OTHER                                          
                       MOVE 'CRDARNG204'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                 END-EVALUATE                                           
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF.                                                   
                                                                        
      * ACCOUNT STATUS VALIDATION                                               
              MOVE ZEROES                TO S-RETURN-CODE               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                    MOVE 'CRDARNG205'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                 WHEN OTHER                                             
                    MOVE 'CRDARNG206'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * DNP                                                                     
              IF WS-PENDING-SO-FLAG = 'Y'                               
      * ACTIVE DNP - NOT WORKED                                                 
                 MOVE ZEROES             TO S-RETURN-CODE               
                 IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0             
D03409              EVALUATE TRUE                                       
D03409               WHEN VO-SERV-ORDER-STATUS < 26                     
D03409                    MOVE 'CRDARNG034'    TO S-BUS-RULE-ID         
D03409                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD 
D03409                    MOVE 'P'             TO S-RULE-RESULT-CD      
D03409                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT        
D03409               WHEN VO-SERV-ORDER-STATUS = 26                     
D03409                    MOVE 'CRDARNG033'    TO S-BUS-RULE-ID         
D03409                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD 
D03409                    MOVE 'P'             TO S-RULE-RESULT-CD      
D03409                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT        
D03409               WHEN VO-SERV-ORDER-STATUS >= 30                    
D03409                    MOVE 'CRDARNG108'    TO S-BUS-RULE-ID         
D03409                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD 
D03409                    MOVE 'P'             TO S-RULE-RESULT-CD      
D03409                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT        
D03409              END-EVALUATE                                        
      * ACTIVE DNP - WORKED                                                     
                 ELSE                                                   
                    MOVE ZEROES         TO S-RETURN-CODE                
                    IF WS-DNP-ACT-FLAG = 'Y'                            
                       MOVE 'CRDARNG209'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                       PERFORM 8010-INSERT-GTT THRU 8010-EXIT           
                    END-IF                                              
                 END-IF                                                 
              END-IF.                                                   
      * EXISTING PAYMENT ARRANGEMENT - DPP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'CRDARNG212'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - BBP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-BUDGET = 'A'                                   
                 MOVE 'CRDARNG213'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * CONTRACT AMOUNT GREATER THAN $25                                        
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              PERFORM 7050-SELECT-DPP-RECV THRU 7050-EXIT               
              IF WS-DPP-CONTRACT-AMT > 25                               
                 MOVE 'CRDARNG214'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'P'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT      THRU 8010-EXIT            
              ELSE                                                      
                  IF WS-CODE-DPP-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-BUDGET NOT EQUAL 'A'                       
                     MOVE 'CRDARNG215'          TO S-BUS-RULE-ID        
                     MOVE 'A'                   TO S-RULE-NOTIFY-TYPE-CD
                     MOVE 'F'                TO S-RULE-RESULT-CD        
                     PERFORM 8010-INSERT-GTT      THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * UNPAID DEPOSIT ON ACCOUNT                                               
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              MOVE 'N'                   TO WS-UNPAID-DEPOSIT           
              PERFORM 7210-SELECT-DEP-ON-HAND                           
                 THRU 7210-EXIT                                         
              IF WS-UNPAID-DEPOSIT = 'Y'                                
P0726G           MOVE 'CRDARNG225'          TO S-BUS-RULE-ID            
P0726G           MOVE 'P'                   TO S-RULE-NOTIFY-TYPE-CD    
                 MOVE 'P'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * UNPAID RETURN CHECKS                                                    
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
                 MOVE 'CRDARNG217'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'P'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * STA COMPLIANCE                                                          
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
P0726C        PERFORM 7060-SEL-LAST-ARNG-DT-CMPLNCE THRU 7060-EXIT      
P0762C                                                                  
P0726C           MOVE X1-ARNG-COMPLIANCE-CD  TO ws-STA-ARNG-CMPLD-IND   
P0762C                                                                  
P0726C        IF ws-STA-ARNG-CMPLD-IND = 'N' OR SPACES                  
                 MOVE 'CRDARNG061'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'P'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * DPP COMPLIANCE                                                          
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
                  MOVE 'CRDARNG038'       TO S-BUS-RULE-ID              
                  MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD      
                  MOVE 'P'                TO S-RULE-RESULT-CD           
                  PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
              END-IF                                                    
      * BBP COMPLIANCE                                                          
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              PERFORM 7030-SELECT-BBP-COMPLIANCE                        
                 THRU 7030-EXIT                                         
      *                                                                         
              MOVE BH-BUD-HIST-SEQ-NO(1:10) TO WS-BUD-HIST-DT.          
      *                                                                         
              IF  BH-CHANGE-REASON = 'D'                                
              AND BH-REMARKS-TEXT(1:BH-REMARKS-LEN)                     
                                  = 'AUTOMATICALLY DROPPED FROM EPP'    
              AND WS-BUD-HIST-DT > WS-3MNTHS-CHK-DT                     
                  MOVE 'CRDARNG062'       TO S-BUS-RULE-ID              
                  MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD      
                  MOVE 'P'                TO S-RULE-RESULT-CD           
                  PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
              END-IF.                                                   
P0726F* verbal notification message about the CUT                               
P0726F        IF WS-DNP-MINUS-DELINQ-DT <= WS-CURRENT-DATE              
P0726F           MOVE 'CRDARNG040'        TO S-BUS-RULE-ID              
P0726F           MOVE 'P'                 TO S-RULE-NOTIFY-TYPE-CD      
P0726F           MOVE 'P'                 TO S-RULE-RESULT-CD           
P0726F           PERFORM 8010-INSERT-GTT  THRU 8010-EXIT                
P0726F        END-IF.                                                   
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       2230-SEB-DREG-DPP-BUS.                                           
      * ACCOUNT TYPE                                                            
              MOVE ZEROES                TO S-RETURN-CODE               
P0726D        MOVE SPACES                TO S-BUS-RULE-ID               
              EVALUATE TRUE                                             
                 WHEN AT-ACCOUNT-TYPE-CODE = 'R'                        
                    MOVE 'CRDARNG020'       TO S-BUS-RULE-ID            
                    MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD    
                    MOVE 'P'                TO S-RULE-RESULT-CD         
                 WHEN AT-ACCOUNT-TYPE-CODE = 'C'                        
                 WHEN AT-ACCOUNT-TYPE-CODE = 'I'                        
                    MOVE 'CRDARNG031'       TO S-BUS-RULE-ID            
                    MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD    
                    MOVE 'P'                TO S-RULE-RESULT-CD         
                 WHEN OTHER                                             
P0726D              MOVE SPACES             TO S-BUS-RULE-ID            
              END-EVALUATE.                                             
                                                                        
P0726D        IF S-BUS-RULE-ID > SPACES                                 
P0726D           PERFORM 8010-INSERT-GTT       THRU 8010-EXIT           
P0726D        END-IF.                                                   
                                                                        
      * CREDIT GROUP                                                            
P0726D        MOVE SPACES                TO S-BUS-RULE-ID               
              IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 EVALUATE AT-CREDIT-GROUP                               
                    WHEN 'A'                                            
                       MOVE 'CRDARNG223'       TO S-BUS-RULE-ID         
                       MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD 
                       MOVE 'P'                TO S-RULE-RESULT-CD      
                    WHEN 'N'                                            
                       MOVE 'CRDARNG056'       TO S-BUS-RULE-ID         
                       MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD 
                       MOVE 'P'                TO S-RULE-RESULT-CD      
                    WHEN 'C'                                            
                       MOVE 'CRDARNG042'       TO S-BUS-RULE-ID         
                       MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD 
                       MOVE 'F'                TO S-RULE-RESULT-CD      
                    WHEN 'B'                                            
P0726D                 MOVE SPACES             TO S-BUS-RULE-ID         
                    WHEN OTHER                                          
                       MOVE 'CRDARNG042'       TO S-BUS-RULE-ID         
                       MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD 
                       MOVE 'F'                TO S-RULE-RESULT-CD      
                 END-EVALUATE                                           
P0726D           IF S-BUS-RULE-ID    > SPACES                           
P00453              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
P00453           END-IF                                                 
              END-IF.                                                   
      * ACCOUNT STATUS                                                          
              MOVE ZEROES                TO S-RETURN-CODE               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                    MOVE 'CRDARNG205'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                 WHEN OTHER                                             
                    MOVE 'CRDARNG206'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * DNP                                                                     
              IF WS-PENDING-SO-FLAG = 'Y'                               
      * ACTIVE DNP - NOT WORKED                                                 
                 MOVE ZEROES             TO S-RETURN-CODE               
                 IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0             
                    MOVE 'CRDARNG033'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
                 ELSE                                                   
      * ACTIVE DNP - WORKED                                                     
                   MOVE ZEROES           TO S-RETURN-CODE               
                   IF WS-DNP-ACT-FLAG = 'Y'                             
                      MOVE 'CRDARNG209'    TO S-BUS-RULE-ID             
                      MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD     
                      MOVE 'F'             TO S-RULE-RESULT-CD          
                      PERFORM 8010-INSERT-GTT THRU 8010-EXIT            
                   END-IF                                               
                 END-IF                                                 
              END-IF.                                                   
      * EXISTING PAYMENT ARRANGEMENT - STA                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'CRDARNG211'    TO S-BUS-RULE-ID                  
                 MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD          
                 MOVE 'F'             TO S-RULE-RESULT-CD               
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - DPP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'CRDARNG212'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - BBP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-BUDGET = 'A'                                   
                 MOVE 'CRDARNG213'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * CONTRACT AMOUNT GREATER THAN $25                                        
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              PERFORM 7050-SELECT-DPP-RECV THRU 7050-EXIT               
              IF WS-DPP-CONTRACT-AMT > 25                               
                 MOVE 'CRDARNG214'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'P'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT      THRU 8010-EXIT            
              ELSE                                                      
                 IF  WS-CODE-STA-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-DPP-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-BUDGET NOT EQUAL 'A'                       
                     MOVE 'CRDARNG215'   TO S-BUS-RULE-ID               
                     MOVE 'A'            TO S-RULE-NOTIFY-TYPE-CD       
                     MOVE 'F'                TO S-RULE-RESULT-CD        
                     PERFORM 8010-INSERT-GTT      THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * UNPAID RETURN CHECKS                                                    
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
A04527           IF WS-DPP-SEAS = 'Y'                                   
                    MOVE 'CRDARNG201'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
A04527           ELSE                                                   
                    MOVE 'CRDARNG047'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'             TO S-RULE-RESULT-CD            
A04527           END-IF                                                 
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
TASK01* DPP COMPLIANCE                                                          
TASK01        MOVE 0                     TO WS-RETURN-CODE              
TASK01                                      S-RETURN-CODE               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
                  MOVE 'CRDARNG038'       TO S-BUS-RULE-ID              
                  MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD      
                  MOVE 'P'                TO S-RULE-RESULT-CD           
TASK01            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
TASK01        END-IF                                                    
      * COMPLIANCE HISTORY                                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
P0726C        PERFORM 7060-SEL-LAST-ARNG-DT-CMPLNCE   THRU 7060-EXIT    
              PERFORM 7020-SELECT-DPP-COMPLIANCE                        
                 THRU 7020-EXIT                                         
P0726C                                                                  
P0726C           MOVE X1-ARNG-COMPLIANCE-CD  TO ws-STA-ARNG-CMPLD-IND   
P0726C           MOVE WS-LAST-ARNG-DAYS      TO WS-RECENT-STA-DAYS      
P0726C                                                                  
              MOVE 'DAYS-RECNT-ARRNGMT'  TO C8-DELINQ-CD                
              MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
              PERFORM 7005-GET-DELINQ                                   
                 THRU 7005-EXIT                                         
              IF  WS-RECENT-STA-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-STA-DAYS > 0                                
                  MOVE 'Y'                TO WS-RECENT-STA-FL           
              END-IF                                                    
              IF  WS-RECENT-DPP-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-DPP-DAYS > 0                                
                  MOVE 'Y'                TO WS-RECENT-DPP-FL           
              END-IF                                                    
              PERFORM 2160-GET-60-DAY-OLD THRU 2160-EXIT                
              IF WS-AMT-ARREARS-GR-60 > 0                               
              AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)        
                 MOVE 'CRDARNG058'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              ELSE                                                      
                 PERFORM 2170-GET-30-DAY-OLD THRU 2170-EXIT             
                 IF  WS-AMT-ARREARS-GR-30 > 0                           
                 AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)     
                     MOVE 'A'            TO S-RULE-NOTIFY-TYPE-CD       
ACT017               MOVE 'CRDARNG057'   TO S-BUS-RULE-ID               
                     MOVE 'P'            TO S-RULE-RESULT-CD            
                     PERFORM 8010-INSERT-GTT THRU 8010-EXIT             
                 END-IF                                                 
              END-IF.                                                   
P00453* PRE-PAY-PLAN ACCOUNTS.                                                  
P00453        IF WS-CODE-PRE-PAY-PLAN = 'A'                             
P00453           MOVE 0                  TO WS-RETURN-CODE              
P00453                                      S-RETURN-CODE               
                 MOVE 'CRDARNG216'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
P00453           PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
P00453        END-IF.                                                   
P00453*                                                                         
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       2240-SEB-REG-DPP-BUS.                                            
      * ACCOUNT TYPE                                                            
              MOVE ZEROES                TO S-RETURN-CODE               
              EVALUATE TRUE                                             
                 WHEN AT-ACCOUNT-TYPE-CODE = 'R'                        
                    MOVE 'CRDARNG020'       TO S-BUS-RULE-ID            
                    MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD    
                    MOVE 'P'                TO S-RULE-RESULT-CD         
                 WHEN AT-ACCOUNT-TYPE-CODE = 'C'                        
                 WHEN AT-ACCOUNT-TYPE-CODE = 'I'                        
                    MOVE 'CRDARNG031'       TO S-BUS-RULE-ID            
                    MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD    
                    MOVE 'P'                TO S-RULE-RESULT-CD         
                 WHEN OTHER                                             
                    MOVE 'CRDARNG221'       TO S-BUS-RULE-ID            
                    MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD    
                    MOVE 'F'                TO S-RULE-RESULT-CD         
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * CREDIT GROUP                                                            
              IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE ZEROES                TO S-RETURN-CODE            
                 EVALUATE AT-CREDIT-GROUP                               
                    WHEN 'A'                                            
                       MOVE 'CRDARNG223'       TO S-BUS-RULE-ID         
                       MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD 
                       MOVE 'P'                TO S-RULE-RESULT-CD      
                    WHEN 'B'                                            
                       MOVE 'CRDARNG224'       TO S-BUS-RULE-ID         
                       MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD 
                       MOVE 'P'                TO S-RULE-RESULT-CD      
                    WHEN OTHER                                          
                       MOVE 'CRDARNG042'       TO S-BUS-RULE-ID         
                       MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD 
                       MOVE 'F'                TO S-RULE-RESULT-CD      
                 END-EVALUATE                                           
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF.                                                   
      * ACCOUNT STATUS                                                          
              MOVE ZEROES                TO S-RETURN-CODE               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                    MOVE 'CRDARNG205'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                 WHEN OTHER                                             
                    MOVE 'CRDARNG206'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * DNP                                                                     
              IF WS-PENDING-SO-FLAG = 'Y'                               
      * ACTIVE DNP - NOT WORKED                                                 
                 MOVE ZEROES             TO S-RETURN-CODE               
                 IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0             
                    MOVE 'CRDARNG033'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
                 ELSE                                                   
      * ACTIVE DNP - WORKED                                                     
                   MOVE ZEROES           TO S-RETURN-CODE               
                   IF WS-DNP-ACT-FLAG = 'Y'                             
                      MOVE 'CRDARNG209'    TO S-BUS-RULE-ID             
                      MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD     
                      MOVE 'F'             TO S-RULE-RESULT-CD          
                      PERFORM 8010-INSERT-GTT THRU 8010-EXIT            
                   END-IF                                               
                 END-IF                                                 
              END-IF.                                                   
      * EXISTING PAYMENT ARRANGEMENT - STA                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'CRDARNG211'    TO S-BUS-RULE-ID                  
                 MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD          
                 MOVE 'F'             TO S-RULE-RESULT-CD               
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - DPP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'CRDARNG212'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'             TO S-RULE-RESULT-CD               
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - BPP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-BUDGET = 'A'                                   
                 MOVE 'CRDARNG213'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'             TO S-RULE-RESULT-CD               
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * CONTRACT AMOUNT GREATER THAN $25                                        
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              PERFORM 7050-SELECT-DPP-RECV THRU 7050-EXIT               
              IF WS-DPP-CONTRACT-AMT > 25                               
                 MOVE 'CRDARNG214'            TO S-BUS-RULE-ID          
                 MOVE 'A'                     TO S-RULE-NOTIFY-TYPE-CD  
                 MOVE 'P'                     TO S-RULE-RESULT-CD       
                 PERFORM 8010-INSERT-GTT      THRU 8010-EXIT            
              ELSE                                                      
                 IF  WS-CODE-STA-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-DPP-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-BUDGET NOT EQUAL 'A'                       
                     MOVE 'CRDARNG215'          TO S-BUS-RULE-ID        
                     MOVE 'A'                   TO S-RULE-NOTIFY-TYPE-CD
                     MOVE 'F'                   TO S-RULE-RESULT-CD     
                     PERFORM 8010-INSERT-GTT      THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * UNPAID RETURN CHECKS                                                    
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              COMPUTE WS-AMT-NSA =  WS-AMT-00-DAY-NSA                   
                                 +  WS-AMT-30-DAY-NSA                   
                                 +  WS-AMT-60-DAY-NSA                   
                                 +  WS-AMT-90-DAY-NSA                   
              IF WS-AMT-NSA > ZEROES                                    
A04527           IF WS-DPP-SEAS = 'Y'                                   
                    MOVE 'CRDARNG201'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
A04527           ELSE                                                   
                    MOVE 'CRDARNG047'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'             TO S-RULE-RESULT-CD            
A04527           END-IF                                                 
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
TASK01* DPP COMPLIANCE                                                          
TASK01        MOVE 0                     TO WS-RETURN-CODE              
TASK01                                      S-RETURN-CODE               
TASK01        PERFORM 7025-CHK-DPP-DROP  THRU 7025-EXIT                 
TASK01        IF  WS-DPP-DROP-EXISTS = 'Y'                              
                  MOVE 'CRDARNG038'    TO S-BUS-RULE-ID                 
                  MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD         
                  MOVE 'P'             TO S-RULE-RESULT-CD              
TASK01            PERFORM 8010-INSERT-GTT THRU 8010-EXIT                
TASK01        END-IF                                                    
      * COMPLIANCE HISTORY                                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
P0726C        PERFORM 7060-SEL-LAST-ARNG-DT-CMPLNCE   THRU 7060-EXIT    
              PERFORM 7020-SELECT-DPP-COMPLIANCE                        
                 THRU 7020-EXIT                                         
P0726C                                                                  
P0726C           MOVE X1-ARNG-COMPLIANCE-CD  TO ws-STA-ARNG-CMPLD-IND   
P0726C           MOVE WS-LAST-ARNG-DAYS      TO WS-RECENT-STA-DAYS      
P0726C                                                                  
              MOVE 'DAYS-RECNT-ARRNGMT'  TO C8-DELINQ-CD                
              MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
              PERFORM 7005-GET-DELINQ                                   
                 THRU 7005-EXIT                                         
              IF  WS-RECENT-STA-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-STA-DAYS > 0                                
                  MOVE 'Y'                TO WS-RECENT-STA-FL           
              END-IF                                                    
              IF  WS-RECENT-DPP-DAYS <= C8-DELINQ-VALUE                 
              AND WS-RECENT-DPP-DAYS > 0                                
                  MOVE 'Y'                TO WS-RECENT-DPP-FL           
              END-IF                                                    
              PERFORM 2160-GET-60-DAY-OLD THRU 2160-EXIT                
              IF WS-AMT-ARREARS-GR-60 > 0                               
              AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)        
                 MOVE 'CRDARNG058'    TO S-BUS-RULE-ID                  
                 MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD          
                 MOVE 'P'             TO S-RULE-RESULT-CD               
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              ELSE                                                      
                 PERFORM 2170-GET-30-DAY-OLD THRU 2170-EXIT             
                 IF  WS-AMT-ARREARS-GR-30 > 0                           
                 AND (WS-RECENT-STA-EXISTS OR WS-RECENT-DPP-EXISTS)     
                     MOVE 'CRDARNG057'   TO S-BUS-RULE-ID               
                     MOVE 'A'            TO S-RULE-NOTIFY-TYPE-CD       
                     MOVE 'P'            TO S-RULE-RESULT-CD            
                     PERFORM 8010-INSERT-GTT THRU 8010-EXIT             
                 END-IF                                                 
              END-IF.                                                   
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETS SEASONAL DPP BUSINESS RULES/CRITERIA.                     *        
      ******************************************************************        
       2300-GET-SEAS-DPP-BUS-RULES.                                     
      *                                                                         
P0726E      MOVE WS-CREDIT-ACTION-FL   TO S-CREDIT-ACTION-FL.           
P0726D      MOVE 'SDPP'                TO S-ARNG-TYPE.                  
P00726      MOVE 'Y'                   TO S-SEASONAL-FLAG.              
      * CHECK IF IT IS SEASON TO OFFER SDPP.                                    
A03301     PERFORM 2315-GET-SEAS-DPP-DATES                              
A03301        THRU 2315-EXIT.                                           
PRDFIX      MOVE ZEROES                TO S-RETURN-CODE                 
PRDFIX      IF WS-DPP-SEAS = 'Y'                                        
               CONTINUE                                                 
PRDFIX      ELSE                                                        
               MOVE 'CRDARNG222'   TO S-BUS-RULE-ID                     
               MOVE 'A'            TO S-RULE-NOTIFY-TYPE-CD             
               MOVE 'F'            TO S-RULE-RESULT-CD                  
P0726E         PERFORM 8010-INSERT-GTT   THRU 8010-EXIT                 
PRDFIX      END-IF                                                      
A03301                                                                  
A03301* CONTINUE EVALUATING OTHER RULES ONLY IF IT IS SEASON TO OFFER           
A03301* SEASONAL DPP                                                            
A03301     IF  WS-DPP-SEAS = 'Y'                                        
               EVALUATE TRUE ALSO TRUE                                  
                  WHEN SEB-DATABASE ALSO WS-DEREG                       
                      PERFORM 2310-SEB-DREG-SDPP-BUS                    
                         THRU 2310-EXIT                                 
                  WHEN SEB-DATABASE ALSO WS-REG                         
                      PERFORM 2320-SEB-REG-SDPP-BUS                     
                         THRU 2320-EXIT                                 
               END-EVALUATE                                             
A03301     END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2310-SEB-DREG-SDPP-BUS.                                          
      * ACCOUNT TYPE                                                            
              MOVE ZEROES                TO S-RETURN-CODE               
P0726D        MOVE SPACES                TO S-BUS-RULE-ID               
              EVALUATE TRUE                                             
                 WHEN AT-ACCOUNT-TYPE-CODE = 'R'                        
                    MOVE 'CRDARNG020'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                 WHEN AT-ACCOUNT-TYPE-CODE = 'C'                        
                 WHEN AT-ACCOUNT-TYPE-CODE = 'I'                        
                    MOVE 'CRDARNG031'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                 WHEN OTHER                                             
                    MOVE SPACES          TO S-BUS-RULE-ID               
              END-EVALUATE.                                             
              IF S-BUS-RULE-ID    > SPACES                              
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * CREDIT GROUP                                                            
A03300        IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
A03300           NEXT SENTENCE                                          
A03300        ELSE                                                      
                 MOVE ZEROES             TO S-RETURN-CODE               
                 EVALUATE AT-CREDIT-GROUP                               
P00726              WHEN 'C'                                            
                       MOVE 'CRDARNG042'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
A03301              WHEN 'B'                                            
                       MOVE 'CRDARNG224'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'P'             TO S-RULE-RESULT-CD         
A03301              WHEN 'D'                                            
                       MOVE 'CRDARNG011'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                 END-EVALUATE                                           
P0726E           IF I-PARM-TYPE = 'DPP' AND S-BUS-RULE-ID = SPACES      
P00726              CONTINUE                                            
P00726           ELSE                                                   
                    IF S-BUS-RULE-ID > SPACES                           
P00726                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT           
                    END-IF                                              
P00726           END-IF                                                 
A03300        END-IF.                                                   
      * ACCOUNT STATUS                                                          
              MOVE ZEROES                TO S-RETURN-CODE               
               EVALUATE AT-CODE-ACCT-STAT                               
                  WHEN 'A'                                              
                     MOVE 'CRDARNG205'    TO S-BUS-RULE-ID              
                     MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD      
                     MOVE 'P'             TO S-RULE-RESULT-CD           
                  WHEN OTHER                                            
                     MOVE 'CRDARNG206'    TO S-BUS-RULE-ID              
                     MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD      
                     MOVE 'F'             TO S-RULE-RESULT-CD           
               END-EVALUATE.                                            
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * DNP                                                                     
              IF WS-PENDING-SO-FLAG = 'Y'                               
A04527* ACTIVE DNP - NOT WORKED                                                 
                 MOVE ZEROES             TO S-RETURN-CODE               
                 IF WS-DNP-FLAG = 'Y' AND WS-STA-AMOUNT > 0             
                    MOVE 'CRDARNG033'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                    PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
                 ELSE                                                   
      * ACTIVE DNP - WORKED                                                     
                   MOVE ZEROES           TO S-RETURN-CODE               
                   IF WS-DNP-ACT-FLAG = 'Y'                             
                      MOVE 'CRDARNG209'    TO S-BUS-RULE-ID             
                      MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD     
                      MOVE 'F'             TO S-RULE-RESULT-CD          
                      PERFORM 8010-INSERT-GTT THRU 8010-EXIT            
                   END-IF                                               
                 END-IF                                                 
              END-IF.                                                   
      * EXISTING PAYMENT ARRANGEMENT - STA                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'CRDARNG211'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - DPP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'CRDARNG202'    TO S-BUS-RULE-ID                  
                 MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD          
                 MOVE 'F'                TO S-RULE-RESULT-CD            
A03300           PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
P0726B           PERFORM 7020-SELECT-DPP-COMPLIANCE                     
P0726B              THRU 7020-EXIT                                      
P0726B           IF DA-CODE-DFA-DESC NOT = 'S' AND WS-DPP-SEAS = 'Y'    
P0726A* SDPP23 - ADDITIONAL WARNING MESSAGE FOR SEASONAL DPP                    
P0726A              MOVE 0                  TO WS-RETURN-CODE           
P0726A                                      S-RETURN-CODE               
                    MOVE 'CRDARNG210'    TO S-BUS-RULE-ID               
                    MOVE 'P'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'                TO S-RULE-RESULT-CD         
P0726A              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
P0726B           END-IF                                                 
A00300        END-IF                                                    
      * CONTRACT AMOUNT GREATER THAN $25                                        
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              PERFORM 7050-SELECT-DPP-RECV THRU 7050-EXIT               
              IF WS-DPP-CONTRACT-AMT > 25                               
                 MOVE 'CRDARNG214'    TO S-BUS-RULE-ID                  
                 MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD          
                 MOVE 'P'             TO S-RULE-RESULT-CD               
                 PERFORM 8010-INSERT-GTT      THRU 8010-EXIT            
              ELSE                                                      
                 IF  WS-CODE-STA-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-DPP-ACCT NOT EQUAL 'A'                     
A03300*          AND WS-CODE-BUDGET NOT EQUAL 'A'                               
                     MOVE 'CRDARNG215'    TO S-BUS-RULE-ID              
                     MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD      
                     MOVE 'F'             TO S-RULE-RESULT-CD           
                     PERFORM 8010-INSERT-GTT      THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * UNPAID RETURN CHECKS                                                    
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
sakthi                                      WS-AMT-NSA                  
                                                                        
sakthi*       COMPUTE WS-AMT-NSA =  WS-AMT-30-DAY-NSA                           
sakthi*                          +  WS-AMT-60-DAY-NSA                           
sakthi*                          +  WS-AMT-90-DAY-NSA                           
sakthi*       IF WS-AMT-NSA > ZEROES                                            
sakthi*          MOVE 'CRDARNG033'       TO S-BUS-RULE-ID                       
sakthi*          MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD               
sakthi*          MOVE 'F'             TO S-RULE-RESULT-CD                       
sakthi*       END-IF.                                                           
                                                                        
P00453* PRE-PAY-PLAN ACCOUNTS.                                                  
              IF WS-CODE-PRE-PAY-PLAN = 'A'                             
                 MOVE 0                  TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
                 MOVE 'CRDARNG216'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF.                                                   
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02340014
      * SELECTS SEASONAL DPP START AND END DATES                       *02340014
      * FROM CSS_DELINQUENCY.                                          *02340014
      ******************************************************************02340014
       2315-GET-SEAS-DPP-DATES.                                         
      *                                                                         
           MOVE  AT-COMPANY-NO        TO C8-COMPANY-NO                  
           MOVE 'DATE-SEAS-DPP-START' TO C8-DELINQ-CD.                  
           PERFORM 7005-GET-DELINQ THRU 7005-EXIT.                      
           MOVE C8-DELINQ-VALUE TO WS-DATE-SEAS-DPP-START.              
           MOVE 'DATE-SEAS-DPP-END' TO C8-DELINQ-CD.                    
           PERFORM 7005-GET-DELINQ THRU 7005-EXIT.                      
           MOVE C8-DELINQ-VALUE TO WS-DATE-SEAS-DPP-END.                
           MOVE WS-CURRENT-DATE TO WS-HOLD-CURRENT-DATE.                
           MOVE WS-DATE-SEAS-DPP-START(1:2) TO WS-DPP-START-MONTH.      
           MOVE WS-DATE-SEAS-DPP-START(3:2) TO WS-DPP-START-DAY.        
           MOVE WS-DATE-SEAS-DPP-START(1:4) TO WS-DPP-START-MONTH-DAY.  
           MOVE WS-DATE-SEAS-DPP-END(1:2) TO WS-DPP-END-MONTH.          
           MOVE WS-DATE-SEAS-DPP-END(3:2) TO WS-DPP-END-DAY.            
           MOVE WS-DATE-SEAS-DPP-END(1:4) TO WS-DPP-END-MONTH-DAY.      
           MOVE WS-CURRENT-MONTH TO WS-CURRENT-MONTH-DAY(1:2).          
           MOVE WS-CURRENT-DAY   TO WS-CURRENT-MONTH-DAY(3:2).          
                                                                        
           MOVE 'N' TO WS-DPP-SEAS.                                     
           IF WS-DPP-END-MONTH-DAY < WS-DPP-START-MONTH-DAY             
              IF WS-CURRENT-MONTH-DAY <= WS-DPP-START-MONTH-DAY         
              AND WS-CURRENT-MONTH-DAY <= WS-DPP-END-MONTH-DAY          
                 MOVE 'Y' TO WS-DPP-SEAS                                
              ELSE                                                      
                 IF WS-CURRENT-MONTH-DAY >= WS-DPP-START-MONTH-DAY      
                 AND WS-CURRENT-MONTH-DAY >= WS-DPP-END-MONTH-DAY       
                    MOVE 'Y' TO WS-DPP-SEAS                             
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF WS-DPP-END-MONTH-DAY = WS-DPP-START-MONTH-DAY          
                 CONTINUE                                               
              ELSE                                                      
                 IF WS-CURRENT-MONTH-DAY < WS-DPP-START-MONTH-DAY       
                 OR WS-CURRENT-MONTH-DAY > WS-DPP-END-MONTH-DAY         
                    MOVE 'N' TO WS-DPP-SEAS                             
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2315-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02340014
      * 2320-SEB-REG-SDPP-BUS.                                         *        
      ******************************************************************02340014
      *                                                                         
       2320-SEB-REG-SDPP-BUS.                                           
      * ACCOUNT TYPE                                                            
              MOVE ZEROES                TO S-RETURN-CODE               
P0726D        MOVE SPACES                TO S-BUS-RULE-ID               
              EVALUATE TRUE                                             
                 WHEN AT-ACCOUNT-TYPE-CODE = 'R'                        
                    MOVE 'CRDARNG020'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'                TO S-RULE-RESULT-CD         
                 WHEN AT-ACCOUNT-TYPE-CODE = 'C'                        
                 WHEN AT-ACCOUNT-TYPE-CODE = 'I'                        
                    MOVE 'CRDARNG031'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'                TO S-RULE-RESULT-CD         
                 WHEN OTHER                                             
                    MOVE 'CRDARNG221'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'                TO S-RULE-RESULT-CD         
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * CREDIT GROUP                                                            
A03300        IF AT-CODE-ACCT-STAT = 'S' OR 'B'                         
A03300           NEXT SENTENCE                                          
A03300        ELSE                                                      
                 MOVE ZEROES             TO S-RETURN-CODE               
                 EVALUATE AT-CREDIT-GROUP                               
P00726              WHEN 'C'                                            
                       MOVE 'CRDARNG042' TO S-BUS-RULE-ID               
                       MOVE 'A'          TO S-RULE-NOTIFY-TYPE-CD       
                       MOVE 'F'          TO S-RULE-RESULT-CD            
A03301              WHEN 'N'                                            
                       MOVE 'CRDARNG056' TO S-BUS-RULE-ID               
                       MOVE 'A'          TO S-RULE-NOTIFY-TYPE-CD       
                       MOVE 'P'          TO S-RULE-RESULT-CD            
                 END-EVALUATE                                           
P0726E           IF I-PARM-TYPE = 'DPP' AND S-BUS-RULE-ID = SPACES      
P00726              CONTINUE                                            
P00726           ELSE                                                   
                    IF S-BUS-RULE-ID > SPACES                           
P00726                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT           
                    END-IF                                              
P00726           END-IF                                                 
A03300        END-IF.                                                   
A04527* ACCOUNT STATUS                                                          
              MOVE ZEROES                TO S-RETURN-CODE               
              EVALUATE AT-CODE-ACCT-STAT                                
                 WHEN 'A'                                               
                    MOVE 'CRDARNG205'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
                 WHEN OTHER                                             
                    MOVE 'CRDARNG206'    TO S-BUS-RULE-ID               
                    MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'F'             TO S-RULE-RESULT-CD            
              END-EVALUATE.                                             
              PERFORM 8010-INSERT-GTT THRU 8010-EXIT                    
      * DNP                                                                     
              IF WS-PENDING-SO-FLAG = 'Y'                               
      * ACTIVE DNP - NOT WORKED                                                 
                 MOVE ZEROES             TO S-RETURN-CODE               
                 IF WS-DNP-FLAG = 'Y'                                   
                     MOVE 'CRDARNG033'    TO S-BUS-RULE-ID              
                     MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD      
                     MOVE 'P'             TO S-RULE-RESULT-CD           
                     PERFORM 8010-INSERT-GTT THRU 8010-EXIT             
                 ELSE                                                   
      * ACTIVE DNP - WORKED                                                     
                   MOVE ZEROES           TO S-RETURN-CODE               
                   IF WS-DNP-ACT-FLAG = 'Y'                             
                       MOVE 'CRDARNG209'    TO S-BUS-RULE-ID            
                       MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD    
                       MOVE 'F'             TO S-RULE-RESULT-CD         
                       PERFORM 8010-INSERT-GTT THRU 8010-EXIT           
                   END-IF                                               
                 END-IF                                                 
              END-IF.                                                   
      * EXISTING PAYMENT ARRANGEMENT - STA                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-STA-ACCT = 'A'                                 
                 MOVE 'CRDARNG211'       TO S-BUS-RULE-ID               
                 MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD       
                 MOVE 'F'                TO S-RULE-RESULT-CD            
                 PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
              END-IF                                                    
      * EXISTING PAYMENT ARRANGEMENT - DPP                                      
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              IF WS-CODE-DPP-ACCT = 'A'                                 
                 MOVE 'CRDARNG202'    TO S-BUS-RULE-ID                  
                 MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD          
                 MOVE 'F'             TO S-RULE-RESULT-CD               
A03300           PERFORM 8010-INSERT-GTT THRU 8010-EXIT                 
P0726B           PERFORM 7020-SELECT-DPP-COMPLIANCE                     
P0726B              THRU 7020-EXIT                                      
P0726B           IF DA-CODE-DFA-DESC NOT = 'S' AND WS-DPP-SEAS = 'Y'    
P0726A* ADDITIONAL WARNING MESSAGE FOR SEASONAL DPP                             
P0726A              MOVE 0                  TO WS-RETURN-CODE           
P0726A                                      S-RETURN-CODE               
                    MOVE 'CRDARNG210'    TO S-BUS-RULE-ID               
                    MOVE 'P'             TO S-RULE-NOTIFY-TYPE-CD       
                    MOVE 'P'             TO S-RULE-RESULT-CD            
P0726A              PERFORM 8010-INSERT-GTT THRU 8010-EXIT              
P0726B           END-IF                                                 
              END-IF                                                    
      * CONTRACT AMOUNT GREATER THAN $25                                        
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
              PERFORM 7050-SELECT-DPP-RECV THRU 7050-EXIT               
              IF WS-DPP-CONTRACT-AMT > 25                               
                 MOVE 'CRDARNG214'    TO S-BUS-RULE-ID                  
                 MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD          
                 MOVE 'P'             TO S-RULE-RESULT-CD               
                 PERFORM 8010-INSERT-GTT      THRU 8010-EXIT            
              ELSE                                                      
                 IF  WS-CODE-STA-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-DPP-ACCT NOT EQUAL 'A'                     
                 AND WS-CODE-BUDGET NOT EQUAL 'A'                       
                     MOVE 'CRDARNG215'    TO S-BUS-RULE-ID              
                     MOVE 'A'             TO S-RULE-NOTIFY-TYPE-CD      
                     MOVE 'F'             TO S-RULE-RESULT-CD           
                     PERFORM 8010-INSERT-GTT      THRU 8010-EXIT        
                 END-IF                                                 
              END-IF                                                    
      * UNPAID RETURN CHECKS                                                    
              MOVE 0                     TO WS-RETURN-CODE              
                                            S-RETURN-CODE               
sakthi                                      WS-AMT-NSA.                 
                                                                        
sakthi*       COMPUTE WS-AMT-NSA =  WS-AMT-30-DAY-NSA                           
sakthi*                          +  WS-AMT-60-DAY-NSA                           
sakthi*                          +  WS-AMT-90-DAY-NSA                           
sakthi*       IF WS-AMT-NSA > ZEROES                                            
sakthi*          MOVE 'CRDARNG033'       TO S-BUS-RULE-ID                       
sakthi*          MOVE 'A'                TO S-RULE-NOTIFY-TYPE-CD               
sakthi*          MOVE 'F'                TO S-RULE-RESULT-CD                    
sakthi*          PERFORM 8010-INSERT-GTT THRU 8010-EXIT                         
sakthi*       END-IF .                                                          
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-ACCT-TYPE-CD-CHK.                                         *        
      ******************************************************************        
      *                                                                         
       2400-ACCT-TYPE-CD-CHK.                                           
      *                                                                         
           PERFORM 7400-SECURED-RATES  THRU 7400-EXIT                   
      *                                                                         
           MOVE ZEROES                TO S-RETURN-CODE                  
           IF AT-ACCOUNT-TYPE-CODE = 'R'                                
               MOVE 'CRDARNG200'          TO S-BUS-RULE-ID              
               MOVE 'A'                   TO S-RULE-NOTIFY-TYPE-CD      
               MOVE 'P'                   TO S-RULE-RESULT-CD           
               PERFORM 8010-INSERT-GTT    THRU 8010-EXIT                
           ELSE                                                         
              IF AT-ACCOUNT-TYPE-CODE = 'C' AND                         
                 WS-SECURED-RATE-IND  = 'N'                             
                  MOVE 'CRDARNG031'         TO S-BUS-RULE-ID            
                  MOVE 'A'                  TO S-RULE-NOTIFY-TYPE-CD    
                  MOVE 'P'                   TO S-RULE-RESULT-CD        
                  PERFORM 8010-INSERT-GTT   THRU 8010-EXIT              
              ELSE                                                      
                  IF AT-ACCOUNT-TYPE-CODE = 'I' OR                      
                    (AT-ACCOUNT-TYPE-CODE = 'C' AND                     
                     WS-SECURED-RATE-IND  = 'Y')                        
                     MOVE 'CRDARNG202'         TO S-BUS-RULE-ID         
                     MOVE 'A'                  TO S-RULE-NOTIFY-TYPE-CD 
                     MOVE 'F'                   TO S-RULE-RESULT-CD     
                     PERFORM 8010-INSERT-GTT   THRU 8010-EXIT           
                  ELSE                                                  
                     MOVE 'CRDARNG221'         TO S-BUS-RULE-ID         
                     MOVE 'A'                  TO S-RULE-NOTIFY-TYPE-CD 
                     MOVE 'F'                   TO S-RULE-RESULT-CD     
                     PERFORM 8010-INSERT-GTT   THRU 8010-EXIT           
                  END-IF                                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726E******************************************************************        
P0726E* 2405-VALIDATE-CREDIT-ACTION                                    *        
P0726E******************************************************************        
P0726E                                                                  
P0726E 2405-VALIDATE-CREDIT-ACTION.                                     
P0726E                                                                  
P0726E     MOVE 'N'                       TO WS-CREDIT-ACTION-FL.       
P0726E     IF WS-DATE-DISC(1:4) NUMERIC AND                             
P0726E        WS-DATE-DISC(6:2) NUMERIC AND                             
P0726E        WS-DATE-DISC(9:2) NUMERIC                                 
P0726E        IF WS-DATE-DISC >= WS-CURRENT-DATE                        
P0726E           MOVE 'Y'                 TO WS-CREDIT-ACTION-FL        
P0726E        END-IF                                                    
P0726E     ELSE                                                         
P0726E        IF WS-DATE-DISC = 'MULTIPLE'                              
P0726E           IF WS-DATE-CREDIT-ACTION-G >= WS-CURRENT-DATE OR       
P0726E              WS-DATE-CREDIT-ACTION-D >= WS-CURRENT-DATE OR       
P0726E              WS-DATE-CREDIT-ACTION-H >= WS-CURRENT-DATE OR       
P0726E              WS-DATE-CREDIT-ACTION-I >= WS-CURRENT-DATE          
P0726E              MOVE 'Y'              TO WS-CREDIT-ACTION-FL        
P0726E           END-IF                                                 
P0726E        END-IF                                                    
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E     IF WS-DNP-FLAG = 'Y'                                         
P0726E        MOVE 'Y'                    TO WS-CREDIT-ACTION-FL        
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E* GROUP1 SENIOR SCHEDULED TO MOVE TO GROUP2                               
P0726E                                                                  
P0726E     IF LR-REG-GROUP-CD = '100'  AND                              
P0726E        LR-SENIOR-FL = 'Y'       AND                              
P0726E        WS-GROUP1-TO-GROUP2-FL = 'Y' AND                          
P0726E        WS-DATE-NOTICE-MAIL-C > SPACES AND                        
P0726E        WS-AMT-NOTICE-C > WS-NOTICE-DNP-LIMIT                     
P0726E        MOVE 'Y'                    TO WS-CREDIT-ACTION-FL        
P0726E     END-IF.                                                      
P0726E                                                                  
P0726E 2405-EXIT.                                                       
P0726E     EXIT.                                                        
P0726E                                                                  
A03898***************************************************************           
A03898* 2500-PROCESS-BILL-IMED-DEP-CUR.                             *           
A03898***************************************************************           
A03898 2500-PROCESS-BILL-IMED-DEP-CUR.                                  
A03898                                                                  
A03898     IF WS-DATE-CREDIT-ACTION-I         > WS-CURRENT-DATE         
A03898        MOVE 'Y'                      TO WS-BILL-IMED-DEP         
A03898     END-IF.                                                      
A03898                                                                  
A03898     IF WS-BILL-IMED-DEP ='Y'                                     
A03898        MOVE 'STA038'                 TO S-BUS-RULE-ID            
A03898        MOVE 'R'                      TO S-RULE-RESULT-CD         
A03898        PERFORM 8010-INSERT-GTT       THRU 8010-EXIT              
A03898     ELSE                                                         
A03898        MOVE 'STA038'                 TO S-BUS-RULE-ID            
A03898        MOVE 'G'                      TO S-RULE-RESULT-CD         
A03898        PERFORM 8010-INSERT-GTT       THRU 8010-EXIT              
A03898     END-IF.                                                      
A03898                                                                  
A03898 2500-EXIT.                                                       
A03898     EXIT.                                                        
A03898*                                                                         
P0726F******************************************************************        
P0726F* 5900-NEXT-BILL-DATE                                                     
P0726F******************************************************************        
P0726F                                                                  
P0726F     EXEC SQL                                                             
P0726F        INCLUDE CPD00309                                                  
P0726F     END-EXEC.                                                            
P0726F                                                                  
      ***************************************************************           
      * 5901-NEXT-READ-DATE.                                                    
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE CPD00310                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * 6500-GET-NEXT-BUSINESS-DAY                                  *           
      ***************************************************************           
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0315B                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    6525-PREV-BUSINESS-DAY                                    **         
      *                                                              **         
      *    FINDS THE PREVIOUS BUSINESS DAY, SKIPPING OVER WEEKENDS   **         
      *    AND HOLIDAYS (FOUND IN CSS_HOLIDAY), FROM THE CURRENT     **         
      *    VALUE IN WS-NEW-BUSINESS-DAY WHEN 6500 WAS CALLED.        **         
      *****************************************************************         
       6525-PREV-BUSINESS-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) )) -     
                       CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-NEW-BUSINESS-DAY,
              :WS-DAY-OF-WEEK 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET  :WS-NEW-BUSINESS-DAY                                          
MFA-TR*              = DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS                      
MFA-TR*          ,:WS-DAY-OF-WEEK                                               
MFA-TR*              = (DAYS(DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS) -             
MFA-TR*                DAYS(DATE(:WS-NEW-BUSINESS-DAY) - 1 DAYS)/7*7)+1         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '6525'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 6550-WKND-HLDY-CHECK   THRU                          
                                            6550-WKND-HLDY-CHECK-EXIT.  
                                                                        
       6525-PREV-BUSINESS-DAY-EXIT.                                     
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *    6550-WKND-HLDY-CHECK                                       *         
      *    CHECK TO SEE IF IT IS A WEEKEND OR HOLIDAY                 *         
      *****************************************************************         
       6550-WKND-HLDY-CHECK.                                            
                                                                        
           IF WS-DAY-OF-WEEK NOT EQUAL WS-SATURDAY AND                  
              WS-DAY-OF-WEEK NOT EQUAL WS-SUNDAY                        
                                                                        
              MOVE WS-NEW-BUSINESS-DAY       TO J8-HOLIDAY-DT           
              MOVE 'N'                       TO WS-HOLIDAY-EXISTS       
                                                                        
      ***  ...IF NOT A WEEKEND, THEN CHECK TO SEE IF IT IS A HOLIDAY            
              EXEC SQL                                                  
                  SELECT DISTINCT('Y')                                  
                  INTO   :WS-HOLIDAY-EXISTS                             
                  FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                      
                  WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                    
                                                                 
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT DISTINCT('Y')                                          
MFA-TR*           INTO   :WS-HOLIDAY-EXISTS                                     
MFA-TR*           FROM   CSS_HOLIDAY                                            
MFA-TR*           WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                            
MFA-TR*           WITH UR                                                       
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              IF SQLCODE EQUAL SUCCESSFUL-CALL                          
                  CONTINUE                                              
              ELSE                                                      
                  IF SQLCODE NOT EQUAL NOT-FOUND                        
                     MOVE PROGRAM-NAME             TO ABEND-PROGRAM     
                     MOVE '6550'                   TO ACTIVE-PARAGRAPH  
                     MOVE 'SELECT'                 TO ABEND-FUNCTION    
                     MOVE SPACES                 TO ABEND-SQL-PREDICATES
                                                      ABEND-TABLES      
                     MOVE 'CSS_HOLIDAY'            TO TABLE-1           
                     MOVE 'HOLIDAY_DT'             TO TABLE-ELEMENT-1   
                     MOVE J8-HOLIDAY-DT            TO HOSTVAR-ELEMENT-1 
                     PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT       
                  END-IF                                                
              END-IF                                                    
                                                                        
              IF HOLIDAY-EXISTS-NO                                      
                  MOVE 'Y'                   TO WS-PREV-BUS-DAY-FLAG    
              ELSE                                                      
                  MOVE 'N'                   TO WS-PREV-BUS-DAY-FLAG    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       6550-WKND-HLDY-CHECK-EXIT.                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      **     7005-GET-DELINQ.                                         **        
      **                                                              **        
      ******************************************************************        
       7005-GET-DELINQ.                                                 
      *---------------------*                                                   
             MOVE '7005'                   TO WS-ACTIVE-PARAGRAPH.      
                                                                        
             EXEC SQL                                                   
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE COMPANY_NO           = :C8-COMPANY-NO              
                 AND DELINQ_CD            = :C8-DELINQ-CD               
                                                                 
                                                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE COMPANY_NO           = :C8-COMPANY-NO                      
MFA-TR*          AND DELINQ_CD            = :C8-DELINQ-CD                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7005'                   TO ACTIVE-PARAGRAPH        
               MOVE 'SELECT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
               MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1         
               MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7020-SELECT-DPP-COMPLIANCE.                         *                   
      *                                                             *           
      * FETCH DETAILS ABOUT THE RECENT DPP.                         *           
      ***************************************************************           
      *                                                                         
       7020-SELECT-DPP-COMPLIANCE.                                      
      *                                                                         
           MOVE '7020'                          TO ACTIVE-PARAGRAPH.    
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) DA.CODE_DFA_STATUS,
              DA.REVERSE_REASON,
              DA.CODE_DFA_DESC,
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) - CIS.DAYS(
           DA.DATE_OF_AGREE),
              REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS, 121), 
           ' ', '-'), ':', '.') LAST_UPDATE_TS                                 
                INTO :DA-CODE-DFA-STATUS                                
                    ,:DA-REVERSE-REASON                                 
                    ,:DA-CODE-DFA-DESC                                  
                    ,:WS-RECENT-DPP-DAYS                                
                    ,:DA-LAST-UPDATE-TS                                 
               FROM CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                       
              WHERE DA.ACCOUNT_NO    = :DA-ACCOUNT-NO                   
                AND DA.CODE_DFA_TYPE = 'B'                              
              ORDER BY DA.DATE_OF_AGREE DESC                            
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DA.CODE_DFA_STATUS                                         
MFA-TR*             ,DA.REVERSE_REASON                                          
MFA-TR*             ,DA.CODE_DFA_DESC                                           
MFA-TR*             ,DAYS(CURRENT DATE) - DAYS(DA.DATE_OF_AGREE)                
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*         INTO :DA-CODE-DFA-STATUS                                        
MFA-TR*             ,:DA-REVERSE-REASON                                         
MFA-TR*             ,:DA-CODE-DFA-DESC                                          
MFA-TR*             ,:WS-RECENT-DPP-DAYS                                        
MFA-TR*             ,:DA-LAST-UPDATE-TS                                         
MFA-TR*        FROM CSS_DFA_ACCT DA                                             
MFA-TR*       WHERE DA.ACCOUNT_NO    = :DA-ACCOUNT-NO                           
MFA-TR*         AND DA.CODE_DFA_TYPE = 'B'                                      
MFA-TR*       ORDER BY DA.DATE_OF_AGREE DESC                                    
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              CONTINUE                                                  
           ELSE                                                         
               MOVE 'CSR04366'                 TO ABEND-PROGRAM         
               MOVE '7020'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_DFA_ACCOUNT'          TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE DA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
TASK01* 7025-CHK-DPP-DROP.                                             *        
      ******************************************************************        
      *                                                                         
TASK01 7025-CHK-DPP-DROP.                                               
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                             
                  INTO :WS-DPP-DROP-EXISTS                              
                  FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
                 WHERE YP.ACCOUNT_NO           = :YP-ACCOUNT-NO         
                   AND YP.STATUS_CD            = 'A'                    
                   AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'        
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  'Y'                                                     
MFA-TR*           INTO :WS-DPP-DROP-EXISTS                                      
MFA-TR*           FROM CSS_ACCT_ATTRIBUTE YP                                    
MFA-TR*          WHERE YP.ACCOUNT_NO           = :YP-ACCOUNT-NO                 
MFA-TR*            AND YP.STATUS_CD            = 'A'                            
MFA-TR*            AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'                
MFA-TR*          FETCH FIRST 1 ROWS ONLY WITH UR                                
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               MOVE 'CSR04366'                 TO ABEND-PROGRAM         
               MOVE '7025'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
TASK01 7025-EXIT.                                                       
TASK01     EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7030-SELECT-BBP-COMPLIANCE.                         *                   
      *                                                             *           
      * FETCH DETAILS ABOUT THE RECENT BBP.                         *           
      ***************************************************************           
      *                                                                         
       7030-SELECT-BBP-COMPLIANCE.                                      
      *                                                                         
           MOVE '7030'                          TO ACTIVE-PARAGRAPH.    
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) BH.CHANGE_REASON,
              BH.REMARKS,
              REPLACE(REPLACE(CONVERT(CHAR(26), BH.BUD_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') BUD_HIST_SEQ_NO                        
                INTO :BH-CHANGE-REASON                                  
                    ,:BH-REMARKS                                        
                    ,:BH-BUD-HIST-SEQ-NO                                
               FROM CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                    
              WHERE BH.ACCOUNT_NO = :BH-ACCOUNT-NO                      
                ORDER BY BUD_HIST_SEQ_NO DESC                        
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  BH.CHANGE_REASON                                           
MFA-TR*             ,BH.REMARKS                                                 
MFA-TR*             ,BH.BUD_HIST_SEQ_NO                                         
MFA-TR*         INTO :BH-CHANGE-REASON                                          
MFA-TR*             ,:BH-REMARKS                                                
MFA-TR*             ,:BH-BUD-HIST-SEQ-NO                                        
MFA-TR*        FROM CSS_BUDGET_HIST BH                                          
MFA-TR*       WHERE BH.ACCOUNT_NO = :BH-ACCOUNT-NO                              
MFA-TR*         ORDER BY BH.BUD_HIST_SEQ_NO DESC                                
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              CONTINUE                                                  
           ELSE                                                         
               MOVE 'CSR04366'                 TO ABEND-PROGRAM         
               MOVE '7030'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_BUDGET_HIST'          TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE BH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7040-SELECT-MED-CERT.                                       *           
      *                                                             *           
      * FETCH DETAILS ABOUT THE MEDICAL CERTIFICATE.                *           
      ***************************************************************           
      *                                                                         
       7040-SELECT-MED-CERT.                                            
      *                                                                         
           MOVE '7040'                          TO ACTIVE-PARAGRAPH.    
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) COALESCE(DATE_ALERT ,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              COALESCE(DATE_EXPIRE,IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )),
              CAST(SYSDATETIMEOFFSET() AS DATE)                                 
              INTO      :CA-DATE-ALERT                                  
                       ,:CA-DATE-EXPIRE                                 
                       ,:WS-CURRENT-DT                                  
              FROM       CSS_CUST_ALERT WITH(READUNCOMMITTED)                   
              WHERE      ACCOUNT_NO        =:CA-ACCOUNT-NO              
              ORDER BY DATE_ALERT DESC                                  
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT     IFNULL(DATE_ALERT ,'1900-01-01')                       
MFA-TR*                 ,IFNULL(DATE_EXPIRE,'1900-01-01')                       
MFA-TR*                 ,CURRENT DATE                                           
MFA-TR*       INTO      :CA-DATE-ALERT                                          
MFA-TR*                ,:CA-DATE-EXPIRE                                         
MFA-TR*                ,:WS-CURRENT-DT                                          
MFA-TR*       FROM       CSS_CUST_ALERT                                         
MFA-TR*       WHERE      ACCOUNT_NO        =:CA-ACCOUNT-NO                      
MFA-TR*       ORDER BY DATE_ALERT DESC                                          
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 EXEC SQL                                               
                      SELECT
              CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-CURRENT-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DT
              ) <> 0) OR (LEN(:WS-CURRENT-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CURRENT-DT
              ), CONVERT(DATE, :WS-CURRENT-DT) ) ) - CIS.DAYS( 
              IIF(TRY_CONVERT(DATE, :CA-DATE-EXPIRE
              ) IS NULL OR (PATINDEX('%.%', :CA-DATE-EXPIRE
              ) <> 0) OR (LEN(:CA-DATE-EXPIRE) <> 10), CIS.CHAR2DATE(
                                                        :CA-DATE-EXPIRE
              ), CONVERT(DATE, :CA-DATE-EXPIRE) ) )
            INTO
              :WS-DAYS-EXPIRE  
                 END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*          EXEC SQL                                                       
MFA-TR*               SET :WS-DAYS-EXPIRE =                                     
MFA-TR*                   DAYS(:WS-CURRENT-DT) - DAYS(:CA-DATE-EXPIRE)          
MFA-TR*          END-EXEC                                                       
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                               
              ELSE                                                      
                 MOVE 0                        TO WS-DAYS-EXPIRE        
              END-IF                                                    
           ELSE                                                         
               MOVE 'CSR04366'                 TO ABEND-PROGRAM         
               MOVE '7040'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_CUST_ALERT'           TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE CA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7050-SELECT-DPP-RECV.                                       *           
      *                                                             *           
      * FETCH DETAILS ABOUT THE DPP ELIGIBLE RECEIVABLES.           *           
      ***************************************************************           
      *                                                                         
       7050-SELECT-DPP-RECV.                                            
      *                                                                         
           MOVE '7050'                          TO ACTIVE-PARAGRAPH.    
      *                                                                         
           EXEC SQL                                                     
               SELECT COALESCE(SUM(AC.AMT_AR_DAY_00                       
                    +  AC.AMT_AR_DAY_30                                 
                    +  AC.AMT_AR_DAY_60                                 
                    +  AC.AMT_AR_DAY_90                                 
                    +  AC.AMT_UNUSED_CR),0)                             
                 INTO :WS-DPP-CONTRACT-AMT                              
                 FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                 WHERE AC.ACCOUNT_NO = :AC-ACCOUNT-NO                   
                   AND AC.ITEM_ID = 0                                   
                   AND AC.PYMT_PRIORITY_LVL IN (20,30,40,               
                                                 45,47,60)              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(SUM(AC.AMT_AR_DAY_00                               
MFA-TR*             +  AC.AMT_AR_DAY_30                                         
MFA-TR*             +  AC.AMT_AR_DAY_60                                         
MFA-TR*             +  AC.AMT_AR_DAY_90                                         
MFA-TR*             +  AC.AMT_UNUSED_CR),0)                                     
MFA-TR*          INTO :WS-DPP-CONTRACT-AMT                                      
MFA-TR*          FROM CSS_AR_CNTL AC                                            
MFA-TR*          WHERE AC.ACCOUNT_NO = :AC-ACCOUNT-NO                           
MFA-TR*            AND AC.ITEM_ID = 0                                           
MFA-TR*            AND AC.PYMT_PRIORITY_LVL IN (20,30,40,                       
MFA-TR*                                          45,47,60)                      
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7050                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND                                                 
              CONTINUE                                                  
           ELSE                                                         
               MOVE 'CSR04366'                 TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_AR_CNTL'              TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726C*****************************************************************         
P0726C* 7060-SEL-LAST-ARNG-DT-CMPLNCE                                 *         
P0726C*****************************************************************         
P0726C                                                                  
P0726C 7060-SEL-LAST-ARNG-DT-CMPLNCE.                                   
P0726C                                                                  
P0726C     EXEC SQL                                                     
P0726C        SELECT TOP(1) (CIS.DAYS(CAST(SYSDATETIMEOFFSET() 
           AS DATE)) -                              
P0726C                CIS.DAYS(X1.ARNG_SETUP_DT)),
              ARNG_COMPLIANCE_CD                                 
P0726C          INTO :WS-LAST-ARNG-DAYS                                 
P0726C              ,:X1-ARNG-COMPLIANCE-CD                             
P0726C          FROM CSS_CRED_ARNGMENT X1 WITH(READUNCOMMITTED)                 
P0726C         WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                 
P0726C           AND X1.ARNG_TYPE      = 'STA'                          
P0726C           AND X1.ARNG_STATUS_CD ='C'                             
P0726C         ORDER BY X1.ARNG_SETUP_DT DESC                           
P0726C                                              
P0726C                                                           
P0726C                                                      
P0726C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT (DAYS(CURRENT DATE) -                                      
MFA-TR*               DAYS(DATE(X1.ARNG_SETUP_DT)))                             
MFA-TR*             ,ARNG_COMPLIANCE_CD                                         
MFA-TR*         INTO :WS-LAST-ARNG-DAYS                                         
MFA-TR*             ,:X1-ARNG-COMPLIANCE-CD                                     
MFA-TR*         FROM CSS_CRED_ARNGMENT X1                                       
MFA-TR*        WHERE X1.ACCOUNT_NO     = :X1-ACCOUNT-NO                         
MFA-TR*          AND X1.ARNG_TYPE      = 'STA'                                  
MFA-TR*          AND X1.ARNG_STATUS_CD ='C'                                     
MFA-TR*        ORDER BY X1.ARNG_SETUP_DT DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7060                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726C                                                                  
P0726C     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
P0726C                                                                  
P0726C     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726C     OR NOT-FOUND                                                 
P0726C        CONTINUE                                                  
P0726C     ELSE                                                         
P0726C         MOVE 'CSR04366'                 TO ABEND-PROGRAM         
P0726C         MOVE '7050'                     TO ACTIVE-PARAGRAPH      
P0726C         MOVE 'SELECT'                   TO ABEND-FUNCTION        
P0726C         MOVE 'CSS_AR_CNTL'              TO TABLE-1               
P0726C         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
P0726C         MOVE X1-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
P0726C         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P0726C         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P0726C     END-IF.                                                      
P0726C                                                                  
P0726C 7060-EXIT.                                                       
P0726C     EXIT.                                                        
P0726C                                                                  
      ***************************************************************           
      * 7100-SELECT-ACCOUNT                                         *           
      *                                                             *           
      * FETCH DETAILS FROM THE ACCOUNT TABLE                        *           
      ***************************************************************           
      *                                                                         
       7100-SELECT-ACCOUNT.                                             
      *                                                                         
           MOVE '7100'                          TO ACTIVE-PARAGRAPH.    
      *                                                                         
           EXEC SQL                                                     
             SELECT                                                     
                 AT.CODE_ACCT_STAT                                      
               , AT.CODE_MAJOR_ACCT                                     
               , AT.CT_METER_RATED_IND                                  
               , AT.CREDIT_GROUP                                        
               , AT.COMPANY_NO                                          
               , AT.BILL_CYCLE                                          
               , AT.PREMISE_NO                                          
               , AT.LOCAL_OFFICE                                        
               , AT.ACCOUNT_TYPE_CODE                                   
               , AT.TOTAL_AR_BALANCE                                    
               , AT.MST_SUB_ACCT_IND                                    
               , COALESCE(CAST(AT.ACCT_FINALED_DT AS DATE),
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))          
               , COALESCE(AT.DATE_BILL_DAY_00,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))               
               , COALESCE(AT.DATE_BILL_DAY_30,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))               
               , COALESCE(AT.DATE_BILL_DAY_60,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))               
               , COALESCE(AT.DATE_BILL_DAY_90,IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))               
      *        , CURRENT DATE - IFNULL(AT.LAST_PYMT_DATE,'1900-01-01')          
               , CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -                  
                 CIS.DAYS(COALESCE(AT.LAST_PYMT_DATE,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )))           
               , AT.CODES_DATA_PRESENT                                  
               , AT.NOTICE_EXEMPT_CD                                    
               , AT.CODE_DISC_OK                                        
               , AT.BANKRUPTCY_IND                                      
               , AT.IVR_EXEMPT_CD                                       
               , AT.REV_MTH_LST_NRML                                    
P0726F         , AT.CODE_BILL_FREQ                                      
             INTO                                                       
                   :AT-CODE-ACCT-STAT                                   
                 , :AT-CODE-MAJOR-ACCT                                  
                 , :AT-CT-METER-RATED-IND                               
                 , :AT-CREDIT-GROUP                                     
                 , :AT-COMPANY-NO                                       
                 , :AT-BILL-CYCLE                                       
                 , :AT-PREMISE-NO                                       
                 , :AT-LOCAL-OFFICE                                     
                 , :AT-ACCOUNT-TYPE-CODE                                
                 , :AT-TOTAL-AR-BALANCE                                 
                 , :AT-MST-SUB-ACCT-IND                                 
                 , :AT-ACCT-FINALED-DT                                  
                 , :AT-DATE-BILL-DAY-00                                 
                 , :AT-DATE-BILL-DAY-30                                 
                 , :AT-DATE-BILL-DAY-60                                 
                 , :AT-DATE-BILL-DAY-90                                 
                 , :WS-RECENT-PYMT-DAYS                                 
                 , :AT-CODES-DATA-PRESENT                               
                 , :AT-NOTICE-EXEMPT-CD                                 
                 , :AT-CODE-DISC-OK                                     
                 , :AT-BANKRUPTCY-IND                                   
                 , :AT-IVR-EXEMPT-CD                                    
                 , :AT-REV-MTH-LST-NRML                                 
P0726F           , :AT-CODE-BILL-FREQ                                   
             FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                          
             WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                             
MFA-TR*          AT.CODE_ACCT_STAT                                              
MFA-TR*        , AT.CODE_MAJOR_ACCT                                             
MFA-TR*        , AT.CT_METER_RATED_IND                                          
MFA-TR*        , AT.CREDIT_GROUP                                                
MFA-TR*        , AT.COMPANY_NO                                                  
MFA-TR*        , AT.BILL_CYCLE                                                  
MFA-TR*        , AT.PREMISE_NO                                                  
MFA-TR*        , AT.LOCAL_OFFICE                                                
MFA-TR*        , AT.ACCOUNT_TYPE_CODE                                           
MFA-TR*        , AT.TOTAL_AR_BALANCE                                            
MFA-TR*        , AT.MST_SUB_ACCT_IND                                            
MFA-TR*        , IFNULL(DATE(AT.ACCT_FINALED_DT),'1900-01-01')                  
MFA-TR*        , IFNULL(AT.DATE_BILL_DAY_00,'1900-01-01')                       
MFA-TR*        , IFNULL(AT.DATE_BILL_DAY_30,'1900-01-01')                       
MFA-TR*        , IFNULL(AT.DATE_BILL_DAY_60,'1900-01-01')                       
MFA-TR*        , IFNULL(AT.DATE_BILL_DAY_90,'1900-01-01')                       
MFA-TR*        , CURRENT DATE - IFNULL(AT.LAST_PYMT_DATE,'1900-01-01')          
MFA-TR*        , DAYS(CURRENT DATE) -                                           
MFA-TR*          DAYS(IFNULL(AT.LAST_PYMT_DATE,'1900-01-01'))                   
MFA-TR*        , AT.CODES_DATA_PRESENT                                          
MFA-TR*        , AT.NOTICE_EXEMPT_CD                                            
MFA-TR*        , AT.CODE_DISC_OK                                                
MFA-TR*        , AT.BANKRUPTCY_IND                                              
MFA-TR*        , AT.IVR_EXEMPT_CD                                               
MFA-TR*        , AT.REV_MTH_LST_NRML                                            
MFA-TR*        , AT.CODE_BILL_FREQ                                              
MFA-TR*      INTO                                                               
MFA-TR*            :AT-CODE-ACCT-STAT                                           
MFA-TR*          , :AT-CODE-MAJOR-ACCT                                          
MFA-TR*          , :AT-CT-METER-RATED-IND                                       
MFA-TR*          , :AT-CREDIT-GROUP                                             
MFA-TR*          , :AT-COMPANY-NO                                               
MFA-TR*          , :AT-BILL-CYCLE                                               
MFA-TR*          , :AT-PREMISE-NO                                               
MFA-TR*          , :AT-LOCAL-OFFICE                                             
MFA-TR*          , :AT-ACCOUNT-TYPE-CODE                                        
MFA-TR*          , :AT-TOTAL-AR-BALANCE                                         
MFA-TR*          , :AT-MST-SUB-ACCT-IND                                         
MFA-TR*          , :AT-ACCT-FINALED-DT                                          
MFA-TR*          , :AT-DATE-BILL-DAY-00                                         
MFA-TR*          , :AT-DATE-BILL-DAY-30                                         
MFA-TR*          , :AT-DATE-BILL-DAY-60                                         
MFA-TR*          , :AT-DATE-BILL-DAY-90                                         
MFA-TR*          , :WS-RECENT-PYMT-DAYS                                         
MFA-TR*          , :AT-CODES-DATA-PRESENT                                       
MFA-TR*          , :AT-NOTICE-EXEMPT-CD                                         
MFA-TR*          , :AT-CODE-DISC-OK                                             
MFA-TR*          , :AT-BANKRUPTCY-IND                                           
MFA-TR*          , :AT-IVR-EXEMPT-CD                                            
MFA-TR*          , :AT-REV-MTH-LST-NRML                                         
MFA-TR*          , :AT-CODE-BILL-FREQ                                           
MFA-TR*      FROM CSS_ACCOUNT AT                                                
MFA-TR*      WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF AT-ACCT-FINALED-DT = '1900-01-01'                      
                 MOVE SPACES TO  AT-ACCT-FINALED-DT                     
              END-IF                                                    
              IF AT-DATE-BILL-DAY-30 = '1900-01-01'                     
                 MOVE SPACES TO  AT-DATE-BILL-DAY-30                    
              END-IF                                                    
              IF AT-DATE-BILL-DAY-60 = '1900-01-01'                     
                 MOVE SPACES TO  AT-DATE-BILL-DAY-60                    
              END-IF                                                    
              IF AT-DATE-BILL-DAY-90 = '1900-01-01'                     
                 MOVE SPACES TO  AT-DATE-BILL-DAY-90                    
              END-IF                                                    
           ELSE                                                         
               MOVE SPACES                     TO ABEND-TABLES          
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
               MOVE 'CSR04366'                 TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_ACCOUNT'              TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       7110-GET-CURRENT-DATE.                                           
                                                                        
           MOVE '7110'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -                
P00594                              CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) ) ),
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -                
P00594                              CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-30
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-30
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-30
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-30
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-30) ) ),
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -                
P00594                              CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-60
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-60
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-60
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-60
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-60) ) ),
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) -                
P00594                              CIS.DAYS( IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-90
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-90
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-90
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-90
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-90) ) )
            INTO
              :WS-CURRENT-DATE,
              :WS-DAYS-00,
              :WS-DAYS-30,
              :WS-DAYS-60,
              :WS-DAYS-90          
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*         ,:WS-DAYS-00      = DAYS(CURRENT DATE) -                        
MFA-TR*                             DAYS(:AT-DATE-BILL-DAY-00)                  
MFA-TR*         ,:WS-DAYS-30      = DAYS(CURRENT DATE) -                        
MFA-TR*                             DAYS(:AT-DATE-BILL-DAY-30)                  
MFA-TR*         ,:WS-DAYS-60      = DAYS(CURRENT DATE) -                        
MFA-TR*                             DAYS(:AT-DATE-BILL-DAY-60)                  
MFA-TR*         ,:WS-DAYS-90      = DAYS(CURRENT DATE) -                        
MFA-TR*                             DAYS(:AT-DATE-BILL-DAY-90)                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 7150-SELECT-REG-GROUP.                                   *              
      ******************************************************************        
       7150-SELECT-REG-GROUP.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT REG_GROUP_CD                                       
P0726E              ,LR.SENIOR_FL                                       
              INTO  :LR-REG-GROUP-CD                                    
P0726E             ,:LR-SENIOR-FL                                       
              FROM   CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                   
              WHERE  LR.ACCOUNT_NO = :LR-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REG_GROUP_CD                                               
MFA-TR*             ,LR.SENIOR_FL                                               
MFA-TR*       INTO  :LR-REG-GROUP-CD                                            
MFA-TR*            ,:LR-SENIOR-FL                                               
MFA-TR*       FROM   CSS_REG_PROFILE LR                                         
MFA-TR*       WHERE  LR.ACCOUNT_NO = :LR-ACCOUNT-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
                CONTINUE                                                
           WHEN NOT-FOUND                                               
                MOVE SPACES       TO LR-REG-GROUP-CD                    
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7150'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_REG_PROFILE'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE  LR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
P0726E******************************************************************        
P0726E* 7160-ACCOUNT-ATTRIBUTE                                         *        
P0726E* CHECKS ACCCOUNT ATTRIBUTE                                      *        
P0726E******************************************************************        
P0726E 7160-ACCOUNT-ATTRIBUTE.                                          
P0726E                                                                  
P0726E     EXEC SQL                                                     
P0726E         SELECT TOP(1) ACCOUNT_NO                                        
P0726E           INTO :YP-ACCOUNT-NO                                    
P0726E           FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
P0726E          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
P0726E            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
P0726E                                           
P0726E                                                           
P0726E                                                      
P0726E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :YP-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7160                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726E                                                                  
P0726E     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P0726E                                                                  
P0726E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0726E         WHEN SUCCESSFUL-CALL                                     
P0726E             MOVE 'Y' TO WS-ACCT-ATTRIBUTE-FL                     
P0726E         WHEN NOT-FOUND                                           
P0726E             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P0726E             MOVE 'N' TO WS-ACCT-ATTRIBUTE-FL                     
P0726E         WHEN OTHER                                               
P0726E             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P0726E             MOVE '7160'               TO ACTIVE-PARAGRAPH        
P0726E             MOVE 'SELECT'             TO ABEND-FUNCTION          
P0726E             MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                 
P0726E             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P0726E             MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P0726E             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P0726E             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P0726E     END-EVALUATE.                                                
P0726E                                                                  
P0726E 7160-EXIT.                                                       
P0726E     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-SELECT-DEP-ON-HAND                                        *        
      ******************************************************************        
      *                                                                         
       7210-SELECT-DEP-ON-HAND.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :WS-UNPAID-DEPOSIT                                  
              FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
              AND  DEPOSIT_STATUS_CD = 'A'                              
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO  :WS-UNPAID-DEPOSIT                                          
MFA-TR*       FROM   CSS_DEP_ON_HAND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       AND  DEPOSIT_STATUS_CD = 'A'                                      
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
           WHEN NOT-FOUND                                               
               CONTINUE                                                 
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7210'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * THIS GETS THE ACTIVE DNP SERVICE ORDER IF ANY ON THE ACCT   *           
      ***************************************************************           
      *                                                                         
       7300-SELECT-PENDING-SO.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              ORDER_REASON,
              ORDER_TYPE_CD,
              SERV_ORDER_STATUS                                 
               INTO  :WS-PENDING-SO-FLAG                                
                    ,:VO-ORDER-REASON                                   
                    ,:VO-ORDER-TYPE-CD                                  
                    ,:VO-SERV-ORDER-STATUS                              
               FROM CSS_SO_DATA WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO                  
                     AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')     
                     AND ORDER_TYPE_CD = :VO-ORDER-TYPE-CD              
                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*             , ORDER_REASON                                              
MFA-TR*             , ORDER_TYPE_CD                                             
MFA-TR*             , SERV_ORDER_STATUS                                         
MFA-TR*        INTO  :WS-PENDING-SO-FLAG                                        
MFA-TR*             ,:VO-ORDER-REASON                                           
MFA-TR*             ,:VO-ORDER-TYPE-CD                                          
MFA-TR*             ,:VO-SERV-ORDER-STATUS                                      
MFA-TR*        FROM CSS_SO_DATA                                                 
MFA-TR*        WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO                          
MFA-TR*              AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')             
MFA-TR*              AND ORDER_TYPE_CD = :VO-ORDER-TYPE-CD                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                  MOVE 'CSR04366'              TO ABEND-PROGRAM         
                  MOVE '7300'                  TO ACTIVE-PARAGRAPH      
                  MOVE 'SELECT'                TO ABEND-FUNCTION        
                  MOVE 'CSS_SO_DATA'           TO TABLE-1               
                  MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1       
                  MOVE VO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1     
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7400-SECURED-RATES.                                         *           
      ***************************************************************           
      *                                                                         
       7400-SECURED-RATES.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-SECURED-RATE-IND                               
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                 
                     CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE UT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
                 AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE             
                 AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO               
                 AND RD.SECURED_RATE_FL = 'Y'                           
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SECURED-RATE-IND                                       
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT,                                       
MFA-TR*              CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE UT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*          AND UT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                     
MFA-TR*          AND UT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                       
MFA-TR*          AND RD.SECURED_RATE_FL = 'Y'                                   
MFA-TR*        WITH UR                                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SECURED-RATE-IND                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7400'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                 
                   MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7510-SELECT-FINAL-WO                                            *05330000
      ******************************************************************05330000
       7510-SELECT-FINAL-WO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                   A.GUARANTEED_IND                                     
              INTO                                                      
                   :FW-GUARANTEED-IND                                   
              FROM                                                      
                  CSS_FINAL_WO A WITH(READUNCOMMITTED)                          
              WHERE                                                     
                  ACCOUNT_NO = :FW-ACCOUNT-NO                           
                                                                 
                                                            
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            A.GUARANTEED_IND                                             
MFA-TR*       INTO                                                              
MFA-TR*            :FW-GUARANTEED-IND                                           
MFA-TR*       FROM                                                              
MFA-TR*           CSS_FINAL_WO A                                                
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO = :FW-ACCOUNT-NO                                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7510'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FINAL_WO'           TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE FW-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-SELECT-CATEGORY-ID.                                       *        
      ******************************************************************        
      *                                                                         
       7600-SELECT-CATEGORY-ID.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CATEGORY-CD                                    
                FROM CSS_CATEGORY F5 WITH(READUNCOMMITTED)                      
               WHERE F5.USER_ID      = :F5-USER-ID                      
                 AND F5.CATEGORY_ID  = 291                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CATEGORY-CD                                            
MFA-TR*         FROM CSS_CATEGORY F5                                            
MFA-TR*        WHERE F5.USER_ID      = :F5-USER-ID                              
MFA-TR*          AND F5.CATEGORY_ID  = 291                                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
                CONTINUE                                                
           WHEN NOT-FOUND                                               
                MOVE 'N'                TO WS-CATEGORY-CD               
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CATEGORY'       TO TABLE-1                      
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE  F5-USER-ID          TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-CHK-AR-TRAN-HIST.                                         *        
      ******************************************************************        
      *                                                                         
       7700-CHK-AR-TRAN-HIST.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-60-DAY-AR-IND                                  
                FROM CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED)                
               WHERE AR.ACCOUNT_NO      = :AR-ACCOUNT-NO                
                 AND AR.CODE_TRAN_TYPE  = 'T'                           
                 AND AR.DATE_TRANS   BETWEEN DATEADD( DAY, -60, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )     
                                     AND  CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                 AND AR.TRAN_COMMENT LIKE('TRANSFER F%')                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-60-DAY-AR-IND                                          
MFA-TR*         FROM CSS_AR_TRANS_HIST  AR                                      
MFA-TR*        WHERE AR.ACCOUNT_NO      = :AR-ACCOUNT-NO                        
MFA-TR*          AND AR.CODE_TRAN_TYPE  = 'T'                                   
MFA-TR*          AND AR.DATE_TRANS   BETWEEN CURRENT DATE - 60 DAYS             
MFA-TR*                              AND  CURRENT DATE                          
MFA-TR*          AND AR.TRAN_COMMENT LIKE('TRANSFER F%')                        
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
           WHEN SUCCESSFUL-CALL                                         
                CONTINUE                                                
           WHEN NOT-FOUND                                               
                MOVE 'N'                TO WS-60-DAY-AR-IND             
           WHEN OTHER                                                   
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7700'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE  AR-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-EVALUATE.                                                
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P0726D******************************************************************        
P0726D* 7900-GET-RULE-XREF-ID                                          *        
P0726D******************************************************************        
P0726D 7900-GET-RULE-XREF-ID.                                           
P0726D                                                                  
P0726D     EXEC SQL                                                     
P0726D        SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
P0726D          INTO :S-BUS-RULE-XREF-ID                                
P0726D          FROM CSS_BUS_RULE   [1R] WITH(READUNCOMMITTED)                  
P0726D              ,CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)               
P0726D         WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
P0726D           AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
P0726D                                       
P0726D                                                      
P0726D     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0726D                                                                  
P0726D     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
P0726D                                                                  
P0726D     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0726D        CONTINUE                                                  
P0726D     ELSE                                                         
P0726D        MOVE SPACES                    TO ABEND-TABLES            
P0726D        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P0726D        MOVE '7900'                    TO ACTIVE-PARAGRAPH        
P0726D        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P0726D        MOVE SQLCODE                   TO ABEND-SQLCODE           
P0726D        MOVE SQLSTATE                  TO ABEND-SQLSTATE          
P0726D        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P0726D        MOVE 'CSS_BUS_RULE'            TO TABLE-1                 
P0726D        MOVE 'BUS_RULE_ID'             TO TABLE-ELEMENT-1         
P0726D        MOVE S-BUS-RULE-ID             TO HOSTVAR-ELEMENT-1       
P0726D        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P0726D     END-IF.                                                      
P0726D                                                                  
P0726D 7900-EXIT.                                                       
P0726D     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR04366_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04366_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE 'CSR04366_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8010-INSERT-GTT.                                               *        
      ******************************************************************        
      *                                                                         
       8010-INSERT-GTT.                                                 
      *                                                                         
P0726D      IF S-BUS-RULE-ID > SPACES AND S-ARNG-TYPE > SPACES          
P0726D         PERFORM 7900-GET-RULE-XREF-ID THRU 7900-EXIT             
P0726D      END-IF                                                      
            EXEC SQL                                                    
               INSERT INTO #CSR04366_R1                          
                  (                                                     
                    RETURN_CODE                                         
P0726D             ,ARNG_TYPE                                           
P0726D             ,RULE_NOTIFY_TYPE_CD                                 
P0726D             ,BUS_RULE_ID                                         
P0726D             ,RULE_RESULT_CD                                      
P0726D             ,BUS_RULE_XREF_ID                                    
P0726D             ,MESSAGE_PARMS                                       
P0726D             ,LINK_PARMS                                          
P00726             ,SEASONAL_FLAG                                       
P0726E             ,CREDIT_ACTION_FL                                    
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE                                      
P0726D             ,:S-ARNG-TYPE                                        
P0726D             ,:S-RULE-NOTIFY-TYPE-CD                              
P0726D             ,:S-BUS-RULE-ID                                      
P0726D             ,:S-RULE-RESULT-CD                                   
P0726D             ,:S-BUS-RULE-XREF-ID                                 
P0726D             ,:S-MESSAGE-PARMS                                    
P0726D             ,:S-LINK-PARMS                                       
P00726             ,:S-SEASONAL-FLAG                                    
P0726E             ,:S-CREDIT-ACTION-FL                                 
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04366_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,ARNG_TYPE                                                   
MFA-TR*            ,RULE_NOTIFY_TYPE_CD                                         
MFA-TR*            ,BUS_RULE_ID                                                 
MFA-TR*            ,RULE_RESULT_CD                                              
MFA-TR*            ,BUS_RULE_XREF_ID                                            
MFA-TR*            ,MESSAGE_PARMS                                               
MFA-TR*            ,LINK_PARMS                                                  
MFA-TR*            ,SEASONAL_FLAG                                               
MFA-TR*            ,CREDIT_ACTION_FL                                            
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-ARNG-TYPE                                                
MFA-TR*            ,:S-RULE-NOTIFY-TYPE-CD                                      
MFA-TR*            ,:S-BUS-RULE-ID                                              
MFA-TR*            ,:S-RULE-RESULT-CD                                           
MFA-TR*            ,:S-BUS-RULE-XREF-ID                                         
MFA-TR*            ,:S-MESSAGE-PARMS                                            
MFA-TR*            ,:S-LINK-PARMS                                               
MFA-TR*            ,:S-SEASONAL-FLAG                                            
MFA-TR*            ,:S-CREDIT-ACTION-FL                                         
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            WS-RETURN-CODE              
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
              INITIALIZE                     S-RULE-NOTIFY-TYPE-CD      
                                             S-BUS-RULE-ID              
                                             S-RULE-RESULT-CD           
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'CSR04366_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
        8010-EXIT.                                                      
            EXIT.                                                       
      ************************************************************              
      * INCLUDE CPD0023C FOR ERROR HANDLING                                     
      ************************************************************              
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      ************************************************************              
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
