       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04363.                                          
       AUTHOR.       SRIDHAR.                                           
       DATE-WRITTEN. JUN 2010.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED TO     *        
      *  DELETE all CATEGORIES FOR A USER_ID.                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  06/03/2010 SRIDHAR   PRJ220 - INITIAL VERSION                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         5000 - 5999     Common Modules                         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04363'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04363 STARTS HERE'.                  
      *                                                                         
      *****************************************************************         
      *   RETURN FIELD AREA                                           *         
      *****************************************************************         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE               PIC S9(9) COMP VALUE ZERO.     
      *                                                                         
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE              PIC S9(9) COMP VALUE ZERO.     
      *                                                                         
       01 WS-MISC.                                                      
          05 PROGRAM-NAME                PIC X(08) VALUE 'CSR04363'.    
          05 WS-RETURN-CODE              PIC S9(9) USAGE COMP.          
          05 WS-USER-ID                  PIC X(07).                     
          05 WS-UPD-USERID               PIC X(07).                     
          05 WS-REGION                   PIC X(04).                     
          05 WS-CATEGORY-ID              PIC S9(9) USAGE COMP.          
          05 WS-CAT-COUNT                PIC S9(9) USAGE COMP.          
      *                                                                         
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
          05 WS-NO-MORE-DATA-CUR         PIC X(01) VALUE 'N'.           
             88 NO-MORE-DATA-CUR                   VALUE 'Y'.           
                                                                        
      ******************************************************************        
      * INDICATOR VARIABLES.                                           *        
      ******************************************************************        
      *                                                                         
       01 IND-VARIABLES.                                                
          05 WS-NULL-INDICATOR-1         PIC S9(04) COMP.               
          05 WS-NULL-INDICATOR-2         PIC S9(04) COMP.               
          05 WS-NULL-INDICATOR-3         PIC S9(04) COMP.               
          05 WS-NULL-INDICATOR-4         PIC S9(04) COMP.               
          05 WS-NULL-IND                 PIC S9(04) COMP.               
      *                                                                         
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SQL ERROR CHECKING COPY BOOKS.                                 *        
      ******************************************************************        
                                                                        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      *01  CSRERLOG-P.                                                          
           COPY CWSSP001.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR PROCEDURE DIVISION COPY BOOKS              *        
      ******************************************************************        
                                                                        
                                                                        
      *01  WS-11-TABLES.                                                        
      *Used in reducing embdded blanks.                                         
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      *    F5 - CSS_CATEGORY                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CY - CSS_CATEGORY_HIST                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCATHST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING COPY BOOK.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO POPULATE CATEGORIES FOR A USERID.                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE CAT_CURSOR CURSOR FOR                             
              SELECT                                                    
                     F5.CATEGORY_ID                                     
                FROM                                                    
                     CSS_CATEGORY F5 WITH(READUNCOMMITTED)                      
               WHERE                                                    
                     F5.USER_ID  = :F5-USER-ID                          
                 FOR READ ONLY                                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CAT_CURSOR CURSOR FOR                                     
MFA-TR*       SELECT                                                            
MFA-TR*              F5.CATEGORY_ID                                             
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CATEGORY F5                                            
MFA-TR*        WHERE                                                            
MFA-TR*              F5.USER_ID  = :F5-USER-ID                                  
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 2000                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-USER-ID                PIC X(07).                          
       01  I-UPD-USERID             PIC X(07).                          
       01  I-REGION                 PIC X(04).                          
      *                                                                         
       PROCEDURE DIVISION USING I-USER-ID                               
                               , I-UPD-USERID                           
                               , I-REGION.                              
      *                                                                         
      ******************************************************************        
      *0000-MAINLINE                                                   *        
      * CONTROLS THE MAIN PROCESSING OF THE PROGRAM.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT.                 
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *0100-INITIALIZATION.                                            *        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE                AS RETURN_CODE           
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          :S-RETURN-CODE                AS RETURN_CODE                   
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE I-USER-ID                TO WS-USER-ID.                 
           MOVE I-UPD-USERID             TO WS-UPD-USERID.              
           MOVE I-REGION                 TO WS-REGION.                  
                                                                        
           IF ((WS-USER-ID = SPACES) OR (WS-UPD-USERID = SPACES)        
                    OR (WS-REGION = SPACES)) THEN                       
            ADD  +1  TO CTR-ROWS                                        
            MOVE 200                    TO RS-RETURN-CODE               
            PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT                 
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT                  
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           ADD  +1  TO CTR-ROWS.                                        
           MOVE 'N'             TO WS-NO-MORE-DATA-CUR.                 
           MOVE 0               TO WS-RETURN-CODE.                      
           MOVE  WS-USER-ID     TO F5-USER-ID.                          
           PERFORM 7000-OPEN-CAT-CURSOR     THRU 7000-EXIT.             
           PERFORM 7010-FETCH-CAT-CURSOR    THRU 7010-EXIT.             
           PERFORM 2100-PROCESS-CAT-DEL  THRU 2100-EXIT                 
                                UNTIL NO-MORE-DATA-CUR.                 
           PERFORM 7030-CLOSE-CAT-CURSOR    THRU 7030-EXIT.             
           IF WS-CAT-COUNT = 0                                          
             MOVE 100 TO WS-RETURN-CODE                                 
           END-IF.                                                      
           MOVE WS-RETURN-CODE               TO RS-RETURN-CODE.         
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      * PREPARES RESULT SET ROW.                                       *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-CAT-DEL.                                          *        
      ******************************************************************        
       2100-PROCESS-CAT-DEL.                                            
      *                                                                         
            ADD  +1                 TO WS-CAT-COUNT.                    
            MOVE F5-CATEGORY-ID     TO WS-CATEGORY-ID.                  
            IF (WS-REGION = 'CSRP' OR WS-REGION = 'SEBP')               
              MOVE  WS-USER-ID        TO CY-USER-ID                     
              MOVE  WS-CATEGORY-ID    TO CY-CATEGORY-ID                 
              MOVE  WS-UPD-USERID     TO CY-LAST-UPDATE-USERID          
              MOVE  'D'               TO CY-ACTION-CD                   
              PERFORM 7040-INSERT-CAT-HIST   THRU 7040-EXIT             
            END-IF.                                                     
            PERFORM 7050-DEL-CAT    THRU 7050-EXIT.                     
            PERFORM 7010-FETCH-CAT-CURSOR    THRU 7010-EXIT.            
      *                                                                         
       2100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-CAT-CURSOR.                                         *         
      * OPENS CAT_CURSOR CURSOR.                                      *         
      ******************************************************************        
      *                                                                         
       7000-OPEN-CAT-CURSOR.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN CAT_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_CATEGORY'           TO TABLE-1                  
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE WS-USER-ID           TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-FETCH-CAT-CURSOR.                                        *         
      * FETCHES CAT_CURSOR CURSOR.                                    *         
      ******************************************************************        
       7010-FETCH-CAT-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              FETCH CAT_CURSOR                                          
               INTO :F5-CATEGORY-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'Y'                  TO WS-NO-MORE-DATA-CUR       
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                                                  RS-RETURN-CODE        
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '7010'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_CATEGORY'       TO TABLE-1                   
                 MOVE 'USER_ID'            TO TABLE-ELEMENT-1           
                 MOVE WS-USER-ID           TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-EVALUATE.                                                
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-CLOSE-CAT-CURSOR.                                        *         
      * CLOSES CAT_CURSOR CURSOR.                                     *         
      ******************************************************************        
       7030-CLOSE-CAT-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              CLOSE CAT_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_CATEGORY'           TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE WS-USER-ID            TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7040-INSERT INTO CATEGORY HISTORY TABLE                         *        
      ******************************************************************        
       7040-INSERT-CAT-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_CATEGORY_HIST                              
                   (USER_ID,                                            
                   LAST_UPDATE_TS,                                      
                   ACTION_CD,                                           
                   CATEGORY_ID,                                         
                   LAST_UPDATE_USERID                                   
                   )                                                    
             VALUES                                                     
                   (                                                    
                   :CY-USER-ID,                                         
                   CIS.CURRENT$TIMESTAMP(),                                   
                   :CY-ACTION-CD,                                       
                   :CY-CATEGORY-ID,                                     
                   :CY-LAST-UPDATE-USERID                               
                   )                                                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CATEGORY_HIST                                      
MFA-TR*            (USER_ID,                                                    
MFA-TR*            LAST_UPDATE_TS,                                              
MFA-TR*            ACTION_CD,                                                   
MFA-TR*            CATEGORY_ID,                                                 
MFA-TR*            LAST_UPDATE_USERID                                           
MFA-TR*            )                                                            
MFA-TR*      VALUES                                                             
MFA-TR*            (                                                            
MFA-TR*            :CY-USER-ID,                                                 
MFA-TR*            CURRENT TIMESTAMP,                                           
MFA-TR*            :CY-ACTION-CD,                                               
MFA-TR*            :CY-CATEGORY-ID,                                             
MFA-TR*            :CY-LAST-UPDATE-USERID                                       
MFA-TR*            )                                                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7040'             TO ACTIVE-PARAGRAPH               
              MOVE 'INSERT'           TO ABEND-FUNCTION                 
              MOVE 'CSS_CATEGORY_HIST' TO TABLE-1                       
              MOVE 'USER_ID'          TO TABLE-ELEMENT-1                
              MOVE 'CATEGORY_ID'      TO TABLE-ELEMENT-2                
              MOVE CY-USER-ID         TO HOSTVAR-ELEMENT-1              
              MOVE CY-CATEGORY-ID     TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7050-DELETE A CATEGORY ASSOCIATED TO USER ID                    *        
      ******************************************************************        
       7050-DEL-CAT.                                                    
      *                                                                         
           EXEC SQL                                                     
             DELETE  FROM                                               
                    F5                                      
             FROM CSS_CATEGORY F5
             WHERE F5.CATEGORY_ID = :F5-CATEGORY-ID                     
               AND F5.USER_ID     = :F5-USER-ID                         
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE  FROM                                                       
MFA-TR*             CSS_CATEGORY F5                                             
MFA-TR*      WHERE F5.CATEGORY_ID = :F5-CATEGORY-ID                             
MFA-TR*        AND F5.USER_ID     = :F5-USER-ID                                 
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *    EXEC SQL                                                             
      *      DELETE  FROM                                                       
      *             CSS_CATEGORY F5                                             
      *      WHERE CURRENT OF CAT_CURSOR                                        
      *      QUERYNO 7050                                                       
      *    END-EXEC                                                             
                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7050'             TO ACTIVE-PARAGRAPH               
              MOVE 'DELETE'           TO ABEND-FUNCTION                 
              MOVE 'CSS_CATEGORY'     TO TABLE-1                        
              MOVE 'USER_ID'          TO TABLE-ELEMENT-1                
              MOVE 'CATEGORY_ID'      TO TABLE-ELEMENT-2                
              MOVE F5-USER-ID         TO HOSTVAR-ELEMENT-1              
              MOVE F5-CATEGORY-ID     TO HOSTVAR-ELEMENT-2              
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
