       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04344.                                      
COB303 DATE-WRITTEN.  JUL 20,2010                                       
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ****                                                             *00100000
      ******************************************************************00110000
      *                 P R O G R A M  S U M M A R Y                   *00120000
      *                                                                *00130000
      *  THIS PROGRAM RETUNS BBP BPA DATA FOR SEB.                     *00140000
      *  RESULT SETS:                                                  *00150000
      *         1. ACCOUNT ELIGIBILTY FOR BBP                          *00160000
      *         2. IF ELIGIBLE, AVAILABLE OPTIONS                      *00170000
      *         3. OTHER MONTHLY PAYMENTS                              *00180000
      *         3. USAGE DETAILS                                       *00190000
      *         5. PLEASE PAY AMT DETAILS                              *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
P00220*  07/22/10  VP94820    PROCEDURE ORIGINALLY CODED.              *00280000
A02891*  11/09/10  GD97441    1.CHANGE DESCRIPTION OF OPTIONS.         *00290000
A02891*                       2.ADDED ON SIZE ERRROR CHECK TO COMPUTE  *00300000
A02891*                         STATEMENTS HAVING DENOMINATOR.         *00310000
A02891*                       3.ADD "WITH UR" AS NEEDED.               *00320000
ACT002*  12/14/10  GD97441   APPL 3118 : ADDED BUSINESS RULES BBP034   *00330000
ACT002*                      AND BBP035 FOR GROUP 2 CUSTOMERS.         *00340000
ACT003*  12/20/10  GD97441   1.MODIFIED CPD04344 BASED ON COMMON/      *00350000
ACT003*            APPL3118    DREG ONLY/GROUP 2 ONLY RULE CRITERIA.   *00360000
ACT003*                      2.FIXED DEREG/REG CHECK.                  *00370000
ACT003*                      3.FIXED BBP026 RULE CHECK: ACCT SCHEDULED *00380000
ACT003*                        TO BE BILLED IN NEXT 5 DAYS.            *00390000
ACT003*                      4.REMOVED 6100- FROM CPD04344 AND ADDED   *00400000
ACT003*                        ADDITIONAL COLUMNS TO 7050- PARA.       *00410000
ACT003*                      5.DELETED % GAS RATE INCR CHECK.          *00420000
ACT003*                      6.ADDED "EXIT" IN 7060-EXIT PARA.         *00430000
ACT003*                      7.ADDED BILL CYCLE CHECK IN 7100- PARA.   *00440000
ACT003*                      8.DELETED UNUSED CODE.                    *00450000
P00471*  08/04/11  AA97148   REPLACE SQL IN 7900- PARA TO CHECK FOR    *00460000
P00471*                      DPP DROP FROM CSS_ACCT_ATTRIBUTE.         *00470000
A03710** 11/01/11  VV94890   FIX FOR BLL-CYCLE SPACES ON PENDING ACCTS *00480000
P00473*  11/17/11  MN90523   CRM Versioning Changes                    *00490000
P00694** 01/29/13  VV94890  1)CHANGED CALLING CSR04600 INSTEAD CSR03689*00511000
P00694**  ***P00694*****    2)ADDED LOGIC FOR USAGE HISTORY IN RS-4    *00512000
P0694A**                    3)ADDED GAS AND ELECTRIC BUFFERS TO RS-4.  *00513000
P0694A**                    4)ADDED PRIVATE LIGHT, SUBDIVISION LIGHT & *00520000
P0694A**                      NON-ELIG-AMT TO RESULT-2.                *00530000
P0694B**                    5)MODIFIED VERBIAGE FOR ALL 4 BBP OPTIONS. *00540000
P0694C**                    6)ENABLED ROLLOVER OPTIONS.                *00550000
P0694D**                    7)SUPRESSED CURRENT BILL ROLLOVER OPTION.  *00551000
P0694E**                    8)NOT YET BILLED =>SHOW NEXT BILL OPT ONLY.*00552000
P0694F**                    9)MODIFIED VERBIAGE FOR ALL 3 BBP OPTIONS. *00553000
ACT248** 08/22/14  VIJAY    IGNORE ONETIME CONTRACTS.                  *00554000
ACT248** A04880                                                        *00555000
A04987** 11/04/14  VIJAY  1.USE PREMISE DDC BEFORE GETTING DEFAULT DDC.*00556000
A04987**                  2.ADD DEFAULT DDDC INTO REMARKS WHEN IT IS   *00557000
A04987**                    USED.                                      *00558000
ACT078** 03/27/15  MC95456  SELECT STATUS_CD FROM CSS_ACCT_RTPK_AGR    *00559000
ACT078** A05136-ACT078      FOR BUS RULE BBP011.                       *00559100
P00721** 06/01/15  MC95456  CHANGES MADE FOR PROFILE SCREEN TO RETURN  *00559200
P00721**                    BBP ELIGIBLE FLAG ALONE.                   *00559300
P00836** 04/02/16  MN90523  FOR WEB IF EXISTING OPTION IS FIXED PRICE  *00559401
P00836**                    SET BBP ELIGIBLE NO                        *00559501
P00836** 07/12/16  MS7M727  MOVED PARM-ELIGIBLE VALUE TO               *00559502
P00836**                    CALLING-PROGRAM  VALUE FOR VALIDATING      *00559503
P00836**                    BBP028                                     *00559504
      ******************************************************************00560000
      ******************************************************************00570000
      *                                                                *00580000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00590000
      *                                                                *00600000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00610000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00620000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00630000
      *  3000 - 4999  NOT USED                                         *00640000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00650000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00660000
      *  7000 - 7999  INPUT MODULES                                    *00670000
      *  8000 - 8999  OUTPUT MODULES                                   *00680000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00690000
      *                                                                *00700000
      ******************************************************************00710000
      *                                                                 00720000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00740000
       DATA DIVISION.                                                   
      *                                                                 00760000
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04344'.
MSQ017     COPY MFASQLM.
      *                                                                 00780000
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04344 STARTS HERE'.                 
      *                                                                 00810000
       01 WS-CONSTANTS.                                                 
      *                                                                 00830000
          05 WS-PPL-NSC              PIC S9(4) COMP VALUE +019.         
          05 WS-PPL-LPC              PIC S9(4) COMP VALUE +030.         
          05 WS-PPL-UTE              PIC S9(4) COMP VALUE +040.         
          05 WS-PPL-UTG              PIC S9(4) COMP VALUE +045.         
          05 WS-PPL-RCC              PIC S9(4) COMP VALUE +060.         
      *                                                                 00890000
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04344'.        
          05 MCSCB063                PIC X(08) VALUE 'MCSCB063'.        
          05 CSR03689                PIC X(08) VALUE 'CSR03689'.        
      *                                                                 00940000
ACT002** DELINQUENCY WS VARIABLES                                       00950000
ACT002    05 WS-GRP2-BBP-FROM-MM     PIC X(16) VALUE 'GRP2-BBP-FROM-MM'.
ACT002    05 WS-GRP2-BBP-TO-MM       PIC X(14) VALUE 'GRP2-BBP-TO-MM'.  
ACT002    05 WS-GRP2-DELINQ-FROM-MM  PIC 9(02) VALUE 0.                 
ACT002    05 WS-GRP2-DELINQ-TO-MM    PIC 9(02) VALUE 0.                 
ACT002    05 WS-GRP2-CHK-CURR-MM     PIC 9(02) VALUE 0.                 
          05 WS-PCT-ESTRATEINCR-GAS  PIC X(19) VALUE                    
                                     'PCT-ESTRATEINCR-GAS'.             
          05 WS-PCT-ESTRATEINCR-ELEC PIC X(20) VALUE                    
                                     'PCT-ESTRATEINCR-ELEC'.            
      *                                                                 01050000
A02891    05 WS-BBP-OPTN-CUR-BIL-TX1.                                   
A02891       10 FILLER               PIC X(50) VALUE                    
P0694F            'Current Bill - Pay BBP amount and past due charges'. 
A02891*                                                                 01090000
A02891    05 WS-BBP-OPTN-CUR-BIL-TX2.                                   
A02891       10 FILLER               PIC X(29) VALUE                    
P0694F                      'Current Bill - Pay BBP Amount'.            
A02891*                                                                 01130000
A02891    05 WS-BBP-OPTN-NXT-BIL-TX1.                                   
A02891       10 FILLER               PIC X(44) VALUE                    
P0694F            'Next Bill - Pay current and past due charges'.       
A02891*                                                                 01170000
A02891    05 WS-BBP-OPTN-NXT-BIL-TX2.                                   
A02891       10 FILLER               PIC X(31) VALUE                    
P0694F                         'Next Bill - Pay current charges'.       
A02891*                                                                 01210000
P0694D*   05 WS-BBP-OPTN-ROL-CUR-BIL.                                   01220000
P0694D*      10 FILLER               PIC X(35) VALUE                    01230000
P0694D*                     'Pay BBP amount only - include past '.      01240000
P0694D*      10 FILLER               PIC X(26) VALUE                    01250000
P0694D*                             'due charges in plan       '.       01260000
      *                                                                 01270000
A02891    05 WS-BBP-OPTN-ROL-NXT-BIL.                                   
A02891       10 FILLER               PIC X(48) VALUE                    
P0694F              'Next Bill - Pay past due charges only - include '. 
A02891       10 FILLER               PIC X(23) VALUE                    
P0694B                          'current charges in plan'.              
      *                                                                 01330000
       01 WS-MISC.                                                      
          05 RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.           
          05 WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
          05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                     
                                     PIC 9(13).                         
          05 WS-PREMISE-NO           PIC X(10) VALUE SPACES.            
          05 WS-PREMISE-NUM REDEFINES WS-PREMISE-NO                     
                                     PIC 9(10).                         
          05 WS-REV-MTH.                                                
             10 WS-REV-MTH-CCYY      PIC X(04).                         
             10 WS-REV-MTH-MM        PIC X(02).                         
          05 WS-REV-MTH-NUM REDEFINES WS-REV-MTH                        
                                     PIC 9(06).                         
          05 WS-PYMT-STRT-DT.                                           
             10 WS-PYMT-STRT-CCYY    PIC X(04).                         
             10 FILLER               PIC X(01)  VALUE '-'.              
             10 WS-PYMT-STRT-MM      PIC X(02).                         
             10 FILLER               PIC X(01)  VALUE '-'.              
             10 WS-PYMT-STRT-DD      PIC X(02)  VALUE '01'.             
          05 WS-GAS-TOTAL            PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-PVTL-TOTAL           PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-SUBL-TOTAL           PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-NONBBP-ELIG-AMT      PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.            
          05 WS-UTILITY-BAL-ED       PIC -Z(8)9.9(02).                  
          05 WS-UTILITY-ARR-ED       PIC -Z(8)9.9(02).                  
          05 WS-AMT-MO-PYMT-ED       PIC -Z(8)9.9(02).                  
          05 WS-AMT-BBP-EST-ED       PIC -Z(8)9.9(02).                  
          05 WS-AMT-TO-COLL-ED       PIC -Z(8)9.9(02).                  
          05 WS-ROLOVR-AMT-ED        PIC -Z(8)9.9(02).                  
A04987    05 WS-EPP-DEFAULT-DDDC-ED  PIC -Z(8)9.9(02).                  
          05 WS-GAS-RATE-INCR        PIC S9(01)V9(7) COMP-3 VALUE +0.   
          05 WS-ROLOVR-AMT           PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-AMT-MO-PYMT-RND      PIC S9(11) COMP-3 VALUE +0.        
          05 WS-AMT-MO-PYMT-HOLD     PIC S9(11) COMP-3 VALUE +0.        
          05 WS-RECV-AMT-HOLD        PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-MAX-RECV-AMT         PIC S9(9)V99 COMP-3 VALUE +0.      
          05 WS-SQLSTATE             PIC X(05) VALUE SPACES.            
          05 WS-GTT-NAME             PIC X(19) VALUE SPACES.            
          05 WS-REVENUE-MONTH        PIC X(10) VALUE SPACES.            
ACT078    05 WS-DISCONNECT-HIST      PIC X(24).                         
ACT078    05 WS-DISC-HIST-BYTES  REDEFINES WS-DISCONNECT-HIST           
ACT078                               PIC X(1) OCCURS 24.                
ACT078    05  WS-DISC-EXCEPTN-HIST   PIC X(24).                         
ACT078    05  WS-EXCEPTIONAL-HIST-BYTES   REDEFINES                     
ACT078        WS-DISC-EXCEPTN-HIST   PIC X(1) OCCURS 24.                
ACT078    05  WS-PREV-MNTH           PIC S9(4) COMP VALUE 0.            
ACT078    05  WS-DNP-COUNT           PIC S9(4) COMP VALUE 0.            
      *                                                                 01730000
          05 WS-NONBPP-ELIG-ARRAY.                                      
             10 WS-NONBBP-ELIG-DET   OCCURS 15 TIMES                    
                                     INDEXED BY WS-IDX-1.               
                15 WS-RECV-TYPE      PIC X(25).                         
COB305          15 WS-RECV-AMT        PIC S9(9)V99 COMP-3 VALUE 0.              
      *                                                                 01790000
          05 WS-UTIL-ARRS-ARRAY.                                        
             10 WS-UTIL-ARRS-DET     OCCURS 15 TIMES                    
                                     INDEXED BY WS-IDX-A.               
                15 WS-ARRS-TYPE      PIC X(25).                         
COB305          15 WS-ARRS-AMT        PIC S9(9)V99 COMP-3 VALUE 0.              
      *                                                                 01850000
          05 WS-UTIL-BAL-ARRAY.                                         
             10 WS-UTIL-BAL-DET      OCCURS 15 TIMES                    
                                     INDEXED BY WS-IDX-B.               
                15 WS-BAL-TYPE       PIC X(25).                         
COB305          15 WS-BAL-AMT        PIC S9(9)V99 COMP-3 VALUE 0.               
      *                                                                 01910000
          05 WS-REMARKS-TEXT.                                           
             10 WS-REMARKS           OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-R.               
                15 WS-REMARKS-CHAR   PIC X(01).                         
      *                                                                 01960000
          05 WS-RESULT-TEXT.                                            
             10 WS-RESULT            OCCURS 210 TIMES                   
                                     INDEXED BY WS-IDX-2.               
                15 WS-RESULT-CHAR    PIC X(01).                         
      *                                                                 02010000
          05 WS-PREV-CHAR            PIC X(01) VALUE SPACE.             
          05 WS-BBP-DPP-CUTOFF-DT    PIC X(10) VALUE SPACES.            
          05 WS-DPP-CUTOFF-DT        PIC X(10) VALUE SPACES.            
          05 WS-BBP-LIMIT            PIC S9(04) COMP VALUE 0.           
          05 WS-BBP-DROP-EXISTS      PIC X(01) VALUE 'N'.               
          05 WS-DPP-DROP-EXISTS      PIC X(01) VALUE 'N'.               
          05 WS-UTL-ARRS-EXISTS      PIC X(01) VALUE 'N'.               
          05 WS-DAYS-UTIL-ARRS       PIC S9(4)V9(5) COMP-3 VALUE 0.     
          05 WS-ROL-OVR-ELIG         PIC X(01) VALUE 'N'.               
          05 WS-ROL-OVR-ENABLD       PIC X(01) VALUE 'N'.               
          05 WS-DDDC-EDIT            PIC 9(02).9(04).                   
          05 WS-RATE-PRICE-EDIT      PIC 9(05).9(06).                   
          05 WS-CUST-SVC-CHRG-EDIT   PIC 9(02).9(02).                   
          05 WS-BBP-EST-AMT-NUM      PIC S9(11)V99 COMP-3 VALUE +0.     
P00694    05 WS-REVENUE-DATE.                                           
P00694       10 WS-YEAR              PIC X(04) VALUE SPACES.            
P00694       10 FILLER               PIC X(01) VALUE '-'.               
P00694       10 WS-MONTH             PIC X(02) VALUE SPACES.            
P00694       10 FILLER               PIC X(01) VALUE '-'.               
P00694       10 WS-DAY               PIC X(02) VALUE '01'.              
P00694    05 IND-01                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-02                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-03                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-04                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-05                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-06                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-07                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-08                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-09                  PIC S9(04) COMP VALUE 0.           
P00694    05 IND-10                  PIC S9(04) COMP VALUE 0.           
      *                                                                 02320000
P00694*01  LOC1            USAGE IS SQL TYPE IS                         
P00694*                    RESULT-SET-LOCATOR VARYING.                  
P00694*01  LOC2            USAGE IS SQL TYPE IS                         
P00694*                    RESULT-SET-LOCATOR VARYING.                  
      *                                                                 02370000
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-RULES            PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-OPTIONS          PIC S9(9) COMP VALUE 0.            
          05 WS-MTHLY-CHRGS          PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-USAGE            PIC S9(9) COMP VALUE 0.            
          05 WS-BBP-PLS-PAY          PIC S9(9) COMP VALUE 0.            
P00721    05 WS-BBP-ELIG             PIC S9(9) COMP VALUE 0.            
          05 WS-WNTR-SUMR-MTHS       PIC S9(9) COMP VALUE 0.            
      *                                                                 02460000
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.               
             88 SEND-DONE-ERROR                VALUE 'N'.               
             88 SEND-DONE-OK                   VALUE 'Y'.               
          05 WS-EOF-CURSOR           PIC X(01) VALUE 'N'.               
             88 NO-MORE-DATA                   VALUE 'Y'.               
          05 WS-COMPANY              PIC 9(01) VALUE ZERO.              
             88 SEB-DREG                       VALUE 1.                 
             88 SEB-REG                        VALUE 2.                 
          05 WS-REG-GRP              PIC 9(03) VALUE ZERO.              
             88 REG-GRP-1                      VALUE 100.               
             88 REG-GRP-2                      VALUE 200.               
          05 WS-BBP-ELIGIBLE         PIC 9(01) VALUE ZERO.              
             88 BBP-ELIGIBLE                   VALUE 1.                 
             88 BBP-NOT-ELIGIBLE               VALUE 2.                 
          05 WS-RESULT-TYPE          PIC 9(01) VALUE ZERO.              
             88 WS-RULES                       VALUE 1.                 
             88 WS-OPTIONS                     VALUE 2.                 
             88 WS-OTHR-PYMTS                  VALUE 3.                 
             88 WS-USAGE                       VALUE 4.                 
             88 WS-PLS-PAY-AMT                 VALUE 5.                 
      *                                                                 02680000
          05 WS-RETURN-CODE-1        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-2        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-3        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-4        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-5        PIC S9(4)    COMP VALUE 0.         
          05 WS-RETURN-CODE-6        PIC S9(4)    COMP VALUE 0.         
      *                                                                 02740000
       01 WS-04600-RETN-AREA.                                           
          05 WS-04600-RETURN-CODE    PIC S9(9) VALUE 0 COMP.            
          05 WS-04600-GAS-AMT        PIC X(13) VALUE SPACES.            
          05 WS-04600-SUBDIV-AMT     PIC X(13) VALUE SPACES.            
          05 WS-04600-PRIVATE-AMT    PIC X(13) VALUE SPACES.            
          05 WS-04600-EST-AMT        PIC X(13) VALUE SPACES.            
          05 WS-04600-EST-AMT-RND    PIC X(13) VALUE SPACES.            
          05 WS-04600-EST-AMT-EDIT   REDEFINES                          
             WS-04600-EST-AMT-RND    PIC -(9)9.99.                      
          05 WS-AGL-PASS-CHARGE      PIC X(13) VALUE SPACES.            
       01 WS-04600-AREA.                                                
          10 WS-04600-CHANNEL        PIC X(03) VALUE SPACES.            
          10 WS-04600-ACCOUNT-NO     PIC X(13) VALUE SPACES.            
          10 WS-04600-OPTION-CD      PIC X(12) VALUE SPACES.            
          10 WS-04600-RATE-PRICE     PIC X(12) VALUE SPACES.            
          10 WS-04600-DDDC           PIC X(07) VALUE SPACES.            
          10 WS-04600-CUST-SVC-FEE   PIC X(05) VALUE SPACES.            
          10 WS-04600-ZIP-CODE       PIC X(05) VALUE SPACES.            
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE           PIC S9(4)    COMP VALUE 0.         
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1      PIC S9(4)    COMP VALUE 0.         
             10 S-BUS-RULE-TYPE      PIC X(06)    VALUE SPACES.         
             10 S-BUS-RULE-RESULT    PIC X(01)    VALUE SPACES.         
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2      PIC S9(9)    COMP VALUE 0.         
             10 S-OPTION-SEQ-NO      PIC X(01)    VALUE SPACES.         
P0694F       10 S-OPTION-DESC        PIC X(75)    VALUE SPACES.         
             10 S-UTILITY-BALANCE    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-UTILITY-ARREARS    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-MO-PYMT        PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-ELEC-MO-PYMT   PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-GAS-MO-PYMT    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-UNMTRD-MO-PYMT PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-OTHER-PYMTS    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-AMT-ROLLOVR        PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-OPTN-PLS-PAY-AMT   PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-START-DATE         PIC X(10)    VALUE SPACES.         
             10 S-MTHS-ACCT-USAGE    PIC S9(9)    COMP VALUE 0.         
             10 S-MTHS-PREM-USAGE    PIC S9(9)    COMP VALUE 0.         
             10 S-BBP-BILL-FLAG      PIC X(01)    VALUE SPACES.         
             10 S-BBP-EST-AMT        PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-LAST-UPDATE-TS     PIC X(26)    VALUE SPACES.         
             10 S-REMARKS-TEXT       PIC X(210)   VALUE SPACES.         
             10 S-REMARKS-LENGTH     PIC S9(4)    COMP VALUE 0.         
P0694A       10 S-PVTL-TOTAL         PIC S9(9)V99 COMP-3 VALUE +0.      
P0694A       10 S-SUBL-TOTAL         PIC S9(9)V99 COMP-3 VALUE +0.      
P0694A       10 S-NONBBP-ELIG-AMT    PIC S9(9)V99 COMP-3 VALUE +0.      
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3      PIC S9(4)    COMP VALUE 0.         
             10 S-CNT-NAME-DESC      PIC X(30)    VALUE SPACES.         
             10 S-CNT-AMT-MO-PYMT    PIC S9(9)V99 COMP-3 VALUE +0.      
             10 S-CNT-PYMTS-REMAIN   PIC S9(9)    COMP VALUE 0.         
             10 S-CNT-EXPIRY-DT      PIC X(10)    VALUE SPACES.         
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4      PIC S9(4)    COMP VALUE 0.         
             10 S-REVENUE-MONTH      PIC X(10)    VALUE SPACES.         
             10 S-DAYS               PIC S9(4)    COMP VALUE 0.         
             10 S-UNITS              PIC S9(9)    COMP-3 VALUE 0.       
             10 S-CODE-UTIL-TYPE     PIC X(1)     VALUE SPACES.         
             10 S-CUSTOMER-NO        PIC S9(10)   COMP-3 VALUE 0.       
             10 S-NEW-CHARGE         PIC S9(9)V9(2)                     
                                                  COMP-3 VALUE 0.       
             10 S-RATE-PLAN-NO       PIC X(3)     VALUE SPACES.         
             10 S-CALC-ERROR         PIC X(08)    VALUE SPACES.         
             10 S-HTG-CLG-SW         PIC S9(03)   COMP-3 VALUE ZEROES.  
             10 S-BPP-CATEGORY       PIC X(1)     VALUE SPACES.         
P0694A       10 S-ELEC-BUFFER        PIC S9(4)V9(5)                     
P0694A                                            COMP-3 VALUE 0.       
P0694A       10 S-GAS-BUFFER         PIC S9(4)V9(5)                     
P0694A                                            COMP-3 VALUE 0.       
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5      PIC S9(4)    COMP VALUE 0.         
             10 S-OPTN-SEQ-NO-5      PIC X(01)    VALUE SPACES.         
             10 S-AR-TYPE-DESC       PIC X(25)    VALUE SPACES.         
             10 S-PLS-PAY-DET-AMT    PIC S9(9)V99 COMP-3 VALUE +0.      
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6      PIC S9(4)    COMP VALUE 0.         
             10 S-BBP-ELIGIBLE       PIC X(01)    VALUE SPACES.         
      *                                                                 03520000
      ******************************************************************03530000
      *               COBOL WORKING STORAGE COPY BOOKS                 *03540000
      ******************************************************************03550000
      *                                                                 03560000
      ******************************************************************03570000
      *    ERROR HANDLING                                               03580000
      ******************************************************************03590000
      *                                                                 03600000
           EXEC SQL                                                     03610000
              INCLUDE CWSX0010                                          03620000
           END-EXEC.                                                    03630000
      *                                                                 03640000
      ******************************************************************03650000
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *03660000
      ******************************************************************03670000
      *                                                                 03680000
           COPY CWS00303.                                               03690000
                                                                        
      *                                                                 03710000
      ******************************************************************03720000
      *    COPYBOOK FOR CPD00309                                       *03730000
      ******************************************************************03740000
      *                                                                 03750000
           EXEC SQL                                                     03760000
              INCLUDE CWS00309                                          03770000
           END-EXEC.                                                    03780000
      *                                                                 03790000
      ******************************************************************03800000
      *    COPYBOOK FOR CPD04344                                       *03810000
      ******************************************************************03820000
      *                                                                 03830000
           EXEC SQL                                                     03840000
              INCLUDE CWS04344                                          03850000
           END-EXEC.                                                    03860000
      *                                                                 03870000
      ******************************************************************03880000
      *    COPYBOOK FOR MCSCB063                                       *03890000
      ******************************************************************03900000
      *                                                                 03910000
           EXEC SQL                                                     03920000
              INCLUDE CWS00063                                          03930000
           END-EXEC.                                                    03940000
      *                                                                 03950000
      ******************************************************************03960000
      *    SQL COMMUNICATION AREA                                      *03970000
      ******************************************************************03980000
      *                                                                 03990000
           EXEC SQL                                                     04000000
               INCLUDE SQLCA                                            04010000
           END-EXEC.                                                    04020000
      *                                                                 04030000
      ******************************************************************04040000
      *    CSS_AR_CNTL  - AC                                           *04050000
      ******************************************************************04060000
      *                                                                 04070000
           EXEC SQL                                                     04080000
               INCLUDE TBARCNTL                                         04090000
           END-EXEC.                                                    04100000
      *                                                                 04110000
      ******************************************************************04120000
      *    CSS_ACCOUNT  - AT                                           *04130000
      ******************************************************************04140000
      *                                                                 04150000
           EXEC SQL                                                     04160000
                INCLUDE TBACCT                                          04170000
           END-EXEC.                                                    04180000
      *                                                                 04190000
      ******************************************************************04200000
      *    CSS_BILLING_HDR - BI                                        *04210000
      ******************************************************************04220000
      *                                                                 04230000
           EXEC SQL                                                     04240000
               INCLUDE TBBLLHDR                                         04250000
           END-EXEC.                                                    04260000
      *                                                                 04270000
      ******************************************************************04280000
      *    CSS_BUDGET_HIST - BH                                        *04290000
      ******************************************************************04300000
      *                                                                 04310000
           EXEC SQL                                                     04320000
               INCLUDE TBBGTHST                                         04330000
           END-EXEC.                                                    04340000
      *                                                                 04350000
      ******************************************************************04360000
      *    CSS_BILL_WINDOW - BN                                        *04370000
      ******************************************************************04380000
      *                                                                 04390000
           EXEC SQL                                                     04400000
               INCLUDE TBBILWDW                                         04410000
           END-EXEC.                                                    04420000
      *                                                                 04430000
      ******************************************************************04440000
      *    CSS_DELINQUENCY - C8                                        *04450000
      ******************************************************************04460000
      *                                                                 04470000
           EXEC SQL                                                     04480000
               INCLUDE TBDELQ                                           04490000
           END-EXEC.                                                    04500000
      *                                                                 04510000
      ******************************************************************04520000
      *    CSS_CONTRACT - CT                                           *04530000
      ******************************************************************04540000
      *                                                                 04550000
           EXEC SQL                                                     04560000
               INCLUDE TBCNTRCT                                         04570000
           END-EXEC.                                                    04580000
      *                                                                 04590000
      ******************************************************************04600000
      *    CSS_CREDIT_PROFILE- CZ                                     * 04610000
      ******************************************************************04620000
      *                                                                 04630000
           EXEC SQL                                                     04640000
               INCLUDE TBCRPROF                                         04650000
           END-EXEC.                                                    04660000
      *                                                                 04670000
      ******************************************************************04680000
      *    CSS_DFA_ACCR - DA                                            04690000
      ******************************************************************04700000
      *                                                                 04710000
           EXEC SQL                                                     04720000
               INCLUDE TBDFAACT                                         04730000
           END-EXEC.                                                    04740000
      *                                                                 04750000
      ******************************************************************04760000
      *    CSS_DEP_REQ - DR                                            *04770000
      ******************************************************************04780000
      *                                                                 04790000
           EXEC SQL                                                     04800000
               INCLUDE TBDEPREQ                                         04810000
           END-EXEC.                                                    04820000
      *                                                                 04830000
      ******************************************************************04840000
      *    CSS_DFA_DESC - DS                                           *04850000
      ******************************************************************04860000
      *                                                                 04870000
           EXEC SQL                                                     04880000
               INCLUDE TBDFADES                                         04890000
           END-EXEC.                                                    04900000
      *                                                                 04910000
      ******************************************************************04920000
      *    CSS_ADDR_FORMATTED - DY                                      04930000
      ******************************************************************04940000
      *                                                                 04950000
           EXEC SQL                                                     04960000
                INCLUDE TBADRFMT                                        04970000
           END-EXEC.                                                    04980000
      *                                                                 04990000
      ******************************************************************05000000
      *    CSS_FIXED_FCTR - FF                                         *05010000
      ******************************************************************05020000
      *                                                                 05030000
           EXEC SQL                                                     05040000
               INCLUDE TBFXDFCT                                         05050000
           END-EXEC.                                                    05060000
      *                                                                 05070000
      ******************************************************************05080000
      *    CSS_ACTT_RTPK_AGR - D4                                      *05090000
      ******************************************************************05100000
      *                                                                 05110000
           EXEC SQL                                                     05120000
               INCLUDE TBACCTRG                                         05130000
           END-EXEC.                                                    05140000
      *                                                                 05150000
      ******************************************************************05160000
      *    CRM_RT_PKG_OPTION - FI                                      *05170000
      ******************************************************************05180000
      *                                                                 05190000
           EXEC SQL                                                     05200000
               INCLUDE TBRTPKGO                                         05210000
           END-EXEC.                                                    05220000
      *                                                                 05230000
      ******************************************************************05240000
      *    CSS_JOB_PARM - G6                                           *05250000
      ******************************************************************05260000
      *                                                                 05270000
           EXEC SQL                                                     05280000
               INCLUDE TBJBPARM                                         05290000
           END-EXEC.                                                    05300000
      *                                                                 05310000
      ******************************************************************05320000
      *    CSS_RATE_COMP_DEF - J1                                      *05330000
      ******************************************************************05340000
      *                                                                 05350000
           EXEC SQL                                                     05360000
               INCLUDE TBRTCDEF                                         05370000
           END-EXEC.                                                    05380000
      *                                                                 05390000
      ******************************************************************05400000
      *    CSS_CONTRACT_INFO - K6                                      *05410000
      ******************************************************************05420000
      *                                                                 05430000
           EXEC SQL                                                     05440000
               INCLUDE TBCNTINF                                         05450000
           END-EXEC.                                                    05460000
      *                                                                 05470000
      ******************************************************************05480000
      *    CSS_REG_PROFILE - LR                                       * 05490000
      ******************************************************************05500000
      *                                                                 05510000
           EXEC SQL                                                     05520000
               INCLUDE TBREGPRF                                         05530000
           END-EXEC.                                                    05540000
      *                                                                 05550000
      ******************************************************************05560000
      *    CSS_AR_TYPE  - L5                                           *05570000
      ******************************************************************05580000
      *                                                                 05590000
           EXEC SQL                                                     05600000
               INCLUDE TBARTYPE                                         05610000
           END-EXEC.                                                    05620000
      *                                                                 05630000
      ******************************************************************05640000
      *    CSS_NSF_HIST - NH                                           *05650000
      ******************************************************************05660000
      *                                                                 05670000
           EXEC SQL                                                     05680000
               INCLUDE TBNSFHST                                         05690000
           END-EXEC.                                                    05700000
      *                                                                 05710000
      ******************************************************************05720000
      *    CSS_PROJ_SHARE - PJ                                         *05730000
      ******************************************************************05740000
      *                                                                 05750000
           EXEC SQL                                                     05760000
                INCLUDE TBPRJSHR                                        05770000
           END-EXEC.                                                    05780000
      *                                                                 05790000
      ******************************************************************05800000
      *    CSS_PREMISE  - PR                                           *05810000
      ******************************************************************05820000
      *                                                                 05830000
           EXEC SQL                                                     05840000
                INCLUDE TBPREM                                          05850000
           END-EXEC.                                                    05860000
      *                                                                 05870000
      ******************************************************************05880000
      *    CSS_RATE_PLAN_DESC - RD                                     *05890000
      ******************************************************************05900000
      *                                                                 05910000
           EXEC SQL                                                     05920000
               INCLUDE TBRTDESC                                         05930000
           END-EXEC.                                                    05940000
      ******************************************************************05950000
      *    CSS_RATE_TOU_DEF - RJ                                       *05960000
      ******************************************************************05970000
      *                                                                 05980000
           EXEC SQL                                                     05990000
               INCLUDE TBRTTOUD                                         06000000
           END-EXEC.                                                    06010000
      *                                                                 06020000
      *                                                                 06030000
      ******************************************************************06040000
      *    CSS_RATE_CREATOR - RT                                       *06050000
      ******************************************************************06060000
      *                                                                 06070000
           EXEC SQL                                                     06080000
               INCLUDE TBRTCRTR                                         06090000
           END-EXEC.                                                    06100000
      *                                                                 06110000
      ******************************************************************06120000
      *    CSS_UTL_ENVRMNT - UT                                        *06130000
      ******************************************************************06140000
      *                                                                 06150000
           EXEC SQL                                                     06160000
               INCLUDE TBUTLENV                                         06170000
           END-EXEC.                                                    06180000
      *                                                                 06190000
      ******************************************************************06200000
      *    CSS_ACCT_ATTRIBUTE - YP                                    * 06210000
      ******************************************************************06220000
      *                                                                 06230000
           EXEC SQL                                                     06240000
               INCLUDE TBACTATT                                         06250000
           END-EXEC.                                                    06260000
      *                                                                 06270000
      ******************************************************************06280000
      * WORKING STORAGE COPYBOOKS FOR CPD04344                         *06290000
      ******************************************************************06300000
      *                                                                 06310000
          COPY CWS00056.                                                06320000
      *                                                                 06330000
      ******************************************************************06340000
      *    DECLARE CURSOR TO GET ALL RECEIVABLES                       *06350000
      ******************************************************************06360000
      *                                                                 06370000
           EXEC SQL                                                     
               DECLARE AR_CURSOR CURSOR FOR                             
                       SELECT                                           
                              AC.AMT_AR_DAY_00                          
                             ,AC.AMT_AR_DAY_30                          
                             ,AC.AMT_AR_DAY_60                          
                             ,AC.AMT_AR_DAY_90                          
                             ,AC.AMT_UNUSED_CR                          
                             ,AC.AMT_TRAN_BALANCE                       
                             ,AC.TOT_SUMM_UNBILLED                      
                             ,AC.PYMT_PRIORITY_LVL                      
                             ,L5.AR_TYPE_LONG_DESC                      
                             ,AC.ITEM_ID                                
                         FROM                                           
                              CSS_AR_CNTL  AC WITH(READUNCOMMITTED)             
                             ,CSS_AR_TYPE  L5 WITH(READUNCOMMITTED)             
                        WHERE                                           
                              AC.ACCOUNT_NO = :AC-ACCOUNT-NO            
                          AND AC.PYMT_PRIORITY_LVL                      
                                            = L5.PYMT_PRIORITY_LVL      
                     ORDER BY                                           
                              PYMT_PRIORITY_LVL ASC                     
                             ,ITEM_ID DESC                              
               FOR READ ONLY                                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06380000
MFA-TR*        DECLARE AR_CURSOR CURSOR FOR                             06390000
MFA-TR*                SELECT                                           06400000
MFA-TR*                       AC.AMT_AR_DAY_00                          06410000
MFA-TR*                      ,AC.AMT_AR_DAY_30                          06420000
MFA-TR*                      ,AC.AMT_AR_DAY_60                          06430000
MFA-TR*                      ,AC.AMT_AR_DAY_90                          06440000
MFA-TR*                      ,AC.AMT_UNUSED_CR                          06450000
MFA-TR*                      ,AC.AMT_TRAN_BALANCE                       06460000
MFA-TR*                      ,AC.TOT_SUMM_UNBILLED                      06470000
MFA-TR*                      ,AC.PYMT_PRIORITY_LVL                      06480000
MFA-TR*                      ,L5.AR_TYPE_LONG_DESC                      06490000
MFA-TR*                      ,AC.ITEM_ID                                06500000
MFA-TR*                  FROM                                           06510000
MFA-TR*                       CSS_AR_CNTL  AC                           06520000
MFA-TR*                      ,CSS_AR_TYPE  L5                           06530000
MFA-TR*                 WHERE                                           06540000
MFA-TR*                       AC.ACCOUNT_NO = :AC-ACCOUNT-NO            06550000
MFA-TR*                   AND AC.PYMT_PRIORITY_LVL                      06560000
MFA-TR*                                     = L5.PYMT_PRIORITY_LVL      06570000
MFA-TR*              ORDER BY                                           06580000
MFA-TR*                       PYMT_PRIORITY_LVL ASC                     06590000
MFA-TR*                      ,ITEM_ID DESC                              06600000
MFA-TR*        FOR FETCH ONLY                                           06610000
MFA-TR*               WITH UR                                           06620000
MFA-TR*               QUERYNO 7500                                      06630000
MFA-TR*    END-EXEC.                                                    06640000
      *                                                                 06650000
      *01 LOC-RESLTSET USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.    
      *                                                                 06670000
       01  WS-END                        PIC X(40)                      
           VALUE 'WORKING STORAGE FOR CSR04344 ENDS HERE  '.
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_CUR_1 CURSOR
MSQ001          FOR CALL CSR04600( ' '
                  , :WS-04600-ACCOUNT-NO
                  , :WS-04600-OPTION-CD
                  , :WS-04600-RATE-PRICE
                  , :WS-04600-DDDC
                  , :WS-04600-CUST-SVC-FEE
                  , :WS-04600-ZIP-CODE
                  )
MSQ001        END-EXEC.
            
      *                                                                 06700000
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC  X(13).                    
P00721 01  PARM-ELIGIBLE                 PIC  X(01).                    
      *                                                                 06730000
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
P00721                         ,PARM-ELIGIBLE.                          
      *                                                                 06750000
      ******************************************************************06760000
      * 0000-MAINLINE                                                  *06770000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *06780000
      ******************************************************************06790000
      *                                                                 06800000
       0000-MAINLINE.                                                   
      *                                                                 06820000
           PERFORM 0100-INITIALIZE       THRU 0100-EXIT.                
           PERFORM 1000-PROCESS-INPUT    THRU 1000-EXIT.                
           PERFORM 2000-PROCESS-OUTPUT   THRU 2000-EXIT.                
           PERFORM 9999-END-PROGRAM      THRU 9999-EXIT.                
      *                                                                 06870000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06900000
      ******************************************************************06910000
      * 0100-INITIALIZE                                                *06920000
      ******************************************************************06930000
      *                                                                 06940000
       0100-INITIALIZE.                                                 
      *                                                                 06960000
P00836     MOVE PARM-ELIGIBLE            TO CALLING-PROGRAM.            
                                                                        
           PERFORM 7000-GET-CUR-DATE     THRU 7000-EXIT.                
      *                                                                 06980000
P00721     IF PARM-ELIGIBLE = SPACES                                    
P00721        PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT             
P00721     ELSE                                                         
P00721        PERFORM 0100B-DECLARE-GTT     THRU 0100B-EXIT             
P00721     END-IF.                                                      
      *                                                                 07000000
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04344_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07010000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            07020000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07030000
MFA-TR*        SELECT                                                   07040000
MFA-TR*           *                                                     07050000
MFA-TR*        FROM                                                     07060000
MFA-TR*            SESSION.CSR04344_R1                                  07070000
MFA-TR*    END-EXEC.                                                    07080000
      *                                                                 07090000
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04344_R2                                  
               ORDER BY OPTN_PLS_PAY_AMT DESC                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07100000
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            07110000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07120000
MFA-TR*        SELECT                                                   07130000
MFA-TR*           *                                                     07140000
MFA-TR*        FROM                                                     07150000
MFA-TR*            SESSION.CSR04344_R2                                  07160000
MFA-TR*        ORDER BY OPTN_PLS_PAY_AMT DESC                           07170000
MFA-TR*    END-EXEC.                                                    07180000
      *                                                                 07190000
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04344_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07200000
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                            07210000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07220000
MFA-TR*        SELECT                                                   07230000
MFA-TR*           *                                                     07240000
MFA-TR*        FROM                                                     07250000
MFA-TR*            SESSION.CSR04344_R3                                  07260000
MFA-TR*    END-EXEC.                                                    07270000
      *                                                                 07280000
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04344_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07290000
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                            07300000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07310000
MFA-TR*        SELECT                                                   07320000
MFA-TR*           *                                                     07330000
MFA-TR*        FROM                                                     07340000
MFA-TR*            SESSION.CSR04344_R4                                  07350000
MFA-TR*    END-EXEC.                                                    07360000
      *                                                                 07370000
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  *                                                     
               FROM                                                     
                   #CSR04344_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07380000
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                            07390000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07400000
MFA-TR*        SELECT                                                   07410000
MFA-TR*           *                                                     07420000
MFA-TR*        FROM                                                     07430000
MFA-TR*            SESSION.CSR04344_R5                                  07440000
MFA-TR*    END-EXEC.                                                    07450000
      *                                                                 07450100
P00721     EXEC SQL                                                     
P00721         DECLARE C6 CURSOR                             
P00721                           WITH ROWSET POSITIONING FOR            
P00721         SELECT                                                   
P00721            *                                                     
P00721         FROM                                                     
P00721             #CSR04344_R6                                  
P00721     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07451000
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                            07461000
MFA-TR*                          WITH ROWSET POSITIONING FOR            07462000
MFA-TR*        SELECT                                                   07463000
MFA-TR*           *                                                     07464000
MFA-TR*        FROM                                                     07465000
MFA-TR*            SESSION.CSR04344_R6                                  07466000
MFA-TR*    END-EXEC.                                                    07467000
      *                                                                 07468000
           INITIALIZE WS-NONBPP-ELIG-ARRAY                              
                      WS-UTIL-ARRS-ARRAY                                
                      WS-UTIL-BAL-ARRAY.                                
           SET WS-IDX-1                  TO 1.                          
           SET WS-IDX-A                  TO 1.                          
           SET WS-IDX-B                  TO 1.                          
      *                                                                 07530000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07560000
      ******************************************************************07570000
      * 0100A-DECLARE-GTT                                              *07580000
      ******************************************************************07590000
      *                                                                 07600000
       0100A-DECLARE-GTT.                                               
      *                                                                 07620000
           MOVE 'SESSION.CSR04344_R1'    TO WS-GTT-NAME.                
           SET  WS-RULES                 TO TRUE.                       
      *                                                                 07650000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04344_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04344_R1
              (                                                       
                    RETURN_CODE       INT                           
                   ,BUS_RULE_TYPE CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BUS_RULE_RESULT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07750000
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 07790000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 07990000
           MOVE 'SESSION.CSR04344_R2'    TO WS-GTT-NAME.                
           SET  WS-OPTIONS               TO TRUE.                       
      *                                                                 08020000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04344_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04344_R2
              (                                                       
                    RETURN_CODE         INT                         
                   ,OPTION_SEQ_NO CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P0694F             ,OPTION_DESC CHAR(75)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,UTILITY_BALANCE     DECIMAL(11,2)                   
                   ,UTILITY_ARREARS     DECIMAL(11,2)                   
                   ,AMT_MO_PYMT         DECIMAL(11,2)                   
                   ,AMT_ELEC_MO_PYMT    DECIMAL(11,2)                   
                   ,AMT_GAS_MO_PYMT     DECIMAL(11,2)                   
                   ,AMT_UNMTRD_MO_PYMT  DECIMAL(11,2)                   
                   ,AMT_OTHER_PYMTS     DECIMAL(11,2)                   
                   ,AMT_ROLLOVR         DECIMAL(11,2)                   
                   ,OPTN_PLS_PAY_AMT    DECIMAL(11,2)                   
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,MTHS_ACCT_USAGE     INT                         
                   ,MTHS_PREM_USAGE     INT                         
                   ,BBP_BILL_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,BBP_EST_AMT         DECIMAL(11,2)                   
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,REMARKS_TEXT CHAR(210)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,REMARKS_LENGTH      SMALLINT                        
P0694A             ,PVTL_TOTAL          DECIMAL(11,2)                   
P0694A             ,SUBL_TOTAL          DECIMAL(11,2)                   
P0694A             ,NONBBP_ELIG_AMT     DECIMAL(11,2)                   
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08320000
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 08360000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS THRU 8000B-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
                 MOVE 'CSR04344_R2'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08560000
           MOVE 'SESSION.CSR04344_R3'    TO WS-GTT-NAME.                
           SET  WS-OTHR-PYMTS            TO TRUE.                       
      *                                                                 08590000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04344_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04344_R3
              (                                                       
                    RETURN_CODE       INT                           
                   ,CNT_NAME_DESC CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CNT_AMT_MO_PYMT   DECIMAL(11,2)                     
                   ,CNT_PYMTS_REMAIN  INT                           
                   ,CNT_EXPIRY_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08710000
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 08750000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS THRU 8000C-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
                 MOVE 'CSR04344_R3'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 08950000
           MOVE 'SESSION.CSR04344_R4'    TO WS-GTT-NAME.                
           SET  WS-USAGE                 TO TRUE.                       
      *                                                                 08980000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04344_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04344_R4
              (                                                       
                    RETURN_CODE       INT                           
                   ,REVENUE_MONTH CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,DAYS              SMALLINT                          
                   ,UNITS             DECIMAL(9,0)                      
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CUSTOMER_NO       DECIMAL(10,0)                     
                   ,NEW_CHARGE        DECIMAL(11,2)                     
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CALC_ERROR CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,HTG_CLG_SW        DECIMAL(3,0)                      
                   ,EPP_CATEGORY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P0694A             ,ELEC_BUFFER       DECIMAL(9,5)                      
P0694A             ,GAS_BUFFER        DECIMAL(9,5)                      
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09180000
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 09220000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS THRU 8000D-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
                 MOVE 'CSR04344_R4'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09420000
           MOVE 'SESSION.CSR04344_R5'    TO WS-GTT-NAME.                
           SET  WS-PLS-PAY-AMT           TO TRUE.                       
      *                                                                 09450000
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04344_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04344_R5
              (                                                       
                    RETURN_CODE       INT                           
                   ,OPTION_SEQ_NO CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,AR_TYPE_DESC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,PLS_PAY_DET_AMT   DECIMAL(11,2)                     
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09560000
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 09600000
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS THRU 8000E-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                               ABEND-TABLES             
                 MOVE 'CSR04344_R5'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                 09800000
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 09830000
P00721******************************************************************09831000
P00721* 0100B-DECLARE-GTT                                              *09832000
P00721******************************************************************09833000
P00721*                                                                 09834000
P00721 0100B-DECLARE-GTT.                                               
P00721*                                                                 09836000
P00721     MOVE 'SESSION.CSR04344_R1'    TO WS-GTT-NAME.                
P00721     SET  WS-RULES                 TO TRUE.                       
P00721*                                                                 09836300
P00721     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04344_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04344_R1
              (                                                       
P00721              RETURN_CODE       INT                           
P00721             ,BUS_RULE_TYPE CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00721             ,BUS_RULE_RESULT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00721          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00721*                                                                 09837300
P00721     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-1.            
P00721*                                                                 09837700
P00721     IF WS-SQLSTATE = '42710'                                     
P00721        PERFORM 8000A-DEL-GTT-ROWS THRU 8000A-EXIT                
P00721     ELSE                                                         
P00721        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00721           CONTINUE                                               
P00721        ELSE                                                      
P00721           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
P00721           MOVE '0100B'            TO ACTIVE-PARAGRAPH            
P00721           MOVE SQLCODE            TO ABEND-SQLCODE               
P00721           MOVE SQLSTATE           TO ABEND-SQLSTATE              
P00721           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
P00721           MOVE SPACES             TO ABEND-SQL-PREDICATES        
P00721                                      ABEND-TABLES                
P00721           MOVE WS-GTT-NAME        TO TABLE-1                     
P00721           MOVE SPACES             TO TABLE-ELEMENT-1             
P00721           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
P00721           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00721        END-IF                                                    
P00721     END-IF.                                                      
P00721*                                                                 09843400
P00721     MOVE 'SESSION.CSR04344_R6'    TO WS-GTT-NAME.                
P00721     SET  WS-RULES                 TO TRUE.                       
P00721*                                                                 09843700
P00721     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04344_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04344_R6
              (                                                       
P00721              RETURN_CODE       INT                           
P00721             ,BBP_ELIGIBLE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
P00721          )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00721*                                                                 09844700
P00721     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-1.            
P00721*                                                                 09845100
P00721     IF WS-SQLSTATE = '42710'                                     
P00721        PERFORM 8000F-DEL-GTT-ROWS THRU 8000A-EXIT                
P00721     ELSE                                                         
P00721        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00721           CONTINUE                                               
P00721        ELSE                                                      
P00721           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
P00721           MOVE '0100B'            TO ACTIVE-PARAGRAPH            
P00721           MOVE SQLCODE            TO ABEND-SQLCODE               
P00721           MOVE SQLSTATE           TO ABEND-SQLSTATE              
P00721           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
P00721           MOVE SPACES             TO ABEND-SQL-PREDICATES        
P00721                                      ABEND-TABLES                
P00721           MOVE WS-GTT-NAME        TO TABLE-1                     
P00721           MOVE SPACES             TO TABLE-ELEMENT-1             
P00721           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
P00721           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
P00721        END-IF                                                    
P00721     END-IF.                                                      
P00721*                                                                 09847100
P00721 0100B-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************09851000
      * 1000-PROCESS-INPUT                                             *09852000
      ******************************************************************09860000
      *                                                                 09870000
       1000-PROCESS-INPUT.                                              
      *                                                                 09890000
           MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO.              
           MOVE WS-ACCOUNT-NUM           TO AC-ACCOUNT-NO               
                                            AT-ACCOUNT-NO               
                                            BH-ACCOUNT-NO               
                                            CT-ACCOUNT-NO               
ACT002                                      CZ-ACCOUNT-NO               
                                            DA-ACCOUNT-NO               
                                            FF-ACCOUNT-NO               
                                            PJ-ACCOUNT-NO               
                                            LR-ACCOUNT-NO               
                                            UT-ACCOUNT-NO               
ACT078                                      DF-ACCOUNT-NO               
                                            YP-ACCOUNT-NO.              
      *                                                                 10020000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10050000
      ******************************************************************10060000
      * 2000-PROCESS-OUTPUT                                            *10070000
      ******************************************************************10080000
      *                                                                 10090000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 10110000
           MOVE 0                        TO S-UTILITY-BALANCE           
                                            S-UTILITY-ARREARS.          
           MOVE 'N'                      TO WS-EOF-CURSOR.              
      *                                                                 10150000
           PERFORM 7050-GET-ACCT-DET     THRU 7050-EXIT.                
           PERFORM 7060-GET-REG-PROF     THRU 7060-EXIT.                
      *                                                                 10180000
      * Check Roll-over Eligibility                                     10190000
      *                                                                 10200000
           PERFORM 2100-CHK-ROL-OVR-ELIG THRU 2100-EXIT.                
      *                                                                 10220000
           SET WS-RULES                  TO TRUE.                       
ACT003     MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
ACT003     IF WS-CODE-BUDGET = 'A'                                      
ACT003        GO TO 2000-EXIT                                           
ACT003     ELSE                                                         
ACT002** GET GROUP 2 DEFAULT ELIGIBILITY PERIOD                         10280000
ACT002        IF REG-GRP-2                                              
ACT002           MOVE AT-COMPANY-NO          TO C8-COMPANY-NO           
ACT002           MOVE WS-GRP2-BBP-FROM-MM    TO C8-DELINQ-CD            
ACT002           PERFORM 7600-SELECT-DELINQ  THRU 7600-EXIT             
ACT002           MOVE C8-DELINQ-VALUE        TO WS-GRP2-DELINQ-FROM-MM  
ACT002           MOVE WS-GRP2-BBP-TO-MM      TO C8-DELINQ-CD            
ACT002           PERFORM 7600-SELECT-DELINQ  THRU 7600-EXIT             
ACT002           MOVE C8-DELINQ-VALUE        TO WS-GRP2-DELINQ-TO-MM    
ACT002           MOVE WS-CURRENT-DATE(6:2)   TO WS-GRP2-CHK-CURR-MM     
ACT002        END-IF                                                    
ACT003** VALIDATE THE ACCOUNT FOR ALL BUSINESS RULES (CPD04344)         10390000
ACT003        PERFORM 6000-VALIDATE-ACCT-CPD4344  THRU                  
ACT003                6000-CPD4344-EXIT                                 
ACT003     END-IF.                                                      
ACT003*                                                                 10430000
P00721     IF PARM-ELIGIBLE = SPACES                                    
P00721        CONTINUE                                                  
P00721     ELSE                                                         
P00721        IF BBP-ELIGIBLE                                           
P00721           MOVE 'Y'    TO S-BBP-ELIGIBLE                          
P00836                                                                  
P00836           IF PARM-ELIGIBLE = 'W'                                 
P00836                                                                  
P00836              MOVE WS-ACCOUNT-NO      TO WS-04600-ACCOUNT-NO      
P00836              PERFORM 7930-GET-UTIL-DET  THRU 7930-EXIT           
P00836                                                                  
P00836              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
P00836                 AND FI-OPT-CALC-TYPE-CD = 'FP'                   
P00836                                                                  
P00836                 MOVE 'N'    TO S-BBP-ELIGIBLE                    
P00836                                                                  
P00836              END-IF                                              
P00836            END-IF                                                
P00721        ELSE                                                      
P00721           MOVE 'N'    TO S-BBP-ELIGIBLE                          
P00721        END-IF                                                    
P00721        PERFORM 8060-INSERT-GTT-R6 THRU 8060-EXIT                 
P00721        GO TO 2000-EXIT                                           
P00721     END-IF.                                                      
      *                                                                 10439300
           IF BBP-ELIGIBLE                                              
              CONTINUE                                                  
           ELSE                                                         
              GO TO 2000-EXIT                                           
           END-IF.                                                      
      *                                                                 10490000
      * Compute Current Charges & Arrears                               10500000
      *                                                                 10510000
           SET WS-OPTIONS                TO TRUE.                       
           PERFORM 7500-OPEN-AR-CURSOR   THRU 7500-EXIT.                
           PERFORM 7510-FETCH-AR-CURSOR  THRU 7510-EXIT.                
           PERFORM 2250-GET-AR-BALANCE   THRU 2250-EXIT                 
                                         UNTIL NO-MORE-DATA.            
           PERFORM 7520-CLOSE-AR-CURSOR  THRU 7520-EXIT.                
           MOVE S-UTILITY-BALANCE        TO WS-UTILITY-BAL-ED.          
           MOVE S-UTILITY-ARREARS        TO WS-UTILITY-ARR-ED.          
      *                                                                 10600000
      * Compute Premise/DDDC Usage Totals                               10610000
      *                                                                 10620000
           SET WS-USAGE                  TO TRUE.                       
           PERFORM 2270-GET-RATE-DET     THRU 2270-EXIT.                
           PERFORM 5500-CALL-CSR04600    THRU 5500-EXIT.                
      *                                                                 10660000
      * Compute BBP Estimated Monthly Amounts                           10670000
      *                                                                 10680000
           SET WS-OPTIONS                TO TRUE.                       
           MOVE WS-04600-EST-AMT-EDIT    TO WS-BBP-EST-AMT-NUM          
                                            S-AMT-GAS-MO-PYMT.          
           MOVE WS-BBP-EST-AMT-NUM       TO S-BBP-EST-AMT               
           MOVE S-BBP-EST-AMT            TO S-AMT-MO-PYMT               
                                            WS-AMT-BBP-EST-ED           
                                            WS-AMT-MO-PYMT-HOLD.        
      *                                                                 10750000
      * Get Revenue Month                                               10760000
      *                                                                 10770000
           IF AT-REV-MTH-LST-NRML = 0                                   
A03710        IF AT-CODE-ACCT-STAT = 'P' AND ( AT-BILL-CYCLE = SPACES   
A03710                                         OR '99' OR '00' )        
A03710           PERFORM 7070-GET-BN-REV-MTH   THRU 7070-EXIT           
A03710        ELSE                                                      
ACT003           MOVE AT-BILL-CYCLE         TO BN-BILL-CYCLE            
                 PERFORM 7100-GET-REV-MTH   THRU 7100-EXIT              
A03710        END-IF                                                    
              MOVE BN-REVENUE-MONTH      TO WS-REV-MTH-NUM              
           ELSE                                                         
              MOVE AT-REV-MTH-LST-NRML   TO WS-REV-MTH-NUM              
           END-IF.                                                      
      *                                                                 10900000
           MOVE WS-REV-MTH-CCYY          TO WS-PYMT-STRT-CCYY.          
           MOVE WS-REV-MTH-MM            TO WS-PYMT-STRT-MM.            
           MOVE WS-PYMT-STRT-DT          TO S-START-DATE.               
           MOVE AT-LAST-UPDATE-TS        TO S-LAST-UPDATE-TS.           
      *                                                                 10950000
      * Compute BBP Amount To Collect& Start Date                       10960000
      *                                                                 10970000
           IF ( S-UTILITY-ARREARS = 0 AND S-UTILITY-BALANCE = 0 ) OR    
P0694E        ( AT-REV-MTH-LST-NRML = 0 )                               
      *       Option 2 - 'Next Bill' Only                               11000000
              PERFORM 2400-FMT-NXT-BIL-OPTN THRU 2400-EXIT              
           ELSE                                                         
      *       Option 1 - 'Current Bill'                                 11030000
              PERFORM 2300-FMT-CUR-BIL-OPTN THRU 2300-EXIT              
      *       Option 2 - 'Next Bill'                                    11050000
              PERFORM 2400-FMT-NXT-BIL-OPTN THRU 2400-EXIT              
      *                                                                 11070000
              IF WS-ROL-OVR-ELIG = 'Y'                                  
P0694D*******AS PER SHARON'S REQUEST, SUPRESSED CURR BILL ROLLOVER OPT  11090000
P0694D*          IF S-UTILITY-ARREARS > 0                               11091000
P0694D*             Option 3 - Rollover with Current Bill               11100000
P0694D*             PERFORM 2500-ROLOVR-CUR-BIL-OPTN THRU 2500-EXIT     11110000
P0694D*          END-IF                                                 11120000
                 IF S-UTILITY-BALANCE > S-UTILITY-ARREARS AND           
P0694C              S-UTILITY-ARREARS > 0                               
      *             Option 4 - Rollover with Next Bill                  11150000
                    PERFORM 2600-ROLOVR-NXT-BIL-OPTN THRU 2600-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11200000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11230000
      ******************************************************************11240000
      *2000A-MOVE-RESULT.                                               11250000
      ******************************************************************11260000
      *                                                                 11270000
       2000A-MOVE-RESULT.                                               
      *                                                                 11290000
           ADD +1                         TO CTR-ROWS.                  
      *                                                                 11310000
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 11340000
      ******************************************************************11350000
      * 2100-CHK-ROL-OVR-ELIG.                                         *11360000
      ******************************************************************11370000
      *                                                                 11380000
       2100-CHK-ROL-OVR-ELIG.                                           
      *                                                                 11400000
           MOVE AT-COMPANY-NO            TO C8-COMPANY-NO.              
           MOVE 'EPP-ROLLOVER'           TO C8-DELINQ-CD.               
           PERFORM 7600-SELECT-DELINQ    THRU 7600-EXIT.                
           IF C8-DELINQ-VALUE = 0                                       
              MOVE 'N'                   TO WS-ROL-OVR-ENABLD           
              GO TO 2100-EXIT                                           
           ELSE                                                         
              MOVE 'Y'                   TO WS-ROL-OVR-ENABLD           
           END-IF.                                                      
      *                                                                 11500000
           IF WS-ROL-OVR-ENABLD = 'Y'                                   
              MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
              MOVE 'EPP-DPP-DROP-FLAG'   TO C8-DELINQ-CD                
              PERFORM 7600-SELECT-DELINQ THRU 7600-EXIT                 
              MOVE C8-DELINQ-VALUE       TO WS-BBP-LIMIT                
              EXEC SQL                                                  
                   SELECT
              DATEADD( MONTH, -:WS-BBP-LIMIT, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )
            INTO
              :WS-BBP-DPP-CUTOFF-DT              
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*       EXEC SQL                                                  11560000
MFA-TR*            SET :WS-BBP-DPP-CUTOFF-DT = CURRENT DATE -           11570000
MFA-TR*                               :WS-BBP-LIMIT MONTHS              11580000
MFA-TR*       END-EXEC                                                  11590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              PERFORM 7900-CHK-DPP-DROP  THRU 7900-EXIT                 
              PERFORM 7910-CHK-BBP-DROP  THRU 7910-EXIT                 
      *                                                                 11620000
              MOVE AT-COMPANY-NO         TO C8-COMPANY-NO               
              MOVE 'EPP-RO-DAYS-UTIL-ARR'  TO C8-DELINQ-CD              
              PERFORM 7600-SELECT-DELINQ THRU 7600-EXIT                 
              MOVE C8-DELINQ-VALUE       TO WS-DAYS-UTIL-ARRS           
              IF WS-DAYS-UTIL-ARRS = 30                                 
                 PERFORM 7920-CHK-UTL-ARRS THRU 7920-EXIT               
              END-IF                                                    
      *                                                                 11700000
              IF WS-BBP-DROP-EXISTS = 'Y' OR WS-DPP-DROP-EXISTS = 'Y' OR
                 WS-UTL-ARRS-EXISTS = 'Y'                               
                 MOVE 'N'                TO WS-ROL-OVR-ELIG             
              ELSE                                                      
                 MOVE 'Y'                TO WS-ROL-OVR-ELIG             
              END-IF                                                    
           END-IF.                                                      
      *                                                                 11780000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11810000
      ******************************************************************11820000
      * 2250-GET-AR-BALANCE.                                           *11830000
      ******************************************************************11840000
      *                                                                 11850000
       2250-GET-AR-BALANCE.                                             
      *                                                                 11870000
           IF ((AC-PYMT-PRIORITY-LVL = WS-PPL-NSC OR WS-PPL-LPC  OR     
                                       WS-PPL-UTE OR WS-PPL-UTG) AND    
               AC-ITEM-ID = 0)                                          
           OR (AC-PYMT-PRIORITY-LVL = WS-PPL-RCC AND AC-ITEM-ID > 0 AND 
               (AC-AMT-AR-DAY-00 + AC-AMT-AR-DAY-30 + AC-AMT-AR-DAY-60 +
                AC-AMT-AR-DAY-90 + AC-AMT-UNUSED-CR) > 0)               
      *                                                                 11940000
              IF AC-ITEM-ID = 0                                         
                 COMPUTE S-UTILITY-BALANCE = S-UTILITY-BALANCE +        
                                             AC-AMT-AR-DAY-00  +        
                                             AC-AMT-AR-DAY-30  +        
                                             AC-AMT-AR-DAY-60  +        
                                             AC-AMT-AR-DAY-90  +        
                                             AC-AMT-UNUSED-CR           
                 COMPUTE WS-RECV-AMT-HOLD  = AC-AMT-AR-DAY-00 +         
                                             AC-AMT-AR-DAY-30  +        
                                             AC-AMT-AR-DAY-60  +        
                                             AC-AMT-AR-DAY-90  +        
                                             AC-AMT-UNUSED-CR           
                 IF AC-TOT-SUMM-UNBILLED > 0                            
                    COMPUTE S-UTILITY-BALANCE = S-UTILITY-BALANCE +     
                                                AC-TOT-SUMM-UNBILLED    
                    COMPUTE WS-RECV-AMT-HOLD  = WS-RECV-AMT-HOLD +      
                                                AC-TOT-SUMM-UNBILLED    
                 END-IF                                                 
                                                                        
              ELSE                                                      
                 COMPUTE S-UTILITY-BALANCE = S-UTILITY-BALANCE +        
                                             AC-AMT-TRAN-BALANCE        
                 MOVE AC-AMT-TRAN-BALANCE     TO WS-RECV-AMT-HOLD       
              END-IF                                                    
      *                                                                 12190000
              IF WS-RECV-AMT-HOLD > 0                                   
                 MOVE L5-AR-TYPE-LONG-DESC    TO WS-BAL-TYPE (WS-IDX-B) 
                 MOVE WS-RECV-AMT-HOLD        TO WS-BAL-AMT (WS-IDX-B)  
                 SET WS-IDX-B UP BY 1                                   
              END-IF                                                    
      *                                                                 12250000
              COMPUTE S-UTILITY-ARREARS = S-UTILITY-ARREARS +           
                                          AC-AMT-AR-DAY-30  +           
                                          AC-AMT-AR-DAY-60  +           
                                          AC-AMT-AR-DAY-90              
      *                                                                 12300000
              COMPUTE WS-RECV-AMT-HOLD  = AC-AMT-AR-DAY-30  +           
                                          AC-AMT-AR-DAY-60  +           
                                          AC-AMT-AR-DAY-90              
      *                                                                 12340000
              IF WS-RECV-AMT-HOLD > 0                                   
                 MOVE L5-AR-TYPE-LONG-DESC    TO WS-ARRS-TYPE (WS-IDX-A)
                 MOVE WS-RECV-AMT-HOLD        TO WS-ARRS-AMT (WS-IDX-A) 
                 SET WS-IDX-A UP BY 1                                   
              END-IF                                                    
      *                                                                 12400000
           ELSE                                                         
              IF AC-PYMT-PRIORITY-LVL = WS-PPL-RCC                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 IF AC-PYMT-PRIORITY-LVL  < 50 OR                       
                    (AC-PYMT-PRIORITY-LVL > 50 AND AC-ITEM-ID > 0)      
                    COMPUTE WS-NONBBP-ELIG-AMT = WS-NONBBP-ELIG-AMT +   
                                                 AC-AMT-AR-DAY-00   +   
                                                 AC-AMT-AR-DAY-30   +   
                                                 AC-AMT-AR-DAY-60   +   
                                                 AC-AMT-AR-DAY-90   +   
                                                 AC-AMT-UNUSED-CR       
                    IF AC-TOT-SUMM-UNBILLED > ZERO                      
                       COMPUTE WS-NONBBP-ELIG-AMT =                     
                               WS-NONBBP-ELIG-AMT + AC-TOT-SUMM-UNBILLED
                    END-IF                                              
      *                                                                 12570000
P0694A              MOVE WS-NONBBP-ELIG-AMT TO S-NONBBP-ELIG-AMT        
      *                                                                 12590000
                    COMPUTE WS-RECV-AMT-HOLD = AC-AMT-AR-DAY-00 +       
                                               AC-AMT-AR-DAY-30 +       
                                               AC-AMT-AR-DAY-60 +       
                                               AC-AMT-AR-DAY-90 +       
                                               AC-AMT-UNUSED-CR +       
                                               AC-TOT-SUMM-UNBILLED     
                    IF WS-RECV-AMT-HOLD > 0                             
                       MOVE L5-AR-TYPE-LONG-DESC TO                     
                                                 WS-RECV-TYPE (WS-IDX-1)
                       MOVE WS-RECV-AMT-HOLD     TO                     
                                                 WS-RECV-AMT (WS-IDX-1) 
                       SET WS-IDX-1 UP BY 1                             
                    END-IF                                              
      *             Compute Other Monthly Payments                      12730000
                    SET WS-OTHR-PYMTS             TO TRUE               
                    PERFORM 2260-GET-OTHR-AMTS   THRU 2260-EXIT         
                    SET WS-OPTIONS                TO TRUE               
                 END-IF                                                 
      *                                                                 12780000
              END-IF                                                    
           END-IF.                                                      
      *                                                                 12810000
           PERFORM 7510-FETCH-AR-CURSOR  THRU 7510-EXIT.                
      *                                                                 12830000
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12860000
      ******************************************************************12870000
      * 2260-GET-OTHR-AMTS.                                            *12880000
      ******************************************************************12890000
      *                                                                 12900000
       2260-GET-OTHR-AMTS.                                              
      *                                                                 12920000
           MOVE AC-AMT-TRAN-BALANCE            TO WS-MAX-RECV-AMT.      
      *                                                                 12940000
           EVALUATE AC-PYMT-PRIORITY-LVL                                
               WHEN 80                                                  
      *             Deposits                                            12970000
                    MOVE AC-ACCOUNT-NO         TO DR-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DR-DEP-ITEM-ID        
                    PERFORM 7810-GET-DEP-REQ   THRU 7810-EXIT           
                    MOVE DR-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DR-AMT-MO-PYMT            
A02891                   ON SIZE ERROR                                  
A02891                      MOVE 0             TO S-CNT-PYMTS-REMAIN    
A02891              END-COMPUTE                                         
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DR-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                            13100000
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +          13110000
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                 13120000
MFA-TR*             END-EXEC                                            13130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    MOVE 'Deposit'             TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-3       
                    PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT           
               WHEN 90                                                  
      *             DFA's                                               13180000
                    IF AC-ITEM-ID > 40000000                            
                       CONTINUE                                         
                    ELSE                                                
                       NEXT SENTENCE                                    
                    END-IF                                              
                    MOVE AC-ACCOUNT-NO         TO DA-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO DA-DFA-ITEM-ID        
                    PERFORM 7820-GET-DFA-DET   THRU 7820-EXIT           
                    MOVE DA-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =                
                            WS-MAX-RECV-AMT / DA-AMT-MO-PYMT            
A02891                   ON SIZE ERROR                                  
A02891                      MOVE 0             TO S-CNT-PYMTS-REMAIN    
A02891              END-COMPUTE                                         
                    IF S-CNT-PYMTS-REMAIN = 0                           
                       MOVE DA-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    EXEC SQL                                            
                         SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT                 
                    END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*             EXEC SQL                                            13360000
MFA-TR*                  SET :S-CNT-EXPIRY-DT = CURRENT DATE +          13370000
MFA-TR*                      :S-CNT-PYMTS-REMAIN MONTHS                 13380000
MFA-TR*             END-EXEC                                            13390000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    MOVE 'DFA'                 TO S-CNT-NAME-DESC       
                    MOVE 0                     TO S-RETURN-CODE-3       
                    PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT           
               WHEN 100                                                 
      *             Contracts                                           13440000
                    MOVE AC-ACCOUNT-NO         TO CT-ACCOUNT-NO         
                    MOVE AC-ITEM-ID            TO CT-CNT-ITEM-ID        
                    PERFORM 7830-GET-CNT-DET   THRU 7830-EXIT           
                                                                        
ACT248              IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND               
ACT248                GO TO 2260-EXIT                                   
ACT248              ELSE                                                
ACT248                CONTINUE                                          
ACT248              END-IF                                              
                                                                        
                    COMPUTE S-AMT-OTHER-PYMTS = S-AMT-OTHER-PYMTS +     
                                                CT-AMT-MO-PYMT          
                    MOVE K6-CNT-NAME-DESC      TO S-CNT-NAME-DESC       
                    MOVE CT-AMT-MO-PYMT        TO S-CNT-AMT-MO-PYMT     
                    IF CT-CODE-BILL-TYPE = 'C'                          
                       COMPUTE S-CNT-PYMTS-REMAIN ROUNDED =             
                               WS-MAX-RECV-AMT / CT-AMT-MO-PYMT         
A02891                   ON SIZE ERROR                                  
A02891                      MOVE 0             TO S-CNT-PYMTS-REMAIN    
A02891                 END-COMPUTE                                      
                       IF S-CNT-PYMTS-REMAIN = 0                        
                          MOVE CT-NO-SCHED-PYMTS  TO S-CNT-PYMTS-REMAIN 
                       END-IF                                           
                       EXEC SQL                                         
                            SELECT
              DATEADD( MONTH, :S-CNT-PYMTS-REMAIN, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :S-CNT-EXPIRY-DT              
                       END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*                EXEC SQL                                         13610000
MFA-TR*                     SET :S-CNT-EXPIRY-DT = CURRENT DATE +       13620000
MFA-TR*                         :S-CNT-PYMTS-REMAIN MONTHS              13630000
MFA-TR*                END-EXEC                                         13640000
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                         
                    ELSE                                                
                       MOVE SPACES             TO S-CNT-EXPIRY-DT       
                       MOVE 0                  TO S-CNT-PYMTS-REMAIN    
                    END-IF                                              
                    MOVE ZERO                  TO S-RETURN-CODE-3       
                    PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT           
               WHEN 129                                                 
      *             Project Share                                       13720000
                    PERFORM 7700-GET-PJS-AMT   THRU 7700-EXIT           
                    MOVE PJ-MONTHLY-BILL-AM    TO S-AMT-OTHER-PYMTS     
                    IF PJ-MONTHLY-BILL-AM > 0                           
                       MOVE 'Project Share'    TO S-CNT-NAME-DESC       
                       MOVE PJ-MONTHLY-BILL-AM TO S-CNT-AMT-MO-PYMT     
                       MOVE 0                  TO S-RETURN-CODE-3       
                       PERFORM 8030-INSERT-GTT-R3 THRU 8030-EXIT        
                    END-IF                                              
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
      *                                                                 13840000
       2260-EXIT.                                                       
      *                                                                 13860000
      ******************************************************************13870000
      * 2270-GET-RATE-DET.                                             *13880000
      ******************************************************************13890000
      *                                                                 13900000
       2270-GET-RATE-DET.                                               
      *                                                                 13920000
P00694     MOVE WS-ACCOUNT-NO            TO WS-04600-ACCOUNT-NO.        
      *                                                                 13940000
           PERFORM 7930-GET-UTIL-DET     THRU 7930-EXIT.                
ACT078     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
ACT078        PERFORM  9999-END-PROGRAM  THRU 9999-EXIT                 
ACT078     END-IF.                                                      
      *                                                                 13960000
           MOVE PROGRAM-NAME             TO WS-CPD063-CALLING-PGM.      
           MOVE UT-ACCOUNT-NO            TO WS-ACCOUNT-NO-063.          
           MOVE 'G'                      TO WS-CODE-UTIL-TYPE-063.      
           MOVE DF-OPTION-CD             TO WS-OPTION-CD                
P00694                                      WS-04600-OPTION-CD.         
           MOVE UT-IC-NO                 TO WS-IC-NO-063.               
           MOVE 'Y'                      TO WS-THERM-CSC-ACCT-FL.       
           MOVE 'Y'                      TO WS-PENDING-OPTION-FL-063.   
           MOVE SPACES                   TO ABEND-FUNCTION.             
      *                                                                 14060000
           CALL MCSCB063  USING   CWS00063-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
      *                                                                 14100000
           MOVE RS-RETURN-CODE           TO  WS-ACTIVE-RETURN-CODE.     
      *                                                                 14120000
           IF ABEND-FUNCTION > SPACES OR RETURN-CODE > 0                
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPCODE ERROR'        TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMNT'   TO TABLE-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 14200000
           IF WS-PEND063-THERM-PRICE > 0                                
              MOVE WS-PEND063-THERM-PRICE                               
                                         TO WS-THERM-PRICE              
           END-IF                                                       
      *                                                                 14250000
           MOVE WS-CSC-AMT               TO WS-CUST-SVC-CHRG-EDIT.      
P00694     MOVE WS-CUST-SVC-CHRG-EDIT    TO WS-04600-CUST-SVC-FEE.      
           MOVE WS-THERM-PRICE           TO WS-RATE-PRICE-EDIT.         
P00694     MOVE WS-RATE-PRICE-EDIT       TO WS-04600-RATE-PRICE.        
      *                                                                 14300000
           MOVE UT-IC-NO                 TO FF-IC-NO                    
           MOVE UT-RATE-PLAN-NO          TO RD-RATE-PLAN-NO             
                                            RT-RATE-PLAN-NO.            
           MOVE UT-PREMISE-NO            TO PR-PREMISE-NO.              
           PERFORM 7960-GET-ZIP-CD       THRU 7960-EXIT.                
P00694     MOVE DY-ZIP-CODE              TO WS-04600-ZIP-CODE.          
      *                                                                 14410000
           PERFORM 7940-GET-DDDC         THRU 7940-EXIT.                
           MOVE FF-FACTOR                TO WS-DDDC-EDIT.               
P00694     MOVE WS-DDDC-EDIT             TO WS-04600-DDDC.              
      *                                                                 14414000
       2270-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************14440000
      * 2300-FMT-CUR-BIL-OPTN.                                         *14450000
      ******************************************************************14460000
      *                                                                 14470000
       2300-FMT-CUR-BIL-OPTN.                                           
      *                                                                 14490000
           MOVE 'C'                      TO S-BBP-BILL-FLAG.            
           MOVE '1'                      TO S-OPTION-SEQ-NO             
                                            S-OPTN-SEQ-NO-5.            
A02891*                                                                 14530000
A02891     IF S-UTILITY-ARREARS  >  0                                   
A02891        MOVE WS-BBP-OPTN-CUR-BIL-TX1  TO  S-OPTION-DESC           
A02891     ELSE                                                         
A02891        MOVE WS-BBP-OPTN-CUR-BIL-TX2  TO  S-OPTION-DESC           
A02891     END-IF.                                                      
A02891*                                                                 14590000
           COMPUTE S-OPTN-PLS-PAY-AMT    = S-UTILITY-ARREARS +          
                                           S-AMT-MO-PYMT     +          
                                           WS-NONBBP-ELIG-AMT.          
           IF S-OPTN-PLS-PAY-AMT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                     TO S-OPTN-PLS-PAY-AMT          
           END-IF.                                                      
      *                                                                 14680000
A04987     IF WS-EPP-DEFAULT-DDDC-ED > SPACES                           
A04987        STRING 'Default DDDC : '     DELIMITED BY SIZE            
A04987               WS-EPP-DEFAULT-DDDC-ED DELIMITED BY SIZE           
A04987          INTO S-REMARKS-TEXT                                     
A04987        MOVE +19                   TO S-REMARKS-LENGTH            
A04987     ELSE                                                         
A04987        MOVE SPACES                TO S-REMARKS-TEXT              
A04987     END-IF                                                       
                                                                        
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
      *                                                                 14700000
      * Pls Pay Amt Details                                             14710000
      *                                                                 14720000
      * Utility Arrears                                                 14730000
           SET WS-PLS-PAY-AMT            TO TRUE.                       
           IF S-UTILITY-ARREARS > 0                                     
              SET WS-IDX-A               TO 1                           
              PERFORM UNTIL WS-ARRS-TYPE(WS-IDX-A) = SPACES             
                 MOVE 0                       TO S-RETURN-CODE-5        
                 MOVE WS-ARRS-TYPE (WS-IDX-A) TO S-AR-TYPE-DESC         
                 MOVE WS-ARRS-AMT (WS-IDX-A)  TO S-PLS-PAY-DET-AMT      
                 PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT            
                 SET WS-IDX-A UP BY 1                                   
              END-PERFORM                                               
           END-IF.                                                      
      * BBP Estimated Amount                                            14850000
           MOVE 0                        TO S-RETURN-CODE-5.            
           MOVE 'BBP MONTHLY AMOUNT'     TO S-AR-TYPE-DESC.             
           MOVE S-AMT-MO-PYMT            TO S-PLS-PAY-DET-AMT.          
           PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT.                
      * Non BBP Eligible Receivables                                    14900000
           SET WS-IDX-1                  TO 1.                          
           PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                
              MOVE 0                          TO S-RETURN-CODE-5        
              MOVE WS-RECV-TYPE (WS-IDX-1)    TO S-AR-TYPE-DESC         
              MOVE WS-RECV-AMT  (WS-IDX-1)    TO S-PLS-PAY-DET-AMT      
              PERFORM 8050-INSERT-GTT-R5 THRU 8050-EXIT                 
              SET WS-IDX-1 UP BY 1                                      
           END-PERFORM.                                                 
           SET WS-OPTIONS                TO TRUE.                       
      *                                                                 15000000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15030000
      ******************************************************************15040000
      * 2400-FMT-NXT-BIL-OPTN.                                         *15050000
      ******************************************************************15060000
      *                                                                 15070000
       2400-FMT-NXT-BIL-OPTN.                                           
      *                                                                 15090000
           MOVE 'N'                      TO S-BBP-BILL-FLAG.            
           MOVE '2'                      TO S-OPTION-SEQ-NO             
                                            S-OPTN-SEQ-NO-5.            
A02891*                                                                 15130000
A02891     IF S-UTILITY-ARREARS  >  0                                   
A02891        MOVE WS-BBP-OPTN-NXT-BIL-TX1  TO  S-OPTION-DESC           
A02891     ELSE                                                         
A02891        MOVE WS-BBP-OPTN-NXT-BIL-TX2  TO  S-OPTION-DESC           
A02891     END-IF.                                                      
A02891*                                                                 15190000
           COMPUTE S-OPTN-PLS-PAY-AMT    =  S-UTILITY-BALANCE +         
                                            WS-NONBBP-ELIG-AMT.         
           IF S-OPTN-PLS-PAY-AMT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                     TO S-OPTN-PLS-PAY-AMT          
           END-IF.                                                      
      *                                                                 15270000
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :S-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :S-START-DATE
              ) <> 0) OR (LEN(:S-START-DATE) <> 10), CIS.CHAR2DATE(
                                                          :S-START-DATE
              ), CONVERT(DATE, :S-START-DATE) ) )
            INTO
              :S-START-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     15280000
MFA-TR*         SET :S-START-DATE         = DATE(:S-START-DATE) +       15290000
MFA-TR*                                     1 MONTH                     15300000
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A04987     IF WS-EPP-DEFAULT-DDDC-ED > SPACES                           
A04987        STRING 'Default DDDC : '     DELIMITED BY SIZE            
A04987               WS-EPP-DEFAULT-DDDC-ED DELIMITED BY SIZE           
A04987          INTO S-REMARKS-TEXT                                     
A04987        MOVE +19                   TO S-REMARKS-LENGTH            
A04987     ELSE                                                         
A04987        MOVE SPACES                TO S-REMARKS-TEXT              
A04987     END-IF                                                       
                                                                        
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
      *                                                                 15330000
      * Pls Pay Amt Details                                             15340000
      *                                                                 15350000
      * Utility Balance                                                 15360000
           SET WS-PLS-PAY-AMT            TO TRUE.                       
           IF S-UTILITY-BALANCE > 0                                     
              SET WS-IDX-B               TO 1                           
              PERFORM UNTIL WS-BAL-TYPE(WS-IDX-B) = SPACES              
                 MOVE 0                      TO S-RETURN-CODE-5         
                 MOVE WS-BAL-TYPE (WS-IDX-B) TO S-AR-TYPE-DESC          
                 MOVE WS-BAL-AMT (WS-IDX-B)  TO S-PLS-PAY-DET-AMT       
                 PERFORM 8050-INSERT-GTT-R5  THRU 8050-EXIT             
                 SET WS-IDX-B UP BY 1                                   
              END-PERFORM                                               
           END-IF.                                                      
      * Non BBP Eligible Receivables                                    15480000
           SET WS-IDX-1                  TO 1.                          
           PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                
              MOVE 0                         TO S-RETURN-CODE-5         
              MOVE WS-RECV-TYPE (WS-IDX-1)   TO S-AR-TYPE-DESC          
              MOVE WS-RECV-AMT  (WS-IDX-1)   TO S-PLS-PAY-DET-AMT       
              PERFORM 8050-INSERT-GTT-R5 THRU 8050-EXIT                 
              SET WS-IDX-1 UP BY 1                                      
           END-PERFORM.                                                 
           SET WS-OPTIONS                TO TRUE.                       
      *                                                                 15580000
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15610000
      ******************************************************************15620000
      * 2500-ROLOVR-CUR-BIL-OPTN.                                      *15630000
      ******************************************************************15640000
      *                                                                 15650000
P0694D*2500-ROLOVR-CUR-BIL-OPTN.                                        15660000
P0694D*                                                                 15670000
P0694D*    MOVE 'R'                      TO S-BBP-BILL-FLAG.            15680000
P0694D*    MOVE '3'                      TO S-OPTION-SEQ-NO             15690000
P0694D*                                     S-OPTN-SEQ-NO-5.            15700000
P0694D*    MOVE WS-BBP-OPTN-ROL-CUR-BIL  TO S-OPTION-DESC.              15710000
P0694D*                                                                 15720000
P0694D*    COMPUTE WS-ROLOVR-AMT = S-UTILITY-ARREARS / 12.              15730000
P0694D*    COMPUTE WS-AMT-MO-PYMT-RND ROUNDED = WS-ROLOVR-AMT.          15740000
P0694D*    IF WS-ROLOVR-AMT > WS-AMT-MO-PYMT-RND                        15750000
P0694D*       COMPUTE WS-ROLOVR-AMT =  WS-AMT-MO-PYMT-RND + 1           15760000
P0694D*    ELSE                                                         15770000
P0694D*       MOVE WS-AMT-MO-PYMT-RND    TO WS-ROLOVR-AMT               15780000
P0694D*    END-IF.                                                      15790000
P0694D*    MOVE WS-ROLOVR-AMT            TO WS-ROLOVR-AMT-ED            15800000
P0694D*                                     S-AMT-ROLLOVR.              15810000
P0694D*                                                                 15820000
P0694D*    MOVE S-AMT-MO-PYMT            TO WS-AMT-MO-PYMT-HOLD.        15830000
P0694D*    COMPUTE S-AMT-MO-PYMT = S-AMT-MO-PYMT +                      15840000
P0694D*                            WS-ROLOVR-AMT.                       15850000
P0694D*    MOVE S-AMT-MO-PYMT            TO WS-AMT-MO-PYMT-ED.          15860000
P0694D*                                                                 15870000
P0694D*    STRING 'ELIG RO $'          DELIMITED BY SIZE                15880000
P0694D*           WS-UTILITY-ARR-ED    DELIMITED BY SIZE                15890000
P0694D*           ' / 12 = $'          DELIMITED BY SIZE                15900000
P0694D*           WS-ROLOVR-AMT-ED     DELIMITED BY SIZE                15910000
P0694D*           ';BBP EST $'         DELIMITED BY SIZE                15920000
P0694D*           WS-AMT-BBP-EST-ED    DELIMITED BY SIZE                15930000
P0694D*           ';BBP AMT $'         DELIMITED BY SIZE                15940000
P0694D*           WS-AMT-MO-PYMT-ED    DELIMITED BY SIZE                15950000
P0694D*           ';'                  DELIMITED BY SIZE                15960000
P0694D*      INTO S-REMARKS-TEXT.                                       15970000
P0694D*    MOVE +91                    TO S-REMARKS-LENGTH.             15980000
P0694D* Remove embedded spaces                                          15990000
P0694D*    MOVE SPACES                 TO WS-REMARKS-TEXT.              16000000
P0694D*    MOVE S-REMARKS-TEXT         TO WS-REMARKS-TEXT.              16010000
P0694D*    MOVE SPACES                 TO S-REMARKS-TEXT                16020000
P0694D*                                   WS-RESULT-TEXT                16030000
P0694D*                                   WS-PREV-CHAR.                 16040000
P0694D*    SET WS-IDX-R                TO 1.                            16050000
P0694D*    SET WS-IDX-2                TO 1.                            16060000
P0694D*                                                                 16070000
P0694D*    PERFORM S-REMARKS-LENGTH TIMES                               16080000
P0694D*       IF WS-REMARKS-CHAR(WS-IDX-R) = SPACES AND                 16090000
P0694D*          WS-PREV-CHAR              = SPACES                     16100000
P0694D*          CONTINUE                                               16110000
P0694D*       ELSE                                                      16120000
P0694D*          MOVE WS-REMARKS-CHAR(WS-IDX-R)                         16130000
P0694D*                                  TO WS-RESULT-CHAR(WS-IDX-2)    16140000
P0694D*                                     WS-PREV-CHAR                16150000
P0694D*          SET WS-IDX-2            UP BY 1                        16160000
P0694D*       END-IF                                                    16170000
P0694D*          SET WS-IDX-R            UP BY 1                        16180000
P0694D*    END-PERFORM.                                                 16190000
P0694D*    MOVE WS-RESULT-TEXT           TO S-REMARKS-TEXT.             16200000
P0694D*                                                                 16210000
P0694D*    COMPUTE S-OPTN-PLS-PAY-AMT    = S-AMT-MO-PYMT +              16220000
P0694D*                                    WS-NONBBP-ELIG-AMT.          16230000
P0694D*    IF S-OPTN-PLS-PAY-AMT > 0                                    16240000
P0694D*       CONTINUE                                                  16250000
P0694D*    ELSE                                                         16260000
P0694D*       MOVE 0                     TO S-OPTN-PLS-PAY-AMT          16270000
P0694D*    END-IF.                                                      16280000
P0694D*                                                                 16290000
P0694D*    PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                16300000
P0694D*                                                                 16310000
P0694D* Pls Pay Amt Details                                             16320000
P0694D*                                                                 16330000
P0694D* BBP Estimated Amount                                            16340000
P0694D*    SET WS-PLS-PAY-AMT            TO TRUE.                       16350000
P0694D*    MOVE 0                        TO S-RETURN-CODE-5.            16360000
P0694D*    MOVE 'BBP MONTHLY AMOUNT'     TO S-AR-TYPE-DESC.             16370000
P0694D*    MOVE S-AMT-MO-PYMT            TO S-PLS-PAY-DET-AMT.          16380000
P0694D*    PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT.                16390000
P0694D* Non BBP Eligible Receivables                                    16400000
P0694D*    SET WS-IDX-1                  TO 1.                          16410000
P0694D*    PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                16420000
P0694D*       MOVE 0                       TO S-RETURN-CODE-5           16430000
P0694D*       MOVE WS-RECV-TYPE (WS-IDX-1) TO S-AR-TYPE-DESC            16440000
P0694D*       MOVE WS-RECV-AMT  (WS-IDX-1) TO S-PLS-PAY-DET-AMT         16450000
P0694D*       PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT               16460000
P0694D*       SET WS-IDX-1 UP BY 1                                      16470000
P0694D*    END-PERFORM.                                                 16480000
P0694D*    SET WS-OPTIONS                TO TRUE.                       16490000
P0694D*                                                                 16500000
P0694D*2500-EXIT.                                                       16510000
P0694D*    EXIT.                                                        16520000
      *                                                                 16530000
      ******************************************************************16540000
      * 2600-ROLOVR-NXT-BIL-OPTN.                                      *16550000
      ******************************************************************16560000
      *                                                                 16570000
       2600-ROLOVR-NXT-BIL-OPTN.                                        
      *                                                                 16590000
           MOVE 'S'                      TO S-BBP-BILL-FLAG.            
           MOVE '4'                      TO S-OPTION-SEQ-NO             
                                            S-OPTN-SEQ-NO-5.            
           MOVE WS-BBP-OPTN-ROL-NXT-BIL  TO S-OPTION-DESC.              
           MOVE WS-AMT-MO-PYMT-HOLD      TO S-AMT-MO-PYMT.              
      *                                                                 16650000
           COMPUTE WS-ROLOVR-AMT =                                      
                         (S-UTILITY-BALANCE - S-UTILITY-ARREARS) / 12.  
           COMPUTE WS-AMT-MO-PYMT-RND ROUNDED = WS-ROLOVR-AMT.          
           IF WS-ROLOVR-AMT > WS-AMT-MO-PYMT-RND                        
              COMPUTE WS-ROLOVR-AMT =  WS-AMT-MO-PYMT-RND + 1           
           ELSE                                                         
              MOVE WS-AMT-MO-PYMT-RND    TO WS-ROLOVR-AMT               
           END-IF.                                                      
           MOVE WS-ROLOVR-AMT            TO WS-ROLOVR-AMT-ED            
                                            S-AMT-ROLLOVR.              
      *                                                                 16760000
           COMPUTE S-AMT-MO-PYMT = S-AMT-MO-PYMT +                      
                                   WS-ROLOVR-AMT.                       
           MOVE S-AMT-MO-PYMT            TO WS-AMT-MO-PYMT-ED.          
      *                                                                 16810000
           STRING 'ELIG RO $'          DELIMITED BY SIZE                
                  WS-UTILITY-BAL-ED    DELIMITED BY SIZE                
                  ' - AMT TO COLL $'   DELIMITED BY SIZE                
                  WS-UTILITY-ARR-ED    DELIMITED BY SIZE                
                  ' / 12 = $'          DELIMITED BY SIZE                
                  WS-ROLOVR-AMT-ED     DELIMITED BY SIZE                
                  ';BBP EST $'         DELIMITED BY SIZE                
                  WS-AMT-BBP-EST-ED    DELIMITED BY SIZE                
                  ';BBP AMT $'         DELIMITED BY SIZE                
                  WS-AMT-MO-PYMT-ED    DELIMITED BY SIZE                
                  ';'                  DELIMITED BY SIZE                
           INTO S-REMARKS-TEXT                                          
           MOVE +120                   TO S-REMARKS-LENGTH              
      * Remove embedded spaces                                          16950000
           MOVE SPACES                 TO WS-REMARKS-TEXT.              
           MOVE S-REMARKS-TEXT         TO WS-REMARKS-TEXT.              
           MOVE SPACES                 TO S-REMARKS-TEXT                
                                          WS-RESULT-TEXT                
                                          WS-PREV-CHAR.                 
           SET WS-IDX-R                TO 1.                            
           SET WS-IDX-2                TO 1.                            
      *                                                                 17030000
           PERFORM S-REMARKS-LENGTH TIMES                               
              IF WS-REMARKS-CHAR(WS-IDX-R) = SPACES AND                 
                 WS-PREV-CHAR              = SPACES                     
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-REMARKS-CHAR(WS-IDX-R)                         
                                         TO WS-RESULT-CHAR(WS-IDX-2)    
                                            WS-PREV-CHAR                
                 SET WS-IDX-2            UP BY 1                        
              END-IF                                                    
                 SET WS-IDX-R            UP BY 1                        
           END-PERFORM.                                                 
           MOVE WS-RESULT-TEXT           TO S-REMARKS-TEXT.             
      *                                                                 17170000
           COMPUTE S-OPTN-PLS-PAY-AMT    =  S-UTILITY-ARREARS +         
                                            WS-NONBBP-ELIG-AMT.         
           IF S-OPTN-PLS-PAY-AMT > 0                                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE 0                     TO S-OPTN-PLS-PAY-AMT          
           END-IF.                                                      
      *                                                                 17250000
           EXEC SQL                                                     
                SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :S-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :S-START-DATE
              ) <> 0) OR (LEN(:S-START-DATE) <> 10), CIS.CHAR2DATE(
                                                          :S-START-DATE
              ), CONVERT(DATE, :S-START-DATE) ) )
            INTO
              :S-START-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     17260000
MFA-TR*         SET :S-START-DATE         = DATE(:S-START-DATE) +       17270000
MFA-TR*                                     1 MONTH                     17280000
MFA-TR*    END-EXEC.                                                    17290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17300000
           PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT.               
      *                                                                 17320000
      * Pls Pay Amt Details                                             17330000
      *                                                                 17340000
      * Utility Arrears                                                 17350000
           SET WS-PLS-PAY-AMT            TO TRUE.                       
           IF S-UTILITY-ARREARS > 0                                     
              SET WS-IDX-A               TO 1                           
              PERFORM UNTIL WS-ARRS-TYPE(WS-IDX-A) = SPACES             
                 MOVE 0                       TO S-RETURN-CODE-5        
                 MOVE WS-ARRS-TYPE (WS-IDX-A) TO S-AR-TYPE-DESC         
                 MOVE WS-ARRS-AMT (WS-IDX-A)  TO S-PLS-PAY-DET-AMT      
                 PERFORM 8050-INSERT-GTT-R5   THRU 8050-EXIT            
                 SET WS-IDX-A UP BY 1                                   
              END-PERFORM                                               
           END-IF.                                                      
      *    Pls Pay Amt Details                                          17470000
           SET WS-IDX-1                   TO 1.                         
           PERFORM UNTIL WS-RECV-TYPE(WS-IDX-1) = SPACES                
              MOVE 0                        TO S-RETURN-CODE-5          
              MOVE WS-RECV-TYPE (WS-IDX-1)  TO S-AR-TYPE-DESC           
              MOVE WS-RECV-AMT  (WS-IDX-1)  TO S-PLS-PAY-DET-AMT        
              PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT              
              SET WS-IDX-1 UP BY 1                                      
           END-PERFORM.                                                 
           SET WS-OPTIONS                TO TRUE.                       
      *                                                                 17570000
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17600000
      ******************************************************************17610000
      * 5011-FETCH-LOC1                                                *17620000
      ******************************************************************17630000
      *                                                                 17640000
       5011-FETCH-LOC1.                                                 
      *                                                                 17660000
           EXEC SQL                                                     
             FETCH MSQ001_CUR_1                                          
              INTO  :WS-04600-RETURN-CODE                               
                   ,:WS-04600-GAS-AMT                                   
                   ,:WS-04600-SUBDIV-AMT                                
                   ,:WS-04600-PRIVATE-AMT                               
                   ,:WS-04600-EST-AMT                                   
                   ,:WS-04600-EST-AMT-RND                               
                   ,:WS-AGL-PASS-CHARGE                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                     17670000
MFA-TR*      FETCH BBP_AMT_CUR                                          17680000
MFA-TR*       INTO  :WS-04600-RETURN-CODE                               17690000
MFA-TR*            ,:WS-04600-GAS-AMT                                   17700000
MFA-TR*            ,:WS-04600-SUBDIV-AMT                                17710000
MFA-TR*            ,:WS-04600-PRIVATE-AMT                               17720000
MFA-TR*            ,:WS-04600-EST-AMT                                   17730000
MFA-TR*            ,:WS-04600-EST-AMT-RND                               17740000
MFA-TR*            ,:WS-AGL-PASS-CHARGE                                 17750000
MFA-TR*    END-EXEC                                                     17760000

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17770000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 17800000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-04600-RETURN-CODE = 0                         
                       CONTINUE                                         
                    ELSE                                                
                       MOVE WS-04600-RETURN-CODE                        
                                               TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-3       
                       MOVE '5011'             TO ACTIVE-PARAGRAPH      
                       MOVE PROGRAM-NAME       TO ABEND-PROGRAM         
                       MOVE 'FETCH'            TO ABEND-FUNCTION        
                       MOVE 'CSR04600'         TO TABLE-1               
                       MOVE WS-04600-ACCOUNT-NO TO HOSTVAR-ELEMENT-1    
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA           TO TRUE                  
                    MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
                                                  S-RETURN-CODE-3       
               WHEN OTHER                                               
                    MOVE '5011'                TO ACTIVE-PARAGRAPH      
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE 'CSR04600'            TO TABLE-1               
                    MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1     
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 18080000
       5011-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18110000
      ******************************************************************18120000
      * 5500-CALL-CSR04600                                             *18130000
      ******************************************************************18140000
P00694*                                                                 18150000
P00694 5500-CALL-CSR04600.                                              
P00694*                                                                 18170000
P00694*    EXEC SQL                                                     
P00694*         CALL CSR04600(' '                                       
P00694*                      ,:WS-04600-ACCOUNT-NO                      
P00694*                      ,:WS-04600-OPTION-CD                       
P00694*                      ,:WS-04600-RATE-PRICE                      
P00694*                      ,:WS-04600-DDDC                            
P00694*                      ,:WS-04600-CUST-SVC-FEE                    
P00694*                      ,:WS-04600-ZIP-CODE                        
P00694*                      )                                          
P00694*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_CUR_1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_CUR_1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00694*                                                                 18280000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-4.            
P00694*                                                                 18310000
P00694     IF  WS-ACTIVE-RETURN-CODE = +466                             
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE '5500'                TO ACTIVE-PARAGRAPH            
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE 'COBSP CALL'          TO ABEND-FUNCTION              
P00694        MOVE 'CSR04600'            TO TABLE-1                     
P00694        MOVE 'ACCT NO'             TO TABLE-ELEMENT-1             
P00694        MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
P00694        MOVE 'OPTION CD'           TO TABLE-ELEMENT-2             
P00694        MOVE WS-04600-OPTION-CD    TO HOSTVAR-ELEMENT-2           
P00694        MOVE 'RATE PRICE'          TO TABLE-ELEMENT-3             
P00694        MOVE WS-04600-RATE-PRICE   TO HOSTVAR-ELEMENT-3           
P00694        MOVE 'DDDC'                TO TABLE-ELEMENT-4             
P00694        MOVE WS-04600-DDDC         TO HOSTVAR-ELEMENT-4           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 18490000
P00694*    EXEC SQL                                                     
P00694*         ASSOCIATE LOCATORS (:LOC1, :LOC2)                       
P00694*         WITH PROCEDURE CSR04600                                 
P00694*    END-EXEC.                                                    
P00694*                                                                 18540000
P00694*    EXEC SQL                                                     
P00694*      ALLOCATE BBP_AMT_CUR CURSOR FOR RESULT SET :LOC1           
P00694*    END-EXEC.                                                    
P00694*                                                                 18580000
P00694     PERFORM 5011-FETCH-LOC1       THRU 5011-EXIT.                
P00694*                                                                 18600000
P00694*    EXEC SQL                                                     
P00694*      CLOSE BBP_AMT_CUR                                          
P00694*    END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 18640000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-4.            
P00694*                                                                 18670000
P00694     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE '5500'                TO ACTIVE-PARAGRAPH            
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE 'CLOSE LOC1'          TO ABEND-FUNCTION              
P00694        MOVE 'CSR04600'            TO TABLE-1                     
P00694        MOVE 'ACCT NO'             TO TABLE-ELEMENT-1             
P00694        MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
P00694        MOVE 'OPTION CD'           TO TABLE-ELEMENT-2             
P00694        MOVE WS-04600-OPTION-CD    TO HOSTVAR-ELEMENT-2           
P00694        MOVE 'RATE PRICE'          TO TABLE-ELEMENT-3             
P00694        MOVE WS-04600-RATE-PRICE   TO HOSTVAR-ELEMENT-3           
P00694        MOVE 'DDDC'                TO TABLE-ELEMENT-4             
P00694        MOVE WS-04600-DDDC         TO HOSTVAR-ELEMENT-4           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 18850000
P00694*    EXEC SQL                                                     
P00694*      ALLOCATE USAGE_CUR CURSOR FOR RESULT SET :LOC2             
P00694*    END-EXEC.                                                    
P00694*                                                                 18890000
P00694     MOVE 'N'                      TO WS-EOF-CURSOR.              
P00694     PERFORM 5600-FETCH-CSR04600   THRU 5600-EXIT                 
P00694                                   UNTIL NO-MORE-DATA.            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
P00694*                                                                 18930000
P00694     EXEC SQL                                                     
P00694       CLOSE MSQ001_CUR_1                                            
P00694     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                     18940000
MFA-TR*      CLOSE USAGE_CUR                                            18950000
MFA-TR*    END-EXEC                                                     18960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 18970000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694                                      S-RETURN-CODE-4.            
P00694*                                                                 19000000
P00694     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00694         CONTINUE                                                 
P00694     ELSE                                                         
P00694        MOVE '5500'                TO ACTIVE-PARAGRAPH            
P00694        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00694        MOVE 'CLOSE LOC2'          TO ABEND-FUNCTION              
P00694        MOVE 'CSR04600'            TO TABLE-1                     
P00694        MOVE 'ACCT NO'             TO TABLE-ELEMENT-1             
P00694        MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
P00694        MOVE 'OPTION CD'           TO TABLE-ELEMENT-2             
P00694        MOVE WS-04600-OPTION-CD    TO HOSTVAR-ELEMENT-2           
P00694        MOVE 'RATE PRICE'          TO TABLE-ELEMENT-3             
P00694        MOVE WS-04600-RATE-PRICE   TO HOSTVAR-ELEMENT-3           
P00694        MOVE 'DDDC'                TO TABLE-ELEMENT-4             
P00694        MOVE WS-04600-DDDC         TO HOSTVAR-ELEMENT-4           
P00694        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00694     END-IF.                                                      
P00694*                                                                 19180000
P00694 5500-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 19210000
P00694 5600-FETCH-CSR04600.                                             
P00694*                                                                 19230000
P00694     EXEC SQL                                                     
P00694       FETCH MSQ001_CUR_1                                            
P00694        INTO  :S-RETURN-CODE-4                                    
P00694             ,:S-REVENUE-MONTH                                    
P00694             ,:S-DAYS                                             
P00694             ,:S-UNITS                                            
P00694             ,:S-NEW-CHARGE                                       
P00694             ,:S-GAS-BUFFER                                       
P00694     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                     19240000
MFA-TR*      FETCH USAGE_CUR                                            19250000
MFA-TR*       INTO  :S-RETURN-CODE-4                                    19260000
MFA-TR*            ,:S-REVENUE-MONTH                                    19270000
MFA-TR*            ,:S-DAYS                                             19280000
MFA-TR*            ,:S-UNITS                                            19290000
MFA-TR*            ,:S-NEW-CHARGE                                       19300000
MFA-TR*            ,:S-GAS-BUFFER                                       19301000
MFA-TR*    END-EXEC                                                     19310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694*                                                                 19320000
P00694     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00694*                                                                 19340000
P00694     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00694         WHEN SUCCESSFUL-CALL                                     
P00694              PERFORM 5700-PROCESS-CSR04600-DATA THRU 5700-EXIT   
P00694         WHEN NOT-FOUND                                           
P00694              SET NO-MORE-DATA           TO TRUE                  
P00694              MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
P00694                                            S-RETURN-CODE-4       
P00694         WHEN OTHER                                               
P00694              MOVE '5600'                TO ACTIVE-PARAGRAPH      
P00694              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
P00694              MOVE 'FETCH'               TO ABEND-FUNCTION        
P00694              MOVE 'CSR02322'            TO TABLE-1               
P00694              MOVE 'ACCT NO'             TO TABLE-ELEMENT-1       
P00694              MOVE WS-04600-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1     
P00694              MOVE 'OPTION CD'           TO TABLE-ELEMENT-2       
P00694              MOVE WS-04600-OPTION-CD    TO HOSTVAR-ELEMENT-2     
P00694              MOVE 'RATE PRICE'          TO TABLE-ELEMENT-3       
P00694              MOVE WS-04600-RATE-PRICE   TO HOSTVAR-ELEMENT-3     
P00694              MOVE 'DDDC'                TO TABLE-ELEMENT-4       
P00694              MOVE WS-04600-DDDC         TO HOSTVAR-ELEMENT-4     
P00694              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
P00694     END-EVALUATE.                                                
P00694*                                                                 19570000
P00694 5600-EXIT.                                                       
P00694     EXIT.                                                        
P00694*                                                                 19600000
P00694 5700-PROCESS-CSR04600-DATA.                                      
P00694*                                                                 19620000
P00694     IF S-REVENUE-MONTH > LOW-VALUES AND SPACES                   
P00694       MOVE 'G'                           TO S-CODE-UTIL-TYPE     
P00694       MOVE S-REVENUE-MONTH (1:4)         TO WS-YEAR              
P00694       MOVE S-REVENUE-MONTH (5:2)         TO WS-MONTH             
P00694       MOVE WS-REVENUE-DATE               TO S-REVENUE-MONTH      
P00694       PERFORM 8040-INSERT-GTT-R4    THRU 8040-EXIT               
P00694     END-IF.                                                      
P00694*                                                                 19681000
P00694 5700-EXIT.                                                       
P00694     EXIT.                                                        
      *                                                                 19710000
      ******************************************************************19720000
      * 5900-NEXT-BILL-DATE.                                           *19730000
      ******************************************************************19740000
      *                                                                 19750000
           EXEC SQL                                                     19760000
              INCLUDE CPD00309                                          19770000
           END-EXEC.                                                    19780000
      *                                                                 19790000
      ******************************************************************19800000
      * 6000-VALIDATE-ACCT.                                            *19810000
      ******************************************************************19820000
      *                                                                 19830000
           EXEC SQL                                                     19840000
              INCLUDE CPD04344                                          19850000
           END-EXEC.                                                    19860000
      *                                                                 19870000
      ******************************************************************19880000
      * 7000-GET-CUR-DATE.                                             *19890000
      ******************************************************************19900000
      *                                                                 19910000
       7000-GET-CUR-DATE.                                               
      *                                                                 19930000
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     19940000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       19950000
MFA-TR*    END-EXEC.                                                    19960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 20000000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 20090000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20120000
      *                                                                 20130000
      ******************************************************************20140000
      * 7050-GET-ACCT-DET.                                             *20150000
      ******************************************************************20160000
      *                                                                 20170000
       7050-GET-ACCT-DET.                                               
      *                                                                 20190000
           EXEC SQL                                                     
              SELECT                                                    
                     AT.COMPANY_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.BILL_CYCLE                                      
                    ,AT.PREMISE_NO                                      
                    ,AT.REV_MTH_LST_NRML                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
ACT003              ,AT.CODE_BILL_FREQ                                  
ACT003              ,AT.CODES_DATA_PRESENT                              
ACT003              ,AT.CODE_ACCT_STAT                                  
ACT003              ,AT.ACCOUNT_TYPE_CODE                               
ACT003              ,AT.CODE_MAJOR_ACCT                                 
ACT003              ,AT.CREDIT_GROUP                                    
ACT003              ,AT.BANKRUPTCY_IND                                  
ACT003              ,AT.MST_SUB_ACCT_IND                                
                INTO                                                    
                     :AT-COMPANY-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-BILL-CYCLE                                     
                    ,:AT-PREMISE-NO                                     
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-LAST-UPDATE-TS                                 
ACT003              ,:AT-CODE-BILL-FREQ                                 
ACT003              ,:AT-CODES-DATA-PRESENT                             
ACT003              ,:AT-CODE-ACCT-STAT                                 
ACT003              ,:AT-ACCOUNT-TYPE-CODE                              
ACT003              ,:AT-CODE-MAJOR-ACCT                                
ACT003              ,:AT-CREDIT-GROUP                                   
ACT003              ,:AT-BANKRUPTCY-IND                                 
ACT003              ,:AT-MST-SUB-ACCT-IND                               
                FROM                                                    
                     CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
A02891        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
A02891                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     20200000
MFA-TR*       SELECT                                                    20210000
MFA-TR*              AT.COMPANY_NO                                      20220000
MFA-TR*             ,AT.CUSTOMER_NO                                     20230000
MFA-TR*             ,AT.BILL_CYCLE                                      20240000
MFA-TR*             ,AT.PREMISE_NO                                      20250000
MFA-TR*             ,AT.REV_MTH_LST_NRML                                20260000
MFA-TR*             ,AT.LAST_UPDATE_TS                                  20270000
MFA-TR*             ,AT.CODE_BILL_FREQ                                  20280000
MFA-TR*             ,AT.CODES_DATA_PRESENT                              20290000
MFA-TR*             ,AT.CODE_ACCT_STAT                                  20300000
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                               20310000
MFA-TR*             ,AT.CODE_MAJOR_ACCT                                 20320000
MFA-TR*             ,AT.CREDIT_GROUP                                    20330000
MFA-TR*             ,AT.BANKRUPTCY_IND                                  20340000
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                20350000
MFA-TR*         INTO                                                    20360000
MFA-TR*              :AT-COMPANY-NO                                     20370000
MFA-TR*             ,:AT-CUSTOMER-NO                                    20380000
MFA-TR*             ,:AT-BILL-CYCLE                                     20390000
MFA-TR*             ,:AT-PREMISE-NO                                     20400000
MFA-TR*             ,:AT-REV-MTH-LST-NRML                               20410000
MFA-TR*             ,:AT-LAST-UPDATE-TS                                 20420000
MFA-TR*             ,:AT-CODE-BILL-FREQ                                 20430000
MFA-TR*             ,:AT-CODES-DATA-PRESENT                             20440000
MFA-TR*             ,:AT-CODE-ACCT-STAT                                 20450000
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                              20460000
MFA-TR*             ,:AT-CODE-MAJOR-ACCT                                20470000
MFA-TR*             ,:AT-CREDIT-GROUP                                   20480000
MFA-TR*             ,:AT-BANKRUPTCY-IND                                 20490000
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                               20500000
MFA-TR*         FROM                                                    20510000
MFA-TR*              CSS_ACCOUNT AT                                     20520000
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        20530000
MFA-TR*       WITH UR                                                   20540000
MFA-TR*      QUERYNO 7050                                               20550000
MFA-TR*    END-EXEC.                                                    20560000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20570000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 20600000
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 20740000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20770000
      ******************************************************************20780000
      * 7060-GET-REG-PROF.                                             *20790000
      ******************************************************************20800000
      *                                                                 20810000
       7060-GET-REG-PROF.                                               
      *                                                                 20830000
           EXEC SQL                                                     
              SELECT                                                    
                     REG_GROUP_CD                                       
                INTO                                                    
                     :LR-REG-GROUP-CD                                   
                FROM                                                    
                     CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
A02891        WHERE  ACCOUNT_NO = :LR-ACCOUNT-NO                        
A02891                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20840000
MFA-TR*       SELECT                                                    20850000
MFA-TR*              REG_GROUP_CD                                       20860000
MFA-TR*         INTO                                                    20870000
MFA-TR*              :LR-REG-GROUP-CD                                   20880000
MFA-TR*         FROM                                                    20890000
MFA-TR*              CSS_REG_PROFILE                                    20900000
MFA-TR*       WHERE  ACCOUNT_NO = :LR-ACCOUNT-NO                        20910000
MFA-TR*       WITH UR                                                   20920000
MFA-TR*      QUERYNO 7060                                               20930000
MFA-TR*    END-EXEC.                                                    20940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20950000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 20980000
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              IF SQLCODE = NOT-FOUND                                    
                 MOVE '1'                TO WS-COMPANY                  
              ELSE                                                      
                 MOVE LR-REG-GROUP-CD    TO WS-REG-GRP                  
                 MOVE '2'                TO WS-COMPANY                  
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REG_PROFILE'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 21170000
       7060-EXIT.                                                       
ACT003     EXIT.                                                        
      *                                                                 21200000
A03710 7070-GET-BN-REV-MTH.                                             
      *                                                                 21220000
           EXEC SQL                                                     
            SELECT TOP(1) REVENUE_MONTH                                        
             INTO  :BN-REVENUE-MONTH                                    
             FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
             WHERE DATE_EXTRACT  >= CAST(SYSDATETIMEOFFSET() AS DATE)           
             AND CODE_BILL_COND   = 'R'                                 
             ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     21230000
MFA-TR*     SELECT REVENUE_MONTH                                        21240000
MFA-TR*      INTO  :BN-REVENUE-MONTH                                    21250000
MFA-TR*      FROM CSS_BILL_WINDOW                                       21260000
MFA-TR*      WHERE DATE_EXTRACT  >= CURRENT DATE                        21270000
MFA-TR*      AND CODE_BILL_COND   = 'R'                                 21280000
MFA-TR*      ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC                  21290000
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                               21300000
MFA-TR*      QUERYNO 7070                                               21310000
MFA-TR*    END-EXEC.                                                    21320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21330000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 21360000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 21500000
A03710 7070-EXIT.                                                       
A03710     EXIT.                                                        
      *                                                                 21530000
      ******************************************************************21540000
      * 7100-GET-REV-MTH.                                              *21550000
      ******************************************************************21560000
      *                                                                 21570000
       7100-GET-REV-MTH.                                                
      *                                                                 21590000
           EXEC SQL                                                     
ACT003          SELECT COALESCE(MAX(BN.REVENUE_MONTH),0)                
ACT003            INTO :BN-REVENUE-MONTH                                
ACT003            FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
ACT003           WHERE BN.DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                   AND BN.BILL_CYCLE    = :BN-BILL-CYCLE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     21600000
MFA-TR*         SELECT COALESCE(MAX(BN.REVENUE_MONTH),0)                21610000
MFA-TR*           INTO :BN-REVENUE-MONTH                                21620000
MFA-TR*           FROM CSS_BILL_WINDOW BN                               21630000
MFA-TR*          WHERE BN.DATE_EXTRACT <= CURRENT DATE                  21640000
MFA-TR*            AND BN.BILL_CYCLE    = :BN-BILL-CYCLE                21650000
MFA-TR*           WITH UR                                               21660000
MFA-TR*        QUERYNO 7100                                             21670000
MFA-TR*    END-EXEC.                                                    21680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 21690000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 21720000
ACT003     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  AND              
ACT003        BN-REVENUE-MONTH      > 0                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
              MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 21890000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21920000
      ******************************************************************21930000
      * 7500-OPEN-AR-CURSOR                                            *21940000
      ******************************************************************21950000
      *                                                                 21960000
       7500-OPEN-AR-CURSOR.                                             
      *                                                                 21980000
           EXEC SQL                                                     
                OPEN AR_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22020000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 22050000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 22230000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22260000
      ******************************************************************22270000
      * 7510-FETCH-AR-CURSOR                                           *22280000
      ******************************************************************22290000
      *                                                                 22300000
       7510-FETCH-AR-CURSOR.                                            
      *                                                                 22320000
           EXEC SQL                                                     
              FETCH                                                     
                     AR_CURSOR                                          
              INTO                                                      
                    :AC-AMT-AR-DAY-00                                   
                   ,:AC-AMT-AR-DAY-30                                   
                   ,:AC-AMT-AR-DAY-60                                   
                   ,:AC-AMT-AR-DAY-90                                   
                   ,:AC-AMT-UNUSED-CR                                   
                   ,:AC-AMT-TRAN-BALANCE                                
                   ,:AC-TOT-SUMM-UNBILLED                               
                   ,:AC-PYMT-PRIORITY-LVL                               
                   ,:L5-AR-TYPE-LONG-DESC                               
                   ,:AC-ITEM-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22480000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 22510000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-DATA     TO TRUE                        
                    MOVE 0               TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE '7510'          TO ACTIVE-PARAGRAPH            
                    MOVE 'FETCH'         TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSS_AR_CNTL'   TO TABLE-1                     
                    MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1             
                    MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2       
                    MOVE 'ITEM_ID'       TO TABLE-ELEMENT-3             
                    MOVE AC-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1           
                    MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2     
                    MOVE AC-ITEM-ID      TO HOSTVAR-ELEMENT-3           
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                 22740000
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22770000
      ******************************************************************22780000
      * 7520-CLOSE-AR-CURSOR                                           *22790000
      ******************************************************************22800000
      *                                                                 22810000
       7520-CLOSE-AR-CURSOR.                                            
      *                                                                 22830000
           EXEC SQL                                                     
                CLOSE AR_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22870000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 22900000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7520'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
              MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 23080000
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23110000
      ******************************************************************23120000
      * 7600-GET-DELINQ-VALUE                                          *23130000
      ******************************************************************23140000
      *                                                                 23150000
       7600-SELECT-DELINQ.                                              
      *                                                                 23170000
           EXEC SQL                                                     
              SELECT                                                    
                     DELINQ_VALUE                                       
                INTO                                                    
                     :C8-DELINQ-VALUE                                   
                FROM                                                    
                     CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                  
               WHERE                                                    
                     C8.COMPANY_NO  =  :C8-COMPANY-NO                   
                 AND C8.DELINQ_CD   =  :C8-DELINQ-CD                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23180000
MFA-TR*       SELECT                                                    23190000
MFA-TR*              DELINQ_VALUE                                       23200000
MFA-TR*         INTO                                                    23210000
MFA-TR*              :C8-DELINQ-VALUE                                   23220000
MFA-TR*         FROM                                                    23230000
MFA-TR*              CSS_DELINQUENCY  C8                                23240000
MFA-TR*        WHERE                                                    23250000
MFA-TR*              C8.COMPANY_NO  =  :C8-COMPANY-NO                   23260000
MFA-TR*          AND C8.DELINQ_CD   =  :C8-DELINQ-CD                    23270000
MFA-TR*      WITH UR                                                    23280000
MFA-TR*      QUERYNO 7600                                               23290000
MFA-TR*    END-EXEC.                                                    23300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23310000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 23340000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'COMPANY_NO '         TO TABLE-ELEMENT-1             
              MOVE 'DELINQ_CD '          TO TABLE-ELEMENT-2             
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 23500000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23530000
      ******************************************************************23540000
      * 7700-GET-PJS-AMT.                                              *23550000
      ******************************************************************23560000
      *                                                                 23570000
       7700-GET-PJS-AMT.                                                
      *                                                                 23590000
           EXEC SQL                                                     
                SELECT                                                  
                       COALESCE(MONTHLY_BILL_AM,0)                      
                  INTO                                                  
                       :PJ-MONTHLY-BILL-AM                              
                  FROM                                                  
                       CSS_PROJ_SHARE WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       ACCOUNT_NO        = :PJ-ACCOUNT-NO               
                   AND PYMT_PRIORITY_LVL = 129                          
                   AND ITEM_ID           = 1                            
                   AND SHARE_STATUS_CD   = 'A'                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23600000
MFA-TR*         SELECT                                                  23610000
MFA-TR*                COALESCE(MONTHLY_BILL_AM,0)                      23620000
MFA-TR*           INTO                                                  23630000
MFA-TR*                :PJ-MONTHLY-BILL-AM                              23640000
MFA-TR*           FROM                                                  23650000
MFA-TR*                CSS_PROJ_SHARE                                   23660000
MFA-TR*          WHERE                                                  23670000
MFA-TR*                ACCOUNT_NO        = :PJ-ACCOUNT-NO               23680000
MFA-TR*            AND PYMT_PRIORITY_LVL = 129                          23690000
MFA-TR*            AND ITEM_ID           = 1                            23700000
MFA-TR*            AND SHARE_STATUS_CD   = 'A'                          23710000
MFA-TR*           WITH UR                                               23720000
MFA-TR*        QUERYNO 7700                                             23730000
MFA-TR*    END-EXEC.                                                    23740000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23750000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 23780000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
                 MOVE 0.0                TO PJ-MONTHLY-BILL-AM          
              ELSE                                                      
                 CONTINUE                                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7700'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROJ_SHARE'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PJ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 23980000
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24010000
      ******************************************************************24020000
      * 7810-GET-DEP-REQ.                                              *24030000
      ******************************************************************24040000
      *                                                                 24050000
       7810-GET-DEP-REQ.                                                
      *                                                                 24070000
           EXEC SQL                                                     
                SELECT                                                  
                       DR.AMT_MO_PYMT                                   
                      ,DR.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :DR-AMT-MO-PYMT                                  
                      ,:DR-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_DEP_REQ DR WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       DR.ACCOUNT_NO        = :DR-ACCOUNT-NO            
                   AND DR.PYMT_PRIORITY_LVL = 80                        
                   AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24080000
MFA-TR*         SELECT                                                  24090000
MFA-TR*                DR.AMT_MO_PYMT                                   24100000
MFA-TR*               ,DR.NO_SCHED_PYMTS                                24110000
MFA-TR*           INTO                                                  24120000
MFA-TR*                :DR-AMT-MO-PYMT                                  24130000
MFA-TR*               ,:DR-NO-SCHED-PYMTS                               24140000
MFA-TR*           FROM                                                  24150000
MFA-TR*                CSS_DEP_REQ DR                                   24160000
MFA-TR*          WHERE                                                  24170000
MFA-TR*                DR.ACCOUNT_NO        = :DR-ACCOUNT-NO            24180000
MFA-TR*            AND DR.PYMT_PRIORITY_LVL = 80                        24190000
MFA-TR*            AND DR.DEP_ITEM_ID       = :DR-DEP-ITEM-ID           24200000
MFA-TR*           WITH UR                                               24210000
MFA-TR*        QUERYNO 7810                                             24220000
MFA-TR*    END-EXEC.                                                    24230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24240000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 24270000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7810'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DEP_REQ'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEP_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DR-DEP-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24430000
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24460000
      ******************************************************************24470000
      * 7820-GET-DEP-REQ.                                              *24480000
      ******************************************************************24490000
      *                                                                 24500000
       7820-GET-DFA-DET.                                                
      *                                                                 24520000
           EXEC SQL                                                     
                SELECT                                                  
                       DA.AMT_MO_PYMT                                   
                      ,DA.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :DA-AMT-MO-PYMT                                  
                      ,:DA-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_DFA_ACCT DA WITH(READUNCOMMITTED)                    
                 WHERE                                                  
                       DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            
                   AND DA.PYMT_PRIORITY_LVL = 90                        
                   AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24530000
MFA-TR*         SELECT                                                  24540000
MFA-TR*                DA.AMT_MO_PYMT                                   24550000
MFA-TR*               ,DA.NO_SCHED_PYMTS                                24560000
MFA-TR*           INTO                                                  24570000
MFA-TR*                :DA-AMT-MO-PYMT                                  24580000
MFA-TR*               ,:DA-NO-SCHED-PYMTS                               24590000
MFA-TR*           FROM                                                  24600000
MFA-TR*                CSS_DFA_ACCT DA                                  24610000
MFA-TR*          WHERE                                                  24620000
MFA-TR*                DA.ACCOUNT_NO        = :DA-ACCOUNT-NO            24630000
MFA-TR*            AND DA.PYMT_PRIORITY_LVL = 90                        24640000
MFA-TR*            AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID           24650000
MFA-TR*           WITH UR                                               24660000
MFA-TR*        QUERYNO 7820                                             24670000
MFA-TR*    END-EXEC.                                                    24680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24690000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 24720000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7820'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DFA_ITEM_ID'         TO TABLE-ELEMENT-2             
              MOVE DA-DFA-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24880000
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24910000
      ******************************************************************24920000
      * 7830-GET-CNT-DET.                                              *24930000
      ******************************************************************24940000
      *                                                                 24950000
       7830-GET-CNT-DET.                                                
      *                                                                 24970000
           EXEC SQL                                                     
                SELECT                                                  
                       K6.CNT_NAME_DESC                                 
                      ,CT.CODE_BILL_TYPE                                
                      ,CT.AMT_MO_PYMT                                   
                      ,CT.DATE_PYMT_START                               
                      ,CT.NO_SCHED_PYMTS                                
                  INTO                                                  
                       :K6-CNT-NAME-DESC                                
                      ,:CT-CODE-BILL-TYPE                               
                      ,:CT-AMT-MO-PYMT                                  
                      ,:CT-DATE-PYMT-START                              
                      ,:CT-NO-SCHED-PYMTS                               
                  FROM                                                  
                       CSS_CONTRACT    CT WITH(READUNCOMMITTED)                 
                      ,CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            
                   AND CT.PYMT_PRIORITY_LVL = 100                       
                   AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID           
                   AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD            
                   AND CT.CNT_STATUS_CD     = 'B'                       
                   AND CT.CODE_BILL_TYPE    IN ('B','C')                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24980000
MFA-TR*         SELECT                                                  24990000
MFA-TR*                K6.CNT_NAME_DESC                                 25000000
MFA-TR*               ,CT.CODE_BILL_TYPE                                25010000
MFA-TR*               ,CT.AMT_MO_PYMT                                   25020000
MFA-TR*               ,CT.DATE_PYMT_START                               25030000
MFA-TR*               ,CT.NO_SCHED_PYMTS                                25040000
MFA-TR*           INTO                                                  25050000
MFA-TR*                :K6-CNT-NAME-DESC                                25060000
MFA-TR*               ,:CT-CODE-BILL-TYPE                               25070000
MFA-TR*               ,:CT-AMT-MO-PYMT                                  25080000
MFA-TR*               ,:CT-DATE-PYMT-START                              25090000
MFA-TR*               ,:CT-NO-SCHED-PYMTS                               25100000
MFA-TR*           FROM                                                  25110000
MFA-TR*                CSS_CONTRACT    CT                               25120000
MFA-TR*               ,CSS_CONTRACT_INFO K6                             25130000
MFA-TR*          WHERE                                                  25140000
MFA-TR*                CT.ACCOUNT_NO        = :CT-ACCOUNT-NO            25150000
MFA-TR*            AND CT.PYMT_PRIORITY_LVL = 100                       25160000
MFA-TR*            AND CT.CNT_ITEM_ID       = :CT-CNT-ITEM-ID           25170000
MFA-TR*            AND CT.CNT_NAME_CD       = K6.CNT_NAME_CD            25180000
MFA-TR*            AND CT.CNT_STATUS_CD     = 'B'                       25190000
MFA-TR*            AND CT.CODE_BILL_TYPE    IN ('B','C')                25200000
MFA-TR*           WITH UR                                               25210000
MFA-TR*        QUERYNO 7800                                             25220000
MFA-TR*    END-EXEC.                                                    25230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25240000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 25270000
ACT248     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7800'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CNT_ITEM_ID'             TO TABLE-ELEMENT-2         
              MOVE CT-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25430000
       7830-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25460000
      ******************************************************************25470000
P00471* 7900-CHK-DPP-DROP.                                             *25480000
      ******************************************************************25490000
      *                                                                 25500000
       7900-CHK-DPP-DROP.                                               
      *                                                                 25520000
           EXEC SQL                                                     
                SELECT                                                  
                        'Y'                                             
                  INTO                                                  
                       :WS-DPP-DROP-EXISTS                              
                  FROM                                                  
P00471                 CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
                 WHERE                                                  
P00471                 YP.ACCOUNT_NO           = :YP-ACCOUNT-NO         
P00471             AND YP.STATUS_CD            = 'A'                    
P00471             AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'        
P00471                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25530000
MFA-TR*         SELECT                                                  25540000
MFA-TR*                 'Y'                                             25550000
MFA-TR*           INTO                                                  25560000
MFA-TR*                :WS-DPP-DROP-EXISTS                              25570000
MFA-TR*           FROM                                                  25580000
MFA-TR*                CSS_ACCT_ATTRIBUTE YP                            25590000
MFA-TR*          WHERE                                                  25600000
MFA-TR*                YP.ACCOUNT_NO           = :YP-ACCOUNT-NO         25610000
MFA-TR*            AND YP.STATUS_CD            = 'A'                    25620000
MFA-TR*            AND YP.ATTRIBUTE_DESC       = 'AUTO_DROP_DPP'        25630000
MFA-TR*           WITH UR                                               25640000
MFA-TR*        QUERYNO 7900                                             25650000
MFA-TR*    END-EXEC.                                                    25660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25670000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 25700000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT003        MOVE 0                     TO S-RETURN-CODE-1             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7900'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
P00471        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00471        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25840000
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25870000
      ******************************************************************25880000
      * 7910-CHK-BBP-DROP.                                             *25890000
      ******************************************************************25900000
      *                                                                 25910000
       7910-CHK-BBP-DROP.                                               
      *                                                                 25930000
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-BBP-DROP-EXISTS                              
                  FROM                                                  
                       CSS_BUDGET_HIST BH WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                       BH.ACCOUNT_NO         = :BH-ACCOUNT-NO           
                   AND BH.CHANGE_REASON      = 'D'                      
                   AND CIS.SUBSTR3(BH.REMARKS,1,30) =                        
                       'AUTOMATICALLY DROPPED FROM EPP'                 
                   AND CAST(BH.LAST_UPDATE_TS AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-BBP-DPP-CUTOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-BBP-DPP-CUTOFF-DT
              ) <> 0) OR (LEN(:WS-BBP-DPP-CUTOFF-DT
              ) <> 10), CIS.CHAR2DATE(:WS-BBP-DPP-CUTOFF-DT
              ), CONVERT(DATE, :WS-BBP-DPP-CUTOFF-DT) ) 
A02891                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     25940000
MFA-TR*         SELECT                                                  25950000
MFA-TR*                'Y'                                              25960000
MFA-TR*           INTO                                                  25970000
MFA-TR*                :WS-BBP-DROP-EXISTS                              25980000
MFA-TR*           FROM                                                  25990000
MFA-TR*                CSS_BUDGET_HIST BH                               26000000
MFA-TR*          WHERE                                                  26010000
MFA-TR*                BH.ACCOUNT_NO         = :BH-ACCOUNT-NO           26020000
MFA-TR*            AND BH.CHANGE_REASON      = 'D'                      26030000
MFA-TR*            AND SUBSTR(BH.REMARKS,1,30) =                        26040000
MFA-TR*                'AUTOMATICALLY DROPPED FROM EPP'                 26050000
MFA-TR*            AND DATE(BH.LAST_UPDATE_TS) >= :WS-BBP-DPP-CUTOFF-DT 26060000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            26070000
MFA-TR*        QUERYNO 7910                                             26080000
MFA-TR*    END-EXEC.                                                    26090000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26100000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 26130000
ACT003     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT003        MOVE 0                     TO S-RETURN-CODE-1             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7910'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BUDGET_HIST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26270000
       7910-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26300000
      ******************************************************************26310000
      * 7920-CHK-UTL-ARRS.                                             *26320000
      ******************************************************************26330000
      *                                                                 26340000
       7920-CHK-UTL-ARRS.                                               
      *                                                                 26360000
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-UTL-ARRS-EXISTS                              
                  FROM                                                  
                       CSS_AR_CNTL AC WITH(READUNCOMMITTED)                     
                 WHERE                                                  
                       AC.ACCOUNT_NO         = :AC-ACCOUNT-NO           
                   AND AC.PYMT_PRIORITY_LVL  IN (40,45)                 
                   AND (AC.AMT_AR_DAY_60      > 0 OR                    
                        AC.AMT_AR_DAY_90      > 0)                      
A02891                                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26370000
MFA-TR*         SELECT                                                  26380000
MFA-TR*                'Y'                                              26390000
MFA-TR*           INTO                                                  26400000
MFA-TR*                :WS-UTL-ARRS-EXISTS                              26410000
MFA-TR*           FROM                                                  26420000
MFA-TR*                CSS_AR_CNTL AC                                   26430000
MFA-TR*          WHERE                                                  26440000
MFA-TR*                AC.ACCOUNT_NO         = :AC-ACCOUNT-NO           26450000
MFA-TR*            AND AC.PYMT_PRIORITY_LVL  IN (40,45)                 26460000
MFA-TR*            AND (AC.AMT_AR_DAY_60      > 0 OR                    26470000
MFA-TR*                 AC.AMT_AR_DAY_90      > 0)                      26480000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            26490000
MFA-TR*        QUERYNO 7920                                             26500000
MFA-TR*    END-EXEC.                                                    26510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26520000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 26550000
ACT003     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT003        MOVE 0                     TO S-RETURN-CODE-1             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7920'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26690000
       7920-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26720000
      ******************************************************************26730000
      * 7930-GET-UTIL-DET.                                             *26740000
      ******************************************************************26750000
      *                                                                 26760000
       7930-GET-UTIL-DET.                                               
      *                                                                 26780000
           EXEC SQL                                                     
                SELECT                                                  
                       UT.PREMISE_NO                                    
                      ,UT.IC_NO                                         
                      ,UT.RATE_PLAN_NO                                  
                      ,DF.OPTION_CD                                     
                      ,UT.RT_PKG_OPT_SEQ_NO                             
                      ,FI.OPT_DESC_INT                                  
                      ,FI.OPT_DESC_INT_LONG                             
P00836                ,FI.OPT_CALC_TYPE_CD                              
                  INTO                                                  
                       :UT-PREMISE-NO                                   
                      ,:UT-IC-NO                                        
                      ,:UT-RATE-PLAN-NO                                 
                      ,:DF-OPTION-CD                                    
                      ,:UT-RT-PKG-OPT-SEQ-NO                            
                      ,:FI-OPT-DESC-INT                                 
                      ,:FI-OPT-DESC-INT-LONG                            
P00836                ,:FI-OPT-CALC-TYPE-CD                             
                  FROM                                                  
                       CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                      ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
                      ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)               
                WHERE                                                   
                      UT.ACCOUNT_NO       = :UT-ACCOUNT-NO              
                  AND UT.ACCOUNT_NO       = DF.ACCOUNT_NO               
                  AND UT.CODE_UTIL_TYPE   = 'G'                         
                  AND UT.CODE_UTIL_TYPE   = DF.CODE_UTIL_TYPE           
                  AND UT.IC_NO            = DF.IC_NO                    
                  AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO       
                  AND DF.OPTION_CD        = FI.OPTION_CD                
P00473            AND FI.OPT_VSTART_TS   <= CIS.CURRENT$TIMESTAMP()           
P00473            AND FI.OPT_VEND_TS     >= CIS.CURRENT$TIMESTAMP()           
P00473            AND FI.PROC_STATUS_CD   = 'AC'                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     26790000
MFA-TR*         SELECT                                                  26800000
MFA-TR*                UT.PREMISE_NO                                    26810000
MFA-TR*               ,UT.IC_NO                                         26820000
MFA-TR*               ,UT.RATE_PLAN_NO                                  26830000
MFA-TR*               ,DF.OPTION_CD                                     26840000
MFA-TR*               ,UT.RT_PKG_OPT_SEQ_NO                             26850000
MFA-TR*               ,FI.OPT_DESC_INT                                  26860000
MFA-TR*               ,FI.OPT_DESC_INT_LONG                             26870000
MFA-TR*               ,FI.OPT_CALC_TYPE_CD                              26871000
MFA-TR*           INTO                                                  26880000
MFA-TR*                :UT-PREMISE-NO                                   26890000
MFA-TR*               ,:UT-IC-NO                                        26900000
MFA-TR*               ,:UT-RATE-PLAN-NO                                 26910000
MFA-TR*               ,:DF-OPTION-CD                                    26920000
MFA-TR*               ,:UT-RT-PKG-OPT-SEQ-NO                            26930000
MFA-TR*               ,:FI-OPT-DESC-INT                                 26940000
MFA-TR*               ,:FI-OPT-DESC-INT-LONG                            26950000
MFA-TR*               ,:FI-OPT-CALC-TYPE-CD                             26951000
MFA-TR*           FROM                                                  26960000
MFA-TR*                CSS_UTIL_ENVRNMT UT                              26970000
MFA-TR*               ,CSS_ACCT_RTPK_AGR DF                             26980000
MFA-TR*               ,CRM_RT_PKG_OPTION FI                             26990000
MFA-TR*         WHERE                                                   27000000
MFA-TR*               UT.ACCOUNT_NO       = :UT-ACCOUNT-NO              27010000
MFA-TR*           AND UT.ACCOUNT_NO       = DF.ACCOUNT_NO               27020000
MFA-TR*           AND UT.CODE_UTIL_TYPE   = 'G'                         27030000
MFA-TR*           AND UT.CODE_UTIL_TYPE   = DF.CODE_UTIL_TYPE           27040000
MFA-TR*           AND UT.IC_NO            = DF.IC_NO                    27050000
MFA-TR*           AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO       27060000
MFA-TR*           AND DF.OPTION_CD        = FI.OPTION_CD                27070000
MFA-TR*           AND FI.OPT_VSTART_TS   <= CURRENT TIMESTAMP           27080000
MFA-TR*           AND FI.OPT_VEND_TS     >= CURRENT TIMESTAMP           27090000
MFA-TR*           AND FI.PROC_STATUS_CD   = 'AC'                        27100000
MFA-TR*          WITH UR                                                27110000
MFA-TR*       QUERYNO 7930                                              27120000
MFA-TR*    END-EXEC.                                                    27130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27140000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
      *                                                                 27170000
ACT078     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '7930'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 27310000
       7930-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27340000
      ******************************************************************27350000
      * 7940-GET-DDDC.                                                 *27360000
      ******************************************************************27370000
      *                                                                 27380000
       7940-GET-DDDC.                                                   
      *                                                                 27400000
           EXEC SQL                                                     
                SELECT                                                  
                       FF.FACTOR                                        
                  INTO                                                  
                       :FF-FACTOR                                       
                  FROM                                                  
                       CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                  
                 WHERE                                                  
                       ACCOUNT_NO      = :FF-ACCOUNT-NO                 
                   AND IC_NO           = :FF-IC-NO                      
                   AND FACTOR_ID       = 'DDC'                          
                   AND CODE_UTIL_TYPE  = 'G'                            
                   AND EFF_DATE_FROM  <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                   AND EFF_DATE_TO    >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     27410000
MFA-TR*         SELECT                                                  27420000
MFA-TR*                FF.FACTOR                                        27430000
MFA-TR*           INTO                                                  27440000
MFA-TR*                :FF-FACTOR                                       27450000
MFA-TR*           FROM                                                  27460000
MFA-TR*                CSS_FIXED_FCTR FF                                27470000
MFA-TR*          WHERE                                                  27480000
MFA-TR*                ACCOUNT_NO      = :FF-ACCOUNT-NO                 27490000
MFA-TR*            AND IC_NO           = :FF-IC-NO                      27500000
MFA-TR*            AND FACTOR_ID       = 'DDC'                          27510000
MFA-TR*            AND CODE_UTIL_TYPE  = 'G'                            27520000
MFA-TR*            AND EFF_DATE_FROM  <= CURRENT DATE                   27530000
MFA-TR*            AND EFF_DATE_TO    >= CURRENT DATE                   27540000
MFA-TR*           WITH UR                                               27550000
MFA-TR*        QUERYNO 7940                                             27560000
MFA-TR*    END-EXEC.                                                    27570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27580000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
      *                                                                 27610000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
A04987            IF PR-DDDC-FCTR > 0                                   
A04987               MOVE PR-DDDC-FCTR          TO FF-FACTOR            
A04987            ELSE                                                  
                     MOVE 'EPP-DEFAULT-DDDC'    TO C8-DELINQ-CD         
                     PERFORM 7600-SELECT-DELINQ THRU 7600-EXIT          
                     MOVE C8-DELINQ-VALUE     TO FF-FACTOR              
A04987                                           WS-EPP-DEFAULT-DDDC-ED 
A04987            END-IF                                                
               ELSE                                                     
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '7940'            TO ACTIVE-PARAGRAPH            
                  MOVE 'SELECT'          TO ABEND-FUNCTION              
                  MOVE 'CSS_FIXED_FCTR'  TO TABLE-1                     
                  MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1             
                  MOVE 'IC_NO'           TO TABLE-ELEMENT-2             
                  MOVE FF-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1           
                  MOVE FF-IC-NO          TO HOSTVAR-ELEMENT-2           
                  PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
      *                                                                 27820000
       7940-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27850000
      ******************************************************************27860000
      * 7960-GET-ZIP-CD.                                               *27870000
      ******************************************************************27880000
      *                                                                 27890000
       7960-GET-ZIP-CD.                                                 
      *                                                                 27910000
           EXEC SQL                                                     
                SELECT TOP(1) PR.LOCAL_OFFICE,
              PR.COMPANY_NO,
              DY.ZIP_CODE,
              DY.ZIP_CODE_TOKEN,
              PR.DDDC_FCTR                                     
                  INTO                                                  
                       :PR-LOCAL-OFFICE                                 
                      ,:PR-COMPANY-NO                                   
                      ,:DY-ZIP-CODE                                     
                      ,:DY-ZIP-CODE-TOKEN                               
A04987                ,:PR-DDDC-FCTR                                    
                  FROM                                                  
                       CSS_PREMISE  PR WITH(READUNCOMMITTED),                   
                       CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)              
                 WHERE                                                  
                       PR.PREMISE_NO =:PR-PREMISE-NO                    
                   AND DY.ADDRESS_ID = PR.ADDRESS_ID                    
                                                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27920000
MFA-TR*         SELECT                                                  27930000
MFA-TR*                PR.LOCAL_OFFICE                                  27940000
MFA-TR*               ,PR.COMPANY_NO                                    27950000
MFA-TR*               ,DY.ZIP_CODE                                      27960000
MFA-TR*               ,DY.ZIP_CODE_TOKEN                                27970000
MFA-TR*               ,PR.DDDC_FCTR                                     27971000
MFA-TR*           INTO                                                  27980000
MFA-TR*                :PR-LOCAL-OFFICE                                 27990000
MFA-TR*               ,:PR-COMPANY-NO                                   28000000
MFA-TR*               ,:DY-ZIP-CODE                                     28010000
MFA-TR*               ,:DY-ZIP-CODE-TOKEN                               28020000
MFA-TR*               ,:PR-DDDC-FCTR                                    28021000
MFA-TR*           FROM                                                  28030000
MFA-TR*                CSS_PREMISE  PR,                                 28040000
MFA-TR*                CSS_ADDR_FORMATTED DY                            28050000
MFA-TR*          WHERE                                                  28060000
MFA-TR*                PR.PREMISE_NO =:PR-PREMISE-NO                    28070000
MFA-TR*            AND DY.ADDRESS_ID = PR.ADDRESS_ID                    28080000
MFA-TR*          FETCH FIRST ROW ONLY                                   28090000
MFA-TR*           WITH UR                                               28100000
MFA-TR*        QUERYNO 7960                                             28110000
MFA-TR*    END-EXEC                                                     28120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28130000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
      *                                                                 28160000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7960'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28310000
      ******************************************************************28320000
      * 8000A-DEL-GTT-ROWS.                                            *28330000
      ******************************************************************28340000
      *                                                                 28350000
       8000A-DEL-GTT-ROWS.                                              
      *                                                                 28370000
           EXEC SQL                                                     
               DELETE FROM #CSR04344_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     28380000
MFA-TR*        DELETE FROM SESSION.CSR04344_R1                          28390000
MFA-TR*    END-EXEC.                                                    28400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28410000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 28440000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000A'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04344_R1'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 28640000
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 28670000
      ******************************************************************28680000
      * 8000B-DEL-GTT-ROWS.                                            *28690000
      ******************************************************************28700000
      *                                                                 28710000
       8000B-DEL-GTT-ROWS.                                              
      *                                                                 28730000
           EXEC SQL                                                     
               DELETE FROM #CSR04344_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     28740000
MFA-TR*        DELETE FROM SESSION.CSR04344_R2                          28750000
MFA-TR*    END-EXEC.                                                    28760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28770000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 28800000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000B'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04344_R2'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 29000000
      *                                                                 29010000
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 29040000
      ******************************************************************29050000
      * 8000C-DEL-GTT-ROWS.                                            *29060000
      ******************************************************************29070000
      *                                                                 29080000
       8000C-DEL-GTT-ROWS.                                              
      *                                                                 29100000
           EXEC SQL                                                     
               DELETE FROM #CSR04344_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     29110000
MFA-TR*        DELETE FROM SESSION.CSR04344_R3                          29120000
MFA-TR*    END-EXEC.                                                    29130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29140000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 29170000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04344_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 29370000
       8000C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 29400000
      ******************************************************************29410000
      * 8000D-DEL-GTT-ROWS.                                            *29420000
      ******************************************************************29430000
      *                                                                 29440000
       8000D-DEL-GTT-ROWS.                                              
      *                                                                 29460000
           EXEC SQL                                                     
               DELETE FROM #CSR04344_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     29470000
MFA-TR*        DELETE FROM SESSION.CSR04344_R4                          29480000
MFA-TR*    END-EXEC.                                                    29490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29500000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 29530000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04344_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 29730000
       8000D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 29760000
      ******************************************************************29770000
      * 8000E-DEL-GTT-ROWS.                                            *29780000
      ******************************************************************29790000
      *                                                                 29800000
       8000E-DEL-GTT-ROWS.                                              
      *                                                                 29820000
           EXEC SQL                                                     
               DELETE FROM #CSR04344_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     29830000
MFA-TR*        DELETE FROM SESSION.CSR04344_R5                          29840000
MFA-TR*    END-EXEC.                                                    29850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29860000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 29890000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000E'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04344_R5'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
      *                                                                 30090000
       8000E-EXIT.                                                      
            EXIT.                                                       
      *                                                                 30120000
P00721******************************************************************30121000
P00721* 8000F-DEL-GTT-ROWS.                                            *30122000
P00721******************************************************************30123000
P00721*                                                                 30124000
P00721 8000F-DEL-GTT-ROWS.                                              
P00721*                                                                 30126000
P00721     EXEC SQL                                                     
P00721         DELETE FROM #CSR04344_R6                          
P00721     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     30127000
MFA-TR*        DELETE FROM SESSION.CSR04344_R6                          30128000
MFA-TR*    END-EXEC.                                                    30129000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00721*                                                                 30129100
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-6.            
P00721*                                                                 30129400
P00721     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00721         WHEN SUCCESSFUL-CALL                                     
P00721              CONTINUE                                            
P00721         WHEN NOT-FOUND                                           
P00721              MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-5             
P00721         WHEN OTHER                                               
P00721              MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
P00721              MOVE SQLCODE         TO ABEND-SQLCODE               
P00721              MOVE SQLSTATE        TO ABEND-SQLSTATE              
P00721              MOVE '8000F'         TO ACTIVE-PARAGRAPH            
P00721              MOVE 'DELETE'        TO ABEND-FUNCTION              
P00721              MOVE SPACES          TO ABEND-SQL-PREDICATES        
P00721                                      ABEND-TABLES                
P00721              MOVE 'CSR04344_R6'   TO TABLE-1                     
P00721              MOVE SPACES          TO TABLE-ELEMENT-1             
P00721              MOVE SPACES          TO HOSTVAR-ELEMENT-1           
P00721              PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
P00721     END-EVALUATE.                                                
      *                                                                 30131400
P00721 8000F-EXIT.                                                      
P00721      EXIT.                                                       
      *                                                                 30131700
      ******************************************************************30132000
      * 8010-INSERT-GTT-R1.                                            *30140000
      ******************************************************************30150000
      *                                                                 30160000
       8010-INSERT-GTT-R1.                                              
      *                                                                 30180000
            EXEC SQL                                                    
               INSERT INTO #CSR04344_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,BUS_RULE_TYPE                                       
                   ,BUS_RULE_RESULT                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-1                                    
                   ,:S-BUS-RULE-TYPE                                    
                   ,:S-BUS-RULE-RESULT                                  
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    30190000
MFA-TR*        INSERT INTO SESSION.CSR04344_R1                          30200000
MFA-TR*           (                                                     30210000
MFA-TR*             RETURN_CODE                                         30220000
MFA-TR*            ,BUS_RULE_TYPE                                       30230000
MFA-TR*            ,BUS_RULE_RESULT                                     30240000
MFA-TR*           )                                                     30250000
MFA-TR*        VALUES                                                   30260000
MFA-TR*           (                                                     30270000
MFA-TR*             :S-RETURN-CODE-1                                    30280000
MFA-TR*            ,:S-BUS-RULE-TYPE                                    30290000
MFA-TR*            ,:S-BUS-RULE-RESULT                                  30300000
MFA-TR*           )                                                     30310000
MFA-TR*     END-EXEC                                                    30320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30330000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 30360000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-RULES               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04344_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 30520000
        8010-EXIT.                                                      
            EXIT.                                                       
      *                                                                 30550000
      ******************************************************************30560000
      * 8020-INSERT-GTT-R2.                                            *30570000
      ******************************************************************30580000
      *                                                                 30590000
       8020-INSERT-GTT-R2.                                              
      *                                                                 30610000
            EXEC SQL                                                    
               INSERT INTO #CSR04344_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,OPTION_SEQ_NO                                       
                   ,OPTION_DESC                                         
                   ,UTILITY_BALANCE                                     
                   ,UTILITY_ARREARS                                     
                   ,AMT_MO_PYMT                                         
                   ,AMT_ELEC_MO_PYMT                                    
                   ,AMT_GAS_MO_PYMT                                     
                   ,AMT_UNMTRD_MO_PYMT                                  
                   ,AMT_OTHER_PYMTS                                     
                   ,AMT_ROLLOVR                                         
                   ,OPTN_PLS_PAY_AMT                                    
                   ,START_DATE                                          
                   ,MTHS_ACCT_USAGE                                     
                   ,MTHS_PREM_USAGE                                     
                   ,BBP_BILL_FLAG                                       
                   ,BBP_EST_AMT                                         
                   ,LAST_UPDATE_TS                                      
                   ,REMARKS_TEXT                                        
                   ,REMARKS_LENGTH                                      
P0694A             ,PVTL_TOTAL                                          
P0694A             ,SUBL_TOTAL                                          
P0694A             ,NONBBP_ELIG_AMT                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-2                                    
                   ,:S-OPTION-SEQ-NO                                    
                   ,:S-OPTION-DESC                                      
                   ,:S-UTILITY-BALANCE                                  
                   ,:S-UTILITY-ARREARS                                  
                   ,:S-AMT-MO-PYMT                                      
                   ,:S-AMT-ELEC-MO-PYMT                                 
                   ,:S-AMT-GAS-MO-PYMT                                  
                   ,:S-AMT-UNMTRD-MO-PYMT                               
                   ,:S-AMT-OTHER-PYMTS                                  
                   ,:S-AMT-ROLLOVR                                      
                   ,:S-OPTN-PLS-PAY-AMT                                 
                   ,:S-START-DATE                                       
                   ,:S-MTHS-ACCT-USAGE                                  
                   ,:S-MTHS-PREM-USAGE                                  
                   ,:S-BBP-BILL-FLAG                                    
                   ,:S-BBP-EST-AMT                                      
                   ,:S-LAST-UPDATE-TS                                   
                   ,:S-REMARKS-TEXT                                     
                   ,:S-REMARKS-LENGTH                                   
P0694A             ,:S-PVTL-TOTAL                                       
P0694A             ,:S-SUBL-TOTAL                                       
P0694A             ,:S-NONBBP-ELIG-AMT                                  
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    30620000
MFA-TR*        INSERT INTO SESSION.CSR04344_R2                          30630000
MFA-TR*           (                                                     30640000
MFA-TR*             RETURN_CODE                                         30650000
MFA-TR*            ,OPTION_SEQ_NO                                       30660000
MFA-TR*            ,OPTION_DESC                                         30670000
MFA-TR*            ,UTILITY_BALANCE                                     30680000
MFA-TR*            ,UTILITY_ARREARS                                     30690000
MFA-TR*            ,AMT_MO_PYMT                                         30700000
MFA-TR*            ,AMT_ELEC_MO_PYMT                                    30710000
MFA-TR*            ,AMT_GAS_MO_PYMT                                     30720000
MFA-TR*            ,AMT_UNMTRD_MO_PYMT                                  30730000
MFA-TR*            ,AMT_OTHER_PYMTS                                     30740000
MFA-TR*            ,AMT_ROLLOVR                                         30750000
MFA-TR*            ,OPTN_PLS_PAY_AMT                                    30760000
MFA-TR*            ,START_DATE                                          30770000
MFA-TR*            ,MTHS_ACCT_USAGE                                     30780000
MFA-TR*            ,MTHS_PREM_USAGE                                     30790000
MFA-TR*            ,BBP_BILL_FLAG                                       30800000
MFA-TR*            ,BBP_EST_AMT                                         30810000
MFA-TR*            ,LAST_UPDATE_TS                                      30820000
MFA-TR*            ,REMARKS_TEXT                                        30830000
MFA-TR*            ,REMARKS_LENGTH                                      30840000
MFA-TR*            ,PVTL_TOTAL                                          30850000
MFA-TR*            ,SUBL_TOTAL                                          30860000
MFA-TR*            ,NONBBP_ELIG_AMT                                     30870000
MFA-TR*           )                                                     30880000
MFA-TR*        VALUES                                                   30890000
MFA-TR*           (                                                     30900000
MFA-TR*             :S-RETURN-CODE-2                                    30910000
MFA-TR*            ,:S-OPTION-SEQ-NO                                    30920000
MFA-TR*            ,:S-OPTION-DESC                                      30930000
MFA-TR*            ,:S-UTILITY-BALANCE                                  30940000
MFA-TR*            ,:S-UTILITY-ARREARS                                  30950000
MFA-TR*            ,:S-AMT-MO-PYMT                                      30960000
MFA-TR*            ,:S-AMT-ELEC-MO-PYMT                                 30970000
MFA-TR*            ,:S-AMT-GAS-MO-PYMT                                  30980000
MFA-TR*            ,:S-AMT-UNMTRD-MO-PYMT                               30990000
MFA-TR*            ,:S-AMT-OTHER-PYMTS                                  31000000
MFA-TR*            ,:S-AMT-ROLLOVR                                      31010000
MFA-TR*            ,:S-OPTN-PLS-PAY-AMT                                 31020000
MFA-TR*            ,:S-START-DATE                                       31030000
MFA-TR*            ,:S-MTHS-ACCT-USAGE                                  31040000
MFA-TR*            ,:S-MTHS-PREM-USAGE                                  31050000
MFA-TR*            ,:S-BBP-BILL-FLAG                                    31060000
MFA-TR*            ,:S-BBP-EST-AMT                                      31070000
MFA-TR*            ,:S-LAST-UPDATE-TS                                   31080000
MFA-TR*            ,:S-REMARKS-TEXT                                     31090000
MFA-TR*            ,:S-REMARKS-LENGTH                                   31100000
MFA-TR*            ,:S-PVTL-TOTAL                                       31110000
MFA-TR*            ,:S-SUBL-TOTAL                                       31120000
MFA-TR*            ,:S-NONBBP-ELIG-AMT                                  31130000
MFA-TR*           )                                                     31140000
MFA-TR*     END-EXEC                                                    31150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31160000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 31190000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-OPTIONS             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04344_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 31350000
        8020-EXIT.                                                      
            EXIT.                                                       
      *                                                                 31380000
      ******************************************************************31390000
      * 8030-INSERT-GTT-R3.                                            *31400000
      ******************************************************************31410000
      *                                                                 31420000
       8030-INSERT-GTT-R3.                                              
      *                                                                 31440000
            EXEC SQL                                                    
               INSERT INTO #CSR04344_R3                          
                  (                                                     
                    RETURN_CODE                                         
                   ,CNT_NAME_DESC                                       
                   ,CNT_AMT_MO_PYMT                                     
                   ,CNT_PYMTS_REMAIN                                    
                   ,CNT_EXPIRY_DT                                       
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-3                                    
                   ,:S-CNT-NAME-DESC                                    
                   ,:S-CNT-AMT-MO-PYMT                                  
                   ,:S-CNT-PYMTS-REMAIN                                 
                   ,:S-CNT-EXPIRY-DT                                    
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    31450000
MFA-TR*        INSERT INTO SESSION.CSR04344_R3                          31460000
MFA-TR*           (                                                     31470000
MFA-TR*             RETURN_CODE                                         31480000
MFA-TR*            ,CNT_NAME_DESC                                       31490000
MFA-TR*            ,CNT_AMT_MO_PYMT                                     31500000
MFA-TR*            ,CNT_PYMTS_REMAIN                                    31510000
MFA-TR*            ,CNT_EXPIRY_DT                                       31520000
MFA-TR*           )                                                     31530000
MFA-TR*        VALUES                                                   31540000
MFA-TR*           (                                                     31550000
MFA-TR*             :S-RETURN-CODE-3                                    31560000
MFA-TR*            ,:S-CNT-NAME-DESC                                    31570000
MFA-TR*            ,:S-CNT-AMT-MO-PYMT                                  31580000
MFA-TR*            ,:S-CNT-PYMTS-REMAIN                                 31590000
MFA-TR*            ,:S-CNT-EXPIRY-DT                                    31600000
MFA-TR*           )                                                     31610000
MFA-TR*     END-EXEC                                                    31620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31630000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
      *                                                                 31660000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-MTHLY-CHRGS             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04344_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 31820000
        8030-EXIT.                                                      
            EXIT.                                                       
      *                                                                 31850000
      ******************************************************************31860000
      * 8040-INSERT-GTT-R4.                                            *31870000
      ******************************************************************31880000
      *                                                                 31890000
       8040-INSERT-GTT-R4.                                              
      *                                                                 31910000
            EXEC SQL                                                    
               INSERT INTO #CSR04344_R4                          
                  (                                                     
                    RETURN_CODE                                         
                   ,REVENUE_MONTH                                       
                   ,DAYS                                                
                   ,UNITS                                               
                   ,CODE_UTIL_TYPE                                      
                   ,CUSTOMER_NO                                         
                   ,NEW_CHARGE                                          
                   ,RATE_PLAN_NO                                        
                   ,CALC_ERROR                                          
                   ,HTG_CLG_SW                                          
                   ,EPP_CATEGORY                                        
P0694A             ,ELEC_BUFFER                                         
P0694A             ,GAS_BUFFER                                          
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-4                                    
                   ,:S-REVENUE-MONTH                                    
                   ,:S-DAYS                                             
                   ,:S-UNITS                                            
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-CUSTOMER-NO                                      
                   ,:S-NEW-CHARGE                                       
                   ,:S-RATE-PLAN-NO                                     
                   ,:S-CALC-ERROR                                       
                   ,:S-HTG-CLG-SW                                       
                   ,:S-BPP-CATEGORY                                     
P0694A             ,:S-ELEC-BUFFER                                      
P0694A             ,:S-GAS-BUFFER                                       
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    31920000
MFA-TR*        INSERT INTO SESSION.CSR04344_R4                          31930000
MFA-TR*           (                                                     31940000
MFA-TR*             RETURN_CODE                                         31950000
MFA-TR*            ,REVENUE_MONTH                                       31960000
MFA-TR*            ,DAYS                                                31970000
MFA-TR*            ,UNITS                                               31980000
MFA-TR*            ,CODE_UTIL_TYPE                                      31990000
MFA-TR*            ,CUSTOMER_NO                                         32000000
MFA-TR*            ,NEW_CHARGE                                          32010000
MFA-TR*            ,RATE_PLAN_NO                                        32020000
MFA-TR*            ,CALC_ERROR                                          32030000
MFA-TR*            ,HTG_CLG_SW                                          32040000
MFA-TR*            ,EPP_CATEGORY                                        32050000
MFA-TR*            ,ELEC_BUFFER                                         32060000
MFA-TR*            ,GAS_BUFFER                                          32070000
MFA-TR*           )                                                     32080000
MFA-TR*        VALUES                                                   32090000
MFA-TR*           (                                                     32100000
MFA-TR*             :S-RETURN-CODE-4                                    32110000
MFA-TR*            ,:S-REVENUE-MONTH                                    32120000
MFA-TR*            ,:S-DAYS                                             32130000
MFA-TR*            ,:S-UNITS                                            32140000
MFA-TR*            ,:S-CODE-UTIL-TYPE                                   32150000
MFA-TR*            ,:S-CUSTOMER-NO                                      32160000
MFA-TR*            ,:S-NEW-CHARGE                                       32170000
MFA-TR*            ,:S-RATE-PLAN-NO                                     32180000
MFA-TR*            ,:S-CALC-ERROR                                       32190000
MFA-TR*            ,:S-HTG-CLG-SW                                       32200000
MFA-TR*            ,:S-BPP-CATEGORY                                     32210000
MFA-TR*            ,:S-ELEC-BUFFER                                      32220000
MFA-TR*            ,:S-GAS-BUFFER                                       32230000
MFA-TR*           )                                                     32240000
MFA-TR*     END-EXEC                                                    32250000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32260000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 32290000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-USAGE               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04344_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 32450000
        8040-EXIT.                                                      
            EXIT.                                                       
      *                                                                 32480000
      ******************************************************************32490000
      * 8050-INSERT-GTT-R5.                                            *32500000
      ******************************************************************32510000
      *                                                                 32520000
       8050-INSERT-GTT-R5.                                              
      *                                                                 32540000
            EXEC SQL                                                    
               INSERT INTO #CSR04344_R5                          
                  (                                                     
                    RETURN_CODE                                         
                   ,OPTION_SEQ_NO                                       
                   ,AR_TYPE_DESC                                        
                   ,PLS_PAY_DET_AMT                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE-5                                    
                   ,:S-OPTN-SEQ-NO-5                                    
                   ,:S-AR-TYPE-DESC                                     
                   ,:S-PLS-PAY-DET-AMT                                  
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    32550000
MFA-TR*        INSERT INTO SESSION.CSR04344_R5                          32560000
MFA-TR*           (                                                     32570000
MFA-TR*             RETURN_CODE                                         32580000
MFA-TR*            ,OPTION_SEQ_NO                                       32590000
MFA-TR*            ,AR_TYPE_DESC                                        32600000
MFA-TR*            ,PLS_PAY_DET_AMT                                     32610000
MFA-TR*           )                                                     32620000
MFA-TR*        VALUES                                                   32630000
MFA-TR*           (                                                     32640000
MFA-TR*             :S-RETURN-CODE-5                                    32650000
MFA-TR*            ,:S-OPTN-SEQ-NO-5                                    32660000
MFA-TR*            ,:S-AR-TYPE-DESC                                     32670000
MFA-TR*            ,:S-PLS-PAY-DET-AMT                                  32680000
MFA-TR*           )                                                     32690000
MFA-TR*     END-EXEC                                                    32700000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32710000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 32740000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
                                             WS-BBP-PLS-PAY             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04344_R5'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 32900000
        8050-EXIT.                                                      
            EXIT.                                                       
      *                                                                 32930000
P00721******************************************************************32931000
P00721* 8060-INSERT-GTT-R6.                                            *32932000
P00721******************************************************************32933000
P00721*                                                                 32934000
P00721 8060-INSERT-GTT-R6.                                              
P00721*                                                                 32936000
P00721      EXEC SQL                                                    
P00721         INSERT INTO #CSR04344_R6                          
P00721            (                                                     
P00721              RETURN_CODE                                         
P00721             ,BBP_ELIGIBLE                                        
P00721            )                                                     
P00721         VALUES                                                   
P00721            (                                                     
P00721              :S-RETURN-CODE-6                                    
P00721             ,:S-BBP-ELIGIBLE                                     
P00721            )                                                     
P00721      END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    32937000
MFA-TR*        INSERT INTO SESSION.CSR04344_R6                          32938000
MFA-TR*           (                                                     32939000
MFA-TR*             RETURN_CODE                                         32939100
MFA-TR*            ,BBP_ELIGIBLE                                        32939200
MFA-TR*           )                                                     32939500
MFA-TR*        VALUES                                                   32939600
MFA-TR*           (                                                     32939700
MFA-TR*             :S-RETURN-CODE-6                                    32939800
MFA-TR*            ,:S-BBP-ELIGIBLE                                     32939900
MFA-TR*           )                                                     32940200
MFA-TR*     END-EXEC                                                    32940300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00721*                                                                 32940400
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-6.            
P00721*                                                                 32940700
P00721     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00721        ADD +1                     TO  CTR-ROWS                   
P00721                                       WS-BBP-ELIG                
P00721     ELSE                                                         
P00721        MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
P00721        MOVE '8060'                TO  ACTIVE-PARAGRAPH           
P00721        MOVE SQLCODE               TO  ABEND-SQLCODE              
P00721        MOVE 'INSERT'              TO  ABEND-FUNCTION             
P00721        MOVE SPACES                TO  ABEND-SQL-PREDICATES       
P00721                                       ABEND-TABLES               
P00721        MOVE 'CSR04344_R6'         TO  TABLE-1                    
P00721        MOVE SPACES                TO  TABLE-ELEMENT-1            
P00721        MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
P00721        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00721     END-IF.                                                      
P00721*                                                                 32942300
P00721  8060-EXIT.                                                      
P00721      EXIT.                                                       
P00721*                                                                 32942600
      ******************************************************************32943000
      * 8800-CHECK-RESULTS.                                            *32950000
      ******************************************************************32960000
      *                                                                 32970000
       8800-CHECK-RESULTS.                                              
      *                                                                 32990000
           IF WS-BBP-RULES   = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 100                      TO S-RETURN-CODE-1          
              PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT              
           END-IF.                                                      
      *                                                                 33050000
           IF WS-BBP-OPTIONS = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 100                      TO S-RETURN-CODE-2          
              PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT              
           END-IF.                                                      
      *                                                                 33110000
           IF WS-MTHLY-CHRGS = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 100                      TO S-RETURN-CODE-3          
              PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT              
           END-IF.                                                      
      *                                                                 33170000
           IF WS-BBP-USAGE   = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 100                      TO S-RETURN-CODE-4          
              PERFORM 8040-INSERT-GTT-R4    THRU 8040-EXIT              
           END-IF.                                                      
      *                                                                 33230000
           IF WS-BBP-PLS-PAY = 0                                        
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 100                      TO S-RETURN-CODE-5          
              PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT              
           END-IF.                                                      
      *                                                                 33290000
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 33320000
P00721******************************************************************33321000
P00721* 8810-CHECK-RESULTS.                                            *33322000
P00721******************************************************************33323000
P00721*                                                                 33324000
P00721 8810-CHECK-RESULTS.                                              
P00721*                                                                 33326000
P00721     IF WS-BBP-ELIG = 0                                           
P00721        INITIALIZE GTT-RETURN-FIELDS-6                            
P00721        MOVE 100                      TO S-RETURN-CODE-6          
P00721        PERFORM 8060-INSERT-GTT-R6    THRU 8060-EXIT              
P00721     END-IF.                                                      
      *                                                                 33329900
P00721 8810-EXIT.                                                       
P00721     EXIT.                                                        
      *                                                                 33330200
      ******************************************************************33331000
      * 8900-SEND-DONE.                                                *33340000
      ******************************************************************33350000
      *                                                                 33360000
       8900-SEND-DONE.                                                  
      *                                                                 33380000
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 33420000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
      *                                                                 33450000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04344_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 33570000
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 33610000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
      *                                                                 33640000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04344_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 33760000
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 33800000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 33830000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04344_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 33950000
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 33990000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
      *                                                                 34020000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04344_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34140000
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                 34180000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
      *                                                                 34210000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04344_R5'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 34330000
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 34360000
P00721******************************************************************34361000
P00721* 8910-SEND-DONE.                                                *34362000
P00721******************************************************************34363000
P00721  8910-SEND-DONE.                                                 
P00721                                                                  
P00721     EXEC SQL                                                     
P00721         OPEN C6                                                  
P00721     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00721*                                                                 34371000
P00721     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
P00721                                      S-RETURN-CODE-6.            
P00721*                                                                 34371300
P00721     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00721        NEXT SENTENCE                                             
P00721     ELSE                                                         
P00721        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00721        MOVE SQLCODE               TO ABEND-SQLCODE               
P00721        MOVE SQLSTATE              TO ABEND-SQLSTATE              
P00721        MOVE '8910'                TO ACTIVE-PARAGRAPH            
P00721        MOVE 'OPEN'                TO ABEND-FUNCTION              
P00721        MOVE 'CSR04344_R6'         TO TABLE-1                     
P00721        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00721     END-IF.                                                      
P00721*                                                                 34372600
P00721 8910-EXIT.                                                       
P00721     EXIT.                                                        
P00721*                                                                 34372900
      ******************************************************************34373000
      * 9700-ABEND-PROCESSING.                                         *34380000
      ******************************************************************34390000
      *                                                                 34400000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 34420000
           EVALUATE TRUE                                                
               WHEN WS-RULES                                            
                    MOVE S-RETURN-CODE-1 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-OPTIONS                                          
                    MOVE S-RETURN-CODE-2 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-OTHR-PYMTS                                       
                    MOVE S-RETURN-CODE-3 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-USAGE                                            
                    MOVE S-RETURN-CODE-4 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
               WHEN WS-PLS-PAY-AMT                                      
                    MOVE S-RETURN-CODE-5 TO WS-RETURN-CODE-1            
                                            WS-RETURN-CODE-2            
                                            WS-RETURN-CODE-3            
                                            WS-RETURN-CODE-4            
                                            WS-RETURN-CODE-5            
           END-EVALUATE.                                                
      *                                                                 34750000
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                      TO SEND-DONE-SW.               
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC                 TO ABEND-SQLERRMC.             
      *                                                                 34800000
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 34840000
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'            TO ABEND-FUNCTION              
           END-IF.                                                      
      *                                                                 34900000
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                 34920000
           MOVE WS-RETURN-CODE-1         TO S-RETURN-CODE-1.            
           MOVE WS-RETURN-CODE-2         TO S-RETURN-CODE-2.            
           MOVE WS-RETURN-CODE-3         TO S-RETURN-CODE-3.            
           MOVE WS-RETURN-CODE-4         TO S-RETURN-CODE-4.            
           MOVE WS-RETURN-CODE-5         TO S-RETURN-CODE-5.            
      *                                                                 34980000
           PERFORM 8010-INSERT-GTT-R1    THRU 8010-EXIT.                
           PERFORM 8020-INSERT-GTT-R2    THRU 8020-EXIT.                
           PERFORM 8030-INSERT-GTT-R3    THRU 8030-EXIT.                
           PERFORM 8040-INSERT-GTT-R4    THRU 8040-EXIT.                
           PERFORM 8050-INSERT-GTT-R5    THRU 8050-EXIT.                
      *                                                                 35040000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35070000
      ******************************************************************35080000
      * 9700-ABEND-PROCESSING.                                         *35090000
      ******************************************************************35100000
      *                                                                 35110000
       9700-PROCESS-ABEND.                                              
      *                                                                 35130000
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
      *                                                                 35160000
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 35190000
      ******************************************************************35200000
      * 9900-SQL-ERROR-ROUTINE.                                        *35210000
      ******************************************************************35220000
      *                                                                 35230000
           EXEC SQL                                                     35240000
              INCLUDE CPDSP300                                          35250000
           END-EXEC.                                                    35260000
      *                                                                 35270000
      ******************************************************************35280000
      * 9999-END-PROGRAM.                                      *        35290000
      ******************************************************************35300000
      *                                                                 35310000
       9999-END-PROGRAM.                                                
      *                                                                 35330000
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '9999-END-PROGRAM'    TO ABEND-FUNCTION              
              MOVE 'PROGRAMMER LOGIC'    TO TABLE-1                     
              MOVE 'FAILED TO SEND'      TO TABLE-ELEMENT-1             
              MOVE 'RESULT SET'          TO HOSTVAR-ELEMENT-1           
              MOVE -1                    TO WS-ACTIVE-RETURN-CODE       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
P00721        IF PARM-ELIGIBLE = SPACES                                 
                 PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT              
                 PERFORM 8900-SEND-DONE     THRU 8900-EXIT              
P00721        ELSE                                                      
P00721           PERFORM 8810-CHECK-RESULTS THRU 8810-EXIT              
P00721           PERFORM 8910-SEND-DONE     THRU 8910-EXIT
              END-IF
           END-IF.             
      *                                                                 35450000
           
MSQ016        GOBACK.                                                    
      *                                                                 35470000
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *35500000
      **********************End Of Program *****************************35510000
      *                                                                *35520000
