       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04341.                                     
COB303 DATE-WRITTEN. JULY 14, 2010.                                     
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  THIS PROGRAM UPDATES CODE_RENTAL_PROP ON CSS_PREMISE FROM              
      *  THE PROPERTY MANAGER WEB PROCESS.                                      
      *                                                                         
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/14/10    FMB      CREATED.                                 *        
A04527*  06/07/13    MC95456  REMOVED UNUSED COPYBOOK CWS00056         *        
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04341'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04341 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
       COPY CCA00001.                                                           
            EXEC SQL                                                            
               INCLUDE CWSX0010                                                 
            END-EXEC.                                                           
       COPY CWS00027.                                                           
       COPY CWS00303.                                                           
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04341'.     
           05  WS-TRAN-APPL-NO          PIC 9(02) VALUE 0.              
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04341_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-REVERT-FL          PIC X(01).                           
       01  LINK-USERID             PIC X(07).                           
       01  LINK-SOURCE-SYSTEM      PIC X(03).                           
                                                                        
       PROCEDURE DIVISION USING LINK-PREMISE-NO                         
                                LINK-REVERT-FL                          
                                LINK-USERID                             
                                LINK-SOURCE-SYSTEM.                     
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE AS  RETURN_CODE                    
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE AS  RETURN_CODE                            
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT DATE                                              
MFA-TR*          INTO :WS-CURRENT-DATE                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CURRENT TIMESTAMP                                         
MFA-TR*          INTO :WS-CURRENT-TS                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-REVERT-FL = 'S' OR 'D' OR 'C'                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'C' TO LINK-REVERT-FL
           END-IF.                              
            MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                 
            MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                    
            PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 5000-UPDATE THRU 5000-EXIT.                          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE TO S-RETURN-CODE.                        
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           PERFORM 8000-UPDATE-PREMISE THRU 8000-EXIT.                  
           PERFORM 8100-INSERT-TRANSHIST THRU 8100-EXIT.                
                                                                        
           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
           ADD +1                     TO   CTR-ROWS.                    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
       7000-SELECT-PREMISE.                                             
                                                                        
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT CODE_RENTAL_PROP                                  
                 INTO :PR-CODE-RENTAL-PROP                              
                 FROM CSS_PREMISE                                       
                WHERE PREMISE_NO  = :PR-PREMISE-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE SPACES              TO ABEND-TABLES             
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                   MOVE 'CSR04341'          TO ABEND-PROGRAM            
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-UPDATE-PREMISE.                                             
                                                                        
           MOVE '8000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET CODE_RENTAL_PROP   = :LINK-REVERT-FL              
                WHERE PREMISE_NO         = :PR-PREMISE-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE SPACES              TO ABEND-TABLES             
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                   MOVE 'CSR04341'          TO ABEND-PROGRAM            
                   MOVE 'UPDATE'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-INSERT-TRANSHIST.                                           
                                                                        
           MOVE WS-CURRENT-DATE TO MH-DATE-TRANS.                       
           MOVE WS-CURRENT-TS TO MH-TRANS-HIST-SEQ-NO.                  
                                                                        
           EXEC SQL                                                     
              SELECT  RESP_AREA_ID                                      
              INTO    :MH-RESP-AREA-ID                                  
              FROM    CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
              WHERE   USER_ID = :LINK-USERID                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21410000
MFA-TR*       SELECT  RESP_AREA_ID                                      21420000
MFA-TR*       INTO    :MH-RESP-AREA-ID                                  21430000
MFA-TR*       FROM    CSS_USER_PROFILE                                  21440000
MFA-TR*       WHERE   USER_ID = :LINK-USERID                            21450000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    21460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO MH-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
                   MOVE 'SELECT'                TO ABEND-FUNCTION       
                   MOVE SPACES                  TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                   MOVE 'CSS_USER_PROFILE'      TO TABLE-1              
                   MOVE 'USER_ID'               TO TABLE-ELEMENT-1      
                   MOVE LINK-USERID             TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE 1                               TO WS-TRAN-APPL-NO      
                                                   MI-TRAN-APPL-NO.     
                                                                        
           MOVE 'F'                             TO MH-CODE-TRAN-TYPE.   
           MOVE ZEROES                          TO MH-ACCOUNT-NO.       
           MOVE ZEROS                           TO MH-CUSTOMER-NO.      
           MOVE PR-PREMISE-NO                   TO MH-PREMISE-NO.       
           MOVE LINK-USERID                     TO MH-USER-ID.          
           MOVE 'PANEL062'                      TO MH-APPL-PROGRAM-ID.  
                                                                        
           IF PR-CODE-RENTAL-PROP NOT = LINK-REVERT-FL                  
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE 'REVERSION TYPE'        TO MI-COLUMN-DESC           
               MOVE SPACES                  TO MI-TABLE-ID              
               EVALUATE PR-CODE-RENTAL-PROP                             
                   WHEN 'D'                                             
                       MOVE 'REVERSION - YES' TO                        
                            MI-PRV-COLUMN-VALUE-TEXT                    
                       MOVE 15 TO MI-PRV-COLUMN-VALUE-LEN               
                   WHEN 'S'                                             
                       MOVE 'REVERSION - SEASONAL' TO                   
                            MI-PRV-COLUMN-VALUE-TEXT                    
                       MOVE 20 TO MI-PRV-COLUMN-VALUE-LEN               
                   WHEN OTHER                                           
                       MOVE 'REVERSION - NO' TO                         
                            MI-PRV-COLUMN-VALUE-TEXT                    
                       MOVE 14 TO MI-PRV-COLUMN-VALUE-LEN               
               END-EVALUATE                                             
               EVALUATE LINK-REVERT-FL                                  
                   WHEN 'D'                                             
                       MOVE 'REVERSION - YES' TO                        
                            MI-CHG-COLUMN-VALUE-TEXT                    
                       MOVE 15 TO MI-CHG-COLUMN-VALUE-LEN               
                   WHEN 'S'                                             
                       MOVE 'REVERSION - SEASONAL' TO                   
                            MI-CHG-COLUMN-VALUE-TEXT                    
                       MOVE 20 TO MI-CHG-COLUMN-VALUE-LEN               
                   WHEN OTHER                                           
                       MOVE 'REVERSION - NO' TO                         
                            MI-CHG-COLUMN-VALUE-TEXT                    
                       MOVE 14 TO MI-CHG-COLUMN-VALUE-LEN               
               END-EVALUATE                                             
               MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO     
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
              EXEC SQL                                                          
                 INCLUDE CPD00321                                               
              END-EXEC.                                                         
