       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04339.                                          
COB303 DATE-WRITTEN.      JULY 2, 2010.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS IS THE DRIVER PROGRAM FOR LIGHT REPAIR/REQUEST ORDERS    *        
      *  FROM THE WEB AND IVR.                                         *        
      *  PROGRAM WILL ALSO BE USED TO INITIATE A TYPE ORDERS FROM      *        
      *  CISM.                                                         *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/02/10    FMB      NEW PROGRAM.                             *        
P00718*  02/20/14    VV       ADDITIONAL PARM FOR CSR03374 & CSR01116  *        
P00718*                       FOR BUSINESS UNIT                        *        
A05317*  03/15/16    FMB      INCREASE CSR02210 SUBSCRIPT TO AVOID     *        
A05317*                       S0C7 ABEND.                              *        
A05317*  07/12/16    FMB      GET LOCAL OFFICE FROM ACCOUNT IF NOT     *        
A05317*                       PROVIDED IN LINKAGE.                     *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04339'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04339 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
A05317     EXEC SQL                                                             
A05317        INCLUDE TBACCT                                                    
A05317     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04339_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-SERV-ORDER-NO        PIC X(13) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SERV-ORDER-NO        PIC X(13) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
A05317     05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
A05317     05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
A05317                                  PIC 9(13).                      
           05  WS-SERV-ORDER-NO-CHAR    PIC X(13).                      
           05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO-CHAR 
                                        PIC 9(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-TS-PLUS-1-DAY         PIC X(26) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04339'.     
           05  WS-POINT-ID              PIC X(10) VALUE SPACES.         
           05  WS-READ-ROUTE            PIC 9(04) VALUE ZEROES.         
           05  WS-READ-ROUTE-CHAR       REDEFINES WS-READ-ROUTE         
                                        PIC X(04).                      
                                                                        
       01  WS-TABLES.                                                   
           05  T1-CSR02210            OCCURS 80                         
                                      INDEXED BY T1-INDEX.              
               10 T1-TABLE-ID           PIC X(02) VALUE SPACES.         
               10 T1-UT-CODE-UTIL-TYPE  PIC X(01) VALUE SPACES.         
               10 T1-UT-IC-NO           PIC S9(4) COMP VALUE 0.         
               10 T1-UT-READ-ROUTE      PIC S9(4) COMP VALUE 0.         
               10 T1-UT-RATE-PLAN-NO    PIC X(03).                      
               10 T1-UT-RATE-DESC       PIC X(25).                      
               10 T1-UT-CODE-REV-CLASS  PIC X(03).                      
               10 T1-UT-READ-CYCLE      PIC X(02).                      
               10 T1-UT-CODE-SIC-NO     PIC X(04).                      
               10 T1-MN-METER-NO        PIC X(09).                      
               10 T1-MN-MTR-REF-NO      PIC S9(4) COMP VALUE 0.         
               10 T1-MN-CODE-TIME-PER   PIC S9(4) COMP VALUE 0.         
               10 T1-MN-LAST-READ-VAL   PIC S9(12)V9(3) COMP-3 VALUE 0. 
               10 T1-MN-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-USAGE-T    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-USAGE-I    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-USAGE-S    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-METER-S    PIC X(01) VALUE SPACES.         
               10 T1-MN-METER-SUPPLY    PIC X(15) VALUE SPACES.         
               10 T1-MN-CODE-METER-LOC  PIC X(02) VALUE SPACES.         
               10 T1-MN-METER-LOC-DESC  PIC X(14) VALUE SPACES.         
               10 T1-MN-METER-IND       PIC X(01) VALUE SPACES.         
               10 T1-MN-CONSTANT        PIC S9(6)V COMP-3 VALUE 0.      
               10 T1-MN-NO-DIALS        PIC S9(4) COMP VALUE 0.         
               10 T1-MN-DIST-NODE-PO    PIC X(20) VALUE SPACES.         
               10 T1-MN-POINT-ID        PIC X(10) VALUE SPACES.         
               10 T1-MN-SEAL-CODE-ID    PIC X(01) VALUE SPACES.         
               10 T1-MN-HEX-LOCATION    PIC X(02) VALUE SPACES.         
               10 T1-MN-INSULATED-IND   PIC X(01) VALUE SPACES.         
               10 T1-MN-LOCK-TYPE-ID    PIC X(01) VALUE SPACES.         
               10 T1-MN-DELIVERY-LEV    PIC X(01) VALUE SPACES.         
               10 T1-MN-UTILITY-SOURCE  PIC X(01) VALUE SPACES.         
               10 T1-MN-IDR-RECIPIENT   PIC X(01) VALUE SPACES.         
               10 T1-MN-PROGRAM-ID      PIC X(02) VALUE SPACES.         
               10 T1-MN-MTR-READ-SOURCE PIC X(01) VALUE SPACES.         
               10 T1-RG-LAST-READD      PIC X(10) VALUE SPACES.         
               10 T1-RG-REG-ID-NO       PIC S9(4) COMP VALUE 0.         
               10 T1-CP-NO-UNITS        PIC S9(9) COMP VALUE 0.         
               10 T1-CP-CODE-PLAN       PIC X(01) VALUE SPACES.         
               10 T1-CP-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T1-CP-CD-SVC-TYPE     PIC X(01) VALUE SPACES.         
               10 T1-CP-MTHLY-AMT       PIC S9(9)V COMP-3 VALUE 0.      
               10 T1-CP-RT-ITEM-CD      PIC S9(4) COMP VALUE 0.         
               10 T1-CP-LIGHT-NO        PIC S9(4) COMP VALUE 0.         
               10 T1-CP-POLE-NO         PIC X(07) VALUE SPACES.         
               10 T1-CP-DIST-NO         PIC X(03) VALUE SPACES.         
               10 T1-CP-USAGE-FIXED     PIC S9(9)V COMP-3 VALUE 0.      
               10 T1-CP-ITEM-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T1-CP-EQUIP-ID        PIC X(02) VALUE SPACES.         
               10 T1-PREM-DIR-IND       PIC X(01) VALUE SPACES.         
               10 T1-SUBDIV-LIGHT       PIC S9(3)V COMP-3 VALUE 0.      
               10 T1-ACCT-TYPE-CODE     PIC X(01) VALUE SPACES.         
               10 T1-CD-RENTAL-PROP     PIC X(01) VALUE SPACES.         
               10 T1-LL-CUSTOMER-NO     PIC S9(10)V COMP-3 VALUE 0.     
               10 T1-REV-DISTRICT-CD    PIC X(03) VALUE SPACES.         
               10 T1-DISC-BAL           PIC S9(11)V99 COMP-3 VALUE 0.   
               10 T1-OUT-ACCOUNT-NO     PIC S9(13)V COMP-3 VALUE 0.     
               10 T1-ACCT-STATUS        PIC X(01) VALUE SPACES.         
               10 T1-ROW-NO             PIC S9(4) COMP VALUE 0.         
               10 T1-DEPOSIT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T1-SEC-TOT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T1-CUR-MTH-ARR-CD     PIC X(01) VALUE SPACES.         
               10 T1-CREDIT-GROUP       PIC X(01) VALUE SPACES.         
               10 T1-CURRENT-ACCOUNT    PIC X(01) VALUE SPACES.         
               10 T1-DATE-BANKRUPT      PIC X(10) VALUE SPACES.         
               10 T1-FILED-CASE-NO      PIC X(10) VALUE SPACES.         
               10 T1-DL-NO              PIC X(19) VALUE SPACES.         
               10 T1-DL-STATE           PIC X(02) VALUE SPACES.         
               10 T1-SSN                PIC X(09) VALUE SPACES.         
               10 T1-PRIOR-ACCT-STAT    PIC X(01) VALUE SPACES.         
               10 T1-READ-CYCLE         PIC X(02) VALUE SPACES.         
               10 T1-SERV-STRT-DT       PIC X(10) VALUE SPACES.         
               10 T1-DEP-INTST-RT       PIC S9(2)V99 COMP-3 VALUE 0.    
               10 T1-CP-DT-PLAN-ST      PIC X(10) VALUE SPACES.         
               10 T1-ACTIVE-CONTRACT    PIC X(01) VALUE SPACES.         
               10 T1-SECURED-RATE-FL    PIC X(01) VALUE SPACES.         
               10 T1-MN-CODE-MTR-RD     PIC X(02) VALUE SPACES.         
               10 T1-MN-MTR-PRESS       PIC X(03) VALUE SPACES.         
               10 T1-WORK-TYPE-CD       PIC X(03) VALUE SPACES.         
               10 T1-RLSE-REQUIRED      PIC X(01) VALUE SPACES.         
               10 T1-RLSE-NO            PIC X(10) VALUE SPACES.         
               10 T1-RLSE-DATE          PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR02210-CALL-DATA.                                          
           03 ACCOUNT-NO-2210           PIC X(13) VALUE SPACES.         
           03 PREMISE-NO-2210           PIC X(10) VALUE SPACES.         
           03 COMPANY-NO-2210           PIC X(02) VALUE SPACES.         
           03 MKTG-ORDER-2210           PIC X(01) VALUE SPACES.         
           03 RETURN-UTILS-2210         PIC X(01) VALUE SPACES.         
           03 RETURN-DISC-BAL-2210      PIC X(01) VALUE SPACES.         
           03 ORDER-REASON-2210         PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR02210-RETURN-DATA.                                        
           05  RETURN-CODE-2210      PIC S9(9)     COMP VALUE 0.        
           05  ACTIVE-PARA-2210      PIC X(30)     VALUE SPACES.        
           05  TABLE-NAME-2210       PIC X(30)     VALUE SPACES.        
           05  TABLE-ID-2210         PIC X(2)      VALUE SPACES.        
           05  UT-CODE-UTIL-TY-2210  PIC X(1)      VALUE SPACES.        
           05  UT-IC-NO-2210         PIC S9(4)     COMP VALUE 0.        
           05  UT-READ-ROUTE-2210    PIC S9(4)     COMP VALUE 0.        
           05  UT-RATE-PLAN-NO-2210  PIC X(3)      VALUE SPACES.        
           05  UT-RATE-DESC-2210     PIC X(25)     VALUE SPACES.        
           05  UT-CODE-REV-CLA-2210  PIC X(3)      VALUE SPACES.        
           05  UT-READ-CYCLE-2210    PIC X(2)      VALUE SPACES.        
           05  UT-CODE-SIC-NO-2210   PIC X(4)      VALUE SPACES.        
           05  MN-METER-NO-2210      PIC X(9)      VALUE SPACES.        
           05  MN-MTR-REF-NO-2210    PIC S9(4)     COMP VALUE 0.        
           05  MN-CODE-TIME-PE-2210  PIC S9(4)     COMP VALUE 0.        
           05  MN-LAST-READ-VA-2210  PIC S9(12)V999 COMP-3 VALUE 0.     
           05  MN-CD-STUS-RS-2210    PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-T-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-I-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-METER-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-METER-SUPPLY-2210  PIC X(15)     VALUE SPACES.        
           05  MN-CODE-METER-L-2210  PIC X(2)      VALUE SPACES.        
           05  MN-METER-LOC-DE-2210  PIC X(14)     VALUE SPACES.        
           05  MN-METER-IND-2210     PIC X(1)      VALUE SPACES.        
           05  MN-CONSTANT-2210      PIC S9(6)V    COMP-3 VALUE 0.      
           05  MN-NO-DIALS-2210      PIC S9(4) COMP VALUE 0.            
           05  MN-DIST-NODE-PO-2210  PIC X(20)     VALUE SPACES.        
           05  MN-POINT-ID-2210      PIC X(10)     VALUE SPACES.        
           05  MN-SEAL-CODE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-HEX-LOCATION-2210  PIC X(02)     VALUE SPACES.        
           05  MN-INSULATED-IN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-LOCK-TYPE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-DELIVERY-LEV-2210  PIC X(01)     VALUE SPACES.        
           05  MN-UTILITY-SOUR-2210  PIC X(01)     VALUE SPACES.        
           05  MN-IDR-RECIPIEN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-PROGRAM-ID-2210    PIC X(02)     VALUE SPACES.        
           05  MN-MTR-READ-SO-2210   PIC X(01)     VALUE SPACES.        
           05  RG-CODE-REG-ST-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-STATUS-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-TIME-P-2210   PIC S9(4)     COMP VALUE 0.        
           05  RG-CODE-USAGE-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-SRC-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  RG-LAST-READD-2210    PIC X(10)     VALUE SPACES.        
           05  RG-LST-READVL-2210    PIC S9(12)V9(3) COMP-3 VALUE 0.    
           05  RG-REG-ID-NO-2210     PIC S9(4)     COMP VALUE 0.        
           05  CP-NO-UNITS-2210      PIC S9(9)     COMP VALUE 0.        
           05  CP-CODE-PLAN-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-STATRS-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-SVC-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  CP-MTLY-AMT-FX-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-RT-ITEM-CD-2210    PIC S9(4)     COMP VALUE 0.        
           05  CP-LIGHT-NO-2210      PIC S9(4)     COMP VALUE 0.        
           05  CP-POLE-NO-2210       PIC X(7)      VALUE SPACES.        
           05  CP-DIST-NO-2210       PIC X(3)      VALUE SPACES.        
           05  CP-USAGE-FIXED-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-ITEM-SEQ-NO-2210   PIC S9(4)     COMP VALUE 0.        
           05  CP-EQUIP-ID-2210      PIC X(2)      VALUE SPACES.        
           05  PREM-DIR-IND-2210     PIC X(1)      VALUE SPACES.        
           05  SUBDIV-LIGHT-2210 PIC S9(3)V        COMP-3 VALUE 0.      
           05  ACCT-TYPE-2210        PIC X(1)      VALUE SPACES.        
           05  CD-RNTL-PROP-2210     PIC X(1)      VALUE SPACES.        
           05  LL-CUSTOMER-NO-2210   PIC S9(10)    COMP-3 VALUE 0.      
           05  REV-DIST-CD-2210      PIC X(3)      VALUE SPACES.        
           05  DISC-BAL-2210         PIC S9(11)V99 COMP-3 VALUE 0.      
           05  OUT-ACCOUNT-NO-2210   PIC S9(13)V   COMP-3 VALUE 0.      
           05  ACCT-STATUS-2210      PIC X(1)      VALUE SPACES.        
           05  ROW-NO-2210           PIC S9(4)     COMP VALUE 0.        
           05  DEPOSIT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  SEC-TOT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  CUR-MTH-ARR-CD-2210   PIC X(01)     VALUE SPACES.        
           05  CREDIT-GROUP-2210     PIC X(01)     VALUE SPACES.        
           05  CURRENT-ACCOUNT-2210  PIC X(01)     VALUE 'Y'.           
           05  DATE-BNKRPT-FL-2210   PIC X(10)     VALUE SPACES.        
           05  FILED-CASE-NO-2210    PIC X(10)     VALUE SPACES.        
           05  DL-NO-2210            PIC X(19)     VALUE SPACES.        
           05  DL-STATE-2210         PIC X(02)     VALUE SPACES.        
           05  SSN-2210              PIC X(09)     VALUE SPACES.        
           05  PRIOR-ACCT-STAT-2210  PIC X(01)     VALUE SPACES.        
           05  READ-CYCLE-2210       PIC X(02)     VALUE SPACES.        
           05  SERV-STRT-DT-2210     PIC X(10)     VALUE SPACES.        
           05  DEP-INTST-RT-2210     PIC S9(2)V99  COMP-3 VALUE 0.      
           05  CP-DT-PLN-ST-2210     PIC X(10)     VALUE SPACES.        
           05  ACTIVE-CONTRACT-2210  PIC X(01)     VALUE SPACES.        
           05  SECURED-RATE-FL-2210  PIC X(01)     VALUE SPACES.        
           05  MN-CODE-MTR-RD-2210   PIC X(02)     VALUE SPACES.        
           05  MN-MTR-PRESS-2210     PIC X(03)     VALUE SPACES.        
           05  ERROR-MSG-NO-02-2210  PIC X(05)     VALUE SPACES.        
           05  ERROR-MSG-NO-A4-2210  PIC X(05)     VALUE SPACES.        
                                                                        
       01  CSR01116-CALL-DATA.                                          
           03 LOCAL-OFFICE-1116         PIC X(03) VALUE SPACES.         
           03 CODE-UTIL-TYPE-1116       PIC X(50) VALUE SPACES.         
           03 WORK-TYPE-CD-1116         PIC X(150) VALUE SPACES.        
           03 CRAWL-IND-1116            PIC X(01) VALUE SPACES.         
           03 METER-IND-1116            PIC X(50) VALUE SPACES.         
           03 ZIP-CODE-1116             PIC X(05) VALUE SPACES.         
           03 READ-ROUTE-1116           PIC X(04) VALUE SPACES.         
           03 POINT-ID-1116             PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR01116-RETURN-DATA.                                        
           05  RETURN-CODE-1116         PIC S9(9) COMP VALUE 0.         
           05  WORK-AREA-1116           PIC X(12) VALUE SPACES.         
P00718     05  BUSINESS-UNIT-1116       PIC X(03) VALUE SPACES.         
                                                                        
       01  CSR00702-CALL-DATA.                                          
           03 WORK-AREA-0702            PIC X(12) VALUE SPACES.         
           03 IN-ASSIGNED-TS-0702       PIC X(26) VALUE SPACES.         
           03 SERV-ORDER-NO-0702        PIC X(13) VALUE SPACES.         
           03 TOTAL-RES-0702            PIC X(05) VALUE SPACES.         
                                                                        
       01  CSR00702-RETURN-DATA.                                        
           05  RETURN-CODE-0702         PIC S9(9) COMP VALUE 0.         
           05  OUT-ASSIGNED-TS-0702     PIC X(26) VALUE SPACES.         
           05  TOTAL-SO-HRS-0702        PIC S9(5)V99 COMP-3 VALUE 0.0.  
           05  MAX-RE-PER-DAY-0702      PIC S9(10)V COMP-3 VALUE 0.     
           05  TOTAL-SO-0702            PIC S9(5)V COMP-3 VALUE 0.      
           05  MAX-DAILY-WK-REQ-0702    PIC S9(8)V99 COMP-3 VALUE 0.    
                                                                        
       01  CSR03374-CALL-DATA.                                          
           03 PREMISE-NO-3374           PIC X(10) VALUE SPACES.         
           03 ACCOUNT-NO-3374           PIC X(13) VALUE SPACES.         
           03 ACCOUNT-NO-PRIOR-3374     PIC X(13) VALUE SPACES.         
           03 IN-SERV-ORDER-NO-3374     PIC X(13) VALUE SPACES.         
           03 ORDER-TYPE-CD-3374        PIC X(05) VALUE SPACES.         
           03 LOCAL-OFFICE-3374         PIC X(03) VALUE SPACES.         
           03 PHONE-NO-EXT-3374         PIC X(06) VALUE SPACES.         
           03 PHONE-NO-3374             PIC X(10) VALUE SPACES.         
           03 ORDER-PLACED-BY-3374      PIC X(25) VALUE SPACES.         
           03 ORDER-RECVED-BY-3374      PIC X(07) VALUE SPACES.         
           03 WANTED-BY-DATE-3374       PIC X(10) VALUE SPACES.         
           03 ASSIGNED-TS-3374          PIC X(26) VALUE SPACES.         
           03 ORDER-REASON-3374         PIC X(01) VALUE SPACES.         
           03 BACK-DATED-IND-3374       PIC X(01) VALUE SPACES.         
           03 RESP-AREA-ID-3374         PIC X(03) VALUE SPACES.         
           03 CALL-BEFORE-MIN-3374      PIC X(03) VALUE SPACES.         
           03 NOTIFY-CUST-IND-3374      PIC X(01) VALUE SPACES.         
           03 NOTIFY-CSR-IND-3374       PIC X(01) VALUE SPACES.         
           03 BREAKERS-OFF-3374         PIC X(01) VALUE SPACES.         
           03 DEPOSIT-AMT-3374          PIC X(11) VALUE SPACES.         
           03 INIT-BY-CNTRCT-3374       PIC X(01) VALUE SPACES.         
           03 WORK-AREA-ID-3374         PIC X(12) VALUE SPACES.         
           03 ORDER-PRIORITY-3374       PIC X(04) VALUE SPACES.         
           03 ORDER-STATE-CD-3374       PIC X(01) VALUE SPACES.         
           03 WORK-TYPE-CD-3374         PIC X(03) VALUE SPACES.         
           03 CODE-UTIL-TYPE-3374       PIC X(01) VALUE SPACES.         
           03 STD-CHG-AMT-3374          PIC X(09) VALUE SPACES.         
           03 VERIFY-RATE-3374          PIC X(01) VALUE SPACES.         
           03 PANEL-NO-3374             PIC X(04) VALUE SPACES.         
           03 USER-ID-3374              PIC X(07) VALUE SPACES.         
           03 SO-EST-LABOR-HR-3374      PIC X(03) VALUE SPACES.         
           03 ACCT-STATUS-3374          PIC X(01) VALUE SPACES.         
           03 REORDER-FL-3374           PIC X(01) VALUE SPACES.         
           03 COMPANY-NO-3374           PIC X(02) VALUE SPACES.         
           03 OLD-ACCOUNT-STAT-3374     PIC X(01) VALUE SPACES.         
           03 CODE-KEY-FIELD-3374       PIC X(01) VALUE SPACES.         
           03 DT-FORECAST-DNP-3374      PIC X(10) VALUE SPACES.         
           03 AMT-DNP-AT-BILL-3374      PIC X(11) VALUE SPACES.         
           03 PRICE-PER-SERV-3374       PIC X(09) VALUE SPACES.         
           03 ACCOUNT-TYPE-CODE-3374    PIC X(01) VALUE SPACES.         
           03 WORK-PERIOD-CD-3374       PIC X(01) VALUE SPACES.         
           03 WAIVER-TYPE-CD-3374       PIC X(01) VALUE SPACES.         
P00718     03 BUSINESS-UNIT-3374        PIC X(03) VALUE SPACES.         
                                                                        
       01  CSR03374-RETURN-DATA.                                        
           05  RETURN-CODE-3374         PIC S9(9) COMP VALUE 0.         
           05  OUT-SERV-ORDER-NO-3374   PIC S9(13) COMP VALUE 0.        
                                                                        
       01  CSR00717-CALL-DATA.                                          
           03 SERV-ORDER-NO-0717        PIC X(13) VALUE SPACES.         
           03 REMARK-TYPE-CD-0717       PIC X(01) VALUE SPACES.         
           03 REMARK-TX-0717.                                           
              49 REMARK-TX-0717-LEN     PIC S9(4) USAGE COMP VALUE 0.   
              49 REMARK-TX-0717-TEXT    PIC X(210) VALUE SPACES.        
           03 USER-ID-0717              PIC X(07) VALUE SPACES.         
                                                                        
       01  CSR00717-RETURN-DATA.                                        
           05  RETURN-CODE-0717         PIC S9(9) COMP VALUE 0.         
                                                                        
       01  CSR02120-CALL-DATA.                                          
           03 PREMISE-NO-2120           PIC X(10) VALUE SPACES.         
           03 ACCOUNT-NO-2120           PIC X(13) VALUE SPACES.         
           03 ORDER-TYPE-CD-2120        PIC X(05) VALUE SPACES.         
           03 ORDER-STATE-CD-2120       PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR02120-RETURN-DATA.                                        
           05  RETURN-CODE-2120         PIC S9(9) COMP VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC2210 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1116 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0702 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC3374 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0717 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2120 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2210 CURSOR
MSQ001          FOR CALL CSR02210                                             
                  ( :ACCOUNT-NO-2210
                  , :PREMISE-NO-2210
                  , :COMPANY-NO-2210
                  , :MKTG-ORDER-2210
                  , :RETURN-UTILS-2210
                  , :RETURN-DISC-BAL-2210
                  , :ORDER-REASON-2210
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1116 CURSOR
MSQ001          FOR CALL CSR01116                                             
                  ( :LOCAL-OFFICE-1116
                  , :CODE-UTIL-TYPE-1116
                  , :WORK-TYPE-CD-1116
                  , :CRAWL-IND-1116
                  , :METER-IND-1116
                  , :ZIP-CODE-1116
                  , :READ-ROUTE-1116
                  , :POINT-ID-1116
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0702 CURSOR
MSQ001          FOR CALL CSR00702                                             
                  ( :WORK-AREA-0702
                  , :IN-ASSIGNED-TS-0702
                  , :SERV-ORDER-NO-0702
                  , :TOTAL-RES-0702
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_3374 CURSOR
MSQ001          FOR CALL CSR03374                                             
                  ( :PREMISE-NO-3374
                  , :ACCOUNT-NO-3374
                  , :ACCOUNT-NO-PRIOR-3374
                  , :IN-SERV-ORDER-NO-3374
                  , :ORDER-TYPE-CD-3374
                  , :LOCAL-OFFICE-3374
                  , :PHONE-NO-EXT-3374
                  , :PHONE-NO-3374
                  , :ORDER-PLACED-BY-3374
                  , :ORDER-RECVED-BY-3374
                  , :WANTED-BY-DATE-3374
                  , :ASSIGNED-TS-3374
                  , :ORDER-REASON-3374
                  , :BACK-DATED-IND-3374
                  , :RESP-AREA-ID-3374
                  , :CALL-BEFORE-MIN-3374
                  , :NOTIFY-CUST-IND-3374
                  , :NOTIFY-CSR-IND-3374
                  , :BREAKERS-OFF-3374
                  , :DEPOSIT-AMT-3374
                  , :INIT-BY-CNTRCT-3374
                  , :WORK-AREA-ID-3374
                  , :ORDER-PRIORITY-3374
                  , :ORDER-STATE-CD-3374
                  , :WORK-TYPE-CD-3374
                  , :CODE-UTIL-TYPE-3374
                  , :STD-CHG-AMT-3374
                  , :VERIFY-RATE-3374
                  , :PANEL-NO-3374
                  , :USER-ID-3374
                  , :SO-EST-LABOR-HR-3374
                  , :ACCT-STATUS-3374
                  , :REORDER-FL-3374
                  , :COMPANY-NO-3374
                  , :OLD-ACCOUNT-STAT-3374
                  , :CODE-KEY-FIELD-3374
                  , :DT-FORECAST-DNP-3374
                  , :AMT-DNP-AT-BILL-3374
                  , :PRICE-PER-SERV-3374
                  , :ACCOUNT-TYPE-CODE-3374
                  , :WORK-PERIOD-CD-3374
                  , :WAIVER-TYPE-CD-3374
                  , :BUSINESS-UNIT-3374
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0717 CURSOR
MSQ001          FOR CALL CSR00717                                             
                  ( :SERV-ORDER-NO-0717
                  , :REMARK-TYPE-CD-0717
                  , :REMARK-TX-0717
                  , :USER-ID-0717
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2120 CURSOR
MSQ001          FOR CALL CSR02120                                             
                  ( :PREMISE-NO-2120
                  , :ACCOUNT-NO-2120
                  , :ORDER-TYPE-CD-2120
                  , :ORDER-STATE-CD-2120
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-COMPANY-NO         PIC X(02).                           
       01  LINK-LOCAL-OFFICE       PIC X(03).                           
       01  LINK-CODE-UTIL-TYPE     PIC X(01).                           
       01  LINK-WORK-TYPE-CD       PIC X(03).                           
       01  LINK-ZIP-CODE           PIC X(05).                           
       01  LINK-ORDER-TYPE-CD      PIC X(05).                           
       01  LINK-PHONE-NO-EXT       PIC X(06).                           
       01  LINK-PHONE-NO           PIC X(10).                           
       01  LINK-ORDER-PLACED-BY    PIC X(25).                           
       01  LINK-CODE-ACCT-STAT     PIC X(01).                           
       01  LINK-ACCOUNT-TYPE-CODE  PIC X(01).                           
       01  LINK-SPECIAL-INST       PIC X(210).                          
       01  LINK-APPL-PGM-ID        PIC X(07).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO                               
                          LINK-PREMISE-NO                               
                          LINK-COMPANY-NO                               
                          LINK-LOCAL-OFFICE                             
                          LINK-CODE-UTIL-TYPE                           
                          LINK-WORK-TYPE-CD                             
                          LINK-ZIP-CODE                                 
                          LINK-ORDER-TYPE-CD                            
                          LINK-PHONE-NO-EXT                             
                          LINK-PHONE-NO                                 
                          LINK-ORDER-PLACED-BY                          
                          LINK-CODE-ACCT-STAT                           
                          LINK-ACCOUNT-TYPE-CODE                        
                          LINK-SPECIAL-INST                             
                          LINK-APPL-PGM-ID.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                   SELECT :S-RETURN-CODE        AS RETURN_CODE,         
                          :S-SERV-ORDER-NO      AS SERV_ORDER_NO        
                     FROM CIS.SYSDUMMY1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*            SELECT :S-RETURN-CODE        AS RETURN_CODE,                 
MFA-TR*                   :S-SERV-ORDER-NO      AS SERV_ORDER_NO                
MFA-TR*              FROM SYSIBM.SYSDUMMY1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TS = CURRENT TIMESTAMP                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, 1, 
           CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS) ), 121), ' ', '-'), ':', 
           '.')
            INTO
              :WS-TS-PLUS-1-DAY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES (TIMESTAMP(:WS-CURRENT-TS) + 1 DAYS)                      
MFA-TR*          INTO :WS-TS-PLUS-1-DAY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EVALUATE LINK-APPL-PGM-ID(1:3)                               
               WHEN 'IVR'                                               
                   MOVE 'IVRNT01' TO LINK-APPL-PGM-ID                   
                   MOVE 'IVR' TO VO-SOURCE-SYSTEM-CD                    
               WHEN 'WEB'                                               
                  MOVE 'ECSPRD1' TO LINK-APPL-PGM-ID                    
                   MOVE 'WEB' TO VO-SOURCE-SYSTEM-CD                    
               WHEN OTHER                                               
                   MOVE 'MOD' TO VO-SOURCE-SYSTEM-CD                    
           END-EVALUATE.                                                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE '0000000000000' TO LINK-ACCOUNT-NO
           END-IF.                 
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE '0000000000' TO LINK-PREMISE-NO
           END-IF.                    
                                                                        
           MOVE LINK-APPL-PGM-ID TO PF-USER-ID.                         
           PERFORM 7000-GET-RESP-AREA THRU 7000-EXIT.                   
           MOVE LINK-ORDER-TYPE-CD TO C2-ORDER-TYPE-CD.                 
           MOVE LINK-COMPANY-NO TO C2-COMPANY-NO.                       
           PERFORM 7100-GET-SAME-DAY THRU 7100-EXIT.                    
                                                                        
A05317     IF (LINK-LOCAL-OFFICE <= SPACES) OR                          
A05317        (LINK-LOCAL-OFFICE = '000')                               
A05317            MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR            
A05317            MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO               
A05317            PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT
           END-IF.           
                                                                        
           PERFORM 3100-CALL-CSR02210 THRU 3100-EXIT.                   
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T1-INDEX > 80 OR 
SCA006         WS-POINT-ID > SPACES OR 
               T1-TABLE-ID (T1-INDEX) <= SPACES                                 
                  IF T1-MN-POINT-ID (T1-INDEX) > SPACES                 
                      MOVE T1-MN-POINT-ID (T1-INDEX) TO WS-POINT-ID     
                      MOVE T1-UT-READ-ROUTE (T1-INDEX) TO WS-READ-ROUTE 
                  END-IF                                                
           END-PERFORM.                                                 
           IF WS-POINT-ID = SPACES                                      
               MOVE T1-UT-READ-ROUTE (1) TO WS-READ-ROUTE
           END-IF.              
                                                                        
           PERFORM 3200-CALL-CSR01116 THRU 3200-EXIT.                   
           PERFORM 3300-CALL-CSR00702 THRU 3300-EXIT.                   
           PERFORM 3400-CALL-CSR03374 THRU 3400-EXIT.                   
           MOVE OUT-SERV-ORDER-NO-3374 TO RS-SERV-ORDER-NO              
                                          WS-SERV-ORDER-NO-CHAR.        
           MOVE WS-SERV-ORDER-NO-NUM TO VO-SERV-ORDER-NO.               
           IF LINK-SPECIAL-INST > ' '                                   
               PERFORM 3500-CALL-CSR00717 THRU 3500-EXIT
           END-IF.               
           PERFORM 3600-CALL-CSR02120 THRU 3600-EXIT.                   
           PERFORM 8000-UPDATE-ORDER THRU 8000-EXIT.                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
           MOVE RS-SERV-ORDER-NO           TO S-SERV-ORDER-NO.          
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-CALL-CSR02210.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-2210.                     
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2210.                     
           MOVE LINK-COMPANY-NO TO COMPANY-NO-2210.                     
           MOVE 'N' TO MKTG-ORDER-2210.                                 
           MOVE 'Y' TO RETURN-UTILS-2210.                               
           MOVE 'N' TO RETURN-DISC-BAL-2210.                            
           MOVE ' ' TO ORDER-REASON-2210.                               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02210                                             
      *           (:ACCOUNT-NO-2210,                                    
      *            :PREMISE-NO-2210,                                    
      *            :COMPANY-NO-2210,                                    
      *            :MKTG-ORDER-2210,                                    
      *            :RETURN-UTILS-2210,                                  
      *            :RETURN-DISC-BAL-2210,                               
      *            :ORDER-REASON-2210)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2210 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02210'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2210)                                                
      *       WITH PROCEDURE CSR02210                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2210 CURSOR FOR RESULT SET        
      *       :LOC2210                                                  
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y' TO SW-FETCH.                                        
           SET T1-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2210 INTO                          
                   :RETURN-CODE-2210,                                   
                   :ACTIVE-PARA-2210,                                   
                   :TABLE-NAME-2210,                                    
                   :TABLE-ID-2210,                                      
                   :UT-CODE-UTIL-TY-2210,                               
                   :UT-IC-NO-2210,                                      
                   :UT-READ-ROUTE-2210,                                 
                   :UT-RATE-PLAN-NO-2210,                               
                   :UT-RATE-DESC-2210,                                  
                   :UT-CODE-REV-CLA-2210,                               
                   :UT-READ-CYCLE-2210,                                 
                   :UT-CODE-SIC-NO-2210,                                
                   :MN-METER-NO-2210,                                   
                   :MN-MTR-REF-NO-2210,                                 
                   :MN-CODE-TIME-PE-2210,                               
                   :MN-LAST-READ-VA-2210,                               
                   :MN-CD-STUS-RS-2210,                                 
                   :MN-CODE-USAGE-T-2210,                               
                   :MN-CODE-USAGE-I-2210,                               
                   :MN-CODE-USAGE-S-2210,                               
                   :MN-CODE-METER-S-2210,                               
                   :MN-METER-SUPPLY-2210,                               
                   :MN-CODE-METER-L-2210,                               
                   :MN-METER-LOC-DE-2210,                               
                   :MN-METER-IND-2210,                                  
                   :MN-CONSTANT-2210,                                   
                   :MN-NO-DIALS-2210,                                   
                   :MN-DIST-NODE-PO-2210,                               
                   :MN-POINT-ID-2210,                                   
                   :MN-SEAL-CODE-ID-2210,                               
                   :MN-HEX-LOCATION-2210,                               
                   :MN-INSULATED-IN-2210,                               
                   :MN-LOCK-TYPE-ID-2210,                               
                   :MN-DELIVERY-LEV-2210,                               
                   :MN-UTILITY-SOUR-2210,                               
                   :MN-IDR-RECIPIEN-2210,                               
                   :MN-PROGRAM-ID-2210,                                 
                   :MN-MTR-READ-SO-2210,                                
                   :RG-CODE-REG-ST-2210,                                
                   :RG-CODE-STATUS-2210,                                
                   :RG-CODE-TIME-P-2210,                                
                   :RG-CODE-USAGE-2210,                                 
                   :RG-CD-USG-SRC-2210,                                 
                   :RG-CD-USG-TYP-2210,                                 
                   :RG-LAST-READD-2210,                                 
                   :RG-LST-READVL-2210,                                 
                   :RG-REG-ID-NO-2210,                                  
                   :CP-NO-UNITS-2210,                                   
                   :CP-CODE-PLAN-2210,                                  
                   :CP-CD-STATRS-2210,                                  
                   :CP-CD-SVC-TYP-2210,                                 
                   :CP-MTLY-AMT-FX-2210,                                
                   :CP-RT-ITEM-CD-2210,                                 
                   :CP-LIGHT-NO-2210,                                   
                   :CP-POLE-NO-2210,                                    
                   :CP-DIST-NO-2210,                                    
                   :CP-USAGE-FIXED-2210,                                
                   :CP-ITEM-SEQ-NO-2210,                                
                   :CP-EQUIP-ID-2210,                                   
                   :PREM-DIR-IND-2210,                                  
                   :SUBDIV-LIGHT-2210,                                  
                   :ACCT-TYPE-2210,                                     
                   :CD-RNTL-PROP-2210,                                  
                   :LL-CUSTOMER-NO-2210,                                
                   :REV-DIST-CD-2210,                                   
                   :DISC-BAL-2210,                                      
                   :OUT-ACCOUNT-NO-2210,                                
                   :ACCT-STATUS-2210,                                   
                   :ROW-NO-2210,                                        
                   :DEPOSIT-AMT-2210,                                   
                   :SEC-TOT-AMT-2210,                                   
                   :CUR-MTH-ARR-CD-2210,                                
                   :CREDIT-GROUP-2210,                                  
                   :CURRENT-ACCOUNT-2210,                               
                   :DATE-BNKRPT-FL-2210,                                
                   :FILED-CASE-NO-2210,                                 
                   :DL-NO-2210,                                         
                   :DL-STATE-2210,                                      
                   :SSN-2210,                                           
                   :PRIOR-ACCT-STAT-2210,                               
                   :READ-CYCLE-2210,                                    
                   :SERV-STRT-DT-2210,                                  
                   :DEP-INTST-RT-2210,                                  
                   :CP-DT-PLN-ST-2210,                                  
                   :ACTIVE-CONTRACT-2210,                               
                   :SECURED-RATE-FL-2210,                               
                   :MN-CODE-MTR-RD-2210,                                
                   :MN-MTR-PRESS-2210,                                  
                   :ERROR-MSG-NO-02-2210,                               
                   :ERROR-MSG-NO-A4-2210                                
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-2210 NOT = 0                        
                         MOVE RETURN-CODE-2210  TO                      
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '3100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR02210'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE LINK-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1    
                         MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-2      
                         MOVE LINK-PREMISE-NO   TO HOSTVAR-ELEMENT-2    
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                     END-IF                                             
                     PERFORM 3110-LOAD-CSR02210-TABLE THRU 3110-EXIT    
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02210'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3110-LOAD-CSR02210-TABLE.                                        
                                                                        
           MOVE TABLE-ID-2210 TO T1-TABLE-ID (T1-INDEX).                
           MOVE MN-CODE-METER-S-2210 TO T1-MN-CODE-METER-S (T1-INDEX).  
           MOVE UT-CODE-UTIL-TY-2210 TO T1-UT-CODE-UTIL-TYPE (T1-INDEX).
           MOVE UT-IC-NO-2210 TO T1-UT-IC-NO (T1-INDEX).                
           MOVE UT-READ-ROUTE-2210 TO T1-UT-READ-ROUTE (T1-INDEX).      
           MOVE UT-RATE-PLAN-NO-2210 TO T1-UT-RATE-PLAN-NO (T1-INDEX).  
           MOVE UT-RATE-DESC-2210 TO T1-UT-RATE-DESC (T1-INDEX).        
           MOVE UT-CODE-REV-CLA-2210 TO                                 
                T1-UT-CODE-REV-CLASS (T1-INDEX).                        
           MOVE UT-READ-CYCLE-2210 TO T1-UT-READ-CYCLE (T1-INDEX).      
           MOVE UT-CODE-SIC-NO-2210 TO T1-UT-CODE-SIC-NO (T1-INDEX).    
           MOVE MN-METER-NO-2210 TO T1-MN-METER-NO (T1-INDEX).          
           MOVE MN-MTR-REF-NO-2210 TO T1-MN-MTR-REF-NO (T1-INDEX).      
           MOVE MN-CODE-TIME-PE-2210 TO T1-MN-CODE-TIME-PER (T1-INDEX). 
           MOVE MN-LAST-READ-VA-2210 TO T1-MN-LAST-READ-VAL (T1-INDEX). 
           MOVE MN-CD-STUS-RS-2210 TO T1-MN-CD-STAT-REAS (T1-INDEX).    
           MOVE MN-CODE-USAGE-T-2210 TO T1-MN-CODE-USAGE-T (T1-INDEX).  
           MOVE MN-CODE-USAGE-I-2210 TO T1-MN-CODE-USAGE-I (T1-INDEX).  
           MOVE MN-CODE-USAGE-S-2210 TO T1-MN-CODE-USAGE-S (T1-INDEX).  
           MOVE MN-CODE-METER-S-2210 TO T1-MN-CODE-METER-S (T1-INDEX).  
           MOVE MN-METER-SUPPLY-2210 TO T1-MN-METER-SUPPLY (T1-INDEX).  
           MOVE MN-CODE-METER-L-2210 TO                                 
                T1-MN-CODE-METER-LOC (T1-INDEX).                        
           MOVE MN-METER-LOC-DE-2210 TO                                 
                T1-MN-METER-LOC-DESC (T1-INDEX).                        
           MOVE MN-METER-IND-2210 TO T1-MN-METER-IND (T1-INDEX).        
           MOVE MN-CONSTANT-2210 TO T1-MN-CONSTANT (T1-INDEX).          
           MOVE MN-NO-DIALS-2210 TO T1-MN-NO-DIALS (T1-INDEX).          
           MOVE MN-DIST-NODE-PO-2210 TO                                 
                T1-MN-DIST-NODE-PO (T1-INDEX).                          
           MOVE MN-POINT-ID-2210 TO T1-MN-POINT-ID (T1-INDEX).          
           MOVE MN-SEAL-CODE-ID-2210 TO T1-MN-SEAL-CODE-ID (T1-INDEX).  
           MOVE MN-HEX-LOCATION-2210 TO T1-MN-HEX-LOCATION (T1-INDEX).  
           MOVE MN-INSULATED-IN-2210 TO T1-MN-INSULATED-IND (T1-INDEX). 
           MOVE MN-LOCK-TYPE-ID-2210 TO T1-MN-LOCK-TYPE-ID (T1-INDEX).  
           MOVE MN-DELIVERY-LEV-2210 TO T1-MN-DELIVERY-LEV (T1-INDEX).  
           MOVE MN-UTILITY-SOUR-2210 TO                                 
                T1-MN-UTILITY-SOURCE (T1-INDEX).                        
           MOVE MN-IDR-RECIPIEN-2210 TO T1-MN-IDR-RECIPIENT (T1-INDEX). 
           MOVE MN-PROGRAM-ID-2210 TO T1-MN-PROGRAM-ID (T1-INDEX).      
           MOVE MN-MTR-READ-SO-2210 TO                                  
                T1-MN-MTR-READ-SOURCE (T1-INDEX).                       
           MOVE RG-LAST-READD-2210 TO T1-RG-LAST-READD (T1-INDEX).      
           MOVE RG-REG-ID-NO-2210 TO T1-RG-REG-ID-NO (T1-INDEX).        
           MOVE CP-NO-UNITS-2210 TO T1-CP-NO-UNITS (T1-INDEX).          
           MOVE CP-CODE-PLAN-2210 TO T1-CP-CODE-PLAN (T1-INDEX).        
           MOVE CP-CD-STATRS-2210 TO T1-CP-CD-STAT-REAS (T1-INDEX).     
           MOVE CP-CD-SVC-TYP-2210 TO T1-CP-CD-SVC-TYPE (T1-INDEX).     
           MOVE CP-MTLY-AMT-FX-2210 TO T1-CP-MTHLY-AMT (T1-INDEX).      
           MOVE CP-RT-ITEM-CD-2210 TO T1-CP-RT-ITEM-CD (T1-INDEX).      
           MOVE CP-LIGHT-NO-2210 TO T1-CP-LIGHT-NO (T1-INDEX).          
           MOVE CP-POLE-NO-2210 TO T1-CP-POLE-NO (T1-INDEX).            
           MOVE CP-DIST-NO-2210 TO T1-CP-DIST-NO (T1-INDEX).            
           MOVE CP-USAGE-FIXED-2210 TO T1-CP-USAGE-FIXED (T1-INDEX).    
           MOVE CP-ITEM-SEQ-NO-2210 TO T1-CP-ITEM-SEQ-NO (T1-INDEX).    
           MOVE CP-EQUIP-ID-2210 TO T1-CP-EQUIP-ID (T1-INDEX).          
           MOVE PREM-DIR-IND-2210 TO T1-PREM-DIR-IND (T1-INDEX).        
           MOVE SUBDIV-LIGHT-2210 TO T1-SUBDIV-LIGHT (T1-INDEX).        
           MOVE ACCT-TYPE-2210 TO T1-ACCT-TYPE-CODE (T1-INDEX).         
           MOVE CD-RNTL-PROP-2210 TO T1-CD-RENTAL-PROP (T1-INDEX).      
           MOVE LL-CUSTOMER-NO-2210 TO T1-LL-CUSTOMER-NO (T1-INDEX).    
           MOVE REV-DIST-CD-2210 TO T1-REV-DISTRICT-CD (T1-INDEX).      
           MOVE DISC-BAL-2210 TO T1-DISC-BAL (T1-INDEX).                
           MOVE OUT-ACCOUNT-NO-2210 TO T1-OUT-ACCOUNT-NO (T1-INDEX).    
           MOVE ACCT-STATUS-2210 TO T1-ACCT-STATUS (T1-INDEX).          
           MOVE ROW-NO-2210 TO T1-ROW-NO (T1-INDEX).                    
           MOVE DEPOSIT-AMT-2210 TO T1-DEPOSIT-AMT (T1-INDEX).          
           MOVE SEC-TOT-AMT-2210 TO T1-SEC-TOT-AMT (T1-INDEX).          
           MOVE CUR-MTH-ARR-CD-2210 TO T1-CUR-MTH-ARR-CD (T1-INDEX).    
           MOVE CREDIT-GROUP-2210 TO T1-CREDIT-GROUP (T1-INDEX).        
           MOVE CURRENT-ACCOUNT-2210 TO T1-CURRENT-ACCOUNT (T1-INDEX).  
           MOVE DATE-BNKRPT-FL-2210 TO T1-DATE-BANKRUPT (T1-INDEX).     
           MOVE FILED-CASE-NO-2210 TO T1-FILED-CASE-NO (T1-INDEX).      
           MOVE DL-NO-2210 TO T1-DL-NO (T1-INDEX).                      
           MOVE DL-STATE-2210 TO T1-DL-STATE (T1-INDEX).                
           MOVE SSN-2210 TO T1-SSN (T1-INDEX).                          
           MOVE PRIOR-ACCT-STAT-2210 TO T1-PRIOR-ACCT-STAT (T1-INDEX).  
           MOVE READ-CYCLE-2210 TO T1-READ-CYCLE (T1-INDEX).            
           MOVE SERV-STRT-DT-2210 TO T1-SERV-STRT-DT (T1-INDEX).        
           MOVE DEP-INTST-RT-2210 TO T1-DEP-INTST-RT (T1-INDEX).        
           MOVE CP-DT-PLN-ST-2210 TO T1-CP-DT-PLAN-ST (T1-INDEX).       
           MOVE ACTIVE-CONTRACT-2210 TO T1-ACTIVE-CONTRACT (T1-INDEX).  
           MOVE SECURED-RATE-FL-2210 TO T1-SECURED-RATE-FL (T1-INDEX).  
           MOVE MN-CODE-MTR-RD-2210 TO T1-MN-CODE-MTR-RD (T1-INDEX).    
           MOVE MN-MTR-PRESS-2210 TO T1-MN-MTR-PRESS (T1-INDEX).        
           MOVE SPACES TO T1-WORK-TYPE-CD (T1-INDEX)                    
                          T1-RLSE-REQUIRED (T1-INDEX)                   
                          T1-RLSE-NO (T1-INDEX)                         
                          T1-RLSE-DATE (T1-INDEX).                      
           SET T1-INDEX UP BY 1.                                        
                                                                        
       3110-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3200-CALL-CSR01116.                                              
                                                                        
           MOVE LINK-LOCAL-OFFICE TO LOCAL-OFFICE-1116.                 
           MOVE LINK-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-1116.             
           MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-1116.                 
           MOVE 'N' TO CRAWL-IND-1116.                                  
           MOVE 'N' TO METER-IND-1116.                                  
           MOVE LINK-ZIP-CODE TO ZIP-CODE-1116.                         
           MOVE WS-READ-ROUTE-CHAR TO READ-ROUTE-1116.                  
           MOVE WS-POINT-ID TO POINT-ID-1116.                           
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01116                                             
      *           (:LOCAL-OFFICE-1116,                                  
      *            :CODE-UTIL-TYPE-1116,                                
      *            :WORK-TYPE-CD-1116,                                  
      *            :CRAWL-IND-1116,                                     
      *            :METER-IND-1116,                                     
      *            :ZIP-CODE-1116,                                      
      *            :READ-ROUTE-1116,                                    
      *            :POINT-ID-1116)                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1116 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01116'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1116)                                                
      *       WITH PROCEDURE CSR01116                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1116 CURSOR FOR RESULT SET        
      *       :LOC1116                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1116 INTO                            
                   :RETURN-CODE-1116,                                   
                   :WORK-AREA-1116,                                     
P00718             :BUSINESS-UNIT-1116                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                 IF RETURN-CODE-1116 NOT = 0                            
                     MOVE RETURN-CODE-1116      TO                      
                          WS-ACTIVE-RETURN-CODE                         
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR01116'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '3200'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'FETCH'                   TO ABEND-FUNCTION       
                 MOVE 'CSR01116'                TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                 MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2      
                 MOVE LINK-PREMISE-NO           TO HOSTVAR-ELEMENT-2    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3300-CALL-CSR00702.                                              
                                                                        
           MOVE WORK-AREA-1116 TO WORK-AREA-0702.                       
           MOVE WS-TS-PLUS-1-DAY TO IN-ASSIGNED-TS-0702.                
           MOVE ZEROES TO SERV-ORDER-NO-0702.                           
           MOVE '1.0' TO TOTAL-RES-0702.                                
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00702                                             
      *           (:WORK-AREA-0702,                                     
      *            :IN-ASSIGNED-TS-0702,                                
      *            :SERV-ORDER-NO-0702,                                 
      *            :TOTAL-RES-0702)                                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0702
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0702
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0702 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00702'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0702)                                                
      *       WITH PROCEDURE CSR00702                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0702 CURSOR FOR RESULT SET        
      *       :LOC0702                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0702 INTO                            
                   :RETURN-CODE-0702,                                   
                   :OUT-ASSIGNED-TS-0702,                               
                   :TOTAL-SO-HRS-0702,                                  
                   :MAX-RE-PER-DAY-0702,                                
                   :TOTAL-SO-0702,                                      
                   :MAX-DAILY-WK-REQ-0702                               
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                 IF RETURN-CODE-0702 NOT = 0                            
                     MOVE RETURN-CODE-0702      TO                      
                          WS-ACTIVE-RETURN-CODE                         
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3300'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR00702'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '3300'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'FETCH'                   TO ABEND-FUNCTION       
                 MOVE 'CSR00702'                TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                 MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2      
                 MOVE LINK-PREMISE-NO           TO HOSTVAR-ELEMENT-2    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       3300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3400-CALL-CSR03374.                                              
                                                                        
           MOVE LINK-PREMISE-NO TO PREMISE-NO-3374.                     
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-3374                      
                                   ACCOUNT-NO-PRIOR-3374.               
           MOVE ZEROES TO IN-SERV-ORDER-NO-3374.                        
           MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-3374.               
           MOVE LINK-LOCAL-OFFICE TO LOCAL-OFFICE-3374.                 
           MOVE LINK-PHONE-NO-EXT TO PHONE-NO-EXT-3374.                 
           MOVE LINK-PHONE-NO TO PHONE-NO-3374.                         
           MOVE LINK-ORDER-PLACED-BY TO ORDER-PLACED-BY-3374.           
           MOVE LINK-APPL-PGM-ID TO ORDER-RECVED-BY-3374.               
           IF C2-SAME-DAY-ORDER-FL = 'Y'                                
               MOVE WS-CURRENT-DATE TO WANTED-BY-DATE-3374              
                                       ASSIGNED-TS-3374(1:10)           
               MOVE '-00.00.00.000000' TO ASSIGNED-TS-3374(11:16)       
           ELSE                                                         
               MOVE OUT-ASSIGNED-TS-0702(1:10) TO WANTED-BY-DATE-3374   
                                                  ASSIGNED-TS-3374(1:10)
               MOVE '-00.00.00.000000' TO ASSIGNED-TS-3374(11:16)
           END-IF.      
           MOVE SPACES TO ORDER-REASON-3374.                            
           MOVE 'N' TO BACK-DATED-IND-3374.                             
           MOVE PF-RESP-AREA-ID TO RESP-AREA-ID-3374.                   
           MOVE SPACES TO CALL-BEFORE-MIN-3374                          
                          NOTIFY-CUST-IND-3374                          
                          NOTIFY-CSR-IND-3374                           
                          BREAKERS-OFF-3374.                            
           MOVE ZEROES TO DEPOSIT-AMT-3374.                             
           MOVE SPACES TO INIT-BY-CNTRCT-3374.                          
           MOVE WORK-AREA-1116 TO WORK-AREA-ID-3374.                    
P00718     MOVE BUSINESS-UNIT-1116 TO BUSINESS-UNIT-3374.               
           MOVE '7' TO ORDER-PRIORITY-3374.                             
           MOVE 'A' TO ORDER-STATE-CD-3374.                             
           MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-3374.                 
           MOVE LINK-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-3374.             
           MOVE ZEROES TO STD-CHG-AMT-3374.                             
           MOVE SPACES TO VERIFY-RATE-3374.                             
           MOVE '015' TO PANEL-NO-3374.                                 
           MOVE LINK-APPL-PGM-ID TO USER-ID-3374.                       
           MOVE ZEROES TO SO-EST-LABOR-HR-3374.                         
           MOVE LINK-CODE-ACCT-STAT TO ACCT-STATUS-3374.                
           MOVE 'N' TO REORDER-FL-3374.                                 
           MOVE LINK-COMPANY-NO TO COMPANY-NO-3374.                     
           MOVE SPACES TO OLD-ACCOUNT-STAT-3374.                        
           MOVE 'A' TO CODE-KEY-FIELD-3374.                             
           MOVE SPACES TO DT-FORECAST-DNP-3374.                         
           MOVE ZEROES TO AMT-DNP-AT-BILL-3374                          
                         PRICE-PER-SERV-3374.                           
           MOVE LINK-ACCOUNT-TYPE-CODE TO ACCOUNT-TYPE-CODE-3374.       
           MOVE SPACES TO WORK-PERIOD-CD-3374                           
                          WAIVER-TYPE-CD-3374.                          
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR03374                                             
      *           (:PREMISE-NO-3374,                                    
      *            :ACCOUNT-NO-3374,                                    
      *            :ACCOUNT-NO-PRIOR-3374,                              
      *            :IN-SERV-ORDER-NO-3374,                              
      *            :ORDER-TYPE-CD-3374,                                 
      *            :LOCAL-OFFICE-3374,                                  
      *            :PHONE-NO-EXT-3374,                                  
      *            :PHONE-NO-3374,                                      
      *            :ORDER-PLACED-BY-3374,                               
      *            :ORDER-RECVED-BY-3374,                               
      *            :WANTED-BY-DATE-3374,                                
      *            :ASSIGNED-TS-3374,                                   
      *            :ORDER-REASON-3374,                                  
      *            :BACK-DATED-IND-3374,                                
      *            :RESP-AREA-ID-3374,                                  
      *            :CALL-BEFORE-MIN-3374,                               
      *            :NOTIFY-CUST-IND-3374,                               
      *            :NOTIFY-CSR-IND-3374,                                
      *            :BREAKERS-OFF-3374,                                  
      *            :DEPOSIT-AMT-3374,                                   
      *            :INIT-BY-CNTRCT-3374,                                
      *            :WORK-AREA-ID-3374,                                  
      *            :ORDER-PRIORITY-3374,                                
      *            :ORDER-STATE-CD-3374,                                
      *            :WORK-TYPE-CD-3374,                                  
      *            :CODE-UTIL-TYPE-3374,                                
      *            :STD-CHG-AMT-3374,                                   
      *            :VERIFY-RATE-3374,                                   
      *            :PANEL-NO-3374,                                      
      *            :USER-ID-3374,                                       
      *            :SO-EST-LABOR-HR-3374,                               
      *            :ACCT-STATUS-3374,                                   
      *            :REORDER-FL-3374,                                    
      *            :COMPANY-NO-3374,                                    
      *            :OLD-ACCOUNT-STAT-3374,                              
      *            :CODE-KEY-FIELD-3374,                                
      *            :DT-FORECAST-DNP-3374,                               
      *            :AMT-DNP-AT-BILL-3374,                               
      *            :PRICE-PER-SERV-3374,                                
      *            :ACCOUNT-TYPE-CODE-3374,                             
      *            :WORK-PERIOD-CD-3374,                                
      *            :WAIVER-TYPE-CD-3374,                                
P00718*            :BUSINESS-UNIT-3374)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_3374
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_3374
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_3374 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR03374'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC3374)                                                
      *       WITH PROCEDURE CSR03374                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_3374 CURSOR FOR RESULT SET        
      *       :LOC3374                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_3374 INTO                            
                   :RETURN-CODE-3374,                                   
                   :OUT-SERV-ORDER-NO-3374                              
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                 IF RETURN-CODE-3374 NOT = 0                            
                     MOVE RETURN-CODE-3374      TO                      
                          WS-ACTIVE-RETURN-CODE                         
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3400'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR03374'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '3400'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'FETCH'                   TO ABEND-FUNCTION       
                 MOVE 'CSR03374'                TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                 MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2      
                 MOVE LINK-PREMISE-NO           TO HOSTVAR-ELEMENT-2    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       3400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3500-CALL-CSR00717.                                              
                                                                        
           MOVE OUT-SERV-ORDER-NO-3374 TO SERV-ORDER-NO-0717.           
           MOVE 'G' TO REMARK-TYPE-CD-0717.                             
           MOVE LINK-SPECIAL-INST TO REMARK-TX-0717-TEXT.               
           MOVE 210 TO REMARK-TX-0717-LEN.                              
           MOVE LINK-APPL-PGM-ID TO USER-ID-0717.                       
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00717                                             
      *           (:SERV-ORDER-NO-0717,                                 
      *            :REMARK-TYPE-CD-0717,                                
      *            :REMARK-TX-0717,                                     
      *            :USER-ID-0717)                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0717
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0717
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0717 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3500'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00717'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0717)                                                
      *       WITH PROCEDURE CSR00717                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0717 CURSOR FOR RESULT SET        
      *       :LOC0717                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0717 INTO                            
                   :RETURN-CODE-0717                                    
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                 IF RETURN-CODE-0717 NOT = 0                            
                     MOVE RETURN-CODE-0717      TO                      
                          WS-ACTIVE-RETURN-CODE                         
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3500'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR00717'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '3500'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'FETCH'                   TO ABEND-FUNCTION       
                 MOVE 'CSR00717'                TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                 MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2      
                 MOVE LINK-PREMISE-NO           TO HOSTVAR-ELEMENT-2    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       3500-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3600-CALL-CSR02120.                                              
                                                                        
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2120.                     
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-2120.                     
           MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-2120.               
           MOVE 'A' TO ORDER-STATE-CD-2120.                             
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02120                                             
      *           (:PREMISE-NO-2120,                                    
      *            :ACCOUNT-NO-2120,                                    
      *            :ORDER-TYPE-CD-2120,                                 
      *            :ORDER-STATE-CD-2120)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2120
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2120
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2120 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3600'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02120'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2120)                                                
      *       WITH PROCEDURE CSR02120                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2120 CURSOR FOR RESULT SET        
      *       :LOC2120                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2120 INTO                            
                   :RETURN-CODE-2120                                    
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                 IF RETURN-CODE-2120 NOT = 0                            
                     MOVE RETURN-CODE-2120      TO                      
                          WS-ACTIVE-RETURN-CODE                         
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3600'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02120'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
                 END-IF                                                 
             WHEN OTHER                                                 
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '3600'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'FETCH'                   TO ABEND-FUNCTION       
                 MOVE 'CSR02120'                TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE LINK-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                 MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-2      
                 MOVE LINK-PREMISE-NO           TO HOSTVAR-ELEMENT-2    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       3600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :PF-USER-ID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :PF-USER-ID                                     
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PF-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_USER_PROFILE'   TO TABLE-1                 
                   MOVE 'USER_ID'        TO TABLE-ELEMENT-1             
                   MOVE PF-USER-ID       TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-SAME-DAY.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SAME_DAY_ORDER_FL                                 
                 INTO :C2-SAME-DAY-ORDER-FL                             
                 FROM CSS_ORDER_TYPE WITH(READUNCOMMITTED)                      
                WHERE ORDER_TYPE_CD = :C2-ORDER-TYPE-CD                 
                  AND COMPANY_NO = :C2-COMPANY-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SAME_DAY_ORDER_FL                                         
MFA-TR*          INTO :C2-SAME-DAY-ORDER-FL                                     
MFA-TR*          FROM CSS_ORDER_TYPE                                            
MFA-TR*         WHERE ORDER_TYPE_CD = :C2-ORDER-TYPE-CD                         
MFA-TR*           AND COMPANY_NO = :C2-COMPANY-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO C2-SAME-DAY-ORDER-FL                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_TYPE' TO TABLE-1                     
                   MOVE 'ORDER_TYPE_CD'  TO TABLE-ELEMENT-1             
                   MOVE C2-ORDER-TYPE-CD TO HOSTVAR-ELEMENT-1           
                   MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-2             
                   MOVE C2-COMPANY-NO    TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7200-SELECT-ACCOUNT.                                             
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         SELECT TOP(1) LOCAL_OFFICE                                      
A05317           INTO :AT-LOCAL-OFFICE                                  
A05317           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
A05317          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
A05317                                           
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE                                              
MFA-TR*          INTO :AT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             MOVE AT-LOCAL-OFFICE TO LINK-LOCAL-OFFICE            
A05317         WHEN OTHER                                               
A05317             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A05317             MOVE '7200'           TO ACTIVE-PARAGRAPH            
A05317             MOVE 'SELECT'         TO ABEND-FUNCTION              
A05317             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A05317                                           ABEND-TABLES           
A05317             MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
A05317             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
A05317             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
A05317             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05317             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7200-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
       8000-UPDATE-ORDER.                                               
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET SOURCE_SYSTEM_CD = :VO-SOURCE-SYSTEM-CD           
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET SOURCE_SYSTEM_CD = :VO-SOURCE-SYSTEM-CD                   
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         QUERYNO 8000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
