       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04338.                                          
COB303 DATE-WRITTEN.      JUNE 25, 2010.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM BUILDS THE PROPERTY MANAGER LISTING FOR THE WEB. *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/25/10    FMB      NEW PROGRAM.                                      
      *  09/16/11    FMB      CORRECT S04E ABEND.                               
A04558*  05/22/13    FMB      CORRECT -811 ABEND.                               
P01176*  10/06/16    FMB      GAS SAMPLE TEST.                                  
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04338'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04338 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04338_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-PREMISE-NO           PIC X(13) VALUE SPACES.           
           05  S-SERV-ADDRESS         PIC X(70) VALUE SPACES.           
           05  S-HOUSE-NO             PIC X(15) VALUE SPACES.           
           05  S-ADDR-PREFIX-1        PIC X(03) VALUE SPACES.           
           05  S-ADDR-PREFIX-2        PIC X(02) VALUE SPACES.           
           05  S-STREET-NAME          PIC X(30) VALUE SPACES.           
           05  S-STREET-SUFFIX        PIC X(04) VALUE SPACES.           
           05  S-ADDR-SUFFIX          PIC X(02) VALUE SPACES.           
           05  S-STREET-LOCATION-1    PIC X(04) VALUE SPACES.           
           05  S-STREET-LOCATION-2    PIC X(11) VALUE SPACES.           
           05  S-TOWN                 PIC X(26) VALUE SPACES.           
           05  S-STATE                PIC X(26) VALUE SPACES.           
           05  S-ZIP-CODE             PIC X(05) VALUE SPACES.           
           05  S-COMPLEX-NAME         PIC X(26) VALUE SPACES.           
           05  S-ACCOUNT-HOLDER       PIC X(16) VALUE SPACES.           
           05  S-ACCOUNT-NO           PIC X(13) VALUE SPACES.           
           05  S-STATUS               PIC X(75) VALUE SPACES.           
           05  S-STATE-REMARKS        PIC X(75) VALUE SPACES.           
           05  S-REVERT-FL            PIC X(01) VALUE SPACES.           
           05  S-REVERT-ELIG-FL       PIC X(01) VALUE SPACES.           
           05  S-ONLINE-ELIG-FL       PIC X(01) VALUE SPACES.           
           05  S-MST-SUB-FL           PIC X(01) VALUE SPACES.           
           05  S-COMPANY-NO           PIC X(02) VALUE SPACES.           
           05  S-MST-ACCOUNT-NO       PIC X(13) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-DATE-MINUS-30-DAYS    PIC X(10) VALUE SPACES.         
           05  WS-TS-MINUS-30-DAYS      PIC X(26) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04338'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-2                PIC S9(4) COMP VALUE 0.         
           05  WS-NULL-3                PIC S9(4) COMP VALUE 0.         
           05  WS-SORT-TS               PIC X(26) VALUE SPACES.         
           05  WS-SUB1                  PIC S9(04) COMP VALUE ZERO.     
           05  WS-SUB2                  PIC S9(04) COMP VALUE ZERO.     
           05  WS-NON-DNPFB-FL          PIC X(01) VALUE SPACES.         
           05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05  WS-ROW-SENT              PIC X(01) VALUE SPACES.         
           05  WS-ORDERS-FOUND          PIC X(01) VALUE SPACES.         
           05  WS-FORMAT-DATE.                                          
               10  WS-MM                PIC X(02).                      
               10  F                    PIC X(01) VALUE '/'.            
               10  WS-DD                PIC X(02).                      
               10  F                    PIC X(01) VALUE '/'.            
               10  WS-YYYY              PIC X(04).                      
           05  WS-ASSIGNED-DATE         PIC X(10).                      
           05  WS-COMPLETED-DATE        PIC X(10).                      
           05  WS-DNP01-DATE            PIC X(10).                      
           05  WS-DNP01-TS              PIC X(26).                      
           05  WS-ITERATION-STORAGE.                                    
               10 WS-ADDRESS-LINE       PIC X(70) VALUE SPACES.         
               10 WS-ACCOUNT-NO-NUM     PIC 9(13).                      
               10 WS-ACCOUNT-NO-CHAR    REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
               10 WS-PREMISE-NO-NUM     PIC 9(10).                      
               10 WS-PREMISE-NO-CHAR    REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
               10 WS-CUSTOMER-NUM       PIC 9(10).                      
               10 WS-CUSTOMER-CHAR      REDEFINES WS-CUSTOMER-NUM       
                                        PIC X(10).                      
                                                                        
       01  WS-TABLES.                                                   
           05  WS-ORDER-TABLE          OCCURS 25 TIMES                  
                                       INDEXED BY T1-INDEX.             
               10 T1-SERV-ORDER-NO      PIC X(13) VALUE SPACES.         
               10 T1-ORDER-TYPE-CD      PIC X(05) VALUE SPACES.         
               10 T1-ASSIGNED-DATETIME  PIC X(10) VALUE SPACES.         
               10 T1-ACCOUNT-NO         PIC X(13) VALUE SPACES.         
               10 T1-CUSTOMER-NO        PIC 9(10) VALUE ZEROES.         
               10 T1-ACCOUNT-NO-PRIOR   PIC X(13) VALUE SPACES.         
               10 T1-CUSTOMER-NO-PRIOR  PIC 9(13) VALUE ZEROES.         
               10 T1-ORDER-STATE-CD     PIC X(01) VALUE SPACES.         
               10 T1-ORDER-REASON       PIC X(01) VALUE SPACES.         
               10 T1-RELEASE-IND        PIC X(01) VALUE SPACES.         
               10 T1-COMPLETED-DATETIME PIC X(10) VALUE SPACES.         
               10 T1-WORK-AREA-ID       PIC X(12) VALUE SPACES.         
               10 T1-UNBLOCK-FL         PIC X(01) VALUE SPACES.         
               10 T1-NEW-CUST-IS-LL-FL  PIC X(01) VALUE SPACES.         
               10 T1-OLD-CUST-IS-LL-FL  PIC X(01) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
               DECLARE LANDLORD-CURSOR CURSOR FOR                       
                   SELECT SI.PREMISE_NO,                                
                          CODE_RENTAL_PROP,                             
                          PR.ADDRESS_ID,                                
                          PR.SUBDIVISION_ID,                            
                          SUBDIVISION_DESC,                             
                          PR.COMPANY_NO                                 
                     FROM CSS_LANDLORD SI WITH(READUNCOMMITTED),                
                          CSS_PREMISE PR WITH(READUNCOMMITTED),                 
                          CSS_SUBDIVISION B0 WITH(READUNCOMMITTED)              
                    WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                 
                      AND SI.PREMISE_NO = PR.PREMISE_NO                 
                      AND PR.SUBDIVISION_ID = B0.SUBDIVISION_ID         
                      AND PR.COMPANY_NO = B0.COMPANY_NO                 
                      AND EXISTS (                                      
                          SELECT '1'                                    
                            FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)         
                           WHERE PREMISE_NO = PR.PREMISE_NO)            
                   FOR READ ONLY                                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE LANDLORD-CURSOR CURSOR FOR                               
MFA-TR*            SELECT SI.PREMISE_NO,                                        
MFA-TR*                   CODE_RENTAL_PROP,                                     
MFA-TR*                   PR.ADDRESS_ID,                                        
MFA-TR*                   PR.SUBDIVISION_ID,                                    
MFA-TR*                   SUBDIVISION_DESC,                                     
MFA-TR*                   PR.COMPANY_NO                                         
MFA-TR*              FROM CSS_LANDLORD SI,                                      
MFA-TR*                   CSS_PREMISE PR,                                       
MFA-TR*                   CSS_SUBDIVISION B0                                    
MFA-TR*             WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                         
MFA-TR*               AND SI.PREMISE_NO = PR.PREMISE_NO                         
MFA-TR*               AND PR.SUBDIVISION_ID = B0.SUBDIVISION_ID                 
MFA-TR*               AND PR.COMPANY_NO = B0.COMPANY_NO                         
MFA-TR*               AND EXISTS (                                              
MFA-TR*                   SELECT '1'                                            
MFA-TR*                     FROM CSS_UTIL_ENVRNMT                               
MFA-TR*                    WHERE PREMISE_NO = PR.PREMISE_NO)                    
MFA-TR*            FOR FETCH ONLY                                               
MFA-TR*            WITH UR                                                      
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE SO-CURSOR CURSOR FOR                             
                   SELECT SERV_ORDER_NO,                                
                          ORDER_TYPE_CD,                                
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME,                           
                          ACCOUNT_NO,                                   
                          ACCOUNT_NO_PRIOR,                             
                          ORDER_STATE_CD,                               
                          ORDER_REASON,                                 
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                          REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           COMPLETED_DATETIME,                  
                                   ASSIGNED_DATETIME), 121), ' ', '-'), 
           ':', '.'),                  
                          WORK_AREA_ID                                  
                     FROM CSS_SO_DATA WITH(READUNCOMMITTED)                     
                    WHERE PREMISE_NO = :VO-PREMISE-NO                   
                      AND ORDER_TYPE_CD IN ('OFF01', 'OFF02', 'OFF03',  
                                            'CC001', 'CC002', 'CC003',  
                                            'NC001', 'DNPFB')           
                      AND ORDER_STATE_CD <> 'C'                         
                      AND BACK_DATED_IND <> 'Y'                         
                      AND (COMPLETED_DATETIME IS NULL                   
                       OR  COMPLETED_DATETIME >=                        
                           CIS.CHAR2TIMESTAMP(:VO-COMPLETED-DATETIME))          
                   ORDER BY 8                                           
                   FOR READ ONLY                                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO-CURSOR CURSOR FOR                                     
MFA-TR*            SELECT SERV_ORDER_NO,                                        
MFA-TR*                   ORDER_TYPE_CD,                                        
MFA-TR*                   COMPLETED_DATETIME,                                   
MFA-TR*                   ACCOUNT_NO,                                           
MFA-TR*                   ACCOUNT_NO_PRIOR,                                     
MFA-TR*                   ORDER_STATE_CD,                                       
MFA-TR*                   ORDER_REASON,                                         
MFA-TR*                   ASSIGNED_DATETIME,                                    
MFA-TR*                   COALESCE(COMPLETED_DATETIME,                          
MFA-TR*                            ASSIGNED_DATETIME),                          
MFA-TR*                   WORK_AREA_ID                                          
MFA-TR*              FROM CSS_SO_DATA                                           
MFA-TR*             WHERE PREMISE_NO = :VO-PREMISE-NO                           
MFA-TR*               AND ORDER_TYPE_CD IN ('OFF01', 'OFF02', 'OFF03',          
MFA-TR*                                     'CC001', 'CC002', 'CC003',          
MFA-TR*                                     'NC001', 'DNPFB')                   
MFA-TR*               AND ORDER_STATE_CD = 'C'                                 
MFA-TR*               AND BACK_DATED_IND = 'Y'                                 
MFA-TR*               AND (COMPLETED_DATETIME IS NULL                           
MFA-TR*                OR  COMPLETED_DATETIME >=                                
MFA-TR*                    :VO-COMPLETED-DATETIME)                              
MFA-TR*            ORDER BY 8                                                   
MFA-TR*            FOR FETCH ONLY                                               
MFA-TR*            WITH UR                                                      
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      PREMISE_NO          AS PREMISE_NO,                
                      SERV_ADDRESS        AS SERV_ADDRESS,              
                      HOUSE_NO            AS HOUSE_NO,                  
                      ADDR_PREFIX_1       AS ADDR_PREFIX_1,             
                      ADDR_PREFIX_2       AS ADDR_PREFIX_2,             
                      STREET_NAME         AS STREET_NAME,               
                      STREET_SUFFIX       AS STREET_SUFFIX,             
                      ADDR_SUFFIX         AS ADDR_SUFFIX,               
                      STREET_LOCATION_1   AS STREET_LOCATION_1,         
                      STREET_LOCATION_2   AS STREET_LOCATION_2,         
                      TOWN                AS TOWN,                      
                      STATE               AS STATE,                     
                      ZIP_CODE            AS ZIP_CODE,                  
                      COMPLEX_NAME        AS COMPLEX_NAME,              
                      ACCOUNT_HOLDER      AS ACCOUNT_HOLDER,            
                      ACCOUNT_NO          AS ACCOUNT_NO,                
                      STATUS              AS STATUS,                    
                      STATE_REMARKS       AS STATE_REMARKS,             
                      REVERT_FL           AS REVERT_FL,                 
                      REVERT_ELIG_FL      AS REVERT_ELIG_FL,            
                      ONLINE_ELIG_FL      AS ONLINE_ELIG_FL,            
                      MST_SUB_FL          AS MST_SUB_FL,                
                      COMPANY_NO          AS COMPANY_NO,                
                      MST_ACCOUNT_NO      AS MST_ACCOUNT_NO             
               FROM #CSR04338_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               PREMISE_NO          AS PREMISE_NO,                        
MFA-TR*               SERV_ADDRESS        AS SERV_ADDRESS,                      
MFA-TR*               HOUSE_NO            AS HOUSE_NO,                          
MFA-TR*               ADDR_PREFIX_1       AS ADDR_PREFIX_1,                     
MFA-TR*               ADDR_PREFIX_2       AS ADDR_PREFIX_2,                     
MFA-TR*               STREET_NAME         AS STREET_NAME,                       
MFA-TR*               STREET_SUFFIX       AS STREET_SUFFIX,                     
MFA-TR*               ADDR_SUFFIX         AS ADDR_SUFFIX,                       
MFA-TR*               STREET_LOCATION_1   AS STREET_LOCATION_1,                 
MFA-TR*               STREET_LOCATION_2   AS STREET_LOCATION_2,                 
MFA-TR*               TOWN                AS TOWN,                              
MFA-TR*               STATE               AS STATE,                             
MFA-TR*               ZIP_CODE            AS ZIP_CODE,                          
MFA-TR*               COMPLEX_NAME        AS COMPLEX_NAME,                      
MFA-TR*               ACCOUNT_HOLDER      AS ACCOUNT_HOLDER,                    
MFA-TR*               ACCOUNT_NO          AS ACCOUNT_NO,                        
MFA-TR*               STATUS              AS STATUS,                            
MFA-TR*               STATE_REMARKS       AS STATE_REMARKS,                     
MFA-TR*               REVERT_FL           AS REVERT_FL,                         
MFA-TR*               REVERT_ELIG_FL      AS REVERT_ELIG_FL,                    
MFA-TR*               ONLINE_ELIG_FL      AS ONLINE_ELIG_FL,                    
MFA-TR*               MST_SUB_FL          AS MST_SUB_FL,                        
MFA-TR*               COMPANY_NO          AS COMPANY_NO,                        
MFA-TR*               MST_ACCOUNT_NO      AS MST_ACCOUNT_NO                     
MFA-TR*        FROM SESSION.CSR04338_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04338_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04338_R1
              (                                                          
               RETURN_CODE          INT,                            
               PREMISE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,            
               SERV_ADDRESS CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2,          
               HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ADDR_PREFIX_1 CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ADDR_PREFIX_2 CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
               STREET_NAME CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,           
               STREET_SUFFIX CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,           
               STREET_LOCATION_1 CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               STREET_LOCATION_2 CHAR(11)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,              
               COMPLEX_NAME CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ACCOUNT_HOLDER CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2,            
               STATUS CHAR(75)  COLLATE LATIN1_GENERAL_100_BIN2,                
               STATE_REMARKS CHAR(75)  COLLATE LATIN1_GENERAL_100_BIN2,         
               REVERT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               REVERT_ELIG_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ONLINE_ELIG_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               MST_SUB_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
               COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               MST_ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04338_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
               END-IF
           END-IF.        
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -30, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-30-DAYS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 30 DAYS)                       
MFA-TR*          INTO :WS-DATE-MINUS-30-DAYS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-DATE-MINUS-30-DAYS TO WS-TS-MINUS-30-DAYS(1:10).     
           MOVE '-00.00.00.000000' TO WS-TS-MINUS-30-DAYS(11:16).       
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE '0000000000' TO LINK-CUSTOMER-NO
           END-IF.                   
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO SI-CUSTOMER-NO.                   
                                                                        
           PERFORM 7000-SELECT-CUSTOMER THRU 7000-EXIT.                 
                                                                        
           PERFORM 7010-OPEN-LL-CURSOR THRU 7010-EXIT.                  
           PERFORM 1100-PROCESS-PREMISES THRU 1100-EXIT.                
           PERFORM 7030-CLOSE-LL-CURSOR THRU 7030-EXIT.                 
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-PROCESS-PREMISES.                                           
                                                                        
           EXEC SQL                                                     
               FETCH LANDLORD-CURSOR                                    
               INTO :SI-PREMISE-NO,                                     
                    :PR-CODE-RENTAL-PROP,                               
                    :PR-ADDRESS-ID,                                     
                    :PR-SUBDIVISION-ID,                                 
                    :B0-SUBDIVISION-DESC,                               
                    :PR-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '1100'            TO ACTIVE-PARAGRAPH            
                  MOVE 'FETCH'           TO ABEND-FUNCTION              
                  MOVE SPACES            TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                  MOVE 'CSS_LANDLORD'    TO TABLE-1                     
                  MOVE 'CSS_PREMISE'     TO TABLE-2                     
                  MOVE 'CSS_SUBDIVISION' TO TABLE-3                     
                  MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1             
                  MOVE SI-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
           MOVE SI-PREMISE-NO TO WS-PREMISE-NO-NUM.                     
           MOVE WS-PREMISE-NO-CHAR TO S-PREMISE-NO.                     
           PERFORM 7100-SERVICE-ADDRESS THRU 7100-EXIT.                 
           MOVE WS-ADDRESS-LINE TO S-SERV-ADDRESS.                      
           MOVE DY-HOUSE-NO TO S-HOUSE-NO.                              
           MOVE DY-ADDR-PREFIX-1 TO S-ADDR-PREFIX-1.                    
           MOVE DY-ADDR-PREFIX-2 TO S-ADDR-PREFIX-2.                    
           MOVE DY-STREET-NAME TO S-STREET-NAME.                        
           MOVE DY-STREET-SUFFIX TO S-STREET-SUFFIX.                    
           MOVE DY-ADDR-SUFFIX TO S-ADDR-SUFFIX.                        
           MOVE DY-STREET-LOCATION-1 TO S-STREET-LOCATION-1.            
           MOVE DY-STREET-LOCATION-2 TO S-STREET-LOCATION-2.            
           MOVE A4-TOWN TO S-TOWN.                                      
           MOVE A4-STATE TO S-STATE.                                    
           MOVE DY-ZIP-CODE TO S-ZIP-CODE.                              
           IF B0-SUBDIVISION-DESC = 'NONE' OR 'UNKNOWN'                 
               MOVE SPACES TO S-COMPLEX-NAME                            
           ELSE                                                         
               MOVE B0-SUBDIVISION-DESC TO S-COMPLEX-NAME
           END-IF.              
           MOVE PR-CODE-RENTAL-PROP TO S-REVERT-FL.                     
           MOVE CU-LANDLORD-REVERT-FL TO S-REVERT-ELIG-FL.              
           MOVE SI-PREMISE-NO TO WS-CPD99-PREMISE-NO.                   
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO.                   
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
           IF AT-CODE-ACCT-STAT = 'A'                                   
              IF AT-CUSTOMER-NO = SI-CUSTOMER-NO                        
                  MOVE 'PROPERTY MANAGER' TO S-ACCOUNT-HOLDER           
                  MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM               
                  MOVE WS-ACCOUNT-NO-CHAR TO S-ACCOUNT-NO               
              ELSE                                                      
                  MOVE 'TENANT' TO S-ACCOUNT-HOLDER                     
                  MOVE SPACES TO S-ACCOUNT-NO                           
              END-IF                                                    
           ELSE                                                         
              MOVE 'NONE' TO S-ACCOUNT-HOLDER                           
              MOVE SPACES TO S-ACCOUNT-NO
           END-IF.                              
           MOVE AT-MST-SUB-ACCT-IND TO S-MST-SUB-FL.                    
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
               PERFORM 7800-MST-ACCOUNT THRU 7800-EXIT                  
           ELSE                                                         
               MOVE SPACES TO S-MST-ACCOUNT-NO
           END-IF.                         
           MOVE PR-COMPANY-NO TO S-COMPANY-NO.                          
                                                                        
           MOVE SI-PREMISE-NO TO VO-PREMISE-NO.                         
           MOVE WS-TS-MINUS-30-DAYS TO VO-COMPLETED-DATETIME.           
           MOVE 'N' TO WS-ORDERS-FOUND.                                 
           INITIALIZE WS-TABLES.                                        
           PERFORM 7040-OPEN-SO-CURSOR THRU 7040-EXIT.                  
           PERFORM 1200-BUILD-TABLE     THRU 1200-EXIT VARYING          
               T1-INDEX FROM 1 BY 1 UNTIL                               
               T1-INDEX > 25 OR                                         
               WS-ACTIVE-RETURN-CODE = NOT-FOUND.                       
           PERFORM 7050-CLOSE-SO-CURSOR THRU 7050-EXIT.                 
                                                                        
           IF WS-ORDERS-FOUND = 'Y'                                     
               PERFORM 1150-PROCESS-TABLE THRU 1150-EXIT                
           ELSE                                                         
               MOVE SPACES TO S-STATUS                                  
                              S-STATE-REMARKS                           
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
           GO TO 1100-PROCESS-PREMISES.                                 
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1150-PROCESS-TABLE.                                              
                                                                        
           PERFORM 1300-CHAINING THRU 1300-EXIT VARYING                 
               WS-SUB1 FROM 1 BY 1 UNTIL                                
SCA006         WS-SUB1 > 25 OR 
               T1-SERV-ORDER-NO (WS-SUB1) <= SPACES.                            
                                                                        
           PERFORM 1310-CUSTOMER-NOS THRU 1310-EXIT VARYING             
               T1-INDEX FROM 1 BY 1 UNTIL                               
               T1-INDEX > 25 OR                                         
               T1-SERV-ORDER-NO (T1-INDEX) <= SPACES.                   
                                                                        
           PERFORM 1400-FORMAT-AND-SEND THRU 1400-EXIT VARYING          
               T1-INDEX FROM 1 BY 1 UNTIL                               
               T1-INDEX > 25 OR                                         
               T1-SERV-ORDER-NO (T1-INDEX) <= SPACES.                   
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH SO-CURSOR                                          
               INTO :VO-SERV-ORDER-NO,                                  
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-COMPLETED-DATETIME :WS-NULL-1,                   
                    :VO-ACCOUNT-NO,                                     
                    :VO-ACCOUNT-NO-PRIOR,                               
                    :VO-ORDER-STATE-CD,                                 
                    :VO-ORDER-REASON,                                   
                    :VO-ASSIGNED-DATETIME :WS-NULL-2,                    
                    :WS-SORT-TS :WS-NULL-3,                              
                    :VO-WORK-AREA-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ORDERS-FOUND                          
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO VO-ASSIGNED-DATETIME              
                   END-IF                                               
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO VO-COMPLETED-DATETIME             
                   END-IF                                               
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO WS-SORT-TS                        
                   END-IF                                               
                   MOVE VO-SERV-ORDER-NO TO                             
                        T1-SERV-ORDER-NO (T1-INDEX)                     
                   MOVE VO-ORDER-TYPE-CD TO                             
                        T1-ORDER-TYPE-CD (T1-INDEX)                     
                   MOVE VO-ASSIGNED-DATETIME(1:10) TO                   
                        T1-ASSIGNED-DATETIME (T1-INDEX)                 
                   MOVE VO-ACCOUNT-NO TO                                
                        WS-ACCOUNT-NO-NUM                               
                   MOVE WS-ACCOUNT-NO-CHAR TO                           
                        T1-ACCOUNT-NO (T1-INDEX)                        
                   MOVE VO-ACCOUNT-NO-PRIOR TO                          
                        WS-ACCOUNT-NO-NUM                               
                   MOVE WS-ACCOUNT-NO-CHAR TO                           
                        T1-ACCOUNT-NO-PRIOR (T1-INDEX)                  
                   MOVE VO-ORDER-STATE-CD TO                            
                        T1-ORDER-STATE-CD (T1-INDEX)                    
                   MOVE VO-ORDER-REASON TO                              
                        T1-ORDER-REASON (T1-INDEX)                      
                   MOVE VO-COMPLETED-DATETIME(1:10) TO                  
                        T1-COMPLETED-DATETIME (T1-INDEX)                
                   MOVE VO-WORK-AREA-ID TO                              
                        T1-WORK-AREA-ID (T1-INDEX)                      
                   PERFORM 7400-RELEASE-IND THRU 7400-EXIT              
                   PERFORM 7500-WORK-TYPE THRU 7500-EXIT                
                   MOVE ZEROES TO T1-CUSTOMER-NO (T1-INDEX)             
                                  T1-CUSTOMER-NO-PRIOR (T1-INDEX)       
               WHEN NOT-FOUND                                           
                   GO TO 1200-EXIT                                      
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '1200'            TO ACTIVE-PARAGRAPH            
                  MOVE 'FETCH'           TO ABEND-FUNCTION              
                  MOVE SPACES            TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                  MOVE 'CSS_SO_DATA'     TO TABLE-1                     
                  MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1             
                  MOVE SI-PREMISE-NO     TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1300-CHAINING.                                                   
                                                                        
           IF T1-ORDER-STATE-CD (WS-SUB1) NOT = 'Z'                     
               MOVE T1-ACCOUNT-NO (WS-SUB1) TO WS-ACCOUNT-NO            
               COMPUTE WS-SUB2 = WS-SUB1 + 1                            
               PERFORM UNTIL T1-SERV-ORDER-NO (WS-SUB2) <= SPACES OR    
                             WS-SUB2 > 25                               
                   IF T1-ORDER-STATE-CD (WS-SUB2) NOT = 'Z'             
                      MOVE WS-ACCOUNT-NO TO                             
                           T1-ACCOUNT-NO-PRIOR (WS-SUB2)                
                   END-IF                                               
A03263             ADD +1 TO WS-SUB2                                    
               END-PERFORM
           END-IF.                                             
                                                                        
       1300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1310-CUSTOMER-NOS.                                               
                                                                        
           MOVE T1-ACCOUNT-NO (T1-INDEX) TO AT-ACCOUNT-NO.              
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
           MOVE AT-CUSTOMER-NO TO T1-CUSTOMER-NO (T1-INDEX).            
           IF T1-CUSTOMER-NO (T1-INDEX) = SI-CUSTOMER-NO                
               MOVE 'Y' TO T1-NEW-CUST-IS-LL-FL (T1-INDEX)              
           ELSE                                                         
               MOVE 'N' TO T1-NEW-CUST-IS-LL-FL (T1-INDEX)
           END-IF.             
                                                                        
           MOVE T1-ACCOUNT-NO-PRIOR (T1-INDEX) TO AT-ACCOUNT-NO.        
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
           MOVE AT-CUSTOMER-NO TO T1-CUSTOMER-NO-PRIOR (T1-INDEX).      
           IF T1-CUSTOMER-NO-PRIOR (T1-INDEX) = SI-CUSTOMER-NO          
               MOVE 'Y' TO T1-OLD-CUST-IS-LL-FL (T1-INDEX)              
           ELSE                                                         
               MOVE 'N' TO T1-OLD-CUST-IS-LL-FL (T1-INDEX)
           END-IF.             
                                                                        
       1310-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1400-FORMAT-AND-SEND.                                            
                                                                        
           IF T1-ASSIGNED-DATETIME (T1-INDEX) > ' '                     
               MOVE T1-ASSIGNED-DATETIME (T1-INDEX) (1:4) TO WS-YYYY    
               MOVE T1-ASSIGNED-DATETIME (T1-INDEX) (6:2) TO WS-MM      
               MOVE T1-ASSIGNED-DATETIME (T1-INDEX) (9:2) TO WS-DD      
               MOVE WS-FORMAT-DATE TO WS-ASSIGNED-DATE                  
           ELSE                                                         
               MOVE SPACES TO WS-ASSIGNED-DATE
           END-IF.                         
           IF T1-COMPLETED-DATETIME (T1-INDEX) > ' '                    
               MOVE T1-COMPLETED-DATETIME (T1-INDEX) (1:4) TO WS-YYYY   
               MOVE T1-COMPLETED-DATETIME (T1-INDEX) (6:2) TO WS-MM     
               MOVE T1-COMPLETED-DATETIME (T1-INDEX) (9:2) TO WS-DD     
               MOVE WS-FORMAT-DATE TO WS-COMPLETED-DATE                 
           ELSE                                                         
               MOVE SPACES TO WS-COMPLETED-DATE
           END-IF.                        
           IF T1-ORDER-STATE-CD (T1-INDEX) = 'Z'                        
               PERFORM 1420-COMPLETED-ORDERS THRU 1420-EXIT             
           ELSE                                                         
               IF T1-ORDER-TYPE-CD (T1-INDEX) = 'DNPFB'                 
                   PERFORM 7700-ONLY-DNPFB THRU 7700-EXIT               
                   IF WS-NON-DNPFB-FL = 'N'                             
                       MOVE SPACES TO S-STATUS                          
                                      S-STATE-REMARKS                   
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
                   END-IF                                               
               ELSE                                                     
                   PERFORM 1410-PENDING-ORDERS THRU 1410-EXIT
               END-IF
           END-IF.          
                                                                        
       1400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1410-PENDING-ORDERS.                                             
                                                                        
           MOVE SPACES TO S-STATE-REMARKS.                              
           EVALUATE T1-ORDER-STATE-CD (T1-INDEX)                        
               WHEN 'A'                                                 
                   IF T1-RELEASE-IND (T1-INDEX) = 'Y'                   
                       MOVE 'INSPECTION REQUIRED' TO S-STATE-REMARKS    
                   END-IF                                               
               WHEN 'B'                                                 
                   MOVE 'ORDER ON HOLD' TO S-STATE-REMARKS              
               WHEN 'D'                                                 
                   MOVE 'ACTION REQUIRED' TO S-STATE-REMARKS            
               WHEN 'H'                                                 
                   IF T1-WORK-AREA-ID (T1-INDEX) (1:3) = 'ARO'          
                       MOVE SPACES TO S-STATE-REMARKS                   
                   ELSE                                                 
                       MOVE 'ORDER ON HOLD' TO S-STATE-REMARKS          
                   END-IF                                               
               WHEN 'R'                                                 
                   MOVE 'CUSTOMER ACTION REQUIRED' TO                   
                        S-STATE-REMARKS                                 
           END-EVALUATE.                                                
                                                                        
      *  CUSTOMER OR OCCUPANT CHANGE ORDERS                                     
                                                                        
           IF T1-ORDER-TYPE-CD (T1-INDEX) (1:2) = 'CC' OR 'NC'          
               IF T1-ORDER-REASON (T1-INDEX) = 'R'                      
                   MOVE SPACES TO S-STATUS                              
                   STRING 'TENANT TURNING OFF '                         
                          WS-ASSIGNED-DATE                              
                          DELIMITED BY SIZE                             
                          INTO S-STATUS                                 
                   END-STRING                                           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                   MOVE SPACES TO S-STATUS                              
                   STRING 'REVERTING TO PROPERTY MANAGER '              
                          WS-ASSIGNED-DATE                              
                          DELIMITED BY SIZE                             
                          INTO S-STATUS                                 
                   END-STRING                                           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
               ELSE                                                     
                   IF T1-UNBLOCK-FL (T1-INDEX) = 'Y'                    
                       EVALUATE T1-NEW-CUST-IS-LL-FL (T1-INDEX)         
                           WHEN 'Y'                                     
                               MOVE SPACES TO S-STATUS                  
                               STRING 'PROPERTY MANAGER TURNING ON '    
                                      WS-ASSIGNED-DATE                  
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                           WHEN 'N'                                     
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNING ON '              
                                      WS-ASSIGNED-DATE                  
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                       END-EVALUATE                                     
                   ELSE                                                 
                       IF T1-OLD-CUST-IS-LL-FL (T1-INDEX) = 'Y'         
                           MOVE SPACES TO S-STATUS                      
                           STRING 'PROPERTY MANAGER TURNING OFF '       
                                  WS-ASSIGNED-DATE                      
                                  DELIMITED BY SIZE                     
                                  INTO S-STATUS                         
                           END-STRING                                   
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                           MOVE SPACES TO S-STATUS                      
                           STRING 'TENANT TURNING ON '                  
                                  WS-ASSIGNED-DATE                      
                                  DELIMITED BY SIZE                     
                                  INTO S-STATUS                         
                           END-STRING                                   
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       ELSE                                             
                           IF T1-NEW-CUST-IS-LL-FL (T1-INDEX) = 'Y'     
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNING OFF '             
                                      WS-ASSIGNED-DATE                  
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                               MOVE SPACES TO S-STATUS                  
                               STRING 'PROPERTY MANAGER TURNING ON '    
                                      WS-ASSIGNED-DATE                  
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                           ELSE                                         
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNING OFF '             
                                      WS-ASSIGNED-DATE                  
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNING ON '              
                                      WS-ASSIGNED-DATE                  
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
                           END-IF
                       END-IF
                   END-IF
               END-IF
           END-IF. 
                                                                        
      *  OFF ORDERS                                                             
                                                                        
           IF T1-ORDER-TYPE-CD (T1-INDEX) (1:3) = 'OFF'                 
              IF T1-OLD-CUST-IS-LL-FL (T1-INDEX) = 'Y'                  
                  MOVE SPACES TO S-STATUS                               
                  STRING 'PROPERTY MANAGER TURNING OFF '                
                         WS-ASSIGNED-DATE                               
                         DELIMITED BY SIZE                              
                         INTO S-STATUS                                  
                  END-STRING                                            
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT               
              ELSE                                                      
                  MOVE SPACES TO S-STATUS                               
                  STRING 'TENANT TURNING OFF '                          
                         WS-ASSIGNED-DATE                               
                         DELIMITED BY SIZE                              
                         INTO S-STATUS                                  
                  END-STRING                                            
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
              END-IF
           END-IF.              
                                                                        
       1410-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1420-COMPLETED-ORDERS.                                           
                                                                        
      *  CUSTOMER OR OCCUPANT CHANGE ORDERS                                     
                                                                        
           MOVE SPACES TO S-STATE-REMARKS.                              
                                                                        
           IF T1-ORDER-TYPE-CD (T1-INDEX) (1:2) = 'CC' OR 'NC'          
               IF T1-ORDER-REASON (T1-INDEX) = 'R'                      
                   MOVE SPACES TO S-STATUS                              
                   STRING 'TENANT TURNED OFF '                          
                          WS-COMPLETED-DATE                             
                          DELIMITED BY SIZE                             
                          INTO S-STATUS                                 
                   END-STRING                                           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                   MOVE SPACES TO S-STATUS                              
                   STRING 'REVERTED TO PROPERTY MANAGER '               
                          WS-COMPLETED-DATE                             
                          DELIMITED BY SIZE                             
                          INTO S-STATUS                                 
                   END-STRING                                           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
               ELSE                                                     
                   IF T1-UNBLOCK-FL (T1-INDEX) = 'Y'                    
                       EVALUATE T1-NEW-CUST-IS-LL-FL (T1-INDEX)         
                           WHEN 'Y'                                     
                               MOVE SPACES TO S-STATUS                  
                               STRING 'PROPERTY MANAGER TURNED ON '     
                                      WS-COMPLETED-DATE                 
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                           WHEN 'N'                                     
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNED ON '               
                                      WS-COMPLETED-DATE                 
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                       END-EVALUATE                                     
                   ELSE                                                 
                       IF T1-OLD-CUST-IS-LL-FL (T1-INDEX) = 'Y'         
                           MOVE SPACES TO S-STATUS                      
                           STRING 'PROPERTY MANAGER TURNED OFF '        
                                  WS-COMPLETED-DATE                     
                                  DELIMITED BY SIZE                     
                                  INTO S-STATUS                         
                           END-STRING                                   
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                           MOVE SPACES TO S-STATUS                      
                           STRING 'TENANT TURNED ON '                   
                                  WS-COMPLETED-DATE                     
                                  DELIMITED BY SIZE                     
                                  INTO S-STATUS                         
                           END-STRING                                   
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       ELSE                                             
                           IF T1-NEW-CUST-IS-LL-FL (T1-INDEX) = 'Y'     
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNED OFF '              
                                      WS-COMPLETED-DATE                 
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                               MOVE SPACES TO S-STATUS                  
                               STRING 'PROPERTY MANAGER TURNED ON '     
                                      WS-COMPLETED-DATE                 
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                           ELSE                                         
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNED OFF '              
                                      WS-COMPLETED-DATE                 
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT  
                               MOVE SPACES TO S-STATUS                  
                               STRING 'TENANT TURNED ON '               
                                      WS-COMPLETED-DATE                 
                                      DELIMITED BY SIZE                 
                                      INTO S-STATUS                     
                               END-STRING                               
                               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
                           END-IF
                       END-IF
                   END-IF
               END-IF
           END-IF. 
                                                                        
      *  OFF ORDERS                                                             
                                                                        
           IF T1-ORDER-TYPE-CD (T1-INDEX) (1:3) = 'OFF'                 
               IF T1-OLD-CUST-IS-LL-FL (T1-INDEX) = 'Y'                 
                   MOVE SPACES TO S-STATUS                              
                   STRING 'PROPERTY MANAGER TURNED OFF '                
                          WS-COMPLETED-DATE                             
                          DELIMITED BY SIZE                             
                          INTO S-STATUS                                 
                   END-STRING                                           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
               ELSE                                                     
                   MOVE SPACES TO S-STATUS                              
                   STRING 'TENANT TURNED OFF '                          
                          WS-COMPLETED-DATE                             
                          DELIMITED BY SIZE                             
                          INTO S-STATUS                                 
                   END-STRING                                           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.             
                                                                        
      *  DNPFB ORDERS                                                           
                                                                        
           IF T1-ORDER-TYPE-CD (T1-INDEX) = 'DNPFB'                     
              PERFORM 7600-DNP01 THRU 7600-EXIT                         
              IF WS-DNP01-TS > SPACES                                   
                  MOVE SPACES TO S-STATUS                               
                  STRING 'SERVICE TURNED OFF '                          
                         WS-DNP01-DATE                                  
                         DELIMITED BY SIZE                              
                         INTO S-STATUS                                  
                  END-STRING                                            
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT               
              END-IF                                                    
              MOVE SPACES TO S-STATUS                                   
              STRING 'ACCOUNT FINAL BILLED '                            
                     WS-COMPLETED-DATE                                  
                     DELIMITED BY SIZE                                  
                     INTO S-STATUS                                      
              END-STRING                                                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       1420-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
               SELECT LANDLORD_REVERT_FL                                
                 INTO :CU-LANDLORD-REVERT-FL                            
                 FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
                WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LANDLORD_REVERT_FL                                        
MFA-TR*          INTO :CU-LANDLORD-REVERT-FL                                    
MFA-TR*          FROM CSS_CUSTOMER                                              
MFA-TR*         WHERE CUSTOMER_NO = :SI-CUSTOMER-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_CUSTOMER'          TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE SI-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-LL-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN LANDLORD-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_LANDLORD'          TO TABLE-1                  
               MOVE 'CSS_PREMISE'           TO TABLE-2                  
               MOVE 'CSS_SUBDIVISION'       TO TABLE-3                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE SI-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-LL-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE LANDLORD-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_LANDLORD'          TO TABLE-1                  
               MOVE 'CSS_PREMISE'           TO TABLE-2                  
               MOVE 'CSS_SUBDIVISION'       TO TABLE-3                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE SI-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-OPEN-SO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN SO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7040'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE SI-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-CLOSE-SO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE SO-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7050'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE SI-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SERVICE-ADDRESS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_SUFFIX,                                    
                      ADDR_SUFFIX,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      TOWN,                                             
                      STATE,                                            
                      DY.ZIP_CODE,                                      
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           ))))))                                         
                 INTO :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :A4-TOWN,                                         
                      :A4-STATE,                                        
                      :DY-ZIP-CODE,                                     
                      :WS-ADDRESS-LINE                                  
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
                WHERE ADDRESS_ID = :PR-ADDRESS-ID                       
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE,                                                    
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||                  
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)                            
MFA-TR*               )))))))))                                                 
MFA-TR*          INTO :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :A4-TOWN,                                                 
MFA-TR*               :A4-STATE,                                                
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :WS-ADDRESS-LINE                                          
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4                                           
MFA-TR*         WHERE ADDRESS_ID = :PR-ADDRESS-ID                               
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ADDR_FORMATTED'    TO TABLE-1                  
               MOVE 'ADDRESS_ID'            TO TABLE-ELEMENT-1          
               MOVE DY-ADDRESS-ID           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CODE_ACCT_STAT,                                   
                      CUSTOMER_NO,                                      
                      MST_SUB_ACCT_IND                                  
                 INTO :AT-CODE-ACCT-STAT,                               
                      :AT-CUSTOMER-NO,                                  
                      :AT-MST-SUB-ACCT-IND                              
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_ACCT_STAT,                                           
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               MST_SUB_ACCT_IND                                          
MFA-TR*          INTO :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-MST-SUB-ACCT-IND                                      
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   PERFORM 7300-SELECT-HST-ACCOUNT THRU 7300-EXIT       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                                   ABEND-TABLES         
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-HST-ACCOUNT.                                         
                                                                        
           EXEC SQL                                                     
               SELECT CODE_ACCT_STAT,                                   
                      CUSTOMER_NO,                                      
                      ' '                                               
                 INTO :AT-CODE-ACCT-STAT,                               
                      :AT-CUSTOMER-NO,                                  
                      :AT-MST-SUB-ACCT-IND                              
                 FROM HST_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_ACCT_STAT,                                           
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               ' '                                                       
MFA-TR*          INTO :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-MST-SUB-ACCT-IND                                      
MFA-TR*          FROM HST_ACCOUNT AT                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'HST_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-RELEASE-IND.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VI-SERV-ORDER-NO                                 
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
                  AND HOLD_RELEASE = 'Y'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VI-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                        
MFA-TR*           AND HOLD_RELEASE = 'Y'                                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO T1-RELEASE-IND (T1-INDEX)                
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO T1-RELEASE-IND (T1-INDEX)                
                   MOVE ZEROES TO SQLCODE                               
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7400'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE VO-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-WORK-TYPE.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VI-SERV-ORDER-NO                                 
                 FROM CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
P01176            AND WORK_TYPE_CD IN ('UNB', 'SOL', 'SOS',             
P01176                                 'SOR', 'MCU')                    
                  AND NOT EXISTS (                                      
                    SELECT '1'                                          
                      FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)              
                     WHERE SERV_ORDER_NO = OI.SERV_ORDER_NO             
                       AND WORK_TYPE_CD = 'RDO')                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VI-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_ORDER_INST OI                                      
MFA-TR*         WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                        
MFA-TR*           AND WORK_TYPE_CD IN ('UNB', 'SOL', 'SOS',                     
MFA-TR*                                'SOR', 'MCU')                            
MFA-TR*           AND NOT EXISTS (                                              
MFA-TR*             SELECT '1'                                                  
MFA-TR*               FROM CSS_SO_ORDER_INST                                    
MFA-TR*              WHERE SERV_ORDER_NO = OI.SERV_ORDER_NO                     
MFA-TR*                AND WORK_TYPE_CD = 'RDO')                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO T1-UNBLOCK-FL (T1-INDEX)                 
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO T1-UNBLOCK-FL (T1-INDEX)                 
                   MOVE ZEROES TO SQLCODE                               
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7500'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE VO-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-DNP01.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME                                
                 INTO :WS-DNP01-TS                                      
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_ORDER_INST OI WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :SI-PREMISE-NO                       
                  AND ORDER_TYPE_CD = 'DNP01'                           
                  AND ORDER_STATE_CD = 'Z'                              
                  AND VO.SERV_ORDER_NO = OI.SERV_ORDER_NO               
P01176            AND WORK_TYPE_CD IN ('CAT', 'RMM', 'DNP', 'RMT')      
                ORDER BY COMPLETED_DATETIME DESC                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPLETED_DATETIME                                        
MFA-TR*          INTO :WS-DNP01-TS                                              
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_ORDER_INST OI                                      
MFA-TR*         WHERE PREMISE_NO = :SI-PREMISE-NO                               
MFA-TR*           AND ORDER_TYPE_CD = 'DNP01'                                   
MFA-TR*           AND ORDER_STATE_CD = 'Z'                                      
MFA-TR*           AND VO.SERV_ORDER_NO = OI.SERV_ORDER_NO                       
MFA-TR*           AND WORK_TYPE_CD IN ('CAT', 'RMM', 'DNP', 'RMT')              
MFA-TR*         ORDER BY COMPLETED_DATETIME DESC                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-DNP01-TS (1:4) TO WS-YYYY                    
                   MOVE WS-DNP01-TS (6:2) TO WS-MM                      
                   MOVE WS-DNP01-TS (9:2) TO WS-DD                      
                   MOVE WS-FORMAT-DATE TO WS-DNP01-DATE                 
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-DNP01-TS                           
                   MOVE ZEROES TO SQLCODE                               
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7600'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE SI-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-ONLY-DNPFB.                                                 
                                                                        
           MOVE 'N' TO WS-NON-DNPFB-FL.                                 
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-NON-DNPFB-FL                                  
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :VO-PREMISE-NO                       
                  AND ORDER_TYPE_CD IN ('OFF01', 'OFF02', 'OFF03',      
                                        'CC001', 'CC002', 'CC003',      
                                        'NC001')                        
                  AND ORDER_STATE_CD <> 'C'                             
                  AND BACK_DATED_IND <> 'Y'                             
                  AND (COMPLETED_DATETIME IS NULL                       
                   OR      COMPLETED_DATETIME >=                        
                       CIS.CHAR2TIMESTAMP(:WS-TS-MINUS-30-DAYS))                
A04558                                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-NON-DNPFB-FL                                          
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO = :VO-PREMISE-NO                               
MFA-TR*           AND ORDER_TYPE_CD IN ('OFF01', 'OFF02', 'OFF03',              
MFA-TR*                                 'CC001', 'CC002', 'CC003',              
MFA-TR*                                 'NC001')                                
MFA-TR*           AND ORDER_STATE_CD = 'C'                                     
MFA-TR*           AND BACK_DATED_IND = 'Y'                                     
MFA-TR*           AND (COMPLETED_DATETIME IS NULL                               
MFA-TR*            OR      COMPLETED_DATETIME >=                                
MFA-TR*                :WS-TS-MINUS-30-DAYS)                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO SQLCODE                               
                                  WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-NON-DNPFB-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7700'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE SI-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-MST-ACCOUNT.                                                
                                                                        
           EXEC SQL                                                     
               SELECT MST_ACCT_NO                                       
                 INTO :MU-MST-ACCT-NO                                   
                 FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                     
                WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MST_ACCT_NO                                               
MFA-TR*          INTO :MU-MST-ACCT-NO                                           
MFA-TR*          FROM CSS_MSTSUB_ACCT                                           
MFA-TR*         WHERE SUB_ACCT_NO = :AT-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  MOVE MU-MST-ACCT-NO TO WS-ACCOUNT-NO-NUM              
                  MOVE WS-ACCOUNT-NO-CHAR TO S-MST-ACCOUNT-NO           
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO SQLCODE                               
                                  WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO S-MST-ACCOUNT-NO                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7800'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_MSTSUB_ACCT'  TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04338_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04338_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04338_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04338_R1                            
             (                                                          
              RETURN_CODE,                                              
              PREMISE_NO,                                               
              SERV_ADDRESS,                                             
              HOUSE_NO,                                                 
              ADDR_PREFIX_1,                                            
              ADDR_PREFIX_2,                                            
              STREET_NAME,                                              
              STREET_SUFFIX,                                            
              ADDR_SUFFIX,                                              
              STREET_LOCATION_1,                                        
              STREET_LOCATION_2,                                        
              TOWN,                                                     
              STATE,                                                    
              ZIP_CODE,                                                 
              COMPLEX_NAME,                                             
              ACCOUNT_HOLDER,                                           
              ACCOUNT_NO,                                               
              STATUS,                                                   
              STATE_REMARKS,                                            
              REVERT_FL,                                                
              REVERT_ELIG_FL,                                           
              ONLINE_ELIG_FL,                                           
              MST_SUB_FL,                                               
              COMPANY_NO,                                               
              MST_ACCOUNT_NO                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-PREMISE-NO,                                           
               :S-SERV-ADDRESS,                                         
               :S-HOUSE-NO,                                             
               :S-ADDR-PREFIX-1,                                        
               :S-ADDR-PREFIX-2,                                        
               :S-STREET-NAME,                                          
               :S-STREET-SUFFIX,                                        
               :S-ADDR-SUFFIX,                                          
               :S-STREET-LOCATION-1,                                    
               :S-STREET-LOCATION-2,                                    
               :S-TOWN,                                                 
               :S-STATE,                                                
               :S-ZIP-CODE,                                             
               :S-COMPLEX-NAME,                                         
               :S-ACCOUNT-HOLDER,                                       
               :S-ACCOUNT-NO,                                           
               :S-STATUS,                                               
               :S-STATE-REMARKS,                                        
               :S-REVERT-FL,                                            
               :S-REVERT-ELIG-FL,                                       
               :S-ONLINE-ELIG-FL,                                       
               :S-MST-SUB-FL,                                           
               :S-COMPANY-NO,                                           
               :S-MST-ACCOUNT-NO                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04338_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PREMISE_NO,                                                       
MFA-TR*       SERV_ADDRESS,                                                     
MFA-TR*       HOUSE_NO,                                                         
MFA-TR*       ADDR_PREFIX_1,                                                    
MFA-TR*       ADDR_PREFIX_2,                                                    
MFA-TR*       STREET_NAME,                                                      
MFA-TR*       STREET_SUFFIX,                                                    
MFA-TR*       ADDR_SUFFIX,                                                      
MFA-TR*       STREET_LOCATION_1,                                                
MFA-TR*       STREET_LOCATION_2,                                                
MFA-TR*       TOWN,                                                             
MFA-TR*       STATE,                                                            
MFA-TR*       ZIP_CODE,                                                         
MFA-TR*       COMPLEX_NAME,                                                     
MFA-TR*       ACCOUNT_HOLDER,                                                   
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       STATUS,                                                           
MFA-TR*       STATE_REMARKS,                                                    
MFA-TR*       REVERT_FL,                                                        
MFA-TR*       REVERT_ELIG_FL,                                                   
MFA-TR*       ONLINE_ELIG_FL,                                                   
MFA-TR*       MST_SUB_FL,                                                       
MFA-TR*       COMPANY_NO,                                                       
MFA-TR*       MST_ACCOUNT_NO                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-PREMISE-NO,                                                   
MFA-TR*        :S-SERV-ADDRESS,                                                 
MFA-TR*        :S-HOUSE-NO,                                                     
MFA-TR*        :S-ADDR-PREFIX-1,                                                
MFA-TR*        :S-ADDR-PREFIX-2,                                                
MFA-TR*        :S-STREET-NAME,                                                  
MFA-TR*        :S-STREET-SUFFIX,                                                
MFA-TR*        :S-ADDR-SUFFIX,                                                  
MFA-TR*        :S-STREET-LOCATION-1,                                            
MFA-TR*        :S-STREET-LOCATION-2,                                            
MFA-TR*        :S-TOWN,                                                         
MFA-TR*        :S-STATE,                                                        
MFA-TR*        :S-ZIP-CODE,                                                     
MFA-TR*        :S-COMPLEX-NAME,                                                 
MFA-TR*        :S-ACCOUNT-HOLDER,                                               
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-STATUS,                                                       
MFA-TR*        :S-STATE-REMARKS,                                                
MFA-TR*        :S-REVERT-FL,                                                    
MFA-TR*        :S-REVERT-ELIG-FL,                                               
MFA-TR*        :S-ONLINE-ELIG-FL,                                               
MFA-TR*        :S-MST-SUB-FL,                                                   
MFA-TR*        :S-COMPANY-NO,                                                   
MFA-TR*        :S-MST-ACCOUNT-NO                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04338_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
