       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04333.                                     
COB303 DATE-WRITTEN.  FEB  24, 2010                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM ADDS REVENUE PROTECTION CHARGES TO AN ACCOUNT AND*00190000
      *  CREATES DFA'S FROM THOSE CHARGES. THIS PROGRAM IS CALLED FROM *00190000
      *  CSR04332(PANEL161).                                           *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
P00253*  02/24/10  SP95538    PROCEDURE ORIGINALLY CODED.              *00280000
P00253*  07/15/10  AA97148    USE NEW APPL PGM ID FOR REV PROTECTION   *        
P00253*                       NORMAL AND DOWN PAYMNET DAF'S.           *        
P00793*  02/26/14  VENKAT     - DELETE UTG/UTE DFA'S ADDED ON BBP ACCT.*        
P00793*            PONNEKANTI - ADD CHARGE                             *        
ACT205*  06/29/16  TP7R341    - REPLACE COMP VARIABLES WITH COMP-3     *        
ACT205*  07/05/16  VENKAT.P   - ADD USER ID TO CSR02350 CALL           *        
ACT205*                       - RETURN SQLCODE WHEN CALL FAILED        *        
ACT205*                       - APPL*5460                              *        
      *                                                                *00250000
      ******************************************************************00473200
      ******************************************************************00473300
      *                                                                *00473400
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00473500
      *                                                                *00473600
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00473700
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00473800
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00473900
      *  3000 - 4999  NOT USED                                         *00474000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00474100
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00475000
      *  7000 - 7999  INPUT MODULES                                    *00476000
      *  8000 - 8999  OUTPUT MODULES                                   *00477000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00478000
      *                                                                *00479000
      ******************************************************************00480000
      *                                                                 00490000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00490000
       DATA DIVISION.                                                   
      *                                                                 00490000
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04333'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04333 STARTS HERE'.                  
      *                                                                 00560000
       01 WS-MISC.                                                      
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR04333'.     
P00253    05  WS-SUBROUTINE-IDS.                                        
P00253        10  CSR02350              PIC X(8) VALUE 'CSR02350'.      
P00253        10  CSR02084              PIC X(8) VALUE 'CSR02084'.      
P00253        10  CSR02083              PIC X(8) VALUE 'CSR02083'.      
          05 WS-CHARGE.                                                 
             10 WS-RECV-TYPE           PIC X(03).                       
             10 WS-ITEM-ID             PIC X(09).                       
             10 WS-AMT-DIR-PYMT        PIC X(11).                       
             10 WS-AMT-DIR-PYMT-NUM    REDEFINES WS-AMT-DIR-PYMT        
                                       PIC S9(09)V99.                   
             10 WS-INPUT-GL-NO         PIC X(07).                       
             10 WS-INPUT-GL-NO-NUM     REDEFINES WS-INPUT-GL-NO         
                                       PIC S999V9999.                   
             10 WS-CNT-PAY-AHEAD       PIC X(01).                       
P00253    05 WS-COMMENT-TEXT1          PIC X(256) VALUE SPACES.         
P00253    05 WS-COMMENT-TEXT2          PIC X(256) VALUE SPACES.         
P00253    05 WS-COMMENT-TEXT3          PIC X(256) VALUE SPACES.         
      * REDEFINES VARIABLES                                                     
          05 WS-ACCOUNT                PIC X(13).                       
          05 WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT                        
                                       PIC 9(13).                       
          05 WS-ACCOUNT-NO             PIC S9(13)V USAGE COMP-3         
                                                   VALUE +0.            
          05 WS-GL-ACCOUNT-NO          PIC 9(03)V9(4).                  
          05 WS-GL-ACCT-NO REDEFINES WS-GL-ACCOUNT-NO                   
                                       PIC X(07).                       
          05 WS-COLLECT-AMT            PIC 9(09)V9(2).                  
          05 WS-COLLECTIBLE-AM REDEFINES WS-COLLECT-AMT                 
                                       PIC X(11).                       
          05 WS-DOWN-PYMT-AMT          PIC 9(09)V9(2).                  
          05 WS-AMT-DOWN-PYMT REDEFINES WS-DOWN-PYMT-AMT                
                                       PIC X(11).                       
          05 WS-AMT-MO-PYMT1           PIC 9(07)V99.                    
          05 WS-AMT-MO-PYMT REDEFINES WS-AMT-MO-PYMT1                   
                                       PIC X(09).                       
          05 WS-DFA-RECV-AMT1          PIC X(11).                       
          05 WS-DFA-RECV-AMT REDEFINES WS-DFA-RECV-AMT1                 
                                       PIC 9(09)V9(2).                  
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                  PIC S9(9) COMP VALUE 0.          
                                                                        
       01 FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.       
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) COMP VALUE +0.        
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 ALL-DONE-SW               PIC X(01) VALUE 'N'.             
             88 NOT-ALL-DONE                     VALUE 'N'.             
             88 ALL-DONE                         VALUE 'Y'.             
          05 SEND-DONE-SW              PIC X(01) VALUE 'Y'.             
             88 SEND-DONE-ERROR                  VALUE 'N'.             
             88 SEND-DONE-OK                     VALUE 'Y'.             
P00793    05 WS-BBP-FLG                PIC X(01) VALUE ' '.             
P00793       88 BBP-FLG-YES                      VALUE 'A'.             
P00793       88 BBP-FLG-NO                       VALUE ' '.             
      * INPUT PARM VALUES                                               02260000
       01 WS-RECV-PARM.                                                 
          05 WS-COMPANY-NO             PIC  X(2)  VALUE SPACES.         
          05 WS-CASE-TYPE-CD           PIC  X(1)  VALUE SPACES.         
          05 WS-REV-PROT-CASE-NO       PIC  X(10) VALUE SPACES.         
          05 WS-CONSUMPT-TYPE-CD       PIC  X(01) VALUE SPACES.         
          05 WS-CASE-SEQ-NO            PIC  S9(4) USAGE COMP VALUE +0.  
          05 WS-MST-SUB-ACCT-IND       PIC  X(01) VALUE SPACES.         
          05 WS-CODE-ACCT-STATUS       PIC  X(01) VALUE SPACES.         
COB305    05 WS-COLLECTIBLE-AM1        PIC  S9(09)V9(2) USAGE COMP-3 
COB305       VALUE 0.   
COB305    05 WS-AMT-DOWN-PYMT1        PIC  S9(09)V9(2) USAGE COMP-3 
COB305       VALUE 0.   
COB305    05 WS-TOTAL-AR-BALANCE        PIC  S9(09)V9(2) USAGE COMP-3 
COB305       VALUE 0.   
          05 WS-TOT-AR-BALANCE         PIC  9(09)V9(2).                 
          05 WS-START-DT               PIC  X(10) VALUE SPACES.         
          05 WS-USER-ID                PIC  X(07) VALUE SPACES.         
          05 WS-PYMT-START-DT          PIC  X(10) VALUE SPACES.         
          05 WS-AMT-MO-COLLECT-PYMT    PIC  X(9)  VALUE SPACES.         
          05 WS-AMT-MO-DOWN-PYMT       PIC  X(9)  VALUE SPACES.         
      * CSR02350 PARM AREA                                             *        
       01 WS-CSR02350-PARMS.                                            
          05 WS-ACCOUNT-NO-2350        PIC X(13) VALUE SPACES.          
          05 WS-CIA-DEBIT-AMT-2350     PIC X(11) VALUE SPACES.          
          05 WS-GL-ACCT-NO-2350        PIC X(07) VALUE SPACES.          
          05 WS-NO-ROWS-2350           PIC S9(4) USAGE COMP.            
          05 WS-DIR-PAY-1-2350         PIC X(31) VALUE SPACES.          
          05 WS-ACCTING-PERIOD-2350    PIC X(06) VALUE SPACES.          
          05 WS-COMMENT-LEN-2350       PIC S9(4) USAGE COMP VALUE 0.    
          05 WS-COMMENT-TEXT-2350      PIC X(210) VALUE SPACES.         
          05 WS-LAST-UPDATE-TS-2350    PIC X(26) VALUE SPACES.          
ACT205    05 WS-LAST-UPDATE-ID-2350    PIC X(07) VALUE SPACES.          
      * CSR02350 RETURN AREA                                                    
       01 WS-CSR02350-RET-DATA.                                         
          05 WS-RETURN-CODE-2350       PIC S9(9) COMP VALUE 0.          
          05 WS-ERROR-MSG1-2350        PIC X(05) VALUE SPACES.          
          05 WS-ERROR-MSG2-2350        PIC X(05) VALUE SPACES.          
          05 WS-ERROR-MSG3-2350        PIC X(05) VALUE SPACES.          
      * CSR02083 PARM AREA                                                      
       01 WS-CSR02083-PARM-AREA.                                        
          05 WS-ACCOUNT-NO-2083        PIC X(13) VALUE SPACES.          
          05 WS-DFA-TYPE-2083          PIC X(01) VALUE SPACES.          
          05 WS-NEW-FLAG-2083          PIC X(01) VALUE SPACES.          
      * CSR02083 RETURN AREA                                                    
       01 WS-CSR02083-RET-AREA.                                         
          05 WS-RETURN-CODE-2083       PIC S9(9) COMP VALUE 0.          
          05 WS-DFA-ITEM-ID-2083       PIC S9(9) COMP VALUE 0.          
          05 WS-REC-TYPE-2083          PIC X(03) VALUE SPACES.          
COB305    05 WS-CURRENT-CHARGES-2083        PIC S9(09)V9(2) 
COB305       USAGE COMP-3 VALUE 0.    
COB305    05 WS-ARREARS-2083        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
COB305    05 WS-BILLED-BALANCE-2083        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
COB305    05 WS-CONTRACT-AMT-2083        PIC S9(09)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
          05 WS-LAST-TS-2083           PIC X(26) VALUE SPACES.          
          05 WS-EDIT-FLAG-2083         PIC X(01) VALUE SPACES.          
          05 WS-DATE-PYMT-START1-2083  PIC X(10) VALUE SPACES.          
          05 WS-DATE-PYMT-START2-2083  PIC X(10) VALUE SPACES.          
COB305    05 WS-TOTAL-BILL-BAL-2083        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
          05 WS-RECV-DESC-2083         PIC X(25) VALUE SPACES.          
          05 WS-ITEM-ID-2083           PIC S9(4) USAGE COMP VALUE 0.    
COB305    05 WS-RECV-BALANCE-2083        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
      * CSR02084 PARM AREA                                                      
       01 WS-CSR02084-PARM-AREA.                                        
          05 WS-PANEL-NAME-2084        PIC  X(08) VALUE SPACES.         
          05 WS-ACCOUNT-NO-2084        PIC  X(13) VALUE SPACES.         
          05 WS-AGREEMENT-NO-2084      PIC  S9(09) COMP VALUE 0.        
          05 WS-DFA-TYPE-2084          PIC  X(1)  VALUE SPACES.         
          05 WS-DFA-STATUS-2084        PIC  X(1)  VALUE SPACES.         
          05 WS-USER-ID-2084           PIC  X(7)  VALUE SPACES.         
          05 WS-RESP-AREA-ID-2084      PIC  X(3)  VALUE SPACES.         
          05 WS-DFA-REASON-2084        PIC  X(1)  VALUE SPACES.         
          05 WS-DFA-CANCEL-RESN-2084   PIC  X(50) VALUE SPACES.         
          05 WS-AMT-MO-PYMT-2084       PIC  X(09) VALUE SPACES.         
          05 WS-PYMT-START-DATE-2084   PIC  X(10) VALUE SPACES.         
          05 WS-NO-PYMTS-2084          PIC  S9(04) COMP VALUE 0.        
          05 WS-AMT-ORIG-ENTERED-2084  PIC  X(11) VALUE SPACES.         
          05 WS-AMT-UNDEFER-RECV-2084  PIC  X(11) VALUE SPACES.         
          05 WS-DNP-DATE-2084          PIC  X(10) VALUE SPACES.         
          05 WS-AMT-EXTRA-DEPOSIT-2084 PIC  X(11) VALUE SPACES.         
          05 WS-1ST-ERNST-AMT-2084     PIC  X(11) VALUE SPACES.         
          05 WS-1ST-ERNST-DATE-2084    PIC  X(10) VALUE SPACES.         
          05 WS-2ND-ERNST-AMT-2084     PIC  X(11) VALUE SPACES.         
          05 WS-2ND-ERNST-DATE-2084    PIC  X(10) VALUE SPACES.         
          05 WS-DNP-MINUS1-2084        PIC  X(10) VALUE SPACES.         
          05 WS-DNP-MINUS-DELINQ-2084  PIC  X(10) VALUE SPACES.         
          05 WS-TRANS-COMMENTS-2084    PIC  X(255) VALUE SPACES.        
          05 WS-TRANS-CMTS-LEN-2084    PIC S9(04) COMP VALUE 0.         
          05 WS-PYMT-ARR-CMTS-2084     PIC  X(255) VALUE SPACES.        
          05 WS-PYMT-ARR-CMTS-LEN-2084 PIC  S9(04) COMP VALUE 0.        
          05 WS-DFA-TIMESTAMP-2084     PIC  X(26) VALUE SPACES.         
          05 WS-LAST-UPDATE-TS-2084    PIC  X(26) VALUE SPACES.         
          05 WS-DFA-RECV-1-2084        PIC  X(3)  VALUE SPACES.         
          05 WS-DFA-RECV-1-AMT-2084    PIC  X(11) VALUE SPACES.         
          05 WS-DFA-RECV-1-TS-2084     PIC  X(26) VALUE SPACES.         
          05 WS-DFA-RECV-1-ID-2084     PIC  X(9)  VALUE SPACES.         
      * CSR02084 RETURN AREA                                                    
       01 WS-CSR02084-RET-AREA.                                         
          05 WS-RETURN-CODE-2084       PIC S9(09) COMP VALUE +0.        
          05 WS-CANCELDNP-FLAG-2084    PIC X(01) VALUE SPACES.          
          05 WS-AR-LOCKOUT-IND-2084    PIC X(01) VALUE SPACES.          
          05 WS-ACCT-XFER-TO-2084      PIC X(13) VALUE SPACES.          
          05 WS-CANCELNOT-FLAG-2084    PIC X(01) VALUE SPACES.          
      * RESULT SET LOCATOR                                              00520000
      *01 LOC-RESLTSET USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.    
      *                                                                 00520000
      ******************************************************************00570000
      *               COBOL WORKING STORAGE COPY BOOKS                 *00580000
      ******************************************************************00590000
      *                                                                 03010800
      ******************************************************************12232440
      *    ERROR HANDLING                                               03010800
      ******************************************************************12232440
      *                                                                 03010800
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                 00520000
      ******************************************************************12232440
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *03011500
      ******************************************************************12232460
      *                                                                         
           COPY CWS00303.                                               00710000
                                                                        
      *                                                                 04091400
      ***************************************************************** 04091500
      *   SQL COMMUNICATION AREA                                      * 04091600
      ***************************************************************** 04091700
      *                                                                 04091800
           EXEC SQL                                                     04091900
              INCLUDE SQLCA                                             04092000
           END-EXEC.                                                    04093000
      *                                                                 04094000
      *****************************************************************         
      *    CSS_ACCOUNT -AT                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_AR_CNTL -AC                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_REV_CLS_RATE - Q8                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRVCLS                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_DFA_ACCT - DA                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_REV_PROTEC_HDR -R0                                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVPRT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_REV_PROTEC_DET -RL                                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVDET                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_USER_PROFILE -PF                                       *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE MISC_DEBT_CUR CURSOR
MSQ001          FOR CALL CSR02350( :WS-ACCOUNT-NO-2350
                  , :WS-CIA-DEBIT-AMT-2350
                  , :WS-GL-ACCT-NO-2350
                  , :WS-NO-ROWS-2350
                  , :WS-DIR-PAY-1-2350
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , :WS-ACCTING-PERIOD-2350
                  , :WS-COMMENT-LEN-2350
                  , :WS-COMMENT-TEXT-2350
                  , :WS-LAST-UPDATE-TS-2350
                  , :WS-LAST-UPDATE-ID-2350
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE DFA_ID_CUR CURSOR
MSQ001          FOR CALL CSR02083( :WS-ACCOUNT-NO-2083
                  , :WS-DFA-TYPE-2083
                  , :WS-NEW-FLAG-2083
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE DFA_AMT_CUR CURSOR
MSQ001          FOR CALL CSR02084( :WS-PANEL-NAME-2084
                  , :WS-ACCOUNT-NO-2084
                  , :WS-AGREEMENT-NO-2084
                  , :WS-DFA-TYPE-2084
                  , :WS-DFA-STATUS-2084
                  , :WS-USER-ID-2084
                  , :WS-RESP-AREA-ID-2084
                  , :WS-DFA-REASON-2084
                  , :WS-DFA-CANCEL-RESN-2084
                  , :WS-AMT-MO-PYMT-2084
                  , :WS-PYMT-START-DATE-2084
                  , :WS-NO-PYMTS-2084
                  , :WS-AMT-ORIG-ENTERED-2084
                  , :WS-AMT-UNDEFER-RECV-2084
                  , :WS-DNP-DATE-2084
                  , :WS-AMT-EXTRA-DEPOSIT-2084
                  , :WS-1ST-ERNST-AMT-2084
                  , :WS-1ST-ERNST-DATE-2084
                  , :WS-2ND-ERNST-AMT-2084
                  , :WS-2ND-ERNST-DATE-2084
                  , :WS-DNP-MINUS1-2084
                  , :WS-DNP-MINUS-DELINQ-2084
                  , :WS-TRANS-COMMENTS-2084
                  , :WS-TRANS-CMTS-LEN-2084
                  , :WS-PYMT-ARR-CMTS-2084
                  , :WS-PYMT-ARR-CMTS-LEN-2084
                  , :WS-DFA-TIMESTAMP-2084
                  , :WS-LAST-UPDATE-TS-2084
                  , :WS-DFA-RECV-1-2084
                  , :WS-DFA-RECV-1-AMT-2084
                  , :WS-DFA-RECV-1-TS-2084
                  , :WS-DFA-RECV-1-ID-2084
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  )
MSQ001        END-EXEC.
                         
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO               PIC  X(13).                    
       01  PARM-CASE-TYPE-CD             PIC  X(01).                    
       01  PARM-REV-PROT-CASE-NO         PIC  X(10).                    
       01  PARM-COMPANY-NO               PIC  X(2).                     
       01  PARM-CONSUMPT-TYPE-CD         PIC  X(1).                     
       01  PARM-CASE-SEQ-NO              PIC  S9(4) USAGE COMP.         
COB305 01 PARM-GL-ACCOUNT-NO        PIC  S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.  
       01  PARM-START-DT                 PIC  X(10).                    
       01  PARM-CODE-DFA-DESC            PIC  X(01).                    
       01  PARM-NO-SCHED-PYMTS           PIC  S9(4) USAGE COMP.         
COB305 01 PARM-COLLECT-AMT        PIC  S9(11)V9(2) USAGE COMP-3 VALUE 0. 
COB305 01 PARM-DOWN-PYMT-AMT        PIC  S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0. 
       01  PARM-CODE-ACCT-STATUS         PIC  X(01).                    
       01  PARM-REVENUE-MONTH            PIC  X(06).                    
       01  PARM-USER-ID                  PIC  X(07).                    
      *                                                                 05730900
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-CASE-TYPE-CD                       
                                PARM-REV-PROT-CASE-NO                   
                                PARM-COMPANY-NO                         
                                PARM-CONSUMPT-TYPE-CD                   
                                PARM-CASE-SEQ-NO                        
                                PARM-GL-ACCOUNT-NO                      
                                PARM-START-DT                           
                                PARM-CODE-DFA-DESC                      
                                PARM-NO-SCHED-PYMTS                     
                                PARM-COLLECT-AMT                        
                                PARM-DOWN-PYMT-AMT                      
                                PARM-CODE-ACCT-STATUS                   
                                PARM-REVENUE-MONTH                      
                                PARM-USER-ID.                           
      *                                                                         
      ******************************************************************05733000
      * 0000-MAINLINE                                                  *05734000
      ******************************************************************05736000
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT.                 
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 05760000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05800000
      ******************************************************************05810000
      * 0100-INITIALIZE                                                *05820000
      ******************************************************************05880000
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS  RETURN_CODE              
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06120000
      ******************************************************************06140000
      * 1000-PROCESS-INPUT.                                            *06150000
      ******************************************************************06190000
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT.                
           MOVE WS-ACCOUNT-DEC            TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO AT-ACCOUNT-NO              
                                             AC-ACCOUNT-NO              
                                             RL-ACCOUNT-NO.             
           MOVE WS-ACCOUNT                TO WS-ACCOUNT-NO-2083.        
           MOVE PARM-REV-PROT-CASE-NO     TO WS-REV-PROT-CASE-NO.       
           MOVE WS-REV-PROT-CASE-NO       TO RL-REV-PROT-CASE-NO.       
           MOVE PARM-CASE-TYPE-CD         TO WS-CASE-TYPE-CD.           
           MOVE PARM-COMPANY-NO           TO WS-COMPANY-NO.             
           MOVE PARM-CONSUMPT-TYPE-CD     TO WS-CONSUMPT-TYPE-CD.       
           MOVE WS-CONSUMPT-TYPE-CD       TO RL-CONSUMPT-TYPE-CD.       
           MOVE PARM-CASE-SEQ-NO          TO WS-CASE-SEQ-NO.            
           MOVE WS-CASE-SEQ-NO            TO RL-CASE-SEQ-NO.            
           MOVE PARM-GL-ACCOUNT-NO        TO WS-GL-ACCOUNT-NO.          
           MOVE PARM-USER-ID              TO WS-USER-ID.                
           MOVE WS-USER-ID                TO PF-USER-ID.                
           MOVE PARM-COLLECT-AMT          TO WS-COLLECTIBLE-AM1.        
           MOVE WS-COLLECTIBLE-AM1        TO WS-COLLECT-AMT.            
           MOVE PARM-DOWN-PYMT-AMT        TO WS-AMT-DOWN-PYMT1.         
           MOVE WS-AMT-DOWN-PYMT1         TO WS-DOWN-PYMT-AMT.          
           MOVE PARM-CODE-ACCT-STATUS     TO WS-CODE-ACCT-STATUS.       
           MOVE  'A'                      TO WS-DFA-TYPE-2083           
           MOVE  SPACES                   TO WS-NEW-FLAG-2083.          
      *                                                                         
           IF WS-CASE-TYPE-CD = 'E'                                     
              MOVE 'UTE'                  TO WS-RECV-TYPE               
              MOVE '1420300'              TO WS-INPUT-GL-NO             
              MOVE  40                    TO AC-PYMT-PRIORITY-LVL       
           ELSE                                                         
              MOVE 'UTG'                  TO WS-RECV-TYPE               
              MOVE '1420310'              TO WS-INPUT-GL-NO             
              MOVE  45                    TO AC-PYMT-PRIORITY-LVL       
           END-IF.                                                      
      *                                                                 04670100
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06250000
      ******************************************************************10556300
      * 2000-PROCESS-OUTPUT.                                           *10556400
      ******************************************************************10558000
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                 10559100
           PERFORM 7000-SELECT-ACCT           THRU 7000-EXIT            
           PERFORM 7008-SELECT-RESP-AREA      THRU 7008-EXIT            
           MOVE AT-MST-SUB-ACCT-IND       TO WS-MST-SUB-ACCT-IND        
           MOVE AT-TOTAL-AR-BALANCE       TO WS-TOTAL-AR-BALANCE        
           MOVE WS-TOTAL-AR-BALANCE       TO WS-TOT-AR-BALANCE          
           MOVE PF-RESP-AREA-ID           TO WS-RESP-AREA-ID-2084       
P00793* ADD CHARGE                                                              
P00793     IF WS-CASE-TYPE-CD = 'F'                                     
P00793        IF WS-COLLECT-AMT  > 0                                    
P00793           PERFORM 2700-ADD-CHARGE      THRU 2700-EXIT            
P00793        END-IF                                                    
P00793        GO TO 2000-EXIT                                           
P00793     END-IF.                                                      
      * FOR PENDING, FB AND W/O ACCOUNTS ONLY MISC DR REQUIRED. ACTIVE          
      * ACCOUNTS REQUIRED MISC DR& CREATE DFA'S FOR CHARGES                     
           IF (WS-CODE-ACCT-STATUS = 'B' OR 'S' OR 'P') OR              
               WS-MST-SUB-ACCT-IND = 'M'                                
              PERFORM 2200-PROCESS-MISC-DEBIT THRU 2200-EXIT            
           ELSE                                                         
              PERFORM 2300-PROCESS-DFA        THRU 2300-EXIT            
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670000
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           ADD +1                      TO CTR-ROWS.                     
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-MOVE-MISC-DR-VALS.                                         *        
      ******************************************************************        
      *                                                                         
       2100-MOVE-MISC-DR-VALS.                                          
      *                                                                         
P00253     INITIALIZE WS-COMMENT-TEXT1.                                 
           MOVE WS-ACCOUNT                TO WS-ACCOUNT-NO-2350.        
           MOVE WS-GL-ACCT-NO             TO WS-GL-ACCT-NO-2350.        
           MOVE PARM-REVENUE-MONTH        TO WS-ACCTING-PERIOD-2350.    
           MOVE   1                       TO WS-NO-ROWS-2350.           
           MOVE '00000000000'             TO WS-CIA-DEBIT-AMT-2350.     
           MOVE AT-LAST-UPDATE-TS         TO WS-LAST-UPDATE-TS-2350     
ACT205     MOVE PARM-USER-ID              TO WS-LAST-UPDATE-ID-2350     
           MOVE ZEROES                    TO WS-ITEM-ID.                
           MOVE SPACES                    TO WS-CNT-PAY-AHEAD.          
           MOVE ZEROES                    TO AC-ITEM-ID.                
      *                                                                         
P00253     EVALUATE WS-CONSUMPT-TYPE-CD                                 
P00253       WHEN 'B'                                                   
P00253          MOVE 'REVENUE PROTECTION ELEC UTILITY CHARGES'          
P00253                                    TO WS-COMMENT-TEXT1           
P00253          MOVE +39                  TO WS-COMMENT-LEN-2350        
P00253       WHEN 'J'                                                   
P00253          MOVE 'REVENUE PROTECTION KW UTILITY CHARGES'            
P00253                                    TO WS-COMMENT-TEXT1           
P00253          MOVE +37                  TO WS-COMMENT-LEN-2350        
P00253       WHEN 'E'                                                   
P00253          MOVE 'REVENUE PROTECTION KVA UTILITY CHARGES'           
P00253                                    TO WS-COMMENT-TEXT1           
P00253          MOVE +38                  TO WS-COMMENT-LEN-2350        
P00253       WHEN 'C'                                                   
P00253          MOVE 'REVENUE PROTECTION GAS UTILITY CHARGES'           
P00253                                    TO WS-COMMENT-TEXT1           
P00253          MOVE +38                  TO WS-COMMENT-LEN-2350        
P00253       WHEN OTHER                                                 
P00253          CONTINUE                                                
P00253     END-EVALUATE                                                 
P00253*                                                                         
P00253     MOVE WS-COMMENT-TEXT1          TO WS-COMMENT-TEXT-2350.      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2150-MOVE-DFA-VALUES.                                           *        
      ******************************************************************        
      *                                                                         
       2150-MOVE-DFA-VALUES.                                            
      *                                                                         
           MOVE WS-ACCOUNT                TO WS-ACCOUNT-NO-2084.        
           MOVE PARM-START-DT             TO WS-START-DT.               
           MOVE PARM-CODE-DFA-DESC        TO WS-DFA-REASON-2084.        
           MOVE PARM-NO-SCHED-PYMTS       TO WS-NO-PYMTS-2084.          
           MOVE WS-USER-ID                TO WS-USER-ID-2084.           
           MOVE  'N'                      TO WS-DFA-STATUS-2084.        
           MOVE  'A'                      TO WS-DFA-TYPE-2084.          
           STRING WS-START-DT(6:2)                                      
                  '-'                                                   
                  WS-START-DT(9:2)                                      
                  '-'                                                   
                  WS-START-DT(1:4)                                      
           DELIMITED BY SIZE INTO WS-PYMT-START-DT.                     
           MOVE WS-PYMT-START-DT          TO WS-PYMT-START-DATE-2084    
           MOVE WS-RECV-TYPE              TO WS-DFA-RECV-1-2084.        
           DIVIDE WS-COLLECT-AMT BY WS-NO-PYMTS-2084                    
           GIVING WS-AMT-MO-PYMT1                                       
           MOVE WS-AMT-MO-PYMT            TO WS-AMT-MO-COLLECT-PYMT     
           MOVE WS-DOWN-PYMT-AMT          TO WS-AMT-MO-PYMT1.           
           MOVE WS-AMT-MO-PYMT            TO WS-AMT-MO-DOWN-PYMT.       
           MOVE AT-LAST-UPDATE-TS         TO WS-LAST-UPDATE-TS-2084     
           MOVE AC-LAST-UPDATE-TS         TO WS-DFA-RECV-1-TS-2084      
           MOVE WS-DFA-ITEM-ID-2083       TO WS-AGREEMENT-NO-2084.      
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************11690000
      * 2200-PROCESS-MISC-DEBIT.                                       *11700000
      ******************************************************************11750000
      *                                                                 11751000
       2200-PROCESS-MISC-DEBIT.                                         
      *                                                                 11770000
           EVALUATE WS-CONSUMPT-TYPE-CD                                 
              WHEN 'B'                                                  
              WHEN 'J'                                                  
              WHEN 'E'                                                  
              WHEN 'C'                                                  
                    PERFORM 2400-CREATE-MISC-DR THRU 2400-EXIT          
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 12820000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************11690000
      * 2300-PROCESS-DFA.                                              *11700000
      ******************************************************************11750000
      *                                                                 11751000
       2300-PROCESS-DFA.                                                
      *                                                                 11770000
           EVALUATE WS-CONSUMPT-TYPE-CD                                 
              WHEN 'B'                                                  
              WHEN 'J'                                                  
              WHEN 'E'                                                  
              WHEN 'C'                                                  
                    PERFORM 2500-GENERATE-DFA  THRU 2500-EXIT           
              WHEN OTHER                                                
                   CONTINUE                                             
           END-EVALUATE.                                                
      *                                                                 12820000
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2400-CREATE-MISC-DR.                                            *        
      * ISSUES MISC DEBIT.                                             *        
      ******************************************************************        
       2400-CREATE-MISC-DR.                                             
      *                                                                         
           IF WS-COLLECT-AMT >0                                         
              PERFORM 7000-SELECT-ACCT       THRU 7000-EXIT             
              PERFORM 2100-MOVE-MISC-DR-VALS THRU 2100-EXIT             
              MOVE WS-COLLECTIBLE-AM         TO WS-AMT-DIR-PYMT         
              MOVE WS-CHARGE                 TO WS-DIR-PAY-1-2350       
              PERFORM 7010-CALL-CSR02350     THRU 7010-EXIT             
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2500-GENERATE-DFA.                                              *        
      *    GENERATE DFA'S & MISC DEBIT.                                *        
      ******************************************************************        
      *                                                                         
       2500-GENERATE-DFA.                                               
      *                                                                         
           IF WS-COLLECT-AMT  >0                                        
P00253        INITIALIZE WS-COMMENT-TEXT2                               
              MOVE WS-COLLECTIBLE-AM      TO WS-AMT-ORIG-ENTERED-2084   
                                             WS-DFA-RECV-1-AMT-2084     
              MOVE WS-COLLECTIBLE-AM      TO WS-AMT-DIR-PYMT            
              MOVE WS-CHARGE              TO WS-DIR-PAY-1-2350          
              PERFORM 2600-PROCESS-MISC-DR    THRU 2600-EXIT            
              MOVE WS-AMT-MO-COLLECT-PYMT TO WS-AMT-MO-PYMT-2084        
P00253*                                                                         
P00253        EVALUATE WS-CONSUMPT-TYPE-CD                              
P00253          WHEN 'B'                                                
P00253             MOVE 'PANL161A'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION ELEC UTILITY DFA'           
P00253                                    TO WS-COMMENT-TEXT2           
P00253             MOVE +35               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN 'J'                                                
P00253             MOVE 'PANL161B'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION KW UTILITY DFA'             
P00253                                    TO WS-COMMENT-TEXT2           
P00253             MOVE +33               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN 'E'                                                
P00253             MOVE 'PANL161C'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION KVA UTILITY DFA'            
P00253                                    TO WS-COMMENT-TEXT2           
P00253             MOVE +34               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN 'C'                                                
P00253             MOVE 'PANL161D'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION GAS UTILITY DFA'            
P00253                                    TO WS-COMMENT-TEXT2           
P00253             MOVE +34               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN OTHER                                              
P00253             CONTINUE                                             
P00253        END-EVALUATE                                              
P00253*                                                                         
P00253        MOVE WS-COMMENT-TEXT2       TO WS-TRANS-COMMENTS-2084     
P00253                                       WS-PYMT-ARR-CMTS-2084      
P00253*                                                                         
              PERFORM 7030-CALL-CSR02084      THRU 7030-EXIT            
              MOVE WS-AGREEMENT-NO-2084   TO RL-DFA-ITEM-ID             
              PERFORM 8000-UPDATE-DFA-ID      THRU 8000-EXIT            
           END-IF                                                       
           IF WS-DOWN-PYMT-AMT >0                                       
P00253        INITIALIZE WS-COMMENT-TEXT3                               
              MOVE  ZERO                  TO WS-AMT-ORIG-ENTERED-2084   
              MOVE WS-AMT-DOWN-PYMT       TO WS-AMT-ORIG-ENTERED-2084   
                                             WS-DFA-RECV-1-AMT-2084     
              MOVE WS-AMT-DOWN-PYMT       TO WS-AMT-DIR-PYMT            
              MOVE WS-CHARGE              TO WS-DIR-PAY-1-2350          
              PERFORM 2600-PROCESS-MISC-DR    THRU 2600-EXIT            
              MOVE ZEROES                 TO WS-AMT-MO-PYMT-2084        
              MOVE WS-AMT-MO-DOWN-PYMT    TO WS-AMT-MO-PYMT-2084        
              MOVE  1                     TO WS-NO-PYMTS-2084           
P00253*                                                                         
P00253        EVALUATE WS-CONSUMPT-TYPE-CD                              
P00253          WHEN 'B'                                                
P00253             MOVE 'PANL161E'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION ELEC DOWN PAYMENT DFA'      
P00253                                    TO WS-COMMENT-TEXT3           
P00253             MOVE +40               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN 'J'                                                
P00253             MOVE 'PANL161F'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION KW DOWN PAYMENT DFA'        
P00253                                    TO WS-COMMENT-TEXT3           
P00253             MOVE +38               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN 'E'                                                
P00253             MOVE 'PANL161G'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION KVA DOWN PAYMENT DFA'       
P00253                                    TO WS-COMMENT-TEXT3           
P00253             MOVE +39               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN 'C'                                                
P00253             MOVE 'PANL161H'        TO WS-PANEL-NAME-2084         
P00253             MOVE 'REVENUE PROTECTION GAS DOWN PAYMENT DFA'       
P00253                                    TO WS-COMMENT-TEXT3           
P00253             MOVE +39               TO WS-TRANS-CMTS-LEN-2084     
P00253                                       WS-PYMT-ARR-CMTS-LEN-2084  
P00253          WHEN OTHER                                              
P00253             CONTINUE                                             
P00253        END-EVALUATE                                              
P00253*                                                                         
P00253        MOVE WS-COMMENT-TEXT3       TO WS-TRANS-COMMENTS-2084     
P00253                                       WS-PYMT-ARR-CMTS-2084      
P00253*                                                                         
              PERFORM 7030-CALL-CSR02084      THRU 7030-EXIT            
              MOVE WS-AGREEMENT-NO-2084   TO RL-DFA-ITEM-ID-DP          
              PERFORM 8000-UPDATE-DFA-ID      THRU 8000-EXIT            
           END-IF.                                                      
P00793*                                                                         
P00793* ABOVE MISC DR PROCESS CREATES UTE/UTG ROWS ON BBP ACCOUNT,              
P00793* TO ENSURE SMOOTH BILLING DELETE UTE/UTG FROM AR_CNTL.                   
P00793*                                                                         
P00793     IF BBP-FLG-YES                                               
P00793        PERFORM  8100-DEL-AR-CNTL       THRU 8100-EXIT            
P00793     END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2600-PROCESS-MISC-DR.                                           *        
      *    GENERATES MISC DEBIT.                                       *        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-MISC-DR.                                            
      *                                                                         
           PERFORM 7000-SELECT-ACCT           THRU 7000-EXIT            
           PERFORM 2100-MOVE-MISC-DR-VALS     THRU 2100-EXIT            
           PERFORM 7010-CALL-CSR02350         THRU 7010-EXIT            
           IF WS-DFA-ITEM-ID-2083 = 0                                   
              PERFORM 7020-CALL-CSR02083      THRU 7020-EXIT            
           ELSE                                                         
              ADD 1                           TO  WS-DFA-ITEM-ID-2083   
           END-IF                                                       
           PERFORM 7000-SELECT-ACCT           THRU 7000-EXIT            
           PERFORM 7005-SELECT-AR-CNTL        THRU 7005-EXIT            
           PERFORM 2150-MOVE-DFA-VALUES       THRU 2150-EXIT.           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00793*****************************************************************         
P00793* 2700-ADD-CHARGE.                                              *         
P00793*****************************************************************         
P00793*                                                                         
P00793 2700-ADD-CHARGE.                                                 
P00793*                                                                         
P00793     IF WS-DFA-ITEM-ID-2083 = 0                                   
P00793        MOVE WS-CONSUMPT-TYPE-CD    TO WS-DFA-TYPE-2083           
P00793        MOVE 'C'                    TO WS-NEW-FLAG-2083           
P00793        PERFORM 7020-CALL-CSR02083      THRU 7020-EXIT            
P00793     END-IF.                                                      
P00793     PERFORM 7000-SELECT-ACCT           THRU 7000-EXIT.           
P00793     PERFORM 2150-MOVE-DFA-VALUES       THRU 2150-EXIT.           
P00793*                                                                         
P00793     INITIALIZE WS-COMMENT-TEXT2.                                 
P00793*                                                                         
P00793     MOVE WS-REC-TYPE-2083          TO WS-DFA-RECV-1-2084.        
P00793     MOVE WS-COLLECTIBLE-AM         TO WS-AMT-ORIG-ENTERED-2084   
P00793                                       WS-DFA-RECV-1-AMT-2084.    
P00793     MOVE WS-LAST-TS-2083           TO WS-DFA-RECV-1-TS-2084      
P00793     MOVE ZERO                      TO WS-DFA-RECV-1-ID-2084      
P00793     MOVE WS-AMT-MO-COLLECT-PYMT    TO WS-AMT-MO-PYMT-2084.       
P00793     MOVE  1                        TO WS-NO-PYMTS-2084           
P00793     MOVE 'PANEL162'                TO WS-PANEL-NAME-2084.        
P00793     MOVE 'REVENUE PROTECTION CHARGE'                             
P00793                                    TO WS-COMMENT-TEXT2.          
P00793     MOVE +25                       TO WS-TRANS-CMTS-LEN-2084     
P00793                                       WS-PYMT-ARR-CMTS-LEN-2084. 
P00793     MOVE WS-COMMENT-TEXT2          TO WS-TRANS-COMMENTS-2084     
P00793                                       WS-PYMT-ARR-CMTS-2084.     
P00793*                                                                         
P00793     PERFORM 7030-CALL-CSR02084         THRU 7030-EXIT.           
P00793     MOVE WS-AGREEMENT-NO-2084      TO RL-DFA-ITEM-ID.            
P00793     PERFORM 8000-UPDATE-DFA-ID         THRU 8000-EXIT.           
P00793*                                                                         
P00793 2700-EXIT.                                                       
P00793     EXIT.                                                        
P00793*                                                                         
      *****************************************************************         
      * 7000-SELECT-ACCT                                              *         
      *****************************************************************         
      *                                                                         
       7000-SELECT-ACCT.                                                
      *                                                                         
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,AT.MST_SUB_ACCT_IND                               
                     ,AT.TOTAL_AR_BALANCE                               
                     ,AT.CODES_DATA_PRESENT                             
                 INTO :AT-LAST-UPDATE-TS                                
                     ,:AT-MST-SUB-ACCT-IND                              
                     ,:AT-TOTAL-AR-BALANCE                              
                     ,:AT-CODES-DATA-PRESENT                            
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.LAST_UPDATE_TS                                         
MFA-TR*              ,AT.MST_SUB_ACCT_IND                                       
MFA-TR*              ,AT.TOTAL_AR_BALANCE                                       
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*          INTO :AT-LAST-UPDATE-TS                                        
MFA-TR*              ,:AT-MST-SUB-ACCT-IND                                      
MFA-TR*              ,:AT-TOTAL-AR-BALANCE                                      
MFA-TR*              ,:AT-CODES-DATA-PRESENT                                    
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE AT-CODES-DATA-PRESENT(3:1)                           
                                          TO WS-BBP-FLG                 
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7000'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7005-SELECT-AR-CNTL                                           *         
      *****************************************************************         
      *                                                                         
       7005-SELECT-AR-CNTL.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           AC.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                 INTO :AC-LAST-UPDATE-TS                                
                 FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
                WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
                  AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL      
                  AND AC.ITEM_ID           = :AC-ITEM-ID                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AC.LAST_UPDATE_TS                                         
MFA-TR*          INTO :AC-LAST-UPDATE-TS                                        
MFA-TR*          FROM CSS_AR_CNTL AC                                            
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                     
MFA-TR*           AND AC.PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL              
MFA-TR*           AND AC.ITEM_ID           = :AC-ITEM-ID                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7005                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7005'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_AR_CNTL'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7008-SELECT-RESP-AREA                                         *         
      *****************************************************************         
      *                                                                         
       7008-SELECT-RESP-AREA.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT PF.RESP_AREA_ID                                   
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE PF.USER_ID  = :PF-USER-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PF.RESP_AREA_ID                                           
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE PF                                       
MFA-TR*         WHERE PF.USER_ID  = :PF-USER-ID                                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7008                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7008'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_USER_PROFILE'     TO TABLE-1                    
              MOVE 'USER_ID'              TO TABLE-ELEMENT-1            
              MOVE PF-USER-ID             TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7008-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-CALL-CSR02350.                                            *        
      ******************************************************************        
      *                                                                         
       7010-CALL-CSR02350.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR02350(:WS-ACCOUNT-NO-2350                       
      *                      ,:WS-CIA-DEBIT-AMT-2350                    
      *                      ,:WS-GL-ACCT-NO-2350                       
      *                      ,:WS-NO-ROWS-2350                          
      *                      ,:WS-DIR-PAY-1-2350                        
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,:WS-ACCTING-PERIOD-2350                   
      *                      ,:WS-COMMENT-LEN-2350                      
      *                      ,:WS-COMMENT-TEXT-2350                     
      *                      ,:WS-LAST-UPDATE-TS-2350                   
ACT205*                      ,:WS-LAST-UPDATE-ID-2350                   
      *                      )                                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MISC_DEBT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MISC_DEBT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MISC_DEBT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL                                                  
      *           ASSOCIATE LOCATORS                                    
      *           (:LOC-RESLTSET)                                       
      *           WITH PROCEDURE CSR02350                               
      *       END-EXEC                                                  
                                                                        
      *       EXEC SQL                                                  
      *           ALLOCATE MISC_DEBT_CUR CURSOR FOR RESULT SET          
      *           :LOC-RESLTSET                                         
      *       END-EXEC                                                  
      *                                                                         
              MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
      *                                                                         
              EXEC SQL                                                  
                FETCH MISC_DEBT_CUR                                     
                  INTO   :WS-RETURN-CODE-2350                           
                        ,:WS-ERROR-MSG1-2350                            
                        ,:WS-ERROR-MSG2-2350                            
                        ,:WS-ERROR-MSG3-2350                            
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-RETURN-CODE-2350 = 0                             
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE WS-RETURN-CODE-2350 TO S-RETURN-CODE           
                    PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT        
                    PERFORM 9999-END-PROGRAM     THRU 9999-EXIT         
                 END-IF                                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7010'                TO ACTIVE-PARAGRAPH         
                 MOVE 'FETCH'               TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR02350'            TO TABLE-1                  
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 EXEC SQL                                               
                    CLOSE MISC_DEBT_CUR                                 
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                 MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE             
      *                                                                         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                     CONTINUE                                           
                 ELSE                                                   
                    MOVE PROGRAM-NAME      TO ABEND-PROGRAM             
                    MOVE '7010'            TO ACTIVE-PARAGRAPH          
                    MOVE SQLCODE           TO ABEND-SQLCODE             
                    MOVE SQLSTATE          TO ABEND-SQLSTATE            
                    MOVE 'CLOSE'           TO ABEND-FUNCTION            
                    MOVE SPACES            TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                    MOVE 'CSR02350'        TO TABLE-1                   
                    MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2           
                    MOVE WS-ACCOUNT-NO-2350 TO HOSTVAR-ELEMENT-2        
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                 END-IF                                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '7010'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR02350'           TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2           
                 MOVE WS-ACCOUNT-NO-2350   TO HOSTVAR-ELEMENT-2         
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           ELSE                                                         
ACT205        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
ACT205                                         S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DB2SP'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR02350'               TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-ACCOUNT-NO-2350       TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7020-CALL-CSR02083.                                            *        
      ******************************************************************        
      *                                                                         
       7020-CALL-CSR02083.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR02083(:WS-ACCOUNT-NO-2083                       
      *                      ,:WS-DFA-TYPE-2083                         
      *                      ,:WS-NEW-FLAG-2083                         
      *                      )                                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE DFA_ID_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN DFA_ID_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR DFA_ID_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL                                                  
      *           ASSOCIATE LOCATORS                                    
      *           (:LOC-RESLTSET)                                       
      *           WITH PROCEDURE CSR02083                               
      *       END-EXEC                                                  
      *                                                                         
      *       EXEC SQL                                                  
      *           ALLOCATE DFA_ID_CUR CURSOR FOR RESULT SET             
      *           :LOC-RESLTSET                                         
      *       END-EXEC                                                  
      *                                                                         
              MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
      *                                                                         
              EXEC SQL                                                  
                FETCH DFA_ID_CUR                                        
                  INTO   :WS-RETURN-CODE-2083                           
                        ,:WS-DFA-ITEM-ID-2083                           
                        ,:WS-REC-TYPE-2083                              
                        ,:WS-CURRENT-CHARGES-2083                       
                        ,:WS-ARREARS-2083                               
                        ,:WS-BILLED-BALANCE-2083                        
                        ,:WS-CONTRACT-AMT-2083                          
                        ,:WS-LAST-TS-2083                               
                        ,:WS-EDIT-FLAG-2083                             
                        ,:WS-DATE-PYMT-START1-2083                      
                        ,:WS-DATE-PYMT-START2-2083                      
                        ,:WS-TOTAL-BILL-BAL-2083                        
                        ,:WS-RECV-DESC-2083                             
                        ,:WS-ITEM-ID-2083                               
                        ,:WS-RECV-BALANCE-2083                          
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7020'                TO ACTIVE-PARAGRAPH         
                 MOVE 'FETCH'               TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR02083'            TO TABLE-1                  
                 MOVE 'SQLCODE'             TO TABLE-ELEMENT-1          
                 MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
      *                                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  EXEC SQL                                              
                     CLOSE DFA_ID_CUR                                   
                  END-EXEC                                              

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                  MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE             
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                      CONTINUE                                          
                  ELSE                                                  
                     MOVE PROGRAM-NAME      TO ABEND-PROGRAM            
                     MOVE SQLCODE           TO ABEND-SQLCODE            
                     MOVE SQLSTATE          TO ABEND-SQLSTATE           
                     MOVE '7020'            TO ACTIVE-PARAGRAPH         
                     MOVE 'CLOSE'           TO ABEND-FUNCTION           
                     MOVE SPACES            TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                     MOVE 'CSR02083'        TO TABLE-1                  
                     MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2          
                     MOVE WS-ACCOUNT-NO-2083 TO HOSTVAR-ELEMENT-2       
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
                  END-IF                                                
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '7020'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR02083'           TO TABLE-1                  
                  MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2          
                  MOVE WS-ACCOUNT-NO-2083   TO HOSTVAR-ELEMENT-2        
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
               END-IF                                                   
           ELSE                                                         
ACT205        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
ACT205                                         S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DB2SP'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR02083'               TO TABLE-1                  
              MOVE 'SQLCODE'                TO TABLE-ELEMENT-1          
              MOVE SQLCODE                  TO HOSTVAR-ELEMENT-1        
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-ACCOUNT-NO-2083       TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7030-CALL-CSR02084.                                            *        
      ******************************************************************        
      *                                                                         
       7030-CALL-CSR02084.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR02084(:WS-PANEL-NAME-2084                       
      *                      ,:WS-ACCOUNT-NO-2084                       
      *                      ,:WS-AGREEMENT-NO-2084                     
      *                      ,:WS-DFA-TYPE-2084                         
      *                      ,:WS-DFA-STATUS-2084                       
      *                      ,:WS-USER-ID-2084                          
      *                      ,:WS-RESP-AREA-ID-2084                     
      *                      ,:WS-DFA-REASON-2084                       
      *                      ,:WS-DFA-CANCEL-RESN-2084                  
      *                      ,:WS-AMT-MO-PYMT-2084                      
      *                      ,:WS-PYMT-START-DATE-2084                  
      *                      ,:WS-NO-PYMTS-2084                         
      *                      ,:WS-AMT-ORIG-ENTERED-2084                 
      *                      ,:WS-AMT-UNDEFER-RECV-2084                 
      *                      ,:WS-DNP-DATE-2084                         
      *                      ,:WS-AMT-EXTRA-DEPOSIT-2084                
      *                      ,:WS-1ST-ERNST-AMT-2084                    
      *                      ,:WS-1ST-ERNST-DATE-2084                   
      *                      ,:WS-2ND-ERNST-AMT-2084                    
      *                      ,:WS-2ND-ERNST-DATE-2084                   
      *                      ,:WS-DNP-MINUS1-2084                       
      *                      ,:WS-DNP-MINUS-DELINQ-2084                 
      *                      ,:WS-TRANS-COMMENTS-2084                   
      *                      ,:WS-TRANS-CMTS-LEN-2084                   
      *                      ,:WS-PYMT-ARR-CMTS-2084                    
      *                      ,:WS-PYMT-ARR-CMTS-LEN-2084                
      *                      ,:WS-DFA-TIMESTAMP-2084                    
      *                      ,:WS-LAST-UPDATE-TS-2084                   
      *                      ,:WS-DFA-RECV-1-2084                       
      *                      ,:WS-DFA-RECV-1-AMT-2084                   
      *                      ,:WS-DFA-RECV-1-TS-2084                    
      *                      ,:WS-DFA-RECV-1-ID-2084                    
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      ,' '                                       
      *                      )                                          
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE DFA_AMT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN DFA_AMT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR DFA_AMT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           IF SQLCODE = +466 THEN                                       
      *       EXEC SQL                                                  
      *           ASSOCIATE LOCATORS                                    
      *           (:LOC-RESLTSET)                                       
      *           WITH PROCEDURE CSR02084                               
      *       END-EXEC                                                  
      *                                                                         
      *       EXEC SQL                                                  
      *           ALLOCATE DFA_AMT_CUR CURSOR FOR RESULT SET            
      *           :LOC-RESLTSET                                         
      *       END-EXEC                                                  
      *                                                                         
              MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
      *                                                                         
              EXEC SQL                                                  
                FETCH DFA_AMT_CUR                                       
                  INTO   :WS-RETURN-CODE-2084                           
                        ,:WS-CANCELDNP-FLAG-2084                        
                        ,:WS-AR-LOCKOUT-IND-2084                        
                        ,:WS-ACCT-XFER-TO-2084                          
                        ,:WS-CANCELNOT-FLAG-2084                        
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
              MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-RETURN-CODE-2084 = 0                             
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE WS-RETURN-CODE-2084 TO S-RETURN-CODE           
                    PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT        
                    PERFORM 9999-END-PROGRAM     THRU 9999-EXIT         
                 END-IF                                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7030'                TO ACTIVE-PARAGRAPH         
                 MOVE 'FETCH'               TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSR02084'            TO TABLE-1                  
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 EXEC SQL                                               
                    CLOSE DFA_AMT_CUR                                   
                 END-EXEC                                               

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                 MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE     
                                              S-RETURN-CODE             
      *                                                                         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                     CONTINUE                                           
                 ELSE                                                   
                    MOVE PROGRAM-NAME      TO ABEND-PROGRAM             
                    MOVE SQLCODE           TO ABEND-SQLCODE             
                    MOVE SQLSTATE          TO ABEND-SQLSTATE            
                    MOVE '7030'            TO ACTIVE-PARAGRAPH          
                    MOVE 'CLOSE'           TO ABEND-FUNCTION            
                    MOVE SPACES            TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                    MOVE 'CSR02084'        TO TABLE-1                   
                    MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2           
                    MOVE WS-ACCOUNT-NO-2084 TO HOSTVAR-ELEMENT-2        
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
                 END-IF                                                 
              ELSE                                                      
                 MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
                 MOVE SQLCODE             TO ABEND-SQLCODE              
                 MOVE SQLSTATE            TO ABEND-SQLSTATE             
                 MOVE '7030'              TO ACTIVE-PARAGRAPH           
                 MOVE 'FETCH'             TO ABEND-FUNCTION             
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'CSR02084'          TO TABLE-1                    
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2            
                 MOVE WS-ACCOUNT-NO-2084  TO HOSTVAR-ELEMENT-2          
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           ELSE                                                         
ACT205        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
ACT205                                         S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DB2SP'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR02084'               TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-ACCOUNT-NO-2084       TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************41698200
      *  8000-UPDATE-DFA-ID.                                           *41698300
      ******************************************************************41698500
      *                                                                         
       8000-UPDATE-DFA-ID.                                              
      *                                                                         
           EXEC SQL                                                     
                UPDATE RL                             
                SET    RL.DFA_ITEM_ID           = :RL-DFA-ITEM-ID       
                      ,RL.DFA_ITEM_ID_DP        = :RL-DFA-ITEM-ID-DP    
                FROM CSS_REV_PROTEC_DET RL
                WHERE  RL.ACCOUNT_NO            = :RL-ACCOUNT-NO        
                  AND  RL.REV_PROT_CASE_NO      = :RL-REV-PROT-CASE-NO  
                  AND  RL.CONSUMPT_TYPE_CD      = :RL-CONSUMPT-TYPE-CD  
                  AND  RL.CASE_SEQ_NO           = :RL-CASE-SEQ-NO       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     41695400
MFA-TR*         UPDATE CSS_REV_PROTEC_DET RL                            41695500
MFA-TR*         SET    RL.DFA_ITEM_ID           = :RL-DFA-ITEM-ID       41695700
MFA-TR*               ,RL.DFA_ITEM_ID_DP        = :RL-DFA-ITEM-ID-DP    41695700
MFA-TR*         WHERE  RL.ACCOUNT_NO            = :RL-ACCOUNT-NO        41696000
MFA-TR*           AND  RL.REV_PROT_CASE_NO      = :RL-REV-PROT-CASE-NO  41696100
MFA-TR*           AND  RL.CONSUMPT_TYPE_CD      = :RL-CONSUMPT-TYPE-CD  41696100
MFA-TR*           AND  RL.CASE_SEQ_NO           = :RL-CASE-SEQ-NO       41696100
MFA-TR*         QUERYNO 8000                                                    
MFA-TR*    END-EXEC.                                                    41696300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_REV_PROTEC_DET'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'REV_PROT_CASE_NO'        TO TABLE-ELEMENT-2         
              MOVE 'CASE_SEQ_NO'             TO TABLE-ELEMENT-3         
              MOVE RL-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE RL-REV-PROT-CASE-NO       TO HOSTVAR-ELEMENT-2       
              MOVE RL-CASE-SEQ-NO            TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 41697800
       8000-EXIT.                                                       
           EXIT.                                                        
P00793*                                                                         
P00793******************************************************************41698200
P00793*  8100-DEL-AR-CNTL.                                             *41698300
P00793******************************************************************41698500
P00793*                                                                         
P00793 8100-DEL-AR-CNTL.                                                
P00793*                                                                         
P00793     EXEC SQL                                                     
P00793        DELETE FROM CSS_AR_CNTL                                   
P00793         WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
P00793           AND PYMT_PRIORITY_LVL IN (40, 45)                      
P00793           AND ITEM_ID           = 0                              
P00793     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00793*                                                                         
P00793     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00793                                          S-RETURN-CODE.          
P00793*                                                                         
P00793     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00793         CONTINUE                                                 
P00793     ELSE                                                         
P00793        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00793        MOVE '8100'                    TO ACTIVE-PARAGRAPH        
P00793        MOVE 'DELETE'                  TO ABEND-FUNCTION          
P00793        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
P00793                                          ABEND-TABLES            
P00793        MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
P00793        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00793        MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00793        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00793        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00793     END-IF.                                                      
P00793*                                                                 41697800
P00793 8100-EXIT.                                                       
P00793     EXIT.                                                        
P00793*                                                                         
      ******************************************************************41710600
      *       9700 - ABEND PROCESSING                                  *41710700
      ******************************************************************41710800
      *                                                                 41705300
           EXEC SQL                                                     41708700
              INCLUDE CPD0023C                                          41708800
           END-EXEC.                                                    41708900
      *                                                                 41709000
      ******************************************************************41710600
      *       9900 - JOURNALING / ERROR HANDLING ROUTINE               *41710700
      ******************************************************************41710800
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                 41709000
      ******************************************************************41710600
      *       END PROGRAM COPYLIB                                      *41710700
      ******************************************************************41710800
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************41720000
