       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04331.                                      
COB303 DATE-WRITTEN.     FEB 27, 2010.                                  
       DATE-COMPILED.                                                   
      *                                                                 00000500
      ******************************************************************00000600
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000700
      *                                                                *00000800
      *                                                                *00001400
      ******************************************************************00001500
      *                 P R O G R A M  S U M M A R Y                   *00001600
      *                                                                *00001700
      *                                                                *00002000
      * THIS PROGRAM RETRIEVES THE REVENUE PROTECTION CASE DETAILS OF  *00002100
      * AN ACCOUNT FOR PANEL161.                                       *00002100
      *                                                                *00002700
      ******************************************************************00002800
      *                                                                *00002900
      *                     PROGRAM MODIFICATION LOG                   *00003000
      *                                                                *00003100
      *    DATE    INITIALS   COMMENTS                                 *00003200
      *  --------  --------   ---------------------------------------  *00003300
P00253*  02/27/10  SP95538    PROCEDURE ORIGINALLY CODED.              *00003400
      *                                                                *00003100
      ******************************************************************00008300
      ******************************************************************00008400
      *                                                                *00008500
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00008600
      *                                                                *00008700
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00008800
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00008900
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00009000
      *  3000 - 4999  NOT USED                                         *00009100
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00009200
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00009300
      *  7000 - 7999  INPUT MODULES                                    *00009400
      *  8000 - 8999  OUTPUT MODULES                                   *00009500
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00009600
      *                                                                *00009700
      ******************************************************************00009800
      *                                                                 00009900
       ENVIRONMENT DIVISION.                                            
      *                                                                 00009900
       DATA DIVISION.                                                   
      *                                                                 00009900
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04331'.
MSQ017     COPY MFASQLM.
      *                                                                 00009900
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04331 STARTS HERE'.                  
      *                                                                 03011603
       01  WS-COUNTERS.                                                 
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 03011603
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 03015000
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09)  COMP VALUE +0.      
           05  S-REV-PROT-CASE-NO       PIC X(10)   VALUE SPACE.        
           05  S-COMPANY-NO             PIC X(02)   VALUE SPACE.        
           05  S-CASE-STATUS-CD         PIC X(01)   VALUE SPACE.        
           05  S-SOURCE-CD              PIC X(03)   VALUE SPACE.        
           05  S-UNCOLLEC-RESN-CD       PIC X(01)   VALUE SPACE.        
           05  S-SETUP-USERID           PIC X(07)   VALUE SPACE.        
           05  S-END-DT                 PIC X(10)   VALUE SPACE.        
           05  S-CREATE-DT              PIC X(10)   VALUE SPACE.        
           05  S-CASE-NOTES.                                            
               49 S-CASE-LENGTH         PIC S9(4)   COMP VALUE +0.      
               49 S-CASE-TEXT           PIC X(1000) VALUE SPACE.        
           05  S-STATUS-CHANGE-DT       PIC X(10)   VALUE SPACE.        
           05  S-WORK-TYPE-CD           PIC X(03)   VALUE SPACE.        
           05  S-CASE-TYPE-CD           PIC X(01)   VALUE SPACE.        
           05  S-CASE-SEQ-NO            PIC S9(04)  COMP VALUE +0.      
           05  S-RATE-PLAN-NO           PIC X(03)   VALUE SPACE.        
           05  S-CD-REVENUE-CLASS       PIC X(03)   VALUE SPACE.        
           05  S-CUNSUMPT-TYPE-CD       PIC X(1)    VALUE SPACE.        
           05  S-NO-UNITS               PIC S9(9)V  USAGE COMP-3        
                                                          VALUE +0.     
           05  S-COLLECTABLE-UNITS      PIC S9(9)V USAGE COMP-3         
                                                          VALUE +0.     
           05  S-CASE-AM                PIC S9(11)V9(2) USAGE COMP-3    
                                                          VALUE +0.     
           05  S-COLLECTABLE-AM         PIC S9(11)V9(2) USAGE COMP-3    
                                                          VALUE +0.     
           05  S-AMT-DOWN-PYMT          PIC S9(11)V9(2) USAGE COMP-3    
                                                          VALUE +0.     
           05  S-RECURR-REV-PCT         PIC S9(3)V9(2)  USAGE COMP-3    
                                                          VALUE +0.     
           05  S-DFA-ITEM-ID            PIC S9(9) USAGE COMP VALUE +0.  
           05  S-DFA-ITEM-ID-DP         PIC S9(9) USAGE COMP VALUE +0.  
           05  S-CASE-COUNT             PIC S9(4) USAGE COMP VALUE +0.  
           05  S-CD-DFA-DESC            PIC X(01) VALUE SPACE.          
           05  S-PYMT-START-DT          PIC X(10) VALUE SPACE.          
           05  S-NO-SCHED-PYMTS         PIC S9(04) COMP VALUE +0.       
      *                                                                 12232430
       01  WS-MISC-FIELDS.                                              
           05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05  WS-ACCOUNT-DEC  REDEFINES WS-ACCOUNT-NO                  
                                        PIC 9(13).                      
           05  WS-PREV-CASE-NO          PIC X(10)   VALUE SPACE.        
           05  WS-CASE-NO               PIC X(10)   VALUE SPACE.        
           05  WS-NULL-IND-1            PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND-2            PIC S9(04) COMP VALUE +0.       
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04331'.     
      *                                                                 12232430
       01  WS-FLAG.                                                     
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 12232430
      ******************************************************************03011604
      *                          DB2 INCLUDES                          *03011605
      ******************************************************************03011606
      *                                                                 00010600
      ******************************************************************00010700
      *    SQL COMMUNICATION AREA                                      *00010800
      ******************************************************************00010900
      *                                                                 00011000
           EXEC SQL                                                     00011100
              INCLUDE SQLCA                                             00011200
           END-EXEC.                                                    00011300
                                                                        
      *                                                                         
      *****************************************************************         
      *    CSS_DFA_ACCT - DA                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_REV_PROTEC_HDR -R0                                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVPRT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_REV_PROTEC_DET -RL                                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************03010060
      *               COBOL WORKING STORAGE COPY BOOKS                 *03010070
      ******************************************************************03010080
      *                                                                 03010800
      ******************************************************************12232440
      *    ERROR HANDLING                                               03010800
      ******************************************************************12232440
      *                                                                 03010800
           EXEC SQL                                                     03011000
              INCLUDE CWSX0010                                          03011100
           END-EXEC.                                                    03011200
      *                                                                         
      ******************************************************************12232440
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *03011500
      ******************************************************************12232460
      *                                                                         
           COPY CWS00303.                                               03011600
      *                                                                         
      ******************************************************************12232440
      *                      CURSOR DECLARATIONS                       *12232450
      ******************************************************************12232460
      *                                                                *12232490
      ******************************************************************12232460
      *    REV-PROTEC-CUR CURSOR                                       *12232480
      ******************************************************************12232460
      *                                                                 12232490
           EXEC SQL DECLARE REV-PROTEC-CUR CURSOR FOR                   
             SELECT R0.REV_PROT_CASE_NO                                 
                   ,R0.COMPANY_NO                                       
                   ,R0.CASE_STATUS_CD                                   
                   ,R0.SOURCE_CD                                        
                   ,R0.UNCOLLEC_REASON_CD                               
                   ,R0.SETUP_USERID                                     
                   ,R0.END_DT                                           
                   ,R0.CREATE_DT                                        
                   ,R0.CASE_NOTES                                       
                   ,R0.STATUS_CHANGE_DT                                 
                   ,R0.WORK_TYPE_CD                                     
                   ,COALESCE(RL.CASE_TYPE_CD,' ')                       
                   ,COALESCE(RL.CASE_SEQ_NO,0)                          
                   ,COALESCE(RL.RATE_PLAN_NO,' ')                       
                   ,COALESCE(RL.CODE_REVENUE_CLASS,' ')                 
                   ,COALESCE(RL.CONSUMPT_TYPE_CD,' ')                   
                   ,COALESCE(RL.NO_UNITS,0)                             
                   ,COALESCE(RL.COLLECTIBLE_UNITS,0)                    
                   ,COALESCE(RL.CASE_AM,0)                              
                   ,COALESCE(RL.COLLECTIBLE_AM,0)                       
                   ,COALESCE(RL.AMT_DOWN_PYMT,0)                        
                   ,COALESCE(RL.RECURR_REV_PCT,0)                       
                   ,COALESCE(RL.DFA_ITEM_ID,0)                          
                   ,COALESCE(RL.DFA_ITEM_ID_DP,0)                       
                   ,COALESCE(DA.CODE_DFA_DESC,' ')                      
                   ,COALESCE(DA.NO_SCHED_PYMTS,0)                       
                   ,DA.DATE_PYMT_START                                  
             FROM   CSS_REV_PROTEC_HDR R0 WITH(READUNCOMMITTED)                 
                   LEFT OUTER JOIN  CSS_REV_PROTEC_DET RL
                           WITH(READUNCOMMITTED)               
                        ON  RL.ACCOUNT_NO       = R0.ACCOUNT_NO         
                       AND  RL.REV_PROT_CASE_NO = R0.REV_PROT_CASE_NO   
                   LEFT OUTER JOIN  CSS_DFA_ACCT DA
                           WITH(READUNCOMMITTED)                     
                        ON  DA.ACCOUNT_NO       = RL.ACCOUNT_NO         
                       AND  DA.DFA_ITEM_ID      = RL.DFA_ITEM_ID        
             WHERE  R0.ACCOUNT_NO       = :RL-ACCOUNT-NO                
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE REV-PROTEC-CUR CURSOR FOR                   12232500
MFA-TR*      SELECT R0.REV_PROT_CASE_NO                                 12232600
MFA-TR*            ,R0.COMPANY_NO                                       12232700
MFA-TR*            ,R0.CASE_STATUS_CD                                   12233000
MFA-TR*            ,R0.SOURCE_CD                                        12233100
MFA-TR*            ,R0.UNCOLLEC_REASON_CD                               12233200
MFA-TR*            ,R0.SETUP_USERID                                     12233500
MFA-TR*            ,R0.END_DT                                           12233900
MFA-TR*            ,R0.CREATE_DT                                        12234000
MFA-TR*            ,R0.CASE_NOTES                                               
MFA-TR*            ,R0.STATUS_CHANGE_DT                                         
MFA-TR*            ,R0.WORK_TYPE_CD                                             
MFA-TR*            ,COALESCE(RL.CASE_TYPE_CD,' ')                               
MFA-TR*            ,COALESCE(RL.CASE_SEQ_NO,0)                                  
MFA-TR*            ,COALESCE(RL.RATE_PLAN_NO,' ')                               
MFA-TR*            ,COALESCE(RL.CODE_REVENUE_CLASS,' ')                         
MFA-TR*            ,COALESCE(RL.CONSUMPT_TYPE_CD,' ')                           
MFA-TR*            ,COALESCE(RL.NO_UNITS,0)                                     
MFA-TR*            ,COALESCE(RL.COLLECTIBLE_UNITS,0)                            
MFA-TR*            ,COALESCE(RL.CASE_AM,0)                                      
MFA-TR*            ,COALESCE(RL.COLLECTIBLE_AM,0)                               
MFA-TR*            ,COALESCE(RL.AMT_DOWN_PYMT,0)                                
MFA-TR*            ,COALESCE(RL.RECURR_REV_PCT,0)                               
MFA-TR*            ,COALESCE(RL.DFA_ITEM_ID,0)                                  
MFA-TR*            ,COALESCE(RL.DFA_ITEM_ID_DP,0)                               
MFA-TR*            ,COALESCE(DA.CODE_DFA_DESC,' ')                              
MFA-TR*            ,COALESCE(DA.NO_SCHED_PYMTS,0)                               
MFA-TR*            ,DA.DATE_PYMT_START                                          
MFA-TR*      FROM   CSS_REV_PROTEC_HDR R0                               12234300
MFA-TR*            LEFT OUTER JOIN  CSS_REV_PROTEC_DET RL                       
MFA-TR*                 ON  RL.ACCOUNT_NO       = R0.ACCOUNT_NO                 
MFA-TR*                AND  RL.REV_PROT_CASE_NO = R0.REV_PROT_CASE_NO           
MFA-TR*            LEFT OUTER JOIN  CSS_DFA_ACCT DA                             
MFA-TR*                 ON  DA.ACCOUNT_NO       = RL.ACCOUNT_NO                 
MFA-TR*                AND  DA.DFA_ITEM_ID      = RL.DFA_ITEM_ID                
MFA-TR*      WHERE  R0.ACCOUNT_NO       = :RL-ACCOUNT-NO                12234400
MFA-TR*      FOR FETCH ONLY WITH UR                                     12234500
MFA-TR*    END-EXEC.                                                    12234600
      *                                                                 12234700
HPCCDM*EJECT                                                            12237800
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO         PIC X(13).                           
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                 12238600
      ******************************************************************12238700
      * 0000-MAINLINE                                                  *12238800
      ******************************************************************12239500
      *                                                                 12239600
       0000-MAINLINE.                                                   
      *                                                                 12239800
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
      *                                                                         
           IF CTR-ROWS < 1                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE 100  TO S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
      *                                                                         
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
      *                                                                 12240900
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12241200
      ******************************************************************12241300
      * 0100-INITIALIZE                                                *12241400
      ******************************************************************12242500
      *                                                                 12242600
       0100-INITIALIZE.                                                 
      *                                                                 12242800
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
      *                                                                 12245100
               EXEC SQL                                                 
                   DECLARE C1 CURSOR                         
                                     WITH ROWSET POSITIONING FOR        
                   SELECT                                               
                      *                                                 
                   FROM                                                 
                       #CSR04331_R1                              
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                 12245200
MFA-TR*            DECLARE C1 CURSOR WITH RETURN                        12245300
MFA-TR*                              WITH ROWSET POSITIONING FOR                
MFA-TR*            SELECT                                               12245400
MFA-TR*               *                                                 12245500
MFA-TR*            FROM                                                 12245600
MFA-TR*                SESSION.CSR04331_R1                              12245700
MFA-TR*        END-EXEC.                                                12245800
      *                                                                 12245100
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12246100
      ******************************************************************12246200
      * 0100A-DECLARE-GTT.                                             *12246300
      ******************************************************************12246400
       0100A-DECLARE-GTT.                                               
      *                                                                 12246600
              EXEC SQL
                CALL CIS.DROP_TEMP_TABLE('#CSR04331_R1')
              END-EXEC
              EXEC SQL
                CREATE TABLE #CSR04331_R1
                 (                                                       
                    RETURN_CODE              INT                    
                   ,REV_PROT_CASE_NO CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CASE_STATUS_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                   ,SOURCE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,UNCOLLEC_REASON_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                   ,SETUP_USERID CHAR(07)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                   ,END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,CREATE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CASE_NOTES VARCHAR(1000)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2              
                   ,STATUS_CHANGE_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                   ,CASE_TYPE_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
                   ,CASE_SEQ_NO              INT                    
                   ,RATE_PLAN_NO CHAR(3)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
                   ,CODE_REVENUE_CLASS CHAR(3)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
                   ,CONSUMPT_TYPE_CD CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
                   ,NO_UNITS                 DECIMAL(9,0)              
                   ,COLLECTIBLE_UNITS        DECIMAL(9,0)              
                   ,CASE_AM                  DECIMAL(13,2)             
                   ,COLLECTIBLE_AM           DECIMAL(13,2)             
                   ,AMT_DOWN_PYMT            DECIMAL(13,2)             
                   ,RECURR_REV_PCT           DECIMAL(5,2)              
                   ,DFA_ITEM_ID              INT                    
                   ,DFA_ITEM_ID_DP           INT                    
                   ,CASE_COUNT               INT                    
                   ,CODE_DFA_DESC CHAR(1)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
                   ,DATE_PYMT_START CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                   
                   ,NO_SCHED_PYMTS           INT                    
                   ,WORK_TYPE_CD CHAR(3)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
                )
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12252500
            MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                 12252800
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04331_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                              THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                 12255000
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 12255000
      ******************************************************************12255300
      * 1000-PROCESS-INPUT                                             *12255400
      ******************************************************************12256000
      *                                                                 12256100
       1000-PROCESS-INPUT.                                              
      *                                                                 12256500
           MOVE PARM-ACCOUNT-NO          TO WS-ACCOUNT-NO.              
           MOVE WS-ACCOUNT-DEC           TO R0-ACCOUNT-NO               
                                            RL-ACCOUNT-NO.              
      *                                                                 12257300
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12265100
      ******************************************************************23099900
      * 2000-PROCESS-OUTPUT                                            *23100000
      *     FETCHES THE NEXT ROW, FORMAT & INSERT GTT                  *23100600
      ******************************************************************23100800
      *                                                                 23100900
       2000-PROCESS-OUTPUT.                                             
      *                                                                 23101400
           PERFORM 7000-OPEN-REV-PROTEC       THRU 7000-EXIT.           
           PERFORM 7100-FETCH-REV-PROTEC      THRU 7100-EXIT.           
      *                                                                 23101400
           PERFORM 2100-PROCESS-REV-ACCT      THRU 2100-EXIT            
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
      *                                                                 23101400
           PERFORM 7200-CLOSE-REV-PROTEC      THRU 7200-EXIT.           
      *                                                                 23101400
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************23099900
      * 2100-PROCESS-REV-ACCT                                          *23100000
      ******************************************************************23100800
      *                                                                 23100900
       2100-PROCESS-REV-ACCT.                                           
      *                                                                 23101100
           PERFORM 2200-MOVE-VALUES           THRU 2200-EXIT.           
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
      *                                                                 23125000
           PERFORM 7100-FETCH-REV-PROTEC      THRU 7100-EXIT.           
      *                                                                 23125000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50410005
      ******************************************************************12265200
      *2200-MOVE-VALUES.                                               *12265300
      ******************************************************************12265400
      *                                                                         
       2200-MOVE-VALUES.                                                
      *                                                                 12265600
           MOVE R0-REV-PROT-CASE-NO      TO S-REV-PROT-CASE-NO          
                                            WS-CASE-NO                  
           MOVE R0-COMPANY-NO            TO S-COMPANY-NO                
           MOVE R0-CASE-STATUS-CD        TO S-CASE-STATUS-CD            
           MOVE R0-SOURCE-CD             TO S-SOURCE-CD                 
           MOVE R0-UNCOLLEC-REASON-CD    TO S-UNCOLLEC-RESN-CD          
           MOVE R0-SETUP-USERID          TO S-SETUP-USERID              
           MOVE R0-END-DT                TO S-END-DT                    
           MOVE R0-CREATE-DT             TO S-CREATE-DT                 
           MOVE R0-CASE-NOTES            TO S-CASE-NOTES                
           MOVE R0-STATUS-CHANGE-DT      TO S-STATUS-CHANGE-DT          
           MOVE R0-WORK-TYPE-CD          TO S-WORK-TYPE-CD              
           MOVE RL-CASE-TYPE-CD          TO S-CASE-TYPE-CD              
           MOVE RL-CASE-SEQ-NO           TO S-CASE-SEQ-NO               
           MOVE RL-RATE-PLAN-NO          TO S-RATE-PLAN-NO              
           MOVE RL-CODE-REVENUE-CLASS    TO S-CD-REVENUE-CLASS          
           MOVE RL-CONSUMPT-TYPE-CD      TO S-CUNSUMPT-TYPE-CD          
           MOVE RL-NO-UNITS              TO S-NO-UNITS                  
           MOVE RL-COLLECTIBLE-UNITS     TO S-COLLECTABLE-UNITS         
           MOVE RL-CASE-AM               TO S-CASE-AM                   
           MOVE RL-COLLECTIBLE-AM        TO S-COLLECTABLE-AM            
           MOVE RL-AMT-DOWN-PYMT         TO S-AMT-DOWN-PYMT             
           MOVE RL-RECURR-REV-PCT        TO S-RECURR-REV-PCT            
           MOVE RL-DFA-ITEM-ID           TO S-DFA-ITEM-ID               
           MOVE RL-DFA-ITEM-ID-DP        TO S-DFA-ITEM-ID-DP            
           MOVE DA-CODE-DFA-DESC         TO S-CD-DFA-DESC               
           MOVE DA-NO-SCHED-PYMTS        TO S-NO-SCHED-PYMTS            
           MOVE DA-DATE-PYMT-START       TO S-PYMT-START-DT             
      *                                                                 12270300
           IF WS-CASE-NO NOT EQUAL WS-PREV-CASE-NO                      
              MOVE  WS-CASE-NO           TO WS-PREV-CASE-NO             
              ADD +1                     TO S-CASE-COUNT                
           END-IF.                                                      
      *                                                                 12270300
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23099800
      ******************************************************************50410006
      * 7000-OPEN-REV-PROTEC                                           *50410007
      ******************************************************************50410050
      *                                                                 50410060
       7000-OPEN-REV-PROTEC.                                            
      *                                                                 50410080
           EXEC SQL                                                     
              OPEN REV-PROTEC-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50410500
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                 50410700
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REV_PROTEC_DET'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 50412300
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50412600
      ******************************************************************50416400
      * 7100-FETCH-REV-PROTEC                                          *50416500
      ******************************************************************50417200
      *                                                                 50417300
       7100-FETCH-REV-PROTEC.                                           
      *                                                                 50417500
           EXEC SQL                                                     
              FETCH  REV-PROTEC-CUR                                     
              INTO  :R0-REV-PROT-CASE-NO                                
                   ,:R0-COMPANY-NO                                      
                   ,:R0-CASE-STATUS-CD                                  
                   ,:R0-SOURCE-CD                                       
                   ,:R0-UNCOLLEC-REASON-CD                              
                   ,:R0-SETUP-USERID                                    
                   ,:R0-END-DT :WS-NULL-IND-2                            
                   ,:R0-CREATE-DT                                       
                   ,:R0-CASE-NOTES                                      
                   ,:R0-STATUS-CHANGE-DT                                
                   ,:R0-WORK-TYPE-CD                                    
                   ,:RL-CASE-TYPE-CD                                    
                   ,:RL-CASE-SEQ-NO                                     
                   ,:RL-RATE-PLAN-NO                                    
                   ,:RL-CODE-REVENUE-CLASS                              
                   ,:RL-CONSUMPT-TYPE-CD                                
                   ,:RL-NO-UNITS                                        
                   ,:RL-COLLECTIBLE-UNITS                               
                   ,:RL-CASE-AM                                         
                   ,:RL-COLLECTIBLE-AM                                  
                   ,:RL-AMT-DOWN-PYMT                                   
                   ,:RL-RECURR-REV-PCT                                  
                   ,:RL-DFA-ITEM-ID                                     
                   ,:RL-DFA-ITEM-ID-DP                                  
                   ,:DA-CODE-DFA-DESC                                   
                   ,:DA-NO-SCHED-PYMTS                                  
                   ,:DA-DATE-PYMT-START :WS-NULL-IND-1                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50420200
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-1 EQUAL -1                                 
                 MOVE SPACES TO DA-DATE-PYMT-START                      
              END-IF                                                    
              IF WS-NULL-IND-2 EQUAL -1                                 
                 MOVE SPACES TO R0-END-DT                               
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REV_PROTEC_DET'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
     *                                                                  
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50422400
      ******************************************************************50442700
      * 7200-CLOSE-REV-PROTEC.                                         *50442800
      ******************************************************************50443500
      *                                                                 50443600
       7200-CLOSE-REV-PROTEC.                                           
      *                                                                 50443800
           EXEC SQL                                                     
              CLOSE  REV-PROTEC-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 50444400
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                 50444600
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REV_PROTEC_DET'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 50446200
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 50446500
      ******************************************************************50502700
      *8100-SEND-RESULT.                                                50502800
      ******************************************************************50502900
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                 50503100
            EXEC SQL                                                    
                 INSERT INTO #CSR04331_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,REV_PROT_CASE_NO                                  
                     ,COMPANY_NO                                        
                     ,CASE_STATUS_CD                                    
                     ,SOURCE_CD                                         
                     ,UNCOLLEC_REASON_CD                                
                     ,SETUP_USERID                                      
                     ,END_DT                                            
                     ,CREATE_DT                                         
                     ,CASE_NOTES                                        
                     ,STATUS_CHANGE_DT                                  
                     ,CASE_TYPE_CD                                      
                     ,CASE_SEQ_NO                                       
                     ,RATE_PLAN_NO                                      
                     ,CODE_REVENUE_CLASS                                
                     ,CONSUMPT_TYPE_CD                                  
                     ,NO_UNITS                                          
                     ,COLLECTIBLE_UNITS                                 
                     ,CASE_AM                                           
                     ,COLLECTIBLE_AM                                    
                     ,AMT_DOWN_PYMT                                     
                     ,RECURR_REV_PCT                                    
                     ,DFA_ITEM_ID                                       
                     ,DFA_ITEM_ID_DP                                    
                     ,CASE_COUNT                                        
                     ,CODE_DFA_DESC                                     
                     ,DATE_PYMT_START                                   
                     ,NO_SCHED_PYMTS                                    
                     ,WORK_TYPE_CD                                      
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-REV-PROT-CASE-NO                               
                     ,:S-COMPANY-NO                                     
                     ,:S-CASE-STATUS-CD                                 
                     ,:S-SOURCE-CD                                      
                     ,:S-UNCOLLEC-RESN-CD                               
                     ,:S-SETUP-USERID                                   
                     ,:S-END-DT                                         
                     ,:S-CREATE-DT                                      
                     ,:S-CASE-NOTES                                     
                     ,:S-STATUS-CHANGE-DT                               
                     ,:S-CASE-TYPE-CD                                   
                     ,:S-CASE-SEQ-NO                                    
                     ,:S-RATE-PLAN-NO                                   
                     ,:S-CD-REVENUE-CLASS                               
                     ,:S-CUNSUMPT-TYPE-CD                               
                     ,:S-NO-UNITS                                       
                     ,:S-COLLECTABLE-UNITS                              
                     ,:S-CASE-AM                                        
                     ,:S-COLLECTABLE-AM                                 
                     ,:S-AMT-DOWN-PYMT                                  
                     ,:S-RECURR-REV-PCT                                 
                     ,:S-DFA-ITEM-ID                                    
                     ,:S-DFA-ITEM-ID-DP                                 
                     ,:S-CASE-COUNT                                     
                     ,:S-CD-DFA-DESC                                    
                     ,:S-PYMT-START-DT                                  
                     ,:S-NO-SCHED-PYMTS                                 
                     ,:S-WORK-TYPE-CD                                   
                 )                                                      
                 END-EXEC                                               

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    503300  
MFA-TR*          INSERT INTO SESSION.CSR04331_R1                        503400  
MFA-TR*          (                                                      503500  
MFA-TR*               RETURN_CODE                                       503600  
MFA-TR*              ,REV_PROT_CASE_NO                                  503700  
MFA-TR*              ,COMPANY_NO                                        503800  
MFA-TR*              ,CASE_STATUS_CD                                    503900  
MFA-TR*              ,SOURCE_CD                                         504000  
MFA-TR*              ,UNCOLLEC_REASON_CD                                504100  
MFA-TR*              ,SETUP_USERID                                      504200  
MFA-TR*              ,END_DT                                            504300  
MFA-TR*              ,CREATE_DT                                         504400  
MFA-TR*              ,CASE_NOTES                                        504500  
MFA-TR*              ,STATUS_CHANGE_DT                                  504600  
MFA-TR*              ,CASE_TYPE_CD                                      504700  
MFA-TR*              ,CASE_SEQ_NO                                       504700  
MFA-TR*              ,RATE_PLAN_NO                                      504800  
MFA-TR*              ,CODE_REVENUE_CLASS                                504900  
MFA-TR*              ,CONSUMPT_TYPE_CD                                  505000  
MFA-TR*              ,NO_UNITS                                          505100  
MFA-TR*              ,COLLECTIBLE_UNITS                                 505200  
MFA-TR*              ,CASE_AM                                           505300  
MFA-TR*              ,COLLECTIBLE_AM                                    505400  
MFA-TR*              ,AMT_DOWN_PYMT                                     505500  
MFA-TR*              ,RECURR_REV_PCT                                    505600  
MFA-TR*              ,DFA_ITEM_ID                                       505700  
MFA-TR*              ,DFA_ITEM_ID_DP                                    505800  
MFA-TR*              ,CASE_COUNT                                        505800  
MFA-TR*              ,CODE_DFA_DESC                                     505800  
MFA-TR*              ,DATE_PYMT_START                                   505800  
MFA-TR*              ,NO_SCHED_PYMTS                                    505800  
MFA-TR*              ,WORK_TYPE_CD                                      505800  
MFA-TR*          )                                                      506100  
MFA-TR*          VALUES                                                 506200  
MFA-TR*          (                                                      506300  
MFA-TR*               :S-RETURN-CODE                                    506400  
MFA-TR*              ,:S-REV-PROT-CASE-NO                               506600  
MFA-TR*              ,:S-COMPANY-NO                                     506700  
MFA-TR*              ,:S-CASE-STATUS-CD                                 506800  
MFA-TR*              ,:S-SOURCE-CD                                      506900  
MFA-TR*              ,:S-UNCOLLEC-RESN-CD                               507000  
MFA-TR*              ,:S-SETUP-USERID                                   507100  
MFA-TR*              ,:S-END-DT                                         507200  
MFA-TR*              ,:S-CREATE-DT                                      507300  
MFA-TR*              ,:S-CASE-NOTES                                     507400  
MFA-TR*              ,:S-STATUS-CHANGE-DT                               507500  
MFA-TR*              ,:S-CASE-TYPE-CD                                   507600  
MFA-TR*              ,:S-CASE-SEQ-NO                                    507600  
MFA-TR*              ,:S-RATE-PLAN-NO                                   507700  
MFA-TR*              ,:S-CD-REVENUE-CLASS                               507800  
MFA-TR*              ,:S-CUNSUMPT-TYPE-CD                               507900  
MFA-TR*              ,:S-NO-UNITS                                       508000  
MFA-TR*              ,:S-COLLECTABLE-UNITS                              508100  
MFA-TR*              ,:S-CASE-AM                                        508100  
MFA-TR*              ,:S-COLLECTABLE-AM                                 508100  
MFA-TR*              ,:S-AMT-DOWN-PYMT                                  508200  
MFA-TR*              ,:S-RECURR-REV-PCT                                 508400  
MFA-TR*              ,:S-DFA-ITEM-ID                                    508600  
MFA-TR*              ,:S-DFA-ITEM-ID-DP                                 508700  
MFA-TR*              ,:S-CASE-COUNT                                     508700  
MFA-TR*              ,:S-CD-DFA-DESC                                    508700  
MFA-TR*              ,:S-PYMT-START-DT                                  508700  
MFA-TR*              ,:S-NO-SCHED-PYMTS                                 508700  
MFA-TR*              ,:S-WORK-TYPE-CD                                   508700  
MFA-TR*          )                                                      508900  
MFA-TR*          END-EXEC                                               509000  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 513700  
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                 513900  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04331_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 50515400
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************50519500
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     50519600
      ******************************************************************50519700
      *                                                                 50521200
           EXEC SQL                                                     50520100
              INCLUDE CPDSP300                                          50520200
           END-EXEC.                                                    50520300
      *                                                                 50520400
      ******************************************************************50520500
      *       END PROGRAM COPYLIB                                      *50520600
      ******************************************************************50520700
      *                                                                 50521200
           EXEC SQL                                                     50520900
              INCLUDE CPD00320                                          50521000
           END-EXEC.                                                    50521100
      *                                                                 50521200
