       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04326.                                       
       AUTHOR.        DAS MINJUR.                                       
COB303 DATE-WRITTEN. FEB 09, 2010.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04326              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04326 :                                                --         
      *--                                                            --         
      *--  #  INVOKED FROM PANEL428, INSERTS INTO CSS_ARCHIVE_FCST.  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            RETURN_CODE           CHAR(9)                   --         
      *--            FORECAST_TYPE_CD      CHAR(1)                   --         
      *--            FORECAST_REASON_CD    CHAR(1)                   --         
      *--            FORECAST_DT           DATE                      --         
      *--            LAST_UPDATE_TS        TIMESTMP                  --         
      *--            LAST_UPDATE_USERID    CHAR(7)                   --         
      *--            REMARKS               CHAR(200)                 --         
      *--            TRAN_COMMENT          CHAR(200)                 --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     MULTIPLE                                               --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  02/09/2010    DM94438     PROGRAM INTIALLY WRITTEN.       --         
A37666*--  08/25/2010    DM94438     FIX FOR EXEMPTION PANEL TO      --         
      *--                            RIGHT TRANSACTION HIST AND REMOVE          
      *--                            REDUNCTANT CODE                 --         
      *--                            ACTIVITY 82 IN A37666           --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04326'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCT                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_ARCHIEVE_FCST,AZ                                          *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBARCFCS                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_ARCHIEVE_EXEMPT,AA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACXMPT                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_JOB_PARM, G6                                              *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBJBPARM                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MNT_TRANS_HIST, MH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET, MI                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHDT                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_USER_PROFILE, PF                                                    
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBUSRPRF                                               
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR 326.                            *        
      ******************************************************************        
           COPY CWS00326.                                                       
      ***************************************************************** 00165600
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
           05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.           
           05 WS-CURRENT-TS           PIC X(26) VALUE SPACES.           
           05 WS-COMPANY-NO           PIC X(02) VALUE SPACES.           
           05 WS-ACCOUNT-NO           PIC X(13) VALUE SPACES.           
           05 WS-PROCESS-CD           PIC X(1) VALUE SPACES.            
           05 WS-FORECAST-TYPE-CD     PIC X(1)  VALUE SPACES.           
           05 WS-FORECAST-REASON-CD   PIC X(1)  VALUE SPACES.           
           05 WS-FORECAST-DT          PIC X(10) VALUE SPACES.           
           05 WS-LAST-UPDATE-TS       PIC X(26) VALUE SPACES.           
           05 WS-LAST-UPDATE-USERID   PIC X(07) VALUE SPACES.           
           05 WS-RESP-AREA-ID         PIC X(03) VALUE SPACES.           
           05 WS-REMARKS              PIC X(200) VALUE SPACES.          
           05 WS-TRAN-COMMENT         PIC X(200) VALUE SPACES.          
           05 WS-ARCHIVE-EXEMPT-CD    PIC X(01) VALUE SPACES.           
           05 WS-PREV-ARCH-EXMPT-CD   PIC X(01) VALUE SPACES.           
           05 WS-EXIST-ARCH-FCST      PIC X(01) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04326'.       
           05 WS-N                    PIC X(01) VALUE 'N'.              
           05 GTT-NAME                PIC X(26)                         
                                          VALUE 'SESSION.CSR04326_R1'.  
           05  WS-I                   PIC X(01)   VALUE 'I'.            
           05  WS-U                   PIC X(01)   VALUE 'U'.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05 RS-ACCOUNT-NO             PIC X(04)  VALUE SPACES.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05  S-ACCOUNT-NO             PIC X(13)  VALUE SPACES.        
                                                                        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                PIC X(13).                    
       01  PARM-PROCESS-CD                PIC X(01).                    
       01  PARM-FORECAST-TYPE-CD          PIC X(01).                    
       01  PARM-FORECAST-REASON-CD        PIC X(01).                    
       01  PARM-FORECAST-DT               PIC X(10).                    
       01  PARM-LAST-UPDATE-TS            PIC X(26).                    
       01  PARM-LAST-UPDATE-USERID        PIC X(07).                    
       01  PARM-REMARKS                   PIC X(200).                   
       01  PARM-TRAN-COMMENT              PIC X(200).                   
       01  PARM-ARCHIVE-EXEMPT-CD         PIC X(01).                    
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                 PARM-PROCESS-CD                        
                                 PARM-FORECAST-TYPE-CD                  
                                 PARM-FORECAST-REASON-CD                
                                 PARM-FORECAST-DT                       
                                 PARM-LAST-UPDATE-TS                    
                                 PARM-LAST-UPDATE-USERID                
                                 PARM-REMARKS                           
                                 PARM-TRAN-COMMENT                      
                                 PARM-ARCHIVE-EXEMPT-CD.                
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                 SELECT :S-RETURN-CODE AS RETURN_CODE                   
                       ,:S-ACCOUNT-NO  AS ACCOUNT_NO                    
                   FROM CIS.SYSDUMMY1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT :S-RETURN-CODE AS RETURN_CODE                           
MFA-TR*                ,:S-ACCOUNT-NO  AS ACCOUNT_NO                            
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           PERFORM 5200-GET-CURRENT-DATE     THRU 5200-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO              
           MOVE PARM-PROCESS-CD           TO WS-PROCESS-CD              
           MOVE PARM-FORECAST-TYPE-CD     TO WS-FORECAST-TYPE-CD        
           MOVE PARM-FORECAST-REASON-CD   TO WS-FORECAST-REASON-CD      
           MOVE PARM-FORECAST-DT          TO WS-FORECAST-DT             
           MOVE PARM-LAST-UPDATE-TS       TO WS-LAST-UPDATE-TS          
           MOVE PARM-LAST-UPDATE-USERID   TO WS-LAST-UPDATE-USERID      
           MOVE PARM-REMARKS              TO WS-REMARKS                 
           MOVE PARM-TRAN-COMMENT         TO WS-TRAN-COMMENT            
           MOVE PARM-ARCHIVE-EXEMPT-CD    TO WS-ARCHIVE-EXEMPT-CD.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 6000-INSERT-FCST   THRU 6000-EXIT.                   
           PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
            MOVE RS-ACCOUNT-NO              TO S-ACCOUNT-NO.            
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       5200-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TS                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*          ,:WS-CURRENT-TS = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
       5500-GET-FBDATE.                                                 
      *****************************************************************         
                                                                        
           MOVE WS-ACCOUNT-NO TO AT-ACCOUNT-NO                          
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
                 INTO :AT-ACCT-FINALED-DT                               
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED) WHERE                   
                 ACCOUNT_NO = :AT-ACCOUNT-NO                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCT_FINALED_DT                                            
MFA-TR*          INTO :AT-ACCT-FINALED-DT                                       
MFA-TR*          FROM CSS_ACCOUNT WHERE                                         
MFA-TR*          ACCOUNT_NO = :AT-ACCOUNT-NO                                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE  AT-ACCT-FINALED-DT TO AZ-ACCT-FINALED-DT            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-INSERT-FCST                                              *         
      *****************************************************************         
       6000-INSERT-FCST.                                                
                                                                        
                                                                        
           EVALUATE WS-PROCESS-CD                                       
               WHEN WS-I                                                
                  MOVE WS-ACCOUNT-NO TO AZ-ACCOUNT-NO                   
                  MOVE 'E' TO AZ-FORECAST-TYPE-CD                       
                  MOVE 'G' TO AZ-FORECAST-REASON-CD                     
                  MOVE WS-FORECAST-DT TO AZ-FORECAST-DT                 
                  MOVE WS-CURRENT-TS TO AZ-LAST-UPDATE-TS               
                  MOVE WS-LAST-UPDATE-USERID TO AZ-LAST-UPDATE-USERID   
                  MOVE WS-REMARKS TO AZ-REMARKS                         
                  PERFORM 5500-GET-FBDATE    THRU 5500-EXIT             
                                                                        
                  PERFORM 8010-INS-ARCH-FCST   THRU 8010-EXIT           
               WHEN WS-U                                                
                                                                        
                    MOVE WS-ACCOUNT-NO TO AA-ACCOUNT-NO                 
                                                                        
                    PERFORM 8018-SEL-ARCH-EXMPT THRU 8018-EXIT          
           END-EVALUATE.                                                
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  8010-INS-ARCH-FCST                                            *        
      ******************************************************************        
                                                                        
                                                                        
        8010-INS-ARCH-FCST.                                             
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_ARCHIVE_FCST                            
                       (                                                
                        ACCOUNT_NO                                      
                       ,FORECAST_TYPE_CD                                
                       ,FORECAST_REASON_CD                              
                       ,FORECAST_DT                                     
                       ,LAST_UPDATE_TS                                  
                       ,LAST_UPDATE_USERID                              
                       ,REMARKS                                         
                       ,ACCT_FINALED_DT                                 
                       )                                                
                VALUES                                                  
                       (                                                
                        :AZ-ACCOUNT-NO                                  
                       ,:AZ-FORECAST-TYPE-CD                            
                       ,:AZ-FORECAST-REASON-CD                          
                       ,IIF(TRY_CONVERT(DATE, :AZ-FORECAST-DT
              ) IS NULL OR (PATINDEX('%.%', :AZ-FORECAST-DT
              ) <> 0) OR (LEN(:AZ-FORECAST-DT) <> 10), CIS.CHAR2DATE(
                                                        :AZ-FORECAST-DT
              ), CONVERT(DATE, :AZ-FORECAST-DT) )                              
                       ,CIS.CHAR2TIMESTAMP(:AZ-LAST-UPDATE-TS)                  
                       ,:AZ-LAST-UPDATE-USERID                          
                       ,:AZ-REMARKS                                     
                       ,CIS.CHAR2TIMESTAMP(:AZ-ACCT-FINALED-DT)                 
                                                                        
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ARCHIVE_FCST                                    
MFA-TR*                (                                                        
MFA-TR*                 ACCOUNT_NO                                              
MFA-TR*                ,FORECAST_TYPE_CD                                        
MFA-TR*                ,FORECAST_REASON_CD                                      
MFA-TR*                ,FORECAST_DT                                             
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,REMARKS                                                 
MFA-TR*                ,ACCT_FINALED_DT                                         
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :AZ-ACCOUNT-NO                                          
MFA-TR*                ,:AZ-FORECAST-TYPE-CD                                    
MFA-TR*                ,:AZ-FORECAST-REASON-CD                                  
MFA-TR*                ,:AZ-FORECAST-DT                                         
MFA-TR*                ,:AZ-LAST-UPDATE-TS                                      
MFA-TR*                ,:AZ-LAST-UPDATE-USERID                                  
MFA-TR*                ,:AZ-REMARKS                                             
MFA-TR*                ,:AZ-ACCT-FINALED-DT                                     
MFA-TR*                                                                         
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 8015-MAINTENANCE-HISTORY THRU 8015-EXIT           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ARCHIVE_FCST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'FORECAST_TYPE_CD'        TO TABLE-ELEMENT-2         
              MOVE 'FORECAST_REASON_CD'      TO TABLE-ELEMENT-3         
              MOVE 'FORECAST_DT'             TO TABLE-ELEMENT-4         
              MOVE AZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE AZ-FORECAST-TYPE-CD       TO HOSTVAR-ELEMENT-4       
              MOVE AZ-FORECAST-REASON-CD     TO HOSTVAR-ELEMENT-2       
              MOVE AZ-FORECAST-DT            TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8010-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8015-MAINTENANCE-HISTORY.                                     *         
      *                                                               *         
      *                                                               *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
                                                                        
       8015-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '8015'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           MOVE WS-CURRENT-TS          TO MH-TRANS-HIST-SEQ-NO.         
           MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS.                
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           PERFORM 8030-GET-RESP-AREA-ID THRU 8030-EXIT.                
           MOVE WS-RESP-AREA-ID        TO MH-RESP-AREA-ID.              
           MOVE WS-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE WS-LAST-UPDATE-USERID  TO MH-USER-ID.                   
           MOVE 200                    TO MH-TRAN-COMMENT-LEN.          
                                                                        
           IF WS-PROCESS-CD = 'I'                                       
              MOVE 'CSR04326F'             TO MH-APPL-PROGRAM-ID        
              MOVE AZ-REMARKS              TO WS-TRAN-COMMENT           
              STRING 'ARCH FCST INSERT '  ' '                           
                    WS-TRAN-COMMENT DELIMITED  BY SIZE                  
                    INTO MH-TRAN-COMMENT-TEXT                           
           ELSE                                                         
             MOVE 'CSR04326'          TO MH-APPL-PROGRAM-ID             
            MOVE 'EXMPT FLAG' TO MI-COLUMN-DESC                         
            MOVE +20                 TO MI-PRV-COLUMN-VALUE-LEN         
            MOVE WS-PREV-ARCH-EXMPT-CD TO MI-PRV-COLUMN-VALUE-TEXT      
            MOVE +20                 TO MI-CHG-COLUMN-VALUE-LEN         
            MOVE WS-ARCHIVE-EXEMPT-CD TO MI-CHG-COLUMN-VALUE-TEXT       
           END-IF.                                                      
            MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO           
            MOVE +1                  TO MI-TRAN-APPL-NO                 
            PERFORM 6530-LOAD-MNT-TRANS-HIST                            
                                     THRU 6530-EXIT                     
           .                                                            
       8015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8017-DEL-ARCH-EXMPT                                            *        
      ******************************************************************        
                                                                        
       8017-DEL-ARCH-EXMPT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO         TO AA-ACCOUNT-NO                  
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_ARCHIVE_EXEMPT                             
              WHERE ACCOUNT_NO         = :AA-ACCOUNT-NO                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              STRING 'ARCH EXMPT DELETE '  ' '                          
                    WS-TRAN-COMMENT DELIMITED  BY SIZE                  
                      INTO MH-TRAN-COMMENT-TEXT                         
              PERFORM 8015-MAINTENANCE-HISTORY THRU 8015-EXIT           
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8017'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ARCHIVE_EXMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF
           END-IF                                                       
           .                                                            
       8017-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8018-SEL-ARCH-EXMPT                                            *        
      ******************************************************************        
                                                                        
       8018-SEL-ARCH-EXMPT.                                             
           EXEC SQL                                                     
              SELECT TOP(1) ARCHIVE_EXEMPT_CD                                  
                INTO :AA-ARCHIVE-EXEMPT-CD                              
                FROM                                                    
                CSS_ARCHIVE_EXEMPT WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AA-ACCOUNT-NO                       
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ARCHIVE_EXEMPT_CD                                          
MFA-TR*         INTO :AA-ARCHIVE-EXEMPT-CD                                      
MFA-TR*         FROM                                                            
MFA-TR*         CSS_ARCHIVE_EXEMPT                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AA-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AA-ARCHIVE-EXEMPT-CD TO WS-PREV-ARCH-EXMPT-CD   
                   MOVE WS-ARCHIVE-EXEMPT-CD  TO AA-ARCHIVE-EXEMPT-CD   
                   MOVE WS-LAST-UPDATE-USERID TO AA-LAST-UPDATE-USERID  
                   MOVE WS-CURRENT-TS TO AA-LAST-UPDATE-TS              
                   IF WS-PREV-ARCH-EXMPT-CD = ' '                       
                    PERFORM 8017-DEL-ARCH-EXMPT THRU 8017-EXIT          
                   ELSE                                                 
                    PERFORM 8019-UPD-ARCH-EXMPT THRU 8019-EXIT          
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE WS-ARCHIVE-EXEMPT-CD  TO AA-ARCHIVE-EXEMPT-CD   
                   MOVE WS-LAST-UPDATE-USERID TO AA-LAST-UPDATE-USERID  
                   MOVE WS-CURRENT-TS TO AA-LAST-UPDATE-TS              
                   PERFORM 8020-INS-ARCH-EXMPT   THRU 8020-EXIT         
A37666             STRING 'ARCH EXMPT INSERT '  ' '                     
A37666               WS-TRAN-COMMENT DELIMITED  BY SIZE                 
A37666                  INTO MH-TRAN-COMMENT-TEXT                       
A37666             PERFORM 8015-MAINTENANCE-HISTORY THRU 8015-EXIT      
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '8018'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE SPACES                    TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                 MOVE 'CSS_ARCHIVE_EXMPT'       TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE AA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
                                                                        
       8018-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8019-UPD-ARCH-EXMPT                                            *        
      ******************************************************************        
                                                                        
       8019-UPD-ARCH-EXMPT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO         TO AA-ACCOUNT-NO                  
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ARCHIVE_EXEMPT                                  
              SET ARCHIVE_EXEMPT_CD = :AA-ARCHIVE-EXEMPT-CD             
              WHERE ACCOUNT_NO      = :AA-ACCOUNT-NO                    
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              STRING 'ARCH EXMPT UPDATE '  ' '                          
                    WS-TRAN-COMMENT DELIMITED  BY SIZE                  
                      INTO MH-TRAN-COMMENT-TEXT                         
              PERFORM 8015-MAINTENANCE-HISTORY THRU 8015-EXIT           
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8019'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ARCHIVE_EXMPT'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF
           END-IF                                                       
           .                                                            
       8019-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INS-ARCH-EXMPT                                            *        
      ******************************************************************        
                                                                        
       8020-INS-ARCH-EXMPT.                                             
           EXEC SQL                                                     
                INSERT INTO CSS_ARCHIVE_EXEMPT                          
                       (                                                
                        ACCOUNT_NO                                      
                       ,ARCHIVE_EXEMPT_CD                               
                       ,LAST_UPDATE_USERID                              
                       ,LAST_UPDATE_TS                                  
                       )                                                
                VALUES                                                  
                       (                                                
                        :AA-ACCOUNT-NO                                  
                       ,:AA-ARCHIVE-EXEMPT-CD                           
                       ,:AA-LAST-UPDATE-USERID                          
                       ,CIS.CHAR2TIMESTAMP(:AA-LAST-UPDATE-TS)                  
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_ARCHIVE_EXEMPT                                  
MFA-TR*                (                                                        
MFA-TR*                 ACCOUNT_NO                                              
MFA-TR*                ,ARCHIVE_EXEMPT_CD                                       
MFA-TR*                ,LAST_UPDATE_USERID                                      
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :AA-ACCOUNT-NO                                          
MFA-TR*                ,:AA-ARCHIVE-EXEMPT-CD                                   
MFA-TR*                ,:AA-LAST-UPDATE-USERID                                  
MFA-TR*                ,:AA-LAST-UPDATE-TS                                      
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'ARCHIVE_EXMPT_CD'        TO TABLE-ELEMENT-2         
              MOVE AA-ARCHIVE-EXEMPT-CD      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8025-DEL-ARCH-FCST                                             *        
      ******************************************************************        
                                                                        
       8025-DEL-ARCH-FCST.                                              
                                                                        
           MOVE WS-ACCOUNT-NO         TO AZ-ACCOUNT-NO                  
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_ARCHIVE_FCST                               
              WHERE ACCOUNT_NO         = :AZ-ACCOUNT-NO                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             STRING 'ARCH FCST-DELETE,ARCH EXMT-INSERT ' ' '            
                  WS-TRAN-COMMENT DELIMITED  BY SIZE                    
                        INTO MH-TRAN-COMMENT-TEXT                       
              PERFORM 8015-MAINTENANCE-HISTORY THRU 8015-EXIT           
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
             STRING 'ARCH EXMT-INSERT ' ' '                             
                  WS-TRAN-COMMENT DELIMITED  BY SIZE                    
                        INTO MH-TRAN-COMMENT-TEXT                       
              PERFORM 8015-MAINTENANCE-HISTORY THRU 8015-EXIT           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8025'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ARCHIVE_FCST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF
           END-IF                                                       
           .                                                            
       8025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8030 GET RESP AREA ID                                          *        
      *  THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION         *        
      *  ACCORDING TO A USERS ID.                                      *        
      ******************************************************************        
       8030-GET-RESP-AREA-ID.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
               WHERE USER_ID = :WS-LAST-UPDATE-USERID                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*        WHERE USER_ID = :WS-LAST-UPDATE-USERID                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8030'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT '                TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'USER_ID'                TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE WS-LAST-UPDATE-USERID    TO HOSTVAR-ELEMENT-1        
              MOVE WS-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
              ADD +1                    TO CTR-ROWS.                    
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
