       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04325.                                      
COB303 DATE-WRITTEN.     FEB 01,2010.                                   
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00060000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00080000
      *--                   STORED PROCEDURE:  CSR04325              -- 00090001
      *---------------------------------------------------------------- 00100000
      *--                         S U M M A R Y                      -- 00110000
      *--                                                            -- 00120000
      *--  CSR04325 :                                                -- 00130001
      *--                                                            -- 00140000
      *--  #  RETRIEVES ARCHIVE FORECAST DETAILS FOR ACCOUNT         -- 00150038
      *--                                                            -- 00160000
      *---------------------------------------------------------------- 00170000
      *--                                                            -- 00180000
      *--  PARAMETERS                                                -- 00190000
      *--                                                            -- 00200000
      *--      IN                                                    -- 00210000
      *--                                                            -- 00220000
      *--            I_ACCOUNT_NO            CHAR(13)                -- 00230000
      *--                                                            -- 00260000
      *--      OUT                                                   -- 00270000
      *--           I_FORECAST_TYPE_CD        CHAR(1)                -- 00271038
      *--           I_FORECAST_REASON_CD      CHAR(1)                -- 00272038
      *--           I_FORECAST_DT             DATE                   -- 00273038
      *--           I_LAST_UPDATE_TS          TIMESTMP               -- 00274038
      *--           I_LAST_UPDATE_USERID      CHAR(7)                -- 00275038
      *--           I_REMARKS                 CHAR(200)              -- 00276038
      *--                                                            -- 00278038
      *--                                                            -- 00280000
      *--            NONE                                            -- 00290000
      *--                                                            -- 00300000
      *--      INOUT                                                 -- 00310000
      *--                                                            -- 00320000
      *--            NONE                                            -- 00330000
      *--                                                            -- 00340000
      *--  RESULT SET                                                -- 00350000
      *--                                                            -- 00360000
      *--      1                                                     -- 00370000
      *--                                                            -- 00380000
      *--                                                            -- 00390000
      *---------------------------------------------------------------- 00400000
      *--                        MODIFICATION LOG                    -- 00410000
      *--                                                            -- 00420000
      *--  DATE          INITIALS    COMMENTS                        -- 00430000
      *--  -----------   --------    ---------------------------------- 00440000
      *--  01 FEB 2010   DM94438     NEW CODE                        -- 00450001
      *--                                                            -- 00460000
      *---------------------------------------------------------------- 00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04325'.
MSQ017     COPY MFASQLM.
                                                                        
      ***************************************************************** 00530000
      *    DB2 INCLUDES                                               * 00540000
      ***************************************************************** 00550000
                                                                        
           EXEC SQL                                                     00570000
              INCLUDE SQLCA                                             00580000
           END-EXEC.                                                    00590000
                                                                        
      ***************************************************************** 00610000
      * CSS_ACCOUNT, AT                                               * 00620001
      ***************************************************************** 00630000
           EXEC SQL                                                     00640000
              INCLUDE TBACCT                                            00650001
           END-EXEC.                                                    00660000
      *                                                                 00960000
      ***************************************************************** 00960131
      * CSS_USER_PROFILE,PF                                           * 00960238
      ***************************************************************** 00960331
           EXEC SQL                                                     00960431
              INCLUDE TBUSRPRF                                          00960531
           END-EXEC.                                                    00960631
      ***************************************************************** 00960702
      * CSS_ARCHIEVE_FCST,AF                                          * 00960838
      ***************************************************************** 00960902
           EXEC SQL                                                     00961002
              INCLUDE TBARCFCS                                          00961102
           END-EXEC.                                                    00962002
      ***************************************************************** 00970000
      * CSS_ARCHIEVE_EXEMPT,AA                                        * 00972038
      ***************************************************************** 00973016
           EXEC SQL                                                     00974016
              INCLUDE TBACXMPT                                          00975016
           END-EXEC.                                                    00976016
      ***************************************************************** 00977016
      *    COBOL WORKING STORAGE COPY BOOKS                           * 00980000
      ***************************************************************** 00990000
           COPY CCA00001.                                               01000000
      *                                                                 01010000
      ***************************************************************** 01020000
      *    ERROR HANDLING COPY BOOK.                                  * 01030000
      ***************************************************************** 01040000
           EXEC SQL                                                     01050000
               INCLUDE CWSX0010                                         01060000
           END-EXEC.                                                    01070000
      *                                                                 01080000
      ***************************************************************** 01090000
      *    SQL ERROR CHECKING COPYBOOK.                               * 01100000
      ***************************************************************** 01110000
           COPY CWS00303.                                               01120000
                                                                        
      *                                                                 01140000
      ***************************************************************** 01150000
      *    WORK AREAS                                                 * 01160000
      ***************************************************************** 01170000
      *                                                                 01180000
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04325'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR04325_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                 01300000
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                 01340000
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                 01380000
      *---------------------------------------------------------------  01390000
      *--  ERROR PROCESSING VARIABLES                               --  01400000
      *---------------------------------------------------------------  01410000
      *                                                                 01420000
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
      *                                                                 01600000
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE        PIC S9(9) COMP VALUE 0.              
           10 S-ACCOUNT-NO         PIC X(13) VALUE SPACES.              
           10 S-FORECAST-TYPE-CD   PIC X(01) VALUE SPACES.              
           10 S-FORECAST-REASON-CD PIC X(01) VALUE SPACES.              
           10 S-FORECAST-DT        PIC X(10) VALUE SPACES.              
           10 S-LAST-UPDATE-TS     PIC X(26) VALUE SPACES.              
           10 S-LAST-UPDATE-USERID PIC X(07) VALUE SPACES.              
           10 S-REMARKS            PIC X(200) VALUE SPACES.             
           10 S-ARCHIVE-EXEMPT-CD  PIC X(01) VALUE SPACES.              
           10 S-USER-NAME          PIC X(29) VALUE SPACES.              
           10 S-ACCT-FINALED-DT    PIC X(26) VALUE SPACES.              
      *                                                                 01720000
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 01870000
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                 02020000
       01  WS-MISC-ITEMS.                                               
           05  WS-OPT-DESC-INT-LONG    PIC X(255) VALUE SPACES.         
           05  WS-OFFER-DESC-INT-LNG   PIC X(255) VALUE SPACES.         
           05  WS-CURRENT-ROW-NUM      PIC S9(4) COMP VALUE 0.          
           05  WS-HISTORY-ROW-NUM      PIC S9(4) COMP VALUE 0.          
           05  WS-APPLIED-A            PIC X(01) VALUE 'A'.             
           05  WS-OPEN-O               PIC X(01) VALUE 'O'.             
           05  WS-PENDING-P            PIC X(01) VALUE 'P'.             
           05  WS-RENEWED-R            PIC X(01) VALUE 'R'.             
           05  WS-CURRENT-ROW          PIC X(01) VALUE 'C'.             
           05  WS-HISTORY-ROW          PIC X(01) VALUE 'H'.             
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
           05  WS-MST-ACCT-NO          PIC 9(13) VALUE ZERO.            
           05  WS-IC-NO                PIC 9(04) VALUE ZERO.            
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-2     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND2            PIC S9(04) COMP VALUE +0.        
           05  WS-DEST-ID              PIC X(10).                       
           05  WS-HOLD-NAME-OUTPUT     PIC X(29) VALUE SPACES.          
           05  WS-LAST-UPDATE-USERID   PIC X(07) VALUE SPACES.          
           05  WS-SUB                  PIC S9(8) COMP VALUE ZERO.       
           05  WS-DELIMITER            PIC X VALUE ';'.                 
           05  WS-STRING.                                               
               10 WS-STRING-X             OCCURS 51 TIMES PIC X.        
                                                                        
      *                                                                 02160000
      *01  TDS-RETURN-FIELDS.                                           02170039
      *    05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          02180039
      *                                                                 02190000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 02270000
      ***************************************************************** 02280000
      **  CURSORS DECLARATION FOR RETRIEVING ROWS FROM THE            **02290019
      **  CSS_ARCHIVE_FCST  TABLE FOR A GIVEN ACCOUNT                ** 02300019
      **  WITH ARCHIVE EXEMPT FLAG IN CSS_ARCHIVE_EXEMPT  TABLE      ** 02310019
      ***************************************************************** 02320000
                                                                        
           EXEC SQL                                                     
              DECLARE ARCHFCT_CSR CURSOR FOR                            
                SELECT  AZ.ACCOUNT_NO                                   
                 ,COALESCE(AZ.FORECAST_TYPE_CD, ' ')                      
                 ,COALESCE(AZ.FORECAST_REASON_CD, ' ')                    
                 ,COALESCE((CIS.CHAR2$DATE(
           AZ.FORECAST_DT,'USA')),'2999-12-31') 
                 ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           AZ.LAST_UPDATE_TS,CIS.CHAR2TIMESTAMP(
              '2999-12-31-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')
                 ,COALESCE(AZ.LAST_UPDATE_USERID,'  ')                    
                 ,COALESCE(AZ.REMARKS, ' ')                               
                ,REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(
           AZ.ACCT_FINALED_DT,CIS.CHAR2TIMESTAMP(
              '2999-12-31-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')
                  FROM CSS_ARCHIVE_FCST AZ WITH(READUNCOMMITTED)                
                  WHERE AZ.ACCOUNT_NO  = :AZ-ACCOUNT-NO                 
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02340004
MFA-TR*       DECLARE ARCHFCT_CSR CURSOR FOR                            02350003
MFA-TR*         SELECT  AZ.ACCOUNT_NO                                   02360004
MFA-TR*          ,IFNULL(AZ.FORECAST_TYPE_CD, ' ')                      02360126
MFA-TR*          ,IFNULL(AZ.FORECAST_REASON_CD, ' ')                    02370026
MFA-TR*          ,IFNULL((CHAR(DATE(AZ.FORECAST_DT),USA)),'2999-12-31') 02380041
MFA-TR*          ,IFNULL(AZ.LAST_UPDATE_TS,'2999-12-31-00.00.00.000000')02390026
MFA-TR*          ,IFNULL(AZ.LAST_UPDATE_USERID,'  ')                    02400026
MFA-TR*          ,IFNULL(AZ.REMARKS, ' ')                               02410026
MFA-TR*         ,IFNULL(AZ.ACCT_FINALED_DT,'2999-12-31-00.00.00.000000')02413044
MFA-TR*           FROM CSS_ARCHIVE_FCST AZ                              02450004
MFA-TR*           WHERE AZ.ACCOUNT_NO  = :AZ-ACCOUNT-NO                 02451019
MFA-TR*          FOR FETCH ONLY WITH UR                                 02500000
MFA-TR*    END-EXEC.                                                    02510019
                                                                        
           EXEC SQL                                                     
              DECLARE ARCHEXM_CSR CURSOR FOR                            
                SELECT  AA.ACCOUNT_NO                                   
                       ,COALESCE(AA.ARCHIVE_EXEMPT_CD, ' ')               
                  FROM CSS_ARCHIVE_EXEMPT AA WITH(READUNCOMMITTED)              
                  WHERE AA.ACCOUNT_NO  = :AA-ACCOUNT-NO                 
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02520119
MFA-TR*       DECLARE ARCHEXM_CSR CURSOR FOR                            02521019
MFA-TR*         SELECT  AA.ACCOUNT_NO                                   02522019
MFA-TR*                ,IFNULL(AA.ARCHIVE_EXEMPT_CD, ' ')               02523025
MFA-TR*           FROM CSS_ARCHIVE_EXEMPT AA                            02529019
MFA-TR*           WHERE AA.ACCOUNT_NO  = :AA-ACCOUNT-NO                 02529119
MFA-TR*          FOR FETCH ONLY WITH UR                                 02529319
MFA-TR*    END-EXEC.                                                    02529419
                                                                        
       LINKAGE SECTION.                                                 
       01 I-ACCOUNT-NO          PIC  X(13).                             
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                               .                                        
                                                                        
      ***************************************************************** 02630000
      * 0000-MAINLINE                                                 * 02640000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                     * 02650000
      ***************************************************************** 02660000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE                            
              THRU 1000-EXIT.                                           
                                                                        
           PERFORM 2000-PROCESS-OUTPUT                                  
              THRU 2000-EXIT.                                           
                                                                        
           PERFORM 9999-END-PROGRAM                                     
              THRU 9999-EXIT.                                           
           GOBACK.                                                      
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  02830000
      *--  0100A-DECLARE-GTT                                        --  02840000
      *--  DECLARE TEMPORARY TABLE                                  --  02850000
      *---------------------------------------------------------------  02860000
      *                                                                 02870000
       0100A-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04325_R1'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04325_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04325_R1
              (                                                       
                RETURN_CODE        INT                              
               ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2            
               ,FORECAST_TYPE_CD CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                           
               ,FORECAST_REASON_CD CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                           
               ,FORECAST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
               ,LAST_UPDATE_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                           
               ,REMARKS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2              
               ,ARCHIVE_EXEMPT_CD CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                           
               ,USER_NAME CHAR(29)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,ACCT_FINALED_DT CHAR(26)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                           
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS                             
                 THRU 8000A-EXIT                                        
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04325_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      *---------------------------------------------------------------* 03340000
      *--  SET UP SQL ERROR PROCESSING                             ---* 03350000
      *--  DECLARE ASSOCIATED CURSOR                               ---* 03360000
      *---------------------------------------------------------------* 03370000
      *                                                                 03380000
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT                                    
              THRU 0100A-EXIT.                                          
      *                                                                 03580000
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
                SELECT RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,FORECAST_TYPE_CD                                 
                      ,FORECAST_REASON_CD                               
                      ,FORECAST_DT                                      
                      ,LAST_UPDATE_TS                                   
                      ,LAST_UPDATE_USERID                               
                      ,REMARKS                                          
                      ,ARCHIVE_EXEMPT_CD                                
                      ,USER_NAME                                        
                      ,ACCT_FINALED_DT                                  
                  FROM #CSR04325_R1                              
                  ORDER BY LAST_UPDATE_TS DESC                          
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03590000
MFA-TR*                                                                 03600000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        03610000
MFA-TR*         SELECT RETURN_CODE                                      03621004
MFA-TR*               ,ACCOUNT_NO                                       03621119
MFA-TR*               ,FORECAST_TYPE_CD                                 03622004
MFA-TR*               ,FORECAST_REASON_CD                               03623004
MFA-TR*               ,FORECAST_DT                                      03624004
MFA-TR*               ,LAST_UPDATE_TS                                   03625004
MFA-TR*               ,LAST_UPDATE_USERID                               03626004
MFA-TR*               ,REMARKS                                          03680004
MFA-TR*               ,ARCHIVE_EXEMPT_CD                                03690004
MFA-TR*               ,USER_NAME                                        03700036
MFA-TR*               ,ACCT_FINALED_DT                                  03710045
MFA-TR*           FROM SESSION.CSR04325_R1                              03720001
MFA-TR*           ORDER BY LAST_UPDATE_TS DESC                          03721029
MFA-TR*                                                                 03730000
MFA-TR*    END-EXEC.                                                    03740000
      *                                                                 03750000
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03790000
      * 2000-PROCESS-OUTPUT.                                          * 03800000
      *                                                               * 03810000
      ***************************************************************** 03820000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT                                    
              THRU 2200-EXIT.                                           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 03920000
      ***************************************************************** 03930000
      * 2200-BUILD-RESULT                                             * 03940000
      *                                                               * 03950000
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                     * 03960000
      *                                                               * 03970000
      ***************************************************************** 03980000
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                 04010000
           MOVE I-ACCOUNT-NO                TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO               TO AZ-ACCOUNT-NO.           
                                                                        
           PERFORM 7000-OPEN-ARCHFCT-CURSOR                             
              THRU 7000-EXIT.                                           
                                                                        
           PERFORM 7100-FETCH-ARCHFCT-CURSOR                            
              THRU 7100-EXIT.                                           
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              IF WS-LAST-UPDATE-USERID NOT EQUAL SPACES                 
                 MOVE WS-LAST-UPDATE-USERID TO PF-USER-ID               
                 PERFORM 7975-SELECT-USER-NAME  THRU 7975-EXIT          
                 PERFORM 2600-PROCESS-NAME      THRU 2600-EXIT          
              ELSE                                                      
                 MOVE SPACES  TO  WS-HOLD-NAME-OUTPUT                   
              END-IF                                                    
                                                                        
              PERFORM 2300-MOVE-VALUES                                  
                 THRU 2300-EXIT                                         
                                                                        
              PERFORM 7100-FETCH-ARCHFCT-CURSOR                         
                 THRU 7100-EXIT                                         
                                                                        
              ADD 1 TO WS-ROW-COUNT                                     
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7200-CLOSE-ARCHFCT-CURSOR                            
              THRU 7200-EXIT.                                           
                                                                        
           IF WS-ROW-COUNT = 0                                          
              MOVE WS-ACCOUNT-NO  TO AA-ACCOUNT-NO                      
                                                                        
              PERFORM 7500-OPEN-ARCHEXM-CURSOR                          
                 THRU 7500-EXIT                                         
                                                                        
              PERFORM 7510-FETCH-ARCHEXM-CURSOR                         
                 THRU 7510-EXIT                                         
                                                                        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE AA-ARCHIVE-EXEMPT-CD TO S-ARCHIVE-EXEMPT-CD       
                 MOVE 0                      TO  S-RETURN-CODE          
                 MOVE AA-ACCOUNT-NO          TO  S-ACCOUNT-NO           
                 MOVE SPACES                 TO  S-FORECAST-TYPE-CD     
                 MOVE SPACES                 TO  S-FORECAST-REASON-CD   
                 MOVE SPACES                 TO  S-FORECAST-DT          
                 MOVE SPACES                 TO  S-LAST-UPDATE-TS       
                 MOVE SPACES                 TO  S-LAST-UPDATE-USERID   
                 MOVE SPACES                 TO  S-REMARKS              
                 MOVE SPACES                 TO  S-USER-NAME            
                 MOVE SPACES                 TO  S-ACCT-FINALED-DT      
                 PERFORM 8100-SEND-RESULT    THRU 8100-EXIT             
                 PERFORM 7510-FETCH-ARCHEXM-CURSOR                      
                    THRU 7510-EXIT                                      
              END-PERFORM                                               
                                                                        
              PERFORM 7520-CLOSE-ARCHEXM-CURSOR                         
                  THRU 7520-EXIT                                        
           END-IF.                                                      
      *                                                                 04225019
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE NOT-FOUND                TO   S-RETURN-CODE          
              PERFORM 8100-SEND-RESULT                                  
                 THRU 8100-EXIT                                         
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04320000
      ***************************************************************** 04330000
      * 2300-MOVE-VALUES                                              * 04340000
      *                                                               * 04350000
      *     MOVE VALUES INTO RESULT SET.                              * 04360000
      *                                                               * 04370000
      ***************************************************************** 04380000
       2300-MOVE-VALUES.                                                
           MOVE 0                      TO  S-RETURN-CODE                
           MOVE AZ-ACCOUNT-NO          TO  S-ACCOUNT-NO                 
           MOVE AZ-FORECAST-TYPE-CD    TO  S-FORECAST-TYPE-CD           
           MOVE AZ-FORECAST-REASON-CD  TO  S-FORECAST-REASON-CD         
           MOVE AZ-FORECAST-DT         TO  S-FORECAST-DT                
           MOVE AZ-LAST-UPDATE-TS      TO  S-LAST-UPDATE-TS             
           MOVE AZ-LAST-UPDATE-USERID  TO  S-LAST-UPDATE-USERID         
           MOVE AZ-REMARKS             TO  S-REMARKS                    
           MOVE AZ-ACCT-FINALED-DT     TO  S-ACCT-FINALED-DT            
           MOVE WS-HOLD-NAME-OUTPUT    TO  S-USER-NAME                  
           MOVE SPACES                 TO  S-ARCHIVE-EXEMPT-CD          
                                                                        
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
      *                                                                 04680000
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************** 06400000
      * 7000-OPEN-ARCHFCT-CURSOR.                                       06410005
      ***************************************************************** 06420000
                                                                        
       7000-OPEN-ARCHFCT-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN ARCHFCT_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   =  SUCCESSFUL-CALL                
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN '                  TO ABEND-FUNCTION           
              MOVE 'CSS_ARCHIVE_FCST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 06740000
      * 7100-FETCH-ARCHFCT-CURSOR.                                    * 06750005
      *     FETCH CURSOR TO GET ALL RECORDS SELECTED.                 * 06760000
      ***************************************************************** 06770000
                                                                        
       7100-FETCH-ARCHFCT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH ARCHFCT_CSR                                         
              INTO                                                      
                   :AZ-ACCOUNT-NO                                       
                  ,:AZ-FORECAST-TYPE-CD                                 
                  ,:AZ-FORECAST-REASON-CD                               
                  ,:AZ-FORECAST-DT                                      
                  ,:AZ-LAST-UPDATE-TS                                   
                  ,:AZ-LAST-UPDATE-USERID                               
                  ,:AZ-REMARKS                                          
                  ,:AZ-ACCT-FINALED-DT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE AZ-LAST-UPDATE-USERID TO WS-LAST-UPDATE-USERID       
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ARCHIVE_FCST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE  AZ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07190000
      * 7200-CLOSE-ARCHFCT-CURSOR.                                    * 07200005
      ***************************************************************** 07210000
                                                                        
       7200-CLOSE-ARCHFCT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE ARCHFCT_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ARCHIVE_FCST'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE  AZ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07530019
      * 7500-OPEN-ARCHEXM-CURSOR.                                       07540021
      ***************************************************************** 07540119
                                                                        
       7500-OPEN-ARCHEXM-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN ARCHEXM_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   =  SUCCESSFUL-CALL                
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN '                  TO ABEND-FUNCTION           
              MOVE 'CSS_ARCHIVE_EXMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07543019
      * 7510-FETCH-ARCHEXM-CURSOR.                                    * 07543121
      *     FETCH CURSOR TO GET ALL RECORDS SELECTED.                 * 07543219
      ***************************************************************** 07543319
                                                                        
       7510-FETCH-ARCHEXM-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH ARCHEXM_CSR                                         
              INTO                                                      
                  :AA-ACCOUNT-NO                                        
                  ,:AA-ARCHIVE-EXEMPT-CD                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7510'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ARCHIVE_EXMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE  AA-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07547019
      * 7520-CLOSE-ARCHEXM-CURSOR.                                    * 07547121
      ***************************************************************** 07547219
                                                                        
       7520-CLOSE-ARCHEXM-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE ARCHEXM_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7520'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ARCHIVE_EXMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE  AA-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07550131
      * 2600-PROCESS-NAME                                             * 07550231
      *    -- THIS MODULE RETRIEVES THE USER NAME TO THE PANEL --     * 07550331
      ***************************************************************** 07550431
       2600-PROCESS-NAME.                                               
                                                                        
           MOVE SPACES           TO    WS-HOLD-NAME-OUTPUT.             
                                                                        
           MOVE PF-FIRST-NAME    TO    WS-STRING.                       
           PERFORM 2610-PROCESS-FROM-STRING   THRU  2610-EXIT.          
           MOVE WS-STRING        TO    PF-FIRST-NAME.                   
                                                                        
           MOVE PF-LAST-NAME     TO    WS-STRING.                       
           PERFORM 2610-PROCESS-FROM-STRING   THRU  2610-EXIT.          
           MOVE WS-STRING        TO    PF-LAST-NAME.                    
                                                                        
           MOVE PF-MIDDLE-NAME   TO    WS-STRING.                       
           PERFORM 2610-PROCESS-FROM-STRING   THRU  2610-EXIT.          
           MOVE WS-STRING        TO    PF-MIDDLE-NAME.                  
                                                                        
           STRING PF-LAST-NAME DELIMITED WS-DELIMITER                   
                  ', ' DELIMITED SIZE                                   
                  PF-FIRST-NAME DELIMITED WS-DELIMITER                  
                  ' ' DELIMITED SIZE                                    
                  PF-MIDDLE-NAME DELIMITED WS-DELIMITER                 
             INTO WS-HOLD-NAME-OUTPUT                                   
           END-STRING.                                                  
                                                                        
           IF WS-HOLD-NAME-OUTPUT (1:6) EQUAL 'SYSTEM'                  
              MOVE SPACES TO WS-HOLD-NAME-OUTPUT (7:23)                 
           ELSE                                                         
              IF WS-HOLD-NAME-OUTPUT (1:1) EQUAL ','                    
                 MOVE SPACES TO WS-HOLD-NAME-OUTPUT                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2610-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
              VARYING WS-SUB FROM 15 BY -1                              
                  UNTIL WS-SUB < 1                                      
                  OR WS-STRING-X(WS-SUB) NOT = SPACE                    
           END-PERFORM.                                                 
           ADD 1      TO   WS-SUB.                                      
           MOVE WS-DELIMITER  TO WS-STRING-X(WS-SUB).                   
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************07555231
      ***************************************************************** 07555331
      * 7975-SELECT-USER-NAME                                         * 07555431
      *    -- THIS MODULE SELECTS THE USER NAME FOR PROCESSING        * 07555531
      ***************************************************************** 07555631
       7975-SELECT-USER-NAME.                                           
                                                                        
           MOVE '7975'  TO ACTIVE-PARAGRAPH.                            
                                                                        
           EXEC SQL                                                     
             SELECT   FIRST_NAME,                                       
                      MIDDLE_NAME,                                      
                      LAST_NAME                                         
               INTO   :PF-FIRST-NAME,                                   
                      :PF-MIDDLE-NAME,                                  
                      :PF-LAST-NAME                                     
               FROM   CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
              WHERE   USER_ID   =  :PF-USER-ID                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07556131
MFA-TR*      SELECT   FIRST_NAME,                                       07556231
MFA-TR*               MIDDLE_NAME,                                      07556331
MFA-TR*               LAST_NAME                                         07556431
MFA-TR*        INTO   :PF-FIRST-NAME,                                   07556531
MFA-TR*               :PF-MIDDLE-NAME,                                  07556631
MFA-TR*               :PF-LAST-NAME                                     07556731
MFA-TR*        FROM   CSS_USER_PROFILE                                  07556831
MFA-TR*       WHERE   USER_ID   =  :PF-USER-ID                          07556931
MFA-TR*       WITH UR                                                   07557038
MFA-TR*    END-EXEC.                                                    07557131

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE        TO WS-ACTIVE-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             NEXT SENTENCE                                              
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE SPACES      TO PF-FIRST-NAME,                       
                                   PF-LAST-NAME,                        
                                   PF-MIDDLE-NAME                       
             ELSE                                                       
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_USER_PROFILE'   TO TABLE-1                     
               MOVE 'USER_ID'            TO TABLE-ELEMENT-1             
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
               MOVE  PF-USER-ID          TO HOSTVAR-ELEMENT-1           
               MOVE  WS-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
             END-IF                                                     
           END-IF.                                                      
                                                                        
       7975-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 07559819
      * 8000A-DELETE-GTT-ROWS.                                        * 07559919
      ***************************************************************** 07560000
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 07570000
           MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.       
                                                                        
      *                                                                 07600000
            EXEC SQL                                                    
                DELETE FROM #CSR04325_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    07610000
MFA-TR*         DELETE FROM SESSION.CSR04325_R1                         07620001
MFA-TR*     END-EXEC.                                                   07630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07640000
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
      *                                                                 07660000
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE SQLCODE                 TO ABEND-SQLCODE            
               MOVE SQLSTATE                TO ABEND-SQLSTATE           
               MOVE '8000A'                 TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSR04325_R1'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               MOVE SPACES                  TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 07830000
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 07860000
      ****************************************************************  07870000
      * 8100-SEND-RESULT                                             *  07880000
      ****************************************************************  07890000
       8100-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR04325_R1'   TO S-SQL-STATEMENT-V.       
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04325_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,ACCOUNT_NO                                         
                    ,FORECAST_TYPE_CD                                   
                    ,FORECAST_REASON_CD                                 
                    ,FORECAST_DT                                        
                    ,LAST_UPDATE_TS                                     
                    ,LAST_UPDATE_USERID                                 
                    ,REMARKS                                            
                    ,ARCHIVE_EXEMPT_CD                                  
                    ,USER_NAME                                          
                    ,ACCT_FINALED_DT                                    
                   )                                                    
               VALUES                                                   
                   (                                                    
                     :S-RETURN-CODE                                     
                    ,:S-ACCOUNT-NO                                      
                    ,:S-FORECAST-TYPE-CD                                
                    ,:S-FORECAST-REASON-CD                              
                    ,:S-FORECAST-DT                                     
                    ,:S-LAST-UPDATE-TS                                  
                    ,:S-LAST-UPDATE-USERID                              
                    ,:S-REMARKS                                         
                    ,:S-ARCHIVE-EXEMPT-CD                               
                    ,:S-USER-NAME                                       
                    ,:S-ACCT-FINALED-DT                                 
                   )                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     07940000
MFA-TR*        INSERT INTO SESSION.CSR04325_R1                          07950001
MFA-TR*            (                                                    07960000
MFA-TR*              RETURN_CODE                                        07970000
MFA-TR*             ,ACCOUNT_NO                                         07970105
MFA-TR*             ,FORECAST_TYPE_CD                                   07971005
MFA-TR*             ,FORECAST_REASON_CD                                 07972005
MFA-TR*             ,FORECAST_DT                                        07973005
MFA-TR*             ,LAST_UPDATE_TS                                     07974005
MFA-TR*             ,LAST_UPDATE_USERID                                 07975005
MFA-TR*             ,REMARKS                                            08030005
MFA-TR*             ,ARCHIVE_EXEMPT_CD                                  08040013
MFA-TR*             ,USER_NAME                                          08050035
MFA-TR*             ,ACCT_FINALED_DT                                    08060042
MFA-TR*            )                                                    08070000
MFA-TR*        VALUES                                                   08080006
MFA-TR*            (                                                    08090000
MFA-TR*              :S-RETURN-CODE                                     08100000
MFA-TR*             ,:S-ACCOUNT-NO                                      08101011
MFA-TR*             ,:S-FORECAST-TYPE-CD                                08110005
MFA-TR*             ,:S-FORECAST-REASON-CD                              08120005
MFA-TR*             ,:S-FORECAST-DT                                     08130005
MFA-TR*             ,:S-LAST-UPDATE-TS                                  08140005
MFA-TR*             ,:S-LAST-UPDATE-USERID                              08150005
MFA-TR*             ,:S-REMARKS                                         08151005
MFA-TR*             ,:S-ARCHIVE-EXEMPT-CD                               08152008
MFA-TR*             ,:S-USER-NAME                                       08153035
MFA-TR*             ,:S-ACCT-FINALED-DT                                 08154042
MFA-TR*            )                                                    08200000
MFA-TR*    END-EXEC.                                                    08210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
              INITIALIZE GTT-RETURN-FIELDS                              
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04325_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 08400000
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08441038
      * 9700-PROCESS-ABEND - COMBINED ERROR ON-LINE/BATCH ERROR HANDLER*08442038
      ******************************************************************08443038
           EXEC SQL                                                     08450000
              INCLUDE CPD0023C                                          08460000
           END-EXEC.                                                    08470000
                                                                        
      ***************************************************************** 08490000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     * 08500000
      ***************************************************************** 08510000
           EXEC SQL                                                     08520000
              INCLUDE CPDSP300                                          08530000
           END-EXEC.                                                    08540000
                                                                        
      ***************************************************************** 08560000
      *       END PROGRAM COPYLIB                                     * 08570000
      ***************************************************************** 08580000
           EXEC SQL                                                     08590000
             INCLUDE CPD00320                                           08600000
           END-EXEC.                                                    08610000
      *                                                                 08620000
