       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04316.                                            
       DATE-WRITTEN. 01/21/2010.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO RETRIEVE THE IVR NEXT DAY ORDER     *        
      *  CALL LIST FROM CSS_SO_IVR_NDO_CALL_LIST TABLE                 *        
      *                 PANEL 792                                      *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/21/2010  SC41135  PROCEDURE ORIGINALLY CODED               *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04316'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    PR - CSS_PREMISE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CU - CSS_CUSTOMER                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    VO - CSS_SO_DATA                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    YV - HST_SO_DATA                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    NL - CSS_SO_NDO_CALL_LIST                                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNDOLST                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    NK - HST_SO_NDO_CALL_LIST                                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHNDOLS                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    A4 - CSS_ZIP_CD                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    CB - CSS_CUST_PHONE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CP - CSS_CUST_PLAN                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CH - CSS_CUST_PREM_HIST                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
      *    COPY CWS00056.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR ERROR-HANDLING                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04316_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-ACCOUNT-NO                PIC X(13).                  
           05  RS-SERV-ORDER-NO             PIC X(13).                  
           05  RS-ORDER-TYPE-CD             PIC X(05).                  
           05  RS-ADDRESS                   PIC X(76).                  
           05  RS-CITY                      PIC X(26).                  
           05  RS-NAME                      PIC X(26).                  
           05  RS-PHONE-NO                  PIC X(10).                  
           05  RS-CALL-STATUS-CD            PIC X(1).                   
           05  RS-CALL-RESULT-CD            PIC X(1) VALUE SPACES.      
           05  RS-CALL-COUNT-NUM            PIC 9(1).                   
           05  RS-CALL-COUNT                REDEFINES RS-CALL-COUNT-NUM 
                                            PIC X(1).                   
           05  RS-LOCAL-OFFICE              PIC X(3).                   
           05  RS-WORK-AREA-ID              PIC X(12).                  
           05  RS-ASSIGNED-DATETIME         PIC X(26).                  
           05  RS-LAST-UPDATE-TS            PIC X(26).                  
           05  RS-LAST-CALL-TS              PIC X(26).                  
           05  RS-LAST-UPDATE-USERID        PIC X(7).                   
           05  RS-SELECT-FLAG               PIC X(01) VALUE SPACES.     
           05  RS-ERROR-DESC                PIC X(40) VALUE SPACES.     
           05  RS-TOTAL                     PIC S9(9) COMP VALUE 0.     
           05  RS-ROW-NO                    PIC S9(9) COMP VALUE 0.     
                                                                        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE               PIC S9(9) COMP.              
           05  S-ACCOUNT-NO                PIC X(13).                   
           05  S-SERV-ORDER-NO             PIC X(13).                   
           05  S-ORDER-TYPE-CD             PIC X(05).                   
           05  S-ADDRESS                   PIC X(76).                   
           05  S-CITY                      PIC X(26).                   
           05  S-NAME                      PIC X(26).                   
           05  S-PHONE-NO                  PIC X(10).                   
           05  S-CALL-STATUS-CD            PIC X(1).                    
           05  S-CALL-RESULT-CD            PIC X(1).                    
           05  S-CALL-COUNT                PIC X(1).                    
           05  S-LOCAL-OFFICE              PIC X(3).                    
           05  S-WORK-AREA-ID              PIC X(12).                   
           05  S-ASSIGNED-DATETIME         PIC X(26).                   
           05  S-LAST-UPDATE-TS            PIC X(26).                   
           05  S-LAST-CALL-TS              PIC X(26).                   
           05  S-LAST-UPDATE-USERID        PIC X(07).                   
           05  S-SELECT-FLAG               PIC X(01) VALUE SPACES.      
           05  S-ERROR-DESC                PIC X(40) VALUE SPACES.      
           05  S-TOTAL                     PIC S9(9) COMP VALUE 0.      
           05  S-ROW-NO                    PIC S9(9) COMP VALUE 0.      
      *                                                                         
      ******************************************************************        
      *    BETWEEN FIELD WORK AREAS                                    *        
      ******************************************************************        
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-FROM.                                                 
               10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR04316'.  
           05  WS-CUST-LAST-NAME            PIC X(40) VALUE SPACES.     
           05  WS-CUST-FIRST-NAME           PIC X(15) VALUE SPACES.     
           05  WS-CUST-MIDDLE-NAME          PIC X(15) VALUE SPACES.     
           05  WS-CUST-FULL-NAME            PIC X(76) VALUE SPACES.     
           05  WS-CUST-NAME-FORMAT          PIC X(01) VALUE SPACES.     
           05  WS-CUST-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.     
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X             OCCURS 80 TIMES             
                                            INDEXED BY WS-ADD-SUB.      
                   15  FILLER               PIC X.                      
           05  WS-WORK-AREA-ID              PIC X(12) VALUE SPACES.     
           05  WS-LOCAL-OFFICE              PIC X(03) VALUE SPACES.     
           05  WS-COMPANY-NO                PIC X(02) VALUE SPACES.     
           05  WS-ORDER-TYPE-CD             PIC X(05) VALUE SPACES.     
           05  WS-CALL-STATUS-CD            PIC X(01) VALUE SPACES.     
           05  WS-CALL-RESULT-CD            PIC X(01) VALUE SPACES.     
           05  WS-START-DATE                PIC X(10) VALUE SPACES.     
           05  WS-END-DATE                  PIC X(10) VALUE SPACES.     
           05  WS-ROW-FOUND                 PIC X(01) VALUE 'N'.        
           05  WS-SELECTION                 PIC X(01) VALUE SPACES.     
           05  WS-CURRENT                   PIC X(01) VALUE 'C'.        
           05  WS-HISTORY                   PIC X(01) VALUE 'H'.        
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-NULL-UPDATE-TS       PIC S9(04)    COMP   VALUE +0.   
           05  WS-NULL-CALL-TS         PIC S9(04)    COMP   VALUE +0.   
           05  WS-NULL-ASSIGNED-TS     PIC S9(04)    COMP   VALUE +0.   
           05  WS-TOTAL                PIC S9(9)   USAGE COMP VALUE 1.  
                                                                        
       01  WS-NEXT-VARAIBLES.                                           
           05  WS-NEXT-COUNTER              PIC S9(4) COMP VALUE 1.     
           05  WS-MULTIPLIER                PIC X(02) VALUE '00'.       
           05  WS-NEXT-MULTIPLIER           REDEFINES WS-MULTIPLIER     
                                            PIC 9(2).                   
           05  WS-ROWS-PROCESSED            PIC 9(4)  VALUE 1.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 100.   
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-COMPANY-NO           PIC X(02).                         
       01  PARM-LOCAL-OFFICE         PIC X(03).                         
       01  PARM-WORK-AREA-ID         PIC X(12).                         
       01  PARM-ORDER-TYPE-CD        PIC X(05).                         
       01  PARM-CALL-STATUS-CD       PIC X(1).                          
       01  PARM-CALL-RESULT-CD       PIC X(1).                          
       01  PARM-START-DATE           PIC X(26).                         
       01  PARM-END-DATE             PIC X(26).                         
       01  PARM-SELECTION            PIC X(01).                         
       01  PARM-NEXT-COUNTER         PIC X(02).                         
      ******************************************************************        
      *    CALL-LIST CURSOR USED TO RETRIEVE FROM CSS_SO_NDO_CALL_LIST *        
      ******************************************************************        
           EXEC SQL DECLARE CALL-LIST-CUR CURSOR WITH HOLD FOR          
              SELECT  NL.ACCOUNT_NO,                                    
                      NL.SERV_ORDER_NO,                                 
                      NL.PHONE_NO,                                      
                      NL.CALL_STATUS_CD,                                
                      NL.CALL_RESULT_CD,                                
                      NL.CALL_COUNT,                                    
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           NL.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                             
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           NL.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
                      NL.LAST_UPDATE_USERID,                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), NL.LAST_CALL_TS
           , 121), ' ', '-'), ':', '.') LAST_CALL_TS,                          
                      VO.ORDER_TYPE_CD,                                 
                      VO.LOCAL_OFFICE,                                  
                      VO.WORK_AREA_ID,                                  
                      HT.CUSTOMER_NO,                                   
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO                                       
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_SO_NDO_CALL_LIST NL WITH(READUNCOMMITTED),            
                      CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE VO.COMPANY_NO      = :WS-COMPANY-NO               
                  AND VO.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD         
                  AND VO.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE          
                  AND VO.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID          
                  AND VO.SERV_ORDER_NO   = NL.SERV_ORDER_NO             
                  AND NL.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD         
                  AND NL.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD        
                AND CAST(NL.ASSIGNED_DATETIME AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )  
                AND CAST(NL.ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )    
                  AND NL.ACCOUNT_NO              = HT.ACCOUNT_NO        
                  AND HT.NAME_ID                 = DQ.NAME_ID           
                  AND DQ.NAME_TYPE               = 'CN'                 
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO                       
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE CALL-LIST-CUR CURSOR WITH HOLD FOR                  
MFA-TR*       SELECT  NL.ACCOUNT_NO,                                            
MFA-TR*               NL.SERV_ORDER_NO,                                         
MFA-TR*               NL.PHONE_NO,                                              
MFA-TR*               NL.CALL_STATUS_CD,                                        
MFA-TR*               NL.CALL_RESULT_CD,                                        
MFA-TR*               NL.CALL_COUNT,                                            
MFA-TR*               NL.ASSIGNED_DATETIME,                                     
MFA-TR*               NL.LAST_UPDATE_TS,                                        
MFA-TR*               NL.LAST_UPDATE_USERID,                                    
MFA-TR*               NL.LAST_CALL_TS,                                          
MFA-TR*               VO.ORDER_TYPE_CD,                                         
MFA-TR*               VO.LOCAL_OFFICE,                                          
MFA-TR*               VO.WORK_AREA_ID,                                          
MFA-TR*               HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO                                               
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME           DQ,                                    
MFA-TR*               CSS_SO_NDO_CALL_LIST NL,                                  
MFA-TR*               CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE VO.COMPANY_NO      = :WS-COMPANY-NO                       
MFA-TR*           AND VO.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD                 
MFA-TR*           AND VO.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE                  
MFA-TR*           AND VO.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID                  
MFA-TR*           AND VO.SERV_ORDER_NO   = NL.SERV_ORDER_NO                     
MFA-TR*           AND NL.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD                 
MFA-TR*           AND NL.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD                
MFA-TR*         AND DATE(NL.ASSIGNED_DATETIME) >= DATE(:WS-START-DATE)          
MFA-TR*         AND DATE(NL.ASSIGNED_DATETIME) <= DATE(:WS-END-DATE)            
MFA-TR*           AND NL.ACCOUNT_NO              = HT.ACCOUNT_NO                
MFA-TR*           AND HT.NAME_ID                 = DQ.NAME_ID                   
MFA-TR*           AND DQ.NAME_TYPE               = 'CN'                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO                               
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7292                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CALL-LIST CURSOR USED TO RETRIEVE FROM HST_SO_NDO_CALL_LIST *        
      ******************************************************************        
           EXEC SQL DECLARE CALL-HIST-CUR CURSOR WITH HOLD FOR          
              SELECT  NK.ACCOUNT_NO,                                    
                      NK.SERV_ORDER_NO,                                 
                      NK.PHONE_NO,                                      
                      NK.CALL_STATUS_CD,                                
                      NK.CALL_RESULT_CD,                                
                      NK.CALL_COUNT,                                    
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           NK.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                             
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           NK.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
                      NK.LAST_UPDATE_USERID,                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), NK.LAST_CALL_TS
           , 121), ' ', '-'), ':', '.') LAST_CALL_TS,                          
                      YV.ORDER_TYPE_CD,                                 
                      YV.LOCAL_OFFICE,                                  
                      YV.WORK_AREA_ID,                                  
                      HT.CUSTOMER_NO,                                   
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO                                       
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      HST_SO_NDO_CALL_LIST NK WITH(READUNCOMMITTED),            
                      HST_SO_DATA YV WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE YV.COMPANY_NO      = :WS-COMPANY-NO               
                  AND YV.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD         
                  AND YV.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE          
                  AND YV.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID          
                  AND YV.SERV_ORDER_NO   = NK.SERV_ORDER_NO             
                  AND NK.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD         
                  AND NK.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD        
                AND CAST(NK.ASSIGNED_DATETIME AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )  
                AND CAST(NK.ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )    
                  AND NK.ACCOUNT_NO              = HT.ACCOUNT_NO        
                  AND HT.NAME_ID                 = DQ.NAME_ID           
                  AND DQ.NAME_TYPE               = 'CN'                 
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO                       
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE CALL-HIST-CUR CURSOR WITH HOLD FOR                  
MFA-TR*       SELECT  NK.ACCOUNT_NO,                                            
MFA-TR*               NK.SERV_ORDER_NO,                                         
MFA-TR*               NK.PHONE_NO,                                              
MFA-TR*               NK.CALL_STATUS_CD,                                        
MFA-TR*               NK.CALL_RESULT_CD,                                        
MFA-TR*               NK.CALL_COUNT,                                            
MFA-TR*               NK.ASSIGNED_DATETIME,                                     
MFA-TR*               NK.LAST_UPDATE_TS,                                        
MFA-TR*               NK.LAST_UPDATE_USERID,                                    
MFA-TR*               NK.LAST_CALL_TS,                                          
MFA-TR*               YV.ORDER_TYPE_CD,                                         
MFA-TR*               YV.LOCAL_OFFICE,                                          
MFA-TR*               YV.WORK_AREA_ID,                                          
MFA-TR*               HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO                                               
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME           DQ,                                    
MFA-TR*               HST_SO_NDO_CALL_LIST NK,                                  
MFA-TR*               HST_SO_DATA YV,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE YV.COMPANY_NO      = :WS-COMPANY-NO                       
MFA-TR*           AND YV.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD                 
MFA-TR*           AND YV.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE                  
MFA-TR*           AND YV.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID                  
MFA-TR*           AND YV.SERV_ORDER_NO   = NK.SERV_ORDER_NO                     
MFA-TR*           AND NK.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD                 
MFA-TR*           AND NK.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD                
MFA-TR*         AND DATE(NK.ASSIGNED_DATETIME) >= DATE(:WS-START-DATE)          
MFA-TR*         AND DATE(NK.ASSIGNED_DATETIME) <= DATE(:WS-END-DATE)            
MFA-TR*           AND NK.ACCOUNT_NO              = HT.ACCOUNT_NO                
MFA-TR*           AND HT.NAME_ID                 = DQ.NAME_ID                   
MFA-TR*           AND DQ.NAME_TYPE               = 'CN'                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO                               
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7296                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING PARM-COMPANY-NO                         
                                PARM-LOCAL-OFFICE                       
                                PARM-WORK-AREA-ID                       
                                PARM-ORDER-TYPE-CD                      
                                PARM-CALL-STATUS-CD                     
                                PARM-CALL-RESULT-CD                     
                                PARM-START-DATE                         
                                PARM-END-DATE                           
                                PARM-SELECTION                          
                                PARM-NEXT-COUNTER.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.              
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
               PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.               
               EXEC SQL                                                 
                   DECLARE C1 CURSOR  FOR                    
                   SELECT                                               
                        RETURN_CODE                AS RETURN_CODE       
                       ,LTRIM(RTRIM(ERROR_DESC))          AS ERROR_DESC        
                       ,LTRIM(RTRIM(ACCOUNT_NO))          AS ACCOUNT_NO        
                       ,LTRIM(RTRIM(SERV_ORDER_NO))       AS 
           SERV_ORDER_NO     
                       ,LTRIM(RTRIM(ORDER_TYPE_CD))       AS 
           ORDER_TYPE_CD     
                       ,LTRIM(RTRIM(ADDRESS))             AS ADDRESS           
                       ,LTRIM(RTRIM(CITY))                AS CITY              
                       ,LTRIM(RTRIM(NAME))                AS NAME              
                       ,LTRIM(RTRIM(PHONE_NO))            AS PHONE_NO          
                       ,LTRIM(RTRIM(CALL_STATUS_CD))      AS 
           CALL_STATUS_CD    
                       ,LTRIM(RTRIM(CALL_RESULT_CD))      AS 
           CALL_RESULT_CD    
                       ,LTRIM(RTRIM(CALL_COUNT))          AS CALL_COUNT        
                       ,LTRIM(RTRIM(LOCAL_OFFICE))        AS 
           LOCAL_OFFICE      
                       ,LTRIM(RTRIM(WORK_AREA_ID))        AS 
           WORK_AREA_ID      
                       ,LTRIM(RTRIM(ASSIGNED_DATETIME))   AS 
           ASSIGNED_DATETIME 
                       ,LTRIM(RTRIM(LAST_UPDATE_TS))      AS 
           LAST_UPDATE_TS    
                       ,LTRIM(RTRIM(LAST_CALL_TS))        AS 
           LAST_CALL_TS      
                       ,LTRIM(RTRIM(LAST_UPDATE_USERID))  AS 
           LAST_UPDATE_USERID
                       ,TOTAL                                           
                       ,LTRIM(RTRIM(SELECT_FLAG))         AS SELECT_FLAG       
                       ,ROW_NO                                          
                   FROM                                                 
                       #CSR04316_R1                              
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT                                                       
MFA-TR*                 RETURN_CODE                AS RETURN_CODE               
MFA-TR*                ,STRIP(ERROR_DESC)          AS ERROR_DESC                
MFA-TR*                ,STRIP(ACCOUNT_NO)          AS ACCOUNT_NO                
MFA-TR*                ,STRIP(SERV_ORDER_NO)       AS SERV_ORDER_NO             
MFA-TR*                ,STRIP(ORDER_TYPE_CD)       AS ORDER_TYPE_CD             
MFA-TR*                ,STRIP(ADDRESS)             AS ADDRESS                   
MFA-TR*                ,STRIP(CITY)                AS CITY                      
MFA-TR*                ,STRIP(NAME)                AS NAME                      
MFA-TR*                ,STRIP(PHONE_NO)            AS PHONE_NO                  
MFA-TR*                ,STRIP(CALL_STATUS_CD)      AS CALL_STATUS_CD            
MFA-TR*                ,STRIP(CALL_RESULT_CD)      AS CALL_RESULT_CD            
MFA-TR*                ,STRIP(CALL_COUNT)          AS CALL_COUNT                
MFA-TR*                ,STRIP(LOCAL_OFFICE)        AS LOCAL_OFFICE              
MFA-TR*                ,STRIP(WORK_AREA_ID)        AS WORK_AREA_ID              
MFA-TR*                ,STRIP(ASSIGNED_DATETIME)   AS ASSIGNED_DATETIME         
MFA-TR*                ,STRIP(LAST_UPDATE_TS)      AS LAST_UPDATE_TS            
MFA-TR*                ,STRIP(LAST_CALL_TS)        AS LAST_CALL_TS              
MFA-TR*                ,STRIP(LAST_UPDATE_USERID)  AS LAST_UPDATE_USERID        
MFA-TR*                ,TOTAL                                                   
MFA-TR*                ,STRIP(SELECT_FLAG)         AS SELECT_FLAG               
MFA-TR*                ,ROW_NO                                                  
MFA-TR*            FROM                                                         
MFA-TR*                SESSION.CSR04316_R1                                      
MFA-TR*        END-EXEC.                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04316_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04316_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04316_R1
               (                                                       
                   RETURN_CODE              INT                     
                  ,ERROR_DESC CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,SERV_ORDER_NO CHAR(13)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,ORDER_TYPE_CD CHAR(05)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,ADDRESS CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,NAME CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,CALL_STATUS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,CALL_RESULT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,CALL_COUNT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,LOCAL_OFFICE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,WORK_AREA_ID CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,ASSIGNED_DATETIME CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,LAST_CALL_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,TOTAL                    INT                     
                  ,SELECT_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,ROW_NO                   INT                     
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
                                          THRU 8000A-EXIT               
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04316_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *     2. SPLIT OUT PARM STRING INFORMATION                       *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
                                                                        
              IF PARM-LOCAL-OFFICE EQUAL SPACES                         
                   MOVE '%%%'     TO WS-LOCAL-OFFICE                    
                   MOVE '%%%%%%%%%%%%'     TO WS-WORK-AREA-ID           
              ELSE                                                      
                   MOVE PARM-LOCAL-OFFICE   TO WS-LOCAL-OFFICE          
              END-IF                                                    
                                                                        
              IF PARM-WORK-AREA-ID EQUAL SPACES                         
                   MOVE '%%%%%%%%%%%%'     TO WS-WORK-AREA-ID           
              ELSE                                                      
                   MOVE PARM-WORK-AREA-ID  TO WS-WORK-AREA-ID           
              END-IF                                                    
                                                                        
                                                                        
              IF PARM-ORDER-TYPE-CD EQUAL SPACES                        
                   MOVE '%%%%%'            TO WS-ORDER-TYPE-CD          
              ELSE                                                      
                   MOVE PARM-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD          
              END-IF                                                    
                                                                        
              IF WS-ORDER-TYPE-CD = 'CC001' THEN                        
                 MOVE 'CC00%'              TO WS-ORDER-TYPE-CD          
              ELSE IF WS-ORDER-TYPE-CD = 'OFF01' THEN                   
                    MOVE 'OFF0%'              TO WS-ORDER-TYPE-CD       
                   END-IF                                               
              END-IF                                                    
                                                                        
              IF PARM-CALL-STATUS-CD EQUAL SPACES                       
                 MOVE '%'      TO WS-CALL-STATUS-CD                     
              ELSE                                                      
                 MOVE PARM-CALL-STATUS-CD TO WS-CALL-STATUS-CD          
              END-IF                                                    
                                                                        
              IF PARM-CALL-RESULT-CD  EQUAL SPACES                      
                 MOVE '%'      TO WS-CALL-RESULT-CD                     
              ELSE                                                      
                 MOVE PARM-CALL-RESULT-CD  TO WS-CALL-RESULT-CD         
              END-IF                                                    
                                                                        
              IF PARM-START-DATE EQUAL SPACES                           
                 MOVE '2009-01-01' TO WS-START-DATE                     
              ELSE                                                      
                 MOVE PARM-START-DATE TO WS-START-DATE                  
              END-IF                                                    
                                                                        
              IF PARM-END-DATE EQUAL SPACES                             
                 MOVE '2099-01-01' TO WS-END-DATE                       
              ELSE                                                      
                 MOVE PARM-END-DATE TO WS-END-DATE                      
              END-IF                                                    
              MOVE PARM-NEXT-COUNTER TO WS-NEXT-MULTIPLIER              
              MOVE PARM-COMPANY-NO TO WS-COMPANY-NO                     
              MOVE PARM-SELECTION  TO WS-SELECTION                      
                                                                        
      *****************************************************************         
      ** IF A MULTIPLIER IS SENT UP MULTIPLY IT BY THE MAX ROWS, WHICH          
      ** IS CURRENTLY 100.  THIS WILL TELL THE RPC WHEN TO ACTUALLY             
      ** START SENDING THE RESULT TO THE CLIENT                                 
      *****************************************************************         
                                                                        
           IF WS-NEXT-MULTIPLIER > 0                                    
              COMPUTE WS-NEXT-COUNTER =                                 
                   WS-NEXT-MULTIPLIER * CN-MAX-RETURN-ROWS              
              ADD  1  TO WS-NEXT-COUNTER                                
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *     BUILD THE RESULT SET.                                      *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            IF WS-SELECTION EQUAL WS-CURRENT                            
                   PERFORM 2290-SEARCH-CALL-LIST-CURSOR THRU 2290-EXIT  
            ELSE                                                        
                   PERFORM 2295-SEARCH-CALL-HIST-CURSOR THRU 2295-EXIT  
            END-IF.                                                     
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
           IF CTR-ROWS = CN-MAX-RETURN-ROWS                             
               MOVE 101 TO RS-RETURN-CODE                               
               PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-ERROR-DESC          TO S-ERROR-DESC.                 
           MOVE RS-ACCOUNT-NO          TO S-ACCOUNT-NO.                 
           MOVE RS-SERV-ORDER-NO       TO S-SERV-ORDER-NO.              
           MOVE RS-ORDER-TYPE-CD       TO S-ORDER-TYPE-CD.              
           MOVE RS-ADDRESS             TO S-ADDRESS.                    
           MOVE RS-CITY                TO S-CITY.                       
           MOVE RS-NAME                TO S-NAME.                       
           MOVE RS-PHONE-NO            TO S-PHONE-NO.                   
           MOVE RS-CALL-STATUS-CD      TO S-CALL-STATUS-CD.             
           MOVE RS-CALL-RESULT-CD      TO S-CALL-RESULT-CD.             
           MOVE RS-CALL-COUNT          TO S-CALL-COUNT.                 
           MOVE RS-LOCAL-OFFICE        TO S-LOCAL-OFFICE.               
           MOVE RS-WORK-AREA-ID        TO S-WORK-AREA-ID.               
           MOVE RS-ASSIGNED-DATETIME   TO S-ASSIGNED-DATETIME.          
           MOVE RS-LAST-UPDATE-TS      TO S-LAST-UPDATE-TS.             
           MOVE RS-LAST-CALL-TS        TO S-LAST-CALL-TS.               
           MOVE RS-LAST-UPDATE-USERID  TO S-LAST-UPDATE-USERID.         
           MOVE RS-TOTAL               TO S-TOTAL.                      
           MOVE RS-SELECT-FLAG         TO S-SELECT-FLAG.                
           MOVE RS-ROW-NO              TO S-ROW-NO.                     
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2290-SEARCH-CALL-LIST-CURSOR                                   *        
      *     SEARCH FOR ACCOUNTS VIA CALL-LIST CURSOR. COMMON PARAGRAPH *        
      *     TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.            *        
      ******************************************************************        
                                                                        
       2290-SEARCH-CALL-LIST-CURSOR.                                    
                                                                        
           PERFORM 7290-GET-COUNT-CALL-LIST              THRU 7290-EXIT.
           PERFORM 7291-OPEN-CALL-LIST-CUR               THRU 7291-EXIT.
           PERFORM 7292-FETCH-CALL-LIST-CUR              THRU 7292-EXIT.
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7292-FETCH-CALL-LIST-CUR     THRU 7292-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7293-CLOSE-CALL-LIST-CUR    THRU 7293-EXIT.          
                                                                        
           IF CTR-ROWS >= CN-MAX-RETURN-ROWS                            
               GO TO 2290-EXIT                                          
           END-IF.                                                      
                                                                        
       2290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2295-SEARCH-CALL-HIST-CURSOR                                   *        
      *     SEARCH FOR ACCOUNTS VIA CALL-LIST CURSOR. COMMON PARAGRAPH *        
      *     TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.            *        
      ******************************************************************        
                                                                        
       2295-SEARCH-CALL-HIST-CURSOR.                                    
                                                                        
           PERFORM 7294-GET-COUNT-CALL-HIST              THRU 7294-EXIT.
           PERFORM 7295-OPEN-CALL-HIST-CUR               THRU 7295-EXIT.
           PERFORM 7296-FETCH-CALL-HIST-CUR              THRU 7296-EXIT.
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7296-FETCH-CALL-HIST-CUR     THRU 7296-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7297-CLOSE-CALL-HIST-CUR    THRU 7297-EXIT.          
                                                                        
           IF CTR-ROWS >= CN-MAX-RETURN-ROWS                            
               GO TO 2295-EXIT                                          
           END-IF.                                                      
                                                                        
       2295-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-ROW                                               *        
      *     GET ANY MISSING DATA NOT FOUND IN THE ORIGINAL CURSORS.    *        
      *     FORMAT RESULT SET AND SEND DATA.                           *        
      ******************************************************************        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           IF WS-SELECTION EQUAL WS-CURRENT                             
           MOVE NL-ACCOUNT-NO         TO HT-ACCOUNT-NO                  
           MOVE NL-SERV-ORDER-NO      TO RS-SERV-ORDER-NO               
           MOVE NL-PHONE-NO           TO RS-PHONE-NO                    
           MOVE NL-CALL-STATUS-CD     TO RS-CALL-STATUS-CD              
           MOVE NL-CALL-RESULT-CD     TO RS-CALL-RESULT-CD              
           MOVE NL-CALL-COUNT         TO RS-CALL-COUNT-NUM              
           MOVE VO-LOCAL-OFFICE       TO RS-LOCAL-OFFICE                
           MOVE VO-ORDER-TYPE-CD      TO RS-ORDER-TYPE-CD               
           MOVE NL-ASSIGNED-DATETIME  TO RS-ASSIGNED-DATETIME           
           MOVE VO-WORK-AREA-ID       TO RS-WORK-AREA-ID                
           MOVE NL-LAST-UPDATE-TS     TO RS-LAST-UPDATE-TS              
           MOVE NL-LAST-UPDATE-USERID TO RS-LAST-UPDATE-USERID          
           MOVE NL-LAST-CALL-TS       TO RS-LAST-CALL-TS                
           MOVE WS-TOTAL              TO RS-TOTAL                       
           ELSE                                                         
           MOVE NK-ACCOUNT-NO         TO HT-ACCOUNT-NO                  
           MOVE NK-SERV-ORDER-NO      TO RS-SERV-ORDER-NO               
           MOVE NK-PHONE-NO           TO RS-PHONE-NO                    
           MOVE NK-CALL-STATUS-CD     TO RS-CALL-STATUS-CD              
           MOVE NK-CALL-RESULT-CD     TO RS-CALL-RESULT-CD              
           MOVE NK-CALL-COUNT         TO RS-CALL-COUNT-NUM              
           MOVE YV-LOCAL-OFFICE       TO RS-LOCAL-OFFICE                
           MOVE YV-ORDER-TYPE-CD      TO RS-ORDER-TYPE-CD               
           MOVE NK-ASSIGNED-DATETIME  TO RS-ASSIGNED-DATETIME           
           MOVE YV-WORK-AREA-ID       TO RS-WORK-AREA-ID                
           MOVE NK-LAST-UPDATE-TS     TO RS-LAST-UPDATE-TS              
           MOVE NK-LAST-UPDATE-USERID TO RS-LAST-UPDATE-USERID          
           MOVE NK-LAST-CALL-TS       TO RS-LAST-CALL-TS                
           MOVE WS-TOTAL              TO RS-TOTAL                       
           END-IF.                                                      
                                                                        
           IF HT-NAME-ID NOT EQUAL ZERO THEN                            
               PERFORM 7930-GET-NAME               THRU 7930-EXIT       
               IF (HT-CUSTOMER-ROLE-CD > SPACES OR                      
                   DQ-NAME-TYPE NOT = 'CN') AND (HT-ACCOUNT-NO > 0      
                    OR DQ-NAME-TYPE = 'SN')                             
                  IF HT-ACCOUNT-NO > 0                                  
                     PERFORM 7970-GET-CUST-NAME  THRU 7970-EXIT         
                  ELSE                                                  
                     PERFORM 7971-GET-CUST-NAME-WCUSNUM                 
                                                 THRU 7971-EXIT         
                  END-IF                                                
                  IF WS-CUST-NAME-FORMAT = 'I'                          
                     MOVE WS-CUST-LAST-NAME TO WS-FROM                  
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-LAST-NAME                  
                                                                        
                     MOVE WS-CUST-FIRST-NAME TO WS-FROM                 
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-FIRST-NAME                 
                                                                        
                     IF WS-CUST-MIDDLE-NAME NOT = SPACE                 
                         MOVE WS-CUST-MIDDLE-NAME TO WS-FROM            
                         PERFORM 2510-PROCESS-FROM-STRING               
                         MOVE WS-FROM TO WS-CUST-MIDDLE-NAME            
                     END-IF                                             
                                                                        
                     MOVE WS-CUST-TITLE-SUFFIX-1 TO WS-FROM             
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-TITLE-SUFFIX-1             
                                                                        
                     IF WS-CUST-MIDDLE-NAME = SPACE                     
                      STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER   
                       ', ' DELIMITED SIZE                              
                       WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER        
                       ' ' DELIMITED SIZE                               
                       WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER    
                       INTO RS-NAME                                     
                         END-STRING                                     
                     ELSE                                               
                       STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER  
                        ', ' DELIMITED SIZE                             
                        WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER       
                        ' ' DELIMITED SIZE                              
                        WS-CUST-MIDDLE-NAME DELIMITED CN-DELIMITER      
                        ' ' DELIMITED SIZE                              
                        WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER   
                        INTO RS-NAME                                    
                         END-STRING                                     
                     END-IF                                             
                  ELSE                                                  
                     MOVE WS-CUST-FULL-NAME     TO RS-NAME              
                  END-IF                                                
                                                                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           IF HT-ADDRESS-ID NOT EQUAL TO ZERO                           
               PERFORM 7920-GET-ADDRESS          THRU 7920-EXIT         
               PERFORM 7925-GET-CITY             THRU 7925-EXIT         
           ELSE                                                         
               MOVE SPACE TO DY-HOUSE-NO                                
                             DY-ADDR-PREFIX-1                           
                             DY-ADDR-PREFIX-2                           
                             DY-STREET-NAME                             
                             DY-ADDRESS-OVERFLOW                        
                             DY-ADDR-USAGE-CD                           
                             DY-STREET-SUFFIX                           
                             DY-STREET-LOCATION-1                       
                             DY-STREET-LOCATION-2                       
                             DY-ZIP-CODE                                
                             DY-ZIP-CODE-TOKEN                          
                             A4-TOWN                                    
                             DY-ADDR-SUFFIX                             
           END-IF.                                                      
                                                                        
               IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER                   
                   ADD 1 TO WS-ROWS-PROCESSED                           
                   GO TO 2500-EXIT                                      
               END-IF                                                   
                                                                        
           MOVE HT-ACCOUNT-NO         TO RS-ACCOUNT-NO.                 
                                                                        
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO RS-NAME                         
           END-IF.                                                      
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-SUFFIX NOT = SPACE                            
                   MOVE DY-ADDR-SUFFIX                 TO WS-FROM       
                   MOVE LENGTH OF DY-ADDR-SUFFIX       TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
           MOVE A4-TOWN              TO RS-CITY.                        
                                                                        
           IF HT-CUSTOMER-NO = 0                                        
              MOVE SPACES TO RS-NAME                                    
           END-IF.                                                      
      ******************************************************************        
      *  THE FOLLOWING IF STATEMENT IS USED TO DISPLAY THE RELATIONSHIP*        
      *  A PERSON HAS WITH AN ACCOUNT.  THE CUSTOMER_ROLE_CD IN THE    *        
      *  THE CSS_NAME_ACCT_XREF TABLE SAYS WHETHER A PERSON IS A ROOM- *        
      *  MATE OR CO-APPLICANT.  WE ARE GOING TO MOVE THIS TO THE RE-   *        
      *  NAME_TYPE FIELD SO WE CAN SHOW ITS RELATIONSHIP.              *        
      ******************************************************************        
           PERFORM 2000A-MOVE-RESULT         THRU    2000A-EXIT.        
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.        
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-PROCESS-FROM-STRING                                       *        
      *     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *        
      *     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *        
      ******************************************************************        
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2540-ACCUMULATE-ADDRESS                                        *        
      *     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *        
      *     THE FORMATTED ADDRESS FIELD.                               *        
      ******************************************************************        
                                                                        
       2540-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH                               
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE.                                      *        
      ******************************************************************        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7290-GET-COUNT-CALL-LIST                                       *        
      *     SELECT CSS_SO_NDO_CALL_LIST                                *        
      ******************************************************************        
                                                                        
       7290-GET-COUNT-CALL-LIST.                                        
                                                                        
            EXEC SQL                                                    
              SELECT COUNT(VO.SERV_ORDER_NO)                            
                 INTO :WS-TOTAL                                         
               FROM CSS_SO_DATA VO                                      
                   ,CSS_SO_NDO_CALL_LIST NL                             
                WHERE VO.COMPANY_NO      = :WS-COMPANY-NO               
                  AND VO.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD         
                  AND VO.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE          
                  AND VO.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID          
                  AND VO.SERV_ORDER_NO   = NL.SERV_ORDER_NO             
                  AND NL.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD         
                  AND NL.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD        
                AND CAST(NL.ASSIGNED_DATETIME AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )  
                AND CAST(NL.ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT COUNT(VO.SERV_ORDER_NO)                                    
MFA-TR*          INTO :WS-TOTAL                                                 
MFA-TR*        FROM CSS_SO_DATA VO                                              
MFA-TR*            ,CSS_SO_NDO_CALL_LIST NL                                     
MFA-TR*         WHERE VO.COMPANY_NO      = :WS-COMPANY-NO                       
MFA-TR*           AND VO.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD                 
MFA-TR*           AND VO.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE                  
MFA-TR*           AND VO.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID                  
MFA-TR*           AND VO.SERV_ORDER_NO   = NL.SERV_ORDER_NO                     
MFA-TR*           AND NL.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD                 
MFA-TR*           AND NL.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD                
MFA-TR*         AND DATE(NL.ASSIGNED_DATETIME) >= DATE(:WS-START-DATE)          
MFA-TR*         AND DATE(NL.ASSIGNED_DATETIME) <= DATE(:WS-END-DATE)            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7290 ,SELECT CSS_SO_NDO_CALL_LIST'           
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7290'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'CSS_SO_DATA'          TO TABLE-2                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7291-OPEN-CALL-LIST-CUR                                        *        
      *     OPEN CALL-LIST CURSOR.                                     *        
      ******************************************************************        
                                                                        
       7291-OPEN-CALL-LIST-CUR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN CALL-LIST-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7291 ,OPEN   CURSOR CALL-LIST-CUR'           
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7291'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'CSS_SO_DATA'          TO TABLE-2                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-3                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7291-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7292-FETCH-CALL-LIST-CUR                                       *        
      *     FETCH CALL-LIST-CUR.                                       *        
      ******************************************************************        
                                                                        
       7292-FETCH-CALL-LIST-CUR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH CALL-LIST-CUR                                      
                INTO :NL-ACCOUNT-NO,                                    
                     :NL-SERV-ORDER-NO,                                 
                     :NL-PHONE-NO,                                      
                     :NL-CALL-STATUS-CD,                                
                     :NL-CALL-RESULT-CD,                                
                     :NL-CALL-COUNT,                                    
                     :NL-ASSIGNED-DATETIME :WS-NULL-ASSIGNED-TS,         
                     :NL-LAST-UPDATE-TS :WS-NULL-UPDATE-TS,              
                     :NL-LAST-UPDATE-USERID,                            
                     :NL-LAST-CALL-TS :WS-NULL-CALL-TS,                  
                     :VO-ORDER-TYPE-CD,                                 
                     :VO-LOCAL-OFFICE,                                  
                     :VO-WORK-AREA-ID,                                  
                     :HT-CUSTOMER-NO,                                   
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-UPDATE-TS < 0                               
                    MOVE SPACES           TO NL-LAST-UPDATE-TS          
                 END-IF                                                 
                 IF WS-NULL-CALL-TS < 0                                 
                    MOVE SPACES           TO NL-LAST-CALL-TS            
                 END-IF                                                 
                 IF WS-NULL-ASSIGNED-TS < 0                             
                    MOVE SPACES           TO NL-ASSIGNED-DATETIME       
                 END-IF                                                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7292 ,FETCH  CURSOR CALL-LIST-CUR'           
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7292'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'CSS_SO_DATA'          TO TABLE-2                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-3                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF
              END-IF.                                                      
                                                                        
       7292-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7293-CLOSE-CALL-LIST-CUR                                       *        
      *     CLOSE CALL-LIST-CUR.                                       *        
      ******************************************************************        
                                                                        
       7293-CLOSE-CALL-LIST-CUR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE CALL-LIST-CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7293 ,CLOSE  CURSOR CALL-LIST CUR '          
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7293'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'CSS_SO_DATA'          TO TABLE-2                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-3                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7293-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7294-GET-COUNT-CALL-HIST                                       *        
      *     SELECT HST_SO_NDO_CALL_LIST                                *        
      ******************************************************************        
                                                                        
       7294-GET-COUNT-CALL-HIST.                                        
                                                                        
            EXEC SQL                                                    
              SELECT COUNT(YV.SERV_ORDER_NO)                            
                 INTO :WS-TOTAL                                         
               FROM HST_SO_DATA YV                                      
                   ,HST_SO_NDO_CALL_LIST NK                             
                WHERE YV.COMPANY_NO      = :WS-COMPANY-NO               
                  AND YV.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD         
                  AND YV.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE          
                  AND YV.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID          
                  AND YV.SERV_ORDER_NO   = NK.SERV_ORDER_NO             
                  AND NK.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD         
                  AND NK.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD        
                AND CAST(NK.ASSIGNED_DATETIME AS DATE) >= 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) )  
                AND CAST(NK.ASSIGNED_DATETIME AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) )    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT COUNT(YV.SERV_ORDER_NO)                                    
MFA-TR*          INTO :WS-TOTAL                                                 
MFA-TR*        FROM HST_SO_DATA YV                                              
MFA-TR*            ,HST_SO_NDO_CALL_LIST NK                                     
MFA-TR*         WHERE YV.COMPANY_NO      = :WS-COMPANY-NO                       
MFA-TR*           AND YV.ORDER_TYPE_CD   LIKE :WS-ORDER-TYPE-CD                 
MFA-TR*           AND YV.LOCAL_OFFICE    LIKE :WS-LOCAL-OFFICE                  
MFA-TR*           AND YV.WORK_AREA_ID    LIKE :WS-WORK-AREA-ID                  
MFA-TR*           AND YV.SERV_ORDER_NO   = NK.SERV_ORDER_NO                     
MFA-TR*           AND NK.CALL_STATUS_CD LIKE :WS-CALL-STATUS-CD                 
MFA-TR*           AND NK.CALL_RESULT_CD  LIKE :WS-CALL-RESULT-CD                
MFA-TR*         AND DATE(NK.ASSIGNED_DATETIME) >= DATE(:WS-START-DATE)          
MFA-TR*         AND DATE(NK.ASSIGNED_DATETIME) <= DATE(:WS-END-DATE)            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7294 ,SELECT HST_SO_NDO_CALL_LIST'           
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7294'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'HST_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'HST_SO_DATA'          TO TABLE-2                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7294-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7295-OPEN-CALL-HIST-CUR                                        *        
      *     OPEN CALL-HIST CURSOR.                                     *        
      ******************************************************************        
                                                                        
       7295-OPEN-CALL-HIST-CUR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN CALL-HIST-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7295 ,OPEN   CURSOR CALL-HIST-CUR'           
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7295'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'HST_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'HST_SO_DATA'          TO TABLE-2                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-3                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7295-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7296-FETCH-CALL-HIST-CUR                                       *        
      *     FETCH CALL-HIST-CUR.                                       *        
      ******************************************************************        
                                                                        
       7296-FETCH-CALL-HIST-CUR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH CALL-HIST-CUR                                      
                INTO :NK-ACCOUNT-NO,                                    
                     :NK-SERV-ORDER-NO,                                 
                     :NK-PHONE-NO,                                      
                     :NK-CALL-STATUS-CD,                                
                     :NK-CALL-RESULT-CD,                                
                     :NK-CALL-COUNT,                                    
                     :NK-ASSIGNED-DATETIME :WS-NULL-ASSIGNED-TS,         
                     :NK-LAST-UPDATE-TS :WS-NULL-UPDATE-TS,              
                     :NK-LAST-UPDATE-USERID,                            
                     :NK-LAST-CALL-TS :WS-NULL-CALL-TS,                  
                     :YV-ORDER-TYPE-CD,                                 
                     :YV-LOCAL-OFFICE,                                  
                     :YV-WORK-AREA-ID,                                  
                     :HT-CUSTOMER-NO,                                   
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-UPDATE-TS < 0                               
                    MOVE SPACES           TO NL-LAST-UPDATE-TS          
                 END-IF                                                 
                 IF WS-NULL-CALL-TS < 0                                 
                    MOVE SPACES           TO NL-LAST-CALL-TS            
                 END-IF                                                 
                 IF WS-NULL-ASSIGNED-TS < 0                             
                    MOVE SPACES           TO NL-ASSIGNED-DATETIME       
                 END-IF                                                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7296 ,FETCH  CURSOR CALL-HIST-CUR'           
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7296'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'HST_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'HST_SO_DATA'          TO TABLE-2                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-3                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF
              END-IF.                                                      
                                                                        
       7296-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7297-CLOSE-CALL-HIST-CUR                                       *        
      *     CLOSE CALL-HIST-CUR.                                       *        
      ******************************************************************        
                                                                        
       7297-CLOSE-CALL-HIST-CUR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE CALL-HIST-CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7297 ,CLOSE  CURSOR CALL-HIST CUR '          
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7297'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'HST_SO_NDO_CALL_LIST' TO TABLE-1                   
               MOVE 'HST_SO_DATA'          TO TABLE-2                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-3                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'LOCAL_OFFICE'         TO TABLE-ELEMENT-2           
               MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
               MOVE  WS-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7297-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7920-GET-ADDRESS                                               *        
      *     GET COLUMNS FROM FORMATTED ADDRESS TABLE.                  *        
      ******************************************************************        
                                                                        
       7920-GET-ADDRESS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              ADDRESS_OVERFLOW,
              ADDR_USAGE_CD,
              STREET_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              ZIP_CODE,
              ZIP_CODE_TOKEN,
              ADDR_SUFFIX                                       
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX                                   
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :HT-ADDRESS-ID                       
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               ADDR_SUFFIX                                               
MFA-TR*        INTO   :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-ADDR-SUFFIX                                           
MFA-TR*          FROM CSS_ADDR_FORMATTED                                        
MFA-TR*         WHERE ADDRESS_ID = :HT-ADDRESS-ID                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7920                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7920 ,SELECT CSS_ADDR_FORMATTED'             
                  TO RS-ERROR-DESC                                      
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7920'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'ADDRESS_ID'           TO TABLE-ELEMENT-1           
               MOVE HT-ADDRESS-ID          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7925-GET-CITY                                                  *        
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
      ******************************************************************        
                                                                        
       7925-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TOWN                                              
                 INTO :A4-TOWN                                          
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN                                                      
MFA-TR*          INTO :A4-TOWN                                                  
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                             
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7925                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO A4-TOWN                                
               ELSE                                                     
                   MOVE 'PARA -7925 ,SELECT CSS_ZIP_CODE      '         
                      TO RS-ERROR-DESC                                  
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7925'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7925-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7930-GET-NAME                                                  *        
      *     GET CUSTOMER'S NAME.                                       *        
      ******************************************************************        
                                                                        
       7930-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) NAME_TYPE,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              TITLE_SUFFIX_2,
              FULL_NAME                                         
                INTO :DQ-NAME-TYPE,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                 FROM CSS_NAME                                          
                WHERE NAME_ID      = :HT-NAME-ID                        
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NAME_TYPE,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_PREFIX,                                             
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               TITLE_SUFFIX_2,                                           
MFA-TR*               FULL_NAME                                                 
MFA-TR*         INTO :DQ-NAME-TYPE,                                             
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                        
MFA-TR*              :DQ-FULL-NAME                                              
MFA-TR*          FROM CSS_NAME                                                  
MFA-TR*         WHERE NAME_ID      = :HT-NAME-ID                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7930                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO DQ-NAME-TYPE                           
                                 DQ-NAME-FORMAT                         
                                 DQ-LAST-NAME                           
                                 DQ-FIRST-NAME                          
                                 DQ-MIDDLE-NAME                         
                                 DQ-TITLE-PREFIX                        
                                 DQ-TITLE-SUFFIX-1                      
                                 DQ-TITLE-SUFFIX-2                      
                                 DQ-FULL-NAME                           
               ELSE                                                     
                   MOVE 'PARA -7930 ,SELECT CSS_NAME          '         
                      TO RS-ERROR-DESC                                  
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7930'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_NAME'             TO TABLE-1               
                   MOVE 'NAME_ID'              TO TABLE-ELEMENT-1       
                   MOVE HT-NAME-ID             TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7970-GET-CUST-NAME                                             *        
      *     FIND THE CUSTOMER NAME FOR AN ACCOUNT.                     *        
      ******************************************************************        
                                                                        
       7970-GET-CUST-NAME.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.FULL_NAME,
              DQ.NAME_FORMAT,
              DQ.TITLE_SUFFIX_1                                 
                 INTO :WS-CUST-FIRST-NAME,                              
                      :WS-CUST-MIDDLE-NAME,                             
                      :WS-CUST-LAST-NAME,                               
                      :WS-CUST-FULL-NAME,                               
                      :WS-CUST-NAME-FORMAT,                             
                      :WS-CUST-TITLE-SUFFIX-1                           
                 FROM CSS_NAME_ACCT_XREF HT,                            
                      CSS_NAME DQ                                       
                WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                  AND HT.NAME_ID    = DQ.NAME_ID                        
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DQ.NAME_TYPE  = 'CN'                              
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.FIRST_NAME,                                            
MFA-TR*               DQ.MIDDLE_NAME,                                           
MFA-TR*               DQ.LAST_NAME,                                             
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_FORMAT,                                           
MFA-TR*               DQ.TITLE_SUFFIX_1                                         
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                                      
MFA-TR*               :WS-CUST-MIDDLE-NAME,                                     
MFA-TR*               :WS-CUST-LAST-NAME,                                       
MFA-TR*               :WS-CUST-FULL-NAME,                                       
MFA-TR*               :WS-CUST-NAME-FORMAT,                                     
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                                   
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                            
MFA-TR*           AND HT.NAME_ID    = DQ.NAME_ID                                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND DQ.NAME_TYPE  = 'CN'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7970                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7970 ,SELECT CSS_NAME'                       
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7970'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7971-GET-CUST-NAME-WCUSNUM                                     *        
      *     FIND THE CUSTOMER NAME FOR AN ACCOUNT USING THE CUSTOMER #.*        
      ******************************************************************        
                                                                        
       7971-GET-CUST-NAME-WCUSNUM.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.FULL_NAME,
              DQ.NAME_FORMAT,
              DQ.TITLE_SUFFIX_1                                 
                 INTO :WS-CUST-FIRST-NAME,                              
                      :WS-CUST-MIDDLE-NAME,                             
                      :WS-CUST-LAST-NAME,                               
                      :WS-CUST-FULL-NAME,                               
                      :WS-CUST-NAME-FORMAT,                             
                      :WS-CUST-TITLE-SUFFIX-1                           
                 FROM CSS_NAME_ACCT_XREF HT,                            
                      CSS_NAME DQ                                       
                WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                 
                  AND HT.NAME_ID      = DQ.NAME_ID                      
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DQ.NAME_TYPE    = 'CN'                            
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.FIRST_NAME,                                            
MFA-TR*               DQ.MIDDLE_NAME,                                           
MFA-TR*               DQ.LAST_NAME,                                             
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_FORMAT,                                           
MFA-TR*               DQ.TITLE_SUFFIX_1                                         
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                                      
MFA-TR*               :WS-CUST-MIDDLE-NAME,                                     
MFA-TR*               :WS-CUST-LAST-NAME,                                       
MFA-TR*               :WS-CUST-FULL-NAME,                                       
MFA-TR*               :WS-CUST-NAME-FORMAT,                                     
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                                   
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                         
MFA-TR*           AND HT.NAME_ID      = DQ.NAME_ID                              
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND DQ.NAME_TYPE    = 'CN'                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7971                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'PARA -7971 ,SELECT CSS_NAME'                       
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7971'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CUSTOMER-NO'          TO TABLE-ELEMENT-1           
               MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7971-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04316_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04316_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04316_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
            EXEC SQL                                                    
                 INSERT INTO #CSR04316_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,ERROR_DESC                                        
                     ,ACCOUNT_NO                                        
                     ,SERV_ORDER_NO                                     
                     ,ORDER_TYPE_CD                                     
                     ,ADDRESS                                           
                     ,CITY                                              
                     ,NAME                                              
                     ,PHONE_NO                                          
                     ,CALL_STATUS_CD                                    
                     ,CALL_RESULT_CD                                    
                     ,CALL_COUNT                                        
                     ,LOCAL_OFFICE                                      
                     ,WORK_AREA_ID                                      
                     ,ASSIGNED_DATETIME                                 
                     ,LAST_UPDATE_TS                                    
                     ,LAST_CALL_TS                                      
                     ,LAST_UPDATE_USERID                                
                     ,TOTAL                                             
                     ,SELECT_FLAG                                       
                     ,ROW_NO                                            
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-ERROR-DESC                                     
                     ,:S-ACCOUNT-NO                                     
                     ,:S-SERV-ORDER-NO                                  
                     ,:S-ORDER-TYPE-CD                                  
                     ,:S-ADDRESS                                        
                     ,:S-CITY                                           
                     ,:S-NAME                                           
                     ,:S-PHONE-NO                                       
                     ,:S-CALL-STATUS-CD                                 
                     ,:S-CALL-RESULT-CD                                 
                     ,:S-CALL-COUNT                                     
                     ,:S-LOCAL-OFFICE                                   
                     ,:S-WORK-AREA-ID                                   
                     ,:S-ASSIGNED-DATETIME :WS-NULL-ASSIGNED-TS          
                     ,:S-LAST-UPDATE-TS :WS-NULL-UPDATE-TS               
                     ,:S-LAST-CALL-TS :WS-NULL-CALL-TS                   
                     ,:S-LAST-UPDATE-USERID                             
                     ,:S-TOTAL                                          
                     ,:S-SELECT-FLAG                                    
                     ,:S-ROW-NO                                         
                 )                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04316_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,ERROR_DESC                                                
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,SERV_ORDER_NO                                             
MFA-TR*              ,ORDER_TYPE_CD                                             
MFA-TR*              ,ADDRESS                                                   
MFA-TR*              ,CITY                                                      
MFA-TR*              ,NAME                                                      
MFA-TR*              ,PHONE_NO                                                  
MFA-TR*              ,CALL_STATUS_CD                                            
MFA-TR*              ,CALL_RESULT_CD                                            
MFA-TR*              ,CALL_COUNT                                                
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,WORK_AREA_ID                                              
MFA-TR*              ,ASSIGNED_DATETIME                                         
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_CALL_TS                                              
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,TOTAL                                                     
MFA-TR*              ,SELECT_FLAG                                               
MFA-TR*              ,ROW_NO                                                    
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-ERROR-DESC                                             
MFA-TR*              ,:S-ACCOUNT-NO                                             
MFA-TR*              ,:S-SERV-ORDER-NO                                          
MFA-TR*              ,:S-ORDER-TYPE-CD                                          
MFA-TR*              ,:S-ADDRESS                                                
MFA-TR*              ,:S-CITY                                                   
MFA-TR*              ,:S-NAME                                                   
MFA-TR*              ,:S-PHONE-NO                                               
MFA-TR*              ,:S-CALL-STATUS-CD                                         
MFA-TR*              ,:S-CALL-RESULT-CD                                         
MFA-TR*              ,:S-CALL-COUNT                                             
MFA-TR*              ,:S-LOCAL-OFFICE                                           
MFA-TR*              ,:S-WORK-AREA-ID                                           
MFA-TR*              ,:S-ASSIGNED-DATETIME:WS-NULL-ASSIGNED-TS                  
MFA-TR*              ,:S-LAST-UPDATE-TS:WS-NULL-UPDATE-TS                       
MFA-TR*              ,:S-LAST-CALL-TS:WS-NULL-CALL-TS                           
MFA-TR*              ,:S-LAST-UPDATE-USERID                                     
MFA-TR*              ,:S-TOTAL                                                  
MFA-TR*              ,:S-SELECT-FLAG                                            
MFA-TR*              ,:S-ROW-NO                                                 
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04316_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                      *          
      * JOURNALING / ERROR HANDLING INCLUDE                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                           *             
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
