       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04313.                                          
COB303 DATE-WRITTEN. SEP 14,2009.                                       
       DATE-COMPILED.                                                   
                                                                        
      ***********************************************************               
      *                SOUTH CAROLINA ELECTRIC & GAS            *               
      *                                                         *               
      ***********************************************************               
      *                 P R O G R A M  S U M M A R Y            *               
      *                                                         *               
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED IN  WINDOW OF*               
      *  PANEL042 FOR ARCHIVED ACCOUNTS WHICH INVOLVES TABLES   *               
      *  TABLES DP, AR, IH, DO, RN, B1,U,PF.                    *               
      ***********************************************************               
      *                                                         *               
      *                     PROGRAM MODIFICATION LOG            *               
      *                                                         *               
      *    DATE    INITIALS   COMMENTS                          *               
      *  --------  --------   --------------------------------- *               
A37666*  09/14/09  SP95538     PROCEDURE ORIGINALLY CODED.      *               
A04527*  06/06/13  MC95456     REMOVED UNUSED COPYBOOK CWS00056 *               
      ***********************************************************               
      ***********************************************************               
      *                                                         *               
      *                ---- BASIC SEQUENCE STRUCTURE ----       *               
      *                                                         *               
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION      *               
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH             *               
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH            *               
      *  3000 - 4999  NOT USED                                  *               
      *  5000 - 5999  COMMON PROGRAM MODULES                    *               
      *  6000 - 6999  COMMON SYSTEM MODULES                     *               
      *  7000 - 7999  INPUT MODULES                             *               
      *  8000 - 8999  OUTPUT MODULES                            *               
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES      *               
      *                                                         *               
      ***********************************************************               
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04313'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START           PIC X(40) VALUE                           
                'WORKING STORAGE FOR CSR04313 STARTS HERE'.             
                                                                        
      **************************************************************            
      *    DB2 INCLUDES                                            *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  HST_DEP_ON_HAND - IA                                      *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBHDEPHN                                                
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  HST_DEP_PAY_HST - HG                                      *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHDEPHS                                                 
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  HST_REFUND - HU                                           *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHREFUN                                                 
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  HST_INTEREST_HIST - NI                                    *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBHINTHS                                                
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_USER_PROFILE - PF                                     *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBUSRPRF                                                
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  HST_ACCOUNT - HA                                          *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBHACCT                                                 
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_PREMISE - PR                                          *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBPREM                                                  
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *   CSS_REV_DISTRICT - A9                                    *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBRVDST                                                 
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_DEP_REQ  - DR                                         *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDEPREQ                                                
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *   COBOL WORKING STORAGE COPY BOOKS                         *            
      **************************************************************            
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      *--< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                     
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05 WS-FETCH-RETCODE         PIC S9(9) COMP VALUE 0.          
           05 WS-IH-NOT-FOUND-FLAG     PIC X(01) VALUE 'N'.             
              88 WS-IH-NOT-FOUND                 VALUE 'Y'.             
           05 WS-DP-NOT-FOUND-FLAG     PIC X(01) VALUE 'N'.             
              88 WS-DP-NOT-FOUND                 VALUE 'Y'.             
           05 WS-RN-NOT-FOUND-FLAG     PIC X(01) VALUE 'N'.             
              88 WS-RN-NOT-FOUND                 VALUE 'Y'.             
           05 WS-NULL-IND1             PIC S9(04) COMP.                 
           05 WS-NULL-IND2             PIC S9(04) COMP.                 
           05 WS-NULL-INT              PIC S9(04) COMP.                 
           05 WS-NULL-DUMMY-IND        PIC S9(04) COMP.                 
           05 PROGRAM-NAME             PIC X(8)  VALUE 'CSR04313'.      
           05 WS-SQLSTATE              PIC X(5).                        
           05 WS-DATE-REFUNDED         PIC X(10) VALUE SPACES.          
           05 WS-DATE-REFUND           PIC X(10) VALUE SPACES.          
           05 WS-DATE-TRANS            PIC X(10) VALUE SPACES.          
           05 WS-DEP-PAY-DT            PIC X(10) VALUE SPACES.          
           05 WS-INT-CREDIT-DT         PIC X(10) VALUE SPACES.          
           05 WS-EFFECTIVE-DT          PIC X(10) VALUE SPACES.          
           05 WS-ORIG-DEP-AMT          PIC S9(9)V9(2)  COMP-3  VALUE 0. 
           05 WS-INTEREST-AMT-HOLD     PIC S9(9)V9(2)  COMP-3  VALUE 0. 
           05 WS-DEP-AMT-REFUNDED      PIC S9(9)V9(2)  COMP-3  VALUE 0. 
           05 WS-TRANS-INP-FIELD       PIC X(13) VALUE SPACES.          
           05 WS-DEP-CERT-INP-FIELD    PIC X(09) VALUE SPACES.          
           05 WS-COUNT                 PIC S9(04)      COMP    VALUE 0. 
           05 WS-INPUT-ID              PIC X(01) VALUE SPACES.          
                                                                        
           05 WS-POSITIVE-FOUND-SW     PIC X(01) VALUE 'N'.             
              88 POSITIVE-NUM-IS-FOUND           VALUE 'Y'.             
                                                                        
           05 WS-TRANSFERRED-TO        PIC S9(13)V COMP-3  VALUE 0.     
           05 WS-TRANS-TO-REDEF        PIC 9(13).                       
           05 WS-TRANS-TO-RED REDEFINES WS-TRANS-TO-REDEF.              
              10 WS-TRANSFER-TO-RED    PIC X(13).                       
                                                                        
           05 WS-DEP-CERT-NO-TO        PIC S9(9)   COMP    VALUE 0.     
           05 WS-DEP-CERT-TO-REDEF     PIC 9(9).                        
           05 WS-CERT-NO-TO-RED REDEFINES WS-DEP-CERT-TO-REDEF.         
              10 WS-DEPOSIT-TO-RED     PIC X(09).                       
                                                                        
           05 WS-TRANSFERRED-FROM      PIC S9(13)V COMP-3  VALUE 0.     
           05 WS-TRANS-FROM-REDEF      PIC 9(13).                       
           05 WS-TRANS-FROM-RED REDEFINES WS-TRANS-FROM-REDEF.          
              10 WS-TRANSFER-FROM-RED  PIC X(13).                       
                                                                        
           05 WS-DEP-CERT-NO-FROM      PIC S9(9)   COMP    VALUE 0.     
           05 WS-DEP-CERT-FROM-REDEF   PIC 9(9).                        
           05 WS-CERT-NO-FROM-RED REDEFINES WS-DEP-CERT-FROM-REDEF.     
              10 WS-DEPOSIT-FROM-RED   PIC X(09).                       
                                                                        
           05 WS-ACCT-NO-CREDITED      PIC S9(13)V COMP-3  VALUE 0.     
           05 WS-ACCT-NO-CRD-REDEF     PIC 9(13).                       
           05 WS-ACCT-NO-CRD-RED REDEFINES WS-ACCT-NO-CRD-REDEF.        
              10 WS-ACCT-NO-CREDIT-RED PIC X(13).                       
                                                                        
           05 WS-HOLD-REV-DIST         PIC X(03).                       
           05 WS-HOLD-ID-INPUT         PIC X(07).                       
           05 WS-HOLD-NAME-OUTPUT      PIC X(29).                       
           05 WS-SUB                   PIC S9(8) COMP VALUE ZERO.       
           05 CN-DELIMITER             PIC X VALUE ';'.                 
           05 WS-FROM.                                                  
              10 WS-FROM-X                OCCURS 51 TIMES PIC X.        
           05 WS-USA-DATE.                                              
              10  WS-USA-DATE-MM       PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-USA-DATE-DD       PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-USA-DATE-CCYY     PIC X(04) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW              PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05 WS-NUM-TIMES-THRU        PIC X(01) VALUE 'Y'.             
               88 FIRST-TIME-THRU                VALUE 'Y'.             
      *                                                                 0       
       01  COUNTER-FIELDS.                                              
           05 CTR-COLUMN               PIC S9(9) COMP VALUE 1.          
           05 CTR-ROWS                 PIC S9(9) COMP VALUE 0.          
           05 WS-ROW-COUNT             PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05 RS-DEPOSIT-CERT-NO      PIC S9(9) COMP VALUE 0.           
           05 RS-ORIG-DEP-AMT         PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-AMT-REFUNDED         PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-TRANSFER-AMT         PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 RS-AMT-DEPOSIT          PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 RS-TRANSFERRED-TO       PIC X(13).                        
           05 RS-DEP-CERT-NO-TO       PIC X(09).                        
           05 RS-TRANSFERRED-FROM     PIC X(13).                        
           05 RS-DEP-CERT-NO-FROM     PIC X(09).                        
           05 RS-SERVICE-TYPE-CD      PIC X(1)  VALUE SPACES.           
           05 RS-REPEAT-COUNT         PIC S9(4) COMP VALUE 1.           
           05 RS-DATE-TRANS           PIC X(10) VALUE SPACES.           
           05 RS-AMT-POSTED           PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-DEP-PAY-DT           PIC X(10) VALUE SPACES.           
           05 RS-DEP-PAY-AMT          PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 RS-INT-CREDIT-DT        PIC X(10) VALUE SPACES.           
           05 RS-INTEREST-AMT         PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-INTEREST-RT          PIC S9(3)V9(4)  COMP-3 VALUE 0.   
           05 RS-EFFECTIVE-DT         PIC X(10) VALUE SPACES.           
           05 RS-REV-DISTRICT-DESC    PIC X(35) VALUE SPACES.           
           05 RS-DATE-REFUND          PIC X(10) VALUE SPACES.           
           05 RS-MANUAL-INDICATOR     PIC X(01) VALUE SPACES.           
           05 RS-DEP-AMT-REFUNDED     PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-INT-AMT-REFUNDED     PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-TOT-AMT-REFUNDED     PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 RS-CHECK-ISS-REAS-CD    PIC X(02) VALUE SPACES.           
           05 RS-CHECK-STATUS-CD      PIC X(01) VALUE SPACES.           
           05 RS-USER-NAME-RQSTED-BY  PIC X(29) VALUE SPACES.           
           05 RS-USER-NAME-APPRVD-BY  PIC X(29) VALUE SPACES.           
           05 RS-ACCT-NO-CREDITED     PIC X(13) VALUE SPACES.           
           05 RS-COMMENTS             PIC X(72) VALUE SPACES.           
           05 RS-DEPOSIT-STATUS-CD    PIC X(01) VALUE SPACES.           
           05 RS-DATE-TRAN            PIC X(10) VALUE SPACES.           
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE           PIC S9(9) COMP VALUE 0.           
           05 S-DEPOSIT-CERT-NO       PIC S9(9) COMP VALUE 0.           
           05 S-ORIG-DEP-AMT          PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 S-AMT-REFUNDED          PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 S-TRANSFER-AMT          PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 S-AMT-DEPOSIT           PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 S-TRANSFERRED-TO        PIC X(13).                        
           05 S-DEP-CERT-NO-TO        PIC X(09).                        
           05 S-TRANSFERRED-FROM      PIC X(13).                        
           05 S-DEP-CERT-NO-FROM      PIC X(09).                        
           05 S-SERVICE-TYPE-CD       PIC X(1)  VALUE SPACES.           
           05 S-REPEAT-COUNT          PIC S9(4) COMP VALUE 1.           
           05 S-DATE-TRANS            PIC X(10) VALUE SPACES.           
           05 S-AMT-POSTED            PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 S-DEP-PAY-DT            PIC X(10) VALUE SPACES.           
           05 S-DEP-PAY-AMT           PIC S9(7)V9(2)  COMP-3 VALUE 0.   
           05 S-INT-CREDIT-DT         PIC X(10) VALUE SPACES.           
           05 S-INTEREST-AMT          PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 S-INTEREST-RT           PIC S9(3)V9(4)  COMP-3 VALUE 0.   
           05 S-EFFECTIVE-DT          PIC X(10) VALUE SPACES.           
           05 S-REV-DISTRICT-DESC     PIC X(35) VALUE SPACES.           
           05 S-DATE-REFUND           PIC X(10) VALUE SPACES.           
           05 S-MANUAL-INDICATOR      PIC X(01) VALUE SPACES.           
           05 S-DEP-AMT-REFUNDED      PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 S-INT-AMT-REFUNDED      PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 S-TOT-AMT-REFUNDED      PIC S9(9)V9(2)  COMP-3 VALUE 0.   
           05 S-CHECK-ISS-REAS-CD     PIC X(02) VALUE SPACES.           
           05 S-CHECK-STATUS-CD       PIC X(01) VALUE SPACES.           
           05 S-USER-NAME-RQSTED-BY   PIC X(29) VALUE SPACES.           
           05 S-USER-NAME-APPRVD-BY   PIC X(29) VALUE SPACES.           
           05 S-ACCT-NO-CREDITED      PIC X(13) VALUE SPACES.           
           05 S-COMMENTS              PIC X(72) VALUE SPACES.           
           05 S-DEPOSIT-STATUS-CD     PIC X(01) VALUE SPACES.           
           05 S-DATE-TRAN             PIC X(10) VALUE SPACES.           
      *                                                                         
       01  CSRERLOG-P.                                                  
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
                                                                        
      **********************************                                **      
      *    CURSOR DECLARATIONS         *                                 *      
      **********************************                                **      
                                                                        
      ****************************************************************  **      
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF  *  **      
      **  ROWS FROM THE HST_DEP_ON_HAND TABLE.                       *  **      
      ****************************************************************  **      
      *                                                                         
           EXEC SQL                                                     
           DECLARE DO-CURSOR CURSOR FOR                                 
             SELECT DEPOSIT_CERT_NO,                                    
                 AMT_REFUNDED,                                          
                 SERVICE_TYPE_CD,                                       
                 AMT_DEPOSIT,                                           
                 TOTAL_INTRST,                                          
                 CIS.CHAR2$DATE(DATE_REFUNDED,'USA'),                           
                 DATE_TRAN,                                             
                 TRANSFERRED_TO,                                        
                 DEP_CERT_NO_TO,                                        
                 TRANSFERRED_FROM,                                      
                 DEP_CERT_NO_FROM,                                      
                 TRANSFER_AMT,                                          
                 DEPOSIT_STATUS_CD                                      
                 FROM HST_DEP_ON_HAND                                   
             WHERE ACCOUNT_NO = :IA-ACCOUNT-NO                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE DO-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT DEPOSIT_CERT_NO,                                            
MFA-TR*          AMT_REFUNDED,                                                  
MFA-TR*          SERVICE_TYPE_CD,                                               
MFA-TR*          AMT_DEPOSIT,                                                   
MFA-TR*          TOTAL_INTRST,                                                  
MFA-TR*          CHAR(DATE_REFUNDED,USA),                                       
MFA-TR*          DATE_TRAN,                                                     
MFA-TR*          TRANSFERRED_TO,                                                
MFA-TR*          DEP_CERT_NO_TO,                                                
MFA-TR*          TRANSFERRED_FROM,                                              
MFA-TR*          DEP_CERT_NO_FROM,                                              
MFA-TR*          TRANSFER_AMT,                                                  
MFA-TR*          DEPOSIT_STATUS_CD                                              
MFA-TR*          FROM HST_DEP_ON_HAND                                           
MFA-TR*      WHERE ACCOUNT_NO = :IA-ACCOUNT-NO                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***************************************************************   **      
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF *   **      
      **  ROWS FROM THE HST_REFUND TABLE.                           *   **      
      ***************************************************************   **      
      *                                                                         
           EXEC SQL                                                     
           DECLARE RN-CURSOR  CURSOR FOR                                
             SELECT REFUND_ITEM_ID,                                     
                 REFUND_CHECK_NO,                                       
                 AMT_REFUNDED,                                          
                 CIS.CHAR2$DATE(DATE_REFUNDED,'USA'),                           
                 CHECK_ISS_REAS_CD,                                     
                 USER_ID_APPRVD_BY,                                     
                 USER_ID_RQSTED_BY,                                     
                 CHECK_STATUS_CD,                                       
                 MANUAL_INDICATOR,                                      
                 ACCT_NO_CREDITED,                                      
                 COMMENTS                                               
             FROM HST_REFUND                                            
             WHERE ACCOUNT_NO      = :HU-ACCOUNT-NO                     
             AND   DEPOSIT_CERT_NO = :HU-DEPOSIT-CERT-NO                
             ORDER BY REFUND_ITEM_ID DESC                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE RN-CURSOR  CURSOR FOR                                        
MFA-TR*      SELECT REFUND_ITEM_ID,                                             
MFA-TR*          REFUND_CHECK_NO,                                               
MFA-TR*          AMT_REFUNDED,                                                  
MFA-TR*          CHAR(DATE_REFUNDED,USA),                                       
MFA-TR*          CHECK_ISS_REAS_CD,                                             
MFA-TR*          USER_ID_APPRVD_BY,                                             
MFA-TR*          USER_ID_RQSTED_BY,                                             
MFA-TR*          CHECK_STATUS_CD,                                               
MFA-TR*          MANUAL_INDICATOR,                                              
MFA-TR*          ACCT_NO_CREDITED,                                              
MFA-TR*          COMMENTS                                                       
MFA-TR*      FROM HST_REFUND                                                    
MFA-TR*      WHERE ACCOUNT_NO      = :HU-ACCOUNT-NO                             
MFA-TR*      AND   DEPOSIT_CERT_NO = :HU-DEPOSIT-CERT-NO                        
MFA-TR*      ORDER BY REFUND_ITEM_ID DESC                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************  **      
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF  *  **      
      **  ROWS FROM THE HST_DEP_PAY_HST TABLE.                       *  **      
      ****************************************************************  **      
      *                                                                         
           EXEC SQL                                                     
           DECLARE DP-CURSOR CURSOR FOR                                 
             SELECT CIS.CHAR2$DATE(DEP_PAY_DT,'USA'),                           
             DEP_PAY_DT, DEP_PAY_AMT                                    
             FROM HST_DEP_PAY_HST                                       
             WHERE ACCOUNT_NO = :HG-ACCOUNT-NO                          
             AND   DEPOSIT_CERT_NO =:HG-DEPOSIT-CERT-NO                 
             ORDER BY DEP_PAY_DT DESC                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE DP-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT CHAR(DEP_PAY_DT,USA),                                       
MFA-TR*      DEP_PAY_DT, DEP_PAY_AMT                                            
MFA-TR*      FROM HST_DEP_PAY_HST                                               
MFA-TR*      WHERE ACCOUNT_NO = :HG-ACCOUNT-NO                                  
MFA-TR*      AND   DEPOSIT_CERT_NO =:HG-DEPOSIT-CERT-NO                         
MFA-TR*      ORDER BY DEP_PAY_DT DESC                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***************************************************************   **      
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF *   **      
      **  ROWS FROM THE HST_INTEREST_HIST TABLE.                    *   **      
      ***************************************************************   **      
      *                                                                         
           EXEC SQL                                                     
           DECLARE IH-CURSOR CURSOR FOR                                 
             SELECT CIS.CHAR2$DATE(INT_CREDIT_DT,'USA'),                        
                           INT_CREDIT_DT,                               
                           INTEREST_AMT,                                
                           INTEREST_RT,                                 
                           CIS.CHAR2$DATE(EFFECTIVE_DT,'USA'),                  
                           EFFECTIVE_DT,                                
                           REV_DISTRICT_CD                              
             FROM HST_INTEREST_HIST A,                                  
             CSS_PREMISE B, HST_ACCOUNT C                               
             WHERE A.ACCOUNT_NO = :NI-ACCOUNT-NO                        
             AND A.DEPOSIT_CERT_NO =:NI-DEPOSIT-CERT-NO                 
             AND A.ACCOUNT_NO = C.ACCOUNT_NO                            
             AND C.PREMISE_NO = B.PREMISE_NO                            
             ORDER BY INT_CREDIT_DT DESC                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE IH-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT CHAR(INT_CREDIT_DT,USA),                                    
MFA-TR*                    INT_CREDIT_DT,                                       
MFA-TR*                    INTEREST_AMT,                                        
MFA-TR*                    INTEREST_RT,                                         
MFA-TR*                    CHAR(EFFECTIVE_DT,USA),                              
MFA-TR*                    EFFECTIVE_DT,                                        
MFA-TR*                    REV_DISTRICT_CD                                      
MFA-TR*      FROM HST_INTEREST_HIST A,                                          
MFA-TR*      CSS_PREMISE B, HST_ACCOUNT C                                       
MFA-TR*      WHERE A.ACCOUNT_NO = :NI-ACCOUNT-NO                                
MFA-TR*      AND A.DEPOSIT_CERT_NO =:NI-DEPOSIT-CERT-NO                         
MFA-TR*      AND A.ACCOUNT_NO = C.ACCOUNT_NO                                    
MFA-TR*      AND C.PREMISE_NO = B.PREMISE_NO                                    
MFA-TR*      ORDER BY INT_CREDIT_DT DESC                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO          PIC  X(13).                         
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                         
      ***********************************************************       **      
      * 0000-MAINLINE                                           *        *      
      *     CONTROLS THE MAIN PATH OF THE PROGRAM               *        *      
      ***********************************************************       **      
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************     **      
      * 0100-INITIALIZE                                           *      *      
      *     1. RESET DB2 ERROR HANDLERS                           *      *      
      *     2. DECLARE CURSOR FOR RESULT SET                      *      *      
      *                                                           *      *      
      *************************************************************     **      
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           PERFORM 0110-INIT-DO-RS THRU 0110-EXIT.                      
           PERFORM 0140-INIT-DP-RS THRU 0140-EXIT.                      
           PERFORM 0150-INIT-IH-RS THRU 0150-EXIT.                      
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                    RETURN_CODE               AS RETURN_CODE            
                   ,DEPOSIT_CERT_NO           AS DEPOSIT_CERT_NO        
                   ,ORIG_DEP_AMT              AS ORIG_DEP_AMT           
                   ,AMT_REFUNDED              AS AMT_REFUNDED           
                   ,TRANSFER_AMT              AS TRANSFER_AMT           
                   ,AMT_DEPOSIT               AS AMT_DEPOSIT            
                   ,LTRIM(RTRIM(TRANSFERRED_TO))     AS TRANSFERRED_TO         
                   ,LTRIM(RTRIM(DEP_CERT_NO_TO))     AS DEP_CERT_NO_TO         
                   ,LTRIM(RTRIM(TRANSFERRED_FROM))   AS TRANSFERRED_FROM       
                   ,LTRIM(RTRIM(DEP_CERT_NO_FROM))   AS DEP_CERT_NO_FROM       
                   ,SERVICE_TYPE_CD           AS SERVICE_TYPE_CD        
                   ,REPEAT_COUNT              AS REPEAT_COUNT           
                   ,LTRIM(RTRIM(DATE_TRANS))         AS DATE_TRANS             
                   ,AMT_POSTED                AS AMT_POSTED             
                   ,LTRIM(RTRIM(DEP_PAY_DT))         AS DEP_PAY_DT             
                   ,DEP_PAY_AMT               AS DEP_PAY_AMT            
                   ,LTRIM(RTRIM(INT_CREDIT_DT))      AS INT_CREDIT_DT          
                   ,INTEREST_AMT              AS INTEREST_AMT           
                   ,INTEREST_RT               AS INTEREST_RT            
                   ,LTRIM(RTRIM(EFFECTIVE_DT))       AS EFFECTIVE_DT           
                   ,LTRIM(RTRIM(REV_DISTRICT_DESC))  AS 
           REV_DISTRICT_DESC      
                   ,LTRIM(RTRIM(DATE_REFUND))        AS DATE_REFUND            
                   ,MANUAL_INDICATOR          AS MANUAL_INDICATOR       
                   ,[DEP-AMT_REFUNDED]          AS DEP_AMT_REFUNDED       
                   ,[INT-AMT_REFUNDED]          AS INT_AMT_REFUNDED       
                   ,[TOT-AMT_REFUNDED]          AS TOT_AMT_REFUNDED       
                   ,[CHECK_ISS-REAS_CD]         AS CHECK_ISS_REAS_CD      
                   ,CHECK_STATUS_CD           AS CHECK_STATUS_CD        
                   ,LTRIM(RTRIM([USER_NAME-RQTED_BY])) AS 
           [USER_NAME-RQTED_BY]     
                   ,LTRIM(RTRIM(USER_NAME_APRVD_BY)) AS 
           USER_NAME_APRVD_BY     
                   ,LTRIM(RTRIM(ACCT_NO_CREDITED))   AS ACCT_NO_CREDITED       
                   ,LTRIM(RTRIM(COMMENTS))           AS COMMENTS               
                   ,DEPOSIT_STATUS_CD         AS DEPOSIT_STATUS_CD      
                   ,LTRIM(RTRIM(DATE_TRAN))          AS DATE_TRAN              
               FROM                                                     
                   #CSR04313_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE               AS RETURN_CODE                    
MFA-TR*            ,DEPOSIT_CERT_NO           AS DEPOSIT_CERT_NO                
MFA-TR*            ,ORIG_DEP_AMT              AS ORIG_DEP_AMT                   
MFA-TR*            ,AMT_REFUNDED              AS AMT_REFUNDED                   
MFA-TR*            ,TRANSFER_AMT              AS TRANSFER_AMT                   
MFA-TR*            ,AMT_DEPOSIT               AS AMT_DEPOSIT                    
MFA-TR*            ,STRIP(TRANSFERRED_TO)     AS TRANSFERRED_TO                 
MFA-TR*            ,STRIP(DEP_CERT_NO_TO)     AS DEP_CERT_NO_TO                 
MFA-TR*            ,STRIP(TRANSFERRED_FROM)   AS TRANSFERRED_FROM       .       
MFA-TR*            ,STRIP(DEP_CERT_NO_FROM)   AS DEP_CERT_NO_FROM       .       
MFA-TR*            ,SERVICE_TYPE_CD           AS SERVICE_TYPE_CD                
MFA-TR*            ,REPEAT_COUNT              AS REPEAT_COUNT                   
MFA-TR*            ,STRIP(DATE_TRANS)         AS DATE_TRANS                     
MFA-TR*            ,AMT_POSTED                AS AMT_POSTED                     
MFA-TR*            ,STRIP(DEP_PAY_DT)         AS DEP_PAY_DT                     
MFA-TR*            ,DEP_PAY_AMT               AS DEP_PAY_AMT                    
MFA-TR*            ,STRIP(INT_CREDIT_DT)      AS INT_CREDIT_DT                  
MFA-TR*            ,INTEREST_AMT              AS INTEREST_AMT           0.      
MFA-TR*            ,INTEREST_RT               AS INTEREST_RT                    
MFA-TR*            ,STRIP(EFFECTIVE_DT)       AS EFFECTIVE_DT                   
MFA-TR*            ,STRIP(REV_DISTRICT_DESC)  AS REV_DISTRICT_DESC              
MFA-TR*            ,STRIP(DATE_REFUND)        AS DATE_REFUND                    
MFA-TR*            ,MANUAL_INDICATOR          AS MANUAL_INDICATOR               
MFA-TR*            ,DEP-AMT_REFUNDED          AS DEP_AMT_REFUNDED               
MFA-TR*            ,INT-AMT_REFUNDED          AS INT_AMT_REFUNDED               
MFA-TR*            ,TOT-AMT_REFUNDED          AS TOT_AMT_REFUNDED               
MFA-TR*            ,CHECK_ISS-REAS_CD         AS CHECK_ISS_REAS_CD              
MFA-TR*            ,CHECK_STATUS_CD           AS CHECK_STATUS_CD                
MFA-TR*            ,STRIP(USER_NAME-RQTED_BY) AS USER_NAME-RQTED_BY             
MFA-TR*            ,STRIP(USER_NAME_APRVD_BY) AS USER_NAME_APRVD_BY             
MFA-TR*            ,STRIP(ACCT_NO_CREDITED)   AS ACCT_NO_CREDITED               
MFA-TR*            ,STRIP(COMMENTS)           AS COMMENTS                       
MFA-TR*            ,DEPOSIT_STATUS_CD         AS DEPOSIT_STATUS_CD              
MFA-TR*            ,STRIP(DATE_TRAN)          AS DATE_TRAN              02402000
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04313_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100A-DECLARE-GTT.                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04313_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04313_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04313_R1
               (                                                       
                    RETURN_CODE          INT                        
                   ,DEPOSIT_CERT_NO      INT                        
                   ,ORIG_DEP_AMT         DECIMAL(11,2)                  
                   ,AMT_REFUNDED         DECIMAL(11,2)                  
                   ,TRANSFER_AMT         DECIMAL(09,2)                  
                   ,AMT_DEPOSIT          DECIMAL(09,2)                  
                   ,TRANSFERRED_TO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DEP_CERT_NO_TO CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,TRANSFERRED_FROM CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DEP_CERT_NO_FROM CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,SERVICE_TYPE_CD CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,REPEAT_COUNT         SMALLINT                       
                   ,DATE_TRANS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,AMT_POSTED           DECIMAL(11,2)                  
                   ,DEP_PAY_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,DEP_PAY_AMT          DECIMAL(9,2)                   
                   ,INT_CREDIT_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,INTEREST_AMT         DECIMAL(11,2)                  
                   ,INTEREST_RT          DECIMAL(07,4)                  
                   ,EFFECTIVE_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,REV_DISTRICT_DESC CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_REFUND CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,MANUAL_INDICATOR CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[DEP-AMT_REFUNDED]     DECIMAL(11,2)                  
                   ,[INT-AMT_REFUNDED]     DECIMAL(11,2)                  
                   ,[TOT-AMT_REFUNDED]     DECIMAL(11,2)                  
                   ,[CHECK_ISS-REAS_CD] CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CHECK_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[USER_NAME-RQTED_BY] CHAR(29)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,USER_NAME_APRVD_BY CHAR(29)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,ACCT_NO_CREDITED CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,DEPOSIT_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,DATE_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                                                                        
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
                                          THRU 8000A-EXIT               
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04313_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0110-INIT-DO-RS.                                               *        
      ******************************************************************        
      *                                                                         
       0110-INIT-DO-RS.                                                 
      *                                                                         
           MOVE ZEROES TO RS-RETURN-CODE.                               
           MOVE ZEROES TO RS-DEPOSIT-CERT-NO                            
                          WS-TRANSFERRED-TO                             
                          WS-DEP-CERT-NO-TO                             
                          WS-TRANSFERRED-FROM                           
                          WS-DEP-CERT-NO-FROM.                          
           MOVE SPACES TO RS-TRANSFERRED-TO                             
                          RS-DEP-CERT-NO-TO                             
                          RS-TRANSFERRED-FROM                           
                          RS-DEP-CERT-NO-FROM.                          
           MOVE SPACES TO RS-SERVICE-TYPE-CD.                           
           MOVE ZEROES TO RS-AMT-DEPOSIT.                               
           MOVE ZEROES TO RS-TRANSFER-AMT.                              
           MOVE ZEROES TO RS-ORIG-DEP-AMT.                              
      *                                                                         
       0110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0125-INIT-RN-RS.                                               *        
      ******************************************************************        
      *                                                                         
       0125-INIT-RN-RS.                                                 
      *                                                                         
           MOVE SPACES TO RS-DATE-REFUND.                               
           MOVE SPACES TO RS-CHECK-ISS-REAS-CD.                         
           MOVE SPACES TO RS-USER-NAME-APPRVD-BY.                       
           MOVE SPACES TO RS-USER-NAME-RQSTED-BY.                       
           MOVE SPACES TO RS-ACCT-NO-CREDITED.                          
           MOVE ZEROES TO RS-INT-AMT-REFUNDED.                          
           MOVE ZEROES TO RS-DEP-AMT-REFUNDED.                          
           MOVE ZEROES TO RS-TOT-AMT-REFUNDED.                          
      *                                                                         
       0125-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0140-INIT-DP-RS.                                               *        
      ******************************************************************        
      *                                                                         
       0140-INIT-DP-RS.                                                 
           MOVE SPACES TO RS-DEP-PAY-DT.                                
           MOVE ZEROES TO RS-DEP-PAY-AMT.                               
       0140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *    0150-INIT-IH-RS.                                            *        
      ******************************************************************        
      *                                                                         
       0150-INIT-IH-RS.                                                 
      *                                                                         
           MOVE SPACES TO RS-INT-CREDIT-DT                              
                          RS-EFFECTIVE-DT                               
                          RS-REV-DISTRICT-DESC.                         
           MOVE ZEROES TO RS-INTEREST-AMT                               
                          RS-INTEREST-RT.                               
      *                                                                         
       0150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************** **      
      * 1000-PROCESS-INPUT                                            *  *      
      *     ASSIGNS  INPUT PARMS TO WS VARIABLES.                     *  *      
      ***************************************************************** **      
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO     TO IA-ACCOUNT-NO.                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** **      
      * 2000-PROCESS-OUTPUT.                                          *  *      
      *      MAIN BUSINESS LOGIC PROCESS                              *  *      
      ***************************************************************** **      
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-DEPOSIT-CERT-NO     TO S-DEPOSIT-CERT-NO.            
           MOVE RS-ORIG-DEP-AMT        TO S-ORIG-DEP-AMT.               
           MOVE RS-AMT-REFUNDED        TO S-AMT-REFUNDED.               
           MOVE RS-TRANSFER-AMT        TO S-TRANSFER-AMT.               
           MOVE RS-AMT-DEPOSIT         TO S-AMT-DEPOSIT.                
           MOVE RS-TRANSFERRED-TO      TO S-TRANSFERRED-TO.             
           MOVE RS-DEP-CERT-NO-TO      TO S-DEP-CERT-NO-TO.             
           MOVE RS-TRANSFERRED-FROM    TO S-TRANSFERRED-FROM.           
           MOVE RS-DEP-CERT-NO-FROM    TO S-DEP-CERT-NO-FROM.           
           MOVE RS-SERVICE-TYPE-CD     TO S-SERVICE-TYPE-CD.            
           MOVE RS-REPEAT-COUNT        TO S-REPEAT-COUNT.               
           MOVE RS-DATE-TRANS          TO S-DATE-TRANS.                 
           MOVE RS-AMT-POSTED          TO S-AMT-POSTED.                 
           MOVE RS-DEP-PAY-DT          TO S-DEP-PAY-DT.                 
           MOVE RS-DEP-PAY-AMT         TO S-DEP-PAY-AMT.                
           MOVE RS-INT-CREDIT-DT       TO S-INT-CREDIT-DT.              
           MOVE RS-INTEREST-AMT        TO S-INTEREST-AMT.               
           MOVE RS-INTEREST-RT         TO S-INTEREST-RT.                
           MOVE RS-EFFECTIVE-DT        TO S-EFFECTIVE-DT.               
           MOVE RS-REV-DISTRICT-DESC   TO S-REV-DISTRICT-DESC.          
           MOVE RS-DATE-REFUND         TO S-DATE-REFUND.                
           MOVE RS-MANUAL-INDICATOR    TO S-MANUAL-INDICATOR.           
           MOVE RS-DEP-AMT-REFUNDED    TO S-DEP-AMT-REFUNDED.           
           MOVE RS-INT-AMT-REFUNDED    TO S-INT-AMT-REFUNDED.           
           MOVE RS-TOT-AMT-REFUNDED    TO S-TOT-AMT-REFUNDED.           
           MOVE RS-CHECK-ISS-REAS-CD   TO S-CHECK-ISS-REAS-CD.          
           MOVE RS-CHECK-STATUS-CD     TO S-CHECK-STATUS-CD.            
           MOVE RS-USER-NAME-RQSTED-BY TO S-USER-NAME-RQSTED-BY.        
           MOVE RS-USER-NAME-APPRVD-BY TO S-USER-NAME-APPRVD-BY.        
           MOVE RS-ACCT-NO-CREDITED    TO S-ACCT-NO-CREDITED.           
           MOVE RS-COMMENTS            TO S-COMMENTS.                   
           MOVE RS-DEPOSIT-STATUS-CD   TO S-DEPOSIT-STATUS-CD.          
           MOVE RS-DATE-TRAN           TO S-DATE-TRAN.                  
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ****************************************************************  ********
      * 2200-BUILD-RESULT                                            *         *
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                    *         *
      *     PROCESSES ROWS FROM DB2 TABLES INVOLVED.                 *         *
      ****************************************************************  ********
      *                                                                         
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE '2200'              TO ACTIVE-PARAGRAPH.                
                                                                        
           MOVE PARM-ACCOUNT-NO     TO IA-ACCOUNT-NO.                   
                                                                        
           PERFORM 7100-OPEN-DO-CURSOR  THRU  7100-EXIT.                
           PERFORM 7110-FETCH-DO-CURSOR THRU  7110-EXIT.                
           MOVE WS-ACTIVE-RETURN-CODE TO WS-FETCH-RETCODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
           PERFORM 2205-PROCESS-DO-CURSOR     THRU 2205-EXIT            
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
           PERFORM 7120-CLOSE-DO-CURSOR       THRU 7120-EXIT.           
                                                                        
           IF CTR-ROWS <= 0                                             
              MOVE WS-FETCH-RETCODE TO WS-ACTIVE-RETURN-CODE            
              MOVE WS-FETCH-RETCODE TO RS-RETURN-CODE                   
              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** ********
      * 2205-PROCESS-DO-CURSOR                                        *        *
      *     PROCESSES  FOR EVERY DEPOSIT RETIEVED                     *        *
      *                                                               *         
      ***************************************************************** ********
      *                                                                         
       2205-PROCESS-DO-CURSOR.                                          
      *                                                                         
           MOVE 'N' TO WS-IH-NOT-FOUND-FLAG.                            
           MOVE 'N' TO WS-DP-NOT-FOUND-FLAG.                            
           MOVE 'N' TO WS-RN-NOT-FOUND-FLAG.                            
                                                                        
           PERFORM 0110-INIT-DO-RS THRU 0110-EXIT.                      
                                                                        
           COMPUTE WS-ORIG-DEP-AMT = IA-AMT-REFUNDED +                  
               IA-TRANSFER-AMT + IA-AMT-DEPOSIT.                        
                                                                        
           MOVE WS-ORIG-DEP-AMT       TO RS-ORIG-DEP-AMT                
           MOVE IA-DEPOSIT-CERT-NO    TO RS-DEPOSIT-CERT-NO             
           MOVE IA-AMT-REFUNDED       TO RS-AMT-REFUNDED                
           MOVE IA-SERVICE-TYPE-CD    TO RS-SERVICE-TYPE-CD             
           MOVE IA-AMT-DEPOSIT        TO RS-AMT-DEPOSIT                 
           MOVE IA-DEPOSIT-STATUS-CD  TO RS-DEPOSIT-STATUS-CD           
           MOVE IA-DATE-TRAN          TO RS-DATE-TRAN                   
                                                                        
           MOVE IA-TRANSFERRED-TO     TO WS-TRANSFERRED-TO              
           MOVE IA-DEP-CERT-NO-TO     TO WS-DEP-CERT-NO-TO              
           MOVE IA-TRANSFERRED-FROM   TO WS-TRANSFERRED-FROM            
           MOVE IA-DEP-CERT-NO-FROM   TO WS-DEP-CERT-NO-FROM            
                                                                        
           IF WS-TRANSFERRED-TO NOT EQUAL ZERO                          
             MOVE WS-TRANSFERRED-TO   TO WS-TRANS-TO-REDEF              
             MOVE WS-TRANSFER-TO-RED  TO RS-TRANSFERRED-TO              
           ELSE                                                         
             MOVE SPACES              TO RS-TRANSFERRED-TO              
           END-IF.                                                      
                                                                        
           IF WS-DEP-CERT-NO-TO NOT EQUAL ZERO                          
             MOVE WS-DEP-CERT-NO-TO   TO WS-DEP-CERT-TO-REDEF           
             MOVE WS-DEPOSIT-TO-RED   TO RS-DEP-CERT-NO-TO              
           ELSE                                                         
             MOVE SPACES              TO RS-DEP-CERT-NO-TO              
           END-IF.                                                      
                                                                        
           IF WS-TRANSFERRED-FROM NOT EQUAL ZERO                        
             MOVE WS-TRANSFERRED-FROM TO WS-TRANS-FROM-REDEF            
             MOVE WS-TRANSFER-FROM-RED TO RS-TRANSFERRED-FROM           
           ELSE                                                         
             MOVE SPACES              TO RS-TRANSFERRED-FROM            
           END-IF.                                                      
                                                                        
           IF WS-DEP-CERT-NO-FROM NOT EQUAL ZERO                        
             MOVE WS-DEP-CERT-NO-FROM TO WS-DEP-CERT-FROM-REDEF         
             MOVE WS-DEPOSIT-FROM-RED TO RS-DEP-CERT-NO-FROM            
           ELSE                                                         
             MOVE SPACES              TO RS-DEP-CERT-NO-FROM            
           END-IF.                                                      
                                                                        
           MOVE RS-DEP-CERT-NO-TO     TO WS-DEP-CERT-INP-FIELD.         
           MOVE '1'                   TO WS-INPUT-ID.                   
           PERFORM 3600-DEP-CERT-NO-FMT THRU 3600-EXIT.                 
                                                                        
           MOVE WS-DEP-CERT-NO-FROM   TO WS-DEP-CERT-INP-FIELD.         
           MOVE '2'                   TO WS-INPUT-ID.                   
           PERFORM 3600-DEP-CERT-NO-FMT THRU 3600-EXIT.                 
                                                                        
           MOVE IA-TRANSFER-AMT       TO RS-TRANSFER-AMT                
                                                                        
           MOVE PARM-ACCOUNT-NO       TO HU-ACCOUNT-NO                  
                                                                        
           MOVE PARM-ACCOUNT-NO       TO HA-ACCOUNT-NO.                 
                                                                        
           MOVE IA-DEPOSIT-CERT-NO    TO HU-DEPOSIT-CERT-NO.            
           PERFORM 7165-OPEN-RN-CURSOR  THRU 7165-EXIT.                 
           PERFORM 7166-FETCH-RN-CURSOR THRU 7166-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'Y' TO WS-RN-NOT-FOUND-FLAG                          
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           END-IF.                                                      
                                                                        
           MOVE PARM-ACCOUNT-NO       TO NI-ACCOUNT-NO                  
           MOVE IA-DEPOSIT-CERT-NO    TO NI-DEPOSIT-CERT-NO.            
                                                                        
           PERFORM 7200-OPEN-IH-CURSOR  THRU 7200-EXIT.                 
           PERFORM 7210-FETCH-IH-CURSOR THRU 7210-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'Y' TO WS-IH-NOT-FOUND-FLAG                          
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           END-IF.                                                      
                                                                        
           MOVE PARM-ACCOUNT-NO     TO HG-ACCOUNT-NO.                   
           MOVE IA-DEPOSIT-CERT-NO  TO HG-DEPOSIT-CERT-NO.              
                                                                        
           PERFORM 7220-OPEN-DP-CURSOR  THRU 7220-EXIT.                 
           PERFORM 7230-FETCH-DP-CURSOR THRU 7230-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'Y' TO WS-DP-NOT-FOUND-FLAG                          
              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                      
           END-IF.                                                      
                                                                        
           IF  WS-IH-NOT-FOUND-FLAG  = 'Y'                              
           AND WS-RN-NOT-FOUND-FLAG  = 'Y'                              
           AND WS-DP-NOT-FOUND-FLAG  = 'Y' THEN                         
               PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
               PERFORM 8100-SEND-RESULT      THRU 8100-EXIT             
           END-IF.                                                      
                                                                        
           MOVE ZEROES              TO WS-INTEREST-AMT-HOLD.            
           MOVE ZEROES              TO WS-DEP-AMT-REFUNDED.             
                                                                        
           PERFORM 2210-PROCESS-OTHER-CURSORS THRU 2210-EXIT            
           UNTIL WS-IH-NOT-FOUND                                        
             AND WS-DP-NOT-FOUND                                        
             AND WS-RN-NOT-FOUND                                        
                                                                        
           PERFORM 7184-CLOSE-RN-CURSOR THRU 7184-EXIT.                 
           PERFORM 7215-CLOSE-IH-CURSOR THRU 7215-EXIT.                 
           PERFORM 7235-CLOSE-DP-CURSOR THRU 7235-EXIT.                 
           PERFORM 0125-INIT-RN-RS      THRU 0125-EXIT                  
           PERFORM 0150-INIT-IH-RS      THRU 0150-EXIT                  
           PERFORM 0140-INIT-DP-RS      THRU 0140-EXIT                  
                                                                        
           MOVE WS-Y                TO WS-NUM-TIMES-THRU.               
                                                                        
           PERFORM 7110-FETCH-DO-CURSOR THRU 7110-EXIT.                 
           MOVE 1 TO RS-REPEAT-COUNT.                                   
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  ********
      * 2210-PROCESS-OTHER-CURSORS                                   *         *
      *                                                              *          
      * RETRIEVES DATA FROM OTHER DB2 TABLES TO POPULATE RESULT SET  *         *
      * DATA FIELDS.                                                 *         *
      ****************************************************************  ********
      *                                                                         
       2210-PROCESS-OTHER-CURSORS.                                      
      *                                                                         
           MOVE '2210'  TO ACTIVE-PARAGRAPH.                            
                                                                        
           IF WS-RN-NOT-FOUND                                           
              PERFORM 0125-INIT-RN-RS           THRU 0125-EXIT          
           ELSE                                                         
              IF FIRST-TIME-THRU                                        
                MOVE IA-ACCOUNT-NO  TO NI-ACCOUNT-NO                    
                MOVE IA-DEPOSIT-CERT-NO                                 
                                    TO NI-DEPOSIT-CERT-NO               
                                                                        
                PERFORM 7900-SELECT-TOTAL-INT   THRU 7900-EXIT          
                                                                        
                COMPUTE WS-DEP-AMT-REFUNDED =                           
                  HU-AMT-REFUNDED - WS-INTEREST-AMT-HOLD                
                                                                        
                MOVE WS-N               TO WS-NUM-TIMES-THRU            
                                                                        
                                                                        
              ELSE                                                      
                MOVE ZEROES             TO WS-INTEREST-AMT-HOLD         
                COMPUTE WS-DEP-AMT-REFUNDED =                           
                  HU-AMT-REFUNDED - WS-INTEREST-AMT-HOLD                
              END-IF                                                    
                                                                        
              MOVE WS-INTEREST-AMT-HOLD TO RS-INT-AMT-REFUNDED          
              MOVE WS-DEP-AMT-REFUNDED  TO RS-DEP-AMT-REFUNDED          
              MOVE HU-AMT-REFUNDED      TO RS-TOT-AMT-REFUNDED          
              MOVE HU-CHECK-ISS-REAS-CD TO RS-CHECK-ISS-REAS-CD         
              MOVE WS-DATE-REFUND       TO RS-DATE-REFUND               
              MOVE SPACES               TO RS-COMMENTS                  
              MOVE HU-COMMENTS          TO RS-COMMENTS                  
      *                                                                         
              IF HU-USER-ID-APPRVD-BY NOT EQUAL SPACES                  
                MOVE HU-USER-ID-APPRVD-BY TO PF-USER-ID                 
                PERFORM 7975-SELECT-USER-NAME           THRU 7975-EXIT  
                PERFORM 2500-PROCESS-NAME               THRU 2500-EXIT  
                MOVE WS-HOLD-NAME-OUTPUT  TO RS-USER-NAME-APPRVD-BY     
              ELSE                                                      
                MOVE SPACES               TO RS-USER-NAME-APPRVD-BY     
              END-IF                                                    
      *                                                                         
              IF HU-USER-ID-RQSTED-BY NOT EQUAL SPACES                  
                MOVE HU-USER-ID-RQSTED-BY TO PF-USER-ID                 
                PERFORM 7975-SELECT-USER-NAME           THRU 7975-EXIT  
                PERFORM 2500-PROCESS-NAME               THRU 2500-EXIT  
                MOVE WS-HOLD-NAME-OUTPUT  TO RS-USER-NAME-RQSTED-BY     
              ELSE                                                      
                MOVE SPACES               TO RS-USER-NAME-RQSTED-BY     
              END-IF                                                    
      *                                                                         
              MOVE HU-CHECK-STATUS-CD     TO RS-CHECK-STATUS-CD         
              MOVE HU-MANUAL-INDICATOR    TO RS-MANUAL-INDICATOR        
              MOVE HU-ACCT-NO-CREDITED    TO WS-ACCT-NO-CREDITED        
      *                                                                         
              IF WS-ACCT-NO-CREDITED NOT EQUAL ZERO                     
                MOVE WS-ACCT-NO-CREDITED  TO WS-ACCT-NO-CRD-REDEF       
                MOVE WS-ACCT-NO-CREDIT-RED                              
                                          TO RS-ACCT-NO-CREDITED        
              ELSE                                                      
                MOVE SPACES               TO RS-ACCT-NO-CREDITED        
              END-IF                                                    
      *                                                                         
              PERFORM 7166-FETCH-RN-CURSOR THRU 7166-EXIT               
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'  TO WS-RN-NOT-FOUND-FLAG                      
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-IH-NOT-FOUND                                           
              PERFORM 0150-INIT-IH-RS          THRU 0150-EXIT           
           ELSE                                                         
              MOVE WS-INT-CREDIT-DT     TO RS-INT-CREDIT-DT             
              MOVE NI-INTEREST-AMT      TO RS-INTEREST-AMT              
              MOVE NI-INTEREST-RT       TO  RS-INTEREST-RT              
              MOVE WS-EFFECTIVE-DT      TO  RS-EFFECTIVE-DT             
              MOVE PR-REV-DISTRICT-CD   TO WS-HOLD-REV-DIST             
              PERFORM 7950-SELECT-REV-DIST     THRU 7950-EXIT           
              MOVE A9-REV-DISTRICT-DESC TO RS-REV-DISTRICT-DESC         
              PERFORM 7210-FETCH-IH-CURSOR     THRU 7210-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'  TO WS-IH-NOT-FOUND-FLAG                      
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-DP-NOT-FOUND                                           
              PERFORM 0140-INIT-DP-RS      THRU 0140-EXIT               
           ELSE                                                         
              MOVE WS-DEP-PAY-DT TO RS-DEP-PAY-DT                       
              MOVE HG-DEP-PAY-AMT TO RS-DEP-PAY-AMT                     
              PERFORM 7230-FETCH-DP-CURSOR THRU 7230-EXIT               
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'Y'  TO WS-DP-NOT-FOUND-FLAG                      
                 MOVE ZERO TO WS-ACTIVE-RETURN-CODE                     
              END-IF                                                    
           END-IF.                                                      
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
           ADD 1 TO RS-REPEAT-COUNT.                                    
      *                                                                         
        2210-EXIT.                                                      
              EXIT.                                                     
      *                                                                         
      *****************************************************************         
      * 2500-PROCESS-NAME                                             *         
      *    -- THIS MODULE RETRIEVES THE USER NAME TO THE PANEL --     *         
      *****************************************************************         
      *                                                                         
       2500-PROCESS-NAME.                                               
      *                                                                         
           MOVE SPACES           TO    WS-HOLD-NAME-OUTPUT.             
                                                                        
           MOVE PF-FIRST-NAME    TO    WS-FROM.                         
           PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
           MOVE WS-FROM          TO    PF-FIRST-NAME.                   
                                                                        
           MOVE PF-LAST-NAME     TO    WS-FROM.                         
           PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
           MOVE WS-FROM          TO    PF-LAST-NAME.                    
                                                                        
           MOVE PF-MIDDLE-NAME   TO    WS-FROM.                         
           PERFORM 2510-PROCESS-FROM-STRING   THRU  2510-EXIT.          
           MOVE WS-FROM          TO    PF-MIDDLE-NAME.                  
                                                                        
           STRING PF-LAST-NAME DELIMITED CN-DELIMITER                   
                  ', ' DELIMITED SIZE                                   
                  PF-FIRST-NAME DELIMITED CN-DELIMITER                  
                  ' ' DELIMITED SIZE                                    
                  PF-MIDDLE-NAME DELIMITED CN-DELIMITER                 
             INTO WS-HOLD-NAME-OUTPUT                                   
           END-STRING.                                                  
                                                                        
           IF WS-HOLD-NAME-OUTPUT (1:6) EQUAL 'SYSTEM'                  
              MOVE SPACES TO WS-HOLD-NAME-OUTPUT (7:23)                 
           ELSE                                                         
              IF WS-HOLD-NAME-OUTPUT (1:1) EQUAL ','                    
                 MOVE SPACES TO WS-HOLD-NAME-OUTPUT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2510-PROCESS-FROM-STRING                                      *         
      *****************************************************************         
      *                                                                         
       2510-PROCESS-FROM-STRING.                                        
      *                                                                         
           PERFORM                                                      
              VARYING WS-SUB FROM 15 BY -1                              
                  UNTIL WS-SUB < 1                                      
                  OR WS-FROM-X(WS-SUB) NOT = SPACE                      
           END-PERFORM.                                                 
           ADD 1      TO   WS-SUB.                                      
           MOVE CN-DELIMITER  TO WS-FROM-X(WS-SUB).                     
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************                
      ** 3600-DEP-CERT-NO-FMT.                                 *                
      ** THIS PARAGRAPHS FORMATS THE DEPOSIT CERTIFICATE NUMS  *                
      ** TO ELIMINATE LEADING ZEROES BEFORE PASSING THEM BACK  *                
      **                   TO THE PANEL.                       *                
      **********************************************************                
      *                                                                         
       3600-DEP-CERT-NO-FMT.                                            
      *                                                                         
           MOVE WS-N                TO WS-POSITIVE-FOUND-SW.            
                                                                        
           PERFORM VARYING WS-COUNT FROM +1 BY +1                       
             UNTIL WS-COUNT > 9 OR POSITIVE-NUM-IS-FOUND                
               IF WS-DEP-CERT-INP-FIELD(WS-COUNT:1) EQUAL '0'           
                 IF WS-INPUT-ID EQUAL '1'                               
                   MOVE SPACES      TO RS-DEP-CERT-NO-TO(WS-COUNT:1)    
                 ELSE                                                   
                   MOVE SPACES      TO RS-DEP-CERT-NO-FROM(WS-COUNT:1)  
                 END-IF                                                 
               ELSE                                                     
                 MOVE WS-Y          TO WS-POSITIVE-FOUND-SW             
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************       ********
      ** 7100-OPEN-DO-CURSOR.                                   *       H     **
      ***********************************************************       ********
      *                                                                         
       7100-OPEN-DO-CURSOR.                                             
           MOVE '7100'    TO ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                OPEN DO-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'HST_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO '        TO TABLE-ELEMENT-1              
              MOVE IA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************       ********
      **7110-FETCH-DO-CURSOR.                                   *             **
      ***********************************************************       ********
      *                                                                         
       7110-FETCH-DO-CURSOR.                                            
      *                                                                         
           MOVE '7110'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             FETCH DO-CURSOR                                            
             INTO :IA-DEPOSIT-CERT-NO,                                  
                  :IA-AMT-REFUNDED,                                     
                  :IA-SERVICE-TYPE-CD,                                  
                  :IA-AMT-DEPOSIT,                                      
                  :IA-TOTAL-INTRST,                                     
                  :WS-DATE-REFUNDED :WS-NULL-IND1,                       
                  :IA-DATE-TRAN :WS-NULL-IND2,                           
                  :IA-TRANSFERRED-TO,                                   
                  :IA-DEP-CERT-NO-TO,                                   
                  :IA-TRANSFERRED-FROM,                                 
                  :IA-DEP-CERT-NO-FROM,                                 
                  :IA-TRANSFER-AMT,                                     
                  :IA-DEPOSIT-STATUS-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-DATE-REFUNDED                        
           END-IF                                                       
                                                                        
           IF WS-NULL-IND2 < 0                                          
                 MOVE SPACES TO IA-DATE-TRAN                            
           END-IF                                                       
                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'HST_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE IA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************        ********
      ** 7120-CLOSE-DO-CURSOR.                                 *        CH    **
      **********************************************************        ********
      *                                                                         
       7120-CLOSE-DO-CURSOR.                                            
                                                                        
           MOVE '7120'   TO ACTIVE-PARAGRAPH.                           
           EXEC SQL                                                     
                 CLOSE DO-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_ON_HAND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE IA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************        ********
      **7200-OPEN-IH-CURSOR.                                   *        H     **
      **********************************************************        ********
      *                                                                         
       7200-OPEN-IH-CURSOR.                                             
      *                                                                         
           MOVE '7200'    TO ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                OPEN IH-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'HST_INTEREST_HIST'  TO TABLE-1                      
              MOVE 'CSS_PREMISE'        TO TABLE-2                      
              MOVE 'HST_ACCOUNT'        TO TABLE-3                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
              MOVE NI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE NI-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************        ********
      **7210-FETCH-IH-CURSOR.                                  *              **
      **********************************************************        ********
      *                                                                         
       7210-FETCH-IH-CURSOR.                                            
      *                                                                         
           MOVE '7210'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             FETCH IH-CURSOR                                            
             INTO :WS-INT-CREDIT-DT :WS-NULL-IND1,                       
                  :NI-INT-CREDIT-DT :WS-NULL-IND2,                       
                  :NI-INTEREST-AMT,                                     
                  :NI-INTEREST-RT,                                      
                  :WS-EFFECTIVE-DT :WS-NULL-IND1,                        
                  :NI-EFFECTIVE-DT :WS-NULL-IND2,                        
                  :PR-REV-DISTRICT-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-EFFECTIVE-DT                         
                 MOVE SPACES TO WS-INT-CREDIT-DT                        
           END-IF.                                                      
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
                 MOVE SPACES TO NI-EFFECTIVE-DT                         
                 MOVE SPACES TO NI-INT-CREDIT-DT                        
           END-IF.                                                      
                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'HST_INTEREST_HIST'  TO TABLE-1                      
              MOVE 'CSS_PREMISE'        TO TABLE-2                      
              MOVE 'HST_ACCOUNT'        TO TABLE-3                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
              MOVE NI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE NI-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ********************************************************          ********
      **7215-CLOSE-IH-CURSOR.                                *          CH    **
      ********************************************************          ********
      *                                                                         
       7215-CLOSE-IH-CURSOR.                                            
      *                                                                         
           MOVE '7215'   TO ACTIVE-PARAGRAPH.                           
           EXEC SQL                                                     
                 CLOSE IH-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'HST_INTEREST_HIST'  TO TABLE-1                      
              MOVE 'CSS_PREMISE'        TO TABLE-2                      
              MOVE 'HST_ACCOUNT'        TO TABLE-3                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
              MOVE NI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE NI-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************        ********
      **7220-OPEN-DP-CURSOR.                                   *        H     **
      **********************************************************        ********
      *                                                                         
       7220-OPEN-DP-CURSOR.                                             
      *                                                                         
           MOVE '7220'    TO ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                OPEN DP-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_DEP_PAY_HST'  TO TABLE-1                        
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
              MOVE HG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE HG-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************             ********
      **7230-FETCH-DP-CURSOR.                             *                   **
      *****************************************************             ********
      *                                                                         
       7230-FETCH-DP-CURSOR.                                            
      *                                                                         
           MOVE '7230'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             FETCH DP-CURSOR                                            
             INTO :WS-DEP-PAY-DT :WS-NULL-IND1,                          
                  :HG-DEP-PAY-DT :WS-NULL-IND2,                          
                  :HG-DEP-PAY-AMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-DEP-PAY-DT                           
           END-IF.                                                      
                                                                        
      *                                                                         
           IF WS-NULL-IND2 < 0                                          
                 MOVE SPACES TO HG-DEP-PAY-DT                           
           END-IF.                                                      
                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'HST_DEP_PAY_HST'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
              MOVE HG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE HG-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *******************************************************           ********
      **7235-CLOSE-DP-CURSOR.                               *           CH    **
      *******************************************************           ********
      *                                                                         
       7235-CLOSE-DP-CURSOR.                                            
      *                                                                         
           MOVE '7235'   TO ACTIVE-PARAGRAPH.                           
           EXEC SQL                                                     
                 CLOSE DP-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'HST_DEP_PAY_HST'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-2              
              MOVE HG-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE HG-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7235-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***********************************************************       ********
      **7165-OPEN-RN-CURSOR.                                    *       H     **
      ***********************************************************       ********
      *                                                                         
       7165-OPEN-RN-CURSOR.                                             
      *                                                                         
           MOVE '7165'    TO ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                OPEN RN-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                 NEXT SENTENCE                                          
           ELSE                                                         
             MOVE PROGRAM-NAME               TO ABEND-PROGRAM           
             MOVE 'OPEN'                     TO ABEND-FUNCTION          
             MOVE 'HST_REFUND       '        TO TABLE-1                 
             MOVE 'ACCOUNT_NO   '            TO TABLE-ELEMENT-1         
             MOVE 'DEPOSIT_CERT_NO '         TO TABLE-ELEMENT-2         
             MOVE HU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1       
             MOVE HU-DEPOSIT-CERT-NO         TO HOSTVAR-ELEMENT-2       
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.            
      *                                                                         
       7165-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **********************************************************        ********
      **7166-FETCH-RN-CURSOR.                                  *              **
      **********************************************************        ********
      *                                                                         
       7166-FETCH-RN-CURSOR.                                            
      *                                                                         
           MOVE SPACES          TO HU-COMMENTS.                         
           MOVE '7166'          TO ACTIVE-PARAGRAPH.                    
           EXEC SQL                                                     
             FETCH RN-CURSOR                                            
             INTO :HU-REFUND-ITEM-ID,                                   
                  :HU-REFUND-CHECK-NO,                                  
                  :HU-AMT-REFUNDED,                                     
                  :WS-DATE-REFUND :WS-NULL-IND1,                         
                  :HU-CHECK-ISS-REAS-CD,                                
                  :HU-USER-ID-APPRVD-BY,                                
                  :HU-USER-ID-RQSTED-BY,                                
                  :HU-CHECK-STATUS-CD,                                  
                  :HU-MANUAL-INDICATOR,                                 
                  :HU-ACCT-NO-CREDITED,                                 
                  :HU-COMMENTS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-NULL-IND1 < 0                                          
                 MOVE SPACES TO WS-DATE-REFUND                          
           END-IF                                                       
                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                     OR     NOT-FOUND                   
                 NEXT SENTENCE                                          
           ELSE                                                         
           MOVE PROGRAM-NAME             TO ABEND-PROGRAM               
           MOVE 'FETCH'                  TO ABEND-FUNCTION              
           MOVE 'HST_REFUND     '        TO TABLE-1                     
           MOVE 'ACCOUNT_NO  '           TO TABLE-ELEMENT-1             
           MOVE 'DEPOSIT_CERT_NO'        TO TABLE-ELEMENT-2             
           MOVE HU-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1           
           MOVE HU-DEPOSIT-CERT-NO       TO HOSTVAR-ELEMENT-2           
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT               
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.              
      *                                                                         
       7166-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *********************************************************         ********
      **7184-CLOSE-RN-CURSOR.                                 *         CH    **
      *********************************************************         ********
      *                                                                         
       7184-CLOSE-RN-CURSOR.                                            
      *                                                                         
           MOVE '7184'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
                 CLOSE RN-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'HST_REFUND'        TO TABLE-1                       
              MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1               
              MOVE 'DEPOSIT_CERT_NO'   TO TABLE-ELEMENT-2               
              MOVE HU-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              MOVE HU-DEPOSIT-CERT-NO  TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
       7184-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      **    7900-SELECT-TOTAL-INT                                 *             
      *************************************************************             
      *                                                                         
       7900-SELECT-TOTAL-INT.                                           
      *                                                                         
           MOVE '7900'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             SELECT SUM(INTEREST_AMT)                                   
             INTO   :WS-INTEREST-AMT-HOLD :WS-NULL-INT                   
             FROM   HST_INTEREST_HIST                                   
             WHERE  INT_CREDIT_DT    = IIF(TRY_CONVERT(DATE, 
                                                        :WS-DATE-REFUND
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-REFUND
              ) <> 0) OR (LEN(:WS-DATE-REFUND) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-REFUND
              ), CONVERT(DATE, :WS-DATE-REFUND) )                  
               AND  ACCOUNT_NO       = :NI-ACCOUNT-NO                   
               AND  DEPOSIT_CERT_NO  = :NI-DEPOSIT-CERT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUM(INTEREST_AMT)                                           
MFA-TR*      INTO   :WS-INTEREST-AMT-HOLD:WS-NULL-INT                           
MFA-TR*      FROM   HST_INTEREST_HIST                                           
MFA-TR*      WHERE  INT_CREDIT_DT    = :WS-DATE-REFUND                          
MFA-TR*        AND  ACCOUNT_NO       = :NI-ACCOUNT-NO                           
MFA-TR*        AND  DEPOSIT_CERT_NO  = :NI-DEPOSIT-CERT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-NULL-INT < 0                                           
              MOVE ZEROES           TO WS-INTEREST-AMT-HOLD             
           END-IF.                                                      
                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'HST_INTEREST_HIST'  TO TABLE-1                      
              MOVE 'INT_CREDIT_DT'      TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE 'DEPOSIT_CERT_NO'    TO TABLE-ELEMENT-3              
              MOVE WS-DATE-REFUND       TO HOSTVAR-ELEMENT-1            
              MOVE NI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              MOVE NI-DEPOSIT-CERT-NO   TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      ** 7950-SELECT-REV-DIST                                     *             
      *************************************************************             
      *                                                                         
       7950-SELECT-REV-DIST.                                            
      *                                                                         
           MOVE '7950'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             SELECT   REV_DISTRICT_DESC                                 
               INTO   :A9-REV-DISTRICT-DESC                             
               FROM   CSS_REV_DISTRICT                                  
              WHERE   REV_DISTRICT_CD  =  :WS-HOLD-REV-DIST             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             NEXT SENTENCE                                              
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE SPACES        TO A9-REV-DISTRICT-DESC               
             ELSE                                                       
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_REV_DISTRICT'   TO TABLE-1                     
               MOVE 'REV_DISTRICT_CD'    TO TABLE-ELEMENT-1             
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
               MOVE WS-HOLD-REV-DIST     TO HOSTVAR-ELEMENT-1           
               MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7975-SELECT-USER-NAME                                         *         
      *     SELECTS THE USER NAME FOR PROCESSING                      *         
      *****************************************************************         
      *                                                                         
       7975-SELECT-USER-NAME.                                           
      *                                                                         
           MOVE '7975'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             SELECT   FIRST_NAME,                                       
                      MIDDLE_NAME,                                      
                      LAST_NAME                                         
               INTO   :PF-FIRST-NAME,                                   
                      :PF-MIDDLE-NAME,                                  
                      :PF-LAST-NAME                                     
               FROM   CSS_USER_PROFILE                                  
              WHERE   USER_ID   =  :PF-USER-ID                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             NEXT SENTENCE                                              
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE SPACES        TO PF-FIRST-NAME,                     
                                     PF-LAST-NAME,                      
                                     PF-MIDDLE-NAME                     
             ELSE                                                       
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_USER_PROFILE'   TO TABLE-1                     
               MOVE 'USER_ID'            TO TABLE-ELEMENT-1             
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
               MOVE PF-USER-ID           TO HOSTVAR-ELEMENT-1           
               MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       7975-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS.                                          *        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04313_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04313_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04313_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8100-SEND-RESULT.                                               *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
            EXEC SQL                                                    
                 INSERT INTO #CSR04313_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,DEPOSIT_CERT_NO                                   
                     ,ORIG_DEP_AMT                                      
                     ,AMT_REFUNDED                                      
                     ,TRANSFER_AMT                                      
                     ,AMT_DEPOSIT                                       
                     ,TRANSFERRED_TO                                    
                     ,DEP_CERT_NO_TO                                    
                     ,TRANSFERRED_FROM                                  
                     ,DEP_CERT_NO_FROM                                  
                     ,SERVICE_TYPE_CD                                   
                     ,REPEAT_COUNT                                      
                     ,DATE_TRANS                                        
                     ,AMT_POSTED                                        
                     ,DEP_PAY_DT                                        
                     ,DEP_PAY_AMT                                       
                     ,INT_CREDIT_DT                                     
                     ,INTEREST_AMT                                      
                     ,INTEREST_RT                                       
                     ,EFFECTIVE_DT                                      
                     ,REV_DISTRICT_DESC                                 
                     ,DATE_REFUND                                       
                     ,MANUAL_INDICATOR                                  
                     ,[DEP-AMT_REFUNDED]                                  
                     ,[INT-AMT_REFUNDED]                                  
                     ,[TOT-AMT_REFUNDED]                                  
                     ,[CHECK_ISS-REAS_CD]                                 
                     ,CHECK_STATUS_CD                                   
                     ,[USER_NAME-RQTED_BY]                                
                     ,USER_NAME_APRVD_BY                                
                     ,ACCT_NO_CREDITED                                  
                     ,COMMENTS                                          
                     ,DEPOSIT_STATUS_CD                                 
                     ,DATE_TRAN                                         
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-DEPOSIT-CERT-NO                                
                     ,:S-ORIG-DEP-AMT                                   
                     ,:S-AMT-REFUNDED                                   
                     ,:S-TRANSFER-AMT                                   
                     ,:S-AMT-DEPOSIT                                    
                     ,:S-TRANSFERRED-TO                                 
                     ,:S-DEP-CERT-NO-TO                                 
                     ,:S-TRANSFERRED-FROM                               
                     ,:S-DEP-CERT-NO-FROM                               
                     ,:S-SERVICE-TYPE-CD                                
                     ,:S-REPEAT-COUNT                                   
                     ,:S-DATE-TRANS                                     
                     ,:S-AMT-POSTED                                     
                     ,:S-DEP-PAY-DT                                     
                     ,:S-DEP-PAY-AMT                                    
                     ,:S-INT-CREDIT-DT                                  
                     ,:S-INTEREST-AMT                                   
                     ,:S-INTEREST-RT                                    
                     ,:S-EFFECTIVE-DT                                   
                     ,:S-REV-DISTRICT-DESC                              
                     ,:S-DATE-REFUND                                    
                     ,:S-MANUAL-INDICATOR                               
                     ,:S-DEP-AMT-REFUNDED                               
                     ,:S-INT-AMT-REFUNDED                               
                     ,:S-TOT-AMT-REFUNDED                               
                     ,:S-CHECK-ISS-REAS-CD                              
                     ,:S-CHECK-STATUS-CD                                
                     ,:S-USER-NAME-RQSTED-BY                            
                     ,:S-USER-NAME-APPRVD-BY                            
                     ,:S-ACCT-NO-CREDITED                               
                     ,:S-COMMENTS                                       
                     ,:S-DEPOSIT-STATUS-CD                              
                     ,:S-DATE-TRAN                                      
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04313_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,DEPOSIT_CERT_NO                                           
MFA-TR*              ,ORIG_DEP_AMT                                              
MFA-TR*              ,AMT_REFUNDED                                              
MFA-TR*              ,TRANSFER_AMT                                              
MFA-TR*              ,AMT_DEPOSIT                                               
MFA-TR*              ,TRANSFERRED_TO                                            
MFA-TR*              ,DEP_CERT_NO_TO                                            
MFA-TR*              ,TRANSFERRED_FROM                                  .       
MFA-TR*              ,DEP_CERT_NO_FROM                                  .       
MFA-TR*              ,SERVICE_TYPE_CD                                           
MFA-TR*              ,REPEAT_COUNT                                              
MFA-TR*              ,DATE_TRANS                                                
MFA-TR*              ,AMT_POSTED                                                
MFA-TR*              ,DEP_PAY_DT                                                
MFA-TR*              ,DEP_PAY_AMT                                               
MFA-TR*              ,INT_CREDIT_DT                                             
MFA-TR*              ,INTEREST_AMT                                      0.      
MFA-TR*              ,INTEREST_RT                                               
MFA-TR*              ,EFFECTIVE_DT                                              
MFA-TR*              ,REV_DISTRICT_DESC                                         
MFA-TR*              ,DATE_REFUND                                               
MFA-TR*              ,MANUAL_INDICATOR                                          
MFA-TR*              ,DEP-AMT_REFUNDED                                          
MFA-TR*              ,INT-AMT_REFUNDED                                          
MFA-TR*              ,TOT-AMT_REFUNDED                                          
MFA-TR*              ,CHECK_ISS-REAS_CD                                         
MFA-TR*              ,CHECK_STATUS_CD                                           
MFA-TR*              ,USER_NAME-RQTED_BY                                        
MFA-TR*              ,USER_NAME_APRVD_BY                                        
MFA-TR*              ,ACCT_NO_CREDITED                                          
MFA-TR*              ,COMMENTS                                                  
MFA-TR*              ,DEPOSIT_STATUS_CD                                         
MFA-TR*              ,DATE_TRAN                                         02402000
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-DEPOSIT-CERT-NO                                        
MFA-TR*              ,:S-ORIG-DEP-AMT                                           
MFA-TR*              ,:S-AMT-REFUNDED                                           
MFA-TR*              ,:S-TRANSFER-AMT                                           
MFA-TR*              ,:S-AMT-DEPOSIT                                            
MFA-TR*              ,:S-TRANSFERRED-TO                                         
MFA-TR*              ,:S-DEP-CERT-NO-TO                                         
MFA-TR*              ,:S-TRANSFERRED-FROM                               .       
MFA-TR*              ,:S-DEP-CERT-NO-FROM                               .       
MFA-TR*              ,:S-SERVICE-TYPE-CD                                        
MFA-TR*              ,:S-REPEAT-COUNT                                           
MFA-TR*              ,:S-DATE-TRANS                                             
MFA-TR*              ,:S-AMT-POSTED                                             
MFA-TR*              ,:S-DEP-PAY-DT                                             
MFA-TR*              ,:S-DEP-PAY-AMT                                            
MFA-TR*              ,:S-INT-CREDIT-DT                                          
MFA-TR*              ,:S-INTEREST-AMT                                   0.      
MFA-TR*              ,:S-INTEREST-RT                                            
MFA-TR*              ,:S-EFFECTIVE-DT                                           
MFA-TR*              ,:S-REV-DISTRICT-DESC                                      
MFA-TR*              ,:S-DATE-REFUND                                            
MFA-TR*              ,:S-MANUAL-INDICATOR                                       
MFA-TR*              ,:S-DEP-AMT-REFUNDED                                       
MFA-TR*              ,:S-INT-AMT-REFUNDED                                       
MFA-TR*              ,:S-TOT-AMT-REFUNDED                                       
MFA-TR*              ,:S-CHECK-ISS-REAS-CD                                      
MFA-TR*              ,:S-CHECK-STATUS-CD                                        
MFA-TR*              ,:S-USER-NAME-RQSTED-BY                                    
MFA-TR*              ,:S-USER-NAME-APPRVD-BY                                    
MFA-TR*              ,:S-ACCT-NO-CREDITED                                       
MFA-TR*              ,:S-COMMENTS                                               
MFA-TR*              ,:S-DEPOSIT-STATUS-CD                                      
MFA-TR*              ,:S-DATE-TRAN                                      02402000
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04313_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *********************************************                             
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      *********************************************                             
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ********************************************                              
      *    END PROGRAM COPYLIB                   *                              
      ********************************************                              
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
      *                                                                         
