       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04312.                                         
COB303 DATE-WRITTEN.  SEP 24, 2009.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES REFUND DATA FOR ARCHIVED ACCOUNTS.   *        
      *  THIS INFORMATION EXISTS TO SUPPORT THE MANAGEMENT OF THE      *        
      *  REGISTER INFORMATION.                                         *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
A37666*  09/24/09    SP95538  PROCEDURE ORIGINALLY CODED.              *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04312'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04312 STARTS HERE'.                  
                                                                        
      **************************************************************            
      *    DB2 INCLUDES                                            *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  HST_ACCOUNT - HA                                          *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  HST_REFUND - HU                                           *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHREFUN                                                  
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_NAME - DQ                                             *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_NAME_ACCT_XREF - HT                                   *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_PREMISE - PR                                          *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_ADDR_FORMATTED - DY                                   *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_ADDR_FREEFORM - DZ                                    *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      *  CSS_ZIP_CODE - A4                                         *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-REFUND.                                               
               10 RS-REFUND-ITEM-ID       PIC S9(9) COMP VALUE +0.      
               10 RS-REFUND-CHECK-NO      PIC X(9)       VALUE SPACES.  
               10 RS-DEPOSIT-CERT-NO      PIC S9(9) COMP VALUE +0.      
               10 RS-REQUEST-DT           PIC X(10)      VALUE SPACES.  
               10 RS-CLEARED-DT           PIC X(10)      VALUE SPACES.  
               10 RS-DATE-CHECK-VOIDED    PIC X(10)      VALUE SPACES.  
               10 RS-STOP-REQUEST-DT      PIC X(10)      VALUE SPACES.  
               10 RS-CHECK-REMAIL-DT      PIC X(10)      VALUE SPACES.  
               10 RS-REISSUED-DATE        PIC X(10)      VALUE SPACES.  
               10 RS-ORIGINAL-CHECK-NO    PIC X(9)       VALUE SPACES.  
               10 RS-RETURNED-REASON      PIC X(1)       VALUE SPACES.  
               10 RS-USER-ID-APPRVD-BY    PIC X(7)       VALUE SPACES.  
               10 RS-USER-ID-RQSTED-BY    PIC X(7)       VALUE SPACES.  
               10 RS-RETURNED-DATE        PIC X(10)      VALUE SPACES.  
               10 RS-DATE-ESCHEATED       PIC X(10)      VALUE SPACES.  
               10 RS-COMMENTS             PIC X(72)      VALUE SPACES.  
               10 RS-AMT-REFUNDED         PIC S999999999V99 COMP-3      
                                                         VALUE 0.       
               10 RS-MANUAL-INDICATOR     PIC X(1)       VALUE SPACES.  
               10 RS-DATE-REFUNDED        PIC X(10)      VALUE SPACES.  
               10 RS-CHECK-ISS-REAS-CD    PIC X(2)       VALUE SPACES.  
               10 RS-CHECK-STATUS-CD      PIC X(1)       VALUE SPACES.  
               10 RS-REFUND-STATUS-DT     PIC X(10)      VALUE SPACES.  
               10 RS-DATE-ESCH-VERIFIED   PIC X(10)      VALUE SPACES.  
               10 RS-DATE-ESCH-RETURNED   PIC X(10)      VALUE SPACES.  
               10 RS-NAME-FORMAT          PIC X(01)      VALUE SPACES.  
               10 RS-TITLE-PREFIX         PIC X(09)      VALUE SPACES.  
               10 RS-FIRST-NAME           PIC X(15)      VALUE SPACES.  
               10 RS-MIDDLE-NAME          PIC X(15)      VALUE SPACES.  
               10 RS-LAST-NAME            PIC X(20)      VALUE SPACES.  
               10 RS-FULL-NAME            PIC X(50)      VALUE SPACES.  
               10 RS-TITLE-SUFFIX-1       PIC X(03)      VALUE SPACES.  
               10 RS-TITLE-SUFFIX-2       PIC X(03)      VALUE SPACES.  
               10 RS-ADDRESS-FORMAT       PIC X(01)      VALUE SPACES.  
               10 RS-HOUSE-NO             PIC X(05)      VALUE SPACES.  
               10 RS-ADDR-PREFIX-1        PIC X(03)      VALUE SPACES.  
               10 RS-ADDR-PREFIX-2        PIC X(02)      VALUE SPACES.  
               10 RS-ADDR-SUFFIX          PIC X(02)      VALUE SPACES.  
               10 RS-STREET-NAME          PIC X(35)      VALUE SPACES.  
               10 RS-STREET-SUFFIX        PIC X(04)      VALUE SPACES.  
               10 RS-ADDRESS-OVERFLOW     PIC X(35)      VALUE SPACES.  
               10 RS-CITY-STATE           PIC X(26)      VALUE SPACES.  
               10 RS-STATE                PIC X(02)      VALUE SPACES.  
               10 RS-COUNTRY              PIC X(35)      VALUE SPACES.  
               10 RS-ZIP-CODE             PIC X(09)      VALUE SPACES.  
               10 RS-STREET-LOCATION-1    PIC X(4)       VALUE SPACES.  
               10 RS-STREET-LOCATION-2    PIC X(6)       VALUE SPACES.  
               10 RS-ESCHEATMENT-CD       PIC X(1)       VALUE SPACES.  
               10 RS-RETURN-CODE          PIC S9(09) COMP VALUE 0.      
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-REFUND.                                                
               10 S-REFUND-ITEM-ID       PIC S9(9) COMP VALUE +0.       
               10 S-REFUND-CHECK-NO      PIC X(9)       VALUE SPACES.   
               10 S-DEPOSIT-CERT-NO      PIC S9(9) COMP VALUE +0.       
               10 S-REQUEST-DT           PIC X(10)      VALUE SPACES.   
               10 S-CLEARED-DT           PIC X(10)      VALUE SPACES.   
               10 S-DATE-CHECK-VOIDED    PIC X(10)      VALUE SPACES.   
               10 S-STOP-REQUEST-DT      PIC X(10)      VALUE SPACES.   
               10 S-CHECK-REMAIL-DT      PIC X(10)      VALUE SPACES.   
               10 S-REISSUED-DATE        PIC X(10)      VALUE SPACES.   
               10 S-ORIGINAL-CHECK-NO    PIC X(9)       VALUE SPACES.   
               10 S-RETURNED-REASON      PIC X(1)       VALUE SPACES.   
               10 S-USER-ID-APPRVD-BY    PIC X(7)       VALUE SPACES.   
               10 S-USER-ID-RQSTED-BY    PIC X(7)       VALUE SPACES.   
               10 S-RETURNED-DATE        PIC X(10)      VALUE SPACES.   
               10 S-DATE-ESCHEATED       PIC X(10)      VALUE SPACES.   
               10 S-COMMENTS             PIC X(72)      VALUE SPACES.   
               10 S-AMT-REFUNDED         PIC S999999999V99 COMP-3       
                                                         VALUE 0.       
               10 S-MANUAL-INDICATOR     PIC X(1)       VALUE SPACES.   
               10 S-DATE-REFUNDED        PIC X(10)      VALUE SPACES.   
               10 S-CHECK-ISS-REAS-CD    PIC X(2)       VALUE SPACES.   
               10 S-CHECK-STATUS-CD      PIC X(1)       VALUE SPACES.   
               10 S-REFUND-STATUS-DT     PIC X(10)      VALUE SPACES.   
               10 S-DATE-ESCH-VERIFIED   PIC X(10)      VALUE SPACES.   
               10 S-DATE-ESCH-RETURNED   PIC X(10)      VALUE SPACES.   
               10 S-NAME-FORMAT          PIC X(01)      VALUE SPACES.   
               10 S-TITLE-PREFIX         PIC X(09)      VALUE SPACES.   
               10 S-FIRST-NAME           PIC X(15)      VALUE SPACES.   
               10 S-MIDDLE-NAME          PIC X(15)      VALUE SPACES.   
               10 S-LAST-NAME            PIC X(20)      VALUE SPACES.   
               10 S-FULL-NAME            PIC X(50)      VALUE SPACES.   
               10 S-TITLE-SUFFIX-1       PIC X(03)      VALUE SPACES.   
               10 S-TITLE-SUFFIX-2       PIC X(03)      VALUE SPACES.   
               10 S-ADDRESS-FORMAT       PIC X(01)      VALUE SPACES.   
               10 S-HOUSE-NO             PIC X(05)      VALUE SPACES.   
               10 S-ADDR-PREFIX-1        PIC X(03)      VALUE SPACES.   
               10 S-ADDR-PREFIX-2        PIC X(02)      VALUE SPACES.   
               10 S-ADDR-SUFFIX          PIC X(02)      VALUE SPACES.   
               10 S-STREET-NAME          PIC X(35)      VALUE SPACES.   
               10 S-STREET-SUFFIX        PIC X(04)      VALUE SPACES.   
               10 S-ADDRESS-OVERFLOW     PIC X(35)      VALUE SPACES.   
               10 S-CITY-STATE           PIC X(26)      VALUE SPACES.   
               10 S-STATE                PIC X(02)      VALUE SPACES.   
               10 S-COUNTRY              PIC X(35)      VALUE SPACES.   
               10 S-ZIP-CODE             PIC X(09)      VALUE SPACES.   
               10 S-STREET-LOCATION-1    PIC X(4)       VALUE SPACES.   
               10 S-STREET-LOCATION-2    PIC X(6)       VALUE SPACES.   
               10 S-ESCHEATMENT-CD       PIC X(1)       VALUE SPACES.   
               10 S-RETURN-CODE          PIC S9(09) COMP VALUE 0.       
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SQL-STATEMENT.                                         
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
      *                                                                         
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME               PIC X(08) VALUE 'CSR04312'.   
           05  WS-SQLSTATE                PIC X(05) VALUE  SPACES.      
      *                                                                         
       01  SWITCHES.                                                    
           05  ROW-FOUND-SW               PIC X(01) VALUE 'N'.          
               88 ROW-FOUND                         VALUE 'Y'.          
               88 ROW-NOT-FOUND                     VALUE 'N'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-PARM-FIELDS.                                          
               10 WS-ACCOUNT-NO.                                        
                  11 WS-ACCOUNT-NO-N      PIC S9(13)V.                  
COB305         10 WS-ACCOUNT-NO-COMP        PIC S9(13)V COMP-3 VALUE 0.         
           05  WS-EDITS.                                                
               10 WS-DB2-DATE.                                          
                  15 WS-DB2-YYYY          PIC X(04).                    
                  15 FILLER               PIC X.                        
                  15 WS-DB2-MM            PIC X(02).                    
                  15 FILLER               PIC X.                        
                  15 WS-DB2-DD            PIC X(02).                    
               10 WS-PB-DATE.                                           
                  15 WS-PB-MM             PIC X(02).                    
                  15 FILLER               PIC X      VALUE '/'.         
                  15 WS-PB-DD             PIC X(02).                    
                  15 FILLER               PIC X      VALUE '/'.         
                  15 WS-PB-YYYY           PIC X(04).                    
COB305     05 WS-ADDRESS-ID        PIC S9(13)V COMP-3 VALUE 0.          
COB305     05 WS-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.          
           05  WS-ZIP-CODE.                                             
               10 WS-ZIP-CODE-FIVE        PIC X(05).                    
               10 WS-ZIP-CODE-PLUS-FOUR   PIC X(04).                    
      *                                                                         
       01 WS-NULL-INDICATORS.                                           
          05 WS-NULL-DATE-REFUND          PIC S9(04)   COMP.            
          05 WS-NULL-DATE-REQUEST         PIC S9(04)   COMP.            
          05 WS-NULL-DATE-CLEARED         PIC S9(04)   COMP.            
          05 WS-NULL-DATE-CHECK-VOID      PIC S9(04)   COMP.            
          05 WS-NULL-DATE-STOP-REQ        PIC S9(04)   COMP.            
          05 WS-NULL-DATE-CHK-REMAIL      PIC S9(04)   COMP.            
          05 WS-NULL-DATE-REISSUED        PIC S9(04)   COMP.            
          05 WS-NULL-DATE-RETURNED        PIC S9(04)   COMP.            
          05 WS-NULL-DATE-ESCHEATED       PIC S9(04)   COMP.            
          05 WS-NULL-DATE-VERIFIED        PIC S9(04)   COMP.            
          05 WS-NULL-DATE-ESC-RET         PIC S9(04)   COMP.            
          05 WS-NULL-VALUE                PIC S9(04)   COMP VALUE -1.   
      *                                                                         
      ******************************************************************        
      *                         CURSORS                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE REFUNDCURSOR CURSOR FOR                          
                  SELECT REFUND_ITEM_ID,                                
                         REFUND_CHECK_NO,                               
                         DEPOSIT_CERT_NO,                               
                         AMT_REFUNDED,                                  
                         DATE_REFUNDED,                                 
                         REQUEST_DT,                                    
                         CLEARED_DT,                                    
                         DATE_CHECK_VOIDED,                             
                         STOP_REQUEST_DT,                               
                         CHECK_REMAIL_DT,                               
                         CHECK_STATUS_CD,                               
                         CHECK_ISS_REAS_CD,                             
                         REISSUED_DATE,                                 
                         ORIGINAL_CHECK_NO,                             
                         RETURNED_REASON,                               
                         MANUAL_INDICATOR,                              
                         USER_ID_APPRVD_BY,                             
                         REFUND_STATUS_DT,                              
                         USER_ID_RQSTED_BY,                             
                         RETURNED_DATE,                                 
                         DATE_ESCHEATED,                                
                         ADDRESS_ID,                                    
                         ESCHEAT_RETURN_DT,                             
                         ESCHEAT_VERIFY_DT,                             
                         COMMENTS,                                      
                         ESCHEATMENT_CD                                 
                    FROM HST_REFUND                                     
                   WHERE ACCOUNT_NO       =  :WS-ACCOUNT-NO-COMP        
                     AND MANUAL_INDICATOR IN ('C','M','S')              
           END-EXEC.                                                    
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-ACCOUNT-NO             PIC X(13).                       
      *                                                                         
       PROCEDURE DIVISION USING   PARM-ACCOUNT-NO.                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. DECLARE CURSOR FOR RESULT SET                           *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                      REFUND_ITEM_ID                                    
                     ,LTRIM(RTRIM(REFUND_CHECK))        AS REFUND_CHECK        
                     ,DEPOSIT_CERT_NO                                   
                     ,LTRIM(RTRIM(REQUEST_DT))          AS REQUEST_DT          
                     ,LTRIM(RTRIM(CLEARED_DT))          AS CLEARED_DT          
                     ,LTRIM(RTRIM(DATE_CHECK_VOIDED))   AS 
           DATE_CHECK_VOIDED   
                     ,LTRIM(RTRIM(STOP_REQUEST_DT))     AS 
           STOP_REQUEST_DT     
                     ,LTRIM(RTRIM(CHECK_REMAIL_DT))     AS 
           CHECK_REMAIL_DT     
                     ,LTRIM(RTRIM(REISSUED_DATE))       AS REISSUED_DATE       
                     ,LTRIM(RTRIM(ORIGINAL_CHECK_NO))   AS 
           ORIGINAL_CHECK_NO   
                     ,LTRIM(RTRIM(RETURNED_REASON))   AS RETURNED_REASON     
                     ,LTRIM(RTRIM(USER_ID_APPRVD_BY))   AS 
           USER_ID_APPRVD_BY   
                     ,LTRIM(RTRIM(USER_ID_RQSTED_BY))   AS 
           USER_ID_RQSTED_BY   
                     ,LTRIM(RTRIM(RETURNED_DATE))       AS RETURNED_DATE       
                     ,LTRIM(RTRIM(DATE_ESCHEATED))      AS 
           DATE_ESCHEATED      
                     ,LTRIM(RTRIM(COMMENTS))            AS COMMENTS            
                     ,AMT_REFUNDED                                      
                     ,LTRIM(RTRIM(MANUAL_INDICATOR))    AS 
           MANUAL_INDICATOR    
                     ,LTRIM(RTRIM(DATE_REFUNDED))       AS DATE_REFUNDED       
                     ,LTRIM(RTRIM(CHECK_ISS_REAS_CD))   AS 
           CHECK_ISS_REAS_CD   
                     ,LTRIM(RTRIM(CHECK_STATUS_CD))     AS 
           CHECK_STATUS_CD     
                     ,LTRIM(RTRIM(REFUND_STATUS_DT))    AS 
           REFUND_STATUS_DT    
                     ,LTRIM(RTRIM(DATE_ESCH_RETURNED))  AS 
           DATE_ESCH_RETURNED  
                     ,LTRIM(RTRIM(DATE_VERIFIED))       AS DATE_VERIFIED       
                     ,NAME_FORMAT                                       
                     ,LTRIM(RTRIM(TITLE_PREFIX))        AS TITLE_PREFIX        
                     ,LTRIM(RTRIM(FIRST_NAME))          AS FIRST_NAME          
                     ,LTRIM(RTRIM(MIDDLE_NAME))         AS MIDDLE_NAME         
                     ,LTRIM(RTRIM(LAST_NAME))           AS LAST_NAME           
                     ,LTRIM(RTRIM(FULL_NAME))           AS FULL_NAME           
                     ,LTRIM(RTRIM(TITLE_SUFFIX_1))      AS 
           TITLE_SUFFIX_1      
                     ,LTRIM(RTRIM(TITLE_SUFFIX_2))      AS 
           TITLE_SUFFIX_2      
                     ,LTRIM(RTRIM(ADDRESS_FORMAT))      AS 
           ADDRESS_FORMAT      
                     ,LTRIM(RTRIM(HOUSE_NO))            AS HOUSE_NO            
                     ,LTRIM(RTRIM(ADDR_PREFIX_1))       AS ADDR_PREFIX_1       
                     ,LTRIM(RTRIM(ADDR_PREFIX_2))       AS ADDR_PREFIX_2       
                     ,LTRIM(RTRIM(ADDR_SUFFIX))         AS ADDR_SUFFIX         
                     ,LTRIM(RTRIM(STREET_NAME))         AS STREET_NAME         
                     ,LTRIM(RTRIM(STREET_SUFFIX))       AS STREET_SUFFIX       
                     ,LTRIM(RTRIM(ADDRESS_OVERFLOW))    AS 
           ADDRESS_OVERFLOW    
                     ,LTRIM(RTRIM(CITY_STATE))          AS CITY_STATE          
                     ,LTRIM(RTRIM(STATE))               AS STATE               
                     ,LTRIM(RTRIM(COUNTRY))             AS COUNTRY             
                     ,LTRIM(RTRIM(ZIP_CODE))            AS ZIP_CODE            
                     ,LTRIM(RTRIM(STREET_LOCATION_1))   AS 
           STREET_LOCATION_1   
                     ,LTRIM(RTRIM(STREET_LOCATION_2))   AS 
           STREET_LOCATION_2   
                     ,RETURN_CODE                                       
                     ,ESCHEATMENT_CD                                    
                FROM                                                    
                    #CSR04312_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               REFUND_ITEM_ID                                            
MFA-TR*              ,STRIP(REFUND_CHECK)        AS REFUND_CHECK                
MFA-TR*              ,DEPOSIT_CERT_NO                                           
MFA-TR*              ,STRIP(REQUEST_DT)          AS REQUEST_DT                  
MFA-TR*              ,STRIP(CLEARED_DT)          AS CLEARED_DT                  
MFA-TR*              ,STRIP(DATE_CHECK_VOIDED)   AS DATE_CHECK_VOIDED           
MFA-TR*              ,STRIP(STOP_REQUEST_DT)     AS STOP_REQUEST_DT             
MFA-TR*              ,STRIP(CHECK_REMAIL_DT)     AS CHECK_REMAIL_DT             
MFA-TR*              ,STRIP(REISSUED_DATE)       AS REISSUED_DATE               
MFA-TR*              ,STRIP(ORIGINAL_CHECK_NO)   AS ORIGINAL_CHECK_NO           
MFA-TR*              ,STRIP(RETURNED_REASON  )   AS RETURNED_REASON             
MFA-TR*              ,STRIP(USER_ID_APPRVD_BY)   AS USER_ID_APPRVD_BY           
MFA-TR*              ,STRIP(USER_ID_RQSTED_BY)   AS USER_ID_RQSTED_BY           
MFA-TR*              ,STRIP(RETURNED_DATE)       AS RETURNED_DATE               
MFA-TR*              ,STRIP(DATE_ESCHEATED)      AS DATE_ESCHEATED              
MFA-TR*              ,STRIP(COMMENTS)            AS COMMENTS                    
MFA-TR*              ,AMT_REFUNDED                                              
MFA-TR*              ,STRIP(MANUAL_INDICATOR)    AS MANUAL_INDICATOR            
MFA-TR*              ,STRIP(DATE_REFUNDED)       AS DATE_REFUNDED               
MFA-TR*              ,STRIP(CHECK_ISS_REAS_CD)   AS CHECK_ISS_REAS_CD           
MFA-TR*              ,STRIP(CHECK_STATUS_CD)     AS CHECK_STATUS_CD             
MFA-TR*              ,STRIP(REFUND_STATUS_DT)    AS REFUND_STATUS_DT            
MFA-TR*              ,STRIP(DATE_ESCH_RETURNED)  AS DATE_ESCH_RETURNED          
MFA-TR*              ,STRIP(DATE_VERIFIED)       AS DATE_VERIFIED               
MFA-TR*              ,NAME_FORMAT                                               
MFA-TR*              ,STRIP(TITLE_PREFIX)        AS TITLE_PREFIX                
MFA-TR*              ,STRIP(FIRST_NAME)          AS FIRST_NAME                  
MFA-TR*              ,STRIP(MIDDLE_NAME)         AS MIDDLE_NAME                 
MFA-TR*              ,STRIP(LAST_NAME)           AS LAST_NAME                   
MFA-TR*              ,STRIP(FULL_NAME)           AS FULL_NAME                   
MFA-TR*              ,STRIP(TITLE_SUFFIX_1)      AS TITLE_SUFFIX_1              
MFA-TR*              ,STRIP(TITLE_SUFFIX_2)      AS TITLE_SUFFIX_2              
MFA-TR*              ,STRIP(ADDRESS_FORMAT)      AS ADDRESS_FORMAT              
MFA-TR*              ,STRIP(HOUSE_NO)            AS HOUSE_NO                    
MFA-TR*              ,STRIP(ADDR_PREFIX_1)       AS ADDR_PREFIX_1               
MFA-TR*              ,STRIP(ADDR_PREFIX_2)       AS ADDR_PREFIX_2               
MFA-TR*              ,STRIP(ADDR_SUFFIX)         AS ADDR_SUFFIX                 
MFA-TR*              ,STRIP(STREET_NAME)         AS STREET_NAME                 
MFA-TR*              ,STRIP(STREET_SUFFIX)       AS STREET_SUFFIX               
MFA-TR*              ,STRIP(ADDRESS_OVERFLOW)    AS ADDRESS_OVERFLOW            
MFA-TR*              ,STRIP(CITY_STATE)          AS CITY_STATE                  
MFA-TR*              ,STRIP(STATE)               AS STATE                       
MFA-TR*              ,STRIP(COUNTRY)             AS COUNTRY                     
MFA-TR*              ,STRIP(ZIP_CODE)            AS ZIP_CODE                    
MFA-TR*              ,STRIP(STREET_LOCATION_1)   AS STREET_LOCATION_1           
MFA-TR*              ,STRIP(STREET_LOCATION_2)   AS STREET_LOCATION_2           
MFA-TR*              ,RETURN_CODE                                               
MFA-TR*              ,ESCHEATMENT_CD                                            
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04312_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02530000
      * 0100A-DECLARE-GTT.                                             *02540000
      ******************************************************************02890000
       0100A-DECLARE-GTT.                                               
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04312_R1'            
                                       TO S-SQL-STATEMENT-V.            
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04312_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04312_R1
              (                                                       
                   REFUND_ITEM_ID           INT                     
                  ,REFUND_CHECK CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,DEPOSIT_CERT_NO          INT                     
                  ,REQUEST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CLEARED_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,DATE_CHECK_VOIDED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,STOP_REQUEST_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,CHECK_REMAIL_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,REISSUED_DATE CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ORIGINAL_CHECK_NO CHAR(9)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,RETURNED_REASON CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,USER_ID_APPRVD_BY CHAR(7)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,USER_ID_RQSTED_BY CHAR(7)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,RETURNED_DATE CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_ESCHEATED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,COMMENTS CHAR(72)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,AMT_REFUNDED             DECIMAL(11,2)               
                  ,MANUAL_INDICATOR CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,DATE_REFUNDED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,CHECK_ISS_REAS_CD CHAR(2)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,CHECK_STATUS_CD CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,REFUND_STATUS_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_ESCH_RETURNED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,DATE_VERIFIED CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,TITLE_PREFIX CHAR(09)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,LAST_NAME CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,FULL_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,TITLE_SUFFIX_1 CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,TITLE_SUFFIX_2 CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDRESS_FORMAT CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,HOUSE_NO CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,ADDR_PREFIX_1 CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDR_PREFIX_2 CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,STREET_NAME CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,STREET_SUFFIX CHAR(04)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,CITY_STATE CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2              
                  ,COUNTRY CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,ZIP_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,STREET_LOCATION_1 CHAR(4)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,STREET_LOCATION_2 CHAR(6)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,RETURN_CODE              INT                     
                  ,ESCHEATMENT_CD CHAR(1)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-SQLSTATE = '42710'                                     
                  PERFORM 8000A-DELETE-GTT-ROWS                         
                                             THRU 8000A-EXIT            
           ELSE                                                         
                  IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
                     NEXT SENTENCE                                      
                  ELSE                                                  
                     MOVE PROGRAM-NAME       TO ABEND-PROGRAM           
                     MOVE SQLCODE            TO ABEND-SQLCODE           
                     MOVE SQLSTATE           TO ABEND-SQLSTATE          
                     MOVE '0100A'            TO ACTIVE-PARAGRAPH        
                     MOVE 'DECLARE GTT'      TO ABEND-FUNCTION          
                     MOVE SPACES             TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                     MOVE 'CSR04312_R1'      TO TABLE-1                 
                     MOVE SPACES             TO TABLE-ELEMENT-1         
                     MOVE SPACES             TO HOSTVAR-ELEMENT-1       
                     PERFORM 9900-SQL-ERROR-ROUTINE                     
                                                    THRU  9900-EXIT     
                  END-IF                                                
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     ASSIGNS INPUT PARMS TO WS VARIABLES.                       *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO.         
           MOVE WS-ACCOUNT-NO-N               TO WS-ACCOUNT-NO-COMP.    
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     MAIN BUSINESS LOGIC PROCESS                                *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7000-OPEN-REFUND-CURSOR       THRU 7000-EXIT.        
           PERFORM 5000-FETCH-REFUNDS            THRU 5000-EXIT         
                         UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.       
           PERFORM 7200-CLOSE-REFUND-CURSOR      THRU 7200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03570000
      * 2000A-MOVE-RESULT.                                             *03500000
      ******************************************************************03570000
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE   RS-REFUND-ITEM-ID     TO S-REFUND-ITEM-ID.            
           MOVE   RS-REFUND-CHECK-NO    TO S-REFUND-CHECK-NO.           
           MOVE   RS-DEPOSIT-CERT-NO    TO S-DEPOSIT-CERT-NO.           
           MOVE   RS-REQUEST-DT         TO S-REQUEST-DT.                
           MOVE   RS-CLEARED-DT         TO S-CLEARED-DT.                
           MOVE   RS-DATE-CHECK-VOIDED  TO S-DATE-CHECK-VOIDED.         
           MOVE   RS-STOP-REQUEST-DT    TO S-STOP-REQUEST-DT.           
           MOVE   RS-CHECK-REMAIL-DT    TO S-CHECK-REMAIL-DT.           
           MOVE   RS-REISSUED-DATE      TO S-REISSUED-DATE.             
           MOVE   RS-ORIGINAL-CHECK-NO  TO S-ORIGINAL-CHECK-NO.         
           MOVE   RS-RETURNED-REASON    TO S-RETURNED-REASON.           
           MOVE   RS-USER-ID-APPRVD-BY  TO S-USER-ID-APPRVD-BY.         
           MOVE   RS-USER-ID-RQSTED-BY  TO S-USER-ID-RQSTED-BY.         
           MOVE   RS-RETURNED-DATE      TO S-RETURNED-DATE.             
           MOVE   RS-DATE-ESCHEATED     TO S-DATE-ESCHEATED.            
           MOVE   RS-COMMENTS           TO S-COMMENTS.                  
           MOVE   RS-AMT-REFUNDED       TO S-AMT-REFUNDED.              
           MOVE   RS-MANUAL-INDICATOR   TO S-MANUAL-INDICATOR.          
           MOVE   RS-DATE-REFUNDED      TO S-DATE-REFUNDED.             
           MOVE   RS-CHECK-ISS-REAS-CD  TO S-CHECK-ISS-REAS-CD.         
           MOVE   RS-CHECK-STATUS-CD    TO S-CHECK-STATUS-CD.           
           MOVE   RS-REFUND-STATUS-DT   TO S-REFUND-STATUS-DT.          
           MOVE   RS-DATE-ESCH-VERIFIED TO S-DATE-ESCH-VERIFIED.        
           MOVE   RS-DATE-ESCH-RETURNED TO S-DATE-ESCH-RETURNED.        
           MOVE   RS-NAME-FORMAT        TO S-NAME-FORMAT.               
           MOVE   RS-TITLE-PREFIX       TO S-TITLE-PREFIX.              
           MOVE   RS-FIRST-NAME         TO S-FIRST-NAME.                
           MOVE   RS-MIDDLE-NAME        TO S-MIDDLE-NAME.               
           MOVE   RS-LAST-NAME          TO S-LAST-NAME.                 
           MOVE   RS-FULL-NAME          TO S-FULL-NAME.                 
           MOVE   RS-TITLE-SUFFIX-1     TO S-TITLE-SUFFIX-1.            
           MOVE   RS-TITLE-SUFFIX-2     TO S-TITLE-SUFFIX-2.            
           MOVE   RS-ADDRESS-FORMAT     TO S-ADDRESS-FORMAT.            
           MOVE   RS-HOUSE-NO           TO S-HOUSE-NO.                  
           MOVE   RS-ADDR-PREFIX-1      TO S-ADDR-PREFIX-1.             
           MOVE   RS-ADDR-PREFIX-2      TO S-ADDR-PREFIX-2.             
           MOVE   RS-ADDR-SUFFIX        TO S-ADDR-SUFFIX.               
           MOVE   RS-STREET-NAME        TO S-STREET-NAME.               
           MOVE   RS-STREET-SUFFIX      TO S-STREET-SUFFIX.             
           MOVE   RS-ADDRESS-OVERFLOW   TO S-ADDRESS-OVERFLOW.          
           MOVE   RS-CITY-STATE         TO S-CITY-STATE.                
           MOVE   RS-STATE              TO S-STATE.                     
           MOVE   RS-COUNTRY            TO S-COUNTRY.                   
           MOVE   RS-ZIP-CODE           TO S-ZIP-CODE.                  
           MOVE   RS-STREET-LOCATION-1  TO S-STREET-LOCATION-1.         
           MOVE   RS-STREET-LOCATION-2  TO S-STREET-LOCATION-2.         
           MOVE   RS-RETURN-CODE        TO S-RETURN-CODE.               
           MOVE   RS-ESCHEATMENT-CD     TO S-ESCHEATMENT-CD.            
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5000-FETCH-REFUNDS.                                            *        
      *          CHECKS FOR NULL VALUES IN DATES AND LOADS             *        
      *          THE FIELDS APPROPRIATLY.  IT ALSO FINDS AN ADDRESS.   *        
      ******************************************************************        
      *                                                                         
       5000-FETCH-REFUNDS.                                              
      *                                                                         
           MOVE '5000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 7100-FETCH-REFUND-CURSOR      THRU 7100-EXIT         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-DATE-REFUND      = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-DATE-REFUNDED         
              ELSE                                                      
                 MOVE RS-DATE-REFUNDED      TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-DATE-REFUNDED         
              END-IF                                                    
              IF WS-NULL-DATE-REQUEST     = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-REQUEST-DT            
              ELSE                                                      
                 MOVE RS-REQUEST-DT         TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-REQUEST-DT            
              END-IF                                                    
              IF WS-NULL-DATE-CLEARED     = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-CLEARED-DT            
              ELSE                                                      
                 MOVE RS-CLEARED-DT         TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-CLEARED-DT            
              END-IF                                                    
              IF WS-NULL-DATE-CHECK-VOID  = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-DATE-CHECK-VOIDED     
              ELSE                                                      
                 MOVE RS-DATE-CHECK-VOIDED  TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-DATE-CHECK-VOIDED     
              END-IF                                                    
              IF WS-NULL-DATE-STOP-REQ    = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-STOP-REQUEST-DT       
              ELSE                                                      
                 MOVE RS-STOP-REQUEST-DT    TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-STOP-REQUEST-DT       
              END-IF                                                    
              IF WS-NULL-DATE-CHK-REMAIL  = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-CHECK-REMAIL-DT       
              ELSE                                                      
                 MOVE RS-CHECK-REMAIL-DT    TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-CHECK-REMAIL-DT       
              END-IF                                                    
              IF WS-NULL-DATE-REISSUED    = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-REISSUED-DATE         
              ELSE                                                      
                 MOVE RS-REISSUED-DATE      TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-REISSUED-DATE         
              END-IF                                                    
              IF WS-NULL-DATE-RETURNED    = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-RETURNED-DATE         
              ELSE                                                      
                 MOVE RS-RETURNED-DATE      TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-RETURNED-DATE         
              END-IF                                                    
              IF WS-NULL-DATE-ESCHEATED   = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-DATE-ESCHEATED        
              ELSE                                                      
                 MOVE RS-DATE-ESCHEATED     TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-DATE-ESCHEATED        
              END-IF                                                    
              IF WS-NULL-DATE-VERIFIED    = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-DATE-ESCH-VERIFIED    
              ELSE                                                      
                 MOVE RS-DATE-ESCH-VERIFIED TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-DATE-ESCH-VERIFIED    
              END-IF                                                    
              IF WS-NULL-DATE-ESC-RET     = WS-NULL-VALUE               
                 MOVE SPACES                TO RS-DATE-ESCH-RETURNED    
              ELSE                                                      
                 MOVE RS-DATE-ESCH-RETURNED TO WS-DB2-DATE              
                 PERFORM 5100-CHANGE-DATE THRU 5100-EXIT                
                 MOVE WS-PB-DATE            TO RS-DATE-ESCH-RETURNED    
              END-IF                                                    
              IF RS-ESCHEATMENT-CD = LOW-VALUES OR HIGH-VALUES          
                 MOVE SPACES                TO RS-ESCHEATMENT-CD        
              END-IF                                                    
              MOVE RS-REFUND-STATUS-DT      TO WS-DB2-DATE              
              PERFORM 5100-CHANGE-DATE    THRU 5100-EXIT                
              MOVE WS-PB-DATE               TO RS-REFUND-STATUS-DT      
              MOVE SPACES                   TO WS-ZIP-CODE              
      *                                                                         
              PERFORM 7500-NAME           THRU 7500-EXIT                
      *                                                                         
              IF WS-ADDRESS-ID > 0                                      
                 PERFORM 7300-FREEFORM-ADDRESS                          
                                          THRU 7300-EXIT                
                 MOVE 'B'                   TO RS-ADDRESS-FORMAT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    PERFORM 7400-FORMATTED-ADDRESS                      
                                          THRU 7400-EXIT                
                    MOVE WS-ZIP-CODE        TO RS-ZIP-CODE              
                    MOVE 'A'                TO RS-ADDRESS-FORMAT        
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 5200-FIND-ADDRESS                              
                                          THRU 5200-EXIT                
              END-IF                                                    
              PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT
           END-IF.               
           IF ROW-NOT-FOUND                                             
              INITIALIZE RS-REFUND                                      
              PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
              MOVE NOT-FOUND              TO WS-ACTIVE-RETURN-CODE      
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-CHANGE-DATE.                                              *        
      *       CHANGES THE DATES FROM DB2 FORMAT TO POWERBUILDER FORMAT.*        
      ******************************************************************        
      *                                                                         
       5100-CHANGE-DATE.                                                
      *                                                                         
           MOVE '5100'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE WS-DB2-YYYY               TO WS-PB-YYYY.                
           MOVE WS-DB2-MM                 TO WS-PB-MM.                  
           MOVE WS-DB2-DD                 TO WS-PB-DD.                  
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-FIND-ADDRESS.                                             *        
      *    DETERMINES IF BILLING ADDRESS OR SERVICE                    *        
      *           IS RETURNED TO POWERBUILDER.                         *        
      ******************************************************************        
      *                                                                         
       5200-FIND-ADDRESS.                                               
      *                                                                         
           PERFORM 7600-ACCOUNT-INFO      THRU 7600-EXIT                
           IF WS-ADDRESS-ID = 0                                         
              PERFORM 7700-PREMISE-INFO   THRU 7700-EXIT                
           END-IF.                                                      
           IF RS-ADDRESS-FORMAT = 'A'                                   
              PERFORM 7400-FORMATTED-ADDRESS                            
                                          THRU 7400-EXIT                
              MOVE WS-ZIP-CODE            TO RS-ZIP-CODE                
           ELSE                                                         
              PERFORM 7300-FREEFORM-ADDRESS                             
                                          THRU 7300-EXIT
           END-IF.               
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000- OPEN REFUND CURSOR                                       *        
      *        OPENS THE REFUND CURSOR                                 *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-REFUND-CURSOR.                                         
      *                                                                         
           MOVE '7000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
               OPEN REFUNDCURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'HST_REFUND'          TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-REFUND-CURSOR                                       *        
      *       FETCHES THE REFUND CURSOR                                *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-REFUND-CURSOR.                                        
      *                                                                         
           MOVE '7100'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
               FETCH REFUNDCURSOR                                       
                INTO :RS-REFUND-ITEM-ID,                                
                     :RS-REFUND-CHECK-NO,                               
                     :RS-DEPOSIT-CERT-NO,                               
                     :RS-AMT-REFUNDED,                                  
                     :RS-DATE-REFUNDED :WS-NULL-DATE-REFUND,             
                     :RS-REQUEST-DT :WS-NULL-DATE-REQUEST,               
                     :RS-CLEARED-DT :WS-NULL-DATE-CLEARED,               
                     :RS-DATE-CHECK-VOIDED :WS-NULL-DATE-CHECK-VOID,     
                     :RS-STOP-REQUEST-DT :WS-NULL-DATE-STOP-REQ,         
                     :RS-CHECK-REMAIL-DT :WS-NULL-DATE-CHK-REMAIL,       
                     :RS-CHECK-STATUS-CD,                               
                     :RS-CHECK-ISS-REAS-CD,                             
                     :RS-REISSUED-DATE :WS-NULL-DATE-REISSUED,           
                     :RS-ORIGINAL-CHECK-NO,                             
                     :RS-RETURNED-REASON,                               
                     :RS-MANUAL-INDICATOR,                              
                     :RS-USER-ID-APPRVD-BY,                             
                     :RS-REFUND-STATUS-DT,                              
                     :RS-USER-ID-RQSTED-BY,                             
                     :RS-RETURNED-DATE :WS-NULL-DATE-RETURNED,           
                     :RS-DATE-ESCHEATED :WS-NULL-DATE-ESCHEATED,         
                     :WS-ADDRESS-ID,                                    
                     :RS-DATE-ESCH-VERIFIED :WS-NULL-DATE-VERIFIED,      
                     :RS-DATE-ESCH-RETURNED :WS-NULL-DATE-ESC-RET,       
                     :RS-COMMENTS,                                      
                     :RS-ESCHEATMENT-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET ROW-FOUND TO TRUE                                     
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                NEXT SENTENCE                                           
             ELSE                                                       
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7100'                TO ACTIVE-PARAGRAPH         
                 MOVE 'FETCH'               TO ABEND-FUNCTION           
                 MOVE 'HST_REFUND'          TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT   
                 PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT   
           END-IF
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-REFUND-CURSOR                                       *        
      *       CLOSES THE REFUND CURSOR                                 *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-REFUND-CURSOR.                                        
      *                                                                         
           MOVE '7200'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
               CLOSE REFUNDCURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'HST_REFUND'          TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-FREEFORM-ADDRESS                                          *        
      *       RETRIEVES THE FREEFORM ADDRESS.                          *        
      ******************************************************************        
      *                                                                         
       7300-FREEFORM-ADDRESS.                                           
      *                                                                         
           MOVE '7300'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT  ADDR_CITY_STATE,                                  
                      ADDR_STREET,        ADDRESS_OVERFLOW,             
                      ADDR_COUNTRY,       ADDR_ZIP_CODE                 
                INTO :RS-CITY-STATE,                                    
                     :RS-STREET-NAME,     :RS-ADDRESS-OVERFLOW,         
                     :RS-COUNTRY,         :RS-ZIP-CODE                  
                FROM CSS_ADDR_FREEFORM                                  
               WHERE ADDRESS_ID = :WS-ADDRESS-ID                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                               OR NOT-FOUND                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7300'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                    
               MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1            
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
               MOVE WS-ADDRESS-ID         TO HOSTVAR-ELEMENT-1          
               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-FORMATTED-ADDRESS                                         *        
      *       RETRIEVES THE FORMATTED ADDRESS.                         *        
      ******************************************************************        
      *                                                                         
       7400-FORMATTED-ADDRESS.                                          
      *                                                                         
           MOVE '7400'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT  A.ADDR_PREFIX_1,      A.STREET_SUFFIX,            
                      A.ADDR_PREFIX_2,      A.HOUSE_NO,                 
                      A.STREET_NAME,        A.ADDR_SUFFIX,              
                      A.STREET_LOCATION_1,  A.STREET_LOCATION_2,        
                      A.ADDRESS_OVERFLOW,                               
                      A.ZIP_CODE,           A.ZIP_CODE_PLUS_FOUR,       
                      B.TOWN,               B.STATE                     
                INTO :RS-ADDR-PREFIX-1,    :RS-STREET-SUFFIX,           
                     :RS-ADDR-PREFIX-2,    :RS-HOUSE-NO,                
                     :RS-STREET-NAME,      :RS-ADDR-SUFFIX,             
                     :RS-STREET-LOCATION-1,                             
                     :RS-STREET-LOCATION-2,                             
                     :RS-ADDRESS-OVERFLOW,                              
                     :WS-ZIP-CODE-FIVE,    :WS-ZIP-CODE-PLUS-FOUR,      
                     :RS-CITY-STATE,       :RS-STATE                    
                FROM CSS_ADDR_FORMATTED A,                              
                     CSS_ZIP_CODE       B                               
               WHERE A.ADDRESS_ID     = :WS-ADDRESS-ID                  
                 AND B.ZIP_CODE       = A.ZIP_CODE                      
                 AND B.ZIP_CODE_TOKEN = A.ZIP_CODE_TOKEN                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7400'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                    
               MOVE 'CSS_ZIP_CODE'        TO TABLE-2                    
               MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1            
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
               MOVE WS-ADDRESS-ID         TO HOSTVAR-ELEMENT-1          
               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-NAME                                                      *        
      *      RETRIEVES THE CUSTOMER NAME.                              *        
      ******************************************************************        
      *                                                                         
       7500-NAME.                                                       
      *                                                                         
           MOVE '7500'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT A.NAME_FORMAT,        A.TITLE_PREFIX,              
                     A.FIRST_NAME,         A.MIDDLE_NAME,               
                     A.LAST_NAME,          A.TITLE_SUFFIX_1,            
                     A.TITLE_SUFFIX_2,     A.FULL_NAME                  
                INTO :RS-NAME-FORMAT,      :RS-TITLE-PREFIX,            
                     :RS-FIRST-NAME,       :RS-MIDDLE-NAME,             
                     :RS-LAST-NAME,        :RS-TITLE-SUFFIX-1,          
                     :RS-TITLE-SUFFIX-2,   :RS-FULL-NAME                
                FROM CSS_NAME           A,                              
                     CSS_NAME_ACCT_XREF B                               
               WHERE B.ACCOUNT_NO = :WS-ACCOUNT-NO-COMP                 
                 AND B.NAME_ID    = A.NAME_ID                           
                 AND A.NAME_TYPE  = 'CN'                                
                 AND B.CUSTOMER_ROLE_CD = ' '                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7500'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE 'CSS_NAME          '  TO TABLE-1                    
               MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-2                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-ACCOUNT-INFO.                                             *        
      *    RETRIEVES ACCOUNT INFO TO USE IN  RETRIEVING ADDRESS INFO.  *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7600-ACCOUNT-INFO.                                               
      *                                                                         
           MOVE '7600'                    TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               SELECT  ADDRESS_ID,                                      
                       ADDRESS_FORMAT,                                  
                       PREMISE_NO                                       
                 INTO :WS-ADDRESS-ID,                                   
                      :RS-ADDRESS-FORMAT,                               
                      :WS-PREMISE-NO                                    
                 FROM HST_ACCOUNT                                       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-COMP                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7600'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE 'HST_ACCOUNT       '  TO TABLE-1                    
               MOVE 'ACCOUNT_NO        '  TO TABLE-ELEMENT-1            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-PREMISE-INFO.                                             *        
      *    RETRIEVES PREMISE INFO TO USE IN RETRIEVING ADDRESS INFO.   *        
      ******************************************************************        
      *                                                                         
       7700-PREMISE-INFO.                                               
      *                                                                         
           MOVE '7700'                    TO ACTIVE-PARAGRAPH.          
           EXEC SQL                                                     
              SELECT  ADDRESS_ID,                                       
                      ADDRESS_FORMAT                                    
                INTO :WS-ADDRESS-ID,                                    
                     :RS-ADDRESS-FORMAT                                 
                FROM CSS_PREMISE                                        
               WHERE PREMISE_NO = :WS-PREMISE-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT            '  TO ABEND-FUNCTION             
               MOVE 'CSS_PREMISE       '  TO TABLE-1                    
               MOVE 'PREMISE_NO        '  TO TABLE-ELEMENT-1            
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2            
               MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1          
               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  12310000
      * 8000A-DELETE-GTT-ROWS.                                       *  12320000
      ****************************************************************  12330000
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
                DELETE FROM #CSR04312_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04312_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE '8000A'               TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                                 ABEND-TABLES           
               MOVE 'CSR04312_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ****************************************************************  12310000
      * 8100-SEND-RESULT.                                            *  12320000
      ****************************************************************  12330000
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04312_R1                         
                (                                                       
                      REFUND_ITEM_ID                                    
                     ,REFUND_CHECK                                      
                     ,DEPOSIT_CERT_NO                                   
                     ,REQUEST_DT                                        
                     ,CLEARED_DT                                        
                     ,DATE_CHECK_VOIDED                                 
                     ,STOP_REQUEST_DT                                   
                     ,CHECK_REMAIL_DT                                   
                     ,REISSUED_DATE                                     
                     ,ORIGINAL_CHECK_NO                                 
                     ,RETURNED_REASON                                   
                     ,USER_ID_APPRVD_BY                                 
                     ,USER_ID_RQSTED_BY                                 
                     ,RETURNED_DATE                                     
                     ,DATE_ESCHEATED                                    
                     ,COMMENTS                                          
                     ,AMT_REFUNDED                                      
                     ,MANUAL_INDICATOR                                  
                     ,DATE_REFUNDED                                     
                     ,CHECK_ISS_REAS_CD                                 
                     ,CHECK_STATUS_CD                                   
                     ,REFUND_STATUS_DT                                  
                     ,DATE_ESCH_RETURNED                                
                     ,DATE_VERIFIED                                     
                     ,NAME_FORMAT                                       
                     ,TITLE_PREFIX                                      
                     ,FIRST_NAME                                        
                     ,MIDDLE_NAME                                       
                     ,LAST_NAME                                         
                     ,FULL_NAME                                         
                     ,TITLE_SUFFIX_1                                    
                     ,TITLE_SUFFIX_2                                    
                     ,ADDRESS_FORMAT                                    
                     ,HOUSE_NO                                          
                     ,ADDR_PREFIX_1                                     
                     ,ADDR_PREFIX_2                                     
                     ,ADDR_SUFFIX                                       
                     ,STREET_NAME                                       
                     ,STREET_SUFFIX                                     
                     ,ADDRESS_OVERFLOW                                  
                     ,CITY_STATE                                        
                     ,STATE                                             
                     ,COUNTRY                                           
                     ,ZIP_CODE                                          
                     ,STREET_LOCATION_1                                 
                     ,STREET_LOCATION_2                                 
                     ,RETURN_CODE                                       
                     ,ESCHEATMENT_CD                                    
                )                                                       
                VALUES                                                  
                (                                                       
                      :S-REFUND-ITEM-ID                                 
                     ,:S-REFUND-CHECK-NO                                
                     ,:S-DEPOSIT-CERT-NO                                
                     ,:S-REQUEST-DT                                     
                     ,:S-CLEARED-DT                                     
                     ,:S-DATE-CHECK-VOIDED                              
                     ,:S-STOP-REQUEST-DT                                
                     ,:S-CHECK-REMAIL-DT                                
                     ,:S-REISSUED-DATE                                  
                     ,:S-ORIGINAL-CHECK-NO                              
                     ,:S-RETURNED-REASON                                
                     ,:S-USER-ID-APPRVD-BY                              
                     ,:S-USER-ID-RQSTED-BY                              
                     ,:S-RETURNED-DATE                                  
                     ,:S-DATE-ESCHEATED                                 
                     ,:S-COMMENTS                                       
                     ,:S-AMT-REFUNDED                                   
                     ,:S-MANUAL-INDICATOR                               
                     ,:S-DATE-REFUNDED                                  
                     ,:S-CHECK-ISS-REAS-CD                              
                     ,:S-CHECK-STATUS-CD                                
                     ,:S-REFUND-STATUS-DT                               
                     ,:S-DATE-ESCH-RETURNED                             
                     ,:S-DATE-ESCH-VERIFIED                             
                     ,:S-NAME-FORMAT                                    
                     ,:S-TITLE-PREFIX                                   
                     ,:S-FIRST-NAME                                     
                     ,:S-MIDDLE-NAME                                    
                     ,:S-LAST-NAME                                      
                     ,:S-FULL-NAME                                      
                     ,:S-TITLE-SUFFIX-1                                 
                     ,:S-TITLE-SUFFIX-2                                 
                     ,:S-ADDRESS-FORMAT                                 
                     ,:S-HOUSE-NO                                       
                     ,:S-ADDR-PREFIX-1                                  
                     ,:S-ADDR-PREFIX-2                                  
                     ,:S-ADDR-SUFFIX                                    
                     ,:S-STREET-NAME                                    
                     ,:S-STREET-SUFFIX                                  
                     ,:S-ADDRESS-OVERFLOW                               
                     ,:S-CITY-STATE                                     
                     ,:S-STATE                                          
                     ,:S-COUNTRY                                        
                     ,:S-ZIP-CODE                                       
                     ,:S-STREET-LOCATION-1                              
                     ,:S-STREET-LOCATION-2                              
                     ,:S-RETURN-CODE                                    
                     ,:S-ESCHEATMENT-CD                                 
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04312_R1                                 
MFA-TR*         (                                                               
MFA-TR*               REFUND_ITEM_ID                                    01670000
MFA-TR*              ,REFUND_CHECK                                              
MFA-TR*              ,DEPOSIT_CERT_NO                                           
MFA-TR*              ,REQUEST_DT                                                
MFA-TR*              ,CLEARED_DT                                                
MFA-TR*              ,DATE_CHECK_VOIDED                                         
MFA-TR*              ,STOP_REQUEST_DT                                           
MFA-TR*              ,CHECK_REMAIL_DT                                           
MFA-TR*              ,REISSUED_DATE                                             
MFA-TR*              ,ORIGINAL_CHECK_NO                                         
MFA-TR*              ,RETURNED_REASON                                           
MFA-TR*              ,USER_ID_APPRVD_BY                                         
MFA-TR*              ,USER_ID_RQSTED_BY                                         
MFA-TR*              ,RETURNED_DATE                                             
MFA-TR*              ,DATE_ESCHEATED                                            
MFA-TR*              ,COMMENTS                                                  
MFA-TR*              ,AMT_REFUNDED                                              
MFA-TR*              ,MANUAL_INDICATOR                                          
MFA-TR*              ,DATE_REFUNDED                                             
MFA-TR*              ,CHECK_ISS_REAS_CD                                         
MFA-TR*              ,CHECK_STATUS_CD                                           
MFA-TR*              ,REFUND_STATUS_DT                                          
MFA-TR*              ,DATE_ESCH_RETURNED                                        
MFA-TR*              ,DATE_VERIFIED                                             
MFA-TR*              ,NAME_FORMAT                                               
MFA-TR*              ,TITLE_PREFIX                                              
MFA-TR*              ,FIRST_NAME                                                
MFA-TR*              ,MIDDLE_NAME                                               
MFA-TR*              ,LAST_NAME                                                 
MFA-TR*              ,FULL_NAME                                                 
MFA-TR*              ,TITLE_SUFFIX_1                                            
MFA-TR*              ,TITLE_SUFFIX_2                                            
MFA-TR*              ,ADDRESS_FORMAT                                            
MFA-TR*              ,HOUSE_NO                                                  
MFA-TR*              ,ADDR_PREFIX_1                                             
MFA-TR*              ,ADDR_PREFIX_2                                             
MFA-TR*              ,ADDR_SUFFIX                                               
MFA-TR*              ,STREET_NAME                                               
MFA-TR*              ,STREET_SUFFIX                                             
MFA-TR*              ,ADDRESS_OVERFLOW                                          
MFA-TR*              ,CITY_STATE                                                
MFA-TR*              ,STATE                                                     
MFA-TR*              ,COUNTRY                                                   
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,STREET_LOCATION_1                                         
MFA-TR*              ,STREET_LOCATION_2                                         
MFA-TR*              ,RETURN_CODE                                               
MFA-TR*              ,ESCHEATMENT_CD                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-REFUND-ITEM-ID                                 01670000
MFA-TR*              ,:S-REFUND-CHECK-NO                                        
MFA-TR*              ,:S-DEPOSIT-CERT-NO                                        
MFA-TR*              ,:S-REQUEST-DT                                             
MFA-TR*              ,:S-CLEARED-DT                                             
MFA-TR*              ,:S-DATE-CHECK-VOIDED                                      
MFA-TR*              ,:S-STOP-REQUEST-DT                                        
MFA-TR*              ,:S-CHECK-REMAIL-DT                                        
MFA-TR*              ,:S-REISSUED-DATE                                          
MFA-TR*              ,:S-ORIGINAL-CHECK-NO                                      
MFA-TR*              ,:S-RETURNED-REASON                                        
MFA-TR*              ,:S-USER-ID-APPRVD-BY                                      
MFA-TR*              ,:S-USER-ID-RQSTED-BY                                      
MFA-TR*              ,:S-RETURNED-DATE                                          
MFA-TR*              ,:S-DATE-ESCHEATED                                         
MFA-TR*              ,:S-COMMENTS                                               
MFA-TR*              ,:S-AMT-REFUNDED                                           
MFA-TR*              ,:S-MANUAL-INDICATOR                                       
MFA-TR*              ,:S-DATE-REFUNDED                                          
MFA-TR*              ,:S-CHECK-ISS-REAS-CD                                      
MFA-TR*              ,:S-CHECK-STATUS-CD                                        
MFA-TR*              ,:S-REFUND-STATUS-DT                                       
MFA-TR*              ,:S-DATE-ESCH-RETURNED                                     
MFA-TR*              ,:S-DATE-ESCH-VERIFIED                                     
MFA-TR*              ,:S-NAME-FORMAT                                            
MFA-TR*              ,:S-TITLE-PREFIX                                           
MFA-TR*              ,:S-FIRST-NAME                                             
MFA-TR*              ,:S-MIDDLE-NAME                                            
MFA-TR*              ,:S-LAST-NAME                                              
MFA-TR*              ,:S-FULL-NAME                                              
MFA-TR*              ,:S-TITLE-SUFFIX-1                                         
MFA-TR*              ,:S-TITLE-SUFFIX-2                                         
MFA-TR*              ,:S-ADDRESS-FORMAT                                         
MFA-TR*              ,:S-HOUSE-NO                                               
MFA-TR*              ,:S-ADDR-PREFIX-1                                          
MFA-TR*              ,:S-ADDR-PREFIX-2                                          
MFA-TR*              ,:S-ADDR-SUFFIX                                            
MFA-TR*              ,:S-STREET-NAME                                            
MFA-TR*              ,:S-STREET-SUFFIX                                          
MFA-TR*              ,:S-ADDRESS-OVERFLOW                                       
MFA-TR*              ,:S-CITY-STATE                                             
MFA-TR*              ,:S-STATE                                                  
MFA-TR*              ,:S-COUNTRY                                                
MFA-TR*              ,:S-ZIP-CODE                                               
MFA-TR*              ,:S-STREET-LOCATION-1                                      
MFA-TR*              ,:S-STREET-LOCATION-2                                      
MFA-TR*              ,:S-RETURN-CODE                                            
MFA-TR*              ,:S-ESCHEATMENT-CD                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR04312_R1'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                 12750000
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
      *                                                                         
