       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04308.                                         
COB303 DATE-WRITTEN.      OCT 08, 2009.                                 
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE ROOMATE & CO-APPLICANT DETAILS.    *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
A37666*  10/08/09    SV95326  NEW PROGRAM FOR ARCHIVE ACCOUNT.         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04308'.
MSQ017     COPY MFASQLM.
      *                                                                 00550000
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04308 STARTS HERE'.                  
      *                                                                 00580000
      ******************************************************************00590000
      *    DB2 INCLUDES                                                *00600000
      ******************************************************************00610000
      *                                                                 00620000
           EXEC SQL                                                     00630000
              INCLUDE SQLCA                                             00640000
           END-EXEC.                                                    00650000
      *                                                                 00660000
           EXEC SQL                                                     00670000
              INCLUDE TBHCOAPP                                          00680000
           END-EXEC.                                                    00690000
      *                                                                 00700000
           EXEC SQL                                                     00710000
              INCLUDE TBHROOMT                                          00720000
           END-EXEC.                                                    00730000
      *                                                                 00740000
           EXEC SQL                                                     00750000
              INCLUDE TBCNTACT                                          00760000
           END-EXEC.                                                    00770000
      *                                                                 00780000
           EXEC SQL                                                     00790000
              INCLUDE TBCNTPHN                                          00800000
           END-EXEC.                                                    00810000
      *                                                                 00820000
           EXEC SQL                                                     00830000
              INCLUDE TBCNTCAT                                          00840000
           END-EXEC.                                                    00850000
      *                                                                 00860000
           EXEC SQL                                                     00870000
              INCLUDE TBCUST                                            00880000
           END-EXEC.                                                    00890000
      *                                                                 00900000
           EXEC SQL                                                     00910000
              INCLUDE TBCSTSTS                                          00920000
           END-EXEC.                                                    00930000
      *                                                                 00940000
           EXEC SQL                                                     00950000
              INCLUDE TBBSCSTS                                          00960000
           END-EXEC.                                                    00970000
      *                                                                 00980000
           EXEC SQL                                                     00990000
              INCLUDE TBNAME                                            01000000
           END-EXEC.                                                    01010000
      *                                                                 01020000
           EXEC SQL                                                     01030000
              INCLUDE TBCSTMSC                                          01040000
           END-EXEC.                                                    01050000
      *                                                                 01060000
           EXEC SQL                                                     01070000
              INCLUDE TBCSTPHN                                          01080000
           END-EXEC.                                                    01090000
      *                                                                 01100000
           EXEC SQL                                                     01150000
              INCLUDE TBPREM                                            01160000
           END-EXEC.                                                    01170000
      *                                                                 01180000
           EXEC SQL                                                     01190000
              INCLUDE TBUTLENV                                          01200000
           END-EXEC.                                                    01210000
      *                                                                 01220000
           EXEC SQL                                                     01230000
              INCLUDE TBDEPINT                                          01240000
           END-EXEC.                                                    01250000
      *                                                                 01260000
           EXEC SQL                                                     01270000
              INCLUDE TBHACCT                                           01280000
           END-EXEC.                                                    01290000
      *                                                                 01300000
           EXEC SQL                                                             
              INCLUDE TBTHDPTY                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     01310000
              INCLUDE TBMODEL                                           01320000
           END-EXEC.                                                    01330000
      *                                                                 01340000
      ******************************************************************01350000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01360000
      ******************************************************************01370000
      *                                                                 01380000
           COPY CCA00001.                                               01410000
           COPY CWS00027.                                               01430000
           COPY CWS00303.                                               01440000
      *                                                                 01450000
      ******************************************************************01460000
      *    WORK AREAS                                                  *01470000
      ******************************************************************01480000
      *                                                                 01490000
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACCOUNT-NO         PIC X(13)      VALUE SPACES.     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-ALLIANCE-TYPE        PIC X(02) VALUE SPACES.           
           05  S-CUSTOMER-TYPE        PIC X(01) VALUE SPACES.           
           05  S-FIRST-NAME           PIC X(15) VALUE SPACES.           
           05  S-MIDDLE-NAME          PIC X(15) VALUE SPACES.           
           05  S-LAST-NAME            PIC X(40) VALUE SPACES.           
           05  S-NICKNAME             PIC X(50) VALUE SPACES.           
           05  S-TITLE-PREFIX         PIC X(09) VALUE SPACES.           
           05  S-TITLE-SUFFIX         PIC X(03) VALUE SPACES.           
           05  S-BUSINESS-NAME        PIC X(70) VALUE SPACES.           
           05  S-CUST-OCCUP           PIC X(15) VALUE SPACES.           
           05  S-CUST-WORK-PHONE      PIC X(10) VALUE SPACES.           
           05  S-CUST-WORK-PHONE-EXT  PIC X(06) VALUE SPACES.           
           05  S-CUST-HOME-PHONE      PIC X(10) VALUE SPACES.           
           05  S-CUST-BUS-PHONE       PIC X(10) VALUE SPACES.           
           05  S-CUST-EMPLOYER        PIC X(23) VALUE SPACES.           
           05  S-EMPLOYED-DATE        PIC X(08) VALUE SPACES.           
           05  S-EMPLOYEE-NBR         PIC X(05) VALUE SPACES.           
           05  S-CUST-SSN             PIC X(09) VALUE SPACES.           
           05  S-CODE-STATE-ID        PIC X(02) VALUE SPACES.           
           05  S-LICENSE-NO           PIC X(19) VALUE SPACES.           
           05  S-DATE-OF-BIRTH        PIC X(08) VALUE SPACES.           
           05  S-DRVR-LIC-ISS-DT      PIC X(08) VALUE SPACES.           
           05  S-OTHER-ID-TYPE        PIC X(12) VALUE SPACES.           
           05  S-OTHER-ID             PIC X(16) VALUE SPACES.           
           05  S-ALIAS                PIC X(07) VALUE SPACES.           
           05  S-TAX-ID               PIC X(09) VALUE SPACES.           
           05  S-COMPANY-IND          PIC X(01) VALUE SPACES.           
           05  S-BUSINESS-TYPE-CD     PIC X(01) VALUE SPACES.           
           05  S-CONTRACTOR-TYPE      PIC X(30) VALUE SPACES.           
           05  S-CONSULTING-PROJ      PIC X(30) VALUE SPACES.           
           05  S-CONSLT-PRJ-END-DT    PIC X(08) VALUE SPACES.           
           05  S-READ-CYCLE           PIC X(02) VALUE SPACES.           
           05  S-SERV-STRT-DT         PIC X(10) VALUE SPACES.           
           05  S-DEP-INTST-RT         PIC S9(2)V99 COMP-3 VALUE 0.      
      *                                                                         
      ******************************************************************02280000
      *       COPYBOOK FOR CPD00124 RETURN VALUES                      *02290000
      ******************************************************************02300000
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-SELECT-DATE-FORM.                                         
           10  WS-SELECT-YEAR          PIC X(04) VALUE SPACES.          
           10  FILLER                  PIC X(01) VALUE SPACES.          
           10  WS-SELECT-MONTH         PIC X(02) VALUE SPACES.          
           10  FILLER                  PIC X(01) VALUE SPACES.          
           10  WS-SELECT-DAY           PIC X(02) VALUE SPACES.          
                                                                        
       01  WS-RETURN-DATE-FORM.                                         
           10  WS-RETURN-MONTH         PIC X(02) VALUE SPACES.          
           10  WS-RETURN-DAY           PIC X(02) VALUE SPACES.          
           10  WS-RETURN-YEAR          PIC X(04) VALUE SPACES.          
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR04308'.    
           05  WS-ACCOUNT-NO-RED       PIC X(13).                       
           05  WS-ACCOUNT-NO  REDEFINES WS-ACCOUNT-NO-RED               
                                       PIC 9(13).                       
COB305     05 WS-CUSTOMER-NO-NUM        PIC S9(10)V COMP-3 VALUE 0.             
           05  WS-NULL-REV-PROT-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-EMP-DT          PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CNSLT-END-DT    PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-SERV-EST-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CUST-EST-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-BIRTH-DT        PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-DRV-LIC-DT      PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-VISIT-DT        PIC S9(04)  COMP VALUE ZERO.     
           05  WS-RET-SEND-ONCE        PIC X(01)   VALUE 'N'.           
           05  WS-CUST-NAME-TYPE       PIC X(02)   VALUE 'CN'.          
           05  WS-CUST-NAME-FORMAT     PIC X(01)   VALUE 'I'.           
           05  WS-CUST-CUSTOMER-TYPE   PIC X(01)   VALUE 'C'.           
           05  WS-PHONE-TYPE           PIC X(02)   VALUE SPACES.        
           05  WS-WORK-PHONE-TYPE      PIC X(02)   VALUE 'W1'.          
           05  WS-HOME-PHONE-TYPE      PIC X(02)   VALUE 'H1'.          
           05  WS-BUS-PHONE-TYPE       PIC X(02)   VALUE 'B1'.          
           05  WS-IND-READ-CYCLE       PIC S9(04)  COMP.                
           05  WS-IND-DATE-INSTALL     PIC S9(04)  COMP.                
           05  WS-NULL-ANNIV-DATE      PIC S9(04)  COMP VALUE ZERO.     
                                                                        
      ****************************************************************  03680000
      * CURSOR DECLARATION FOR HST_COAPPLICANT , HST_ROOMMATE        *  03690000
      ****************************************************************  03700000
           EXEC SQL                                                     
             DECLARE RY-COAPPLICANT-CUR CURSOR FOR                      
                 SELECT CUSTOMER_NO                                     
                   FROM HST_COAPPLICANT WITH(READUNCOMMITTED)                   
                  WHERE  ACCOUNT_NO = :RY-ACCOUNT-NO                    
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03710000
MFA-TR*      DECLARE RY-COAPPLICANT-CUR CURSOR FOR                      03720000
MFA-TR*          SELECT CUSTOMER_NO                                     03730000
MFA-TR*            FROM HST_COAPPLICANT                                 03740000
MFA-TR*           WHERE  ACCOUNT_NO = :RY-ACCOUNT-NO                    03750000
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                    03760000
      *                                                                 03770000
           EXEC SQL                                                     
             DECLARE RX-ROOMMATE-CUR CURSOR FOR                         
                 SELECT CUSTOMER_NO                                     
                   FROM HST_ROOMMATE WITH(READUNCOMMITTED)                      
                  WHERE ACCOUNT_NO = :RX-ACCOUNT-NO                     
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03780000
MFA-TR*      DECLARE RX-ROOMMATE-CUR CURSOR FOR                         03790000
MFA-TR*          SELECT CUSTOMER_NO                                     03800000
MFA-TR*            FROM HST_ROOMMATE                                    03810000
MFA-TR*           WHERE ACCOUNT_NO = :RX-ACCOUNT-NO                     03820000
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                    03830000
      *                                                                 03840000
HPCCDM*EJECT                                                            03850000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   RETURN_CODE                                          
                  ,ALLIANCE_TYPE                                        
                  ,CUSTOMER_TYPE                                        
                  ,LTRIM(RTRIM(TITLE_PREFIX))        AS PREFIX                 
                  ,LTRIM(RTRIM(FIRST_NAME))          AS FIRST_NAME             
                  ,LTRIM(RTRIM(MIDDLE_NAME))         AS MIDDLE_NAME            
                  ,LTRIM(RTRIM(LAST_NAME))           AS LAST_NAME              
                  ,LTRIM(RTRIM(TITLE_SUFFIX))        AS SUFFIX                 
                  ,LTRIM(RTRIM(BUSINESS_NAME))       AS BUSINESS_NAME          
                  ,LTRIM(RTRIM(NICKNAME))            AS NICKNAME               
                  ,LTRIM(RTRIM(CUST_HOME_PHONE))     AS CUST_HOME_PHONE        
                  ,LTRIM(RTRIM(CUST_BUS_PHONE))      AS CUST_BUS_PHONE         
                  ,LTRIM(RTRIM(CUST_OCCUP))          AS CUST_OCCUP             
                  ,LTRIM(RTRIM(CUST_WORK_PHONE))     AS CUST_WORK_PHONE        
                  ,LTRIM(RTRIM(CUST_WORK_PHONE_EX))  AS 
           CUST_WORK_PHONE_EX     
                  ,LTRIM(RTRIM(CUST_EMPLOYER))       AS CUST_EMPLOYER          
                  ,EMPLOYED_DATE                                        
                  ,EMPLOYEE_NBR                                         
                  ,LTRIM(RTRIM(CUST_SSN))            AS CUST_SSN               
                  ,LTRIM(RTRIM(DATE_OF_BIRTH))       AS DATE_OF_BIRTH          
                  ,LTRIM(RTRIM(LICENSE_NO))          AS LICENSE_NO             
                  ,CODE_STATE_ID              AS CODE_STATE_ID          
                  ,LTRIM(RTRIM(DRVR_LIC_ISS_DT))     AS DRVR_LIC_ISS_DT        
                  ,LTRIM(RTRIM(OTHER_ID_TYPE))       AS OTHER_ID_TYPE          
                  ,LTRIM(RTRIM(OTHER_ID))            AS OTHER_ID               
                  ,LTRIM(RTRIM(ALIAS))               AS ALIAS                  
                  ,LTRIM(RTRIM(TAX_ID))              AS TAX_ID                 
                  ,COMPANY_IND                AS COMPANY_IND            
                  ,BUSINESS_TYPE_CD           AS BUSINESS_TYPE_CD       
                  ,LTRIM(RTRIM(CONTRACTOR_TYPE))     AS CONTRACTOR_TYPE        
                  ,LTRIM(RTRIM(CONSULTING_PROJ))     AS CONSULTING_PROJ        
                  ,LTRIM(RTRIM(CONSLT_PRJ_END_DT))   AS 
           CONSLT_PRJ_END_DT      
                  ,READ_CYCLE                                           
                  ,SERV_STRT_DT               AS SERVICE_START_DATE     
                  ,DEP_INTST_RT               AS DEPOSIT_INT_RATE       
               FROM #CSR04308_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,ALLIANCE_TYPE                                                
MFA-TR*           ,CUSTOMER_TYPE                                                
MFA-TR*           ,STRIP(TITLE_PREFIX)        AS PREFIX                         
MFA-TR*           ,STRIP(FIRST_NAME)          AS FIRST_NAME                     
MFA-TR*           ,STRIP(MIDDLE_NAME)         AS MIDDLE_NAME                    
MFA-TR*           ,STRIP(LAST_NAME)           AS LAST_NAME                      
MFA-TR*           ,STRIP(TITLE_SUFFIX)        AS SUFFIX                         
MFA-TR*           ,STRIP(BUSINESS_NAME)       AS BUSINESS_NAME                  
MFA-TR*           ,STRIP(NICKNAME)            AS NICKNAME                       
MFA-TR*           ,STRIP(CUST_HOME_PHONE)     AS CUST_HOME_PHONE                
MFA-TR*           ,STRIP(CUST_BUS_PHONE)      AS CUST_BUS_PHONE                 
MFA-TR*           ,STRIP(CUST_OCCUP)          AS CUST_OCCUP                     
MFA-TR*           ,STRIP(CUST_WORK_PHONE)     AS CUST_WORK_PHONE                
MFA-TR*           ,STRIP(CUST_WORK_PHONE_EX)  AS CUST_WORK_PHONE_EX             
MFA-TR*           ,STRIP(CUST_EMPLOYER)       AS CUST_EMPLOYER                  
MFA-TR*           ,EMPLOYED_DATE                                                
MFA-TR*           ,EMPLOYEE_NBR                                                 
MFA-TR*           ,STRIP(CUST_SSN)            AS CUST_SSN                       
MFA-TR*           ,STRIP(DATE_OF_BIRTH)       AS DATE_OF_BIRTH                  
MFA-TR*           ,STRIP(LICENSE_NO)          AS LICENSE_NO                     
MFA-TR*           ,CODE_STATE_ID              AS CODE_STATE_ID                  
MFA-TR*           ,STRIP(DRVR_LIC_ISS_DT)     AS DRVR_LIC_ISS_DT                
MFA-TR*           ,STRIP(OTHER_ID_TYPE)       AS OTHER_ID_TYPE                  
MFA-TR*           ,STRIP(OTHER_ID)            AS OTHER_ID                       
MFA-TR*           ,STRIP(ALIAS)               AS ALIAS                          
MFA-TR*           ,STRIP(TAX_ID)              AS TAX_ID                         
MFA-TR*           ,COMPANY_IND                AS COMPANY_IND                    
MFA-TR*           ,BUSINESS_TYPE_CD           AS BUSINESS_TYPE_CD               
MFA-TR*           ,STRIP(CONTRACTOR_TYPE)     AS CONTRACTOR_TYPE                
MFA-TR*           ,STRIP(CONSULTING_PROJ)     AS CONSULTING_PROJ                
MFA-TR*           ,STRIP(CONSLT_PRJ_END_DT)   AS CONSLT_PRJ_END_DT              
MFA-TR*           ,READ_CYCLE                                                   
MFA-TR*           ,SERV_STRT_DT               AS SERVICE_START_DATE             
MFA-TR*           ,DEP_INTST_RT               AS DEPOSIT_INT_RATE               
MFA-TR*        FROM SESSION.CSR04308_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO                                         
               .                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************03880000
      * 0000-MAINLINE                                                  *03890000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03900000
      ******************************************************************03910000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04020000
      * 0100-INITIALIZE                                                *04030000
      *     1. RESET DB2 ERROR HANDLERS                                *04050000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04060000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04070000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04080000
      ******************************************************************04100000
       0100-INITIALIZE.                                                 
                                                                        
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
           PERFORM 0100A-DECLARE-GTT                                    
             THRU 0100A-EXIT.                                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04308_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04308_R1
              (                                                          
               RETURN_CODE              INT                         
              ,ALLIANCE_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,CUSTOMER_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,TITLE_PREFIX CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,TITLE_SUFFIX CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,BUSINESS_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,NICKNAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,CUST_HOME_PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,CUST_BUS_PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CUST_OCCUP CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,CUST_WORK_PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,CUST_WORK_PHONE_EX CHAR(06)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CUST_EMPLOYER CHAR(23)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,EMPLOYED_DATE CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,EMPLOYEE_NBR CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CUST_SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,DATE_OF_BIRTH CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,LICENSE_NO CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,CODE_STATE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,DRVR_LIC_ISS_DT CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,OTHER_ID_TYPE CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,OTHER_ID CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,ALIAS CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2                  
              ,TAX_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2                 
              ,COMPANY_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,BUSINESS_TYPE_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CONTRACTOR_TYPE CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,CONSULTING_PROJ CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,CONSLT_PRJ_END_DT CHAR(08)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,READ_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,SERV_STRT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,DEP_INTST_RT             DECIMAL(4,2)                    
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04308_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
      ******************************************************************04370000
      * 1000-PROCESS-INPUT                                             *04380000
      *     RECEIVE PARMS FROM THE CALLING STORED PROCEDURE.           *04400000
      ******************************************************************04420000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO-RED.             
           MOVE WS-ACCOUNT-NO         TO RY-ACCOUNT-NO.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04720000
      *   2000-PROCESS-OUTPUT                                          *04730000
      *   1. DESCRIBE RESULT SET                                       *04750000
      *   2. RETRIEVE DB2 DATA AND BUILD RESULT SET                    *04760000
      *   3. SEND RESULT SET                                           *04770000
      ******************************************************************04790000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            MOVE '2000'    TO ACTIVE-PARAGRAPH.                         
            PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13040000
      *   2200-BUILD-RESULT                                            *13050000
      *   1.  SELECT AND FORMAT ALL CUSTOMER DETAIL INFORMATION        *13070000
      *       TO BE RETURNED.                                          *13080000
      ******************************************************************13100000
      *                                                                         
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE  '2200'  TO ACTIVE-PARAGRAPH.                           
           PERFORM 2500-PROCESS-CUST-DETAILS     THRU 2500-EXIT.        
      ** OPEN CURSOR FOR CO-APPLICANT **                                13150000
                                                                        
           MOVE WS-ACCOUNT-NO                    TO RY-ACCOUNT-NO.      
           PERFORM 7000-OPEN-CO-APPLICANT-CUR    THRU 7000-EXIT.        
                                                                        
           PERFORM 7010-FETCH-CO-APPLICANT-CUR   THRU 7010-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  SUCCESSFUL-CALL                 
              MOVE WS-ACCOUNT-NO               TO UT-ACCOUNT-NO         
              MOVE 'Y'                         TO WS-RET-SEND-ONCE      
              PERFORM 2300-PROCESS-COAPPLICANT THRU 2300-EXIT           
              UNTIL WS-ACTIVE-RETURN-CODE  = NOT-FOUND                  
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-CO-APPLICANT-CUR   THRU 7020-EXIT.        
                                                                        
      ** OPEN CURSOR FOR ROMMMATE **                                    13320000
                                                                        
           PERFORM 2600-FILL-BLANK-FOR-SEND      THRU 2600-EXIT         
           MOVE WS-ACCOUNT-NO                    TO RX-ACCOUNT-NO.      
           PERFORM 7100-OPEN-ROOMMATE-CUR        THRU 7100-EXIT.        
                                                                        
           PERFORM 7110-FETCH-ROOMMATE-CUR       THRU 7110-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE  =  SUCCESSFUL-CALL                 
              MOVE 'Y'                           TO WS-RET-SEND-ONCE    
              PERFORM 2400-PROCESS-ROOMMATE      THRU 2400-EXIT         
              UNTIL WS-ACTIVE-RETURN-CODE  = NOT-FOUND                  
           END-IF.                                                      
                                                                        
           PERFORM 7120-CLOSE-ROOMMATE-CUR       THRU 7120-EXIT.        
                                                                        
           IF WS-RET-SEND-ONCE = 'N'                                    
              MOVE 200                       TO S-RETURN-CODE           
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13890000
      ******************************************************************13900000
      * 2300-PROCESS-COAPPLICANT.                                      *13910000
      ******************************************************************13930000
      *                                                                         
       2300-PROCESS-COAPPLICANT.                                        
                                                                        
           MOVE '2300'    TO ACTIVE-PARAGRAPH.                          
           MOVE RY-CUSTOMER-NO                   TO WS-CUSTOMER-NO-NUM. 
           MOVE 'CO'                             TO S-ALLIANCE-TYPE.    
           PERFORM 7300-SELECT-CUSTOMER-DTLS   THRU 7300-EXIT.          
                                                                        
           PERFORM 7400-SELECT-RES-STATS       THRU 7400-EXIT.          
                                                                        
           PERFORM 7500-SELECT-BUS-STATS       THRU 7500-EXIT.          
                                                                        
           PERFORM 7600-SELECT-MISC-INFO       THRU 7600-EXIT.          
                                                                        
           MOVE WS-HOME-PHONE-TYPE     TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-HOME-PHONE             
           ELSE                                                         
              MOVE SPACES              TO S-CUST-HOME-PHONE             
           END-IF.                                                      
                                                                        
           MOVE WS-WORK-PHONE-TYPE     TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-WORK-PHONE             
              MOVE CB-EXTENSION-NO     TO S-CUST-WORK-PHONE-EXT         
           ELSE                                                         
              MOVE SPACES              TO S-CUST-WORK-PHONE             
              MOVE SPACES              TO S-CUST-WORK-PHONE-EXT         
           END-IF.                                                      
                                                                        
           MOVE WS-BUS-PHONE-TYPE      TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-BUS-PHONE              
           ELSE                                                         
              MOVE SPACES              TO S-CUST-BUS-PHONE              
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           PERFORM 2600-FILL-BLANK-FOR-SEND      THRU 2600-EXIT.        
           PERFORM 7010-FETCH-CO-APPLICANT-CUR   THRU 7010-EXIT.        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14390000
      ******************************************************************14410000
      * 2400-PROCESS-ROOMMATE.                                         *14420000
      ******************************************************************14440000
      *                                                                         
       2400-PROCESS-ROOMMATE.                                           
                                                                        
           MOVE '2400'    TO ACTIVE-PARAGRAPH.                          
           MOVE RX-CUSTOMER-NO                   TO WS-CUSTOMER-NO-NUM. 
           MOVE 'RO'                             TO S-ALLIANCE-TYPE.    
           PERFORM 7300-SELECT-CUSTOMER-DTLS   THRU 7300-EXIT.          
                                                                        
           PERFORM 7400-SELECT-RES-STATS       THRU 7400-EXIT.          
                                                                        
           MOVE WS-HOME-PHONE-TYPE     TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-HOME-PHONE             
           ELSE                                                         
              MOVE SPACES              TO S-CUST-HOME-PHONE             
           END-IF.                                                      
                                                                        
           MOVE WS-WORK-PHONE-TYPE     TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-WORK-PHONE             
              MOVE CB-EXTENSION-NO     TO S-CUST-WORK-PHONE-EXT         
           ELSE                                                         
              MOVE SPACES              TO S-CUST-WORK-PHONE             
              MOVE SPACES              TO S-CUST-WORK-PHONE-EXT         
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           PERFORM 2600-FILL-BLANK-FOR-SEND      THRU 2600-EXIT.        
           PERFORM 7110-FETCH-ROOMMATE-CUR       THRU 7110-EXIT.        
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14780000
      ******************************************************************14790000
      * 2500-PROCESS-CUST-DETAILS.                                     *14800000
      ******************************************************************14820000
      *                                                                         
       2500-PROCESS-CUST-DETAILS.                                       
                                                                        
           MOVE '2500'    TO ACTIVE-PARAGRAPH.                          
           MOVE WS-ACCOUNT-NO               TO HA-ACCOUNT-NO.           
                                                                        
           PERFORM 7200-SELECT-ACCNT-CUSTOMER  THRU 7200-EXIT.          
                                                                        
           MOVE HA-CUSTOMER-NO              TO WS-CUSTOMER-NO-NUM.      
           MOVE 'CN'                        TO S-ALLIANCE-TYPE.         
           PERFORM 7300-SELECT-CUSTOMER-DTLS   THRU 7300-EXIT.          
                                                                        
           PERFORM 7400-SELECT-RES-STATS       THRU 7400-EXIT.          
                                                                        
           PERFORM 7500-SELECT-BUS-STATS       THRU 7500-EXIT.          
                                                                        
           PERFORM 7600-SELECT-MISC-INFO       THRU 7600-EXIT.          
                                                                        
           MOVE WS-HOME-PHONE-TYPE     TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-HOME-PHONE             
           ELSE                                                         
              MOVE SPACES              TO S-CUST-HOME-PHONE             
           END-IF.                                                      
                                                                        
           MOVE WS-WORK-PHONE-TYPE     TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-WORK-PHONE             
              MOVE CB-EXTENSION-NO     TO S-CUST-WORK-PHONE-EXT         
           ELSE                                                         
              MOVE SPACES              TO S-CUST-WORK-PHONE             
              MOVE SPACES              TO S-CUST-WORK-PHONE-EXT         
           END-IF.                                                      
                                                                        
           MOVE WS-BUS-PHONE-TYPE      TO WS-PHONE-TYPE.                
           PERFORM 7700-SELECT-PHONE-NO     THRU 7700-EXIT.             
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              MOVE CB-PHONE-NO         TO S-CUST-BUS-PHONE              
           ELSE                                                         
              MOVE SPACES              TO S-CUST-BUS-PHONE              
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           PERFORM 2600-FILL-BLANK-FOR-SEND      THRU 2600-EXIT.        
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15310000
      ******************************************************************15320000
      * 2600-FILL-BLANK-FOR-SEND                                       *15330000
      * RESET RETURN FIELD VALUES TO SPACES                            *15340000
      ******************************************************************15350000
      *                                                                         
       2600-FILL-BLANK-FOR-SEND.                                        
      *                                                                         
           MOVE SPACES                 TO S-ALLIANCE-TYPE.              
           MOVE SPACES                 TO S-CUSTOMER-TYPE.              
           MOVE SPACES                 TO S-FIRST-NAME.                 
           MOVE SPACES                 TO S-MIDDLE-NAME.                
           MOVE SPACES                 TO S-LAST-NAME.                  
           MOVE SPACES                 TO S-NICKNAME.                   
           MOVE SPACES                 TO S-TITLE-PREFIX.               
           MOVE SPACES                 TO S-TITLE-SUFFIX.               
           MOVE SPACES                 TO S-BUSINESS-NAME.              
           MOVE SPACES                 TO S-CUST-OCCUP.                 
           MOVE SPACES                 TO S-CUST-WORK-PHONE.            
           MOVE SPACES                 TO S-CUST-WORK-PHONE-EXT.        
           MOVE SPACES                 TO S-CUST-HOME-PHONE.            
           MOVE SPACES                 TO S-CUST-BUS-PHONE.             
           MOVE SPACES                 TO S-CUST-EMPLOYER.              
           MOVE SPACES                 TO S-EMPLOYED-DATE.              
           MOVE SPACES                 TO S-EMPLOYEE-NBR.               
           MOVE SPACES                 TO S-CUST-SSN.                   
           MOVE SPACES                 TO S-CODE-STATE-ID.              
           MOVE SPACES                 TO S-LICENSE-NO.                 
           MOVE SPACES                 TO S-DATE-OF-BIRTH.              
           MOVE SPACES                 TO S-DRVR-LIC-ISS-DT.            
           MOVE SPACES                 TO S-OTHER-ID-TYPE.              
           MOVE SPACES                 TO S-OTHER-ID.                   
           MOVE SPACES                 TO S-ALIAS.                      
           MOVE SPACES                 TO S-TAX-ID.                     
           MOVE SPACES                 TO S-COMPANY-IND.                
           MOVE SPACES                 TO S-BUSINESS-TYPE-CD.           
           MOVE SPACES                 TO S-CONTRACTOR-TYPE.            
           MOVE SPACES                 TO S-CONSULTING-PROJ.            
           MOVE SPACES                 TO S-CONSLT-PRJ-END-DT.          
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************15890000
      *   7000-OPEN-CO-APPLICANT-CUR                                   *15900000
      ******************************************************************15940000
      *                                                                 15950000
       7000-OPEN-CO-APPLICANT-CUR.                                      
           EXEC SQL                                                     
               OPEN RY-COAPPLICANT-CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16000000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 16030000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'HST_COAPPLICANT  ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE RY-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16200000
      ******************************************************************16210000
      *   7010-FETCH-CO-APPLICANT-CUR                                  *16220000
      ******************************************************************16260000
      *                                                                 16270000
       7010-FETCH-CO-APPLICANT-CUR.                                     
      *                                                                 16290000
           EXEC SQL                                                     
               FETCH RY-COAPPLICANT-CUR                                 
               INTO :RY-CUSTOMER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16340000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 16370000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7010'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'HST_COAPPLICANT  ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE RY-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16550000
      ******************************************************************16560000
      *   7020-CLOSE-CO-APPLICANT-CUR                                  *16570000
      ******************************************************************16610000
      *                                                                         
       7020-CLOSE-CO-APPLICANT-CUR.                                     
      *                                                                 16630000
           EXEC SQL                                                     
               CLOSE RY-COAPPLICANT-CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16670000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 16700000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_COAPPLICANT  '        TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
              MOVE RY-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16860000
      ******************************************************************16560000
      *  7100-OPEN-ROOMMATE-CUR.                                       *16570000
      ******************************************************************16610000
      *                                                                         
       7100-OPEN-ROOMMATE-CUR.                                          
           EXEC SQL                                                     
               OPEN RX-ROOMMATE-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 16910000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 16940000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'HST_ROOMMATE     ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE RX-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17110000
      ******************************************************************17120000
      *   7110-FETCH-ROOMMATE-CUR                                      *17130000
      ******************************************************************17170000
      *                                                                 17180000
       7110-FETCH-ROOMMATE-CUR.                                         
      *                                                                 17200000
           EXEC SQL                                                     
               FETCH RX-ROOMMATE-CUR                                    
               INTO :RX-CUSTOMER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17250000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 17280000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7110'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'HST_ROOMMATE     ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE RX-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17460000
      ******************************************************************17470000
      *   7120-CLOSE-ROOMMATE-CUR                                      *17480000
      ******************************************************************17520000
      *                                                                         
       7120-CLOSE-ROOMMATE-CUR.                                         
      *                                                                 17540000
           EXEC SQL                                                     
               CLOSE RX-ROOMMATE-CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17580000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 17610000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_ROOMMATE     '        TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
              MOVE RX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17770000
      ******************************************************************19160000
      * 7200-SELECT-ACCNT-CUSTOMER                                     *19170000
      * SELECT THE CUSTOMER FOR AN ACCOUNT                             *19180000
      ******************************************************************19190000
      *                                                                         
       7200-SELECT-ACCNT-CUSTOMER.                                      
      *                                                                 19210000
           EXEC SQL                                                     
               SELECT CUSTOMER_NO                                       
                 INTO :HA-CUSTOMER-NO                                   
                 FROM HST_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19220000
MFA-TR*        SELECT CUSTOMER_NO                                       19230000
MFA-TR*          INTO :HA-CUSTOMER-NO                                   19240000
MFA-TR*          FROM HST_ACCOUNT                                       19250000
MFA-TR*         WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       19260000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    19270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19280000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          S-RETURN-CODE.                
      *                                                                 19310000
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'HST_ACCOUNT      '        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE HA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 19430000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19460000
      ******************************************************************19470000
      *   7300-SELECT-CUSTOMER-DTLS.                                   *19480000
      *   1.  DETERMINE NAME_ID BASED ON PASSED CUSTOMER_NO.           *19500000
      *       USE BOTH CUSTOMER_NO AND NAME_ID TO SELECT CUSTOMER      *19510000
      *       INFORMATION FROM CSS_CUSTOMER AND CSS_NAME TABLES.       *19520000
      ******************************************************************19530000
      *                                                                         
       7300-SELECT-CUSTOMER-DTLS.                                       
           MOVE WS-CUSTOMER-NO-NUM            TO CU-CUSTOMER-NO.        
           MOVE WS-CUST-NAME-TYPE             TO DQ-NAME-TYPE.          
      *                                                                 19570000
           EXEC SQL                                                     
              SELECT CU.CUSTOMER_EST_DATE,                              
                     CU.SERVICE_EST_DATE,                               
                     CU.CUST_LAST_VISIT_DT,                             
                     DQ.NAME_FORMAT,                                    
                     DQ.FIRST_NAME,                                     
                     DQ.MIDDLE_NAME,                                    
                     DQ.LAST_NAME,                                      
                     DQ.NICKNAME,                                       
                     DQ.TITLE_PREFIX,                                   
                     DQ.TITLE_SUFFIX_1,                                 
                     DQ.FULL_NAME                                       
                INTO :CU-CUSTOMER-EST-DATE :WS-NULL-REV-PROT-DT,         
                     :CU-SERVICE-EST-DATE :WS-NULL-SERV-EST-DT,          
                     :CU-CUST-LAST-VISIT-DT :WS-NULL-VISIT-DT,           
                     :DQ-NAME-FORMAT,                                   
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-NICKNAME,                                      
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME                                      
                FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   
                 AND DQ.NAME_ID     = CU.NAME_ID                        
                 AND DQ.NAME_TYPE   = :DQ-NAME-TYPE                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19580000
MFA-TR*       SELECT CU.CUSTOMER_EST_DATE,                              19590000
MFA-TR*              CU.SERVICE_EST_DATE,                               19600000
MFA-TR*              CU.CUST_LAST_VISIT_DT,                             19610000
MFA-TR*              DQ.NAME_FORMAT,                                    19640000
MFA-TR*              DQ.FIRST_NAME,                                     19650000
MFA-TR*              DQ.MIDDLE_NAME,                                    19660000
MFA-TR*              DQ.LAST_NAME,                                      19670000
MFA-TR*              DQ.NICKNAME,                                       19680000
MFA-TR*              DQ.TITLE_PREFIX,                                   19690000
MFA-TR*              DQ.TITLE_SUFFIX_1,                                 19700000
MFA-TR*              DQ.FULL_NAME                                       19710000
MFA-TR*         INTO :CU-CUSTOMER-EST-DATE:WS-NULL-REV-PROT-DT,         19720000
MFA-TR*              :CU-SERVICE-EST-DATE:WS-NULL-SERV-EST-DT,          19730000
MFA-TR*              :CU-CUST-LAST-VISIT-DT:WS-NULL-VISIT-DT,           19740000
MFA-TR*              :DQ-NAME-FORMAT,                                   19770000
MFA-TR*              :DQ-FIRST-NAME,                                    19780000
MFA-TR*              :DQ-MIDDLE-NAME,                                   19790000
MFA-TR*              :DQ-LAST-NAME,                                     19800000
MFA-TR*              :DQ-NICKNAME,                                      19810000
MFA-TR*              :DQ-TITLE-PREFIX,                                  19820000
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                19830000
MFA-TR*              :DQ-FULL-NAME                                      19840000
MFA-TR*         FROM CSS_CUSTOMER CU,                                   19850000
MFA-TR*              CSS_NAME DQ                                        19860000
MFA-TR*        WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   19870000
MFA-TR*          AND DQ.NAME_ID     = CU.NAME_ID                        19880000
MFA-TR*          AND DQ.NAME_TYPE   = :DQ-NAME-TYPE                     19890000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                    19900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19920000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
      *                                                                 19950000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'CSS_CUSTOMER'       TO TABLE-2                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 20090000
           MOVE DQ-NAME-FORMAT         TO S-CUSTOMER-TYPE.              
           MOVE DQ-NICKNAME            TO S-NICKNAME.                   
      *                                                                 20140000
           IF DQ-NAME-FORMAT = WS-CUST-NAME-FORMAT                      
              MOVE DQ-FIRST-NAME       TO S-FIRST-NAME                  
              MOVE DQ-MIDDLE-NAME      TO S-MIDDLE-NAME                 
              MOVE DQ-LAST-NAME        TO S-LAST-NAME                   
              MOVE DQ-TITLE-PREFIX     TO S-TITLE-PREFIX                
              MOVE DQ-TITLE-SUFFIX-1   TO S-TITLE-SUFFIX                
           ELSE                                                         
              MOVE DQ-FULL-NAME        TO S-BUSINESS-NAME               
           END-IF.                                                      
      *                                                                 20240000
           IF WS-NULL-VISIT-DT NOT EQUAL -1                             
              MOVE CU-CUST-LAST-VISIT-DT TO WS-SELECT-DATE-FORM         
              MOVE WS-SELECT-YEAR        TO WS-RETURN-YEAR              
              MOVE WS-SELECT-MONTH       TO WS-RETURN-MONTH             
              MOVE WS-SELECT-DAY         TO WS-RETURN-DAY               
           END-IF.                                                      
      *                                                                 20340000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20380000
      ******************************************************************20390000
      *   7400-SELECT-RES-STATS                                        *20400000
      *   1. SELECT RESIDENTIAL INFORMATION FROM CSS_CUST_STATS.       *20420000
      ******************************************************************20440000
      *                                                                         
       7400-SELECT-RES-STATS.                                           
      *                                                                         
           MOVE WS-CUSTOMER-NO-NUM          TO CE-CUSTOMER-NO.          
           MOVE WS-CUST-CUSTOMER-TYPE       TO CE-CUSTOMER-TYPE.        
      *                                                                 20480000
           EXEC SQL                                                     
              SELECT SSN,                                               
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     EMPLOYED_DATE,                                     
                     OCCUPATION,                                        
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DRVR_LIC_ISS_DT,                                   
                     DATE_OF_BIRTH,                                     
                     EMPLOYEE_NBR,                                      
                     INTR_CO_IND                                        
                INTO :CE-SSN,                                           
                     :CE-CODE-STATE-ID,                                 
                     :CE-DRIVERS-LICENSE-NO,                            
                     :CE-EMPLOYER,                                      
                     :CE-EMPLOYED-DATE :WS-NULL-EMP-DT,                  
                     :CE-OCCUPATION,                                    
                     :CE-OTHER-ID-TYPE,                                 
                     :CE-OTHER-ID,                                      
                     :CE-DRVR-LIC-ISS-DT :WS-NULL-DRV-LIC-DT,            
                     :CE-DATE-OF-BIRTH :WS-NULL-BIRTH-DT,                
                     :CE-EMPLOYEE-NBR,                                  
                     :CE-INTR-CO-IND                                    
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                    
                 AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20490000
MFA-TR*       SELECT SSN,                                               20500000
MFA-TR*              CODE_STATE_ID,                                     20510000
MFA-TR*              DRIVERS_LICENSE_NO,                                20520000
MFA-TR*              EMPLOYER,                                          20530000
MFA-TR*              EMPLOYED_DATE,                                     20540000
MFA-TR*              OCCUPATION,                                        20550000
MFA-TR*              OTHER_ID_TYPE,                                     20560000
MFA-TR*              OTHER_ID,                                          20570000
MFA-TR*              DRVR_LIC_ISS_DT,                                   20580000
MFA-TR*              DATE_OF_BIRTH,                                     20590000
MFA-TR*              EMPLOYEE_NBR,                                      20600000
MFA-TR*              INTR_CO_IND                                        20610000
MFA-TR*         INTO :CE-SSN,                                           20620000
MFA-TR*              :CE-CODE-STATE-ID,                                 20630000
MFA-TR*              :CE-DRIVERS-LICENSE-NO,                            20640000
MFA-TR*              :CE-EMPLOYER,                                      20650000
MFA-TR*              :CE-EMPLOYED-DATE:WS-NULL-EMP-DT,                  20660000
MFA-TR*              :CE-OCCUPATION,                                    20670000
MFA-TR*              :CE-OTHER-ID-TYPE,                                 20680000
MFA-TR*              :CE-OTHER-ID,                                      20690000
MFA-TR*              :CE-DRVR-LIC-ISS-DT:WS-NULL-DRV-LIC-DT,            20700000
MFA-TR*              :CE-DATE-OF-BIRTH:WS-NULL-BIRTH-DT,                20710000
MFA-TR*              :CE-EMPLOYEE-NBR,                                  20720000
MFA-TR*              :CE-INTR-CO-IND                                    20730000
MFA-TR*         FROM CSS_CUST_STATS                                     20740000
MFA-TR*        WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                    20750000
MFA-TR*          AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                  20760000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                    20770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20780000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
      *                                                                 20810000
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 20950000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CE-SSN                TO S-CUST-SSN                  
              MOVE CE-CODE-STATE-ID      TO S-CODE-STATE-ID             
              MOVE CE-DRIVERS-LICENSE-NO TO S-LICENSE-NO                
              MOVE CE-EMPLOYER           TO S-CUST-EMPLOYER             
              MOVE CE-OCCUPATION         TO S-CUST-OCCUP                
              MOVE CE-OTHER-ID-TYPE      TO S-OTHER-ID-TYPE             
              MOVE CE-OTHER-ID           TO S-OTHER-ID                  
              MOVE CE-EMPLOYEE-NBR       TO S-EMPLOYEE-NBR              
      *                                                                 21050000
              IF WS-NULL-EMP-DT = -1                                    
                 MOVE SPACES             TO S-EMPLOYED-DATE             
              ELSE                                                      
                 MOVE CE-EMPLOYED-DATE    TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO S-EMPLOYED-DATE            
              END-IF                                                    
      *                                                                 21150000
              IF WS-NULL-DRV-LIC-DT = -1                                
                 MOVE SPACES             TO S-DRVR-LIC-ISS-DT           
              ELSE                                                      
                 MOVE CE-DRVR-LIC-ISS-DT  TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO S-DRVR-LIC-ISS-DT          
              END-IF                                                    
      *                                                                 21250000
              IF WS-NULL-BIRTH-DT = -1                                  
                 MOVE SPACES             TO S-DATE-OF-BIRTH             
              ELSE                                                      
                 MOVE CE-DATE-OF-BIRTH    TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO S-DATE-OF-BIRTH            
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                 TO S-CUST-SSN                 
              MOVE SPACES                 TO S-CODE-STATE-ID            
              MOVE SPACES                 TO S-LICENSE-NO               
              MOVE SPACES                 TO S-CUST-EMPLOYER            
              MOVE SPACES                 TO S-CUST-OCCUP               
              MOVE SPACES                 TO S-OTHER-ID-TYPE            
              MOVE SPACES                 TO S-OTHER-ID                 
              MOVE SPACES                 TO S-EMPLOYEE-NBR             
              MOVE SPACES                 TO S-EMPLOYED-DATE            
              MOVE SPACES                 TO S-DRVR-LIC-ISS-DT          
              MOVE SPACES                 TO S-DATE-OF-BIRTH            
           END-IF.                                                      
      *                                                                 21490000
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21520000
      ******************************************************************21530000
      *   7500-SELECT-BUS-STATS.                                       *21540000
      *   1. SELECT BUSINESS INFORMATION FROM CSS_BUS_CUST_STATS.      *21560000
      ******************************************************************21580000
      *                                                                         
       7500-SELECT-BUS-STATS.                                           
           MOVE WS-CUSTOMER-NO-NUM            TO BS-CUSTOMER-NO.        
      *                                                                 21610000
           EXEC SQL                                                     
              SELECT BUSINESS_TYPE_CD,                                  
                     TAX_ID,                                            
                     ALIAS,                                             
                     INTRA_CO_IND,                                      
                     SUBSIDIARY_IND,                                    
                     TRADE_ALLY_IND,                                    
                     CONTRACTOR_TYPE                                    
                INTO :BS-BUSINESS-TYPE-CD,                              
                     :BS-TAX-ID,                                        
                     :BS-ALIAS,                                         
                     :BS-INTRA-CO-IND,                                  
                     :BS-SUBSIDIARY-IND,                                
                     :BS-TRADE-ALLY-IND,                                
                     :BS-CONTRACTOR-TYPE                                
                FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO      = :BS-CUSTOMER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     21620000
MFA-TR*       SELECT BUSINESS_TYPE_CD,                                  21630000
MFA-TR*              TAX_ID,                                            21640000
MFA-TR*              ALIAS,                                             21650000
MFA-TR*              INTRA_CO_IND,                                      21660000
MFA-TR*              SUBSIDIARY_IND,                                    21670000
MFA-TR*              TRADE_ALLY_IND,                                    21680000
MFA-TR*              CONTRACTOR_TYPE                                    21690000
MFA-TR*         INTO :BS-BUSINESS-TYPE-CD,                              21700000
MFA-TR*              :BS-TAX-ID,                                        21710000
MFA-TR*              :BS-ALIAS,                                         21720000
MFA-TR*              :BS-INTRA-CO-IND,                                  21730000
MFA-TR*              :BS-SUBSIDIARY-IND,                                21740000
MFA-TR*              :BS-TRADE-ALLY-IND,                                21750000
MFA-TR*              :BS-CONTRACTOR-TYPE                                21760000
MFA-TR*         FROM CSS_BUS_CUST_STATS                                 21770000
MFA-TR*        WHERE CUSTOMER_NO      = :BS-CUSTOMER-NO                 21780000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                    21790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
      *                                                                 21830000
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 21970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BS-BUSINESS-TYPE-CD   TO S-BUSINESS-TYPE-CD          
              MOVE BS-TAX-ID             TO S-TAX-ID                    
              MOVE BS-ALIAS              TO S-ALIAS                     
              MOVE BS-CONTRACTOR-TYPE    TO S-CONTRACTOR-TYPE           
      *                                                                 22030000
              IF BS-INTRA-CO-IND = 'Y'                                  
                 MOVE 'I'                TO S-COMPANY-IND               
              ELSE                                                      
                 IF BS-SUBSIDIARY-IND = 'Y'                             
                    MOVE 'S'             TO S-COMPANY-IND               
                 ELSE                                                   
                    IF BS-TRADE-ALLY-IND = 'Y'                          
                       MOVE 'T'          TO S-COMPANY-IND               
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                TO S-BUSINESS-TYPE-CD          
              MOVE SPACES                TO S-TAX-ID                    
              MOVE SPACES                TO S-ALIAS                     
              MOVE SPACES                TO S-CONTRACTOR-TYPE           
              MOVE SPACES                TO S-COMPANY-IND               
           END-IF.                                                      
      *                                                                 22230000
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22260000
      ******************************************************************22270000
      *   7600-SELECT-MISC-INFO.                                       *22280000
      *   1. SELECT CONSULTING PROJECT INFORMATION FROM CSS_MISC_INFO. *22300000
      ******************************************************************22320000
      *                                                                         
       7600-SELECT-MISC-INFO.                                           
           MOVE WS-CUSTOMER-NO-NUM         TO LQ-CUSTOMER-NO.           
      *                                                                 22350000
           EXEC SQL                                                     
              SELECT CONSULTING_PROJECT,                                
                     CONSLT_PRJ_END_DT                                  
                INTO :LQ-CONSULTING-PROJECT,                            
                     :LQ-CONSLT-PRJ-END-DT :WS-NULL-CNSLT-END-DT         
                FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22360000
MFA-TR*       SELECT CONSULTING_PROJECT,                                22370000
MFA-TR*              CONSLT_PRJ_END_DT                                  22380000
MFA-TR*         INTO :LQ-CONSULTING-PROJECT,                            22390000
MFA-TR*              :LQ-CONSLT-PRJ-END-DT:WS-NULL-CNSLT-END-DT         22400000
MFA-TR*         FROM CSS_CUST_MISC_INFO                                 22410000
MFA-TR*        WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      22420000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                    22430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 22440000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
      *                                                                 22470000
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7600'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE LQ-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 22600000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE LQ-CONSULTING-PROJECT   TO S-CONSULTING-PROJ         
              IF WS-NULL-CNSLT-END-DT = -1                              
                 MOVE SPACES               TO S-CONSLT-PRJ-END-DT       
              ELSE                                                      
                 MOVE LQ-CONSLT-PRJ-END-DT TO WS-SELECT-DATE-FORM       
                 MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR            
                 MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH           
                 MOVE WS-SELECT-DAY        TO WS-RETURN-DAY             
                 MOVE WS-RETURN-DATE-FORM  TO S-CONSLT-PRJ-END-DT       
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                  TO S-CONSULTING-PROJ         
              MOVE SPACES                  TO S-CONSLT-PRJ-END-DT       
           END-IF.                                                      
      *                                                                 22790000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 22820000
      ******************************************************************22830000
      *   7700-SELECT-PHONE-NO.                                        *22840000
      *   1. SELECTS PHONE NUMBERS BASED ON THE CUSTOMER NUMBER,       *22860000
      *      CUSTOMER TYPE AND PHONE TYPE.                             *22870000
      ******************************************************************22890000
      *                                                                         
       7700-SELECT-PHONE-NO.                                            
           MOVE WS-CUSTOMER-NO-NUM             TO CB-CUSTOMER-NO.       
           MOVE WS-PHONE-TYPE                  TO CB-PHONE-TYPE         
      *                                                                 22930000
           EXEC SQL                                                     
              SELECT PHONE_NO,                                          
                     EXTENSION_NO                                       
                INTO :CB-PHONE-NO,                                      
                     :CB-EXTENSION-NO                                   
                FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                    
                 AND PHONE_TYPE    = :CB-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22940000
MFA-TR*       SELECT PHONE_NO,                                          22950000
MFA-TR*              EXTENSION_NO                                       22960000
MFA-TR*         INTO :CB-PHONE-NO,                                      22970000
MFA-TR*              :CB-EXTENSION-NO                                   22980000
MFA-TR*         FROM CSS_CUST_PHONE                                     22990000
MFA-TR*        WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                    23000000
MFA-TR*          AND PHONE_TYPE    = :CB-PHONE-TYPE                     23010000
MFA-TR*          AND CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE             23020000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                    23030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23040000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE.                               
      *                                                                 23070000
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7700'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE WS-CUST-CUSTOMER-TYPE                                
                                        TO HOSTVAR-ELEMENT-3            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23220000
HPCCDM*EJECT                                                            23610000
      ******************************************************************23690000
      *       END PROGRAM COPYLIB                                      *23700000
      ******************************************************************23710000
      *                                                                 23730000
       8100-SEND-RESULT.                                                
           EXEC SQL                                                     
             INSERT INTO #CSR04308_R1                            
             (                                                          
              RETURN_CODE                                               
             ,ALLIANCE_TYPE                                             
             ,CUSTOMER_TYPE                                             
             ,TITLE_PREFIX                                              
             ,FIRST_NAME                                                
             ,MIDDLE_NAME                                               
             ,LAST_NAME                                                 
             ,TITLE_SUFFIX                                              
             ,BUSINESS_NAME                                             
             ,NICKNAME                                                  
             ,CUST_HOME_PHONE                                           
             ,CUST_BUS_PHONE                                            
             ,CUST_OCCUP                                                
             ,CUST_WORK_PHONE                                           
             ,CUST_WORK_PHONE_EX                                        
             ,CUST_EMPLOYER                                             
             ,EMPLOYED_DATE                                             
             ,EMPLOYEE_NBR                                              
             ,CUST_SSN                                                  
             ,DATE_OF_BIRTH                                             
             ,LICENSE_NO                                                
             ,CODE_STATE_ID                                             
             ,DRVR_LIC_ISS_DT                                           
             ,OTHER_ID_TYPE                                             
             ,OTHER_ID                                                  
             ,ALIAS                                                     
             ,TAX_ID                                                    
             ,COMPANY_IND                                               
             ,BUSINESS_TYPE_CD                                          
             ,CONTRACTOR_TYPE                                           
             ,CONSULTING_PROJ                                           
             ,CONSLT_PRJ_END_DT                                         
             ,READ_CYCLE                                                
             ,SERV_STRT_DT                                              
             ,DEP_INTST_RT                                              
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-ALLIANCE-TYPE                                          
             ,:S-CUSTOMER-TYPE                                          
             ,:S-TITLE-PREFIX                                           
             ,:S-FIRST-NAME                                             
             ,:S-MIDDLE-NAME                                            
             ,:S-LAST-NAME                                              
             ,:S-TITLE-SUFFIX                                           
             ,:S-BUSINESS-NAME                                          
             ,:S-NICKNAME                                               
             ,:S-CUST-HOME-PHONE                                        
             ,:S-CUST-BUS-PHONE                                         
             ,:S-CUST-OCCUP                                             
             ,:S-CUST-WORK-PHONE                                        
             ,:S-CUST-WORK-PHONE-EXT                                    
             ,:S-CUST-EMPLOYER                                          
             ,:S-EMPLOYED-DATE                                          
             ,:S-EMPLOYEE-NBR                                           
             ,:S-CUST-SSN                                               
             ,:S-DATE-OF-BIRTH                                          
             ,:S-LICENSE-NO                                             
             ,:S-CODE-STATE-ID                                          
             ,:S-DRVR-LIC-ISS-DT                                        
             ,:S-OTHER-ID-TYPE                                          
             ,:S-OTHER-ID                                               
             ,:S-ALIAS                                                  
             ,:S-TAX-ID                                                 
             ,:S-COMPANY-IND                                            
             ,:S-BUSINESS-TYPE-CD                                       
             ,:S-CONTRACTOR-TYPE                                        
             ,:S-CONSULTING-PROJ                                        
             ,:S-CONSLT-PRJ-END-DT                                      
             ,:S-READ-CYCLE                                             
             ,:S-SERV-STRT-DT                                           
             ,:S-DEP-INTST-RT                                           
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04308_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ALLIANCE_TYPE                                                     
MFA-TR*      ,CUSTOMER_TYPE                                                     
MFA-TR*      ,TITLE_PREFIX                                                      
MFA-TR*      ,FIRST_NAME                                                        
MFA-TR*      ,MIDDLE_NAME                                                       
MFA-TR*      ,LAST_NAME                                                         
MFA-TR*      ,TITLE_SUFFIX                                                      
MFA-TR*      ,BUSINESS_NAME                                                     
MFA-TR*      ,NICKNAME                                                          
MFA-TR*      ,CUST_HOME_PHONE                                                   
MFA-TR*      ,CUST_BUS_PHONE                                                    
MFA-TR*      ,CUST_OCCUP                                                        
MFA-TR*      ,CUST_WORK_PHONE                                                   
MFA-TR*      ,CUST_WORK_PHONE_EX                                                
MFA-TR*      ,CUST_EMPLOYER                                                     
MFA-TR*      ,EMPLOYED_DATE                                                     
MFA-TR*      ,EMPLOYEE_NBR                                                      
MFA-TR*      ,CUST_SSN                                                          
MFA-TR*      ,DATE_OF_BIRTH                                                     
MFA-TR*      ,LICENSE_NO                                                        
MFA-TR*      ,CODE_STATE_ID                                                     
MFA-TR*      ,DRVR_LIC_ISS_DT                                                   
MFA-TR*      ,OTHER_ID_TYPE                                                     
MFA-TR*      ,OTHER_ID                                                          
MFA-TR*      ,ALIAS                                                             
MFA-TR*      ,TAX_ID                                                            
MFA-TR*      ,COMPANY_IND                                                       
MFA-TR*      ,BUSINESS_TYPE_CD                                                  
MFA-TR*      ,CONTRACTOR_TYPE                                                   
MFA-TR*      ,CONSULTING_PROJ                                                   
MFA-TR*      ,CONSLT_PRJ_END_DT                                                 
MFA-TR*      ,READ_CYCLE                                                        
MFA-TR*      ,SERV_STRT_DT                                                      
MFA-TR*      ,DEP_INTST_RT                                                      
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-ALLIANCE-TYPE                                                  
MFA-TR*      ,:S-CUSTOMER-TYPE                                                  
MFA-TR*      ,:S-TITLE-PREFIX                                                   
MFA-TR*      ,:S-FIRST-NAME                                                     
MFA-TR*      ,:S-MIDDLE-NAME                                                    
MFA-TR*      ,:S-LAST-NAME                                                      
MFA-TR*      ,:S-TITLE-SUFFIX                                                   
MFA-TR*      ,:S-BUSINESS-NAME                                                  
MFA-TR*      ,:S-NICKNAME                                                       
MFA-TR*      ,:S-CUST-HOME-PHONE                                                
MFA-TR*      ,:S-CUST-BUS-PHONE                                                 
MFA-TR*      ,:S-CUST-OCCUP                                                     
MFA-TR*      ,:S-CUST-WORK-PHONE                                                
MFA-TR*      ,:S-CUST-WORK-PHONE-EXT                                            
MFA-TR*      ,:S-CUST-EMPLOYER                                                  
MFA-TR*      ,:S-EMPLOYED-DATE                                                  
MFA-TR*      ,:S-EMPLOYEE-NBR                                                   
MFA-TR*      ,:S-CUST-SSN                                                       
MFA-TR*      ,:S-DATE-OF-BIRTH                                                  
MFA-TR*      ,:S-LICENSE-NO                                                     
MFA-TR*      ,:S-CODE-STATE-ID                                                  
MFA-TR*      ,:S-DRVR-LIC-ISS-DT                                                
MFA-TR*      ,:S-OTHER-ID-TYPE                                                  
MFA-TR*      ,:S-OTHER-ID                                                       
MFA-TR*      ,:S-ALIAS                                                          
MFA-TR*      ,:S-TAX-ID                                                         
MFA-TR*      ,:S-COMPANY-IND                                                    
MFA-TR*      ,:S-BUSINESS-TYPE-CD                                               
MFA-TR*      ,:S-CONTRACTOR-TYPE                                                
MFA-TR*      ,:S-CONSULTING-PROJ                                                
MFA-TR*      ,:S-CONSLT-PRJ-END-DT                                              
MFA-TR*      ,:S-READ-CYCLE                                                     
MFA-TR*      ,:S-SERV-STRT-DT                                                   
MFA-TR*      ,:S-DEP-INTST-RT                                                   
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE SQLCODE             TO ABEND-SQLCODE                
               MOVE SQLSTATE            TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04308_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
      *                                                                 00002000
       8100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************00000100
      * 8000A-DELETE-GTT-ROWS.                                         *00000200
      ******************************************************************00000300
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00000500
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 00000900
            EXEC SQL                                                    
                DELETE FROM #CSR04308_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04308_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04308_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00003400
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
      ******************************************************************23620000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     23630000
      ******************************************************************23640000
           EXEC SQL                                                     23650000
              INCLUDE CPDSP300                                          23660000
           END-EXEC.                                                    23670000
                                                                        
