       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04307.                                         
COB303 DATE-WRITTEN.      OCT 08, 2009.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES THE ROOMATE & CO-APPLICANT DETAILS.    *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
A37666*  10/08/09    SV95326  NEW PROGRAM FOR ARCHIVE ACCOUNT.         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04307'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR04307 STARTS HERE'.                  
                                                                        
      ******************************************************************00550000
      *    DB2 INCLUDES                                                *00560000
      ******************************************************************00570000
                                                                        
           EXEC SQL                                                     00590000
              INCLUDE SQLCA                                             00600000
           END-EXEC.                                                    00610000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBCUST                                            00640000
           END-EXEC.                                                    00650000
                                                                        
           EXEC SQL                                                     00670000
              INCLUDE TBCSTSTS                                          00680000
           END-EXEC.                                                    00690000
                                                                        
           EXEC SQL                                                     00710000
              INCLUDE TBBSCSTS                                          00720000
           END-EXEC.                                                    00730000
                                                                        
           EXEC SQL                                                     00771000
              INCLUDE TBNAME                                            00772000
           END-EXEC.                                                    00773000
                                                                        
           EXEC SQL                                                     00781000
              INCLUDE TBCSTMSC                                          00782000
           END-EXEC.                                                    00783000
                                                                        
           EXEC SQL                                                     00783200
              INCLUDE TBCSTPHN                                          00783300
           END-EXEC.                                                    00783400
                                                                        
           EXEC SQL                                                     00790000
              INCLUDE TBMODEL                                           00800000
           END-EXEC.                                                    00810000
                                                                        
           EXEC SQL                                                     00785001
              INCLUDE TBHACCT                                           00786001
           END-EXEC.                                                    00787001
                                                                        
           EXEC SQL                                                     00785001
              INCLUDE TBUTLENV                                          00786001
           END-EXEC.                                                    00787001
                                                                        
           EXEC SQL                                                     00785001
              INCLUDE TBRTDESC                                          00786001
           END-EXEC.                                                    00787001
                                                                        
           EXEC SQL                                                     00785001
              INCLUDE TBCSTEML                                          00786001
           END-EXEC.                                                    00787001
                                                                        
      ******************************************************************00830000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00840000
      ******************************************************************00850000
                                                                        
           COPY CCA00001.                                               00890000
           COPY CWS00027.                                               00910000
           COPY CWS00303.                                               00920000
                                                                        
      ******************************************************************00940000
      *    WORK AREAS                                                  *00950000
      ******************************************************************00960000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-CUSTOMER-NO        PIC X(10)      VALUE SPACES.     
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
           05  RS-CUSTOMER-EST-DATE    PIC X(08) VALUE SPACES.          
           05  RS-REV-PROT-IND         PIC X(01) VALUE 'N'.             
           05  RS-SERV-EST-DATE        PIC X(08) VALUE SPACES.          
           05  RS-CUSTOMER-TYPE        PIC X(01) VALUE SPACES.          
           05  RS-FIRST-NAME           PIC X(15) VALUE SPACES.          
           05  RS-MIDDLE-NAME          PIC X(15) VALUE SPACES.          
           05  RS-LAST-NAME            PIC X(40) VALUE SPACES.          
           05  RS-NICKNAME             PIC X(50) VALUE SPACES.          
           05  RS-TITLE-PREFIX         PIC X(09) VALUE SPACES.          
           05  RS-TITLE-SUFFIX         PIC X(03) VALUE SPACES.          
           05  RS-BUSINESS-NAME        PIC X(70) VALUE SPACES.          
           05  RS-CUST-OCCUP           PIC X(15) VALUE SPACES.          
           05  RS-CUST-WORK-PHONE      PIC X(10) VALUE SPACES.          
           05  RS-CUST-WORK-PHONE-EXT  PIC X(06) VALUE SPACES.          
           05  RS-CUST-HOME-PHONE      PIC X(10) VALUE SPACES.          
           05  RS-CUST-BUS-PHONE       PIC X(10) VALUE SPACES.          
           05  RS-CUST-EMPLOYER        PIC X(23) VALUE SPACES.          
           05  RS-EMPLOYED-DATE        PIC X(08) VALUE SPACES.          
           05  RS-EMPLOYEE-NBR         PIC X(05) VALUE SPACES.          
           05  RS-CUST-SSN             PIC X(09) VALUE SPACES.          
           05  RS-CODE-STATE-ID        PIC X(02) VALUE SPACES.          
           05  RS-LICENSE-NO           PIC X(19) VALUE SPACES.          
           05  RS-DATE-OF-BIRTH        PIC X(08) VALUE SPACES.          
           05  RS-DRVR-LIC-ISS-DT      PIC X(08) VALUE SPACES.          
           05  RS-OTHER-ID-TYPE        PIC X(12) VALUE SPACES.          
           05  RS-OTHER-ID             PIC X(16) VALUE SPACES.          
           05  RS-ALIAS                PIC X(07) VALUE SPACES.          
           05  RS-TAX-ID               PIC X(09) VALUE SPACES.          
           05  RS-COMPANY-IND          PIC X(01) VALUE SPACES.          
           05  RS-BUSINESS-TYPE-CD     PIC X(01) VALUE SPACES.          
           05  RS-CONTRACTOR-TYPE      PIC X(30) VALUE SPACES.          
           05  RS-CONSULTING-PROJ      PIC X(30) VALUE SPACES.          
           05  RS-CONSLT-PRJ-END-DT    PIC X(08) VALUE SPACES.          
           05  RS-LOCAL-OFFICE         PIC X(03) VALUE SPACES.          
           05  RS-REFUSED-SSN-FL       PIC X(01) VALUE SPACES.          
           05  RS-CUST-ALT-PHONE       PIC X(10) VALUE SPACES.          
           05  RS-EMAIL-ADDR           PIC X(100) VALUE SPACES.         
           05  RS-EMAIL-DISP-PREF      PIC X(01) VALUE SPACES.          
           05  RS-PASSWORD             PIC X(16) VALUE SPACES.          
           05  RS-PASSWORD-HINT        PIC X(02) VALUE SPACES.          
           05  RS-LANGUAGE-PREF-CD     PIC X(02) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-CUSTOMER-NO           PIC X(10) VALUE SPACES.          
           05  S-CUSTOMER-EST-DATE     PIC X(08) VALUE SPACES.          
           05  S-REV-PROT-IND          PIC X(01) VALUE SPACES.          
           05  S-SERV-EST-DATE         PIC X(08) VALUE SPACES.          
           05  S-CUSTOMER-TYPE         PIC X(01) VALUE SPACES.          
           05  S-FIRST-NAME            PIC X(15) VALUE SPACES.          
           05  S-MIDDLE-NAME           PIC X(15) VALUE SPACES.          
           05  S-LAST-NAME             PIC X(40) VALUE SPACES.          
           05  S-NICKNAME              PIC X(50) VALUE SPACES.          
           05  S-TITLE-PREFIX          PIC X(09) VALUE SPACES.          
           05  S-TITLE-SUFFIX          PIC X(03) VALUE SPACES.          
           05  S-BUSINESS-NAME         PIC X(70) VALUE SPACES.          
           05  S-CUST-OCCUP            PIC X(15) VALUE SPACES.          
           05  S-CUST-WORK-PHONE       PIC X(10) VALUE SPACES.          
           05  S-CUST-WORK-PHONE-EXT   PIC X(06) VALUE SPACES.          
           05  S-CUST-HOME-PHONE       PIC X(10) VALUE SPACES.          
           05  S-CUST-BUS-PHONE        PIC X(10) VALUE SPACES.          
           05  S-CUST-EMPLOYER         PIC X(23) VALUE SPACES.          
           05  S-EMPLOYED-DATE         PIC X(08) VALUE SPACES.          
           05  S-EMPLOYEE-NBR          PIC X(05) VALUE SPACES.          
           05  S-CUST-SSN              PIC X(09) VALUE SPACES.          
           05  S-CODE-STATE-ID         PIC X(02) VALUE SPACES.          
           05  S-LICENSE-NO            PIC X(19) VALUE SPACES.          
           05  S-DATE-OF-BIRTH         PIC X(08) VALUE SPACES.          
           05  S-DRVR-LIC-ISS-DT       PIC X(08) VALUE SPACES.          
           05  S-OTHER-ID-TYPE         PIC X(12) VALUE SPACES.          
           05  S-OTHER-ID              PIC X(16) VALUE SPACES.          
           05  S-ALIAS                 PIC X(07) VALUE SPACES.          
           05  S-TAX-ID                PIC X(09) VALUE SPACES.          
           05  S-COMPANY-IND           PIC X(01) VALUE SPACES.          
           05  S-BUSINESS-TYPE-CD      PIC X(01) VALUE SPACES.          
           05  S-CONTRACTOR-TYPE       PIC X(30) VALUE SPACES.          
           05  S-CONSULTING-PROJ       PIC X(30) VALUE SPACES.          
           05  S-CONSLT-PRJ-END-DT     PIC X(08) VALUE SPACES.          
           05  S-LOCAL-OFFICE          PIC X(03) VALUE SPACES.          
           05  S-REFUSED-SSN-FL        PIC X(01) VALUE SPACES.          
           05  S-CUST-ALT-PHONE        PIC X(10) VALUE SPACES.          
           05  S-EMAIL-ADDR            PIC X(100) VALUE SPACES.         
           05  S-EMAIL-DISP-PREF       PIC X(01) VALUE SPACES.          
           05  S-PASSWORD              PIC X(16) VALUE SPACES.          
           05  S-PASSWORD-HINT         PIC X(02) VALUE SPACES.          
           05  S-LANGUAGE-PREF-CD      PIC X(02) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-SELECT-DATE-FORM.                                         
           10  WS-SELECT-YEAR          PIC X(04) VALUE SPACES.          
           10  FILLER                  PIC X(01) VALUE SPACES.          
           10  WS-SELECT-MONTH         PIC X(02) VALUE SPACES.          
           10  FILLER                  PIC X(01) VALUE SPACES.          
           10  WS-SELECT-DAY           PIC X(02) VALUE SPACES.          
                                                                        
       01  WS-RETURN-DATE-FORM.                                         
           10  WS-RETURN-MONTH         PIC X(02) VALUE SPACES.          
           10  WS-RETURN-DAY           PIC X(02) VALUE SPACES.          
           10  WS-RETURN-YEAR          PIC X(04) VALUE SPACES.          
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR04307'.    
           05  WS-Y                    PIC X(01).                       
           05  WS-FOUND-MANY           PIC S9(09) COMP VALUE -811.      
COB305     05 WS-CUSTOMER-NO-NUM        PIC S9(10)V COMP-3 VALUE 0.             
           05  WS-NULL-EMP-DT          PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CNSLT-END-DT    PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-SERV-EST-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-CUST-EST-DT     PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-BIRTH-DT        PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-DRV-LIC-DT      PIC S9(04)  COMP VALUE ZERO.     
           05  WS-NULL-VISIT-DT        PIC S9(04)  COMP VALUE ZERO.     
           05  WS-CUST-NAME-TYPE       PIC X(02)   VALUE 'CN'.          
           05  WS-CUST-NAME-FORMAT     PIC X(01)   VALUE 'I'.           
           05  WS-CUST-CUSTOMER-TYPE   PIC X(01)   VALUE 'C'.           
           05  WS-PHONE-TYPE           PIC X(02)   VALUE SPACES.        
           05  WS-WORK-PHONE-TYPE      PIC X(02)   VALUE 'W1'.          
           05  WS-HOME-PHONE-TYPE      PIC X(02)   VALUE 'H1'.          
           05  WS-ALT-PHONE-TYPE       PIC X(02)   VALUE 'A1'.          
           05  WS-BUS-PHONE-TYPE       PIC X(02)   VALUE 'B1'.          
           05  WS-INACTIVE-NAME-IDI    PIC S9(13)V COMP-3 VALUE         
                                                   1800000000002.       
           05  WS-INACTIVE-NAME-IDB    PIC S9(13)V COMP-3 VALUE         
                                                   1800000100001.       
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10)                .          
       01  LINK-CUSTOMER-NO-RED     PIC 9(10)                .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO                                        
               .                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************02730000
      * 0000-MAINLINE                                                  *02740000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02750000
      ******************************************************************02760000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02880000
      * 0100-INITIALIZE                                                *02890000
      *                                                                *02900000
      *     1. RESET DB2 ERROR HANDLERS                                *02910000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02920000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02930000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02940000
      *                                                                *02950000
      ******************************************************************02960000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE              AS    RETURN_CODE             
             ,:S-CUSTOMER-NO              AS    CUSTOMER_NO             
             ,:S-REV-PROT-IND             AS    REV_PROT_IND            
             ,:S-CUSTOMER-EST-DATE        AS    CUSTOMER_EST_DATE       
             ,LTRIM(RTRIM(:S-SERV-EST-DATE))     AS    SERVICE_EST_DATE        
             ,:S-CUSTOMER-TYPE            AS    CUSTOMER_TYPE           
             ,LTRIM(RTRIM(:S-TITLE-PREFIX))      AS    PREFIX                  
             ,LTRIM(RTRIM(:S-FIRST-NAME))        AS    FIRST_NAME              
             ,LTRIM(RTRIM(:S-MIDDLE-NAME))       AS    MIDDLE_NAME             
             ,LTRIM(RTRIM(:S-LAST-NAME))         AS    LAST_NAME               
             ,LTRIM(RTRIM(:S-TITLE-SUFFIX))      AS    SUFFIX                  
             ,LTRIM(RTRIM(:S-BUSINESS-NAME))     AS    BUSINESS_NAME           
             ,LTRIM(RTRIM(:S-NICKNAME))          AS    NICKNAME                
             ,LTRIM(RTRIM(:S-CUST-HOME-PHONE))   AS    CUST_HOME_PHONE         
             ,LTRIM(RTRIM(:S-CUST-BUS-PHONE))    AS    CUST_BUS_PHONE          
             ,LTRIM(RTRIM(:S-CUST-OCCUP))        AS    CUST_OCCUP              
             ,LTRIM(RTRIM(:S-CUST-WORK-PHONE))   AS    CUST_WORK_PHONE         
             ,LTRIM(RTRIM(:S-CUST-WORK-PHONE-EXT)) AS    
           CUST_WORK_PHONE_EX    
             ,LTRIM(RTRIM(:S-CUST-EMPLOYER))     AS    CUST_EMPLOYER           
             ,LTRIM(RTRIM(:S-EMPLOYED-DATE))     AS    EMPLOYED_DATE           
             ,LTRIM(RTRIM(:S-EMPLOYEE-NBR))      AS    EMPLOYEE_NBR            
             ,LTRIM(RTRIM(:S-CUST-SSN))          AS    CUST_SSN                
             ,LTRIM(RTRIM(:S-DATE-OF-BIRTH))     AS    DATE_OF_BIRTH           
             ,LTRIM(RTRIM(:S-LICENSE-NO))        AS    LICENSE_NO              
             ,:S-CODE-STATE-ID            AS    CODE_STATE_ID           
             ,LTRIM(RTRIM(:S-DRVR-LIC-ISS-DT))   AS    DRVR_LIC_ISS_DT         
             ,LTRIM(RTRIM(:S-OTHER-ID-TYPE))     AS    OTHER_ID_TYPE           
             ,LTRIM(RTRIM(:S-OTHER-ID))          AS    OTHER_ID                
             ,LTRIM(RTRIM(:S-ALIAS))             AS    ALIAS                   
             ,LTRIM(RTRIM(:S-TAX-ID))            AS    TAX_ID                  
             ,LTRIM(RTRIM(:S-COMPANY-IND))       AS    COMPANY_IND             
             ,LTRIM(RTRIM(:S-BUSINESS-TYPE-CD))  AS    BUSINESS_TYPE_CD        
             ,LTRIM(RTRIM(:S-CONTRACTOR-TYPE))   AS    CONTRACTOR_TYPE         
             ,LTRIM(RTRIM(:S-CONSULTING-PROJ))   AS    CONSULTING_PROJ         
             ,LTRIM(RTRIM(:S-CONSLT-PRJ-END-DT)) AS    CONSLT_PRJ_END_DT       
             ,LTRIM(RTRIM(:S-LOCAL-OFFICE))      AS    LOCAL_OFFICE            
             ,LTRIM(RTRIM(:S-REFUSED-SSN-FL))    AS    REFUSED_SSN             
             ,LTRIM(RTRIM(:S-CUST-ALT-PHONE))    AS    CUST_ALT_PHONE          
             ,LTRIM(RTRIM(:S-EMAIL-ADDR))        AS    EMAIL_ADDR              
             ,LTRIM(RTRIM(:S-EMAIL-DISP-PREF))   AS    EMAIL_DISP_PREF         
             ,LTRIM(RTRIM(:S-PASSWORD))          AS    PASSWORD                
             ,LTRIM(RTRIM(:S-PASSWORD-HINT))     AS    PASSWORD_HINT           
             ,LTRIM(RTRIM(:S-LANGUAGE-PREF-CD))  AS    LANGUAGE_PREF_CD        
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-CUSTOMER-NO              AS    CUSTOMER_NO                     
MFA-TR*      ,:S-REV-PROT-IND             AS    REV_PROT_IND                    
MFA-TR*      ,:S-CUSTOMER-EST-DATE        AS    CUSTOMER_EST_DATE               
MFA-TR*      ,STRIP(:S-SERV-EST-DATE)     AS    SERVICE_EST_DATE                
MFA-TR*      ,:S-CUSTOMER-TYPE            AS    CUSTOMER_TYPE                   
MFA-TR*      ,STRIP(:S-TITLE-PREFIX)      AS    PREFIX                          
MFA-TR*      ,STRIP(:S-FIRST-NAME)        AS    FIRST_NAME                      
MFA-TR*      ,STRIP(:S-MIDDLE-NAME)       AS    MIDDLE_NAME                     
MFA-TR*      ,STRIP(:S-LAST-NAME)         AS    LAST_NAME                       
MFA-TR*      ,STRIP(:S-TITLE-SUFFIX)      AS    SUFFIX                          
MFA-TR*      ,STRIP(:S-BUSINESS-NAME)     AS    BUSINESS_NAME                   
MFA-TR*      ,STRIP(:S-NICKNAME)          AS    NICKNAME                        
MFA-TR*      ,STRIP(:S-CUST-HOME-PHONE)   AS    CUST_HOME_PHONE                 
MFA-TR*      ,STRIP(:S-CUST-BUS-PHONE)    AS    CUST_BUS_PHONE                  
MFA-TR*      ,STRIP(:S-CUST-OCCUP)        AS    CUST_OCCUP                      
MFA-TR*      ,STRIP(:S-CUST-WORK-PHONE)   AS    CUST_WORK_PHONE                 
MFA-TR*      ,STRIP(:S-CUST-WORK-PHONE-EXT) AS    CUST_WORK_PHONE_EX            
MFA-TR*      ,STRIP(:S-CUST-EMPLOYER)     AS    CUST_EMPLOYER                   
MFA-TR*      ,STRIP(:S-EMPLOYED-DATE)     AS    EMPLOYED_DATE                   
MFA-TR*      ,STRIP(:S-EMPLOYEE-NBR)      AS    EMPLOYEE_NBR                    
MFA-TR*      ,STRIP(:S-CUST-SSN)          AS    CUST_SSN                        
MFA-TR*      ,STRIP(:S-DATE-OF-BIRTH)     AS    DATE_OF_BIRTH                   
MFA-TR*      ,STRIP(:S-LICENSE-NO)        AS    LICENSE_NO                      
MFA-TR*      ,:S-CODE-STATE-ID            AS    CODE_STATE_ID                   
MFA-TR*      ,STRIP(:S-DRVR-LIC-ISS-DT)   AS    DRVR_LIC_ISS_DT                 
MFA-TR*      ,STRIP(:S-OTHER-ID-TYPE)     AS    OTHER_ID_TYPE                   
MFA-TR*      ,STRIP(:S-OTHER-ID)          AS    OTHER_ID                        
MFA-TR*      ,STRIP(:S-ALIAS)             AS    ALIAS                           
MFA-TR*      ,STRIP(:S-TAX-ID)            AS    TAX_ID                          
MFA-TR*      ,STRIP(:S-COMPANY-IND)       AS    COMPANY_IND                     
MFA-TR*      ,STRIP(:S-BUSINESS-TYPE-CD)  AS    BUSINESS_TYPE_CD                
MFA-TR*      ,STRIP(:S-CONTRACTOR-TYPE)   AS    CONTRACTOR_TYPE                 
MFA-TR*      ,STRIP(:S-CONSULTING-PROJ)   AS    CONSULTING_PROJ                 
MFA-TR*      ,STRIP(:S-CONSLT-PRJ-END-DT) AS    CONSLT_PRJ_END_DT               
MFA-TR*      ,STRIP(:S-LOCAL-OFFICE)      AS    LOCAL_OFFICE                    
MFA-TR*      ,STRIP(:S-REFUSED-SSN-FL)    AS    REFUSED_SSN                     
MFA-TR*      ,STRIP(:S-CUST-ALT-PHONE)    AS    CUST_ALT_PHONE                  
MFA-TR*      ,STRIP(:S-EMAIL-ADDR)        AS    EMAIL_ADDR                      
MFA-TR*      ,STRIP(:S-EMAIL-DISP-PREF)   AS    EMAIL_DISP_PREF                 
MFA-TR*      ,STRIP(:S-PASSWORD)          AS    PASSWORD                        
MFA-TR*      ,STRIP(:S-PASSWORD-HINT)     AS    PASSWORD_HINT                   
MFA-TR*      ,STRIP(:S-LANGUAGE-PREF-CD)  AS    LANGUAGE_PREF_CD                
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03240000
      * 1000-PROCESS-INPUT                                             *03250000
      *                                                                *03260000
      *     RECEIVE PARMS FROM THE CALLING STORED PROCEDURE.           *03270000
      *                                                                *03280000
      ******************************************************************03290000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO      TO RS-CUSTOMER-NO.                
           MOVE PARM-CUSTOMER-NO-RED  TO WS-CUSTOMER-NO-NUM.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      03580000
      *   2000-PROCESS-OUTPUT                                    *      03590000
      *                                                          *      03600000
      *   1. DESCRIBE RESULT SET                                 *      03610000
      *   2. RETRIEVE DB2 DATA AND BUILD RESULT SET              *      03620000
      *   3. SEND RESULT SET                                     *      03630000
      *                                                          *      03640000
      ************************************************************      03650000
       2000-PROCESS-OUTPUT.                                             
                                                                        
            PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                
            MOVE '2000'          TO ACTIVE-PARAGRAPH.                   
            PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.               
            PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03760000
      *2000A-MOVE-RESULT.                                               03760000
      ******************************************************************03760000
       2000A-MOVE-RESULT.                                               
      *                                                                 03760000
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-CUSTOMER-NO         TO S-CUSTOMER-NO.                
           MOVE RS-CUSTOMER-EST-DATE   TO S-CUSTOMER-EST-DATE.          
           MOVE RS-REV-PROT-IND        TO S-REV-PROT-IND.               
           MOVE RS-SERV-EST-DATE       TO S-SERV-EST-DATE.              
           MOVE RS-CUSTOMER-TYPE       TO S-CUSTOMER-TYPE.              
           MOVE RS-FIRST-NAME          TO S-FIRST-NAME.                 
           MOVE RS-MIDDLE-NAME         TO S-MIDDLE-NAME.                
           MOVE RS-LAST-NAME           TO S-LAST-NAME.                  
           MOVE RS-NICKNAME            TO S-NICKNAME.                   
           MOVE RS-TITLE-PREFIX        TO S-TITLE-PREFIX.               
           MOVE RS-TITLE-SUFFIX        TO S-TITLE-SUFFIX.               
           MOVE RS-BUSINESS-NAME       TO S-BUSINESS-NAME.              
           MOVE RS-CUST-OCCUP          TO S-CUST-OCCUP.                 
           MOVE RS-CUST-WORK-PHONE     TO S-CUST-WORK-PHONE.            
           MOVE RS-CUST-WORK-PHONE-EXT TO S-CUST-WORK-PHONE-EXT.        
           MOVE RS-CUST-HOME-PHONE     TO S-CUST-HOME-PHONE.            
           MOVE RS-CUST-BUS-PHONE      TO S-CUST-BUS-PHONE.             
           MOVE RS-CUST-EMPLOYER       TO S-CUST-EMPLOYER.              
           MOVE RS-EMPLOYED-DATE       TO S-EMPLOYED-DATE.              
           MOVE RS-EMPLOYEE-NBR        TO S-EMPLOYEE-NBR.               
           MOVE RS-CUST-SSN            TO S-CUST-SSN.                   
           MOVE RS-CODE-STATE-ID       TO S-CODE-STATE-ID.              
           MOVE RS-LICENSE-NO          TO S-LICENSE-NO.                 
           MOVE RS-DATE-OF-BIRTH       TO S-DATE-OF-BIRTH.              
           MOVE RS-DRVR-LIC-ISS-DT     TO S-DRVR-LIC-ISS-DT.            
           MOVE RS-OTHER-ID-TYPE       TO S-OTHER-ID-TYPE.              
           MOVE RS-OTHER-ID            TO S-OTHER-ID.                   
           MOVE RS-ALIAS               TO S-ALIAS.                      
           MOVE RS-TAX-ID              TO S-TAX-ID.                     
           MOVE RS-COMPANY-IND         TO S-COMPANY-IND.                
           MOVE RS-BUSINESS-TYPE-CD    TO S-BUSINESS-TYPE-CD.           
           MOVE RS-CONTRACTOR-TYPE     TO S-CONTRACTOR-TYPE.            
           MOVE RS-CONSULTING-PROJ     TO S-CONSULTING-PROJ.            
           MOVE RS-CONSLT-PRJ-END-DT   TO S-CONSLT-PRJ-END-DT.          
           MOVE RS-LOCAL-OFFICE        TO S-LOCAL-OFFICE.               
           MOVE RS-REFUSED-SSN-FL      TO S-REFUSED-SSN-FL.             
           MOVE RS-CUST-ALT-PHONE      TO S-CUST-ALT-PHONE.             
           MOVE RS-EMAIL-ADDR          TO S-EMAIL-ADDR.                 
           MOVE RS-EMAIL-DISP-PREF     TO S-EMAIL-DISP-PREF.            
           MOVE RS-PASSWORD            TO S-PASSWORD.                   
           MOVE RS-PASSWORD-HINT       TO S-PASSWORD-HINT.              
           MOVE RS-LANGUAGE-PREF-CD    TO S-LANGUAGE-PREF-CD.           
      *                                                                 03760000
       2000A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************03760000
      ******************************************************************11460000
      *   2200-BUILD-RESULT                                            *11470000
      *                                                                *11480000
      *   1.  SELECT AND FORMAT ALL CUSTOMER DETAIL INFORMATION        *11500000
      *       TO BE RETURNED.                                          *11512000
      *                                                                *11520000
      ******************************************************************11530000
       2200-BUILD-RESULT.                                               
                                                                        
            PERFORM 7000-SELECT-CUSTOMER-DTLS   THRU 7000-EXIT.         
                                                                        
            PERFORM 7100-SELECT-RES-STATS       THRU 7100-EXIT.         
                                                                        
            PERFORM 7200-SELECT-BUS-STATS       THRU 7200-EXIT.         
                                                                        
            PERFORM 7300-SELECT-MISC-INFO       THRU 7300-EXIT.         
                                                                        
            MOVE WS-HOME-PHONE-TYPE     TO WS-PHONE-TYPE.               
            PERFORM 7400-SELECT-PHONE-NO     THRU 7400-EXIT.            
            IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                 
               MOVE CB-PHONE-NO         TO RS-CUST-HOME-PHONE           
            ELSE                                                        
               MOVE SPACES              TO RS-CUST-HOME-PHONE           
            END-IF.                                                     
                                                                        
            MOVE WS-WORK-PHONE-TYPE     TO WS-PHONE-TYPE.               
            PERFORM 7400-SELECT-PHONE-NO     THRU 7400-EXIT.            
            IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                 
               MOVE CB-PHONE-NO         TO RS-CUST-WORK-PHONE           
               MOVE CB-EXTENSION-NO     TO RS-CUST-WORK-PHONE-EXT       
            ELSE                                                        
               MOVE SPACES              TO RS-CUST-WORK-PHONE           
               MOVE SPACES              TO RS-CUST-WORK-PHONE-EXT       
            END-IF.                                                     
                                                                        
            MOVE WS-BUS-PHONE-TYPE      TO WS-PHONE-TYPE.               
            PERFORM 7400-SELECT-PHONE-NO     THRU 7400-EXIT.            
            IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                 
               MOVE CB-PHONE-NO         TO RS-CUST-BUS-PHONE            
            ELSE                                                        
               MOVE SPACES              TO RS-CUST-BUS-PHONE            
            END-IF.                                                     
                                                                        
            MOVE WS-ALT-PHONE-TYPE     TO WS-PHONE-TYPE.                
            PERFORM 7400-SELECT-PHONE-NO     THRU 7400-EXIT.            
            IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                 
               MOVE CB-PHONE-NO         TO RS-CUST-ALT-PHONE            
            ELSE                                                        
               MOVE SPACES              TO RS-CUST-ALT-PHONE            
            END-IF.                                                     
            PERFORM 7500-SELECT-EMAIL       THRU 7500-EXIT.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13260000
      *   7000-SELECT-CUSTOMER-DTLS.                                   *13270000
      *                                                                *13271000
      *   1.  DETERMINE NAME_ID BASED ON PASSED CUSTOMER_NO.           *13272000
      *       USE BOTH CUSTOMER_NO AND NAME_ID TO SELECT CUSTOMER      *13272100
      *       INFORMATION FROM CSS_CUSTOMER AND CSS_NAME TABLES.       *13273000
      ******************************************************************13280000
       7000-SELECT-CUSTOMER-DTLS.                                       
                                                                        
           EXEC SQL                                                     
              SELECT A.CUSTOMER_EST_DATE,                               
                     A.SERVICE_EST_DATE,                                
                     A.CUST_LAST_VISIT_DT,                              
                     A.LOCAL_OFFICE_ORIG,                               
                     B.NAME_FORMAT,                                     
                     B.FIRST_NAME,                                      
                     B.MIDDLE_NAME,                                     
                     B.LAST_NAME,                                       
                     B.NICKNAME,                                        
                     B.TITLE_PREFIX,                                    
                     B.TITLE_SUFFIX_1,                                  
                     B.FULL_NAME,                                       
                     B.NAME_ID                                          
                INTO :CU-CUSTOMER-EST-DATE :WS-NULL-CUST-EST-DT,         
                     :CU-SERVICE-EST-DATE :WS-NULL-SERV-EST-DT,          
                     :CU-CUST-LAST-VISIT-DT :WS-NULL-VISIT-DT,           
                     :CU-LOCAL-OFFICE-ORIG,                             
                     :DQ-NAME-FORMAT,                                   
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-NICKNAME,                                      
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-ID                                        
                FROM CSS_CUSTOMER A WITH(READUNCOMMITTED),                      
                     CSS_NAME B WITH(READUNCOMMITTED)                           
               WHERE A.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                
                 AND B.NAME_ID     =  A.NAME_ID                         
                 AND B.NAME_TYPE   = :WS-CUST-NAME-TYPE                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT A.CUSTOMER_EST_DATE,                               13330000
MFA-TR*              A.SERVICE_EST_DATE,                                13330200
MFA-TR*              A.CUST_LAST_VISIT_DT,                              13330300
MFA-TR*              A.LOCAL_OFFICE_ORIG,                               13330400
MFA-TR*              B.NAME_FORMAT,                                     13330700
MFA-TR*              B.FIRST_NAME,                                      13330800
MFA-TR*              B.MIDDLE_NAME,                                     13330900
MFA-TR*              B.LAST_NAME,                                       13331000
MFA-TR*              B.NICKNAME,                                        13331100
MFA-TR*              B.TITLE_PREFIX,                                    13332000
MFA-TR*              B.TITLE_SUFFIX_1,                                  13380000
MFA-TR*              B.FULL_NAME,                                       13390000
MFA-TR*              B.NAME_ID                                          13400000
MFA-TR*         INTO :CU-CUSTOMER-EST-DATE:WS-NULL-CUST-EST-DT,         13440101
MFA-TR*              :CU-SERVICE-EST-DATE:WS-NULL-SERV-EST-DT,          13440300
MFA-TR*              :CU-CUST-LAST-VISIT-DT:WS-NULL-VISIT-DT,           13440400
MFA-TR*              :CU-LOCAL-OFFICE-ORIG,                             13440500
MFA-TR*              :DQ-NAME-FORMAT,                                   13440700
MFA-TR*              :DQ-FIRST-NAME,                                    13440800
MFA-TR*              :DQ-MIDDLE-NAME,                                   13440900
MFA-TR*              :DQ-LAST-NAME,                                     13441000
MFA-TR*              :DQ-NICKNAME,                                      13441100
MFA-TR*              :DQ-TITLE-PREFIX,                                  13441200
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                13441300
MFA-TR*              :DQ-FULL-NAME,                                     13442000
MFA-TR*              :DQ-NAME-ID                                        13443000
MFA-TR*         FROM CSS_CUSTOMER A,                                    13550000
MFA-TR*              CSS_NAME B                                         13551000
MFA-TR*        WHERE A.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                13560000
MFA-TR*          AND B.NAME_ID     =  A.NAME_ID                         13561000
MFA-TR*          AND B.NAME_TYPE   = :WS-CUST-NAME-TYPE                 13562000
MFA-TR*         WITH UR                                                 13562000
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'CSS_CUSTOMER'       TO TABLE-2                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE WS-CUST-NAME-TYPE    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
           MOVE DQ-NAME-FORMAT         TO RS-CUSTOMER-TYPE.             
           MOVE DQ-NICKNAME            TO RS-NICKNAME.                  
           MOVE CU-LOCAL-OFFICE-ORIG   TO RS-LOCAL-OFFICE.              
                                                                        
           IF DQ-NAME-FORMAT = WS-CUST-NAME-FORMAT                      
              MOVE DQ-FIRST-NAME       TO RS-FIRST-NAME                 
              MOVE DQ-MIDDLE-NAME      TO RS-MIDDLE-NAME                
              MOVE DQ-LAST-NAME        TO RS-LAST-NAME                  
              MOVE DQ-TITLE-PREFIX     TO RS-TITLE-PREFIX               
              MOVE DQ-TITLE-SUFFIX-1   TO RS-TITLE-SUFFIX               
           ELSE                                                         
              MOVE DQ-FULL-NAME        TO RS-BUSINESS-NAME              
           END-IF.                                                      
                                                                        
           IF DQ-NAME-ID EQUAL WS-INACTIVE-NAME-IDI OR                  
              DQ-NAME-ID EQUAL WS-INACTIVE-NAME-IDB                     
              MOVE DQ-FIRST-NAME       TO RS-FIRST-NAME                 
              MOVE DQ-LAST-NAME        TO RS-LAST-NAME                  
           END-IF.                                                      
                                                                        
           IF WS-NULL-CUST-EST-DT = -1                                  
              MOVE SPACES               TO RS-CUSTOMER-EST-DATE         
           ELSE                                                         
              MOVE CU-CUSTOMER-EST-DATE TO WS-SELECT-DATE-FORM          
              MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR               
              MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH              
              MOVE WS-SELECT-DAY        TO WS-RETURN-DAY                
              MOVE WS-RETURN-DATE-FORM  TO RS-CUSTOMER-EST-DATE         
           END-IF.                                                      
                                                                        
           IF WS-NULL-SERV-EST-DT = -1                                  
              MOVE SPACES               TO RS-SERV-EST-DATE             
           ELSE                                                         
              MOVE CU-SERVICE-EST-DATE  TO WS-SELECT-DATE-FORM          
              MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR               
              MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH              
              MOVE WS-SELECT-DAY        TO WS-RETURN-DAY                
              MOVE WS-RETURN-DATE-FORM  TO RS-SERV-EST-DATE             
           END-IF.                                                      
                                                                        
           IF WS-NULL-VISIT-DT NOT EQUAL -1                             
              MOVE CU-CUST-LAST-VISIT-DT TO WS-SELECT-DATE-FORM         
              MOVE WS-SELECT-YEAR        TO WS-RETURN-YEAR              
              MOVE WS-SELECT-MONTH       TO WS-RETURN-MONTH             
              MOVE WS-SELECT-DAY         TO WS-RETURN-DAY               
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14140000
      *   7100-SELECT-RES-STATS                                        *14150000
      *                                                                *14151000
      *   1. SELECT RESIDENTIAL INFORMATION FROM CSS_CUST_STATS.       *14151100
      *                                                                *14152000
      ******************************************************************14160000
       7100-SELECT-RES-STATS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT SSN,                                               
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     EMPLOYED_DATE,                                     
                     OCCUPATION,                                        
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DRVR_LIC_ISS_DT,                                   
                     DATE_OF_BIRTH,                                     
                     EMPLOYEE_NBR,                                      
                     INTR_CO_IND,                                       
                     PASSWORD_HINT_CD,                                  
                     PASSWORD_TX,                                       
                     REFUSED_SSN_FL,                                    
                     LANGUAGE_PREF_CD                                   
                INTO :CE-SSN,                                           
                     :CE-CODE-STATE-ID,                                 
                     :CE-DRIVERS-LICENSE-NO,                            
                     :CE-EMPLOYER,                                      
                     :CE-EMPLOYED-DATE :WS-NULL-EMP-DT,                  
                     :CE-OCCUPATION,                                    
                     :CE-OTHER-ID-TYPE,                                 
                     :CE-OTHER-ID,                                      
                     :CE-DRVR-LIC-ISS-DT :WS-NULL-DRV-LIC-DT,            
                     :CE-DATE-OF-BIRTH :WS-NULL-BIRTH-DT,                
                     :CE-EMPLOYEE-NBR,                                  
                     :CE-INTR-CO-IND,                                   
                     :CE-PASSWORD-HINT-CD,                              
                     :CE-PASSWORD-TX,                                   
                     :CE-REFUSED-SSN-FL,                                
                     :CE-LANGUAGE-PREF-CD                               
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM                
                 AND CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*       SELECT SSN,                                               14210000
MFA-TR*              CODE_STATE_ID,                                     14240000
MFA-TR*              DRIVERS_LICENSE_NO,                                14250000
MFA-TR*              EMPLOYER,                                          14260000
MFA-TR*              EMPLOYED_DATE,                                     14270000
MFA-TR*              OCCUPATION,                                        14280000
MFA-TR*              OTHER_ID_TYPE,                                     14310000
MFA-TR*              OTHER_ID,                                          14320000
MFA-TR*              DRVR_LIC_ISS_DT,                                   14330000
MFA-TR*              DATE_OF_BIRTH,                                     14340000
MFA-TR*              EMPLOYEE_NBR,                                      14350000
MFA-TR*              INTR_CO_IND,                                       14370000
MFA-TR*              PASSWORD_HINT_CD,                                  14370000
MFA-TR*              PASSWORD_TX,                                       14370000
MFA-TR*              REFUSED_SSN_FL,                                    14370000
MFA-TR*              LANGUAGE_PREF_CD                                           
MFA-TR*         INTO :CE-SSN,                                           14380000
MFA-TR*              :CE-CODE-STATE-ID,                                 14410000
MFA-TR*              :CE-DRIVERS-LICENSE-NO,                            14420000
MFA-TR*              :CE-EMPLOYER,                                      14430000
MFA-TR*              :CE-EMPLOYED-DATE:WS-NULL-EMP-DT,                  14440000
MFA-TR*              :CE-OCCUPATION,                                    14450000
MFA-TR*              :CE-OTHER-ID-TYPE,                                 14480000
MFA-TR*              :CE-OTHER-ID,                                      14490000
MFA-TR*              :CE-DRVR-LIC-ISS-DT:WS-NULL-DRV-LIC-DT,            14500000
MFA-TR*              :CE-DATE-OF-BIRTH:WS-NULL-BIRTH-DT,                14510000
MFA-TR*              :CE-EMPLOYEE-NBR,                                  14520000
MFA-TR*              :CE-INTR-CO-IND,                                   14540000
MFA-TR*              :CE-PASSWORD-HINT-CD,                              14540000
MFA-TR*              :CE-PASSWORD-TX,                                   14540000
MFA-TR*              :CE-REFUSED-SSN-FL,                                14540000
MFA-TR*              :CE-LANGUAGE-PREF-CD                                       
MFA-TR*         FROM CSS_CUST_STATS                                     14550000
MFA-TR*        WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM                14560000
MFA-TR*          AND CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE             14561000
MFA-TR*         WITH UR                                                 13562000
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE WS-CUST-CUSTOMER-TYPE TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CE-SSN                TO RS-CUST-SSN                 
              MOVE CE-CODE-STATE-ID      TO RS-CODE-STATE-ID            
              MOVE CE-DRIVERS-LICENSE-NO TO RS-LICENSE-NO               
              MOVE CE-EMPLOYER           TO RS-CUST-EMPLOYER            
              MOVE CE-OCCUPATION         TO RS-CUST-OCCUP               
              MOVE CE-OTHER-ID-TYPE      TO RS-OTHER-ID-TYPE            
              MOVE CE-OTHER-ID           TO RS-OTHER-ID                 
              MOVE CE-EMPLOYEE-NBR       TO RS-EMPLOYEE-NBR             
              MOVE CE-PASSWORD-HINT-CD   TO RS-PASSWORD-HINT            
              MOVE CE-PASSWORD-TX        TO RS-PASSWORD                 
              MOVE CE-REFUSED-SSN-FL     TO RS-REFUSED-SSN-FL           
              MOVE CE-LANGUAGE-PREF-CD   TO RS-LANGUAGE-PREF-CD         
                                                                        
              IF WS-NULL-EMP-DT = -1                                    
                 MOVE SPACES             TO RS-EMPLOYED-DATE            
              ELSE                                                      
                 MOVE CE-EMPLOYED-DATE    TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO RS-EMPLOYED-DATE           
              END-IF                                                    
                                                                        
              IF WS-NULL-DRV-LIC-DT = -1                                
                 MOVE SPACES             TO RS-DRVR-LIC-ISS-DT          
              ELSE                                                      
                 MOVE CE-DRVR-LIC-ISS-DT  TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO RS-DRVR-LIC-ISS-DT         
              END-IF                                                    
                                                                        
              IF WS-NULL-BIRTH-DT = -1                                  
                 MOVE SPACES             TO RS-DATE-OF-BIRTH            
              ELSE                                                      
                 MOVE CE-DATE-OF-BIRTH    TO WS-SELECT-DATE-FORM        
                 MOVE WS-SELECT-YEAR      TO WS-RETURN-YEAR             
                 MOVE WS-SELECT-MONTH     TO WS-RETURN-MONTH            
                 MOVE WS-SELECT-DAY       TO WS-RETURN-DAY              
                 MOVE WS-RETURN-DATE-FORM TO RS-DATE-OF-BIRTH           
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE SPACES                 TO RS-CUST-SSN                
              MOVE SPACES                 TO RS-CODE-STATE-ID           
              MOVE SPACES                 TO RS-LICENSE-NO              
              MOVE SPACES                 TO RS-CUST-EMPLOYER           
              MOVE SPACES                 TO RS-CUST-OCCUP              
              MOVE SPACES                 TO RS-OTHER-ID-TYPE           
              MOVE SPACES                 TO RS-OTHER-ID                
              MOVE SPACES                 TO RS-EMPLOYEE-NBR            
              MOVE SPACES                 TO RS-EMPLOYED-DATE           
              MOVE SPACES                 TO RS-DRVR-LIC-ISS-DT         
              MOVE SPACES                 TO RS-DATE-OF-BIRTH           
              MOVE SPACES                 TO RS-PASSWORD-HINT           
              MOVE SPACES                 TO RS-PASSWORD                
              MOVE SPACES                 TO RS-REFUSED-SSN-FL          
              MOVE SPACES                 TO RS-LANGUAGE-PREF-CD        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14770000
      *   7200-SELECT-BUS-STATS.                                       *14780000
      *                                                                *14781000
      *   1. SELECT BUSINESS INFORMATION FROM CSS_BUS_CUST_STATS.      *14781100
      *                                                                *14783000
      ******************************************************************14790000
       7200-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT BUSINESS_TYPE_CD,                                  
                     TAX_ID,                                            
                     ALIAS,                                             
                     INTRA_CO_IND,                                      
                     SUBSIDIARY_IND,                                    
                     TRADE_ALLY_IND,                                    
                     CONTRACTOR_TYPE                                    
                INTO :BS-BUSINESS-TYPE-CD,                              
                     :BS-TAX-ID,                                        
                     :BS-ALIAS,                                         
                     :BS-INTRA-CO-IND,                                  
                     :BS-SUBSIDIARY-IND,                                
                     :BS-TRADE-ALLY-IND,                                
                     :BS-CONTRACTOR-TYPE                                
                FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14830000
MFA-TR*       SELECT BUSINESS_TYPE_CD,                                  14850000
MFA-TR*              TAX_ID,                                            14851000
MFA-TR*              ALIAS,                                             14860000
MFA-TR*              INTRA_CO_IND,                                      14870000
MFA-TR*              SUBSIDIARY_IND,                                    14880000
MFA-TR*              TRADE_ALLY_IND,                                    14890000
MFA-TR*              CONTRACTOR_TYPE                                    14900000
MFA-TR*         INTO :BS-BUSINESS-TYPE-CD,                              14930000
MFA-TR*              :BS-TAX-ID,                                        14931000
MFA-TR*              :BS-ALIAS,                                         14940000
MFA-TR*              :BS-INTRA-CO-IND,                                  14950000
MFA-TR*              :BS-SUBSIDIARY-IND,                                14960000
MFA-TR*              :BS-TRADE-ALLY-IND,                                14970000
MFA-TR*              :BS-CONTRACTOR-TYPE                                14980000
MFA-TR*         FROM CSS_BUS_CUST_STATS                                 15000000
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  15010000
MFA-TR*         WITH UR                                                 13562000
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                    15020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BS-BUSINESS-TYPE-CD   TO RS-BUSINESS-TYPE-CD         
              MOVE BS-TAX-ID             TO RS-TAX-ID                   
              MOVE BS-ALIAS              TO RS-ALIAS                    
              MOVE BS-CONTRACTOR-TYPE    TO RS-CONTRACTOR-TYPE          
                                                                        
              IF BS-INTRA-CO-IND = 'Y'                                  
                 MOVE 'I'                TO RS-COMPANY-IND              
              ELSE                                                      
                 IF BS-SUBSIDIARY-IND = 'Y'                             
                    MOVE 'S'             TO RS-COMPANY-IND              
                 ELSE                                                   
                    IF BS-TRADE-ALLY-IND = 'Y'                          
                       MOVE 'T'          TO RS-COMPANY-IND              
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
           ELSE                                                         
              MOVE SPACES                TO RS-BUSINESS-TYPE-CD         
              MOVE SPACES                TO RS-TAX-ID                   
              MOVE SPACES                TO RS-ALIAS                    
              MOVE SPACES                TO RS-CONTRACTOR-TYPE          
              MOVE SPACES                TO RS-COMPANY-IND              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15201000
      *   7300-SELECT-MISC-INFO.                                       *15202000
      *                                                                *15202100
      *   1. SELECT CONSULTING PROJECT INFORMATION FROM CSS_MISC_INFO. *15202200
      *                                                                *15202300
      ******************************************************************15203000
       7300-SELECT-MISC-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CONSULTING_PROJECT,                                
                     CONSLT_PRJ_END_DT                                  
                INTO :LQ-CONSULTING-PROJECT,                            
                     :LQ-CONSLT-PRJ-END-DT :WS-NULL-CNSLT-END-DT         
                FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15210900
MFA-TR*       SELECT CONSULTING_PROJECT,                                15211000
MFA-TR*              CONSLT_PRJ_END_DT                                  15211200
MFA-TR*         INTO :LQ-CONSULTING-PROJECT,                            15211400
MFA-TR*              :LQ-CONSLT-PRJ-END-DT:WS-NULL-CNSLT-END-DT         15211600
MFA-TR*         FROM CSS_CUST_MISC_INFO                                 15211800
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  15211900
MFA-TR*         WITH UR                                                 13562000
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                    15212000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE LQ-CONSULTING-PROJECT   TO RS-CONSULTING-PROJ        
              IF WS-NULL-CNSLT-END-DT = -1                              
                 MOVE SPACES               TO RS-CONSLT-PRJ-END-DT      
              ELSE                                                      
                 MOVE LQ-CONSLT-PRJ-END-DT TO WS-SELECT-DATE-FORM       
                 MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR            
                 MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH           
                 MOVE WS-SELECT-DAY        TO WS-RETURN-DAY             
                 MOVE WS-RETURN-DATE-FORM  TO RS-CONSLT-PRJ-END-DT      
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                  TO RS-CONSULTING-PROJ        
              MOVE SPACES                  TO RS-CONSLT-PRJ-END-DT      
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15224200
      *   7400-SELECT-PHONE-NO.                                        *15224300
      *                                                                *15224400
      *   1. SELECTS PHONE NUMBERS BASED ON THE CUSTOMER NUMBER,       *15224500
      *      CUSTOMER TYPE AND PHONE TYPE.                             *15224600
      *                                                                *15224700
      ******************************************************************15224800
       7400-SELECT-PHONE-NO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PHONE_NO,                                          
                     EXTENSION_NO                                       
                INTO :CB-PHONE-NO,                                      
                     :CB-EXTENSION-NO                                   
                FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM                
                 AND PHONE_TYPE    = :WS-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT PHONE_NO,                                          15225200
MFA-TR*              EXTENSION_NO                                       15225300
MFA-TR*         INTO :CB-PHONE-NO,                                      15225400
MFA-TR*              :CB-EXTENSION-NO                                   15225500
MFA-TR*         FROM CSS_CUST_PHONE                                     15225600
MFA-TR*        WHERE CUSTOMER_NO   = :WS-CUSTOMER-NO-NUM                15225700
MFA-TR*          AND PHONE_TYPE    = :WS-PHONE-TYPE                     15225800
MFA-TR*          AND CUSTOMER_TYPE = :WS-CUST-CUSTOMER-TYPE             15225900
MFA-TR*         WITH UR                                                 13562000
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7400'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE WS-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE WS-CUST-CUSTOMER-TYPE TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15224200
      *   7500-SELECT-EMAIL                                            *15224300
      *                                                                *15224400
      *   1. SELECTS EMAIL INFORMATION FROM THE CUST_EMAIL TABLE       *15224500
      *                                                                *15224700
      ******************************************************************15224800
       7500-SELECT-EMAIL.                                               
                                                                        
           EXEC SQL                                                     
              SELECT EMAIL_DISP_PREF_CD,                                
                     EMAIL_ADDRESS_TX                                   
                INTO :RS-EMAIL-DISP-PREF,                               
                     :RS-EMAIL-ADDR                                     
                FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO      = :WS-CUSTOMER-NO-NUM             
                 AND EMAIL_TYPE_CD    = 'P1'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT EMAIL_DISP_PREF_CD,                                15225200
MFA-TR*              EMAIL_ADDRESS_TX                                           
MFA-TR*         INTO :RS-EMAIL-DISP-PREF,                               15225400
MFA-TR*              :RS-EMAIL-ADDR                                     15225400
MFA-TR*         FROM CSS_CUST_EMAIL                                     15225600
MFA-TR*        WHERE CUSTOMER_NO      = :WS-CUSTOMER-NO-NUM             15225700
MFA-TR*          AND EMAIL_TYPE_CD    = 'P1'                            15225800
MFA-TR*         WITH UR                                                 13562000
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES     TO    RS-EMAIL-DISP-PREF             
                   MOVE SPACES     TO    RS-EMAIL-ADDR                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7500'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15300000
      *       END PROGRAM COPYLIB                                      *15310000
      ******************************************************************15320000
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
      ******************************************************************15230000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     15240000
      ******************************************************************15250000
           EXEC SQL                                                     15260000
              INCLUDE CPDSP300                                          15270000
           END-EXEC.                                                    15280000
