       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04305.                                         
COB303 DATE-WRITTEN. SEPTEMBER 17, 2009                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00170000
      *                                                                *00180000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00210000
      *                                                                *00220000
      *                                                                *00260000
      ******************************************************************00270000
      *                 P R O G R A M  S U M M A R Y                   *00280000
      *                                                                *00290000
      *  THIS PROGRAM DOES THE FOLLOWING:                              *00300000
      *  1. INSERT INTO CSS_SPCL_BILL_MSG                              *00310000
      *                                                                *00330000
      ******************************************************************00340000
      *                                                                *00350000
      *                     PROGRAM MODIFICATION LOG                   *00360000
      *                                                                *00370000
      *    DATE    INITIALS   COMMENTS                                 *00380000
      *  --------  --------   ---------------------------------------  *00390000
P00222*  09/17/09  MS93554    INSERT ROW INTO CSS_SPCL_BILL_MSG TABLE*  00400003
      ******************************************************************00710000
      ******************************************************************00720000
      *                                                                *00730000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00740000
      *                                                                *00750000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00760000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00770000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00780000
      *  3000 - 4999  NOT USED                                         *00790000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00800000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00810000
      *  7000 - 7999  INPUT MODULES                                    *00820000
      *  8000 - 8999  OUTPUT MODULES                                   *00830000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00840000
      *                                                                *00850000
      ******************************************************************00860000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04305'.
MSQ017     COPY MFASQLM.
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04305 STARTS HERE'.                  
                                                                        
      ******************************************************************00950000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00960000
      ******************************************************************00970000
           COPY CWS00303.                                               00990000
           COPY CWS00132.                                               01065100
                                                                        
      ******************************************************************01070000
      *    WORK AREAS                                                  *01080000
      ******************************************************************01090000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04305'.     
           05  WS-REVENUE-MONTH-1       PIC X(06).                      
           05  FILLER REDEFINES WS-REVENUE-MONTH-1.                     
               10  WS-REVMTH-CCYY       PIC 9(04).                      
               10  WS-REVMTH-MM         PIC 9(02).                      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
                                                                        
      ******** SQL COMMUNICATION                                        01860000
           EXEC SQL                                                     01890000
              INCLUDE SQLCA                                             01900000
           END-EXEC.                                                    01910000
                                                                        
      ******** CSS_ACCOUNT                                              01921000
           EXEC SQL                                                     01930000
              INCLUDE TBACCT                                            01940000
           END-EXEC.                                                    01950000
                                                                        
      ******** CSS_SPCL_BILL_MSG                                        02001000
           EXEC SQL                                                     02010000
              INCLUDE TBSBLMSG                                          02020000
           END-EXEC.                                                    02030000
                                                                        
      ******** CSS_BILL_WINDOW                                          02140000
           EXEC SQL                                                     02150000
              INCLUDE TBBILWDW                                          02160000
           END-EXEC.                                                    02170000
                                                                        
           EXEC SQL                                                     02181000
               INCLUDE CWSX0010                                         02182000
           END-EXEC.                                                    02183000
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                PIC X(18) VALUE SPACES.         
           10  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
           10  S-SQLSTATE               PIC X(5)  VALUE ' '.            
           10  S-TABLE-NAME             PIC X(18) VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L   PIC S9(4) USAGE COMP.           
               49  S-HOST-VARIABLES-V   PIC X(255).                     
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L    PIC S9(4) USAGE COMP.           
               49  S-SQL-STATEMENT-V    PIC X(255).                     
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L  PIC S9(4) USAGE COMP.           
               49  S-SQL-DESCRIPTION-V  PIC X(255).                     
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L  PIC S9(4) USAGE COMP.           
               49  WS-ABEND-SQLERRMC-V  PIC X(255).                     
           10  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO              PIC X(13).                      
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-ACCOUNT-NO.                                        
                                                                        
                                                                        
      ******************************************************************02910000
      * 0000-MAINLINE                                                  *02920000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02930000
      ******************************************************************02940000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03050000
      * 0100-INITIALIZE                                                *03060000
      ******************************************************************03130000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR  
             SELECT :S-RETURN-CODE AS RETURN_CODE                       
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     03152000
MFA-TR*      DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR  03153000
MFA-TR*      SELECT :S-RETURN-CODE AS RETURN_CODE                       03154001
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                    03156001
MFA-TR*    END-EXEC.                                                    03157000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO                  TO WS-PARM-ACCOUNT-NO  
           MOVE WS-PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO.      
           MOVE WS-ACCOUNT-NO-NUM                TO WS-ACCOUNT-NO-COMP3.
           MOVE WS-ACCOUNT-NO-COMP3              TO AT-ACCOUNT-NO.      
                                                                        
           PERFORM 7000-SELECT-AT-DTLS           THRU 7000-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03380100
      * 2000-PROCESS-OUTPUT.                                           *03380200
      ******************************************************************03380900
       2000-PROCESS-OUTPUT.                                             
      *                                                                 03381100
           PERFORM 5510-MOVE-SPCL-BILL-MSG       THRU 5510-EXIT         
      *                                                                 03381400
           IF CTR-ROWS < 1                                              
              MOVE WS-ACTIVE-RETURN-CODE         TO RS-RETURN-CODE      
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03384000
      *2000A-MOVE-RESULT                                                03385000
      ******************************************************************03386000
       2000A-MOVE-RESULT.                                               
      *                                                                 03387100
           MOVE  RS-RETURN-CODE                  TO    S-RETURN-CODE.   
      *                                                                 03388100
       2000A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************            03390000
      * INSERTS ROW IN SPCL BILL MSG  TABLE                *            03400000
      ******************************************************            03410000
      *                                                                 03420000
       5510-MOVE-SPCL-BILL-MSG.                                         
      *                                                                 03440000
           MOVE AT-ACCOUNT-NO                    TO U1-ACCOUNT-NO       
           MOVE '95172'                          TO U1-BILL-MSG-ID      
           MOVE 'M'                              TO U1-MSG-TYPE-CD      
           MOVE AT-COMPANY-NO                    TO U1-COMPANY-NO       
           MOVE AT-REV-MTH-LST-NRML              TO WS-REVENUE-MONTH-1  
           IF AT-REV-MTH-LST-NRML > ZERO                                
              COMPUTE WS-REVMTH-MM  = WS-REVMTH-MM + 1                  
              IF WS-REVMTH-MM > 12                                      
                ADD  1                           TO WS-REVMTH-CCYY      
                COMPUTE WS-REVMTH-MM  = WS-REVMTH-MM - 12               
              END-IF                                                    
              MOVE WS-REVENUE-MONTH-1            TO U1-REVENUE-MO-ST    
                                                    U1-REVENUE-MO-END   
           ELSE                                                         
              MOVE AT-BILL-CYCLE                 TO BN-BILL-CYCLE       
              PERFORM 7100-GET-REV-MONTH         THRU 7100-EXIT         
              MOVE BN-REVENUE-MONTH              TO U1-REVENUE-MO-END   
                                                    U1-REVENUE-MO-ST    
           END-IF.                                                      
           MOVE 1                                 TO U1-BILL-CYCLE-ST.  
           MOVE 21                                TO U1-BILL-CYCLE-END. 
           PERFORM 8550-INSERT-BILL-MSG           THRU 8550-EXIT.       
      *                                                                 03640000
       5510-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************03670000
      * SELECT THE ACCOUNT DETAILS FROM CSS_ACCOUNT TABLE.              03670100
      ******************************************************************03670200
       7000-SELECT-AT-DTLS.                                             
           EXEC SQL                                                     
             SELECT AT.ACCOUNT_NO,                                      
                    AT.COMPANY_NO,                                      
                    AT.REV_MTH_LST_NRML,                                
                    AT.BILL_CYCLE                                       
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-COMPANY-NO,                                     
                    :AT-REV-MTH-LST-NRML,                               
                    :AT-BILL-CYCLE                                      
            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                           
            WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03690000
MFA-TR*      SELECT AT.ACCOUNT_NO,                                      03700000
MFA-TR*             AT.COMPANY_NO,                                      03770000
MFA-TR*             AT.REV_MTH_LST_NRML,                                03930000
MFA-TR*             AT.BILL_CYCLE                                       03940000
MFA-TR*        INTO :AT-ACCOUNT-NO,                                     03990000
MFA-TR*             :AT-COMPANY-NO,                                     04060000
MFA-TR*             :AT-REV-MTH-LST-NRML,                               04220000
MFA-TR*             :AT-BILL-CYCLE                                      04230000
MFA-TR*     FROM CSS_ACCOUNT AT                                         04280000
MFA-TR*     WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                        04290000
MFA-TR*     WITH UR                                                     04320000
MFA-TR*     QUERYNO 7000                                                04321001
MFA-TR*    END-EXEC.                                                    04330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'COMPANY_NO '             TO TABLE-2                 
              MOVE AT-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              MOVE 'REVENUE MON'             TO TABLE-3                 
              MOVE AT-REV-MTH-LST-NRML       TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04500000
      ******************************************************************04501000
      * GET THE REVENUE MONTH THE ACCOUNT.                              04502000
      ******************************************************************04503000
       7100-GET-REV-MONTH.                                              
           EXEC SQL                                                     
             SELECT TOP(1) REVENUE_MONTH                                      
                INTO :BN-REVENUE-MONTH                                  
             FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
             WHERE BILL_CYCLE = :BN-BILL-CYCLE                          
             AND DATE_EXTRACT >= CAST(SYSDATETIMEOFFSET() AS DATE)              
             ORDER BY DATE_EXTRACT ASC                                  
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     04510100
MFA-TR*      SELECT  REVENUE_MONTH                                      04511000
MFA-TR*         INTO :BN-REVENUE-MONTH                                  04512000
MFA-TR*      FROM CSS_BILL_WINDOW                                       04513000
MFA-TR*      WHERE BILL_CYCLE = :BN-BILL-CYCLE                          04514000
MFA-TR*      AND DATE_EXTRACT >= CURRENT DATE                           04515000
MFA-TR*      ORDER BY DATE_EXTRACT ASC                                  04515100
MFA-TR*      FETCH FIRST ROW ONLY                                       04515200
MFA-TR*      WITH UR                                                    04515300
MFA-TR*      QUERYNO 7100                                               04515401
MFA-TR*    END-EXEC.                                                    04515500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_BILL_WINDOW'         TO TABLE-1                 
              MOVE BN-REVENUE-MONTH          TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04517800
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
      *                                                                 04518300
      ******************************************************************04519000
      * 8550-INSERT-BILL-MSG                                           *04520000
      *    INSERT ROW IN THE  CSS_SPCL_BILL_MSG  TABLE                 *04530000
      ******************************************************************04540000
       8550-INSERT-BILL-MSG.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_SPCL_BILL_MSG                             
                    ( REVENUE_MO_ST                                     
                    , ACCOUNT_NO                                        
                    , BILL_MSG_ID                                       
                    , MSG_TYPE_CD                                       
                    , COMPANY_NO                                        
                    , BILL_CYCLE_ST                                     
                    , BILL_CYCLE_END                                    
                    , REVENUE_MO_END)                                   
              VALUES (:U1-REVENUE-MO-ST                                 
                    , :U1-ACCOUNT-NO                                    
                    , :U1-BILL-MSG-ID                                   
                    , :U1-MSG-TYPE-CD                                   
                    , :U1-COMPANY-NO                                    
                    , :U1-BILL-CYCLE-ST                                 
                    , :U1-BILL-CYCLE-END                                
                    , :U1-REVENUE-MO-END)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8550'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_BILL_MSG'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BILL_MSG_ID'             TO TABLE-ELEMENT-2         
              MOVE 'REVENUE_MO_END'          TO TABLE-ELEMENT-3         
              MOVE U1-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE U1-BILL-MSG-ID            TO HOSTVAR-ELEMENT-2       
              MOVE U1-REVENUE-MO-END         TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 04960000
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04981100
      * 9900- JOURNAL INCLUDE                                          *04981200
      ******************************************************************04981300
           EXEC SQL                                                     04981400
              INCLUDE CPDSP300                                          04981500
           END-EXEC.                                                    04981600
                                                                        
      ******************************************************************04981800
      *       END PROGRAM COPYLIB                                      *04981900
      ******************************************************************04982000
                                                                        
           EXEC SQL                                                     04982600
               INCLUDE CPD00321                                         04982700
           END-EXEC.                                                    04982800
      *                                                                 04982900
