       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR04304.                                           
       AUTHOR.      RICK SPIRES.                                        
COB303 DATE-WRITTEN. SEP 2009.                                           
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00070000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00080000
      *---------------------------------------------------------------- 00090000
      *--                   STORED PROCEDURE:  CSR04304              -- 00100000
      *---------------------------------------------------------------- 00110000
      *--                         S U M M A R Y                      -- 00120000
      *--                                                            -- 00130000
      *--  CSR04304 :                                                -- 00140000
      *--                                                            -- 00150000
      *--                                                            -- 00160000
      *--    #  ENROLLS/CANCELS AUTOMATIC CREDIT CARD PAYMENTS AND   -- 00170000
      *--    #  WRITES TRANSACTION HISTORY.                          -- 00180000
      *--                                                            -- 00190000
      *--    #  INVOKED FROM BILLMATRIX WEBSERVICE                   -- 00200000
      *--                                                            -- 00210000
      *---------------------------------------------------------------- 00220000
      *--                                                            -- 00230000
      *--                                                            -- 00240000
      *--    PARAMETERS                                              -- 00250000
      *--                                                            -- 00260000
      *--        IN                                                  -- 00270000
      *--                                                            -- 00280000
      *--              ENROLL STATUS                CHAR(03)         -- 00290000
      *--              ACCOUNT NO                   CHAR(13)         -- 00300000
      *--              COMPANY NO                   CHAR(04)         -- 00310000
      *--              RECEIVED TS                  TIMESTAMP        -- 00320000
      *--              RESP AREA                    CHAR(03)         -- 00330000
A05460*--              USER ID                      CHAR(07)         -- 00330100
      *--                                                            -- 00340000
      *--        OUT                                                 -- 00350000
      *--                                                            -- 00360000
      *--              NONE                                          -- 00370000
      *--                                                            -- 00380000
      *--        INOUT                                               -- 00390000
      *--                                                            -- 00400000
      *--              NONE                                          -- 00410000
      *--                                                            -- 00420000
      *---------------------------------------------------------------- 00430000
      *--    RESULT SET                                              -- 00440000
      *--                                                            -- 00450000
      *--      1                                                     -- 00460000
      *--              RETURN CODE               INTEGER             -- 00470000
      *--              ACCOUNT NO                CHAR(13)            -- 00480000
      *--              COMPANY NO                CHAR(04)            -- 00490000
      *--              TIMESTAMP                 TIMESTAMP           -- 00500000
      *---------------------------------------------------------------- 00510000
      *--                   MODIFICATION LOG                         -- 00520000
      *--                                                            -- 00530000
      *--   DATE      INITIALS    COMMENTS                           -- 00540000
      *-- ----------  --------    ------------------------------------- 00550000
      *-- 09/14/2009  RICK SPIRES NEW CODE                           -- 00560000
      *--                                                            -- 00570000
A02714*-- 01/17/2011  BASKAR VANNI MADE CHANGES FOR PANEL190. THIS   -- 00571000
A02714*--                          PANEL NOW USES THIS SP FOR        -- 00572000
A02714*--                          ENROLLMENT AND CANCELLATIONS.     -- 00573000
A02714*-- 01/06/2012  AP40911      ADD CREDIT CARD PAYMENT CANCEL    -- 00574000
      *--                          REASON.                           -- 00575000
A05460*-- 05/24/2016  DB41297      SET WS-CURRENT-USER AS SYSTEM     -- 00576001
      *--                          INSTEAD OF GETTING FROM SQLID     -- 00577001
A05460*-- 10/07/2016  VENKAT.P     ADD PARM-USER-ID INPUT PARM       -- 00577002
A05460*-- 02/01/2017  VENKAT.P     CONVERT USER-ID TO UPPER CASE     -- 00577003
      *----------------------------------------------------------------*00580000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04304'.
MSQ017     COPY MFASQLM.
                                                                        
      *----------------------------------------------------------------*00640000
      *    DB2 INCLUDES                                                *00650000
      *----------------------------------------------------------------*00660000
                                                                        
           EXEC SQL                                                     00680000
              INCLUDE SQLCA                                             00690000
           END-EXEC.                                                    00700000
      *                                                                 00710000
      * CSS_DELINQUENCY - C8                                            00711000
           EXEC SQL                                                     00712000
              INCLUDE TBDELQ                                            00713000
           END-EXEC.                                                    00714000
                                                                        
      * CSS_ACCOUNT - AT                                                00770000
           EXEC SQL                                                     00780000
              INCLUDE TBACCT                                            00790000
           END-EXEC.                                                    00800000
                                                                        
      * CSS_ACCT_ATTRIBUTE - YP                                         00820000
           EXEC SQL                                                     00830000
              INCLUDE TBACTATT                                          00840000
           END-EXEC.                                                    00850000
                                                                        
      * CSS_PNDNG_CARD_PMTS - PC                                        00870000
           EXEC SQL                                                     00880000
              INCLUDE TBPNDCRD                                          00890000
           END-EXEC.                                                    00900000
                                                                        
      * CSS_MNT_TRANS_HIST - MN                                         00920000
           EXEC SQL                                                     00930000
              INCLUDE TBMNHIST                                          00940000
           END-EXEC.                                                    00950000
                                                                        
      * CSS_MT_TRN_HST_DET - MI                                         00970000
           EXEC SQL                                                     00980000
              INCLUDE TBMNHDT                                           00990000
           END-EXEC.                                                    01000000
                                                                        
A02714* CSS_USER_PROFILE - PF                                           01020000
A02714     EXEC SQL                                                     01030000
A02714        INCLUDE TBUSRPRF                                          01040000
A02714     END-EXEC.                                                    01050000
                                                                        
           EXEC SQL                                                     01070000
               INCLUDE CWSX0010                                         01080000
           END-EXEC.                                                    01090000
                                                                        
      *  DB2 ERRORS                                                     01100000
           COPY CWS00303.                                               01150000
      *  CODES DATA PRESENT                                             01160000
           COPY CWS00056.                                               01180000
                                                                        
      *----------------------------------------------------------------*01200000
      *    WORK AREAS                                                  *01210000
      *----------------------------------------------------------------*01220000
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG            PIC X(8)   VALUE 'CSRERLOG'.     
                                                                        
      *---------------------------------------------------------------  01280000
      *--  ERROR PROCESSING VARIABLES                               --  01290000
      *---------------------------------------------------------------  01300000
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)  VALUE SPACES.         
           10  S-SQLCODE               PIC S9(9)  VALUE 0 COMP.         
           10  S-SQLSTATE              PIC X(05)  VALUE SPACES.         
           10  S-TABLE-NAME            PIC X(18)  VALUE SPACES.         
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4)  USAGE COMP.           
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4)  USAGE COMP.           
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4)  USAGE COMP.           
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4)  USAGE COMP.           
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9)  VALUE 0 COMP.         
           10 S-ACCOUNT-NO             PIC X(13)  VALUE SPACES.         
           10 S-COMPANY-NO             PIC X(04)  VALUE SPACES.         
           10 S-TIMESTAMP              PIC X(26)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)  COMP VALUE 1.         
           05  CTR-ROWS                PIC S9(9)  COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9)  COMP.                 
           05  WRKLEN1                 PIC S9(9)  COMP.                 
           05  WRKLEN2                 PIC S9(9)  COMP.                 
           05  WRK-DONE-STATUS         PIC S9(9)  COMP.                 
                                                                        
           05  WS-SQLSTATE             PIC X(05)  VALUE SPACES.         
                                                                        
       01  WS-CONSTANTS.                                                
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04304'.     
           05  WS-PGRMNAME             PIC X(08)  VALUE 'CSR04304'.     
           05  WS-J                    PIC X(01)  VALUE 'J'.            
           05  WS-F                    PIC X(01)  VALUE 'F'.            
           05  WS-P                    PIC X(01)  VALUE 'P'.            
           05  WS-01                   PIC X(02)  VALUE '01'.           
           05  WS-DATABASE             PIC X(08)  VALUE 'DATABASE'.     
           05  MULTIPLE-ROWS-SELECTED  PIC S9(09) VALUE -811 COMP.      
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-1           PIC S9(4)  USAGE COMP VALUE +0.  
           05  WS-NULL-IND-2           PIC S9(4)  USAGE COMP VALUE +0.  
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-INPUT-ERROR-SW        PIC X(01) VALUE SPACES.          
              88 ACCOUNT-NOT-FOUND               VALUE 'A'.             
              88 ACCOUNT-INACTIVE                VALUE 'B'.             
              88 ACCOUNT-NOT-NUMERIC             VALUE 'L'.             
              88 ENROLL-ST-ERROR                 VALUE 'E'.             
              88 INVALID-TIMESTAMP               VALUE 'Y'.             
           05 WS-ATTR-ACCT-ST          PIC X(01) VALUE SPACES.          
              88 ACCT-ACTIVE                     VALUE 'A'.             
              88 ACCT-BLOCKED                    VALUE 'B'.             
              88 ACCT-CANCEL                     VALUE 'C'.             
              88 ACCT-NOTFND                     VALUE 'N'.             
           05 WS-DATABASE-SW           PIC 9(01) VALUE 0.               
              88 CSR-DATABASE                    VALUE 1.               
              88 SEB-DATABASE                    VALUE 2.               
           05 WS-PROCESS-SW            PIC X(01) VALUE SPACES.          
              88 ENR                             VALUE 'E'.             
              88 CAN                             VALUE 'C'.             
                                                                        
       01  WS-MISC-ITEMS.                                               
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-AMOUNT-9             PIC 9(11)V99.                    
           05  WS-AMOUNT-X  REDEFINES  WS-AMOUNT-9 PIC X(13).           
           05  WS-USER-ID              PIC X(07)  VALUE SPACES.         
           05  WS-XFER-ACCT            PIC X(01)  VALUE SPACES.         
           05  WS-HOLD-ACCT-NUM        PIC X(13)  VALUE SPACES.         
           05  RS-RETURN-CODE          PIC S9(9)      VALUE 0 COMP.     
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-CURRENT-TS           PIC X(26)  VALUE SPACES.         
           05  WS-COMPANY-NO           PIC X(02)  VALUE SPACES.         
           05  WS-PREV-STATUS          PIC X(01)  VALUE SPACES.         
                                                                        
       LINKAGE SECTION.                                                 
       01  I-ENROLL-STATUS             PIC X(03).                       
       01  I-ACCOUNT-NO                PIC X(13).                       
       01  I-COMPANY-NO                PIC X(04).                       
       01  I-TIMESTAMP                 PIC X(26).                       
       01  I-RESP-AREA                 PIC X(03).                       
A05460 01  I-USER-ID                   PIC X(07).                       
                                                                        
       PROCEDURE DIVISION USING I-ENROLL-STATUS,                        
                                I-ACCOUNT-NO,                           
                                I-COMPANY-NO,                           
                                I-TIMESTAMP,                            
                                I-RESP-AREA,                            
A05460                          I-USER-ID.                              
                                                                        
      *---------------------------------------------------------------  03060000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                    *  03070000
      *---------------------------------------------------------------  03080000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE-PROCEDURE THRU 0100-EXIT             
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT             
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT             
           GOBACK                                                       
           .                                                            
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  03570000
      *    SET UP SQL ERROR PROCESSING                               *  03580000
      *    DECLARE ASSOCIATED CURSOR                                 *  03590000
      *---------------------------------------------------------------  03600000
                                                                        
       0100-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC               
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC               
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC               
                                                                        
           MOVE WS-01                        TO C8-COMPANY-NO           
           MOVE WS-DATABASE                  TO C8-DELINQ-CD            
           PERFORM 7020-GET-DELINQ-VALUE     THRU 7020-EXIT             
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE-SW          
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT  :S-RETURN-CODE     AS RETURN_CODE                  
                    ,:S-ACCOUNT-NO      AS ACCOUNT_NO                   
                    ,:S-COMPANY-NO      AS COMPANY_NO                   
                    ,:S-TIMESTAMP       AS TIMESTAMP                    
               FROM CIS.SYSDUMMY1                                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     03730000
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                           03740000
MFA-TR*      SELECT  :S-RETURN-CODE     AS RETURN_CODE                  03750000
MFA-TR*             ,:S-ACCOUNT-NO      AS ACCOUNT_NO                   03760000
MFA-TR*             ,:S-COMPANY-NO      AS COMPANY_NO                   03770000
MFA-TR*             ,:S-TIMESTAMP       AS TIMESTAMP                    03780000
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                    03790000
MFA-TR*    END-EXEC                                                     03800000
                                                                        
           PERFORM 7200-GET-CURRENT-DATE     THRU 7200-EXIT             
                                                                        
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  03850000
      * THIS IS THE MAIN PROGRAM DRIVER PARAGRAPH. IT CALLS INPUT    *  03860000
      * VALIDATION,  DETERMINES THE PROCESSING LOGIC FOR ENR AND CAN *  03870000
      * CREDIT CARD TRANSACTIONS AND PASSES BACK THE APPROPRIATE     *  03880000
      * RETURN CODES.                                                *  03890000
      *---------------------------------------------------------------  03910000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                                                                        
      * POPULATE RETURN VARIABLES                                       03970000
           MOVE ZERO                         TO S-RETURN-CODE           
           MOVE I-TIMESTAMP                  TO S-TIMESTAMP             
           MOVE I-ACCOUNT-NO                 TO S-ACCOUNT-NO            
           MOVE I-COMPANY-NO                 TO S-COMPANY-NO            
           ADD +1 TO CTR-ROWS                                           
                                                                        
           PERFORM 1100-VALIDATE-INPUT    THRU 1100-EXIT                
                                                                        
           IF CSR-DATABASE                                              
              IF WS-COMPANY-NO = '01'                                   
                 MOVE 'SCEG'                 TO S-COMPANY-NO            
              ELSE                                                      
                 IF WS-COMPANY-NO = '26'                                
                    MOVE 'PSNC'              TO S-COMPANY-NO            
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF SEB-DATABASE                                           
                 MOVE 'SEB'                  TO S-COMPANY-NO            
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE +0                           TO S-RETURN-CODE           
           IF WS-INPUT-ERROR-SW > SPACES                                
             IF ACCOUNT-NOT-FOUND                                       
                 MOVE +100                   TO S-RETURN-CODE           
              ELSE                                                      
                 MOVE +2000                  TO S-RETURN-CODE           
              END-IF                                                    
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
           PERFORM 7010-GET-ACCT-ATTR        THRU 7010-EXIT             
                                                                        
           IF ENR                                                       
             EVALUATE TRUE                                              
                WHEN ACCT-ACTIVE                                        
                   MOVE +1000                TO S-RETURN-CODE           
                WHEN ACCT-BLOCKED                                       
                   MOVE +3000                TO S-RETURN-CODE           
                WHEN ACCT-CANCEL                                        
                   PERFORM 1200-FORMAT-ACCTATTR                         
                                             THRU 1200-EXIT             
                   PERFORM 8020-UPD-ACCT-ATTR                           
                                             THRU 8020-EXIT             
                WHEN ACCT-NOTFND                                        
                   PERFORM 1200-FORMAT-ACCTATTR                         
                                             THRU 1200-EXIT             
                   PERFORM 8010-INSERT-ACCT-ATTR                        
                                             THRU 8010-EXIT             
                WHEN OTHER                                              
                   MOVE +1000                TO S-RETURN-CODE           
             END-EVALUATE                                               
           END-IF                                                       
                                                                        
           IF CAN                                                       
             EVALUATE TRUE                                              
                WHEN ACCT-ACTIVE                                        
                   MOVE 'C'                  TO YP-STATUS-CD            
                   MOVE SPACES TO YP-ATTRIBUTE-VALUE-TX-TEXT            
                   MOVE 'CANCEL_TS='                                    
                              TO YP-ATTRIBUTE-VALUE-TX-TEXT (1:10)      
                   MOVE WS-CURRENT-TS                                   
                              TO YP-ATTRIBUTE-VALUE-TX-TEXT (11:26)     
                   MOVE +40   TO YP-ATTRIBUTE-VALUE-TX-LEN              
                   PERFORM 8020-UPD-ACCT-ATTR                           
                                             THRU 8020-EXIT             
                   PERFORM 8030-UPD-PNDNG-CC-PMTS                       
                                             THRU 8030-EXIT             
                WHEN ACCT-BLOCKED                                       
                   MOVE +3000                  TO S-RETURN-CODE         
                WHEN ACCT-CANCEL                                        
                WHEN ACCT-NOTFND                                        
                   MOVE +1000                  TO S-RETURN-CODE         
             END-EVALUATE                                               
           END-IF                                                       
                                                                        
           IF S-RETURN-CODE EQUAL +0 OR +4000                           
              PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  04440000
      * VALIDATES INPUT PARAMETERS.                                  *  04450000
      *---------------------------------------------------------------  04480000
                                                                        
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF I-TIMESTAMP = SPACES                                      
              SET INVALID-TIMESTAMP TO TRUE                             
              GO TO 1100-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE I-ACCOUNT-NO                 TO WS-ACCOUNT-NO           
           MOVE WS-ACCOUNT-NO-NUM            TO WS-ACCOUNT-NO-COMP3     
           MOVE WS-ACCOUNT-NO-COMP3          TO AT-ACCOUNT-NO           
                                                                        
           IF I-ACCOUNT-NO NOT NUMERIC                                  
              SET ACCOUNT-NOT-NUMERIC TO TRUE                           
              GO TO 1100-EXIT                                           
           END-IF                                                       
                                                                        
           PERFORM 7000-VALIDATE-ACCOUNT     THRU 7000-EXIT             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF AT-CODE-ACCT-STAT = WS-J                               
                 SET ACCOUNT-INACTIVE TO TRUE                           
                 GO TO 1100-EXIT                                        
              END-IF                                                    
                                                                        
              EVALUATE I-COMPANY-NO                                     
                WHEN 'SCEG'                                             
                  MOVE '01'        TO WS-COMPANY-NO                     
                WHEN 'PSNC'                                             
                  MOVE '26'        TO WS-COMPANY-NO                     
                WHEN 'SEB'                                              
                  MOVE '01'        TO WS-COMPANY-NO                     
              END-EVALUATE                                              
                                                                        
              IF WS-COMPANY-NO NOT = AT-COMPANY-NO                      
                 MOVE AT-COMPANY-NO TO WS-COMPANY-NO                    
              END-IF                                                    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              SET ACCOUNT-NOT-FOUND TO TRUE                             
           END-IF                                                       
           END-IF                                                       
                                                                        
           IF I-ENROLL-STATUS = 'ENR'                                   
              SET ENR      TO TRUE                                      
           ELSE                                                         
           IF I-ENROLL-STATUS = 'CAN'                                   
              SET CAN      TO TRUE                                      
           ELSE                                                         
              SET ENROLL-ST-ERROR TO TRUE                               
           END-IF END-IF                                                
                                                                        
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------  04910000
      * FORMAT CSS_ACCT_ATTRIBUTE RECORD                             *  04920000
      *---------------------------------------------------------------  04950000
                                                                        
       1200-FORMAT-ACCTATTR.                                            
                                                                        
           MOVE WS-ACCOUNT-NO         TO YP-ACCOUNT-NO                  
           MOVE 'AUTO_CARD_PAY'       TO YP-ATTRIBUTE-DESC              
           MOVE 'AUTOC'               TO YP-ATTRIBUTE-VALUE-CD          
           MOVE WS-CURRENT-DATE       TO YP-ATTRIBUTE-VALUE-DT          
           MOVE +0                    TO YP-ATTRIBUTE-VALUE-TX-LEN      
           MOVE SPACES                TO YP-ATTRIBUTE-VALUE-TX-TEXT     
           MOVE WS-CURRENT-TS         TO YP-CREATED-TS                  
           MOVE 'A'                   TO YP-STATUS-CD                   
                                                                        
           .                                                            
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05510000
      * 2500-MAINTENANCE-HISTORY.                                     * 05520000
      *                                                               * 05530000
      *                                                               * 05540000
      *     PREPARE MAINTENANCE JOURNAL                               * 05550000
      ***************************************************************** 05560000
                                                                        
       2500-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '2500'                 TO ACTIVE-PARAGRAPH.             
                                                                        
A05460     MOVE I-USER-ID              TO MH-USER-ID                    
A05460                                    PF-USER-ID.                   
A05460     PERFORM 7030-SELECT-RESP-AREA THRU 7030-EXIT.                
A05460     MOVE PF-RESP-AREA-ID     TO MH-RESP-AREA-ID                  
           MOVE WS-CURRENT-TS          TO MH-TRANS-HIST-SEQ-NO          
           MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS                 
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE YP-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE 'CSR04304'             TO MH-APPL-PROGRAM-ID.           
           MOVE 20                     TO MH-TRAN-COMMENT-LEN.          
           IF ENR                                                       
              MOVE 'AUTO CARD PAY ENROLL'                               
                                       TO MH-TRAN-COMMENT-TEXT          
              MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO         
              MOVE +1                  TO MI-TRAN-APPL-NO               
              MOVE 'ENROLL DATE'       TO MI-COLUMN-DESC                
              MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE 'NEW'               TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN       
              MOVE WS-CURRENT-DATE     TO MI-CHG-COLUMN-VALUE-TEXT      
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                       THRU 6530-EXIT                   
              MOVE +2                  TO MI-TRAN-APPL-NO               
              MOVE 'STATUS'            TO MI-COLUMN-DESC                
              IF YP-STATUS-CD = 'C'                                     
                 MOVE +6               TO MI-PRV-COLUMN-VALUE-LEN       
                 MOVE 'CANCEL'         TO MI-PRV-COLUMN-VALUE-TEXT      
              ELSE                                                      
                 MOVE +3               TO MI-PRV-COLUMN-VALUE-LEN       
                 MOVE 'NEW'            TO MI-PRV-COLUMN-VALUE-TEXT      
              END-IF                                                    
              MOVE +6                  TO MI-CHG-COLUMN-VALUE-LEN       
              MOVE 'ACTIVE'            TO MI-CHG-COLUMN-VALUE-TEXT      
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                       THRU 6530-EXIT                   
           ELSE                                                         
              MOVE 'AUTO CARD PAY CANCEL'                               
                                       TO MH-TRAN-COMMENT-TEXT          
              MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO         
              MOVE +1                  TO MI-TRAN-APPL-NO               
              MOVE 'CANCEL DATE'       TO MI-COLUMN-DESC                
              MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE YP-ATTRIBUTE-VALUE-DT TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN       
              MOVE WS-CURRENT-DATE     TO MI-CHG-COLUMN-VALUE-TEXT      
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                       THRU 6530-EXIT                   
              MOVE +2                  TO MI-TRAN-APPL-NO               
              MOVE 'STATUS'            TO MI-COLUMN-DESC                
              MOVE +6                  TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE 'ACTIVE'            TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE +6                  TO MI-CHG-COLUMN-VALUE-LEN       
              MOVE 'CANCEL'            TO MI-CHG-COLUMN-VALUE-TEXT      
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                       THRU 6530-EXIT                   
           END-IF                                                       
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05930000
      * 6530-LOAD-MNT-TRANS-HIST                                       *05940000
      *                                                                *05950000
      *                                                                *05960000
      *     JOURNALING ROUTINE                                         *05970000
      ******************************************************************05980000
           EXEC SQL                                                     05990000
              INCLUDE CPD00067                                          06000000
           END-EXEC.                                                    06010000
                                                                        
      *---------------------------------------------------------------* 07510000
      * VALIDATES ACCOUNT NO AND SELECTS ACCOUNT DETAILS FOR GIVEN    * 07520000
      * ACCOUNT NO                                                    * 07530000
      *---------------------------------------------------------------* 07540000
                                                                        
       7000-VALIDATE-ACCOUNT.                                           
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NO                                          
                   ,CODE_ACCT_STAT                                      
               INTO :AT-COMPANY-NO                                      
                   ,:AT-CODE-ACCT-STAT                                  
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
A02714                                                      
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07580000
MFA-TR*      SELECT COMPANY_NO                                          07590000
MFA-TR*            ,CODE_ACCT_STAT                                      07600000
MFA-TR*        INTO :AT-COMPANY-NO                                      07620000
MFA-TR*            ,:AT-CODE-ACCT-STAT                                  07630000
MFA-TR*        FROM CSS_ACCOUNT                                         07650000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         07660000
MFA-TR*     QUERYNO 7000                                                07661000
MFA-TR*        WITH UR                                                  07670000
MFA-TR*    END-EXEC                                                     07680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 08271000
      * VALIDATES ACCOUNT ATTRIBUTE TABLE                             * 08272000
      *---------------------------------------------------------------* 08274000
                                                                        
       7010-GET-ACCT-ATTR.                                              
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3       TO YP-ACCOUNT-NO.             
                                                                        
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
                   ,ATTRIBUTE_DESC                                      
                   ,ATTRIBUTE_VALUE_CD                                  
                   ,ATTRIBUTE_VALUE_DT                                  
                   ,ATTRIBUTE_VALUE_TX                                  
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS, 121), 
           ' ', '-'), ':', '.') CREATED_TS                                     
                   ,STATUS_CD                                           
               INTO :YP-ACCOUNT-NO                                      
                   ,:YP-ATTRIBUTE-DESC                                  
                   ,:YP-ATTRIBUTE-VALUE-CD                              
                   ,:YP-ATTRIBUTE-VALUE-DT                              
                   ,:YP-ATTRIBUTE-VALUE-TX                              
                   ,:YP-CREATED-TS                                      
                   ,:YP-STATUS-CD                                       
               FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                         
                AND ATTRIBUTE_DESC = 'AUTO_CARD_PAY'                    
                AND ATTRIBUTE_VALUE_CD = 'AUTOC'                        
A02714                                                      
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08278000
MFA-TR*      SELECT ACCOUNT_NO                                          08279000
MFA-TR*            ,ATTRIBUTE_DESC                                      08279100
MFA-TR*            ,ATTRIBUTE_VALUE_CD                                  08279200
MFA-TR*            ,ATTRIBUTE_VALUE_DT                                  08279300
MFA-TR*            ,ATTRIBUTE_VALUE_TX                                  08279400
MFA-TR*            ,CREATED_TS                                          08279500
MFA-TR*            ,STATUS_CD                                           08279600
MFA-TR*        INTO :YP-ACCOUNT-NO                                      08279700
MFA-TR*            ,:YP-ATTRIBUTE-DESC                                  08279800
MFA-TR*            ,:YP-ATTRIBUTE-VALUE-CD                              08279900
MFA-TR*            ,:YP-ATTRIBUTE-VALUE-DT                              08280000
MFA-TR*            ,:YP-ATTRIBUTE-VALUE-TX                              08280100
MFA-TR*            ,:YP-CREATED-TS                                      08280200
MFA-TR*            ,:YP-STATUS-CD                                       08280300
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE                                  08280400
MFA-TR*       WHERE ACCOUNT_NO = :YP-ACCOUNT-NO                         08280500
MFA-TR*         AND ATTRIBUTE_DESC = 'AUTO_CARD_PAY'                    08280600
MFA-TR*         AND ATTRIBUTE_VALUE_CD = 'AUTOC'                        08280700
MFA-TR*     QUERYNO 7010                                                08280800
MFA-TR*        WITH UR                                                  08280900
MFA-TR*    END-EXEC                                                     08281000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                MOVE YP-STATUS-CD        TO WS-PREV-STATUS              
                MOVE YP-STATUS-CD        TO WS-ATTR-ACCT-ST             
             ELSE                                                       
                MOVE SPACE               TO WS-PREV-STATUS              
                MOVE 'N'                 TO WS-ATTR-ACCT-ST             
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :C8-DELINQ-VALUE                                    
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD  = :C8-DELINQ-CD                          
                AND COMPANY_NO = :C8-COMPANY-NO                         
A02714                                                      
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08284100
MFA-TR*      SELECT DELINQ_VALUE                                        08284200
MFA-TR*        INTO :C8-DELINQ-VALUE                                    08284300
MFA-TR*        FROM CSS_DELINQUENCY                                     08284400
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                          08284500
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                         08284600
MFA-TR*     QUERYNO 7020                                                08284700
MFA-TR*        WITH UR                                                  08284800
MFA-TR*    END-EXEC                                                     08284900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
              MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02714*---------------------------------------------------------------* 08287400
A02714* SELECTS RESP AREA FOR A USER ID                               * 08287500
      *---------------------------------------------------------------* 08287600
       7030-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
             SELECT RESP_AREA_ID                                        
               INTO :PF-RESP-AREA-ID                                    
               FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                      
              WHERE USER_ID = :PF-USER-ID                               
A02714                                                      
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08287900
MFA-TR*      SELECT RESP_AREA_ID                                        08288000
MFA-TR*        INTO :PF-RESP-AREA-ID                                    08288100
MFA-TR*        FROM CSS_USER_PROFILE                                    08288200
MFA-TR*       WHERE USER_ID = :PF-USER-ID                               08288300
MFA-TR*     QUERYNO 7030                                                08288400
MFA-TR*        WITH UR                                                  08288500
MFA-TR*    END-EXEC                                                     08288600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7030'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE PF-USER-ID            TO HOSTVAR-ELEMENT-1           
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
A02714 7030-EXIT.                                                       
A02714     EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 08290900
      * SELECTS CURRENT DATE AND TIMESTAMP                            * 08291000
      *---------------------------------------------------------------* 08300000
                                                                        
       7200-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              UPPER(:I-USER-ID)
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TS,
              :I-USER-ID                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08340000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       08350000
MFA-TR*          ,:WS-CURRENT-TS   = CURRENT TIMESTAMP                  08351000
MFA-TR*          ,:I-USER-ID       = UPPER(:I-USER-ID)                  08351100
MFA-TR*    END-EXEC                                                     08360000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*10301000
      * INSERTS ENROLLMENT IN CSS_ACCT_ATTRIBUTE TABLE                 *10302000
      *----------------------------------------------------------------*10303000
                                                                        
       8010-INSERT-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_ACCT_ATTRIBUTE                          
                       (                                                
                        ACCOUNT_NO                                      
                       ,ATTRIBUTE_DESC                                  
                       ,ATTRIBUTE_VALUE_CD                              
                       ,ATTRIBUTE_VALUE_DT                              
                       ,ATTRIBUTE_VALUE_TX                              
                       ,CREATED_TS                                      
                       ,STATUS_CD                                       
                       )                                                
                VALUES                                                  
                       (                                                
                        :YP-ACCOUNT-NO                                  
                       ,:YP-ATTRIBUTE-DESC                              
                       ,:YP-ATTRIBUTE-VALUE-CD                          
                       ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                       ,:YP-ATTRIBUTE-VALUE-TX                          
                       ,CIS.CHAR2TIMESTAMP(:YP-CREATED-TS)                      
                       ,:YP-STATUS-CD                                   
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10307000
MFA-TR*         INSERT INTO CSS_ACCT_ATTRIBUTE                          10308000
MFA-TR*                (                                                10309000
MFA-TR*                 ACCOUNT_NO                                      10309100
MFA-TR*                ,ATTRIBUTE_DESC                                  10309200
MFA-TR*                ,ATTRIBUTE_VALUE_CD                              10309300
MFA-TR*                ,ATTRIBUTE_VALUE_DT                              10309400
MFA-TR*                ,ATTRIBUTE_VALUE_TX                              10309500
MFA-TR*                ,CREATED_TS                                      10309600
MFA-TR*                ,STATUS_CD                                       10309700
MFA-TR*                )                                                10310800
MFA-TR*         VALUES                                                  10310900
MFA-TR*                (                                                10311000
MFA-TR*                 :YP-ACCOUNT-NO                                  10311100
MFA-TR*                ,:YP-ATTRIBUTE-DESC                              10311200
MFA-TR*                ,:YP-ATTRIBUTE-VALUE-CD                          10311300
MFA-TR*                ,:YP-ATTRIBUTE-VALUE-DT                          10311400
MFA-TR*                ,:YP-ATTRIBUTE-VALUE-TX                          10311500
MFA-TR*                ,:YP-CREATED-TS                                  10311600
MFA-TR*                ,:YP-STATUS-CD                                   10311700
MFA-TR*                )                                                10312800
MFA-TR*    END-EXEC                                                     10313000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ATTRIBUTE_DESC'          TO TABLE-ELEMENT-2         
              MOVE 'ATTRIBUTE_VALUE_DT'      TO TABLE-ELEMENT-3         
              MOVE 'STATUS_CD'               TO TABLE-ELEMENT-4         
              MOVE YP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE YP-ATTRIBUTE-DESC         TO HOSTVAR-ELEMENT-2       
              MOVE YP-ATTRIBUTE-VALUE-DT     TO HOSTVAR-ELEMENT-3       
              MOVE YP-STATUS-CD              TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 10316000
      * UPDATES A CREDIT CARD ENROLLMENT RECORD                       * 10320000
      *---------------------------------------------------------------* 10330000
                                                                        
       8020-UPD-ACCT-ATTR.                                              
                                                                        
           MOVE WS-CURRENT-DATE        TO YP-ATTRIBUTE-VALUE-DT         
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCT_ATTRIBUTE                                  
                SET ATTRIBUTE_VALUE_DT = IIF(TRY_CONVERT(DATE, 
                                                 :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )         
                   ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX         
                   ,CREATED_TS         = CIS.CHAR2TIMESTAMP(
                                                         :YP-CREATED-TS
              )                 
                   ,STATUS_CD          = :YP-STATUS-CD                  
              WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                 
                AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'                
                AND ATTRIBUTE_VALUE_CD = 'AUTOC'                        
A02714                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10370000
MFA-TR*      UPDATE CSS_ACCT_ATTRIBUTE                                  10380000
MFA-TR*         SET ATTRIBUTE_VALUE_DT = :YP-ATTRIBUTE-VALUE-DT         10390000
MFA-TR*            ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX         10400000
MFA-TR*            ,CREATED_TS         = :YP-CREATED-TS                 10410000
MFA-TR*            ,STATUS_CD          = :YP-STATUS-CD                  10420000
MFA-TR*       WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                 10430000
MFA-TR*         AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'                10440000
MFA-TR*         AND ATTRIBUTE_VALUE_CD = 'AUTOC'                        10450000
MFA-TR*     QUERYNO 8020                                                10460000
MFA-TR*    END-EXEC                                                     10470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE YP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'ATTRIBUTE_DESC'          TO TABLE-ELEMENT-2         
              MOVE YP-ATTRIBUTE-DESC         TO HOSTVAR-ELEMENT-2       
              MOVE 'ATTRIBUTE_VALUE_CD'      TO TABLE-ELEMENT-3         
              MOVE YP-ATTRIBUTE-VALUE-CD     TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 10751000
      * UPDATE PENDING PAYMENTS                                       * 10752000
      *---------------------------------------------------------------* 10753000
                                                                        
       8030-UPD-PNDNG-CC-PMTS.                                          
                                                                        
           MOVE WS-ACCOUNT-NO          TO PC-ACCOUNT-NO                 
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PNDNG_CARD_PMT                                  
                SET STATUS_CODE        = 'X'                            
                   ,CANCELLED_TS       = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )                 
A02714             ,PMT_CANCEL_REAS_CD = 'EC'                           
              WHERE ACCOUNT_NO         = :PC-ACCOUNT-NO                 
                AND STATUS_CODE        = 'A'                            
A02714                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10759000
MFA-TR*      UPDATE CSS_PNDNG_CARD_PMT                                  10759100
MFA-TR*         SET STATUS_CODE        = 'X'                            10759200
MFA-TR*            ,CANCELLED_TS       = :WS-CURRENT-TS                 10759300
MFA-TR*            ,PMT_CANCEL_REAS_CD = 'EC'                           10759400
MFA-TR*       WHERE ACCOUNT_NO         = :PC-ACCOUNT-NO                 10759600
MFA-TR*         AND STATUS_CODE        = 'A'                            10759700
MFA-TR*     QUERYNO 8030                                                10759900
MFA-TR*    END-EXEC                                                     10760000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           S-RETURN-CODE                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PNDNG_CARD_PMT'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE PC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'STATUS_CODE'             TO TABLE-ELEMENT-2         
              MOVE PC-STATUS-CODE            TO HOSTVAR-ELEMENT-2       
              MOVE 'CANCELLED_TS'            TO TABLE-ELEMENT-3         
              MOVE WS-CURRENT-TS             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE +4000 TO S-RETURN-CODE                               
           END-IF                                                       
                                                                        
           IF S-RETURN-CODE = +100                                      
              MOVE +0 TO S-RETURN-CODE                                  
           END-IF                                                       
           .                                                            
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *---------------------------------------------------------------* 12600000
      *   OPEN THE RESULT SET CURSOR                                  * 12610000
      *---------------------------------------------------------------* 12620000
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
           .                                                            
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 12860000
      * SENDS ERROR RESULT                                            * 12870000
      *---------------------------------------------------------------* 12880000
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE                  
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF                                                       
           .                                                            
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      *---------------------------------------------------------------* 13150000
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    * 13160000
      *---------------------------------------------------------------* 13170000
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF                                                       
                                                                        
           
MSQ016        GOBACK                                                     
           .                                                            
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     13550000
              INCLUDE CPDSP300                                          13560000
           END-EXEC.                                                    13570000
                                                                        
