       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04303.                                      
       AUTHOR.       MS93554.                                           
COB303 DATE-WRITTEN.     MAY 02, 2012.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *        CONVERT EXISTING SPDB MODULE CSR04303 TO A DB2 COBOL SP *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  RETRIEVE FIXED FACTOR DETAILS. IT IS CALLED FROM PANEL 100    *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             ACCOUNT_NO                 CHAR(13)                *        
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             IC_NO                      CHAR(04)                *        
      *             STATUS_CD                  CHAR(01)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -----------------                                             *        
      *             RETURN_CODE                INTEGER                 *        
      *             FACTOR_TYPE                CHAR(01)                *        
      *             FACTOR_ID                  CHAR(09)                *        
      *             FACTOR_DESC                CHAR(20)                *        
      *             START_DATE                 DATE                    *        
      *             END_DATE                   DATE                    *        
      *             DURATION_REM               SMALLINT                *        
      *             FACTOR                     DECIMAL(13,4)           *        
      *             APPL_METHOD                CHAR(01)                *        
      *             SWITCH_EXIT_FEE            DECIMAL(11,6)           *        
      *             RATE_CHNG_EXIT_FEE         DECIMAL(11,6)           *        
      *             OPTION_DESC                CHAR(50)                *        
      *                                                                *        
      *  APPL RETURN CODE                                              *        
      *  -----------------                                             *        
      *  1000 - INPUT VALUES ARE INVALID                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *  --------    --------   ------------------------------         *        
      *  02-05-2012  MS93554    NEW PROGRAM                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04303'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04303 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        FF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_MKT_TIER  DD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT UT                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR     FF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR      SF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR  DF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CRM_OPT_ATTR_INCTV HQ                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CRM_RT_PKG_OPTION  FI                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM       G6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_WINDOW    BN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_ATTR_PRORATE   2L                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATRPRO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_ATTR_PRO_FCTR  2N                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATRFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT TO GET EXIT FEE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS04114                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04303'. 
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
                                                                        
       01  SWITCHES.                                                    
           05  CSR04303-DONE-SW             PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
           05  WS-PENDING-STATUS            PIC X(01) VALUE 'Y'.        
               88 PENDING-STATUS                      VALUE 'Y'.        
               88 NOT-PENDING-STATUS                  VALUE 'N'.        
                                                                        
       01  NULL-INDICATORS.                                             
           05  WS-IND-DATE-TO               PIC S9(04) COMP.            
           05  WS-IND-DATE-FROM             PIC S9(04) COMP.            
           05  WS-IND-DUR-REM-NO            PIC S9(04) COMP.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN               PIC S9(04) COMP.            
               49 GTT-ROW-CHAR              PIC X(1024).                
           05  GTT-SQLCODE                  PIC S9(9) COMP.             
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ZERO                      PIC S9(4) COMP VALUE 0.     
           05  GTT-NAME                     PIC X(26) VALUE             
                                                'SESSION.CSR04303_R1'.  
       01  WS-MISC.                                                     
           05 WS-PENDING                    PIC X(01) VALUE 'P'.        
           05 WS-DUR-RMN-NO-TEMP-1          PIC 9(04).                  
           05 WS-DUR-RMN-NO-TEMP-2          PIC ZZZ9.                   
           05 WS-YES-NULL                   PIC S9(04) VALUE -1.        
           05 WS-DURATION-REM-NO            PIC X(04) VALUE SPACE.      
           05 WS-ACCOUNT-NO                 PIC X(13) VALUE SPACES.     
           05 WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                    
                                            PIC 9(13).                  
           05 WS-FACTOR-FF                  PIC S9(9)V9(6) USAGE COMP-3 
                                                      VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE 0.    
           05  S-APPL-RETURN-CODE           PIC S9(09) COMP VALUE 0.    
           05  S-FACTOR-TYPE                PIC X(01) VALUE SPACE.      
           05  S-FACTOR-ID                  PIC X(09) VALUE SPACE.      
           05  S-FACTOR-DESC                PIC X(20) VALUE SPACE.      
           05  S-START-DATE                 PIC X(10) VALUE             
                                                      '1900-01-01'.     
           05  S-END-DATE                   PIC X(10) VALUE             
                                                      '1900-01-01'.     
           05  S-DURATION-REM-NO            PIC X(04) VALUE SPACE.      
           05  S-FACTOR                     PIC S9(9)V9(6) USAGE COMP-3 
                                                      VALUE 0.          
           05  S-APPL-METHOD                PIC X(01) VALUE SPACE.      
           05  S-SWITCH-EXIT-FEE            PIC S9(5)V9(6) USAGE COMP-3 
                                               VALUE 0.                 
           05  S-RATE-CHNG-EXIT-FEE         PIC S9(5)V9(6) USAGE COMP-3 
                                               VALUE 0.                 
           05  S-OPTION-DESC                PIC X(50) VALUE SPACES.     
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                   PIC X(18)  VALUE SPACES.    
            10  S-SQLCODE                   PIC S9(9)  COMP VALUE 0.    
            10  S-SQLSTATE                  PIC X(5)   VALUE ' '.       
            10  S-TABLE-NAME                PIC X(18)  VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L      PIC S9(4)  USAGE COMP.      
                49  S-HOST-VARIABLES-V      PIC X(255).                 
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L       PIC S9(4)  USAGE COMP.      
                49  S-SQL-STATEMENT-V       PIC X(255).                 
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L     PIC S9(4)  USAGE COMP.      
                49  S-SQL-DESCRIPTION-V     PIC X(255).                 
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO RETRIEVE THE ROWS FOR ACTIVE / OPEN FOR      *        
      * RENEWAL / RENEWED STATUS. FACTOR TYPE SHOULD BE                *        
      * FIXED FACTOR / COMBO FIXED.                                    *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE FIXED_FCTR_CUR CURSOR FOR                         
                 SELECT SF.FACTOR_TYPE                                  
                       ,SF.FACTOR_ID                                    
                       ,SF.FACTOR_TEXT                                  
                       ,FF.EFF_DATE_FROM                                
                       ,FF.EFF_DATE_TO                                  
                       ,FF.DURATION_REMAIN_NO                           
                       ,FF.FACTOR                                       
                       ,SF.FCTR_POWER_10                                
                       ,SF.VERS_PRORATE_CD                              
                       ,FI.OPT_DESC_INT                                 
                   FROM CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)             
                       ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)             
                       ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)             
                       ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
                       ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)             
                  WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO           
                    AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE       
                    AND DF.IC_NO             = :DF-IC-NO                
                    AND DF.STATUS_CD        IN ('A','O','R')            
                    AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO            
                    AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE        
                    AND UT.IC_NO             = DF.IC_NO                 
                    AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO     
                    AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO     
                    AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO            
                    AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE        
                    AND FF.IC_NO             = DF.IC_NO                 
                    AND SF.FACTOR_ID         = FF.FACTOR_ID             
                    AND SF.FACTOR_TYPE      IN ('B','F')                
                    AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'      
                    AND FI.OPTION_CD         = DF.OPTION_CD             
                    AND FI.COMPANY_NO        = '01'                     
                    AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()        
                    AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()        
                    AND FI.PROC_STATUS_CD    = 'AC'                     
                  ORDER BY FF.EFF_DATE_TO DESC                          
                          ,FF.EFF_DATE_FROM DESC                        
                          ,SF.FACTOR_TEXT ASC                           
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FIXED_FCTR_CUR CURSOR FOR                                 
MFA-TR*          SELECT SF.FACTOR_TYPE                                          
MFA-TR*                ,SF.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*                ,SF.VERS_PRORATE_CD                                      
MFA-TR*                ,FI.OPT_DESC_INT                                         
MFA-TR*            FROM CSS_FIXED_FCTR     FF                                   
MFA-TR*                ,CSS_SPCL_FCTR      SF                                   
MFA-TR*                ,CSS_ACCT_RTPK_AGR  DF                                   
MFA-TR*                ,CSS_UTIL_ENVRNMT   UT                                   
MFA-TR*                ,CRM_RT_PKG_OPTION  FI                                   
MFA-TR*           WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                   
MFA-TR*             AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE               
MFA-TR*             AND DF.IC_NO             = :DF-IC-NO                        
MFA-TR*             AND DF.STATUS_CD        IN ('A','O','R')                    
MFA-TR*             AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR*             AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR*             AND UT.IC_NO             = DF.IC_NO                         
MFA-TR*             AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR*             AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR*             AND FF.IC_NO             = DF.IC_NO                         
MFA-TR*             AND SF.FACTOR_ID         = FF.FACTOR_ID                     
MFA-TR*             AND SF.FACTOR_TYPE      IN ('B','F')                        
MFA-TR*             AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'              
MFA-TR*             AND FI.OPTION_CD         = DF.OPTION_CD                     
MFA-TR*             AND FI.COMPANY_NO        = '01'                             
MFA-TR*             AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                
MFA-TR*             AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                
MFA-TR*             AND FI.PROC_STATUS_CD    = 'AC'                             
MFA-TR*           ORDER BY FF.EFF_DATE_TO DESC                                  
MFA-TR*                   ,FF.EFF_DATE_FROM DESC                                
MFA-TR*                   ,SF.FACTOR_TEXT ASC                                   
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * DECLARE CURSOR TO RETRIEVE THE ROWS FOR PENDING STATUS AND     *        
      * FACTOR TYPE SHOULD BE FIXED FACTOR / COMBO FIXED.              *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE PEND_FIXED_FCTR_CUR CURSOR FOR                    
                 SELECT SF.FACTOR_TYPE                                  
                       ,SF.FACTOR_ID                                    
                       ,SF.FACTOR_TEXT                                  
                       ,FF.EFF_DATE_FROM                                
                       ,FF.EFF_DATE_TO                                  
                       ,FF.DURATION_REMAIN_NO                           
                       ,FF.FACTOR                                       
                       ,SF.FCTR_POWER_10                                
                       ,SF.VERS_PRORATE_CD                              
                       ,FI.OPT_DESC_INT                                 
                   FROM CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)             
                       ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)             
                       ,CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)             
                       ,CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)             
                  WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO           
                    AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE       
                    AND DF.IC_NO             = :DF-IC-NO                
                    AND DF.STATUS_CD         = :DF-STATUS-CD            
                    AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO     
                    AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO            
                    AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE        
                    AND FF.IC_NO             = DF.IC_NO                 
                    AND SF.FACTOR_ID         = FF.FACTOR_ID             
                    AND SF.FACTOR_TYPE      IN ('B','F')                
                    AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'      
                    AND FI.OPTION_CD         = DF.OPTION_CD             
                    AND FI.COMPANY_NO        = '01'                     
                    AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()        
                    AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()        
                    AND FI.PROC_STATUS_CD    = 'AC'                     
                  ORDER BY FF.EFF_DATE_TO DESC                          
                          ,FF.EFF_DATE_FROM DESC                        
                          ,SF.FACTOR_TEXT ASC                           
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PEND_FIXED_FCTR_CUR CURSOR FOR                            
MFA-TR*          SELECT SF.FACTOR_TYPE                                          
MFA-TR*                ,SF.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*                ,SF.VERS_PRORATE_CD                                      
MFA-TR*                ,FI.OPT_DESC_INT                                         
MFA-TR*            FROM CSS_FIXED_FCTR     FF                                   
MFA-TR*                ,CSS_SPCL_FCTR      SF                                   
MFA-TR*                ,CSS_ACCT_RTPK_AGR  DF                                   
MFA-TR*                ,CRM_RT_PKG_OPTION  FI                                   
MFA-TR*           WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                   
MFA-TR*             AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE               
MFA-TR*             AND DF.IC_NO             = :DF-IC-NO                        
MFA-TR*             AND DF.STATUS_CD         = :DF-STATUS-CD                    
MFA-TR*             AND FF.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO             
MFA-TR*             AND FF.ACCOUNT_NO        = DF.ACCOUNT_NO                    
MFA-TR*             AND FF.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                
MFA-TR*             AND FF.IC_NO             = DF.IC_NO                         
MFA-TR*             AND SF.FACTOR_ID         = FF.FACTOR_ID                     
MFA-TR*             AND SF.FACTOR_TYPE      IN ('B','F')                        
MFA-TR*             AND SF.RT_ATTR_INCTV_TYPE <> 'ADJUSTABLE RATE'              
MFA-TR*             AND FI.OPTION_CD         = DF.OPTION_CD                     
MFA-TR*             AND FI.COMPANY_NO        = '01'                             
MFA-TR*             AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                
MFA-TR*             AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                
MFA-TR*             AND FI.PROC_STATUS_CD    = 'AC'                             
MFA-TR*           ORDER BY FF.EFF_DATE_TO DESC                                  
MFA-TR*                   ,FF.EFF_DATE_FROM DESC                                
MFA-TR*                   ,SF.FACTOR_TEXT ASC                                   
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO      PIC X(13).                              
       01  PARM-CODE-UTIL-TYPE  PIC X(01).                              
       01  PARM-IC-NO           PIC X(04).                              
       01  PARM-STATUS-CD       PIC X(01).                              
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-IC-NO                              
                                PARM-STATUS-CD.                         
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04303_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04303_R1
              (                                                       
                    RETURN_CODE                INT                  
                   ,FACTOR_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,FACTOR_DESC CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,END_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,DURATION_REM_NO CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,FACTOR                     DECIMAL(13,4)            
                   ,APPL_METHOD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                   ,SWITCH_EXIT_FEE            DECIMAL(11,6)            
                   ,RATE_CHNG_EXIT_FEE         DECIMAL(11,6)            
                   ,OPTION_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                 
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE               AS RETURN_CODE         
                      ,FACTOR_TYPE               AS FACTOR_TYPE         
                      ,FACTOR_ID                 AS FACTOR_ID           
                      ,FACTOR_DESC               AS FACTOR_DESC         
                      ,START_DATE                AS START_DATE          
                      ,END_DATE                  AS END_DATE            
                      ,DURATION_REM_NO           AS DURATION_REM        
                      ,FACTOR                    AS FACTOR              
                      ,APPL_METHOD               AS APPL_METHOD         
                      ,SWITCH_EXIT_FEE           AS SWITCH_EXIT_FEE     
                      ,RATE_CHNG_EXIT_FEE        AS RATE_CHNG_EXIT_FEE  
                      ,OPTION_DESC               AS OPTION_DESC         
                  FROM #CSR04303_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE               AS RETURN_CODE                 
MFA-TR*               ,FACTOR_TYPE               AS FACTOR_TYPE                 
MFA-TR*               ,FACTOR_ID                 AS FACTOR_ID                   
MFA-TR*               ,FACTOR_DESC               AS FACTOR_DESC                 
MFA-TR*               ,START_DATE                AS START_DATE                  
MFA-TR*               ,END_DATE                  AS END_DATE                    
MFA-TR*               ,DURATION_REM_NO           AS DURATION_REM                
MFA-TR*               ,FACTOR                    AS FACTOR                      
MFA-TR*               ,APPL_METHOD               AS APPL_METHOD                 
MFA-TR*               ,SWITCH_EXIT_FEE           AS SWITCH_EXIT_FEE             
MFA-TR*               ,RATE_CHNG_EXIT_FEE        AS RATE_CHNG_EXIT_FEE          
MFA-TR*               ,OPTION_DESC               AS OPTION_DESC                 
MFA-TR*           FROM SESSION.CSR04303_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NUM              TO DF-ACCOUNT-NO            
                                               WS-ACCT-NO-4114.         
           MOVE PARM-CODE-UTIL-TYPE         TO DF-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO DF-IC-NO.                
           MOVE PARM-STATUS-CD              TO DF-STATUS-CD             
                                               WS-RTPK-AGR-STAT-4114.   
           MOVE 'EXIT FEE'                  TO WS-INCTV-TYPE-4114.      
                                                                        
           PERFORM 1100-VALIDATE-INPUT         THRU 1100-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * BASIC INPUT VALIDATION FOR ACCOUNT NO / UTIL TYPE/ IC NO      *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF WS-ACCOUNT-NUM > WS-ZERO AND DF-CODE-UTIL-TYPE > SPACES   
                                 AND DF-IC-NO > WS-ZERO                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '1100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'RECEIVE INPUT'         TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE SPACES                  TO TABLE-1                   
              MOVE SPACES                  TO TABLE-ELEMENT-1           
              MOVE SPACES                  TO HOSTVAR-ELEMENT-1         
      **********************************************************                
      *      IF PASSED INPUT VALUES ARE INVALID                *                
      **********************************************************                
              MOVE +1000                   TO S-RETURN-CODE             
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-DETERMINE-OPERATION    THRU 2200-EXIT.          
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                        TO S-RETURN-CODE          
              MOVE   0                        TO S-APPL-RETURN-CODE     
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2200-DETERMINE-OPERATION.                                     *        
      ******************************************************************        
       2200-DETERMINE-OPERATION.                                        
                                                                        
           PERFORM 2300-GET-EXIT-FEE-DET         THRU 2300-EXIT.        
                                                                        
           IF DF-STATUS-CD NOT EQUAL WS-PENDING                         
              MOVE WS-NO                      TO WS-PENDING-STATUS      
              PERFORM 7000-OPEN-FIXED-FCTR-CUR   THRU 7000-EXIT         
              PERFORM 7100-FETCH-FIXED-FCTR-CUR  THRU 7100-EXIT         
              PERFORM 2400-BUILD-RESULT-SET      THRU 2400-EXIT         
                                                 UNTIL NO-MORE-ROWS     
              PERFORM 7200-CLOSE-FIXED-FCTR-CUR  THRU 7200-EXIT         
           ELSE                                                         
              PERFORM 7300-OPEN-PEND-FIXED-FCTR  THRU 7300-EXIT         
              PERFORM 7400-FETCH-PEND-FIXED-FCTR THRU 7400-EXIT         
              PERFORM 2400-BUILD-RESULT-SET      THRU 2400-EXIT         
                                                 UNTIL NO-MORE-ROWS     
              PERFORM 7500-CLOSE-PEND-FIXED-FCTR THRU 7500-EXIT         
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETTING EXIT FEE / RATE CHANGE EXIT FEE FROM CPD04114 CPYC.    *        
      * 2300-GET-EXIT-FEE-DET.                                         *        
      ******************************************************************        
       2300-GET-EXIT-FEE-DET.                                           
                                                                        
           INITIALIZE                       WS-INPUT-DATE-4114          
                                            WS-REV-MTH-4114             
                                                                        
           PERFORM 6000-GET-PRO-INCTV-CPD4114  THRU                     
                   6000-CPD4114-EXIT                                    
           IF NO-ERRORS-4114                                            
              MOVE WS-EXIT-FEE-4114         TO S-SWITCH-EXIT-FEE        
              MOVE WS-RATE-CHNG-EXIT-FEE-4114                           
                                            TO S-RATE-CHNG-EXIT-FEE     
           ELSE                                                         
              MOVE WS-ZERO                  TO S-SWITCH-EXIT-FEE        
              MOVE WS-ZERO                  TO S-RATE-CHNG-EXIT-FEE     
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2400-BUILD-RESULT-SET.                                                 
      ******************************************************************        
       2400-BUILD-RESULT-SET.                                           
                                                                        
           IF WS-IND-DATE-FROM EQUAL WS-YES-NULL                        
              MOVE SPACES                   TO FF-EFF-DATE-FROM         
           END-IF.                                                      
                                                                        
           IF WS-IND-DATE-TO EQUAL WS-YES-NULL                          
              MOVE SPACES                   TO FF-EFF-DATE-TO           
           END-IF.                                                      
                                                                        
           IF WS-IND-DUR-REM-NO EQUAL WS-YES-NULL                       
               MOVE 'N/A'                   TO WS-DURATION-REM-NO       
           ELSE                                                         
               MOVE FF-DURATION-REMAIN-NO   TO WS-DUR-RMN-NO-TEMP-1     
               MOVE WS-DUR-RMN-NO-TEMP-1    TO WS-DUR-RMN-NO-TEMP-2     
               MOVE WS-DUR-RMN-NO-TEMP-2    TO WS-DURATION-REM-NO       
           END-IF.                                                      
                                                                        
           IF SF-FCTR-POWER-10 NOT EQUAL WS-ZERO                        
              COMPUTE WS-FACTOR-FF = FF-FACTOR * 10** SF-FCTR-POWER-10  
              MOVE WS-FACTOR-FF             TO FF-FACTOR                
              MOVE WS-ZERO                  TO SF-FCTR-POWER-10         
           END-IF.                                                      
                                                                        
           MOVE SF-FACTOR-TYPE              TO S-FACTOR-TYPE.           
           MOVE SF-FACTOR-ID                TO S-FACTOR-ID.             
           MOVE SF-FACTOR-TEXT              TO S-FACTOR-DESC.           
           MOVE FF-EFF-DATE-FROM            TO S-START-DATE.            
           MOVE FF-EFF-DATE-TO              TO S-END-DATE.              
           MOVE WS-DURATION-REM-NO          TO S-DURATION-REM-NO.       
           MOVE FF-FACTOR                   TO S-FACTOR.                
           MOVE SF-VERS-PRORATE-CD          TO S-APPL-METHOD.           
           MOVE FI-OPT-DESC-INT             TO S-OPTION-DESC.           
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
           IF PENDING-STATUS                                            
              PERFORM 7400-FETCH-PEND-FIXED-FCTR  THRU 7400-EXIT        
           ELSE                                                         
              PERFORM 7100-FETCH-FIXED-FCTR-CUR   THRU 7100-EXIT        
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6000-GET-PRO-INCTV-CPD04114                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD04114                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** ERROR ROUTINE FOR COPYBOOK CPD04114                         **         
      *****************************************************************         
       6999-ERROR-ROUTINE-CPD4114.                                      
                                                                        
           IF ERRORS-4114                                               
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6999-CPD4114-EXIT.                                               
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-FIXED-FCTR-CUR.                                      *        
      ******************************************************************        
       7000-OPEN-FIXED-FCTR-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN FIXED_FCTR_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
              MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-4                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-FETCH-FIXED-FCTR-CUR.                                     *        
      ******************************************************************        
       7100-FETCH-FIXED-FCTR-CUR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH FIXED_FCTR_CUR                                      
               INTO :SF-FACTOR-TYPE                                     
                   ,:SF-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:FF-EFF-DATE-FROM :WS-IND-DATE-FROM                  
                   ,:FF-EFF-DATE-TO :WS-IND-DATE-TO                      
                   ,:FF-DURATION-REMAIN-NO :WS-IND-DUR-REM-NO            
                   ,:FF-FACTOR                                          
                   ,:SF-FCTR-POWER-10                                   
                   ,:SF-VERS-PRORATE-CD                                 
                   ,:FI-OPT-DESC-INT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                    TO WS-NO-MORE-ROWS      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7100'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1              
                    MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2              
                    MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3              
                    MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2      
                    MOVE 'IC_NO'                TO TABLE-ELEMENT-3      
                    MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3    
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-CLOSE-FIXED-FCTR-CUR.                                     *        
      ******************************************************************        
       7200-CLOSE-FIXED-FCTR-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE FIXED_FCTR_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1                    
              MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2                    
              MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3                    
              MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-OPEN-PEND-FIXED-FCTR.                                     *        
      ******************************************************************        
       7300-OPEN-PEND-FIXED-FCTR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN PEND_FIXED_FCTR_CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
              MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'STATUS_CD'              TO TABLE-ELEMENT-4          
              MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE DF-STATUS-CD             TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-FETCH-PEND-FIXED-FCTR.                                    *        
      ******************************************************************        
       7400-FETCH-PEND-FIXED-FCTR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH PEND_FIXED_FCTR_CUR                                 
               INTO :SF-FACTOR-TYPE                                     
                   ,:SF-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:FF-EFF-DATE-FROM :WS-IND-DATE-FROM                  
                   ,:FF-EFF-DATE-TO :WS-IND-DATE-TO                      
                   ,:FF-DURATION-REMAIN-NO :WS-IND-DUR-REM-NO            
                   ,:FF-FACTOR                                          
                   ,:SF-FCTR-POWER-10                                   
                   ,:SF-VERS-PRORATE-CD                                 
                   ,:FI-OPT-DESC-INT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                    TO WS-NO-MORE-ROWS      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7400'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1              
                    MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2              
                    MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3              
                    MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1      
                    MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2      
                    MOVE 'IC_NO'                TO TABLE-ELEMENT-3      
                    MOVE 'STATUS_CD'            TO TABLE-ELEMENT-4      
                    MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1    
                    MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2    
                    MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3    
                    MOVE DF-STATUS-CD           TO TABLE-ELEMENT-4      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-CLOSE-PEND-FIXED-FCTR.                                    *        
      ******************************************************************        
       7500-CLOSE-PEND-FIXED-FCTR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE PEND_FIXED_FCTR_CUR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7500'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE 'CSS_FIXED_FCTR  '     TO TABLE-1                    
              MOVE 'CSS_SPCL_FCTR   '     TO TABLE-2                    
              MOVE 'CSS_ACCT_RTPK_AG'     TO TABLE-3                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'IC_NO'                TO TABLE-ELEMENT-3            
              MOVE 'STATUS_CD'            TO TABLE-ELEMENT-4            
              MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3          
              MOVE DF-STATUS-CD           TO TABLE-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04303_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04303_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04303_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04303_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,FACTOR_TYPE                                          
                  ,FACTOR_ID                                            
                  ,FACTOR_DESC                                          
                  ,START_DATE                                           
                  ,END_DATE                                             
                  ,DURATION_REM_NO                                      
                  ,FACTOR                                               
                  ,APPL_METHOD                                          
                  ,SWITCH_EXIT_FEE                                      
                  ,RATE_CHNG_EXIT_FEE                                   
                  ,OPTION_DESC                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-FACTOR-TYPE                                       
                  ,:S-FACTOR-ID                                         
                  ,:S-FACTOR-DESC                                       
                  ,:S-START-DATE                                        
                  ,:S-END-DATE                                          
                  ,:S-DURATION-REM-NO                                   
                  ,:S-FACTOR                                            
                  ,:S-APPL-METHOD                                       
                  ,:S-SWITCH-EXIT-FEE                                   
                  ,:S-RATE-CHNG-EXIT-FEE                                
                  ,:S-OPTION-DESC                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04303_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,FACTOR_TYPE                                                  
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,FACTOR_DESC                                                  
MFA-TR*           ,START_DATE                                                   
MFA-TR*           ,END_DATE                                                     
MFA-TR*           ,DURATION_REM_NO                                              
MFA-TR*           ,FACTOR                                                       
MFA-TR*           ,APPL_METHOD                                                  
MFA-TR*           ,SWITCH_EXIT_FEE                                              
MFA-TR*           ,RATE_CHNG_EXIT_FEE                                           
MFA-TR*           ,OPTION_DESC                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-FACTOR-TYPE                                               
MFA-TR*           ,:S-FACTOR-ID                                                 
MFA-TR*           ,:S-FACTOR-DESC                                               
MFA-TR*           ,:S-START-DATE                                                
MFA-TR*           ,:S-END-DATE                                                  
MFA-TR*           ,:S-DURATION-REM-NO                                           
MFA-TR*           ,:S-FACTOR                                                    
MFA-TR*           ,:S-APPL-METHOD                                               
MFA-TR*           ,:S-SWITCH-EXIT-FEE                                           
MFA-TR*           ,:S-RATE-CHNG-EXIT-FEE                                        
MFA-TR*           ,:S-OPTION-DESC                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04303_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
