       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04288.                                         
COB303 DATE-WRITTEN.     JUNE 18, 2009.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES A SINGLE INSTANCE OF THE CUSTOMER'S    *        
      *  ARCHIVE ACCOUNT PROFILE INFORMATION AT A SUMMARY LEVEL.       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
A37666*  06/19/09    SV95326  NEW PROGRAM FOR ARCHIVE ACCOUNT.         *        
A37666*  05/07/10    SJ97149  CHECKING EBILL FLAG AND RETURNING TO THE *        
A37666*                       RESULT SET FIELD RS-EBILL-REGISTER       *        
A32011*  04/08/11    PK98692  RETURN ITPA FLAG                         *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04288'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04288 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *    CSS_APPLIANCE                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
      *    HST_COAPPLICANT                                                      
           EXEC SQL                                                             
              INCLUDE TBHCOAPP                                                  
           END-EXEC.                                                            
                                                                        
      *    CSS_COMM_DATA                                                        
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
      *    CSS_CUST_PHONE                                                       
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
      *    CSS_CUST_STATS                                                       
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
      *    CSS_CUSTOMER                                                         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
      *    CSS_NAME                                                             
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *    CSS_PREMISE                                                          
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *    HST_ROOMMATE                                                         
           EXEC SQL                                                             
              INCLUDE TBHROOMT                                                  
           END-EXEC.                                                            
                                                                        
      *    HST_ACCOUNT                                                          
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
      *    CSS_CREDIT_HIST                                                      
A32011     EXEC SQL                                                             
A32011        INCLUDE TBCRHIST                                                  
A32011     END-EXEC.                                                            
                                                                        
      *    CSS_CRED_ITPA_HIST                                                   
A32011     EXEC SQL                                                             
A32011        INCLUDE TBCRITPA                                                  
A32011     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00011.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04288'.      
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO          PIC X(13).                      
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO       
                                        PIC 9(13).                      
           05  PARM-CUSTOMER-NO         PIC X(10).                      
           05  PARM-CUSTOMER-NO-RED     REDEFINES PARM-CUSTOMER-NO      
                                        PIC 9(10).                      
           05  PARM-PREMISE-NO          PIC X(10).                      
           05  PARM-PREMISE-NO-RED      REDEFINES PARM-PREMISE-NO       
                                        PIC 9(10).                      
           05  PARM-USERID              PIC X(07).                      
           05  PARM-BYPASS-ACCESS-HIST  PIC X(01).                      
                                                                        
       01  WS-FIELDS.                                                   
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-PREMISE-NO           PIC 9(10) VALUE ZERO.            
           05  WS-PREMISE-NO-NUM       PIC S9(10) COMP-3 VALUE ZERO.    
           05  WS-CUSTOMER-NO          PIC 9(10) VALUE ZERO.            
           05  WS-CUSTOMER-NO-NUM      PIC S9(10) COMP-3 VALUE ZERO.    
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-MULT-ACCOUNT-NO      PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-THREE-MONTHS-AGO-DT  PIC X(10) VALUE SPACES.          
           05  WS-THREE-MONTHS-AGO     PIC X(26) VALUE SPACES.          
           05  WS-RED-FLAG-NULL-IND    PIC S9(4) COMP VALUE 0.          
           05  WS-RED-FLAG-EXP-DT      PIC X(26) VALUE SPACES.          
           05  MULTIPLE-ROWS           PIC S9(04) COMP VALUE -811.      
COB305     05 WS-HOLD-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.              
           05  WS-COMPLAINT-COUNT      PIC S9(4) COMP VALUE 0.          
           05  WS-ORDER-TODAY          PIC X(01) VALUE 'N'.             
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
                                                                        
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-MULTI-ACCTS          PIC X(01) VALUE SPACE.           
A37666     05  WS-EBILL-REGISTER       PIC X(01) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  RS-CODE-ACCT-STAT       PIC X(01) VALUE SPACE.           
           05  RS-ACCT-STATUS-REASON   PIC X(01) VALUE SPACE.           
           05  RS-CREATE-DATE          PIC X(10) VALUE SPACE.           
           05  RS-FINAL-BILL-DATE      PIC X(10) VALUE SPACE.           
           05  RS-ARCHIVED-DATE        PIC X(10) VALUE SPACE.           
           05  RS-DBA                  PIC X(50) VALUE SPACE.           
           05  RS-XFER-FROM-ACCT       PIC X(13) VALUE SPACE.           
           05  RS-XFER-TO-ACCT         PIC X(13) VALUE SPACE.           
           05  RS-CREDIT-GROUP         PIC X(04) VALUE SPACE.           
           05  RS-AGL-ACCT-NO          PIC X(20) VALUE SPACE.           
           05  RS-APPLIANCE-EXIST      PIC X(01) VALUE SPACE.           
           05  RS-BILL-ADDR-FLAG       PIC X(01) VALUE SPACE.           
           05  RS-CUST-COMM-FLAG       PIC X(01) VALUE SPACE.           
           05  RS-LANDLORD-INFO        PIC X(01) VALUE SPACE.           
           05  RS-MULTI-ACCTS          PIC X(01) VALUE SPACE.           
           05  RS-RED-FLAG             PIC X(01) VALUE SPACE.           
           05  RS-CHECK-REFUND-INFO    PIC X(01) VALUE SPACE.           
           05  RS-ROOMMATE             PIC X(01) VALUE SPACE.           
           05  RS-SPEC-MTR-READ-INS    PIC X(01) VALUE SPACE.           
           05  RS-PHONE-NO             PIC X(10) VALUE SPACE.           
           05  RS-PHONE-TYPE           PIC X(01) VALUE SPACE.           
           05  RS-PASSWORD             PIC X(16) VALUE SPACE.           
           05  RS-SPOUSE-NAME          PIC X(70) VALUE SPACE.           
A37666     05  RS-EBILL-REGISTER       PIC X(01) VALUE SPACE.           
           05  RS-SPOUSE-SSN           PIC X(09) VALUE SPACE.           
           05  RS-TODAY                PIC X(26) VALUE SPACES.          
           05  RS-WRITE-OFF-FLAG       PIC X(01) VALUE SPACE.           
           05  RS-DEPOSIT-FLAG         PIC X(01) VALUE SPACE.           
A32011     05  RS-ITPA-FLAG            PIC X(01) VALUE SPACE.           
                                                                        
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE COMM_DATA CURSOR FOR                              
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMMUNICATION_ID, 121), ' ', '-'), ':', '.') 
           COMMUNICATION_ID,                                
                       COMPLAINT_FL,                                    
                       RED_FLAG_IND,                                    
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                              
                       COMM_ASSOC_CD,                                   
                       COMM_TYPE_CD,                                    
                       COMM_SUBTYPE_CODE,                               
                       PREMISE_NO,                                      
                       CUSTOMER_NO                                      
                FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                        
               WHERE (CUSTOMER_NO = :WS-CUSTOMER-NO-NUM)                
                  OR (PREMISE_NO = :WS-PREMISE-NO-NUM)                  
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COMM_DATA CURSOR FOR                                      
MFA-TR*         SELECT COMMUNICATION_ID,                                        
MFA-TR*                COMPLAINT_FL,                                            
MFA-TR*                RED_FLAG_IND,                                            
MFA-TR*                RED_FLAG_EXPIRE_DT,                                      
MFA-TR*                COMM_ASSOC_CD,                                           
MFA-TR*                COMM_TYPE_CD,                                            
MFA-TR*                COMM_SUBTYPE_CODE,                                       
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                CUSTOMER_NO                                              
MFA-TR*         FROM CSS_COMM_DATA                                              
MFA-TR*        WHERE (CUSTOMER_NO = :WS-CUSTOMER-NO-NUM)                        
MFA-TR*           OR (PREMISE_NO = :WS-PREMISE-NO-NUM)                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*      QUERYNO 7601                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
           EXEC SQL                                                     00000050
               INCLUDE CWSSP001                                         00000060
           END-EXEC.                                                    00000070
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13)                .          
       01  LINK-CUSTOMER-NO         PIC X(10)                .          
       01  LINK-PREMISE-NO          PIC X(10)                .          
       01  LINK-USERID              PIC X(07)                .          
       01  LINK-BYPASS-ACCESS-HIST  PIC X(01)                .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-ACCOUNT-NO                                         
               ,LINK-CUSTOMER-NO                                        
               ,LINK-PREMISE-NO                                         
               ,LINK-USERID                                             
               ,LINK-BYPASS-ACCESS-HIST                                 
               .                                                        
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :RS-RETURN-CODE              AS    RETURN_CODE            
             ,:RS-CODE-ACCT-STAT           AS    CODE_ACCT_STAT         
             ,:RS-ACCT-STATUS-REASON       AS    ACCT_STATUS_REASON     
             ,:RS-CREATE-DATE              AS    CREATE_DATE            
             ,:RS-FINAL-BILL-DATE          AS    [FINAL-BILL-DATE]        
             ,:RS-ARCHIVED-DATE            AS    ARCHIVED_DATE          
             ,:RS-DBA                      AS    DBA                    
             ,:RS-XFER-FROM-ACCT           AS    XFER_FROM_ACCT         
             ,:RS-XFER-TO-ACCT             AS    XFER_TO_ACCT           
             ,:RS-CREDIT-GROUP             AS    CREDIT_GROUP           
             ,:RS-AGL-ACCT-NO              AS    AGL_ACCT_NO            
             ,:RS-APPLIANCE-EXIST          AS    APPLIANCE_EXIST        
             ,:RS-BILL-ADDR-FLAG           AS    BILL_ADDR_FLAG         
             ,:RS-CUST-COMM-FLAG           AS    CUST_COMM_FLAG         
             ,:RS-LANDLORD-INFO            AS    LANDLORD_INFO          
             ,:RS-MULTI-ACCTS              AS    MULTI_ACCTS            
             ,:RS-RED-FLAG                 AS    RED_FLAG               
             ,:RS-CHECK-REFUND-INFO        AS    CHECK_REFUND_INFO      
             ,:RS-ROOMMATE                 AS    ROOMMATE               
             ,:RS-SPEC-MTR-READ-INS        AS    SPEC_MTR_READ_INS      
             ,:RS-PHONE-NO                 AS    PHONE_NO               
             ,:RS-PHONE-TYPE               AS    PHONE_TYPE             
             ,:RS-PASSWORD                 AS    PASSWORD               
             ,:RS-SPOUSE-NAME              AS    SPOUSE_NAME            
             ,LTRIM(RTRIM(:RS-SPOUSE-SSN))        AS    SPOUSE_SSN             
             ,:RS-TODAY                    AS    TODAY                  
             ,:RS-WRITE-OFF-FLAG           AS    WRITE_OFF_FLAG         
             ,:RS-DEPOSIT-FLAG             AS    DEPOSIT_FLAG           
A37666       ,:RS-EBILL-REGISTER           AS    EBILL_REGISTER         
A32011       ,:RS-ITPA-FLAG                AS    ITPA_FLAG              
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-CODE-ACCT-STAT           AS    CODE_ACCT_STAT                 
MFA-TR*      ,:RS-ACCT-STATUS-REASON       AS    ACCT_STATUS_REASON             
MFA-TR*      ,:RS-CREATE-DATE              AS    CREATE_DATE                    
MFA-TR*      ,:RS-FINAL-BILL-DATE          AS    FINAL-BILL-DATE                
MFA-TR*      ,:RS-ARCHIVED-DATE            AS    ARCHIVED_DATE                  
MFA-TR*      ,:RS-DBA                      AS    DBA                            
MFA-TR*      ,:RS-XFER-FROM-ACCT           AS    XFER_FROM_ACCT                 
MFA-TR*      ,:RS-XFER-TO-ACCT             AS    XFER_TO_ACCT                   
MFA-TR*      ,:RS-CREDIT-GROUP             AS    CREDIT_GROUP                   
MFA-TR*      ,:RS-AGL-ACCT-NO              AS    AGL_ACCT_NO                    
MFA-TR*      ,:RS-APPLIANCE-EXIST          AS    APPLIANCE_EXIST                
MFA-TR*      ,:RS-BILL-ADDR-FLAG           AS    BILL_ADDR_FLAG                 
MFA-TR*      ,:RS-CUST-COMM-FLAG           AS    CUST_COMM_FLAG                 
MFA-TR*      ,:RS-LANDLORD-INFO            AS    LANDLORD_INFO                  
MFA-TR*      ,:RS-MULTI-ACCTS              AS    MULTI_ACCTS                    
MFA-TR*      ,:RS-RED-FLAG                 AS    RED_FLAG                       
MFA-TR*      ,:RS-CHECK-REFUND-INFO        AS    CHECK_REFUND_INFO              
MFA-TR*      ,:RS-ROOMMATE                 AS    ROOMMATE                       
MFA-TR*      ,:RS-SPEC-MTR-READ-INS        AS    SPEC_MTR_READ_INS              
MFA-TR*      ,:RS-PHONE-NO                 AS    PHONE_NO                       
MFA-TR*      ,:RS-PHONE-TYPE               AS    PHONE_TYPE                     
MFA-TR*      ,:RS-PASSWORD                 AS    PASSWORD                       
MFA-TR*      ,:RS-SPOUSE-NAME              AS    SPOUSE_NAME                    
MFA-TR*      ,STRIP(:RS-SPOUSE-SSN)        AS    SPOUSE_SSN                     
MFA-TR*      ,:RS-TODAY                    AS    TODAY                          
MFA-TR*      ,:RS-WRITE-OFF-FLAG           AS    WRITE_OFF_FLAG                 
MFA-TR*      ,:RS-DEPOSIT-FLAG             AS    DEPOSIT_FLAG                   
MFA-TR*      ,:RS-EBILL-REGISTER           AS    EBILL_REGISTER                 
MFA-TR*      ,:RS-ITPA-FLAG                AS    ITPA_FLAG                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO.           
           MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO.          
           MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO.           
           MOVE LINK-USERID               TO PARM-USERID.               
           MOVE LINK-BYPASS-ACCESS-HIST   TO PARM-BYPASS-ACCESS-HIST.   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO-RED   TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO         TO WS-ACCOUNT-NO-NUM.             
           MOVE WS-ACCOUNT-NO         TO HA-ACCOUNT-NO.                 
           MOVE PARM-PREMISE-NO-RED   TO WS-PREMISE-NO.                 
           MOVE WS-PREMISE-NO         TO WS-PREMISE-NO-NUM.             
           MOVE PARM-CUSTOMER-NO-RED  TO WS-CUSTOMER-NO.                
           MOVE WS-CUSTOMER-NO        TO WS-CUSTOMER-NO-NUM.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           PERFORM 2300-INSERT-ACCESS    THRU 2300-EXIT.                
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 7050-GET-TIMESTAMP    THRU 7050-EXIT.                
           MOVE WS-CURRENT-TIMESTAMP     TO RS-TODAY.                   
           PERFORM 7000-SELECT-ACCOUNT   THRU 7000-EXIT.                
           MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE HA-PREMISE-NO         TO PR-PREMISE-NO               
              MOVE HA-CODE-ACCT-STAT     TO RS-CODE-ACCT-STAT           
              MOVE HA-CODE-STATUS-REASON TO RS-ACCT-STATUS-REASON       
              MOVE HA-ACCT-CREATE-DT     TO RS-CREATE-DATE              
              MOVE HA-ACCT-FINALED-DT    TO RS-FINAL-BILL-DATE          
              MOVE HA-ARCHIVED-DT        TO RS-ARCHIVED-DATE            
              MOVE HA-CREDIT-GROUP       TO RS-CREDIT-GROUP             
              MOVE HA-DIST-ACCT-NO       TO RS-AGL-ACCT-NO              
              MOVE HA-REFUND-FL          TO RS-CHECK-REFUND-INFO        
              MOVE HA-DEPOSIT-FL         TO RS-DEPOSIT-FLAG             
                                                                        
              IF HA-ADDRESS-ID > 0                                      
                  MOVE 'Y' TO RS-BILL-ADDR-FLAG                         
              ELSE                                                      
                  MOVE 'N' TO RS-BILL-ADDR-FLAG                         
              END-IF                                                    
                                                                        
              IF HA-ACCT-XFER-FROM-LST  > 0                             
                 MOVE HA-ACCT-XFER-FROM-LST TO RS-XFER-FROM-ACCT        
              END-IF                                                    
                                                                        
              IF HA-ACCT-XFER-TO > 0                                    
                 MOVE HA-ACCT-XFER-TO TO RS-XFER-TO-ACCT                
              END-IF                                                    
                                                                        
              PERFORM 7100-CHECK-MULTI-ACCTS THRU 7100-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 7150-CHECK-MULTI-ACCTS-AT  THRU 7150-EXIT      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-CUSTOMER-NO-NUM    TO HA-CUSTOMER-NO              
              MOVE WS-PREMISE-NO-NUM     TO PR-PREMISE-NO               
              MOVE ZEROS                 TO HA-ACCOUNT-NO               
              MOVE SPACES                TO RS-CODE-ACCT-STAT           
              MOVE SPACES                TO RS-ACCT-STATUS-REASON       
              MOVE SPACES                TO RS-CREATE-DATE              
              MOVE SPACES                TO RS-FINAL-BILL-DATE          
              MOVE SPACES                TO RS-ARCHIVED-DATE            
              MOVE SPACES                TO RS-XFER-FROM-ACCT           
              MOVE SPACES                TO RS-XFER-TO-ACCT             
              MOVE SPACES                TO RS-CREDIT-GROUP             
              MOVE SPACES                TO RS-AGL-ACCT-NO              
              MOVE 'N'                   TO RS-BILL-ADDR-FLAG           
              MOVE 'N'                   TO RS-LANDLORD-INFO            
              MOVE 'N'                   TO RS-WRITE-OFF-FLAG           
              MOVE 'N'                   TO RS-CHECK-REFUND-INFO        
              MOVE 'N'                   TO RS-DEPOSIT-FLAG             
           END-IF.                                                      
           PERFORM 7200-SELECT-PREMISE THRU 7200-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              IF PR-SPCL-READ-INSTR-LEN  > 0                            
                 MOVE 'Y' TO RS-SPEC-MTR-READ-INS                       
              ELSE                                                      
                 MOVE 'N' TO RS-SPEC-MTR-READ-INS                       
              END-IF                                                    
                                                                        
              IF PR-CODE-RENTAL-PROP = 'C' OR 'D' OR 'S'                
                  MOVE 'Y' TO RS-LANDLORD-INFO                          
              ELSE                                                      
                  MOVE 'N' TO RS-LANDLORD-INFO                          
              END-IF                                                    
                                                                        
              PERFORM 7250-APPLIANCES THRU 7250-EXIT                    
           ELSE                                                         
              MOVE 'N' TO RS-SPEC-MTR-READ-INS                          
              MOVE 'N' TO RS-LANDLORD-INFO                              
              MOVE 'N' TO RS-APPLIANCE-EXIST                            
           END-IF.                                                      
                                                                        
           MOVE 'N' TO RS-ROOMMATE.                                     
           PERFORM 7300-SELECT-ROOMMATE      THRU 7300-EXIT.            
           IF RS-ROOMMATE = 'N'                                         
              PERFORM 7350-SELECT-COAPPLICANT   THRU 7350-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 7400-SPOUSE-INFO    THRU 7400-EXIT.                  
           PERFORM 7450-PHONE-NUMBER   THRU 7450-EXIT.                  
A37666     PERFORM 7455-EBILL-REGISTER THRU 7455-EXIT.                  
A37666     IF WS-EBILL-REGISTER = 'Y'                                   
A37666        MOVE 'Y' TO RS-EBILL-REGISTER                             
A37666     ELSE                                                         
A37666        PERFORM 7500-EBILL-REGISTER THRU 7500-EXIT                
A37666        IF WS-EBILL-REGISTER = 'Y'                                
A37666           MOVE 'Y' TO RS-EBILL-REGISTER                          
A37666        ELSE                                                      
A37666           MOVE 'N' TO RS-EBILL-REGISTER                          
A37666        END-IF                                                    
A37666     END-IF.                                                      
           PERFORM 7550-SELECT-TBNAME  THRU 7550-EXIT.                  
           MOVE DQ-FULL-NAME           TO RS-DBA.                       
           PERFORM 7600-COMMUNICATIONS THRU 7600-EXIT.                  
           IF WS-MULTI-ACCTS = 'Y' AND HA-ACCOUNT-NO > 0                
               PERFORM 7650-WRITE-OFFS THRU 7650-EXIT                   
               IF RS-WRITE-OFF-FLAG = 'N'                               
                   PERFORM 7700-WRITE-OFFS-AT THRU 7700-EXIT            
               END-IF                                                   
           ELSE                                                         
               MOVE 'N' TO RS-WRITE-OFF-FLAG                            
           END-IF.                                                      
A32011     PERFORM 7720-ITPA-ALERT     THRU 7720-EXIT.                  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-INSERT-ACCESS.                                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2300-INSERT-ACCESS.                                              
                                                                        
           IF PARM-BYPASS-ACCESS-HIST NOT = 'Y'                         
              AND WS-CUSTOMER-NO-NUM > 0                                
                  PERFORM 8000-INSERT-TABLE THRU 8000-EXIT              
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT HA.CUSTOMER_NO                                     
                    ,HA.PREMISE_NO                                      
                    ,HA.CODE_ACCT_STAT                                  
                    ,HA.CODE_STATUS_REASON                              
                    ,HA.ACCT_CREATE_DT                                  
                    ,HA.ACCT_FINALED_DT                                 
                    ,HA.ARCHIVED_DT                                     
                    ,HA.ACCT_XFER_FROM_LST                              
                    ,HA.ACCT_XFER_TO                                    
                    ,HA.CREDIT_GROUP                                    
                    ,HA.ADDRESS_ID                                      
                    ,HA.DIST_ACCT_NO                                    
                    ,HA.REFUND_FL                                       
                    ,HA.DEPOSIT_FL                                      
                INTO :HA-CUSTOMER-NO                                    
                    ,:HA-PREMISE-NO                                     
                    ,:HA-CODE-ACCT-STAT                                 
                    ,:HA-CODE-STATUS-REASON                             
                    ,:HA-ACCT-CREATE-DT                                 
                    ,:HA-ACCT-FINALED-DT                                
                    ,:HA-ARCHIVED-DT                                    
                    ,:HA-ACCT-XFER-FROM-LST                             
                    ,:HA-ACCT-XFER-TO                                   
                    ,:HA-CREDIT-GROUP                                   
                    ,:HA-ADDRESS-ID                                     
                    ,:HA-DIST-ACCT-NO                                   
                    ,:HA-REFUND-FL                                      
                    ,:HA-DEPOSIT-FL                                     
                FROM HST_ACCOUNT  HA WITH(READUNCOMMITTED)                      
               WHERE HA.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HA.CUSTOMER_NO                                             
MFA-TR*             ,HA.PREMISE_NO                                              
MFA-TR*             ,HA.CODE_ACCT_STAT                                          
MFA-TR*             ,HA.CODE_STATUS_REASON                                      
MFA-TR*             ,HA.ACCT_CREATE_DT                                          
MFA-TR*             ,HA.ACCT_FINALED_DT                                         
MFA-TR*             ,HA.ARCHIVED_DT                                             
MFA-TR*             ,HA.ACCT_XFER_FROM_LST                                      
MFA-TR*             ,HA.ACCT_XFER_TO                                            
MFA-TR*             ,HA.CREDIT_GROUP                                            
MFA-TR*             ,HA.ADDRESS_ID                                              
MFA-TR*             ,HA.DIST_ACCT_NO                                            
MFA-TR*             ,HA.REFUND_FL                                               
MFA-TR*             ,HA.DEPOSIT_FL                                              
MFA-TR*         INTO :HA-CUSTOMER-NO                                            
MFA-TR*             ,:HA-PREMISE-NO                                             
MFA-TR*             ,:HA-CODE-ACCT-STAT                                         
MFA-TR*             ,:HA-CODE-STATUS-REASON                                     
MFA-TR*             ,:HA-ACCT-CREATE-DT                                         
MFA-TR*             ,:HA-ACCT-FINALED-DT                                        
MFA-TR*             ,:HA-ARCHIVED-DT                                            
MFA-TR*             ,:HA-ACCT-XFER-FROM-LST                                     
MFA-TR*             ,:HA-ACCT-XFER-TO                                           
MFA-TR*             ,:HA-CREDIT-GROUP                                           
MFA-TR*             ,:HA-ADDRESS-ID                                             
MFA-TR*             ,:HA-DIST-ACCT-NO                                           
MFA-TR*             ,:HA-REFUND-FL                                              
MFA-TR*             ,:HA-DEPOSIT-FL                                             
MFA-TR*         FROM HST_ACCOUNT  HA                                            
MFA-TR*        WHERE HA.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'HST_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-TIMESTAMP.                                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7050-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET   :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES          TO ABEND-TABLES                     
               MOVE SPACES          TO ABEND-SQL-PREDICATES             
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '7050'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SET'           TO ABEND-FUNCTION                   
               MOVE 'TIME_STAMP'    TO TABLE-ELEMENT-1                  
               MOVE WS-CURRENT-TIMESTAMP TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-CHECK-MULTI-ACCTS                                         *        
      *     CHECK FOR MULTIPLE ACCTS FOR THE CUSTOMER                  *        
      ******************************************************************        
                                                                        
       7100-CHECK-MULTI-ACCTS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
                INTO :WS-MULT-ACCOUNT-NO                                
                FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO = :HA-CUSTOMER-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-MULT-ACCOUNT-NO                                        
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO = :HA-CUSTOMER-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
           OR -811                                                      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 MOVE 'N' TO RS-MULTI-ACCTS                             
              ELSE                                                      
                 MOVE 'Y' TO RS-MULTI-ACCTS                             
                 MOVE 'Y' TO WS-MULTI-ACCTS                             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'HST_ACCOUNT'        TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HA-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-CHECK-MULTI-ACCTS-AT                                      *        
      *     CHECK FOR MULTIPLE ACCTS FOR THE CUSTOMER IN ACCOUNT TABLE.*        
      ******************************************************************        
      *                                                                         
       7150-CHECK-MULTI-ACCTS-AT.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.ACCOUNT_NO                                      
                INTO :WS-MULT-ACCOUNT-NO                                
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.CUSTOMER_NO = :HA-CUSTOMER-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_NO                                              
MFA-TR*         INTO :WS-MULT-ACCOUNT-NO                                        
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.CUSTOMER_NO = :HA-CUSTOMER-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
           OR -811                                                      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811        
                 MOVE 'Y' TO RS-MULTI-ACCTS                             
                 MOVE 'Y' TO WS-MULTI-ACCTS                             
              ELSE                                                      
                 MOVE 'N' TO RS-MULTI-ACCTS                             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE HA-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-SELECT-PREMISE.                                           *        
      *     DETERMINE IF GAS, ELECTRIC, AND LIGHTING SERVICE IS ACTIVE *        
      ******************************************************************        
                                                                        
       7200-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT SPCL_READ_INSTR,                                   
                     CODE_RENTAL_PROP                                   
                INTO :PR-SPCL-READ-INSTR,                               
                     :PR-CODE-RENTAL-PROP                               
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SPCL_READ_INSTR,                                           
MFA-TR*              CODE_RENTAL_PROP                                           
MFA-TR*         INTO :PR-SPCL-READ-INSTR,                                       
MFA-TR*              :PR-CODE-RENTAL-PROP                                       
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-APPLIANCES.                                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7250-APPLIANCES.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                         
                INTO :LA-PREMISE-NO                                     
                FROM CSS_APPLIANCE WITH(READUNCOMMITTED)                        
               WHERE PREMISE_NO  = :WS-PREMISE-NO-NUM                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO                                                 
MFA-TR*         INTO :LA-PREMISE-NO                                             
MFA-TR*         FROM CSS_APPLIANCE                                              
MFA-TR*        WHERE PREMISE_NO  = :WS-PREMISE-NO-NUM                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-APPLIANCE-EXIST                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-APPLIANCE-EXIST                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7250'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_APPLIANCE' TO TABLE-1                      
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE WS-PREMISE-NO-NUM TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-ROOMMATE                                           *        
      *     DETERMINE IF ROOMMATE EXISTS                               *        
      ******************************************************************        
                                                                        
       7300-SELECT-ROOMMATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :RX-ACCOUNT-NO                                     
                FROM HST_ROOMMATE WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :RX-ACCOUNT-NO                                             
MFA-TR*         FROM HST_ROOMMATE                                               
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN MULTIPLE-ROWS                                       
                   MOVE 'Y' TO RS-ROOMMATE                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-ROOMMATE                              
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME TO ABEND-PROGRAM                    
                  MOVE '7300'            TO ACTIVE-PARAGRAPH            
                  MOVE 'SELECT'          TO ABEND-FUNCTION              
                  MOVE 'HST_ROOMMATE'    TO TABLE-1                     
                  MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1             
                  MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-SELECT-COAPPLICANT                                        *        
      *     DETERMINE IF COAPPLICANT EXISTS                            *        
      ******************************************************************        
                                                                        
       7350-SELECT-COAPPLICANT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :RY-ACCOUNT-NO                                     
                FROM HST_COAPPLICANT WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :RY-ACCOUNT-NO                                             
MFA-TR*         FROM HST_COAPPLICANT                                            
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                            
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7350                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN MULTIPLE-ROWS                                       
                   MOVE 'Y' TO RS-ROOMMATE                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-ROOMMATE                              
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '7350'            TO ACTIVE-PARAGRAPH            
                  MOVE 'SELECT'          TO ABEND-FUNCTION              
                  MOVE 'HST_COAPPLICANT' TO TABLE-1                     
                  MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1             
                  MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SPOUSE-INFO.                                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7400-SPOUSE-INFO.                                                
                                                                        
           EXEC SQL                                                     
              SELECT CE.SSN,                                            
                     DQ.FIRST_NAME,                                     
                     DQ.MIDDLE_NAME,                                    
                     DQ.LAST_NAME                                       
                INTO :CE-SSN,                                           
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME                                      
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                   
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CE.CUSTOMER_NO   = :HA-CUSTOMER-NO                 
                 AND CE.CUSTOMER_TYPE = 'S'                             
                 AND DQ.NAME_ID       = CE.NAME_ID                      
                 AND DQ.NAME_TYPE     = 'SN'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09260000
MFA-TR*       SELECT CE.SSN,                                            09270000
MFA-TR*              DQ.FIRST_NAME,                                     09380000
MFA-TR*              DQ.MIDDLE_NAME,                                    09390000
MFA-TR*              DQ.LAST_NAME                                       09400000
MFA-TR*         INTO :CE-SSN,                                           09410000
MFA-TR*              :DQ-FIRST-NAME,                                    09520000
MFA-TR*              :DQ-MIDDLE-NAME,                                   09530000
MFA-TR*              :DQ-LAST-NAME                                      09540000
MFA-TR*         FROM CSS_CUST_STATS CE,                                 09550000
MFA-TR*              CSS_NAME DQ                                        09560000
MFA-TR*        WHERE CE.CUSTOMER_NO   = :HA-CUSTOMER-NO                 09570000
MFA-TR*          AND CE.CUSTOMER_TYPE = 'S'                             09580000
MFA-TR*          AND DQ.NAME_ID       = CE.NAME_ID                      09590000
MFA-TR*          AND DQ.NAME_TYPE     = 'SN'                            09600000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                    09610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CE-SSN         TO RS-SPOUSE-SSN                 
                   MOVE DQ-FIRST-NAME  TO WS-EMB-INPUT (1:15)           
                   MOVE DQ-MIDDLE-NAME TO WS-EMB-INPUT (16:15)          
                   MOVE DQ-LAST-NAME   TO WS-EMB-INPUT (31:40)          
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT   
                   MOVE WS-CMP-TABLE   TO RS-SPOUSE-NAME                
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RS-SPOUSE-SSN                         
                                  RS-SPOUSE-NAME                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE HA-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7450-PHONE-NUMBER.                                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7450-PHONE-NUMBER.                                               
                                                                        
           EXEC SQL                                                     
              SELECT NAME_FORMAT                                        
                INTO :DQ-NAME-FORMAT                                    
                FROM CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
               WHERE CU.CUSTOMER_NO   = :HA-CUSTOMER-NO                 
                 AND CU.NAME_ID       = DQ.NAME_ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09260000
MFA-TR*       SELECT NAME_FORMAT                                        09270000
MFA-TR*         INTO :DQ-NAME-FORMAT                                    09410000
MFA-TR*         FROM CSS_NAME DQ,                                       09550000
MFA-TR*              CSS_CUSTOMER CU                                    09560000
MFA-TR*        WHERE CU.CUSTOMER_NO   = :HA-CUSTOMER-NO                 09570000
MFA-TR*          AND CU.NAME_ID       = DQ.NAME_ID                      09590000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                    09610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'I'                              
                       MOVE 'H1' TO CB-PHONE-TYPE                       
                       MOVE 'H'  TO RS-PHONE-TYPE                       
                   ELSE                                                 
                       MOVE 'B1' TO CB-PHONE-TYPE                       
                       MOVE 'B'  TO RS-PHONE-TYPE                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RS-PHONE-TYPE                         
                                  RS-PHONE-NO                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7450'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE HA-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF RS-PHONE-TYPE > ' '                                       
               EXEC SQL                                                 
                  SELECT PHONE_NO                                       
                    INTO :CB-PHONE-NO                                   
                    FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                   
                   WHERE CUSTOMER_NO   = :HA-CUSTOMER-NO                
                     AND PHONE_TYPE    = :CB-PHONE-TYPE                 
                     AND CUSTOMER_TYPE = 'C'                            
                                                                 
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                 15225100
MFA-TR*           SELECT PHONE_NO                                       15225200
MFA-TR*             INTO :CB-PHONE-NO                                   15225400
MFA-TR*             FROM CSS_CUST_PHONE                                 15225600
MFA-TR*            WHERE CUSTOMER_NO   = :HA-CUSTOMER-NO                15225700
MFA-TR*              AND PHONE_TYPE    = :CB-PHONE-TYPE                 15225800
MFA-TR*              AND CUSTOMER_TYPE = 'C'                            15225900
MFA-TR*             WITH UR                                                     
MFA-TR*          QUERYNO 7450                                                   
MFA-TR*        END-EXEC                                                 15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE CB-PHONE-NO TO RS-PHONE-NO                  
                   WHEN NOT-FOUND                                       
                       MOVE SPACES TO RS-PHONE-NO                       
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME     TO ABEND-PROGRAM           
                       MOVE '7450'           TO ACTIVE-PARAGRAPH        
                       MOVE 'SELECT'         TO ABEND-FUNCTION          
                       MOVE 'CSS_CUST_PHONE' TO TABLE-1                 
                       MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1         
                       MOVE HA-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1       
                       MOVE 'PHONE_TYPE'     TO TABLE-ELEMENT-2         
                       MOVE CB-PHONE-TYPE    TO HOSTVAR-ELEMENT-2       
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
               END-EVALUATE
           END-IF.                                            
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
A37666******************************************************************        
A37666* 7455-EBILL-REGISTER                                            *        
A37666*     CHECK EBILL-REGISTER_IND ON F 7455- FIRSTS                 *        
A37666******************************************************************        
A37666                                                                  
A37666 7455-EBILL-REGISTER.                                             
A37666                                                                  
A37666     EXEC SQL                                                     
A37666        SELECT EBILL_REGISTER_IND,                                
A37666               PASSWORD_TX                                        
A37666          INTO :WS-EBILL-REGISTER,                                
A37666               :CE-PASSWORD-TX                                    
A37666          FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
A37666         WHERE CUSTOMER_NO = :HA-CUSTOMER-NO                      
A37666           AND CUSTOMER_TYPE = 'C'                                
A37666                                                           
A37666                                                      
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EBILL_REGISTER_IND,                                        
MFA-TR*              PASSWORD_TX                                                
MFA-TR*         INTO :WS-EBILL-REGISTER,                                        
MFA-TR*              :CE-PASSWORD-TX                                            
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO = :HA-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7455                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666                                                                  
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666                                                                  
A37666     EVALUATE WS-ACTIVE-RETURN-CODE                               
A37666         WHEN SUCCESSFUL-CALL                                     
A37666             MOVE CE-PASSWORD-TX       TO RS-PASSWORD             
A37666         WHEN NOT-FOUND                                           
A37666             MOVE SPACES               TO RS-PASSWORD             
A37666         WHEN OTHER                                               
A37666             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
A37666             MOVE '7455'               TO ACTIVE-PARAGRAPH        
A37666             MOVE 'SELECT'             TO ABEND-FUNCTION          
A37666             MOVE 'CSS_CUST_STATS'     TO TABLE-1                 
A37666             MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
A37666             MOVE HA-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
A37666             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
A37666             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
A37666     END-EVALUATE.                                                
A37666                                                                  
A37666 7455-EXIT.                                                       
A37666     EXIT.                                                        
A37666                                                                  
A37666******************************************************************        
A37666* 7500A-EBILL-REGISTER                                           *        
A37666*     CHECK EBILL-REGISTER_IND IS SET FOR SPOUSE                 *        
A37666******************************************************************        
A37666                                                                  
A37666 7500-EBILL-REGISTER.                                             
A37666                                                                  
A37666     EXEC SQL                                                     
A37666        SELECT EBILL_REGISTER_IND                                 
A37666          INTO :WS-EBILL-REGISTER                                 
A37666          FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
A37666         WHERE CUSTOMER_NO = :HA-CUSTOMER-NO                      
A37666           AND CUSTOMER_TYPE = 'S'                                
A37666                                                           
A37666                                                      
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EBILL_REGISTER_IND                                         
MFA-TR*         INTO :WS-EBILL-REGISTER                                         
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO = :HA-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666                                                                  
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A37666        NEXT SENTENCE                                             
A37666     ELSE                                                         
A37666        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
A37666        MOVE '7500'               TO ACTIVE-PARAGRAPH             
A37666        MOVE 'SELECT'             TO ABEND-FUNCTION               
A37666        MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
A37666        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
A37666        MOVE HA-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
A37666        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A37666        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A37666     END-IF.                                                      
A37666                                                                  
A37666 7500-EXIT.                                                       
A37666     EXIT.                                                        
A37666                                                                  
      ******************************************************************        
      * 7550-SELECT-TBNAME.                                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7550-SELECT-TBNAME.                                              
                                                                        
           EXEC SQL                                                     
              SELECT DQ.FULL_NAME                                       
                INTO :DQ-FULL-NAME                                      
                FROM CSS_NAME           DQ WITH(READUNCOMMITTED),               
                     HST_ACCT_BILL_NMES N8 WITH(READUNCOMMITTED)                
               WHERE N8.ACCOUNT_NO  = :WS-ACCOUNT-NO-NUM                
                 AND DQ.NAME_ID     = N8.NAME_ID                        
                 AND DQ.NAME_TYPE   = 'DB'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26250000
MFA-TR*       SELECT DQ.FULL_NAME                                       26260000
MFA-TR*         INTO :DQ-FULL-NAME                                      26270000
MFA-TR*         FROM CSS_NAME           DQ,                             26280000
MFA-TR*              HST_ACCT_BILL_NMES N8                              26290000
MFA-TR*        WHERE N8.ACCOUNT_NO  = :WS-ACCOUNT-NO-NUM                26300000
MFA-TR*          AND DQ.NAME_ID     = N8.NAME_ID                        26310000
MFA-TR*          AND DQ.NAME_TYPE   = 'DB'                              26320000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC.                                                    26330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                    TO DQ-FULL-NAME         
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7500'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT-TBNAME'           TO ABEND-FUNCTION       
                 MOVE 'CSS_NAME'                TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-COMMUNICATIONS                                            *        
      * 1.  SET RS-CUST-COMM-FLAG IF CUSTOMER/ACCOUNT/PREMISE HAS      *        
      *     ANY COMMUNICATIONS.                                        *        
      * 2.  SET RS-RED-FLAG IF CUSTOMER/ACCOUNT/PREMISE HAS ANY        *        
      *     UNEXPIRED RED FLAGS.                                       *        
      * 3.  SET RS-RED-FLAG IF CUSTOMER/ACCOUNT/PREMISE HAS MORE THAN  *        
      *     TWO COMPLAINTS WITHIN THE PAST THREE MONTHS.               *        
      ******************************************************************        
                                                                        
       7600-COMMUNICATIONS.                                             
                                                                        
           MOVE 'N' TO RS-CUST-COMM-FLAG                                
                       RS-RED-FLAG.                                     
           MOVE 0   TO WS-COMPLAINT-COUNT.                              
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -3, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-THREE-MONTHS-AGO-DT                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 3 MONTH)                       
MFA-TR*          INTO :WS-THREE-MONTHS-AGO-DT                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-THREE-MONTHS-AGO-DT TO WS-THREE-MONTHS-AGO(1:10).    
           MOVE '-00.00.00.000000'     TO WS-THREE-MONTHS-AGO(11:16).   
                                                                        
           MOVE WS-CURRENT-DATE       TO WS-RED-FLAG-EXP-DT(1:10).      
           MOVE '-00.00.00.000000'    TO WS-RED-FLAG-EXP-DT(11:16).     
                                                                        
           IF WS-CUSTOMER-NO-NUM = 0                                    
              MOVE 9999999999  TO  WS-CUSTOMER-NO-NUM                   
           END-IF.                                                      
                                                                        
           IF WS-PREMISE-NO-NUM = 0                                     
              MOVE 9999999999  TO  WS-PREMISE-NO-NUM                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN COMM_DATA                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_COMM_DATA'      TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-PREMISE-NO-NUM    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'N' TO  WS-ORDER-TODAY.                                 
                                                                        
           PERFORM 7601-FETCH-COMM-DATA THRU 7601-EXIT.                 
                                                                        
           EXEC SQL                                                     
               CLOSE COMM_DATA                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_COMM_DATA'      TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE 'PERMISE_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-PREMISE-NO-NUM    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-COMPLAINT-COUNT > 2                                    
              MOVE 'Y' TO RS-RED-FLAG                                   
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7601-FETCH-COMM-DATA.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7601-FETCH-COMM-DATA.                                            
                                                                        
           EXEC SQL                                                     
               FETCH COMM_DATA                                          
                INTO :KO-COMMUNICATION-ID,                              
                     :KO-COMPLAINT-FL,                                  
                     :KO-RED-FLAG-IND,                                  
                     :KO-RED-FLAG-EXPIRE-DT :WS-RED-FLAG-NULL-IND,       
                     :KO-COMM-ASSOC-CD,                                 
                     :KO-COMM-TYPE-CD,                                  
                     :KO-COMM-SUBTYPE-CODE,                             
                     :KO-PREMISE-NO,                                    
                     :KO-CUSTOMER-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-CUST-COMM-FLAG                        
                   IF WS-RED-FLAG-NULL-IND < 0                          
                       MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT             
                   END-IF                                               
                   IF KO-RED-FLAG-IND = 'Y' AND                         
                     (KO-RED-FLAG-EXPIRE-DT <= SPACES OR                
                      KO-RED-FLAG-EXPIRE-DT > WS-RED-FLAG-EXP-DT)       
                       IF (KO-PREMISE-NO = WS-PREMISE-NO-NUM AND        
                           KO-CUSTOMER-NO NOT = WS-CUSTOMER-NO-NUM AND  
                           KO-COMM-ASSOC-CD NOT = 'P') OR               
                          (KO-PREMISE-NO NOT = WS-PREMISE-NO-NUM AND    
                           KO-CUSTOMER-NO = WS-CUSTOMER-NO-NUM AND      
                           KO-COMM-ASSOC-CD = 'P')                      
                              NEXT SENTENCE                             
                       ELSE                                             
                          MOVE 'Y' TO RS-RED-FLAG                       
                       END-IF                                           
                   END-IF                                               
                   IF WS-RED-FLAG-EXP-DT <= KO-COMMUNICATION-ID         
                      IF KO-COMM-TYPE-CD = '40' AND                     
                         KO-COMM-SUBTYPE-CODE = '06'                    
                         MOVE 'Y' TO WS-ORDER-TODAY                     
                      END-IF                                            
                      IF KO-COMM-TYPE-CD = '41' AND                     
                         (KO-COMM-SUBTYPE-CODE = '10' OR                
                         KO-COMM-SUBTYPE-CODE = '11' OR                 
                         KO-COMM-SUBTYPE-CODE = '12' OR                 
                         KO-COMM-SUBTYPE-CODE = '03' )                  
                         MOVE 'Y' TO WS-ORDER-TODAY                     
                      END-IF                                            
                   END-IF                                               
                                                                        
                   IF KO-COMPLAINT-FL = 'Y' AND                         
                      KO-COMMUNICATION-ID > WS-THREE-MONTHS-AGO AND     
                      KO-CUSTOMER-NO = WS-CUSTOMER-NO-NUM               
                          ADD 1 TO WS-COMPLAINT-COUNT                   
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   GO TO 7601-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7601'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_COMM_DATA'    TO TABLE-1                   
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
                   MOVE WS-CUSTOMER-NO-NUM TO HOSTVAR-ELEMENT-1         
                   MOVE 'PERMISE_NO'       TO TABLE-ELEMENT-2           
                   MOVE WS-PREMISE-NO-NUM  TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           GO TO 7601-FETCH-COMM-DATA.                                  
                                                                        
       7601-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-WRITE-OFFS.                                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7650-WRITE-OFFS.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :WS-HOLD-ACCOUNT-NO                                
                FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO    = :HA-CUSTOMER-NO                   
                 AND ACCOUNT_NO    <> :HA-ACCOUNT-NO                    
                 AND CODE_ACCT_STAT = 'S'                               
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-HOLD-ACCOUNT-NO                                        
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO    = :HA-CUSTOMER-NO                           
MFA-TR*          AND ACCOUNT_NO    <> :HA-ACCOUNT-NO                            
MFA-TR*          AND CODE_ACCT_STAT = 'S'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7650                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN MULTIPLE-ROWS                                       
                   MOVE 'Y' TO RS-WRITE-OFF-FLAG                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-WRITE-OFF-FLAG                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7650'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'HST_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE HA-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-WRITE-OFFS-AT.                                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7700-WRITE-OFFS-AT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :WS-HOLD-ACCOUNT-NO                                
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO    = :HA-CUSTOMER-NO                   
                 AND ACCOUNT_NO    <> :HA-ACCOUNT-NO                    
                 AND CODE_ACCT_STAT = 'S'                               
                                                                 
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-HOLD-ACCOUNT-NO                                        
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO    = :HA-CUSTOMER-NO                           
MFA-TR*          AND ACCOUNT_NO    <> :HA-ACCOUNT-NO                            
MFA-TR*          AND CODE_ACCT_STAT = 'S'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN MULTIPLE-ROWS                                       
                   MOVE 'Y' TO RS-WRITE-OFF-FLAG                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-WRITE-OFF-FLAG                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7700'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE HA-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
A32011******************************************************************        
A32011* 7720-FETCH-ITPA-ALERT                                          *        
A32011******************************************************************        
A32011                                                                  
A32011 7720-ITPA-ALERT.                                                 
A32011                                                                  
A32011     EXEC SQL                                                     
A32011         SELECT TOP(1) CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM,
              LF.ITPA_RSLT_CURR_CD                              
A32011           INTO :CK-CR-HIST-TRAN-DT,                              
A32011                :CK-CR-HIST-TRAN-TM,                              
A32011                :LF-ITPA-RSLT-CURR-CD                             
A32011           FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED),                 
A32011                CSS_CRED_ITPA_HIST LF WITH(READUNCOMMITTED)               
A32011          WHERE CK.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM              
A32011            AND CK.CR_HIST_TRAN_TM =                              
A32011               (SELECT MAX(CR_HIST_TRAN_TM)                       
A32011                  FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)              
A32011                 WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM          
A32011                   AND CR_HIST_TRAN_DT =                          
A32011                    (SELECT MAX(CR_HIST_TRAN_DT)                  
A32011                       FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)         
A32011                      WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM))   
A32011            AND CK.CR_HIST_TRAN_DT =                              
A32011             (SELECT MAX(CR_HIST_TRAN_DT)                         
A32011                 FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)               
A32011           WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM)               
A32011             AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                  
A32011             AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT          
A32011             AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM          
A32011                                           
A32011                                                           
A32011                                                      
A32011     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CK.CR_HIST_TRAN_DT,                                       
MFA-TR*               CK.CR_HIST_TRAN_TM,                                       
MFA-TR*               LF.ITPA_RSLT_CURR_CD                                      
MFA-TR*          INTO :CK-CR-HIST-TRAN-DT,                                      
MFA-TR*               :CK-CR-HIST-TRAN-TM,                                      
MFA-TR*               :LF-ITPA-RSLT-CURR-CD                                     
MFA-TR*          FROM CSS_CREDIT_HIST CK,                                       
MFA-TR*               CSS_CRED_ITPA_HIST LF                                     
MFA-TR*         WHERE CK.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                      
MFA-TR*           AND CK.CR_HIST_TRAN_TM =                                      
MFA-TR*              (SELECT MAX(CR_HIST_TRAN_TM)                               
MFA-TR*                 FROM CSS_CREDIT_HIST                                    
MFA-TR*                WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  
MFA-TR*                  AND CR_HIST_TRAN_DT =                                  
MFA-TR*                   (SELECT MAX(CR_HIST_TRAN_DT)                          
MFA-TR*                      FROM CSS_CREDIT_HIST                               
MFA-TR*                     WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM))           
MFA-TR*           AND CK.CR_HIST_TRAN_DT =                                      
MFA-TR*            (SELECT MAX(CR_HIST_TRAN_DT)                                 
MFA-TR*                FROM CSS_CREDIT_HIST                                     
MFA-TR*          WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM)                       
MFA-TR*            AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                          
MFA-TR*            AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT                  
MFA-TR*            AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7720                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A32011                                                                  
A32011     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
A32011                                                                  
A32011     EVALUATE WS-ACTIVE-RETURN-CODE                               
A32011      WHEN SUCCESSFUL-CALL                                        
A32011               IF LF-ITPA-RSLT-CURR-CD = 'R'                      
A32011                 MOVE 'N' TO RS-ITPA-FLAG                         
A32011               ELSE                                               
A32011                 MOVE 'Y' TO RS-ITPA-FLAG                         
A32011               END-IF                                             
A32011      WHEN NOT-FOUND                                              
A32011            MOVE 'P' TO RS-ITPA-FLAG                              
A32011      WHEN OTHER                                                  
A32011            MOVE PROGRAM-NAME    TO ABEND-PROGRAM                 
A32011            MOVE '7720'          TO ACTIVE-PARAGRAPH              
A32011            MOVE 'SELECT'        TO ABEND-FUNCTION                
A32011            MOVE 'CSS_CREDIT_HIST'  TO TABLE-1                    
A32011            MOVE 'CSS_CRED_HIST_ITPA'  TO TABLE-2                 
A32011            MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1               
A32011            MOVE WS-CUSTOMER-NO-NUM TO HOSTVAR-ELEMENT-1          
A32011            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
A32011            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
A32011     END-EVALUATE.                                                
A32011                                                                  
A32011 7720-EXIT.                                                       
A32011     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-INSERT-TABLE.                                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       8000-INSERT-TABLE.                                               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCESS_HISTORY (                          
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ACCESS_TIMESTAMP,                                  
                     ACCESS_STATUS,                                     
                     USERID                                             
                     )                                                  
              VALUES (                                                  
                     :WS-CUSTOMER-NO-NUM,                               
                     :WS-ACCOUNT-NO-NUM,                                
                     CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP),                 
                     'D',                                               
                     :PARM-USERID                                       
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCESS_HISTORY (                                  
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              ACCESS_TIMESTAMP,                                          
MFA-TR*              ACCESS_STATUS,                                             
MFA-TR*              USERID                                                     
MFA-TR*              )                                                          
MFA-TR*       VALUES (                                                          
MFA-TR*              :WS-CUSTOMER-NO-NUM,                                       
MFA-TR*              :WS-ACCOUNT-NO-NUM,                                        
MFA-TR*              :WS-CURRENT-TIMESTAMP,                                     
MFA-TR*              'D',                                                       
MFA-TR*              :PARM-USERID                                               
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
                                      MULTIPLE-ROWS                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCESS_HIST'    TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-2            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-2            
              MOVE 'ACCESS_STATUS'      TO TABLE-ELEMENT-3              
              MOVE 'D'                  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
