       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04286.                                          
COB303 DATE-WRITTEN.      JUNE 26, 2012.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS COMMUNICATIONS DATA.                    *        
      *  RESULTS SETS:                                                 *        
      *     1.  COMMUNICATIONS                                         *        
      *     2.  COMMUNICATION COMMENTS                                 *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/26/12    FMB      NEW PROGRAM.                                      
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04286'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04286 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCOMCMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04286_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04286_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-COMM-DATE         PIC X(10) VALUE SPACES.           
               10 S-RED-FLAG-IND      PIC X(01) VALUE SPACES.           
               10 S-RED-FLAG-DT       PIC X(10) VALUE SPACES.           
               10 S-COMM-TYPE         PIC X(02) VALUE SPACES.           
               10 S-COMM-SUBTYPE      PIC X(02) VALUE SPACES.           
               10 S-CONTACT-NAME      PIC X(25) VALUE SPACES.           
               10 S-COMMENTS-1        PIC X(255) VALUE SPACES.          
               10 S-COMM-ID-1         PIC X(26) VALUE SPACES.           
               10 S-COMM-METHOD       PIC X(15) VALUE SPACES.           
               10 S-COMM-DIRECTION    PIC X(15) VALUE SPACES.           
               10 S-USER-ID-ORIG      PIC X(07) VALUE SPACES.           
               10 S-COMM-ASSOC-CD     PIC X(01) VALUE SPACES.           
               10 S-COMM-ADDRESS      PIC X(80) VALUE SPACES.           
               10 S-RESP-AREA-DESC    PIC X(30) VALUE SPACES.           
               10 S-USER-ID-NAME      PIC X(40) VALUE SPACES.           
               10 S-COMPLAINT-FL      PIC X(01) VALUE SPACES.           
               10 S-COMPLIANCE-IND    PIC X(01) VALUE SPACES.           
               10 S-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.       
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-COMM-ID-2         PIC X(26) VALUE SPACES.           
               10 S-COMM-UPDATE-TS    PIC X(26) VALUE SPACES.           
               10 S-COMM-UPDATE-USER  PIC X(07) VALUE SPACES.           
               10 S-COMMENTS-2        PIC X(255) VALUE SPACES.          
               10 S-RESP-AREA-DESC-2  PIC X(30) VALUE SPACES.           
               10 S-COMM-UPDATE-NAME  PIC X(40) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-PREM-NO-NUM           PIC 9(10).                      
           05  WS-PREM-NO-CHAR          REDEFINES WS-PREM-NO-NUM        
                                        PIC X(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-RED-FLAG-TS           PIC X(26) VALUE SPACES.         
           05  WS-TS-MINUS-XX-DAYS      PIC X(26) VALUE SPACES.         
           05  WS-MINUS-DAYS            PIC S9(08) COMP-3 VALUE +0.     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04286'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-COMM-DIRECTION        PIC X(15) VALUE SPACES.         
           05  WS-COMM-METHOD-DESC      PIC X(15) VALUE SPACES.         
           05  WS-MAX-DATE              PIC X(10) VALUE SPACES.         
           05  WS-COMMENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-CALL-TYPE             PIC X(01) VALUE 'A'.            
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
COB305     05 WS-PR-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
           05  WS-USER-NAME             PIC X(40) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE COMM-CURSOR-A CURSOR FOR                          
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
                      RED_FLAG_IND,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
                      COMM_TYPE_CD,                                     
                      KO.COMM_SUBTYPE_CODE,                             
                      CONTACT_NAME,                                     
                      INITIAL_COMMENT_TX,                               
                      COMM_METHOD_DESC,                                 
                      CASE COMM_DIRECTION                               
                          WHEN 'I' THEN 'INCOMING'                      
                          WHEN 'O' THEN 'OUTGOING'                      
                          WHEN 'R' THEN 'INTERNAL REVIEW'               
                          ELSE ' '                                      
                      END,                                              
                      USER_ID_ORIG,                                     
                      COMM_ASSOC_CD,                                    
                      COMM_DIRECTION,                                   
                      COMM_METHOD,                                      
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPLAINT_FL,                                     
                      PSC_COMPLIANCE_IND                                
                 FROM CSS_COMM_DATA KO WITH(READUNCOMMITTED),                   
                      CSS_COMM_METHOD C1 WITH(READUNCOMMITTED)                  
                WHERE ((CUSTOMER_NO = :CU-CUSTOMER-NO                   
                  AND  CUSTOMER_NO > 0)                                 
                   OR (PREMISE_NO = :PR-PREMISE-NO                      
                  AND  PREMISE_NO > 0)                                  
                   OR (ACCOUNT_NO = :AT-ACCOUNT-NO                      
                  AND  ACCOUNT_NO > 0))                                 
                  AND ((COMMUNICATION_ID >= CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              ))       
                   OR  (RED_FLAG_IND = 'Y'                              
                  AND  (RED_FLAG_EXPIRE_DT IS NULL                      
                   OR  RED_FLAG_EXPIRE_DT >= CIS.CHAR2TIMESTAMP(
                                                        :WS-RED-FLAG-TS
              )))          
                   OR  EXISTS (                                         
                        SELECT '1'                                      
                          FROM CSS_COMM_COMMENT WITH(READUNCOMMITTED)           
                         WHERE COMMUNICATION_ID = KO.COMMUNICATION_ID   
                           AND UPDATE_TS >= CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )))      
                  AND KO.COMM_METHOD = C1.COMM_METHOD_CD                
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COMM-CURSOR-A CURSOR FOR                                  
MFA-TR*        SELECT COMMUNICATION_ID,                                         
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               KO.COMM_SUBTYPE_CODE,                                     
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               COMM_METHOD_DESC,                                         
MFA-TR*               CASE COMM_DIRECTION                                       
MFA-TR*                   WHEN 'I' THEN 'INCOMING'                              
MFA-TR*                   WHEN 'O' THEN 'OUTGOING'                              
MFA-TR*                   WHEN 'R' THEN 'INTERNAL REVIEW'                       
MFA-TR*                   ELSE ' '                                              
MFA-TR*               END,                                                      
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPLAINT_FL,                                             
MFA-TR*               PSC_COMPLIANCE_IND                                        
MFA-TR*          FROM CSS_COMM_DATA KO,                                         
MFA-TR*               CSS_COMM_METHOD C1                                        
MFA-TR*         WHERE ((CUSTOMER_NO = :CU-CUSTOMER-NO                           
MFA-TR*           AND  CUSTOMER_NO > 0)                                         
MFA-TR*            OR (PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*           AND  PREMISE_NO > 0)                                          
MFA-TR*            OR (ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*           AND  ACCOUNT_NO > 0))                                         
MFA-TR*           AND ((COMMUNICATION_ID >= :KO-COMMUNICATION-ID)               
MFA-TR*            OR  (RED_FLAG_IND = 'Y'                                      
MFA-TR*           AND  (RED_FLAG_EXPIRE_DT IS NULL                              
MFA-TR*            OR  RED_FLAG_EXPIRE_DT >= :WS-RED-FLAG-TS))                  
MFA-TR*            OR  EXISTS (                                                 
MFA-TR*                 SELECT '1'                                              
MFA-TR*                   FROM CSS_COMM_COMMENT                                 
MFA-TR*                  WHERE COMMUNICATION_ID = KO.COMMUNICATION_ID           
MFA-TR*                    AND UPDATE_TS >= :KO-COMMUNICATION-ID))              
MFA-TR*           AND KO.COMM_METHOD = C1.COMM_METHOD_CD                        
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE COMM-CURSOR-C CURSOR FOR                          
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
                      RED_FLAG_IND,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
                      COMM_TYPE_CD,                                     
                      KO.COMM_SUBTYPE_CODE,                             
                      CONTACT_NAME,                                     
                      INITIAL_COMMENT_TX,                               
                      COMM_METHOD_DESC,                                 
                      CASE COMM_DIRECTION                               
                          WHEN 'I' THEN 'INCOMING'                      
                          WHEN 'O' THEN 'OUTGOING'                      
                          WHEN 'R' THEN 'INTERNAL REVIEW'               
                          ELSE ' '                                      
                      END,                                              
                      USER_ID_ORIG,                                     
                      COMM_ASSOC_CD,                                    
                      COMM_DIRECTION,                                   
                      COMM_METHOD,                                      
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPLAINT_FL,                                     
                      PSC_COMPLIANCE_IND                                
                 FROM CSS_COMM_DATA KO WITH(READUNCOMMITTED),                   
                      CSS_COMM_METHOD C1 WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND ((COMMUNICATION_ID >= CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              ))       
                   OR  (RED_FLAG_IND = 'Y'                              
                  AND  (RED_FLAG_EXPIRE_DT IS NULL                      
                   OR  RED_FLAG_EXPIRE_DT >= CIS.CHAR2TIMESTAMP(
                                                        :WS-RED-FLAG-TS
              )))          
                   OR  EXISTS (                                         
                        SELECT '1'                                      
                          FROM CSS_COMM_COMMENT WITH(READUNCOMMITTED)           
                         WHERE COMMUNICATION_ID = KO.COMMUNICATION_ID   
                           AND UPDATE_TS >= CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )))      
                  AND KO.COMM_METHOD = C1.COMM_METHOD_CD                
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COMM-CURSOR-C CURSOR FOR                                  
MFA-TR*        SELECT COMMUNICATION_ID,                                         
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               KO.COMM_SUBTYPE_CODE,                                     
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               COMM_METHOD_DESC,                                         
MFA-TR*               CASE COMM_DIRECTION                                       
MFA-TR*                   WHEN 'I' THEN 'INCOMING'                              
MFA-TR*                   WHEN 'O' THEN 'OUTGOING'                              
MFA-TR*                   WHEN 'R' THEN 'INTERNAL REVIEW'                       
MFA-TR*                   ELSE ' '                                              
MFA-TR*               END,                                                      
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPLAINT_FL,                                             
MFA-TR*               PSC_COMPLIANCE_IND                                        
MFA-TR*          FROM CSS_COMM_DATA KO,                                         
MFA-TR*               CSS_COMM_METHOD C1                                        
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND ((COMMUNICATION_ID >= :KO-COMMUNICATION-ID)               
MFA-TR*            OR  (RED_FLAG_IND = 'Y'                                      
MFA-TR*           AND  (RED_FLAG_EXPIRE_DT IS NULL                              
MFA-TR*            OR  RED_FLAG_EXPIRE_DT >= :WS-RED-FLAG-TS))                  
MFA-TR*            OR  EXISTS (                                                 
MFA-TR*                 SELECT '1'                                              
MFA-TR*                   FROM CSS_COMM_COMMENT                                 
MFA-TR*                  WHERE COMMUNICATION_ID = KO.COMMUNICATION_ID           
MFA-TR*                    AND UPDATE_TS >= :KO-COMMUNICATION-ID))              
MFA-TR*           AND KO.COMM_METHOD = C1.COMM_METHOD_CD                        
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE COMM-CURSOR-P CURSOR FOR                          
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
                      RED_FLAG_IND,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
                      COMM_TYPE_CD,                                     
                      KO.COMM_SUBTYPE_CODE,                             
                      CONTACT_NAME,                                     
                      INITIAL_COMMENT_TX,                               
                      COMM_METHOD_DESC,                                 
                      CASE COMM_DIRECTION                               
                          WHEN 'I' THEN 'INCOMING'                      
                          WHEN 'O' THEN 'OUTGOING'                      
                          WHEN 'R' THEN 'INTERNAL REVIEW'               
                          ELSE ' '                                      
                      END,                                              
                      USER_ID_ORIG,                                     
                      COMM_ASSOC_CD,                                    
                      COMM_DIRECTION,                                   
                      COMM_METHOD,                                      
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPLAINT_FL,                                     
                      PSC_COMPLIANCE_IND                                
                 FROM CSS_COMM_DATA KO WITH(READUNCOMMITTED),                   
                      CSS_COMM_METHOD C1 WITH(READUNCOMMITTED)                  
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND ((COMMUNICATION_ID >= CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              ))       
                   OR  (RED_FLAG_IND = 'Y'                              
                  AND  (RED_FLAG_EXPIRE_DT IS NULL                      
                   OR  RED_FLAG_EXPIRE_DT >= CIS.CHAR2TIMESTAMP(
                                                        :WS-RED-FLAG-TS
              )))          
                   OR  EXISTS (                                         
                        SELECT '1'                                      
                          FROM CSS_COMM_COMMENT WITH(READUNCOMMITTED)           
                         WHERE COMMUNICATION_ID = KO.COMMUNICATION_ID   
                           AND UPDATE_TS >= CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )))      
                  AND KO.COMM_METHOD = C1.COMM_METHOD_CD                
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COMM-CURSOR-P CURSOR FOR                                  
MFA-TR*        SELECT COMMUNICATION_ID,                                         
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               KO.COMM_SUBTYPE_CODE,                                     
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               COMM_METHOD_DESC,                                         
MFA-TR*               CASE COMM_DIRECTION                                       
MFA-TR*                   WHEN 'I' THEN 'INCOMING'                              
MFA-TR*                   WHEN 'O' THEN 'OUTGOING'                              
MFA-TR*                   WHEN 'R' THEN 'INTERNAL REVIEW'                       
MFA-TR*                   ELSE ' '                                              
MFA-TR*               END,                                                      
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPLAINT_FL,                                             
MFA-TR*               PSC_COMPLIANCE_IND                                        
MFA-TR*          FROM CSS_COMM_DATA KO,                                         
MFA-TR*               CSS_COMM_METHOD C1                                        
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND ((COMMUNICATION_ID >= :KO-COMMUNICATION-ID)               
MFA-TR*            OR  (RED_FLAG_IND = 'Y'                                      
MFA-TR*           AND  (RED_FLAG_EXPIRE_DT IS NULL                              
MFA-TR*            OR  RED_FLAG_EXPIRE_DT >= :WS-RED-FLAG-TS))                  
MFA-TR*            OR  EXISTS (                                                 
MFA-TR*                 SELECT '1'                                              
MFA-TR*                   FROM CSS_COMM_COMMENT                                 
MFA-TR*                  WHERE COMMUNICATION_ID = KO.COMMUNICATION_ID           
MFA-TR*                    AND UPDATE_TS >= :KO-COMMUNICATION-ID))              
MFA-TR*           AND KO.COMM_METHOD = C1.COMM_METHOD_CD                        
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE COMM-DET-CURSOR CURSOR FOR                        
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), UPDATE_TS
           , 121), ' ', '-'), ':', '.') UPDATE_TS,                             
                      USER_ID,                                          
                      COMMENT_TX                                        
                 FROM CSS_COMM_COMMENT WITH(READUNCOMMITTED)                    
                WHERE COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                   :KN-COMMUNICATION-ID
              )           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COMM-DET-CURSOR CURSOR FOR                                
MFA-TR*        SELECT UPDATE_TS,                                                
MFA-TR*               USER_ID,                                                  
MFA-TR*               COMMENT_TX                                                
MFA-TR*          FROM CSS_COMM_COMMENT                                          
MFA-TR*         WHERE COMMUNICATION_ID = :KN-COMMUNICATION-ID                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7112                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      STATUS_CODE     AS STATUS_CODE,                   
                      COMM_DATE       AS COMM_DATE,                     
                      RED_FLAG_IND    AS RED_FLAG_IND,                  
                      RED_FLAG_DT     AS RED_FLAG_DT,                   
                      COMM_TYPE       AS COMM_TYPE,                     
                      COMM_SUBTYPE    AS COMM_SUBTYPE,                  
                      CONTACT_NAME    AS CONTACT_NAME,                  
                      COMMENTS        AS COMMENTS,                      
                      COMM_ID         AS COMM_ID,                       
                      COMM_METHOD     AS COMM_METHOD,                   
                      COMM_DIRECTION  AS COMM_DIRECTION,                
                      USER_ID_ORIG    AS USER_ID_ORIG,                  
                      COMM_ASSOC_CD   AS COMM_ASSOC_CD,                 
                      COMM_ADDRESS    AS COMM_ADDRESS,                  
                      RESP_AREA_DESC  AS RESP_AREA_DESC,                
                      USER_ID_NAME    AS USER_ID_NAME,                  
                      COMPLAINT_FL    AS COMPLAINT_FL,                  
                      COMPLIANCE_IND  AS COMPLIANCE_IND,                
                      ACCOUNT_NO      AS ACCOUNT_NO                     
                FROM #CSR04286_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               STATUS_CODE     AS STATUS_CODE,                           
MFA-TR*               COMM_DATE       AS COMM_DATE,                             
MFA-TR*               RED_FLAG_IND    AS RED_FLAG_IND,                          
MFA-TR*               RED_FLAG_DT     AS RED_FLAG_DT,                           
MFA-TR*               COMM_TYPE       AS COMM_TYPE,                             
MFA-TR*               COMM_SUBTYPE    AS COMM_SUBTYPE,                          
MFA-TR*               CONTACT_NAME    AS CONTACT_NAME,                          
MFA-TR*               COMMENTS        AS COMMENTS,                              
MFA-TR*               COMM_ID         AS COMM_ID,                               
MFA-TR*               COMM_METHOD     AS COMM_METHOD,                           
MFA-TR*               COMM_DIRECTION  AS COMM_DIRECTION,                        
MFA-TR*               USER_ID_ORIG    AS USER_ID_ORIG,                          
MFA-TR*               COMM_ASSOC_CD   AS COMM_ASSOC_CD,                         
MFA-TR*               COMM_ADDRESS    AS COMM_ADDRESS,                          
MFA-TR*               RESP_AREA_DESC  AS RESP_AREA_DESC,                        
MFA-TR*               USER_ID_NAME    AS USER_ID_NAME,                          
MFA-TR*               COMPLAINT_FL    AS COMPLAINT_FL,                          
MFA-TR*               COMPLIANCE_IND  AS COMPLIANCE_IND,                        
MFA-TR*               ACCOUNT_NO      AS ACCOUNT_NO                             
MFA-TR*         FROM SESSION.CSR04286_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1  AS RETURN_CODE,                 
                      :S-STATUS-CODE    AS STATUS_CODE,                 
                      :S-COMM-DATE      AS COMM_DATE,                   
                      :S-RED-FLAG-IND   AS RED_FLAG_IND,                
                      :S-RED-FLAG-DT    AS RED_FLAG_DT,                 
                      :S-COMM-TYPE      AS COMM_TYPE,                   
                      :S-COMM-SUBTYPE   AS COMM_SUBTYPE,                
                      :S-CONTACT-NAME   AS CONTACT_NAME,                
                      :S-COMMENTS-1     AS COMMENTS,                    
                      :S-COMM-ID-1      AS COMM_ID,                     
                      :S-COMM-METHOD    AS COMM_METHOD,                 
                      :S-COMM-DIRECTION AS COMM_DIRECTION,              
                      :S-USER-ID-ORIG   AS USER_ID_ORIG,                
                      :S-COMM-ASSOC-CD  AS COMM_ASSOC_CD,               
                      :S-COMM-ADDRESS   AS COMM_ADDRESS,                
                      :S-RESP-AREA-DESC AS RESP_AREA_DESC,              
                      :S-USER-ID-NAME   AS USER_ID_NAME,                
                      :S-COMPLAINT-FL   AS COMPLAINT_FL,                
                      :S-COMPLIANCE-IND AS COMPLIANCE_IND,              
                      :S-ACCOUNT-NO     AS ACCOUNT_NO                   
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1  AS RETURN_CODE,                         
MFA-TR*               :S-STATUS-CODE    AS STATUS_CODE,                         
MFA-TR*               :S-COMM-DATE      AS COMM_DATE,                           
MFA-TR*               :S-RED-FLAG-IND   AS RED_FLAG_IND,                        
MFA-TR*               :S-RED-FLAG-DT    AS RED_FLAG_DT,                         
MFA-TR*               :S-COMM-TYPE      AS COMM_TYPE,                           
MFA-TR*               :S-COMM-SUBTYPE   AS COMM_SUBTYPE,                        
MFA-TR*               :S-CONTACT-NAME   AS CONTACT_NAME,                        
MFA-TR*               :S-COMMENTS-1     AS COMMENTS,                            
MFA-TR*               :S-COMM-ID-1      AS COMM_ID,                             
MFA-TR*               :S-COMM-METHOD    AS COMM_METHOD,                         
MFA-TR*               :S-COMM-DIRECTION AS COMM_DIRECTION,                      
MFA-TR*               :S-USER-ID-ORIG   AS USER_ID_ORIG,                        
MFA-TR*               :S-COMM-ASSOC-CD  AS COMM_ASSOC_CD,                       
MFA-TR*               :S-COMM-ADDRESS   AS COMM_ADDRESS,                        
MFA-TR*               :S-RESP-AREA-DESC AS RESP_AREA_DESC,                      
MFA-TR*               :S-USER-ID-NAME   AS USER_ID_NAME,                        
MFA-TR*               :S-COMPLAINT-FL   AS COMPLAINT_FL,                        
MFA-TR*               :S-COMPLIANCE-IND AS COMPLIANCE_IND,                      
MFA-TR*               :S-ACCOUNT-NO     AS ACCOUNT_NO                           
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE      AS RETURN_CODE,                  
                      COMM_ID          AS COMM_ID,                      
                      COMM_UPDATE_TS   AS COMM_UPDATE_TS,               
                      COMM_UPDATE_USER AS COMM_UPDATE_USER,             
                      COMMENTS         AS COMMENTS,                     
                      RESP_AREA_DESC   AS RESP_AREA_DESC,               
                      COMM_UPDATE_NAME AS COMM_UPDATE_NAME              
                FROM #CSR04286_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE      AS RETURN_CODE,                          
MFA-TR*               COMM_ID          AS COMM_ID,                              
MFA-TR*               COMM_UPDATE_TS   AS COMM_UPDATE_TS,                       
MFA-TR*               COMM_UPDATE_USER AS COMM_UPDATE_USER,                     
MFA-TR*               COMMENTS         AS COMMENTS,                             
MFA-TR*               RESP_AREA_DESC   AS RESP_AREA_DESC,                       
MFA-TR*               COMM_UPDATE_NAME AS COMM_UPDATE_NAME                      
MFA-TR*         FROM SESSION.CSR04286_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2    AS RETURN_CODE,               
                      :S-COMM-ID-2        AS COMM_ID,                   
                      :S-COMM-UPDATE-TS   AS COMM_UPDATE_TS,            
                      :S-COMM-UPDATE-USER AS COMM_UPDATE_USER,          
                      :S-COMMENTS-2       AS COMMENTS,                  
                      :S-RESP-AREA-DESC-2 AS RESP_AREA_DESC,            
                      :S-COMM-UPDATE-NAME AS COMM_UPDATE_NAME           
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2    AS RETURN_CODE,                       
MFA-TR*               :S-COMM-ID-2        AS COMM_ID,                           
MFA-TR*               :S-COMM-UPDATE-TS   AS COMM_UPDATE_TS,                    
MFA-TR*               :S-COMM-UPDATE-USER AS COMM_UPDATE_USER,                  
MFA-TR*               :S-COMMENTS-2       AS COMMENTS,                          
MFA-TR*               :S-RESP-AREA-DESC-2 AS RESP_AREA_DESC,                    
MFA-TR*               :S-COMM-UPDATE-NAME AS COMM_UPDATE_NAME                   
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-DAYS               PIC S9(4) COMP.                      
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO                               
                          LINK-CUSTOMER-NO                              
                          LINK-PREMISE-NO                               
                          LINK-DAYS.                                    
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04286_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04286_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               COMM_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,             
               RED_FLAG_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RED_FLAG_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               COMM_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               COMM_SUBTYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CONTACT_NAME CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,          
               COMMENTS CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2,             
               COMM_ID CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,               
               COMM_METHOD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,           
               COMM_DIRECTION CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,        
               USER_ID_ORIG CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2,          
               COMM_ASSOC_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               COMM_ADDRESS CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RESP_AREA_DESC CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,        
               USER_ID_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,          
               COMPLAINT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               COMPLIANCE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ACCOUNT_NO           DECIMAL(13,0)                       
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-CTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04286_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04286_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04286_R2
              (                                                          
               RETURN_CODE          INT,                            
               COMM_ID CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,               
               COMM_UPDATE_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,        
               COMM_UPDATE_USER CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               COMMENTS CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2,             
               RESP_AREA_DESC CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,        
               COMM_UPDATE_NAME CHAR(40)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04286_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-DAYS = 0                                             
               MOVE +60 TO LINK-DAYS
           END-IF.                                   
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           EVALUATE TRUE                                                
               WHEN LINK-ACCOUNT-NO > ZEROES                            
                   MOVE 'A' TO WS-CALL-TYPE                             
               WHEN LINK-CUSTOMER-NO > ZEROES                           
                   MOVE 'C' TO WS-CALL-TYPE                             
               WHEN LINK-PREMISE-NO > ZEROES                            
                   MOVE 'P' TO WS-CALL-TYPE                             
           END-EVALUATE.                                                
           IF WS-CALL-TYPE = ' '                                        
               MOVE 'A' TO WS-CALL-TYPE
           END-IF.                                
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-CURRENT-TS TO WS-RED-FLAG-TS.                        
           MOVE '-00.00.00.000000' TO WS-RED-FLAG-TS(11:16).            
           COMPUTE LINK-DAYS = LINK-DAYS * -1.                          
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.TIMESTAMPADD(16, 
                                                            :LINK-DAYS,        
                      CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS)), 121), ' ', 
           '-'), ':', '.')
            INTO
              :WS-TS-MINUS-XX-DAYS                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES TIMESTAMPADD(16, :LINK-DAYS,                              
MFA-TR*               TIMESTAMP(:WS-CURRENT-TS))                                
MFA-TR*          INTO :WS-TS-MINUS-XX-DAYS                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF LINK-ACCOUNT-NO = ZEROES AND                              
              LINK-CUSTOMER-NO = ZEROES AND                             
              LINK-PREMISE-NO = ZEROES                                  
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                  MOVE 'PARMS ZERO' TO S-COMM-DATE                      
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO                      
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT
           END-IF.              
                                                                        
           MOVE WS-TS-MINUS-XX-DAYS TO KO-COMMUNICATION-ID.             
           EVALUATE WS-CALL-TYPE                                        
               WHEN 'A'                                                 
                   PERFORM 7110-OPEN-COMM-CURSOR THRU 7110-EXIT         
                   PERFORM 2010-FETCH-ROWS THRU 2010-EXIT               
                   PERFORM 7111-CLOSE-COMM-CURSOR THRU 7111-EXIT        
               WHEN 'C'                                                 
                   PERFORM 7114-OPEN-COMM-CURSOR THRU 7114-EXIT         
                   PERFORM 2011-FETCH-ROWS THRU 2011-EXIT               
                   PERFORM 7115-CLOSE-COMM-CURSOR THRU 7115-EXIT        
               WHEN 'P'                                                 
                   PERFORM 7116-OPEN-COMM-CURSOR THRU 7116-EXIT         
                   PERFORM 2012-FETCH-ROWS THRU 2012-EXIT               
                   PERFORM 7117-CLOSE-COMM-CURSOR THRU 7117-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE +100 TO S-RETURN-CODE-1                              
              MOVE 'NO DATA' TO S-COMM-DATE                             
              PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                 
              PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                 
              PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                 
              PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO KO-INITIAL-COMMENT-TX.                        
                                                                        
           EXEC SQL                                                     
               FETCH COMM-CURSOR-A                                      
                INTO :KO-COMMUNICATION-ID,                              
                     :KO-RED-FLAG-IND,                                  
                     :KO-RED-FLAG-EXPIRE-DT :WS-NULL-3,                  
                     :KO-COMM-TYPE-CD,                                  
                     :KO-COMM-SUBTYPE-CODE,                             
                     :KO-CONTACT-NAME,                                  
                     :KO-INITIAL-COMMENT-TX,                            
                     :WS-COMM-METHOD-DESC,                              
                     :WS-COMM-DIRECTION,                                
                     :KO-USER-ID-ORIG,                                  
                     :KO-COMM-ASSOC-CD,                                 
                     :KO-COMM-DIRECTION,                                
                     :KO-COMM-METHOD,                                   
                     :KO-ACCOUNT-NO,                                    
                     :KO-CUSTOMER-NO,                                   
                     :KO-PREMISE-NO,                                    
                     :KO-COMPLAINT-FL,                                  
                     :KO-PSC-COMPLIANCE-IND                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT             
                   END-IF                                               
                   IF KO-RED-FLAG-IND <= ' '                            
                       MOVE 'N' TO KO-RED-FLAG-IND                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
      *    IF KO-COMM-DIRECTION = 'O' AND                                       
      *       KO-COMM-TYPE-CD = '06' AND                                        
      *       KO-COMM-SUBTYPE-CODE = '42' AND                                   
      *       KO-COMM-METHOD = 'E'                                              
      *           GO TO 2011-FETCH-ROWS.                                        
                                                                        
      *    IF KO-USER-ID-ORIG(1:3) = 'IVR'                                      
      *        GO TO 2011-FETCH-ROWS.                                           
                                                                        
           IF KO-PREMISE-NO = PR-PREMISE-NO AND                         
              PR-PREMISE-NO > 0 AND                                     
              KO-CUSTOMER-NO NOT = CU-CUSTOMER-NO AND                   
              KO-COMM-ASSOC-CD NOT = 'P'                                
                  GO TO 2010-FETCH-ROWS
           END-IF.                                
                                                                        
           IF KO-PREMISE-NO NOT = PR-PREMISE-NO AND                     
              KO-CUSTOMER-NO = CU-CUSTOMER-NO AND                       
              CU-CUSTOMER-NO > 0 AND                                    
              KO-COMM-ASSOC-CD = 'P'                                    
                  GO TO 2010-FETCH-ROWS
           END-IF.                                
                                                                        
           PERFORM 2015-COMM-DATA THRU 2015-EXIT.                       
                                                                        
           GO TO 2010-FETCH-ROWS.                                       
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2011-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO KO-INITIAL-COMMENT-TX.                        
                                                                        
           EXEC SQL                                                     
               FETCH COMM-CURSOR-C                                      
                INTO :KO-COMMUNICATION-ID,                              
                     :KO-RED-FLAG-IND,                                  
                     :KO-RED-FLAG-EXPIRE-DT :WS-NULL-3,                  
                     :KO-COMM-TYPE-CD,                                  
                     :KO-COMM-SUBTYPE-CODE,                             
                     :KO-CONTACT-NAME,                                  
                     :KO-INITIAL-COMMENT-TX,                            
                     :WS-COMM-METHOD-DESC,                              
                     :WS-COMM-DIRECTION,                                
                     :KO-USER-ID-ORIG,                                  
                     :KO-COMM-ASSOC-CD,                                 
                     :KO-COMM-DIRECTION,                                
                     :KO-COMM-METHOD,                                   
                     :KO-ACCOUNT-NO,                                    
                     :KO-CUSTOMER-NO,                                   
                     :KO-PREMISE-NO,                                    
                     :KO-COMPLAINT-FL,                                  
                     :KO-PSC-COMPLIANCE-IND                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT             
                   END-IF                                               
                   IF KO-RED-FLAG-IND <= ' '                            
                       MOVE 'N' TO KO-RED-FLAG-IND                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2011-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2011'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
      *    IF KO-COMM-DIRECTION = 'O' AND                                       
      *       KO-COMM-TYPE-CD = '06' AND                                        
      *       KO-COMM-SUBTYPE-CODE = '42' AND                                   
      *       KO-COMM-METHOD = 'E'                                              
      *           GO TO 2011-FETCH-ROWS.                                        
                                                                        
      *    IF KO-USER-ID-ORIG(1:3) = 'IVR'                                      
      *        GO TO 2011-FETCH-ROWS.                                           
                                                                        
           IF KO-PREMISE-NO = PR-PREMISE-NO AND                         
              PR-PREMISE-NO > 0 AND                                     
              KO-CUSTOMER-NO NOT = CU-CUSTOMER-NO AND                   
              KO-COMM-ASSOC-CD NOT = 'P'                                
                  GO TO 2011-FETCH-ROWS
           END-IF.                                
                                                                        
           IF KO-PREMISE-NO NOT = PR-PREMISE-NO AND                     
              KO-CUSTOMER-NO = CU-CUSTOMER-NO AND                       
              CU-CUSTOMER-NO > 0 AND                                    
              KO-COMM-ASSOC-CD = 'P'                                    
                  GO TO 2011-FETCH-ROWS
           END-IF.                                
                                                                        
           PERFORM 2015-COMM-DATA THRU 2015-EXIT.                       
                                                                        
           GO TO 2011-FETCH-ROWS.                                       
                                                                        
       2011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2012-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO KO-INITIAL-COMMENT-TX.                        
                                                                        
           EXEC SQL                                                     
               FETCH COMM-CURSOR-P                                      
                INTO :KO-COMMUNICATION-ID,                              
                     :KO-RED-FLAG-IND,                                  
                     :KO-RED-FLAG-EXPIRE-DT :WS-NULL-3,                  
                     :KO-COMM-TYPE-CD,                                  
                     :KO-COMM-SUBTYPE-CODE,                             
                     :KO-CONTACT-NAME,                                  
                     :KO-INITIAL-COMMENT-TX,                            
                     :WS-COMM-METHOD-DESC,                              
                     :WS-COMM-DIRECTION,                                
                     :KO-USER-ID-ORIG,                                  
                     :KO-COMM-ASSOC-CD,                                 
                     :KO-COMM-DIRECTION,                                
                     :KO-COMM-METHOD,                                   
                     :KO-ACCOUNT-NO,                                    
                     :KO-CUSTOMER-NO,                                   
                     :KO-PREMISE-NO,                                    
                     :KO-COMPLAINT-FL,                                  
                     :KO-PSC-COMPLIANCE-IND                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT             
                   END-IF                                               
                   IF KO-RED-FLAG-IND <= ' '                            
                       MOVE 'N' TO KO-RED-FLAG-IND                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2012-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2012'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
      *    IF KO-COMM-DIRECTION = 'O' AND                                       
      *       KO-COMM-TYPE-CD = '06' AND                                        
      *       KO-COMM-SUBTYPE-CODE = '42' AND                                   
      *       KO-COMM-METHOD = 'E'                                              
      *           GO TO 2012-FETCH-ROWS.                                        
                                                                        
      *    IF KO-USER-ID-ORIG(1:3) = 'IVR'                                      
      *        GO TO 2012-FETCH-ROWS.                                           
                                                                        
           IF KO-PREMISE-NO = PR-PREMISE-NO AND                         
              PR-PREMISE-NO > 0 AND                                     
              KO-CUSTOMER-NO NOT = CU-CUSTOMER-NO AND                   
              KO-COMM-ASSOC-CD NOT = 'P'                                
                  GO TO 2012-FETCH-ROWS
           END-IF.                                
                                                                        
           IF KO-PREMISE-NO NOT = PR-PREMISE-NO AND                     
              KO-CUSTOMER-NO = CU-CUSTOMER-NO AND                       
              CU-CUSTOMER-NO > 0 AND                                    
              KO-COMM-ASSOC-CD = 'P'                                    
                  GO TO 2012-FETCH-ROWS
           END-IF.                                
                                                                        
           PERFORM 2015-COMM-DATA THRU 2015-EXIT.                       
                                                                        
           GO TO 2012-FETCH-ROWS.                                       
                                                                        
       2012-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2015-COMM-DATA.                                                  
                                                                        
           IF KO-RED-FLAG-IND = 'Y' AND                                 
              KO-RED-FLAG-EXPIRE-DT (1:10) < WS-CURRENT-DATE AND        
              KO-RED-FLAG-EXPIRE-DT > SPACES                            
                  MOVE 'N' TO KO-RED-FLAG-IND                           
                  MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT
           END-IF.                 
                                                                        
           MOVE SPACES TO WS-MAX-DATE.                                  
           MOVE KO-COMMUNICATION-ID (1:10) TO WS-MAX-DATE.              
           MOVE KO-COMMUNICATION-ID TO KN-COMMUNICATION-ID.             
                                                                        
           PERFORM 7112-OPEN-COMM-DET-CURSOR THRU 7112-EXIT.            
           PERFORM 2020-FETCH-ROWS THRU 2020-EXIT.                      
           PERFORM 7113-CLOSE-COMM-DET-CURSOR THRU 7113-EXIT.           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE KO-COMMUNICATION-ID TO S-COMM-ID-1.                     
           MOVE WS-MAX-DATE TO S-COMM-DATE.                             
           MOVE KO-RED-FLAG-IND TO S-RED-FLAG-IND.                      
           MOVE KO-RED-FLAG-EXPIRE-DT (1:10) TO S-RED-FLAG-DT.          
           MOVE KO-COMM-TYPE-CD TO S-COMM-TYPE.                         
           MOVE KO-COMM-SUBTYPE-CODE TO S-COMM-SUBTYPE.                 
           MOVE KO-CONTACT-NAME TO S-CONTACT-NAME.                      
           MOVE KO-INITIAL-COMMENT-TX-TEXT TO S-COMMENTS-1.             
           MOVE WS-COMM-METHOD-DESC TO S-COMM-METHOD.                   
           MOVE WS-COMM-DIRECTION TO S-COMM-DIRECTION.                  
           MOVE KO-USER-ID-ORIG TO S-USER-ID-ORIG.                      
           MOVE KO-COMPLAINT-FL TO S-COMPLAINT-FL.                      
           MOVE KO-PSC-COMPLIANCE-IND TO S-COMPLIANCE-IND.              
           MOVE KO-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           IF KO-USER-ID-ORIG > ' '                                     
               MOVE KO-USER-ID-ORIG TO PF-USER-ID                       
               MOVE SPACES TO WS-USER-NAME                              
                              C1-RESP-AREA-DESC                         
               PERFORM 7890-USER-PROFILE THRU 7890-EXIT                 
               MOVE WS-USER-NAME TO S-USER-ID-NAME                      
               MOVE C1-RESP-AREA-DESC TO S-RESP-AREA-DESC
           END-IF.              
           MOVE KO-COMM-ASSOC-CD TO S-COMM-ASSOC-CD.                    
           IF KO-PREMISE-NO > 0                                         
               MOVE KO-PREMISE-NO TO WS-PR-PREMISE-NO                   
               PERFORM 7750-SERVICE-ADDRESS THRU 7750-EXIT              
               MOVE WS-ADDRESS-LINE TO S-COMM-ADDRESS                   
           ELSE                                                         
               IF KO-ACCOUNT-NO > 0                                     
                   PERFORM 7880-SELECT-PREM-NO THRU 7880-EXIT           
                   IF WS-PR-PREMISE-NO > 0                              
                       PERFORM 7750-SERVICE-ADDRESS THRU 7750-EXIT      
                       MOVE WS-ADDRESS-LINE TO S-COMM-ADDRESS           
                   ELSE                                                 
                       MOVE SPACES TO S-COMM-ADDRESS                    
                   END-IF                                               
               ELSE                                                     
                   MOVE SPACES TO S-COMM-ADDRESS
               END-IF
           END-IF.                       
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
       2015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2020-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO KN-COMMENT-TX.                                
                                                                        
           EXEC SQL                                                     
               FETCH COMM-DET-CURSOR                                    
                INTO :KN-UPDATE-TS,                                     
                     :KN-USER-ID,                                       
                     :KN-COMMENT-TX                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2020-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2320'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_COMMENT'  TO TABLE-1                  
                   MOVE 'COMMUNICATION_ID' TO TABLE-ELEMENT-1           
                   MOVE KO-COMMUNICATION-ID TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE KN-COMMUNICATION-ID TO S-COMM-ID-2.                     
           MOVE KN-UPDATE-TS TO S-COMM-UPDATE-TS.                       
           MOVE KN-USER-ID TO S-COMM-UPDATE-USER.                       
           IF KN-USER-ID > ' '                                          
               MOVE KN-USER-ID TO PF-USER-ID                            
               MOVE SPACES TO WS-USER-NAME                              
               PERFORM 7890-USER-PROFILE THRU 7890-EXIT                 
               MOVE WS-USER-NAME TO S-COMM-UPDATE-NAME                  
               MOVE C1-RESP-AREA-DESC TO S-RESP-AREA-DESC-2
           END-IF.            
           MOVE KN-COMMENT-TX-TEXT TO S-COMMENTS-2.                     
           MOVE KN-UPDATE-TS (1:10) TO WS-COMMENT-DATE.                 
           IF WS-COMMENT-DATE > WS-MAX-DATE                             
               MOVE WS-COMMENT-DATE TO WS-MAX-DATE
           END-IF.                     
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2020-FETCH-ROWS.                                       
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO,                                        
                     CUSTOMER_NO                                        
               INTO :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO                                     
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO,                                                
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*        INTO :AT-PREMISE-NO,                                             
MFA-TR*             :AT-CUSTOMER-NO                                             
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CU-CUSTOMER-NO = 0                                
                       MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO            
                   END-IF                                               
                   IF PR-PREMISE-NO = 0                                 
                       MOVE AT-PREMISE-NO TO PR-PREMISE-NO              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   PERFORM 7001-SELECT-ACCOUNT-ARCH THRU 7001-EXIT      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7001-SELECT-ACCOUNT-ARCH.                                        
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO,                                        
                     CUSTOMER_NO                                        
              INTO  :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO                                     
                 FROM HST_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO,                                                
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*       INTO  :AT-PREMISE-NO,                                             
MFA-TR*             :AT-CUSTOMER-NO                                             
MFA-TR*          FROM HST_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CU-CUSTOMER-NO = 0                                
                       MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO            
                   END-IF                                               
                   IF PR-PREMISE-NO = 0                                 
                       MOVE AT-PREMISE-NO TO PR-PREMISE-NO              
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-OPEN-COMM-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN COMM-CURSOR-A                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7111-CLOSE-COMM-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE COMM-CURSOR-A                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7111'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7111-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7112-OPEN-COMM-DET-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN COMM-DET-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7112'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_COMMENT'  TO TABLE-1                  
                   MOVE 'COMMUNICATION_ID' TO TABLE-ELEMENT-1           
                   MOVE KO-COMMUNICATION-ID TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7112-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7113-CLOSE-COMM-DET-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE COMM-DET-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7113'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_COMMENT'  TO TABLE-1                  
                   MOVE 'COMMUNICATION_ID' TO TABLE-ELEMENT-1           
                   MOVE KO-COMMUNICATION-ID TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7113-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7114-OPEN-COMM-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN COMM-CURSOR-C                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7114'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7114-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7115-CLOSE-COMM-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE COMM-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7115'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7115-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7116-OPEN-COMM-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN COMM-CURSOR-P                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7116'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7116-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7117-CLOSE-COMM-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE COMM-CURSOR-P                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7117'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COMM_DATA'  TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7117-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7750-SERVICE-ADDRESS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),
              DY.ADDRESS_ID,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              DY.ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN                                 
                 INTO :WS-ADDRESS-LINE,                                 
                      :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN                                
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                    
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
               WHERE PREMISE_NO = :WS-PR-PREMISE-NO                     
                 AND PR.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||             00010002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||              00020002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||              00030002
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                00040002
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||              00050002
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                00060002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||          00070002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||           00080002
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                      00090006
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                      00100002
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),             00110004
MFA-TR*               DY.ADDRESS_ID,                                            
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               DY.ZIP_CODE_TOKEN                                         
MFA-TR*          INTO :WS-ADDRESS-LINE,                                         
MFA-TR*               :DY-ADDRESS-ID,                                           
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                                   
MFA-TR*               :DY-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            00130001
MFA-TR*               CSS_ZIP_CODE A4,                                  00140001
MFA-TR*               CSS_PREMISE PR                                    00150001
MFA-TR*        WHERE PREMISE_NO = :WS-PR-PREMISE-NO                     00160000
MFA-TR*          AND PR.ADDRESS_ID = DY.ADDRESS_ID                      00170000
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                          00180000
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              00190000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00200000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7750                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-ADDRESS-LINE                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7750'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE'    TO TABLE-1                     
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'CSS_ZIP-CODE'   TO TABLE-3                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7880-SELECT-PREM-NO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                 INTO :WS-PR-PREMISE-NO                                 
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :KO-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*          INTO :WS-PR-PREMISE-NO                                         
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :KO-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7880                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-PR-PREMISE-NO                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7880'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE KO-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7880-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7890-USER-PROFILE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(LAST_NAME) + ', ' + 
           LTRIM(RTRIM(FIRST_NAME) + ' ' + LTRIM(RTRIM(MIDDLE_NAME))))
           ),
              RESP_AREA_ID                                      
                 INTO :WS-USER-NAME,                                    
                      :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :PF-USER-ID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(LAST_NAME) || ', ' ||           00010002
MFA-TR*               LTRIM(RTRIM(FIRST_NAME) || ' ' ||                 00020002
MFA-TR*               LTRIM(RTRIM(MIDDLE_NAME))))),                     00110004
MFA-TR*               RESP_AREA_ID                                              
MFA-TR*          INTO :WS-USER-NAME,                                            
MFA-TR*               :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :PF-USER-ID                                     
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7890                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE PF-RESP-AREA-ID TO C1-RESP-AREA-ID              
                   PERFORM 7900-RESP-AREA THRU 7900-EXIT                
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE PF-USER-ID TO WS-USER-NAME                      
                   MOVE SPACES TO C1-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7890'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_USER_PROFILE' TO TABLE-1                   
                   MOVE 'USER_ID'        TO TABLE-ELEMENT-1             
                   MOVE PF-USER-ID       TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7890-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7900-RESP-AREA.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RESP_AREA_DESC                                    
                 INTO :C1-RESP-AREA-DESC                                
                 FROM CSS_RESP_AREA WITH(READUNCOMMITTED)                       
                WHERE RESP_AREA_ID = :C1-RESP-AREA-ID                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_DESC                                    00010002
MFA-TR*          INTO :C1-RESP-AREA-DESC                                        
MFA-TR*          FROM CSS_RESP_AREA                                             
MFA-TR*         WHERE RESP_AREA_ID = :C1-RESP-AREA-ID                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO C1-RESP-AREA-DESC                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7900'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_RESP_AREA'  TO TABLE-1                     
                   MOVE 'RESP_AREA_ID'   TO TABLE-ELEMENT-1             
                   MOVE C1-RESP-AREA-ID  TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-CTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04286_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04286_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8003'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04286_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04286_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04286_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8009'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04286_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04286_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              COMM_DATE,                                                
              RED_FLAG_IND,                                             
              RED_FLAG_DT,                                              
              COMM_TYPE,                                                
              COMM_SUBTYPE,                                             
              CONTACT_NAME,                                             
              COMMENTS,                                                 
              COMM_ID,                                                  
              COMM_METHOD,                                              
              COMM_DIRECTION,                                           
              USER_ID_ORIG,                                             
              COMM_ASSOC_CD,                                            
              COMM_ADDRESS,                                             
              RESP_AREA_DESC,                                           
              USER_ID_NAME,                                             
              COMPLAINT_FL,                                             
              COMPLIANCE_IND,                                           
              ACCOUNT_NO                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-COMM-DATE,                                            
               :S-RED-FLAG-IND,                                         
               :S-RED-FLAG-DT,                                          
               :S-COMM-TYPE,                                            
               :S-COMM-SUBTYPE,                                         
               :S-CONTACT-NAME,                                         
               :S-COMMENTS-1,                                           
               :S-COMM-ID-1,                                            
               :S-COMM-METHOD,                                          
               :S-COMM-DIRECTION,                                       
               :S-USER-ID-ORIG,                                         
               :S-COMM-ASSOC-CD,                                        
               :S-COMM-ADDRESS,                                         
               :S-RESP-AREA-DESC,                                       
               :S-USER-ID-NAME,                                         
               :S-COMPLAINT-FL,                                         
               :S-COMPLIANCE-IND,                                       
               :S-ACCOUNT-NO                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04286_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       COMM_DATE,                                                        
MFA-TR*       RED_FLAG_IND,                                                     
MFA-TR*       RED_FLAG_DT,                                                      
MFA-TR*       COMM_TYPE,                                                        
MFA-TR*       COMM_SUBTYPE,                                                     
MFA-TR*       CONTACT_NAME,                                                     
MFA-TR*       COMMENTS,                                                         
MFA-TR*       COMM_ID,                                                          
MFA-TR*       COMM_METHOD,                                                      
MFA-TR*       COMM_DIRECTION,                                                   
MFA-TR*       USER_ID_ORIG,                                                     
MFA-TR*       COMM_ASSOC_CD,                                                    
MFA-TR*       COMM_ADDRESS,                                                     
MFA-TR*       RESP_AREA_DESC,                                                   
MFA-TR*       USER_ID_NAME,                                                     
MFA-TR*       COMPLAINT_FL,                                                     
MFA-TR*       COMPLIANCE_IND,                                                   
MFA-TR*       ACCOUNT_NO                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-COMM-DATE,                                                    
MFA-TR*        :S-RED-FLAG-IND,                                                 
MFA-TR*        :S-RED-FLAG-DT,                                                  
MFA-TR*        :S-COMM-TYPE,                                                    
MFA-TR*        :S-COMM-SUBTYPE,                                                 
MFA-TR*        :S-CONTACT-NAME,                                                 
MFA-TR*        :S-COMMENTS-1,                                                   
MFA-TR*        :S-COMM-ID-1,                                                    
MFA-TR*        :S-COMM-METHOD,                                                  
MFA-TR*        :S-COMM-DIRECTION,                                               
MFA-TR*        :S-USER-ID-ORIG,                                                 
MFA-TR*        :S-COMM-ASSOC-CD,                                                
MFA-TR*        :S-COMM-ADDRESS,                                                 
MFA-TR*        :S-RESP-AREA-DESC,                                               
MFA-TR*        :S-USER-ID-NAME,                                                 
MFA-TR*        :S-COMPLAINT-FL,                                                 
MFA-TR*        :S-COMPLIANCE-IND,                                               
MFA-TR*        :S-ACCOUNT-NO                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04286_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04286_R2                            
             (                                                          
              RETURN_CODE,                                              
              COMM_ID,                                                  
              COMM_UPDATE_TS,                                           
              COMM_UPDATE_USER,                                         
              COMMENTS,                                                 
              RESP_AREA_DESC,                                           
              COMM_UPDATE_NAME                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-COMM-ID-2,                                            
               :S-COMM-UPDATE-TS,                                       
               :S-COMM-UPDATE-USER,                                     
               :S-COMMENTS-2,                                           
               :S-RESP-AREA-DESC-2,                                     
               :S-COMM-UPDATE-NAME                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04286_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       COMM_ID,                                                          
MFA-TR*       COMM_UPDATE_TS,                                                   
MFA-TR*       COMM_UPDATE_USER,                                                 
MFA-TR*       COMMENTS,                                                         
MFA-TR*       RESP_AREA_DESC,                                                   
MFA-TR*       COMM_UPDATE_NAME                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-COMM-ID-2,                                                    
MFA-TR*        :S-COMM-UPDATE-TS,                                               
MFA-TR*        :S-COMM-UPDATE-USER,                                             
MFA-TR*        :S-COMMENTS-2,                                                   
MFA-TR*        :S-RESP-AREA-DESC-2,                                             
MFA-TR*        :S-COMM-UPDATE-NAME                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8810'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04286_R2'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
