       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04285.                                          
COB303 DATE-WRITTEN.      JUNE 27, 2012.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS COMMON BPA DATA.                        *        
      *  RESULTS SETS:                                                 *        
      *     1.  ACCOUNT NAMES/CONTACTS                                 *        
      *     2.  CONTACT PHONE INFO                                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/27/12    FMB      NEW PROGRAM.                                      
A04671*  07/29/13    FMB      ADDED NEW FIELDS TO RESULTS SET FOR               
A04671*                       CREDIT CHECK.                                     
P00740*  03/12/14    FMB      CASA MODS.                                        
D09342*  09/25/15    FMB      RETURN 3RD PARTY STATUS. INACTIVE 3RD             
D09342*                       PARTIES MUST BE RETURNED FOR NAVIGATION.          
D05317*  11/12/15    FMB      EMAIL DATE TO TIMESTAMP.                          
A05317*  02/08/16    FMB      INCLUDE PREFIX AND SUFFIX IN SPOUSE NAME.         
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04285'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04285 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHSTNME                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBSCSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTHDPTY                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTHDPHO                                                  
           END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                             
P00740        INCLUDE TBTHDEML                                                  
P00740     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCPR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTPHN                                                  
           END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                             
P00740        INCLUDE TBCONSTA                                                  
P00740     END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                             
P00740        INCLUDE TBCONEML                                                  
P00740     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCOAPP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHCOAPP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBROOMT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHROOMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                             
P00740        INCLUDE TBCUSXFR                                                  
P00740     END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                             
P00740        INCLUDE TBDELQ                                                    
P00740     END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                             
P00740        INCLUDE TBCTYPE                                                   
P00740     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04285_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04285_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-NAME-TYPE         PIC X(02) VALUE SPACES.           
               10 S-NAME              PIC X(86) VALUE SPACES.           
               10 S-CONTACT-TYPE      PIC X(35) VALUE SPACES.           
               10 S-CONTACT-SSN       PIC X(09) VALUE SPACES.           
               10 S-CONTACT-DOB       PIC X(10) VALUE SPACES.           
               10 S-CONTACT-DLN       PIC X(19) VALUE SPACES.           
               10 S-CONTACT-OTHER-ID  PIC X(16) VALUE SPACES.           
               10 S-CONTACT-TAX-ID    PIC X(09) VALUE SPACES.           
               10 S-CONTACT-OTHER-ID-TYPE PIC X(15) VALUE SPACES.       
               10 S-CONTACT-NICKNAME  PIC X(50) VALUE SPACES.           
               10 S-REFUSED-SSN       PIC X(01) VALUE SPACES.           
               10 S-NAME-COUNTER      PIC S9(9) COMP VALUE 0.           
               10 S-CONTACT-TYPE-CD   PIC X(02) VALUE SPACES.           
               10 S-PASSWORD          PIC X(16) VALUE SPACES.           
               10 S-ID                PIC S9(10)V COMP-3 VALUE 0.       
               10 S-EMAIL-ADDRESS     PIC X(100) VALUE SPACES.          
               10 S-NAME-FORMAT       PIC X(01) VALUE SPACES.           
               10 S-CONTACT-DLN-STATE PIC X(02) VALUE SPACES.           
A04671         10 S-LAST-NAME         PIC X(40) VALUE SPACES.           
A04671         10 S-FIRST-NAME        PIC X(15) VALUE SPACES.           
A04671         10 S-MIDDLE-NAME       PIC X(15) VALUE SPACES.           
A04671         10 S-NAME-SUFFIX       PIC X(03) VALUE SPACES.           
A04671         10 S-DOB-VERIFIED      PIC X(01) VALUE SPACES.           
A04671         10 S-DHR-FL            PIC X(01) VALUE SPACES.           
P00740         10 S-ACCESS-LEVEL-CD   PIC X(02) VALUE SPACES.           
P00740         10 S-VERIFY-SSN-FL     PIC X(01) VALUE SPACES.           
P00740         10 S-ALLOW-CALL-FL     PIC X(01) VALUE SPACES.           
P00740         10 S-MEMO-BILL-IND     PIC X(01) VALUE SPACES.           
P00740         10 S-CONFIRM-FL        PIC X(01) VALUE SPACES.           
P00740         10 S-EMAIL-CT          PIC S9(4) COMP VALUE 0.           
P00740         10 S-CONTACT-ITIN      PIC X(09) VALUE SPACES.           
P00740         10 S-ENTITY-IND        PIC X(01) VALUE SPACES.           
P00740         10 S-PASSWORD-HINT     PIC X(100) VALUE SPACES.          
P00740         10 S-ALLOW-EMAIL-FL    PIC X(01) VALUE SPACES.           
D09342         10 S-3RD-PARTY-FL      PIC X(01) VALUE SPACES.           
A05317         10 S-SORT-ORDER        PIC X(01) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2      PIC S9(9) COMP VALUE 0.          
               10 S-PHONE-NAME-TYPE    PIC X(02) VALUE SPACES.          
               10 S-PHONE-NAME-COUNTER PIC S9(9) COMP VALUE 0.          
               10 S-PHONE-TYPE         PIC X(02) VALUE SPACES.          
               10 S-PHONE-NO           PIC X(10) VALUE SPACES.          
               10 S-PHONE-EXT          PIC X(06) VALUE SPACES.          
P00740         10 S-PHONE-MOBILE-FL    PIC X(01) VALUE SPACES.          
P00740         10 S-PHONE-MKT-FL       PIC X(01) VALUE SPACES.          
P00740         10 S-PHONE-MKT-DT       PIC X(10) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-PREM-NO-NUM           PIC 9(10).                      
           05  WS-PREM-NO-CHAR          REDEFINES WS-PREM-NO-NUM        
                                        PIC X(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04285'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
P00740     05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
P00740     05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
P00740     05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
P00740     05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
P00740     05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-NAME                  PIC X(86) VALUE SPACES.         
           05  WS-ARCHIVED-ACCOUNT      PIC X(01) VALUE 'N'.            
           05  WS-SPACES                PIC S9(02) COMP-3 VALUE +0.     
           05  WS-LENGTH                PIC S9(02) COMP-3 VALUE +0.     
           05  WS-SSN-FORMAT            PIC X(01) VALUE SPACES.         
           05  WS-UNFORMATTED-SSN       PIC X(09) VALUE SPACES.         
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
P00740     05  WS-EMAIL-TYPE-CD         PIC X(02) VALUE SPACES.         
           05  WS-CUST-NAME             PIC X(76) VALUE SPACES.         
P00740     05  WS-CUST-EMAIL            PIC X(100) VALUE SPACES.        
P00740     05  WS-CUST-EMAIL-CT         PIC S9(04) COMP VALUE 0.        
P00740     05  WS-3RD-EMAIL             PIC X(100) VALUE SPACES.        
P00740     05  WS-3RD-EMAIL-CT          PIC S9(04) COMP VALUE 0.        
P00740     05  WS-CONTACT-EMAIL         PIC X(100) VALUE SPACES.        
P00740     05  WS-CONTACT-EMAIL-CT      PIC S9(04) COMP VALUE 0.        
P00740     05  WS-ENTITY-IND            PIC X(01) VALUE SPACES.         
P00740     05  WS-DATABASE              PIC 9(01) VALUE 0.              
P00740         88  CSR-DATABASE                   VALUE 1.              
P00740         88  SEB-DATABASE                   VALUE 2.              
P00740     05  WS-CASA-CONFIRM          PIC 9(01) VALUE 0.              
P00740         88  CASA-CONFIRM-NO                VALUE 0.              
P00740         88  CASA-CONFIRM-YES               VALUE 1.              
                                                                        
       01  WS-CONTACT-COUNTERS.                                         
           05  WS-RO-COUNTER            PIC 9(9) VALUE 0.               
           05  WS-CO-COUNTER            PIC 9(9) VALUE 0.               
           05  WS-TP-COUNTER            PIC 9(9) VALUE 0.               
           05  WS-AC-COUNTER            PIC 9(9) VALUE 0.               
           05  WS-CC-COUNTER            PIC 9(9) VALUE 0.               
           05  WS-PC-COUNTER            PIC 9(9) VALUE 0.               
                                                                        
       01  WS-PHONE-FIELDS.                                             
           05  WS-PRIMARY-PHONE         PIC X(10) VALUE SPACES.         
           05  WS-PRIMARY-EXT           PIC X(06) VALUE SPACES.         
P00740     05  WS-PRIMARY-MOBILE-FL     PIC X(01) VALUE SPACES.         
P00740     05  WS-PRIMARY-MKT-FL        PIC X(01) VALUE SPACES.         
P00740     05  WS-PRIMARY-MKT-DT        PIC X(10) VALUE SPACES.         
           05  WS-ALTERNATE-PHONE       PIC X(10) VALUE SPACES.         
           05  WS-ALTERNATE-EXT         PIC X(06) VALUE SPACES.         
P00740     05  WS-ALTERNATE-MOBILE-FL   PIC X(01) VALUE SPACES.         
P00740     05  WS-ALTERNATE-MKT-FL      PIC X(01) VALUE SPACES.         
P00740     05  WS-ALTERNATE-MKT-DT      PIC X(10) VALUE SPACES.         
           05  WS-BUSINESS-PHONE        PIC X(10) VALUE SPACES.         
           05  WS-BUSINESS-EXT          PIC X(06) VALUE SPACES.         
P00740     05  WS-BUSINESS-MOBILE-FL    PIC X(01) VALUE SPACES.         
P00740     05  WS-BUSINESS-MKT-FL       PIC X(01) VALUE SPACES.         
P00740     05  WS-BUSINESS-MKT-DT       PIC X(10) VALUE SPACES.         
           05  WS-WORK-PHONE            PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXT              PIC X(06) VALUE SPACES.         
P00740     05  WS-WORK-MOBILE-FL        PIC X(01) VALUE SPACES.         
P00740     05  WS-WORK-MKT-FL           PIC X(01) VALUE SPACES.         
P00740     05  WS-WORK-MKT-DT           PIC X(10) VALUE SPACES.         
                                                                        
P00740 01  WS-TABLES.                                                   
P00740     05  T1-CONTACTS          OCCURS 100 INDEXED BY T1-INDEX.     
P00740         10 T1-CONTACT-CD     PIC X(02).                          
P00740         10 T1-CONTACT-DESC   PIC X(35).                          
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE PHONE-CURSOR CURSOR FOR                           
               SELECT PHONE_NO,                                         
                      PHONE_TYPE,                                       
                      EXTENSION_NO,                                     
P00740                MOBILE_PHONE_FL,                                  
P00740                PERMISN_TO_MKT_DT,                                
P00740                PERMISN_TO_MKT_FL                                 
                 FROM CSS_CUST_PHONE WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                     
P00740            AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                 
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PHONE-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT PHONE_NO,                                                 
MFA-TR*               PHONE_TYPE,                                               
MFA-TR*               EXTENSION_NO,                                             
MFA-TR*               MOBILE_PHONE_FL,                                          
MFA-TR*               PERMISN_TO_MKT_DT,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_CUST_PHONE                                            
MFA-TR*         WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                         
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ROOMMATE-CURSOR CURSOR FOR                        
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      RO.CUSTOMER_NO,                                   
P00740                RO.ACCESS_LEVEL_CD,                               
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), CU.VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS                          
                 FROM CSS_ROOMMATE RO WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                WHERE RO.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND RO.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ROOMMATE-CURSOR CURSOR FOR                                
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               RO.CUSTOMER_NO,                                           
MFA-TR*               RO.ACCESS_LEVEL_CD,                                       
MFA-TR*               CU.VALIDATION_TS                                          
MFA-TR*          FROM CSS_ROOMMATE RO,                                          
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE RO.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND RO.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7140                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE COAPP-CURSOR CURSOR FOR                           
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      IC.CUSTOMER_NO,                                   
P00740                IC.ACCESS_LEVEL_CD,                               
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), CU.VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS                          
                 FROM CSS_COAPPLICANT IC WITH(READUNCOMMITTED),                 
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                WHERE IC.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND IC.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COAPP-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               IC.CUSTOMER_NO,                                           
MFA-TR*               IC.ACCESS_LEVEL_CD,                                       
MFA-TR*               CU.VALIDATION_TS                                          
MFA-TR*          FROM CSS_COAPPLICANT IC,                                       
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE IC.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND IC.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ROOMMATE-CURSOR-H CURSOR FOR                      
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      RX.CUSTOMER_NO,                                   
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), CU.VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS                          
                 FROM HST_ROOMMATE RX WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                WHERE RX.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND RX.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ROOMMATE-CURSOR-H CURSOR FOR                              
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               RX.CUSTOMER_NO,                                           
MFA-TR*               CU.VALIDATION_TS                                          
MFA-TR*          FROM HST_ROOMMATE RX,                                          
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE RX.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND RX.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7142                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE COAPP-CURSOR-H CURSOR FOR                         
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      RY.CUSTOMER_NO,                                   
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), CU.VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS                          
                 FROM HST_COAPPLICANT RY WITH(READUNCOMMITTED),                 
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                WHERE RY.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND RY.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COAPP-CURSOR-H CURSOR FOR                                 
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               RY.CUSTOMER_NO,                                           
MFA-TR*               CU.VALIDATION_TS                                          
MFA-TR*          FROM HST_COAPPLICANT RY,                                       
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE RY.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND RY.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                     
P00740        DECLARE XFER-CURSOR CURSOR FOR                            
P00740         SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
P00740                FULL_NAME,                                        
P00740                NAME_FORMAT,                                      
P00740                EK.CUSTOMER_NO,                                   
P00740                EK.ACCESS_LEVEL_CD,                               
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), CU.VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                RELATION_TYPE_CD                                  
P00740           FROM CSS_CUSTOMER_XFER EK WITH(READUNCOMMITTED),               
P00740                CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00740                CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
P00740          WHERE EK.ASSOC_CUSTOMER_NO = :CU-CUSTOMER-NO            
P00740            AND EK.CUSTOMER_NO = CU.CUSTOMER_NO                   
P00740            AND CU.NAME_ID = DQ.NAME_ID                           
P00740                                                           
P00740          FOR READ ONLY                                          
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE XFER-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               EK.CUSTOMER_NO,                                           
MFA-TR*               EK.ACCESS_LEVEL_CD,                                       
MFA-TR*               CU.VALIDATION_TS,                                         
MFA-TR*               RELATION_TYPE_CD                                          
MFA-TR*          FROM CSS_CUSTOMER_XFER EK,                                     
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE EK.ASSOC_CUSTOMER_NO = :CU-CUSTOMER-NO                    
MFA-TR*           AND EK.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7206                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE THIRD-PARTY-CURSOR CURSOR FOR                     
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      THD_PRTY_ID,                                      
P00740                ACCESS_LEVEL_CD,                                  
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                DATE_OF_BIRTH,                                    
D09342                THD_PRTY_STATUS                                   
                 FROM CSS_THD_PRTY ZW WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ZW.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND ZW.NAME_ID = DQ.NAME_ID                           
P00740*           AND THD_PRTY_STATUS = 'A'                                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE THIRD-PARTY-CURSOR CURSOR FOR                             
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               THD_PRTY_ID,                                              
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               THD_PRTY_STATUS                                           
MFA-TR*          FROM CSS_THD_PRTY ZW,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ZW.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND ZW.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND THD_PRTY_STATUS = 'A'                                     
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7160                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE THIRD-PHONE-CURSOR CURSOR FOR                     
               SELECT PHONE_TYPE,                                       
                      PHONE_NO,                                         
                      EXTENSION_NO,                                     
P00740                MOBILE_PHONE_FL,                                  
P00740                PERMISN_TO_MKT_DT,                                
P00740                PERMISN_TO_MKT_FL                                 
                 FROM CSS_THD_PRTY_PHONE WITH(READUNCOMMITTED)                  
                WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                     
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE THIRD-PHONE-CURSOR CURSOR FOR                             
MFA-TR*        SELECT PHONE_TYPE,                                               
MFA-TR*               PHONE_NO,                                                 
MFA-TR*               EXTENSION_NO,                                             
MFA-TR*               MOBILE_PHONE_FL,                                          
MFA-TR*               PERMISN_TO_MKT_DT,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_THD_PRTY_PHONE                                        
MFA-TR*         WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7162                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                     
P00740        DECLARE OUTAGE-CONTACT-CURSOR CURSOR FOR                  
P00740         SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
P00740                FULL_NAME,                                        
P00740                NAME_FORMAT,                                      
P00740                CONTACT_TYPE,                                     
P00740                CONTACT_POSITION,                                 
P00740                CV.CONTACT_ID,                                    
P00740                ACCESS_LEVEL_CD,                                  
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                MEMO_BILL_IND                                     
P00740           FROM CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
P00740                CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00740                CSS_NAME DQ WITH(READUNCOMMITTED)                         
P00740          WHERE DW.ACCOUNT_NO = :AT-ACCOUNT-NO                    
P00740            AND DW.CONTACT_ID = CV.CONTACT_ID                     
P00740            AND CV.NAME_ID = DQ.NAME_ID                           
P00740            AND CONTACT_TYPE = 'OC'                               
P00740                                                           
P00740          FOR READ ONLY                                          
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OUTAGE-CONTACT-CURSOR CURSOR FOR                          
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CONTACT_TYPE,                                             
MFA-TR*               CONTACT_POSITION,                                         
MFA-TR*               CV.CONTACT_ID,                                            
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               MEMO_BILL_IND                                             
MFA-TR*          FROM CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DW.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND DW.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE = 'OC'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7194                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                     
P00740        DECLARE INTERNAL-CONTACT-CURSOR CURSOR FOR                
P00740         SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
P00740                FULL_NAME,                                        
P00740                NAME_FORMAT,                                      
P00740                CONTACT_TYPE,                                     
P00740                CONTACT_POSITION,                                 
P00740                CV.CONTACT_ID,                                    
P00740                ACCESS_LEVEL_CD,                                  
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                MEMO_BILL_IND,                                    
P00740                'A'                                               
P00740           FROM CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
P00740                CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00740                CSS_NAME DQ WITH(READUNCOMMITTED)                         
P00740          WHERE DW.ACCOUNT_NO = :AT-ACCOUNT-NO                    
P00740            AND DW.CONTACT_ID = CV.CONTACT_ID                     
P00740            AND CV.NAME_ID = DQ.NAME_ID                           
P00740            AND CONTACT_TYPE IN ('SA', 'SE', 'SG', 'PG')          
P00740         UNION                                                    
P00740         SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
P00740                FULL_NAME,                                        
P00740                NAME_FORMAT,                                      
P00740                CONTACT_TYPE,                                     
P00740                CONTACT_POSITION,                                 
P00740                CV.CONTACT_ID,                                    
P00740                ACCESS_LEVEL_CD,                                  
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                MEMO_BILL_IND,                                    
P00740                'C'                                               
P00740           FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
P00740                CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00740                CSS_NAME DQ WITH(READUNCOMMITTED)                         
P00740          WHERE DT.CUSTOMER_NO = :CU-CUSTOMER-NO                  
P00740            AND DT.CONTACT_ID = CV.CONTACT_ID                     
P00740            AND CV.NAME_ID = DQ.NAME_ID                           
P00740            AND CONTACT_TYPE IN ('SA', 'SE', 'SG', 'PG')          
P00740                                                           
P00740          FOR READ ONLY                                          
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INTERNAL-CONTACT-CURSOR CURSOR FOR                        
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CONTACT_TYPE,                                             
MFA-TR*               CONTACT_POSITION,                                         
MFA-TR*               CV.CONTACT_ID,                                            
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               MEMO_BILL_IND,                                            
MFA-TR*               'A'                                                       
MFA-TR*          FROM CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DW.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND DW.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE IN ('SA', 'SE', 'SG', 'PG')                  
MFA-TR*        UNION                                                            
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CONTACT_TYPE,                                             
MFA-TR*               CONTACT_POSITION,                                         
MFA-TR*               CV.CONTACT_ID,                                            
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               MEMO_BILL_IND,                                            
MFA-TR*               'C'                                                       
MFA-TR*          FROM CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DT.CUSTOMER_NO = :CU-CUSTOMER-NO                          
MFA-TR*           AND DT.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE IN ('SA', 'SE', 'SG', 'PG')                  
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7196                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ACCT-CONTACT-CURSOR CURSOR FOR                    
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      CONTACT_TYPE,                                     
                      NICKNAME,                                         
                      CONTACT_POSITION,                                 
                      CV.CONTACT_ID,                                    
P00740                ACCESS_LEVEL_CD,                                  
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                MEMO_BILL_IND                                     
                 FROM CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
                      CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE DW.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND DW.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.NAME_ID = DQ.NAME_ID                           
P00740            AND CONTACT_TYPE NOT IN ('OC', 'SA', 'SE',            
P00740                                     'SG', 'PG', 'SS', 'RR')      
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CONTACT-CURSOR CURSOR FOR                            
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CONTACT_TYPE,                                             
MFA-TR*               NICKNAME,                                                 
MFA-TR*               CONTACT_POSITION,                                         
MFA-TR*               CV.CONTACT_ID,                                            
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               MEMO_BILL_IND                                             
MFA-TR*          FROM CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DW.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND DW.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE NOT IN ('OC', 'SA', 'SE',                    
MFA-TR*                                    'SG', 'PG', 'SS', 'RR')              
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7170                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE CUST-CONTACT-CURSOR CURSOR FOR                    
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      CONTACT_TYPE,                                     
                      NICKNAME,                                         
                      CONTACT_POSITION,                                 
                      CV.CONTACT_ID,                                    
P00740                ACCESS_LEVEL_CD,                                  
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                MEMO_BILL_IND                                     
                 FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
                      CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE DT.CUSTOMER_NO = :CU-CUSTOMER-NO                  
                  AND DT.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.NAME_ID = DQ.NAME_ID                           
P00740            AND CONTACT_TYPE NOT IN ('OC', 'SA', 'SE',            
P00740                                     'SG', 'PG', 'SS', 'RR')      
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUST-CONTACT-CURSOR CURSOR FOR                            
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CONTACT_TYPE,                                             
MFA-TR*               NICKNAME,                                                 
MFA-TR*               CONTACT_POSITION,                                         
MFA-TR*               CV.CONTACT_ID,                                            
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               MEMO_BILL_IND                                             
MFA-TR*          FROM CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DT.CUSTOMER_NO = :CU-CUSTOMER-NO                          
MFA-TR*           AND DT.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE NOT IN ('OC', 'SA', 'SE',                    
MFA-TR*                                    'SG', 'PG', 'SS', 'RR')              
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7180                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE PREM-CONTACT-CURSOR CURSOR FOR                    
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),                             
                      FULL_NAME,                                        
                      NAME_FORMAT,                                      
                      CONTACT_TYPE,                                     
                      NICKNAME,                                         
                      CONTACT_POSITION,                                 
                      CV.CONTACT_ID,                                    
P00740                ACCESS_LEVEL_CD,                                  
P00740                REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS
           , 121), ' ', '-'), ':', '.') VALIDATION_TS,                         
P00740                MEMO_BILL_IND                                     
                 FROM CSS_CONTACT_PREM DX WITH(READUNCOMMITTED),                
                      CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE DX.PREMISE_NO = :PR-PREMISE-NO                    
                  AND DX.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.NAME_ID = DQ.NAME_ID                           
P00740            AND CONTACT_TYPE NOT IN ('OC', 'SA', 'SE',            
P00740                                     'SG', 'PG', 'SS', 'RR')      
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PREM-CONTACT-CURSOR CURSOR FOR                            
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CONTACT_TYPE,                                             
MFA-TR*               NICKNAME,                                                 
MFA-TR*               CONTACT_POSITION,                                         
MFA-TR*               CV.CONTACT_ID,                                            
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               MEMO_BILL_IND                                             
MFA-TR*          FROM CSS_CONTACT_PREM DX,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DX.PREMISE_NO = :PR-PREMISE-NO                            
MFA-TR*           AND DX.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE NOT IN ('OC', 'SA', 'SE',                    
MFA-TR*                                    'SG', 'PG', 'SS', 'RR')              
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7190                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE CONTACT-PHONE-CURSOR CURSOR FOR                   
               SELECT PHONE_TYPE,                                       
                      PHONE_NO,                                         
                      EXTENSION_NO,                                     
P00740                MOBILE_PHONE_FL,                                  
P00740                PERMISN_TO_MKT_DT,                                
P00740                PERMISN_TO_MKT_FL                                 
                 FROM CSS_CONTACT_PHONE WITH(READUNCOMMITTED)                   
                WHERE CONTACT_ID = :LP-CONTACT-ID                       
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTACT-PHONE-CURSOR CURSOR FOR                           
MFA-TR*        SELECT PHONE_TYPE,                                               
MFA-TR*               PHONE_NO,                                                 
MFA-TR*               EXTENSION_NO,                                             
MFA-TR*               MOBILE_PHONE_FL,                                          
MFA-TR*               PERMISN_TO_MKT_DT,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_CONTACT_PHONE                                         
MFA-TR*         WHERE CONTACT_ID = :LP-CONTACT-ID                               
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7192                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                     
P00740        DECLARE CUST-EMAIL-CURSOR CURSOR FOR                      
P00740         SELECT EMAIL_TYPE_CD,                                    
P00740                EMAIL_ADDRESS_TX,                                 
D05317                REPLACE(REPLACE(CONVERT(CHAR(26), 
           PERMISN_TO_MKT_TS, 121), ' ', '-'), ':', '.') 
           PERMISN_TO_MKT_TS,                                
P00740                PERMISN_TO_MKT_FL                                 
P00740           FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
P00740          WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                     
P00740            AND EMAIL_TYPE_CD LIKE :WS-EMAIL-TYPE-CD              
P00740                                                           
P00740          FOR READ ONLY                                          
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUST-EMAIL-CURSOR CURSOR FOR                              
MFA-TR*        SELECT EMAIL_TYPE_CD,                                            
MFA-TR*               EMAIL_ADDRESS_TX,                                         
MFA-TR*               PERMISN_TO_MKT_TS,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD LIKE :WS-EMAIL-TYPE-CD                      
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                     
P00740        DECLARE THIRD-EMAIL-CURSOR CURSOR FOR                     
P00740         SELECT EMAIL_TYPE_CD,                                    
P00740                EMAIL_ADDRESS_TX,                                 
D05317                REPLACE(REPLACE(CONVERT(CHAR(26), 
           PERMISN_TO_MKT_TS, 121), ' ', '-'), ':', '.') 
           PERMISN_TO_MKT_TS,                                
P00740                PERMISN_TO_MKT_FL                                 
P00740           FROM CSS_THD_PRTY_EMAIL WITH(READUNCOMMITTED)                  
P00740          WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                     
P00740            AND EMAIL_TYPE_CD LIKE 'T%'                           
P00740                                                           
P00740          FOR READ ONLY                                          
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE THIRD-EMAIL-CURSOR CURSOR FOR                             
MFA-TR*        SELECT EMAIL_TYPE_CD,                                            
MFA-TR*               EMAIL_ADDRESS_TX,                                         
MFA-TR*               PERMISN_TO_MKT_TS,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_THD_PRTY_EMAIL                                        
MFA-TR*         WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                             
MFA-TR*           AND EMAIL_TYPE_CD LIKE 'T%'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7202                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                     
P00740        DECLARE CONTACT-EMAIL-CURSOR CURSOR FOR                   
P00740         SELECT EMAIL_TYPE_CD,                                    
P00740                EMAIL_ADDRESS_TX,                                 
D05317                REPLACE(REPLACE(CONVERT(CHAR(26), 
           PERMISN_TO_MKT_TS, 121), ' ', '-'), ':', '.') 
           PERMISN_TO_MKT_TS,                                
P00740                PERMISN_TO_MKT_FL                                 
P00740           FROM CSS_CONTACT_EMAIL WITH(READUNCOMMITTED)                   
P00740          WHERE CONTACT_ID = :CV-CONTACT-ID                       
P00740            AND EMAIL_TYPE_CD LIKE 'N%'                           
P00740                                                           
P00740          FOR READ ONLY                                          
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTACT-EMAIL-CURSOR CURSOR FOR                           
MFA-TR*        SELECT EMAIL_TYPE_CD,                                            
MFA-TR*               EMAIL_ADDRESS_TX,                                         
MFA-TR*               PERMISN_TO_MKT_TS,                                        
MFA-TR*               PERMISN_TO_MKT_FL                                         
MFA-TR*          FROM CSS_CONTACT_EMAIL                                         
MFA-TR*         WHERE CONTACT_ID = :CV-CONTACT-ID                               
MFA-TR*           AND EMAIL_TYPE_CD LIKE 'N%'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7204                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00740     EXEC SQL                                                     
P00740        DECLARE CONTACT-TYPE-CURSOR CURSOR FOR                    
P00740         SELECT DISTINCT CONTACT_TYPE,                            
P00740                CONTACT_TYPE_DESC                                 
P00740           FROM CSS_CONTACT_TYPE WITH(READUNCOMMITTED)                    
P00740                                                           
P00740          FOR READ ONLY                                          
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTACT-TYPE-CURSOR CURSOR FOR                            
MFA-TR*        SELECT DISTINCT CONTACT_TYPE,                                    
MFA-TR*               CONTACT_TYPE_DESC                                         
MFA-TR*          FROM CSS_CONTACT_TYPE                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7208                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE      AS RETURN_CODE,                  
                      STATUS_CODE      AS STATUS_CODE,                  
                      NAME_TYPE        AS NAME_TYPE,                    
                      NAME             AS NAME,                         
                      CONTACT_TYPE     AS CONTACT_TYPE,                 
                      CONTACT_SSN      AS CONTACT_SSN,                  
                      CONTACT_DOB      AS CONTACT_DOB,                  
                      CONTACT_DLN      AS CONTACT_DLN,                  
                      CONTACT_OTHER_ID AS CONTACT_OTHER_ID,             
                      CONTACT_TAX_ID   AS CONTACT_TAX_ID,               
                      CONTACT_OTHER_ID_TYPE AS CONTACT_OTHER_ID_TYPE,   
                      CONTACT_NICKNAME AS CONTACT_NICKNAME,             
                      REFUSED_SSN      AS REFUSED_SSN,                  
                      NAME_COUNTER     AS NAME_COUNTER,                 
                      CONTACT_TYPE_CD  AS CONTACT_TYPE_CD,              
                      PASSWORD         AS PASSWORD,                     
                      ID               AS ID,                           
                      EMAIL_ADDRESS    AS EMAIL_ADDRESS,                
                      NAME_FORMAT      AS NAME_FORMAT,                  
                      CONTACT_DLN_STATE AS CONTACT_DLN_STATE,           
A04671                LAST_NAME        AS LAST_NAME,                    
A04671                FIRST_NAME       AS FIRST_NAME,                   
A04671                MIDDLE_NAME      AS MIDDLE_NAME,                  
A04671                NAME_SUFFIX      AS NAME_SUFFIX,                  
A04671                DOB_VERIFIED     AS DOB_VERIFIED,                 
A04671                DHR_FL           AS DHR_FL,                       
P00740                ACCESS_LEVEL_CD  AS ACCESS_LEVEL_CD,              
P00740                VERIFY_SSN_FL    AS VERIFY_SSN_FL,                
P00740                ALLOW_CALL_FL    AS ALLOW_CALL_FL,                
P00740                MEMO_BILL_IND    AS MEMO_BILL_IND,                
P00740                CONFIRM_REQ_FL   AS CONFIRM_REQ_FL,               
P00740                EMAIL_CT         AS EMAIL_CT,                     
P00740                CONTACT_ITIN     AS CONTACT_ITIN,                 
P00740                ENTITY_IND       AS ENTITY_IND,                   
P00740                PASSWORD_HINT    AS PASSWORD_HINT,                
P00740                ALLOW_EMAIL_FL   AS ALLOW_EMAIL_FL,               
D09342                THIRD_PARTY_FL   AS THIRD_PARTY_FL,               
A05317                SORT_ORDER       AS SORT_ORDER                    
                FROM #CSR04285_R1                                
A05317          ORDER BY SORT_ORDER,                                    
A05317                   NAME                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE      AS RETURN_CODE,                          
MFA-TR*               STATUS_CODE      AS STATUS_CODE,                          
MFA-TR*               NAME_TYPE        AS NAME_TYPE,                            
MFA-TR*               NAME             AS NAME,                                 
MFA-TR*               CONTACT_TYPE     AS CONTACT_TYPE,                         
MFA-TR*               CONTACT_SSN      AS CONTACT_SSN,                          
MFA-TR*               CONTACT_DOB      AS CONTACT_DOB,                          
MFA-TR*               CONTACT_DLN      AS CONTACT_DLN,                          
MFA-TR*               CONTACT_OTHER_ID AS CONTACT_OTHER_ID,                     
MFA-TR*               CONTACT_TAX_ID   AS CONTACT_TAX_ID,                       
MFA-TR*               CONTACT_OTHER_ID_TYPE AS CONTACT_OTHER_ID_TYPE,           
MFA-TR*               CONTACT_NICKNAME AS CONTACT_NICKNAME,                     
MFA-TR*               REFUSED_SSN      AS REFUSED_SSN,                          
MFA-TR*               NAME_COUNTER     AS NAME_COUNTER,                         
MFA-TR*               CONTACT_TYPE_CD  AS CONTACT_TYPE_CD,                      
MFA-TR*               PASSWORD         AS PASSWORD,                             
MFA-TR*               ID               AS ID,                                   
MFA-TR*               EMAIL_ADDRESS    AS EMAIL_ADDRESS,                        
MFA-TR*               NAME_FORMAT      AS NAME_FORMAT,                          
MFA-TR*               CONTACT_DLN_STATE AS CONTACT_DLN_STATE,                   
MFA-TR*               LAST_NAME        AS LAST_NAME,                            
MFA-TR*               FIRST_NAME       AS FIRST_NAME,                           
MFA-TR*               MIDDLE_NAME      AS MIDDLE_NAME,                          
MFA-TR*               NAME_SUFFIX      AS NAME_SUFFIX,                          
MFA-TR*               DOB_VERIFIED     AS DOB_VERIFIED,                         
MFA-TR*               DHR_FL           AS DHR_FL,                               
MFA-TR*               ACCESS_LEVEL_CD  AS ACCESS_LEVEL_CD,                      
MFA-TR*               VERIFY_SSN_FL    AS VERIFY_SSN_FL,                        
MFA-TR*               ALLOW_CALL_FL    AS ALLOW_CALL_FL,                        
MFA-TR*               MEMO_BILL_IND    AS MEMO_BILL_IND,                        
MFA-TR*               CONFIRM_REQ_FL   AS CONFIRM_REQ_FL,                       
MFA-TR*               EMAIL_CT         AS EMAIL_CT,                             
MFA-TR*               CONTACT_ITIN     AS CONTACT_ITIN,                         
MFA-TR*               ENTITY_IND       AS ENTITY_IND,                           
MFA-TR*               PASSWORD_HINT    AS PASSWORD_HINT,                        
MFA-TR*               ALLOW_EMAIL_FL   AS ALLOW_EMAIL_FL,                       
MFA-TR*               THIRD_PARTY_FL   AS THIRD_PARTY_FL,                       
MFA-TR*               SORT_ORDER       AS SORT_ORDER                            
MFA-TR*         FROM SESSION.CSR04285_R1                                        
MFA-TR*         ORDER BY SORT_ORDER,                                            
MFA-TR*                  NAME                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1    AS RETURN_CODE,               
                      :S-STATUS-CODE      AS STATUS_CODE,               
                      :S-NAME-TYPE        AS NAME_TYPE,                 
                      :S-NAME             AS NAME,                      
                      :S-CONTACT-TYPE     AS CONTACT_TYPE,              
                      :S-CONTACT-SSN      AS CONTACT_SSN,               
                      :S-CONTACT-DOB      AS CONTACT_DOB,               
                      :S-CONTACT-DLN      AS CONTACT_DLN,               
                      :S-CONTACT-OTHER-ID AS CONTACT_OTHER_ID,          
                      :S-CONTACT-TAX-ID   AS CONTACT_TAX_ID,            
                      :S-CONTACT-OTHER-ID-TYPE AS CONTACT_OTHER_ID_TYPE,
                      :S-CONTACT-NICKNAME AS CONTACT_NICKNAME,          
                      :S-REFUSED-SSN      AS REFUSED_SSN,               
                      :S-NAME-COUNTER     AS NAME_COUNTER,              
                      :S-CONTACT-TYPE-CD  AS CONTACT_TYPE_CD,           
                      :S-PASSWORD         AS PASSWORD,                  
                      :S-ID               AS ID,                        
                      :S-EMAIL-ADDRESS    AS EMAIL_ADDRESS,             
                      :S-NAME-FORMAT      AS NAME_FORMAT,               
                      :S-CONTACT-DLN-STATE AS CONTACT_DLN_STATE,        
A04671                :S-LAST-NAME        AS LAST_NAME,                 
A04671                :S-FIRST-NAME       AS FIRST_NAME,                
A04671                :S-MIDDLE-NAME      AS MIDDLE_NAME,               
A04671                :S-NAME-SUFFIX      AS NAME_SUFFIX,               
A04671                :S-DOB-VERIFIED     AS DOB_VERIFIED,              
A04671                :S-DHR-FL           AS DHR_FL,                    
P00740                :S-ACCESS-LEVEL-CD  AS ACCESS_LEVEL_CD,           
P00740                :S-VERIFY-SSN-FL    AS VERIFY_SSN_FL,             
P00740                :S-ALLOW-CALL-FL    AS ALLOW_CALL_FL,             
P00740                :S-MEMO-BILL-IND    AS MEMO_BILL_IND,             
P00740                :S-CONFIRM-FL       AS CONFIRM_REQ_FL,            
P00740                :S-EMAIL-CT         AS EMAIL_CT,                  
P00740                :S-CONTACT-ITIN     AS CONTACT_ITIN,              
P00740                :S-ENTITY-IND       AS ENTITY_IND,                
P00740                :S-PASSWORD-HINT    AS PASSWORD_HINT,             
P00740                :S-ALLOW-EMAIL-FL   AS ALLOW_EMAIL_FL,            
D09342                :S-3RD-PARTY-FL     AS THIRD_PARTY_FL,            
A05317                :S-SORT-ORDER       AS SORT_ORDER                 
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1    AS RETURN_CODE,                       
MFA-TR*               :S-STATUS-CODE      AS STATUS_CODE,                       
MFA-TR*               :S-NAME-TYPE        AS NAME_TYPE,                         
MFA-TR*               :S-NAME             AS NAME,                              
MFA-TR*               :S-CONTACT-TYPE     AS CONTACT_TYPE,                      
MFA-TR*               :S-CONTACT-SSN      AS CONTACT_SSN,                       
MFA-TR*               :S-CONTACT-DOB      AS CONTACT_DOB,                       
MFA-TR*               :S-CONTACT-DLN      AS CONTACT_DLN,                       
MFA-TR*               :S-CONTACT-OTHER-ID AS CONTACT_OTHER_ID,                  
MFA-TR*               :S-CONTACT-TAX-ID   AS CONTACT_TAX_ID,                    
MFA-TR*               :S-CONTACT-OTHER-ID-TYPE AS CONTACT_OTHER_ID_TYPE,        
MFA-TR*               :S-CONTACT-NICKNAME AS CONTACT_NICKNAME,                  
MFA-TR*               :S-REFUSED-SSN      AS REFUSED_SSN,                       
MFA-TR*               :S-NAME-COUNTER     AS NAME_COUNTER,                      
MFA-TR*               :S-CONTACT-TYPE-CD  AS CONTACT_TYPE_CD,                   
MFA-TR*               :S-PASSWORD         AS PASSWORD,                          
MFA-TR*               :S-ID               AS ID,                                
MFA-TR*               :S-EMAIL-ADDRESS    AS EMAIL_ADDRESS,                     
MFA-TR*               :S-NAME-FORMAT      AS NAME_FORMAT,                       
MFA-TR*               :S-CONTACT-DLN-STATE AS CONTACT_DLN_STATE,                
MFA-TR*               :S-LAST-NAME        AS LAST_NAME,                         
MFA-TR*               :S-FIRST-NAME       AS FIRST_NAME,                        
MFA-TR*               :S-MIDDLE-NAME      AS MIDDLE_NAME,                       
MFA-TR*               :S-NAME-SUFFIX      AS NAME_SUFFIX,                       
MFA-TR*               :S-DOB-VERIFIED     AS DOB_VERIFIED,                      
MFA-TR*               :S-DHR-FL           AS DHR_FL,                            
MFA-TR*               :S-ACCESS-LEVEL-CD  AS ACCESS_LEVEL_CD,                   
MFA-TR*               :S-VERIFY-SSN-FL    AS VERIFY_SSN_FL,                     
MFA-TR*               :S-ALLOW-CALL-FL    AS ALLOW_CALL_FL,                     
MFA-TR*               :S-MEMO-BILL-IND    AS MEMO_BILL_IND,                     
MFA-TR*               :S-CONFIRM-FL       AS CONFIRM_REQ_FL,                    
MFA-TR*               :S-EMAIL-CT         AS EMAIL_CT,                          
MFA-TR*               :S-CONTACT-ITIN     AS CONTACT_ITIN,                      
MFA-TR*               :S-ENTITY-IND       AS ENTITY_IND,                        
MFA-TR*               :S-PASSWORD-HINT    AS PASSWORD_HINT,                     
MFA-TR*               :S-ALLOW-EMAIL-FL   AS ALLOW_EMAIL_FL,                    
MFA-TR*               :S-3RD-PARTY-FL     AS THIRD_PARTY_FL,                    
MFA-TR*               :S-SORT-ORDER       AS SORT_ORDER                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING  FOR
               SELECT RETURN_CODE        AS RETURN_CODE,                
                      PHONE_NAME_TYPE    AS PHONE_NAME_TYPE,            
                      PHONE_NAME_COUNTER AS PHONE_NAME_COUNTER,         
                      PHONE_TYPE         AS PHONE_TYPE,                 
                      PHONE_NO           AS PHONE_NO,                   
                      PHONE_EXT          AS PHONE_EXT,                  
P00740                PHONE_MOBILE_FL    AS PHONE_MOBILE_FL,            
P00740                PHONE_MKT_FL       AS PHONE_MKT_FL,               
P00740                PHONE_MKT_DT       AS PHONE_MKT_DT                
                FROM #CSR04285_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING  FOR        
MFA-TR*        SELECT RETURN_CODE        AS RETURN_CODE,                        
MFA-TR*               PHONE_NAME_TYPE    AS PHONE_NAME_TYPE,                    
MFA-TR*               PHONE_NAME_COUNTER AS PHONE_NAME_COUNTER,                 
MFA-TR*               PHONE_TYPE         AS PHONE_TYPE,                         
MFA-TR*               PHONE_NO           AS PHONE_NO,                           
MFA-TR*               PHONE_EXT          AS PHONE_EXT,                          
MFA-TR*               PHONE_MOBILE_FL    AS PHONE_MOBILE_FL,                    
MFA-TR*               PHONE_MKT_FL       AS PHONE_MKT_FL,                       
MFA-TR*               PHONE_MKT_DT       AS PHONE_MKT_DT                        
MFA-TR*         FROM SESSION.CSR04285_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2      AS RETURN_CODE,             
                      :S-PHONE-NAME-TYPE    AS PHONE_NAME_TYPE,         
                      :S-PHONE-NAME-COUNTER AS PHONE_NAME_COUNTER,      
                      :S-PHONE-TYPE         AS PHONE_TYPE,              
                      :S-PHONE-NO           AS PHONE_NO,                
                      :S-PHONE-EXT          AS PHONE_EXT,               
P00740                :S-PHONE-MOBILE-FL    AS PHONE_MOBILE_FL,         
P00740                :S-PHONE-MKT-FL       AS PHONE_MKT_FL,            
P00740                :S-PHONE-MKT-DT       AS PHONE_MKT_DT             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2      AS RETURN_CODE,                     
MFA-TR*               :S-PHONE-NAME-TYPE    AS PHONE_NAME_TYPE,                 
MFA-TR*               :S-PHONE-NAME-COUNTER AS PHONE_NAME_COUNTER,              
MFA-TR*               :S-PHONE-TYPE         AS PHONE_TYPE,                      
MFA-TR*               :S-PHONE-NO           AS PHONE_NO,                        
MFA-TR*               :S-PHONE-EXT          AS PHONE_EXT,                       
MFA-TR*               :S-PHONE-MOBILE-FL    AS PHONE_MOBILE_FL,                 
MFA-TR*               :S-PHONE-MKT-FL       AS PHONE_MKT_FL,                    
MFA-TR*               :S-PHONE-MKT-DT       AS PHONE_MKT_DT                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO                               
                          LINK-CUSTOMER-NO                              
                          LINK-PREMISE-NO.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04285_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04285_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               NAME_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               CONTACT_TYPE CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CONTACT_SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,           
               CONTACT_DOB CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               CONTACT_DLN CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2,           
               CONTACT_OTHER_ID CHAR(16)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CONTACT_TAX_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CONTACT_OTHER_ID_TYPE CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                          
               CONTACT_NICKNAME CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               REFUSED_SSN CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2,            
               NAME_COUNTER         INT,                            
               CONTACT_TYPE_CD CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PASSWORD CHAR(16)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ID                   DECIMAL(10,0),                      
               EMAIL_ADDRESS CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2,        
               NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               CONTACT_DLN_STATE CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
A04671         LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,             
A04671         FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,            
A04671         MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,           
A04671         NAME_SUFFIX CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,           
A04671         DOB_VERIFIED CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
A04671         DHR_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                
P00740         ACCESS_LEVEL_CD CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00740         VERIFY_SSN_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
P00740         ALLOW_CALL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
P00740         MEMO_BILL_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
P00740         CONFIRM_REQ_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
P00740         EMAIL_CT             SMALLINT,                           
P00740         CONTACT_ITIN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,          
P00740         ENTITY_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
P00740         PASSWORD_HINT CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2,        
P00740         ALLOW_EMAIL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
D09342         THIRD_PARTY_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
A05317         SORT_ORDER CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04285_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04285_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04285_R2
              (                                                          
               RETURN_CODE          INT,                            
               PHONE_NAME_TYPE CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PHONE_NAME_COUNTER   INT,                            
               PHONE_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
               PHONE_EXT CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2,             
P00740         PHONE_MOBILE_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P00740         PHONE_MKT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
P00740         PHONE_MKT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT02-ROWS THRU 8002-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04285_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
                                                                        
P00740     MOVE 'DATABASE' TO C8-DELINQ-CD.                             
P00740     MOVE '01' TO C8-COMPANY-NO.                                  
P00740     PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
P00740     MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
P00740     PERFORM 7208-OPEN-TYPE-CURSOR THRU 7208-EXIT.                
P00740     SET T1-INDEX TO 1.                                           
P00740     PERFORM 1010-FETCH-ROWS THRU 1010-EXIT.                      
P00740     PERFORM 7209-CLOSE-TYPE-CURSOR THRU 7209-EXIT.               
                                                                        
           IF LINK-ACCOUNT-NO = ZEROES AND                              
              LINK-CUSTOMER-NO = ZEROES AND                             
              LINK-PREMISE-NO = ZEROES                                  
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                  MOVE 'ALL PARMS ZERO' TO S-NAME                       
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 1010-FETCH-ROWS.                                                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         FETCH CONTACT-TYPE-CURSOR                                
P00740          INTO :D8-CONTACT-TYPE,                                  
P00740               :D8-CONTACT-TYPE-DESC                              
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             GO TO 1010-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '1010'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_TYPE' TO TABLE-1                   
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     MOVE D8-CONTACT-TYPE TO T1-CONTACT-CD (T1-INDEX).            
P00740     MOVE D8-CONTACT-TYPE-DESC TO T1-CONTACT-DESC (T1-INDEX).     
P00740     SET T1-INDEX UP BY 1.                                        
P00740                                                                  
P00740     GO TO 1010-FETCH-ROWS.                                       
P00740                                                                  
P00740 1010-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-CUST-SPOUSE-INFO THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULTS-1 THRU 2200-EXIT.                 
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE +100 TO S-RETURN-CODE-1                              
              MOVE 'NO DATA' TO S-NAME                                  
              PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                 
              PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                 
              PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                 
              PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-CUST-SPOUSE-INFO.                                           
                                                                        
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
                                                                        
           MOVE '00' TO AT-COMPANY-NO.                                  
           IF AT-ACCOUNT-NO > 0                                         
               MOVE 'N' TO WS-ARCHIVED-ACCOUNT                          
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT               
P00740         MOVE 'CASA-CONTACT-CONFIRM' TO C8-DELINQ-CD              
P00740         MOVE AT-COMPANY-NO TO C8-COMPANY-NO                      
P00740         PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT       
P00740         MOVE C8-DELINQ-VALUE TO WS-CASA-CONFIRM
           END-IF.                 
           IF CU-CUSTOMER-NO > 0                                        
               PERFORM 7025-SELECT-NAME THRU 7025-EXIT                  
               IF AT-COMPANY-NO = '00'                                  
P00740             MOVE 'CASA-CONTACT-CONFIRM' TO C8-DELINQ-CD          
P00740             MOVE CU-COMPANY-NO-ORIG TO C8-COMPANY-NO             
P00740             PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT   
P00740             MOVE C8-DELINQ-VALUE TO WS-CASA-CONFIRM              
               END-IF                                                   
               PERFORM 7030-SELECT-STATS THRU 7030-EXIT                 
               MOVE CU-CUSTOMER-NO TO BS-CUSTOMER-NO                    
               PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT             
               MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                    
P00740         MOVE 'C' TO CB-CUSTOMER-TYPE                             
P00740         INITIALIZE WS-PHONE-FIELDS                               
               PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT            
               PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT           
               PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT           
P00740         MOVE CU-CUSTOMER-NO TO NE-CUSTOMER-NO                    
P00740         MOVE 'P%' TO WS-EMAIL-TYPE-CD                            
P00740         PERFORM 7200-OPEN-CUST-EML-CURSOR THRU 7200-EXIT         
P00740         PERFORM 2420-FETCH-ROWS THRU 2420-EXIT                   
P00740         PERFORM 7201-CLOSE-CUST-EML-CURSOR THRU 7201-EXIT
           END-IF.       
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
P00740     IF WS-CUST-NAME > ' '                                        
P00740         MOVE 'CU' TO S-NAME-TYPE                                 
P00740                      S-CONTACT-TYPE-CD                           
A05317         MOVE 'A' TO S-SORT-ORDER                                 
P00740         MOVE WS-CUST-NAME TO S-NAME                              
P00740         MOVE 'CUSTOMER' TO S-CONTACT-TYPE                        
P00740         MOVE CE-SSN TO S-CONTACT-SSN                             
P00740         MOVE CE-ITIN-ID TO S-CONTACT-ITIN                        
P00740         MOVE CE-DATE-OF-BIRTH TO S-CONTACT-DOB                   
P00740         MOVE CE-DOB-VERIFIED-CD TO S-DOB-VERIFIED                
P00740         MOVE CE-DRIVERS-LICENSE-NO TO S-CONTACT-DLN              
P00740         MOVE CE-CODE-STATE-ID TO S-CONTACT-DLN-STATE             
P00740         MOVE CE-OTHER-ID TO S-CONTACT-OTHER-ID                   
P00740         MOVE CE-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE         
P00740         MOVE BS-TAX-ID TO S-CONTACT-TAX-ID                       
P00740         MOVE DQ-NICKNAME TO S-CONTACT-NICKNAME                   
P00740         MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN                  
P00740         MOVE CE-PASSWORD-TX TO S-PASSWORD                        
P00740         MOVE CE-PASSWORD-HINT TO S-PASSWORD-HINT                 
P00740         MOVE CE-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD             
P00740         MOVE CE-ALLOW-CALL-FL TO S-ALLOW-CALL-FL                 
P00740         MOVE CE-ALLOW-EMAIL-FL TO S-ALLOW-EMAIL-FL               
P00740         MOVE CE-VERIFY-SSN-FL TO S-VERIFY-SSN-FL                 
P00740         MOVE CU-CUSTOMER-NO TO S-ID                              
P00740         MOVE WS-CUST-EMAIL TO S-EMAIL-ADDRESS                    
P00740         MOVE WS-CUST-EMAIL-CT TO S-EMAIL-CT                      
P00740         MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT                     
P00740         MOVE DQ-LAST-NAME TO S-LAST-NAME                         
P00740         MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME                     
P00740         MOVE DQ-FIRST-NAME TO S-FIRST-NAME                       
P00740         MOVE DQ-TITLE-SUFFIX-1 TO S-NAME-SUFFIX                  
P00740         IF CASA-CONFIRM-YES                                      
P00740             MOVE 'Y' TO S-CONFIRM-FL                             
P00740         ELSE                                                     
P00740             MOVE 'N' TO S-CONFIRM-FL                             
P00740         END-IF                                                   
P00740         MOVE '00' TO S-ACCESS-LEVEL-CD                           
P00740         MOVE CU-DHR-FL TO S-DHR-FL                               
P00740         PERFORM 2500-MOVE-ITIN THRU 2500-EXIT                    
               MOVE 1 TO S-NAME-COUNTER                                 
               IF DQ-NAME-FORMAT = 'I'                                  
                   MOVE SPACES TO WS-BUSINESS-PHONE                     
               END-IF                                                   
               PERFORM 4100-PHONE-PROCESSING THRU 4100-EXIT             
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF CU-CUSTOMER-NO > 0                                        
               PERFORM 7060-SELECT-SPOUSE-STATS THRU 7060-EXIT          
P00740         MOVE 'S' TO CB-CUSTOMER-TYPE                             
P00740         MOVE CU-CUSTOMER-NO TO CB-CUSTOMER-NO                    
P00740         PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT            
P00740         PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT           
P00740         PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT           
P00740         MOVE 'S%' TO WS-EMAIL-TYPE-CD                            
P00740         PERFORM 7200-OPEN-CUST-EML-CURSOR THRU 7200-EXIT         
P00740         PERFORM 2420-FETCH-ROWS THRU 2420-EXIT                   
P00740         PERFORM 7201-CLOSE-CUST-EML-CURSOR THRU 7201-EXIT
           END-IF.       
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
P00740     IF DQ-FULL-NAME > ' '                                        
P00740         MOVE 'SP' TO S-NAME-TYPE                                 
P00740                      S-CONTACT-TYPE-CD                           
A05317         MOVE 'B' TO S-SORT-ORDER                                 
P00740         MOVE DQ-FULL-NAME TO S-NAME                              
P00740         MOVE 'SPOUSE' TO S-CONTACT-TYPE                          
P00740         MOVE CE-SSN TO S-CONTACT-SSN                             
P00740         MOVE CE-ITIN-ID TO S-CONTACT-ITIN                        
P00740         MOVE CE-DATE-OF-BIRTH TO S-CONTACT-DOB                   
P00740         MOVE CE-DRIVERS-LICENSE-NO TO S-CONTACT-DLN              
P00740         MOVE CE-CODE-STATE-ID TO S-CONTACT-DLN-STATE             
P00740         MOVE CE-OTHER-ID TO S-CONTACT-OTHER-ID                   
P00740         MOVE CE-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE         
P00740         MOVE DQ-NICKNAME TO S-CONTACT-NICKNAME                   
P00740         MOVE CE-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD             
P00740         MOVE CE-ALLOW-CALL-FL TO S-ALLOW-CALL-FL                 
P00740         MOVE CE-ALLOW-EMAIL-FL TO S-ALLOW-EMAIL-FL               
P00740         MOVE WS-CUST-EMAIL TO S-EMAIL-ADDRESS                    
P00740         MOVE WS-CUST-EMAIL-CT TO S-EMAIL-CT                      
P00740         MOVE 'C' TO S-ENTITY-IND                                 
P00740         IF CASA-CONFIRM-YES                                      
P00740             MOVE 'Y' TO S-CONFIRM-FL                             
P00740         ELSE                                                     
P00740             MOVE 'N' TO S-CONFIRM-FL                             
P00740         END-IF                                                   
P00740         PERFORM 2500-MOVE-ITIN THRU 2500-EXIT                    
P00740         MOVE CU-CUSTOMER-NO TO S-ID                              
P00740         MOVE 'I' TO S-NAME-FORMAT                                
P00740         MOVE 1 TO S-NAME-COUNTER                                 
P00740         PERFORM 4100-PHONE-PROCESSING THRU 4100-EXIT             
P00740         IF WS-GTT01-DECLARED = 'N'                               
P00740             PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
P00740         END-IF                                                   
P00740         PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-BUILD-RESULTS-1.                                            
                                                                        
           IF AT-ACCOUNT-NO > 0                                         
               IF WS-ARCHIVED-ACCOUNT = 'N'                             
                   PERFORM 7150-OPEN-COAPP-CURSOR THRU 7150-EXIT        
                   PERFORM 2230-FETCH-ROWS THRU 2230-EXIT               
                   PERFORM 7151-CLOSE-COAPP-CURSOR THRU 7151-EXIT       
                                                                        
                   PERFORM 7140-OPEN-ROOMMATE-CURSOR THRU 7140-EXIT     
                   PERFORM 2210-FETCH-ROWS THRU 2210-EXIT               
                   PERFORM 7141-CLOSE-ROOMMATE-CURSOR THRU 7141-EXIT    
               ELSE                                                     
                   PERFORM 7152-OPEN-COAPP-CURSOR-H THRU 7152-EXIT      
                   PERFORM 2240-FETCH-ROWS THRU 2240-EXIT               
                   PERFORM 7153-CLOSE-COAPP-CURSOR-H THRU 7153-EXIT     
                                                                        
                   PERFORM 7142-OPEN-ROOMMATE-CURSOR-H THRU 7142-EXIT   
                   PERFORM 2220-FETCH-ROWS THRU 2220-EXIT               
                   PERFORM 7143-CLOSE-ROOMMATE-CURSOR-H THRU 7143-EXIT  
               END-IF                                                   
                                                                        
               PERFORM 7160-OPEN-THIRD-PARTY-CURSOR THRU 7160-EXIT      
               PERFORM 2250-FETCH-ROWS THRU 2250-EXIT                   
               PERFORM 7161-CLOSE-THIRD-PARTY-CURSOR THRU 7161-EXIT     
                                                                        
P00740         PERFORM 7196-OPEN-INTERNAL-CURSOR THRU 7196-EXIT         
P00740         PERFORM 2410-FETCH-ROWS THRU 2410-EXIT                   
P00740         PERFORM 7197-CLOSE-INTERNAL-CURSOR THRU 7197-EXIT        
P00740                                                                  
P00740         PERFORM 7194-OPEN-OUTAGE-CURSOR THRU 7194-EXIT           
P00740         PERFORM 2400-FETCH-ROWS THRU 2400-EXIT                   
P00740         PERFORM 7195-CLOSE-OUTAGE-CURSOR THRU 7195-EXIT          
                                                                        
               PERFORM 7170-OPEN-ACCT-CONTACT-CURSOR THRU 7170-EXIT     
               PERFORM 2270-FETCH-ROWS THRU 2270-EXIT                   
               PERFORM 7171-CLOSE-ACCT-CONTACT-CURSOR THRU 7171-EXIT
           END-IF.   
                                                                        
           IF CU-CUSTOMER-NO > 0                                        
P00740         IF AT-ACCOUNT-NO = 0                                     
P00740             PERFORM 7196-OPEN-INTERNAL-CURSOR THRU 7196-EXIT     
P00740             PERFORM 2410-FETCH-ROWS THRU 2410-EXIT               
P00740             PERFORM 7197-CLOSE-INTERNAL-CURSOR THRU 7197-EXIT    
P00740         END-IF                                                   
P00740                                                                  
P00740         PERFORM 7206-OPEN-XFER-CURSOR THRU 7206-EXIT             
P00740         PERFORM 2450-FETCH-ROWS THRU 2450-EXIT                   
P00740         PERFORM 7207-CLOSE-XFER-CURSOR THRU 7207-EXIT            
P00740                                                                  
               PERFORM 7180-OPEN-CUST-CONTACT-CURSOR THRU 7180-EXIT     
               PERFORM 2280-FETCH-ROWS THRU 2280-EXIT                   
               PERFORM 7181-CLOSE-CUST-CONTACT-CURSOR THRU 7181-EXIT
           END-IF.   
                                                                        
           IF PR-PREMISE-NO > 0                                         
               PERFORM 7190-OPEN-PREM-CONTACT-CURSOR THRU 7190-EXIT     
               PERFORM 2290-FETCH-ROWS THRU 2290-EXIT                   
               PERFORM 7191-CLOSE-PREM-CONTACT-CURSOR THRU 7191-EXIT
           END-IF.   
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ROOMMATE-CURSOR                                    
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :RO-CUSTOMER-NO,                                   
P00740               :RO-ACCESS-LEVEL-CD,                               
P00740               :CU-VALIDATION-TS :WS-NULL-7                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CU-VALIDATION-TS                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2210-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ROOMMATE'   TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE RO-CUSTOMER-NO TO BS-CUSTOMER-NO.                       
           PERFORM 7035-SELECT-RC-STATS THRU 7035-EXIT.                 
           PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
           MOVE 'RO' TO S-NAME-TYPE                                     
                        S-CONTACT-TYPE-CD.                              
A05317     MOVE 'D' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE WS-NAME TO S-NAME                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
           MOVE 'ROOMMATE' TO S-CONTACT-TYPE.                           
           MOVE CE-SSN TO S-CONTACT-SSN.                                
P00740     MOVE CE-ITIN-ID TO S-CONTACT-ITIN.                           
           MOVE CE-DRIVERS-LICENSE-NO TO S-CONTACT-DLN.                 
           MOVE CE-CODE-STATE-ID TO S-CONTACT-DLN-STATE.                
           MOVE CE-DATE-OF-BIRTH TO S-CONTACT-DOB.                      
           MOVE CE-OTHER-ID TO S-CONTACT-OTHER-ID.                      
           MOVE CE-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE.            
           MOVE BS-TAX-ID TO S-CONTACT-TAX-ID.                          
           MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN.                     
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
P00740     PERFORM 2500-MOVE-ITIN THRU 2500-EXIT.                       
           ADD 1 TO WS-RO-COUNTER.                                      
           MOVE WS-RO-COUNTER TO S-NAME-COUNTER.                        
           MOVE RO-CUSTOMER-NO TO CB-CUSTOMER-NO                        
                                  S-ID.                                 
P00740     MOVE RO-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD.                
P00740     IF CASA-CONFIRM-YES                                          
P00740         MOVE 'Y' TO S-CONFIRM-FL                                 
P00740     ELSE                                                         
P00740         MOVE 'N' TO S-CONFIRM-FL
           END-IF.                                
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
P00740     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
P00740     INITIALIZE WS-PHONE-FIELDS.                                  
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
           PERFORM 4100-PHONE-PROCESSING THRU 4100-EXIT.                
P00740     MOVE RO-CUSTOMER-NO TO NE-CUSTOMER-NO.                       
P00740     MOVE 'P%' TO WS-EMAIL-TYPE-CD.                               
P00740     PERFORM 7200-OPEN-CUST-EML-CURSOR THRU 7200-EXIT.            
P00740     PERFORM 2420-FETCH-ROWS THRU 2420-EXIT.                      
P00740     PERFORM 7201-CLOSE-CUST-EML-CURSOR THRU 7201-EXIT.           
P00740     MOVE WS-CUST-EMAIL TO S-EMAIL-ADDRESS.                       
P00740     MOVE WS-CUST-EMAIL-CT TO S-EMAIL-CT.                         
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           GO TO 2210-FETCH-ROWS.                                       
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2220-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH ROOMMATE-CURSOR-H                                  
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :RO-CUSTOMER-NO,                                   
P00740               :CU-VALIDATION-TS :WS-NULL-7                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CU-VALIDATION-TS                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2220-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2220'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ROOMMATE'   TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE RO-CUSTOMER-NO TO BS-CUSTOMER-NO.                       
           PERFORM 7035-SELECT-RC-STATS THRU 7035-EXIT.                 
           PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
           MOVE 'RO' TO S-NAME-TYPE                                     
                        S-CONTACT-TYPE-CD.                              
A05317     MOVE 'D' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE WS-NAME TO S-NAME                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
           MOVE 'ROOMMATE' TO S-CONTACT-TYPE.                           
           MOVE CE-SSN TO S-CONTACT-SSN.                                
P00740     MOVE CE-ITIN-ID TO S-CONTACT-ITIN.                           
           MOVE CE-DRIVERS-LICENSE-NO TO S-CONTACT-DLN.                 
           MOVE CE-CODE-STATE-ID TO S-CONTACT-DLN-STATE.                
           MOVE CE-DATE-OF-BIRTH TO S-CONTACT-DOB.                      
           MOVE CE-OTHER-ID TO S-CONTACT-OTHER-ID.                      
           MOVE CE-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE.            
           MOVE BS-TAX-ID TO S-CONTACT-TAX-ID.                          
           MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN.                     
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
P00740     PERFORM 2500-MOVE-ITIN THRU 2500-EXIT.                       
           ADD 1 TO WS-RO-COUNTER.                                      
           MOVE WS-RO-COUNTER TO S-NAME-COUNTER.                        
           MOVE RO-CUSTOMER-NO TO CB-CUSTOMER-NO                        
                                  S-ID.                                 
P00740     IF CASA-CONFIRM-YES                                          
P00740         MOVE 'Y' TO S-CONFIRM-FL                                 
P00740     ELSE                                                         
P00740         MOVE 'N' TO S-CONFIRM-FL
           END-IF.                                
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
P00740     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
P00740     INITIALIZE WS-PHONE-FIELDS.                                  
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
           PERFORM 4100-PHONE-PROCESSING THRU 4100-EXIT.                
P00740     MOVE RO-CUSTOMER-NO TO NE-CUSTOMER-NO.                       
P00740     MOVE 'P%' TO WS-EMAIL-TYPE-CD.                               
P00740     PERFORM 7200-OPEN-CUST-EML-CURSOR THRU 7200-EXIT.            
P00740     PERFORM 2420-FETCH-ROWS THRU 2420-EXIT.                      
P00740     PERFORM 7201-CLOSE-CUST-EML-CURSOR THRU 7201-EXIT.           
P00740     MOVE WS-CUST-EMAIL TO S-EMAIL-ADDRESS.                       
P00740     MOVE WS-CUST-EMAIL-CT TO S-EMAIL-CT.                         
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           GO TO 2220-FETCH-ROWS.                                       
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2230-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH COAPP-CURSOR                                       
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :IC-CUSTOMER-NO,                                   
P00740               :IC-ACCESS-LEVEL-CD,                               
P00740               :CU-VALIDATION-TS :WS-NULL-7                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CU-VALIDATION-TS                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2230-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2230'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COAPPLICANT'  TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE IC-CUSTOMER-NO TO BS-CUSTOMER-NO                        
                                  RO-CUSTOMER-NO.                       
           PERFORM 7035-SELECT-RC-STATS THRU 7035-EXIT.                 
           PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
           MOVE 'CO' TO S-NAME-TYPE                                     
                        S-CONTACT-TYPE-CD.                              
A05317     MOVE 'C' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE WS-NAME TO S-NAME                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
           MOVE 'COAPPLICANT' TO S-CONTACT-TYPE.                        
           MOVE CE-SSN TO S-CONTACT-SSN.                                
P00740     MOVE CE-ITIN-ID TO S-CONTACT-ITIN.                           
           MOVE CE-DRIVERS-LICENSE-NO TO S-CONTACT-DLN.                 
           MOVE CE-CODE-STATE-ID TO S-CONTACT-DLN-STATE.                
           MOVE CE-DATE-OF-BIRTH TO S-CONTACT-DOB.                      
           MOVE CE-OTHER-ID TO S-CONTACT-OTHER-ID.                      
           MOVE CE-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE.            
           MOVE BS-TAX-ID TO S-CONTACT-TAX-ID.                          
           MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN.                     
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
P00740     PERFORM 2500-MOVE-ITIN THRU 2500-EXIT.                       
           ADD 1 TO WS-CO-COUNTER.                                      
           MOVE WS-CO-COUNTER TO S-NAME-COUNTER.                        
           MOVE RO-CUSTOMER-NO TO CB-CUSTOMER-NO                        
                                  S-ID.                                 
P00740     MOVE IC-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD.                
P00740     IF CASA-CONFIRM-YES                                          
P00740         MOVE 'Y' TO S-CONFIRM-FL                                 
P00740     ELSE                                                         
P00740         MOVE 'N' TO S-CONFIRM-FL
           END-IF.                                
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
P00740     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
P00740     INITIALIZE WS-PHONE-FIELDS.                                  
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
           PERFORM 4100-PHONE-PROCESSING THRU 4100-EXIT.                
P00740     MOVE RO-CUSTOMER-NO TO NE-CUSTOMER-NO.                       
P00740     MOVE 'P%' TO WS-EMAIL-TYPE-CD.                               
P00740     PERFORM 7200-OPEN-CUST-EML-CURSOR THRU 7200-EXIT.            
P00740     PERFORM 2420-FETCH-ROWS THRU 2420-EXIT.                      
P00740     PERFORM 7201-CLOSE-CUST-EML-CURSOR THRU 7201-EXIT.           
P00740     MOVE WS-CUST-EMAIL TO S-EMAIL-ADDRESS.                       
P00740     MOVE WS-CUST-EMAIL-CT TO S-EMAIL-CT.                         
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           GO TO 2230-FETCH-ROWS.                                       
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2240-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH COAPP-CURSOR-H                                     
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :IC-CUSTOMER-NO,                                   
P00740               :CU-VALIDATION-TS :WS-NULL-7                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CU-VALIDATION-TS                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2240-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2240'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_COAPPLICANT'  TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE IC-CUSTOMER-NO TO BS-CUSTOMER-NO                        
                                  RO-CUSTOMER-NO.                       
           PERFORM 7035-SELECT-RC-STATS THRU 7035-EXIT.                 
           PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
           MOVE 'CO' TO S-NAME-TYPE                                     
                        S-CONTACT-TYPE-CD.                              
A05317     MOVE 'C' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE WS-NAME TO S-NAME                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
           MOVE 'COAPPLICANT' TO S-CONTACT-TYPE.                        
           MOVE CE-SSN TO S-CONTACT-SSN.                                
P00740     MOVE CE-ITIN-ID TO S-CONTACT-ITIN.                           
           MOVE CE-DRIVERS-LICENSE-NO TO S-CONTACT-DLN.                 
           MOVE CE-CODE-STATE-ID TO S-CONTACT-DLN-STATE.                
           MOVE CE-DATE-OF-BIRTH TO S-CONTACT-DOB.                      
           MOVE CE-OTHER-ID TO S-CONTACT-OTHER-ID.                      
           MOVE CE-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE.            
           MOVE BS-TAX-ID TO S-CONTACT-TAX-ID.                          
           MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN.                     
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
P00740     PERFORM 2500-MOVE-ITIN THRU 2500-EXIT.                       
           ADD 1 TO WS-CO-COUNTER.                                      
           MOVE WS-CO-COUNTER TO S-NAME-COUNTER.                        
           MOVE RO-CUSTOMER-NO TO CB-CUSTOMER-NO                        
                                  S-ID.                                 
P00740     IF CASA-CONFIRM-YES                                          
P00740         MOVE 'Y' TO S-CONFIRM-FL                                 
P00740     ELSE                                                         
P00740         MOVE 'N' TO S-CONFIRM-FL
           END-IF.                                
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
P00740     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
P00740     INITIALIZE WS-PHONE-FIELDS.                                  
           PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
           PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
           PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
           PERFORM 4100-PHONE-PROCESSING THRU 4100-EXIT.                
P00740     MOVE RO-CUSTOMER-NO TO NE-CUSTOMER-NO.                       
P00740     MOVE 'P%' TO WS-EMAIL-TYPE-CD.                               
P00740     PERFORM 7200-OPEN-CUST-EML-CURSOR THRU 7200-EXIT.            
P00740     PERFORM 2420-FETCH-ROWS THRU 2420-EXIT.                      
P00740     PERFORM 7201-CLOSE-CUST-EML-CURSOR THRU 7201-EXIT.           
P00740     MOVE WS-CUST-EMAIL TO S-EMAIL-ADDRESS.                       
P00740     MOVE WS-CUST-EMAIL-CT TO S-EMAIL-CT.                         
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           GO TO 2240-FETCH-ROWS.                                       
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2250-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH THIRD-PARTY-CURSOR                                 
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :ZW-THD-PRTY-ID,                                   
P00740               :ZW-ACCESS-LEVEL-CD,                               
P00740               :ZW-VALIDATION-TS :WS-NULL-7,                       
P00740               :ZW-DATE-OF-BIRTH :WS-NULL-6,                       
D09342               :ZW-THD-PRTY-STATUS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO ZW-VALIDATION-TS                  
P00740             END-IF                                               
P00740             IF WS-NULL-6 < 0                                     
P00740                 MOVE SPACES TO ZW-DATE-OF-BIRTH                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2250-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2250'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THIRD_PARTY'  TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'TP' TO S-NAME-TYPE                                     
                        S-CONTACT-TYPE-CD.                              
A05317     MOVE 'E' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE WS-NAME TO S-NAME                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
           MOVE 'THIRD PARTY' TO S-CONTACT-TYPE.                        
           MOVE ZW-THD-PRTY-ID TO ZY-THD-PRTY-ID                        
                                  S-ID.                                 
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
P00740     MOVE ZW-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD.                
P00740     IF CASA-CONFIRM-YES                                          
P00740         MOVE 'Y' TO S-CONFIRM-FL                                 
P00740     ELSE                                                         
P00740         MOVE 'N' TO S-CONFIRM-FL
           END-IF.                                
P00740     MOVE ZW-DATE-OF-BIRTH TO S-CONTACT-DOB.                      
D09342     MOVE ZW-THD-PRTY-STATUS TO S-3RD-PARTY-FL.                   
           ADD 1 TO WS-TP-COUNTER.                                      
           MOVE WS-TP-COUNTER TO S-NAME-COUNTER.                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE S-NAME-TYPE TO S-PHONE-NAME-TYPE.                       
           MOVE S-NAME-COUNTER TO S-PHONE-NAME-COUNTER.                 
           PERFORM 7162-OPEN-THIRD-PHONE-CURSOR THRU 7162-EXIT.         
           PERFORM 2260-FETCH-ROWS THRU 2260-EXIT.                      
           PERFORM 7163-CLOSE-THIRD-PHONE-CURSOR THRU 7163-EXIT.        
P00740     PERFORM 7202-OPEN-THIRD-EML-CURSOR THRU 7202-EXIT.           
P00740     PERFORM 2430-FETCH-ROWS THRU 2430-EXIT.                      
P00740     PERFORM 7203-CLOSE-THIRD-EML-CURSOR THRU 7203-EXIT.          
P00740     MOVE WS-3RD-EMAIL TO S-EMAIL-ADDRESS.                        
P00740     MOVE WS-3RD-EMAIL-CT TO S-EMAIL-CT.                          
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           GO TO 2250-FETCH-ROWS.                                       
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2260-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH THIRD-PHONE-CURSOR                                 
                INTO :ZY-PHONE-TYPE,                                    
                     :ZY-PHONE-NO,                                      
                     :ZY-EXTENSION-NO,                                  
P00740               :ZY-MOBILE-PHONE-FL,                               
P00740               :ZY-PERMISN-TO-MKT-DT :WS-NULL-5,                   
P00740               :ZY-PERMISN-TO-MKT-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-5 < 0                                     
P00740                 MOVE SPACES TO ZY-PERMISN-TO-MKT-DT              
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2260-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2631'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE ZY-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE ZY-PHONE-TYPE TO S-PHONE-TYPE.                          
           MOVE ZY-PHONE-NO TO S-PHONE-NO.                              
           MOVE ZY-EXTENSION-NO TO S-PHONE-EXT.                         
P00740     MOVE ZY-MOBILE-PHONE-FL TO S-PHONE-MOBILE-FL.                
P00740     MOVE ZY-PERMISN-TO-MKT-FL TO S-PHONE-MKT-FL.                 
P00740     MOVE ZY-PERMISN-TO-MKT-DT TO S-PHONE-MKT-DT.                 
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2260-FETCH-ROWS.                                       
                                                                        
       2260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2270-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO CV-CONTACT-POSITION.                          
           EXEC SQL                                                     
               FETCH ACCT-CONTACT-CURSOR                                
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :CV-CONTACT-TYPE,                                  
                     :DQ-NICKNAME,                                      
                     :CV-CONTACT-POSITION,                              
                     :CV-CONTACT-ID,                                    
P00740               :CV-ACCESS-LEVEL-CD,                               
P00740               :CV-VALIDATION-TS :WS-NULL-7,                       
P00740               :CV-MEMO-BILL-IND                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CV-VALIDATION-TS                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2270-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2270'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'AC' TO S-NAME-TYPE.                                    
A05317     MOVE 'H' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               IF WS-NAME <= ' ' OR                                     
                  WS-NAME = ','                                         
                      MOVE DQ-FULL-NAME TO S-NAME                       
               ELSE                                                     
                   MOVE WS-NAME TO S-NAME                               
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
                                                                        
           PERFORM 2310-FORMAT-CONTACT THRU 2310-EXIT.                  
                                                                        
           ADD 1 TO WS-AC-COUNTER.                                      
           MOVE WS-AC-COUNTER TO S-NAME-COUNTER.                        
                                                                        
P00740     MOVE SPACES TO WS-CONTACT-EMAIL.                             
P00740     MOVE ZEROES TO WS-CONTACT-EMAIL-CT.                          
P00740     PERFORM 7204-OPEN-CONTACT-EML-CURSOR THRU 7204-EXIT.         
P00740     PERFORM 2440-FETCH-ROWS THRU 2440-EXIT.                      
P00740     PERFORM 7205-CLOSE-CONTACT-EML-CURSOR THRU 7205-EXIT.        
P00740     MOVE WS-CONTACT-EMAIL TO S-EMAIL-ADDRESS.                    
P00740     MOVE WS-CONTACT-EMAIL-CT TO S-EMAIL-CT.                      
                                                                        
           PERFORM 2320-CONTACT-PHONE THRU 2320-EXIT.                   
                                                                        
           GO TO 2270-FETCH-ROWS.                                       
                                                                        
       2270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2280-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO CV-CONTACT-POSITION.                          
           EXEC SQL                                                     
               FETCH CUST-CONTACT-CURSOR                                
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :CV-CONTACT-TYPE,                                  
                     :DQ-NICKNAME,                                      
                     :CV-CONTACT-POSITION,                              
                     :CV-CONTACT-ID,                                    
P00740               :CV-ACCESS-LEVEL-CD,                               
P00740               :CV-VALIDATION-TS :WS-NULL-7,                       
P00740               :CV-MEMO-BILL-IND                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CV-VALIDATION-TS                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2280-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2280'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'CC' TO S-NAME-TYPE.                                    
A05317     MOVE 'H' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               IF WS-NAME <= ' ' OR                                     
                  WS-NAME = ','                                         
                      MOVE DQ-FULL-NAME TO S-NAME                       
               ELSE                                                     
                   MOVE WS-NAME TO S-NAME                               
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
P00740     MOVE 'C' TO S-ENTITY-IND.                                    
                                                                        
           PERFORM 2310-FORMAT-CONTACT THRU 2310-EXIT.                  
                                                                        
           ADD 1 TO WS-CC-COUNTER.                                      
           MOVE WS-CC-COUNTER TO S-NAME-COUNTER.                        
                                                                        
P00740     MOVE SPACES TO WS-CONTACT-EMAIL.                             
P00740     MOVE ZEROES TO WS-CONTACT-EMAIL-CT.                          
P00740     PERFORM 7204-OPEN-CONTACT-EML-CURSOR THRU 7204-EXIT.         
P00740     PERFORM 2440-FETCH-ROWS THRU 2440-EXIT.                      
P00740     PERFORM 7205-CLOSE-CONTACT-EML-CURSOR THRU 7205-EXIT.        
P00740     MOVE WS-CONTACT-EMAIL TO S-EMAIL-ADDRESS.                    
P00740     MOVE WS-CONTACT-EMAIL-CT TO S-EMAIL-CT.                      
                                                                        
           PERFORM 2320-CONTACT-PHONE THRU 2320-EXIT.                   
                                                                        
           GO TO 2280-FETCH-ROWS.                                       
                                                                        
       2280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2290-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO CV-CONTACT-POSITION.                          
           EXEC SQL                                                     
               FETCH PREM-CONTACT-CURSOR                                
                INTO :WS-NAME,                                          
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :CV-CONTACT-TYPE,                                  
                     :DQ-NICKNAME,                                      
                     :CV-CONTACT-POSITION,                              
                     :CV-CONTACT-ID,                                    
P00740               :CV-ACCESS-LEVEL-CD,                               
P00740               :CV-VALIDATION-TS :WS-NULL-7,                       
P00740               :CV-MEMO-BILL-IND                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CV-VALIDATION-TS                  
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2290-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2290'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PREM' TO TABLE-1                   
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
           MOVE 'PC' TO S-NAME-TYPE.                                    
A05317     MOVE 'H' TO S-SORT-ORDER.                                    
           IF DQ-NAME-FORMAT = 'I'                                      
               IF WS-NAME <= ' ' OR                                     
                  WS-NAME = ','                                         
                      MOVE DQ-FULL-NAME TO S-NAME                       
               ELSE                                                     
                   MOVE WS-NAME TO S-NAME                               
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
P00740     MOVE 'P' TO S-ENTITY-IND.                                    
                                                                        
           PERFORM 2310-FORMAT-CONTACT THRU 2310-EXIT.                  
                                                                        
           ADD 1 TO WS-PC-COUNTER.                                      
           MOVE WS-PC-COUNTER TO S-NAME-COUNTER.                        
                                                                        
P00740     MOVE SPACES TO WS-CONTACT-EMAIL.                             
P00740     MOVE ZEROES TO WS-CONTACT-EMAIL-CT.                          
P00740     PERFORM 7204-OPEN-CONTACT-EML-CURSOR THRU 7204-EXIT.         
P00740     PERFORM 2440-FETCH-ROWS THRU 2440-EXIT.                      
P00740     PERFORM 7205-CLOSE-CONTACT-EML-CURSOR THRU 7205-EXIT.        
P00740     MOVE WS-CONTACT-EMAIL TO S-EMAIL-ADDRESS.                    
P00740     MOVE WS-CONTACT-EMAIL-CT TO S-EMAIL-CT.                      
                                                                        
           PERFORM 2320-CONTACT-PHONE THRU 2320-EXIT.                   
                                                                        
           GO TO 2290-FETCH-ROWS.                                       
                                                                        
       2290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CONTACT-PHONE-CURSOR                               
                INTO :LP-PHONE-TYPE,                                    
                     :LP-PHONE-NO,                                      
                     :LP-EXTENSION-NO,                                  
P00740               :LP-MOBILE-PHONE-FL,                               
P00740               :LP-PERMISN-TO-MKT-DT :WS-NULL-5,                   
P00740               :LP-PERMISN-TO-MKT-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-5 < 0                                     
P00740                 MOVE SPACES TO LP-PERMISN-TO-MKT-FL              
P00740             END-IF                                               
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2300-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '2300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PHONE' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE LP-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE LP-PHONE-TYPE TO S-PHONE-TYPE.                          
           MOVE LP-PHONE-NO TO S-PHONE-NO.                              
           MOVE LP-EXTENSION-NO TO S-PHONE-EXT.                         
P00740     MOVE LP-MOBILE-PHONE-FL TO S-PHONE-MOBILE-FL.                
P00740     MOVE LP-PERMISN-TO-MKT-FL TO S-PHONE-MKT-FL.                 
P00740     MOVE LP-PERMISN-TO-MKT-DT TO S-PHONE-MKT-DT.                 
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           GO TO 2300-FETCH-ROWS.                                       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-FORMAT-CONTACT.                                             
                                                                        
           SET T1-INDEX TO +1                                           
           SEARCH T1-CONTACTS                                           
               AT END                                                   
                   MOVE CV-CONTACT-TYPE TO S-CONTACT-TYPE               
                                           S-CONTACT-TYPE-CD            
               WHEN CV-CONTACT-TYPE =                                   
                    T1-CONTACT-CD (T1-INDEX)                            
                        MOVE T1-CONTACT-DESC (T1-INDEX) TO              
                             S-CONTACT-TYPE                             
                   MOVE CV-CONTACT-TYPE TO S-CONTACT-TYPE-CD            
           END-SEARCH.                                                  
                                                                        
           IF CV-CONTACT-POSITION-TEXT(1:15) = 'SOCIAL SECURITY' OR     
              CV-CONTACT-POSITION-TEXT(1:15) = 'DRIVERS LICENSE' OR     
              CV-CONTACT-POSITION-TEXT(1:11) = 'MILITARY ID' OR         
              CV-CONTACT-POSITION-TEXT(1:8)  = 'OTHER ID'               
                  MOVE CV-CONTACT-POSITION-TEXT(1:15) TO                
                       S-CONTACT-OTHER-ID-TYPE                          
                  MOVE DQ-NICKNAME TO S-CONTACT-NICKNAME
           END-IF.               
                                                                        
           IF CV-CONTACT-POSITION-TEXT(1:15) = 'DRIVERS LICENSE' OR     
              CV-CONTACT-POSITION-TEXT(1:11) = 'MILITARY ID' OR         
              CV-CONTACT-POSITION-TEXT(1:8)  = 'OTHER ID'               
                  MOVE DQ-NICKNAME TO S-CONTACT-OTHER-ID
           END-IF.               
                                                                        
           IF S-CONTACT-OTHER-ID-TYPE = 'SOCIAL SECURITY' AND           
              S-CONTACT-NICKNAME > ' '                                  
                  PERFORM 4000-FORMAT-SSN THRU 4000-EXIT
           END-IF.               
                                                                        
           MOVE CV-CONTACT-ID TO S-ID.                                  
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
P00740     MOVE CV-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD.                
P00740     IF CASA-CONFIRM-YES                                          
P00740         MOVE 'Y' TO S-CONFIRM-FL                                 
P00740     ELSE                                                         
P00740         MOVE 'N' TO S-CONFIRM-FL
           END-IF.                                
P00740     MOVE CV-MEMO-BILL-IND TO S-MEMO-BILL-IND.                    
P00740     PERFORM 7100-CONTACT-STATS THRU 7100-EXIT.                   
P00740     IF S-CONTACT-SSN > SPACES                                    
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         IF 3H-SSN NUMERIC                                        
P00740             MOVE 3H-SSN TO S-CONTACT-SSN
               END-IF
           END-IF.                        
P00740     MOVE 3H-DRIVERS-LICENSE-NO TO S-CONTACT-DLN.                 
P00740     IF S-CONTACT-OTHER-ID > SPACES                               
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE 3H-OTHER-ID TO S-CONTACT-OTHER-ID
           END-IF.                  
P00740     IF S-CONTACT-OTHER-ID-TYPE > SPACES                          
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE 3H-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE
           END-IF.        
P00740     MOVE 3H-DATE-OF-BIRTH TO S-CONTACT-DOB.                      
P00740     MOVE 3H-CODE-STATE-ID TO S-CONTACT-DLN-STATE.                
P00740     MOVE 3H-ITIN-ID TO S-CONTACT-ITIN.                           
P00740     MOVE 3H-ALLOW-CALL-FL TO S-ALLOW-CALL-FL.                    
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2320-CONTACT-PHONE.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE S-NAME-TYPE TO S-PHONE-NAME-TYPE.                       
           MOVE S-NAME-COUNTER TO S-PHONE-NAME-COUNTER.                 
           MOVE CV-CONTACT-ID TO LP-CONTACT-ID.                         
           PERFORM 7192-OPEN-CONTACT-PHONE-CURSOR THRU 7192-EXIT.       
           PERFORM 2300-FETCH-ROWS THRU 2300-EXIT.                      
           PERFORM 7193-CLOSE-CONTACT-PHO-CURSOR THRU 7193-EXIT.        
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 2400-FETCH-ROWS.                                                 
P00740                                                                  
P00740     MOVE SPACES TO CV-CONTACT-POSITION.                          
P00740     EXEC SQL                                                     
P00740         FETCH OUTAGE-CONTACT-CURSOR                              
P00740          INTO :WS-NAME,                                          
P00740               :DQ-FULL-NAME,                                     
P00740               :DQ-NAME-FORMAT,                                   
P00740               :CV-CONTACT-TYPE,                                  
P00740               :CV-CONTACT-POSITION,                              
P00740               :CV-CONTACT-ID,                                    
P00740               :CV-ACCESS-LEVEL-CD,                               
P00740               :CV-VALIDATION-TS :WS-NULL-7,                       
P00740               :CV-MEMO-BILL-IND                                  
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CV-VALIDATION-TS                  
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             GO TO 2400-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '2400'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
P00740             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00740             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     INITIALIZE GTT-RETURN-FIELDS-1.                              
P00740     MOVE 'AC' TO S-NAME-TYPE.                                    
A05317     MOVE 'G' TO S-SORT-ORDER.                                    
P00740     IF DQ-NAME-FORMAT = 'I'                                      
P00740         IF WS-NAME <= ' ' OR                                     
P00740            WS-NAME = ','                                         
P00740                MOVE DQ-FULL-NAME TO S-NAME                       
P00740         ELSE                                                     
P00740             MOVE WS-NAME TO S-NAME                               
P00740         END-IF                                                   
P00740     ELSE                                                         
P00740         MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
P00740                                                                  
P00740     PERFORM 2310-FORMAT-CONTACT THRU 2310-EXIT.                  
P00740                                                                  
P00740     ADD 1 TO WS-AC-COUNTER.                                      
P00740     MOVE WS-AC-COUNTER TO S-NAME-COUNTER.                        
P00740                                                                  
P00740     MOVE SPACES TO WS-CONTACT-EMAIL.                             
P00740     MOVE ZEROES TO WS-CONTACT-EMAIL-CT.                          
P00740     PERFORM 7204-OPEN-CONTACT-EML-CURSOR THRU 7204-EXIT.         
P00740     PERFORM 2440-FETCH-ROWS THRU 2440-EXIT.                      
P00740     PERFORM 7205-CLOSE-CONTACT-EML-CURSOR THRU 7205-EXIT.        
P00740     MOVE WS-CONTACT-EMAIL TO S-EMAIL-ADDRESS.                    
P00740     MOVE WS-CONTACT-EMAIL-CT TO S-EMAIL-CT.                      
P00740                                                                  
P00740     PERFORM 2320-CONTACT-PHONE THRU 2320-EXIT.                   
P00740                                                                  
P00740     GO TO 2400-FETCH-ROWS.                                       
P00740                                                                  
P00740 2400-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2410-FETCH-ROWS.                                                 
P00740                                                                  
P00740     MOVE SPACES TO CV-CONTACT-POSITION.                          
P00740     EXEC SQL                                                     
P00740         FETCH INTERNAL-CONTACT-CURSOR                            
P00740          INTO :WS-NAME,                                          
P00740               :DQ-FULL-NAME,                                     
P00740               :DQ-NAME-FORMAT,                                   
P00740               :CV-CONTACT-TYPE,                                  
P00740               :CV-CONTACT-POSITION,                              
P00740               :CV-CONTACT-ID,                                    
P00740               :CV-ACCESS-LEVEL-CD,                               
P00740               :CV-VALIDATION-TS :WS-NULL-7,                       
P00740               :CV-MEMO-BILL-IND,                                 
P00740               :WS-ENTITY-IND                                     
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CV-VALIDATION-TS                  
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             GO TO 2410-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '2410'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
P00740             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00740             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     INITIALIZE GTT-RETURN-FIELDS-1.                              
P00740     IF WS-ENTITY-IND = 'C'                                       
P00740         MOVE 'CC' TO S-NAME-TYPE                                 
P00740     ELSE                                                         
P00740         MOVE 'AC' TO S-NAME-TYPE
           END-IF.                                
A05317     MOVE 'F' TO S-SORT-ORDER.                                    
P00740     IF DQ-NAME-FORMAT = 'I'                                      
P00740         IF WS-NAME <= ' ' OR                                     
P00740            WS-NAME = ','                                         
P00740                MOVE DQ-FULL-NAME TO S-NAME                       
P00740         ELSE                                                     
P00740             MOVE WS-NAME TO S-NAME                               
P00740         END-IF                                                   
P00740     ELSE                                                         
P00740         MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
P00740     MOVE WS-ENTITY-IND TO S-ENTITY-IND.                          
P00740                                                                  
P00740     PERFORM 2310-FORMAT-CONTACT THRU 2310-EXIT.                  
P00740                                                                  
P00740     IF WS-ENTITY-IND = 'C'                                       
P00740         ADD 1 TO WS-CC-COUNTER                                   
P00740         MOVE WS-CC-COUNTER TO S-NAME-COUNTER                     
P00740     ELSE                                                         
P00740         ADD 1 TO WS-AC-COUNTER                                   
P00740         MOVE WS-AC-COUNTER TO S-NAME-COUNTER
           END-IF.                    
P00740                                                                  
P00740     PERFORM 2320-CONTACT-PHONE THRU 2320-EXIT.                   
P00740                                                                  
P00740     GO TO 2410-FETCH-ROWS.                                       
P00740                                                                  
P00740 2410-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2420-FETCH-ROWS.                                                 
P00740                                                                  
P00740     MOVE SPACES TO NE-EMAIL-ADDRESS-TX.                          
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         FETCH CUST-EMAIL-CURSOR                                  
P00740          INTO :NE-EMAIL-TYPE-CD,                                 
P00740               :NE-EMAIL-ADDRESS-TX,                              
D05317               :NE-PERMISN-TO-MKT-TS :WS-NULL-6,                   
P00740               :NE-PERMISN-TO-MKT-FL                              
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-6 < 0                                     
D05317                 MOVE SPACES TO NE-PERMISN-TO-MKT-TS              
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             GO TO 2420-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '2420'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
P00740             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
P00740             MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     IF NE-EMAIL-TYPE-CD(2:1) = '1'                               
P00740         MOVE NE-EMAIL-ADDRESS-TX-TEXT TO WS-CUST-EMAIL
           END-IF.          
P00740     ADD +1 TO WS-CUST-EMAIL-CT.                                  
P00740                                                                  
P00740     GO TO 2420-FETCH-ROWS.                                       
P00740                                                                  
P00740 2420-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2430-FETCH-ROWS.                                                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         FETCH THIRD-EMAIL-CURSOR                                 
P00740          INTO :3N-EMAIL-TYPE-CD,                                 
P00740               :3N-EMAIL-ADDRESS-TX,                              
D05317               :3N-PERMISN-TO-MKT-TS :WS-NULL-6,                   
P00740               :3N-PERMISN-TO-MKT-FL                              
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-6 < 0                                     
D05317                 MOVE SPACES TO 3N-PERMISN-TO-MKT-TS              
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             GO TO 2430-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '2430'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                 
P00740             MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
P00740             MOVE ZW-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     IF 3N-EMAIL-TYPE-CD(2:1) = '1'                               
P00740         MOVE 3N-EMAIL-ADDRESS-TX TO WS-3RD-EMAIL
           END-IF.                
P00740     ADD +1 TO WS-3RD-EMAIL-CT.                                   
P00740                                                                  
P00740     GO TO 2430-FETCH-ROWS.                                       
P00740                                                                  
P00740 2430-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2440-FETCH-ROWS.                                                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         FETCH CONTACT-EMAIL-CURSOR                               
P00740          INTO :3G-EMAIL-TYPE-CD,                                 
P00740               :3G-EMAIL-ADDRESS-TX,                              
D05317               :3G-PERMISN-TO-MKT-TS :WS-NULL-6,                   
P00740               :3G-PERMISN-TO-MKT-FL                              
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-6 < 0                                     
D05317                 MOVE SPACES TO 3G-PERMISN-TO-MKT-TS              
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             GO TO 2440-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '2440'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
P00740             MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
P00740             MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     IF 3G-EMAIL-TYPE-CD(2:1) = '1'                               
P00740         MOVE 3G-EMAIL-ADDRESS-TX TO WS-CONTACT-EMAIL
           END-IF.            
P00740     ADD +1 TO WS-CONTACT-EMAIL-CT.                               
P00740                                                                  
P00740     GO TO 2440-FETCH-ROWS.                                       
P00740                                                                  
P00740 2440-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2450-FETCH-ROWS.                                                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         FETCH XFER-CURSOR                                        
P00740          INTO :WS-NAME,                                          
P00740               :DQ-FULL-NAME,                                     
P00740               :DQ-NAME-FORMAT,                                   
P00740               :EK-CUSTOMER-NO,                                   
P00740               :EK-ACCESS-LEVEL-CD,                               
P00740               :CU-VALIDATION-TS :WS-NULL-7,                       
P00740               :EK-RELATION-TYPE-CD                               
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-7 < 0                                     
P00740                 MOVE SPACES TO CU-VALIDATION-TS                  
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             GO TO 2450-EXIT                                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '2450'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'FETCH'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_XFER' TO TABLE-1                   
P00740             MOVE 'CSS_NAME'         TO TABLE-2                   
P00740             MOVE 'CSS_CUSTOMER'     TO TABLE-3                   
P00740             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
P00740             MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740     INITIALIZE GTT-RETURN-FIELDS-1.                              
P00740     MOVE EK-CUSTOMER-NO TO BS-CUSTOMER-NO                        
P00740                            RO-CUSTOMER-NO.                       
P00740     PERFORM 7035-SELECT-RC-STATS THRU 7035-EXIT.                 
P00740     PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
P00740     EVALUATE EK-RELATION-TYPE-CD                                 
P00740         WHEN 'RO'                                                
P00740             MOVE 'RO' TO S-NAME-TYPE                             
P00740                          S-CONTACT-TYPE-CD                       
A05317             MOVE 'D' TO S-SORT-ORDER                             
P00740             MOVE 'ROOMMATE' TO S-CONTACT-TYPE                    
P00740             ADD 1 TO WS-RO-COUNTER                               
P00740             MOVE WS-RO-COUNTER TO S-NAME-COUNTER                 
P00740         WHEN 'CO'                                                
P00740             MOVE 'CO' TO S-NAME-TYPE                             
P00740                          S-CONTACT-TYPE-CD                       
A05317             MOVE 'C' TO S-SORT-ORDER                             
P00740             MOVE 'COAPPLICANT' TO S-CONTACT-TYPE                 
P00740             ADD 1 TO WS-CO-COUNTER                               
P00740             MOVE WS-CO-COUNTER TO S-NAME-COUNTER                 
P00740     END-EVALUATE.                                                
P00740     IF DQ-NAME-FORMAT = 'I'                                      
P00740         MOVE WS-NAME TO S-NAME                                   
P00740     ELSE                                                         
P00740         MOVE DQ-FULL-NAME TO S-NAME
           END-IF.                             
P00740     MOVE CE-SSN TO S-CONTACT-SSN.                                
P00740     MOVE CE-ITIN-ID TO S-CONTACT-ITIN.                           
P00740     MOVE CE-DRIVERS-LICENSE-NO TO S-CONTACT-DLN.                 
P00740     MOVE CE-CODE-STATE-ID TO S-CONTACT-DLN-STATE.                
P00740     MOVE CE-DATE-OF-BIRTH TO S-CONTACT-DOB.                      
P00740     MOVE CE-OTHER-ID TO S-CONTACT-OTHER-ID.                      
P00740     MOVE CE-OTHER-ID-TYPE TO S-CONTACT-OTHER-ID-TYPE.            
P00740     MOVE BS-TAX-ID TO S-CONTACT-TAX-ID.                          
P00740     MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN.                     
P00740     MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
P00740     MOVE RO-CUSTOMER-NO TO CB-CUSTOMER-NO                        
P00740                            S-ID.                                 
P00740     MOVE EK-ACCESS-LEVEL-CD TO S-ACCESS-LEVEL-CD.                
P00740     MOVE 'A' TO S-ENTITY-IND.                                    
P00740     PERFORM 2500-MOVE-ITIN THRU 2500-EXIT.                       
P00740     IF CASA-CONFIRM-YES                                          
P00740         MOVE 'Y' TO S-CONFIRM-FL                                 
P00740     ELSE                                                         
P00740         MOVE 'N' TO S-CONFIRM-FL
           END-IF.                                
P00740     MOVE 'C' TO CB-CUSTOMER-TYPE.                                
P00740     INITIALIZE WS-PHONE-FIELDS.                                  
P00740     PERFORM 7050-OPEN-PHONE-CURSOR THRU 7050-EXIT.               
P00740     PERFORM 7051-FETCH-PHONE-CURSOR THRU 7051-EXIT.              
P00740     PERFORM 7052-CLOSE-PHONE-CURSOR THRU 7052-EXIT.              
P00740     PERFORM 4100-PHONE-PROCESSING THRU 4100-EXIT.                
P00740     MOVE RO-CUSTOMER-NO TO NE-CUSTOMER-NO.                       
P00740     MOVE 'P%' TO WS-EMAIL-TYPE-CD.                               
P00740     PERFORM 7200-OPEN-CUST-EML-CURSOR THRU 7200-EXIT.            
P00740     PERFORM 2420-FETCH-ROWS THRU 2420-EXIT.                      
P00740     PERFORM 7201-CLOSE-CUST-EML-CURSOR THRU 7201-EXIT.           
P00740     MOVE WS-CUST-EMAIL TO S-EMAIL-ADDRESS.                       
P00740     MOVE WS-CUST-EMAIL-CT TO S-EMAIL-CT.                         
P00740     IF WS-GTT01-DECLARED = 'N'                                   
P00740         PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
P00740     PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
P00740                                                                  
P00740     GO TO 2450-FETCH-ROWS.                                       
P00740                                                                  
P00740 2450-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2500-MOVE-ITIN.                                                  
P00740                                                                  
P00740     IF S-CONTACT-OTHER-ID-TYPE = 'ITIN' AND                      
P00740        S-CONTACT-ITIN <= SPACES AND                              
P00740        S-CONTACT-OTHER-ID(1:1) = '9'                             
P00740            MOVE 0 TO WS-SPACES WS-LENGTH                         
P00740            INSPECT FUNCTION REVERSE (CE-OTHER-ID) TALLYING       
P00740                WS-SPACES FOR LEADING SPACES                      
P00740            COMPUTE WS-LENGTH = 16 - WS-SPACES                    
P00740            IF WS-LENGTH = 9 OR 11                                
P00740                PERFORM 2510-FORMAT-ITIN THRU 2510-EXIT
                  END-IF
           END-IF.          
P00740*               IF S-CONTACT-ITIN > SPACES                                
P00740*                   MOVE SPACES TO S-CONTACT-OTHER-ID                     
P00740*                                  S-CONTACT-OTHER-ID-TYPE.               
P00740                                                                  
P00740*    IF S-CONTACT-ITIN > SPACES AND                                       
P00740*       S-CONTACT-OTHER-ID-TYPE = 'ITIN'                                  
P00740*           MOVE SPACES TO S-CONTACT-OTHER-ID                             
P00740*                          S-CONTACT-OTHER-ID-TYPE.                       
P00740 2500-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2510-FORMAT-ITIN.                                                
P00740                                                                  
P00740     IF S-CONTACT-OTHER-ID(1:9) NUMERIC                           
P00740         MOVE S-CONTACT-OTHER-ID(1:9) TO S-CONTACT-ITIN           
P00740     ELSE                                                         
P00740         IF S-CONTACT-OTHER-ID(4:1) = '-' AND                     
P00740            S-CONTACT-OTHER-ID(7:1) = '-' AND                     
P00740            S-CONTACT-OTHER-ID(1:3) NUMERIC AND                   
P00740            S-CONTACT-OTHER-ID(5:2) NUMERIC AND                   
P00740            S-CONTACT-OTHER-ID(8:4) NUMERIC                       
P00740                MOVE S-CONTACT-OTHER-ID(1:3) TO                   
P00740                     S-CONTACT-ITIN(1:3)                          
P00740                MOVE S-CONTACT-OTHER-ID(5:2) TO                   
P00740                     S-CONTACT-ITIN(4:2)                          
P00740                MOVE S-CONTACT-OTHER-ID(8:4) TO                   
P00740                     S-CONTACT-ITIN(6:4)
               END-IF
           END-IF.                         
P00740     IF S-CONTACT-ITIN > SPACES AND                               
P00740       (S-CONTACT-ITIN(4:1) = '7' OR '8' OR '9') AND              
P00740        S-CONTACT-ITIN(4:2) NOT = '89' AND                        
P00740        S-CONTACT-ITIN(4:2) NOT = '93'                            
P00740            CONTINUE                                              
P00740     ELSE                                                         
P00740         MOVE SPACES TO S-CONTACT-ITIN
           END-IF.                           
P00740                                                                  
P00740 2510-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       4000-FORMAT-SSN.                                                 
                                                                        
           MOVE 0 TO WS-SPACES WS-LENGTH.                               
           INSPECT FUNCTION REVERSE (S-CONTACT-NICKNAME) TALLYING       
               WS-SPACES FOR LEADING SPACES.                            
           COMPUTE WS-LENGTH = 50 - WS-SPACES.                          
           MOVE SPACES TO WS-SSN-FORMAT WS-UNFORMATTED-SSN.             
           IF WS-LENGTH = 9 AND S-CONTACT-NICKNAME(1:9) NUMERIC         
               MOVE 'U' TO WS-SSN-FORMAT                                
           ELSE                                                         
               IF WS-LENGTH = 4 AND S-CONTACT-NICKNAME(1:4) NUMERIC     
                   MOVE 'L' TO WS-SSN-FORMAT                            
               ELSE                                                     
                   IF WS-LENGTH = 11 AND                                
                      S-CONTACT-NICKNAME(4:1) = '-' AND                 
                      S-CONTACT-NICKNAME(7:1) = '-'                     
                          MOVE 'F' TO WS-SSN-FORMAT
                   END-IF
               END-IF
           END-IF.                    
           EVALUATE WS-SSN-FORMAT                                       
               WHEN 'F'                                                 
                   MOVE S-CONTACT-NICKNAME(1:3) TO                      
                        WS-UNFORMATTED-SSN(1:3)                         
                   MOVE S-CONTACT-NICKNAME(5:2) TO                      
                        WS-UNFORMATTED-SSN(4:2)                         
                   MOVE S-CONTACT-NICKNAME(8:4) TO                      
                        WS-UNFORMATTED-SSN(6:4)                         
                   IF WS-UNFORMATTED-SSN(1:5) = '*****'                 
                       MOVE S-CONTACT-NICKNAME(8:4) TO S-CONTACT-SSN    
                   ELSE                                                 
                       MOVE WS-UNFORMATTED-SSN TO S-CONTACT-SSN         
                   END-IF                                               
               WHEN 'U'                                                 
                   MOVE S-CONTACT-NICKNAME(1:9) TO S-CONTACT-SSN        
               WHEN 'L'                                                 
                   MOVE S-CONTACT-NICKNAME(1:4) TO S-CONTACT-SSN        
           END-EVALUATE.                                                
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4100-PHONE-PROCESSING.                                           
                                                                        
      * TEMP PHONE REFORMAT FOR INDIVIDUAL BEHIND BUSINESS                      
                                                                        
      *    IF S-NAME-TYPE = 'CU' AND                                            
      *       S-NAME-FORMAT = 'B'                                               
      *          EVALUATE TRUE                                                  
      *             WHEN WS-PRIMARY-PHONE <= SPACES AND                         
      *                  WS-BUSINESS-PHONE > SPACES                             
      *                     MOVE WS-BUSINESS-PHONE TO WS-PRIMARY-PHONE          
      *                     MOVE WS-BUSINESS-EXT TO WS-PRIMARY-EXT              
      *             WHEN WS-PRIMARY-PHONE > SPACES AND                          
      *                  WS-BUSINESS-PHONE > SPACES AND                         
      *                  WS-ALTERNATE-PHONE <= SPACES                           
      *                     MOVE WS-PRIMARY-PHONE TO WS-ALTERNATE-PHONE         
      *                     MOVE WS-PRIMARY-EXT TO WS-ALTERNATE-EXT             
      *                     MOVE WS-BUSINESS-PHONE TO WS-PRIMARY-PHONE          
      *                     MOVE WS-BUSINESS-EXT TO WS-PRIMARY-EXT              
      *             WHEN WS-PRIMARY-PHONE > SPACES AND                          
      *                  WS-BUSINESS-PHONE > SPACES AND                         
      *                  WS-ALTERNATE-PHONE > SPACES AND                        
      *                  WS-WORK-PHONE <= SPACES                                
      *                      MOVE WS-ALTERNATE-PHONE TO WS-WORK-PHONE           
      *                      MOVE WS-ALTERNATE-EXT TO WS-WORK-EXT               
      *                      MOVE WS-PRIMARY-PHONE TO WS-ALTERNATE-PHONE        
      *                      MOVE WS-PRIMARY-EXT TO WS-ALTERNATE-EXT            
      *                      MOVE WS-BUSINESS-PHONE TO WS-PRIMARY-PHONE         
      *                      MOVE WS-BUSINESS-EXT TO WS-PRIMARY-EXT             
      *             WHEN WS-PRIMARY-PHONE > SPACES AND                          
      *                  WS-BUSINESS-PHONE > SPACES AND                         
      *                  WS-ALTERNATE-PHONE > SPACES AND                        
      *                  WS-WORK-PHONE > SPACES                                 
      *                      MOVE WS-ALTERNATE-PHONE TO WS-WORK-PHONE           
      *                      MOVE WS-ALTERNATE-EXT TO WS-WORK-EXT               
      *                      MOVE WS-PRIMARY-PHONE TO WS-ALTERNATE-PHONE        
      *                      MOVE WS-PRIMARY-EXT TO WS-ALTERNATE-EXT            
      *                      MOVE WS-BUSINESS-PHONE TO WS-PRIMARY-PHONE         
      *                      MOVE WS-BUSINESS-EXT TO WS-PRIMARY-EXT             
      *          END-EVALUATE.                                                  
                                                                        
           IF WS-PRIMARY-PHONE > SPACES                                 
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE S-NAME-TYPE TO S-PHONE-NAME-TYPE                    
               MOVE S-NAME-COUNTER TO S-PHONE-NAME-COUNTER              
               MOVE 'H1' TO S-PHONE-TYPE                                
               MOVE WS-PRIMARY-PHONE TO S-PHONE-NO                      
               MOVE WS-PRIMARY-EXT TO S-PHONE-EXT                       
P00740         MOVE WS-PRIMARY-MOBILE-FL TO S-PHONE-MOBILE-FL           
P00740         MOVE WS-PRIMARY-MKT-FL TO S-PHONE-MKT-FL                 
P00740         MOVE WS-PRIMARY-MKT-DT TO S-PHONE-MKT-DT                 
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
           IF WS-ALTERNATE-PHONE > SPACES                               
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE S-NAME-TYPE TO S-PHONE-NAME-TYPE                    
               MOVE S-NAME-COUNTER TO S-PHONE-NAME-COUNTER              
               MOVE 'A1' TO S-PHONE-TYPE                                
               MOVE WS-ALTERNATE-PHONE TO S-PHONE-NO                    
               MOVE WS-ALTERNATE-EXT TO S-PHONE-EXT                     
P00740         MOVE WS-ALTERNATE-MOBILE-FL TO S-PHONE-MOBILE-FL         
P00740         MOVE WS-ALTERNATE-MKT-FL TO S-PHONE-MKT-FL               
P00740         MOVE WS-ALTERNATE-MKT-DT TO S-PHONE-MKT-DT               
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
      *    IF WS-BUSINESS-PHONE > SPACES                                        
      *        INITIALIZE GTT-RETURN-FIELDS-2                                   
      *        MOVE S-NAME-TYPE TO S-PHONE-NAME-TYPE                            
      *        MOVE S-NAME-COUNTER TO S-PHONE-NAME-COUNTER                      
      *        MOVE 'B1' TO S-PHONE-TYPE                                        
      *        MOVE WS-BUSINESS-PHONE TO S-PHONE-NO                             
      *        MOVE WS-BUSINESS-EXT TO S-PHONE-EXT                              
P00740*        MOVE WS-BUSINESS-MOBILE-FL TO S-PHONE-MOBILE-FL                  
P00740*        MOVE WS-BUSINESS-MKT-FL TO S-PHONE-MKT-FL                        
P00740*        MOVE WS-BUSINESS-MKT-DT TO S-PHONE-MKT-DT                        
      *        IF WS-GTT02-DECLARED = 'N'                                       
      *            PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                    
      *        END-IF                                                           
      *        PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                       
           IF WS-WORK-PHONE > SPACES                                    
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE S-NAME-TYPE TO S-PHONE-NAME-TYPE                    
               MOVE S-NAME-COUNTER TO S-PHONE-NAME-COUNTER              
               MOVE 'W1' TO S-PHONE-TYPE                                
               MOVE WS-WORK-PHONE TO S-PHONE-NO                         
               MOVE WS-WORK-EXT TO S-PHONE-EXT                          
P00740         MOVE WS-WORK-MOBILE-FL TO S-PHONE-MOBILE-FL              
P00740         MOVE WS-WORK-MKT-FL TO S-PHONE-MKT-FL                    
P00740         MOVE WS-WORK-MKT-DT TO S-PHONE-MKT-DT                    
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
       4100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO,                                        
                     CUSTOMER_NO,                                       
P00740               COMPANY_NO                                         
               INTO :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO,                                    
P00740              :AT-COMPANY-NO                                      
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO                                                 
MFA-TR*        INTO :AT-PREMISE-NO,                                             
MFA-TR*             :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-COMPANY-NO                                              
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
                   IF CU-CUSTOMER-NO = 0                                
                       MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO            
                   END-IF                                               
                   IF PR-PREMISE-NO = 0                                 
                       MOVE AT-PREMISE-NO TO PR-PREMISE-NO              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   PERFORM 7001-SELECT-ACCOUNT-ARCH THRU 7001-EXIT      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7001-SELECT-ACCOUNT-ARCH.                                        
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO,                                        
                     CUSTOMER_NO,                                       
P00740               COMPANY_NO                                         
               INTO :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO,                                    
P00740              :AT-COMPANY-NO                                      
                 FROM HST_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PREMISE_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO                                                 
MFA-TR*        INTO :AT-PREMISE-NO,                                             
MFA-TR*             :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-COMPANY-NO                                              
MFA-TR*          FROM HST_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ARCHIVED-ACCOUNT                      
                   IF CU-CUSTOMER-NO = 0                                
                       MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO            
                   END-IF                                               
                   IF PR-PREMISE-NO = 0                                 
                       MOVE AT-PREMISE-NO TO PR-PREMISE-NO              
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-3             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-3           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 7010-GET-DELINQUENCY-VALUES.                                     
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        SELECT TOP(1) DELINQ_VALUE                                       
P00740          INTO :C8-DELINQ-VALUE                                   
P00740          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
P00740        WHERE DELINQ_CD = :C8-DELINQ-CD                           
P00740          AND COMPANY_NO = :C8-COMPANY-NO                         
P00740                                           
P00740                                                           
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN NOT-FOUND                                           
P00740             MOVE 1 TO C8-DELINQ-VALUE                            
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7010'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
P00740             MOVE 'DELINQ_CD'      TO TABLE-ELEMENT-1             
P00740             MOVE C8-DELINQ-CD     TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7010-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       7025-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(
           FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),
              NICKNAME,
              FULL_NAME,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_SUFFIX_1,
              DHR_FL,
              REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS, 121), 
           ' ', '-'), ':', '.') VALIDATION_TS,
              COMPANY_NO_ORIG                                   
                 INTO :WS-CUST-NAME,                                    
                      :DQ-NICKNAME,                                     
                      :DQ-FULL-NAME,                                    
                      :DQ-NAME-FORMAT,                                  
A04671                :DQ-LAST-NAME,                                    
A04671                :DQ-FIRST-NAME,                                   
A04671                :DQ-MIDDLE-NAME,                                  
A04671                :DQ-TITLE-SUFFIX-1,                               
A04671                :CU-DHR-FL,                                       
P00740                :CU-VALIDATION-TS :WS-NULL-3,                      
P00740                :CU-COMPANY-NO-ORIG                               
                 FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               NICKNAME,                                                 
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               DHR_FL,                                                   
MFA-TR*               VALIDATION_TS,                                            
MFA-TR*               COMPANY_NO_ORIG                                           
MFA-TR*          INTO :WS-CUST-NAME,                                            
MFA-TR*               :DQ-NICKNAME,                                             
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-TITLE-SUFFIX-1,                                       
MFA-TR*               :CU-DHR-FL,                                               
MFA-TR*               :CU-VALIDATION-TS:WS-NULL-3,                              
MFA-TR*               :CU-COMPANY-NO-ORIG                                       
MFA-TR*          FROM CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-3 < 0                                     
P00740                 MOVE SPACES TO CU-VALIDATION-TS                  
P00740             END-IF                                               
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-CUST-NAME                
A04671                 MOVE SPACES TO DQ-LAST-NAME                      
A04671                                DQ-FIRST-NAME                     
A04671                                DQ-MIDDLE-NAME                    
A04671                                DQ-TITLE-SUFFIX-1                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-CUST-NAME                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7025'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SSN,
              REFUSED_SSN_FL,
              DRIVERS_LICENSE_NO,
              OTHER_ID,
              PASSWORD_TX,
              DATE_OF_BIRTH,
              OTHER_ID_TYPE,
              CODE_STATE_ID,
              DOB_VERIFIED_CD,
              ACCESS_LEVEL_CD,
              ALLOW_CALL_FL,
              ITIN_ID,
              VERIFY_SSN_FL,
              PASSWORD_HINT,
              ALLOW_EMAIL_FL                                    
                 INTO :CE-SSN,                                          
                      :CE-REFUSED-SSN-FL,                               
                      :CE-DRIVERS-LICENSE-NO,                           
                      :CE-OTHER-ID,                                     
                      :CE-PASSWORD-TX,                                  
                      :CE-DATE-OF-BIRTH :WS-NULL-2,                      
                      :CE-OTHER-ID-TYPE,                                
                      :CE-CODE-STATE-ID,                                
A04671                :CE-DOB-VERIFIED-CD,                              
P00740                :CE-ACCESS-LEVEL-CD,                              
P00740                :CE-ALLOW-CALL-FL,                                
P00740                :CE-ITIN-ID,                                      
P00740                :CE-VERIFY-SSN-FL,                                
P00740                :CE-PASSWORD-HINT,                                
P00740                :CE-ALLOW-EMAIL-FL                                
                 FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = 'C'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN,                                                      
MFA-TR*               REFUSED_SSN_FL,                                           
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               OTHER_ID,                                                 
MFA-TR*               PASSWORD_TX,                                              
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               OTHER_ID_TYPE,                                            
MFA-TR*               CODE_STATE_ID,                                            
MFA-TR*               DOB_VERIFIED_CD,                                          
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               ALLOW_CALL_FL,                                            
MFA-TR*               ITIN_ID,                                                  
MFA-TR*               VERIFY_SSN_FL,                                            
MFA-TR*               PASSWORD_HINT,                                            
MFA-TR*               ALLOW_EMAIL_FL                                            
MFA-TR*          INTO :CE-SSN,                                                  
MFA-TR*               :CE-REFUSED-SSN-FL,                                       
MFA-TR*               :CE-DRIVERS-LICENSE-NO,                                   
MFA-TR*               :CE-OTHER-ID,                                             
MFA-TR*               :CE-PASSWORD-TX,                                          
MFA-TR*               :CE-DATE-OF-BIRTH:WS-NULL-2,                              
MFA-TR*               :CE-OTHER-ID-TYPE,                                        
MFA-TR*               :CE-CODE-STATE-ID,                                        
MFA-TR*               :CE-DOB-VERIFIED-CD,                                      
MFA-TR*               :CE-ACCESS-LEVEL-CD,                                      
MFA-TR*               :CE-ALLOW-CALL-FL,                                        
MFA-TR*               :CE-ITIN-ID,                                              
MFA-TR*               :CE-VERIFY-SSN-FL,                                        
MFA-TR*               :CE-PASSWORD-HINT,                                        
MFA-TR*               :CE-ALLOW-EMAIL-FL                                        
MFA-TR*          FROM CSS_CUST_STATS                                            
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = 'C'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-SSN > SPACES AND                               
                      CE-OTHER-ID > SPACES AND                          
                      CE-OTHER-ID-TYPE = 'ITIN'                         
                          MOVE 'OTHER' TO CE-OTHER-ID-TYPE              
                   END-IF                                               
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             INITIALIZE DCLCSS-CUST-STATS                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7035-SELECT-RC-STATS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SSN,
              REFUSED_SSN_FL,
              DRIVERS_LICENSE_NO,
              OTHER_ID,
              PASSWORD_TX,
              DATE_OF_BIRTH,
              OTHER_ID_TYPE,
              CODE_STATE_ID,
              ITIN_ID                                           
                 INTO :CE-SSN,                                          
                      :CE-REFUSED-SSN-FL,                               
                      :CE-DRIVERS-LICENSE-NO,                           
                      :CE-OTHER-ID,                                     
                      :CE-PASSWORD-TX,                                  
                      :CE-DATE-OF-BIRTH :WS-NULL-2,                      
                      :CE-OTHER-ID-TYPE,                                
                      :CE-CODE-STATE-ID,                                
P00740                :CE-ITIN-ID                                       
                 FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :RO-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = 'C'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN,                                                      
MFA-TR*               REFUSED_SSN_FL,                                           
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               OTHER_ID,                                                 
MFA-TR*               PASSWORD_TX,                                              
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               OTHER_ID_TYPE,                                            
MFA-TR*               CODE_STATE_ID,                                            
MFA-TR*               ITIN_ID                                                   
MFA-TR*          INTO :CE-SSN,                                                  
MFA-TR*               :CE-REFUSED-SSN-FL,                                       
MFA-TR*               :CE-DRIVERS-LICENSE-NO,                                   
MFA-TR*               :CE-OTHER-ID,                                             
MFA-TR*               :CE-PASSWORD-TX,                                          
MFA-TR*               :CE-DATE-OF-BIRTH:WS-NULL-2,                              
MFA-TR*               :CE-OTHER-ID-TYPE,                                        
MFA-TR*               :CE-CODE-STATE-ID,                                        
MFA-TR*               :CE-ITIN-ID                                               
MFA-TR*          FROM CSS_CUST_STATS                                            
MFA-TR*         WHERE CUSTOMER_NO = :RO-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = 'C'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7035                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
                   IF CE-SSN > SPACES AND                               
                      CE-OTHER-ID > SPACES AND                          
                      CE-OTHER-ID-TYPE = 'ITIN'                         
                          MOVE 'OTHER' TO CE-OTHER-ID-TYPE              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-CUST-STATS                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7035'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TAX_ID                                            
                 INTO :BS-TAX-ID                                        
                 FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TAX_ID                                                    
MFA-TR*          INTO :BS-TAX-ID                                                
MFA-TR*          FROM CSS_BUS_CUST_STATS                                        
MFA-TR*         WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO BS-TAX-ID                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7040'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-OPEN-PHONE-CURSOR.                                          
                                                                        
           INITIALIZE WS-PHONE-FIELDS.                                  
                                                                        
           EXEC SQL                                                     
               OPEN PHONE-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7051-FETCH-PHONE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH PHONE-CURSOR                                       
                INTO :CB-PHONE-NO,                                      
                     :CB-PHONE-TYPE,                                    
                     :CB-EXTENSION-NO,                                  
                     :CB-MOBILE-PHONE-FL,                               
                     :CB-PERMISN-TO-MKT-DT :WS-NULL-5,                   
                     :CB-PERMISN-TO-MKT-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-5 < 0                                     
P00740                 MOVE SPACES TO CB-PERMISN-TO-MKT-DT              
P00740             END-IF                                               
P00740             EVALUATE CB-PHONE-TYPE                               
P00740                 WHEN 'H1'                                        
P00740                     MOVE CB-PHONE-NO TO WS-PRIMARY-PHONE         
P00740                     MOVE CB-MOBILE-PHONE-FL TO                   
P00740                          WS-PRIMARY-MOBILE-FL                    
P00740                     MOVE CB-PERMISN-TO-MKT-DT TO                 
P00740                          WS-PRIMARY-MKT-DT                       
P00740                     MOVE CB-PERMISN-TO-MKT-FL TO                 
P00740                          WS-PRIMARY-MKT-FL                       
P00740                 WHEN 'A1'                                        
P00740                     MOVE CB-PHONE-NO TO WS-ALTERNATE-PHONE       
P00740                     MOVE CB-MOBILE-PHONE-FL TO                   
P00740                          WS-ALTERNATE-MOBILE-FL                  
P00740                     MOVE CB-PERMISN-TO-MKT-DT TO                 
P00740                          WS-ALTERNATE-MKT-DT                     
P00740                     MOVE CB-PERMISN-TO-MKT-FL TO                 
P00740                          WS-ALTERNATE-MKT-FL                     
P00740                 WHEN 'W1'                                        
P00740                     MOVE CB-PHONE-NO TO WS-WORK-PHONE            
P00740                     MOVE CB-MOBILE-PHONE-FL TO                   
P00740                          WS-WORK-MOBILE-FL                       
P00740                     MOVE CB-PERMISN-TO-MKT-DT TO                 
P00740                          WS-WORK-MKT-DT                          
P00740                     MOVE CB-PERMISN-TO-MKT-FL TO                 
P00740                          WS-WORK-MKT-FL                          
P00740                     MOVE CB-EXTENSION-NO TO                      
P00740                          WS-WORK-EXT                             
P00740                 WHEN 'B1'                                        
P00740                     MOVE CB-PHONE-NO TO WS-BUSINESS-PHONE        
P00740                     MOVE CB-MOBILE-PHONE-FL TO                   
P00740                          WS-BUSINESS-MOBILE-FL                   
P00740                     MOVE CB-PERMISN-TO-MKT-DT TO                 
P00740                          WS-BUSINESS-MKT-DT                      
P00740                     MOVE CB-PERMISN-TO-MKT-FL TO                 
P00740                          WS-BUSINESS-MKT-FL                      
P00740             END-EVALUATE                                         
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 7051-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7051'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 7051-FETCH-PHONE-CURSOR.                               
                                                                        
       7051-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7052-CLOSE-PHONE-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE PHONE-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7052'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7052-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-SPOUSE-STATS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SSN,
              DRIVERS_LICENSE_NO,
              OTHER_ID,
              DATE_OF_BIRTH,
              OTHER_ID_TYPE,
              RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(TITLE_SUFFIX_1)) + 
           ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(FIRST_NAME) + 
           ' ' + RTRIM(MIDDLE_NAME),
              NICKNAME,
              CODE_STATE_ID,
              ACCESS_LEVEL_CD,
              ALLOW_CALL_FL,
              ITIN_ID,
              REPLACE(REPLACE(CONVERT(CHAR(26), INFO_VERIFIED_TS, 121), 
           ' ', '-'), ':', '.') INFO_VERIFIED_TS,
              ALLOW_EMAIL_FL                                    
                 INTO :CE-SSN,                                          
                      :CE-DRIVERS-LICENSE-NO,                           
                      :CE-OTHER-ID,                                     
                      :CE-DATE-OF-BIRTH :WS-NULL-2,                      
                      :CE-OTHER-ID-TYPE,                                
                      :DQ-FULL-NAME,                                    
                      :DQ-NICKNAME,                                     
                      :CE-CODE-STATE-ID,                                
P00740                :CE-ACCESS-LEVEL-CD,                              
P00740                :CE-ALLOW-CALL-FL,                                
P00740                :CE-ITIN-ID,                                      
P00740                :CE-INFO-VERIFIED-TS :WS-NULL-4,                   
P00740                :CE-ALLOW-EMAIL-FL                                
                 FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = 'S'                               
                  AND CE.NAME_ID = DQ.NAME_ID                           
P00740            AND NAME_TYPE = 'SN'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN,                                                      
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               OTHER_ID,                                                 
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               OTHER_ID_TYPE,                                            
MFA-TR*               RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               NICKNAME,                                                 
MFA-TR*               CODE_STATE_ID,                                            
MFA-TR*               ACCESS_LEVEL_CD,                                          
MFA-TR*               ALLOW_CALL_FL,                                            
MFA-TR*               ITIN_ID,                                                  
MFA-TR*               INFO_VERIFIED_TS,                                         
MFA-TR*               ALLOW_EMAIL_FL                                            
MFA-TR*          INTO :CE-SSN,                                                  
MFA-TR*               :CE-DRIVERS-LICENSE-NO,                                   
MFA-TR*               :CE-OTHER-ID,                                             
MFA-TR*               :CE-DATE-OF-BIRTH:WS-NULL-2,                              
MFA-TR*               :CE-OTHER-ID-TYPE,                                        
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NICKNAME,                                             
MFA-TR*               :CE-CODE-STATE-ID,                                        
MFA-TR*               :CE-ACCESS-LEVEL-CD,                                      
MFA-TR*               :CE-ALLOW-CALL-FL,                                        
MFA-TR*               :CE-ITIN-ID,                                              
MFA-TR*               :CE-INFO-VERIFIED-TS:WS-NULL-4,                           
MFA-TR*               :CE-ALLOW-EMAIL-FL                                        
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = 'S'                                       
MFA-TR*           AND CE.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND NAME_TYPE = 'SN'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-SSN > SPACES AND                               
                      CE-OTHER-ID > SPACES AND                          
                      CE-OTHER-ID-TYPE = 'ITIN'                         
                          MOVE 'OTHER' TO CE-OTHER-ID-TYPE              
                   END-IF                                               
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
P00740             IF WS-NULL-4 < 0                                     
P00740                 MOVE SPACES TO CE-INFO-VERIFIED-TS               
P00740             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             INITIALIZE DCLCSS-CUST-STATS                         
P00740                        DCLCSS-NAME                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 7100-CONTACT-STATS.                                              
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         SELECT TOP(1) SSN,
              DRIVERS_LICENSE_NO,
              OTHER_ID,
              DATE_OF_BIRTH,
              OTHER_ID_TYPE,
              CODE_STATE_ID,
              ALLOW_CALL_FL,
              ITIN_ID                                           
P00740           INTO :3H-SSN,                                          
P00740                :3H-DRIVERS-LICENSE-NO,                           
P00740                :3H-OTHER-ID,                                     
P00740                :3H-DATE-OF-BIRTH :WS-NULL-2,                      
P00740                :3H-OTHER-ID-TYPE,                                
P00740                :3H-CODE-STATE-ID,                                
P00740                :3H-ALLOW-CALL-FL,                                
P00740                :3H-ITIN-ID                                       
P00740           FROM CSS_CONTACT_STATS WITH(READUNCOMMITTED)                   
P00740          WHERE CONTACT_ID = :CV-CONTACT-ID                       
P00740                                           
P00740                                                           
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN,                                                      
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               OTHER_ID,                                                 
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               OTHER_ID_TYPE,                                            
MFA-TR*               CODE_STATE_ID,                                            
MFA-TR*               ALLOW_CALL_FL,                                            
MFA-TR*               ITIN_ID                                                   
MFA-TR*          INTO :3H-SSN,                                                  
MFA-TR*               :3H-DRIVERS-LICENSE-NO,                                   
MFA-TR*               :3H-OTHER-ID,                                             
MFA-TR*               :3H-DATE-OF-BIRTH:WS-NULL-2,                              
MFA-TR*               :3H-OTHER-ID-TYPE,                                        
MFA-TR*               :3H-CODE-STATE-ID,                                        
MFA-TR*               :3H-ALLOW-CALL-FL,                                        
MFA-TR*               :3H-ITIN-ID                                               
MFA-TR*          FROM CSS_CONTACT_STATS                                         
MFA-TR*         WHERE CONTACT_ID = :CV-CONTACT-ID                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-2 < 0                                     
P00740                 MOVE SPACES TO 3H-DATE-OF-BIRTH                  
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00740             INITIALIZE DCLCSS-CONTACT-STATS                      
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7100'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_STATS' TO TABLE-1                  
P00740             MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
P00740             MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7100-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       7140-OPEN-ROOMMATE-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN ROOMMATE-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7140'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ROOMMATE'     TO TABLE-1                   
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7141-CLOSE-ROOMMATE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE ROOMMATE-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7141'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ROOMMATE'    TO TABLE-1                    
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7141-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7142-OPEN-ROOMMATE-CURSOR-H.                                     
                                                                        
           EXEC SQL                                                     
               OPEN ROOMMATE-CURSOR-H                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7142'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ROOMMATE'     TO TABLE-1                   
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7142-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7143-CLOSE-ROOMMATE-CURSOR-H.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE ROOMMATE-CURSOR-H                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7143'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_ROOMMATE'    TO TABLE-1                    
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7143-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-OPEN-COAPP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN COAPP-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COAPPLICANT'  TO TABLE-1                   
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7151-CLOSE-COAPP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE COAPP-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7151'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_COAPPLICANT' TO TABLE-1                    
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7151-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7152-OPEN-COAPP-CURSOR-H.                                        
                                                                        
           EXEC SQL                                                     
               OPEN COAPP-CURSOR-H                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7152'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_COAPPLICANT'  TO TABLE-1                   
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7152-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7153-CLOSE-COAPP-CURSOR-H.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE COAPP-CURSOR-H                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7153'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'HST_COAPPLICANT' TO TABLE-1                    
                   MOVE 'CSS_CUSTOMER'     TO TABLE-2                   
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7153-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7160-OPEN-THIRD-PARTY-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               OPEN THIRD-PARTY-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7160'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THIRD_PARTY'  TO TABLE-1                   
                   MOVE 'CSS_NAME'         TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7161-CLOSE-THIRD-PARTY-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE THIRD-PARTY-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7161'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THIRD_PARTY' TO TABLE-1                    
                   MOVE 'CSS_NAME'         TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7161-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7162-OPEN-THIRD-PHONE-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               OPEN THIRD-PHONE-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7162'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE ZY-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7162-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7163-CLOSE-THIRD-PHONE-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE THIRD-PHONE-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7163'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE ZY-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7163-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-OPEN-ACCT-CONTACT-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               OPEN ACCT-CONTACT-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7170'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7171-CLOSE-ACCT-CONTACT-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-CONTACT-CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7171'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7171-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7180-OPEN-CUST-CONTACT-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               OPEN CUST-CONTACT-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7180'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-2                  
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7181-CLOSE-CUST-CONTACT-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
               CLOSE CUST-CONTACT-CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7181'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-2                  
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7181-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7190-OPEN-PREM-CONTACT-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               OPEN PREM-CONTACT-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7190'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PREM'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-2                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7191-CLOSE-PREM-CONTACT-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
               CLOSE PREM-CONTACT-CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7191'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PREM' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-2                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7191-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7192-OPEN-CONTACT-PHONE-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
               OPEN CONTACT-PHONE-CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7192'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PHONE' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE LP-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7192-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7193-CLOSE-CONTACT-PHO-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE CONTACT-PHONE-CURSOR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7193'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CONTACT_PHONE' TO TABLE-1                  
                   MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
                   MOVE LP-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7193-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 7194-OPEN-OUTAGE-CURSOR.                                         
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         OPEN OUTAGE-CONTACT-CURSOR                               
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7194'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
P00740             MOVE 'CSS_CONTACT'       TO TABLE-2                  
P00740             MOVE 'CSS_NAME'          TO TABLE-2                  
P00740             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00740             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7194-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7195-CLOSE-OUTAGE-CURSOR.                                        
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE OUTAGE-CONTACT-CURSOR                              
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7195'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
P00740             MOVE 'CSS_CONTACT'       TO TABLE-2                  
P00740             MOVE 'CSS_NAME'          TO TABLE-2                  
P00740             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00740             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7195-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7196-OPEN-INTERNAL-CURSOR.                                       
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         OPEN INTERNAL-CONTACT-CURSOR                             
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7196'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_ACCT'  TO TABLE-1                  
P00740             MOVE 'CSS_CONTACT'       TO TABLE-2                  
P00740             MOVE 'CSS_NAME'          TO TABLE-2                  
P00740             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00740             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7196-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7197-CLOSE-INTERNAL-CURSOR.                                      
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE INTERNAL-CONTACT-CURSOR                            
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7197'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
P00740             MOVE 'CSS_CONTACT'       TO TABLE-2                  
P00740             MOVE 'CSS_NAME'          TO TABLE-2                  
P00740             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00740             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7197-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7200-OPEN-CUST-EML-CURSOR.                                       
P00740                                                                  
P00740     MOVE ZEROES TO WS-CUST-EMAIL-CT.                             
P00740     MOVE SPACES TO WS-CUST-EMAIL.                                
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         OPEN CUST-EMAIL-CURSOR                                   
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7200'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
P00740             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
P00740             MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7200-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7201-CLOSE-CUST-EML-CURSOR.                                      
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE CUST-EMAIL-CURSOR                                  
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7201'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
P00740             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
P00740             MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7201-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7202-OPEN-THIRD-EML-CURSOR.                                      
P00740                                                                  
P00740     MOVE ZEROES TO WS-3RD-EMAIL-CT.                              
P00740     MOVE SPACES TO WS-3RD-EMAIL.                                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         OPEN THIRD-EMAIL-CURSOR                                  
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7202'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                 
P00740             MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
P00740             MOVE ZW-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7202-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7203-CLOSE-THIRD-EML-CURSOR.                                     
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE THIRD-EMAIL-CURSOR                                 
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7203'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                 
P00740             MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
P00740             MOVE ZW-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7203-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7204-OPEN-CONTACT-EML-CURSOR.                                    
P00740                                                                  
P00740     MOVE ZEROES TO WS-CONTACT-EMAIL-CT.                          
P00740     MOVE SPACES TO WS-CONTACT-EMAIL.                             
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         OPEN CONTACT-EMAIL-CURSOR                                
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7204'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
P00740             MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
P00740             MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7204-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7205-CLOSE-CONTACT-EML-CURSOR.                                   
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE CONTACT-EMAIL-CURSOR                               
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7205'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                  
P00740             MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1             
P00740             MOVE CV-CONTACT-ID    TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7205-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7206-OPEN-XFER-CURSOR.                                           
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         OPEN XFER-CURSOR                                         
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7206'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_XFER' TO TABLE-1                   
P00740             MOVE 'CSS_NAME'         TO TABLE-2                   
P00740             MOVE 'CSS_CUSTOMER'     TO TABLE-3                   
P00740             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
P00740             MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7206-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7207-CLOSE-XFER-CURSOR.                                          
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE XFER-CURSOR                                        
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7207'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_XFER' TO TABLE-1                   
P00740             MOVE 'CSS_NAME'         TO TABLE-2                   
P00740             MOVE 'CSS_CUSTOMER'     TO TABLE-3                   
P00740             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
P00740             MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7207-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7208-OPEN-TYPE-CURSOR.                                           
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         OPEN CONTACT-TYPE-CURSOR                                 
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7208'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'OPEN'           TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_TYPE' TO TABLE-1                   
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7208-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7209-CLOSE-TYPE-CURSOR.                                          
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         CLOSE CONTACT-TYPE-CURSOR                                
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
P00740             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00740             MOVE '7209'           TO ACTIVE-PARAGRAPH            
P00740             MOVE 'CLOSE'          TO ABEND-FUNCTION              
P00740             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740             MOVE 'CSS_CONTACT_TYPE' TO TABLE-1                   
P00740             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7209-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04285_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04285_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8006'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04285_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT02-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04285_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04285_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8013'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04285_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04285_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              NAME_TYPE,                                                
              NAME,                                                     
              CONTACT_TYPE,                                             
              CONTACT_SSN,                                              
              CONTACT_DOB,                                              
              CONTACT_DLN,                                              
              CONTACT_OTHER_ID,                                         
              CONTACT_TAX_ID,                                           
              CONTACT_OTHER_ID_TYPE,                                    
              CONTACT_NICKNAME,                                         
              REFUSED_SSN,                                              
              NAME_COUNTER,                                             
              CONTACT_TYPE_CD,                                          
              PASSWORD,                                                 
              ID,                                                       
              EMAIL_ADDRESS,                                            
              NAME_FORMAT,                                              
              CONTACT_DLN_STATE,                                        
A04671        LAST_NAME,                                                
A04671        FIRST_NAME,                                               
A04671        MIDDLE_NAME,                                              
A04671        NAME_SUFFIX,                                              
A04671        DOB_VERIFIED,                                             
A04671        DHR_FL,                                                   
P00740        ACCESS_LEVEL_CD,                                          
P00740        VERIFY_SSN_FL,                                            
P00740        ALLOW_CALL_FL,                                            
P00740        MEMO_BILL_IND,                                            
P00740        CONFIRM_REQ_FL,                                           
P00740        EMAIL_CT,                                                 
P00740        CONTACT_ITIN,                                             
P00740        ENTITY_IND,                                               
P00740        PASSWORD_HINT,                                            
P00740        ALLOW_EMAIL_FL,                                           
D09342        THIRD_PARTY_FL,                                           
A05317        SORT_ORDER                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-NAME-TYPE,                                            
               :S-NAME,                                                 
               :S-CONTACT-TYPE,                                         
               :S-CONTACT-SSN,                                          
               :S-CONTACT-DOB,                                          
               :S-CONTACT-DLN,                                          
               :S-CONTACT-OTHER-ID,                                     
               :S-CONTACT-TAX-ID,                                       
               :S-CONTACT-OTHER-ID-TYPE,                                
               :S-CONTACT-NICKNAME,                                     
               :S-REFUSED-SSN,                                          
               :S-NAME-COUNTER,                                         
               :S-CONTACT-TYPE-CD,                                      
               :S-PASSWORD,                                             
               :S-ID,                                                   
               :S-EMAIL-ADDRESS,                                        
               :S-NAME-FORMAT,                                          
               :S-CONTACT-DLN-STATE,                                    
A04671         :S-LAST-NAME,                                            
A04671         :S-FIRST-NAME,                                           
A04671         :S-MIDDLE-NAME,                                          
A04671         :S-NAME-SUFFIX,                                          
A04671         :S-DOB-VERIFIED,                                         
A04671         :S-DHR-FL,                                               
P00740         :S-ACCESS-LEVEL-CD,                                      
P00740         :S-VERIFY-SSN-FL,                                        
P00740         :S-ALLOW-CALL-FL,                                        
P00740         :S-MEMO-BILL-IND,                                        
P00740         :S-CONFIRM-FL,                                           
P00740         :S-EMAIL-CT,                                             
P00740         :S-CONTACT-ITIN,                                         
P00740         :S-ENTITY-IND,                                           
P00740         :S-PASSWORD-HINT,                                        
P00740         :S-ALLOW-EMAIL-FL,                                       
D09342         :S-3RD-PARTY-FL,                                         
A05317         :S-SORT-ORDER                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04285_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       NAME_TYPE,                                                        
MFA-TR*       NAME,                                                             
MFA-TR*       CONTACT_TYPE,                                                     
MFA-TR*       CONTACT_SSN,                                                      
MFA-TR*       CONTACT_DOB,                                                      
MFA-TR*       CONTACT_DLN,                                                      
MFA-TR*       CONTACT_OTHER_ID,                                                 
MFA-TR*       CONTACT_TAX_ID,                                                   
MFA-TR*       CONTACT_OTHER_ID_TYPE,                                            
MFA-TR*       CONTACT_NICKNAME,                                                 
MFA-TR*       REFUSED_SSN,                                                      
MFA-TR*       NAME_COUNTER,                                                     
MFA-TR*       CONTACT_TYPE_CD,                                                  
MFA-TR*       PASSWORD,                                                         
MFA-TR*       ID,                                                               
MFA-TR*       EMAIL_ADDRESS,                                                    
MFA-TR*       NAME_FORMAT,                                                      
MFA-TR*       CONTACT_DLN_STATE,                                                
MFA-TR*       LAST_NAME,                                                        
MFA-TR*       FIRST_NAME,                                                       
MFA-TR*       MIDDLE_NAME,                                                      
MFA-TR*       NAME_SUFFIX,                                                      
MFA-TR*       DOB_VERIFIED,                                                     
MFA-TR*       DHR_FL,                                                           
MFA-TR*       ACCESS_LEVEL_CD,                                                  
MFA-TR*       VERIFY_SSN_FL,                                                    
MFA-TR*       ALLOW_CALL_FL,                                                    
MFA-TR*       MEMO_BILL_IND,                                                    
MFA-TR*       CONFIRM_REQ_FL,                                                   
MFA-TR*       EMAIL_CT,                                                         
MFA-TR*       CONTACT_ITIN,                                                     
MFA-TR*       ENTITY_IND,                                                       
MFA-TR*       PASSWORD_HINT,                                                    
MFA-TR*       ALLOW_EMAIL_FL,                                                   
MFA-TR*       THIRD_PARTY_FL,                                                   
MFA-TR*       SORT_ORDER                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-NAME-TYPE,                                                    
MFA-TR*        :S-NAME,                                                         
MFA-TR*        :S-CONTACT-TYPE,                                                 
MFA-TR*        :S-CONTACT-SSN,                                                  
MFA-TR*        :S-CONTACT-DOB,                                                  
MFA-TR*        :S-CONTACT-DLN,                                                  
MFA-TR*        :S-CONTACT-OTHER-ID,                                             
MFA-TR*        :S-CONTACT-TAX-ID,                                               
MFA-TR*        :S-CONTACT-OTHER-ID-TYPE,                                        
MFA-TR*        :S-CONTACT-NICKNAME,                                             
MFA-TR*        :S-REFUSED-SSN,                                                  
MFA-TR*        :S-NAME-COUNTER,                                                 
MFA-TR*        :S-CONTACT-TYPE-CD,                                              
MFA-TR*        :S-PASSWORD,                                                     
MFA-TR*        :S-ID,                                                           
MFA-TR*        :S-EMAIL-ADDRESS,                                                
MFA-TR*        :S-NAME-FORMAT,                                                  
MFA-TR*        :S-CONTACT-DLN-STATE,                                            
MFA-TR*        :S-LAST-NAME,                                                    
MFA-TR*        :S-FIRST-NAME,                                                   
MFA-TR*        :S-MIDDLE-NAME,                                                  
MFA-TR*        :S-NAME-SUFFIX,                                                  
MFA-TR*        :S-DOB-VERIFIED,                                                 
MFA-TR*        :S-DHR-FL,                                                       
MFA-TR*        :S-ACCESS-LEVEL-CD,                                              
MFA-TR*        :S-VERIFY-SSN-FL,                                                
MFA-TR*        :S-ALLOW-CALL-FL,                                                
MFA-TR*        :S-MEMO-BILL-IND,                                                
MFA-TR*        :S-CONFIRM-FL,                                                   
MFA-TR*        :S-EMAIL-CT,                                                     
MFA-TR*        :S-CONTACT-ITIN,                                                 
MFA-TR*        :S-ENTITY-IND,                                                   
MFA-TR*        :S-PASSWORD-HINT,                                                
MFA-TR*        :S-ALLOW-EMAIL-FL,                                               
MFA-TR*        :S-3RD-PARTY-FL,                                                 
MFA-TR*        :S-SORT-ORDER                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8600'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04285_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04285_R2                            
             (                                                          
              RETURN_CODE,                                              
              PHONE_NAME_TYPE,                                          
              PHONE_NAME_COUNTER,                                       
              PHONE_TYPE,                                               
              PHONE_NO,                                                 
              PHONE_EXT,                                                
P00740        PHONE_MOBILE_FL,                                          
P00740        PHONE_MKT_FL,                                             
P00740        PHONE_MKT_DT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-PHONE-NAME-TYPE,                                      
               :S-PHONE-NAME-COUNTER,                                   
               :S-PHONE-TYPE,                                           
               :S-PHONE-NO,                                             
               :S-PHONE-EXT,                                            
P00740         :S-PHONE-MOBILE-FL,                                      
P00740         :S-PHONE-MKT-FL,                                         
P00740         :S-PHONE-MKT-DT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04285_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       PHONE_NAME_TYPE,                                                  
MFA-TR*       PHONE_NAME_COUNTER,                                               
MFA-TR*       PHONE_TYPE,                                                       
MFA-TR*       PHONE_NO,                                                         
MFA-TR*       PHONE_EXT,                                                        
MFA-TR*       PHONE_MOBILE_FL,                                                  
MFA-TR*       PHONE_MKT_FL,                                                     
MFA-TR*       PHONE_MKT_DT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-PHONE-NAME-TYPE,                                              
MFA-TR*        :S-PHONE-NAME-COUNTER,                                           
MFA-TR*        :S-PHONE-TYPE,                                                   
MFA-TR*        :S-PHONE-NO,                                                     
MFA-TR*        :S-PHONE-EXT,                                                    
MFA-TR*        :S-PHONE-MOBILE-FL,                                              
MFA-TR*        :S-PHONE-MKT-FL,                                                 
MFA-TR*        :S-PHONE-MKT-DT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8840'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04285_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
