       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04283.                                            
       DATE-WRITTEN. 05/15/12.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  SEARCH PROGRAM. SEARCH METHOD DETERMINES CURSOR USED. LIMITS  *        
      *  INDICATE IF OUTPUT IS LIMITED BY LOCAL OFFICE, COMPANY, CITY  *        
      *  STATE, OR DIVISION. FILTERS DETERMINE WHICH ACCOUNT STATUSES  *        
      *  WILL DISPLAY. DETAILED DATA CONTROLS WHICH RESULTS SET WILL   *        
      *  BE RETURNED. SEARCH CRITERIA CONTAINS DELIMITED DATA FOR      *        
      *  SPECIFIED SEARCH METHOD.                                      *        
      *  INPUT:                                                        *        
      *      LINK-SEARCH-METHOD                                        *        
      *      LINK-LIMITS                                               *        
      *      LINK-FILTERS                                              *        
      *      LINK-DETAILED-DATA                                        *        
      *      LINK-CRITERIA                                             *        
      *  OUTPUT:                                                       *        
      *      C1 - NON-ACCOUNT SEARCH SKINNY RESULTS SET                *        
      *      C2 - ACCOUNT SEARCH SKINNY RESULTS SET                    *        
      *      C3 - NON-ACCOUNT SEARCH WIDE RESULTS SET                  *        
      *      C4 - ACCOUNT SEARCH WIDE RESULTS SET                      *        
      *                                                                *        
      *  PERFORMANCE NOTES:                                            *        
      *  1.  ADDRESS FORMAT IS A HOST VARIABLE IN THE ADDRESS CURSORS  *        
      *      TO FORCE USE OF INDEX ON EXPRESSION FOR HOUSE # SORT.     *        
      *  2.  LOCATOR CURSOR MUST HAVE BETWEEN AND NOT IN LOGIC.        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/15/12    FMB      PROCEDURE ORIGINALLY CODED.              *        
A04671*  05/31/13    FMB      ADD ZIPCODE TO DETAILED RESULTS SET.     *        
A04671*  07/17/13    FMB      USE NAME_FORMAT TO DETERMINE WHICH NAME  *        
A04671*                       DATA SHOULD BE RETURNED.                 *        
P00778*  11/11/2013  SC41135  INCLUDE SEARCH BY AGL-PREM-NO                     
P00837*  02/15/16    FMB      INTERNAL ACCOUNT MANAGER SEARCH.                  
A05317*  03/01/16    FMB      ITIN SEARCH MODIFICATIONS.                        
A05317*  04/26/16    FMB      FIX SORTING ISSUES WITH ARTIFICIAL SORT           
A05317*                       FIELDS - ADDRESS, PENDING, UTILITY START.         
P00870*  06/27/16    FMB      REFUND CHECK NUMBER SEARCH.                       
A05317*  10/06/16    FMB      RETURN ALL ACCOUNT STATUSES FOR SO SEARCH         
A05317*  10/21/16    FMB      STATE CODE SHOULD NOT BE IN PARMS FOR DLN         
A05317*  01/03/17    FMB      RETURN THREE NEW COLUMNS IN C3 AND C4.            
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04283'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUMEQP                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBSCSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBXREF                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREHST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBLADRX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTIACTP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
P00837     EXEC SQL                                                             
P00837        INCLUDE TBCNTCCS                                                  
P00837     END-EXEC.                                                            
P00870     EXEC SQL                                                             
P00870        INCLUDE TBREFUND                                                  
P00870     END-EXEC.                                                            
A05317     EXEC SQL                                                             
A05317        INCLUDE TBATMISC                                                  
A05317     END-EXEC.                                                            
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04283_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR04283'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-SEARCH-METHOD           PIC X(3).                   
               88  SEL-METH-CUS             VALUE 'CUS'.                
               88  SEL-METH-ACC             VALUE 'ACC'.                
               88  SEL-METH-OTH             VALUE 'OTH'.                
               88  SEL-METH-MET             VALUE 'MET'.                
               88  SEL-METH-DLN             VALUE 'DLN'.                
               88  SEL-METH-SSN             VALUE 'SSN'.                
               88  SEL-METH-PHO             VALUE 'PHO'.                
               88  SEL-METH-POI             VALUE 'POI'.                
               88  SEL-METH-PIM             VALUE 'PIM'.                
               88  SEL-METH-TAX             VALUE 'TAX'.                
               88  SEL-METH-MAS             VALUE 'MAS'.                
               88  SEL-METH-NAM             VALUE 'NAM'.                
               88  SEL-METH-ADD             VALUE 'ADD'.                
               88  SEL-METH-LOC             VALUE 'LOC'.                
               88  SEL-METH-CUR             VALUE 'CUR'.                
               88  SEL-METH-SUB             VALUE 'SUB'.                
               88  SEL-METH-PMS             VALUE 'PMS'.                
               88  SEL-METH-SON             VALUE 'SON'.                
               88  SEL-METH-GAS             VALUE 'GAS'.                
               88  SEL-METH-LIG             VALUE 'LIG'.                
P00778         88  SEL-METH-AGP             VALUE 'AGP'.                
P00837         88  SEL-METH-MGR             VALUE 'MGR'.                
P00870         88  SEL-METH-REF             VALUE 'REF'.                
           05  PARM-LIMITS.                                             
               10  PARM-COMPANY-NO          PIC X(02).                  
               10  PARM-LOCAL-OFFICE        PIC X(03).                  
               10  PARM-CITY                PIC X(26).                  
               10  PARM-STATE               PIC X(02).                  
               10  PARM-DIVISION            PIC X(01).                  
           05  PARM-FILTERS.                                            
               10  PARM-ARCHIVE-FL          PIC X(01).                  
               10  PARM-ACTIVE-FL           PIC X(01).                  
               10  PARM-PENDING-FL          PIC X(01).                  
               10  PARM-FINAL-BILL-FL       PIC X(01).                  
               10  PARM-WRITE-OFF-FL        PIC X(01).                  
               10  PARM-INACTIVE-FL         PIC X(01).                  
           05  PARM-CRITERIA                PIC X(250).                 
                                                                        
       77  WS-BLO-LOT-SPACES                PIC X(05) VALUE SPACES.     
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE        PIC S9(9) COMP VALUE 0.             
           05  S-STATUS-CODE        PIC S9(9) COMP VALUE 0.             
           05  S-NAME               PIC X(76) VALUE SPACES.             
           05  S-ADDRESS            PIC X(80) VALUE SPACES.             
           05  S-CITY               PIC X(26) VALUE SPACES.             
           05  S-NAME-TYPE          PIC X(02) VALUE SPACES.             
           05  S-ACCT-TYPE          PIC X(01) VALUE SPACES.             
           05  S-ACCT-STATUS        PIC X(01) VALUE SPACES.             
           05  S-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE 0.         
           05  S-CUSTOMER-NO        PIC S9(10)V COMP-3 VALUE 0.         
           05  S-PREMISE-NO         PIC S9(10)V COMP-3 VALUE 0.         
           05  S-RED-FLAG-IND       PIC X(01) VALUE SPACES.             
           05  S-ARCHIVE-IND        PIC X(01) VALUE SPACES.             
           05  S-GROUP-CD           PIC X(09) VALUE SPACES.             
           05  S-UTIL-SVC-STRT      PIC X(10) VALUE SPACES.             
           05  S-UTIL-SVC-END       PIC X(10) VALUE SPACES.             
           05  S-REV-DISTRICT-CD    PIC X(03) VALUE SPACES.             
           05  S-SUBDIVISION-ID     PIC X(26) VALUE SPACES.             
           05  S-SERV-SUPPL         PIC X(03) VALUE SPACES.             
           05  S-SERV-AVAIL         PIC X(03) VALUE SPACES.             
           05  S-READ-CYCLE         PIC X(02) VALUE SPACES.             
           05  S-READ-ROUTE         PIC X(04) VALUE SPACES.             
           05  S-ELEC-RATE          PIC X(03) VALUE SPACES.             
           05  S-GAS-RATE           PIC X(03) VALUE SPACES.             
           05  S-UNMETER-RATE       PIC X(03) VALUE SPACES.             
           05  S-METER-NO           PIC X(09) VALUE SPACES.             
           05  S-METER-STATUS       PIC X(01) VALUE SPACES.             
           05  S-METER-LOC          PIC X(01) VALUE SPACES.             
           05  S-METER-READ-SEQ     PIC S9(9) COMP VALUE 0.             
           05  S-POINT-ID           PIC X(10) VALUE SPACES.             
           05  S-POLE-NO            PIC X(07) VALUE SPACES.             
           05  S-LIGHT-TYPE         PIC X(17) VALUE SPACES.             
           05  S-ACCT-SUB-TYPE      PIC X(30) VALUE SPACES.             
           05  S-BILL-CYCLE         PIC X(02) VALUE SPACES.             
           05  S-AGL-ACCT-NO        PIC X(20) VALUE SPACES.             
           05  S-OFFER-CODE         PIC X(65) VALUE SPACES.             
           05  S-OPTION-CODE        PIC X(255) VALUE SPACES.            
           05  S-CORE-RATE          PIC X(50) VALUE SPACES.             
A04671     05  S-ZIP-CODE           PIC X(05) VALUE SPACES.             
A05317     05  S-SORT-FIELD-1       PIC S9(4) COMP VALUE 0.             
A05317     05  S-SORT-FIELD-2       PIC X(01) VALUE SPACES.             
A05317     05  S-SORT-FIELD-3       PIC X(10) VALUE SPACES.             
A05317     05  S-CREDIT-GROUP       PIC X(01) VALUE SPACES.             
A05317     05  S-NAME-FORMAT        PIC X(01) VALUE SPACES.             
A05317     05  S-ACCOUNT-ID         PIC X(35) VALUE SPACES.             
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
       01  WS-PARM-CRITERIA.                                            
                                                                        
           05  WS-CUS-PARM-CRITERIA.                                    
               10  CUS-CUST-NO              PIC X(10).                  
               10  CUS-CUST-NO-NUM          REDEFINES CUS-CUST-NO       
                                            PIC 9(10).                  
                                                                        
           05  WS-ACC-PARM-CRITERIA.                                    
               10  ACC-ACCT-NO              PIC X(13)                   
                                            JUSTIFIED RIGHT.            
               10  ACC-ACCT-NO-NUM          REDEFINES ACC-ACCT-NO       
                                            PIC 9(13).                  
               10  ACC-OLD-ACCT-NO          PIC X(13)                   
                                            JUSTIFIED RIGHT.            
               10  ACC-OLD-ACCT-NO-NUM      REDEFINES ACC-OLD-ACCT-NO   
                                            PIC 9(13).                  
                                                                        
           05  WS-OTH-PARM-CRITERIA.                                    
               10  OTH-ID-NUMBER            PIC X(16).                  
               10  OTH-ID-TYPE              PIC X(12).                  
                                                                        
           05  WS-MET-PARM-CRITERIA.                                    
               10  MET-CODE-UTIL-TYPE       PIC X(1).                   
               10  MET-NUMBER               PIC X(9).                   
                                                                        
           05  WS-DLN-PARM-CRITERIA.                                    
               10  DLN-NUMBER               PIC X(19).                  
                                                                        
           05  WS-SSN-PARM-CRITERIA.                                    
               10  SSN-NUMBER               PIC X(9).                   
                                                                        
           05  WS-PHO-PARM-CRITERIA.                                    
               10  PHO-NUMBER               PIC X(10).                  
                                                                        
           05  WS-POI-PARM-CRITERIA.                                    
               10  POI-ID-NUMBER            PIC X(10).                  
                                                                        
                                                                        
           05  WS-TAX-PARM-CRITERIA.                                    
               10  TAX-ID-NUMBER            PIC X(09).                  
                                                                        
           05  WS-MAS-PARM-CRITERIA.                                    
               10  MAS-LAST-NAME            PIC X(40).                  
               10  MAS-FIRST-NAME           PIC X(15).                  
               10  MAS-MIDDLE-NAME          PIC X(15).                  
               10  MAS-BUSINESS-NAME        PIC X(50).                  
               10  MAS-ACCT-NO              PIC X(13).                  
               10  MAS-ACCT-NO-NUM          REDEFINES MAS-ACCT-NO       
                                            PIC 9(13).                  
                                                                        
           05  WS-NAM-PARM-CRITERIA.                                    
               10  NAM-LAST-NAME            PIC X(40).                  
               10  NAM-FIRST-NAME           PIC X(15).                  
               10  NAM-MIDDLE-NAME          PIC X(15).                  
               10  NAM-BUSINESS-NAME        PIC X(70).                  
               10  NAM-STREET-NAME          PIC X(30).                  
                                                                        
           05  WS-ADD-PARM-CRITERIA.                                    
               10  ADD-ADDRESS-TYPE         PIC X.                      
                   88  SERVICE-ADDRESS      VALUE 'S'.                  
                   88  BILLING-ADDRESS      VALUE 'B'.                  
                   88  INTERSECTION-ADDRESS VALUE 'I'.                  
               10  ADD-STREET-NBR           PIC X(15).                  
               10  ADD-PREFIX-1             PIC X(3).                   
               10  ADD-PREFIX-2             PIC X(2).                   
               10  ADD-STREET-NAME          PIC X(30).                  
               10  ADD-LOCATION-1           PIC X(4).                   
               10  ADD-LOCATION-2           PIC X(11).                  
               10  ADD-CITY                 PIC X(26).                  
               10  ADD-OVERFLOW             PIC X(35).                  
               10  ADD-BLOCK                PIC X(05).                  
               10  ADD-LOT                  PIC X(05).                  
                                                                        
           05  WS-LOC-PARM-CRITERIA.                                    
               10  LOC-ID-NUMBER            PIC X(9).                   
                                                                        
           05  WS-PRM-PARM-CRITERIA.                                    
               10  PREMISE-NUMBER           PIC X(10).                  
                                                                        
           05  WS-SUB-PARM-CRITERIA.                                    
               10  SUBDIVISION-ID           PIC X(03).                  
                                                                        
           05  WS-PMS-PARM-CRITERIA.                                    
               10  PMS-PREM-NO              PIC X(10).                  
               10  PMS-PREM-NO-NUM          REDEFINES PMS-PREM-NO       
                                            PIC 9(10).                  
                                                                        
           05  WS-SON-PARM-CRITERIA.                                    
               10  SON-ORDER-NO             PIC X(13).                  
               10  SON-ORDER-NO-NUM         REDEFINES SON-ORDER-NO      
                                            PIC 9(13).                  
                                                                        
P00778     05  WS-AGL-PARM-CRITERIA.                                    
P00778         10  PMS-AGL-PREM-NO          PIC X(9).                   
P00778         10  PMS-AGL-PREM-NUM         REDEFINES PMS-AGL-PREM-NO   
                                            PIC 9(9).                   
                                                                        
P00837     05  WS-MGR-PARM-CRITERIA.                                    
P00837         10  MGR-LAST-NAME            PIC X(40).                  
P00837         10  MGR-FIRST-NAME           PIC X(15).                  
                                                                        
P00870     05  WS-REF-PARM-CRITERIA.                                    
P00870         10  REF-CHECK-NO             PIC X(09).                  
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR04283'.  
           05  WS-CURRENT-TS                PIC X(26) VALUE SPACES.     
           05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
           05  WS-GTT01-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-GTT03-DECLARED            PIC X(01) VALUE 'N'.        
           05  WS-NAME                      PIC X(80) VALUE SPACES.     
           05  WS-ARCHIVE-IND               PIC X(01) VALUE SPACES.     
           05  WS-ADDRESS-FORMAT            PIC X(01) VALUE 'F'.        
           05  WS-ADDRESS                   PIC X(80).                  
           05  WS-RED-FLAG-TS               PIC X(26) VALUE SPACES.     
           05  WS-NEED-ADDRESS              PIC X VALUE 'N'.            
               88  NEED-ADDRESS             VALUE 'Y'.                  
               88  NEED-ADDRESS-NO          VALUE 'N'.                  
           05  WS-NEED-NAME                 PIC X VALUE 'N'.            
               88  NEED-NAME                VALUE 'Y'.                  
               88  NEED-NAME-NO             VALUE 'N'.                  
           05  WS-NEED-TOWN                 PIC X VALUE 'N'.            
               88  NEED-TOWN                VALUE 'Y'.                  
               88  NEED-TOWN-NO             VALUE 'N'.                  
           05  COMPANY-LIMIT                PIC X(2)  VALUE '%%'.       
           05  CITY-LIMIT                   PIC X(26) VALUE ALL '%'.    
           05  STATE-LIMIT                  PIC X(02) VALUE '%%'.       
           05  LOCAL-OFFICE-LIMIT           PIC X(03) VALUE '%%%'.      
           05  DIVISION-LIMIT               PIC X(01) VALUE '%'.        
           05  WS-NULL1                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL2                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL3                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL4                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL5                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL6                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL7                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL8                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL9                     PIC S9(04) COMP VALUE +0.   
           05  WS-NULL10                    PIC S9(04) COMP VALUE +0.   
           05  WS-NULL11                    PIC S9(04) COMP VALUE +0.   
           05  WS-NULL12                    PIC S9(04) COMP VALUE +0.   
           05  WS-ROW-COUNT                 PIC S9(04) COMP VALUE +50.  
           05  WS-NAME-FORMAT               PIC X.                      
           05  WS-GIS-LOC-OFF               PIC X(03) VALUE SPACES.     
           05  WS-TAG-NM                    PIC X(10) VALUE SPACES.     
           05  WS-TODAYS-DATE               PIC X(10).                  
           05  WS-ACTIVE-DHR                PIC X(01) VALUE ' '.        
           05  WS-PREPAY-ACCT               PIC X(01) VALUE ' '.        
           05  WS-ORIGINATION-CD            PIC X(01) VALUE SPACES.     
COB305     05 WS-HOLD-PREMISE-NO        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-HOLD-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-STAR-COUNT                PIC S9(02) COMP-3 VALUE 0.  
           05  WS-LOT-BLOCK                 PIC X(01) VALUE 'N'.        
           05  INT-STREET-NAME              PIC X(30) VALUE SPACES.     
           05  INT-OVERFLOW                 PIC X(35) VALUE SPACES.     
           05  WS-TOWN                      PIC X(26).                  
           05  WS-ROW-FOUND                 PIC X(01) VALUE 'N'.        
           05  WS-UNMTR-FOUND               PIC X(01) VALUE 'N'.        
           05  WS-ELEC-RATE                 PIC X(03) VALUE SPACES.     
           05  WS-LIGHT-RATE                PIC X(03) VALUE SPACES.     
           05  WS-SUBDIV-LIGHT              PIC X(01) VALUE 'N'.        
           05  LOC-ID-NUMBER-L              PIC X(9)  VALUE LOW-VALUE.  
           05  LOC-ID-NUMBER-H              PIC X(9)  VALUE HIGH-VALUE. 
           05  ADD-CITY-L                   PIC X(26) VALUE LOW-VALUE.  
           05  ADD-CITY-H                   PIC X(26) VALUE HIGH-VALUE. 
           05  WS-DATABASE                  PIC 9(01) VALUE 0.          
               88  CSR-DATABASE                       VALUE 1.          
               88  SEB-DATABASE                       VALUE 2.          
           05  WS-GROUP-CD                  PIC X(09) VALUE SPACES.     
A05317     05  WS-PREMISE-NO                PIC 9(10) VALUE ZEROES.     
A05317     05  WS-SORT-FIELD                PIC S9(4) COMP VALUE 0.     
                                                                        
       01  WS-NEXT-VARAIBLES.                                           
           05  WS-NEXT-COUNTER              PIC S9(4) COMP VALUE 1.     
           05  WS-MULTIPLIER                PIC X(02) VALUE '00'.       
           05  WS-NEXT-MULTIPLIER           REDEFINES WS-MULTIPLIER     
                                            PIC 9(2).                   
           05  WS-ROWS-PROCESSED            PIC 9(4)  VALUE 1.          
                                                                        
        01  WS-COMPRESSION-TABLES.                                      
            05  WS-EMB-INPUT.                                           
                10  WS-EMB-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-EMB-INDX.         
            05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +255.          
            05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
            05  WS-EMB-LAST-CHAR        PIC X(01).                      
            05  WS-CMP-TABLE.                                           
                10  WS-CMP-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-CMP-INDX.         
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 50.    
           05  CN-DELIMITER                 PIC X VALUE ';'.            
                                                                        
      ******************************************************************        
      *    DY-HT-CURSOR USED TO SEARCH FOR PREMISE ADDRESSES.          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-HT-CURSOR CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                        OR HT.NAME_ID = 0)                              
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-HT-CURSOR CURSOR FOR                             
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                 OR HT.NAME_ID = 0)                                      
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7211                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-HT-CURSOR-L USED TO SEARCH FOR PREMISE ADDRESSES WITH    *        
      *                   THE LOCAL OFFICE LIMIT.                      *        
      ******************************************************************        
           EXEC SQL DECLARE DY-HT-CURSOR-L CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-HT-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7201                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-HT-CURSOR-C USED TO SEARCH FOR PREMISE ADDRESSES WITH    *        
      *                   CITY/STATE LIMIT.                            *        
      ******************************************************************        
           EXEC SQL DECLARE DY-HT-CURSOR-C CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.TOWN  = :CITY-LIMIT                            
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-HT-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.TOWN  = :CITY-LIMIT                                    
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7204                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-PR-CURSOR USED TO SEARCH ON LOT AND BLOCK.    .          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-PR-CURSOR CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND PR.PREMISE_NO = HT.PREMISE_NO                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR CURSOR FOR                             
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND PR.PREMISE_NO = HT.PREMISE_NO                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7820                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-PR-CURSOR-L USED TO SEARCH ON LOT AND BLOCK WITH THE     *        
      *                   LOCAL OFFICE LIMIT.                          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-PR-CURSOR-L CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND PR.PREMISE_NO = HT.PREMISE_NO                     
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND PR.PREMISE_NO = HT.PREMISE_NO                             
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7207                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-PR-CURSOR-C USED TO SEARCH ON LOT AND BLOCK WITH THE     *        
      *                   CITY/STATE LIMIT.                            *        
      ******************************************************************        
           EXEC SQL DECLARE DY-PR-CURSOR-C CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND PR.PREMISE_NO = HT.PREMISE_NO                     
                  AND HT.TOWN = :CITY-LIMIT                             
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND PR.PREMISE_NO = HT.PREMISE_NO                             
MFA-TR*           AND HT.TOWN = :CITY-LIMIT                                     
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7227                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    INT-CURSOR USED TO SEARCH FOR INTERSECTION ADDRESSES.       *        
      ******************************************************************        
           EXEC SQL DECLARE INT-CURSOR CURSOR FOR                       
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(STREET_NAME) + ' & ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW)))),           
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE ((DY.STREET_NAME LIKE :ADD-STREET-NAME AND        
                       DY.ADDRESS_OVERFLOW LIKE :ADD-OVERFLOW) OR       
                      (DY.STREET_NAME LIKE :INT-STREET-NAME AND         
                       DY.ADDRESS_OVERFLOW LIKE :INT-OVERFLOW))         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME,                                   
                      DY.ADDRESS_ID                                     
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE INT-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' & ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDRESS_OVERFLOW)))),                   
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE ((DY.STREET_NAME LIKE :ADD-STREET-NAME AND                
MFA-TR*                DY.ADDRESS_OVERFLOW LIKE :ADD-OVERFLOW) OR               
MFA-TR*               (DY.STREET_NAME LIKE :INT-STREET-NAME AND                 
MFA-TR*                DY.ADDRESS_OVERFLOW LIKE :INT-OVERFLOW))                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7217                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    INT-CURSOR-L USED TO SEARCH FOR INTERSECTION ADDRESSES WITH *        
      *                 THE LOCAL OFFICE LIMIT.                        *        
      ******************************************************************        
           EXEC SQL DECLARE INT-CURSOR-L CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(STREET_NAME) + ' & ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW)))),           
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE ((DY.STREET_NAME LIKE :ADD-STREET-NAME AND        
                       DY.ADDRESS_OVERFLOW LIKE :ADD-OVERFLOW) OR       
                      (DY.STREET_NAME LIKE :INT-STREET-NAME AND         
                       DY.ADDRESS_OVERFLOW LIKE :INT-OVERFLOW))         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME,                                   
                      DY.ADDRESS_ID                                     
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE INT-CURSOR-L CURSOR FOR                             
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' & ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDRESS_OVERFLOW)))),                   
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE ((DY.STREET_NAME LIKE :ADD-STREET-NAME AND                
MFA-TR*                DY.ADDRESS_OVERFLOW LIKE :ADD-OVERFLOW) OR               
MFA-TR*               (DY.STREET_NAME LIKE :INT-STREET-NAME AND                 
MFA-TR*                DY.ADDRESS_OVERFLOW LIKE :INT-OVERFLOW))                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7234                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    INT-CURSOR-C USED TO SEARCH FOR INTERSECTION ADDRESSES WITH *        
      *                 THE CITY/STATE LIMIT.                          *        
      ******************************************************************        
           EXEC SQL DECLARE INT-CURSOR-C CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(STREET_NAME) + ' & ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW)))),           
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE ((DY.STREET_NAME LIKE :ADD-STREET-NAME AND        
                       DY.ADDRESS_OVERFLOW LIKE :ADD-OVERFLOW) OR       
                      (DY.STREET_NAME LIKE :INT-STREET-NAME AND         
                       DY.ADDRESS_OVERFLOW LIKE :INT-OVERFLOW))         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.TOWN = :CITY-LIMIT                             
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME,                                   
                      DY.ADDRESS_ID                                     
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE INT-CURSOR-C CURSOR FOR                             
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' & ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDRESS_OVERFLOW)))),                   
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE ((DY.STREET_NAME LIKE :ADD-STREET-NAME AND                
MFA-TR*                DY.ADDRESS_OVERFLOW LIKE :ADD-OVERFLOW) OR               
MFA-TR*               (DY.STREET_NAME LIKE :INT-STREET-NAME AND                 
MFA-TR*                DY.ADDRESS_OVERFLOW LIKE :INT-OVERFLOW))                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.TOWN = :CITY-LIMIT                                     
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7237                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-AQ-CURSOR USED TO SEARCH FOR BILLING ADDRESSES.          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-AQ-CURSOR CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.ADDRESS_ID,                                    
                      RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) + ' ' + LTRIM(
           RTRIM(DY.ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(DY.ADDR_PREFIX_2
           ) + ' ' + LTRIM(RTRIM(DY.STREET_NAME) + ' ' + LTRIM(RTRIM(
           DY.STREET_SUFFIX) + ' ' + LTRIM(RTRIM(DY.ADDR_SUFFIX) + 
           ' ' + LTRIM(RTRIM(DY.STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           DY.STREET_LOCATION_2)))))))))) ,
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N'                                               
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_BILL_ADDR_XREF AQ WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = AQ.ADDRESS_ID                     
                  AND AQ.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-AQ-CURSOR CURSOR FOR                             
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.ADDRESS_ID,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_PREFIX_1) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_PREFIX_2) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.STREET_NAME) || ' ' ||               
MFA-TR*                     LTRIM(RTRIM(DY.STREET_SUFFIX) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_SUFFIX) || ' ' ||               
MFA-TR*                     LTRIM(RTRIM(DY.STREET_LOCATION_1) || ' '  ||        
MFA-TR*                     LTRIM(RTRIM(DY.STREET_LOCATION_2)))))))))) ,        
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N'                                                       
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_BILL_ADDR_XREF AQ                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = AQ.ADDRESS_ID                             
MFA-TR*           AND AQ.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7214                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-AQ-CURSOR-L USED TO SEARCH FOR BILLING ADDRESSES WITH    *        
      *                   THE LOCAL OFFICE LIMIT.                      *        
      ******************************************************************        
           EXEC SQL DECLARE DY-AQ-CURSOR-L CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.ADDRESS_ID,                                    
                      RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) + ' ' + LTRIM(
           RTRIM(DY.ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(DY.ADDR_PREFIX_2
           ) + ' ' + LTRIM(RTRIM(DY.STREET_NAME) + ' ' + LTRIM(RTRIM(
           DY.STREET_SUFFIX) + ' ' + LTRIM(RTRIM(DY.ADDR_SUFFIX) + 
           ' ' + LTRIM(RTRIM(DY.STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           DY.STREET_LOCATION_2)))))))))) ,
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N'                                               
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_BILL_ADDR_XREF AQ WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = AQ.ADDRESS_ID                     
                  AND AQ.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-AQ-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.ADDRESS_ID,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_PREFIX_1) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_PREFIX_2) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.STREET_NAME) || ' ' ||               
MFA-TR*                     LTRIM(RTRIM(DY.STREET_SUFFIX) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_SUFFIX) || ' ' ||               
MFA-TR*                     LTRIM(RTRIM(DY.STREET_LOCATION_1) || ' '  ||        
MFA-TR*                     LTRIM(RTRIM(DY.STREET_LOCATION_2)))))))))) ,        
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N'                                                       
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_BILL_ADDR_XREF AQ                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = AQ.ADDRESS_ID                             
MFA-TR*           AND AQ.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7244                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-AQ-CURSOR-C USED TO SEARCH FOR BILLING ADDRESSES WITH    *        
      *                   THE CITY/STATE LIMIT.                        *        
      ******************************************************************        
           EXEC SQL DECLARE DY-AQ-CURSOR-C CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.ADDRESS_ID,                                    
                      RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) + ' ' + LTRIM(
           RTRIM(DY.ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(DY.ADDR_PREFIX_2
           ) + ' ' + LTRIM(RTRIM(DY.STREET_NAME) + ' ' + LTRIM(RTRIM(
           DY.STREET_SUFFIX) + ' ' + LTRIM(RTRIM(DY.ADDR_SUFFIX) + 
           ' ' + LTRIM(RTRIM(DY.STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           DY.STREET_LOCATION_2)))))))))) ,
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N'                                               
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_BILL_ADDR_XREF AQ WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = AQ.ADDRESS_ID                     
                  AND AQ.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
                  AND HT.TOWN = :CITY-LIMIT                             
                  AND HT.STATE = :STATE-LIMIT                           
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-AQ-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.ADDRESS_ID,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(DY.HOUSE_NO) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_PREFIX_1) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_PREFIX_2) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.STREET_NAME) || ' ' ||               
MFA-TR*                     LTRIM(RTRIM(DY.STREET_SUFFIX) || ' ' ||             
MFA-TR*                     LTRIM(RTRIM(DY.ADDR_SUFFIX) || ' ' ||               
MFA-TR*                     LTRIM(RTRIM(DY.STREET_LOCATION_1) || ' '  ||        
MFA-TR*                     LTRIM(RTRIM(DY.STREET_LOCATION_2)))))))))) ,        
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N'                                                       
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_BILL_ADDR_XREF AQ                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = AQ.ADDRESS_ID                             
MFA-TR*           AND AQ.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*           AND HT.TOWN = :CITY-LIMIT                                     
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7247                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-IND-CURSOR USED TO SEARCH FOR INDIVIDUAL'S NAMES.        *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-IND-CURSOR CURSOR FOR                    
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
                      RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + RTRIM(
           DQ.TITLE_SUFFIX_1))),                       
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                  
                  AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                
                  AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME              
                  AND DQ.NAME_FORMAT = 'I'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
             ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME       
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DQ-IND-CURSOR CURSOR FOR                            
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||                
MFA-TR*               RTRIM(DQ.FIRST_NAME) || ' ' ||                            
MFA-TR*               RTRIM(DQ.MIDDLE_NAME) || ' ' ||                           
MFA-TR*               RTRIM(DQ.TITLE_SUFFIX_1))),                               
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                          
MFA-TR*           AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                        
MFA-TR*           AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'I'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*      ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME               
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7221                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-IND-CURSOR-S USED TO SEARCH FOR INDIVIDUAL'S NAMES       *        
      *                    WITH A PRIMARY STREET NAME.                 *        
      ******************************************************************        
      *   THE CONCATENATION ON LAST NAME FORCES INDEX USAGE            *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-IND-CURSOR-S CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
                      RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + RTRIM(
           DQ.TITLE_SUFFIX_1))),                       
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME + ''            
                  AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                
                  AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME              
                  AND DQ.NAME_FORMAT  = 'I'                             
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID  = DQ.NAME_ID                          
                  AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.STREET_NAME = :NAM-STREET-NAME                 
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
             ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME       
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DQ-IND-CURSOR-S CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||                
MFA-TR*               RTRIM(DQ.FIRST_NAME) || ' ' ||                            
MFA-TR*               RTRIM(DQ.MIDDLE_NAME) || ' ' ||                           
MFA-TR*               RTRIM(DQ.TITLE_SUFFIX_1))),                               
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME || ''                    
MFA-TR*           AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                        
MFA-TR*           AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT  = 'I'                                     
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID  = DQ.NAME_ID                                  
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.STREET_NAME = :NAM-STREET-NAME                         
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*      ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME               
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7328                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-IND-CURSOR-L USED TO SEARCH FOR INDIVIDUAL'S NAMES WITH  *        
      *                    THE LOCAL OFFICE LIMIT.                     *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-IND-CURSOR-L CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
                      RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + RTRIM(
           DQ.TITLE_SUFFIX_1))),                       
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                  
                  AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                
                  AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME              
                  AND DQ.NAME_FORMAT = 'I'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
             ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME       
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DQ-IND-CURSOR-L CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||                
MFA-TR*               RTRIM(DQ.FIRST_NAME) || ' ' ||                            
MFA-TR*               RTRIM(DQ.MIDDLE_NAME) || ' ' ||                           
MFA-TR*               RTRIM(DQ.TITLE_SUFFIX_1))),                               
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                          
MFA-TR*           AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                        
MFA-TR*           AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'I'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*      ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME               
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7254                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-IND-CURSOR-SL USED TO SEARCH FOR INDIVIDUAL'S NAMES WITH *        
      *                THE LOCAL OFFICE LIMIT AND PRIMARY STREET NAME. *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-IND-CURSOR-SL CURSOR FOR                 
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
                      RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + RTRIM(
           DQ.TITLE_SUFFIX_1))),                       
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                  
                  AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                
                  AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME              
                  AND DQ.NAME_FORMAT = 'I'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.STREET_NAME = :NAM-STREET-NAME                 
             ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME       
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DQ-IND-CURSOR-SL CURSOR FOR                         
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||                
MFA-TR*               RTRIM(DQ.FIRST_NAME) || ' ' ||                            
MFA-TR*               RTRIM(DQ.MIDDLE_NAME) || ' ' ||                           
MFA-TR*               RTRIM(DQ.TITLE_SUFFIX_1))),                               
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME           DQ,                                    
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                          
MFA-TR*           AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                        
MFA-TR*           AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'I'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.STREET_NAME = :NAM-STREET-NAME                         
MFA-TR*      ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME               
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7313                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-IND-CURSOR-C USED TO SEARCH FOR INDIVIDUAL'S NAMES WITH  *        
      *                    THE CITY/STATE LIMIT.                       *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-IND-CURSOR-C CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
                      RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + RTRIM(
           DQ.TITLE_SUFFIX_1))),                       
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                  
                  AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                
                  AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME              
                  AND DQ.NAME_FORMAT = 'I'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.TOWN = :CITY-LIMIT                             
                  AND HT.STATE = :STATE-LIMIT                           
             ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME       
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DQ-IND-CURSOR-C CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||                
MFA-TR*               RTRIM(DQ.FIRST_NAME) || ' ' ||                            
MFA-TR*               RTRIM(DQ.MIDDLE_NAME) || ' ' ||                           
MFA-TR*               RTRIM(DQ.TITLE_SUFFIX_1))),                               
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME           DQ,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                          
MFA-TR*           AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                        
MFA-TR*           AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'I'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.TOWN = :CITY-LIMIT                                     
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*      ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME               
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7257                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-IND-CURSOR-SC USED TO SEARCH FOR INDIVIDUAL'S NAMES WITH *        
      *                   THE CITY/STATE LIMIT AND PRIMARY STREET NAME.*        
      ******************************************************************        
           EXEC SQL DECLARE DQ-IND-CURSOR-SC CURSOR FOR                 
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
                      RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + RTRIM(
           DQ.TITLE_SUFFIX_1))),                       
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                  
                  AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                
                  AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME              
                  AND DQ.NAME_FORMAT = 'I'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.STREET_NAME = :NAM-STREET-NAME                 
                  AND HT.TOWN = :CITY-LIMIT                             
                  AND HT.STATE = :STATE-LIMIT                           
             ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME       
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DQ-IND-CURSOR-SC CURSOR FOR                         
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||                
MFA-TR*               RTRIM(DQ.FIRST_NAME) || ' ' ||                            
MFA-TR*               RTRIM(DQ.MIDDLE_NAME) || ' ' ||                           
MFA-TR*               RTRIM(DQ.TITLE_SUFFIX_1))),                               
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME           DQ,                                    
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.LAST_NAME LIKE :NAM-LAST-NAME                          
MFA-TR*           AND DQ.FIRST_NAME LIKE :NAM-FIRST-NAME                        
MFA-TR*           AND DQ.MIDDLE_NAME LIKE :NAM-MIDDLE-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'I'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.STREET_NAME = :NAM-STREET-NAME                         
MFA-TR*           AND HT.TOWN = :CITY-LIMIT                                     
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*      ORDER BY DQ.LAST_NAME, DQ.FIRST_NAME, DQ.MIDDLE_NAME               
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-BUS-CURSOR USED TO SEARCH FOR BUSINESS'S NAME.           *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-BUS-CURSOR CURSOR FOR                    
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.FULL_NAME,                                     
                      DQ.NAME_TYPE,                                     
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME              
                  AND DQ.NAME_FORMAT = 'B'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
             ORDER BY DQ.FULL_NAME                                      
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DQ-BUS-CURSOR CURSOR FOR                            
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'B'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*      ORDER BY DQ.FULL_NAME                                              
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7224                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-BUS-CURSOR-S USED TO SEARCH FOR BUSINESS'S NAME WITH     *        
      *                    A PRIMARY STREET NAME.                      *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-BUS-CURSOR-S CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.FULL_NAME,                                     
                      DQ.NAME_TYPE,                                     
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME              
                  AND DQ.NAME_FORMAT = 'B'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.STREET_NAME = :NAM-STREET-NAME                 
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
             ORDER BY DQ.FULL_NAME                                      
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DQ-BUS-CURSOR-S CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME           DQ,                                    
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'B'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.STREET_NAME = :NAM-STREET-NAME                         
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*      ORDER BY DQ.FULL_NAME                                              
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7316                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-BUS-CURSOR-L USED TO SEARCH FOR BUSINESS'S NAME WITH     *        
      *                    THE LOCAL OFFICE LIMIT.                     *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-BUS-CURSOR-L CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.FULL_NAME,                                     
                      DQ.NAME_TYPE,                                     
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME              
                  AND DQ.NAME_FORMAT = 'B'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
             ORDER BY DQ.FULL_NAME                                      
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DQ-BUS-CURSOR-L CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'B'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*      ORDER BY DQ.FULL_NAME                                              
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7264                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-BUS-CURSOR-SL USED TO SEARCH FOR BUSINESS'S NAME WITH    *        
      *                 THE LOCAL OFFICE LIMIT AND PRIMARY STREET NAME.*        
      ******************************************************************        
           EXEC SQL DECLARE DQ-BUS-CURSOR-SL CURSOR FOR                 
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.FULL_NAME,                                     
                      DQ.NAME_TYPE,                                     
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME              
                  AND DQ.NAME_FORMAT = 'B'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.STREET_NAME = :NAM-STREET-NAME                 
             ORDER BY DQ.FULL_NAME                                      
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DQ-BUS-CURSOR-SL CURSOR FOR                         
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'B'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.STREET_NAME = :NAM-STREET-NAME                         
MFA-TR*      ORDER BY DQ.FULL_NAME                                              
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7316                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-BUS-CURSOR-C USED TO SEARCH FOR BUSINESS'S NAME WITH     *        
      *                    THE CITY/STATE LIMIT.                       *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-BUS-CURSOR-C CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.FULL_NAME,                                     
                      DQ.NAME_TYPE,                                     
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME              
                  AND DQ.NAME_FORMAT = 'B'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.TOWN = :CITY-LIMIT                             
                  AND HT.STATE = :STATE-LIMIT                           
             ORDER BY DQ.FULL_NAME                                      
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DQ-BUS-CURSOR-C CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME           DQ,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'B'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.TOWN = :CITY-LIMIT                                     
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*      ORDER BY DQ.FULL_NAME                                              
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7267                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ-BUS-CURSOR-SC USED TO SEARCH FOR BUSINESS'S NAME WITH    *        
      *                 THE CITY/STATE LIMIT AND PRIMARY STREET NAME.  *        
      ******************************************************************        
           EXEC SQL DECLARE DQ-BUS-CURSOR-SC CURSOR FOR                 
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.FULL_NAME,                                     
                      DQ.NAME_TYPE,                                     
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME              
                  AND DQ.NAME_FORMAT = 'B'                              
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND HT.TOWN = :CITY-LIMIT                             
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.STREET_NAME = :NAM-STREET-NAME                 
             ORDER BY DQ.FULL_NAME                                      
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DQ-BUS-CURSOR-SC CURSOR FOR                         
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME           DQ,                                    
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FULL_NAME LIKE :NAM-BUSINESS-NAME                      
MFA-TR*           AND DQ.NAME_FORMAT = 'B'                                      
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND HT.TOWN = :CITY-LIMIT                                     
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND DY.STREET_NAME = :NAM-STREET-NAME                         
MFA-TR*      ORDER BY DQ.FULL_NAME                                              
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7319                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CE1-CURSOR IS USED TO SEARCH FOR SOCIAL SECURITY NUMBERS             
      ******************************************************************        
           EXEC SQL DECLARE CE1-CURSOR CURSOR FOR                       
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE CE.SSN = :SSN-NUMBER                              
                  AND CE.NAME_ID = HT.NAME_ID                           
             ORDER BY 1, 2                                              
             FOR READ ONLY                                             
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CE1-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE CE.SSN = :SSN-NUMBER                                      
MFA-TR*           AND CE.NAME_ID = HT.NAME_ID                                   
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 72511                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CE2-CURSOR USED TO SEARCH FOR DRIVER'S LICENSE NUMBER                
      ******************************************************************        
           EXEC SQL DECLARE CE2-CURSOR CURSOR FOR                       
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE CE.DRIVERS_LICENSE_NO = :DLN-NUMBER               
                  AND CE.NAME_ID = HT.NAME_ID                           
             ORDER BY 1, 2                                              
             FOR READ ONLY                                             
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CE2-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE CE.DRIVERS_LICENSE_NO = :DLN-NUMBER                       
MFA-TR*           AND CE.NAME_ID = HT.NAME_ID                                   
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 72512                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CE3-CURSOR USED TO SEARCH FOR OTHER ID NUMBER                        
      ******************************************************************        
           EXEC SQL DECLARE CE3-CURSOR CURSOR FOR                       
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE CE.OTHER_ID = :OTH-ID-NUMBER                      
                  AND CE.OTHER_ID_TYPE = :OTH-ID-TYPE                   
                  AND CE.NAME_ID = HT.NAME_ID                           
             ORDER BY 1, 2                                              
             FOR READ ONLY                                             
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CE3-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE CE.OTHER_ID = :OTH-ID-NUMBER                              
MFA-TR*           AND CE.OTHER_ID_TYPE = :OTH-ID-TYPE                           
MFA-TR*           AND CE.NAME_ID = HT.NAME_ID                                   
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 72513                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
A05317******************************************************************        
A05317*    CE4-CURSOR USED TO SEARCH FOR ITIN                                   
A05317******************************************************************        
A05317     EXEC SQL DECLARE CE4-CURSOR CURSOR FOR                       
A05317         SELECT HT.CUSTOMER_NO,                                   
A05317                HT.ACCOUNT_NO,                                    
A05317                HT.PREMISE_NO,                                    
A05317                HT.ADDRESS_ID,                                    
A05317                HT.NAME_ID,                                       
A05317                HT.CUSTOMER_ROLE_CD,                              
A05317                HT.COMPANY_NO,                                    
A05317                HT.ACCOUNT_TYPE_CODE,                             
A05317                HT.CODE_ACCT_STAT,                                
A05317                CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
A05317                      'Y' ELSE 'N' END                            
A05317           FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
A05317                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
A05317          WHERE CE.ITIN_ID = :OTH-ID-NUMBER                       
A05317            AND CE.NAME_ID = HT.NAME_ID                           
A05317       ORDER BY 1, 2                                              
A05317       FOR READ ONLY                                             
A05317                                                           
A05317                                                     
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CE4-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE CE.ITIN_ID = :OTH-ID-NUMBER                               
MFA-TR*           AND CE.NAME_ID = HT.NAME_ID                                   
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 72514                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    AT-CURSOR USED TO SEARCH FOR ACCOUNT NUMBER.                *        
      ******************************************************************        
           EXEC SQL DECLARE AT-CURSOR CURSOR FOR                        
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
A04671                CASE WHEN NAME_FORMAT = 'I' THEN                  
                              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + 
           RTRIM(DQ.TITLE_SUFFIX_1)))                
                           ELSE FULL_NAME END,                          
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE AT-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME) || ' ' ||                   
MFA-TR*                       RTRIM(DQ.TITLE_SUFFIX_1)))                        
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                            
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7231                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    XR-CURSOR USED TO SEARCH FOR THE OLD ACCOUNT NUMBER.        *        
      ******************************************************************        
           EXEC SQL DECLARE XR-CURSOR CURSOR FOR                        
               SELECT NEW_ACCOUNT_NO                                    
                 FROM CSS_XREF_ACCT WITH(READUNCOMMITTED)                       
                WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO               
                  FOR READ ONLY                                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE XR-CURSOR CURSOR FOR                                
MFA-TR*        SELECT NEW_ACCOUNT_NO                                            
MFA-TR*          FROM CSS_XREF_ACCT                                             
MFA-TR*         WHERE OLD_ACCOUNT_NO = :XR-OLD-ACCOUNT-NO                       
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CU-CURSOR USED TO SEARCH FOR CUSTOMER NUMBER.               *        
      ******************************************************************        
           EXEC SQL DECLARE CU-CURSOR CURSOR FOR                        
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
A04671                CASE WHEN NAME_FORMAT = 'I' THEN                  
                              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + 
           RTRIM(DQ.TITLE_SUFFIX_1)))                
                           ELSE FULL_NAME END,                          
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                  
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')            
             ORDER BY 1, 2                                              
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE CU-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME) || ' ' ||                   
MFA-TR*                       RTRIM(DQ.TITLE_SUFFIX_1)))                        
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                          
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE NOT IN ('AN', 'AA', 'AI')                    
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7241                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    PR-CURSOR USED TO SEARCH FOR POINT IDS                      *        
      ******************************************************************        
           EXEC SQL DECLARE PR-CURSOR CURSOR FOR                        
              SELECT  DISTINCT                                          
                      HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
A04671                CASE WHEN NAME_FORMAT = 'I' THEN                  
                              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + 
           RTRIM(DQ.TITLE_SUFFIX_1)))                
                           ELSE FULL_NAME END,                          
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N'                                               
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_PIM_POINT PP WITH(READUNCOMMITTED)                    
                WHERE PP.AREA_ID = :WS-GIS-LOC-OFF                      
                  AND PP.TAG_NM = :WS-TAG-NM                            
                  AND MN.GIS_POINT_ID = PP.POINT_ID                     
                  AND MN.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
             ORDER BY 1, 2                                              
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE PR-CURSOR CURSOR FOR                                
MFA-TR*       SELECT  DISTINCT                                                  
MFA-TR*               HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME) || ' ' ||                   
MFA-TR*                       RTRIM(DQ.TITLE_SUFFIX_1)))                        
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N'                                                       
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_PIM_POINT PP                                          
MFA-TR*         WHERE PP.AREA_ID = :WS-GIS-LOC-OFF                              
MFA-TR*           AND PP.TAG_NM = :WS-TAG-NM                                    
MFA-TR*           AND MN.GIS_POINT_ID = PP.POINT_ID                             
MFA-TR*           AND MN.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7291                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    LO-CURSOR USED TO SEARCH FOR LOCATOR ID'S.                  *        
      ******************************************************************        
           EXEC SQL DECLARE LO-CURSOR CURSOR FOR                        
              SELECT  DISTINCT                                          
                      HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE PR.LOCATOR_ID BETWEEN :LOC-ID-NUMBER-L            
                                        AND :LOC-ID-NUMBER-H            
                  AND PR.LOCATOR_ID <> '         '                      
                  AND PR.PREMISE_NO = HT.PREMISE_NO                     
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
             ORDER BY HT.CUSTOMER_NO                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE LO-CURSOR CURSOR FOR                                
MFA-TR*       SELECT  DISTINCT                                                  
MFA-TR*               HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE PR.LOCATOR_ID BETWEEN :LOC-ID-NUMBER-L                    
MFA-TR*                                 AND :LOC-ID-NUMBER-H                    
MFA-TR*           AND PR.LOCATOR_ID <> '         '                              
MFA-TR*           AND PR.PREMISE_NO = HT.PREMISE_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*      ORDER BY HT.CUSTOMER_NO                                            
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7307                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    BS-CURSOR USED TO SEARCH FOR TAX ID NUMBERS.                *        
      ******************************************************************        
           EXEC SQL DECLARE BS-CURSOR CURSOR FOR                        
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
A04671                CASE WHEN NAME_FORMAT = 'I' THEN                  
                              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + 
           RTRIM(DQ.TITLE_SUFFIX_1)))                
                           ELSE FULL_NAME END,                          
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_BUS_CUST_STATS BS WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE BS.TAX_ID = :TAX-ID-NUMBER                        
                  AND BS.CUSTOMER_NO = HT.CUSTOMER_NO                   
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
             ORDER BY 1, 2                                              
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE BS-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME) || ' ' ||                   
MFA-TR*                       RTRIM(DQ.TITLE_SUFFIX_1)))                        
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_BUS_CUST_STATS BS,                                    
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE BS.TAX_ID = :TAX-ID-NUMBER                                
MFA-TR*           AND BS.CUSTOMER_NO = HT.CUSTOMER_NO                           
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7271                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CB-CURSOR USED TO SEARCH FOR PHONE NUMBERS.                 *        
      ******************************************************************        
           EXEC SQL DECLARE CB-CURSOR CURSOR FOR                        
               SELECT DISTINCT(HT.CUSTOMER_NO),                         
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
A04671                CASE WHEN NAME_FORMAT = 'I' THEN                  
                              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + 
           RTRIM(DQ.TITLE_SUFFIX_1)))                
                           ELSE FULL_NAME END,                          
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_CUST_PHONE CB WITH(READUNCOMMITTED),                  
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE CB.PHONE_NO = :PHO-NUMBER                         
                  AND CB.CUSTOMER_NO = HT.CUSTOMER_NO                   
                  AND CB.PHONE_TYPE IN ('H1','B1','W1','A1')            
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
               UNION                                                    
               SELECT DISTINCT(HT.CUSTOMER_NO),                         
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
A04671                CASE WHEN NAME_FORMAT = 'I' THEN                  
                              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME)))                
                           ELSE FULL_NAME END,                          
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N'                                               
                 FROM CSS_CONTACT_PHONE LP WITH(READUNCOMMITTED),               
                      CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE PHONE_NO = :PHO-NUMBER                            
                  AND LP.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.CONTACT_TYPE = 'OC'                            
                  AND CV.CONTACT_ID = DW.CONTACT_ID                     
                  AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
             ORDER BY 1, 2                                              
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE CB-CURSOR CURSOR FOR                                
MFA-TR*        SELECT DISTINCT(HT.CUSTOMER_NO),                                 
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME) || ' ' ||                   
MFA-TR*                       RTRIM(DQ.TITLE_SUFFIX_1)))                        
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_CUST_PHONE CB,                                        
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE CB.PHONE_NO = :PHO-NUMBER                                 
MFA-TR*           AND CB.CUSTOMER_NO = HT.CUSTOMER_NO                           
MFA-TR*           AND CB.PHONE_TYPE IN ('H1','B1','W1','A1')                    
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*        UNION                                                            
MFA-TR*        SELECT DISTINCT(HT.CUSTOMER_NO),                                 
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME)))                           
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N'                                                       
MFA-TR*          FROM CSS_CONTACT_PHONE LP,                                     
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE PHONE_NO = :PHO-NUMBER                                    
MFA-TR*           AND LP.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.CONTACT_TYPE = 'OC'                                    
MFA-TR*           AND CV.CONTACT_ID = DW.CONTACT_ID                             
MFA-TR*           AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7261                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    MT-CURSOR USED TO SEARCH BY METER NUMBER.                   *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE MT-CURSOR CURSOR FOR                                
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DQ.NAME_TYPE,                                     
A04671                CASE WHEN NAME_FORMAT = 'I' THEN                  
                              RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + 
           RTRIM(DQ.TITLE_SUFFIX_1)))                
                           ELSE FULL_NAME END,                          
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE MN.METER_NO = :MET-NUMBER                         
                  AND MN.CODE_UTIL_TYPE = :MET-CODE-UTIL-TYPE           
                  AND MN.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND HT.CUSTOMER_ROLE_CD  = ' '                        
             ORDER BY 2                                                 
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE MT-CURSOR CURSOR FOR                                        
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME) || ' ' ||                   
MFA-TR*                       RTRIM(DQ.TITLE_SUFFIX_1)))                        
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE MN.METER_NO = :MET-NUMBER                                 
MFA-TR*           AND MN.CODE_UTIL_TYPE = :MET-CODE-UTIL-TYPE                   
MFA-TR*           AND MN.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      ORDER BY 2                                                         
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7297                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUB-CURSOR USED TO SEARCH BY SUBDIVISION                    *        
      ******************************************************************        
           EXEC SQL DECLARE SUB-CURSOR CURSOR FOR                       
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE PR.SUBDIVISION_ID = :SUBDIVISION-ID               
                  AND PR.PREMISE_NO = HT.PREMISE_NO                     
                  AND HT.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                        OR HT.NAME_ID = 0)                              
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE SUB-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE PR.SUBDIVISION_ID = :SUBDIVISION-ID                       
MFA-TR*           AND PR.PREMISE_NO = HT.PREMISE_NO                             
MFA-TR*           AND HT.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                 OR HT.NAME_ID = 0)                                      
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7359                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    PMS-CURSOR USED TO SEARCH FOR PREMISE NO.                   *        
      ******************************************************************        
           EXEC SQL DECLARE PMS-CURSOR CURSOR FOR                       
              SELECT  HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      DATE_UTIL_SVC_STRT,                               
                      DATE_UTIL_SVC_END                                 
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                      LEFT OUTER JOIN CSS_CUST_PREM_HIST CH
                           WITH(READUNCOMMITTED)             
                           ON HT.ACCOUNT_NO = CH.ACCOUNT_NO             
                          AND HT.PREMISE_NO = CH.PREMISE_NO             
                WHERE HT.PREMISE_NO = :HT-PREMISE-NO                    
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY CH.DATE_UTIL_SVC_STRT DESC,                       
                      CH.DATE_UTIL_SVC_END DESC                         
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PMS-CURSOR CURSOR FOR                               
MFA-TR*       SELECT  HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               DATE_UTIL_SVC_STRT,                                       
MFA-TR*               DATE_UTIL_SVC_END                                         
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT                                     
MFA-TR*               LEFT OUTER JOIN CSS_CUST_PREM_HIST CH                     
MFA-TR*                    ON HT.ACCOUNT_NO = CH.ACCOUNT_NO                     
MFA-TR*                   AND HT.PREMISE_NO = CH.PREMISE_NO                     
MFA-TR*         WHERE HT.PREMISE_NO = :HT-PREMISE-NO                            
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY CH.DATE_UTIL_SVC_STRT DESC,                               
MFA-TR*               CH.DATE_UTIL_SVC_END DESC                                 
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7362                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
P00778******************************************************************        
P00778*    AGL-PMS-CURSOR USED TO SEARCH FOR AGL PREM NO.              *        
P00778******************************************************************        
           EXEC SQL DECLARE AGL-PMS-CURSOR CURSOR FOR                   
              SELECT  HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
                            'Y' ELSE 'N' END,                           
                      DATE_UTIL_SVC_STRT,                               
                      DATE_UTIL_SVC_END                                 
                 FROM                                                   
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                      LEFT OUTER JOIN CSS_CUST_PREM_HIST CH
                           WITH(READUNCOMMITTED)             
                           ON HT.ACCOUNT_NO = CH.ACCOUNT_NO             
                          AND HT.PREMISE_NO = CH.PREMISE_NO             
                WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                  
                  AND PR.PREMISE_NO = HT.PREMISE_NO                     
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY CH.DATE_UTIL_SVC_STRT DESC,                       
                      CH.DATE_UTIL_SVC_END DESC                         
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE AGL-PMS-CURSOR CURSOR FOR                           
MFA-TR*       SELECT  HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END,                                   
MFA-TR*               DATE_UTIL_SVC_STRT,                                       
MFA-TR*               DATE_UTIL_SVC_END                                         
MFA-TR*          FROM                                                           
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*               LEFT OUTER JOIN CSS_CUST_PREM_HIST CH                     
MFA-TR*                    ON HT.ACCOUNT_NO = CH.ACCOUNT_NO                     
MFA-TR*                   AND HT.PREMISE_NO = CH.PREMISE_NO                     
MFA-TR*         WHERE PR.AGL_PREM_NO = :PR-AGL-PREM-NO                          
MFA-TR*           AND PR.PREMISE_NO = HT.PREMISE_NO                             
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY CH.DATE_UTIL_SVC_STRT DESC,                               
MFA-TR*               CH.DATE_UTIL_SVC_END DESC                                 
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7466                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-UT-CURSOR USED TO SEARCH FOR GAS ADDRESSES.              *        
      ******************************************************************        
           EXEC SQL DECLARE DY-UT-CURSOR CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN,                                   
                      IC_NO                                             
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_UTIL_TYPE = 'G'                           
                  AND UT.RATE_PLAN_NO > ' '                             
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                        OR HT.NAME_ID = 0)                              
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-UT-CURSOR CURSOR FOR                             
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               IC_NO                                                     
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND UT.RATE_PLAN_NO > ' '                                     
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                 OR HT.NAME_ID = 0)                                      
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7371                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-UT-CURSOR-L USED TO SEARCH FOR GAS ADDRESSES WITH THE    *        
      *                   LOCAL OFFICE LIMIT.                          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-UT-CURSOR-L CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN,                                   
                      IC_NO                                             
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_UTIL_TYPE = 'G'                           
                  AND UT.RATE_PLAN_NO > ' '                             
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-UT-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               IC_NO                                                     
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND UT.RATE_PLAN_NO > ' '                                     
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7365                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-UT-CURSOR-C USED TO SEARCH FOR GAS ADDRESSES WITH        *        
      *                   CITY/STATE LIMIT.                            *        
      ******************************************************************        
           EXEC SQL DECLARE DY-UT-CURSOR-C CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN,                                   
                      IC_NO                                             
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_UTIL_TYPE = 'G'                           
                  AND UT.RATE_PLAN_NO > ' '                             
                  AND HT.TOWN  = :CITY-LIMIT                            
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-UT-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               IC_NO                                                     
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND UT.RATE_PLAN_NO > ' '                                     
MFA-TR*           AND HT.TOWN  = :CITY-LIMIT                                    
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7368                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-UT-PR-CURSOR USED TO SEARCH FOR GAS ADDRESSES WITH       *        
      *                    LOT AND BLOCK.                              *        
      ******************************************************************        
           EXEC SQL DECLARE DY-UT-PR-CURSOR CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN,                                   
                      IC_NO                                             
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_UTIL_TYPE = 'G'                           
                  AND UT.RATE_PLAN_NO > ' '                             
                  AND HT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                        OR HT.NAME_ID = 0)                              
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-UT-PR-CURSOR CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               IC_NO                                                     
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND UT.RATE_PLAN_NO > ' '                                     
MFA-TR*           AND HT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                 OR HT.NAME_ID = 0)                                      
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7389                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-UT-PR-CURSOR-L USED TO SEARCH FOR GAS ADDRESSES WITH THE *        
      *                   LOCAL OFFICE LIMIT WITH LOT AND BLOCK        *        
      ******************************************************************        
           EXEC SQL DECLARE DY-UT-PR-CURSOR-L CURSOR FOR                
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN,                                   
                      IC_NO                                             
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_UTIL_TYPE = 'G'                           
                  AND UT.RATE_PLAN_NO > ' '                             
                  AND HT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-UT-PR-CURSOR-L CURSOR FOR                        
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               IC_NO                                                     
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND UT.RATE_PLAN_NO > ' '                                     
MFA-TR*           AND HT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7383                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-UT-PR-CURSOR-C USED TO SEARCH FOR GAS ADDRESSES WITH     *        
      *                   CITY/STATE LIMIT WITH LOT AND BLOCK          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-UT-PR-CURSOR-C CURSOR FOR                
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN,                                   
                      IC_NO                                             
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND UT.CODE_UTIL_TYPE = 'G'                           
                  AND UT.RATE_PLAN_NO > ' '                             
                  AND HT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND HT.TOWN  = :CITY-LIMIT                            
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-UT-PR-CURSOR-C CURSOR FOR                        
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               IC_NO                                                     
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT,                                      
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND UT.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*           AND UT.RATE_PLAN_NO > ' '                                     
MFA-TR*           AND HT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND HT.TOWN  = :CITY-LIMIT                                    
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7386                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-LG-CURSOR USED TO SEARCH FOR LIGHT ADDRESSES.            *        
      ******************************************************************        
           EXEC SQL DECLARE DY-LG-CURSOR CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND EXISTS                                            
                      (SELECT '1'                                       
                         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)         
                        WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO             
                          AND UT.CODE_UTIL_TYPE IN ('E','U')            
                          AND UT.RATE_PLAN_NO IN                        
                            ('017','018','025','026','029','062','064', 
                             '067','068','069','69A'))                  
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                        OR HT.NAME_ID = 0)                              
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-LG-CURSOR CURSOR FOR                             
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_UTIL_ENVRNMT UT                               
MFA-TR*                 WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                     
MFA-TR*                   AND UT.CODE_UTIL_TYPE IN ('E','U')                    
MFA-TR*                   AND UT.RATE_PLAN_NO IN                                
MFA-TR*                     ('017','018','025','026','029','062','064',         
MFA-TR*                      '067','068','069','69A'))                          
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                 OR HT.NAME_ID = 0)                                      
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7380                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-LG-CURSOR-L USED TO SEARCH FOR LIGHT ADDRESSES WITH THE  *        
      *                   LOCAL OFFICE LIMIT.                          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-LG-CURSOR-L CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND EXISTS                                            
                      (SELECT '1'                                       
                         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)         
                        WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO             
                          AND UT.CODE_UTIL_TYPE IN ('E','U')            
                          AND UT.RATE_PLAN_NO IN                        
                            ('017','018','025','026','029','062','064', 
                             '067','068','069','69A'))                  
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-LG-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_UTIL_ENVRNMT UT                               
MFA-TR*                 WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                     
MFA-TR*                   AND UT.CODE_UTIL_TYPE IN ('E','U')                    
MFA-TR*                   AND UT.RATE_PLAN_NO IN                                
MFA-TR*                     ('017','018','025','026','029','062','064',         
MFA-TR*                      '067','068','069','69A'))                          
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7374                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-LG-CURSOR-C USED TO SEARCH FOR LIGHT ADDRESSES WITH      *        
      *                   CITY/STATE LIMIT.                            *        
      ******************************************************************        
           EXEC SQL DECLARE DY-LG-CURSOR-C CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND EXISTS                                            
                      (SELECT '1'                                       
                         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)         
                        WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO             
                          AND UT.CODE_UTIL_TYPE IN ('E','U')            
                          AND UT.RATE_PLAN_NO IN                        
                            ('017','018','025','026','029','062','064', 
                             '067','068','069','69A'))                  
                  AND HT.TOWN  = :CITY-LIMIT                            
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-LG-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_UTIL_ENVRNMT UT                               
MFA-TR*                 WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                     
MFA-TR*                   AND UT.CODE_UTIL_TYPE IN ('E','U')                    
MFA-TR*                   AND UT.RATE_PLAN_NO IN                                
MFA-TR*                     ('017','018','025','026','029','062','064',         
MFA-TR*                      '067','068','069','69A'))                          
MFA-TR*           AND HT.TOWN  = :CITY-LIMIT                                    
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7377                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-LG-PR-CURSOR USED TO SEARCH FOR LIGHT ADDRESSES          *        
      *                    WITH LOT AND BLOCK                          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-LG-PR-CURSOR CURSOR FOR                  
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND EXISTS                                            
                      (SELECT '1'                                       
                         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)         
                        WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO             
                          AND UT.CODE_UTIL_TYPE IN ('E','U')            
                          AND UT.RATE_PLAN_NO IN                        
                            ('017','018','025','026','029','062','064', 
                             '067','068','069','69A'))                  
                  AND HT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                        OR HT.NAME_ID = 0)                              
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-LG-PR-CURSOR CURSOR FOR                          
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_UTIL_ENVRNMT UT                               
MFA-TR*                 WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                     
MFA-TR*                   AND UT.CODE_UTIL_TYPE IN ('E','U')                    
MFA-TR*                   AND UT.RATE_PLAN_NO IN                                
MFA-TR*                     ('017','018','025','026','029','062','064',         
MFA-TR*                      '067','068','069','69A'))                          
MFA-TR*           AND HT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                 OR HT.NAME_ID = 0)                                      
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7398                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-LG-PR-CURSOR-L USED TO SEARCH FOR LIGHT ADDRESSES WITH   *        
      *                   THE LOCAL OFFICE LIMIT WITH LOT AND BLOCK    *        
      ******************************************************************        
           EXEC SQL DECLARE DY-LG-PR-CURSOR-L CURSOR FOR                
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND EXISTS                                            
                      (SELECT '1'                                       
                         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)         
                        WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO             
                          AND UT.CODE_UTIL_TYPE IN ('E','U')            
                          AND UT.RATE_PLAN_NO IN                        
                            ('017','018','025','026','029','062','064', 
                             '067','068','069','69A'))                  
                  AND HT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT             
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-LG-PR-CURSOR-L CURSOR FOR                        
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_UTIL_ENVRNMT UT                               
MFA-TR*                 WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                     
MFA-TR*                   AND UT.CODE_UTIL_TYPE IN ('E','U')                    
MFA-TR*                   AND UT.RATE_PLAN_NO IN                                
MFA-TR*                     ('017','018','025','026','029','062','064',         
MFA-TR*                      '067','068','069','69A'))                          
MFA-TR*           AND HT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND HT.LOCAL_OFFICE = :LOCAL-OFFICE-LIMIT                     
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7392                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-LG-PR-CURSOR-C USED TO SEARCH FOR LIGHT ADDRESSES WITH   *        
      *                   CITY/STATE LIMIT WITH LOT AND BLOCK          *        
      ******************************************************************        
           EXEC SQL DECLARE DY-LG-PR-CURSOR-C CURSOR FOR                
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      'N',                                              
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                  
                  AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1               
                  AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2               
                  AND DY.STREET_NAME LIKE :ADD-STREET-NAME              
                  AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1         
                  AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2         
                  AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT             
                  AND DY.ADDRESS_ID = HT.ADDRESS_ID                     
                  AND EXISTS                                            
                      (SELECT '1'                                       
                         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)         
                        WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO             
                          AND UT.CODE_UTIL_TYPE IN ('E','U')            
                          AND UT.RATE_PLAN_NO IN                        
                            ('017','018','025','026','029','062','064', 
                             '067','068','069','69A'))                  
                  AND HT.PREMISE_NO = PR.PREMISE_NO                     
                  AND PR.BLOCK LIKE :ADD-BLOCK                          
                  AND PR.LOT LIKE :ADD-LOT                              
                  AND HT.TOWN  = :CITY-LIMIT                            
                  AND HT.STATE = :STATE-LIMIT                           
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME   COLLATE SQL_EBCDIC037_CP1_CS_AS,                                   
                      RIGHT('000000000000000' + LTRIM(
                  RTRIM(HOUSE_NO)),15) COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDR_PREFIX_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_1 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                  DY.STREET_LOCATION_2 COLLATE SQL_EBCDIC037_CP1_CS_AS,
                      DY.ADDRESS_ID                                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE DY-LG-PR-CURSOR-C CURSOR FOR                        
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(STREET_NAME) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                
MFA-TR*                     LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                  
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*                     LTRIM(RTRIM(STREET_LOCATION_2)))))))))),            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               'N',                                                      
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO LIKE :ADD-STREET-NBR                          
MFA-TR*           AND DY.ADDR_PREFIX_1 LIKE :ADD-PREFIX-1                       
MFA-TR*           AND DY.ADDR_PREFIX_2 LIKE :ADD-PREFIX-2                       
MFA-TR*           AND DY.STREET_NAME LIKE :ADD-STREET-NAME                      
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE :ADD-LOCATION-1                 
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE :ADD-LOCATION-2                 
MFA-TR*           AND DY.ADDR_USAGE_CD = :WS-ADDRESS-FORMAT                     
MFA-TR*           AND DY.ADDRESS_ID = HT.ADDRESS_ID                             
MFA-TR*           AND EXISTS                                                    
MFA-TR*               (SELECT '1'                                               
MFA-TR*                  FROM CSS_UTIL_ENVRNMT UT                               
MFA-TR*                 WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                     
MFA-TR*                   AND UT.CODE_UTIL_TYPE IN ('E','U')                    
MFA-TR*                   AND UT.RATE_PLAN_NO IN                                
MFA-TR*                     ('017','018','025','026','029','062','064',         
MFA-TR*                      '067','068','069','69A'))                          
MFA-TR*           AND HT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*           AND PR.BLOCK LIKE :ADD-BLOCK                                  
MFA-TR*           AND PR.LOT LIKE :ADD-LOT                                      
MFA-TR*           AND HT.TOWN  = :CITY-LIMIT                                    
MFA-TR*           AND HT.STATE = :STATE-LIMIT                                   
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME,                                           
MFA-TR*               RIGHT('000000000000000' ||                                
MFA-TR*               LTRIM(RTRIM(HOUSE_NO)),15),                               
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,               
MFA-TR*               DY.ADDRESS_ID                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7395                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
P00837******************************************************************        
P00837*    MGR-CURSOR USED TO SEARCH BY INTERNAL ACCOUNT MANAGER       *        
P00837******************************************************************        
P00837     EXEC SQL DECLARE MGR-CURSOR CURSOR FOR                       
P00837         SELECT HT.CUSTOMER_NO,                                   
P00837                HT.ACCOUNT_NO,                                    
P00837                HT.PREMISE_NO,                                    
P00837                HT.ADDRESS_ID,                                    
P00837                HT.NAME_ID,                                       
P00837                HT.CUSTOMER_ROLE_CD,                              
P00837                HT.COMPANY_NO,                                    
P00837                HT.ACCOUNT_TYPE_CODE,                             
P00837                HT.CODE_ACCT_STAT,                                
P00837                CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
P00837                      'Y' ELSE 'N' END                            
P00837           FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00837                CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00837                CSS_CONTACT_ACCT DW WITH(READUNCOMMITTED),                
P00837                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
P00837          WHERE DQ.FIRST_NAME = :DQ-FIRST-NAME                    
P00837            AND DQ.LAST_NAME = :DQ-LAST-NAME                      
P00837            AND DQ.NAME_ID = CV.NAME_ID                           
P00837            AND CV.CONTACT_ID = DW.CONTACT_ID                     
P00837            AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                     
P00837            AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
P00837            AND HT.CUSTOMER_ROLE_CD = ' '                         
P00837            AND (EXISTS (SELECT 'X'                               
P00837                           FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
P00837                          WHERE HT.NAME_ID   = DQ.NAME_ID         
P00837                            AND DQ.NAME_TYPE = 'CN')              
P00837                 OR HT.NAME_ID = 0)                               
P00837     UNION                                                        
P00837         SELECT HT.CUSTOMER_NO,                                   
P00837                HT.ACCOUNT_NO,                                    
P00837                HT.PREMISE_NO,                                    
P00837                HT.ADDRESS_ID,                                    
P00837                HT.NAME_ID,                                       
P00837                HT.CUSTOMER_ROLE_CD,                              
P00837                HT.COMPANY_NO,                                    
P00837                HT.ACCOUNT_TYPE_CODE,                             
P00837                HT.CODE_ACCT_STAT,                                
P00837                CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
P00837                      'Y' ELSE 'N' END                            
P00837           FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00837                CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00837                CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
P00837                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
P00837          WHERE DQ.FIRST_NAME = :MGR-FIRST-NAME                   
P00837            AND DQ.LAST_NAME = :MGR-LAST-NAME                     
P00837            AND DQ.NAME_ID = CV.NAME_ID                           
P00837            AND CV.CONTACT_ID = DT.CONTACT_ID                     
P00837            AND DT.CUSTOMER_NO = HT.CUSTOMER_NO                   
P00837            AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                 
P00837            AND HT.CUSTOMER_ROLE_CD = ' '                         
P00837            AND (EXISTS (SELECT 'X'                               
P00837                           FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
P00837                          WHERE HT.NAME_ID   = DQ.NAME_ID         
P00837                            AND DQ.NAME_TYPE = 'CN')              
P00837                 OR HT.NAME_ID = 0)                               
P00837       ORDER BY 1, 2                                              
P00837       FOR READ ONLY                                             
P00837                                                           
P00837                                                      
P00837     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE MGR-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_CONTACT_ACCT DW,                                      
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FIRST_NAME = :DQ-FIRST-NAME                            
MFA-TR*           AND DQ.LAST_NAME = :DQ-LAST-NAME                              
MFA-TR*           AND DQ.NAME_ID = CV.NAME_ID                                   
MFA-TR*           AND CV.CONTACT_ID = DW.CONTACT_ID                             
MFA-TR*           AND DW.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*    UNION                                                                
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DQ.FIRST_NAME = :MGR-FIRST-NAME                           
MFA-TR*           AND DQ.LAST_NAME = :MGR-LAST-NAME                             
MFA-TR*           AND DQ.NAME_ID = CV.NAME_ID                                   
MFA-TR*           AND CV.CONTACT_ID = DT.CONTACT_ID                             
MFA-TR*           AND DT.CUSTOMER_NO = HT.CUSTOMER_NO                           
MFA-TR*           AND HT.COMPANY_NO LIKE :COMPANY-LIMIT                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY 1, 2                                                      
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7410                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
P00870******************************************************************        
P00870*    REF-CURSOR USED TO SEARCH FOR REFUND CHECK.                 *        
P00870******************************************************************        
P00870     EXEC SQL DECLARE REF-CURSOR CURSOR FOR                       
P00870         SELECT HT.CUSTOMER_NO,                                   
P00870                HT.ACCOUNT_NO,                                    
P00870                HT.PREMISE_NO,                                    
P00870                HT.ADDRESS_ID,                                    
P00870                HT.NAME_ID,                                       
P00870                HT.CUSTOMER_ROLE_CD,                              
P00870                HT.COMPANY_NO,                                    
P00870                DQ.NAME_TYPE,                                     
P00870                CASE WHEN NAME_FORMAT = 'I' THEN                  
P00870                        RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) + ', ' + 
           RTRIM(DQ.FIRST_NAME) + ' ' + RTRIM(DQ.MIDDLE_NAME) + ' ' + 
           RTRIM(DQ.TITLE_SUFFIX_1)))                
P00870                     ELSE FULL_NAME END,                          
P00870                HT.ACCOUNT_TYPE_CODE,                             
P00870                HT.CODE_ACCT_STAT,                                
P00870                CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN            
P00870                      'Y' ELSE 'N' END                            
P00870           FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
P00870                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
P00870                CSS_REFUND RN WITH(READUNCOMMITTED)                       
P00870          WHERE REFUND_CHECK_NO = :RN-REFUND-CHECK-NO             
P00870            AND RN.ACCOUNT_NO = HT.ACCOUNT_NO                     
P00870            AND HT.NAME_ID = DQ.NAME_ID                           
P00870            AND DQ.NAME_TYPE = 'CN'                               
P00870            AND HT.CUSTOMER_ROLE_CD  = ' '                        
P00870       FOR READ ONLY                                             
P00870                                                           
P00870                                                      
P00870     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE REF-CURSOR CURSOR FOR                               
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DQ.NAME_TYPE,                                             
MFA-TR*               CASE WHEN NAME_FORMAT = 'I' THEN                          
MFA-TR*                       RTRIM(LTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||        
MFA-TR*                       RTRIM(DQ.FIRST_NAME) || ' ' ||                    
MFA-TR*                       RTRIM(DQ.MIDDLE_NAME) || ' ' ||                   
MFA-TR*                       RTRIM(DQ.TITLE_SUFFIX_1)))                        
MFA-TR*                    ELSE FULL_NAME END,                                  
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN HT.CODE_ACCT_STAT = 'R' THEN                    
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_REFUND RN                                             
MFA-TR*         WHERE REFUND_CHECK_NO = :RN-REFUND-CHECK-NO                     
MFA-TR*           AND RN.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND HT.CUSTOMER_ROLE_CD  = ' '                                
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7413                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE UT-CURSOR CURSOR FOR                        
               SELECT CODE_UTIL_TYPE, MIN(RATE_PLAN_NO)                 
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
             GROUP BY CODE_UTIL_TYPE                                    
               HAVING CODE_UTIL_TYPE IN ('E','G','U')                   
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UT-CURSOR CURSOR FOR                                
MFA-TR*        SELECT CODE_UTIL_TYPE, MIN(RATE_PLAN_NO)                         
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*      GROUP BY CODE_UTIL_TYPE                                            
MFA-TR*        HAVING CODE_UTIL_TYPE IN ('E','G','U')                           
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7274                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE G-MTR-CURSOR CURSOR FOR                     
               SELECT METER_NO,                                         
                      CODE_METER_STATUS,                                
                      CODE_METER_LOC,                                   
                      REGISTER_RD_SEQ                                   
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO        = :HT-ACCOUNT-NO                
                  AND CODE_UTIL_TYPE    = 'G'                           
                  AND IC_NO             = :UT-IC-NO                     
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE G-MTR-CURSOR CURSOR FOR                             
MFA-TR*        SELECT METER_NO,                                                 
MFA-TR*               CODE_METER_STATUS,                                        
MFA-TR*               CODE_METER_LOC,                                           
MFA-TR*               REGISTER_RD_SEQ                                           
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO        = :HT-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = 'G'                                   
MFA-TR*           AND IC_NO             = :UT-IC-NO                             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7401                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE L-UT-CURSOR CURSOR FOR                      
               SELECT CODE_UTIL_TYPE,                                   
                      MAX(RATE_PLAN_NO)                                 
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
               GROUP BY CODE_UTIL_TYPE                                  
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE L-UT-CURSOR CURSOR FOR                      11570000
MFA-TR*        SELECT CODE_UTIL_TYPE,                                   11580000
MFA-TR*               MAX(RATE_PLAN_NO)                                 11580000
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                  11590000
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       11600000
MFA-TR*        GROUP BY CODE_UTIL_TYPE                                  11610000
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7404                                                     
MFA-TR*    END-EXEC.                                                    11630000
                                                                        
       LINKAGE SECTION.                                                 
       01 LINK-SEARCH-METHOD      PIC X(03).                            
       01 LINK-LIMITS             PIC X(34).                            
       01 LINK-FILTERS            PIC X(06).                            
       01 LINK-DETAILED-DATA      PIC X(01).                            
       01 LINK-CRITERIA           PIC X(250).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-SEARCH-METHOD,                           
                          LINK-LIMITS,                                  
                          LINK-FILTERS,                                 
                          LINK-DETAILED-DATA,                           
                          LINK-CRITERIA.                                
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           IF  SEL-METH-ACC                                             
               
MSQ016        GOBACK                                                 
           ELSE                                                         
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           IF LINK-DETAILED-DATA = 'Y'                                  
               PERFORM 0200W-DECLARE-WIDE THRU 0200W-EXIT               
           ELSE                                                         
               PERFORM 0200S-DECLARE-SKINNY THRU 0200S-EXIT
           END-IF.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100S-DECLARE-GTT.                                               
                                                                        
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04283_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04283_R1
               (                                                       
                   RETURN_CODE              INT,                    
                   STATUS_CODE              INT,                    
                   NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,              
                   ADDRESS CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,           
                   CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,              
                   NAME_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
                   ACCT_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
                   ACCT_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   ACCOUNT_NO               DECIMAL(13,0),              
                   CUSTOMER_NO              DECIMAL(10,0),              
                   PREMISE_NO               DECIMAL(10,0),              
                   RED_FLAG_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   ARCHIVE_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   GROUP_CD CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,          
                   UTIL_SVC_STRT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   UTIL_SVC_END CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   ACCT_SUB_TYPE CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
A05317             SORT_FIELD_1             SMALLINT,                   
A05317             SORT_FIELD_2 CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
A05317             SORT_FIELD_3 CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE TO WS-SQLSTATE.                               
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000S-DELETE-GTT-ROW THRU 8000S-EXIT             
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100S'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04283_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT
               END-IF
            END-IF.        
                                                                        
       0100S-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0100W-DECLARE-GTT.                                               
                                                                        
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04283_R3')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04283_R3
               (                                                       
                   RETURN_CODE              INT,                    
                   STATUS_CODE              INT,                    
                   NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,              
                   ADDRESS CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,           
                   CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,              
                   NAME_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
                   ACCT_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
                   ACCT_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   ACCOUNT_NO               DECIMAL(13,0),              
                   CUSTOMER_NO              DECIMAL(10,0),              
                   PREMISE_NO               DECIMAL(10,0),              
                   RED_FLAG_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   ARCHIVE_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   GROUP_CD CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,          
                   UTIL_SVC_STRT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   UTIL_SVC_END CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   REV_DISTRICT_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   SUBDIVISION_ID CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   SERVICES_SUPPLIED CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   SERVICES_AVAILABLE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   READ_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
                   READ_ROUTE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,        
                   ELEC_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,         
                   GAS_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
                   UNMETER_RATE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,          
                   METER_STATUS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   METER_LOC CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
                   METER_READ_SEQ           INT,                    
                   POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
                   POLE_NO CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2,           
                   LIGHT_TYPE CHAR(17)  COLLATE LATIN1_GENERAL_100_BIN2,        
                   ACCT_SUB_TYPE CHAR(30)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   BILL_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
                   AGL_ACCT_NO CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
                   OFFER_CODE CHAR(65)  COLLATE LATIN1_GENERAL_100_BIN2,        
                   OPTION_CODE CHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                  
                   CORE_RATE CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2,         
A04671             ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,          
A05317             SORT_FIELD_1             SMALLINT,                   
A05317             SORT_FIELD_2 CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
A05317             SORT_FIELD_3 CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
A05317             CREDIT_GROUP CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
A05317             NAME_FORMAT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2,                   
A05317             ACCOUNT_ID CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2         
                                                                        
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE TO WS-SQLSTATE.                               
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000W-DELETE-GTT-ROW THRU 8000W-EXIT             
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100F'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04283_R3'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT
               END-IF
            END-IF.        
                                                                        
       0100W-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0200W-DECLARE-WIDE.                                              
                                                                        
           IF  LINK-SEARCH-METHOD  NOT = 'ACC'                          
               PERFORM 0100W-DECLARE-GTT THRU 0100W-EXIT                
               EXEC SQL                                                 
                   DECLARE C3 CURSOR                         
                                     WITH ROWSET POSITIONING FOR        
                   SELECT  RETURN_CODE      AS RETURN_CODE,             
                           STATUS_CODE      AS STATUS_CODE,             
                           NAME             AS NAME,                    
                           ADDRESS          AS SERV_ADDRESS,            
                           CITY             AS CITY,                    
                           NAME_TYPE        AS NAME_TYPE,               
                           ACCT_TYPE        AS ACCT_TYPE,               
                           ACCT_STATUS      AS ACCT_STATUS,             
                           ACCOUNT_NO       AS ACCOUNT_NO,              
                           CUSTOMER_NO      AS CUSTOMER_NO,             
                           PREMISE_NO       AS PREMISE_NO,              
                           RED_FLAG_IND     AS RED_FLAG_IND,            
                           ARCHIVE_IND      AS ARCHIVE_IND,             
                           GROUP_CD         AS GROUP_CD,                
                           UTIL_SVC_STRT    AS UTIL_SVC_STRT,           
                           UTIL_SVC_END     AS UTIL_SVC_END,            
                           REV_DISTRICT_CD  AS REV_DISTRICT_CD,         
                           SUBDIVISION_ID   AS SUBDIVISION_ID,          
                           SERVICES_SUPPLIED AS SERVICES_SUPPLIED,      
                           SERVICES_AVAILABLE AS SERVICES_AVAILABLE,    
                           READ_CYCLE       AS READ_CYCLE,              
                           READ_ROUTE       AS READ_ROUTE,              
                           ELEC_RATE        AS ELEC_RATE,               
                           GAS_RATE         AS GAS_RATE,                
                           UNMETER_RATE     AS UNMETER_RATE,            
                           METER_NO         AS METER_NO,                
                           METER_STATUS     AS METER_STATUS,            
                           METER_LOC        AS METER_LOC,               
                           METER_READ_SEQ   AS METER_READ_SEQ,          
                           POINT_ID         AS POINT_ID,                
                           POLE_NO          AS POLE_NO,                 
                           LIGHT_TYPE       AS LIGHT_TYPE,              
                           ACCT_SUB_TYPE    AS ACCT_SUB_TYPE,           
                           BILL_CYCLE       AS BILL_CYCLE,              
                           AGL_ACCT_NO      AS AGL_ACCT_NO,             
                           OFFER_CODE       AS OFFER_CODE,              
                           OPTION_CODE      AS OPTION_CODE,             
                           CORE_RATE        AS CORE_RATE,               
A04671                     ZIP_CODE         AS ZIP_CODE,                
A05317                     SORT_FIELD_1     AS SORT_FIELD_1,            
A05317                     SORT_FIELD_2     AS SORT_FIELD_2,            
A05317                     SORT_FIELD_3     AS SORT_FIELD_3,            
A05317                     CREDIT_GROUP     AS CREDIT_GROUP,            
A05317                     NAME_FORMAT      AS NAME_FORMAT,             
A05317                     ACCOUNT_ID       AS ACCOUNT_ID               
                   FROM  #CSR04283_R3                            
A05317             ORDER BY RETURN_CODE,                                
A05317                      SORT_FIELD_1,                               
A05317                      SORT_FIELD_2,                               
A05317                      SORT_FIELD_3 DESC                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C3 CURSOR WITH RETURN                                
MFA-TR*                              WITH ROWSET POSITIONING FOR                
MFA-TR*            SELECT  RETURN_CODE      AS RETURN_CODE,                     
MFA-TR*                    STATUS_CODE      AS STATUS_CODE,                     
MFA-TR*                    NAME             AS NAME,                            
MFA-TR*                    ADDRESS          AS SERV_ADDRESS,                    
MFA-TR*                    CITY             AS CITY,                            
MFA-TR*                    NAME_TYPE        AS NAME_TYPE,                       
MFA-TR*                    ACCT_TYPE        AS ACCT_TYPE,                       
MFA-TR*                    ACCT_STATUS      AS ACCT_STATUS,                     
MFA-TR*                    ACCOUNT_NO       AS ACCOUNT_NO,                      
MFA-TR*                    CUSTOMER_NO      AS CUSTOMER_NO,                     
MFA-TR*                    PREMISE_NO       AS PREMISE_NO,                      
MFA-TR*                    RED_FLAG_IND     AS RED_FLAG_IND,                    
MFA-TR*                    ARCHIVE_IND      AS ARCHIVE_IND,                     
MFA-TR*                    GROUP_CD         AS GROUP_CD,                        
MFA-TR*                    UTIL_SVC_STRT    AS UTIL_SVC_STRT,                   
MFA-TR*                    UTIL_SVC_END     AS UTIL_SVC_END,                    
MFA-TR*                    REV_DISTRICT_CD  AS REV_DISTRICT_CD,                 
MFA-TR*                    SUBDIVISION_ID   AS SUBDIVISION_ID,                  
MFA-TR*                    SERVICES_SUPPLIED AS SERVICES_SUPPLIED,              
MFA-TR*                    SERVICES_AVAILABLE AS SERVICES_AVAILABLE,            
MFA-TR*                    READ_CYCLE       AS READ_CYCLE,                      
MFA-TR*                    READ_ROUTE       AS READ_ROUTE,                      
MFA-TR*                    ELEC_RATE        AS ELEC_RATE,                       
MFA-TR*                    GAS_RATE         AS GAS_RATE,                        
MFA-TR*                    UNMETER_RATE     AS UNMETER_RATE,                    
MFA-TR*                    METER_NO         AS METER_NO,                        
MFA-TR*                    METER_STATUS     AS METER_STATUS,                    
MFA-TR*                    METER_LOC        AS METER_LOC,                       
MFA-TR*                    METER_READ_SEQ   AS METER_READ_SEQ,                  
MFA-TR*                    POINT_ID         AS POINT_ID,                        
MFA-TR*                    POLE_NO          AS POLE_NO,                         
MFA-TR*                    LIGHT_TYPE       AS LIGHT_TYPE,                      
MFA-TR*                    ACCT_SUB_TYPE    AS ACCT_SUB_TYPE,                   
MFA-TR*                    BILL_CYCLE       AS BILL_CYCLE,                      
MFA-TR*                    AGL_ACCT_NO      AS AGL_ACCT_NO,                     
MFA-TR*                    OFFER_CODE       AS OFFER_CODE,                      
MFA-TR*                    OPTION_CODE      AS OPTION_CODE,                     
MFA-TR*                    CORE_RATE        AS CORE_RATE,                       
MFA-TR*                    ZIP_CODE         AS ZIP_CODE,                        
MFA-TR*                    SORT_FIELD_1     AS SORT_FIELD_1,                    
MFA-TR*                    SORT_FIELD_2     AS SORT_FIELD_2,                    
MFA-TR*                    SORT_FIELD_3     AS SORT_FIELD_3,                    
MFA-TR*                    CREDIT_GROUP     AS CREDIT_GROUP,                    
MFA-TR*                    NAME_FORMAT      AS NAME_FORMAT,                     
MFA-TR*                    ACCOUNT_ID       AS ACCOUNT_ID                       
MFA-TR*            FROM  SESSION.CSR04283_R3                                    
MFA-TR*            ORDER BY RETURN_CODE,                                        
MFA-TR*                     SORT_FIELD_1,                                       
MFA-TR*                     SORT_FIELD_2,                                       
MFA-TR*                     SORT_FIELD_3 DESC                                   
MFA-TR*        END-EXEC                                                         
           ELSE                                                         
               EXEC SQL                                                 
                   DECLARE C4 CURSOR  FOR                    
                   SELECT :S-RETURN-CODE    AS RETURN_CODE,             
                          :S-STATUS-CODE    AS STATUS_CODE,             
                          :S-NAME           AS NAME,                    
                          :S-ADDRESS        AS SERV_ADDRESS,            
                          :S-CITY           AS CITY,                    
                          :S-NAME-TYPE      AS NAME_TYPE,               
                          :S-ACCT-TYPE      AS ACCT_TYPE,               
                          :S-ACCT-STATUS    AS ACCT_STATUS,             
                          :S-ACCOUNT-NO     AS ACCOUNT_NO,              
                          :S-CUSTOMER-NO    AS CUSTOMER_NO,             
                          :S-PREMISE-NO     AS PREMISE_NO,              
                          :S-RED-FLAG-IND   AS RED_FLAG_IND,            
                          :S-ARCHIVE-IND    AS ARCHIVE_IND,             
                          :S-GROUP-CD       AS GROUP_CD,                
                          :S-UTIL-SVC-STRT  AS UTIL_SVC_STRT,           
                          :S-UTIL-SVC-END   AS UTIL_SVC_END,            
                          :S-REV-DISTRICT-CD AS REV_DISTRICT_CD,        
                          :S-SUBDIVISION-ID AS SUBDIVISION_ID,          
                          :S-SERV-SUPPL     AS SERVICES_SUPPLIED,       
                          :S-SERV-AVAIL     AS SERVICES_AVAILABLE,      
                          :S-READ-CYCLE     AS READ_CYCLE,              
                          :S-READ-ROUTE     AS READ_ROUTE,              
                          :S-ELEC-RATE      AS ELEC_RATE,               
                          :S-GAS-RATE       AS GAS_RATE,                
                          :S-UNMETER-RATE   AS UNMETER_RATE,            
                          :S-METER-NO       AS METER_NO,                
                          :S-METER-STATUS   AS METER_STATUS,            
                          :S-METER-LOC      AS METER_LOC,               
                          :S-METER-READ-SEQ AS METER_READ_SEQ,          
                          :S-POINT-ID       AS POINT_ID,                
                          :S-POLE-NO        AS POLE_NO,                 
                          :S-LIGHT-TYPE     AS LIGHT_TYPE,              
                          :S-ACCT-SUB-TYPE  AS ACCT_SUB_TYPE,           
                          :S-BILL-CYCLE     AS BILL_CYCLE,              
                          :S-AGL-ACCT-NO    AS AGL_ACCT_NO,             
                          :S-OFFER-CODE     AS OFFER_CODE,              
                          :S-OPTION-CODE    AS OPTION_CODE,             
                          :S-CORE-RATE      AS CORE_RATE,               
A04671                    :S-ZIP-CODE       AS ZIP_CODE,                
A05317                    :S-SORT-FIELD-1   AS SORT_FIELD_1,            
A05317                    :S-SORT-FIELD-2   AS SORT_FIELD_2,            
A05317                    :S-SORT-FIELD-3   AS SORT_FIELD_3,            
A05317                    :S-CREDIT-GROUP   AS CREDIT_GROUP,            
A05317                    :S-NAME-FORMAT    AS NAME_FORMAT,             
A05317                    :S-ACCOUNT-ID     AS ACCOUNT_ID               
                   FROM   CIS.SYSDUMMY1                              
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C4 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT :S-RETURN-CODE    AS RETURN_CODE,                     
MFA-TR*                   :S-STATUS-CODE    AS STATUS_CODE,                     
MFA-TR*                   :S-NAME           AS NAME,                            
MFA-TR*                   :S-ADDRESS        AS SERV_ADDRESS,                    
MFA-TR*                   :S-CITY           AS CITY,                            
MFA-TR*                   :S-NAME-TYPE      AS NAME_TYPE,                       
MFA-TR*                   :S-ACCT-TYPE      AS ACCT_TYPE,                       
MFA-TR*                   :S-ACCT-STATUS    AS ACCT_STATUS,                     
MFA-TR*                   :S-ACCOUNT-NO     AS ACCOUNT_NO,                      
MFA-TR*                   :S-CUSTOMER-NO    AS CUSTOMER_NO,                     
MFA-TR*                   :S-PREMISE-NO     AS PREMISE_NO,                      
MFA-TR*                   :S-RED-FLAG-IND   AS RED_FLAG_IND,                    
MFA-TR*                   :S-ARCHIVE-IND    AS ARCHIVE_IND,                     
MFA-TR*                   :S-GROUP-CD       AS GROUP_CD,                        
MFA-TR*                   :S-UTIL-SVC-STRT  AS UTIL_SVC_STRT,                   
MFA-TR*                   :S-UTIL-SVC-END   AS UTIL_SVC_END,                    
MFA-TR*                   :S-REV-DISTRICT-CD AS REV_DISTRICT_CD,                
MFA-TR*                   :S-SUBDIVISION-ID AS SUBDIVISION_ID,                  
MFA-TR*                   :S-SERV-SUPPL     AS SERVICES_SUPPLIED,               
MFA-TR*                   :S-SERV-AVAIL     AS SERVICES_AVAILABLE,              
MFA-TR*                   :S-READ-CYCLE     AS READ_CYCLE,                      
MFA-TR*                   :S-READ-ROUTE     AS READ_ROUTE,                      
MFA-TR*                   :S-ELEC-RATE      AS ELEC_RATE,                       
MFA-TR*                   :S-GAS-RATE       AS GAS_RATE,                        
MFA-TR*                   :S-UNMETER-RATE   AS UNMETER_RATE,                    
MFA-TR*                   :S-METER-NO       AS METER_NO,                        
MFA-TR*                   :S-METER-STATUS   AS METER_STATUS,                    
MFA-TR*                   :S-METER-LOC      AS METER_LOC,                       
MFA-TR*                   :S-METER-READ-SEQ AS METER_READ_SEQ,                  
MFA-TR*                   :S-POINT-ID       AS POINT_ID,                        
MFA-TR*                   :S-POLE-NO        AS POLE_NO,                         
MFA-TR*                   :S-LIGHT-TYPE     AS LIGHT_TYPE,                      
MFA-TR*                   :S-ACCT-SUB-TYPE  AS ACCT_SUB_TYPE,                   
MFA-TR*                   :S-BILL-CYCLE     AS BILL_CYCLE,                      
MFA-TR*                   :S-AGL-ACCT-NO    AS AGL_ACCT_NO,                     
MFA-TR*                   :S-OFFER-CODE     AS OFFER_CODE,                      
MFA-TR*                   :S-OPTION-CODE    AS OPTION_CODE,                     
MFA-TR*                   :S-CORE-RATE      AS CORE_RATE,                       
MFA-TR*                   :S-ZIP-CODE       AS ZIP_CODE,                        
MFA-TR*                   :S-SORT-FIELD-1   AS SORT_FIELD_1,                    
MFA-TR*                   :S-SORT-FIELD-2   AS SORT_FIELD_2,                    
MFA-TR*                   :S-SORT-FIELD-3   AS SORT_FIELD_3,                    
MFA-TR*                   :S-CREDIT-GROUP   AS CREDIT_GROUP,                    
MFA-TR*                   :S-NAME-FORMAT    AS NAME_FORMAT,                     
MFA-TR*                   :S-ACCOUNT-ID     AS ACCOUNT_ID                       
MFA-TR*            FROM   SYSIBM.SYSDUMMY1                                      
MFA-TR*        END-EXEC.                                                        
           END-IF.                                                
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0200W-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0200S-DECLARE-SKINNY.                                            
                                                                        
           IF  LINK-SEARCH-METHOD  NOT = 'ACC'                          
               PERFORM 0100S-DECLARE-GTT THRU 0100S-EXIT                
               EXEC SQL                                                 
                   DECLARE C1 CURSOR                         
                                     WITH ROWSET POSITIONING FOR        
                   SELECT  RETURN_CODE      AS RETURN_CODE,             
                           STATUS_CODE      AS STATUS_CODE,             
                           NAME             AS NAME,                    
                           ADDRESS          AS SERV_ADDRESS,            
                           CITY             AS CITY,                    
                           NAME_TYPE        AS NAME_TYPE,               
                           ACCT_TYPE        AS ACCT_TYPE,               
                           ACCT_STATUS      AS ACCT_STATUS,             
                           ACCOUNT_NO       AS ACCOUNT_NO,              
                           CUSTOMER_NO      AS CUSTOMER_NO,             
                           PREMISE_NO       AS PREMISE_NO,              
                           RED_FLAG_IND     AS RED_FLAG_IND,            
                           ARCHIVE_IND      AS ARCHIVE_IND,             
                           GROUP_CD         AS GROUP_CD,                
                           UTIL_SVC_STRT    AS UTIL_SVC_STRT,           
                           UTIL_SVC_END     AS UTIL_SVC_END,            
                           ACCT_SUB_TYPE    AS ACCT_SUB_TYPE,           
A05317                     SORT_FIELD_1     AS SORT_FIELD_1,            
A05317                     SORT_FIELD_2     AS SORT_FIELD_2,            
A05317                     SORT_FIELD_3     AS SORT_FIELD_3             
                   FROM  #CSR04283_R1                            
A05317             ORDER BY RETURN_CODE,                                
A05317                      SORT_FIELD_1,                               
A05317                      SORT_FIELD_2,                               
A05317                      SORT_FIELD_3 DESC                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR WITH RETURN                                
MFA-TR*                              WITH ROWSET POSITIONING FOR                
MFA-TR*            SELECT  RETURN_CODE      AS RETURN_CODE,                     
MFA-TR*                    STATUS_CODE      AS STATUS_CODE,                     
MFA-TR*                    NAME             AS NAME,                            
MFA-TR*                    ADDRESS          AS SERV_ADDRESS,                    
MFA-TR*                    CITY             AS CITY,                            
MFA-TR*                    NAME_TYPE        AS NAME_TYPE,                       
MFA-TR*                    ACCT_TYPE        AS ACCT_TYPE,                       
MFA-TR*                    ACCT_STATUS      AS ACCT_STATUS,                     
MFA-TR*                    ACCOUNT_NO       AS ACCOUNT_NO,                      
MFA-TR*                    CUSTOMER_NO      AS CUSTOMER_NO,                     
MFA-TR*                    PREMISE_NO       AS PREMISE_NO,                      
MFA-TR*                    RED_FLAG_IND     AS RED_FLAG_IND,                    
MFA-TR*                    ARCHIVE_IND      AS ARCHIVE_IND,                     
MFA-TR*                    GROUP_CD         AS GROUP_CD,                        
MFA-TR*                    UTIL_SVC_STRT    AS UTIL_SVC_STRT,                   
MFA-TR*                    UTIL_SVC_END     AS UTIL_SVC_END,                    
MFA-TR*                    ACCT_SUB_TYPE    AS ACCT_SUB_TYPE,                   
MFA-TR*                    SORT_FIELD_1     AS SORT_FIELD_1,                    
MFA-TR*                    SORT_FIELD_2     AS SORT_FIELD_2,                    
MFA-TR*                    SORT_FIELD_3     AS SORT_FIELD_3                     
MFA-TR*            FROM  SESSION.CSR04283_R1                                    
MFA-TR*            ORDER BY RETURN_CODE,                                        
MFA-TR*                     SORT_FIELD_1,                                       
MFA-TR*                     SORT_FIELD_2,                                       
MFA-TR*                     SORT_FIELD_3 DESC                                   
MFA-TR*        END-EXEC                                                         
           ELSE                                                         
               EXEC SQL                                                 
                   DECLARE C2 CURSOR  FOR                    
                   SELECT :S-RETURN-CODE    AS RETURN_CODE,             
                          :S-STATUS-CODE    AS STATUS_CODE,             
                          :S-NAME           AS NAME,                    
                          :S-ADDRESS        AS SERV_ADDRESS,            
                          :S-CITY           AS CITY,                    
                          :S-NAME-TYPE      AS NAME_TYPE,               
                          :S-ACCT-TYPE      AS ACCT_TYPE,               
                          :S-ACCT-STATUS    AS ACCT_STATUS,             
                          :S-ACCOUNT-NO     AS ACCOUNT_NO,              
                          :S-CUSTOMER-NO    AS CUSTOMER_NO,             
                          :S-PREMISE-NO     AS PREMISE_NO,              
                          :S-RED-FLAG-IND   AS RED_FLAG_IND,            
                          :S-ARCHIVE-IND    AS ARCHIVE_IND,             
                          :S-GROUP-CD       AS GROUP_CD,                
                          :S-UTIL-SVC-STRT  AS UTIL_SVC_STRT,           
                          :S-UTIL-SVC-END   AS UTIL_SVC_END,            
                          :S-ACCT-SUB-TYPE  AS ACCT_SUB_TYPE,           
A05317                    :S-SORT-FIELD-1   AS SORT_FIELD_1,            
A05317                    :S-SORT-FIELD-2   AS SORT_FIELD_2,            
A05317                    :S-SORT-FIELD-3   AS SORT_FIELD_3             
                   FROM   CIS.SYSDUMMY1                              
               END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C2 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT :S-RETURN-CODE    AS RETURN_CODE,                     
MFA-TR*                   :S-STATUS-CODE    AS STATUS_CODE,                     
MFA-TR*                   :S-NAME           AS NAME,                            
MFA-TR*                   :S-ADDRESS        AS SERV_ADDRESS,                    
MFA-TR*                   :S-CITY           AS CITY,                            
MFA-TR*                   :S-NAME-TYPE      AS NAME_TYPE,                       
MFA-TR*                   :S-ACCT-TYPE      AS ACCT_TYPE,                       
MFA-TR*                   :S-ACCT-STATUS    AS ACCT_STATUS,                     
MFA-TR*                   :S-ACCOUNT-NO     AS ACCOUNT_NO,                      
MFA-TR*                   :S-CUSTOMER-NO    AS CUSTOMER_NO,                     
MFA-TR*                   :S-PREMISE-NO     AS PREMISE_NO,                      
MFA-TR*                   :S-RED-FLAG-IND   AS RED_FLAG_IND,                    
MFA-TR*                   :S-ARCHIVE-IND    AS ARCHIVE_IND,                     
MFA-TR*                   :S-GROUP-CD       AS GROUP_CD,                        
MFA-TR*                   :S-UTIL-SVC-STRT  AS UTIL_SVC_STRT,                   
MFA-TR*                   :S-UTIL-SVC-END   AS UTIL_SVC_END,                    
MFA-TR*                   :S-ACCT-SUB-TYPE  AS ACCT_SUB_TYPE,                   
MFA-TR*                   :S-SORT-FIELD-1   AS SORT_FIELD_1,                    
MFA-TR*                   :S-SORT-FIELD-2   AS SORT_FIELD_2,                    
MFA-TR*                   :S-SORT-FIELD-3   AS SORT_FIELD_3                     
MFA-TR*            FROM   SYSIBM.SYSDUMMY1                                      
MFA-TR*        END-EXEC.                                                        
           END-IF.                                                
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0200S-EXIT.                                                      
            EXIT.                                                       
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-SEARCH-METHOD TO PARM-SEARCH-METHOD.               
           MOVE LINK-LIMITS TO PARM-LIMITS.                             
           MOVE LINK-FILTERS TO PARM-FILTERS.                           
           MOVE LINK-CRITERIA TO PARM-CRITERIA.                         
           IF PARM-LOCAL-OFFICE > ' '                                   
              MOVE PARM-LOCAL-OFFICE TO LOCAL-OFFICE-LIMIT
           END-IF.             
           IF PARM-CITY  > ' '                                          
              MOVE PARM-CITY TO CITY-LIMIT
           END-IF.                             
           IF PARM-STATE  > ' '                                         
              MOVE PARM-STATE TO STATE-LIMIT
           END-IF.                           
           IF PARM-COMPANY-NO = 'A' OR 'D' OR 'R'                       
               MOVE PARM-COMPANY-NO TO PARM-DIVISION                    
               MOVE '01' TO PARM-COMPANY-NO
           END-IF.                            
           IF PARM-COMPANY-NO = '##'                                    
              MOVE SPACES TO COMPANY-LIMIT
           END-IF.                             
           IF PARM-COMPANY-NO > ' '                                     
              MOVE PARM-COMPANY-NO TO COMPANY-LIMIT
           END-IF.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE TRUE                                                
               WHEN SEL-METH-NAM                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO NAM-LAST-NAME                               
                            NAM-FIRST-NAME                              
                            NAM-MIDDLE-NAME                             
                            NAM-BUSINESS-NAME                           
                            NAM-STREET-NAME                             
                            WS-MULTIPLIER                               
                                                                        
                   IF NAM-LAST-NAME > ' '                               
                       MOVE 0 TO WS-STAR-COUNT                          
                       MOVE 'I' TO WS-NAME-FORMAT                       
                       INSPECT NAM-LAST-NAME TALLYING WS-STAR-COUNT     
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-LAST-NAME REPLACING ALL          
                                '*' BY '%'                              
                           MOVE FUNCTION REVERSE(NAM-LAST-NAME) TO      
                                NAM-LAST-NAME                           
                           INSPECT NAM-LAST-NAME REPLACING LEADING      
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-LAST-NAME) TO      
                                NAM-LAST-NAME                           
                       END-IF                                           
                   END-IF                                               
                   IF NAM-FIRST-NAME > ' '                              
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT NAM-FIRST-NAME TALLYING WS-STAR-COUNT    
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-FIRST-NAME REPLACING ALL         
                                '*' BY '%'                              
                           MOVE FUNCTION REVERSE(NAM-FIRST-NAME) TO     
                                NAM-FIRST-NAME                          
                           INSPECT NAM-FIRST-NAME REPLACING LEADING     
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-FIRST-NAME) TO     
                                NAM-FIRST-NAME                          
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO NAM-FIRST-NAME                   
                   END-IF                                               
                   IF NAM-MIDDLE-NAME > ' '                             
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT NAM-MIDDLE-NAME TALLYING WS-STAR-COUNT   
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-MIDDLE-NAME REPLACING ALL        
                               '*' BY '%'                               
                           MOVE FUNCTION REVERSE(NAM-MIDDLE-NAME) TO    
                                NAM-MIDDLE-NAME                         
                           INSPECT NAM-MIDDLE-NAME REPLACING LEADING    
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-MIDDLE-NAME) TO    
                                NAM-MIDDLE-NAME                         
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO NAM-MIDDLE-NAME                  
                   END-IF                                               
                   IF NAM-BUSINESS-NAME > ' '                           
                       MOVE 'B' TO WS-NAME-FORMAT                       
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT NAM-BUSINESS-NAME TALLYING WS-STAR-COUNT 
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-BUSINESS-NAME                    
                                   REPLACING ALL '*' BY '%'             
                           MOVE FUNCTION REVERSE(NAM-BUSINESS-NAME) TO  
                                NAM-BUSINESS-NAME                       
                           INSPECT NAM-BUSINESS-NAME REPLACING LEADING  
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-BUSINESS-NAME) TO  
                                NAM-BUSINESS-NAME                       
                       END-IF                                           
                   END-IF                                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-ADD                                        
               WHEN SEL-METH-CUR                                        
               WHEN SEL-METH-GAS                                        
               WHEN SEL-METH-LIG                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO ADD-ADDRESS-TYPE                            
                            ADD-STREET-NBR                              
                            ADD-PREFIX-1                                
                            ADD-PREFIX-2                                
                            ADD-STREET-NAME                             
                            ADD-LOCATION-1                              
                            ADD-LOCATION-2                              
                            ADD-CITY                                    
                            ADD-OVERFLOW                                
                            ADD-BLOCK                                   
                            ADD-LOT                                     
                            WS-MULTIPLIER                               
                                                                        
                   MOVE 'N' TO WS-LOT-BLOCK                             
                   IF ADD-STREET-NBR > ' '                              
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT ADD-STREET-NBR TALLYING WS-STAR-COUNT    
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT ADD-STREET-NBR REPLACING ALL         
                               '*' BY '%'                               
                           MOVE FUNCTION REVERSE(ADD-STREET-NBR) TO     
                               ADD-STREET-NBR                           
                           INSPECT ADD-STREET-NBR REPLACING LEADING     
                               SPACES BY '%'                            
                           MOVE FUNCTION REVERSE(ADD-STREET-NBR) TO     
                               ADD-STREET-NBR                           
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO ADD-STREET-NBR                   
                   END-IF                                               
                   IF ADD-PREFIX-1 = ' '                                
                       MOVE ALL '%' TO ADD-PREFIX-1                     
                   END-IF                                               
                   IF ADD-PREFIX-2 = ' '                                
                       MOVE ALL '%' TO ADD-PREFIX-2                     
                   END-IF                                               
                   IF ADD-STREET-NAME > ' '                             
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT ADD-STREET-NAME TALLYING WS-STAR-COUNT   
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT ADD-STREET-NAME REPLACING ALL        
                               '*' BY '%'                               
                           MOVE FUNCTION REVERSE(ADD-STREET-NAME) TO    
                               ADD-STREET-NAME                          
                           INSPECT ADD-STREET-NAME REPLACING LEADING    
                               SPACES BY '%'                            
                           MOVE FUNCTION REVERSE(ADD-STREET-NAME) TO    
                               ADD-STREET-NAME                          
                           MOVE ADD-STREET-NAME TO INT-OVERFLOW         
                           MOVE ALL '%' TO INT-OVERFLOW(31:5)           
                       ELSE                                             
                           MOVE ADD-STREET-NAME TO INT-OVERFLOW         
                           MOVE SPACES TO INT-OVERFLOW(31:5)            
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO ADD-STREET-NAME                  
                   END-IF                                               
                   IF ADD-LOCATION-1 = ' '                              
                       MOVE ALL '%' TO ADD-LOCATION-1                   
                   END-IF                                               
                   IF ADD-LOCATION-2 > ' '                              
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT ADD-LOCATION-2 TALLYING WS-STAR-COUNT    
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT ADD-LOCATION-2 REPLACING ALL         
                               '*' BY '%'                               
                           MOVE FUNCTION REVERSE(ADD-LOCATION-2) TO     
                               ADD-LOCATION-2                           
                           INSPECT ADD-LOCATION-2 REPLACING LEADING     
                               SPACES BY '%'                            
                           MOVE FUNCTION REVERSE(ADD-LOCATION-2) TO     
                               ADD-LOCATION-2                           
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO ADD-LOCATION-2                   
                   END-IF                                               
                   IF ADD-CITY > ' '                                    
      *                MOVE 0 TO WS-STAR-COUNT                                  
      *                INSPECT ADD-CITY TALLYING WS-STAR-COUNT                  
      *                    FOR ALL '*'                                          
      *                IF WS-STAR-COUNT > 0                                     
                           MOVE ADD-CITY TO ADD-CITY-L                  
                           INSPECT ADD-CITY-L REPLACING ALL '*' BY      
                               LOW-VALUES                               
                           MOVE FUNCTION REVERSE(ADD-CITY-L) TO         
                               ADD-CITY-L                               
                           INSPECT ADD-CITY-L REPLACING LEADING         
                               SPACES BY LOW-VALUES                     
                           MOVE FUNCTION REVERSE(ADD-CITY-L) TO         
                               ADD-CITY-L                               
                           MOVE ADD-CITY TO ADD-CITY-H                  
                           INSPECT ADD-CITY-H REPLACING ALL '*' BY      
                               HIGH-VALUES                              
                           MOVE FUNCTION REVERSE(ADD-CITY-H) TO         
                               ADD-CITY-H                               
                           INSPECT ADD-CITY-H REPLACING LEADING         
                               SPACES BY HIGH-VALUES                    
                           MOVE FUNCTION REVERSE(ADD-CITY-H) TO         
                               ADD-CITY-H                               
                           INSPECT ADD-CITY REPLACING ALL '*' BY '%'    
                           MOVE FUNCTION REVERSE(ADD-CITY) TO           
                               ADD-CITY                                 
                           INSPECT ADD-CITY REPLACING LEADING           
                               SPACES BY '%'                            
                           MOVE FUNCTION REVERSE(ADD-CITY) TO           
                               ADD-CITY                                 
      *                END-IF                                                   
                   ELSE                                                 
                       MOVE ALL '%' TO ADD-CITY                         
                   END-IF                                               
                   IF ADD-OVERFLOW > ' '                                
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT ADD-OVERFLOW TALLYING WS-STAR-COUNT      
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT ADD-OVERFLOW REPLACING ALL           
                               '*' BY '%'                               
                           MOVE FUNCTION REVERSE(ADD-OVERFLOW) TO       
                               ADD-OVERFLOW                             
                           INSPECT ADD-OVERFLOW REPLACING LEADING       
                               SPACES BY '%'                            
                           MOVE FUNCTION REVERSE(ADD-OVERFLOW) TO       
                               ADD-OVERFLOW                             
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO ADD-OVERFLOW                     
                   END-IF                                               
                   MOVE ADD-OVERFLOW TO INT-STREET-NAME                 
                   IF ADD-BLOCK > ' '                                   
                       MOVE 'Y' TO WS-LOT-BLOCK                         
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT ADD-BLOCK TALLYING WS-STAR-COUNT         
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT ADD-BLOCK REPLACING ALL '*' BY '%'   
                           MOVE FUNCTION REVERSE(ADD-BLOCK) TO          
                               ADD-BLOCK                                
                           INSPECT ADD-BLOCK REPLACING LEADING          
                               SPACES BY '%'                            
                           MOVE FUNCTION REVERSE(ADD-BLOCK) TO          
                               ADD-BLOCK                                
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO ADD-BLOCK                        
                   END-IF                                               
                   IF ADD-LOT > ' '                                     
                       MOVE 'Y' TO WS-LOT-BLOCK                         
                       MOVE 0 TO WS-STAR-COUNT                          
                       INSPECT ADD-LOT TALLYING WS-STAR-COUNT           
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT ADD-LOT REPLACING ALL '*' BY '%'     
                           MOVE FUNCTION REVERSE(ADD-LOT) TO            
                               ADD-LOT                                  
                           INSPECT ADD-LOT REPLACING LEADING            
                               SPACES BY '%'                            
                           MOVE FUNCTION REVERSE(ADD-LOT) TO            
                               ADD-LOT                                  
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO ADD-LOT                          
                   END-IF                                               
                   MOVE 0 TO WS-HOLD-PREMISE-NO                         
                             WS-HOLD-ACCOUNT-NO                         
                   MOVE 'N' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
                   MOVE 'Y' TO WS-NEED-TOWN                             
                                                                        
               WHEN SEL-METH-CUS                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO CUS-CUST-NO                                 
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-ACC                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO ACC-ACCT-NO                                 
                            ACC-OLD-ACCT-NO                             
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                   MOVE 'YYYYYY' TO PARM-FILTERS                        
                   IF ACC-ACCT-NO NOT = SPACES                          
                       INSPECT ACC-ACCT-NO REPLACING ALL SPACES BY '0'  
                       IF ACC-ACCT-NO NOT NUMERIC                       
                           MOVE ZEROES TO ACC-ACCT-NO                   
                       END-IF                                           
                   END-IF                                               
                   IF ACC-OLD-ACCT-NO NOT = SPACES                      
                       INSPECT ACC-OLD-ACCT-NO REPLACING                
                               ALL SPACES BY '0'                        
                       IF ACC-OLD-ACCT-NO NOT NUMERIC                   
                           MOVE ZEROES TO ACC-OLD-ACCT-NO               
                       END-IF                                           
                   END-IF                                               
                                                                        
               WHEN SEL-METH-OTH                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO OTH-ID-NUMBER                               
                            OTH-ID-TYPE                                 
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-MET                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO MET-CODE-UTIL-TYPE                          
                            MET-NUMBER                                  
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-DLN                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO DLN-NUMBER                                  
                            WS-MULTIPLIER                               
A05317             IF WS-MULTIPLIER NOT NUMERIC                         
A05317                 MOVE '00' TO WS-MULTIPLIER                       
A05317             END-IF                                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-SSN                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO SSN-NUMBER                                  
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-PHO                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO PHO-NUMBER                                  
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-PIM                                        
               WHEN SEL-METH-POI                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO POI-ID-NUMBER                               
                            WS-MULTIPLIER                               
                   MOVE POI-ID-NUMBER(1:3) TO WS-GIS-LOC-OFF            
                   MOVE SPACES             TO WS-TAG-NM                 
                   MOVE POI-ID-NUMBER(4:7) TO WS-TAG-NM                 
                   MOVE 0 TO WS-HOLD-PREMISE-NO                         
                             WS-HOLD-ACCOUNT-NO                         
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-TAX                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO TAX-ID-NUMBER                               
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-MAS                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO MAS-LAST-NAME                               
                            MAS-FIRST-NAME                              
                            MAS-MIDDLE-NAME                             
                            MAS-BUSINESS-NAME                           
                            MAS-ACCT-NO                                 
                            WS-MULTIPLIER                               
                                                                        
                   MOVE SPACES TO NAM-STREET-NAME                       
                   IF MAS-LAST-NAME > ' '                               
                       MOVE 0 TO WS-STAR-COUNT                          
                       MOVE 'I' TO WS-NAME-FORMAT                       
                       MOVE MAS-LAST-NAME TO NAM-LAST-NAME              
                       INSPECT NAM-LAST-NAME TALLYING WS-STAR-COUNT     
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-LAST-NAME REPLACING ALL          
                                '*' BY '%'                              
                           MOVE FUNCTION REVERSE(NAM-LAST-NAME) TO      
                                NAM-LAST-NAME                           
                           INSPECT NAM-LAST-NAME REPLACING LEADING      
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-LAST-NAME) TO      
                                NAM-LAST-NAME                           
                       END-IF                                           
                   END-IF                                               
                   IF MAS-FIRST-NAME > ' '                              
                       MOVE 0 TO WS-STAR-COUNT                          
                       MOVE MAS-FIRST-NAME TO NAM-FIRST-NAME            
                       INSPECT NAM-FIRST-NAME TALLYING WS-STAR-COUNT    
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-FIRST-NAME REPLACING ALL         
                                '*' BY '%'                              
                           MOVE FUNCTION REVERSE(NAM-FIRST-NAME) TO     
                                NAM-FIRST-NAME                          
                           INSPECT NAM-FIRST-NAME REPLACING LEADING     
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-FIRST-NAME) TO     
                                NAM-FIRST-NAME                          
                       END-IF                                           
                   ELSE                                                 
                       MOVE ALL '%' TO NAM-FIRST-NAME                   
                   END-IF                                               
                   IF MAS-MIDDLE-NAME > ' '                             
                       MOVE 0 TO WS-STAR-COUNT                          
                       MOVE MAS-MIDDLE-NAME TO NAM-MIDDLE-NAME          
                       INSPECT NAM-MIDDLE-NAME TALLYING WS-STAR-COUNT   
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-MIDDLE-NAME REPLACING ALL        
                               '*' BY '%'                               
                           MOVE FUNCTION REVERSE(NAM-MIDDLE-NAME) TO    
                                NAM-MIDDLE-NAME                         
                           INSPECT NAM-MIDDLE-NAME REPLACING LEADING    
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-MIDDLE-NAME) TO    
                                NAM-MIDDLE-NAME                         
                        END-IF                                          
                   ELSE                                                 
                       MOVE ALL '%' TO NAM-MIDDLE-NAME                  
                   END-IF                                               
                   IF MAS-BUSINESS-NAME > ' '                           
                       MOVE 'B' TO WS-NAME-FORMAT                       
                       MOVE 0 TO WS-STAR-COUNT                          
                       MOVE MAS-BUSINESS-NAME TO NAM-BUSINESS-NAME      
                       INSPECT NAM-BUSINESS-NAME TALLYING WS-STAR-COUNT 
                           FOR ALL '*'                                  
                       IF WS-STAR-COUNT > 0                             
                           INSPECT NAM-BUSINESS-NAME                    
                                   REPLACING ALL'*' BY '%'              
                           MOVE FUNCTION REVERSE(NAM-BUSINESS-NAME) TO  
                                NAM-BUSINESS-NAME                       
                           INSPECT NAM-BUSINESS-NAME REPLACING LEADING  
                                SPACES BY '%'                           
                           MOVE FUNCTION REVERSE(NAM-BUSINESS-NAME) TO  
                                NAM-BUSINESS-NAME                       
                       END-IF                                           
                   END-IF                                               
                   IF MAS-ACCT-NO = ' '                                 
                       MOVE ZEROES TO MAS-ACCT-NO                       
                   END-IF                                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'N' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-LOC                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO LOC-ID-NUMBER                               
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
                   MOVE LOC-ID-NUMBER TO LOC-ID-NUMBER-L                
                                         LOC-ID-NUMBER-H                
                                                                        
               WHEN SEL-METH-SUB                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO SUBDIVISION-ID                              
                            WS-MULTIPLIER                               
                   MOVE 'N' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
                   MOVE 'Y' TO WS-NEED-TOWN                             
                                                                        
               WHEN SEL-METH-PMS                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO PMS-PREM-NO                                 
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
                                                                        
P00778         WHEN SEL-METH-AGP                                        
P00778             UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
P00778                 INTO PMS-AGL-PREM-NO                             
P00778                      WS-MULTIPLIER                               
P00778             MOVE 'Y' TO WS-NEED-ADDRESS                          
P00778             MOVE 'Y' TO WS-NEED-NAME                             
                                                                        
               WHEN SEL-METH-SON                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO SON-ORDER-NO                                
                            WS-MULTIPLIER                               
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   MOVE 'Y' TO WS-NEED-NAME                             
A05317             MOVE 'Y' TO PARM-FINAL-BILL-FL                       
A05317                         PARM-PENDING-FL                          
A05317                         PARM-WRITE-OFF-FL                        
A05317                         PARM-ARCHIVE-FL                          
                                                                        
P00837         WHEN SEL-METH-MGR                                        
P00837             UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
P00837                 INTO MGR-LAST-NAME                               
P00837                      MGR-FIRST-NAME                              
P00837                      WS-MULTIPLIER                               
P00837             MOVE 'Y' TO WS-NEED-ADDRESS                          
P00837             MOVE 'Y' TO WS-NEED-NAME                             
                                                                        
P00870         WHEN SEL-METH-REF                                        
P00870             UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
P00870                 INTO REF-CHECK-NO                                
P00870                      WS-MULTIPLIER                               
P00870             MOVE 'Y' TO WS-NEED-ADDRESS                          
                                                                        
           END-EVALUATE.                                                
                                                                        
      *****************************************************************         
      ** IF A MULTIPLIER IS SENT UP MULTIPLY IT BY THE MAX ROWS, WHICH          
      ** IS CURRENTLY 50.  THIS WILL TELL THE RPC WHEN TO ACTUALLY              
      ** START SENDING THE RESULT TO THE CLIENT                                 
      *****************************************************************         
                                                                        
           IF WS-NEXT-MULTIPLIER > 0                                    
              COMPUTE WS-NEXT-COUNTER =                                 
                   WS-NEXT-MULTIPLIER * CN-MAX-RETURN-ROWS              
              ADD  1  TO WS-NEXT-COUNTER
           END-IF.                               
                                                                        
           PERFORM 7000-DETERMINE-REGION THRU 7000-EXIT.                
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-TODAYS-DATE                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-TODAYS-DATE TO WS-RED-FLAG-TS(1:10).                 
           MOVE '-00.00.00.000000' TO WS-RED-FLAG-TS(11:16).            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
               WHEN (SEL-METH-ADD AND SERVICE-ADDRESS)                  
               WHEN (SEL-METH-CUR)                                      
                   IF WS-LOT-BLOCK = 'Y'                                
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2212-SERVADDR-BY-LO-LB THRU      
                                       2212-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2213-SERVADDR-BY-CITY-LB THRU    
                                       2213-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2211-SERVADDR-LB THRU            
                                       2211-EXIT                        
                       END-EVALUATE                                     
                   ELSE                                                 
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2208-SERVADDR-BY-LO THRU         
                                       2208-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2209-SERVADDR-BY-CITY THRU       
                                       2209-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2210-SERVADDR THRU 2210-EXIT     
                     END-EVALUATE                                       
                   END-IF                                               
               WHEN (SEL-METH-ADD AND BILLING-ADDRESS)                  
                   MOVE 'Y' TO WS-NEED-ADDRESS                          
                   EVALUATE TRUE                                        
                       WHEN PARM-LOCAL-OFFICE > ' '                     
                           PERFORM 2214-BILLADDR-BY-LO THRU 2214-EXIT   
                       WHEN PARM-CITY > ' '                             
                           PERFORM 2216-BILLADDR-BY-CITY THRU 2216-EXIT 
                       WHEN OTHER                                       
                           PERFORM 2215-BILLADDR THRU 2215-EXIT         
                   END-EVALUATE                                         
               WHEN (SEL-METH-ADD AND INTERSECTION-ADDRESS)             
                   MOVE 'I' TO WS-ADDRESS-FORMAT                        
                   EVALUATE TRUE                                        
                       WHEN PARM-LOCAL-OFFICE > ' '                     
                           PERFORM 2217-INTERADDR-BY-LO THRU            
                                   2217-EXIT                            
                       WHEN PARM-CITY > ' '                             
                           PERFORM 2219-INTERADDR-BY-CITY THRU          
                                   2219-EXIT                            
                       WHEN OTHER                                       
                           PERFORM 2218-INTERADDR THRU 2218-EXIT        
                  END-EVALUATE                                          
               WHEN (SEL-METH-NAM OR                                    
                    (SEL-METH-MAS AND MAS-ACCT-NO-NUM = 0))             
                   IF NAM-STREET-NAME = SPACES                          
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2221-NAME-BY-LO-NO-STREET THRU   
                                       2221-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2222-NAME-BY-CITY-NO-STREET THRU 
                                       2222-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2220-NAME-NO-STREET THRU         
                                       2220-EXIT                        
                       END-EVALUATE                                     
                  ELSE                                                  
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2223-NAME-BY-LO-STREET THRU      
                                       2223-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2224-NAME-BY-CITY-STREET THRU    
                                       2224-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2226-NAME-STREET THRU            
                                       2226-EXIT                        
                    END-EVALUATE                                        
                  END-IF                                                
               WHEN ((SEL-METH-ACC AND ACC-ACCT-NO-NUM NOT = 0) OR      
                   (SEL-METH-MAS AND MAS-ACCT-NO-NUM NOT = 0))          
                   PERFORM 2230-ACCOUNT-SEARCH THRU 2230-EXIT           
               WHEN SEL-METH-CUS                                        
                   PERFORM 2240-CUSTOMER-SEARCH THRU 2240-EXIT          
               WHEN SEL-METH-MET                                        
                   PERFORM 2260-METER-SEARCH THRU 2260-EXIT             
               WHEN SEL-METH-SSN                                        
                   PERFORM 2250A-SSN-SEARCH THRU 2250A-EXIT             
               WHEN SEL-METH-DLN                                        
                   PERFORM 2250B-DLN-SEARCH THRU 2250B-EXIT             
               WHEN SEL-METH-OTH                                        
A05317             IF OTH-ID-TYPE = 'ITIN'                              
A05317                 PERFORM 2250D-ITIN-SEARCH THRU 2250D-EXIT        
A05317             ELSE                                                 
                       PERFORM 2250C-OTHER-ID-SEARCH THRU 2250C-EXIT    
A05317             END-IF                                               
               WHEN SEL-METH-PHO                                        
                   PERFORM 2360-PHONE-SEARCH THRU 2360-EXIT             
               WHEN SEL-METH-TAX                                        
                   PERFORM 2270-TAX-ID-SEARCH THRU 2270-EXIT            
               WHEN SEL-METH-POI                                        
               WHEN SEL-METH-PIM                                        
                   PERFORM 2290-POINT-ID-SEARCH THRU 2290-EXIT          
               WHEN SEL-METH-LOC                                        
                   PERFORM 2295-LOCATOR-SEARCH THRU 2295-EXIT           
               WHEN SEL-METH-SUB                                        
                   PERFORM 2330-SUBDIV-SEARCH THRU 2330-EXIT            
               WHEN SEL-METH-PMS                                        
                   PERFORM 2340-PREMISE-SEARCH THRU 2340-EXIT           
               WHEN SEL-METH-AGP                                        
                   PERFORM 2345-AGL-PREM-SEARCH THRU 2345-EXIT          
               WHEN SEL-METH-SON                                        
                   PERFORM 2350-SERV-ORDER-SEARCH THRU 2350-EXIT        
P00837         WHEN SEL-METH-MGR                                        
P00837             PERFORM 2370-ACCOUNT-MGR-SEARCH THRU 2370-EXIT       
P00870         WHEN SEL-METH-REF                                        
P00870             PERFORM 2380-REFUND-CHECK-SEARCH THRU 2380-EXIT      
               WHEN SEL-METH-GAS                                        
                   IF WS-LOT-BLOCK = 'Y'                                
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2361-GASADDR-BY-LO-LB THRU       
                                       2361-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2362-GASADDR-BY-CITY-LB THRU     
                                       2362-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2363-GASADDR-LB THRU 2363-EXIT   
                       END-EVALUATE                                     
                   ELSE                                                 
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2201-GASADDR-BY-LO THRU          
                                       2201-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2202-GASADDR-BY-CITY THRU        
                                       2202-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2203-GASADDR THRU 2203-EXIT      
                  END-EVALUATE                                          
                  END-IF                                                
               WHEN SEL-METH-LIG                                        
                   IF WS-LOT-BLOCK = 'Y'                                
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2364-LIGHTADDR-BY-LO-LB THRU     
                                       2364-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2365-LIGHTADDR-BY-CITY-LB THRU   
                                       2365-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2366-LIGHTADDR-LB THRU 2366-EXIT 
                      END-EVALUATE                                      
                   ELSE                                                 
                       EVALUATE TRUE                                    
                           WHEN PARM-LOCAL-OFFICE > ' '                 
                               PERFORM 2204-LIGHTADDR-BY-LO THRU        
                                       2204-EXIT                        
                           WHEN PARM-CITY > ' '                         
                               PERFORM 2205-LIGHTADDR-BY-CITY THRU      
                                       2205-EXIT                        
                           WHEN OTHER                                   
                               PERFORM 2206-LIGHTADDR THRU 2206-EXIT    
                      END-EVALUATE                                      
                  END-IF                                                
           END-EVALUATE.                                                
                                                                        
           IF  SEL-METH-ACC                                             
               IF CTR-ROWS = ZERO                                       
                  MOVE NOT-FOUND TO S-RETURN-CODE                       
               END-IF                                                   
               EVALUATE LINK-DETAILED-DATA                              
                   WHEN 'Y'                                             
                       EXEC SQL                                         
                            OPEN C4                                     
                       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                         
                   WHEN 'N'                                             
                       EXEC SQL                                         
                           OPEN C2                                      
                       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                         
               END-EVALUATE                                             
               GO TO 2000-EXIT
           END-IF.                                         
                                                                        
           IF  CTR-ROWS = 0                                             
               MOVE NOT-FOUND TO S-RETURN-CODE                          
               EVALUATE LINK-DETAILED-DATA                              
                   WHEN 'Y'                                             
                       PERFORM 8300-SEND-RESULT THRU 8300-EXIT          
                   WHEN 'N'                                             
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF  CTR-ROWS = CN-MAX-RETURN-ROWS                            
               MOVE 101 TO S-RETURN-CODE                                
               EVALUATE LINK-DETAILED-DATA                              
                   WHEN 'Y'                                             
                       PERFORM 8300-SEND-RESULT THRU 8300-EXIT          
                   WHEN 'N'                                             
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
               END-EVALUATE
           END-IF.                                            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2201-GASADDR-BY-LO.                                              
                                                                        
           PERFORM 7365-OPEN-DY-UT-CURSOR-L THRU 7365-EXIT.             
           PERFORM 7366-FETCH-DY-UT-CURSOR-L THRU 7366-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7366-FETCH-DY-UT-CURSOR-L THRU 7366-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7367-CLOSE-DY-UT-CURSOR-L THRU 7367-EXIT.            
                                                                        
       2201-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2202-GASADDR-BY-CITY.                                            
                                                                        
           PERFORM 7368-OPEN-DY-UT-CURSOR-C THRU 7368-EXIT.             
           PERFORM 7369-FETCH-DY-UT-CURSOR-C THRU 7369-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7369-FETCH-DY-UT-CURSOR-C THRU 7369-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7370-CLOSE-DY-UT-CURSOR-C THRU 7370-EXIT.            
                                                                        
       2202-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2203-GASADDR.                                                    
                                                                        
           PERFORM 7371-OPEN-DY-UT-CURSOR THRU 7371-EXIT.               
           PERFORM 7372-FETCH-DY-UT-CURSOR THRU 7372-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7372-FETCH-DY-UT-CURSOR THRU 7372-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7373-CLOSE-DY-UT-CURSOR THRU 7373-EXIT.              
                                                                        
       2203-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2204-LIGHTADDR-BY-LO.                                            
                                                                        
           PERFORM 7374-OPEN-DY-LG-CURSOR-L THRU 7374-EXIT.             
           PERFORM 7375-FETCH-DY-LG-CURSOR-L THRU 7375-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7375-FETCH-DY-LG-CURSOR-L THRU 7375-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7376-CLOSE-DY-LG-CURSOR-L THRU 7376-EXIT.            
                                                                        
       2204-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2205-LIGHTADDR-BY-CITY.                                          
                                                                        
           PERFORM 7377-OPEN-DY-LG-CURSOR-C THRU 7377-EXIT.             
           PERFORM 7378-FETCH-DY-LG-CURSOR-C THRU 7378-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7378-FETCH-DY-LG-CURSOR-C THRU 7378-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7379-CLOSE-DY-LG-CURSOR-C THRU 7379-EXIT.            
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2206-LIGHTADDR.                                                  
                                                                        
           PERFORM 7380-OPEN-DY-LG-CURSOR THRU 7380-EXIT.               
           PERFORM 7381-FETCH-DY-LG-CURSOR THRU 7381-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7381-FETCH-DY-LG-CURSOR THRU 7381-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7382-CLOSE-DY-LG-CURSOR THRU 7382-EXIT.              
                                                                        
       2206-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2207-GAS-MTR-SEARCH.                                             
                                                                        
           PERFORM 7401-OPEN-G-MTR-CURSOR THRU 7401-EXIT.               
           PERFORM 7402-FETCH-G-MTR-CURSOR THRU 7402-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               MOVE MN-METER-NO TO S-METER-NO                           
               MOVE MN-CODE-METER-STATUS TO S-METER-STATUS              
               MOVE MN-CODE-METER-LOC TO S-METER-LOC                    
               MOVE MN-REGISTER-RD-SEQ TO S-METER-READ-SEQ              
               PERFORM 8300-SEND-RESULT THRU 8300-EXIT                  
               PERFORM 7402-FETCH-G-MTR-CURSOR THRU 7402-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7403-CLOSE-G-MTR-CURSOR THRU 7403-EXIT.              
                                                                        
       2207-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2208-SERVADDR-BY-LO.                                             
                                                                        
           PERFORM 7201-OPEN-DY-HT-CURSOR-L THRU 7201-EXIT.             
           PERFORM 7202-FETCH-DY-HT-CURSOR-L THRU 7202-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7202-FETCH-DY-HT-CURSOR-L THRU 7202-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7203-CLOSE-DY-HT-CURSOR-L THRU 7203-EXIT.            
                                                                        
       2208-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2209-SERVADDR-BY-CITY.                                           
                                                                        
           PERFORM 7204-OPEN-DY-HT-CURSOR-C THRU 7204-EXIT.             
           PERFORM 7205-FETCH-DY-HT-CURSOR-C THRU 7205-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7205-FETCH-DY-HT-CURSOR-C THRU 7205-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7206-CLOSE-DY-HT-CURSOR-C THRU 7206-EXIT.            
                                                                        
       2209-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-SERVADDR.                                                   
                                                                        
           PERFORM 7211-OPEN-DY-HT-CURSOR THRU 7211-EXIT.               
           PERFORM 7212-FETCH-DY-HT-CURSOR THRU 7212-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7212-FETCH-DY-HT-CURSOR THRU 7212-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7213-CLOSE-DY-HT-CURSOR THRU 7213-EXIT.              
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2211-SERVADDR-LB.                                                
                                                                        
           PERFORM 7280-OPEN-DY-PR-CURSOR THRU 7280-EXIT.               
           PERFORM 7281-FETCH-DY-PR-CURSOR THRU 7281-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7281-FETCH-DY-PR-CURSOR THRU 7281-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7282-CLOSE-DY-PR-CURSOR THRU 7282-EXIT.              
                                                                        
       2211-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2212-SERVADDR-BY-LO-LB.                                          
                                                                        
           PERFORM 7207-OPEN-DY-PR-CURSOR-L THRU 7207-EXIT.             
           PERFORM 7208-FETCH-DY-PR-CURSOR-L THRU 7208-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7208-FETCH-DY-PR-CURSOR-L THRU 7208-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7209-CLOSE-DY-PR-CURSOR-L THRU 7209-EXIT.            
                                                                        
       2212-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2213-SERVADDR-BY-CITY-LB.                                        
                                                                        
           PERFORM 7227-OPEN-DY-PR-CURSOR-C THRU 7227-EXIT.             
           PERFORM 7228-FETCH-DY-PR-CURSOR-C THRU 7228-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7228-FETCH-DY-PR-CURSOR-C THRU 7228-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7229-CLOSE-DY-PR-CURSOR-C THRU 7229-EXIT.            
                                                                        
       2213-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2214-BILLADDR-BY-LO.                                             
                                                                        
           PERFORM 7244-OPEN-DY-AQ-CURSOR-L THRU 7244-EXIT.             
           PERFORM 7245-FETCH-DY-AQ-CURSOR-L THRU 7245-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7245-FETCH-DY-AQ-CURSOR-L THRU 7245-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7246-CLOSE-DY-AQ-CURSOR-L THRU 7246-EXIT.            
                                                                        
       2214-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2215-BILLADDR.                                                   
                                                                        
           PERFORM 7214-OPEN-DY-AQ-CURSOR THRU 7214-EXIT.               
           PERFORM 7215-FETCH-DY-AQ-CURSOR THRU 7215-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7215-FETCH-DY-AQ-CURSOR THRU 7215-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7216-CLOSE-DY-AQ-CURSOR THRU 7216-EXIT.              
                                                                        
       2215-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2216-BILLADDR-BY-CITY.                                           
                                                                        
           PERFORM 7247-OPEN-DY-AQ-CURSOR-C THRU 7247-EXIT.             
           PERFORM 7248-FETCH-DY-AQ-CURSOR-C THRU 7248-EXIT.            
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7248-FETCH-DY-AQ-CURSOR-C THRU 7248-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7249-CLOSE-DY-AQ-CURSOR-C THRU 7249-EXIT.            
                                                                        
       2216-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2217-INTERADDR-BY-LO.                                            
                                                                        
           PERFORM 7234-OPEN-INT-CURSOR-L THRU 7234-EXIT.               
           PERFORM 7235-FETCH-INT-CURSOR-L THRU 7235-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7235-FETCH-INT-CURSOR-L THRU 7235-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7236-CLOSE-INT-CURSOR-L THRU 7236-EXIT.              
                                                                        
       2217-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2218-INTERADDR.                                                  
                                                                        
           PERFORM 7217-OPEN-INT-CURSOR THRU 7217-EXIT.                 
           PERFORM 7218-FETCH-INT-CURSOR THRU 7218-EXIT.                
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7218-FETCH-INT-CURSOR THRU 7218-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7219-CLOSE-INT-CURSOR THRU 7219-EXIT.                
                                                                        
       2218-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2219-INTERADDR-BY-CITY.                                          
                                                                        
           PERFORM 7237-OPEN-INT-CURSOR-C THRU 7237-EXIT.               
           PERFORM 7238-FETCH-INT-CURSOR-C THRU 7238-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7238-FETCH-INT-CURSOR-C THRU 7238-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7239-CLOSE-INT-CURSOR-C THRU 7239-EXIT.              
                                                                        
       2219-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2220-NAME-NO-STREET.                                             
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
                                                                        
              PERFORM 7221-OPEN-DQ-IND-CURSOR THRU 7221-EXIT            
              PERFORM 7222-FETCH-DQ-IND-CURSOR THRU 7222-EXIT           
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7222-FETCH-DQ-IND-CURSOR THRU 7222-EXIT       
              END-PERFORM                                               
                                                                        
              PERFORM 7223-CLOSE-DQ-IND-CURSOR THRU 7223-EXIT           
           ELSE                                                         
              PERFORM 7224-OPEN-DQ-BUS-CURSOR THRU 7224-EXIT            
              PERFORM 7225-FETCH-DQ-BUS-CURSOR THRU 7225-EXIT           
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7225-FETCH-DQ-BUS-CURSOR THRU 7225-EXIT       
              END-PERFORM                                               
                                                                        
              PERFORM 7226-CLOSE-DQ-BUS-CURSOR THRU 7226-EXIT
           END-IF.          
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2221-NAME-BY-LO-NO-STREET.                                       
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
              PERFORM 7254-OPEN-DQ-IND-CURSOR-L THRU 7254-EXIT          
              PERFORM 7255-FETCH-DQ-IND-CURSOR-L THRU 7255-EXIT         
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7255-FETCH-DQ-IND-CURSOR-L THRU 7255-EXIT     
              END-PERFORM                                               
                                                                        
              PERFORM 7256-CLOSE-DQ-IND-CURSOR-L THRU 7256-EXIT         
           ELSE                                                         
              PERFORM 7264-OPEN-DQ-BUS-CURSOR-L THRU 7264-EXIT          
              PERFORM 7265-FETCH-DQ-BUS-CURSOR-L THRU 7265-EXIT         
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7265-FETCH-DQ-BUS-CURSOR-L THRU 7265-EXIT     
              END-PERFORM                                               
                                                                        
              PERFORM 7266-CLOSE-DQ-BUS-CURSOR-L THRU 7266-EXIT
           END-IF.        
                                                                        
       2221-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2222-NAME-BY-CITY-NO-STREET.                                     
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
              PERFORM 7257-OPEN-DQ-IND-CURSOR-C THRU 7257-EXIT          
              PERFORM 7258-FETCH-DQ-IND-CURSOR-C THRU 7258-EXIT         
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7258-FETCH-DQ-IND-CURSOR-C THRU 7258-EXIT     
              END-PERFORM                                               
                                                                        
              PERFORM 7259-CLOSE-DQ-IND-CURSOR-C THRU 7259-EXIT         
           ELSE                                                         
              PERFORM 7267-OPEN-DQ-BUS-CURSOR-C THRU 7267-EXIT          
              PERFORM 7268-FETCH-DQ-BUS-CURSOR-C THRU 7268-EXIT         
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7268-FETCH-DQ-BUS-CURSOR-C THRU 7268-EXIT     
              END-PERFORM                                               
                                                                        
              PERFORM 7269-CLOSE-DQ-BUS-CURSOR-C THRU 7269-EXIT
           END-IF.        
                                                                        
       2222-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2223-NAME-BY-LO-STREET.                                          
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
              PERFORM 7313-OPEN-DQ-IND-CURSOR-SL THRU 7313-EXIT         
              PERFORM 7314-FETCH-DQ-IND-CURSOR-SL THRU 7314-EXIT        
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7314-FETCH-DQ-IND-CURSOR-SL THRU 7314-EXIT    
              END-PERFORM                                               
                                                                        
              PERFORM 7315-CLOSE-DQ-IND-CURSOR-SL THRU 7315-EXIT        
           ELSE                                                         
              PERFORM 7316-OPEN-DQ-BUS-CURSOR-SL THRU 7316-EXIT         
              PERFORM 7317-FETCH-DQ-BUS-CURSOR-SL THRU 7317-EXIT        
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7317-FETCH-DQ-BUS-CURSOR-SL THRU 7317-EXIT    
              END-PERFORM                                               
                                                                        
              PERFORM 7318-CLOSE-DQ-BUS-CURSOR-SL THRU 7318-EXIT
           END-IF.       
                                                                        
       2223-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2224-NAME-BY-CITY-STREET.                                        
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
              PERFORM 7310-OPEN-DQ-IND-CURSOR-SC THRU 7310-EXIT         
              PERFORM 7311-FETCH-DQ-IND-CURSOR-SC THRU 7311-EXIT        
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7311-FETCH-DQ-IND-CURSOR-SC THRU 7311-EXIT    
              END-PERFORM                                               
                                                                        
              PERFORM 7312-CLOSE-DQ-IND-CURSOR-SC THRU 7312-EXIT        
           ELSE                                                         
              PERFORM 7319-OPEN-DQ-BUS-CURSOR-SC THRU 7319-EXIT         
              PERFORM 7320-FETCH-DQ-BUS-CURSOR-SC THRU 7320-EXIT        
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7320-FETCH-DQ-BUS-CURSOR-SC THRU 7320-EXIT    
              END-PERFORM                                               
                                                                        
              PERFORM 7321-CLOSE-DQ-BUS-CURSOR-SC THRU 7321-EXIT
           END-IF.       
                                                                        
       2224-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2226-NAME-STREET.                                                
                                                                        
           IF WS-NAME-FORMAT = 'I'                                      
              PERFORM 7328-OPEN-DQ-IND-CURSOR-S THRU 7328-EXIT          
              PERFORM 7329-FETCH-DQ-IND-CURSOR-S THRU 7329-EXIT         
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7329-FETCH-DQ-IND-CURSOR-S THRU 7329-EXIT     
              END-PERFORM                                               
                                                                        
              PERFORM 7330-CLOSE-DQ-IND-CURSOR-S THRU 7330-EXIT         
           ELSE                                                         
              PERFORM 7331-OPEN-DQ-BUS-CURSOR-S THRU 7331-EXIT          
              PERFORM 7332-FETCH-DQ-BUS-CURSOR-S THRU 7332-EXIT         
                                                                        
              PERFORM                                                   
                  UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                         CTR-ROWS >= CN-MAX-RETURN-ROWS)                
                  PERFORM 2500-PROCESS-ROW THRU 2500-EXIT               
                  PERFORM 7332-FETCH-DQ-BUS-CURSOR-S THRU 7332-EXIT     
              END-PERFORM                                               
                                                                        
              PERFORM 7333-CLOSE-DQ-BUS-CURSOR-S THRU 7333-EXIT
           END-IF.        
                                                                        
       2226-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2230-ACCOUNT-SEARCH.                                             
                                                                        
           IF SEL-METH-ACC                                              
               IF ACC-ACCT-NO NOT = SPACE                               
                   MOVE ACC-ACCT-NO-NUM TO HT-ACCOUNT-NO                
               ELSE                                                     
                   MOVE ACC-OLD-ACCT-NO-NUM TO XR-OLD-ACCOUNT-NO        
                   PERFORM 2236-SEARCH-XR-CURSOR THRU 2236-EXIT         
                   GO TO 2230-EXIT                                      
               END-IF                                                   
           ELSE                                                         
               MOVE MAS-ACCT-NO-NUM TO HT-ACCOUNT-NO
           END-IF.                   
                                                                        
           PERFORM 2235-SEARCH-AT-CURSOR THRU 2235-EXIT.                
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2235-SEARCH-AT-CURSOR.                                           
                                                                        
           PERFORM 7231-OPEN-AT-CURSOR THRU 7231-EXIT.                  
           PERFORM 7232-FETCH-AT-CURSOR THRU 7232-EXIT.                 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7232-FETCH-AT-CURSOR THRU 7232-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7233-CLOSE-AT-CURSOR THRU 7233-EXIT.                 
                                                                        
       2235-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2236-SEARCH-XR-CURSOR.                                           
                                                                        
           PERFORM 7900-OPEN-XR-CURSOR THRU 7900-EXIT.                  
           PERFORM 7905-FETCH-XR-CURSOR THRU 7905-EXIT.                 
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND OR           
                     CTR-ROWS >= CN-MAX-RETURN-ROWS                     
              MOVE XR-NEW-ACCOUNT-NO TO HT-ACCOUNT-NO                   
              PERFORM 2235-SEARCH-AT-CURSOR THRU 2235-EXIT              
              PERFORM 7905-FETCH-XR-CURSOR THRU 7905-EXIT               
           END-PERFORM.                                                 
                                                                        
           PERFORM 7910-CLOSE-XR-CURSOR THRU 7910-EXIT.                 
                                                                        
       2236-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2240-CUSTOMER-SEARCH.                                            
                                                                        
           MOVE CUS-CUST-NO-NUM TO HT-CUSTOMER-NO.                      
                                                                        
           PERFORM 7241-OPEN-CU-CURSOR THRU 7241-EXIT.                  
           PERFORM 7242-FETCH-CU-CURSOR THRU 7242-EXIT.                 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7242-FETCH-CU-CURSOR THRU 7242-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7243-CLOSE-CU-CURSOR THRU 7243-EXIT.                 
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2250A-SSN-SEARCH.                                                
                                                                        
           PERFORM 7251A-OPEN-CE1-CURSOR THRU 7251A-EXIT.               
           PERFORM 7252A-FETCH-CE1-CURSOR THRU 7252A-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7252A-FETCH-CE1-CURSOR THRU 7252A-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7253A-CLOSE-CE1-CURSOR THRU 7253A-EXIT.              
                                                                        
       2250A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2250B-DLN-SEARCH.                                                
                                                                        
           PERFORM 7251B-OPEN-CE2-CURSOR THRU 7251B-EXIT.               
           PERFORM 7252B-FETCH-CE2-CURSOR THRU 7252B-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7252B-FETCH-CE2-CURSOR THRU 7252B-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7253B-CLOSE-CE2-CURSOR THRU 7253B-EXIT.              
                                                                        
       2250B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2250C-OTHER-ID-SEARCH.                                           
                                                                        
           PERFORM 7251C-OPEN-CE3-CURSOR THRU 7251C-EXIT.               
           PERFORM 7252C-FETCH-CE3-CURSOR THRU 7252C-EXIT.              
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7252C-FETCH-CE3-CURSOR THRU 7252C-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7253C-CLOSE-CE3-CURSOR THRU 7253C-EXIT.              
                                                                        
       2250C-EXIT.                                                      
           EXIT.                                                        
                                                                        
A05317 2250D-ITIN-SEARCH.                                               
A05317                                                                  
A05317     PERFORM 7251D-OPEN-CE4-CURSOR THRU 7251D-EXIT.               
A05317     PERFORM 7252D-FETCH-CE4-CURSOR THRU 7252D-EXIT.              
A05317                                                                  
A05317     PERFORM                                                      
A05317         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
A05317                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
A05317         PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
A05317         PERFORM 7252D-FETCH-CE4-CURSOR THRU 7252D-EXIT           
A05317     END-PERFORM.                                                 
A05317                                                                  
A05317     PERFORM 7253D-CLOSE-CE4-CURSOR THRU 7253D-EXIT.              
A05317                                                                  
A05317 2250D-EXIT.                                                      
A05317     EXIT.                                                        
                                                                        
       2260-METER-SEARCH.                                               
                                                                        
           PERFORM 7297-OPEN-MT-CURSOR THRU 7297-EXIT.                  
           PERFORM 7298-FETCH-MT-CURSOR THRU 7298-EXIT.                 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7298-FETCH-MT-CURSOR THRU 7298-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7299-CLOSE-MT-CURSOR THRU 7299-EXIT.                 
                                                                        
       2260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2270-TAX-ID-SEARCH.                                              
                                                                        
           PERFORM 7271-OPEN-BS-CURSOR THRU 7271-EXIT.                  
           PERFORM 7272-FETCH-BS-CURSOR THRU 7272-EXIT.                 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7272-FETCH-BS-CURSOR THRU 7272-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7273-CLOSE-BS-CURSOR THRU 7273-EXIT.                 
                                                                        
       2270-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2290-POINT-ID-SEARCH.                                            
                                                                        
           PERFORM 7291-OPEN-PR-CURSOR THRU 7291-EXIT.                  
           PERFORM 7292-FETCH-PR-CURSOR THRU 7292-EXIT.                 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7292-FETCH-PR-CURSOR THRU 7292-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7293-CLOSE-PR-CURSOR THRU 7293-EXIT.                 
                                                                        
       2290-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2295-LOCATOR-SEARCH.                                             
                                                                        
           PERFORM 7307-OPEN-LO-CURSOR THRU 7307-EXIT.                  
           PERFORM 7308-FETCH-LO-CURSOR THRU 7308-EXIT.                 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7308-FETCH-LO-CURSOR THRU 7308-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7309-CLOSE-LO-CURSOR THRU 7309-EXIT.                 
                                                                        
       2295-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2330-SUBDIV-SEARCH.                                              
                                                                        
           PERFORM 7359-OPEN-SUB-CURSOR THRU 7359-EXIT.                 
           PERFORM 7360-FETCH-SUB-CURSOR THRU 7360-EXIT.                
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7360-FETCH-SUB-CURSOR THRU 7360-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7361-CLOSE-SUB-CURSOR THRU 7361-EXIT.                
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2340-PREMISE-SEARCH.                                             
                                                                        
           MOVE PMS-PREM-NO-NUM TO HT-PREMISE-NO.                       
                                                                        
           PERFORM 7362-OPEN-PMS-CURSOR THRU 7362-EXIT.                 
           PERFORM 7363-FETCH-PMS-CURSOR THRU 7363-EXIT.                
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7363-FETCH-PMS-CURSOR THRU 7363-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7364-CLOSE-PMS-CURSOR THRU 7364-EXIT.                
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00778 2345-AGL-PREM-SEARCH.                                            
P00778                                                                  
P00778     MOVE PMS-AGL-PREM-NUM    TO PR-AGL-PREM-NO.                  
P00778                                                                  
P00778     PERFORM 7407-OPEN-AGL-PMS-CURSOR THRU 7407-EXIT.             
P00778     PERFORM 7408-FETCH-AGL-PMS-CURSOR THRU 7408-EXIT.            
P00778                                                                  
P00778     PERFORM UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR          
P00778                 CTR-ROWS >= CN-MAX-RETURN-ROWS)                  
P00778          PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                 
P00778          PERFORM 7408-FETCH-AGL-PMS-CURSOR THRU 7408-EXIT        
P00778        END-PERFORM.                                              
P00778                                                                  
P00778        PERFORM 7409-CLOSE-AGL-PMS-CURSOR THRU 7409-EXIT.         
P00778                                                                  
P00778  2345-EXIT.                                                      
P00778      EXIT.                                                       
                                                                        
                                                                        
       2350-SERV-ORDER-SEARCH.                                          
                                                                        
           MOVE SON-ORDER-NO-NUM TO VO-SERV-ORDER-NO.                   
           PERFORM 7980-GET-SERVICE-ORDER THRU 7980-EXIT.               
           MOVE VO-PREMISE-NO TO HT-PREMISE-NO.                         
                                                                        
           PERFORM 7362-OPEN-PMS-CURSOR THRU 7362-EXIT.                 
           PERFORM 7363-FETCH-PMS-CURSOR THRU 7363-EXIT.                
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7363-FETCH-PMS-CURSOR THRU 7363-EXIT             
           END-PERFORM.                                                 
                                                                        
           PERFORM 7364-CLOSE-PMS-CURSOR THRU 7364-EXIT.                
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2360-PHONE-SEARCH.                                               
                                                                        
           PERFORM 7261-OPEN-CB-CURSOR THRU 7261-EXIT.                  
           PERFORM 7262-FETCH-CB-CURSOR THRU 7262-EXIT.                 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7262-FETCH-CB-CURSOR THRU 7262-EXIT              
           END-PERFORM.                                                 
                                                                        
           PERFORM 7263-CLOSE-CB-CURSOR THRU 7263-EXIT.                 
                                                                        
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2361-GASADDR-BY-LO-LB.                                           
                                                                        
           PERFORM 7383-OPEN-DY-UT-PR-CURSOR-L THRU 7383-EXIT.          
           PERFORM 7384-FETCH-DY-UT-PR-CURSOR-L THRU 7384-EXIT.         
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7384-FETCH-DY-UT-PR-CURSOR-L THRU 7384-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7385-CLOSE-DY-UT-PR-CURSOR-L THRU 7385-EXIT.         
                                                                        
       2361-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2362-GASADDR-BY-CITY-LB.                                         
                                                                        
           PERFORM 7386-OPEN-DY-UT-PR-CURSOR-C THRU 7386-EXIT.          
           PERFORM 7387-FETCH-DY-UT-PR-CURSOR-C THRU 7387-EXIT.         
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7387-FETCH-DY-UT-PR-CURSOR-C THRU 7387-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7388-CLOSE-DY-UT-PR-CURSOR-C THRU 7388-EXIT.         
                                                                        
       2362-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2363-GASADDR-LB.                                                 
                                                                        
           PERFORM 7389-OPEN-DY-UT-PR-CURSOR THRU 7389-EXIT.            
           PERFORM 7390-FETCH-DY-UT-PR-CURSOR THRU 7390-EXIT.           
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7390-FETCH-DY-UT-PR-CURSOR THRU 7390-EXIT        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7391-CLOSE-DY-UT-PR-CURSOR THRU 7391-EXIT.           
                                                                        
       2363-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2364-LIGHTADDR-BY-LO-LB.                                         
                                                                        
           PERFORM 7392-OPEN-DY-LG-PR-CURSOR-L THRU 7392-EXIT.          
           PERFORM 7393-FETCH-DY-LG-PR-CURSOR-L THRU 7393-EXIT.         
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7393-FETCH-DY-LG-PR-CURSOR-L THRU 7393-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7394-CLOSE-DY-LG-PR-CURSOR-L THRU 7394-EXIT.         
                                                                        
       2364-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2365-LIGHTADDR-BY-CITY-LB.                                       
                                                                        
           PERFORM 7395-OPEN-DY-LG-PR-CURSOR-C THRU 7395-EXIT.          
           PERFORM 7396-FETCH-DY-LG-PR-CURSOR-C THRU 7396-EXIT.         
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7396-FETCH-DY-LG-PR-CURSOR-C THRU 7396-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7397-CLOSE-DY-LG-PR-CURSOR-C THRU 7397-EXIT.         
                                                                        
       2365-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2366-LIGHTADDR-LB.                                               
                                                                        
           PERFORM 7398-OPEN-DY-LG-PR-CURSOR THRU 7398-EXIT.            
           PERFORM 7399-FETCH-DY-LG-PR-CURSOR THRU 7399-EXIT.           
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7399-FETCH-DY-LG-PR-CURSOR THRU 7399-EXIT        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7400-CLOSE-DY-LG-PR-CURSOR THRU 7400-EXIT.           
                                                                        
       2366-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00837 2370-ACCOUNT-MGR-SEARCH.                                         
P00837                                                                  
P00837     MOVE MGR-FIRST-NAME TO DQ-FIRST-NAME.                        
P00837     MOVE MGR-LAST-NAME TO DQ-LAST-NAME.                          
P00837                                                                  
P00837     PERFORM 7410-OPEN-MGR-CURSOR THRU 7410-EXIT.                 
P00837     PERFORM 7411-FETCH-MGR-CURSOR THRU 7411-EXIT.                
P00837                                                                  
P00837     PERFORM                                                      
P00837         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
P00837                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
P00837         PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
P00837         PERFORM 7411-FETCH-MGR-CURSOR THRU 7411-EXIT             
P00837     END-PERFORM.                                                 
P00837                                                                  
P00837     PERFORM 7412-CLOSE-MGR-CURSOR THRU 7412-EXIT.                
P00837                                                                  
P00837 2370-EXIT.                                                       
P00837     EXIT.                                                        
                                                                        
P00870 2380-REFUND-CHECK-SEARCH.                                        
P00870                                                                  
P00870     MOVE REF-CHECK-NO TO RN-REFUND-CHECK-NO.                     
P00870                                                                  
P00870     PERFORM 7413-OPEN-REF-CURSOR THRU 7413-EXIT.                 
P00870     PERFORM 7414-FETCH-REF-CURSOR THRU 7414-EXIT.                
P00870                                                                  
P00870     PERFORM                                                      
P00870         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
P00870                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
P00870         PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
P00870         PERFORM 7414-FETCH-REF-CURSOR THRU 7414-EXIT             
P00870     END-PERFORM.                                                 
P00870                                                                  
P00870     PERFORM 7415-CLOSE-REF-CURSOR THRU 7415-EXIT.                
P00870                                                                  
P00870 2380-EXIT.                                                       
P00870     EXIT.                                                        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           EVALUATE TRUE ALSO TRUE                                      
              WHEN AT-CODE-ACCT-STAT = 'A' ALSO PARM-ACTIVE-FL = 'N'    
                  GO TO 2500-EXIT                                       
              WHEN AT-CODE-ACCT-STAT = 'B' ALSO PARM-FINAL-BILL-FL = 'N'
                  GO TO 2500-EXIT                                       
              WHEN AT-CODE-ACCT-STAT = 'J' ALSO PARM-INACTIVE-FL = 'N'  
                  GO TO 2500-EXIT                                       
              WHEN AT-CODE-ACCT-STAT = 'P' ALSO PARM-PENDING-FL = 'N'   
                  GO TO 2500-EXIT                                       
              WHEN AT-CODE-ACCT-STAT = 'S' ALSO PARM-WRITE-OFF-FL = 'N' 
                  GO TO 2500-EXIT                                       
              WHEN WS-ARCHIVE-IND = 'Y' ALSO PARM-ARCHIVE-FL = 'N'      
                  GO TO 2500-EXIT                                       
           END-EVALUATE.                                                
                                                                        
           IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER AND                   
              PARM-SEARCH-METHOD NOT = 'MAS' AND                        
              PARM-SEARCH-METHOD NOT = 'CUR' AND                        
              PARM-SEARCH-METHOD NOT = 'PIM'                            
                ADD  1  TO WS-ROWS-PROCESSED                            
                GO TO 2500-EXIT
           END-IF.                                        
                                                                        
           IF SEL-METH-PIM OR                                           
              SEL-METH-CUR OR                                           
              SEL-METH-LIG                                              
                  IF HT-PREMISE-NO NOT = WS-HOLD-PREMISE-NO             
                      MOVE ZEROES TO WS-CPD99-ACCOUNT-NO                
                                     WS-CPD99-PREMISE-NO                
                      MOVE HT-PREMISE-NO TO WS-HOLD-PREMISE-NO          
                                            WS-CPD99-PREMISE-NO         
                      PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT     
                      MOVE WS-CPD99-ACCOUNT-NO TO WS-HOLD-ACCOUNT-NO    
                  END-IF                                                
                  IF HT-ACCOUNT-NO NOT = WS-HOLD-ACCOUNT-NO             
                      GO TO 2500-EXIT                                   
                  ELSE                                                  
                      IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER            
                          ADD 1 TO WS-ROWS-PROCESSED                    
                          GO TO 2500-EXIT
                      END-IF
                  END-IF
           END-IF.                              
                                                                        
           IF SEL-METH-MAS THEN                                         
              PERFORM 7975-GET-ACCOUNT THRU 7975-EXIT                   
              IF AT-MST-SUB-ACCT-IND NOT = 'M'                          
                 GO TO 2500-EXIT                                        
              ELSE                                                      
                 IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER THEN            
                    ADD  1  TO WS-ROWS-PROCESSED                        
                    GO TO 2500-EXIT
                 END-IF
              END-IF
           END-IF.                                    
                                                                        
           IF (SEL-METH-ADD AND BILLING-ADDRESS)                        
               PERFORM 7950-GET-BILLING-TOWN THRU 7950-EXIT             
               IF NOT (WS-TOWN >= ADD-CITY-L AND                        
                       WS-TOWN <= ADD-CITY-H)                           
                  GO TO 2500-EXIT
               END-IF
           END-IF.                                      
                                                                        
           IF HT-ACCOUNT-NO > 0 AND                                     
              WS-ARCHIVE-IND = 'Y'                                      
                  PERFORM 7990-ARCHIVE-ACCOUNT THRU 7990-EXIT
           END-IF.          
                                                                        
           IF SEB-DATABASE                                              
               PERFORM 7750-REG-PROFILE THRU 7750-EXIT                  
               IF LR-REG-GROUP-CD = '200'                               
                   PERFORM 7760-ACTIVE-DHR THRU 7760-EXIT               
               END-IF                                                   
               PERFORM 7770-ORIG-CD THRU 7770-EXIT                      
               PERFORM 7780-PRE-PAY-PLAN THRU 7780-EXIT                 
               MOVE S-GROUP-CD TO WS-GROUP-CD                           
               EVALUATE PARM-DIVISION                                   
                  WHEN 'D'                                              
                      IF WS-GROUP-CD(1:3) IS NUMERIC                    
                          GO TO 2500-EXIT                               
                      END-IF                                            
                  WHEN 'R'                                              
                      IF WS-GROUP-CD(1:3) IS NOT NUMERIC                
                          GO TO 2500-EXIT                               
                      END-IF                                            
               END-EVALUATE                                             
           ELSE                                                         
               MOVE SPACES TO WS-GROUP-CD
           END-IF.                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE WS-GROUP-CD TO S-GROUP-CD.                              
                                                                        
           IF HT-NAME-ID = 0                                            
               MOVE SPACES TO WS-NAME                                   
           ELSE                                                         
               IF HT-NAME-ID > 0 AND NEED-NAME                          
                   MOVE SPACES TO WS-NAME                               
                   PERFORM 7930-GET-NAME THRU 7930-EXIT
               END-IF
           END-IF.                
                                                                        
           IF NEED-TOWN                                                 
               MOVE SPACES TO A4-TOWN                                   
               PERFORM 7025-GET-ZIP THRU 7025-EXIT
           END-IF.                     
                                                                        
           IF HT-ACCOUNT-NO > 0 AND                                     
              AT-CODE-ACCT-STAT NOT = 'P'                               
                   PERFORM 7035-CUST-PREM-HIST THRU 7035-EXIT           
                   MOVE CH-DATE-UTIL-SVC-STRT TO S-UTIL-SVC-STRT        
                   MOVE CH-DATE-UTIL-SVC-END TO S-UTIL-SVC-END
           END-IF.         
                                                                        
A05317     IF SEL-METH-ADD OR                                           
A05317        SEL-METH-LIG OR                                           
A05317        SEL-METH-GAS OR                                           
A05317        SEL-METH-SUB                                              
A05317            MOVE S-UTIL-SVC-STRT TO S-SORT-FIELD-3                
A05317            IF HT-PREMISE-NO NOT = WS-PREMISE-NO                  
A05317                MOVE HT-PREMISE-NO TO WS-PREMISE-NO               
A05317                ADD +1 TO WS-SORT-FIELD                           
A05317            END-IF                                                
A05317            MOVE WS-SORT-FIELD TO S-SORT-FIELD-1                  
A05317            IF AT-CODE-ACCT-STAT = 'P'                            
A05317                MOVE 'A' TO S-SORT-FIELD-2                        
A05317            ELSE                                                  
A05317                MOVE 'B' TO S-SORT-FIELD-2                        
A05317            END-IF                                                
A05317     ELSE                                                         
A05317         MOVE SPACES TO S-SORT-FIELD-2                            
A05317                        S-SORT-FIELD-3                            
A05317         ADD +1 TO WS-SORT-FIELD                                  
A05317         MOVE WS-SORT-FIELD TO S-SORT-FIELD-1
           END-IF.                    
                                                                        
           MOVE HT-ACCOUNT-NO TO KO-ACCOUNT-NO.                         
           MOVE HT-CUSTOMER-NO TO KO-CUSTOMER-NO.                       
           MOVE HT-PREMISE-NO TO KO-PREMISE-NO.                         
           PERFORM 7100-SET-RED-FLAG THRU 7100-EXIT.                    
                                                                        
           IF HT-ADDRESS-ID = 0                                         
               MOVE SPACES TO WS-ADDRESS                                
                              A4-TOWN                                   
           ELSE                                                         
               IF HT-ADDRESS-ID > 0 AND NEED-ADDRESS                    
                   MOVE SPACES TO WS-ADDRESS                            
                                  A4-TOWN                               
                   PERFORM 7920-GET-ADDRESS THRU 7920-EXIT
               END-IF
           END-IF.             
                                                                        
           IF SEB-DATABASE AND                                          
              HT-ACCOUNT-NO > 0                                         
                   PERFORM 7790-SELECT-MKT-TIER THRU 7790-EXIT          
                   MOVE TT-TIER-ACCT-DESC-LNG TO S-ACCT-SUB-TYPE        
                   IF LINK-DETAILED-DATA = 'Y' AND                      
                      WS-ARCHIVE-IND NOT = 'Y'                          
                          PERFORM 7800-BILL-CYCLE THRU 7800-EXIT        
                          MOVE AT-BILL-CYCLE TO S-BILL-CYCLE            
                   ELSE                                                 
                       MOVE SPACES TO S-BILL-CYCLE                      
                   END-IF                                               
                   MOVE XM-DIST-ACCT-NO TO S-AGL-ACCT-NO                
           ELSE                                                         
               MOVE SPACES TO S-ACCT-SUB-TYPE                           
                              S-BILL-CYCLE                              
                              S-OFFER-CODE                              
                              S-OPTION-CODE                             
                              S-CORE-RATE                               
A04671                        S-AGL-ACCT-NO
           END-IF.                            
                                                                        
           EVALUATE HT-CUSTOMER-ROLE-CD                                 
               WHEN 'A'                                                 
                  MOVE 'RO' TO S-NAME-TYPE                              
               WHEN 'B'                                                 
                  MOVE 'CO' TO S-NAME-TYPE                              
               WHEN OTHER                                               
                   IF HT-NAME-ID = 0                                    
                       MOVE SPACES TO S-NAME-TYPE                       
                   ELSE                                                 
                       MOVE DQ-NAME-TYPE TO S-NAME-TYPE                 
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
           IF HT-CUSTOMER-NO = 0                                        
               MOVE SPACES TO S-NAME                                    
           ELSE                                                         
               MOVE WS-NAME TO S-NAME
           END-IF.                                  
           MOVE HT-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE HT-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           MOVE HT-PREMISE-NO TO S-PREMISE-NO.                          
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCT-TYPE.                    
           MOVE AT-CODE-ACCT-STAT TO S-ACCT-STATUS.                     
           MOVE WS-ADDRESS TO S-ADDRESS.                                
           MOVE A4-TOWN TO S-CITY.                                      
           MOVE WS-ARCHIVE-IND TO S-ARCHIVE-IND.                        
           IF LINK-DETAILED-DATA = 'Y'                                  
               PERFORM 2600-GET-DETAILED-DATA THRU 2600-EXIT            
               EVALUATE TRUE                                            
                   WHEN SEL-METH-ACC                                    
                       MOVE 1 TO CTR-ROWS                               
                   WHEN SEL-METH-GAS                                    
                       CONTINUE                                         
                   WHEN OTHER                                           
                       PERFORM 8300-SEND-RESULT THRU 8300-EXIT          
               END-EVALUATE                                             
           ELSE                                                         
               IF  SEL-METH-ACC                                         
                   MOVE 1 TO CTR-ROWS                                   
               ELSE                                                     
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.             
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-GET-DETAILED-DATA.                                          
                                                                        
           IF HT-PREMISE-NO > 0                                         
A04671         MOVE DY-ZIP-CODE TO S-ZIP-CODE                           
               MOVE HT-PREMISE-NO TO PR-PREMISE-NO                      
               PERFORM 7010-SELECT-PREMISE THRU 7010-EXIT               
               IF PR-SUBDIVISION-ID > ' '                               
                   PERFORM 7015-SELECT-SUBDIV THRU 7015-EXIT
               END-IF
           END-IF.           
                                                                        
           IF HT-ACCOUNT-NO > 0                                         
A05317         PERFORM 7420-GET-ACCOUNT THRU 7420-EXIT                  
A05317         PERFORM 7425-GET-ACCT-MISC-INFO THRU 7425-EXIT           
               IF SEL-METH-LIG                                          
                   PERFORM 2620-LIGHT-RATES THRU 2620-EXIT              
               ELSE                                                     
                   PERFORM 2610-GET-RATES THRU 2610-EXIT                
               END-IF                                                   
               IF CH-DATE-UTIL-SVC-STRT <= SPACES AND                   
                  CH-DATE-UTIL-SVC-END                                  
                      PERFORM 7020-UTIL-DATES THRU 7020-EXIT            
               ELSE                                                     
                   MOVE CH-DATE-UTIL-SVC-STRT TO S-UTIL-SVC-STRT        
                   MOVE CH-DATE-UTIL-SVC-END TO S-UTIL-SVC-END          
               END-IF                                                   
               MOVE SPACES TO CH-DATE-UTIL-SVC-STRT                     
                              CH-DATE-UTIL-SVC-END                      
               PERFORM 7917E-SUPPLIED-AVAILABLE THRU 7917E-EXIT         
               PERFORM 7917G-SUPPLIED-AVAILABLE THRU 7917G-EXIT         
               PERFORM 7917L-SUPPLIED-AVAILABLE THRU 7917L-EXIT         
               PERFORM 7918-READ-CYCLE THRU 7918-EXIT                   
               MOVE UT-READ-CYCLE TO S-READ-CYCLE                       
               IF UT-READ-ROUTE = ZEROES                                
                   MOVE SPACES TO S-READ-ROUTE                          
               ELSE                                                     
                   MOVE UT-READ-ROUTE TO S-READ-ROUTE
               END-IF
           END-IF.                  
                                                                        
A05317     IF HT-CUSTOMER-NO > 0                                        
A05317         PERFORM 7430-GET-NAME THRU 7430-EXIT
           END-IF.                    
                                                                        
           IF SEL-METH-GAS                                              
               PERFORM 2207-GAS-MTR-SEARCH THRU 2207-EXIT
           END-IF.              
           IF SEL-METH-LIG                                              
               PERFORM 7030-ELEC-METER THRU 7030-EXIT                   
               MOVE MN-METER-NO TO S-METER-NO                           
               MOVE MN-POINT-ID TO S-POINT-ID
           END-IF.                          
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2610-GET-RATES.                                                  
                                                                        
           PERFORM 7274-OPEN-UT-CURSOR THRU 7274-EXIT.                  
           PERFORM 7275-FETCH-UT-CURSOR THRU 7275-EXIT.                 
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                EVALUATE UT-CODE-UTIL-TYPE                              
                    WHEN 'E'                                            
                        PERFORM 2650-CHECK-RATE THRU 2650-EXIT          
                        IF WS-UNMTR-FOUND = 'N'                         
                           MOVE UT-RATE-PLAN-NO TO S-ELEC-RATE          
                           PERFORM 7720-CHECK-UNMTR-ELEC THRU 7720-EXIT 
                        ELSE                                            
                           PERFORM 7700-GET-ELEC-RATE THRU 7700-EXIT    
                        END-IF                                          
                    WHEN 'G'                                            
                        PERFORM 2650-CHECK-RATE THRU 2650-EXIT          
                        IF WS-UNMTR-FOUND = 'N'                         
                           MOVE UT-RATE-PLAN-NO TO S-GAS-RATE           
                           IF SEB-DATABASE                              
                               MOVE SPACES TO S-OFFER-CODE              
                                              S-OPTION-CODE             
                                              S-CORE-RATE               
                               MOVE UT-RATE-PLAN-NO TO RD-RATE-PLAN-NO  
                               PERFORM 7080-RATE-DESCRIPTION THRU       
                                       7080-EXIT                        
                               MOVE UT-RATE-PLAN-NO TO S-CORE-RATE(1:3) 
                               MOVE ' - ' TO S-CORE-RATE(4:3)           
                               MOVE RD-RATE-DESC TO S-CORE-RATE(7:44)   
                               PERFORM 7090-SELECT-PKG-OPTION THRU      
                                       7090-EXIT                        
                               MOVE FI-OPT-DESC-INT-LONG-TEXT TO        
                                    S-OPTION-CODE                       
                               IF DF-OFFER-CD > ' '                     
                                   PERFORM 7095-OFFER-DESC THRU         
                                           7095-EXIT                    
                                   MOVE SPACES TO WS-EMB-INPUT          
                                                  WS-CMP-TABLE          
                                   STRING DF-OFFER-CD                   
                                          ' - '                         
                                          FG-OFFER-DESC-INT             
                                          DELIMITED BY SIZE INTO        
                                          WS-EMB-INPUT                  
                                   PERFORM 6000-REDUCE-EMBEDDED-SPACES  
                                           THRU 6000-EXIT               
                                   MOVE WS-CMP-TABLE TO S-OFFER-CODE    
                               END-IF                                   
                           END-IF                                       
                           PERFORM 7730-CHECK-UNMTR-GAS  THRU 7730-EXIT 
                        ELSE                                            
                           PERFORM 7710-GET-GAS-RATE  THRU 7710-EXIT    
                        END-IF                                          
                    WHEN 'U'                                            
                        IF UT-RATE-PLAN-NO > S-UNMETER-RATE             
                           MOVE UT-RATE-PLAN-NO TO S-UNMETER-RATE       
                        END-IF                                          
                END-EVALUATE                                            
                PERFORM 7275-FETCH-UT-CURSOR      THRU 7275-EXIT        
           END-PERFORM.                                                 
           PERFORM 7276-CLOSE-UT-CURSOR           THRU 7276-EXIT.       
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2620-LIGHT-RATES.                                                
                                                                        
           PERFORM 7404-OPEN-L-UT-CURSOR THRU 7404-EXIT.                
           PERFORM 7405-FETCH-L-UT-CURSOR THRU 7405-EXIT.               
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                EVALUATE UT-CODE-UTIL-TYPE                              
                    WHEN 'E'                                            
                        IF UT-RATE-PLAN-NO = '029' OR '69A'             
                           PERFORM 7070-GET-E-UTIL THRU 7070-EXIT       
                           IF WS-SUBDIV-LIGHT NOT = 'Y'                 
                               PERFORM 7050-GET-LGT-RATE THRU 7050-EXIT 
                           END-IF                                       
                        ELSE                                            
                            MOVE UT-RATE-PLAN-NO TO S-ELEC-RATE         
                        END-IF                                          
                    WHEN 'U'                                            
                        MOVE 'N' TO WS-SUBDIV-LIGHT                     
                        PERFORM 7040-GET-SUBDIV-RATE THRU 7040-EXIT     
                        IF WS-SUBDIV-LIGHT = 'Y'                        
                            MOVE '064' TO S-UNMETER-RATE                
                                          WS-LIGHT-RATE                 
                            PERFORM 7060-GET-LIGHT-TYPE THRU 7060-EXIT  
                        ELSE                                            
                            PERFORM 7050-GET-LGT-RATE THRU 7050-EXIT    
                        END-IF                                          
                    WHEN 'G'                                            
                        MOVE UT-RATE-PLAN-NO TO S-GAS-RATE              
                END-EVALUATE                                            
                PERFORM 7405-FETCH-L-UT-CURSOR THRU 7405-EXIT           
           END-PERFORM.                                                 
           PERFORM 7406-CLOSE-L-UT-CURSOR THRU 7406-EXIT.               
           MOVE L9-UM-EQUIP-SHRT-DESC TO S-LIGHT-TYPE.                  
           MOVE CP-POLE-NO TO S-POLE-NO.                                
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2650-CHECK-RATE.                                                 
                                                                        
            MOVE 'N'                          TO WS-UNMTR-FOUND.        
                                                                        
            IF UT-CODE-UTIL-TYPE = 'E'                                  
               IF UT-RATE-PLAN-NO = '013' OR '029' OR '069' OR '079' OR 
                                    '68A' OR '68B' OR '69A' OR '69B' OR 
                                    '69C' OR '69D' OR 'A68' OR 'A69' OR 
                                    'B68' OR 'B69' OR 'C69' OR 'D69'    
                  MOVE 'Y'                  TO WS-UNMTR-FOUND           
               END-IF                                                   
            ELSE                                                        
               IF UT-RATE-PLAN-NO = '049' OR '079' OR '047'             
                  MOVE 'Y'                  TO WS-UNMTR-FOUND           
               END-IF                                                   
            END-IF.                                                     
                                                                        
            IF WS-UNMTR-FOUND = 'Y' AND UT-RATE-PLAN-NO >               
                                        S-UNMETER-RATE                  
               MOVE UT-RATE-PLAN-NO         TO S-UNMETER-RATE           
            END-IF.                                                     
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6000-REDUCE-EMBEDDED-SPACES.                                     
                                                                        
           MOVE 255 TO WS-EMB-TBL-LENG.                                 
           SET WS-EMB-INDX TO 1.                                        
           SET WS-CMP-INDX TO 1.                                        
           MOVE SPACE TO WS-EMB-LAST-CHAR.                              
           IF WS-EMB-LENG NUMERIC AND                                   
              WS-EMB-LENG > ZERO AND                                    
              WS-EMB-LENG < WS-EMB-TBL-LENG                             
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-TBL-LENG TO WS-EMB-LENG
           END-IF.                     
           PERFORM 6010-COMPRESSION-ROUTINE THRU 6010-EXIT              
               VARYING WS-EMB-INDX FROM WS-EMB-INDX BY 1                
               UNTIL WS-EMB-INDX > WS-EMB-LENG.                         
           MOVE ZERO TO WS-EMB-LENG.                                    
                                                                        
       6000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6010-COMPRESSION-ROUTINE.                                        
                                                                        
           IF WS-EMB-CHAR (WS-EMB-INDX) EQUAL SPACE AND                 
              WS-EMB-LAST-CHAR                                          
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-CHAR (WS-EMB-INDX) TO                        
                    WS-CMP-CHAR (WS-CMP-INDX)                           
                    WS-EMB-LAST-CHAR                                    
                SET WS-CMP-INDX UP BY 1
           END-IF.                                
                                                                        
       6010-EXIT.                                                       
            EXIT.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-DETERMINE-REGION.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'DATABASE'                             
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                                     
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DATABASE                  
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO WS-DATABASE                                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_DELINQUENCY'     TO TABLE-1                
                   MOVE 'DELINQ_VALUE'        TO TABLE-ELEMENT-1        
                   MOVE 'DATABASE'            TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT REV_DISTRICT_CD,                                   
                     SUBDIVISION_ID                                     
                INTO :PR-REV-DISTRICT-CD,                               
                     :PR-SUBDIVISION-ID                                 
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REV_DISTRICT_CD,                                           
MFA-TR*              SUBDIVISION_ID                                             
MFA-TR*         INTO :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :PR-SUBDIVISION-ID                                         
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE PR-REV-DISTRICT-CD TO S-REV-DISTRICT-CD         
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-REV-DISTRICT-CD                     
                                  PR-SUBDIVISION-ID                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7010'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_PREMISE'         TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-SELECT-SUBDIV.                                              
                                                                        
           EXEC SQL                                                     
              SELECT SUBDIVISION_DESC                                   
                INTO :B0-SUBDIVISION-DESC                               
                FROM CSS_SUBDIVISION WITH(READUNCOMMITTED)                      
               WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID                
                 AND COMPANY_NO = :HT-COMPANY-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUBDIVISION_DESC                                           
MFA-TR*         INTO :B0-SUBDIVISION-DESC                                       
MFA-TR*         FROM CSS_SUBDIVISION                                            
MFA-TR*        WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID                        
MFA-TR*          AND COMPANY_NO = :HT-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE B0-SUBDIVISION-DESC TO S-SUBDIVISION-ID         
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-SUBDIVISION-ID                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7015'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_SUBDIVISION'     TO TABLE-1                
                   MOVE 'SUBDIVISION_ID'      TO TABLE-ELEMENT-1        
                   MOVE PR-SUBDIVISION-ID     TO HOSTVAR-ELEMENT-1      
                   MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2        
                   MOVE HT-COMPANY-NO         TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-UTIL-DATES.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT DATE_UTIL_SVC_STRT,                                
                     DATE_UTIL_SVC_END                                  
                INTO :CH-DATE-UTIL-SVC-STRT :WS-NULL7,                   
                     :CH-DATE-UTIL-SVC-END :WS-NULL8                     
                FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                   
               WHERE PREMISE_NO = :HT-PREMISE-NO                        
                 AND ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_UTIL_SVC_STRT,                                        
MFA-TR*              DATE_UTIL_SVC_END                                          
MFA-TR*         INTO :CH-DATE-UTIL-SVC-STRT:WS-NULL7,                           
MFA-TR*              :CH-DATE-UTIL-SVC-END:WS-NULL8                             
MFA-TR*         FROM CSS_CUST_PREM_HIST                                         
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                                
MFA-TR*          AND ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL7 < 0                                      
                       MOVE SPACES TO CH-DATE-UTIL-SVC-STRT             
                   END-IF                                               
                   IF WS-NULL8 < 0                                      
                       MOVE SPACES TO CH-DATE-UTIL-SVC-END              
                   END-IF                                               
                   MOVE CH-DATE-UTIL-SVC-STRT TO S-UTIL-SVC-STRT        
                   MOVE CH-DATE-UTIL-SVC-END TO S-UTIL-SVC-END          
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-UTIL-SVC-STRT                       
                                  S-UTIL-SVC-END                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7020'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE HT-PREMISE-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-GET-ZIP.                                                    
                                                                        
           EXEC SQL                                                     
              SELECT TOWN                                               
                INTO :A4-TOWN                                           
                FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                         
               WHERE ZIP_CODE = :DY-ZIP-CODE                            
                 AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TOWN                                                       
MFA-TR*         INTO :A4-TOWN                                                   
MFA-TR*         FROM CSS_ZIP_CODE                                               
MFA-TR*        WHERE ZIP_CODE = :DY-ZIP-CODE                                    
MFA-TR*          AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO A4-TOWN                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7025'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ZIP_CODE'        TO TABLE-1                
                   MOVE 'ZIP_CODE'            TO TABLE-ELEMENT-1        
                   MOVE A4-ZIP-CODE           TO HOSTVAR-ELEMENT-1      
                   MOVE 'ZIP_CODE_TOKEN'      TO TABLE-ELEMENT-2        
                   MOVE A4-ZIP-CODE-TOKEN     TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-ELEC-METER.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MN. METER_NO,
              PP.AREA_ID + PP.TAG_NM                           
                 INTO :MN-METER-NO,                                     
                      :MN-POINT-ID                                      
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
                      CSS_PIM_POINT    PP WITH(READUNCOMMITTED)                 
                WHERE MN.ACCOUNT_NO  = :HT-ACCOUNT-NO                   
                  AND MN.CODE_UTIL_TYPE = 'E'                           
                  AND MN.GIS_POINT_ID = PP.POINT_ID                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MN. METER_NO,                                             
MFA-TR*               PP.AREA_ID || PP.TAG_NM                                   
MFA-TR*          INTO :MN-METER-NO,                                             
MFA-TR*               :MN-POINT-ID                                              
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_PIM_POINT    PP                                       
MFA-TR*         WHERE MN.ACCOUNT_NO  = :HT-ACCOUNT-NO                           
MFA-TR*           AND MN.CODE_UTIL_TYPE = 'E'                                   
MFA-TR*           AND MN.GIS_POINT_ID = PP.POINT_ID                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO MN-METER-NO                           
                                  MN-POINT-ID                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7030'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7035-CUST-PREM-HIST.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DATE_UTIL_SVC_STRT,
              DATE_UTIL_SVC_END                                 
                 INTO :CH-DATE-UTIL-SVC-STRT :WS-NULL1,                  
                      :CH-DATE-UTIL-SVC-END :WS-NULL2                    
                 FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO  = :HT-ACCOUNT-NO                      
                  AND PREMISE_NO = :HT-PREMISE-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE_UTIL_SVC_STRT,                                       
MFA-TR*               DATE_UTIL_SVC_END                                         
MFA-TR*          INTO :CH-DATE-UTIL-SVC-STRT:WS-NULL1,                          
MFA-TR*               :CH-DATE-UTIL-SVC-END:WS-NULL2                            
MFA-TR*          FROM CSS_CUST_PREM_HIST                                        
MFA-TR*         WHERE ACCOUNT_NO  = :HT-ACCOUNT-NO                              
MFA-TR*           AND PREMISE_NO = :HT-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7035                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE SPACES TO CH-DATE-UTIL-SVC-STRT             
                   END-IF                                               
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO CH-DATE-UTIL-SVC-END              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO CH-DATE-UTIL-SVC-STRT                 
                                  CH-DATE-UTIL-SVC-END                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7035'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2        
                   MOVE HT-PREMISE-NO         TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7035-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-GET-SUBDIV-RATE.                                            
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-SUBDIV-LIGHT                                 
                  FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                 WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                   
                   AND UT.RATE_PLAN_NO = '064'                          
                   AND UT.CODE_UTIL_TYPE = 'U'                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-SUBDIV-LIGHT                                         
MFA-TR*           FROM CSS_UTIL_ENVRNMT UT                                      
MFA-TR*          WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                           
MFA-TR*            AND UT.RATE_PLAN_NO = '064'                                  
MFA-TR*            AND UT.CODE_UTIL_TYPE = 'U'                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7040                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7040'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UM_EQUIPMENT'        TO TABLE-1                
               MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1        
               MOVE '064'                     TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-GET-LGT-RATE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT MAX(UT.RATE_PLAN_NO)                              
                 INTO :WS-LIGHT-RATE :WS-NULL10                          
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                  AND UT.RATE_PLAN_NO IN                                
                      ('017','018','025','026','029','062','064',       
                       '067','068','069','69A')                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     49300000
MFA-TR*        SELECT MAX(UT.RATE_PLAN_NO)                              49310000
MFA-TR*          INTO :WS-LIGHT-RATE:WS-NULL10                          49320000
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                               49330000
MFA-TR*         WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                    49340000
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                    49350000
MFA-TR*           AND UT.RATE_PLAN_NO IN                                        
MFA-TR*               ('017','018','025','026','029','062','064',               
MFA-TR*                '067','068','069','69A')                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                    49370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL10 < 0                                     
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE WS-LIGHT-RATE TO S-UNMETER-RATE             
                       PERFORM 7060-GET-LIGHT-TYPE THRU 7060-EXIT       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7050'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-GET-LIGHT-TYPE.                                             
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) L9.UM_EQUIP_SHRT_DESC,
              CP.POLE_NO                                       
                  INTO :L9-UM-EQUIP-SHRT-DESC,                          
                       :CP-POLE-NO                                      
                  FROM CSS_UM_EQUIPMENT L9 WITH(READUNCOMMITTED),               
                       CSS_UNMTR_PLAN UP WITH(READUNCOMMITTED),                 
                       CSS_CUST_PLAN CP WITH(READUNCOMMITTED),                  
                       CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                  WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                  
                    AND UT.CODE_UTIL_TYPE IN ('E','U')                  
                    AND UT.RATE_PLAN_NO = :WS-LIGHT-RATE                
                    AND UP.RATE_PLAN_NO = UT.RATE_PLAN_NO               
                    AND UP.UM_EQUIP_ID = L9.UM_EQUIP_ID                 
                    AND UP.VERSION_NO_CNTRL =                           
                        (SELECT MAX(VERSION_NO_CNTRL)                   
                           FROM CSS_UNMTR_PLAN B WITH(READUNCOMMITTED)          
                          WHERE B.RATE_PLAN_NO = UP.RATE_PLAN_NO        
                            AND B.RATE_ITEM_CODE = UP.RATE_ITEM_CODE    
                            AND B.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE)   
                    AND CP.ACCOUNT_NO = UT.ACCOUNT_NO                   
                    AND CP.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           
                    AND CP.IC_NO = UT.IC_NO                             
                    AND CP.RATE_ITEM_CODE = UP.RATE_ITEM_CODE           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT L9.UM_EQUIP_SHRT_DESC,                                   
MFA-TR*                CP.POLE_NO                                               
MFA-TR*           INTO :L9-UM-EQUIP-SHRT-DESC,                                  
MFA-TR*                :CP-POLE-NO                                              
MFA-TR*           FROM CSS_UM_EQUIPMENT L9,                                     
MFA-TR*                CSS_UNMTR_PLAN UP,                                       
MFA-TR*                CSS_CUST_PLAN CP,                                        
MFA-TR*                CSS_UTIL_ENVRNMT UT                                      
MFA-TR*           WHERE UT.ACCOUNT_NO = :HT-ACCOUNT-NO                          
MFA-TR*             AND UT.CODE_UTIL_TYPE IN ('E','U')                          
MFA-TR*             AND UT.RATE_PLAN_NO = :WS-LIGHT-RATE                        
MFA-TR*             AND UP.RATE_PLAN_NO = UT.RATE_PLAN_NO                       
MFA-TR*             AND UP.UM_EQUIP_ID = L9.UM_EQUIP_ID                         
MFA-TR*             AND UP.VERSION_NO_CNTRL =                                   
MFA-TR*                 (SELECT MAX(VERSION_NO_CNTRL)                           
MFA-TR*                    FROM CSS_UNMTR_PLAN B                                
MFA-TR*                   WHERE B.RATE_PLAN_NO = UP.RATE_PLAN_NO                
MFA-TR*                     AND B.RATE_ITEM_CODE = UP.RATE_ITEM_CODE            
MFA-TR*                     AND B.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE)           
MFA-TR*             AND CP.ACCOUNT_NO = UT.ACCOUNT_NO                           
MFA-TR*             AND CP.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                   
MFA-TR*             AND CP.IC_NO = UT.IC_NO                                     
MFA-TR*             AND CP.RATE_ITEM_CODE = UP.RATE_ITEM_CODE                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO L9-UM-EQUIP-SHRT-DESC                 
                   MOVE SPACES TO CP-POLE-NO                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7060'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UM_EQUIPMENT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-GET-E-UTIL.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :WS-ELEC-RATE :WS-NULL9                            
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND RATE_PLAN_NO NOT IN ('69A','029')                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :WS-ELEC-RATE:WS-NULL9                                    
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND RATE_PLAN_NO NOT IN ('69A','029')                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7070                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL9 < 0                                      
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE WS-ELEC-RATE TO S-ELEC-RATE                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7070'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'E'                   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-RATE-DESCRIPTION.                                           
                                                                        
           EXEC SQL                                                     
               SELECT RATE_DESC                                         
                 INTO :RD-RATE-DESC                                     
                 FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                  
                WHERE COMPANY_NO = :HT-COMPANY-NO                       
                  AND RATE_PLAN_NO = :RD-RATE-PLAN-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_DESC                                                 
MFA-TR*          INTO :RD-RATE-DESC                                             
MFA-TR*          FROM CSS_RATE_PLAN_DESC                                        
MFA-TR*         WHERE COMPANY_NO = :HT-COMPANY-NO                               
MFA-TR*           AND RATE_PLAN_NO = :RD-RATE-PLAN-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7080                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RD-RATE-DESC                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7080'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_RATE_PLAN_DESC'  TO TABLE-1                
                   MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2        
                   MOVE HT-COMPANY-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE RD-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-SELECT-PKG-OPTION.                                          
                                                                        
           MOVE SPACES TO FI-OPT-DESC-INT-LONG-TEXT.                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FI.OPT_DESC_INT_LONG,
              DF.OPTION_CD,
              DF.OFFER_CD,
              DF.STATUS_CD,
              DF.RT_PKG_OPT_SEQ_NO,
              FI.OPT_CALC_TYPE_CD                               
                 INTO :FI-OPT-DESC-INT-LONG,                            
                      :DF-OPTION-CD,                                    
                      :DF-OFFER-CD,                                     
                      :DF-STATUS-CD,                                    
                      :DF-RT-PKG-OPT-SEQ-NO,                            
                      :FI-OPT-CALC-TYPE-CD                              
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED),               
                      CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED),               
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
                  AND UT.ACCOUNT_NO        = :HT-ACCOUNT-NO             
                  AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
                  AND DF.IC_NO             = UT.IC_NO                   
                  AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
                  AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
                  AND FI.OPTION_CD         = DF.OPTION_CD               
                  AND FI.COMPANY_NO        = :HT-COMPANY-NO             
                  AND FI.OPT_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )             
                  AND FI.OPT_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )             
                  AND FI.PROC_STATUS_CD    = 'AC'                       
                ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                      
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*        SELECT FI.OPT_DESC_INT_LONG,                             41146600
MFA-TR*               DF.OPTION_CD,                                     41146600
MFA-TR*               DF.OFFER_CD,                                      41146600
MFA-TR*               DF.STATUS_CD,                                     41146600
MFA-TR*               DF.RT_PKG_OPT_SEQ_NO,                             41146600
MFA-TR*               FI.OPT_CALC_TYPE_CD                                       
MFA-TR*          INTO :FI-OPT-DESC-INT-LONG,                            41146600
MFA-TR*               :DF-OPTION-CD,                                    41146600
MFA-TR*               :DF-OFFER-CD,                                     41146600
MFA-TR*               :DF-STATUS-CD,                                    41146600
MFA-TR*               :DF-RT-PKG-OPT-SEQ-NO,                            41146600
MFA-TR*               :FI-OPT-CALC-TYPE-CD                              41146600
MFA-TR*          FROM CRM_RT_PKG_OPTION FI,                             41146600
MFA-TR*               CSS_ACCT_RTPK_AGR DF,                             41146600
MFA-TR*               CSS_UTIL_ENVRNMT UT                               41146600
MFA-TR*         WHERE UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         41146600
MFA-TR*           AND UT.ACCOUNT_NO        = :HT-ACCOUNT-NO             41146600
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          41146600
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                   41146600
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              41146600
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       41146600
MFA-TR*           AND FI.OPTION_CD         = DF.OPTION_CD               41146600
MFA-TR*           AND FI.COMPANY_NO        = :HT-COMPANY-NO             41146600
MFA-TR*           AND FI.OPT_VSTART_TS    <= :WS-CURRENT-TS                     
MFA-TR*           AND FI.OPT_VEND_TS      >= :WS-CURRENT-TS                     
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*         ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                      41146600
MFA-TR*         FETCH FIRST ROW ONLY                                    41146600
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7090                                                    
MFA-TR*     END-EXEC.                                                   41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO DF-OPTION-CD                          
                                  FI-OPT-DESC-INT-LONG-TEXT             
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7090'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CRM_RT_PKG_OPTION' TO TABLE-1                  
                   MOVE 'CSS_ACCT_RTPK_AGR' TO TABLE-2                  
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-3                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7095-OFFER-DESC.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) OFFER_DESC_INT                                    
                 INTO :FG-OFFER-DESC-INT                                
                 FROM CRM_RT_PKG_OFFER WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO = :HT-COMPANY-NO                       
                  AND OFFER_CD = :DF-OFFER-CD                           
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*        SELECT OFFER_DESC_INT                                    41146600
MFA-TR*          INTO :FG-OFFER-DESC-INT                                41146600
MFA-TR*          FROM CRM_RT_PKG_OFFER                                  41146600
MFA-TR*         WHERE COMPANY_NO = :HT-COMPANY-NO                       41146600
MFA-TR*           AND OFFER_CD = :DF-OFFER-CD                           41146600
MFA-TR*         FETCH FIRST ROW ONLY                                    41146600
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7095                                                    
MFA-TR*     END-EXEC.                                                   41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO FG-OFFER-DESC-INT                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7095'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CRM_RT_PKG_OFFER' TO TABLE-1                   
                   MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'OFFER_CD'       TO TABLE-ELEMENT-2             
                   MOVE DF-OFFER-CD      TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7095-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SET-RED-FLAG.                                               
                                                                        
           IF KO-PREMISE-NO = 0                                         
              MOVE 9999999999 TO KO-PREMISE-NO
           END-IF.                         
                                                                        
           IF KO-CUSTOMER-NO = 0                                        
              MOVE 9999999999 TO KO-CUSTOMER-NO
           END-IF.                        
                                                                        
           MOVE 'N' TO S-RED-FLAG-IND.                                  
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :S-RED-FLAG-IND                                    
                FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                        
               WHERE  (CUSTOMER_NO = :KO-CUSTOMER-NO)                   
                 AND   RED_FLAG_IND = 'Y'                               
                 AND  (RED_FLAG_EXPIRE_DT >= CIS.CHAR2TIMESTAMP(
                                                        :WS-RED-FLAG-TS
              )            
                  OR   RED_FLAG_EXPIRE_DT IS NULL)                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :S-RED-FLAG-IND                                            
MFA-TR*         FROM CSS_COMM_DATA                                              
MFA-TR*        WHERE  (CUSTOMER_NO = :KO-CUSTOMER-NO)                           
MFA-TR*          AND   RED_FLAG_IND = 'Y'                                       
MFA-TR*          AND  (RED_FLAG_EXPIRE_DT >= :WS-RED-FLAG-TS                    
MFA-TR*           OR   RED_FLAG_EXPIRE_DT IS NULL)                              
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-RED-FLAG-IND                           
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-RED-FLAG-IND                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_COMM_DATA'       TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE KO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2        
                   MOVE KO-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2      
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-3        
                   MOVE KO-PREMISE-NO         TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7201-OPEN-DY-HT-CURSOR-L.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-HT-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7201'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7201-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7202-FETCH-DY-HT-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-HT-CURSOR-L                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7202'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7202-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7203-CLOSE-DY-HT-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-HT-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7203'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7203-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7204-OPEN-DY-HT-CURSOR-C.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-HT-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7204'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7204-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7205-FETCH-DY-HT-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-HT-CURSOR-C                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7205'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7206-CLOSE-DY-HT-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-HT-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7206'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7206-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7207-OPEN-DY-PR-CURSOR-L.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-PR-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7207'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7207-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7208-FETCH-DY-PR-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-PR-CURSOR-L                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7208'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_PREMISE'      TO TABLE-3                   
                   MOVE 'CSS_NAME'         TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7208-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7209-CLOSE-DY-PR-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-PR-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7209'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7209-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7211-OPEN-DY-HT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN DY-HT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7211'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7211-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7212-FETCH-DY-HT-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH DY-HT-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7212'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                   
                 MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                   
                 MOVE 'CSS_NAME'           TO TABLE-3                   
                 MOVE 'HOUSE_NO'           TO TABLE-ELEMENT-1           
                 MOVE ADD-STREET-NBR       TO HOSTVAR-ELEMENT-1         
                 MOVE 'STREET_NAME'        TO TABLE-ELEMENT-2           
                 MOVE 'ADDR_PREFIX_1'      TO TABLE-ELEMENT-3           
                 MOVE 'STREET_LOCATION_1'  TO TABLE-ELEMENT-4           
                 MOVE ADD-STREET-NAME      TO HOSTVAR-ELEMENT-2         
                 MOVE ADD-PREFIX-1         TO HOSTVAR-ELEMENT-3         
                 MOVE ADD-LOCATION-1       TO HOSTVAR-ELEMENT-4         
                 PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT  
                 PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7212-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7213-CLOSE-DY-HT-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE DY-HT-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7213'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7213-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7214-OPEN-DY-AQ-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN DY-AQ-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7214'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_BILL_ADDR_XREF'   TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7214-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7215-FETCH-DY-AQ-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH DY-AQ-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-ADDRESS-ID,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7215'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_BILL_ADDR_XREF' TO TABLE-3                 
                   MOVE 'CSS_NAME'         TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7215-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7216-CLOSE-DY-AQ-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE DY-AQ-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7216'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_BILL_ADDR_XREF'   TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7216-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7217-OPEN-INT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN INT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7217'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-1         
               MOVE 'ADDRESS_OVERFLOW'     TO TABLE-ELEMENT-2           
               MOVE ADD-OVERFLOW           TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7217-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7218-FETCH-INT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH INT-CURSOR                                         
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7218'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'STREET_NAME'          TO TABLE-ELEMENT-1       
                   MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-1     
                   MOVE 'ADDRESS_OVERFLOW'     TO TABLE-ELEMENT-2       
                   MOVE ADD-OVERFLOW           TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7218-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7219-CLOSE-INT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE INT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7219'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'STREET_NAME'              TO TABLE-ELEMENT-1       
               MOVE ADD-STREET-NAME            TO HOSTVAR-ELEMENT-1     
               MOVE 'ADDRESS_OVERFLOW'         TO TABLE-ELEMENT-2       
               MOVE ADD-OVERFLOW               TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7219-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7221-OPEN-DQ-IND-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN DQ-IND-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7221'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7221-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7222-FETCH-DQ-IND-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH DQ-IND-CURSOR                                      
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               IF DQ-NAME-TYPE <= SPACES                                
                  MOVE 'CN'    TO DQ-NAME-TYPE                          
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7222'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7222-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7223-CLOSE-DQ-IND-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-IND-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7223'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7223-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7224-OPEN-DQ-BUS-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN DQ-BUS-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7224'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7224-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7225-FETCH-DQ-BUS-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH DQ-BUS-CURSOR                                      
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-TYPE,                                     
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-TYPE <= SPACES                            
                      MOVE 'CN'    TO DQ-NAME-TYPE                      
                   END-IF                                               
                   MOVE DQ-FULL-NAME TO WS-NAME                         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7225'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'FULL_NAME'        TO TABLE-ELEMENT-1           
                   MOVE NAM-BUSINESS-NAME TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7226-CLOSE-DQ-BUS-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-BUS-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7226'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7226-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7227-OPEN-DY-PR-CURSOR-C.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-PR-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7227'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7227-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7228-FETCH-DY-PR-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-PR-CURSOR-C                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7228'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_PREMISE'      TO TABLE-3                   
                   MOVE 'CSS_NAME'         TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7228-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7229-CLOSE-DY-PR-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-PR-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7229'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7229-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7231-OPEN-AT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN AT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7231'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7231-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7232-FETCH-AT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH AT-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7232'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7232-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7233-CLOSE-AT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE AT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7233'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7233-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7234-OPEN-INT-CURSOR-L.                                          
                                                                        
           EXEC SQL                                                     
               OPEN INT-CURSOR-L                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7234'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'STREET_NAME'              TO TABLE-ELEMENT-1       
               MOVE ADD-STREET-NAME            TO HOSTVAR-ELEMENT-1     
               MOVE 'ADDRESS_OVERFLOW'         TO TABLE-ELEMENT-2       
               MOVE ADD-OVERFLOW               TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7234-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7235-FETCH-INT-CURSOR-L.                                         
                                                                        
           EXEC SQL                                                     
               FETCH INT-CURSOR-L                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7235'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'STREET_NAME'          TO TABLE-ELEMENT-1       
                   MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-1     
                   MOVE 'ADDRESS_OVERFLOW'     TO TABLE-ELEMENT-2       
                   MOVE ADD-OVERFLOW           TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7235-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7236-CLOSE-INT-CURSOR-L.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE INT-CURSOR-L                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7236'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'STREET_NAME'              TO TABLE-ELEMENT-1       
               MOVE ADD-STREET-NAME            TO HOSTVAR-ELEMENT-1     
               MOVE 'ADDRESS_OVERFLOW'         TO TABLE-ELEMENT-2       
               MOVE ADD-OVERFLOW               TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7236-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7237-OPEN-INT-CURSOR-C.                                          
                                                                        
           EXEC SQL                                                     
               OPEN INT-CURSOR-C                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7237'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'STREET_NAME'              TO TABLE-ELEMENT-1       
               MOVE ADD-STREET-NAME            TO HOSTVAR-ELEMENT-1     
               MOVE 'ADDRESS_OVERFLOW'         TO TABLE-ELEMENT-2       
               MOVE ADD-OVERFLOW               TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7237-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7238-FETCH-INT-CURSOR-C.                                         
                                                                        
           EXEC SQL                                                     
               FETCH INT-CURSOR-C                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7238'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'STREET_NAME'          TO TABLE-ELEMENT-1       
                   MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-1     
                   MOVE 'ADDRESS_OVERFLOW'     TO TABLE-ELEMENT-2       
                   MOVE ADD-OVERFLOW           TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7238-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7239-CLOSE-INT-CURSOR-C.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE INT-CURSOR-C                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7239'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'STREET_NAME'              TO TABLE-ELEMENT-1       
               MOVE ADD-STREET-NAME            TO HOSTVAR-ELEMENT-1     
               MOVE 'ADDRESS_OVERFLOW'         TO TABLE-ELEMENT-2       
               MOVE ADD-OVERFLOW               TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7239-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7241-OPEN-CU-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN CU-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7241'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7241-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7242-FETCH-CU-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH CU-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7242'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
                   MOVE HT-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7242-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7243-CLOSE-CU-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE CU-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7243'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7243-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7244-OPEN-DY-AQ-CURSOR-L.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-AQ-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7244'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_BILL_ADDR_XREF'   TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7244-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7245-FETCH-DY-AQ-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-AQ-CURSOR-L                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-ADDRESS-ID,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7245'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_BILL_ADDR_XREF' TO TABLE-3                 
                   MOVE 'CSS_NAME'         TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7245-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7246-CLOSE-DY-AQ-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-AQ-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7246'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_BILL_ADDR_XREF'   TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7246-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7247-OPEN-DY-AQ-CURSOR-C.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-AQ-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7247'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_BILL_ADDR_XREF'   TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7247-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7248-FETCH-DY-AQ-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-AQ-CURSOR-C                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-ADDRESS-ID,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7248'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_BILL_ADDR_XREF' TO TABLE-3                 
                   MOVE 'CSS_NAME'         TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7248-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7249-CLOSE-DY-AQ-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-AQ-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7249'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_BILL_ADDR_XREF'   TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7249-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7251A-OPEN-CE1-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN CE1-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7251A'                TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SSN'                  TO TABLE-ELEMENT-1           
               MOVE SSN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7251A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7252A-FETCH-CE1-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH CE1-CURSOR                                         
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7252A'                TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SSN'                  TO TABLE-ELEMENT-1           
               MOVE SSN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7252A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7253A-CLOSE-CE1-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE CE1-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7253A'                TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SSN'                  TO TABLE-ELEMENT-1           
               MOVE SSN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7253A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7251B-OPEN-CE2-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN CE2-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7251B'                TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'DLN'                  TO TABLE-ELEMENT-1           
               MOVE DLN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7251B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7252B-FETCH-CE2-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH CE2-CURSOR                                         
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7252B'                TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'DLN'                  TO TABLE-ELEMENT-1           
               MOVE DLN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7252B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7253B-CLOSE-CE2-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE CE2-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7253B'                TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'DLN'                  TO TABLE-ELEMENT-1           
               MOVE DLN-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7253B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7251C-OPEN-CE3-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN CE3-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7251C'                TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'OTHER ID'             TO TABLE-ELEMENT-1           
               MOVE OTH-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               MOVE 'OTHER TYPE'           TO TABLE-ELEMENT-2           
               MOVE OTH-ID-TYPE            TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7251C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7252C-FETCH-CE3-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               FETCH CE3-CURSOR                                         
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7252C'                TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'OTHER ID'             TO TABLE-ELEMENT-1           
               MOVE OTH-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               MOVE 'OTHER TYPE'           TO TABLE-ELEMENT-2           
               MOVE OTH-ID-TYPE            TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7252C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       7253C-CLOSE-CE3-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE CE3-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7253C'                TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'OTHER ID'             TO TABLE-ELEMENT-1           
               MOVE OTH-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               MOVE 'OTHER TYPE'           TO TABLE-ELEMENT-2           
               MOVE OTH-ID-TYPE            TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7253C-EXIT.                                                      
           EXIT.                                                        
                                                                        
A05317 7251D-OPEN-CE4-CURSOR.                                           
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         OPEN CE4-CURSOR                                          
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05317         NEXT SENTENCE                                            
A05317     ELSE                                                         
A05317         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A05317         MOVE '7251D'                TO ACTIVE-PARAGRAPH          
A05317         MOVE 'OPEN'                 TO ABEND-FUNCTION            
A05317         MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
A05317         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
A05317         MOVE 'ITIN_ID'              TO TABLE-ELEMENT-1           
A05317         MOVE OTH-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
A05317         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
A05317         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
A05317                                                                  
A05317 7251D-EXIT.                                                      
A05317     EXIT.                                                        
A05317                                                                  
A05317 7252D-FETCH-CE4-CURSOR.                                          
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         FETCH CE4-CURSOR                                         
A05317          INTO :HT-CUSTOMER-NO,                                   
A05317               :HT-ACCOUNT-NO,                                    
A05317               :HT-PREMISE-NO,                                    
A05317               :HT-ADDRESS-ID,                                    
A05317               :HT-NAME-ID,                                       
A05317               :HT-CUSTOMER-ROLE-CD,                              
A05317               :HT-COMPANY-NO,                                    
A05317               :AT-ACCOUNT-TYPE-CODE,                             
A05317               :AT-CODE-ACCT-STAT,                                
A05317               :WS-ARCHIVE-IND                                    
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
A05317         NEXT SENTENCE                                            
A05317     ELSE                                                         
A05317         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A05317         MOVE '7252D'                TO ACTIVE-PARAGRAPH          
A05317         MOVE 'FETCH'                TO ABEND-FUNCTION            
A05317         MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
A05317         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
A05317         MOVE 'ITIN_ID'              TO TABLE-ELEMENT-1           
A05317         MOVE OTH-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
A05317         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
A05317         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
A05317                                                                  
A05317 7252D-EXIT.                                                      
A05317     EXIT.                                                        
A05317                                                                  
A05317 7253D-CLOSE-CE4-CURSOR.                                          
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         CLOSE CE4-CURSOR                                         
A05317     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05317         NEXT SENTENCE                                            
A05317     ELSE                                                         
A05317         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A05317         MOVE '7253D'                TO ACTIVE-PARAGRAPH          
A05317         MOVE 'CLOSE'                TO ABEND-FUNCTION            
A05317         MOVE 'CSS_CUST_STATS'       TO TABLE-1                   
A05317         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
A05317         MOVE 'ITIN_ID'              TO TABLE-ELEMENT-1           
A05317         MOVE OTH-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
A05317         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
A05317         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
A05317                                                                  
A05317 7253D-EXIT.                                                      
A05317     EXIT.                                                        
A05317                                                                  
       7254-OPEN-DQ-IND-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               OPEN DQ-IND-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7254'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7254-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7255-FETCH-DQ-IND-CURSOR-L.                                      
                                                                        
           EXEC SQL                                                     
               FETCH DQ-IND-CURSOR-L                                    
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               IF DQ-NAME-TYPE <= SPACES                                
                  MOVE 'CN'    TO DQ-NAME-TYPE                          
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7255'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7255-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7256-CLOSE-DQ-IND-CURSOR-L.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-IND-CURSOR-L                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7256'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7256-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7257-OPEN-DQ-IND-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               OPEN DQ-IND-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7257'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7257-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7258-FETCH-DQ-IND-CURSOR-C.                                      
                                                                        
           EXEC SQL                                                     
               FETCH DQ-IND-CURSOR-C                                    
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               IF DQ-NAME-TYPE <= SPACES                                
                  MOVE 'CN'    TO DQ-NAME-TYPE                          
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7258'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7258-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7259-CLOSE-DQ-IND-CURSOR-C.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-IND-CURSOR-C                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7259'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7259-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7261-OPEN-CB-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN CB-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7261'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
               MOVE PHO-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7261-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7262-FETCH-CB-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              FETCH CB-CURSOR                                           
               INTO :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-NAME-ID,                                        
                    :HT-CUSTOMER-ROLE-CD,                               
                    :HT-COMPANY-NO,                                     
                    :DQ-NAME-TYPE,                                      
                    :WS-NAME,                                           
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-CODE-ACCT-STAT,                                 
                    :WS-ARCHIVE-IND                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7262'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
               MOVE PHO-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7262-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7263-CLOSE-CB-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE CB-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7263'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'PHONE_NO'             TO TABLE-ELEMENT-1           
               MOVE PHO-NUMBER             TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7263-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7264-OPEN-DQ-BUS-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               OPEN DQ-BUS-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7264'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7264-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7265-FETCH-DQ-BUS-CURSOR-L.                                      
                                                                        
           EXEC SQL                                                     
               FETCH DQ-BUS-CURSOR-L                                    
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-TYPE,                                     
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-TYPE <= SPACES                            
                      MOVE 'CN'    TO DQ-NAME-TYPE                      
                   END-IF                                               
                   MOVE DQ-FULL-NAME TO WS-NAME                         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7265'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'FULL_NAME'        TO TABLE-ELEMENT-1           
                   MOVE NAM-BUSINESS-NAME  TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7265-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7266-CLOSE-DQ-BUS-CURSOR-L.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-BUS-CURSOR-L                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7266'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7266-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7267-OPEN-DQ-BUS-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               OPEN DQ-BUS-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7267'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7267-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7268-FETCH-DQ-BUS-CURSOR-C.                                      
                                                                        
           EXEC SQL                                                     
               FETCH DQ-BUS-CURSOR-C                                    
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-TYPE,                                     
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-TYPE <= SPACES                            
                      MOVE 'CN'    TO DQ-NAME-TYPE                      
                   END-IF                                               
                   MOVE DQ-FULL-NAME TO WS-NAME                         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7268'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'FULL_NAME'        TO TABLE-ELEMENT-1           
                   MOVE NAM-BUSINESS-NAME  TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7268-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7269-CLOSE-DQ-BUS-CURSOR-C.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-BUS-CURSOR-C                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7269'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7269-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7271-OPEN-BS-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN BS-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7271'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'TAX_ID'               TO TABLE-ELEMENT-1           
               MOVE TAX-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               MOVE 'CSS_BUS_CUST_STATS'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7271-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7272-FETCH-BS-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH BS-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7272'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_BUS_CUST_STATS'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'TAX_ID'               TO TABLE-ELEMENT-1           
               MOVE TAX-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7272-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7273-CLOSE-BS-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE BS-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7273'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_BUS_CUST_STATS'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'TAX_ID'               TO TABLE-ELEMENT-1           
               MOVE TAX-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7273-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7274-OPEN-UT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN UT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7274'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7274-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7275-FETCH-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH UT-CURSOR                                          
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7275'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7276-CLOSE-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE UT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7276'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7276-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7280-OPEN-DY-PR-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN DY-PR-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7280'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7281-FETCH-DY-PR-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH DY-PR-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7281'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_PREMISE'      TO TABLE-3                   
                   MOVE 'CSS_NAME'         TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7281-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7282-CLOSE-DY-PR-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE DY-PR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7282'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7282-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7291-OPEN-PR-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN PR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7291'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE POI-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7291-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7292-FETCH-PR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH PR-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7292'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE POI-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7292-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7293-CLOSE-PR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE PR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7293'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE POI-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7293-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7297-OPEN-MT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN MT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7297'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'METER_NO'             TO TABLE-ELEMENT-1           
               MOVE MET-NUMBER             TO HOSTVAR-ELEMENT-1         
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2           
               MOVE MET-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7297-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7298-FETCH-MT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH MT-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7298'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'METER_NO'             TO TABLE-ELEMENT-1           
               MOVE MET-NUMBER             TO HOSTVAR-ELEMENT-1         
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2           
               MOVE MET-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7298-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7299-CLOSE-MT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE MT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7299'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'METER_NO'             TO TABLE-ELEMENT-1           
               MOVE MET-NUMBER             TO HOSTVAR-ELEMENT-1         
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2           
               MOVE MET-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7299-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7307-OPEN-LO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN LO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7307'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-1                   
               MOVE 'CSS_PREMISE'          TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'LOCATOR_ID'           TO TABLE-ELEMENT-1           
               MOVE LOC-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7307-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7308-FETCH-LO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH LO-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7308'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-1                   
               MOVE 'CSS_PREMISE'          TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'LOCATOR_ID'           TO TABLE-ELEMENT-1           
               MOVE LOC-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7308-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7309-CLOSE-LO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE LO-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7309'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-1                   
               MOVE 'CSS_PREMISE'          TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'LOCATOR_ID'           TO TABLE-ELEMENT-1           
               MOVE LOC-ID-NUMBER          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7309-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-OPEN-DQ-IND-CURSOR-SC.                                      
                                                                        
           EXEC SQL                                                     
               OPEN DQ-IND-CURSOR-SC                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7310'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE NAM-MIDDLE-NAME        TO HOSTVAR-ELEMENT-3         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7311-FETCH-DQ-IND-CURSOR-SC.                                     
                                                                        
           EXEC SQL                                                     
               FETCH DQ-IND-CURSOR-SC                                   
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               IF DQ-NAME-TYPE <= SPACES                                
                  MOVE 'CN'    TO DQ-NAME-TYPE                          
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7311'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7311-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7312-CLOSE-DQ-IND-CURSOR-SC.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-IND-CURSOR-SC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7312'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7312-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7313-OPEN-DQ-IND-CURSOR-SL.                                      
                                                                        
           EXEC SQL                                                     
               OPEN DQ-IND-CURSOR-SL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7313'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7313-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7314-FETCH-DQ-IND-CURSOR-SL.                                     
                                                                        
           EXEC SQL                                                     
               FETCH DQ-IND-CURSOR-SL                                   
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               IF DQ-NAME-TYPE <= SPACES                                
                  MOVE 'CN'    TO DQ-NAME-TYPE                          
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7314'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7314-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7315-CLOSE-DQ-IND-CURSOR-SL.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-IND-CURSOR-SL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7315'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7315-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7316-OPEN-DQ-BUS-CURSOR-SL.                                      
                                                                        
           EXEC SQL                                                     
               OPEN DQ-BUS-CURSOR-SL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7316'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7316-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7317-FETCH-DQ-BUS-CURSOR-SL.                                     
                                                                        
           EXEC SQL                                                     
               FETCH DQ-BUS-CURSOR-SL                                   
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-TYPE,                                     
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-TYPE <= SPACES                            
                      MOVE 'CN'    TO DQ-NAME-TYPE                      
                   END-IF                                               
                   MOVE DQ-FULL-NAME TO WS-NAME                         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7317'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-3                 
                   MOVE 'FULL_NAME'        TO TABLE-ELEMENT-1           
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE NAM-BUSINESS-NAME  TO HOSTVAR-ELEMENT-1         
                   MOVE NAM-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7317-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7318-CLOSE-DQ-BUS-CURSOR-SL.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-BUS-CURSOR-SL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7318'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7318-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7319-OPEN-DQ-BUS-CURSOR-SC.                                      
                                                                        
           EXEC SQL                                                     
               OPEN DQ-BUS-CURSOR-SC                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7319'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7319-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-FETCH-DQ-BUS-CURSOR-SC.                                     
                                                                        
           EXEC SQL                                                     
               FETCH DQ-BUS-CURSOR-SC                                   
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-TYPE,                                     
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-TYPE <= SPACES                            
                      MOVE 'CN'    TO DQ-NAME-TYPE                      
                   END-IF                                               
                   MOVE DQ-FULL-NAME TO WS-NAME                         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7320'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-3                 
                   MOVE 'FULL_NAME'        TO TABLE-ELEMENT-1           
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE NAM-BUSINESS-NAME  TO HOSTVAR-ELEMENT-1         
                   MOVE NAM-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7321-CLOSE-DQ-BUS-CURSOR-SC.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-BUS-CURSOR-SC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7321'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7321-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7328-OPEN-DQ-IND-CURSOR-S.                                       
                                                                        
           EXEC SQL                                                     
               OPEN DQ-IND-CURSOR-S                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7328'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7328-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7329-FETCH-DQ-IND-CURSOR-S.                                      
                                                                        
           EXEC SQL                                                     
               FETCH DQ-IND-CURSOR-S                                    
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-NAME-TYPE,                                     
                     :WS-NAME,                                          
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               IF DQ-NAME-TYPE <= SPACES                                
                  MOVE 'CN'    TO DQ-NAME-TYPE                          
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7329'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7329-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7330-CLOSE-DQ-IND-CURSOR-S.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-IND-CURSOR-S                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7330'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'LAST_NAME'            TO TABLE-ELEMENT-1           
               MOVE NAM-LAST-NAME          TO HOSTVAR-ELEMENT-1         
               MOVE 'FIRST_NAME'           TO TABLE-ELEMENT-2           
               MOVE NAM-FIRST-NAME         TO HOSTVAR-ELEMENT-2         
               MOVE 'MIDDLE_NAME'          TO TABLE-ELEMENT-3           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-4           
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7331-OPEN-DQ-BUS-CURSOR-S.                                       
                                                                        
           EXEC SQL                                                     
               OPEN DQ-BUS-CURSOR-S                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7331'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7331-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7332-FETCH-DQ-BUS-CURSOR-S.                                      
                                                                        
           EXEC SQL                                                     
               FETCH DQ-BUS-CURSOR-S                                    
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-TYPE,                                     
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-TYPE <= SPACES                            
                      MOVE 'CN'    TO DQ-NAME-TYPE                      
                   END-IF                                               
                   MOVE DQ-FULL-NAME TO WS-NAME                         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7332'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME'         TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-3                 
                   MOVE 'FULL_NAME'        TO TABLE-ELEMENT-1           
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE NAM-BUSINESS-NAME  TO HOSTVAR-ELEMENT-1         
                   MOVE NAM-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7332-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7333-CLOSE-DQ-BUS-CURSOR-S.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE DQ-BUS-CURSOR-S                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7333'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-3                   
               MOVE 'FULL_NAME'            TO TABLE-ELEMENT-1           
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE NAM-BUSINESS-NAME      TO HOSTVAR-ELEMENT-1         
               MOVE NAM-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7333-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7359-OPEN-SUB-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN SUB-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7359'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_PREMISE'          TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SUBDIVISION_ID'       TO TABLE-ELEMENT-1           
               MOVE SUBDIVISION-ID         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7359-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7360-FETCH-SUB-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH SUB-CURSOR                                         
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7360'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'SUBDIVISION_ID'   TO TABLE-ELEMENT-1           
                   MOVE SUBDIVISION-ID     TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7361-CLOSE-SUB-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE SUB-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7361'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_PREMISE'          TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'SUBDIVISION_ID'       TO TABLE-ELEMENT-1           
               MOVE SUBDIVISION-ID         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7361-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7362-OPEN-PMS-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN PMS-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7362'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_PREMISE'          TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7362-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7363-FETCH-PMS-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               FETCH PMS-CURSOR                                         
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :CH-DATE-UTIL-SVC-STRT :WS-NULL1,                   
                     :CH-DATE-UTIL-SVC-END :WS-NULL2                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE SPACES TO CH-DATE-UTIL-SVC-STRT             
                   END-IF                                               
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO CH-DATE-UTIL-SVC-END              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7363'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7363-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7364-CLOSE-PMS-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE PMS-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7364'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_PREMISE'          TO TABLE-1                   
               MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7364-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7365-OPEN-DY-UT-CURSOR-L.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-UT-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7365'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7365-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7366-FETCH-DY-UT-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-UT-CURSOR-L                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN,                                
                     :UT-IC-NO                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7366'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7366-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7367-CLOSE-DY-UT-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-UT-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7367'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7367-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7368-OPEN-DY-UT-CURSOR-C.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-UT-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7368'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7368-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7369-FETCH-DY-UT-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-UT-CURSOR-C                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN,                                
                     :UT-IC-NO                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7369'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7369-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7370-CLOSE-DY-UT-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-UT-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7370'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7371-OPEN-DY-UT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN DY-UT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7371'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7371-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7372-FETCH-DY-UT-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH DY-UT-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN,                                
                     :UT-IC-NO                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7372'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                   
                 MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                   
                 MOVE 'CSS_NAME'           TO TABLE-3                   
                 MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-3                   
                 MOVE 'HOUSE_NO'           TO TABLE-ELEMENT-1           
                 MOVE ADD-STREET-NBR       TO HOSTVAR-ELEMENT-1         
                 MOVE 'STREET_NAME'        TO TABLE-ELEMENT-2           
                 MOVE 'ADDR_PREFIX_1'      TO TABLE-ELEMENT-3           
                 MOVE 'STREET_LOCATION_1'  TO TABLE-ELEMENT-4           
                 MOVE ADD-STREET-NAME      TO HOSTVAR-ELEMENT-2         
                 MOVE ADD-PREFIX-1         TO HOSTVAR-ELEMENT-3         
                 MOVE ADD-LOCATION-1       TO HOSTVAR-ELEMENT-4         
                 PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT  
                 PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7372-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7373-CLOSE-DY-UT-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE DY-UT-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7373'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7373-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7374-OPEN-DY-LG-CURSOR-L.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-LG-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7374'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7374-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7375-FETCH-DY-LG-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-LG-CURSOR-L                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7375'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7375-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7376-CLOSE-DY-LG-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-LG-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7376'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7376-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7377-OPEN-DY-LG-CURSOR-C.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-LG-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7377'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7377-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7378-FETCH-DY-LG-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-LG-CURSOR-C                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7378'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'CSS_NAME'         TO TABLE-3                   
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-4                   
                   MOVE 'HOUSE_NO'         TO TABLE-ELEMENT-1           
                   MOVE ADD-STREET-NBR     TO HOSTVAR-ELEMENT-1         
                   MOVE 'STREET_NAME'      TO TABLE-ELEMENT-2           
                   MOVE 'ADDR_PREFIX_1'    TO TABLE-ELEMENT-3           
                   MOVE 'STREET_LOCATION_1' TO TABLE-ELEMENT-4          
                   MOVE ADD-STREET-NAME    TO HOSTVAR-ELEMENT-2         
                   MOVE ADD-PREFIX-1       TO HOSTVAR-ELEMENT-3         
                   MOVE ADD-LOCATION-1     TO HOSTVAR-ELEMENT-4         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7378-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7379-CLOSE-DY-LG-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-LG-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7379'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7379-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7380-OPEN-DY-LG-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN DY-LG-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7380'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR         TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME        TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1           TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1         TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7380-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7381-FETCH-DY-LG-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH DY-LG-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :WS-ADDRESS,                                       
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND,                                   
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-TOKEN                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7381'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                   
                 MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                   
                 MOVE 'CSS_NAME'           TO TABLE-3                   
                 MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-3                   
                 MOVE 'HOUSE_NO'           TO TABLE-ELEMENT-1           
                 MOVE ADD-STREET-NBR       TO HOSTVAR-ELEMENT-1         
                 MOVE 'STREET_NAME'        TO TABLE-ELEMENT-2           
                 MOVE 'ADDR_PREFIX_1'      TO TABLE-ELEMENT-3           
                 MOVE 'STREET_LOCATION_1'  TO TABLE-ELEMENT-4           
                 MOVE ADD-STREET-NAME      TO HOSTVAR-ELEMENT-2         
                 MOVE ADD-PREFIX-1         TO HOSTVAR-ELEMENT-3         
                 MOVE ADD-LOCATION-1       TO HOSTVAR-ELEMENT-4         
                 PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT  
                 PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7381-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7382-CLOSE-DY-LG-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE DY-LG-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

