       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04281.                                          
       AUTHOR.       FRAN BARRY.                                        
       DATE-WRITTEN. NOV 2010.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED TO     *        
      *  DISPLAY ACCOUNTS FOR CUSTOMER/SPOUSE/SPOUSE AS CUSTOMER.      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  11/05/2010 FMB       INITIAL VERSION                          *        
A04558*  08/27/2013 FMB       HANDLE -811 ERROR IN 7700-RETURN-CHECK.  *        
A04558*                       DIRECTED PAYMENTS.                       *        
A05317*  11/18/2015 FMB       INCREASE TABLE INDEX.                    *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04281'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04281 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04281_R1'.          
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(9) COMP VALUE ZERO.       
          05 S-ACCOUNT-NO              PIC S9(13)V COMP-3 VALUE +0.     
          05 S-CODE-ACCT-STAT          PIC X(01) VALUE  SPACES.         
          05 S-PAST-DUE-UTIL           PIC S9(09)V99 COMP-3 VALUE +0.   
          05 S-PAST-DUE-NONUTIL        PIC S9(09)V99 COMP-3 VALUE +0.   
          05 S-CUST-TYPE               PIC X(30) VALUE  SPACES.         
          05 S-SSN                     PIC X(09) VALUE SPACES.          
          05 S-SERV-ADDRESS            PIC X(75) VALUE SPACES.          
          05 S-PREMISE-NO              PIC S9(10)V COMP-3 VALUE +0.     
          05 S-CIA                     PIC S9(09)V99 COMP-3 VALUE +0.   
          05 S-BILLED-BALANCE          PIC S9(09)V99 COMP-3 VALUE +0.   
          05 S-DEPOSIT-DUE             PIC S9(09)V99 COMP-3 VALUE +0.   
          05 S-PAYMENTS                PIC S9(09)V99 COMP-3 VALUE +0.   
          05 S-PSNC-LABOR-CHG          PIC S9(09)V99 COMP-3 VALUE +0.   
          05 S-RET-CHECK-FL            PIC X(01) VALUE SPACES.          
          05 S-ARREARS-UTIL            PIC S9(9)V99 COMP-3 VALUE +0.    
          05 S-ARREARS-NONUTIL         PIC S9(9)V99 COMP-3 VALUE +0.    
          05 S-AMT-INSTALL-DEP         PIC S9(9)V99 COMP-3 VALUE +0.    
          05 S-NAME                    PIC X(76) VALUE SPACES.          
          05 S-TOTAL-DUE               PIC S9(9)V99 COMP-3 VALUE +0.    
                                                                        
       01 WS-TABLES.                                                    
            05  T1-CSR04281            OCCURS 9000                      
                                       INDEXED BY T1-INDEX.             
                10 T1-ACCOUNT-NO       PIC S9(13)V COMP-3 VALUE 0.      
                10 T1-CODE-ACCT-STAT   PIC X(01) VALUE SPACES.          
                10 T1-CUST-TYPE        PIC X(30) VALUE SPACES.          
                10 T1-PREMISE-NO       PIC S9(10)V COMP-3 VALUE 0.      
                10 T1-CIA              PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-PAST-DUE-UTIL    PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-PAST-DUE-NONUTIL PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-BILLED-BALANCE   PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-DEPOSIT-DUE      PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-PAYMENTS         PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-PSNC-LABOR-CHG   PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-RET-CHECK-FL     PIC X(01) VALUE SPACES.          
                10 T1-ARREARS-UTIL     PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-ARREARS-NONUTIL  PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-AMT-INSTALL-DEP  PIC S9(9)V99 COMP-3 VALUE 0.     
                10 T1-TOTAL-DUE        PIC S9(9)V99 COMP-3 VALUE 0.     
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04281'.      
          05  WS-MCSCB068              PIC X(08) VALUE 'MCSCB068'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-CUSTOMER-NO           PIC X(10) VALUE SPACES.          
          05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO         
                                       PIC 9(10).                       
          05  WS-CALL-TYPE             PIC X(01) VALUE SPACES.          
              88  ACCT-CUST            VALUE '1'.                       
              88  ACCT-SPOUSE          VALUE '2'.                       
              88  CUST-AS-SPOUSE       VALUE '3'.                       
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-MULTIPLE-ROWS         PIC S9(9) VALUE -811 COMP.       
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  WS-ACCT-EXISTS           PIC X(01) VALUE 'N'.             
          05  WS-ACCT-ARRAY-CNT        PIC S9(7) COMP-3 VALUE 0.        
          05  WS-SPOUSE-SSN            PIC X(09) VALUE SPACES.          
          05  WS-CUST-SSN              PIC X(09) VALUE SPACES.          
          05  WS-CUST-NAME             PIC X(76) VALUE SPACES.          
          05  WS-SPOUSE-NAME           PIC X(76) VALUE SPACES.          
          05  WS-SPOUSE-CUST           PIC S9(13)V COMP-3 VALUE 0.      
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-SERV-ADDRESS          PIC X(74) VALUE SPACES.          
          05  WS-CUST-ACTIVE           PIC X(01) VALUE SPACES.          
          05  WS-SPOUSE-ACTIVE         PIC X(01) VALUE SPACES.          
          05  WS-CUST-AS-SPOUSE-ACTIVE PIC X(01) VALUE SPACES.          
          05  WS-CUST-NOT-ACTIVE       PIC X(01) VALUE SPACES.          
          05  WS-DISPLAY-ACTIVE        PIC X(01) VALUE SPACES.          
          05  WS-ACTIVE-PAST-DUE       PIC X(01) VALUE SPACES.          
          05  WS-CUT-OFF-DATE          PIC X(10) VALUE SPACES.          
COB305    05 WS-TOTAL-PAYMENTS        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
COB305    05 WS-TOTAL-CORRECTIONS        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
COB305    05 WS-PSNC-LABOR-CHG        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
          05  WS-AMT-INSTALL-DEP       PIC S9(7)V9(2) COMP-3 VALUE 0.   
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01 IND-VARIABLES.                                                
          05 WS-NULL1                    PIC S9(04) COMP.               
          05 WS-NULL2                    PIC S9(04) COMP.               
          05 WS-NULL3                    PIC S9(04) COMP.               
          05 WS-NULL4                    PIC S9(04) COMP.               
          05 WS-NULL5                    PIC S9(04) COMP.               
          05 WS-NULL6                    PIC S9(04) COMP.               
          05 WS-NULL7                    PIC S9(04) COMP.               
          05 WS-NULL8                    PIC S9(04) COMP.               
          05 WS-NULL9                    PIC S9(04) COMP.               
          05 WS-NULL10                   PIC S9(04) COMP.               
          05 WS-NULL11                   PIC S9(04) COMP.               
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
           COPY CWS0068L.                                                       
           COPY CWS00011.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
A04558     EXEC SQL                                                             
A04558        INCLUDE TBARHDT                                                   
A04558     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOCHR                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ACCT-CURSOR CURSOR FOR                            
              SELECT ACCOUNT_NO,                                        
                     CODE_ACCT_STAT,                                    
                     PREMISE_NO                                         
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO    = :AT-CUSTOMER-NO                   
                 AND COMPANY_NO     = :AT-COMPANY-NO                    
                 AND BANKRUPTCY_IND <> 'B'                              
                 AND JUDGEMENT_IND  <> 'J'                              
                 AND ACCOUNT_TYPE_CODE NOT IN ('B', 'D', 'M', 'N')      
                 FOR READ ONLY                                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CURSOR CURSOR FOR                                    
MFA-TR*       SELECT ACCOUNT_NO,                                                
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              PREMISE_NO                                                 
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO    = :AT-CUSTOMER-NO                           
MFA-TR*          AND COMPANY_NO     = :AT-COMPANY-NO                            
MFA-TR*          AND BANKRUPTCY_IND <> 'B'                                      
MFA-TR*          AND JUDGEMENT_IND  <> 'J'                                      
MFA-TR*          AND ACCOUNT_TYPE_CODE NOT IN ('B', 'D', 'M', 'N')              
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE CUST-CURSOR CURSOR FOR                            
              SELECT CE.CUSTOMER_NO                                     
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                   
                     CSS_CUST_STATS CE1 WITH(READUNCOMMITTED)                   
               WHERE                                                    
                 CE.CUSTOMER_TYPE = 'S'                                 
                 AND CE.SSN = CE1.SSN                                   
                 AND CE1.CUSTOMER_NO   = :AT-CUSTOMER-NO                
                 AND CE1.CUSTOMER_TYPE = 'C'                            
                 AND CE1.SSN <> ' '                                     
                 AND CE.CUSTOMER_NO <> CE1.CUSTOMER_NO                  
                 FOR READ ONLY                                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUST-CURSOR CURSOR FOR                                    
MFA-TR*       SELECT CE.CUSTOMER_NO                                             
MFA-TR*         FROM CSS_CUST_STATS CE,                                         
MFA-TR*              CSS_CUST_STATS CE1                                         
MFA-TR*        WHERE                                                            
MFA-TR*          CE.CUSTOMER_TYPE = 'S'                                         
MFA-TR*          AND CE.SSN = CE1.SSN                                           
MFA-TR*          AND CE1.CUSTOMER_NO   = :AT-CUSTOMER-NO                        
MFA-TR*          AND CE1.CUSTOMER_TYPE = 'C'                                    
MFA-TR*          AND CE1.SSN <> ' '                                             
MFA-TR*          AND CE.CUSTOMER_NO <> CE1.CUSTOMER_NO                          
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7102                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 ACCOUNT_NO           AS ACCOUNT_NO,                    
                 CODE_ACCT_STAT       AS CODE_ACCT_STAT,                
                 PAST_DUE_UTIL        AS PAST_DUE_UTIL,                 
                 PAST_DUE_NONUTIL     AS PAST_DUE_NONUTIL,              
                 CUST_TYPE            AS CUST_TYPE,                     
                 SSN                  AS SSN,                           
                 SERV_ADDRESS         AS SERV_ADDRESS,                  
                 CIA                  AS CIA,                           
                 BILLED_BALANCE       AS BILLED_BALANCE,                
                 DEPOSIT_DUE          AS DEPOSIT_DUE,                   
                 PAYMENTS             AS PAYMENTS,                      
                 PSNC_LABOR_CHG       AS PSNC_LABOR_CHG,                
                 RET_CHECK_FL         AS RET_CHECK_FL,                  
                 NAME                 AS NAME,                          
                 TOTAL_DUE            AS TOTAL_DUE                      
              FROM #CSR04281_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          ACCOUNT_NO           AS ACCOUNT_NO,                            
MFA-TR*          CODE_ACCT_STAT       AS CODE_ACCT_STAT,                        
MFA-TR*          PAST_DUE_UTIL        AS PAST_DUE_UTIL,                         
MFA-TR*          PAST_DUE_NONUTIL     AS PAST_DUE_NONUTIL,                      
MFA-TR*          CUST_TYPE            AS CUST_TYPE,                             
MFA-TR*          SSN                  AS SSN,                                   
MFA-TR*          SERV_ADDRESS         AS SERV_ADDRESS,                          
MFA-TR*          CIA                  AS CIA,                                   
MFA-TR*          BILLED_BALANCE       AS BILLED_BALANCE,                        
MFA-TR*          DEPOSIT_DUE          AS DEPOSIT_DUE,                           
MFA-TR*          PAYMENTS             AS PAYMENTS,                              
MFA-TR*          PSNC_LABOR_CHG       AS PSNC_LABOR_CHG,                        
MFA-TR*          RET_CHECK_FL         AS RET_CHECK_FL,                          
MFA-TR*          NAME                 AS NAME,                                  
MFA-TR*          TOTAL_DUE            AS TOTAL_DUE                              
MFA-TR*       FROM SESSION.CSR04281_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-CUSTOMER-NO,                      
                                 LINK-COMPANY-NO.                       
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04281_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04281_R1
              (                                                          
               RETURN_CODE          INT,                            
               ACCOUNT_NO           DECIMAL(13,0),                      
               CODE_ACCT_STAT CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2,         
               PAST_DUE_UTIL        DECIMAL(11,2),                      
               PAST_DUE_NONUTIL     DECIMAL(11,2),                      
               CUST_TYPE CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,             
               SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               SERV_ADDRESS CHAR(75)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CIA                  DECIMAL(11,2),                      
               BILLED_BALANCE       DECIMAL(11,2),                      
               DEPOSIT_DUE          DECIMAL(11,2),                      
               PAYMENTS             DECIMAL(11,2),                      
               PSNC_LABOR_CHG       DECIMAL(11,2),                      
               RET_CHECK_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               TOTAL_DUE            DECIMAL(11,2)                       
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04281_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           IF LINK-COMPANY-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-COMPANY-NO
           END-IF.                          
           MOVE LINK-CUSTOMER-NO         TO WS-CUSTOMER-NO.             
           MOVE WS-CUSTOMER-NO-NUM       TO AT-CUSTOMER-NO.             
           MOVE LINK-COMPANY-NO          TO AT-COMPANY-NO.              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF AT-COMPANY-NO > '00'                                      
               PERFORM 7050-DELINQUENCY THRU 7050-EXIT
           END-IF.                 
           MOVE 'N' TO WS-CUST-ACTIVE                                   
                       WS-SPOUSE-ACTIVE                                 
                       WS-CUST-AS-SPOUSE-ACTIVE                         
                       WS-CUST-NOT-ACTIVE                               
                       WS-DISPLAY-ACTIVE                                
                       WS-ACTIVE-PAST-DUE.                              
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '1' TO WS-CALL-TYPE.                                    
           PERFORM 7005-SELECT-CUST-SSN THRU 7005-EXIT.                 
           PERFORM 2100-CUSTOMER THRU 2100-EXIT.                        
           IF WS-CUST-ACTIVE = 'N' AND                                  
              WS-CUST-NOT-ACTIVE = 'Y'                                  
                  MOVE '2' TO WS-CALL-TYPE                              
                  PERFORM 2200-SPOUSE THRU 2200-EXIT                    
                  MOVE '3' TO WS-CALL-TYPE                              
                  PERFORM 2300-CUST-AS-SPOUSE THRU 2300-EXIT
           END-IF.           
                                                                        
           PERFORM 2600-MONEY-AMOUNTS THRU 2600-EXIT                    
               VARYING T1-INDEX FROM 1 BY 1 UNTIL                       
SCA006         T1-INDEX > 9000 OR 
               T1-ACCOUNT-NO (T1-INDEX) = ZEROES.                               
                                                                        
           PERFORM 3000-PROCESS-TABLE THRU 3000-EXIT                    
               VARYING T1-INDEX FROM 1 BY 1 UNTIL                       
SCA006         T1-INDEX > 9000 OR 
               T1-ACCOUNT-NO (T1-INDEX) = ZEROES.                               
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              MOVE 'NO DATA' TO S-SERV-ADDRESS                          
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2100-CUSTOMER.                                                   
                                                                        
           PERFORM 7100-OPEN-ACCT-CURSOR THRU 7100-EXIT.                
           PERFORM 2110-FETCH-ROWS THRU 2110-EXIT.                      
           PERFORM 7101-CLOSE-ACCT-CURSOR THRU 7101-EXIT.               
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH ACCT-CURSOR                                         
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                  MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                  
                  GO TO 2110-EXIT                                       
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                                                  RS-RETURN-CODE        
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '2110'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1           
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2           
                 MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1         
                 MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
           SET T1-INDEX TO 1.                                           
           SEARCH T1-CSR04281                                           
               WHEN T1-ACCOUNT-NO (T1-INDEX) = AT-ACCOUNT-NO            
                   MOVE 'Y' TO WS-ACCT-EXISTS                           
           END-SEARCH.                                                  
                                                                        
           IF WS-ACCT-EXISTS = 'N'                                      
               PERFORM 2500-LOAD-TABLE THRU 2500-EXIT                   
               MOVE '1' TO T1-CUST-TYPE (T1-INDEX)                      
               IF AT-CODE-ACCT-STAT = 'A'                               
                   MOVE 'Y' TO WS-CUST-ACTIVE                           
               ELSE                                                     
                   MOVE 'Y' TO WS-CUST-NOT-ACTIVE
               END-IF
           END-IF.                      
                                                                        
           GO TO 2110-FETCH-ROWS.                                       
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-SPOUSE.                                                     
                                                                        
           PERFORM 7000-SELECT-SPOUSE THRU 7000-EXIT.                   
           IF WS-SPOUSE-SSN > ' '                                       
              PERFORM 7010-SELECT-SPOUSE-CUSTNO THRU 7010-EXIT          
              IF WS-SPOUSE-CUST > 0                                     
                  MOVE WS-SPOUSE-CUST TO AT-CUSTOMER-NO                 
                  PERFORM 7100-OPEN-ACCT-CURSOR THRU 7100-EXIT          
                  PERFORM 2210-FETCH-ROWS THRU 2210-EXIT                
                  PERFORM 7101-CLOSE-ACCT-CURSOR THRU 7101-EXIT
              END-IF
           END-IF.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH ACCT-CURSOR                                         
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                  MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                  
                  GO TO 2210-EXIT                                       
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                                                  RS-RETURN-CODE        
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '2210'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1           
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2           
                 MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1         
                 MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
           IF AT-CODE-ACCT-STAT = 'A'                                   
               MOVE 'Y' TO WS-SPOUSE-ACTIVE                             
               GO TO 2210-FETCH-ROWS
           END-IF.                                   
                                                                        
           SET T1-INDEX TO 1.                                           
           SEARCH T1-CSR04281                                           
               WHEN T1-ACCOUNT-NO (T1-INDEX) = AT-ACCOUNT-NO            
                   MOVE 'Y' TO WS-ACCT-EXISTS                           
           END-SEARCH.                                                  
                                                                        
           IF WS-ACCT-EXISTS = 'N'                                      
               PERFORM 2500-LOAD-TABLE THRU 2500-EXIT                   
               MOVE '2' TO T1-CUST-TYPE (T1-INDEX)
           END-IF.                     
                                                                        
           GO TO 2210-FETCH-ROWS.                                       
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-CUST-AS-SPOUSE.                                             
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO AT-CUSTOMER-NO.                   
           PERFORM 7102-OPEN-CUST-CURSOR THRU 7102-EXIT.                
           PERFORM 2310-FETCH-ROWS THRU 2310-EXIT.                      
           PERFORM 7103-CLOSE-CUST-CURSOR THRU 7103-EXIT.               
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH CUST-CURSOR                                         
               INTO :CE-CUSTOMER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                  CONTINUE                                              
              WHEN NOT-FOUND                                            
                  MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                  
                  GO TO 2310-EXIT                                       
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
                  MOVE SQLCODE             TO ABEND-SQLCODE             
                                                   RS-RETURN-CODE       
                  MOVE SQLSTATE            TO ABEND-SQLSTATE            
                  MOVE '2310'              TO ACTIVE-PARAGRAPH          
                  MOVE 'FETCH'             TO ABEND-FUNCTION            
                  MOVE 'CSS_ACCOUNT'       TO TABLE-1                   
                  MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1           
                  MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-2           
                  MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1         
                  MOVE AT-COMPANY-NO       TO HOSTVAR-ELEMENT-2         
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
           MOVE CE-CUSTOMER-NO TO AT-CUSTOMER-NO                        
           PERFORM 7100-OPEN-ACCT-CURSOR THRU 7100-EXIT.                
           PERFORM 2320-FETCH-ROWS THRU 2320-EXIT.                      
           PERFORM 7101-CLOSE-ACCT-CURSOR THRU 7101-EXIT.               
                                                                        
           GO TO 2310-FETCH-ROWS.                                       
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2320-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH ACCT-CURSOR                                         
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-PREMISE-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                  MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                  
                  GO TO 2320-EXIT                                       
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                                                  RS-RETURN-CODE        
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '2320'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1           
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2           
                 MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1         
                 MOVE AT-COMPANY-NO        TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
           IF AT-CODE-ACCT-STAT = 'A'                                   
               MOVE 'Y' TO WS-CUST-AS-SPOUSE-ACTIVE                     
               GO TO 2320-FETCH-ROWS
           END-IF.                                   
                                                                        
           SET T1-INDEX TO 1.                                           
           SEARCH T1-CSR04281                                           
               WHEN T1-ACCOUNT-NO (T1-INDEX) = AT-ACCOUNT-NO            
                   MOVE 'Y' TO WS-ACCT-EXISTS                           
           END-SEARCH.                                                  
                                                                        
           IF WS-ACCT-EXISTS = 'N'                                      
               PERFORM 2500-LOAD-TABLE THRU 2500-EXIT                   
               MOVE '3' TO T1-CUST-TYPE (T1-INDEX)
           END-IF.                     
                                                                        
           GO TO 2320-FETCH-ROWS.                                       
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-LOAD-TABLE.                                                 
                                                                        
           ADD +1 TO WS-ACCT-ARRAY-CNT.                                 
           SET T1-INDEX TO WS-ACCT-ARRAY-CNT.                           
           MOVE AT-ACCOUNT-NO TO T1-ACCOUNT-NO (T1-INDEX).              
           MOVE AT-CODE-ACCT-STAT TO T1-CODE-ACCT-STAT (T1-INDEX).      
           MOVE AT-PREMISE-NO TO T1-PREMISE-NO (T1-INDEX).              
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-MONEY-AMOUNTS.                                              
                                                                        
           MOVE 'N' TO T1-RET-CHECK-FL (T1-INDEX)                       
                       WS-ACTIVE-PAST-DUE.                              
           MOVE T1-ACCOUNT-NO (T1-INDEX) TO AT-ACCOUNT-NO.              
      *    IF T1-CUST-TYPE (T1-INDEX) = '1' AND                                 
      *       WS-CUST-ACTIVE = 'Y'                                              
      *           PERFORM 2610-ACTIVE-PAST-DUE THRU 2610-EXIT                   
      *    ELSE                                                                 
           IF T1-CUST-TYPE (T1-INDEX) = '1' AND                         
              WS-CUST-ACTIVE = 'Y'                                      
                  MOVE 'Y' TO WS-ACTIVE-PAST-DUE
           END-IF.                       
                                                                        
           PERFORM 2620-PAST-DUE THRU 2620-EXIT.                        
                                                                        
           PERFORM 7030-CIA THRU 7030-EXIT.                             
           COMPUTE T1-TOTAL-DUE (T1-INDEX) =                            
                   T1-TOTAL-DUE (T1-INDEX) +                            
                   T1-CIA (T1-INDEX).                                   
                                                                        
           IF T1-TOTAL-DUE (T1-INDEX) NOT = 0 AND                       
              T1-CODE-ACCT-STAT (T1-INDEX) NOT = 'A'                    
                  MOVE 'Y' TO WS-DISPLAY-ACTIVE
           END-IF.                        
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2610-ACTIVE-PAST-DUE.                                            
                                                                        
           IF T1-CODE-ACCT-STAT (T1-INDEX) = 'A' OR 'P'                 
               PERFORM 2620-PAST-DUE THRU 2620-EXIT
           END-IF.                    
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2620-PAST-DUE.                                                   
                                                                        
           PERFORM 7040-SELECT-ACCOUNT THRU 7040-EXIT.                  
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'A'                                                 
               WHEN 'B'                                                 
                   PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT            
                   MOVE WS-AMT-ARREARS-UTL TO                           
                        T1-ARREARS-UTIL (T1-INDEX)                      
                   MOVE WS-AMT-ARREARS-NONUTL TO                        
                        T1-ARREARS-NONUTIL (T1-INDEX)                   
                   IF AT-CODE-STATUS-REASON = 'C'                       
                       MOVE WS-AMT-FULL-BAL-UTL TO                      
                            T1-PAST-DUE-UTIL (T1-INDEX)                 
                       MOVE WS-AMT-FULL-BAL-NONUTL TO                   
                            T1-PAST-DUE-NONUTIL (T1-INDEX)              
                   ELSE                                                 
                       MOVE WS-AMT-PAST-DUE-UTL TO                      
                            T1-PAST-DUE-UTIL (T1-INDEX)                 
                       MOVE WS-AMT-PAST-DUE-NONUTL TO                   
                            T1-PAST-DUE-NONUTIL (T1-INDEX)              
                   END-IF                                               
                   MOVE AT-TOTAL-AR-BALANCE TO                          
                        T1-BILLED-BALANCE (T1-INDEX)                    
                   IF (AT-CODE-ACCT-STAT = 'A') OR                      
                      (AT-CODE-ACCT-STAT = 'B' AND                      
                       WS-ACTIVE-PAST-DUE = 'N')                        
                           COMPUTE T1-TOTAL-DUE (T1-INDEX) =            
                                   T1-TOTAL-DUE (T1-INDEX) +            
                                   T1-PAST-DUE-UTIL (T1-INDEX)          
                           END-COMPUTE                                  
                   END-IF                                               
               WHEN 'P'                                                 
                   PERFORM 7600-ORDER-STATE THRU 7600-EXIT              
                   IF T1-CUST-TYPE(T1-INDEX) = '1' AND                  
                      VO-ORDER-STATE-CD = 'R'                           
                          PERFORM 7200-PAYMENTS THRU 7200-EXIT          
                          PERFORM 7300-DEPOSITS THRU 7300-EXIT          
                          PERFORM 7400-SUM-INSTALL-DEP THRU 7400-EXIT   
                          MOVE WS-AMT-INSTALL-DEP TO                    
                               T1-AMT-INSTALL-DEP (T1-INDEX)            
                          COMPUTE T1-DEPOSIT-DUE (T1-INDEX) =           
                                  DO-AMT-DEPOSIT -                      
                                  WS-AMT-INSTALL-DEP                    
                          END-COMPUTE                                   
                          IF AT-COMPANY-NO = '26'                       
                             PERFORM 7500-PSNC-LABOR-CHG THRU 7500-EXIT 
                              MOVE WS-PSNC-LABOR-CHG TO                 
                                  T1-PSNC-LABOR-CHG (T1-INDEX)          
                          END-IF                                        
                          PERFORM 7700-RETURN-CHECK THRU 7700-EXIT      
                          PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT     
                          MOVE WS-AMT-ARREARS-UTL TO                    
                               T1-ARREARS-UTIL (T1-INDEX)               
                          MOVE WS-AMT-ARREARS-NONUTL TO                 
                               T1-ARREARS-NONUTIL (T1-INDEX)            
                          MOVE AT-TOTAL-AR-BALANCE TO                   
                               T1-BILLED-BALANCE (T1-INDEX)             
                          COMPUTE T1-TOTAL-DUE (T1-INDEX) =             
                                  T1-TOTAL-DUE (T1-INDEX) +             
                                  T1-DEPOSIT-DUE (T1-INDEX) +           
                                  T1-PSNC-LABOR-CHG (T1-INDEX) -        
                                  T1-PAYMENTS (T1-INDEX)                
                          END-COMPUTE                                   
                   END-IF                                               
               WHEN 'S'                                                 
                   IF AT-ACCT-FINALED-DT(1:10) >= WS-CUT-OFF-DATE       
                       PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT        
                       MOVE WS-AMT-PAST-DUE-UTL TO                      
                            T1-PAST-DUE-UTIL (T1-INDEX)                 
                       MOVE WS-AMT-PAST-DUE-NONUTL TO                   
                            T1-PAST-DUE-NONUTIL (T1-INDEX)              
                       MOVE WS-WO-BALANCE TO                            
                            T1-BILLED-BALANCE (T1-INDEX)                
                       MOVE WS-AMT-ARREARS-UTL TO                       
                            T1-ARREARS-UTIL (T1-INDEX)                  
                       MOVE WS-AMT-ARREARS-NONUTL TO                    
                            T1-ARREARS-NONUTIL (T1-INDEX)               
                       COMPUTE T1-TOTAL-DUE (T1-INDEX) =                
                               T1-TOTAL-DUE (T1-INDEX) +                
                               T1-PAST-DUE-UTIL (T1-INDEX)              
                       END-COMPUTE                                      
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-PROCESS-TABLE.                                              
                                                                        
           IF T1-CIA (T1-INDEX) = 0 AND                                 
              T1-PAST-DUE-UTIL (T1-INDEX) = 0 AND                       
              T1-DEPOSIT-DUE (T1-INDEX) = 0 AND                         
              T1-PAYMENTS (T1-INDEX) = 0 AND                            
              T1-PSNC-LABOR-CHG (T1-INDEX) = 0 AND                      
              T1-BILLED-BALANCE (T1-INDEX) = 0                          
                  GO TO 3000-EXIT
           END-IF.                                      
      *    IF T1-CODE-ACCT-STAT (T1-INDEX) = 'A' AND                            
      *       WS-DISPLAY-ACTIVE = 'N' AND                                       
      *       T1-CIA (T1-INDEX) = 0 AND                                         
      *       T1-PAST-DUE-UTIL (T1-INDEX) = 0 AND                               
      *       T1-DEPOSIT-DUE (T1-INDEX) = 0 AND                                 
      *       T1-PAYMENTS (T1-INDEX) = 0 AND                                    
      *       T1-PSNC-LABOR-CHG (T1-INDEX) = 0 AND                              
      *       T1-BILLED-BALANCE (T1-INDEX) NOT = 0                              
      *           GO TO 3000-EXIT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE T1-ACCOUNT-NO (T1-INDEX) TO S-ACCOUNT-NO.               
           MOVE T1-CODE-ACCT-STAT (T1-INDEX) TO S-CODE-ACCT-STAT.       
           EVALUATE T1-CUST-TYPE (T1-INDEX)                             
               WHEN '1'                                                 
                   MOVE 'CUSTOMER' TO S-CUST-TYPE                       
                   MOVE WS-CUST-SSN TO S-SSN                            
                   MOVE WS-CUST-NAME TO S-NAME                          
               WHEN '2'                                                 
                   MOVE 'SPOUSE' TO S-CUST-TYPE                         
                   MOVE WS-SPOUSE-SSN TO S-SSN                          
                   MOVE WS-SPOUSE-NAME TO S-NAME                        
               WHEN '3'                                                 
                   MOVE 'CUSTOMER AS SPOUSE' TO S-CUST-TYPE             
                   MOVE WS-CUST-SSN TO S-SSN                            
                   MOVE WS-CUST-NAME TO S-NAME                          
               WHEN OTHER                                               
                   MOVE T1-CUST-TYPE (T1-INDEX) TO S-CUST-TYPE          
                   MOVE WS-CUST-SSN TO S-SSN                            
                   MOVE WS-CUST-NAME TO S-NAME                          
           END-EVALUATE.                                                
           MOVE T1-PREMISE-NO (T1-INDEX) TO S-PREMISE-NO                
                                            PR-PREMISE-NO.              
           PERFORM 7020-SELECT-ADDRESS THRU 7020-EXIT.                  
           MOVE T1-CIA (T1-INDEX) TO S-CIA.                             
           MOVE T1-PAST-DUE-UTIL (T1-INDEX) TO S-PAST-DUE-UTIL.         
           MOVE T1-PAST-DUE-NONUTIL (T1-INDEX) TO S-PAST-DUE-NONUTIL.   
           MOVE T1-BILLED-BALANCE (T1-INDEX) TO S-BILLED-BALANCE.       
           MOVE T1-DEPOSIT-DUE (T1-INDEX) TO S-DEPOSIT-DUE.             
           MOVE T1-PAYMENTS (T1-INDEX) TO S-PAYMENTS.                   
           MOVE T1-PSNC-LABOR-CHG (T1-INDEX) TO S-PSNC-LABOR-CHG.       
           MOVE T1-RET-CHECK-FL (T1-INDEX) TO S-RET-CHECK-FL.           
           MOVE T1-ARREARS-UTIL (T1-INDEX) TO S-ARREARS-UTIL.           
           MOVE T1-ARREARS-NONUTIL (T1-INDEX) TO S-ARREARS-NONUTIL.     
           MOVE T1-AMT-INSTALL-DEP (T1-INDEX) TO S-AMT-INSTALL-DEP.     
           MOVE T1-TOTAL-DUE (T1-INDEX) TO S-TOTAL-DUE.                 
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-SPOUSE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SSN,
              RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME) + ' ' + 
           RTRIM(LAST_NAME) + ' ' + RTRIM(TITLE_SUFFIX_1),
              FULL_NAME,
              NAME_FORMAT                                        
                INTO :CE-SSN,                                           
                     :WS-SPOUSE-NAME,                                   
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                   
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO     = :AT-CUSTOMER-NO                  
                 AND CUSTOMER_TYPE   = 'S'                              
                 AND SSN <> ' '                                         
                 AND CE.NAME_ID = DQ.NAME_ID                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SSN,                                                       
MFA-TR*              RTRIM(FIRST_NAME) ||                                       
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(MIDDLE_NAME) ||                                      
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(LAST_NAME) ||                                        
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(TITLE_SUFFIX_1),                                     
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              NAME_FORMAT                                                
MFA-TR*         INTO :CE-SSN,                                                   
MFA-TR*              :WS-SPOUSE-NAME,                                           
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-FORMAT                                            
MFA-TR*         FROM CSS_CUST_STATS CE,                                         
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE CUSTOMER_NO     = :AT-CUSTOMER-NO                          
MFA-TR*          AND CUSTOMER_TYPE   = 'S'                                      
MFA-TR*          AND SSN <> ' '                                                 
MFA-TR*          AND CE.NAME_ID = DQ.NAME_ID                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CE-SSN TO WS-SPOUSE-SSN                         
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-SPOUSE-NAME              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-SPOUSE-SSN                         
                                  WS-SPOUSE-NAME                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-SELECT-CUST-SSN.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SSN,
              RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME) + ' ' + 
           RTRIM(LAST_NAME) + ' ' + RTRIM(TITLE_SUFFIX_1),
              FULL_NAME,
              NAME_FORMAT                                        
                INTO :CE-SSN,                                           
                     :WS-CUST-NAME,                                     
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                   
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO     = :AT-CUSTOMER-NO                  
                 AND CUSTOMER_TYPE   = 'C'                              
                 AND CE.NAME_ID = DQ.NAME_ID                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SSN,                                                       
MFA-TR*              RTRIM(FIRST_NAME) ||                                       
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(MIDDLE_NAME) ||                                      
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(LAST_NAME) ||                                        
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(TITLE_SUFFIX_1),                                     
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              NAME_FORMAT                                                
MFA-TR*         INTO :CE-SSN,                                                   
MFA-TR*              :WS-CUST-NAME,                                             
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-FORMAT                                            
MFA-TR*         FROM CSS_CUST_STATS CE,                                         
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE CUSTOMER_NO     = :AT-CUSTOMER-NO                          
MFA-TR*          AND CUSTOMER_TYPE   = 'C'                                      
MFA-TR*          AND CE.NAME_ID = DQ.NAME_ID                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CE-SSN TO WS-CUST-SSN                           
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-CUST-NAME                
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-CUST-SSN                           
                                  WS-CUST-NAME                          
                   PERFORM 7060-CUSTOMER-NAME THRU 7060-EXIT            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7005'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-SPOUSE-CUSTNO.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO                                        
                INTO :AT-CUSTOMER-NO                                    
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE SSN             = :CE-SSN                          
                 AND CUSTOMER_TYPE   = 'C'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*         INTO :AT-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE SSN             = :CE-SSN                                  
MFA-TR*          AND CUSTOMER_TYPE   = 'C'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CUSTOMER-NO TO WS-SPOUSE-CUST                
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-SPOUSE-CUST                        
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_STATS'    TO TABLE-1                  
                   MOVE 'SSN'               TO TABLE-ELEMENT-1          
                   MOVE CE-SSN              TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  VALUE AFTER STREET LOC 2 IN CONCATENATION IS HEX 0A (NEWLINE)          
                                                                        
       7020-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + CHAR(10) + LTRIM(RTRIM(TOWN) + 
           ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE)))
           ))))))))))              
                 INTO :WS-SERV-ADDRESS                                  
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                    
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||             00010002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||              00020002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||              00030002
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                00040002
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||              00050002
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                00060002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||          00070002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||           00080002
MFA-TR*               ' ' ||                                                    
MFA-TR*               BINCHAR(10) ||
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                      00090006
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                      00100002
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE)))))))))))))              00110004
MFA-TR*          INTO :WS-SERV-ADDRESS                                          
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            00130001
MFA-TR*               CSS_ZIP_CODE A4,                                  00140001
MFA-TR*               CSS_PREMISE PR                                    00150001
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                       00160000
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                     00170000
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                         00180000
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             00190000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00200000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-SERV-ADDRESS TO S-SERV-ADDRESS               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-SERV-ADDRESS                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CIA.                                                        
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_UNUSED_CR)                                 
                INTO :AC-AMT-UNUSED-CR :WS-NULL6                         
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = 70                             
                 AND ITEM_ID           IN(1,2)                          
                 AND AMT_UNUSED_CR     <> 0                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_UNUSED_CR)                                         
MFA-TR*         INTO :AC-AMT-UNUSED-CR:WS-NULL6                                 
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 70                                     
MFA-TR*          AND ITEM_ID           IN(1,2)                                  
MFA-TR*          AND AMT_UNUSED_CR     <> 0                                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL6 < 0                                      
                       MOVE ZEROES TO AC-AMT-UNUSED-CR                  
                   END-IF                                               
                   MOVE AC-AMT-UNUSED-CR TO T1-CIA (T1-INDEX)           
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  T1-CIA (T1-INDEX)                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7030'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_AR_CNTL'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT COMPANY_NO,                                         
                   CODE_COMPANY_ACCT,                                   
                   CODE_ACCT_STAT,                                      
                   CODE_STATUS_REASON,                                  
                   PREMISE_NO,                                          
                   CUSTOMER_NO,                                         
                   DATE_LAST_ACTION,                                    
                   LOCAL_OFFICE,                                        
                   CODES_DATA_PRESENT,                                  
                   CREDIT_GROUP,                                        
                   TOTAL_AR_BALANCE,                                    
                   NOTICE_EXEMPT_CD,                                    
                   CODE_DISC_OK,                                        
                   DATE_BILL_DAY_00,                                    
                   DATE_BILL_DAY_30,                                    
                   DATE_BILL_DAY_60,                                    
                   DATE_BILL_DAY_90,                                    
                   BANKRUPTCY_IND,                                      
                   IVR_EXEMPT_CD,                                       
                   REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
            INTO :AT-COMPANY-NO,                                        
                 :AT-CODE-COMPANY-ACCT,                                 
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-CODE-STATUS-REASON,                                
                 :AT-PREMISE-NO,                                        
                 :AT-CUSTOMER-NO,                                       
                 :AT-DATE-LAST-ACTION,                                  
                 :AT-LOCAL-OFFICE,                                      
                 :AT-CODES-DATA-PRESENT,                                
                 :AT-CREDIT-GROUP,                                      
                 :AT-TOTAL-AR-BALANCE,                                  
                 :AT-NOTICE-EXEMPT-CD,                                  
                 :AT-CODE-DISC-OK,                                      
                 :AT-DATE-BILL-DAY-00 :WS-NULL1,                         
                 :AT-DATE-BILL-DAY-30 :WS-NULL2,                         
                 :AT-DATE-BILL-DAY-60 :WS-NULL3,                         
                 :AT-DATE-BILL-DAY-90 :WS-NULL4,                         
                 :AT-BANKRUPTCY-IND,                                    
                 :AT-IVR-EXEMPT-CD,                                     
                 :AT-ACCT-FINALED-DT :WS-NULL5                           
              FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                           
             WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COMPANY_NO,                                                 
MFA-TR*            CODE_COMPANY_ACCT,                                           
MFA-TR*            CODE_ACCT_STAT,                                              
MFA-TR*            CODE_STATUS_REASON,                                          
MFA-TR*            PREMISE_NO,                                                  
MFA-TR*            CUSTOMER_NO,                                                 
MFA-TR*            DATE_LAST_ACTION,                                            
MFA-TR*            LOCAL_OFFICE,                                                
MFA-TR*            CODES_DATA_PRESENT,                                          
MFA-TR*            CREDIT_GROUP,                                                
MFA-TR*            TOTAL_AR_BALANCE,                                            
MFA-TR*            NOTICE_EXEMPT_CD,                                            
MFA-TR*            CODE_DISC_OK,                                                
MFA-TR*            DATE_BILL_DAY_00,                                            
MFA-TR*            DATE_BILL_DAY_30,                                            
MFA-TR*            DATE_BILL_DAY_60,                                            
MFA-TR*            DATE_BILL_DAY_90,                                            
MFA-TR*            BANKRUPTCY_IND,                                              
MFA-TR*            IVR_EXEMPT_CD,                                               
MFA-TR*            ACCT_FINALED_DT                                              
MFA-TR*     INTO :AT-COMPANY-NO,                                                
MFA-TR*          :AT-CODE-COMPANY-ACCT,                                         
MFA-TR*          :AT-CODE-ACCT-STAT,                                            
MFA-TR*          :AT-CODE-STATUS-REASON,                                        
MFA-TR*          :AT-PREMISE-NO,                                                
MFA-TR*          :AT-CUSTOMER-NO,                                               
MFA-TR*          :AT-DATE-LAST-ACTION,                                          
MFA-TR*          :AT-LOCAL-OFFICE,                                              
MFA-TR*          :AT-CODES-DATA-PRESENT,                                        
MFA-TR*          :AT-CREDIT-GROUP,                                              
MFA-TR*          :AT-TOTAL-AR-BALANCE,                                          
MFA-TR*          :AT-NOTICE-EXEMPT-CD,                                          
MFA-TR*          :AT-CODE-DISC-OK,                                              
MFA-TR*          :AT-DATE-BILL-DAY-00:WS-NULL1,                                 
MFA-TR*          :AT-DATE-BILL-DAY-30:WS-NULL2,                                 
MFA-TR*          :AT-DATE-BILL-DAY-60:WS-NULL3,                                 
MFA-TR*          :AT-DATE-BILL-DAY-90:WS-NULL4,                                 
MFA-TR*          :AT-BANKRUPTCY-IND,                                            
MFA-TR*          :AT-IVR-EXEMPT-CD,                                             
MFA-TR*          :AT-ACCT-FINALED-DT:WS-NULL5                                   
MFA-TR*       FROM  CSS_ACCOUNT                                                 
MFA-TR*      WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                                
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE SPACES TO AT-DATE-BILL-DAY-00               
                   END-IF                                               
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO AT-DATE-BILL-DAY-30               
                   END-IF                                               
                   IF WS-NULL3 < 0                                      
                       MOVE SPACES TO AT-DATE-BILL-DAY-60               
                   END-IF                                               
                   IF WS-NULL4 < 0                                      
                       MOVE SPACES TO AT-DATE-BILL-DAY-90               
                   END-IF                                               
                   IF WS-NULL5 < 0                                      
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7040'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD   = 'WO-CUTOFF-DT'                       
                AND  COMPANY_NO  = :AT-COMPANY-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD   = 'WO-CUTOFF-DT'                               
MFA-TR*         AND  COMPANY_NO  = :AT-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   EXEC SQL                                             
                       SELECT
              DATEADD( YEAR, -:C8-DELINQ-VALUE, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CUT-OFF-DATE        
                   END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*            EXEC SQL                                                     
MFA-TR*                SET :WS-CUT-OFF-DATE =                                   
MFA-TR*                    CURRENT DATE - :C8-DELINQ-VALUE YEARS                
MFA-TR*            END-EXEC                                                     
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE GTT-RETURN-FIELDS                         
                   MOVE +100 TO S-RETURN-CODE                           
                   MOVE 'NO DATA' TO S-SERV-ADDRESS                     
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                   PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7050'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_DELINQUENCY'   TO TABLE-1                  
                   MOVE 'WO-CUTOFF-DT'      TO TABLE-ELEMENT-1          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-CUSTOMER-NAME.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME
           ) + ' ' + RTRIM(LAST_NAME) + ' ' + RTRIM(TITLE_SUFFIX_1),
              FULL_NAME,
              NAME_FORMAT                                        
                INTO :WS-CUST-NAME,                                     
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
                FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                      
                 AND CU.NAME_ID = DQ.NAME_ID                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RTRIM(FIRST_NAME) ||                                       
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(MIDDLE_NAME) ||                                      
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(LAST_NAME) ||                                        
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(TITLE_SUFFIX_1),                                     
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              NAME_FORMAT                                                
MFA-TR*         INTO :WS-CUST-NAME,                                             
MFA-TR*              :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-FORMAT                                            
MFA-TR*         FROM CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                              
MFA-TR*          AND CU.NAME_ID = DQ.NAME_ID                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-CUST-NAME                
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-CUST-NAME                          
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7060'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUSTOMER'      TO TABLE-1                  
                   MOVE 'CSS_NAME'          TO TABLE-2                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-ACCT-CURSOR.                                           
                                                                        
           MOVE LINK-COMPANY-NO TO AT-COMPANY-NO.                       
                                                                        
           EXEC SQL                                                     
              OPEN ACCT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7101-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7101'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7102-OPEN-CUST-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN CUST-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7102'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_STATS'         TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'SSN'                    TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7103-CLOSE-CUST-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE CUST-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7103'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-PAYMENTS.                                                   
                                                                        
           EXEC SQL                                                     
A04558         SELECT SUM(AMT_POSTED)                                   
                 INTO :WS-TOTAL-PAYMENTS :WS-NULL7                       
                 FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED),               
A04558                CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)               
                WHERE AR.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND CODE_TRAN_TYPE = 'P'                              
A04558            AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                     
A04558            AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO       
A04558            AND GL_ACCT_CREDIT = 142.0800                         
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_POSTED)                                           
MFA-TR*          INTO :WS-TOTAL-PAYMENTS:WS-NULL7                               
MFA-TR*          FROM CSS_AR_TRANS_HIST AR,                                     
MFA-TR*               CSS_AR_TRN_HST_DET AU                                     
MFA-TR*         WHERE AR.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND CODE_TRAN_TYPE = 'P'                                      
MFA-TR*           AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                             
MFA-TR*           AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO               
MFA-TR*           AND GL_ACCT_CREDIT = 142.0800                                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 72001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL7 < 0                                      
                       MOVE 0.0 TO WS-TOTAL-PAYMENTS                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO WS-TOTAL-PAYMENTS                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7200'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT1'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
A04558         SELECT SUM(AMT_POSTED)                                   
                 INTO :WS-TOTAL-CORRECTIONS :WS-NULL8                    
                 FROM CSS_AR_TRANS_HIST AR WITH(READUNCOMMITTED),               
A04558                CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)               
                WHERE AR.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND CODE_TRAN_TYPE = 'C'                              
A04558            AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                     
A04558            AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO       
A04558            AND GL_ACCT_DEBIT = 142.0800                          
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_POSTED)                                           
MFA-TR*          INTO :WS-TOTAL-CORRECTIONS:WS-NULL8                            
MFA-TR*          FROM CSS_AR_TRANS_HIST AR,                                     
MFA-TR*               CSS_AR_TRN_HST_DET AU                                     
MFA-TR*         WHERE AR.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND CODE_TRAN_TYPE = 'C'                                      
MFA-TR*           AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                             
MFA-TR*           AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO               
MFA-TR*           AND GL_ACCT_DEBIT = 142.0800                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 72002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL8 < 0                                      
                       MOVE 0.0 TO WS-TOTAL-CORRECTIONS                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO WS-TOTAL-CORRECTIONS                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7200'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT2'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           COMPUTE T1-PAYMENTS (T1-INDEX) =                             
                   WS-TOTAL-PAYMENTS -                                  
                   WS-TOTAL-CORRECTIONS.                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-DEPOSITS.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :DO-AMT-DEPOSIT :WS-NULL9                          
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND DEPOSIT_STATUS_CD NOT IN ('R', 'T')               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :DO-AMT-DEPOSIT:WS-NULL9                                  
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_STATUS_CD NOT IN ('R', 'T')                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL9 < 0                                      
                       MOVE 0.0 TO DO-AMT-DEPOSIT                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO DO-AMT-DEPOSIT                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7300'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SUM-INSTALL-DEP.                                            
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :WS-AMT-INSTALL-DEP :WS-NULL10                     
                 FROM CSS_DEP_ON_HAND D1 WITH(READUNCOMMITTED),                 
                      CSS_DEP_REQ DR WITH(READUNCOMMITTED)                      
                WHERE D1.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND D1.ACCOUNT_NO = DR.ACCOUNT_NO                     
                  AND DEPOSIT_STATUS_CD = 'A'                           
                  AND DEP_BILL_OPTION_CD = 'T'                          
                  AND DEPOSIT_CERT_NO = DEP_ITEM_ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :WS-AMT-INSTALL-DEP:WS-NULL10                             
MFA-TR*          FROM CSS_DEP_ON_HAND D1,                                       
MFA-TR*               CSS_DEP_REQ DR                                            
MFA-TR*         WHERE D1.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND D1.ACCOUNT_NO = DR.ACCOUNT_NO                             
MFA-TR*           AND DEPOSIT_STATUS_CD = 'A'                                   
MFA-TR*           AND DEP_BILL_OPTION_CD = 'T'                                  
MFA-TR*           AND DEPOSIT_CERT_NO = DEP_ITEM_ID                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL10 < 0                                     
                       MOVE 0.00 TO WS-AMT-INSTALL-DEP                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7400'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1             
                   MOVE 'CSS_DEP_REQ'            TO TABLE-2             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-PSNC-LABOR-CHG.                                             
                                                                        
           EXEC SQL                                                     
              SELECT SUM(VG.STD_LABOR_CHRG)                             
                INTO :WS-PSNC-LABOR-CHG :WS-NULL11                       
                FROM CSS_SO_DATA    VO WITH(READUNCOMMITTED),                   
                     CSS_SO_CHARGES VG WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
                 AND VO.SERV_ORDER_NO  = VG.SERV_ORDER_NO               
                 AND ORDER_TYPE_CD  IN ('CC001', 'CC002', 'CC003'       
                                                ,'NC001' )              
                 AND CODE_UTIL_TYPE = 'G'                               
                 AND ORDER_STATE_CD = 'R'                               
                 AND WORK_PERIOD_CD IN ('X', 'Y')                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(VG.STD_LABOR_CHRG)                                     
MFA-TR*         INTO :WS-PSNC-LABOR-CHG:WS-NULL11                               
MFA-TR*         FROM CSS_SO_DATA    VO,                                         
MFA-TR*              CSS_SO_CHARGES VG                                          
MFA-TR*        WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                            
MFA-TR*          AND VO.SERV_ORDER_NO  = VG.SERV_ORDER_NO                       
MFA-TR*          AND ORDER_TYPE_CD  IN ('CC001', 'CC002', 'CC003'               
MFA-TR*                                         ,'NC001' )                      
MFA-TR*          AND CODE_UTIL_TYPE = 'G'                                       
MFA-TR*          AND ORDER_STATE_CD = 'R'                                       
MFA-TR*          AND WORK_PERIOD_CD IN ('X', 'Y')                               
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL11 < 0                                     
                       MOVE 0.00 TO WS-PSNC-LABOR-CHG                   
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7500'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_SO_DATA'            TO TABLE-1             
                   MOVE 'CSS_SO_CHARGES'         TO TABLE-2             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-ORDER-STATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ORDER_STATE_CD                                     
                INTO :VO-ORDER-STATE-CD                                 
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND ORDER_STATE_CD = 'R'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ORDER_STATE_CD                                             
MFA-TR*         INTO :VO-ORDER-STATE-CD                                         
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND ORDER_STATE_CD = 'R'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO VO-ORDER-STATE-CD                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7600'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_SO_DATA'            TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-RETURN-CHECK.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :NH-ACCOUNT-NO                                     
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND NSF_STATUS_CD = 'C'                                
A04558                                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :NH-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND NSF_STATUS_CD = 'C'                                        
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO T1-RET-CHECK-FL (T1-INDEX)               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO T1-RET-CHECK-FL (T1-INDEX)               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7700'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_NSF_HIST'           TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04281_R1                            
             (                                                          
              RETURN_CODE,                                              
              ACCOUNT_NO,                                               
              CODE_ACCT_STAT,                                           
              PAST_DUE_UTIL,                                            
              PAST_DUE_NONUTIL,                                         
              CUST_TYPE,                                                
              SSN,                                                      
              SERV_ADDRESS,                                             
              CIA,                                                      
              BILLED_BALANCE,                                           
              DEPOSIT_DUE,                                              
              PAYMENTS,                                                 
              PSNC_LABOR_CHG,                                           
              RET_CHECK_FL,                                             
              NAME,                                                     
              TOTAL_DUE                                                 
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-ACCOUNT-NO,                                           
               :S-CODE-ACCT-STAT,                                       
               :S-PAST-DUE-UTIL,                                        
               :S-PAST-DUE-NONUTIL,                                     
               :S-CUST-TYPE,                                            
               :S-SSN,                                                  
               :S-SERV-ADDRESS,                                         
               :S-CIA,                                                  
               :S-BILLED-BALANCE,                                       
               :S-DEPOSIT-DUE,                                          
               :S-PAYMENTS,                                             
               :S-PSNC-LABOR-CHG,                                       
               :S-RET-CHECK-FL,                                         
               :S-NAME,                                                 
               :S-TOTAL-DUE                                             
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04281_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       CODE_ACCT_STAT,                                                   
MFA-TR*       PAST_DUE_UTIL,                                                    
MFA-TR*       PAST_DUE_NONUTIL,                                                 
MFA-TR*       CUST_TYPE,                                                        
MFA-TR*       SSN,                                                              
MFA-TR*       SERV_ADDRESS,                                                     
MFA-TR*       CIA,                                                              
MFA-TR*       BILLED_BALANCE,                                                   
MFA-TR*       DEPOSIT_DUE,                                                      
MFA-TR*       PAYMENTS,                                                         
MFA-TR*       PSNC_LABOR_CHG,                                                   
MFA-TR*       RET_CHECK_FL,                                                     
MFA-TR*       NAME,                                                             
MFA-TR*       TOTAL_DUE                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-CODE-ACCT-STAT,                                               
MFA-TR*        :S-PAST-DUE-UTIL,                                                
MFA-TR*        :S-PAST-DUE-NONUTIL,                                             
MFA-TR*        :S-CUST-TYPE,                                                    
MFA-TR*        :S-SSN,                                                          
MFA-TR*        :S-SERV-ADDRESS,                                                 
MFA-TR*        :S-CIA,                                                          
MFA-TR*        :S-BILLED-BALANCE,                                               
MFA-TR*        :S-DEPOSIT-DUE,                                                  
MFA-TR*        :S-PAYMENTS,                                                     
MFA-TR*        :S-PSNC-LABOR-CHG,                                               
MFA-TR*        :S-RET-CHECK-FL,                                                 
MFA-TR*        :S-NAME,                                                         
MFA-TR*        :S-TOTAL-DUE                                                     
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04281_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04281_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04281_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04281_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       9500-CALL-CPD00068.                                              
                                                                        
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
           MOVE SPACES TO WS-HOLD-DATE.                                 
           MOVE 'Y' TO CALC-BALANCE-SW                                  
                       CALC-ARREARS-SW                                  
                       CALC-PAST-DUE-SW                                 
                       LOAD-DNP-DATE-SW.                                
                                                                        
           CALL WS-MCSCB068  USING CWS00068-FIELDS                      
                                   WS-CODES-DATA-PRESENT                
                                   DCLCSS-ACCOUNT                       
                                   ABEND-FILE                           
                                   RS-RETURN-CODE.                      
                                                                        
           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
                                  S-RETURN-CODE                         
                                  SQLCODE.                              
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1 TO RS-RETURN-CODE                              
                            WS-ACTIVE-RETURN-CODE                       
              END-IF                                                    
              MOVE PROGRAM-NAME TO ABEND-PROGRAM                        
              MOVE '9500' TO ACTIVE-PARAGRAPH                           
              MOVE 'CALL' TO ABEND-FUNCTION                             
              MOVE 'MCSCB068' TO TABLE-1                                
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
