       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04277.                                          
COB303 DATE-WRITTEN.      AUGUST 6, 2010.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS ORDER INFO TO THE IVR AND WEB.           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/06/10    FMB      NEW PROGRAM.                                      
P00836*  08/16/16    FMB      NEW WORK TYPE OF LNI. CHANGE LITERALS.            
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04277'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04277 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKCST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOCRQ                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04277_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04277_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04277_R3'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-WEBORDERNO        PIC X(13) VALUE SPACES.           
               10 S-WEBFLAG           PIC X(01) VALUE SPACES.           
               10 S-EDITFLAG          PIC X(01) VALUE SPACES.           
               10 S-NONPRODFLAG       PIC X(01) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-FULL-NAME          PIC X(70) VALUE SPACES.          
               10 S-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.          
               10 S-ORDER-TYPE-CD      PIC X(05) VALUE SPACES.          
               10 S-WORK-TYPE-CD       PIC X(03) VALUE SPACES.          
               10 S-ASSIGNED-DATETIME  PIC X(26) VALUE SPACES.          
               10 S-COMPLETED-DATETIME PIC X(26) VALUE SPACES.          
               10 S-SERV-ORDER-STATUS  PIC X(02) VALUE SPACES.          
               10 S-ORDER-STATE-CD     PIC X(01) VALUE SPACES.          
               10 S-ACCOUNT-NO         PIC S9(13) COMP-3 VALUE 0.       
               10 S-SERV-ORDER-NO      PIC S9(13) COMP-3 VALUE 0.       
               10 S-ORDER-GROUP-CD     PIC X(01) VALUE SPACES.          
               10 S-COMPANY-NO         PIC X(02) VALUE SPACES.          
               10 S-CUSTOMER-NO        PIC S9(10) COMP-3 VALUE 0.       
               10 S-ACCOUNT-NO-PRIOR   PIC S9(13) COMP-3 VALUE 0.       
               10 S-LOCAL-OFFICE       PIC X(03) VALUE SPACES.          
               10 S-ZIP-CODE           PIC X(05) VALUE SPACES.          
               10 S-HISTORY-FLAG       PIC X(01) VALUE SPACES.          
               10 S-ORDER-TYPE-DESC    PIC X(15) VALUE SPACES.          
               10 S-WORK-TYPE-DESC     PIC X(25) VALUE SPACES.          
               10 S-ORDER-REASON       PIC X(15) VALUE SPACES.          
               10 S-STATUS-TX          PIC X(25) VALUE SPACES.          
               10 S-DATE-RECVED        PIC X(26) VALUE SPACES.          
               10 S-ORDER-RECVED-BY    PIC X(07) VALUE SPACES.          
               10 S-CUST-REQ-TYPE-CD   PIC X(08) VALUE SPACES.          
               10 S-CUST-REQ-SOURCE-CD PIC X(03) VALUE SPACES.          
               10 S-BEGIN-APPT-DT      PIC X(26) VALUE SPACES.          
               10 S-END-APPT-DT        PIC X(26) VALUE SPACES.          
               10 S-APPT-AM-PM-CD      PIC X(01) VALUE SPACES.          
               10 S-WORK-COMPLETED-IND PIC X(01) VALUE SPACES.          
               10 S-RETURN-CODE-2      PIC S9(9) COMP VALUE 0.          
               10 S-SERVICETYPE        PIC X(25) VALUE SPACES.          
               10 S-STATUS             PIC X(10) VALUE SPACES.          
               10 S-COMMENTS           PIC X(10) VALUE SPACES.          
               10 S-BUTTON             PIC X(01) VALUE SPACES.          
               10 S-CREATEDDATE        PIC X(26) VALUE SPACES.          
               10 S-COMPLETEDATE       PIC X(26) VALUE SPACES.          
               10 S-BEGAPPTDATE        PIC X(26) VALUE SPACES.          
               10 S-ENDAPPTDATE        PIC X(26) VALUE SPACES.          
               10 S-APPTAMPMCD         PIC X(01) VALUE SPACES.          
           05  GTT-RETURN-FIELDS-3.                                     
               10 S-RETURN-CODE-3     PIC S9(9) COMP VALUE 0.           
               10 S-SERVORDERNO       PIC X(13) VALUE SPACES.           
               10 S-EXISTSFLAG        PIC X(01) VALUE SPACES.           
               10 S-ASSIGNDATETIME    PIC X(26) VALUE SPACES.           
               10 S-SOAGE             PIC X(05) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-SERV-ORDER-NO-NUM     PIC 9(13).                      
           05  WS-SERV-ORDER-NO-CHAR    REDEFINES WS-SERV-ORDER-NO-NUM  
                                        PIC X(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04277'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-DAYS-COUNT            PIC S9(4) COMP VALUE 0.         
           05  WS-DAYS-COUNT-NUM        PIC -9(04).                     
           05  WS-DAYS-COUNT-CHAR       REDEFINES WS-DAYS-COUNT-NUM     
                                        PIC X(05).                      
           05  WS-PROCESS-FLOW          PIC X(01) VALUE SPACES.         
               88  WEB-ACTIVE-STREET    VALUE '1'.                      
               88  WEB-ACTIVE-OUTDOOR   VALUE '2'.                      
               88  WEB-ACTIVE-PILOT     VALUE '3'.                      
               88  WEB-REQUEST          VALUE '4'.                      
               88  IVR-EXISTS           VALUE '5'.                      
           05  WS-WORK-COMPLETED-IND    PIC X(01) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE ACTIVE-STREET CURSOR FOR                          
               SELECT VO.SERV_ORDER_NO,                                 
                      VO.ORDER_RECVED_BY,                               
                      VO.ORDER_STATE_CD,                                
                      VO.SERV_ORDER_STATUS                              
                 FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO
                           WITH(READUNCOMMITTED) LEFT OUTER JOIN               
                      CSS_SO_CUST_REQ OW WITH(READUNCOMMITTED) ON               
                      OW.SERV_ORDER_NO = VO.SERV_ORDER_NO               
                WHERE VO.PREMISE_NO = :VO-PREMISE-NO                    
                  AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                    
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                  AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')               
                  AND ((VO.ORDER_TYPE_CD = 'FW003'                      
                  AND   VO.ORDER_RECVED_BY <> 'ECSPRD1'                 
                  AND   VI.WORK_TYPE_CD = 'LRL')                        
                   OR  (VO.ORDER_TYPE_CD = 'FW008'                      
                  AND   VO.ORDER_RECVED_BY <> 'ECSPRD1'                 
                  AND   VI.WORK_TYPE_CD = 'LRL')                        
                   OR  (CUST_REQ_TYPE_CD = 'FW003LRL')                  
                   OR  (CUST_REQ_TYPE_CD = 'FW008LRL'))                 
                ORDER BY DATE_RECVED                                    
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACTIVE-STREET CURSOR FOR                                  
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               VO.ORDER_RECVED_BY,                                       
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VO.SERV_ORDER_STATUS                                      
MFA-TR*          FROM CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_SO_DATA VO LEFT OUTER JOIN                            
MFA-TR*               CSS_SO_CUST_REQ OW ON                                     
MFA-TR*               OW.SERV_ORDER_NO = VO.SERV_ORDER_NO                       
MFA-TR*         WHERE VO.PREMISE_NO = :VO-PREMISE-NO                            
MFA-TR*           AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                            
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')                       
MFA-TR*           AND ((VO.ORDER_TYPE_CD = 'FW003'                              
MFA-TR*           AND   VO.ORDER_RECVED_BY = 'ECSPRD1'                         
MFA-TR*           AND   VI.WORK_TYPE_CD = 'LRL')                                
MFA-TR*            OR  (VO.ORDER_TYPE_CD = 'FW008'                              
MFA-TR*           AND   VO.ORDER_RECVED_BY = 'ECSPRD1'                         
MFA-TR*           AND   VI.WORK_TYPE_CD = 'LRL')                                
MFA-TR*            OR  (CUST_REQ_TYPE_CD = 'FW003LRL')                          
MFA-TR*            OR  (CUST_REQ_TYPE_CD = 'FW008LRL'))                         
MFA-TR*         ORDER BY DATE_RECVED                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ACTIVE-OUTDOOR CURSOR FOR                         
               SELECT VO.SERV_ORDER_NO,                                 
                      VO.ORDER_RECVED_BY,                               
                      VO.ORDER_STATE_CD,                                
                      VO.SERV_ORDER_STATUS                              
                 FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO
                           WITH(READUNCOMMITTED) LEFT OUTER JOIN               
                      CSS_SO_CUST_REQ OW WITH(READUNCOMMITTED) ON               
                      OW.SERV_ORDER_NO = VO.SERV_ORDER_NO               
                WHERE VO.PREMISE_NO = :VO-PREMISE-NO                    
                  AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                    
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                  AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')               
                  AND ((VO.ORDER_TYPE_CD = 'FW003'                      
                  AND   VO.ORDER_RECVED_BY <> 'ECSPRD1'                 
                  AND   VI.WORK_TYPE_CD = 'LPL')                        
                   OR  (CUST_REQ_TYPE_CD = 'FW003LPL')                  
P00836             OR  (VO.ORDER_TYPE_CD = 'FW003'                      
P00836            AND   VO.ORDER_RECVED_BY <> 'ECSPRD1'                 
P00836            AND   VI.WORK_TYPE_CD = 'LNI')                        
P00836             OR  (CUST_REQ_TYPE_CD = 'FW003LNI'))                 
                ORDER BY DATE_RECVED                                    
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACTIVE-OUTDOOR CURSOR FOR                                 
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               VO.ORDER_RECVED_BY,                                       
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VO.SERV_ORDER_STATUS                                      
MFA-TR*          FROM CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_SO_DATA VO LEFT OUTER JOIN                            
MFA-TR*               CSS_SO_CUST_REQ OW ON                                     
MFA-TR*               OW.SERV_ORDER_NO = VO.SERV_ORDER_NO                       
MFA-TR*         WHERE VO.PREMISE_NO = :VO-PREMISE-NO                            
MFA-TR*           AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                            
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')                       
MFA-TR*           AND ((VO.ORDER_TYPE_CD = 'FW003'                              
MFA-TR*           AND   VO.ORDER_RECVED_BY = 'ECSPRD1'                         
MFA-TR*           AND   VI.WORK_TYPE_CD = 'LPL')                                
MFA-TR*            OR  (CUST_REQ_TYPE_CD = 'FW003LPL')                          
MFA-TR*            OR  (VO.ORDER_TYPE_CD = 'FW003'                              
MFA-TR*           AND   VO.ORDER_RECVED_BY = 'ECSPRD1'                         
MFA-TR*           AND   VI.WORK_TYPE_CD = 'LNI')                                
MFA-TR*            OR  (CUST_REQ_TYPE_CD = 'FW003LNI'))                         
MFA-TR*         ORDER BY DATE_RECVED                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ACTIVE-PILOT CURSOR FOR                           
               SELECT VO.SERV_ORDER_NO,                                 
                      VO.ORDER_RECVED_BY,                               
                      VO.ORDER_STATE_CD,                                
                      VO.SERV_ORDER_STATUS                              
                 FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO
                           WITH(READUNCOMMITTED) LEFT OUTER JOIN               
                      CSS_SO_CUST_REQ OW WITH(READUNCOMMITTED) ON               
                      OW.SERV_ORDER_NO = VO.SERV_ORDER_NO               
                WHERE VO.PREMISE_NO = :VO-PREMISE-NO                    
                  AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                    
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                  AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')               
                  AND ((VO.ORDER_TYPE_CD = 'FM008'                      
                  AND   VO.ORDER_RECVED_BY <> 'ECSPRD1'                 
                  AND   VI.WORK_TYPE_CD = 'LTP')                        
                   OR  (CUST_REQ_TYPE_CD = 'FM008LTP'))                 
                ORDER BY DATE_RECVED                                    
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACTIVE-PILOT CURSOR FOR                                   
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               VO.ORDER_RECVED_BY,                                       
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VO.SERV_ORDER_STATUS                                      
MFA-TR*          FROM CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_SO_DATA VO LEFT OUTER JOIN                            
MFA-TR*               CSS_SO_CUST_REQ OW ON                                     
MFA-TR*               OW.SERV_ORDER_NO = VO.SERV_ORDER_NO                       
MFA-TR*         WHERE VO.PREMISE_NO = :VO-PREMISE-NO                            
MFA-TR*           AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                            
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')                       
MFA-TR*           AND ((VO.ORDER_TYPE_CD = 'FM008'                              
MFA-TR*           AND   VO.ORDER_RECVED_BY = 'ECSPRD1'                         
MFA-TR*           AND   VI.WORK_TYPE_CD = 'LTP')                                
MFA-TR*            OR  (CUST_REQ_TYPE_CD = 'FM008LTP'))                         
MFA-TR*         ORDER BY DATE_RECVED                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE WEB-REQUEST CURSOR FOR                            
               SELECT COALESCE((                                        
                      SELECT CASE                                       
                            WHEN DQ.NAME_FORMAT = 'I'                   
                                THEN RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + CIS.SUBSTR3(DQ.MIDDLE_NAME,1,1)         
                            WHEN DQ.NAME_FORMAT = 'B'                   
                                THEN DQ.FULL_NAME                       
                            END                                         
                      FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),         
                           CSS_NAME DQ WITH(READUNCOMMITTED)                    
                     WHERE VO.ACCOUNT_NO = HT.ACCOUNT_NO                
                       AND VO.ACCOUNT_NO <> 0                           
                       AND HT.NAME_ID = DQ.NAME_ID                      
                       AND HT.CUSTOMER_ROLE_CD = ' '                    
                       AND DQ.NAME_TYPE = 'CN'                          
                       AND DQ.NAME_FORMAT IN ('I', 'B')),' ')           
                           AS FULL_NAME,                                
                      VI.CODE_UTIL_TYPE,                                
                      VO.ORDER_TYPE_CD,                                 
                      VI.WORK_TYPE_CD,                                  
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                             
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME,                            
                      VO.SERV_ORDER_STATUS,                             
                      VO.ORDER_STATE_CD,                                
                      VO.ACCOUNT_NO,                                    
                      VO.SERV_ORDER_NO,                                 
                      C2.ORDER_GROUP_CD,                                
                      VO.COMPANY_NO,                                    
                      (SELECT HT1.CUSTOMER_NO                           
                         FROM CSS_NAME_ACCT_XREF HT1
                           WITH(READUNCOMMITTED),                   
                              CSS_NAME DQ1 WITH(READUNCOMMITTED)                
                        WHERE HT1.NAME_ID = DQ1.NAME_ID                 
                          AND VO.ACCOUNT_NO_PRIOR = HT1.ACCOUNT_NO      
                          AND VO.ACCOUNT_NO_PRIOR <> 0                  
                          AND HT1.CUSTOMER_ROLE_CD = ' '                
                          AND DQ1.NAME_TYPE = 'CN'                      
                          AND DQ1.NAME_FORMAT IN ('I', 'B'))            
                          AS CUSTOMER_NO,                               
                      VO.ACCOUNT_NO_PRIOR,                              
                      VO.LOCAL_OFFICE,                                  
                      (SELECT DZ.ZIP_CODE                               
                         FROM CSS_PREMISE       PR
                           WITH(READUNCOMMITTED),                     
                              CSS_ADDR_FORMATTED DZ
                           WITH(READUNCOMMITTED)                     
                        WHERE PR.PREMISE_NO = :VO-PREMISE-NO            
                         AND PR.ADDRESS_ID = DZ.ADDRESS_ID)             
                         AS ZIP_CODE,                                   
                      C2.ORDER_TYPE_DESC,                               
                      L4.WORK_TYPE_DESC,                                
                      VO.ORDER_REASON,                                  
                      R6.STATUS_TX,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), VO.DATE_RECVED
           , 121), ' ', '-'), ':', '.') DATE_RECVED,                           
                      VO.ORDER_RECVED_BY,                               
                      OW.CUST_REQ_TYPE_CD,                              
                      OW.CUST_REQ_SOURCE_CD,                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), VO.BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT,                         
                      REPLACE(REPLACE(CONVERT(CHAR(26), VO.END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT,                           
                      VO.APPT_AM_PM_CD,                                 
                      VO.WORK_COMPLETED_IND                             
                 FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),               
                      CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED),                  
                      CSS_WORK_TYPE L4 WITH(READUNCOMMITTED),                   
                      CSS_WK_CLASS_STAT R6 WITH(READUNCOMMITTED),               
                      CSS_SO_DATA VO
                           WITH(READUNCOMMITTED) LEFT OUTER JOIN               
                      CSS_SO_CUST_REQ OW WITH(READUNCOMMITTED) ON               
                      OW.SERV_ORDER_NO = VO.SERV_ORDER_NO               
                WHERE VO.PREMISE_NO = :VO-PREMISE-NO                    
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                  AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO = C2.COMPANY_NO                     
                  AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                 
                  AND VO.COMPANY_NO = L4.COMPANY_NO                     
                  AND C2.WORK_CLASS_ID = R6.WORK_CLASS_ID               
                  AND VO.SERV_ORDER_STATUS = R6.SERV_ORDER_STATUS       
                  AND VI.WORK_TYPE_CD > ' '                             
                  AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                    
                  AND ((VO.ORDER_RECVED_BY <> 'ECSPRD1'                 
                  AND  VO.ORDER_TYPE_CD = 'FW003'                       
                  AND  VI.WORK_TYPE_CD = 'LRL')                         
                   OR (VO.ORDER_RECVED_BY <> 'ECSPRD1'                  
                  AND  VO.ORDER_TYPE_CD = 'FW008'                       
                  AND  VI.WORK_TYPE_CD = 'LRL')                         
                   OR (OW.CUST_REQ_TYPE_CD = 'FW003LRL')                
                   OR (OW.CUST_REQ_TYPE_CD = 'FW008LRL')                
                   OR (VO.ORDER_RECVED_BY <> 'ECSPRD1'                  
                  AND  VO.ORDER_TYPE_CD = 'FW003'                       
                  AND  VI.WORK_TYPE_CD = 'LPL')                         
                   OR (OW.CUST_REQ_TYPE_CD = 'FW003LPL')                
                   OR (VO.ORDER_RECVED_BY <> 'ECSPRD1'                  
                  AND  VO.ORDER_TYPE_CD = 'FM008'                       
                  AND  VI.WORK_TYPE_CD = 'LTP')                         
                   OR (OW.CUST_REQ_TYPE_CD = 'FM008LTP')                
P00836             OR (VO.ORDER_TYPE_CD = 'FW003'                       
P00836            AND  VO.ORDER_RECVED_BY <> 'ECSPRD1'                  
P00836            AND  VI.WORK_TYPE_CD = 'LNI')                         
P00836             OR (CUST_REQ_TYPE_CD = 'FW003LNI'))                  
                ORDER BY DATE_RECVED DESC                               
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ053
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WEB-REQUEST CURSOR FOR                                    
MFA-TR*        SELECT COALESCE((                                                
MFA-TR*               SELECT CASE                                               
MFA-TR*                     WHEN DQ.NAME_FORMAT = 'I'                           
MFA-TR*                         THEN RTRIM(DQ.LAST_NAME) || ', ' ||             
MFA-TR*                              RTRIM(DQ.FIRST_NAME) || ' ' ||             
MFA-TR*                              SUBSTR(DQ.MIDDLE_NAME,1,1)                 
MFA-TR*                     WHEN DQ.NAME_FORMAT = 'B'                           
MFA-TR*                         THEN DQ.FULL_NAME                               
MFA-TR*                     END                                                 
MFA-TR*               FROM CSS_NAME_ACCT_XREF HT,                               
MFA-TR*                    CSS_NAME DQ                                          
MFA-TR*              WHERE VO.ACCOUNT_NO = HT.ACCOUNT_NO                        
MFA-TR*                AND VO.ACCOUNT_NO = 0                                   
MFA-TR*                AND HT.NAME_ID = DQ.NAME_ID                              
MFA-TR*                AND HT.CUSTOMER_ROLE_CD = ' '                            
MFA-TR*                AND DQ.NAME_TYPE = 'CN'                                  
MFA-TR*                AND DQ.NAME_FORMAT IN ('I', 'B')),' ')                   
MFA-TR*                    AS FULL_NAME,                                        
MFA-TR*               VI.CODE_UTIL_TYPE,                                        
MFA-TR*               VO.ORDER_TYPE_CD,                                         
MFA-TR*               VI.WORK_TYPE_CD,                                          
MFA-TR*               VO.ASSIGNED_DATETIME,                                     
MFA-TR*               VO.COMPLETED_DATETIME,                                    
MFA-TR*               VO.SERV_ORDER_STATUS,                                     
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VO.ACCOUNT_NO,                                            
MFA-TR*               VO.SERV_ORDER_NO,                                         
MFA-TR*               C2.ORDER_GROUP_CD,                                        
MFA-TR*               VO.COMPANY_NO,                                            
MFA-TR*               (SELECT HT1.CUSTOMER_NO                                   
MFA-TR*                  FROM CSS_NAME_ACCT_XREF HT1,                           
MFA-TR*                       CSS_NAME DQ1                                      
MFA-TR*                 WHERE HT1.NAME_ID = DQ1.NAME_ID                         
MFA-TR*                   AND VO.ACCOUNT_NO_PRIOR = HT1.ACCOUNT_NO              
MFA-TR*                   AND VO.ACCOUNT_NO_PRIOR <> 0                          
MFA-TR*                   AND HT1.CUSTOMER_ROLE_CD = ' '                        
MFA-TR*                   AND DQ1.NAME_TYPE = 'CN'                              
MFA-TR*                   AND DQ1.NAME_FORMAT IN ('I', 'B'))                    
MFA-TR*                   AS CUSTOMER_NO,                                       
MFA-TR*               VO.ACCOUNT_NO_PRIOR,                                      
MFA-TR*               VO.LOCAL_OFFICE,                                          
MFA-TR*               (SELECT DZ.ZIP_CODE                                       
MFA-TR*                  FROM CSS_PREMISE       PR,                             
MFA-TR*                       CSS_ADDR_FORMATTED DZ                             
MFA-TR*                 WHERE PR.PREMISE_NO = :VO-PREMISE-NO                    
MFA-TR*                  AND PR.ADDRESS_ID = DZ.ADDRESS_ID)                     
MFA-TR*                  AS ZIP_CODE,                                           
MFA-TR*               C2.ORDER_TYPE_DESC,                                       
MFA-TR*               L4.WORK_TYPE_DESC,                                        
MFA-TR*               VO.ORDER_REASON,                                          
MFA-TR*               R6.STATUS_TX,                                             
MFA-TR*               VO.DATE_RECVED,                                           
MFA-TR*               VO.ORDER_RECVED_BY,                                       
MFA-TR*               OW.CUST_REQ_TYPE_CD,                                      
MFA-TR*               OW.CUST_REQ_SOURCE_CD,                                    
MFA-TR*               VO.BEGIN_APPT_DT,                                         
MFA-TR*               VO.END_APPT_DT,                                           
MFA-TR*               VO.APPT_AM_PM_CD,                                         
MFA-TR*               VO.WORK_COMPLETED_IND                                     
MFA-TR*          FROM CSS_SO_ORDER_INST VI,                                     
MFA-TR*               CSS_ORDER_TYPE C2,                                        
MFA-TR*               CSS_WORK_TYPE L4,                                         
MFA-TR*               CSS_WK_CLASS_STAT R6,                                     
MFA-TR*               CSS_SO_DATA VO LEFT OUTER JOIN                            
MFA-TR*               CSS_SO_CUST_REQ OW ON                                     
MFA-TR*               OW.SERV_ORDER_NO = VO.SERV_ORDER_NO                       
MFA-TR*         WHERE VO.PREMISE_NO = :VO-PREMISE-NO                            
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO = C2.COMPANY_NO                             
MFA-TR*           AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                         
MFA-TR*           AND VO.COMPANY_NO = L4.COMPANY_NO                             
MFA-TR*           AND C2.WORK_CLASS_ID = R6.WORK_CLASS_ID                       
MFA-TR*           AND VO.SERV_ORDER_STATUS = R6.SERV_ORDER_STATUS               
MFA-TR*           AND VI.WORK_TYPE_CD > ' '                                     
MFA-TR*           AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                            
MFA-TR*           AND ((VO.ORDER_RECVED_BY = 'ECSPRD1'                         
MFA-TR*           AND  VO.ORDER_TYPE_CD = 'FW003'                               
MFA-TR*           AND  VI.WORK_TYPE_CD = 'LRL')                                 
MFA-TR*            OR (VO.ORDER_RECVED_BY = 'ECSPRD1'                          
MFA-TR*           AND  VO.ORDER_TYPE_CD = 'FW008'                               
MFA-TR*           AND  VI.WORK_TYPE_CD = 'LRL')                                 
MFA-TR*            OR (OW.CUST_REQ_TYPE_CD = 'FW003LRL')                        
MFA-TR*            OR (OW.CUST_REQ_TYPE_CD = 'FW008LRL')                        
MFA-TR*            OR (VO.ORDER_RECVED_BY = 'ECSPRD1'                          
MFA-TR*           AND  VO.ORDER_TYPE_CD = 'FW003'                               
MFA-TR*           AND  VI.WORK_TYPE_CD = 'LPL')                                 
MFA-TR*            OR (OW.CUST_REQ_TYPE_CD = 'FW003LPL')                        
MFA-TR*            OR (VO.ORDER_RECVED_BY = 'ECSPRD1'                          
MFA-TR*           AND  VO.ORDER_TYPE_CD = 'FM008'                               
MFA-TR*           AND  VI.WORK_TYPE_CD = 'LTP')                                 
MFA-TR*            OR (OW.CUST_REQ_TYPE_CD = 'FM008LTP')                        
MFA-TR*            OR (VO.ORDER_TYPE_CD = 'FW003'                               
MFA-TR*           AND  VO.ORDER_RECVED_BY = 'ECSPRD1'                          
MFA-TR*           AND  VI.WORK_TYPE_CD = 'LNI')                                 
MFA-TR*            OR (CUST_REQ_TYPE_CD = 'FW003LNI'))                          
MFA-TR*         ORDER BY DATE_RECVED DESC                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE IVR-EXISTS CURSOR FOR                             
               SELECT VO.SERV_ORDER_NO,                                 
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME                              
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE VO.PREMISE_NO = :VO-PREMISE-NO                    
                  AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                    
                  AND VO.ORDER_TYPE_CD = 'FW003'                        
                  AND VI.WORK_TYPE_CD = 'LRL'                           
                  AND VO.ORDER_STATE_CD = 'A'                           
                  AND VI.CODE_UTIL_TYPE = 'E'                           
                  AND VO.COMPLETED_DATETIME IS NULL                     
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                ORDER BY DATE_RECVED                                    
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE IVR-EXISTS CURSOR FOR                                     
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               VO.ASSIGNED_DATETIME                                      
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE VO.PREMISE_NO = :VO-PREMISE-NO                            
MFA-TR*           AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                            
MFA-TR*           AND VO.ORDER_TYPE_CD = 'FW003'                                
MFA-TR*           AND VI.WORK_TYPE_CD = 'LRL'                                   
MFA-TR*           AND VO.ORDER_STATE_CD = 'A'                                   
MFA-TR*           AND VI.CODE_UTIL_TYPE = 'E'                                   
MFA-TR*           AND VO.COMPLETED_DATETIME IS NULL                             
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*         ORDER BY DATE_RECVED                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE      AS RETURN_CODE,                  
                      WEBORDERNO       AS WEB_ORDER_NO,                 
                      WEBFLAG          AS WEB_FLAG,                     
                      EDITFLAG         AS EDIT_FLAG,                    
                      NONPRODFLAG      AS NON_PROD_FLAG                 
                FROM #CSR04277_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE      AS RETURN_CODE,                          
MFA-TR*               WEBORDERNO       AS WEB_ORDER_NO,                         
MFA-TR*               WEBFLAG          AS WEB_FLAG,                             
MFA-TR*               EDITFLAG         AS EDIT_FLAG,                            
MFA-TR*               NONPRODFLAG      AS NON_PROD_FLAG                         
MFA-TR*         FROM SESSION.CSR04277_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT FULL_NAME           AS FULL_NAME,                 
                      CODE_UTIL_TYPE      AS CODE_UTIL_TYPE,            
                      ORDER_TYPE_CD       AS ORDER_TYPE_CD,             
                      WORK_TYPE_CD        AS WORK_TYPE_CD,              
                      ASSIGNED_DATETIME   AS ASSIGNED_DATETIME,         
                      COMPLETED_DATETIME  AS COMPLETED_DATETIME,        
                      SERV_ORDER_STATUS   AS SERV_ORDER_STATUS,         
                      ORDER_STATE_CD      AS ORDER_STATE_CD,            
                      ACCOUNT_NO          AS ACCOUNT_NO,                
                      SERV_ORDER_NO       AS SERV_ORDER_NO,             
                      ORDER_GROUP_CD      AS ORDER_GROUP_CD,            
                      COMPANY_NO          AS COMPANY_NO,                
                      CUSTOMER_NO         AS CUSTOMER_NO,               
                      ACCOUNT_NO_PRIOR    AS ACCOUNT_NO_PRIOR,          
                      LOCAL_OFFICE        AS LOCAL_OFFICE,              
                      ZIP_CODE            AS ZIP_CODE,                  
                      HISTORY_FLAG        AS HISTORY_FLAG,              
                      ORDER_TYPE_DESC     AS ORDER_TYPE_DESC,           
                      WORK_TYPE_DESC      AS WORK_TYPE_DESC,            
                      ORDER_REASON        AS ORDER_REASON,              
                      STATUS_TX           AS STATUS_TX,                 
                      DATE_RECVED         AS DATE_RECVED,               
                      ORDER_RECVED_BY     AS ORDER_RECVED_BY,           
                      CUST_REQ_TYPE_CD    AS CUST_REQ_TYPE_CD,          
                      CUST_REQ_SOURCE_CD  AS CUST_REQ_SOURCE_CD,        
                      BEGIN_APPT_DT       AS BEGIN_APPT_DT,             
                      END_APPT_DT         AS END_APPT_DT,               
                      APPT_AM_PM_CD       AS APPT_AM_PM_CD,             
                      WORK_COMPLETED_IND  AS WORK_COMPLETED_IND,        
                      RETURN_CODE         AS RETURN_CODE,               
                      DISPLAYSERVICETYPE  AS DISPLAY_SERVICETYPE,       
                      DISPLAYSTATUS       AS DISPLAY_STATUS,            
                      DISPLAYCOMMENTS     AS DISPLAY_COMMENTS,          
                      DISPLAYBUTTON       AS DISPLAY_BUTTON,            
                      DISPLAYCREATEDDATE  AS DISPLAY_CREATE_DATE,       
                      DISPLAYCOMPLETEDATE AS DISPLAY_COMPLETE_DATE,     
                      DISPLAYBEGAPPTDATE  AS DISPLAY_BEG_APPT_DATE,     
                      DISPLAYENDAPPTDATE  AS DISPLAY_END_APPT_DATE,     
                      DISPLAYAPPTAMPMCD   AS DISPLAY_APPT_AM_PM_CD      
                FROM #CSR04277_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT FULL_NAME           AS FULL_NAME,                         
MFA-TR*               CODE_UTIL_TYPE      AS CODE_UTIL_TYPE,                    
MFA-TR*               ORDER_TYPE_CD       AS ORDER_TYPE_CD,                     
MFA-TR*               WORK_TYPE_CD        AS WORK_TYPE_CD,                      
MFA-TR*               ASSIGNED_DATETIME   AS ASSIGNED_DATETIME,                 
MFA-TR*               COMPLETED_DATETIME  AS COMPLETED_DATETIME,                
MFA-TR*               SERV_ORDER_STATUS   AS SERV_ORDER_STATUS,                 
MFA-TR*               ORDER_STATE_CD      AS ORDER_STATE_CD,                    
MFA-TR*               ACCOUNT_NO          AS ACCOUNT_NO,                        
MFA-TR*               SERV_ORDER_NO       AS SERV_ORDER_NO,                     
MFA-TR*               ORDER_GROUP_CD      AS ORDER_GROUP_CD,                    
MFA-TR*               COMPANY_NO          AS COMPANY_NO,                        
MFA-TR*               CUSTOMER_NO         AS CUSTOMER_NO,                       
MFA-TR*               ACCOUNT_NO_PRIOR    AS ACCOUNT_NO_PRIOR,                  
MFA-TR*               LOCAL_OFFICE        AS LOCAL_OFFICE,                      
MFA-TR*               ZIP_CODE            AS ZIP_CODE,                          
MFA-TR*               HISTORY_FLAG        AS HISTORY_FLAG,                      
MFA-TR*               ORDER_TYPE_DESC     AS ORDER_TYPE_DESC,                   
MFA-TR*               WORK_TYPE_DESC      AS WORK_TYPE_DESC,                    
MFA-TR*               ORDER_REASON        AS ORDER_REASON,                      
MFA-TR*               STATUS_TX           AS STATUS_TX,                         
MFA-TR*               DATE_RECVED         AS DATE_RECVED,                       
MFA-TR*               ORDER_RECVED_BY     AS ORDER_RECVED_BY,                   
MFA-TR*               CUST_REQ_TYPE_CD    AS CUST_REQ_TYPE_CD,                  
MFA-TR*               CUST_REQ_SOURCE_CD  AS CUST_REQ_SOURCE_CD,                
MFA-TR*               BEGIN_APPT_DT       AS BEGIN_APPT_DT,                     
MFA-TR*               END_APPT_DT         AS END_APPT_DT,                       
MFA-TR*               APPT_AM_PM_CD       AS APPT_AM_PM_CD,                     
MFA-TR*               WORK_COMPLETED_IND  AS WORK_COMPLETED_IND,                
MFA-TR*               RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               DISPLAYSERVICETYPE  AS DISPLAY_SERVICETYPE,               
MFA-TR*               DISPLAYSTATUS       AS DISPLAY_STATUS,                    
MFA-TR*               DISPLAYCOMMENTS     AS DISPLAY_COMMENTS,                  
MFA-TR*               DISPLAYBUTTON       AS DISPLAY_BUTTON,                    
MFA-TR*               DISPLAYCREATEDDATE  AS DISPLAY_CREATE_DATE,               
MFA-TR*               DISPLAYCOMPLETEDATE AS DISPLAY_COMPLETE_DATE,             
MFA-TR*               DISPLAYBEGAPPTDATE  AS DISPLAY_BEG_APPT_DATE,             
MFA-TR*               DISPLAYENDAPPTDATE  AS DISPLAY_END_APPT_DATE,             
MFA-TR*               DISPLAYAPPTAMPMCD   AS DISPLAY_APPT_AM_PM_CD              
MFA-TR*         FROM SESSION.CSR04277_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE     AS RETURN_CODE,                   
                      SERVORDERNO     AS SERV_ORDER_NO,                 
                      EXISTSFLAG      AS EXISTS_FLAG,                   
                      ASSIGNDATETIME  AS ASSIGN_DATETIME,               
                      SOAGE           AS SO_AGE                         
                FROM #CSR04277_R3                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE     AS RETURN_CODE,                           
MFA-TR*               SERVORDERNO     AS SERV_ORDER_NO,                         
MFA-TR*               EXISTSFLAG      AS EXISTS_FLAG,                           
MFA-TR*               ASSIGNDATETIME  AS ASSIGN_DATETIME,                       
MFA-TR*               SOAGE           AS SO_AGE                                 
MFA-TR*         FROM SESSION.CSR04277_R3                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-HISTORY-FLAG       PIC X(01).                           
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-ORDER-ACTION       PIC X(15).                           
       01  LINK-REQUEST-METHOD     PIC X(15).                           
       01  LINK-SOURCE-SYSTEM      PIC X(07).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-PREMISE-NO                               
                          LINK-HISTORY-FLAG                             
                          LINK-ACCOUNT-NO                               
                          LINK-ORDER-ACTION                             
                          LINK-REQUEST-METHOD                           
                          LINK-SOURCE-SYSTEM.                           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INSPECT LINK-ORDER-ACTION                                    
                   CONVERTING 'abcdefghijklmnopqrstuvwxyz'              
                           TO 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.             
           INSPECT LINK-REQUEST-METHOD                                  
                   CONVERTING 'abcdefghijklmnopqrstuvwxyz'              
                           TO 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'.             
                                                                        
           EVALUATE LINK-SOURCE-SYSTEM                                  
               WHEN 'WEB'                                               
                   EVALUATE LINK-REQUEST-METHOD                         
                       WHEN 'ACTIVEORDER'                               
                           EVALUATE LINK-ORDER-ACTION                   
                               WHEN 'STREETLIGHTOUT'                    
                                   MOVE '1' TO WS-PROCESS-FLOW          
                               WHEN 'OUTDOORLIGHTING'                   
                                   MOVE '2' TO WS-PROCESS-FLOW          
                               WHEN 'LIGHTPILOT'                        
                                   MOVE '3' TO WS-PROCESS-FLOW          
                           END-EVALUATE                                 
                       WHEN 'REQUESTORDER'                              
                           MOVE '4' TO WS-PROCESS-FLOW                  
                   END-EVALUATE                                         
               WHEN 'IVR'                                               
                   MOVE '5' TO WS-PROCESS-FLOW                          
           END-EVALUATE.                                                
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           IF WEB-ACTIVE-STREET OR                                      
              WEB-ACTIVE-OUTDOOR OR                                     
              WEB-ACTIVE-PILOT                                          
                  PERFORM 0100B-DECLARE-GTT THRU 0100B-EXIT
           END-IF.            
           IF WEB-REQUEST                                               
               PERFORM 0100C-DECLARE-GTT THRU 0100C-EXIT
           END-IF.               
           IF IVR-EXISTS                                                
               PERFORM 0100D-DECLARE-GTT THRU 0100D-EXIT
           END-IF.               
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       0100B-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04277_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04277_R1
              (                                                          
               RETURN_CODE          INT,                            
               WEBORDERNO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2,            
               WEBFLAG CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2,                
               EDITFLAG CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2,               
               NONPRODFLAG CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04277_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
       0100C-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04277_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04277_R2
              (                                                          
               FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2,             
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ORDER_TYPE_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ASSIGNED_DATETIME CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               COMPLETED_DATETIME CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               SERV_ORDER_STATUS CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ORDER_STATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ACCOUNT_NO           DECIMAL(13,0),                      
               SERV_ORDER_NO        DECIMAL(13,0),                      
               ORDER_GROUP_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               CUSTOMER_NO          DECIMAL(10,0),                      
               ACCOUNT_NO_PRIOR     DECIMAL(13,0),                      
               LOCAL_OFFICE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,              
               HISTORY_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ORDER_TYPE_DESC CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               WORK_TYPE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ORDER_REASON CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,          
               STATUS_TX CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,             
               DATE_RECVED CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ORDER_RECVED_BY CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CUST_REQ_TYPE_CD CHAR(08)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CUST_REQ_SOURCE_CD CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               BEGIN_APPT_DT CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,         
               END_APPT_DT CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,           
               APPT_AM_PM_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               WORK_COMPLETED_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               RETURN_CODE          INT,                            
               DISPLAYSERVICETYPE CHAR(25)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DISPLAYSTATUS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
               DISPLAYCOMMENTS CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DISPLAYBUTTON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               DISPLAYCREATEDDATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DISPLAYCOMPLETEDATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DISPLAYBEGAPPTDATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DISPLAYENDAPPTDATE CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DISPLAYAPPTAMPMCD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04277_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
       0100C-EXIT.                                                      
           EXIT.                                                        
                                                                        
       0100D-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04277_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04277_R3
              (                                                          
               RETURN_CODE          INT,                            
               SERVORDERNO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2,           
               EXISTSFLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
               ASSIGNDATETIME CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,        
               SOAGE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2                  
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04277_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
                                                                        
       0100D-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO VO-PREMISE-NO.                     
           MOVE WS-ACCOUNT-NO-NUM TO VO-ACCOUNT-NO.                     
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
               WHEN WEB-ACTIVE-STREET                                   
               WHEN WEB-ACTIVE-OUTDOOR                                  
               WHEN WEB-ACTIVE-PILOT                                    
               WHEN WEB-REQUEST                                         
                   PERFORM 2100-WEB-SOURCE THRU 2100-EXIT               
               WHEN IVR-EXISTS                                          
                   PERFORM 2600-IVR-SOURCE THRU 2600-EXIT               
           END-EVALUATE.                                                
                                                                        
           IF CTR-ROWS = 0                                              
              EVALUATE TRUE                                             
                 WHEN WEB-ACTIVE-STREET                                 
                 WHEN WEB-ACTIVE-OUTDOOR                                
                 WHEN WEB-ACTIVE-PILOT                                  
                     INITIALIZE GTT-RETURN-FIELDS-1                     
                     MOVE +100 TO S-RETURN-CODE-1                       
                     PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT          
                 WHEN WEB-REQUEST                                       
                     INITIALIZE GTT-RETURN-FIELDS-2                     
                     MOVE +100 TO S-RETURN-CODE-2                       
                     PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT          
                 WHEN IVR-EXISTS                                        
                     INITIALIZE GTT-RETURN-FIELDS-3                     
                     MOVE +100 TO S-RETURN-CODE-3                       
                     PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT          
              END-EVALUATE
           END-IF.                                             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-WEB-SOURCE.                                                 
                                                                        
           EVALUATE TRUE                                                
               WHEN WEB-ACTIVE-STREET                                   
                   PERFORM 2200-ACTIVE-STREET THRU 2200-EXIT            
               WHEN WEB-ACTIVE-OUTDOOR                                  
                   PERFORM 2300-ACTIVE-OUTDOOR THRU 2300-EXIT           
               WHEN WEB-ACTIVE-PILOT                                    
                   PERFORM 2400-ACTIVE-PILOT THRU 2400-EXIT             
               WHEN WEB-REQUEST                                         
                   PERFORM 2500-WEB-REQUEST THRU 2500-EXIT              
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-ACTIVE-STREET.                                              
                                                                        
           PERFORM 7000-OPEN-ACTIVE-STREET THRU 7000-EXIT.              
           PERFORM 7001-FETCH-ACTIVE-STREET THRU 7001-EXIT.             
           PERFORM 2210-AS-ROW THRU 2210-EXIT                           
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
           PERFORM 7002-CLOSE-ACTIVE-STREET THRU 7002-EXIT.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-AS-ROW.                                                     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1,                              
           MOVE 0 TO S-RETURN-CODE-1.                                   
           MOVE WS-SERV-ORDER-NO-CHAR TO S-WEBORDERNO.                  
           IF VO-SERV-ORDER-STATUS < '20' AND                           
              VO-ORDER-RECVED-BY = 'ECSPRD1'                            
                  MOVE 'Y' TO S-WEBFLAG                                 
                              S-EDITFLAG
           END-IF.                               
                                                                        
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           PERFORM 7001-FETCH-ACTIVE-STREET THRU 7001-EXIT.             
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-ACTIVE-OUTDOOR.                                             
                                                                        
           PERFORM 7010-OPEN-ACTIVE-OUTDOOR THRU 7010-EXIT.             
           PERFORM 7011-FETCH-ACTIVE-OUTDOOR THRU 7011-EXIT.            
           PERFORM 2310-AO-ROW THRU 2310-EXIT                           
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
           PERFORM 7012-CLOSE-ACTIVE-OUTDOOR THRU 7012-EXIT.            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-AO-ROW.                                                     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1,                              
           MOVE 0 TO S-RETURN-CODE-1.                                   
           MOVE WS-SERV-ORDER-NO-CHAR TO S-WEBORDERNO.                  
           IF VO-SERV-ORDER-STATUS < '20' AND                           
              VO-ORDER-RECVED-BY = 'ECSPRD1'                            
                  MOVE 'Y' TO S-WEBFLAG                                 
                              S-EDITFLAG
           END-IF.                               
                                                                        
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           PERFORM 7011-FETCH-ACTIVE-OUTDOOR THRU 7011-EXIT.            
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-ACTIVE-PILOT.                                               
                                                                        
           PERFORM 7100-SELECT-NONPROD THRU 7100-EXIT.                  
                                                                        
           PERFORM 7020-OPEN-ACTIVE-PILOT THRU 7020-EXIT.               
           PERFORM 7021-FETCH-ACTIVE-PILOT THRU 7021-EXIT.              
           PERFORM 2410-AP-ROW THRU 2410-EXIT                           
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
           PERFORM 7022-CLOSE-ACTIVE-PILOT THRU 7022-EXIT.              
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2410-AP-ROW.                                                     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1,                              
           MOVE 0 TO S-RETURN-CODE-1.                                   
           MOVE WS-SERV-ORDER-NO-CHAR TO S-WEBORDERNO.                  
           IF VO-SERV-ORDER-STATUS < '20' AND                           
              VO-ORDER-RECVED-BY = 'ECSPRD1'                            
                  MOVE 'Y' TO S-WEBFLAG                                 
                              S-EDITFLAG                                
                  MOVE WS-WORK-COMPLETED-IND TO S-NONPRODFLAG
           END-IF.          
                                                                        
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
           PERFORM 7021-FETCH-ACTIVE-PILOT THRU 7021-EXIT.              
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-WEB-REQUEST.                                                
                                                                        
           PERFORM 7030-OPEN-WEB-REQUEST THRU 7030-EXIT.                
           PERFORM 7031-FETCH-WEB-REQUEST THRU 7031-EXIT.               
           PERFORM 2510-WR-ROW THRU 2510-EXIT                           
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                 
           PERFORM 7032-CLOSE-WEB-REQUEST THRU 7032-EXIT.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2510-WR-ROW.                                                     
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           MOVE DQ-FULL-NAME TO S-FULL-NAME.                            
           MOVE VI-CODE-UTIL-TYPE TO S-CODE-UTIL-TYPE.                  
           MOVE VO-ORDER-TYPE-CD TO S-ORDER-TYPE-CD.                    
           MOVE VI-WORK-TYPE-CD TO S-WORK-TYPE-CD.                      
           MOVE VO-ASSIGNED-DATETIME TO S-ASSIGNED-DATETIME.            
           MOVE VO-COMPLETED-DATETIME TO S-COMPLETED-DATETIME.          
           MOVE VO-SERV-ORDER-STATUS TO S-SERV-ORDER-STATUS.            
           MOVE VO-ORDER-STATE-CD TO S-ORDER-STATE-CD.                  
           MOVE VO-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE VO-SERV-ORDER-NO TO S-SERV-ORDER-NO.                    
           MOVE C2-ORDER-GROUP-CD TO S-ORDER-GROUP-CD.                  
           MOVE VO-COMPANY-NO TO S-COMPANY-NO.                          
           MOVE HT-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           MOVE VO-ACCOUNT-NO-PRIOR TO S-ACCOUNT-NO-PRIOR.              
           MOVE VO-LOCAL-OFFICE TO S-LOCAL-OFFICE.                      
           MOVE DY-ZIP-CODE TO S-ZIP-CODE.                              
           MOVE LINK-HISTORY-FLAG TO S-HISTORY-FLAG.                    
           MOVE C2-ORDER-TYPE-DESC TO S-ORDER-TYPE-DESC.                
           MOVE L4-WORK-TYPE-DESC TO S-WORK-TYPE-DESC.                  
           MOVE VO-ORDER-REASON TO S-ORDER-REASON.                      
           MOVE R6-STATUS-TX TO S-STATUS-TX.                            
           MOVE VO-DATE-RECVED TO S-DATE-RECVED.                        
           MOVE VO-ORDER-RECVED-BY TO S-ORDER-RECVED-BY.                
           MOVE OW-CUST-REQ-TYPE-CD TO S-CUST-REQ-TYPE-CD.              
           MOVE OW-CUST-REQ-SOURCE-CD TO S-CUST-REQ-SOURCE-CD.          
           MOVE VO-BEGIN-APPT-DT TO S-BEGIN-APPT-DT.                    
           MOVE VO-END-APPT-DT TO S-END-APPT-DT.                        
           MOVE VO-APPT-AM-PM-CD TO S-APPT-AM-PM-CD.                    
           MOVE VO-WORK-COMPLETED-IND TO S-WORK-COMPLETED-IND.          
           MOVE 0 TO S-RETURN-CODE-2.                                   
           MOVE VO-DATE-RECVED TO S-CREATEDDATE.                        
           MOVE VO-COMPLETED-DATETIME TO S-COMPLETEDATE.                
           EVALUATE VO-ORDER-STATE-CD                                   
               WHEN 'Z'                                                 
                   MOVE 'COMPLETE' TO S-STATUS                          
               WHEN 'C'                                                 
                   MOVE 'CANCELLED' TO S-STATUS                         
               WHEN OTHER                                               
                   MOVE 'ACTIVE' TO S-STATUS                            
           END-EVALUATE.                                                
           MOVE VO-BEGIN-APPT-DT TO S-BEGAPPTDATE.                      
           MOVE VO-END-APPT-DT TO S-ENDAPPTDATE.                        
           MOVE VO-APPT-AM-PM-CD TO S-APPTAMPMCD.                       
           MOVE SPACES TO S-COMMENTS.                                   
           MOVE 'N' TO S-BUTTON.                                        
           IF VO-SERV-ORDER-STATUS < '20' AND                           
              VO-ORDER-RECVED-BY = 'ECSPRD1' AND                        
              VO-ORDER-STATE-CD = 'A' OR 'H' OR 'D' OR                  
                                  'Q' OR 'B' OR 'R'                     
                  MOVE 'Y' TO S-BUTTON
           END-IF.                                 
           MOVE 'UNKNOWN' TO S-SERVICETYPE.                             
           IF OW-CUST-REQ-TYPE-CD = 'FW003LRL' OR 'FW008LRL'            
               MOVE 'REPORTED STREETLIGHT OUT' TO S-SERVICETYPE
           END-IF.        
P00836     IF OW-CUST-REQ-TYPE-CD = 'FW003LPL' OR 'FW003LNI'            
               MOVE 'REQUESTED OUTDOOR LIGHT' TO S-SERVICETYPE
           END-IF.         
           IF OW-CUST-REQ-TYPE-CD = 'FW008LTP'                          
               MOVE 'PILOT LIGHTING' TO S-SERVICETYPE
           END-IF.                  
           IF S-SERVICETYPE = 'UNKNOWN'                                 
               IF (VO-ORDER-TYPE-CD = 'FW003' AND                       
                   VI-WORK-TYPE-CD = 'LRL') OR                          
                  (VO-ORDER-TYPE-CD = 'FW008' AND                       
                   VI-WORK-TYPE-CD = 'LRL')                             
                      MOVE 'REPORTED STREETLIGHT OUT' TO S-SERVICETYPE  
               END-IF                                                   
               IF (VO-ORDER-TYPE-CD = 'FW003' AND                       
P00836            (VI-WORK-TYPE-CD = 'LPL' OR 'LNI'))                   
                      MOVE 'REQUESTED OUTDOOR LIGHT' TO S-SERVICETYPE   
               END-IF                                                   
               IF (VO-ORDER-TYPE-CD = 'FM008' AND                       
                   VI-WORK-TYPE-CD = 'LTP')                             
                      MOVE 'PILOT LIGHTING' TO S-SERVICETYPE
               END-IF
           END-IF.           
                                                                        
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
           PERFORM 7031-FETCH-WEB-REQUEST THRU 7031-EXIT.               
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-IVR-SOURCE.                                                 
                                                                        
           EVALUATE LINK-REQUEST-METHOD                                 
               WHEN 'ORDEREXISTS'                                       
                   PERFORM 7050-OPEN-IVR-EXISTS THRU 7050-EXIT          
                   PERFORM 7051-FETCH-IVR-EXISTS THRU 7051-EXIT         
                   PERFORM 2610-IVR-EXISTS THRU 2610-EXIT               
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
                   PERFORM 7052-CLOSE-IVR-EXISTS THRU 7052-EXIT         
           END-EVALUATE.                                                
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2610-IVR-EXISTS.                                                 
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3,                              
           MOVE 0 TO S-RETURN-CODE-3.                                   
           MOVE WS-SERV-ORDER-NO-CHAR TO S-SERVORDERNO.                 
           MOVE 'Y' TO S-EXISTSFLAG.                                    
           MOVE VO-ASSIGNED-DATETIME TO S-ASSIGNDATETIME.               
                                                                        
           EXEC SQL                                                     
               SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :VO-ASSIGNED-DATETIME
              ) IS NULL OR (PATINDEX('%.%', :VO-ASSIGNED-DATETIME
              ) <> 0) OR (LEN(:VO-ASSIGNED-DATETIME
              ) <> 10), CIS.CHAR2DATE(:VO-ASSIGNED-DATETIME
              ), CONVERT(DATE, :VO-ASSIGNED-DATETIME) )) -               
                       CIS.DAYS( IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DAYS-COUNT                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES DAYS(DATE(:VO-ASSIGNED-DATETIME)) -                       
MFA-TR*                DAYS(:WS-CURRENT-DATE)                                   
MFA-TR*          INTO :WS-DAYS-COUNT                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-DAYS-COUNT TO WS-DAYS-COUNT-NUM.                     
           MOVE WS-DAYS-COUNT-CHAR TO S-SOAGE.                          
                                                                        
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
           PERFORM 7051-FETCH-IVR-EXISTS THRU 7051-EXIT.                
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-OPEN-ACTIVE-STREET.                                         
                                                                        
           EXEC SQL                                                     
               OPEN ACTIVE-STREET                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7001-FETCH-ACTIVE-STREET.                                        
                                                                        
           EXEC SQL                                                     
               FETCH ACTIVE-STREET                                      
                INTO :VO-SERV-ORDER-NO,                                 
                     :VO-ORDER-RECVED-BY,                               
                     :VO-ORDER-STATE-CD,                                
                     :VO-SERV-ORDER-STATUS                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7002-CLOSE-ACTIVE-STREET.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE ACTIVE-STREET                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-ACTIVE-OUTDOOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN ACTIVE-OUTDOOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7011-FETCH-ACTIVE-OUTDOOR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH ACTIVE-OUTDOOR                                     
                INTO :VO-SERV-ORDER-NO,                                 
                     :VO-ORDER-RECVED-BY,                               
                     :VO-ORDER-STATE-CD,                                
                     :VO-SERV-ORDER-STATUS                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7011'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7012-CLOSE-ACTIVE-OUTDOOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE ACTIVE-OUTDOOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7012'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7012-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-OPEN-ACTIVE-PILOT.                                          
                                                                        
           EXEC SQL                                                     
               OPEN ACTIVE-PILOT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7021-FETCH-ACTIVE-PILOT.                                         
                                                                        
           EXEC SQL                                                     
               FETCH ACTIVE-PILOT                                       
                INTO :VO-SERV-ORDER-NO,                                 
                     :VO-ORDER-RECVED-BY,                               
                     :VO-ORDER-STATE-CD,                                
                     :VO-SERV-ORDER-STATUS                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7021'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7021-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7022-CLOSE-ACTIVE-PILOT.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE ACTIVE-PILOT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7012'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7022-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-OPEN-WEB-REQUEST.                                           
                                                                        
           EXEC SQL                                                     
               OPEN WEB-REQUEST                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7030'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7031-FETCH-WEB-REQUEST.                                          
                                                                        
           EXEC SQL                                                     
               FETCH WEB-REQUEST                                        
                INTO :DQ-FULL-NAME,                                     
                     :VI-CODE-UTIL-TYPE,                                
                     :VO-ORDER-TYPE-CD,                                 
                     :VI-WORK-TYPE-CD,                                  
                     :VO-ASSIGNED-DATETIME :WS-NULL-1,                   
                     :VO-COMPLETED-DATETIME :WS-NULL-2,                  
                     :VO-SERV-ORDER-STATUS,                             
                     :VO-ORDER-STATE-CD,                                
                     :VO-ACCOUNT-NO,                                    
                     :VO-SERV-ORDER-NO,                                 
                     :C2-ORDER-GROUP-CD,                                
                     :VO-COMPANY-NO,                                    
                     :HT-CUSTOMER-NO,                                   
                     :VO-ACCOUNT-NO-PRIOR,                              
                     :VO-LOCAL-OFFICE,                                  
                     :DY-ZIP-CODE,                                      
                     :C2-ORDER-TYPE-DESC,                               
                     :L4-WORK-TYPE-DESC,                                
                     :VO-ORDER-REASON,                                  
                     :R6-STATUS-TX,                                     
                     :VO-DATE-RECVED,                                   
                     :VO-ORDER-RECVED-BY,                               
                     :OW-CUST-REQ-TYPE-CD :WS-NULL-5,                    
                     :OW-CUST-REQ-SOURCE-CD :WS-NULL-6,                  
                     :VO-BEGIN-APPT-DT :WS-NULL-3,                       
                     :VO-END-APPT-DT :WS-NULL-4,                         
                     :VO-APPT-AM-PM-CD,                                 
                     :VO-WORK-COMPLETED-IND                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO VO-ASSIGNED-DATETIME              
                   END-IF                                               
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO VO-COMPLETED-DATETIME             
                   END-IF                                               
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO VO-BEGIN-APPT-DT                  
                   END-IF                                               
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO VO-END-APPT-DT                    
                   END-IF                                               
                   IF WS-NULL-5 < 0                                     
                       MOVE SPACES TO OW-CUST-REQ-TYPE-CD               
                   END-IF                                               
                   IF WS-NULL-6 < 0                                     
                       MOVE SPACES TO OW-CUST-REQ-SOURCE-CD             
                   END-IF                                               
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7031'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7031-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7032-CLOSE-WEB-REQUEST.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE WEB-REQUEST                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7032'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7032-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-OPEN-IVR-EXISTS.                                            
                                                                        
           EXEC SQL                                                     
               OPEN IVR-EXISTS                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7050'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7051-FETCH-IVR-EXISTS.                                           
                                                                        
           EXEC SQL                                                     
               FETCH IVR-EXISTS                                         
                INTO :VO-SERV-ORDER-NO,                                 
                     :VO-ASSIGNED-DATETIME :WS-NULL-1                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO VO-ASSIGNED-DATETIME              
                   END-IF                                               
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7051'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7051-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7052-CLOSE-IVR-EXISTS.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE IVR-EXISTS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7052'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2        
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7052-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-NONPROD.                                             
                                                                        
           MOVE 'N' TO WS-WORK-COMPLETED-IND.                           
           EXEC SQL                                                     
              SELECT TOP(1) WORK_COMPLETED_IND                                 
                INTO :WS-WORK-COMPLETED-IND                             
                FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED),                
                     CSS_SO_DATA VO
                           WITH(READUNCOMMITTED) LEFT OUTER JOIN               
                     CSS_SO_CUST_REQ OW WITH(READUNCOMMITTED) ON                
                     OW.SERV_ORDER_NO = VO.SERV_ORDER_NO                
                WHERE VO.PREMISE_NO = :VO-PREMISE-NO                    
                  AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                    
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
                  AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')               
                  AND ((VO.ORDER_TYPE_CD = 'FM008'                      
                  AND   VO.ORDER_RECVED_BY <> 'ECSPRD1'                 
                  AND   VI.WORK_TYPE_CD = 'LTP')                        
                   OR  (CUST_REQ_TYPE_CD = 'FM008LTP'))                 
                  AND WORK_COMPLETED_IND = 'Y'                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WORK_COMPLETED_IND                                         
MFA-TR*         INTO :WS-WORK-COMPLETED-IND                                     
MFA-TR*         FROM CSS_SO_ORDER_INST VI,                                      
MFA-TR*              CSS_SO_DATA VO LEFT OUTER JOIN                             
MFA-TR*              CSS_SO_CUST_REQ OW ON                                      
MFA-TR*              OW.SERV_ORDER_NO = VO.SERV_ORDER_NO                        
MFA-TR*         WHERE VO.PREMISE_NO = :VO-PREMISE-NO                            
MFA-TR*           AND VO.ACCOUNT_NO = :VO-ACCOUNT-NO                            
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')                       
MFA-TR*           AND ((VO.ORDER_TYPE_CD = 'FM008'                              
MFA-TR*           AND   VO.ORDER_RECVED_BY = 'ECSPRD1'                         
MFA-TR*           AND   VI.WORK_TYPE_CD = 'LTP')                                
MFA-TR*            OR  (CUST_REQ_TYPE_CD = 'FM008LTP'))                         
MFA-TR*           AND WORK_COMPLETED_IND = 'Y'                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-WORK-COMPLETED-IND                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'DATABASE'       TO TABLE-ELEMENT-1             
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04277_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04277_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8000A'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04277_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04277_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04277_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8000A'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04277_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04277_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04277_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8000A'          TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04277_R3'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04277_R1                            
             (                                                          
              RETURN_CODE,                                              
              WEBORDERNO,                                               
              WEBFLAG,                                                  
              EDITFLAG,                                                 
              NONPRODFLAG                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-WEBORDERNO,                                           
               :S-WEBFLAG,                                              
               :S-EDITFLAG,                                             
               :S-NONPRODFLAG                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04277_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       WEBORDERNO,                                                       
MFA-TR*       WEBFLAG,                                                          
MFA-TR*       EDITFLAG,                                                         
MFA-TR*       NONPRODFLAG                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-WEBORDERNO,                                                   
MFA-TR*        :S-WEBFLAG,                                                      
MFA-TR*        :S-EDITFLAG,                                                     
MFA-TR*        :S-NONPRODFLAG                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04277_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04277_R2                            
             (                                                          
              FULL_NAME,                                                
              CODE_UTIL_TYPE,                                           
              ORDER_TYPE_CD,                                            
              WORK_TYPE_CD,                                             
              ASSIGNED_DATETIME,                                        
              COMPLETED_DATETIME,                                       
              SERV_ORDER_STATUS,                                        
              ORDER_STATE_CD,                                           
              ACCOUNT_NO,                                               
              SERV_ORDER_NO,                                            
              ORDER_GROUP_CD,                                           
              COMPANY_NO,                                               
              CUSTOMER_NO,                                              
              ACCOUNT_NO_PRIOR,                                         
              LOCAL_OFFICE,                                             
              ZIP_CODE,                                                 
              HISTORY_FLAG,                                             
              ORDER_TYPE_DESC,                                          
              WORK_TYPE_DESC,                                           
              ORDER_REASON,                                             
              STATUS_TX,                                                
              DATE_RECVED,                                              
              ORDER_RECVED_BY,                                          
              CUST_REQ_TYPE_CD,                                         
              CUST_REQ_SOURCE_CD,                                       
              BEGIN_APPT_DT,                                            
              END_APPT_DT,                                              
              APPT_AM_PM_CD,                                            
              WORK_COMPLETED_IND,                                       
              RETURN_CODE,                                              
              DISPLAYSERVICETYPE,                                       
              DISPLAYSTATUS,                                            
              DISPLAYCOMMENTS,                                          
              DISPLAYBUTTON,                                            
              DISPLAYCREATEDDATE,                                       
              DISPLAYCOMPLETEDATE,                                      
              DISPLAYBEGAPPTDATE,                                       
              DISPLAYENDAPPTDATE,                                       
              DISPLAYAPPTAMPMCD                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-FULL-NAME,                                            
               :S-CODE-UTIL-TYPE,                                       
               :S-ORDER-TYPE-CD,                                        
               :S-WORK-TYPE-CD,                                         
               :S-ASSIGNED-DATETIME,                                    
               :S-COMPLETED-DATETIME,                                   
               :S-SERV-ORDER-STATUS,                                    
               :S-ORDER-STATE-CD,                                       
               :S-ACCOUNT-NO,                                           
               :S-SERV-ORDER-NO,                                        
               :S-ORDER-GROUP-CD,                                       
               :S-COMPANY-NO,                                           
               :S-CUSTOMER-NO,                                          
               :S-ACCOUNT-NO-PRIOR,                                     
               :S-LOCAL-OFFICE,                                         
               :S-ZIP-CODE,                                             
               :S-HISTORY-FLAG,                                         
               :S-ORDER-TYPE-DESC,                                      
               :S-WORK-TYPE-DESC,                                       
               :S-ORDER-REASON,                                         
               :S-STATUS-TX,                                            
               :S-DATE-RECVED,                                          
               :S-ORDER-RECVED-BY,                                      
               :S-CUST-REQ-TYPE-CD,                                     
               :S-CUST-REQ-SOURCE-CD,                                   
               :S-BEGIN-APPT-DT,                                        
               :S-END-APPT-DT,                                          
               :S-APPT-AM-PM-CD,                                        
               :S-WORK-COMPLETED-IND,                                   
               :S-RETURN-CODE-2,                                        
               :S-SERVICETYPE,                                          
               :S-STATUS,                                               
               :S-COMMENTS,                                             
               :S-BUTTON,                                               
               :S-CREATEDDATE,                                          
               :S-COMPLETEDATE,                                         
               :S-BEGAPPTDATE,                                          
               :S-ENDAPPTDATE,                                          
               :S-APPTAMPMCD                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04277_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       FULL_NAME,                                                        
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       ORDER_TYPE_CD,                                                    
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       ASSIGNED_DATETIME,                                                
MFA-TR*       COMPLETED_DATETIME,                                               
MFA-TR*       SERV_ORDER_STATUS,                                                
MFA-TR*       ORDER_STATE_CD,                                                   
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       ORDER_GROUP_CD,                                                   
MFA-TR*       COMPANY_NO,                                                       
MFA-TR*       CUSTOMER_NO,                                                      
MFA-TR*       ACCOUNT_NO_PRIOR,                                                 
MFA-TR*       LOCAL_OFFICE,                                                     
MFA-TR*       ZIP_CODE,                                                         
MFA-TR*       HISTORY_FLAG,                                                     
MFA-TR*       ORDER_TYPE_DESC,                                                  
MFA-TR*       WORK_TYPE_DESC,                                                   
MFA-TR*       ORDER_REASON,                                                     
MFA-TR*       STATUS_TX,                                                        
MFA-TR*       DATE_RECVED,                                                      
MFA-TR*       ORDER_RECVED_BY,                                                  
MFA-TR*       CUST_REQ_TYPE_CD,                                                 
MFA-TR*       CUST_REQ_SOURCE_CD,                                               
MFA-TR*       BEGIN_APPT_DT,                                                    
MFA-TR*       END_APPT_DT,                                                      
MFA-TR*       APPT_AM_PM_CD,                                                    
MFA-TR*       WORK_COMPLETED_IND,                                               
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       DISPLAYSERVICETYPE,                                               
MFA-TR*       DISPLAYSTATUS,                                                    
MFA-TR*       DISPLAYCOMMENTS,                                                  
MFA-TR*       DISPLAYBUTTON,                                                    
MFA-TR*       DISPLAYCREATEDDATE,                                               
MFA-TR*       DISPLAYCOMPLETEDATE,                                              
MFA-TR*       DISPLAYBEGAPPTDATE,                                               
MFA-TR*       DISPLAYENDAPPTDATE,                                               
MFA-TR*       DISPLAYAPPTAMPMCD                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-FULL-NAME,                                                    
MFA-TR*        :S-CODE-UTIL-TYPE,                                               
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-WORK-TYPE-CD,                                                 
MFA-TR*        :S-ASSIGNED-DATETIME,                                            
MFA-TR*        :S-COMPLETED-DATETIME,                                           
MFA-TR*        :S-SERV-ORDER-STATUS,                                            
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-SERV-ORDER-NO,                                                
MFA-TR*        :S-ORDER-GROUP-CD,                                               
MFA-TR*        :S-COMPANY-NO,                                                   
MFA-TR*        :S-CUSTOMER-NO,                                                  
MFA-TR*        :S-ACCOUNT-NO-PRIOR,                                             
MFA-TR*        :S-LOCAL-OFFICE,                                                 
MFA-TR*        :S-ZIP-CODE,                                                     
MFA-TR*        :S-HISTORY-FLAG,                                                 
MFA-TR*        :S-ORDER-TYPE-DESC,                                              
MFA-TR*        :S-WORK-TYPE-DESC,                                               
MFA-TR*        :S-ORDER-REASON,                                                 
MFA-TR*        :S-STATUS-TX,                                                    
MFA-TR*        :S-DATE-RECVED,                                                  
MFA-TR*        :S-ORDER-RECVED-BY,                                              
MFA-TR*        :S-CUST-REQ-TYPE-CD,                                             
MFA-TR*        :S-CUST-REQ-SOURCE-CD,                                           
MFA-TR*        :S-BEGIN-APPT-DT,                                                
MFA-TR*        :S-END-APPT-DT,                                                  
MFA-TR*        :S-APPT-AM-PM-CD,                                                
MFA-TR*        :S-WORK-COMPLETED-IND,                                           
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-SERVICETYPE,                                                  
MFA-TR*        :S-STATUS,                                                       
MFA-TR*        :S-COMMENTS,                                                     
MFA-TR*        :S-BUTTON,                                                       
MFA-TR*        :S-CREATEDDATE,                                                  
MFA-TR*        :S-COMPLETEDATE,                                                 
MFA-TR*        :S-BEGAPPTDATE,                                                  
MFA-TR*        :S-ENDAPPTDATE,                                                  
MFA-TR*        :S-APPTAMPMCD                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04277_R2'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04277_R3                            
             (                                                          
              RETURN_CODE,                                              
              SERVORDERNO,                                              
              EXISTSFLAG,                                               
              ASSIGNDATETIME,                                           
              SOAGE                                                     
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-SERVORDERNO,                                          
               :S-EXISTSFLAG,                                           
               :S-ASSIGNDATETIME,                                       
               :S-SOAGE                                                 
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04277_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERVORDERNO,                                                      
MFA-TR*       EXISTSFLAG,                                                       
MFA-TR*       ASSIGNDATETIME,                                                   
MFA-TR*       SOAGE                                                             
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-SERVORDERNO,                                                  
MFA-TR*        :S-EXISTSFLAG,                                                   
MFA-TR*        :S-ASSIGNDATETIME,                                               
MFA-TR*        :S-SOAGE                                                         
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04277_R3'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EVALUATE TRUE                                                
             WHEN WEB-ACTIVE-STREET                                     
             WHEN WEB-ACTIVE-OUTDOOR                                    
             WHEN WEB-ACTIVE-PILOT                                      
                 EXEC SQL                                               
                     OPEN C1                                            
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
             WHEN WEB-REQUEST                                           
                 EXEC SQL                                               
                     OPEN C2                                            
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
             WHEN IVR-EXISTS                                            
                 EXEC SQL                                               
                     OPEN C3                                            
                 END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                               
           END-EVALUATE.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION
           END-IF.                
                                                                        
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
           EVALUATE TRUE                                                
             WHEN WEB-ACTIVE-STREET                                     
             WHEN WEB-ACTIVE-OUTDOOR                                    
             WHEN WEB-ACTIVE-PILOT                                      
                 PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT              
             WHEN WEB-REQUEST                                           
                 PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT              
             WHEN IVR-EXISTS                                            
                 PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT              
           END-EVALUATE.                                                
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
