       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04262.                                       
       AUTHOR.          SATISH S.                                       
COB303 DATE-WRITTEN. MAR 19, 2009.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04262              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04262 :                                                --         
      *--                                                            --         
      *--  #  INSERTS FACTOR TO CIS TABLES.                          --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--      IN                                                    --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            IC_NO                 CHAR(04)                  --         
      *--            FACTOR_ID             CHAR(09)                  --         
      *--            APPL_PGMID            CHAR(08)                  --         
      *--            FACTOR                CHAR(13)                  --         
      *--            DURATION_REMAIN_NO    CHAR(04)                  --         
      *--      OUT                                                   --         
      *--            RETURN_CODE           CHAR(09)                  --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--            1                                               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  03/19/2009    SS95855     PROGRAM INTIALLY WRITTEN.       --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04262'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR (FF)                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR (DF)                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCTRG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT (UT)                                                
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR (SF)                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL (SA)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_WINDOW (BN)                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM (G6)                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MNT_TRANS_HIST (MH)                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_MT_TRN_HST_DET (MI)                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR CPD00065                        *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWS00065                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01 WS-LITERALS.                                                  
          05  MCSCB065                    PIC X(08) VALUE 'MCSCB065'.   
          05  WS-N                        PIC X(01) VALUE 'N'.          
          05  GTT-NAME                    PIC X(26) VALUE               
                                               'SESSION.CSR04262_R1'.   
          05  PROGRAM-NAME                PIC X(08) VALUE 'CSR04262'.   
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE                 PIC X(05) VALUE SPACES.       
           05 WS-ACCOUNT-NO               PIC 9(13) VALUE ZEROES.       
           05 WS-IC-NO                    PIC 9(04) VALUE ZEROES.       
           05 WS-IC-NO-JST                PIC X(04) JUSTIFIED RIGHT.    
           05 WS-FACTOR                   PIC 9(13) VALUE ZEROES.       
           05 WS-FACTOR-RED     REDEFINES                               
                                WS-FACTOR PIC 999999999V9999.           
           05 WS-DURATION-REMAIN-NO       PIC 9(04) VALUE ZEROES.       
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW                 PIC X(01) VALUE 'N'.          
              88 NOT-ALL-DONE                 VALUE 'N'.                
              88 ALL-DONE                     VALUE 'Y'.                
           05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.          
              88 SEND-DONE-ERROR              VALUE 'N'.                
              88 SEND-DONE-OK                 VALUE 'Y'.                
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN            PIC S9(04) COMP.              
                49 GTT-ROW-CHAR           PIC X(1024).                  
            05  GTT-SQLCODE               PIC S9(9) COMP.               
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP   VALUE 1.     
           05  CTR-ROWS                   PIC S9(9) COMP   VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM            PIC S9(9) COMP.               
           05  WRKLEN1                    PIC S9(9) COMP.               
           05  WRKLEN2                    PIC S9(9) COMP.               
           05  WRK-DONE-STATUS            PIC S9(9) COMP.               
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE              PIC S9(09) COMP VALUE 0.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(09) COMP VALUE 0.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                 PIC X(18) VALUE SPACES.       
            10  S-SQLCODE                 PIC S9(9) COMP  VALUE 0.      
            10  S-SQLSTATE                PIC X(5)  VALUE ' '.          
            10  S-TABLE-NAME              PIC X(18) VALUE SPACES.       
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.         
                49  S-HOST-VARIABLES-V    PIC X(255).                   
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.         
                49  S-SQL-STATEMENT-V     PIC X(255).                   
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.         
                49  S-SQL-DESCRIPTION-V   PIC X(255).                   
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ACCOUNT-NO             PIC X(13).                        
       01 PARM-CODE-UTIL-TYPE         PIC X(01).                        
       01 PARM-IC-NO                  PIC X(04).                        
       01 PARM-FACTOR-ID              PIC X(09).                        
       01 PARM-APPL-PGMID             PIC X(08).                        
       01 PARM-FACTOR                 PIC X(13).                        
       01 PARM-DURATION-REMAIN-NO     PIC X(04).                        
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-FACTOR-ID                         
                                 PARM-APPL-PGMID                        
                                 PARM-FACTOR                            
                                 PARM-DURATION-REMAIN-NO.               
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE        THRU 0100-EXIT.               
           PERFORM 1000-PROCESS-INPUT     THRU 1000-EXIT.               
           PERFORM 6000-CREATE-FACTOR     THRU 6000-EXIT.               
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100-INITIALIZE'         TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                WHENEVER SQLWARNING                                     
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER SQLERROR                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER NOT FOUND                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                 SELECT :S-RETURN-CODE         AS RETURN_CODE           
                   FROM CIS.SYSDUMMY1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT :S-RETURN-CODE         AS RETURN_CODE                   
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE LS-CPD65-CALLING-FIELDS.                          
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO               TO WS-CPD65-ACCOUNT-NO.     
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CPD65-CODE-UTIL-TYPE. 
                                                                        
           UNSTRING PARM-IC-NO DELIMITED BY ' '                         
                                    INTO WS-IC-NO-JST.                  
           MOVE WS-IC-NO-JST                TO WS-IC-NO.                
           MOVE WS-IC-NO                    TO WS-CPD65-IC-NO.          
                                                                        
           MOVE PARM-FACTOR-ID              TO WS-CPD65-FACTOR-ID.      
                                                                        
           MOVE PARM-FACTOR                 TO WS-FACTOR.               
           MOVE WS-FACTOR-RED               TO WS-CPD65-FACTOR.         
                                                                        
           MOVE PARM-APPL-PGMID             TO WS-CPD65-CALLING-PGM.    
                                                                        
           MOVE PARM-DURATION-REMAIN-NO     TO WS-DURATION-REMAIN-NO.   
           MOVE WS-DURATION-REMAIN-NO       TO WS-CPD65-DUR-REMAIN-NO.  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 6000-CREATE-FACTOR.                                            *        
      ******************************************************************        
       6000-CREATE-FACTOR.                                              
                                                                        
           CALL MCSCB065 USING CPD00065-FIELDS,                         
                               ABEND-FILE.                              
                                                                        
           MOVE WS-CPD65-RETURN-CODE          TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL ZEROES                        
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
              ADD +1                    TO CTR-ROWS.                    
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
