       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04261.                                      
COB303 DATE-WRITTEN. MARCH 24, 2009.                                    
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04261              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04261 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES RATE PLAN DETAILS BASED ON THE INPUT PARMS   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            RATE_PLAN_NO          CHAR(03)                  --         
      *--            COMPANY_NO            CHAR(02)                  --         
      *--            USER_ID               CHAR(08)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            RETURN_CODE           CHAR(09)                  --         
      *--            RATE_PLAN_NO          CHAR(03)                  --         
      *--            RATE_DESC             CHAR(103)                 --         
      *--            COMPANY_NO            CHAR(02)                  --         
      *--            SECURED_RATE_FL       CHAR(01)                  --         
      *--            SUM_REVENUE_FL        CHAR(01)                  --         
      *--            CODE_STATUS           CHAR(01)                  --         
      *--            REG_GROUP_CD          CHAR(03)                  --         
      *--            RATE_ACCESS_FLAG      CHAR(01)                  --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     MULTIPLE                                               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
I00397*--  03/24/2009    VY95550     PROGRAM INTIALLY WRITTEN.       --         
I00397*--  03/25/2009    JC91900     SECURED RATE CHANGES.           --         
A37342*--  07/07/2009    SJ97149     1.ADD ROWSET POSITIONING IN THE --         
A37342*--                            CURSOR TO IMPROVE THE PERFORMANCE-         
A37342*--                            2. ADDED "WITH UR" TO SQL       --         
A37342*--                            STATEMENTS                      --         
A04527*--  11/29/2013    SS7F226     DELETED THE RATE PLANS FOR SEB  --         
A04527*--                            BY REMOVING THE CODE RELATED TO --         
A04527*--                            CSR01218                        --         
ACT006*--  01/13/2017    TP7R341     REPLACE CSS NAVIGATION          --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04261'.
MSQ017     COPY MFASQLM.
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_RATE_SECUR_CAT, RI                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTSEC                                                
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_RATE_PLAN_DESC, RD                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTDESC                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_RATE_CREATOR, RT                                          *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBRTCRTR                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_CATEGORY, F5                                              *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBCAT                                                  
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_DELINQUENCY, C8                                           *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      *    SQL ERROR CHECKING COPYBOOK.                                         
      *****************************************************************         
           COPY CWS00303.                                                       
                                                                        
      *****************************************************************         
      *    ERROR HANDLING COPY BOOK.                                            
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04261'.       
           05 GTT-NAME                PIC X(26)                         
                                            VALUE 'SESSION.CSR04261_R1'.
                                                                        
       01  WS-MISC.                                                     
           05 WS-CONSRVTION-RATE      PIC X(01) VALUE SPACE.            
           05 WS-RATE-ACCESS-FLAG     PIC X(01) VALUE SPACE.            
           05 WS-CONS-ACCESS-FLAG     PIC X(01) VALUE SPACE.            
           05 WS-SECD-ACCESS-FLAG     PIC X(01) VALUE SPACE.            
           05 WS-RATE-TYPE            PIC X(01) VALUE SPACE.            
           05 WS-RATE-DESC            PIC X(130) VALUE SPACE.           
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE                   VALUE 'N'.              
              88 ALL-DONE                       VALUE 'Y'.              
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR                VALUE 'N'.              
              88 SEND-DONE-OK                   VALUE 'Y'.              
           05 WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.              
              88 NO-MORE-ROWS                   VALUE 'Y'.              
           05 WS-DATABASE             PIC 9(01) VALUE ZERO.             
              88 CSR-DATABASE                   VALUE 1.                
              88 SEB-DATABASE                   VALUE 2.                
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC X(09) VALUE SPACES.          
           05  S-RATE-PLAN-NO          PIC X(03) VALUE SPACES.          
           05  S-RATE-DESC             PIC X(103) VALUE SPACES.         
           05  S-COMPANY-NO            PIC X(02) VALUE SPACES.          
           05  S-SECURED-RATE-FL       PIC X(01) VALUE SPACES.          
           05  S-SUM-REVENUE-FL        PIC X(01) VALUE SPACES.          
           05  S-CODE-STATUS           PIC X(01) VALUE SPACES.          
           05  S-REG-GROUP-CD          PIC X(03) VALUE SPACES.          
           05  S-RATE-ACCESS-FLAG      PIC X(01) VALUE SPACES.          
           05  S-RATE-TYPE             PIC X(01) VALUE SPACES.          
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *****************************************************************         
      *  CURSOR DECLARATIONS.                                         *         
      *****************************************************************         
           EXEC SQL                                                     
            DECLARE RATE_DESC_CUR CURSOR FOR                            
             SELECT RD.RATE_PLAN_NO,                                    
                    RD.RATE_PLAN_NO + ' - ' + RD.RATE_DESC + 
           REPLICATE(' ', 47) AS RATE_DESC, 
                    RD.COMPANY_NO,                                      
                    RD.SECURED_RATE_FL,                                 
                    RD.SUM_REVENUE_FL,                                  
                    RT.CODE_STATUS,                                     
                    RD.REG_GROUP_CD                                     
               FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
                   ,CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                   
              WHERE RD.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE               
                AND RD.RATE_PLAN_NO   = RT.RATE_PLAN_NO                 
                AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE              
                AND RD.COMPANY_NO     = :RD-COMPANY-NO                  
                AND (    (RD.DISPLAY_START_TS <= CIS.CURRENT$TIMESTAMP()      
                      AND RD.DISPLAY_END_TS   >= 
           CIS.CURRENT$TIMESTAMP())     
                       OR RD.RATE_PLAN_NO = :RD-RATE-PLAN-NO)           
                AND RT.VERSION_NO_CNTRL =                               
                   (SELECT MAX(IRT.VERSION_NO_CNTRL)                    
                      FROM CSS_RATE_CREATOR IRT WITH(READUNCOMMITTED)           
                     WHERE IRT.RATE_PLAN_NO    = RT.RATE_PLAN_NO        
                       AND IRT.CODE_STATUS     <> 'T'                   
                       AND IRT.CODE_UTIL_TYPE  = RT.CODE_UTIL_TYPE)     
              ORDER BY RD.RATE_PLAN_NO                                  
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE RATE_DESC_CUR CURSOR FOR                                    
MFA-TR*      SELECT RD.RATE_PLAN_NO,                                            
MFA-TR*             CHAR(RD.RATE_PLAN_NO CONCAT ' - '                           
MFA-TR*             CONCAT RD.RATE_DESC CONCAT SPACE(47)) AS RATE_DESC,         
MFA-TR*             RD.COMPANY_NO,                                              
MFA-TR*             RD.SECURED_RATE_FL,                                         
MFA-TR*             RD.SUM_REVENUE_FL,                                          
MFA-TR*             RT.CODE_STATUS,                                             
MFA-TR*             RD.REG_GROUP_CD                                             
MFA-TR*        FROM CSS_RATE_PLAN_DESC RD                                       
MFA-TR*            ,CSS_RATE_CREATOR RT                                         
MFA-TR*       WHERE RD.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE                       
MFA-TR*         AND RD.RATE_PLAN_NO   = RT.RATE_PLAN_NO                         
MFA-TR*         AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                      
MFA-TR*         AND RD.COMPANY_NO     = :RD-COMPANY-NO                          
MFA-TR*         AND (    (RD.DISPLAY_START_TS <= CURRENT TIMESTAMP              
MFA-TR*               AND RD.DISPLAY_END_TS   >= CURRENT TIMESTAMP)             
MFA-TR*                OR RD.RATE_PLAN_NO = :RD-RATE-PLAN-NO)                   
MFA-TR*         AND RT.VERSION_NO_CNTRL =                                       
MFA-TR*            (SELECT MAX(IRT.VERSION_NO_CNTRL)                            
MFA-TR*               FROM CSS_RATE_CREATOR IRT                                 
MFA-TR*              WHERE IRT.RATE_PLAN_NO    = RT.RATE_PLAN_NO                
MFA-TR*                AND IRT.CODE_STATUS     <> 'T'                           
MFA-TR*                AND IRT.CODE_UTIL_TYPE  = RT.CODE_UTIL_TYPE)             
MFA-TR*       ORDER BY RD.RATE_PLAN_NO                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
            DECLARE RATE_DESC_SEB CURSOR FOR                            
              SELECT RD.RATE_PLAN_NO                                    
                    , RD.RATE_PLAN_NO + ' - ' + RD.RATE_DESC + 
           REPLICATE(' ', 47) AS RATE_DESC 
                    ,RD.COMPANY_NO                                      
                    ,RD.SECURED_RATE_FL                                 
                    ,RD.SUM_REVENUE_FL                                  
                    ,RT.CODE_STATUS                                     
                    ,RD.REG_GROUP_CD                                    
                FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
                    ,CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
               WHERE RD.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE              
                 AND RD.RATE_PLAN_NO   = RT.RATE_PLAN_NO                
                 AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE             
                 AND RD.COMPANY_NO     = :RD-COMPANY-NO                 
                 AND RD.DISPLAY_START_TS <= CIS.CURRENT$TIMESTAMP()           
                 AND RD.DISPLAY_END_TS    >= CIS.CURRENT$TIMESTAMP()          
                 AND RT.VERSION_NO_CNTRL =                              
                    (SELECT MAX(IRT.VERSION_NO_CNTRL)                   
                      FROM CSS_RATE_CREATOR IRT WITH(READUNCOMMITTED)           
                     WHERE IRT.RATE_PLAN_NO    = RT.RATE_PLAN_NO        
                       AND IRT.CODE_UTIL_TYPE  = RT.CODE_UTIL_TYPE)     
             ORDER BY RATE_PLAN_NO                                      
A37342       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE RATE_DESC_SEB CURSOR FOR                                    
MFA-TR*       SELECT RD.RATE_PLAN_NO                                            
MFA-TR*             , CHAR(RD.RATE_PLAN_NO CONCAT ' - '                         
MFA-TR*              CONCAT RD.RATE_DESC CONCAT SPACE(47)) AS RATE_DESC         
MFA-TR*             ,RD.COMPANY_NO                                              
MFA-TR*             ,RD.SECURED_RATE_FL                                         
MFA-TR*             ,RD.SUM_REVENUE_FL                                          
MFA-TR*             ,RT.CODE_STATUS                                             
MFA-TR*             ,RD.REG_GROUP_CD                                            
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*             ,CSS_RATE_CREATOR RT                                        
MFA-TR*        WHERE RD.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE                      
MFA-TR*          AND RD.RATE_PLAN_NO   = RT.RATE_PLAN_NO                        
MFA-TR*          AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                     
MFA-TR*          AND RD.COMPANY_NO     = :RD-COMPANY-NO                         
MFA-TR*          AND RD.DISPLAY_START_TS <= CURRENT TIMESTAMP                   
MFA-TR*          AND RD.DISPLAY_END_TS    >= CURRENT TIMESTAMP                  
MFA-TR*          AND RT.VERSION_NO_CNTRL =                                      
MFA-TR*             (SELECT MAX(IRT.VERSION_NO_CNTRL)                           
MFA-TR*               FROM CSS_RATE_CREATOR IRT                                 
MFA-TR*              WHERE IRT.RATE_PLAN_NO    = RT.RATE_PLAN_NO                
MFA-TR*                AND IRT.CODE_UTIL_TYPE  = RT.CODE_UTIL_TYPE)             
MFA-TR*      ORDER BY RATE_PLAN_NO                                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-CODE-UTIL-TYPE          PIC X(01).                       
       01 PARM-RATE-PLAN-NO            PIC X(03).                       
       01 PARM-COMPANY-NO              PIC X(02).                       
       01 PARM-USER-ID                 PIC X(08).                       
                                                                        
       PROCEDURE DIVISION  USING                                        
                           PARM-CODE-UTIL-TYPE                          
                           PARM-RATE-PLAN-NO                            
                           PARM-COMPANY-NO                              
                           PARM-USER-ID.                                
                                                                        
      *****************************************************************         
      *                                                                         
      * 0000-MAINLINE.                                                          
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 0100-INITIALIZE                                                         
      *****************************************************************         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
A37342                          WITH ROWSET POSITIONING FOR             
                 SELECT RETURN_CODE                                     
                       ,RATE_PLAN_NO                                    
                       ,RATE_DESC                                       
                       ,COMPANY_NO                                      
                       ,SECURED_RATE_FL                                 
                       ,SUM_REVENUE_FL                                  
                       ,CODE_STATUS                                     
                       ,REG_GROUP_CD                                    
                       ,RATE_ACCESS_FLAG                                
                       ,RATE_TYPE                                       
                 FROM #CSR04261_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*          SELECT RETURN_CODE                                             
MFA-TR*                ,RATE_PLAN_NO                                            
MFA-TR*                ,RATE_DESC                                               
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,SECURED_RATE_FL                                         
MFA-TR*                ,SUM_REVENUE_FL                                          
MFA-TR*                ,CODE_STATUS                                             
MFA-TR*                ,REG_GROUP_CD                                            
MFA-TR*                ,RATE_ACCESS_FLAG                                        
MFA-TR*                ,RATE_TYPE                                               
MFA-TR*          FROM SESSION.CSR04261_R1                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      *0100A-DECLARE-GTT                                                        
      *****************************************************************         
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04261_R1'            
                                                TO S-SQL-STATEMENT-V.   
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04261_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04261_R1
              (                                                       
                   RETURN_CODE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,RATE_DESC CHAR(103)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,SECURED_RATE_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,SUM_REVENUE_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,CODE_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,REG_GROUP_CD CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,RATE_ACCESS_FLAG CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
                  ,RATE_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                    )
           END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
             PERFORM 8000A-DELETE-GTT-ROWS     THRU 8000A-EXIT          
             MOVE ZEROES                     TO WS-ACTIVE-RETURN-CODE   
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '0100A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'DECLARE'                 TO ABEND-FUNCTION          
              MOVE 'CSR04261_R1'             TO TABLE-1                 
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-INPUT.                                           *         
      *****************************************************************         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CODE-UTIL-TYPE          TO RD-CODE-UTIL-TYPE       
           MOVE PARM-RATE-PLAN-NO            TO RD-RATE-PLAN-NO         
           MOVE PARM-COMPANY-NO              TO RD-COMPANY-NO           
           MOVE PARM-USER-ID                 TO F5-USER-ID.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000-PROCESS-OUTPUT.                                          *         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 'N'                          TO WS-NO-MORE-ROWS         
           MOVE '01'                         TO C8-COMPANY-NO           
           MOVE 'DATABASE'                   TO C8-DELINQ-CD            
           PERFORM 7350-SELECT-DELINQNCY        THRU 7350-EXIT          
           MOVE C8-DELINQ-VALUE              TO WS-DATABASE             
           IF CSR-DATABASE                                              
              PERFORM 7200-OPEN-RATE-DESC-CUR   THRU 7200-EXIT          
              PERFORM 7210-FETCH-RATE-DESC-CUR  THRU 7210-EXIT          
              PERFORM 2100-PROCESS-RATE-PLANS   THRU 2100-EXIT          
                                                UNTIL NO-MORE-ROWS      
              PERFORM 7220-CLOSE-RATE-DESC-CUR  THRU 7220-EXIT          
           ELSE                                                         
              PERFORM 7250-OPEN-RATE-SEB-CUR    THRU 7250-EXIT          
              PERFORM 7260-FETCH-RATE-SEB-CUR   THRU 7260-EXIT          
              PERFORM 2100-PROCESS-RATE-PLANS   THRU 2100-EXIT          
                                                UNTIL NO-MORE-ROWS      
              PERFORM 7270-CLOSE-RATE-SEB-CUR   THRU 7270-EXIT          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE 0                           TO S-RETURN-CODE           
            MOVE RD-RATE-PLAN-NO             TO S-RATE-PLAN-NO          
            MOVE WS-RATE-DESC                TO S-RATE-DESC             
            MOVE RD-COMPANY-NO               TO S-COMPANY-NO            
            MOVE RD-SECURED-RATE-FL          TO S-SECURED-RATE-FL       
            MOVE RD-SUM-REVENUE-FL           TO S-SUM-REVENUE-FL        
            MOVE RT-CODE-STATUS              TO S-CODE-STATUS           
            MOVE RD-REG-GROUP-CD             TO S-REG-GROUP-CD          
            MOVE WS-RATE-ACCESS-FLAG         TO S-RATE-ACCESS-FLAG      
            MOVE WS-RATE-TYPE                TO S-RATE-TYPE.            
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2100-PROCESS-RATE-PLANS.                                      *         
      *****************************************************************         
       2100-PROCESS-RATE-PLANS.                                         
                                                                        
           MOVE 'N'                          TO WS-CONS-ACCESS-FLAG     
           MOVE 'Y'                          TO WS-RATE-ACCESS-FLAG     
           MOVE SPACES                       TO WS-RATE-TYPE            
                                                                        
           MOVE RD-COMPANY-NO                TO RI-COMPANY-NO           
           MOVE RD-CODE-UTIL-TYPE            TO RI-CODE-UTIL-TYPE       
           MOVE RD-RATE-PLAN-NO              TO RI-RATE-PLAN-NO         
                                                                        
           MOVE 'N'                          TO WS-CONSRVTION-RATE.     
           PERFORM 7290-CHECK-CONSRVTION-RATE   THRU 7290-EXIT          
           IF WS-CONSRVTION-RATE EQUAL 'Y'                              
              MOVE 'C'                       TO WS-RATE-TYPE            
              PERFORM 7300-SET-RATE-ACCESS-FLAG THRU 7300-EXIT          
              IF WS-CONS-ACCESS-FLAG EQUAL 'N'                          
                 MOVE 'N'                    TO WS-RATE-ACCESS-FLAG     
                 IF RD-SECURED-RATE-FL EQUAL 'Y'                        
                    MOVE 'N'                 TO WS-SECD-ACCESS-FLAG     
                    PERFORM 7400-CHECK-SEC-RATE-ACCESS                  
                                                THRU 7400-EXIT          
                    IF WS-SECD-ACCESS-FLAG EQUAL 'Y'                    
                       MOVE 'Y'              TO WS-RATE-ACCESS-FLAG     
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT          
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT           
                                                                        
           IF CSR-DATABASE                                              
              PERFORM 7210-FETCH-RATE-DESC-CUR THRU 7210-EXIT           
           ELSE                                                         
              PERFORM 7260-FETCH-RATE-SEB-CUR THRU 7260-EXIT            
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7200-OPEN-RATE-DESC-CUR.                                      *         
      *****************************************************************         
       7200-OPEN-RATE-DESC-CUR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN RATE_DESC_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE RD-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RD-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7210-FETCH-RATE-DESC-CUR.                                     *         
      *****************************************************************         
       7210-FETCH-RATE-DESC-CUR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH RATE_DESC_CUR                                      
                INTO :RD-RATE-PLAN-NO                                   
                    ,:WS-RATE-DESC                                      
                    ,:RD-COMPANY-NO                                     
                    ,:RD-SECURED-RATE-FL                                
                    ,:RD-SUM-REVENUE-FL                                 
                    ,:RT-CODE-STATUS                                    
                    ,:RD-REG-GROUP-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y' TO WS-NO-MORE-ROWS                            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE RD-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RD-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7220-CLOSE-RATE-DESC-CUR.                                     *         
      *****************************************************************         
       7220-CLOSE-RATE-DESC-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE RATE_DESC_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE RD-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RD-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7250-OPEN-RATE-SEB-CUR.                                       *         
      *****************************************************************         
       7250-OPEN-RATE-SEB-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN RATE_DESC_SEB                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE RD-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RD-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7260-FETCH-RATE-SEB-CUR.                                      *         
      *****************************************************************         
       7260-FETCH-RATE-SEB-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH RATE_DESC_SEB                                      
                INTO :RD-RATE-PLAN-NO                                   
                    ,:WS-RATE-DESC                                      
                    ,:RD-COMPANY-NO                                     
                    ,:RD-SECURED-RATE-FL                                
                    ,:RD-SUM-REVENUE-FL                                 
                    ,:RT-CODE-STATUS                                    
                    ,:RD-REG-GROUP-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y' TO WS-NO-MORE-ROWS                            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE RD-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RD-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7270-CLOSE-RATE-SEB-CUR.                                      *         
      *****************************************************************         
       7270-CLOSE-RATE-SEB-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE RATE_DESC_SEB                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7270'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE RD-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RD-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *7290-CHECK-CONSRVTION-RATE.                                    *         
      *****************************************************************         
       7290-CHECK-CONSRVTION-RATE.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-CONSRVTION-RATE                               
                 FROM CSS_RATE_SECUR_CAT RI WITH(READUNCOMMITTED)               
                WHERE RI.COMPANY_NO     = :RI-COMPANY-NO                
                  AND RI.CODE_UTIL_TYPE = :RI-CODE-UTIL-TYPE            
                  AND RI.RATE_PLAN_NO   = :RI-RATE-PLAN-NO              
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-CONSRVTION-RATE                                       
MFA-TR*          FROM CSS_RATE_SECUR_CAT RI                                     
MFA-TR*         WHERE RI.COMPANY_NO     = :RI-COMPANY-NO                        
MFA-TR*           AND RI.CODE_UTIL_TYPE = :RI-CODE-UTIL-TYPE                    
MFA-TR*           AND RI.RATE_PLAN_NO   = :RI-RATE-PLAN-NO                      
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_SECUR_CAT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-3         
              MOVE RI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE RI-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE RI-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *7300-SET-RATE-ACCESS-FLAG.                                     *         
      *****************************************************************         
       7300-SET-RATE-ACCESS-FLAG.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-CONS-ACCESS-FLAG                              
                 FROM CSS_RATE_SECUR_CAT RI WITH(READUNCOMMITTED)               
                     ,CSS_CATEGORY       F5 WITH(READUNCOMMITTED)               
                WHERE RI.COMPANY_NO     = :RI-COMPANY-NO                
                  AND RI.CODE_UTIL_TYPE = :RI-CODE-UTIL-TYPE            
                  AND RI.RATE_PLAN_NO   = :RI-RATE-PLAN-NO              
                  AND RI.CATEGORY_ID    = F5.CATEGORY_ID                
                  AND F5.USER_ID        = :F5-USER-ID                   
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-CONS-ACCESS-FLAG                                      
MFA-TR*          FROM CSS_RATE_SECUR_CAT RI                                     
MFA-TR*              ,CSS_CATEGORY       F5                                     
MFA-TR*         WHERE RI.COMPANY_NO     = :RI-COMPANY-NO                        
MFA-TR*           AND RI.CODE_UTIL_TYPE = :RI-CODE-UTIL-TYPE                    
MFA-TR*           AND RI.RATE_PLAN_NO   = :RI-RATE-PLAN-NO                      
MFA-TR*           AND RI.CATEGORY_ID    = F5.CATEGORY_ID                        
MFA-TR*           AND F5.USER_ID        = :F5-USER-ID                           
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_SECUR_CAT'      TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-3         
              MOVE RI-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE RI-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE RI-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7350-SELECT-DELINQNCY                                          *        
      ******************************************************************        
       7350-SELECT-DELINQNCY.                                           
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
                WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                     
                  AND C8.COMPANY_NO = :C8-COMPANY-NO                    
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY C8                                        
MFA-TR*         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                             
MFA-TR*           AND C8.COMPANY_NO = :C8-COMPANY-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7350'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-2         
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *7400-CHECK-SEC-RATE-ACCESS.                                    *         
      *****************************************************************         
       7400-CHECK-SEC-RATE-ACCESS.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-SECD-ACCESS-FLAG                              
ACT006           FROM CSS_CATEGORY WITH(READUNCOMMITTED)                        
ACT006          WHERE CATEGORY_ID IN ('220','9999')                     
ACT006            AND USER_ID     = :F5-USER-ID                         
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-SECD-ACCESS-FLAG                                      
MFA-TR*          FROM CSS_CATEGORY                                              
MFA-TR*         WHERE CATEGORY_ID IN ('220','9999')                             
MFA-TR*           AND USER_ID     = :F5-USER-ID                                 
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CATEGORY'            TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE F5-USER-ID                TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *8000A-DELETE-GTT-ROWS                                          *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            MOVE 'DELETE ROWS'               TO S-SQL-STATEMENT-V.      
                                                                        
            EXEC SQL                                                    
               DELETE FROM #CSR04261_R1                          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DELETE FROM SESSION.CSR04261_R1                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             NEXT SENTENCE                                              
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSR04261_R1'             TO TABLE-1                 
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8100-SEND-RESULT                                                        
      *****************************************************************         
       8100-SEND-RESULT.                                                
            EXEC SQL                                                    
                 INSERT INTO #CSR04261_R1                        
                  (                                                     
                      RETURN_CODE                                       
                     ,RATE_PLAN_NO                                      
                     ,RATE_DESC                                         
                     ,COMPANY_NO                                        
                     ,SECURED_RATE_FL                                   
                     ,SUM_REVENUE_FL                                    
                     ,CODE_STATUS                                       
                     ,REG_GROUP_CD                                      
                     ,RATE_ACCESS_FLAG                                  
                     ,RATE_TYPE                                         
                  )                                                     
                  VALUES                                                
                  (                                                     
                      :S-RETURN-CODE                                    
                     ,:S-RATE-PLAN-NO                                   
                     ,:S-RATE-DESC                                      
                     ,:S-COMPANY-NO                                     
                     ,:S-SECURED-RATE-FL                                
                     ,:S-SUM-REVENUE-FL                                 
                     ,:S-CODE-STATUS                                    
                     ,:S-REG-GROUP-CD                                   
                     ,:S-RATE-ACCESS-FLAG                               
                     ,:S-RATE-TYPE                                      
                  )                                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04261_R1                                
MFA-TR*           (                                                             
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,RATE_DESC                                                 
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,SECURED_RATE_FL                                           
MFA-TR*              ,SUM_REVENUE_FL                                            
MFA-TR*              ,CODE_STATUS                                               
MFA-TR*              ,REG_GROUP_CD                                              
MFA-TR*              ,RATE_ACCESS_FLAG                                          
MFA-TR*              ,RATE_TYPE                                                 
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                        
MFA-TR*           (                                                             
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-RATE-PLAN-NO                                           
MFA-TR*              ,:S-RATE-DESC                                              
MFA-TR*              ,:S-COMPANY-NO                                             
MFA-TR*              ,:S-SECURED-RATE-FL                                        
MFA-TR*              ,:S-SUM-REVENUE-FL                                         
MFA-TR*              ,:S-CODE-STATUS                                            
MFA-TR*              ,:S-REG-GROUP-CD                                           
MFA-TR*              ,:S-RATE-ACCESS-FLAG                                       
MFA-TR*              ,:S-RATE-TYPE                                              
MFA-TR*           )                                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD +1                    TO CTR-ROWS                  
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE '8100'               TO ACTIVE-PARAGRAPH          
                 MOVE 'INSERT'             TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04261_R1'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF.                                                   
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                              
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *       END PROGRAM COPYLIB                                               
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
