       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04259.                                          
COB303 DATE-WRITTEN. MARCH 12, 2009.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  EQUIFAX CREDIT CHECK VALIDATION PROCESS. FOR WEB ONLY.        *        
      *                                                                *        
      *  FOR WEB SST CUSTOMERS BEFORE CALLING EQUIFAX, CREDIT HISTORY  *        
      *  TABLE HAS ANY RECENT EQUIFAX INFO AVAILBLE OR NOT. IF EXISTS  *        
      *  AND THE LAST CREDIT SCORE LESS THAN 6 MTHS, USE THAT INFO FOR *        
      *  DEPOSIT CALCULATION ELSE ITS ELIGIBLE TO CALL EQUIFAX.        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/12/09  VD41351    NEW PROGRAM.                                      
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04259'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04259 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CK - CSS_CREDIT_HIST                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *01  WS-WARNING-DATA-ELEMENTS.                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      * ERROR HANDLING COPY BOOK.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04259_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-DEP-AMT-C            PIC X(10).                       
           05  WS-DEP-AMT-N REDEFINES WS-DEP-AMT-C                      
                                       PIC -(7).99.                     
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-PROGRAM-ID           PIC X(08) VALUE SPACES.          
           05  RS-PROCESS-CODE         PIC X(01) VALUE SPACES.          
           05  RS-DEPOSIT-AMT          PIC X(10) VALUE '0.0'.           
           05  RS-CALL-EQUIFAX         PIC X(01) VALUE SPACES.          
           05  RS-EQUIFAX-REASON       PIC X(01) VALUE SPACES.          
           05  RS-WAIVER-REASON        PIC X(01) VALUE SPACES.          
           05  RS-WAIVER-ACCT          PIC X(13) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-PROGRAM-ID           PIC X(08) VALUE SPACES.           
           05  S-PROCESS-CODE         PIC X(01) VALUE SPACES.           
           05  S-DEPOSIT-AMT          PIC X(10) VALUE '0.0'.            
           05  S-CALL-EQUIFAX         PIC X(01) VALUE SPACES.           
           05  S-EQUIFAX-REASON       PIC X(01) VALUE SPACES.           
           05  S-WAIVER-REASON        PIC X(01) VALUE SPACES.           
           05  S-WAIVER-ACCT          PIC X(13) VALUE SPACES.           
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04259'.     
           05  WS-DELINQ-CD             PIC X(20) VALUE SPACES.         
           05  WS-DELINQ-VALUE          PIC S9(4)V COMP-3 VALUE 0.      
           05  WS-DIFF-VALUE            PIC S9(9)  COMP VALUE 0.        
           05  WS-PGM-ID                PIC X(08) VALUE 'CSR04031'.     
                                                                        
      *****************************************************************         
      *    WS FOR 6010-REDUCE-EMBEDDED SPACES                         *         
      *****************************************************************         
           COPY CWS00011.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * CSR04053 - CALCULATE DEPOSIT                                   *        
      ******************************************************************        
                                                                        
       01  CSR04053-CALL-DATA.                                          
           05  CUSTOMER-NO-4053          PIC X(10) VALUE SPACES.        
           05  PREMISE-NO-4053           PIC X(10) VALUE SPACES.        
           05  COMPANY-NO-4053           PIC X(02) VALUE SPACES.        
           05  APPL-STATUS-CD-4053       PIC X(02) VALUE SPACES.        
           05  CR-ACTION-FL-4053         PIC X(02) VALUE SPACES.        
           05  CR-SCORE-TYPE-CD-4053     PIC X(05) VALUE SPACES.        
           05  USER-ID-4053              PIC X(07) VALUE SPACES.        
                                                                        
       01  CSR04053-RETURN-DATA.                                        
           05  RETURN-CODE-4053          PIC S9(09) COMP VALUE 0.       
           05  PROCESS-CODE-4053         PIC X(01) VALUE SPACES.        
           05  DEPOSIT-AMT-4053          PIC X(10) VALUE '0.0'.         
           05  WAIVER-REASON-4053        PIC X(01) VALUE SPACES.        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC4053 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4053 CURSOR
MSQ001          FOR CALL CSR04053                                             
                  ( :CUSTOMER-NO-4053
                  , :PREMISE-NO-4053
                  , :COMPANY-NO-4053
                  , :APPL-STATUS-CD-4053
                  , :CR-ACTION-FL-4053
                  , :CR-SCORE-TYPE-CD-4053
                  , :USER-ID-4053
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-COMPANY-NO         PIC X(02).                           
       01  LINK-PROGRAM-ID         PIC X(08).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO                              
                          LINK-PREMISE-NO                               
                          LINK-COMPANY-NO                               
                          LINK-PROGRAM-ID.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE        AS RETURN_CODE,             
                      :S-PROGRAM-ID         AS PROGRAM_ID,              
                      :S-PROCESS-CODE       AS PROCESS_CODE,            
                      :S-DEPOSIT-AMT        AS DEPOSIT_AMT,             
                      :S-CALL-EQUIFAX       AS CALL_EQUIFAX,            
                      :S-EQUIFAX-REASON     AS EQUIFAX_REASON,          
                      :S-WAIVER-REASON      AS WAIVER_REASON,           
                      :S-WAIVER-ACCT        AS WAIVER_ACCT              
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE        AS RETURN_CODE,                     
MFA-TR*               :S-PROGRAM-ID         AS PROGRAM_ID,                      
MFA-TR*               :S-PROCESS-CODE       AS PROCESS_CODE,                    
MFA-TR*               :S-DEPOSIT-AMT        AS DEPOSIT_AMT,                     
MFA-TR*               :S-CALL-EQUIFAX       AS CALL_EQUIFAX,                    
MFA-TR*               :S-EQUIFAX-REASON     AS EQUIFAX_REASON,                  
MFA-TR*               :S-WAIVER-REASON      AS WAIVER_REASON,                   
MFA-TR*               :S-WAIVER-ACCT        AS WAIVER_ACCT                      
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           INITIALIZE WS-DIFF-VALUE.                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE '0000000000'    TO LINK-CUSTOMER-NO
           END-IF.                
           MOVE LINK-CUSTOMER-NO    TO WS-CUSTOMER-NO-CHAR.             
           MOVE WS-CUSTOMER-NO-NUM  TO CK-CUSTOMER-NO.                  
                                                                        
           MOVE 'WEB-EQFX-CHK-MTHS' TO C8-DELINQ-CD.                    
           MOVE LINK-COMPANY-NO     TO C8-COMPANY-NO.                   
                                                                        
           PERFORM 7000-SELECT-CUST-CRED-HIST THRU 7000-EXIT.           
      ***                                                                       
      *** NO CREDIT_HIST ROWS FOUND, CALL EQUIFAX. 'E' - ELIGIBLE               
      ***                                                                       
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE +0               TO RS-RETURN-CODE                   
              MOVE 'T'              TO RS-PROCESS-CODE                  
              MOVE 0                TO RS-DEPOSIT-AMT                   
              MOVE 'Y'              TO RS-CALL-EQUIFAX                  
              MOVE 'E'              TO RS-EQUIFAX-REASON                
           ELSE                                                         
              PERFORM 1100-DEPOSIT-PROCESS THRU 1100-EXIT               
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-DEPOSIT-PROCESS.                                            
                                                                        
           PERFORM 7010-GET-DEL-VAL   THRU 7010-EXIT.                   
           MOVE C8-DELINQ-VALUE     TO WS-DELINQ-VALUE.                 
                                                                        
           PERFORM 7020-CAL-DIFF-DAYS THRU 7020-EXIT.                   
                                                                        
           IF WS-DIFF-VALUE > WS-DELINQ-VALUE * 30                      
              MOVE +0               TO RS-RETURN-CODE                   
              MOVE 'T'              TO RS-PROCESS-CODE                  
              MOVE 0                TO RS-DEPOSIT-AMT                   
              MOVE 'Y'              TO RS-CALL-EQUIFAX                  
              MOVE 'E'              TO RS-EQUIFAX-REASON                
           ELSE                                                         
              PERFORM 5100-CALL-CSR04053 THRU 5100-EXIT                 
                                                                        
              MOVE RETURN-CODE-4053   TO RS-RETURN-CODE                 
              MOVE PROCESS-CODE-4053  TO RS-PROCESS-CODE                
              MOVE DEPOSIT-AMT-4053   TO RS-DEPOSIT-AMT                 
              MOVE WAIVER-REASON-4053 TO RS-WAIVER-REASON               
              MOVE 'N'                TO RS-CALL-EQUIFAX                
              MOVE 'I'                TO RS-EQUIFAX-REASON              
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-PGM-ID                  TO RS-PROGRAM-ID.            
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE       TO S-RETURN-CODE.                 
            MOVE RS-PROGRAM-ID        TO S-PROGRAM-ID.                  
            MOVE RS-PROCESS-CODE      TO S-PROCESS-CODE.                
            MOVE RS-DEPOSIT-AMT       TO WS-DEP-AMT-C.                  
            MOVE WS-DEP-AMT-N         TO S-DEPOSIT-AMT.                 
            MOVE RS-CALL-EQUIFAX      TO S-CALL-EQUIFAX.                
            MOVE RS-EQUIFAX-REASON    TO S-EQUIFAX-REASON.              
            MOVE RS-WAIVER-REASON     TO S-WAIVER-REASON.               
            MOVE RS-WAIVER-ACCT       TO S-WAIVER-ACCT.                 
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ****************************************************************          
      **  CALL CSR04053 TO CALCULATE DEPOSIT AMOUNT                 **          
      ****************************************************************          
                                                                        
       5100-CALL-CSR04053.                                              
                                                                        
           MOVE LINK-CUSTOMER-NO    TO CUSTOMER-NO-4053.                
           MOVE LINK-PREMISE-NO     TO PREMISE-NO-4053.                 
           MOVE LINK-COMPANY-NO     TO COMPANY-NO-4053.                 
           MOVE CK-APPL-STATUS-CD   TO APPL-STATUS-CD-4053.             
           MOVE CK-CR-ACTION-FL     TO CR-ACTION-FL-4053.               
           MOVE CK-CR-SCORE-TYPE-CD TO CR-SCORE-TYPE-CD-4053.           
           MOVE 'WEBTRN1'           TO USER-ID-4053.                    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04053                                             
      *           (:CUSTOMER-NO-4053                                    
      *           ,:PREMISE-NO-4053                                     
      *           ,:COMPANY-NO-4053                                     
      *           ,:APPL-STATUS-CD-4053                                 
      *           ,:CR-ACTION-FL-4053                                   
      *           ,:CR-SCORE-TYPE-CD-4053                               
      *           ,:USER-ID-4053)                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4053
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4053
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4053 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04053'            TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CUSTOMER-NO-4053      TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE PREMISE-NO-4053       TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE COMPANY-NO-4053       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4053)                                                
      *       WITH PROCEDURE CSR04053                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4053 CURSOR FOR RESULT SET        
      *       :LOC4053                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4053 INTO                            
                 :RETURN-CODE-4053,                                     
                 :PROCESS-CODE-4053,                                    
                 :DEPOSIT-AMT-4053,                                     
                 :WAIVER-REASON-4053                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4053 NOT = 0                          
                       MOVE RETURN-CODE-4053  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04053'        TO TABLE-1                
                       MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1        
                       MOVE CUSTOMER-NO-4053   TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04053'            TO TABLE-1                
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
                   MOVE CUSTOMER-NO-4053      TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  COMPRESSION ROUTINE TO ELIMINATE SPACES.                  **          
      ****************************************************************          
                                                                        
      ****************************************************************          
      **  GET CUSTOMER CREDIT HIST INFORMATION                      **          
      ****************************************************************          
                                                                        
       7000-SELECT-CUST-CRED-HIST.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CR_HIST_TRAN_TM, 108), ':', '.') 
           CR_HIST_TRAN_TM,
              APPL_STATUS_CD,
              CR_ACTION_FL,
              CR_SCORE_TYPE_CD                                  
                 INTO :CK-CR-HIST-TRAN-DT                               
                     ,:CK-CR-HIST-TRAN-TM                               
                     ,:CK-APPL-STATUS-CD                                
                     ,:CK-CR-ACTION-FL                                  
                     ,:CK-CR-SCORE-TYPE-CD                              
                 FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)                     
                WHERE CUSTOMER_NO = :CK-CUSTOMER-NO                     
                ORDER BY CR_HIST_TRAN_DT DESC                           
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CR_HIST_TRAN_DT                                           
MFA-TR*              ,CR_HIST_TRAN_TM                                           
MFA-TR*              ,APPL_STATUS_CD                                            
MFA-TR*              ,CR_ACTION_FL                                              
MFA-TR*              ,CR_SCORE_TYPE_CD                                          
MFA-TR*          INTO :CK-CR-HIST-TRAN-DT                                       
MFA-TR*              ,:CK-CR-HIST-TRAN-TM                                       
MFA-TR*              ,:CK-APPL-STATUS-CD                                        
MFA-TR*              ,:CK-CR-ACTION-FL                                          
MFA-TR*              ,:CK-CR-SCORE-TYPE-CD                                      
MFA-TR*          FROM CSS_CREDIT_HIST                                           
MFA-TR*         WHERE CUSTOMER_NO = :CK-CUSTOMER-NO                             
MFA-TR*         ORDER BY CR_HIST_TRAN_DT DESC                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '7000'           TO ACTIVE-PARAGRAPH                 
              MOVE 'SELECT'         TO ABEND-FUNCTION                   
              MOVE SPACES           TO ABEND-SQL-PREDICATES             
                                       ABEND-TABLES                     
              MOVE 'CSS_CUST_HIST'  TO TABLE-1                          
              MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1                  
              MOVE CK-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-DEL-VAL                                               *        
      * THIS PARA IS USED TO SELECT THE DELINQ-VALUE FOR THE DELINQ-CD *        
      ******************************************************************        
                                                                        
       7010-GET-DEL-VAL.                                                
                                                                        
            EXEC SQL                                                    
                 SELECT DELINQ_VALUE                                    
                   INTO :C8-DELINQ-VALUE                                
                   FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
                  WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                   
                    AND C8.COMPANY_NO = :C8-COMPANY-NO                  
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT DELINQ_VALUE                                            
MFA-TR*            INTO :C8-DELINQ-VALUE                                        
MFA-TR*            FROM CSS_DELINQUENCY C8                                      
MFA-TR*           WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                           
MFA-TR*             AND C8.COMPANY_NO = :C8-COMPANY-NO                          
MFA-TR*             WITH UR                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SQLCODE       TO RS-RETURN-CODE                   
                 MOVE 0             TO C8-DELINQ-VALUE                  
              ELSE                                                      
                 MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
                 MOVE '7010'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE 'CSS_DELINQUENCY'         TO TABLE-1              
                 MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1      
                 MOVE WS-DELINQ-CD              TO HOSTVAR-ELEMENT-1    
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7020-CAL-DIFF-DAYS                                             *        
      * THIS PARA IS USED TO FIND VALUE BETWEEN CR_HIST_TRAN_DT AND    *        
      * AND CURRENT DATE                                               *        
      ******************************************************************        
                                                                        
       7020-CAL-DIFF-DAYS.                                              
                                                                        
           EXEC SQL                                                     
                SELECT
              CIS.DAYS(CAST(SYSDATETIMEOFFSET() AS DATE)) - CIS.DAYS(
              IIF(TRY_CONVERT(DATE, :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) ))
            INTO
              :WS-DIFF-VALUE 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DIFF-VALUE =                                            
MFA-TR*          (DAYS(CURRENT DATE) - DAYS(DATE(:CK-CR-HIST-TRAN-DT)))         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE          =  SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET COMMAND'             TO TABLE-1                 
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  REDUCE-EMBEDDED SPACES                                        *        
      ******************************************************************        
                                                                        
       COPY CPD00004.                                                           
                                                                        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
