       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04251.                                          
COB303 DATE-WRITTEN.      OCTOBER 13, 2008.                             
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                 P R O G R A M  S U M M A R Y                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM CALCULATES THE WORK AREA FOR A SERVICE ORDER.    *00100000
      *                                                                 00101000
      *  ANY CHANGES MADE TO THE ORDER WHICH MAY IMPACT THE WORK AREA  *00101100
      *  ASSIGNMENT SUCH AS A WORK TYPE CHANGE OR CHANGE TO AN         *00101200
      *  APPLIANCE SHOULD BE SAVED TO DATABASE PRIOR TO CALLING THIS   *00101300
      *  PROGRAM. THIS PROGRAM DOES NOT INCLUDE SCHEDULE DATE          *00101400
      *  VALIDATION LOGIC TO DETERMINE WHETHER A GIVEN WORK AREA HAS   *00101500
      *  REACHED ITS MAX APPOINTMENTS ALLOWED.                         *00101600
      *                                                                *00101700
      *  IF THE V_UPDATE_FL PARM IS 'U' IT WILL ALSO UPDATE THE WORK_  *00102000
      *  AREA_ID ON CSS_SO_DATA IF FOUND AND INSERT SERVICE ORDER      *00103000
      *  REMARKS TO RECORD THE CHANGE IN WORK AREA.  AN 'S' SHOULD BE  *00104000
      *  PASSED IF YOU WISH ONLY TO CALCULATE AND RETURN THE WORK AREA *00105000
      *  AND NOT UPDATE.                                               *00106000
      *                                                                *00107000
      *  IF THE V_UPDATE_FL IS 'U' AND CSR01116 FAILS TO RETURN A WORK *00108000
      *  AREA A WORK AREA VALIDATION WORK QUEUE WILL GENERATE.  IF YOU *00109000
      *  DECIDE TO HANDLE THE WORK AREA UPDATE ELSEWHERE YOU MAY WANT  *00109100
      *  TO GENERATE THE WORK AREA VALIDATION WORK QUEUE IF NO WORK    *00109200
      *  AREA IS RETURNED FROM THIS PROGRAM.                           *00109300
      *                                                                 00109400
      *  VALUE FOR V_PANEL_NO SHOULD ALWAYS BE PASSED. THIS MAY BE     *00109500
      *  USEFUL WHEN DETERMINING WHERE PROGRAM IS BEING CALLED FROM IF *00109600
      *  AN ERROR OCCURS.                                              *00109700
      ******************************************************************00110000
      *  CALLED IN:       FG_STR_CALCULATE_WORK_AREA (CALLED FROM PNLS *00120000
      *                        016, 090)                               *00120100
      *                   AROP.TCL                                     *00120200
      *                   CAD                                          *00120300
      *                                                                *00120400
      *  RETURN CODES:    0 = SUCCESS                                  *00120500
      *                 100 = NOT FOUND                                *00120600
      *                1000 = WORK AREA NOT FOUND                      *00120700
      *                  <0 = DB FAILURE                               *00120800
      ******************************************************************00121000
      *                                                                *00122000
      *                     PROGRAM MODIFICATION LOG                   *00130000
      *                                                                *00140000
      *    DATE    INITIALS   COMMENTS                                 *00150000
      *  --------  --------   ---------------------------------------  *00160000
      *  10/13/08    AKW      NEW PROGRAM.                             *00170000
      *  06/18/09    SC41135  CHANGES TO ACCOMODATE MORE MTRS - A1387  *00171000
      *  06/30/09    AW41078  CORRECT ISSUE WITH CAT 480 WQ COMMENTS   *00172000
A00560*  08/20/09    VV90387  NOT RECORD REMARKS HISTORY FOR SYSTEM    *00173000
A00560*                       RECLACULATED WORK AREA CHANGES FOR       *00174000
A00560*                       DNPFB & FM006.                           *00175000
P00447* 09/07/10    SJ97149  ADD CHECK FOR CONSTANT = 0 FOR SENDING    *00176000
P00447*                      'Y' FOR METER-IND                         *00177000
P00718* 02/20/14    VV90387   ADDITIONAL PARM FOR BUSINESS UNIT        *00178000
ACT230* 07/20/16    TP7R341   REPLACE CSR00028 WITH CSR04675           *00178100
ACT230*  A05460                                                        *00178200
      ******************************************************************00180000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04251'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04251 STARTS HERE'.                  
                                                                        
      ******************************************************************00270000
      *    DB2 INCLUDES                                                *00280000
      ******************************************************************00290000
                                                                        
           EXEC SQL                                                     00310000
              INCLUDE SQLCA                                             00320000
           END-EXEC.                                                    00321000
                                                                        
      *----<CSS_SO_DATA>                                                00322100
           EXEC SQL                                                     00323000
              INCLUDE TBSODAT                                           00324000
           END-EXEC.                                                    00325000
                                                                        
      *----<CSS_ORDER_TYPE>                                             00330100
           EXEC SQL                                                     00331000
              INCLUDE TBORTYP                                           00332000
           END-EXEC.                                                    00333000
                                                                        
      *----<CSS_SO_ORDER_INST>                                          00334100
           EXEC SQL                                                     00335000
              INCLUDE TBSOODR                                           00336000
           END-EXEC.                                                    00337000
                                                                        
      *----<CSS_SO_APPLIANCE>                                           00339800
           EXEC SQL                                                     00339900
              INCLUDE TBSOEQP                                           00340000
           END-EXEC.                                                    00340100
                                                                        
      *----<CSS_MKT_APPLIANCE>                                          00340300
           EXEC SQL                                                     00340400
              INCLUDE TBMKTAPL                                          00340500
           END-EXEC.                                                    00340600
                                                                        
      *----<CSS_UTIL_ENVRNMT>                                           00340800
           EXEC SQL                                                     00340900
              INCLUDE TBUTLENV                                          00341000
           END-EXEC.                                                    00341100
                                                                        
      *----<CSS_MTRD_ENVRNMT>                                           00341300
           EXEC SQL                                                     00341400
              INCLUDE TBMTRENV                                          00341500
           END-EXEC.                                                    00341600
                                                                        
      *----<CSS_PREMISE>                                                00341800
           EXEC SQL                                                     00341900
              INCLUDE TBPREM                                            00342000
           END-EXEC.                                                    00342100
                                                                        
      *----<CSS_ADDR_FORMATTED>                                         00342300
           EXEC SQL                                                     00342400
              INCLUDE TBADRFMT                                          00342500
           END-EXEC.                                                    00342600
                                                                        
      *----<CSS_WORK_AREA>                                              00342900
           EXEC SQL                                                     00343000
              INCLUDE TBWKAR                                            00343100
           END-EXEC.                                                    00343200
                                                                        
      *----<CSS_SO_REMARKS>                                             00343400
           EXEC SQL                                                     00343500
              INCLUDE TBSOREM                                           00343600
           END-EXEC.                                                    00343700
                                                                        
      *----<CSS_LOCAL_OFFICE>                                           00344000
           EXEC SQL                                                     00344100
              INCLUDE TBLOCOFC                                          00344200
           END-EXEC.                                                    00344300
                                                                        
      *----<CSS_ACCOUNT>                                                00344500
           EXEC SQL                                                     00344600
              INCLUDE TBACCT                                            00344700
           END-EXEC.                                                    00344800
                                                                        
      ******************************************************************00345000
      *  CURSOR DECLARATIONS                                           *00345100
      ******************************************************************00345200
                                                                        
           EXEC SQL                                                     
            DECLARE WORK-TYPE CURSOR FOR                                
                SELECT VI.CODE_UTIL_TYPE,                               
                       LTRIM(RTRIM(VI.WORK_TYPE_CD)) AS WORK_TYPE_CD,          
                       CASE                                             
                       WHEN UG.CODE_CAP_TYPE = 'A'                      
P00447              AND (VC.CONSTANT > 1 OR VC.CONSTANT = 0) THEN 'Y'   
                       ELSE 'N'                                         
                       END AS METER_IND                                 
                FROM CSS_SO_MTR_CHG VC WITH(READUNCOMMITTED),                   
                     CSS_MTR_USAGE_VALS UG WITH(READUNCOMMITTED),               
                     CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)                
                     LEFT OUTER JOIN CSS_SO_UTL_CHG UC
                           WITH(READUNCOMMITTED)                  
                          ON UC.SERV_ORDER_NO = VI.SERV_ORDER_NO        
                          AND UC.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE     
                          AND UC.IC_NO = VI.IC_NO                       
                     LEFT OUTER JOIN CSS_SO_UTILITY VT
                           WITH(READUNCOMMITTED)                  
                          ON VT.SERV_ORDER_NO = VI.SERV_ORDER_NO        
                          AND VT.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE     
                          AND VT.IC_NO = VI.IC_NO                       
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND VI.SERV_ORDER_NO = VC.SERV_ORDER_NO               
                  AND VI.CODE_UTIL_TYPE = VC.CODE_UTIL_TYPE             
                  AND VI.IC_NO = VC.IC_NO                               
                  AND VI.METER_NO = VC.METER_NO                         
                  AND VC.CODE_UTIL_TYPE = UG.CODE_UTIL_TYPE             
                  AND VC.CODE_USAGE_ID = UG.CODE_USAGE_ID               
                  AND VC.CODE_USAGE_TYPE = UG.CODE_USAGE_TYPE           
                  AND VC.CODE_USAGE_SOURCE = UG.CODE_USAGE_SOURCE       
                UNION ALL                                               
                SELECT VI1.CODE_UTIL_TYPE,                              
                       LTRIM(RTRIM(VI1.WORK_TYPE_CD)) AS WORK_TYPE_CD,         
                       CASE                                             
                       WHEN UG1.CODE_CAP_TYPE = 'A'                     
P00447              AND (VC1.CONSTANT > 1 OR VC1.CONSTANT = 0) THEN 'Y' 
                       ELSE 'N'                                         
                       END AS METER_IND                                 
                  FROM CSS_SO_METER VC1 WITH(READUNCOMMITTED),                  
                       CSS_MTR_USAGE_VALS UG1 WITH(READUNCOMMITTED),            
                       CSS_SO_ORDER_INST  VI1 WITH(READUNCOMMITTED)             
                      LEFT OUTER JOIN CSS_SO_UTL_CHG UC1
                           WITH(READUNCOMMITTED)                
                              ON UC1.SERV_ORDER_NO   =VI1.SERV_ORDER_NO 
                              AND UC1.CODE_UTIL_TYPE =VI1.CODE_UTIL_TYPE
                              AND UC1.IC_NO          =VI1.IC_NO         
                      LEFT OUTER JOIN CSS_SO_UTILITY VT1
                           WITH(READUNCOMMITTED)                
                              ON VT1.SERV_ORDER_NO   =VI1.SERV_ORDER_NO 
                              AND VT1.CODE_UTIL_TYPE =VI1.CODE_UTIL_TYPE
                              AND VT1.IC_NO          =VI1.IC_NO         
                WHERE VI1.SERV_ORDER_NO           = :VO-SERV-ORDER-NO   
                  AND VI1.SERV_ORDER_NO           =VC1.SERV_ORDER_NO    
                  AND VI1.CODE_UTIL_TYPE          =VC1.CODE_UTIL_TYPE   
                  AND VI1.IC_NO                   =VC1.IC_NO            
                  AND VI1.METER_NO                =VC1.METER_NO         
                  AND VC1.CODE_UTIL_TYPE          =UG1.CODE_UTIL_TYPE   
                  AND VC1.CODE_USAGE_ID           =UG1.CODE_USAGE_ID    
                  AND VC1.CODE_USAGE_TYPE         =UG1.CODE_USAGE_TYPE  
                  AND VC1.CODE_USAGE_SOURCE       =UG1.CODE_USAGE_SOURCE
                UNION ALL                                               
                SELECT VI2.CODE_UTIL_TYPE,                              
                       LTRIM(RTRIM(VI2.WORK_TYPE_CD)) AS WORK_TYPE_CD,         
                       '' AS METER_IND                                  
                  FROM CSS_SO_ORDER_INST  VI2 WITH(READUNCOMMITTED)             
                       LEFT OUTER JOIN CSS_SO_UTL_CHG UC2
                           WITH(READUNCOMMITTED)               
                              ON UC2.SERV_ORDER_NO   =VI2.SERV_ORDER_NO 
                              AND UC2.CODE_UTIL_TYPE =VI2.CODE_UTIL_TYPE
                              AND UC2.IC_NO          =VI2.IC_NO         
                       LEFT OUTER JOIN CSS_SO_UTILITY VT2
                           WITH(READUNCOMMITTED)               
                              ON VT2.SERV_ORDER_NO   =VI2.SERV_ORDER_NO 
                              AND VT2.CODE_UTIL_TYPE =VI2.CODE_UTIL_TYPE
                              AND VT2.IC_NO          =VI2.IC_NO         
                  WHERE VI2.SERV_ORDER_NO = :VO-SERV-ORDER-NO           
                    AND NOT EXISTS(SELECT 1                             
                     FROM CSS_SO_METER VC3 WITH(READUNCOMMITTED),               
                          CSS_MTR_USAGE_VALS UG3 WITH(READUNCOMMITTED)          
                    WHERE VI2.SERV_ORDER_NO     = VC3.SERV_ORDER_NO     
                      AND VI2.CODE_UTIL_TYPE    = VC3.CODE_UTIL_TYPE    
                      AND VI2.IC_NO             = VC3.IC_NO             
                      AND VI2.METER_NO          = VC3.METER_NO          
                      AND VC3.CODE_UTIL_TYPE    = UG3.CODE_UTIL_TYPE    
                      AND VC3.CODE_USAGE_ID     = UG3.CODE_USAGE_ID     
                      AND VC3.CODE_USAGE_TYPE   = UG3.CODE_USAGE_TYPE   
                      AND VC3.CODE_USAGE_SOURCE = UG3.CODE_USAGE_SOURCE)
                    AND NOT EXISTS(SELECT 1                             
                     FROM CSS_SO_MTR_CHG VC4 WITH(READUNCOMMITTED),             
                          CSS_MTR_USAGE_VALS UG4 WITH(READUNCOMMITTED)          
                    WHERE VI2.SERV_ORDER_NO     = VC4.SERV_ORDER_NO     
                      AND VI2.CODE_UTIL_TYPE    = VC4.CODE_UTIL_TYPE    
                      AND VI2.IC_NO             = VC4.IC_NO             
                      AND VI2.METER_NO          = VC4.METER_NO          
                      AND VC4.CODE_UTIL_TYPE    = UG4.CODE_UTIL_TYPE    
                      AND VC4.CODE_USAGE_ID     = UG4.CODE_USAGE_ID     
                      AND VC4.CODE_USAGE_TYPE   = UG4.CODE_USAGE_TYPE   
                      AND VC4.CODE_USAGE_SOURCE = UG4.CODE_USAGE_SOURCE)
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     00345400
MFA-TR*     DECLARE WORK-TYPE CURSOR FOR                                00345500
MFA-TR*         SELECT VI.CODE_UTIL_TYPE,                               00345600
MFA-TR*                STRIP(VI.WORK_TYPE_CD) AS WORK_TYPE_CD,          00345700
MFA-TR*                CASE                                             00345800
MFA-TR*                WHEN UG.CODE_CAP_TYPE = 'A'                      00345900
MFA-TR*             AND (VC.CONSTANT > 1 OR VC.CONSTANT = 0) THEN 'Y'   00346000
MFA-TR*                ELSE 'N'                                         00346100
MFA-TR*                END AS METER_IND                                 00346200
MFA-TR*         FROM CSS_SO_MTR_CHG VC,                                 00346300
MFA-TR*              CSS_MTR_USAGE_VALS UG,                             00346400
MFA-TR*              CSS_SO_ORDER_INST  VI                              00346500
MFA-TR*              LEFT OUTER JOIN CSS_SO_UTL_CHG UC                  00346600
MFA-TR*                   ON UC.SERV_ORDER_NO = VI.SERV_ORDER_NO        00346700
MFA-TR*                   AND UC.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE     00346800
MFA-TR*                   AND UC.IC_NO = VI.IC_NO                       00346900
MFA-TR*              LEFT OUTER JOIN CSS_SO_UTILITY VT                  00347000
MFA-TR*                   ON VT.SERV_ORDER_NO = VI.SERV_ORDER_NO        00347100
MFA-TR*                   AND VT.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE     00347200
MFA-TR*                   AND VT.IC_NO = VI.IC_NO                       00347300
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              00347400
MFA-TR*           AND VI.SERV_ORDER_NO = VC.SERV_ORDER_NO               00347500
MFA-TR*           AND VI.CODE_UTIL_TYPE = VC.CODE_UTIL_TYPE             00347600
MFA-TR*           AND VI.IC_NO = VC.IC_NO                               00347700
MFA-TR*           AND VI.METER_NO = VC.METER_NO                         00347800
MFA-TR*           AND VC.CODE_UTIL_TYPE = UG.CODE_UTIL_TYPE             00347900
MFA-TR*           AND VC.CODE_USAGE_ID = UG.CODE_USAGE_ID               00348000
MFA-TR*           AND VC.CODE_USAGE_TYPE = UG.CODE_USAGE_TYPE           00348100
MFA-TR*           AND VC.CODE_USAGE_SOURCE = UG.CODE_USAGE_SOURCE       00348200
MFA-TR*         UNION ALL                                               00348300
MFA-TR*         SELECT VI1.CODE_UTIL_TYPE,                              00348400
MFA-TR*                STRIP(VI1.WORK_TYPE_CD) AS WORK_TYPE_CD,         00348500
MFA-TR*                CASE                                             00348600
MFA-TR*                WHEN UG1.CODE_CAP_TYPE = 'A'                     00348700
MFA-TR*             AND (VC1.CONSTANT > 1 OR VC1.CONSTANT = 0) THEN 'Y' 00348900
MFA-TR*                ELSE 'N'                                         00349000
MFA-TR*                END AS METER_IND                                 00349100
MFA-TR*           FROM CSS_SO_METER VC1,                                00349200
MFA-TR*                CSS_MTR_USAGE_VALS UG1,                          00349300
MFA-TR*                CSS_SO_ORDER_INST  VI1                           00349400
MFA-TR*               LEFT OUTER JOIN CSS_SO_UTL_CHG UC1                00349500
MFA-TR*                       ON UC1.SERV_ORDER_NO   =VI1.SERV_ORDER_NO 00349600
MFA-TR*                       AND UC1.CODE_UTIL_TYPE =VI1.CODE_UTIL_TYPE00349700
MFA-TR*                       AND UC1.IC_NO          =VI1.IC_NO         00349800
MFA-TR*               LEFT OUTER JOIN CSS_SO_UTILITY VT1                00349900
MFA-TR*                       ON VT1.SERV_ORDER_NO   =VI1.SERV_ORDER_NO 00350000
MFA-TR*                       AND VT1.CODE_UTIL_TYPE =VI1.CODE_UTIL_TYPE00350100
MFA-TR*                       AND VT1.IC_NO          =VI1.IC_NO         00350200
MFA-TR*         WHERE VI1.SERV_ORDER_NO           = :VO-SERV-ORDER-NO   00350600
MFA-TR*           AND VI1.SERV_ORDER_NO           =VC1.SERV_ORDER_NO    00350700
MFA-TR*           AND VI1.CODE_UTIL_TYPE          =VC1.CODE_UTIL_TYPE   00350800
MFA-TR*           AND VI1.IC_NO                   =VC1.IC_NO            00350900
MFA-TR*           AND VI1.METER_NO                =VC1.METER_NO         00351000
MFA-TR*           AND VC1.CODE_UTIL_TYPE          =UG1.CODE_UTIL_TYPE   00351100
MFA-TR*           AND VC1.CODE_USAGE_ID           =UG1.CODE_USAGE_ID    00351200
MFA-TR*           AND VC1.CODE_USAGE_TYPE         =UG1.CODE_USAGE_TYPE  00351300
MFA-TR*           AND VC1.CODE_USAGE_SOURCE       =UG1.CODE_USAGE_SOURCE00351400
MFA-TR*         UNION ALL                                               00351500
MFA-TR*         SELECT VI2.CODE_UTIL_TYPE,                              00351600
MFA-TR*                STRIP(VI2.WORK_TYPE_CD) AS WORK_TYPE_CD,         00351700
MFA-TR*                '' AS METER_IND                                  00351800
MFA-TR*           FROM CSS_SO_ORDER_INST  VI2                           00351900
MFA-TR*                LEFT OUTER JOIN CSS_SO_UTL_CHG UC2               00352000
MFA-TR*                       ON UC2.SERV_ORDER_NO   =VI2.SERV_ORDER_NO 00352100
MFA-TR*                       AND UC2.CODE_UTIL_TYPE =VI2.CODE_UTIL_TYPE00352200
MFA-TR*                       AND UC2.IC_NO          =VI2.IC_NO         00352300
MFA-TR*                LEFT OUTER JOIN CSS_SO_UTILITY VT2               00352400
MFA-TR*                       ON VT2.SERV_ORDER_NO   =VI2.SERV_ORDER_NO 00352500
MFA-TR*                       AND VT2.CODE_UTIL_TYPE =VI2.CODE_UTIL_TYPE00352600
MFA-TR*                       AND VT2.IC_NO          =VI2.IC_NO         00352700
MFA-TR*           WHERE VI2.SERV_ORDER_NO = :VO-SERV-ORDER-NO           00352800
MFA-TR*             AND NOT EXISTS(SELECT 1                             00352900
MFA-TR*              FROM CSS_SO_METER VC3,                             00353000
MFA-TR*                   CSS_MTR_USAGE_VALS UG3                        00353100
MFA-TR*             WHERE VI2.SERV_ORDER_NO     = VC3.SERV_ORDER_NO     00353200
MFA-TR*               AND VI2.CODE_UTIL_TYPE    = VC3.CODE_UTIL_TYPE    00353300
MFA-TR*               AND VI2.IC_NO             = VC3.IC_NO             00353400
MFA-TR*               AND VI2.METER_NO          = VC3.METER_NO          00353500
MFA-TR*               AND VC3.CODE_UTIL_TYPE    = UG3.CODE_UTIL_TYPE    00353600
MFA-TR*               AND VC3.CODE_USAGE_ID     = UG3.CODE_USAGE_ID     00353700
MFA-TR*               AND VC3.CODE_USAGE_TYPE   = UG3.CODE_USAGE_TYPE   00353800
MFA-TR*               AND VC3.CODE_USAGE_SOURCE = UG3.CODE_USAGE_SOURCE)00353900
MFA-TR*             AND NOT EXISTS(SELECT 1                             00354000
MFA-TR*              FROM CSS_SO_MTR_CHG VC4,                           00354100
MFA-TR*                   CSS_MTR_USAGE_VALS UG4                        00354200
MFA-TR*             WHERE VI2.SERV_ORDER_NO     = VC4.SERV_ORDER_NO     00354300
MFA-TR*               AND VI2.CODE_UTIL_TYPE    = VC4.CODE_UTIL_TYPE    00354400
MFA-TR*               AND VI2.IC_NO             = VC4.IC_NO             00354500
MFA-TR*               AND VI2.METER_NO          = VC4.METER_NO          00354600
MFA-TR*               AND VC4.CODE_UTIL_TYPE    = UG4.CODE_UTIL_TYPE    00354700
MFA-TR*               AND VC4.CODE_USAGE_ID     = UG4.CODE_USAGE_ID     00354800
MFA-TR*               AND VC4.CODE_USAGE_TYPE   = UG4.CODE_USAGE_TYPE   00354900
MFA-TR*               AND VC4.CODE_USAGE_SOURCE = UG4.CODE_USAGE_SOURCE)00355000
MFA-TR*        WITH UR                                                  00355100
MFA-TR*    END-EXEC.                                                    00355200
                                                                        
      ******************************************************************00355400
      *    COBOL WORKING STORAGE COPY BOOKS                            *00356000
      ******************************************************************00360000
                                                                        
      *----< ERROR HANDLING >                                           00411000
           EXEC SQL                                                     00420000
               INCLUDE CWSX0010                                         00430000
           END-EXEC.                                                    00440000
                                                                        
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >           00440200
           COPY CWS00027.                                               00440300
                                                                        
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                      00440500
           COPY CWS00303.                                               00441000
                                                                        
      ******************************************************************00451000
      *    WORK AREAS                                                  *00452000
      ******************************************************************00453000
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-SERV-ORDER-NO      PIC X(13) VALUE SPACES.          
           05  PARM-SERV-ORDER-NO-RED  PIC 9(13).                       
           05  PARM-SERV-ORDER-NO-NUM  PIC S9(13)V COMP-3 VALUE 0.      
           05  PARM-UPDATE-FL          PIC X(01).                       
           05  PARM-USER-ID            PIC X(07).                       
           05  PARM-PANEL-NO           PIC X(04) VALUE SPACES.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-OLD-WORK-AREA        PIC X(12) VALUE SPACES.          
           05  RS-OLD-WORK-AREA-TX     PIC X(40) VALUE SPACES.          
           05  RS-NEW-WORK-AREA        PIC X(12) VALUE SPACES.          
           05  RS-LOCAL-OFFICE         PIC X(03) VALUE SPACES.          
A1387      05  RS-CODE-UTIL-TYPE       PIC X(50) VALUE SPACES.          
A1387      05  RS-WORK-TYPE-CD         PIC X(150) VALUE SPACES.         
           05  RS-CRAWL-IND            PIC X(01) VALUE SPACES.          
A1387      05  RS-METER-IND            PIC X(50) VALUE SPACES.          
           05  RS-ZIP-CODE             PIC X(05) VALUE SPACES.          
           05  RS-READ-ROUTE           PIC X(04) VALUE SPACES.          
           05  RS-POINT-ID             PIC X(10) VALUE SPACES.          
P00718     05  RS-BUSINESS-UNIT        PIC X(03) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-OLD-WORK-AREA        PIC X(12) VALUE SPACES.           
           05  S-OLD-WORK-AREA-TX     PIC X(40) VALUE SPACES.           
           05  S-NEW-WORK-AREA        PIC X(12) VALUE SPACES.           
           05  S-LOCAL-OFFICE         PIC X(03) VALUE SPACES.           
A1387      05  S-CODE-UTIL-TYPE       PIC X(50) VALUE SPACES.           
A1387      05  S-WORK-TYPE-CD         PIC X(150) VALUE SPACES.          
           05  S-CRAWL-IND            PIC X(01) VALUE SPACES.           
A1387      05  S-METER-IND            PIC X(50) VALUE SPACES.           
           05  S-ZIP-CODE             PIC X(05) VALUE SPACES.           
           05  S-READ-ROUTE           PIC X(04) VALUE SPACES.           
           05  S-POINT-ID             PIC X(10) VALUE SPACES.           
P00718     05  S-BUSINESS-UNIT        PIC X(03) VALUE SPACES.           
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 NORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04251'.     
           05  WS-SERV-ORDER-NO         PIC X(13) JUSTIFIED RIGHT.      
COB305     05 WS-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-UPDATE-FL             PIC X(01).                      
           05  WS-USER-ID               PIC X(07).                      
           05  WS-PANEL-NO              PIC X(04) VALUE SPACES.         
A00560     05  WS-090                   PIC X(04) VALUE '090'.          
A00560     05  WS-CAD                   PIC X(04) VALUE 'CAD3'.         
           05  WS-ORIG-WORK-AREA        PIC X(12) VALUE SPACES.         
           05  WS-ORDER-TYPE-CD-2       PIC X(02) VALUE SPACES.         
           05  WS-LOCAL-OFFICE          PIC X(03) VALUE SPACES.         
           05  WS-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.         
A1387      05  WS-CODE-UTIL-TYPES       PIC X(50) VALUE SPACES.         
           05  WS-WORK-TYPE-CD          PIC X(03) VALUE SPACES.         
A1387      05  WS-WORK-TYPES            PIC X(150) VALUE SPACES.        
           05  WS-CRAWL-IND             PIC X(01) VALUE 'N'.            
           05  WS-METER-IND             PIC X(01) VALUE SPACES.         
A1387      05  WS-METER-INDICATORS      PIC X(50) VALUE SPACES.         
           05  WS-ZIP-CODE              PIC X(05) VALUE SPACES.         
           05  WS-READ-ROUTE-CHAR       PIC X(04).                      
           05  WS-READ-ROUTE-NUM        REDEFINES WS-READ-ROUTE-CHAR    
                                         PIC 9(04).                     
           05  WS-POINT-ID              PIC X(10) VALUE SPACES.         
           05  WS-REMARK-TX.                                            
               10 FILLER                PIC X(15) VALUE                 
               'ORIG WK AREA - '.                                       
               10 WS-ORIG-WORK-AREA-TX  PIC X(40).                      
           05  WS-SERV-ORDER-WORK-CD    PIC X(05) VALUE SPACES.         
               88 CRAWL-WORK-CD         VALUES 'METRO', 'DISTC'.        
           05  WS-CSR01116-PARMS.                                       
               10 WS-CSR01116-PARMS-1   PIC X(20) VALUE SPACES.         
               10 WS-CSR01116-PARMS-2   PIC X(20) VALUE SPACES.         
               10 WS-CSR01116-PARMS-3   PIC X(20) VALUE SPACES.         
           05  WS-POINTER-1             PIC 9(02) VALUE 1.              
A1387      05  WS-POINTER-2             PIC 9(03) VALUE 1.              
           05  WS-POINTER-3             PIC 9(02) VALUE 1.              
                                                                        
      ******************************************************************01035100
      * CSR01116 - CALCULATE WORK AREA                                 *01035200
      ******************************************************************01035300
       01  CSR01116-CALL-DATA.                                          
           03  LOCAL-OFFICE-1116        PIC X(03) VALUE SPACES.         
A1387      03  CODE-UTIL-TYPE-1116      PIC X(50) VALUE SPACES.         
A1387      03  WORK-TYPE-CD-1116        PIC X(150) VALUE SPACES.        
           03  CRAWL-IND-1116           PIC X(01) VALUE SPACES.         
A1387      03  METER-IND-1116           PIC X(50) VALUE SPACES.         
           03  ZIP-CODE-1116            PIC X(05) VALUE SPACES.         
           03  READ-ROUTE-1116          PIC X(04) VALUE SPACES.         
           03  POINT-ID-1116            PIC X(10) VALUE SPACES.         
                                                                        
                                                                        
       01  CSR01116-RETURN-DATA.                                        
           03  RETURN-CODE-1116         PIC S9(9) COMP VALUE 0.         
           03  WORK-AREA-1116           PIC X(12) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-1116       PIC X(03) VALUE SPACES.         
                                                                        
      ******************************************************************01180100
      * CSR00709 - UPDATE WORK AREA                                    *01180200
      ******************************************************************01180300
       01  CSR00709-CALL-DATA.                                          
           03  SERV-ORDER-NO-0709       PIC X(13) VALUE SPACES.         
           03  WORK-AREA-ID-0709        PIC X(12) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-0709       PIC X(03) VALUE SPACES.         
                                                                        
       01  CSR00709-RETURN-DATA.                                        
           03  RETURN-CODE-0709         PIC S9(9) COMP VALUE 0.         
                                                                        
      ******************************************************************01189100
      * CSR00425 - INSERT SERVICE ORDER REMARKS*                        01189200
      ******************************************************************01189300
       01  CSR00425-CALL-DATA.                                          
           03  SERV-ORDER-NO-0425       PIC X(13) VALUE SPACES.         
           03  REMARK-TYPE-CD-0425      PIC X(01) VALUE SPACES.         
           03  REMARK-TX-0425           PIC X(60) VALUE SPACES.         
           03  USER-ID-0425             PIC X(07) VALUE SPACES.         
                                                                        
       01  CSR00425-RETURN-DATA.                                        
           03  RETURN-CODE-0425         PIC S9(9) COMP VALUE 0.         
                                                                        
      ******************************************************************01190700
ACT230* CSR04675 - INSERT WORK QUEUE                                   *01190800
      ******************************************************************01190900
ACT230 01  CSR04675-CALL-DATA.                                          
ACT230     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT230     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT230     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT230     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT230     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT230     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT230     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT230     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT230     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT230     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT230     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT230     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT230     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT230     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT230     05  COMMENTS-4675.                                           
ACT230        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT230        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT230     05  FREE-FORM-DATA-4675.                                     
ACT230        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT230        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT230     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT230 01  CSR04675-RETURN-DATA.                                        
ACT230     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT230     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      *01  LOC1116 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01  LOC0709 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01  LOC0425 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
ACT230*01  LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1116 CURSOR
MSQ001          FOR CALL CSR01116                                             
                   ( :LOCAL-OFFICE-1116
                  , :CODE-UTIL-TYPE-1116
                  , :WORK-TYPE-CD-1116
                  , :CRAWL-IND-1116
                  , :METER-IND-1116
                  , :ZIP-CODE-1116
                  , :READ-ROUTE-1116
                  , :POINT-ID-1116
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0709 CURSOR
MSQ001          FOR CALL CSR00709                                             
                   ( :SERV-ORDER-NO-0709
                  , :WORK-AREA-ID-0709
                  , :BUSINESS-UNIT-0709
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0425 CURSOR
MSQ001          FOR CALL CSR00425                                             
                   ( :SERV-ORDER-NO-0425
                  , :REMARK-TYPE-CD-0425
                  , :EF-REMARK-TX
                  , :USER-ID-0425
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT230            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SERV-ORDER-NO      PIC X(13).                           
       01  LINK-UPDATE-FL          PIC X(01).                           
       01  LINK-USER-ID            PIC X(07).                           
       01  LINK-PANEL-NO           PIC X(04).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-SERV-ORDER-NO,                           
                          LINK-UPDATE-FL,                               
                          LINK-USER-ID,                                 
                          LINK-PANEL-NO.                                
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                 
            PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                 
            PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                 
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                 
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
            EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.             
            EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.             
            EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.             
            EXEC SQL                                                    
                DECLARE C1 CURSOR  FOR                       
                SELECT :S-RETURN-CODE       AS RETURN_CODE,             
                       :S-OLD-WORK-AREA     AS OLD_WORK_AREA,           
                       :S-OLD-WORK-AREA-TX  AS OLD_WORK_AREA_TX,        
                       :S-NEW-WORK-AREA     AS NEW_WORK_AREA,           
                       :S-LOCAL-OFFICE      AS LOCAL_OFFICE,            
                       :S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE,          
                       :S-WORK-TYPE-CD      AS WORK_TYPE_CD,            
                       :S-CRAWL-IND         AS CRAWL_IND,               
                       :S-METER-IND         AS METER_IND,               
                       :S-ZIP-CODE          AS ZIP_CODE,                
                       :S-READ-ROUTE        AS READ_ROUTE,              
                       :S-POINT-ID          AS POINT_ID,                
P00718                 :S-BUSINESS-UNIT     AS BUSINESS_UNIT            
                FROM CIS.SYSDUMMY1                                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*     EXEC SQL                                                    02030000
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                       02040000
MFA-TR*         SELECT :S-RETURN-CODE       AS RETURN_CODE,             02050000
MFA-TR*                :S-OLD-WORK-AREA     AS OLD_WORK_AREA,           02130000
MFA-TR*                :S-OLD-WORK-AREA-TX  AS OLD_WORK_AREA_TX,        02130100
MFA-TR*                :S-NEW-WORK-AREA     AS NEW_WORK_AREA,           02131000
MFA-TR*                :S-LOCAL-OFFICE      AS LOCAL_OFFICE,            02132000
MFA-TR*                :S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE,          02133000
MFA-TR*                :S-WORK-TYPE-CD      AS WORK_TYPE_CD,            02134000
MFA-TR*                :S-CRAWL-IND         AS CRAWL_IND,               02135000
MFA-TR*                :S-METER-IND         AS METER_IND,               02136000
MFA-TR*                :S-ZIP-CODE          AS ZIP_CODE,                02137000
MFA-TR*                :S-READ-ROUTE        AS READ_ROUTE,              02138000
MFA-TR*                :S-POINT-ID          AS POINT_ID,                02139000
MFA-TR*                :S-BUSINESS-UNIT     AS BUSINESS_UNIT            02139100
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                   02140000
MFA-TR*     END-EXEC.                                                   02150000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE LINK-SERV-ORDER-NO        TO PARM-SERV-ORDER-NO.       
            UNSTRING PARM-SERV-ORDER-NO    DELIMITED   BY ' '           
                                           INTO WS-SERV-ORDER-NO.       
            MOVE WS-SERV-ORDER-NO          TO  PARM-SERV-ORDER-NO-RED.  
            MOVE PARM-SERV-ORDER-NO-RED    TO  PARM-SERV-ORDER-NO-NUM.  
            MOVE PARM-SERV-ORDER-NO-NUM    TO  WS-ORDER-NO.             
            MOVE WS-ORDER-NO               TO VO-SERV-ORDER-NO.         
                                                                        
            MOVE LINK-UPDATE-FL       TO WS-UPDATE-FL                   
                                         PARM-UPDATE-FL.                
            MOVE LINK-USER-ID         TO WS-USER-ID                     
                                         PARM-USER-ID.                  
            MOVE LINK-PANEL-NO        TO WS-PANEL-NO                    
                                         PARM-PANEL-NO.                 
                                                                        
            PERFORM 7000-SELECT-SO-DATA THRU 7000-EXIT.                 
            MOVE VO-LOCAL-OFFICE TO WS-LOCAL-OFFICE.                    
            MOVE VO-WORK-AREA-ID TO WS-ORIG-WORK-AREA                   
                                    RS-OLD-WORK-AREA.                   
            PERFORM 7050-GET-WORK-AREA-DESC THRU 7050-EXIT.             
                                                                        
            PERFORM 7010-SELECT-ORDER-TYPE  THRU 7010-EXIT.             
            MOVE VO-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD-2.                
                                                                        
            IF C2-ORDER-GROUP-CD NOT = 'A' AND                          
               C2-ORDER-GROUP-CD NOT = 'F' AND                          
               C2-ORDER-GROUP-CD NOT = 'G' AND                          
               WS-ORDER-TYPE-CD-2 NOT = 'UM' THEN                       
               PERFORM 7200-OPEN-WORK-TYPE-METER THRU 7200-EXIT         
               PERFORM 7210-FETCH-WORK-TYPE-METER THRU 7210-EXIT UNTIL  
                   WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               PERFORM 7220-CLOSE-WORK-TYPE-METER THRU 7220-EXIT        
            ELSE                                                        
               PERFORM 7300-GET-WORK-TYPE THRU 7300-EXIT                
               MOVE WS-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPES         
               MOVE WS-WORK-TYPE-CD       TO WS-WORK-TYPES              
               MOVE 'N'                   TO WS-METER-INDICATORS        
            END-IF.                                                     
                                                                        
            PERFORM 7400-GET-LOCOFF-WORK-CD THRU 7400-EXIT.             
            IF CRAWL-WORK-CD THEN                                       
               PERFORM 7410-GET-CRAWL-IND  THRU 7410-EXIT               
            END-IF.                                                     
                                                                        
            PERFORM 7020-GET-READ-ROUTE THRU 7020-EXIT.                 
                                                                        
            PERFORM 7030-GET-POINT-ID   THRU 7030-EXIT.                 
                                                                        
            PERFORM 7040-GET-ZIP-CODE   THRU 7040-EXIT.                 
            MOVE DY-ZIP-CODE            TO WS-ZIP-CODE.                 
                                                                        
            PERFORM 3000-FORMAT-CSR01116-CALL   THRU 3000-EXIT.         
            PERFORM 3010-CALL-CSR01116          THRU 3010-EXIT.         
                                                                        
            IF WORK-AREA-1116 = SPACES THEN                             
               IF WS-UPDATE-FL = 'U' THEN                               
ACT230           MOVE 480  TO CATEGORY-ID-4675                          
ACT230           PERFORM 3300-FORMAT-CSR04675-CALL THRU 3300-EXIT       
ACT230           PERFORM 3310-CALL-CSR04675        THRU 3310-EXIT       
               END-IF                                                   
               MOVE 1000 TO WS-ACTIVE-RETURN-CODE                       
               GO TO 1000-EXIT                                          
            END-IF.                                                     
                                                                        
            IF WORK-AREA-1116 NOT = WS-ORIG-WORK-AREA AND               
               WORK-AREA-1116 NOT = SPACES            AND               
               WS-UPDATE-FL = 'U' THEN                                  
               PERFORM 3100-FORMAT-CSR00709-CALL THRU 3100-EXIT         
               PERFORM 3110-CALL-CSR00709        THRU 3110-EXIT         
A00560         IF WS-PANEL-NO NOT EQUAL WS-090 AND                      
A00560            WS-PANEL-NO NOT EQUAL WS-CAD                          
                  PERFORM 3200-FORMAT-CSR00425-CALL THRU 3200-EXIT      
                  PERFORM 3210-CALL-CSR00425        THRU 3210-EXIT      
A00560         END-IF                                                   
            END-IF.                                                     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.          
            MOVE '2000'                     TO ACTIVE-PARAGRAPH.        
            PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.            
            ADD 1                           TO  CTR-ROWS.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE       TO S-RETURN-CODE.                  
           MOVE RS-OLD-WORK-AREA     TO S-OLD-WORK-AREA.                
           MOVE RS-OLD-WORK-AREA-TX  TO S-OLD-WORK-AREA-TX.             
           MOVE RS-NEW-WORK-AREA     TO S-NEW-WORK-AREA.                
           MOVE RS-LOCAL-OFFICE      TO S-LOCAL-OFFICE.                 
           MOVE RS-CODE-UTIL-TYPE    TO S-CODE-UTIL-TYPE.               
           MOVE RS-WORK-TYPE-CD      TO S-WORK-TYPE-CD.                 
           MOVE RS-CRAWL-IND         TO S-CRAWL-IND.                    
           MOVE RS-METER-IND         TO S-METER-IND.                    
           MOVE RS-ZIP-CODE          TO S-ZIP-CODE.                     
           MOVE RS-READ-ROUTE        TO S-READ-ROUTE.                   
           MOVE RS-POINT-ID          TO S-POINT-ID.                     
P00718     MOVE RS-BUSINESS-UNIT     TO S-BUSINESS-UNIT.                
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       3000-FORMAT-CSR01116-CALL.                                       
                                                                        
           MOVE WS-LOCAL-OFFICE      TO LOCAL-OFFICE-1116               
                                        RS-LOCAL-OFFICE.                
           MOVE WS-CODE-UTIL-TYPES   TO CODE-UTIL-TYPE-1116             
                                        RS-CODE-UTIL-TYPE.              
           MOVE WS-WORK-TYPES        TO WORK-TYPE-CD-1116               
                                        RS-WORK-TYPE-CD.                
           MOVE WS-CRAWL-IND         TO CRAWL-IND-1116                  
                                        RS-CRAWL-IND.                   
           IF WS-METER-INDICATORS = SPACES THEN                         
              MOVE 'N'               TO WS-METER-INDICATORS             
           END-IF.                                                      
           MOVE WS-METER-INDICATORS  TO METER-IND-1116                  
                                        RS-METER-IND.                   
           MOVE WS-ZIP-CODE          TO ZIP-CODE-1116                   
                                        RS-ZIP-CODE.                    
           MOVE WS-READ-ROUTE-CHAR   TO READ-ROUTE-1116                 
                                        RS-READ-ROUTE.                  
           MOVE WS-POINT-ID          TO POINT-ID-1116                   
                                        RS-POINT-ID.                    
           STRING LOCAL-OFFICE-1116            DELIMITED BY SIZE        
                  ','                          DELIMITED BY SIZE        
                  CODE-UTIL-TYPE-1116          DELIMITED BY SPACES      
                  ','                          DELIMITED BY SIZE        
                  WORK-TYPE-CD-1116            DELIMITED BY SPACES      
                  ','                          DELIMITED BY SIZE        
                  CRAWL-IND-1116               DELIMITED BY SPACES      
                  ','                          DELIMITED BY SIZE        
                  METER-IND-1116               DELIMITED BY SPACES      
                  ','                          DELIMITED BY SIZE        
                  ZIP-CODE-1116                DELIMITED BY SIZE        
                  ','                          DELIMITED BY SIZE        
                  READ-ROUTE-1116              DELIMITED BY SIZE        
                  ','                          DELIMITED BY SIZE        
                  POINT-ID-1116                DELIMITED BY SIZE        
                                               INTO WS-CSR01116-PARMS.  
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-CALL-CSR01116.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01116                                             
      *            (:LOCAL-OFFICE-1116,                                 
      *             :CODE-UTIL-TYPE-1116,                               
      *             :WORK-TYPE-CD-1116,                                 
      *             :CRAWL-IND-1116,                                    
      *             :METER-IND-1116,                                    
      *             :ZIP-CODE-1116,                                     
      *             :READ-ROUTE-1116,                                   
      *             :POINT-ID-1116)                                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1116 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3010'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01116'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              MOVE 'PARMS1'              TO TABLE-ELEMENT-2             
              MOVE WS-CSR01116-PARMS-1   TO HOSTVAR-ELEMENT-2           
              MOVE 'PARMS2'              TO TABLE-ELEMENT-3             
              MOVE WS-CSR01116-PARMS-2   TO HOSTVAR-ELEMENT-3           
              MOVE 'PARMS3'              TO TABLE-ELEMENT-4             
              MOVE WS-CSR01116-PARMS-3   TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1116)                                                
      *       WITH PROCEDURE CSR01116                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1116 CURSOR FOR RESULT SET        
      *       :LOC1116                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_1116 INTO                           
                   :RETURN-CODE-1116 ,                                  
                   :WORK-AREA-1116,                                     
P00718             :BUSINESS-UNIT-1116                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WORK-AREA-1116        TO RS-NEW-WORK-AREA       
P00718             MOVE BUSINESS-UNIT-1116    TO RS-BUSINESS-UNIT       
               WHEN NOT-FOUND                                           
                   MOVE SPACES                TO RS-NEW-WORK-AREA       
P00718             MOVE SPACES                TO RS-BUSINESS-UNIT       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3010'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01116'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
                   MOVE 'PARMS1'              TO TABLE-ELEMENT-2        
                   MOVE WS-CSR01116-PARMS-1   TO HOSTVAR-ELEMENT-2      
                   MOVE 'PARMS2'              TO TABLE-ELEMENT-3        
                   MOVE WS-CSR01116-PARMS-2   TO HOSTVAR-ELEMENT-3      
                   MOVE 'PARMS3'              TO TABLE-ELEMENT-4        
                   MOVE WS-CSR01116-PARMS-3   TO HOSTVAR-ELEMENT-4      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-FORMAT-CSR00709-CALL.                                       
                                                                        
           MOVE VO-SERV-ORDER-NO TO SERV-ORDER-NO-0709.                 
           MOVE WORK-AREA-1116   TO WORK-AREA-ID-0709.                  
P00718     MOVE BUSINESS-UNIT-1116 TO BUSINESS-UNIT-0709.               
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3110-CALL-CSR00709.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00709                                             
      *            (:SERV-ORDER-NO-0709,                                
      *             :WORK-AREA-ID-0709,                                 
P00718*             :BUSINESS-UNIT-0709)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0709
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0709
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0709 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3110'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00709'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-2             
              MOVE WORK-AREA-ID-0709     TO HOSTVAR-ELEMENT-2           
P00718        MOVE 'BUSINESS_UNIT'       TO TABLE-ELEMENT-3             
P00718        MOVE BUSINESS-UNIT-0709    TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0709)                                                
      *       WITH PROCEDURE CSR00709                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0709 CURSOR FOR RESULT SET        
      *       :LOC0709                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_0709 INTO                           
                   :RETURN-CODE-0709                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3110'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00709'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
                   MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-2        
                   MOVE WORK-AREA-ID-0709     TO HOSTVAR-ELEMENT-2      
P00718             MOVE 'BUSINESS_UNIT'       TO TABLE-ELEMENT-3        
P00718             MOVE BUSINESS-UNIT-0709    TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-FORMAT-CSR00425-CALL.                                       
                                                                        
           MOVE VO-SERV-ORDER-NO           TO SERV-ORDER-NO-0425.       
           MOVE 'E'                        TO REMARK-TYPE-CD-0425.      
           MOVE WS-REMARK-TX               TO EF-REMARK-TX-TEXT.        
           MOVE LENGTH OF WS-REMARK-TX     TO EF-REMARK-TX-LEN.         
           MOVE WS-USER-ID                 TO USER-ID-0425.             
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3210-CALL-CSR00425.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00425                                             
      *            (:SERV-ORDER-NO-0425,                                
      *             :REMARK-TYPE-CD-0425,                               
      *             :EF-REMARK-TX,                                      
      *             :USER-ID-0425)                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0425
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0425
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0425 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00425'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0425    TO HOSTVAR-ELEMENT-1           
              MOVE 'REMARK_TYPE_CD'      TO TABLE-ELEMENT-2             
              MOVE REMARK-TYPE-CD-0425   TO HOSTVAR-ELEMENT-2           
              MOVE 'REMARK_TX'           TO TABLE-ELEMENT-3             
              MOVE WS-REMARK-TX          TO HOSTVAR-ELEMENT-3           
              MOVE 'USER_ID'             TO TABLE-ELEMENT-4             
              MOVE USER-ID-0425          TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0425)                                                
      *       WITH PROCEDURE CSR00425                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0425 CURSOR FOR RESULT SET        
      *       :LOC0425                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_0425 INTO                           
                   :RETURN-CODE-0425                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00425'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0425    TO HOSTVAR-ELEMENT-1      
                   MOVE 'REMARK_TYPE_CD'      TO TABLE-ELEMENT-2        
                   MOVE REMARK-TYPE-CD-0425   TO HOSTVAR-ELEMENT-2      
                   MOVE 'REMARK_TX'           TO TABLE-ELEMENT-3        
                   MOVE WS-REMARK-TX          TO HOSTVAR-ELEMENT-3      
                   MOVE 'USER_ID'             TO TABLE-ELEMENT-4        
                   MOVE USER-ID-0425          TO HOSTVAR-ELEMENT-4      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3210-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT230 3300-FORMAT-CSR04675-CALL.                                       
                                                                        
ACT230     MOVE 0                TO IN-ITEM-ID-4675.                    
ACT230     MOVE '5'              TO ROUTING-CATEGORY-4675.              
ACT230     MOVE WS-USER-ID       TO USER-ID-ORIG-4675.                  
ACT230     MOVE VO-ACCOUNT-NO    TO ACCOUNT-NO-4675.                    
ACT230     MOVE VO-PREMISE-NO    TO PREMISE-NO-4675.                    
           PERFORM 7060-SELECT-ACCOUNT THRU 7060-EXIT.                  
ACT230     MOVE AT-CUSTOMER-NO   TO CUSTOMER-NO-4675.                   
ACT230     MOVE VO-SERV-ORDER-NO TO SERV-ORDER-NO-4675.                 
ACT230     MOVE 'CSR04251'       TO CREATED-BY-4675.                    
                                                                        
           STRING 'VERIFY/CORRECT WORK AREA: ' DELIMITED BY SIZE        
                  'PANEL-'                     DELIMITED BY SIZE        
                  WS-PANEL-NO                  DELIMITED BY SIZE        
                  ', SO#-'                     DELIMITED BY SIZE        
                  PARM-SERV-ORDER-NO           DELIMITED BY SIZE        
                  ', WKAREA-'                  DELIMITED BY SIZE        
                  WS-ORIG-WORK-AREA-TX         DELIMITED BY '  '        
                  ', LOCOFF-'                  DELIMITED BY SIZE        
                  LOCAL-OFFICE-1116            DELIMITED BY SIZE        
                  ', ZIPCD-'                   DELIMITED BY SIZE        
                  ZIP-CODE-1116                DELIMITED BY SIZE        
                  ', RDRTE-'                   DELIMITED BY SIZE        
                  READ-ROUTE-1116              DELIMITED BY SIZE        
                  ', PTID-'                    DELIMITED BY SIZE        
                  POINT-ID-1116                DELIMITED BY SIZE        
                  ', CRAWLIND-'                DELIMITED BY SIZE        
                  CRAWL-IND-1116               DELIMITED BY SPACES      
                  ', UTLTYPS-'                 DELIMITED BY SIZE        
                  CODE-UTIL-TYPE-1116          DELIMITED BY SPACES      
                  ', WKTYPS-'                  DELIMITED BY SIZE        
                  WORK-TYPE-CD-1116            DELIMITED BY SPACES      
                  ', METERINDS - '             DELIMITED BY SIZE        
                  METER-IND-1116               DELIMITED BY SPACES      
ACT230                                         INTO COMMENTS-4675-TEXT. 
ACT230     MOVE 250              TO COMMENTS-4675-LEN.                  
ACT230     MOVE 'N'              TO WQ-PRIORITY-4675.                   
ACT230     MOVE SPACES           TO LOCAL-OFFICE-4675                   
ACT230                              USER-ID-ASGN-4675                   
ACT230                              RESP-AREA-ID-4675                   
ACT230                              DATE-REQUIRED-4675                  
ACT230                              DATE-CREATED-4675                   
ACT230                              FREE-FORM-DATA-4675.                
ACT230     MOVE 0                TO FREE-FORM-DATA-4675-LEN.            
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT230 3310-CALL-CSR04675.                                              
                                                                        
      *    EXEC SQL                                                     
ACT230*       CALL CSR04675                                             
ACT230*           (:IN-ITEM-ID-4675,                                    
ACT230*            :ROUTING-CATEGORY-4675,                              
ACT230*            :LOCAL-OFFICE-4675,                                  
ACT230*            :USER-ID-ORIG-4675,                                  
ACT230*            :USER-ID-ASGN-4675,                                  
ACT230*            :RESP-AREA-ID-4675,                                  
ACT230*            :CATEGORY-ID-4675,                                   
ACT230*            :ACCOUNT-NO-4675,                                    
ACT230*            :PREMISE-NO-4675,                                    
ACT230*            :CUSTOMER-NO-4675,                                   
ACT230*            :SERV-ORDER-NO-4675,                                 
ACT230*            :COMMENTS-4675,                                      
ACT230*            :DATE-REQUIRED-4675,                                 
ACT230*            :DATE-CREATED-4675,                                  
ACT230*            :WQ-PRIORITY-4675,                                   
ACT230*            :FREE-FORM-DATA-4675,                                
ACT230*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3310'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT230        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
ACT230        MOVE SERV-ORDER-NO-4675    TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT230        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              MOVE 'CATEGORY_ID'         TO TABLE-ELEMENT-3             
ACT230        MOVE CATEGORY-ID-4675      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT230*       (:LOC4675)                                                
ACT230*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT230*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT230*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT230         FETCH RESULT_SET_CSR_4675 INTO                           
ACT230             :RETURN-CODE-4675,                                   
ACT230             :OUT-ITEM-ID-4675                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3310'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT230             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
ACT230             MOVE SERV-ORDER-NO-4675    TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT230             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   MOVE 'CATEGORY_ID'         TO TABLE-ELEMENT-3        
ACT230             MOVE CATEGORY-ID-4675      TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       3310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
               SELECT VO.COMPANY_NO                                     
                     ,VO.ORDER_TYPE_CD                                  
                     ,VO.WORK_AREA_ID                                   
                     ,VO.LOCAL_OFFICE                                   
                     ,VO.ACCOUNT_NO                                     
                     ,VO.ACCOUNT_NO_PRIOR                               
                     ,VO.PREMISE_NO                                     
                INTO :VO-COMPANY-NO                                     
                    ,:VO-ORDER-TYPE-CD                                  
                    ,:VO-WORK-AREA-ID                                   
                    ,:VO-LOCAL-OFFICE                                   
                    ,:VO-ACCOUNT-NO                                     
                    ,:VO-ACCOUNT-NO-PRIOR                               
                    ,:VO-PREMISE-NO                                     
                FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                       
               WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02321900
MFA-TR*        SELECT VO.COMPANY_NO                                     02322000
MFA-TR*              ,VO.ORDER_TYPE_CD                                  02322100
MFA-TR*              ,VO.WORK_AREA_ID                                   02323000
MFA-TR*              ,VO.LOCAL_OFFICE                                   02330000
MFA-TR*              ,VO.ACCOUNT_NO                                     02330100
MFA-TR*              ,VO.ACCOUNT_NO_PRIOR                               02331000
MFA-TR*              ,VO.PREMISE_NO                                     02332000
MFA-TR*         INTO :VO-COMPANY-NO                                     02340000
MFA-TR*             ,:VO-ORDER-TYPE-CD                                  02341000
MFA-TR*             ,:VO-WORK-AREA-ID                                   02350000
MFA-TR*             ,:VO-LOCAL-OFFICE                                   02360000
MFA-TR*             ,:VO-ACCOUNT-NO                                     02360100
MFA-TR*             ,:VO-ACCOUNT-NO-PRIOR                               02361000
MFA-TR*             ,:VO-PREMISE-NO                                     02362000
MFA-TR*         FROM CSS_SO_DATA VO                                     02370000
MFA-TR*        WHERE VO.SERV_ORDER_NO = :VO-SERV-ORDER-NO               02380000
MFA-TR*        WITH UR                                                  02390000
MFA-TR*    END-EXEC.                                                    02400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-ORDER-TYPE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT C2.ORDER_GROUP_CD                                  
                INTO :C2-ORDER-GROUP-CD                                 
                FROM CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED)                    
               WHERE C2.COMPANY_NO = :VO-COMPANY-NO                     
                 AND C2.ORDER_TYPE_CD = :VO-ORDER-TYPE-CD               
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02620000
MFA-TR*       SELECT C2.ORDER_GROUP_CD                                  02630000
MFA-TR*         INTO :C2-ORDER-GROUP-CD                                 02640000
MFA-TR*         FROM CSS_ORDER_TYPE C2                                  02650000
MFA-TR*        WHERE C2.COMPANY_NO = :VO-COMPANY-NO                     02660000
MFA-TR*          AND C2.ORDER_TYPE_CD = :VO-ORDER-TYPE-CD               02670000
MFA-TR*        WITH UR                                                  02671000
MFA-TR*    END-EXEC.                                                    02680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ORDER_TYPE'      TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE VO-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ORDER_TYPE_CD'       TO TABLE-ELEMENT-2             
              MOVE VO-ORDER-TYPE-CD      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-GET-READ-ROUTE.                                             
            EXEC SQL                                                    
                SELECT TOP(1) UT.READ_ROUTE                                    
                  INTO :UT-READ-ROUTE                                   
                  FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                 WHERE UT.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR             
                   AND UT.READ_ROUTE > 0                                
                                                 
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    02884700
MFA-TR*         SELECT UT.READ_ROUTE                                    02884800
MFA-TR*           INTO :UT-READ-ROUTE                                   02884900
MFA-TR*           FROM CSS_UTIL_ENVRNMT UT                              02885000
MFA-TR*          WHERE UT.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR             02885100
MFA-TR*            AND UT.READ_ROUTE > 0                                02885200
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                02885300
MFA-TR*          WITH UR                                                02885400
MFA-TR*     END-EXEC.                                                   02885500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            EVALUATE WS-ACTIVE-RETURN-CODE                              
                WHEN SUCCESSFUL-CALL                                    
                    MOVE UT-READ-ROUTE       TO WS-READ-ROUTE-NUM       
                WHEN NOT-FOUND                                          
                    MOVE ZEROES              TO WS-READ-ROUTE-NUM       
                WHEN OTHER                                              
                     MOVE PROGRAM-NAME       TO ABEND-PROGRAM           
                     MOVE '7020'             TO ACTIVE-PARAGRAPH        
                     MOVE 'SELECT'           TO ABEND-FUNCTION          
                     MOVE SPACES             TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                 
                    MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1         
                    MOVE VO-ACCOUNT-NO-PRIOR TO HOSTVAR-ELEMENT-1       
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
            END-EVALUATE.                                               
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-GET-POINT-ID.                                               
           EXEC SQL                                                     
               SELECT TOP(1) GIS_POINT_ID                                      
                 INTO :MN-GIS-POINT-ID                                  
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
                WHERE MN.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR              
                  AND MN.GIS_POINT_ID > 0                               
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02888100
MFA-TR*        SELECT GIS_POINT_ID                                      02888200
MFA-TR*          INTO :MN-GIS-POINT-ID                                  02888300
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN                               02888400
MFA-TR*         WHERE MN.ACCOUNT_NO = :VO-ACCOUNT-NO-PRIOR              02888500
MFA-TR*           AND MN.GIS_POINT_ID > 0                               02888600
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                 02888700
MFA-TR*         WITH UR                                                 02888800
MFA-TR*    END-EXEC.                                                    02888900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE MN-GIS-POINT-ID     TO WS-POINT-ID              
               WHEN NOT-FOUND                                           
                   MOVE SPACES              TO WS-POINT-ID              
               WHEN OTHER                                               
                   MOVE                                                 
                   PROGRAM-NAME             TO ABEND-PROGRAM            
                   MOVE '7030'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                              ABEND-TABLES              
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-ACCOUNT-NO-PRIOR TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-GET-ZIP-CODE.                                               
                                                                        
           EXEC SQL                                                     
             SELECT DY.ZIP_CODE                                         
              INTO  :DY-ZIP-CODE                                        
               FROM CSS_PREMISE PR                                      
                   ,CSS_ADDR_FORMATTED DY                               
              WHERE PR.PREMISE_NO   = :VO-PREMISE-NO                    
                AND PR.ADDRESS_ID   = DY.ADDRESS_ID                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7040'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-2                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE VO-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-GET-WORK-AREA-DESC.                                         
                                                                        
           EXEC SQL                                                     
             SELECT RTRIM(I2.WORK_AREA_TX)                              
               INTO :WS-ORIG-WORK-AREA-TX                               
               FROM CSS_WORK_AREA I2                                    
              WHERE I2.WORK_AREA_ID = :WS-ORIG-WORK-AREA                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02894900
MFA-TR*      SELECT RTRIM(I2.WORK_AREA_TX)                              02895000
MFA-TR*        INTO :WS-ORIG-WORK-AREA-TX                               02895100
MFA-TR*        FROM CSS_WORK_AREA I2                                    02895200
MFA-TR*       WHERE I2.WORK_AREA_ID = :WS-ORIG-WORK-AREA                02895300
MFA-TR*    END-EXEC.                                                    02895400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-ORIG-WORK-AREA-TX  TO RS-OLD-WORK-AREA-TX         
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_WORK_AREA'       TO TABLE-1                     
              MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-1             
              MOVE WS-ORIG-WORK-AREA     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT AT.CUSTOMER_NO                                      
              INTO  :AT-CUSTOMER-NO                                     
               FROM CSS_ACCOUNT AT                                      
              WHERE AT.ACCOUNT_NO = :VO-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE VO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-WORK-TYPE-METER.                                       
                                                                        
           EXEC SQL                                                     
               OPEN WORK-TYPE                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_ORDER_INST'     TO TABLE-1                  
               MOVE 'CSS_MTR_USAGE_VALS'    TO TABLE-2                  
               MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1          
               MOVE VO-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7210-FETCH-WORK-TYPE-METER.                                      
                                                                        
           EXEC SQL                                                     
               FETCH WORK-TYPE                                          
               INTO :WS-CODE-UTIL-TYPE                                  
                   ,:WS-WORK-TYPE-CD                                    
                   ,:WS-METER-IND                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 IF WS-WORK-TYPE-CD NOT = SPACES THEN                   
                    STRING WS-CODE-UTIL-TYPE DELIMITED BY SIZE          
                        INTO WS-CODE-UTIL-TYPES                         
                        WITH POINTER WS-POINTER-1                       
                    STRING WS-WORK-TYPE-CD DELIMITED BY SIZE            
                        INTO WS-WORK-TYPES                              
                        WITH POINTER WS-POINTER-2                       
                    STRING WS-METER-IND DELIMITED BY SIZE               
                        INTO WS-METER-INDICATORS                        
                        WITH POINTER WS-POINTER-3                       
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 GO TO 7210-EXIT                                        
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7210'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'FETCH'                 TO ABEND-FUNCTION         
                 MOVE SPACES                  TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                 MOVE 'CSS_SO_ORDER_INST'     TO TABLE-1                
                 MOVE 'CSS_MTR_USAGE_VALS'    TO TABLE-2                
                 MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1        
                 MOVE VO-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1      
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-WORK-TYPE-METER.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE WORK-TYPE                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7220'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_ORDER_INST'     TO TABLE-1                  
               MOVE 'CSS_MTR_USAGE_VALS'    TO TABLE-2                  
               MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1          
               MOVE VO-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7300-GET-WORK-TYPE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT VI.WORK_TYPE_CD                                   
                     ,VI.CODE_UTIL_TYPE                                 
                 INTO :WS-WORK-TYPE-CD                                  
                     ,:WS-CODE-UTIL-TYPE                                
                 FROM CSS_SO_ORDER_INST VI                              
               WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_ORDER_INST'     TO TABLE-1                  
               MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1          
               MOVE VO-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-LOCOFF-WORK-CD.                                         
                                                                        
           EXEC SQL                                                     
              SELECT B1.SERV_ORDER_WORK_CD                              
                INTO :B1-SERV-ORDER-WORK-CD                             
                FROM CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE B1.COMPANY_NO   = :VO-COMPANY-NO                   
                 AND B1.LOCAL_OFFICE = :VO-LOCAL-OFFICE                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03032100
MFA-TR*       SELECT B1.SERV_ORDER_WORK_CD                              03032200
MFA-TR*         INTO :B1-SERV-ORDER-WORK-CD                             03032300
MFA-TR*         FROM CSS_LOCAL_OFFICE B1                                03032400
MFA-TR*        WHERE B1.COMPANY_NO   = :VO-COMPANY-NO                   03032500
MFA-TR*          AND B1.LOCAL_OFFICE = :VO-LOCAL-OFFICE                 03032600
MFA-TR*        WITH UR                                                  03032700
MFA-TR*    END-EXEC.                                                    03032800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE B1-SERV-ORDER-WORK-CD TO WS-SERV-ORDER-WORK-CD      
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_LOCAL_OFFICE'    TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE VO-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-2             
              MOVE VO-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-GET-CRAWL-IND.                                              
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-CRAWL-IND                                      
              FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED)                    
                  ,CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                   
                  ,CSS_SO_DATA  VO WITH(READUNCOMMITTED)                        
              WHERE VQ.SERV_ORDER_NO =   :VO-SERV-ORDER-NO              
                AND VQ.SERV_ORDER_NO = VO.SERV_ORDER_NO                 
                AND VQ.APPLIANCE_CD = JA.APPLIANCE_CD                   
                AND JA.CIS_DISPLAY_FL = 'Y'                             
                AND JA.COMPANY_NO = VO.COMPANY_NO                       
                AND JA.CRAWL_FL = 'Y'                                   
                AND ( VQ.LEAK_IND = 'Y' OR                              
                      VQ.LIGHT_IND = 'Y' OR                             
                      VQ.REPAIR_IND = 'Y' OR                            
                      VQ.INSTALL_IND = 'Y')                             
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03039000
MFA-TR*       SELECT 'Y'                                                03039100
MFA-TR*         INTO :WS-CRAWL-IND                                      03039200
MFA-TR*       FROM CSS_SO_APPLIANCE VQ                                  03039300
MFA-TR*           ,CSS_MKT_APPLIANCE JA                                 03039400
MFA-TR*           ,CSS_SO_DATA  VO                                      03039500
MFA-TR*       WHERE VQ.SERV_ORDER_NO =   :VO-SERV-ORDER-NO              03039600
MFA-TR*         AND VQ.SERV_ORDER_NO = VO.SERV_ORDER_NO                 03039700
MFA-TR*         AND VQ.APPLIANCE_CD = JA.APPLIANCE_CD                   03039800
MFA-TR*         AND JA.CIS_DISPLAY_FL = 'Y'                             03039900
MFA-TR*         AND JA.COMPANY_NO = VO.COMPANY_NO                       03040000
MFA-TR*         AND JA.CRAWL_FL = 'Y'                                   03040100
MFA-TR*         AND ( VQ.LEAK_IND = 'Y' OR                              03040200
MFA-TR*               VQ.LIGHT_IND = 'Y' OR                             03040300
MFA-TR*               VQ.REPAIR_IND = 'Y' OR                            03040400
MFA-TR*               VQ.INSTALL_IND = 'Y')                             03040500
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   03040600
MFA-TR*       WITH UR                                                   03041000
MFA-TR*    END-EXEC.                                                    03041100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N'                TO WS-CRAWL-IND                
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7410'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_SO_APPLIANCE'    TO TABLE-1                  
                 MOVE 'CSS_MKT_APPLIANCE'   TO TABLE-2                  
                 MOVE 'CSS_SO_DATA'         TO TABLE-3                  
                 MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1          
                 MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     03044000
              INCLUDE CPDSP300                                          03050000
           END-EXEC.                                                    03060000
                                                                        
           EXEC SQL                                                     03080000
               INCLUDE CPD00331                                         03090000
           END-EXEC.                                                    03100000
                                                                        
