       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04250.                                     
COB303 DATE-WRITTEN.     JULY 10, 2008.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04250              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04250 :                                                --         
      *--                                                            --         
      *--  #  UPDATES EDI HEADER STATUS TO RECONCILED FROM BIZ TALK. --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--   ACCOUNT_NO            CHAR(13)                                      
      *--   BILL_NO               INTEGER                                       
      *--                                                            --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  10 JUL 2008   RS40309     NEW CODE                        --         
ACT135*--  04 MAY 2016   MR7E794     ADD USERID AS EBILCSR/EBILSEB   --         
ACT135*--                A05460      INSTEAD OF SQLID.               --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04250'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
      * SQL COMMUNICATION AREA                                                  
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT - AT                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      * CSS_EDI_BILL_HDR - HZ                                                   
           EXEC SQL                                                             
              INCLUDE TBBILHDR                                                  
           END-EXEC.                                                            
                                                                        
ACT135******************************************************************        
ACT135*   CSS_DELINQUENCY - C8                                                  
ACT135******************************************************************        
ACT135     EXEC SQL                                                             
ACT135        INCLUDE TBDELQ                                                    
ACT135     END-EXEC.                                                            
ACT135*                                                                         
      *                                                                         
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04250'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR04250_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
ACT135 01  WS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           10 S-ERROR-MSG            PIC X(07) VALUE SPACES.            
      *                                                                         
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
           05  WS-PARM-ACCOUNT-NO      PIC 9(13) VALUE ZERO.            
           05  WS-AMT-DUE              PIC 9(11)V9(2) VALUE 0.          
           05  WS-BILLED-AM            PIC 9(09)V9(2) VALUE 0.          
           05  WS-AMT-DUE-T            PIC 9(13) VALUE 0.               
           05  WS-BILLED-AM-T          PIC 9(11) VALUE 0.               
           05  WS-MST-ACCT-NO          PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO           PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-STATUS-CD-L          PIC X(01) VALUE SPACES.          
           05  WS-STATUS-CD-H          PIC X(01) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-L      PIC X(10) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-H      PIC X(10) VALUE SPACES.          
           05  WS-SCHED-DT-NULL        PIC S9(04) COMP VALUE +0.        
           05  WS-DATE-READ-NULL       PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
           05  WS-SEQ-NULL             PIC S9(04) COMP VALUE +0.        
           05  WS-BILL-NULL            PIC S9(04) COMP VALUE +0.        
           05  WS-MAX-SEQ-NO           PIC S9(04) COMP VALUE +0.        
           05  WS-MAX-BILL-NO          PIC S9(08) COMP VALUE +0.        
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-USER-ID              PIC X(07) VALUE SPACES.          
           05  WS-PREV-EXT-FL          PIC X(01) VALUE SPACES.          
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  IN-ACCOUNT-NO            PIC X(13).                          
       01  IN-BILL-NO               PIC S9(8) COMP VALUE 0.             
      *                                                                         
       PROCEDURE DIVISION USING IN-ACCOUNT-NO                           
                               ,IN-BILL-NO.                             
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                 :S-RETURN-CODE                                         
                ,:S-ERROR-MSG                                           
               FROM CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                         
               FOR READ ONLY                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE                                                 
MFA-TR*         ,:S-ERROR-MSG                                                   
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
           PERFORM 1500-PROCESS-INPUT         THRU 1500-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1500-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1500-PROCESS-INPUT.                                              
      *                                                                         
           MOVE IN-ACCOUNT-NO            TO WS-PARM-ACCOUNT-NO          
           MOVE WS-PARM-ACCOUNT-NO       TO HZ-ACCOUNT-NO               
           MOVE IN-BILL-NO               TO HZ-BILL-NO                  
           PERFORM 7000-GET-EXISTING-EXT THRU 7000-EXIT.                
           MOVE HZ-EXTRACTED-FL          TO WS-PREV-EXT-FL              
           IF HZ-EXTRACTED-FL = ' '                                     
              PERFORM 7050-SELECT-CURRENT-DATE                          
                                         THRU 7050-EXIT                 
              MOVE 'R'                   TO HZ-EXTRACTED-FL             
              MOVE WS-CURRENT-TIMESTAMP  TO HZ-EXTRACTED-TS             
           ELSE                                                         
              MOVE 100                   TO  S-RETURN-CODE              
              MOVE 'D05050'              TO  S-ERROR-MSG                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF                                                       
ACT135*                                                                 02692000
ACT135     MOVE HZ-ACCOUNT-NO            TO AT-ACCOUNT-NO               
ACT135     PERFORM 7300-GET-ACCOUNT-INFO      THRU 7300-EXIT            
ACT135     MOVE ZERO                     TO WS-DATABASE                 
ACT135     MOVE 'DATABASE'               TO C8-DELINQ-CD                
ACT135     MOVE AT-COMPANY-NO            TO C8-COMPANY-NO               
ACT135     PERFORM 7560-GET-DELINQUENCY-VALUE THRU 7560-EXIT            
ACT135     MOVE C8-DELINQ-VALUE          TO WS-DATABASE                 
ACT135*                                                                 02692000
ACT135     IF CSR-DATABASE                                              
ACT135        MOVE 'EBILCSR'             TO WS-USER-ID                  
ACT135     ELSE                                                         
ACT135        IF SEB-DATABASE                                           
ACT135           MOVE 'EBILSEB'          TO WS-USER-ID                  
ACT135        END-IF                                                    
ACT135     END-IF.                                                      
           PERFORM 8200-UPDATE-HEADER       THRU 8200-EXIT.             
                                                                        
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT  THRU 2200-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
           PERFORM 2300-MOVE-VALUES THRU 2300-EXIT                      
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE NOT-FOUND TO S-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2300-MOVE-VALUES.                                                
      *                                                                         
           MOVE 0                        TO  S-RETURN-CODE              
           MOVE SPACES                   TO  S-ERROR-MSG                
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      *  9700-PROCESS-ABEND ROUTINE                                 *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
       7000-GET-EXISTING-EXT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT EXTRACTED_FL                                       
                INTO :HZ-EXTRACTED-FL                                   
                FROM CSS_EDI_BILL_HDR WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :HZ-ACCOUNT-NO                        
               AND   BILL_NO    = :HZ-BILL-NO                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EXTRACTED_FL                                               
MFA-TR*         INTO :HZ-EXTRACTED-FL                                           
MFA-TR*         FROM CSS_EDI_BILL_HDR                                           
MFA-TR*        WHERE ACCOUNT_NO = :HZ-ACCOUNT-NO                                
MFA-TR*        AND   BILL_NO    = :HZ-BILL-NO                                   
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HZ-BILL-NO           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7050-SELECT-CURRENT-DATE                                    *        
      *       SELECT CURRENT DATE FROM CSS_MODEL_SQL                   *        
      ******************************************************************        
                                                                        
       7050-SELECT-CURRENT-DATE.                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET  :WS-CURRENT-DATE  =                                         
MFA-TR*             CURRENT DATE                                                
MFA-TR*            ,:WS-CURRENT-TIMESTAMP =                                     
MFA-TR*             CURRENT TIMESTAMP                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
ACT135*                                                                         
ACT135******************************************************************        
ACT135* 7300-GET-ACCOUNT-INFO                                          *        
ACT135*      CHECK TO MAKE SURE THAT ACCOUNT NO EXISTS                 *        
ACT135******************************************************************        
ACT135 7300-GET-ACCOUNT-INFO.                                           
ACT135                                                                  
ACT135     EXEC SQL                                                     
ACT135         SELECT AT.ACCOUNT_NO                                     
ACT135               ,AT.COMPANY_NO                                     
ACT135           INTO :AT-ACCOUNT-NO                                    
ACT135               ,:AT-COMPANY-NO                                    
ACT135           FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
ACT135          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
ACT135                                                           
ACT135     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*          INTO :AT-ACCOUNT-NO                                            
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT135                                                                  
ACT135     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT135                                                                  
ACT135     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
ACT135        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
ACT135        MOVE '7300'                     TO ACTIVE-PARAGRAPH       
ACT135        MOVE 'SELECT'                   TO ABEND-FUNCTION         
ACT135        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
ACT135                                           ABEND-TABLES           
ACT135        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
ACT135        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
ACT135        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
ACT135        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
ACT135        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
ACT135     END-IF.                                                      
ACT135                                                                  
ACT135 7300-EXIT.                                                       
ACT135      EXIT.                                                       
ACT135*                                                                         
ACT135*                                                                         
ACT135******************************************************************17920000
ACT135*   TO INDENTIFY THE DATABASE.                                   *17930000
ACT135******************************************************************17940000
ACT135*                                                                         
ACT135 7560-GET-DELINQUENCY-VALUE.                                      
ACT135*                                                                 17950000
ACT135     EXEC SQL                                                     
ACT135        SELECT C8.DELINQ_VALUE                                    
ACT135          INTO :C8-DELINQ-VALUE                                   
ACT135        FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                    
ACT135        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                       
ACT135          AND C8.COMPANY_NO = :C8-COMPANY-NO                      
ACT135                                                           
ACT135     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT C8.DELINQ_VALUE                                    17970000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   17980000
MFA-TR*       FROM  CSS_DELINQUENCY C8                                  17990000
MFA-TR*       WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                       18000000
MFA-TR*         AND C8.COMPANY_NO = :C8-COMPANY-NO                      18010000
MFA-TR*       WITH UR                                                   18011000
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT135                                                                  
ACT135     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT135                                                                  
ACT135     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT135        NEXT SENTENCE                                             
ACT135     ELSE                                                         
ACT135        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
ACT135        MOVE '7560'                  TO ACTIVE-PARAGRAPH          
ACT135        MOVE 'SELECT'                TO ABEND-FUNCTION            
ACT135        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
ACT135                                        ABEND-TABLES              
ACT135        MOVE 'CSS_DELINQUENCY'       TO TABLE-1                   
ACT135        MOVE 'DATABASE'              TO TABLE-ELEMENT-1           
ACT135        MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1         
ACT135        MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2           
ACT135        MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2         
ACT135        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
ACT135        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
ACT135     END-IF.                                                      
ACT135                                                                  
ACT135 7560-EXIT.                                                       
ACT135     EXIT.                                                        
ACT135*                                                                 18230000
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-UPDATE-HEADER.                                            *        
      ******************************************************************        
       8200-UPDATE-HEADER.                                              
                                                                        
                                                                        
           EXEC SQL                                                     
                                                                        
               UPDATE CSS_EDI_BILL_HDR                                  
                SET EXTRACTED_FL = :HZ-EXTRACTED-FL                     
                 ,EXTRACTED_TS   = CIS.CURRENT$TIMESTAMP()                    
                 ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                    
ACT135           ,LAST_UPDATE_USERID = :WS-USER-ID                      
                 ,UPDATE_IND     = 'Y'                                  
               WHERE ACCOUNT_NO  = :HZ-ACCOUNT-NO                       
               AND   BILL_NO     = :HZ-BILL-NO                          
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        UPDATE CSS_EDI_BILL_HDR                                          
MFA-TR*         SET EXTRACTED_FL = :HZ-EXTRACTED-FL                             
MFA-TR*          ,EXTRACTED_TS   = CURRENT TIMESTAMP                            
MFA-TR*          ,LAST_UPDATE_TS = CURRENT TIMESTAMP                            
MFA-TR*          ,LAST_UPDATE_USERID = :WS-USER-ID                              
MFA-TR*          ,UPDATE_IND     = 'Y'                                          
MFA-TR*        WHERE ACCOUNT_NO  = :HZ-ACCOUNT-NO                               
MFA-TR*        AND   BILL_NO     = :HZ-BILL-NO                                  
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HZ-BILL-NO           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
                                                                        
               ROLLBACK                                                 
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
***********PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                          
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9100-CHECK-ERROR                                               *        
      ******************************************************************        
       9100-CHECK-ERROR.                                                
           EXIT.                                                        
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
