       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04242.                                         
COB303 DATE-WRITTEN.  FEBRUARY 2009                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED FROM THE SEB REGULATED WEB.          *00100000
      *                                                                *00110000
      ******************************************************************00160000
      *                                                                *00180000
      *  GETS THE DRAFT CYCLE AND DAY FOR SEB REGULATED CUSTOMERS BASED*00190000
      *  ON THE CREDIT GROUP.                                          *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *   02/02/09    LG      PROCEDURE ORIGINALLY CODED.              *00280000
P00836*   04/08/15  GOKUL     CHECK FOR REG_GROUP_CODE, SP WILL BE USED*00280000
P00836*                       BY CSR AND SEB.                          *00280000
      ******************************************************************00630901
      *                                                                *00631001
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00631101
      *                                                                *00631201
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00631301
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00631401
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00631501
      *  3000 - 4999  NOT USED                                         *00631601
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00631701
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00631801
      *  7000 - 7999  INPUT MODULES                                    *00631901
      *  8000 - 8999  OUTPUT MODULES                                   *00632001
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00632101
      *                                                                *00632201
      ******************************************************************00632301
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04242'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04242 STARTS HERE'.                  
                                                                        
      ******************************************************************00810000
      *    WORK AREAS                                                  *00820000
      ******************************************************************00830000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04242'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
P00836     05  WS-01                    PIC X(02) VALUE '01'.           
P00836     05  WS-DATABASE              PIC X(08) VALUE 'DATABASE'.     
P00836     05 WS-DATABASE-SW            PIC 9(01) VALUE 0.              
P00836        88 CSR-DATABASE                     VALUE 1.              
P00836        88 SEB-DATABASE                     VALUE 2.              
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-ACCOUNT-NUM           PIC X(13).                      
           05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NUM     PIC 9(13).    
                                                                        
           05  WS-BILL-CYCLE-TEMP       PIC X(02).                      
           05  WS-BILL-CYCLE REDEFINES WS-BILL-CYCLE-TEMP PIC 9(02).    
           05  WS-FIRST-CYCLE           PIC 9(02).                      
           05  WS-LAST-CYCLE            PIC 9(02).                      
           05  WS-BILL-MAX              PIC S9(02).                     
           05  WS-BILL-MIN              PIC S9(02).                     
           05  WS-MAX-CYCLE-TEMP        PIC 9(02).                      
           05  WS-MAX-CYCLE REDEFINES WS-MAX-CYCLE-TEMP PIC X(02).      
           05  WS-MIN-CYCLE-TEMP        PIC 9(02).                      
           05  WS-MIN-CYCLE REDEFINES WS-MIN-CYCLE-TEMP PIC X(02).      
                                                                        
COB305     05 WS-CURR-REV-MNTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
           05  WS-AND-OR-TYPE           PIC X(1).                       
           05  WS-DRAFT-DAY             PIC S9(9)  COMP VALUE 0.        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE +0.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE +0.        
           05  S-DRAFT-CYCLE            PIC X(02) VALUE SPACE.          
           05  S-DRAFT-DAY              PIC S9(9) COMP  VALUE 0.        
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                PIC X(18)      VALUE SPACES.    
           10  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
           10  S-SQLSTATE               PIC X(5)       VALUE ' '.       
           10  S-TABLE-NAME             PIC X(18)      VALUE SPACES.    
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L   PIC S9(4) USAGE COMP.           
               49  S-HOST-VARIABLES-V   PIC X(255).                     
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L    PIC S9(4) USAGE COMP.           
               49  S-SQL-STATEMENT-V    PIC X(255).                     
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L  PIC S9(4) USAGE COMP.           
               49  S-SQL-DESCRIPTION-V  PIC X(255).                     
                                                                        
           EXEC SQL                                                     03500000
              INCLUDE SQLCA                                             03510000
           END-EXEC.                                                    03520000
                                                                        
      ******************************************************************05140000
      *    DCLGEN FOR CSS_ACCOUNT                                       05141000
      ******************************************************************05142000
           EXEC SQL                                                     03540000
              INCLUDE TBACCT                                            03550000
           END-EXEC.                                                    03560000
                                                                        
      ******************************************************************05140000
      *    DCLGEN FOR CSS_JOB_PARM                                      05141000
      ******************************************************************05142000
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************05140000
      *    DCLGEN FOR CSS_BILL_WINDOW                                   05141000
      ******************************************************************05142000
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************05140000
      *    DCLGEN FOR CSS_CRED_FORECAST                                 05141000
      ******************************************************************05142000
           EXEC SQL                                                             
              INCLUDE TBCRFCST                                                  
           END-EXEC.                                                            
                                                                        
P00836******************************************************************05140000
P00836*    DCLGEN FOR CSS_DELINQUENCY                                   05141000
P00836******************************************************************05142000
P00836     EXEC SQL                                                             
P00836        INCLUDE TBDELQ                                                    
P00836     END-EXEC.                                                            
                                                                        
P00836******************************************************************05140000
P00836*    DCLGEN FOR CSS_REG_PROFILE                                   05141000
P00836******************************************************************05142000
P00836     EXEC SQL                                                             
P00836        INCLUDE TBREGPRF                                                  
P00836     END-EXEC.                                                            
                                                                        
      ******************************************************************05140000
      *    ERROR HANDLING                                               05141000
      ******************************************************************05142000
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******* SQL ERROR CHECKING                                                
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************05140000
      *    CURSOR DECLARATIONS                                          05141000
      ******************************************************************05142000
           EXEC SQL                                                     
               DECLARE DRAFT_DAY_CUR CURSOR FOR                         
                SELECT BILL_CYCLE,                                      
                       MIN(DAY(DATE_EXTRACT))                           
                  FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
                 WHERE ((:WS-AND-OR-TYPE = 'O' AND                      
                       (BILL_CYCLE <= :WS-MIN-CYCLE OR                  
                        BILL_CYCLE >= :WS-MAX-CYCLE))                   
                    OR                                                  
                       (:WS-AND-OR-TYPE <> 'O' AND                      
                       (BILL_CYCLE <= :WS-MIN-CYCLE AND                 
                        BILL_CYCLE >= :WS-MAX-CYCLE ))                  
                       )                                                
                   AND BILL_CYCLE < '22'                                
                   AND (DATE_EXTRACT > CAST(SYSDATETIMEOFFSET() 
           AS DATE))                    
                   AND CIS.INT2DECIMAL(MONTH(DATE_EXTRACT))/100 =               
                       (REVENUE_MONTH/100) - FLOOR(REVENUE_MONTH/100)   
                   AND YEAR(DATE_EXTRACT)  = FLOOR(REVENUE_MONTH/100)   
                 GROUP BY BILL_CYCLE                                    
                 ORDER BY BILL_CYCLE                                    
                   FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DRAFT_DAY_CUR CURSOR FOR                                 
MFA-TR*         SELECT BILL_CYCLE,                                              
MFA-TR*                MIN(DAY(DATE_EXTRACT))                                   
MFA-TR*           FROM CSS_BILL_WINDOW                                          
MFA-TR*          WHERE ((:WS-AND-OR-TYPE = 'O' AND                              
MFA-TR*                (BILL_CYCLE <= :WS-MIN-CYCLE OR                          
MFA-TR*                 BILL_CYCLE >= :WS-MAX-CYCLE))                           
MFA-TR*             OR                                                          
MFA-TR*                (:WS-AND-OR-TYPE <> 'O' AND                              
MFA-TR*                (BILL_CYCLE <= :WS-MIN-CYCLE AND                         
MFA-TR*                 BILL_CYCLE >= :WS-MAX-CYCLE ))                          
MFA-TR*                )                                                        
MFA-TR*            AND BILL_CYCLE < '22'                                        
MFA-TR*            AND (DATE_EXTRACT > CURRENT_DATE)                            
MFA-TR*            AND DECIMAL(MONTH(DATE_EXTRACT))/100 =                       
MFA-TR*                (REVENUE_MONTH/100) - FLOOR(REVENUE_MONTH/100)           
MFA-TR*            AND YEAR(DATE_EXTRACT)  = FLOOR(REVENUE_MONTH/100)           
MFA-TR*          GROUP BY BILL_CYCLE                                            
MFA-TR*          ORDER BY BILL_CYCLE                                            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO              PIC X(13).                      
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO.                       
                                                                        
      ******************************************************************05555000
      * 0000-MAINLINE                                                  *05556000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *05557000
      ******************************************************************05558000
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05555000
      * 0100-INITIALIZE                                                 05556000
      ******************************************************************05558000
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
P00836     MOVE WS-01                        TO C8-COMPANY-NO           
P00836     MOVE WS-DATABASE                  TO C8-DELINQ-CD            
P00836     PERFORM 7070-GET-DELINQ-VALUE     THRU 7070-EXIT             
P00836     MOVE C8-DELINQ-VALUE              TO WS-DATABASE-SW          
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                 SELECT RETURN_CODE,                                    
                        DRAFT_CYCLE,                                    
                        DRAFT_DATE                                      
                   FROM #CSR04242_R1                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*          SELECT RETURN_CODE,                                            
MFA-TR*                 DRAFT_CYCLE,                                            
MFA-TR*                 DRAFT_DATE                                              
MFA-TR*            FROM SESSION.CSR04242_R1                                     
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05555000
      * 0100A-DECLARE-GTT.                                              05556000
      ******************************************************************05558000
       0100A-DECLARE-GTT.                                               
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04242_R1'            
                                            TO S-SQL-STATEMENT-V.       
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04242_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04242_R1
              (  RETURN_CODE                 INT                   
                 ,DRAFT_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,DRAFT_DATE                  INT                   
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                  NEXT SENTENCE                                         
              ELSE                                                      
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04242_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************05980000
      * 1000-PROCESS-INPUT.                                            *05990000
      ******************************************************************06030000
       1000-PROCESS-INPUT.                                              
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NUM.          
           MOVE WS-ACCOUNT-NUM              TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO               TO AT-ACCOUNT-NO.           
                                                                        
           MOVE 1                           TO WS-FIRST-CYCLE.          
           MOVE 21                          TO WS-LAST-CYCLE.           
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10970000
      * 2000-PROCESS-OUTPUT.                                           *10980000
      ******************************************************************11050000
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7000-SELECT-ACCT         THRU 7000-EXIT.             
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL) AND             
                 (AT-BILL-CYCLE > '00' AND AT-BILL-CYCLE < '22')        
              PERFORM 2200-PROCESS          THRU 2200-EXIT              
           ELSE                                                         
              MOVE 100                      TO RS-RETURN-CODE,          
                                               S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000A-MOVE-RESULT.                                            *         
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
           MOVE  RS-RETURN-CODE             TO S-RETURN-CODE.           
           MOVE  BN-BILL-CYCLE              TO S-DRAFT-CYCLE.           
           MOVE  WS-DRAFT-DAY               TO S-DRAFT-DAY.             
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2200-PROCESS.                                                           
      *****************************************************************         
       2200-PROCESS.                                                    
           MOVE AT-BILL-CYCLE               TO WS-BILL-CYCLE-TEMP.      
           MOVE WS-BILL-CYCLE-TEMP          TO WS-BILL-CYCLE.           
           MOVE AT-BILL-CYCLE               TO CM-BILL-CYCLE.           
           PERFORM 2300-GET-MIN-CYCLE       THRU 2300-EXIT.             
           PERFORM 2400-GET-MAX-CYCLE       THRU 2400-EXIT.             
           IF WS-MIN-CYCLE < WS-MAX-CYCLE                               
              MOVE 'O'                      TO WS-AND-OR-TYPE           
           ELSE                                                         
              MOVE 'A'                      TO WS-AND-OR-TYPE           
           END-IF.                                                      
                                                                        
           PERFORM 7500-DRAFT-CYCLE-DAYS    THRU 7500-EXIT.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *2300-GET-MIN-CYCLE.                                                      
      * FOR BALANCE GROUP, GET THE MIN-CYCLE FROM CSS_BILL_WINDOW               
      * FOR OTHERS, IT IS CURRENT-CYCLE - 2.                                    
      *****************************************************************         
       2300-GET-MIN-CYCLE.                                              
P00836     MOVE SPACES                      TO LR-REG-GROUP-CD.         
P00836     IF SEB-DATABASE                                              
P00836        PERFORM 7050-SELECT-REG-PROFILE                           
P00836                                      THRU 7050-EXIT              
P00836     END-IF.                                                      
P00836     IF AT-CREDIT-GROUP = 'B' AND LR-REG-GROUP-CD > SPACES        
              PERFORM 7100-GET-CURR-REVMNTH THRU 7100-EXIT              
              PERFORM 7200-GET-DUEDT-CYCLE  THRU 7200-EXIT              
           ELSE                                                         
              COMPUTE WS-BILL-MIN = WS-BILL-CYCLE - 2                   
              IF WS-BILL-MIN <= 0                                       
                 COMPUTE WS-BILL-MIN = WS-BILL-CYCLE - 2 + WS-LAST-CYCLE
              END-IF                                                    
                                                                        
              MOVE WS-BILL-MIN              TO WS-MIN-CYCLE-TEMP        
              MOVE WS-MIN-CYCLE-TEMP        TO WS-MIN-CYCLE             
              IF LENGTH OF WS-MIN-CYCLE EQUAL 1                         
                 STRING '0', WS-MIN-CYCLE DELIMITED SIZE                
                                            INTO WS-MIN-CYCLE           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2400-GET-MAX-CYCLE.                                                     
      * MAX-CYCLE IS CURRENT-CYCLE + 5                                          
      *****************************************************************         
       2400-GET-MAX-CYCLE.                                              
           COMPUTE WS-BILL-MAX = WS-BILL-CYCLE + 5                      
           IF WS-BILL-MAX > WS-LAST-CYCLE                               
              COMPUTE WS-BILL-MAX = WS-BILL-MAX - WS-LAST-CYCLE         
           END-IF.                                                      
                                                                        
           MOVE WS-BILL-MAX                 TO WS-MAX-CYCLE-TEMP        
           MOVE WS-MAX-CYCLE-TEMP           TO WS-MAX-CYCLE.            
           IF LENGTH OF WS-MAX-CYCLE = 1                                
              STRING '0', WS-MAX-CYCLE DELIMITED SIZE INTO WS-MAX-CYCLE 
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-SELECT-ACCT.                                                       
      *****************************************************************         
       7000-SELECT-ACCT.                                                
           EXEC SQL                                                     
              SELECT AT.BILL_CYCLE,                                     
                     AT.CREDIT_GROUP                                    
                INTO :AT-BILL-CYCLE,                                    
                     :AT-CREDIT-GROUP                                   
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25890000
MFA-TR*       SELECT AT.BILL_CYCLE,                                     25900000
MFA-TR*              AT.CREDIT_GROUP                                    25910000
MFA-TR*         INTO :AT-BILL-CYCLE,                                    26140000
MFA-TR*              :AT-CREDIT-GROUP                                   26150000
MFA-TR*         FROM CSS_ACCOUNT AT                                     26380000
MFA-TR*        WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    26390000
MFA-TR*         WITH UR                                                 26410000
MFA-TR*    END-EXEC.                                                    26420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* SELECTS REG GROUP CODE.                                       * 00226600
P00836*****************************************************************         
P00836 7050-SELECT-REG-PROFILE.                                         
P00836     EXEC SQL                                                     
P00836        SELECT REG_GROUP_CD                                       
P00836          INTO :LR-REG-GROUP-CD                                   
P00836          FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
P00836         WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
P00836                                                           
P00836                                                      
P00836     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00226900
MFA-TR*       SELECT REG_GROUP_CD                                       00227000
MFA-TR*         INTO :LR-REG-GROUP-CD                                   00227100
MFA-TR*         FROM CSS_REG_PROFILE                                    00227200
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   00227300
MFA-TR*         WITH UR                                                 00227400
MFA-TR*      QUERYNO 7050                                               00227500
MFA-TR*    END-EXEC                                                     00227600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00836        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00836        MOVE '7050'                TO ACTIVE-PARAGRAPH            
P00836        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00836        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836        MOVE 'CSS_REG_PROFILE'     TO TABLE-1                     
P00836        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00836        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00836        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00836        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00836     END-IF                                                       
P00836     .                                                            
P00836 7050-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* SELECTS DELINQUENCY VALUE FOR GIVEN DELINQUENCY CODE          * 24260000
P00836*****************************************************************         
P00836                                                                  
P00836 7070-GET-DELINQ-VALUE.                                           
P00836                                                                  
P00836     EXEC SQL                                                     
P00836       SELECT DELINQ_VALUE                                        
P00836         INTO :C8-DELINQ-VALUE                                    
P00836         FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
P00836        WHERE DELINQ_CD  = :C8-DELINQ-CD                          
P00836          AND COMPANY_NO = :C8-COMPANY-NO                         
P00836                                                           
P00836                                                      
P00836     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24310000
MFA-TR*      SELECT DELINQ_VALUE                                        24320000
MFA-TR*        INTO :C8-DELINQ-VALUE                                    24330000
MFA-TR*        FROM CSS_DELINQUENCY                                     24340000
MFA-TR*       WHERE DELINQ_CD  = :C8-DELINQ-CD                          24350000
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                         24360000
MFA-TR*        WITH UR                                                  24362000
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC                                                     24370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00836        CONTINUE                                                  
P00836     ELSE                                                         
P00836        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00836        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00836        MOVE '7070'                TO ACTIVE-PARAGRAPH            
P00836        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00836        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836        MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
P00836        MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
P00836        MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
P00836        MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
P00836        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
P00836        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00836        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00836     END-IF                                                       
P00836     .                                                            
P00836 7070-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7100-GET-CURR-REVMNTH.                                                  
      * GET CURRENT REVENUE MONTH.                                              
      *****************************************************************         
       7100-GET-CURR-REVMNTH.                                           
           EXEC SQL                                                     
               SELECT CIS.CHAR2DECIMAL(CIS.SUBSTR3(PARM_DATA,15,6))             
                 INTO :WS-CURR-REV-MNTH                                 
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND COMPANY_NO   = '01'                               
                  AND CMND_CODE    = 'DATE'                             
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     26750000
MFA-TR*        SELECT DECIMAL(SUBSTR(PARM_DATA,15,6))                           
MFA-TR*          INTO :WS-CURR-REV-MNTH                                         
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                                   
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           AND CMND_CODE    = 'DATE'                                     
MFA-TR*           AND SEQ_NO       = 20                                         
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    26820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-GET-DUEDT-CYCLE.                                                   
      * GET THE MAXIMUM CYCLE THAT CORRESPONDS TO THE DUE DATE.                 
      *****************************************************************         
       7200-GET-DUEDT-CYCLE.                                            
           EXEC SQL                                                     
               SELECT MAX(BN.BILL_CYCLE)                                
                 INTO :WS-MIN-CYCLE                                     
                 FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                WHERE BN.DATE_EXTRACT = (SELECT MIN(CURR_CHG_DUE_DT)    
                                 FROM CSS_CRED_FORECAST
                           WITH(READUNCOMMITTED)                 
                                WHERE REVENUE_MONTH = :WS-CURR-REV-MNTH 
                                  AND BILL_CYCLE    = :CM-BILL-CYCLE    
                                  AND CRED_FORECAST_CD = 'A'            
                                  AND COMPANY_NO    = '01')             
                  AND BN.REVENUE_MONTH = (SELECT MAX(REVENUE_MONTH)     
                                 FROM CSS_BILL_WINDOW
                           WITH(READUNCOMMITTED)                   
                                WHERE DATE_EXTRACT = BN.DATE_EXTRACT)   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26750000
MFA-TR*        SELECT MAX(BN.BILL_CYCLE)                                        
MFA-TR*          INTO :WS-MIN-CYCLE                                             
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.DATE_EXTRACT = (SELECT MIN(CURR_CHG_DUE_DT)            
MFA-TR*                          FROM CSS_CRED_FORECAST                         
MFA-TR*                         WHERE REVENUE_MONTH = :WS-CURR-REV-MNTH         
MFA-TR*                           AND BILL_CYCLE    = :CM-BILL-CYCLE            
MFA-TR*                           AND CRED_FORECAST_CD = 'A'                    
MFA-TR*                           AND COMPANY_NO    = '01')                     
MFA-TR*           AND BN.REVENUE_MONTH = (SELECT MAX(REVENUE_MONTH)             
MFA-TR*                          FROM CSS_BILL_WINDOW                           
MFA-TR*                         WHERE DATE_EXTRACT = BN.DATE_EXTRACT)           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    26820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'REVENUE_MONTH'          TO TABLE-ELEMENT-1          
              MOVE 'BILL_CYCLE'             TO TABLE-ELEMENT-2          
              MOVE WS-CURR-REV-MNTH         TO HOSTVAR-ELEMENT-1        
              MOVE WS-BILL-CYCLE            TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7500-DRAFT-CYCLE-DAYS                                                   
      * GET DRAFT CYCLE AND DAY FROM THE MAIN CURSOR.                           
      *****************************************************************         
       7500-DRAFT-CYCLE-DAYS.                                           
           PERFORM 7510-OPEN-DRFT-CURSOR      THRU 7510-EXIT.           
           PERFORM 7520-FETCH-DRFT-CURSOR     THRU 7520-EXIT UNTIL      
                        WS-ACTIVE-RETURN-CODE = NOT-FOUND.              
           PERFORM 7530-CLOSE-DRFT-CURSOR     THRU 7530-EXIT.           
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-OPEN-DRFT-CURSOR.                                           
           EXEC SQL                                                     
               OPEN DRAFT_DAY_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7510'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'WS-AND-OR-TYPE'      TO TABLE-ELEMENT-1             
              MOVE 'WS-MIN-CYCLE'        TO TABLE-ELEMENT-2             
              MOVE 'WS-MAX-CYCLE'        TO TABLE-ELEMENT-3             
              MOVE WS-AND-OR-TYPE        TO HOSTVAR-ELEMENT-1           
              MOVE WS-MIN-CYCLE          TO HOSTVAR-ELEMENT-2           
              MOVE WS-MAX-CYCLE          TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7520-FETCH-DRFT-CURSOR.                                          
           EXEC SQL                                                     
               FETCH DRAFT_DAY_CUR                                      
                INTO :BN-BILL-CYCLE,                                    
                     :WS-DRAFT-DAY                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE,      
                                            RS-RETURN-CODE.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7520'             TO ACTIVE-PARAGRAPH            
                 MOVE 'FETCH'            TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                     
                 MOVE 'WS-AND-OR-TYPE'   TO TABLE-ELEMENT-1             
                 MOVE 'WS-MIN-CYCLE'     TO TABLE-ELEMENT-2             
                 MOVE 'WS-MAX-CYCLE'     TO TABLE-ELEMENT-3             
                 MOVE WS-AND-OR-TYPE     TO HOSTVAR-ELEMENT-1           
                 MOVE WS-MIN-CYCLE       TO HOSTVAR-ELEMENT-2           
                 MOVE WS-MAX-CYCLE       TO HOSTVAR-ELEMENT-3           
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7530-CLOSE-DRFT-CURSOR.                                          
           EXEC SQL                                                     
               CLOSE DRAFT_DAY_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7530'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'WS-AND-OR-TYPE'      TO TABLE-ELEMENT-1             
              MOVE 'WS-MIN-CYCLE'        TO TABLE-ELEMENT-2             
              MOVE 'WS-MAX-CYCLE'        TO TABLE-ELEMENT-3             
              MOVE WS-AND-OR-TYPE        TO HOSTVAR-ELEMENT-1           
              MOVE WS-MIN-CYCLE          TO HOSTVAR-ELEMENT-2           
              MOVE WS-MAX-CYCLE          TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
           EXEC SQL                                                     
               DELETE FROM #CSR04242_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04242_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04242_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
           EXEC SQL                                                     
                INSERT INTO #CSR04242_R1                         
                       (RETURN_CODE,                                    
                        DRAFT_CYCLE,                                    
                        DRAFT_DATE)                                     
                VALUES (:S-RETURN-CODE,                                 
                        :S-DRAFT-CYCLE,                                 
                        :S-DRAFT-DAY                                    
                       )                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04242_R1                                 
MFA-TR*                (RETURN_CODE,                                            
MFA-TR*                 DRAFT_CYCLE,                                            
MFA-TR*                 DRAFT_DATE)                                             
MFA-TR*         VALUES (:S-RETURN-CODE,                                         
MFA-TR*                 :S-DRAFT-CYCLE,                                         
MFA-TR*                 :S-DRAFT-DAY                                            
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04242_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29170000
      * 9900 - ERROR HANDLING ROUTINE                                  *29180000
      ******************************************************************29190000
           EXEC SQL                                                     29200000
              INCLUDE CPDSP300                                          29210000
           END-EXEC.                                                    29220000
                                                                        
      ******************************************************************29240000
      * END PROGRAM COPYLIB                                            *29250000
      ******************************************************************29260000
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
