       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04229.                                         
COB303 DATE-WRITTEN.  JAN 16 2009                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00143000
      *                 P R O G R A M  S U M M A R Y                   *00144000
      *                                                                *00145000
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC AND   *00146000
      *  GAS ATTACHMENT TRANSFER AND MOVEMENT SCREENS                  *00147000
      *                                                                *00148000
      ******************************************************************00149000
      *                                                                *00150000
      *                     PROGRAM MODIFICATION LOG                   *00160000
      *                                                                *00170000
      *    DATE    INITIALS   COMMENTS                                 *00180000
      *  --------  --------   ---------------------------------------  *00190000
      *  01/17/09  SJ94244    PROCEDURE ORIGINALLY CODED.              *00200000
C14744*  10/17/09  SB40505    ADDED INTRANSIT EMPLOYEE ID FOR BAR CODE *00200000
      ******************************************************************00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00250000
      *                                                                *00260000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00270000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00280000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00290000
      *  3000 - 4999  NOT USED                                         *00300000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00310000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00320000
      *  7000 - 7999  INPUT MODULES                                    *00330000
      *  8000 - 8999  OUTPUT MODULES                                   *00340000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00350000
      *                                                                *00360000
      ******************************************************************00370000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04229'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                    PIC X(40) VALUE                   
          'WORKING STORAGE FOR CSR04229 STARTS HERE'.                   
                                                                        
      ******************************************************************00780000
      *    WORK AREAS                                                  *00790000
      ******************************************************************00800000
                                                                        
       01 WS-COUNTER-FIELDS.                                            
          05 CTR-ROWS                 PIC S9(9) COMP VALUE 1.           
                                                                        
       01 WS-PROGRAM-NAME.                                              
          05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04229'.       
                                                                        
       01 WS-WORK-FIELDS.                                               
          05 WS-CODE-UTIL-TYPE        PIC X(01).                        
          05 WS-COMPANY-NO            PIC X(02).                        
          05 WS-DEVICE-NO             PIC X(12).                        
          05 WS-CODE-ATT-TYPE         PIC X(02).                        
          05 WS-MOVE-DATE             PIC X(10).                        
          05 WS-EQUIP-LOC-ID          PIC X(01).                        
          05 WS-MSF-CD                PIC X(03).                        
          05 WS-REPAIR-CODE           PIC X(01).                        
C14744    05 WS-IN-TRANSIT-EMP-ID     PIC X(07).                        
          05 WS-CURRENT-TIMESTAMP     PIC X(26).                        
          05 WS-CURRENT-TIME          PIC X(08).                        
          05 WS-CURRENT-DATE          PIC X(10).                        
          05 WS-DATE-LAST-TESTED      PIC X(10).                        
          05 WS-DATE-MOVE             PIC X(10).                        
                                                                        
       01 WS-CONSTANTS.                                                 
          05 WS-PARM-EQUIP-LOC-SW     PIC X(01)  VALUE SPACES.          
             88 WS-PARM-LOCATION-INVENTORY       VALUE 'A'.             
             88 WS-PARM-LOCATION-RETIRE          VALUE 'I'.             
             88 WS-PARM-LOCATION-METER-SHOP      VALUE 'B'.             
             88 WS-PARM-LOCATION-UNKNOWN         VALUE 'U'.             
             88 WS-PARM-LOCATION-AT-CUSTOMER     VALUE 'J'.             
             88 WS-PARM-LOCATION-ATTACHED        VALUE 'K'.             
             88 WS-PARM-LOCATION-OLD-ACCT        VALUE 'X'.             
             88 WS-PARM-LOCATION-IN-TRANSIT      VALUE 'C'.             
                                                                        
          05 WS-LX-EQUIP-LOC-SW        PIC X(01) VALUE SPACES.          
             88 WS-LX-LOCATION-INVENTORY         VALUE 'A'.             
             88 WS-LX-LOCATION-RETIRE            VALUE 'I'.             
             88 WS-LX-LOCATION-METER-SHOP        VALUE 'B'.             
             88 WS-LX-LOCATION-UNKNOWN           VALUE 'U'.             
             88 WS-LX-LOCATION-AT-CUSTOMER       VALUE 'J'.             
             88 WS-LX-LOCATION-ATTACHED          VALUE 'K'.             
             88 WS-LX-LOCATION-OLD-ACCT          VALUE 'X'.             
             88 WS-LX-LOCATION-IN-TRANSIT        VALUE 'C'.             
                                                                        
       01 WS-FLAGS.                                                     
          05 WS-EQUIP-ATTCHMENT-EXISTS PIC X(01) VALUE 'N'.             
             88 EQUIP-ATTCHMENT-EXISTS           VALUE 'Y'.             
          05 WS-MTR-ATTCHMENT-EXISTS   PIC X(01) VALUE 'N'.             
             88 MTR-ATTCHMENT-EXISTS             VALUE 'Y'.             
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01) VALUE 'Y'.             
             88 SEND-DONE-ERROR                  VALUE 'N'.             
             88 SEND-DONE-OK                     VALUE 'Y'.             
                                                                        
          05 WS-CALL-TYPE-SW           PIC X(01) VALUE SPACES.          
             88 WS-MOVEMENT-M                    VALUE 'M'.             
             88 WS-TRANSFER-T                    VALUE 'T'.             
                                                                        
      *************** THIS IS THE ROW RETURN AREA ********************* 01360000
                                                                        
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.         
          05 RS-ADDITIONAL-MSG         PIC X(30) VALUE SPACES.          
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) COMP VALUE 0.         
          05 S-ADDITIONAL-MSG          PIC X(30) VALUE SPACES.          
                                                                        
       01 WS-NULL-INDICATORS.                                           
          05 WS-LX-DT-LST-MOVE-NULL-IND   PIC S9(04) COMP VALUE 0.      
          05 WS-LX-DT-PURCHASE-NULL-IND   PIC S9(04) COMP VALUE 0.      
          05 WS-LY-DATE-TEST-NULL-IND     PIC S9(04) COMP VALUE 0.      
          05 WS-DATE-MOVE-NULL-IND        PIC S9(04) COMP VALUE 0.      
          05 WS-DATE-LAST-TESTED-NULL-IND PIC S9(04) COMP VALUE 0.      
          05 WS-MTR-STR-FAC-CD-NULL-IND   PIC S9(04) COMP VALUE 0.      
          05 WS-DATE-LAST-TRAN-NULL-IND   PIC S9(04) COMP VALUE 0.      
          05 WS-CODE-REPAIR-NULL-IND      PIC S9(04) COMP VALUE 0.      
          05 WS-TEST-NULL-IND             PIC S9(04) COMP VALUE 0.      
                                                                        
      ******************************************************************00460000
      *    DB2 INCLUDES                                                *00470000
      ******************************************************************00480000
                                                                        
           EXEC SQL                                                     00500000
              INCLUDE SQLCA                                             00510000
           END-EXEC.                                                    00520000
      *                                                                 00650000
      ******************************************************************        
      * CSS_EQUIP_ATTCHMTS - LX                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQATTH                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS - MA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATT_MOVE - MP                                        *        
      ******************************************************************        
           EXEC SQL                                                     00620000
              INCLUDE TBEQMOVE                                          00630000
           END-EXEC.                                                    00640000
      *                                                                 00650000
      ******************************************************************        
      * CSS_EQUIP_ATT_TEST - LY                                        *        
      ******************************************************************        
           EXEC SQL                                                     00620000
              INCLUDE TBEQTEST                                          00630000
           END-EXEC.                                                    00640000
      *                                                                 00650000
      ******************************************************************00670000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00680000
      ******************************************************************00690000
                                                                        
           COPY CWS00303.                                               00760000
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                 01720900
HPCCDM*EJECT                                                            01660000
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-CALL-TYPE         PIC X(01).                             
       01 PARM-CODE-UTIL-TYPE    PIC X(01).                             
       01 PARM-COMPANY-NO        PIC X(02).                             
       01 PARM-DEVICE-NO         PIC X(12).                             
       01 PARM-CODE-ATT-TYPE     PIC X(02).                             
       01 PARM-MOVE-DATE         PIC X(10).                             
       01 PARM-EQUIP-LOC-ID      PIC X(01).                             
       01 PARM-MSF-CD            PIC X(03).                             
       01 PARM-REPAIR-CODE       PIC X(01).                             
C14744 01 PARM-IN-TRANSIT-EMP-ID PIC X(07).                             
      *                                                                         
       PROCEDURE DIVISION USING  PARM-CALL-TYPE                         
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-COMPANY-NO                        
                                 PARM-DEVICE-NO                         
                                 PARM-CODE-ATT-TYPE                     
                                 PARM-MOVE-DATE                         
                                 PARM-EQUIP-LOC-ID                      
                                 PARM-MSF-CD                            
C14744                           PARM-REPAIR-CODE                       
C14744                           PARM-IN-TRANSIT-EMP-ID.                
                                                                        
      ******************************************************************01710000
      * 0000-MAINLINE                                                  *01730000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01740000
      ******************************************************************01750000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01850000
      ******************************************************************01870000
      * 0100-INITIALIZE                                                *01880000
      ******************************************************************01950000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                  :S-RETURN-CODE          AS RETURN_CODE                
                 ,:S-ADDITIONAL-MSG       AS ADDITIONAL_MSG             
              FROM                                                      
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*           :S-RETURN-CODE          AS RETURN_CODE                        
MFA-TR*          ,:S-ADDITIONAL-MSG       AS ADDITIONAL_MSG                     
MFA-TR*       FROM                                                              
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 1000-PROCESS-INPUT                                             *02240000
      ******************************************************************02280000
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE PARM-CALL-TYPE         TO WS-CALL-TYPE-SW.              
           MOVE PARM-CODE-UTIL-TYPE    TO WS-CODE-UTIL-TYPE.            
           MOVE PARM-COMPANY-NO        TO WS-COMPANY-NO.                
           MOVE PARM-DEVICE-NO         TO WS-DEVICE-NO.                 
           MOVE PARM-CODE-ATT-TYPE     TO WS-CODE-ATT-TYPE.             
           MOVE PARM-MOVE-DATE         TO WS-MOVE-DATE.                 
           MOVE PARM-EQUIP-LOC-ID      TO WS-EQUIP-LOC-ID               
                                          WS-PARM-EQUIP-LOC-SW.         
           MOVE PARM-MSF-CD            TO WS-MSF-CD.                    
           MOVE PARM-REPAIR-CODE       TO WS-REPAIR-CODE.               
C14744     MOVE PARM-IN-TRANSIT-EMP-ID TO WS-IN-TRANSIT-EMP-ID.         
           PERFORM 7300-GET-CURRENT-TIMESTAMP    THRU 7300-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-CODE-UTIL-TYPE = SPACES OR                           
              PARM-COMPANY-NO     = SPACES OR                           
              PARM-CALL-TYPE      = SPACES OR                           
              PARM-DEVICE-NO      = SPACES OR                           
              PARM-CODE-ATT-TYPE  = SPACES                              
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-2          
              MOVE 'PARM-CALL-TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'PARM-DEVICE-NO'         TO TABLE-ELEMENT-4          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-2        
              MOVE PARM-CALL-TYPE           TO HOSTVAR-ELEMENT-3        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02810000
      * 2000-PROCESS-OUTPUT.                                           *02820000
      ******************************************************************02870000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-MOVEMENT-M                                        
                 PERFORM 2100-PROCESS-FOR-MOVEMENT     THRU 2100-EXIT   
              WHEN WS-TRANSFER-T                                        
                 PERFORM 2200-PROCESS-FOR-TRANSFER     THRU 2200-EXIT   
              WHEN OTHER                                                
                 MOVE 9999                  TO WS-ACTIVE-RETURN-CODE    
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '2000'                TO ACTIVE-PARAGRAPH         
                 MOVE 'EVALUATE'            TO ABEND-FUNCTION           
                 MOVE 'WS-CALL-TYPE-SW'     TO TABLE-1                  
                 MOVE WS-CALL-TYPE-SW       TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT   
                 PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT   
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02950000
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE     TO S-RETURN-CODE.                    
           MOVE RS-ADDITIONAL-MSG  TO S-ADDITIONAL-MSG.                 
           ADD +1                  TO CTR-ROWS.                         
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04640000
      ******************************************************************04650000
      * 2100-PROCESS-FOR-MOVEMENT                                      *04660000
      ******************************************************************04700000
       2100-PROCESS-FOR-MOVEMENT.                                       
                                                                        
           PERFORM 2300-VALIDATION-PROCESS         THRU 2300-EXIT.      
           PERFORM 2400-EQUIP-ATTCH-UPDT-PROCESS   THRU 2400-EXIT.      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04640000
      ******************************************************************04650000
      * 2200-PROCESS-FOR-TRANSFER.                                     *04660000
      ******************************************************************04700000
       2200-PROCESS-FOR-TRANSFER.                                       
                                                                        
           MOVE WS-COMPANY-NO      TO LX-COMPANY-NO                     
           MOVE WS-CODE-UTIL-TYPE  TO LX-CODE-UTIL-TYPE                 
           MOVE WS-CODE-ATT-TYPE   TO LX-CODE-ATT-TYPE                  
           MOVE WS-DEVICE-NO       TO LX-DEVICE-NO                      
C14744     MOVE WS-IN-TRANSIT-EMP-ID                                    
                                   TO LX-IN-TRANSIT-EMP-ID              
           PERFORM 7050-SELCT-EQUIP-ATTACHMENTS   THRU 7050-EXIT.       
                                                                        
           IF WS-EQUIP-ATTCHMENT-EXISTS = 'N'                           
              MOVE 6200            TO RS-RETURN-CODE                    
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 9999-END-PROGRAM            THRU 9999-EXIT        
           END-IF                                                       
                                                                        
           PERFORM 2300-VALIDATION-PROCESS        THRU 2300-EXIT.       
           PERFORM 2500-EQUIP-ATTCH-UPDT-PROCESS  THRU 2500-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04650000
      * 2300-VALIDATION-PROCESS                                        *04660000
      ******************************************************************04700000
       2300-VALIDATION-PROCESS.                                         
                                                                        
           IF WS-MOVE-DATE > WS-CURRENT-DATE                            
              MOVE 5500            TO  RS-RETURN-CODE                   
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
           MOVE WS-COMPANY-NO      TO MA-COMPANY-NO                     
                                      LX-COMPANY-NO                     
           MOVE WS-CODE-UTIL-TYPE  TO MA-CODE-UTIL-TYPE                 
                                      LX-CODE-UTIL-TYPE                 
           MOVE WS-CODE-ATT-TYPE   TO MA-CODE-ATT-TYPE                  
                                      LX-CODE-ATT-TYPE                  
           MOVE WS-DEVICE-NO       TO MA-DEVICE-NO                      
                                      LX-DEVICE-NO                      
                                                                        
           PERFORM 7000-SELCT-METER-ATTACHMENTS  THRU 7000-EXIT.        
                                                                        
           IF MTR-ATTCHMENT-EXISTS                                      
              MOVE 5100                          TO RS-RETURN-CODE      
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 7100-SELCT-EQUIP-LOC-ID       THRU 7100-EXIT.        
                                                                        
           IF WS-MOVE-DATE < LX-DATE-LAST-MOVE                          
              MOVE 5600            TO  RS-RETURN-CODE                   
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
           END-IF                                                       
                                                                        
           MOVE LX-EQUIP-LOC-ID    TO WS-LX-EQUIP-LOC-SW.               
                                                                        
           EVALUATE TRUE                                                
                                                                        
              WHEN WS-LX-LOCATION-INVENTORY                             
                 PERFORM 2600-PROCESS-LCTN-INVNTRY   THRU 2600-EXIT     
                                                                        
              WHEN WS-LX-LOCATION-METER-SHOP                            
                 PERFORM 2610-PROCESS-LCTN-MTRSHOP   THRU 2610-EXIT     
                                                                        
              WHEN WS-LX-LOCATION-IN-TRANSIT                            
                 PERFORM 2620-PROCESS-LCTN-INTRANSIT THRU 2620-EXIT     
                                                                        
              WHEN WS-LX-LOCATION-AT-CUSTOMER                           
                 PERFORM 2630-PROCESS-LCTN-CUSTOMER  THRU 2630-EXIT     
                                                                        
              WHEN WS-LX-LOCATION-RETIRE                                
                 PERFORM 2640-PROCESS-LCTN-RETIRE    THRU 2640-EXIT     
                                                                        
              WHEN WS-LX-LOCATION-UNKNOWN                               
                 PERFORM 2650-PROCESS-LCTN-UNKNOWN   THRU 2650-EXIT     
                                                                        
              WHEN WS-LX-LOCATION-OLD-ACCT                              
                 PERFORM 2660-PROCESS-LCTN-OLDACCT   THRU 2660-EXIT     
                                                                        
              WHEN WS-LX-LOCATION-ATTACHED                              
                 PERFORM 2670-PROCESS-LCTN-ATTACHED  THRU 2670-EXIT     
                                                                        
           END-EVALUATE.                                                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04650000
      * 2400-EQUIP-ATTCH-UPDT-PROCESS.                                 *04660000
      ******************************************************************04700000
       2400-EQUIP-ATTCH-UPDT-PROCESS.                                   
                                                                        
           IF WS-LX-DT-LST-MOVE-NULL-IND = -1                           
              IF WS-LX-DT-PURCHASE-NULL-IND  = -1                       
                 MOVE '1900-01-01'       TO WS-DATE-MOVE                
              ELSE                                                      
                 MOVE LX-DATE-PURCHASED  TO WS-DATE-MOVE                
              END-IF                                                    
           ELSE                                                         
              MOVE LX-DATE-LAST-MOVE     TO WS-DATE-MOVE                
           END-IF                                                       
                                                                        
           MOVE WS-DEVICE-NO             TO MP-DEVICE-NO                
                                            LY-DEVICE-NO                
                                            LX-DEVICE-NO                
           MOVE WS-COMPANY-NO            TO MP-COMPANY-NO               
                                            LY-COMPANY-NO               
                                            LX-COMPANY-NO               
           MOVE WS-CODE-UTIL-TYPE        TO MP-CODE-UTIL-TYPE           
                                            LY-CODE-UTIL-TYPE           
                                            LX-CODE-UTIL-TYPE           
           MOVE WS-CODE-ATT-TYPE         TO MP-CODE-ATT-TYPE            
                                            LY-CODE-ATT-TYPE            
                                            LX-CODE-ATT-TYPE            
                                                                        
           MOVE WS-DATE-MOVE             TO MP-DATE-MOVE                
           MOVE LX-MTR-STORAGE-FAC-CD    TO MP-MTR-STORAGE-FAC-CD       
           MOVE LX-EQUIP-LOC-ID          TO MP-EQUIP-LOC-ID             
           MOVE MA-METER-NO              TO MP-METER-NO                 
C14744                                                                  
C14744     MOVE WS-IN-TRANSIT-EMP-ID     TO MP-IN-TRANSIT-EMP-ID        
C14744                                      LX-IN-TRANSIT-EMP-ID        
                                                                        
           PERFORM 8000-INS-EQUIP-ATT-MOVE-DET    THRU 8000-EXIT        
                                                                        
           MOVE PARM-EQUIP-LOC-ID        TO WS-PARM-EQUIP-LOC-SW        
                                                                        
           IF WS-PARM-LOCATION-RETIRE                                   
                                                                        
              MOVE WS-CURRENT-DATE       TO WS-DATE-LAST-TESTED         
              PERFORM 7200-SELCT-DATE-TEST        THRU 7200-EXIT        
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 AND WS-LY-DATE-TEST-NULL-IND  = 0                      
                 AND LY-DATE-TEST > SPACES                              
                 MOVE LY-DATE-TEST       TO WS-DATE-LAST-TESTED         
              END-IF                                                    
                                                                        
              MOVE WS-DATE-LAST-TESTED   TO LX-DATE-LAST-TESTED         
                                                                        
              PERFORM 8020-UPDATE-EQUP-ATCH       THRU 8020-EXIT        
                                                                        
              MOVE WS-REPAIR-CODE        TO LY-CODE-REPAIR              
                                                                        
              PERFORM 8010-INS-EQUIP-ATT-TEST-DET THRU 8010-EXIT        
           END-IF                                                       
                                                                        
           MOVE WS-MOVE-DATE             TO LX-DATE-LAST-MOVE           
                                                                        
           IF LX-DATE-LAST-MOVE = SPACES                                
              MOVE -1                    TO WS-DATE-MOVE-NULL-IND       
           END-IF                                                       
                                                                        
           MOVE WS-MSF-CD                TO LX-MTR-STORAGE-FAC-CD       
           MOVE WS-EQUIP-LOC-ID          TO LX-EQUIP-LOC-ID             
                                                                        
           PERFORM 8030-UPDATE-EQUP-ATCH          THRU 8030-EXIT.       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04650000
      *2500-EQUIP-ATTCH-UPDT-PROCESS                                   *04660000
      ******************************************************************04700000
       2500-EQUIP-ATTCH-UPDT-PROCESS.                                   
                                                                        
           IF WS-LX-DT-LST-MOVE-NULL-IND = -1                           
              IF WS-LX-DT-PURCHASE-NULL-IND  = -1                       
                 MOVE '1900-01-01'      TO WS-DATE-MOVE                 
              ELSE                                                      
                 MOVE LX-DATE-PURCHASED TO WS-DATE-MOVE                 
              END-IF                                                    
           ELSE                                                         
              MOVE LX-DATE-LAST-MOVE    TO WS-DATE-MOVE                 
           END-IF                                                       
                                                                        
           MOVE WS-DEVICE-NO            TO MP-DEVICE-NO                 
                                           LX-DEVICE-NO                 
           MOVE WS-COMPANY-NO           TO MP-COMPANY-NO                
                                           LX-COMPANY-NO                
           MOVE WS-CODE-UTIL-TYPE       TO MP-CODE-UTIL-TYPE            
                                           LX-CODE-UTIL-TYPE            
           MOVE WS-CODE-ATT-TYPE        TO MP-CODE-ATT-TYPE             
                                           LX-CODE-ATT-TYPE             
           MOVE WS-DATE-MOVE            TO MP-DATE-MOVE                 
           MOVE LX-MTR-STORAGE-FAC-CD   TO MP-MTR-STORAGE-FAC-CD        
           MOVE LX-EQUIP-LOC-ID         TO MP-EQUIP-LOC-ID              
           MOVE MA-METER-NO             TO MP-METER-NO                  
C14744                                                                  
C14744     MOVE WS-IN-TRANSIT-EMP-ID     TO MP-IN-TRANSIT-EMP-ID        
C14744                                      LX-IN-TRANSIT-EMP-ID        
                                                                        
           PERFORM 8000-INS-EQUIP-ATT-MOVE-DET THRU 8000-EXIT           
                                                                        
           MOVE WS-MOVE-DATE            TO LX-DATE-LAST-MOVE            
                                                                        
           IF LX-DATE-LAST-MOVE = SPACES                                
              MOVE -1                   TO WS-DATE-MOVE-NULL-IND        
           END-IF                                                       
                                                                        
           MOVE WS-MSF-CD               TO LX-MTR-STORAGE-FAC-CD        
           MOVE WS-EQUIP-LOC-ID         TO LX-EQUIP-LOC-ID              
                                                                        
                                                                        
           PERFORM 8030-UPDATE-EQUP-ATCH       THRU 8030-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-PROCESS-LCTN-INVNTRY                                      *        
      ******************************************************************        
       2600-PROCESS-LCTN-INVNTRY.                                       
      *                                                                         
           MOVE PARM-EQUIP-LOC-ID   TO WS-PARM-EQUIP-LOC-SW.            
                                                                        
           EVALUATE TRUE                                                
                                                                        
              WHEN WS-PARM-LOCATION-INVENTORY                           
                 IF LX-MTR-STORAGE-FAC-CD = WS-MSF-CD                   
                    MOVE 5200       TO  RS-RETURN-CODE                  
                    PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT         
                    PERFORM 9999-END-PROGRAM    THRU 9999-EXIT          
                 END-IF                                                 
                                                                        
              WHEN WS-PARM-LOCATION-RETIRE                              
                                                                        
                 IF WS-TRANSFER-T AND                                   
                    WS-MSF-CD NOT = LX-MTR-STORAGE-FAC-CD               
                   MOVE 5700       TO  RS-RETURN-CODE                   
                   PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
                   PERFORM 9999-END-PROGRAM    THRU 9999-EXIT           
                 END-IF                                                 
                                                                        
              WHEN WS-PARM-LOCATION-METER-SHOP                          
              WHEN WS-PARM-LOCATION-UNKNOWN                             
C14744        WHEN WS-PARM-LOCATION-IN-TRANSIT                          
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 IF WS-TRANSFER-T                                       
                   MOVE LX-MTR-STORAGE-FAC-CD TO RS-ADDITIONAL-MSG      
                 END-IF                                                 
                 MOVE 5300       TO  RS-RETURN-CODE                     
                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
                 PERFORM 9999-END-PROGRAM    THRU 9999-EXIT             
           END-EVALUATE.                                                
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2610-PROCESS-LCTN-MTRSHOP                                      *        
      ******************************************************************        
       2610-PROCESS-LCTN-MTRSHOP.                                       
      *                                                                         
           MOVE PARM-EQUIP-LOC-ID           TO WS-PARM-EQUIP-LOC-SW.    
                                                                        
           EVALUATE TRUE                                                
                                                                        
              WHEN WS-PARM-LOCATION-METER-SHOP                          
                 IF LX-MTR-STORAGE-FAC-CD = WS-MSF-CD                   
                    MOVE 5200               TO  RS-RETURN-CODE          
                    PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT         
                    PERFORM 9999-END-PROGRAM    THRU 9999-EXIT          
                 END-IF                                                 
                                                                        
              WHEN WS-PARM-LOCATION-RETIRE                              
                                                                        
                 IF WS-TRANSFER-T AND                                   
                    WS-MSF-CD NOT = LX-MTR-STORAGE-FAC-CD               
                   MOVE 5700               TO  RS-RETURN-CODE           
                   PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
                   PERFORM 9999-END-PROGRAM    THRU 9999-EXIT           
                 END-IF                                                 
                                                                        
              WHEN WS-PARM-LOCATION-INVENTORY                           
              WHEN WS-PARM-LOCATION-UNKNOWN                             
C14744        WHEN WS-PARM-LOCATION-IN-TRANSIT                          
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 IF WS-TRANSFER-T                                       
                   MOVE LX-MTR-STORAGE-FAC-CD TO RS-ADDITIONAL-MSG      
                 END-IF                                                 
                 MOVE 5300               TO RS-RETURN-CODE              
                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
                 PERFORM 9999-END-PROGRAM    THRU 9999-EXIT             
           END-EVALUATE.                                                
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2620-PROCESS-LCTN-INTRANSIT                                    *        
      ******************************************************************        
       2620-PROCESS-LCTN-INTRANSIT.                                     
      *                                                                         
           MOVE PARM-EQUIP-LOC-ID  TO WS-PARM-EQUIP-LOC-SW.             
                                                                        
           IF WS-PARM-LOCATION-IN-TRANSIT  OR                           
              WS-PARM-LOCATION-UNKNOWN     OR                           
              WS-PARM-LOCATION-INVENTORY   OR                           
              WS-PARM-LOCATION-METER-SHOP                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5300            TO  RS-RETURN-CODE                   
              PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 9999-END-PROGRAM     THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2630-PROCESS-LCTN-CUSTOMER                                     *        
      ******************************************************************        
       2630-PROCESS-LCTN-CUSTOMER.                                      
      *                                                                         
           MOVE PARM-EQUIP-LOC-ID     TO WS-PARM-EQUIP-LOC-SW.          
                                                                        
           IF WS-MOVEMENT-M                 AND                         
              ( WS-PARM-LOCATION-IN-TRANSIT OR                          
                WS-PARM-LOCATION-INVENTORY  OR                          
                WS-PARM-LOCATION-METER-SHOP OR                          
C14744          WS-PARM-LOCATION-IN-TRANSIT OR                          
                WS-PARM-LOCATION-UNKNOWN     )                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5300               TO RS-RETURN-CODE                 
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF                                                       
                                                                        
           IF WS-TRANSFER-T                                             
              MOVE LX-EQUIP-LOC-ID    TO RS-ADDITIONAL-MSG              
           END-IF                                                       
           MOVE 6500               TO RS-RETURN-CODE                    
           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT                
           PERFORM 9999-END-PROGRAM      THRU 9999-EXIT.                
                                                                        
       2630-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2640-PROCESS-LCTN-RETIRE                                       *        
      ******************************************************************        
       2640-PROCESS-LCTN-RETIRE.                                        
      *                                                                         
           MOVE PARM-EQUIP-LOC-ID        TO WS-PARM-EQUIP-LOC-SW.       
                                                                        
           IF NOT WS-PARM-LOCATION-INVENTORY AND                        
              NOT WS-PARM-LOCATION-METER-SHOP                           
                                                                        
              IF WS-TRANSFER-T                                          
                MOVE LX-MTR-STORAGE-FAC-CD TO RS-ADDITIONAL-MSG         
              END-IF                                                    
                                                                        
              MOVE 5800               TO  RS-RETURN-CODE                
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
       2640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2650-PROCESS-LCTN-UNKNOWN                                      *        
      ******************************************************************        
       2650-PROCESS-LCTN-UNKNOWN.                                       
      *                                                                         
           MOVE PARM-EQUIP-LOC-ID        TO WS-PARM-EQUIP-LOC-SW.       
                                                                        
           IF WS-MOVEMENT-M                AND                          
              ( WS-PARM-LOCATION-IN-TRANSIT OR                          
                WS-PARM-LOCATION-RETIRE     OR                          
                WS-PARM-LOCATION-INVENTORY  OR                          
C14744          WS-PARM-LOCATION-IN-TRANSIT OR                          
                WS-PARM-LOCATION-METER-SHOP  )                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5300                  TO  RS-RETURN-CODE             
              PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 9999-END-PROGRAM     THRU 9999-EXIT               
           END-IF                                                       
                                                                        
           IF WS-TRANSFER-T                AND                          
              ( WS-PARM-LOCATION-INVENTORY  OR                          
                WS-PARM-LOCATION-METER-SHOP OR                          
                WS-PARM-LOCATION-RETIRE     OR                          
C14744          WS-PARM-LOCATION-IN-TRANSIT OR                          
                WS-PARM-LOCATION-UNKNOWN     )                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE LX-MTR-STORAGE-FAC-CD TO RS-ADDITIONAL-MSG           
              MOVE 5900                  TO RS-RETURN-CODE              
              PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 9999-END-PROGRAM     THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2660-PROCESS-LCTN-OLDACCT                                      *        
      ******************************************************************        
       2660-PROCESS-LCTN-OLDACCT.                                       
      *                                                                         
           MOVE PARM-EQUIP-LOC-ID         TO WS-PARM-EQUIP-LOC-SW.      
           IF WS-MOVEMENT-M                  AND                        
              ( WS-PARM-LOCATION-IN-TRANSIT  OR                         
                WS-PARM-LOCATION-RETIRE      OR                         
                WS-PARM-LOCATION-INVENTORY   OR                         
C14744          WS-PARM-LOCATION-IN-TRANSIT OR                          
                WS-PARM-LOCATION-METER-SHOP  OR                         
                WS-PARM-LOCATION-UNKNOWN      )                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE 5300                   TO RS-RETURN-CODE             
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
           IF WS-TRANSFER-T                  AND                        
              ( WS-PARM-LOCATION-INVENTORY   OR                         
                WS-PARM-LOCATION-METER-SHOP  OR                         
                WS-PARM-LOCATION-RETIRE      OR                         
C14744          WS-PARM-LOCATION-IN-TRANSIT OR                          
                WS-PARM-LOCATION-UNKNOWN      )                         
              CONTINUE                                                  
           ELSE                                                         
              MOVE LX-MTR-STORAGE-FAC-CD  TO RS-ADDITIONAL-MSG          
              MOVE 5900                   TO RS-RETURN-CODE             
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
       2660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2670-PROCESS-LCTN-ATTACHED                                     *        
      ******************************************************************        
       2670-PROCESS-LCTN-ATTACHED.                                      
      *                                                                         
           IF WS-TRANSFER-T                                             
              MOVE LX-EQUIP-LOC-ID TO RS-ADDITIONAL-MSG                 
           END-IF                                                       
           MOVE 6600            TO RS-RETURN-CODE                       
           PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       2670-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-SELCT-METER-ATTACHMENTS.                                  *        
      ******************************************************************        
       7000-SELCT-METER-ATTACHMENTS.                                    
      *                                                                         
           MOVE '7000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     'Y'                                                
                INTO                                                    
                     :WS-MTR-ATTCHMENT-EXISTS                           
                FROM                                                    
                     CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     COMPANY_NO      = :MA-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE               
                 AND CODE_ATT_TYPE   = :MA-CODE-ATT-TYPE                
                 AND DEVICE_NO       = :MA-DEVICE-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              'Y'                                                        
MFA-TR*         INTO                                                            
MFA-TR*              :WS-MTR-ATTCHMENT-EXISTS                                   
MFA-TR*         FROM                                                            
MFA-TR*              CSS_METER_ATTCHMTS                                         
MFA-TR*        WHERE                                                            
MFA-TR*              COMPANY_NO      = :MA-COMPANY-NO                           
MFA-TR*          AND CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE                       
MFA-TR*          AND CODE_ATT_TYPE   = :MA-CODE-ATT-TYPE                        
MFA-TR*          AND DEVICE_NO       = :MA-DEVICE-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_METER_ATTACHMTS'  TO TABLE-1                    
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-3            
              MOVE 'CODE_ATT_TYPE'        TO TABLE-ELEMENT-4            
              MOVE MA-COMPANY-NO          TO HOSTVAR-ELEMENT-1          
              MOVE MA-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE MA-DEVICE-NO           TO HOSTVAR-ELEMENT-3          
              MOVE MA-CODE-ATT-TYPE       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7050-SELCT-EQUIP-ATTACHMENTS.                                  *        
      ******************************************************************        
       7050-SELCT-EQUIP-ATTACHMENTS.                                    
      *                                                                         
           MOVE '7050'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     'Y'                                                
                INTO                                                    
                     :WS-EQUIP-ATTCHMENT-EXISTS                         
                FROM                                                    
                     CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     COMPANY_NO      = :LX-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE               
                 AND CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE                
                 AND DEVICE_NO       = :LX-DEVICE-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              'Y'                                                        
MFA-TR*         INTO                                                            
MFA-TR*              :WS-EQUIP-ATTCHMENT-EXISTS                                 
MFA-TR*         FROM                                                            
MFA-TR*              CSS_EQUIP_ATTCHMTS                                         
MFA-TR*        WHERE                                                            
MFA-TR*              COMPANY_NO      = :LX-COMPANY-NO                           
MFA-TR*          AND CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE                       
MFA-TR*          AND CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE                        
MFA-TR*          AND DEVICE_NO       = :LX-DEVICE-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_EQUIP_ATTACHMTS'  TO TABLE-1                    
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-3            
              MOVE 'CODE_ATT_TYPE'        TO TABLE-ELEMENT-4            
              MOVE LX-COMPANY-NO          TO HOSTVAR-ELEMENT-1          
              MOVE LX-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE LX-DEVICE-NO           TO HOSTVAR-ELEMENT-3          
              MOVE LX-CODE-ATT-TYPE       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7100-SELCT-EQUIP-LOC-ID.                                       *        
      ******************************************************************        
       7100-SELCT-EQUIP-LOC-ID.                                         
      *                                                                         
           MOVE '7100'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     LX.EQUIP_LOC_ID                                    
                    ,LX.MTR_STORAGE_FAC_CD                              
                    ,LX.DATE_LAST_MOVE                                  
                    ,LX.DATE_PURCHASED                                  
                    ,MA.METER_NO                                        
                INTO                                                    
                     :LX-EQUIP-LOC-ID                                   
                    ,:LX-MTR-STORAGE-FAC-CD :WS-MTR-STR-FAC-CD-NULL-IND  
                    ,:LX-DATE-LAST-MOVE :WS-LX-DT-LST-MOVE-NULL-IND      
                    ,:LX-DATE-PURCHASED :WS-LX-DT-PURCHASE-NULL-IND      
                    ,:MA-METER-NO :WS-TEST-NULL-IND                     
                FROM                                                    
                     CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                
                LEFT OUTER JOIN                                         
                     CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                  ON (LX.COMPANY_NO     = MA.COMPANY_NO                 
                 AND LX.CODE_UTIL_TYPE  = MA.CODE_UTIL_TYPE             
                 AND LX.CODE_ATT_TYPE   = MA.CODE_ATT_TYPE              
                 AND LX.DEVICE_NO       = MA.DEVICE_NO)                 
               WHERE                                                    
                     LX.COMPANY_NO      = :LX-COMPANY-NO                
                 AND LX.CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE            
                 AND LX.CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE             
                 AND LX.DEVICE_NO       = :LX-DEVICE-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              LX.EQUIP_LOC_ID                                            
MFA-TR*             ,LX.MTR_STORAGE_FAC_CD                                      
MFA-TR*             ,LX.DATE_LAST_MOVE                                          
MFA-TR*             ,LX.DATE_PURCHASED                                          
MFA-TR*             ,MA.METER_NO                                                
MFA-TR*         INTO                                                            
MFA-TR*              :LX-EQUIP-LOC-ID                                           
MFA-TR*             ,:LX-MTR-STORAGE-FAC-CD:WS-MTR-STR-FAC-CD-NULL-IND          
MFA-TR*             ,:LX-DATE-LAST-MOVE:WS-LX-DT-LST-MOVE-NULL-IND              
MFA-TR*             ,:LX-DATE-PURCHASED:WS-LX-DT-PURCHASE-NULL-IND              
MFA-TR*             ,:MA-METER-NO :WS-TEST-NULL-IND                             
MFA-TR*         FROM                                                            
MFA-TR*              CSS_EQUIP_ATTCHMTS LX                                      
MFA-TR*         LEFT OUTER JOIN                                                 
MFA-TR*              CSS_METER_ATTCHMTS MA                                      
MFA-TR*           ON (LX.COMPANY_NO     = MA.COMPANY_NO                         
MFA-TR*          AND LX.CODE_UTIL_TYPE  = MA.CODE_UTIL_TYPE                     
MFA-TR*          AND LX.CODE_ATT_TYPE   = MA.CODE_ATT_TYPE                      
MFA-TR*          AND LX.DEVICE_NO       = MA.DEVICE_NO)                         
MFA-TR*        WHERE                                                            
MFA-TR*              LX.COMPANY_NO      = :LX-COMPANY-NO                        
MFA-TR*          AND LX.CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE                    
MFA-TR*          AND LX.CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE                     
MFA-TR*          AND LX.DEVICE_NO       = :LX-DEVICE-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_METER_ATTACHMTS'  TO TABLE-1                    
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-3            
              MOVE 'CODE_ATT_TYPE'        TO TABLE-ELEMENT-4            
              MOVE LX-COMPANY-NO          TO HOSTVAR-ELEMENT-1          
              MOVE LX-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE LX-DEVICE-NO           TO HOSTVAR-ELEMENT-3          
              MOVE LX-CODE-ATT-TYPE       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7200-SELCT-DATE-TEST                                           *        
      ******************************************************************        
       7200-SELCT-DATE-TEST.                                            
      *                                                                         
           MOVE '7200'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DATE_TEST                                          
                INTO                                                    
                     :LY-DATE-TEST :WS-LY-DATE-TEST-NULL-IND            
                FROM                                                    
                     CSS_EQUIP_ATT_TEST WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     COMPANY_NO      = :LY-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :LY-CODE-UTIL-TYPE               
                 AND CODE_ATT_TYPE   = :LY-CODE-ATT-TYPE                
                 AND DEVICE_NO       = :LY-DEVICE-NO                    
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              DATE_TEST                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :LY-DATE-TEST :WS-LY-DATE-TEST-NULL-IND                    
MFA-TR*         FROM                                                            
MFA-TR*              CSS_EQUIP_ATT_TEST                                         
MFA-TR*        WHERE                                                            
MFA-TR*              COMPANY_NO      = :LY-COMPANY-NO                           
MFA-TR*          AND CODE_UTIL_TYPE  = :LY-CODE-UTIL-TYPE                       
MFA-TR*          AND CODE_ATT_TYPE   = :LY-CODE-ATT-TYPE                        
MFA-TR*          AND DEVICE_NO       = :LY-DEVICE-NO                            
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_EQUIP_ATT_TEST'   TO TABLE-1                    
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-3            
              MOVE 'CODE_ATT_TYPE'        TO TABLE-ELEMENT-4            
              MOVE LY-COMPANY-NO          TO HOSTVAR-ELEMENT-1          
              MOVE LY-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE LY-DEVICE-NO           TO HOSTVAR-ELEMENT-3          
              MOVE LY-CODE-ATT-TYPE       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-CURRENT-TIMESTAMP                                     *        
      ******************************************************************        
       7300-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           MOVE '7300'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                    ,REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), 
           ':', '.')                                       
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO                                                    
                     :WS-CURRENT-TIMESTAMP                              
                    ,:WS-CURRENT-TIME                                   
                    ,:WS-CURRENT-DATE                                   
                FROM                                                    
                     CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              CURRENT TIMESTAMP                                          
MFA-TR*             ,CURRENT TIME                                               
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*         INTO                                                            
MFA-TR*              :WS-CURRENT-TIMESTAMP                                      
MFA-TR*             ,:WS-CURRENT-TIME                                           
MFA-TR*             ,:WS-CURRENT-DATE                                           
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'SYSDUMMY1'            TO TABLE-1                    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-INS-EQUIP-ATT-MOVE-DET.                                   *        
      ******************************************************************        
       8000-INS-EQUIP-ATT-MOVE-DET.                                     
      *                                                                         
           MOVE '8000'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIP_ATT_MOVE                            
              (                                                         
                  DEVICE_NO                                             
                 ,CODE_ATT_TYPE                                         
                 ,COMPANY_NO                                            
                 ,CODE_UTIL_TYPE                                        
                 ,DATE_MOVE                                             
                 ,MOVE_NO                                               
                 ,MTR_STORAGE_FAC_CD                                    
                 ,EQUIP_LOC_ID                                          
                 ,METER_NO                                              
C14744           ,IN_TRANSIT_EMP_ID                                     
              )                                                         
              VALUES                                                    
              (                                                         
                  :MP-DEVICE-NO                                         
                 ,:MP-CODE-ATT-TYPE                                     
                 ,:MP-COMPANY-NO                                        
                 ,:MP-CODE-UTIL-TYPE                                    
                 ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) )                                
                 ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)                     
                 ,:MP-MTR-STORAGE-FAC-CD                                
                 ,:MP-EQUIP-LOC-ID                                      
                 ,:MP-METER-NO                                          
C14744           ,:MP-IN-TRANSIT-EMP-ID                                 
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EQUIP_ATT_MOVE                                    
MFA-TR*       (                                                                 
MFA-TR*           DEVICE_NO                                                     
MFA-TR*          ,CODE_ATT_TYPE                                                 
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,DATE_MOVE                                                     
MFA-TR*          ,MOVE_NO                                                       
MFA-TR*          ,MTR_STORAGE_FAC_CD                                            
MFA-TR*          ,EQUIP_LOC_ID                                                  
MFA-TR*          ,METER_NO                                                      
MFA-TR*          ,IN_TRANSIT_EMP_ID                                             
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*           :MP-DEVICE-NO                                                 
MFA-TR*          ,:MP-CODE-ATT-TYPE                                             
MFA-TR*          ,:MP-COMPANY-NO                                                
MFA-TR*          ,:MP-CODE-UTIL-TYPE                                            
MFA-TR*          ,:MP-DATE-MOVE                                                 
MFA-TR*          ,:WS-CURRENT-TIMESTAMP                                         
MFA-TR*          ,:MP-MTR-STORAGE-FAC-CD                                        
MFA-TR*          ,:MP-EQUIP-LOC-ID                                              
MFA-TR*          ,:MP-METER-NO                                                  
MFA-TR*          ,:MP-IN-TRANSIT-EMP-ID                                         
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'INSERT'               TO ABEND-FUNCTION             
              MOVE 'CSS_EQUIP_ATT_MOVE'   TO TABLE-1                    
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1            
              MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-2            
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3            
              MOVE 'CODE_ATT_TYPE'        TO TABLE-ELEMENT-4            
              MOVE MP-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1          
              MOVE MP-DEVICE-NO           TO HOSTVAR-ELEMENT-2          
              MOVE MP-COMPANY-NO          TO HOSTVAR-ELEMENT-3          
              MOVE MP-CODE-ATT-TYPE       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8010-INS-EQUIP-ATT-TEST-DET.                                   *        
      ******************************************************************        
       8010-INS-EQUIP-ATT-TEST-DET.                                     
      *                                                                         
           MOVE '8010'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIP_ATT_TEST                            
              (                                                         
                   COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,CODE_ATT_TYPE                                        
                  ,DEVICE_NO                                            
                  ,DATE_TEST                                            
                  ,TIME_TEST                                            
                  ,CODE_TEST_TYPE                                       
                  ,CODE_REPAIR                                          
                  ,REPAIR_DESC                                          
              )                                                         
              VALUES                                                    
              (                                                         
                   :LY-COMPANY-NO                                       
                  ,:LY-CODE-UTIL-TYPE                                   
                  ,:LY-CODE-ATT-TYPE                                    
                  ,:LY-DEVICE-NO                                        
                  ,IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                             
                  ,CIS.CHAR2TIME(:WS-CURRENT-TIME)                              
                  ,'I'                                                  
                  ,:LY-CODE-REPAIR :WS-CODE-REPAIR-NULL-IND             
                  ,'RETIRE'                                             
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EQUIP_ATT_TEST                                    
MFA-TR*       (                                                                 
MFA-TR*            COMPANY_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,CODE_ATT_TYPE                                                
MFA-TR*           ,DEVICE_NO                                                    
MFA-TR*           ,DATE_TEST                                                    
MFA-TR*           ,TIME_TEST                                                    
MFA-TR*           ,CODE_TEST_TYPE                                               
MFA-TR*           ,CODE_REPAIR                                                  
MFA-TR*           ,REPAIR_DESC                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*            :LY-COMPANY-NO                                               
MFA-TR*           ,:LY-CODE-UTIL-TYPE                                           
MFA-TR*           ,:LY-CODE-ATT-TYPE                                            
MFA-TR*           ,:LY-DEVICE-NO                                                
MFA-TR*           ,:WS-CURRENT-DATE                                             
MFA-TR*           ,:WS-CURRENT-TIME                                             
MFA-TR*           ,'I'                                                          
MFA-TR*           ,:LY-CODE-REPAIR :WS-CODE-REPAIR-NULL-IND                     
MFA-TR*           ,'RETIRE'                                                     
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'INSERT'               TO ABEND-FUNCTION             
              MOVE 'CSS_EQUIP_ATT_TEST'   TO TABLE-1                    
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1            
              MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-2            
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3            
              MOVE 'CODE_ATT_TYPE'        TO TABLE-ELEMENT-4            
              MOVE LY-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1          
              MOVE LY-DEVICE-NO           TO HOSTVAR-ELEMENT-2          
              MOVE LY-COMPANY-NO          TO HOSTVAR-ELEMENT-3          
              MOVE LY-CODE-ATT-TYPE       TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8020-UPDATE-EQUP-ATCH.                                         *        
      ******************************************************************        
       8020-UPDATE-EQUP-ATCH.                                           
                                                                        
           MOVE '8020'                   TO ACTIVE-PARAGRAPH            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIP_ATTCHMTS                                 
                 SET                                                    
                     DATE_LAST_TESTED = IIF(TRY_CONVERT(DATE, 
                                                  :LX-DATE-LAST-TESTED 
                                          :WS-DATE-LAST-TESTED-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TESTED 
                                          :WS-DATE-LAST-TESTED-NULL-IND
              ) <> 0) OR (LEN(:LX-DATE-LAST-TESTED 
                                          :WS-DATE-LAST-TESTED-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TESTED 
                                          :WS-DATE-LAST-TESTED-NULL-IND
              ), CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                          :WS-DATE-LAST-TESTED-NULL-IND
              ) )   
               WHERE COMPANY_NO       = :LX-COMPANY-NO                  
                 AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE              
                 AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE               
                 AND DEVICE_NO        = :LX-DEVICE-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIP_ATTCHMTS                                         
MFA-TR*          SET                                                            
MFA-TR*              DATE_LAST_TESTED = :LX-DATE-LAST-TESTED                    
MFA-TR*                                 :WS-DATE-LAST-TESTED-NULL-IND           
MFA-TR*        WHERE COMPANY_NO       = :LX-COMPANY-NO                          
MFA-TR*          AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE                      
MFA-TR*          AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                       
MFA-TR*          AND DEVICE_NO        = :LX-DEVICE-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                     
              MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1             
              MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-2             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4             
              MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-1           
              MOVE LX-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-2           
              MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8030-UPDATE-EQUP-ATCH.                                         *        
      ******************************************************************        
       8030-UPDATE-EQUP-ATCH.                                           
                                                                        
           MOVE '8030'                   TO ACTIVE-PARAGRAPH            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIP_ATTCHMTS                                 
                 SET                                                    
                     DATE_LAST_MOVE     = IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-LAST-MOVE 
                                                 :WS-DATE-MOVE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                                 :WS-DATE-MOVE-NULL-IND
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE :WS-DATE-MOVE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE 
                                                 :WS-DATE-MOVE-NULL-IND
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                                 :WS-DATE-MOVE-NULL-IND
              ) )        
                    ,DATE_LAST_TRAN     = IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURRENT-DATE 
                                            :WS-DATE-LAST-TRAN-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE 
                                            :WS-DATE-LAST-TRAN-NULL-IND
              ) <> 0) OR (LEN(:WS-CURRENT-DATE 
                                            :WS-DATE-LAST-TRAN-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:WS-CURRENT-DATE 
                                            :WS-DATE-LAST-TRAN-NULL-IND
              ), CONVERT(DATE, :WS-CURRENT-DATE 
                                            :WS-DATE-LAST-TRAN-NULL-IND
              ) )   
                    ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD 
                                          :WS-MTR-STR-FAC-CD-NULL-IND   
                    ,EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID              
C14744              ,IN_TRANSIT_EMP_ID  = :LX-IN-TRANSIT-EMP-ID         
               WHERE DEVICE_NO          = :LX-DEVICE-NO                 
                 AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE             
                 AND COMPANY_NO         = :LX-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIP_ATTCHMTS                                         
MFA-TR*          SET                                                            
MFA-TR*              DATE_LAST_MOVE     = :LX-DATE-LAST-MOVE                    
MFA-TR*                                   :WS-DATE-MOVE-NULL-IND                
MFA-TR*             ,DATE_LAST_TRAN     = :WS-CURRENT-DATE                      
MFA-TR*                                   :WS-DATE-LAST-TRAN-NULL-IND           
MFA-TR*             ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD                
MFA-TR*                                   :WS-MTR-STR-FAC-CD-NULL-IND           
MFA-TR*             ,EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                      
MFA-TR*             ,IN_TRANSIT_EMP_ID  = :LX-IN-TRANSIT-EMP-ID                 
MFA-TR*        WHERE DEVICE_NO          = :LX-DEVICE-NO                         
MFA-TR*          AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                     
MFA-TR*          AND COMPANY_NO         = :LX-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                     
              MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1             
              MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-2             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4             
              MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-1           
              MOVE LX-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-2           
              MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05880000
      * 9900-ERROR HANDLING INCLUDE                                    *05890000
      ******************************************************************05900000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      * 9000-SEND-ERROR-RESULT                                         *        
      * 9999-END-PROGRAM                                               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
