       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04228.                                         
COB303 DATE-WRITTEN.  FEB 18 2009                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC METER *        
      *  ATTACHMENT SCREENS                                            *        
      *                                                                *        
      *  FOLLOWING ARE DONE USING THIS SP                              *        
      *                                                                *        
      *  * TRANSFER METERS, TRANSFORMERS OR BOTH FROM ONE METER TO     *        
      *    ANOTHER METER                                               *        
      *                                                                *        
      *  * ADD ATTACHMENT TO AN EXISTING METER                         *        
      *                                                                *        
      *  * DELETE ALL ATTACHMENTS FOR A GIVEN METER                    *        
      *                                                                *        
      *  * DELETE ONE OR MORE ATTACHMENT FOR A GIVEN METER             *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/18/09  MN90523    PROCEDURE ORIGINALLY CODED.              *        
A00631*  06/16/10  SJ97149    ADDING EQUIP_ATTACH_DT WITH THE NULL OR  *        
A00631*            ACT6324    CURRENT_DATE DEPENDING ON THE            *        
A00631*                       EQUIP-LOC-ID AND ALSO ADDING QUERY NOS   *        
A00631*                       TO SQL'S                                 *        
P00447*  09/13/10  SB40505    ADD CSS_ELEC_CL_SPEC FOR CONSTANT DEFAULT*        
P00447*                       IF CT_METER_FL = 'Y' THEN 0 ELSE 1       *        
P00462*  11/17/10  SB40505    CHANGES FOR SMARTSYNCH AND ADAPTERS      *        
PRJ914*  09/29/15  SS95855    Openway AMI Metering                     *        
P00914*  05/04/16  JC91900    Openway AMI Metering - Prod Fix          *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04228'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04228 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04228'.      
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-CRNT-LOC-NO-X          PIC X(10).                      
           05 WS-CRNT-LOC-NO-9          REDEFINES WS-CRNT-LOC-NO-X      
                                        PIC 9(10).                      
COB305     05 WS-CRNT-LOC-NO        PIC S9(10)V COMP-3 VALUE 0.             
           05 WS-CODE-CRNT-LOC          PIC X(01).                      
           05 WS-SERIAL-NO              PIC X(11).                      
           05 WS-LOCAL-OFFICE           PIC X(03).                      
           05 WS-XFR-CODE-CRNT-LOC      PIC X(01).                      
COB305     05 WS-XFR-CRNT-LOC-NO        PIC S9(10)V COMP-3 VALUE 0.             
           05 WS-XFR-SERIAL-NO          PIC X(11).                      
           05 WS-XFR-LOCAL-OFFICE       PIC X(03).                      
           05 WS-CODE-UTIL-TYPE         PIC X(01) VALUE SPACES.         
           05 WS-CODE-DEVICE-TYPE       PIC X(02) VALUE SPACES.         
           05 WS-NEW-CONSTANT           PIC S9(06)V9(03) VALUE +0.      
           05 WS-OLD-CONSTANT           PIC S9(06)V9(03) VALUE +0.      
           05 WS-CONSTANT-DISP          PIC -ZZZ,ZZ9.999.               
           05 WS-NUMBER-DISP            PIC ZZZ9.                       
           05 WS-IN-CONSTANT           PIC S9(06)V9(03) COMP-3 VALUE +0.
           05 WS-PREV-CONSTANT         PIC S9(06)V9(03) COMP-3 VALUE +0.
           05 WS-CHNG-CONSTANT         PIC S9(06)V9(03) COMP-3 VALUE +0.
           05 WS-PREV-VALUE             PIC X(75) VALUE SPACES.         
           05 WS-CHNG-VALUE             PIC X(75) VALUE SPACES.         
           05 WS-METER-EXISTS           PIC X(01) VALUE 'N'.            
           05 WS-DEVICE-ATTCHED         PIC X(01) VALUE 'N'.            
           05 WS-EQUIP-EXISTS           PIC X(01) VALUE 'N'.            
           05 WS-EQUIP-ATTACH-EXISTS    PIC X(01) VALUE 'N'.            
           05 WS-METER-ATTACHMTS-EXISTS PIC X(01) VALUE 'N'.            
           05 WS-METER-ATT-TYPE-EXISTS  PIC X(01) VALUE 'N'.            
           05 WS-METER-MOVEMNT-EXISTS   PIC X(01) VALUE 'N'.            
           05 WS-GAS-MTR-TEST-EXISTS    PIC X(01) VALUE 'N'.            
           05 WS-TRAN-APPL-NO           PIC S9(04) COMP VALUE +0.       
           05 WS-TRANSHIST-SEQ-NO       PIC X(26).                      
           05 WS-ATTCH-TYP-DEVICE-TX.                                   
              10 WS-ATTCH-TYP-TX        PIC X(02) VALUE SPACES.         
              10 FILLER                 PIC X(01) VALUE SPACES.         
              10 WS-DEVICE-NO-TX        PIC X(12) VALUE SPACES.         
           05 WS-TRANS-CMNT-CONSTANT.                                   
              10 FILLER                 PIC X(37) VALUE                 
                     'CONSTANT CHANGED ON ELECTRIC METER : '.           
              10 WS-CMNT-CNST-DEV-NO-C  PIC X(09) VALUE SPACES.         
              10 FILLER                 PIC X(03) VALUE ' ; '.          
              10 WS-IN-CONST-USR-CMT    PIC X(206) VALUE SPACES.        
           05 WS-TRANS-CMNT-CONST-DEL.                                  
              10 FILLER                 PIC X(60) VALUE                 
       'CONSTANT CHANGED ON ELECTRIC METER ; DELETED ELECTRIC METER '.  
              10 FILLER                 PIC X(31) VALUE                 
                                    'ATTACHMENT FOR THE EQUIPMENT : '.  
              10 WS-CMNT-CNST-DEV-NO-D  PIC X(09) VALUE SPACES.         
              10 FILLER                 PIC X(03) VALUE ' ; '.          
              10 WS-IN-CONST-USR-CMT-D  PIC X(152) VALUE SPACES.        
           05 WS-TRANS-CMNT-ADD-ATTCH.                                  
              10 FILLER                 PIC X(56) VALUE                 
             'ADDED NEW ELECTRIC METER ATTACHMENT FOR THE EQUIPMENT : '.
              10 WS-CMNT-DEVICE-NO-A    PIC X(09) VALUE SPACES.         
              10 FILLER                 PIC X(03) VALUE ' ; '.          
              10 WS-IN-ATTCH-USR-CMT-A  PIC X(187) VALUE SPACES.        
           05 WS-TRANS-CMNT-DEL-ATTCH.                                  
              10 FILLER                 PIC X(54) VALUE                 
             'DELETED ELECTRIC METER ATTACHMENT FOR THE EQUIPMENT : '.  
              10 WS-CMNT-DEVICE-NO-D    PIC X(09) VALUE SPACES.         
              10 FILLER                 PIC X(03) VALUE ' ; '.          
              10 WS-IN-ATTCH-USR-CMT-D  PIC X(189) VALUE SPACES.        
           05 WS-TRANS-CMNT-XFR-ATTCH.                                  
              10 FILLER                 PIC X(43) VALUE                 
             'ELECTRIC METER ATTACHMENT TRANSFERRED FROM '.             
              10 WS-CMNT-FRM-METER-NO-X PIC X(09) VALUE SPACES.         
              10 FILLER                 PIC X(04) VALUE ' TO '.         
              10 WS-CMNT-TO-METER-NO-X  PIC X(09) VALUE SPACES.         
              10 FILLER                 PIC X(03) VALUE ' ; '.          
              10 WS-IN-ATTCH-USR-CMT-X  PIC X(187) VALUE SPACES.        
           05 WS-LEN-OF-COMMENTS        PIC X(255) VALUE SPACES.        
           05 WS-CMNTS                  PIC X(255) VALUE SPACES.        
           05 WS-COMMENTS-LEN           PIC S9(04) COMP VALUE +0.       
           05 WS-ATTCH-COUNT            PIC S9(9) COMP VALUE ZERO.      
           05 WS-CURRENT-TIMESTAMP      PIC X(26).                      
           05 WS-CURRENT-DATE           PIC X(10).                      
           05 WS-RMT-RD-CODE            PIC X(01) VALUE SPACES.         
           05 WS-FULL-SCALE-DISP        PIC -ZZ,ZZ9.9999.               
           05 WS-CODE-ATTACHMENT-FLAGS.                                 
              10 WS-ATT-CT-RATED        PIC X(01) VALUE 'N'.            
              10 WS-ATT-PT-RATED        PIC X(01) VALUE 'N'.            
              10 WS-ATT-MAG-TAPE        PIC X(01) VALUE 'N'.            
              10 WS-ATT-IDR-DEVC        PIC X(01) VALUE 'N'.            
              10 WS-ATT-REACTIVE-MTR    PIC X(01) VALUE 'N'.            
              10 WS-ATT-V2H-MTR         PIC X(01) VALUE 'N'.            
           05 WS-IN-UPDATE-IND          PIC X(01) VALUE SPACES.         
           05 WS-IN-TRANSFER-TYPE       PIC X(01) VALUE SPACES.         
           05 WS-IN-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.         
           05 WS-IN-COMPANY-NO          PIC X(02) VALUE SPACES.         
           05 WS-IN-DEVICE-NO           PIC X(09) VALUE SPACES.         
           05 WS-IN-XFR-TO-DEVICE-NO    PIC X(09) VALUE SPACES.         
           05 WS-IN-XFR-TO-SERIAL-NO    PIC X(11) VALUE SPACES.         
           05 WS-IN-ALLOW-OVERRIDE      PIC X(01) VALUE SPACES.         
           05 WS-IN-TEST-SCHED-CD       PIC X(01) VALUE SPACES.         
           05 WS-IN-SECURITY-FLAG       PIC X(01) VALUE SPACES.         
           05 WS-IN-COMMENTS            PIC X(255) VALUE SPACES.        
           05 WS-IN-TRAN-COMMENTS       PIC X(255) VALUE SPACES.        
           05 WS-IN-USER-ID             PIC X(07) VALUE SPACES.         
           05 WS-IN-APPL-PROGRAM-ID     PIC X(08) VALUE SPACES.         
                                                                        
       01  WS-WORK-FIELDS-CONSTANTS.                                    
           05 WS-ATT-TYPE-ERT           PIC X(02) VALUE 'IT'.           
P00462     05 WS-ATT-TYPE-SMARTSYNCH    PIC X(02) VALUE 'SS'.           
P00462     05 WS-ATT-TYPE-KBASE         PIC X(02) VALUE 'KA'.           
PRJ914     05 WS-ATT-TYPE-OPENWAY       PIC X(02) VALUE 'OW'.           
           05 WS-ATT-TYPE-DC            PIC X(02) VALUE 'DC'.           
           05 WS-TRNSFR-ALL-A           PIC X(01) VALUE 'A'.            
           05 WS-TRNSFR-METERS-M        PIC X(01) VALUE 'M'.            
           05 WS-TRNSFR-TRANSFORMERS-T  PIC X(01) VALUE 'T'.            
           05 WS-LOCATION-ATTACHED-K    PIC X(01) VALUE 'K'.            
           05 WS-LOCATION-AT-CUSTOMER-J PIC X(01) VALUE 'J'.            
           05 WS-LOCATION-INVENTORY-A   PIC X(01) VALUE 'A'.            
           05 WS-LOCATION-METER-SHOP-B  PIC X(01) VALUE 'B'.            
           05 WS-CURRENT-XFORMER-CT     PIC X(02) VALUE 'CT'.           
           05 WS-POTENTIAL-XFORMER-PT   PIC X(02) VALUE 'PT'.           
           05 WS-UTIL-TYPE-XFORMER-X    PIC X(01) VALUE 'X'.            
           05 WS-UTIL-TYPE-ELECTRIC-E   PIC X(01) VALUE 'E'.            
           05 WS-DEVICE-XFORMER-T       PIC X(01) VALUE 'T'.            
           05 WS-DEVICE-METER-M         PIC X(01) VALUE 'M'.            
           05 WS-RANDOM-TESTING-R       PIC X(01) VALUE 'R'.            
           05 WS-ATT-CT-RATED-CT        PIC X(02) VALUE 'CT'.           
           05 WS-ATT-PT-RATED-PT        PIC X(02) VALUE 'PT'.           
           05 WS-ATT-MAG-TAPE-MT        PIC X(02) VALUE 'MT'.           
           05 WS-ATT-IDR-DEVC-ID        PIC X(02) VALUE 'ID'.           
           05 WS-ATT-REACTIVE-MTR-RE    PIC X(02) VALUE 'RE'.           
           05 WS-ATT-V2H-MTR-VH         PIC X(02) VALUE 'VH'.           
           05 WS-ATT-BACKUP-MTR         PIC X(02) VALUE 'BU'.           
           05 WS-UPDATE-U               PIC X(01) VALUE 'U'.            
           05 WS-DELETE-D               PIC X(01) VALUE 'D'.            
           05 WS-ADD-A                  PIC X(01) VALUE 'A'.            
           05 WS-TRANSFER-K             PIC X(01) VALUE 'K'.            
                                                                        
       01  WS-ALL-ATTCH-INFO            PIC X(800) VALUE SPACES.        
       01  WS-ATTCH-INFO-TABLE          REDEFINES WS-ALL-ATTCH-INFO.    
           05 WS-ATTCH-INFO-REC OCCURS 20 TIMES                         
                                      INDEXED BY ATTCH-INDX.            
             10 WS-ARRY-ATTCH-INFO.                                     
                15 WS-ARRY-ATTACH-TYPE PIC X(02).                       
                15 WS-ARRY-DEVICE-NO   PIC X(12).                       
                15 WS-ARRY-SERIAL-NO   PIC X(25).                       
                15 WS-ARRY-HOW-ATTCH   PIC X(01).                       
                                                                        
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-CONSTANT-SW          PIC X(01) VALUE 'Y'.             
               88 WS-CONSTANT-CHANGED            VALUE 'Y'.             
               88 WS-CONSTANT-NOT-CHANGED        VALUE 'N'.             
           05  WS-TRANSFORMER-REMV-SW  PIC X(01) VALUE 'Y'.             
               88 WS-XFORMER-REMOVED             VALUE 'Y'.             
               88 WS-XFORMER-NOT-REMOVED         VALUE 'N'.             
           05  WS-XFORMER-SW           PIC X(01) VALUE 'Y'.             
               88 WS-XFORMER-FOUND               VALUE 'Y'.             
               88 WS-XFORMER-NOT-FOUND           VALUE 'N'.             
           05  WS-METER-SW             PIC X(01) VALUE 'Y'.             
               88 WS-METER-FOUND                 VALUE 'Y'.             
               88 WS-METER-NOT-FOUND             VALUE 'N'.             
           05  WS-CONSTANT-UPDT-SW     PIC X(01) VALUE 'N'.             
               88 WS-CONSTANT-UPDATE             VALUE 'Y'.             
               88 WS-CONSTANT-NOT-UPDATED        VALUE 'N'.             
PRJ914     05  WS-ATTACHMENT-TYPE      PIC X(01) VALUE ' '.             
PRJ914         88 Q-TYPE-ATTACHMENT              VALUE 'Q'.             
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
           05  RS-INFO-RETURN-CODE       PIC S9(09) COMP VALUE 0.       
           05  RS-DEVICE-ATTACHD-TO-MTR  PIC X(09) VALUE SPACES.        
           05  RS-ROW-NUM                PIC S9(04) COMP VALUE 0.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
           05  S-INFO-RETURN-CODE        PIC S9(09) COMP VALUE 0.       
           05  S-DEVICE-ATTACHD-TO-MTR   PIC X(09) VALUE SPACES.        
           05  S-ROW-NUM                 PIC S9(04) COMP VALUE 0.       
                                                                        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-DATE-LST-TST-NULL       PIC S9(04) COMP VALUE 0.       
           05 WS-DT-LST-MOVE-NULL        PIC S9(04) COMP VALUE 0.       
A00631     05 WS-EQUIP-ATTACH-DT-NULL    PIC S9(04) COMP VALUE 0.       
P00462     05 WS-LX-DT-PURCHASE-NULL-IND PIC S9(04) COMP VALUE 0.       
P00462     05 WS-LX-DT-LST-MOVE-NULL-IND PIC S9(04) COMP VALUE 0.       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT        - AT                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CUST_PREM_HIST - CH                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ELEC_METER     - EM                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIPMENT      - EQ                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ELEC_MTR_SPEC  - U5                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTRSP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATTCHMTS - LX                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQATTH                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATT_MOVE - MP                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQMOVE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_INSTR_XFORMER  - IX                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINXFOR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS - MA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MOVEMENT_HIST  - MV                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_ATT_TYPE   - N5                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_CAP        - MC                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MNT_TRANS_HIST - MH                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MT_TRN_HST_DET -  MI                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_RESP_AREA      -  C1                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
      *                                                                         
P00447******************************************************************        
P00447* CSS_ELEC_CL_SPEC, U0                                           *        
P00447******************************************************************        
P00447     EXEC SQL                                                             
P00447         INCLUDE TBELCLSP                                                 
P00447     END-EXEC.                                                            
P00447*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00526                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ***************************************************************           
      * CURSOR DECLARATIONS                                                     
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                     
             DECLARE CSS_MTR_ATTCH_CUR CURSOR FOR                       
             SELECT                                                     
                 MA.CODE_UTIL_TYPE                                      
                ,MA.METER_NO                                            
                ,MA.CODE_DEVICE_TYPE                                    
                ,MA.DEVICE_NO                                           
                ,MA.CODE_ATT_TYPE                                       
                ,MA.DATE_LAST_TESTED                                    
                ,MA.TEST_SCHED_CD                                       
                ,EQ.LOCAL_OFFICE                                        
                ,EQ.CODE_CRNT_LOC                                       
                ,MA.CT_PT_RATIO                                         
                ,MA.HOW_ATTACHED_CD                                     
             FROM                                                       
                 CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                    
                ,CSS_EQUIPMENT      EQ WITH(READUNCOMMITTED)                    
P00462          ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)                    
             WHERE                                                      
                 MA.METER_NO       = EQ.DEVICE_NO                       
             AND MA.COMPANY_NO     = EQ.COMPANY_NO                      
             AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                  
             AND MA.HOW_ATTACHED_CD <> 'I'                              
             AND MA.METER_NO       = :MA-METER-NO                       
             AND MA.COMPANY_NO     = :MA-COMPANY-NO                     
             AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                 
P00462       AND N5.CODE_UTIL_TYPE = MA.CODE_UTIL_TYPE                  
P00462       AND N5.CODE_ATT_TYPE = MA.CODE_ATT_TYPE                    
P00462       AND N5.CODE_DEVICE_TYPE <> 'Q'                             
                                                                 
A00631                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CSS_MTR_ATTCH_CUR CURSOR FOR                               
MFA-TR*      SELECT                                                             
MFA-TR*          MA.CODE_UTIL_TYPE                                              
MFA-TR*         ,MA.METER_NO                                                    
MFA-TR*         ,MA.CODE_DEVICE_TYPE                                            
MFA-TR*         ,MA.DEVICE_NO                                                   
MFA-TR*         ,MA.CODE_ATT_TYPE                                               
MFA-TR*         ,MA.DATE_LAST_TESTED                                            
MFA-TR*         ,MA.TEST_SCHED_CD                                               
MFA-TR*         ,EQ.LOCAL_OFFICE                                                
MFA-TR*         ,EQ.CODE_CRNT_LOC                                               
MFA-TR*         ,MA.CT_PT_RATIO                                                 
MFA-TR*         ,MA.HOW_ATTACHED_CD                                             
MFA-TR*      FROM                                                               
MFA-TR*          CSS_METER_ATTCHMTS MA                                          
MFA-TR*         ,CSS_EQUIPMENT      EQ                                          
MFA-TR*         ,CSS_MTR_ATT_TYPE   N5                                          
MFA-TR*      WHERE                                                              
MFA-TR*          MA.METER_NO       = EQ.DEVICE_NO                               
MFA-TR*      AND MA.COMPANY_NO     = EQ.COMPANY_NO                              
MFA-TR*      AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                          
MFA-TR*      AND MA.HOW_ATTACHED_CD <> 'I'                                      
MFA-TR*      AND MA.METER_NO       = :MA-METER-NO                               
MFA-TR*      AND MA.COMPANY_NO     = :MA-COMPANY-NO                             
MFA-TR*      AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                         
MFA-TR*      AND N5.CODE_UTIL_TYPE = MA.CODE_UTIL_TYPE                          
MFA-TR*      AND N5.CODE_ATT_TYPE = MA.CODE_ATT_TYPE                            
MFA-TR*      AND N5.CODE_DEVICE_TYPE <> 'Q'                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE CSS_MTR_ATTCH_DEL CURSOR FOR                       
             SELECT                                                     
                 MA.CODE_UTIL_TYPE                                      
                ,MA.METER_NO                                            
                ,MA.CODE_DEVICE_TYPE                                    
                ,MA.DEVICE_NO                                           
                ,MA.CODE_ATT_TYPE                                       
                ,MA.DATE_LAST_TESTED                                    
                ,MA.TEST_SCHED_CD                                       
                ,EQ.LOCAL_OFFICE                                        
                ,EQ.CODE_CRNT_LOC                                       
                ,MA.CT_PT_RATIO                                         
                ,MA.HOW_ATTACHED_CD                                     
             FROM                                                       
                 CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                    
                ,CSS_EQUIPMENT      EQ WITH(READUNCOMMITTED)                    
             WHERE                                                      
                 MA.METER_NO       = EQ.DEVICE_NO                       
             AND MA.COMPANY_NO     = EQ.COMPANY_NO                      
             AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                  
             AND MA.METER_NO       = :MA-METER-NO                       
             AND MA.COMPANY_NO     = :MA-COMPANY-NO                     
             AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                 
                                                                 
A00631                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CSS_MTR_ATTCH_DEL CURSOR FOR                               
MFA-TR*      SELECT                                                             
MFA-TR*          MA.CODE_UTIL_TYPE                                              
MFA-TR*         ,MA.METER_NO                                                    
MFA-TR*         ,MA.CODE_DEVICE_TYPE                                            
MFA-TR*         ,MA.DEVICE_NO                                                   
MFA-TR*         ,MA.CODE_ATT_TYPE                                               
MFA-TR*         ,MA.DATE_LAST_TESTED                                            
MFA-TR*         ,MA.TEST_SCHED_CD                                               
MFA-TR*         ,EQ.LOCAL_OFFICE                                                
MFA-TR*         ,EQ.CODE_CRNT_LOC                                               
MFA-TR*         ,MA.CT_PT_RATIO                                                 
MFA-TR*         ,MA.HOW_ATTACHED_CD                                             
MFA-TR*      FROM                                                               
MFA-TR*          CSS_METER_ATTCHMTS MA                                          
MFA-TR*         ,CSS_EQUIPMENT      EQ                                          
MFA-TR*      WHERE                                                              
MFA-TR*          MA.METER_NO       = EQ.DEVICE_NO                               
MFA-TR*      AND MA.COMPANY_NO     = EQ.COMPANY_NO                              
MFA-TR*      AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                          
MFA-TR*      AND MA.METER_NO       = :MA-METER-NO                               
MFA-TR*      AND MA.COMPANY_NO     = :MA-COMPANY-NO                             
MFA-TR*      AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7190                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE CSS_CODE_ATTCH_CUR CURSOR FOR                      
             SELECT                                                     
                 MA.CODE_ATT_TYPE                                       
             FROM                                                       
                 CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                    
             WHERE                                                      
                 MA.METER_NO       = :MA-METER-NO                       
             AND MA.COMPANY_NO     = :MA-COMPANY-NO                     
             AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                 
                                                                 
A00631                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CSS_CODE_ATTCH_CUR CURSOR FOR                              
MFA-TR*      SELECT                                                             
MFA-TR*          MA.CODE_ATT_TYPE                                               
MFA-TR*      FROM                                                               
MFA-TR*          CSS_METER_ATTCHMTS MA                                          
MFA-TR*      WHERE                                                              
MFA-TR*          MA.METER_NO       = :MA-METER-NO                               
MFA-TR*      AND MA.COMPANY_NO     = :MA-COMPANY-NO                             
MFA-TR*      AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7140                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE CSS_MTR_CAP_CNST_CUR CURSOR FOR                    
             SELECT                                                     
                  MC.CONSTANT                                           
                 ,MA.CODE_ATT_TYPE                                      
                 ,EM.METER_NO                                           
                 ,MA.CT_PT_RATIO                                        
                 ,MA.DEVICE_NO                                          
                 ,XT.RTO_UPPER_FRACTION                                 
                 ,XT.RTO_LOWER_FRACTION                                 
             FROM                                                       
                  CSS_ELEC_METER     EM WITH(READUNCOMMITTED)                   
                 ,CSS_MTR_CAP        MC WITH(READUNCOMMITTED)                   
                 ,CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                   
                 ,CSS_EQUIPMENT      EQ WITH(READUNCOMMITTED)                   
                 ,CSS_INSTR_XFORMER  XT WITH(READUNCOMMITTED)                   
             WHERE                                                      
                   EQ.DEVICE_NO      = :EQ-DEVICE-NO                    
               AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                   
               AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE               
               AND MA.METER_NO       = EQ.DEVICE_NO                     
               AND MA.COMPANY_NO     = EQ.COMPANY_NO                    
               AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                
               AND MA.CODE_ATT_TYPE  IN ('CT', 'PT')                    
               AND MC.METER_NO       = MA.METER_NO                      
               AND MC.COMPANY_NO     = MA.COMPANY_NO                    
               AND MC.CODE_UTIL_TYPE = MA.CODE_UTIL_TYPE                
               AND MC.CODE_CAP_TYPE  = 'A'                              
               AND EM.METER_NO       = MC.METER_NO                      
               AND EM.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                
               AND XT.XFORMER_NO     = MA.DEVICE_NO                     
               AND XT.CODE_UTIL_TYPE = 'X'                              
               AND XT.COMPANY_NO     = MA.COMPANY_NO                    
                                                                 
A00631                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CSS_MTR_CAP_CNST_CUR CURSOR FOR                            
MFA-TR*      SELECT                                                             
MFA-TR*           MC.CONSTANT                                                   
MFA-TR*          ,MA.CODE_ATT_TYPE                                              
MFA-TR*          ,EM.METER_NO                                                   
MFA-TR*          ,MA.CT_PT_RATIO                                                
MFA-TR*          ,MA.DEVICE_NO                                                  
MFA-TR*          ,XT.RTO_UPPER_FRACTION                                         
MFA-TR*          ,XT.RTO_LOWER_FRACTION                                         
MFA-TR*      FROM                                                               
MFA-TR*           CSS_ELEC_METER     EM                                         
MFA-TR*          ,CSS_MTR_CAP        MC                                         
MFA-TR*          ,CSS_METER_ATTCHMTS MA                                         
MFA-TR*          ,CSS_EQUIPMENT      EQ                                         
MFA-TR*          ,CSS_INSTR_XFORMER  XT                                         
MFA-TR*      WHERE                                                              
MFA-TR*            EQ.DEVICE_NO      = :EQ-DEVICE-NO                            
MFA-TR*        AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                           
MFA-TR*        AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                       
MFA-TR*        AND MA.METER_NO       = EQ.DEVICE_NO                             
MFA-TR*        AND MA.COMPANY_NO     = EQ.COMPANY_NO                            
MFA-TR*        AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                        
MFA-TR*        AND MA.CODE_ATT_TYPE  IN ('CT', 'PT')                            
MFA-TR*        AND MC.METER_NO       = MA.METER_NO                              
MFA-TR*        AND MC.COMPANY_NO     = MA.COMPANY_NO                            
MFA-TR*        AND MC.CODE_UTIL_TYPE = MA.CODE_UTIL_TYPE                        
MFA-TR*        AND MC.CODE_CAP_TYPE  = 'A'                                      
MFA-TR*        AND EM.METER_NO       = MC.METER_NO                              
MFA-TR*        AND EM.CODE_UTIL_TYPE = MC.CODE_UTIL_TYPE                        
MFA-TR*        AND XT.XFORMER_NO     = MA.DEVICE_NO                             
MFA-TR*        AND XT.CODE_UTIL_TYPE = 'X'                                      
MFA-TR*        AND XT.COMPANY_NO     = MA.COMPANY_NO                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-UPDATE-IND           PIC X(01).                          
       01 PARM-TRANSFER-TYPE        PIC X(01).                          
       01 PARM-CODE-UTIL-TYPE       PIC X(01).                          
       01 PARM-COMPANY-NO           PIC X(02).                          
       01 PARM-DEVICE-NO            PIC X(09).                          
       01 PARM-XFR-TO-DEVICE-NO     PIC X(09).                          
       01 PARM-XFR-TO-SERIAL-NO     PIC X(11).                          
       01 PARM-ALLOW-OVERRIDE       PIC X(01).                          
       01 PARM-TEST-SCHED-CD        PIC X(01).                          
COB305 01 PARM-CONSTANT        PIC S9(06)V9(03) COMP-3 VALUE 0.            
       01 PARM-SECURITY-FLAG        PIC X(01).                          
       01 PARM-COMMENTS             PIC X(255).                         
       01 PARM-TRAN-COMMENTS        PIC X(255).                         
       01 PARM-USER-ID              PIC X(07).                          
       01 PARM-APPL-PROGRAM-ID      PIC X(08).                          
       01 PARM-ATTCH-INFO-01        PIC X(40).                          
       01 PARM-ATTCH-INFO-02        PIC X(40).                          
       01 PARM-ATTCH-INFO-03        PIC X(40).                          
       01 PARM-ATTCH-INFO-04        PIC X(40).                          
       01 PARM-ATTCH-INFO-05        PIC X(40).                          
       01 PARM-ATTCH-INFO-06        PIC X(40).                          
       01 PARM-ATTCH-INFO-07        PIC X(40).                          
       01 PARM-ATTCH-INFO-08        PIC X(40).                          
       01 PARM-ATTCH-INFO-09        PIC X(40).                          
       01 PARM-ATTCH-INFO-10        PIC X(40).                          
       01 PARM-ATTCH-INFO-11        PIC X(40).                          
       01 PARM-ATTCH-INFO-12        PIC X(40).                          
       01 PARM-ATTCH-INFO-13        PIC X(40).                          
       01 PARM-ATTCH-INFO-14        PIC X(40).                          
       01 PARM-ATTCH-INFO-15        PIC X(40).                          
       01 PARM-ATTCH-INFO-16        PIC X(40).                          
       01 PARM-ATTCH-INFO-17        PIC X(40).                          
       01 PARM-ATTCH-INFO-18        PIC X(40).                          
       01 PARM-ATTCH-INFO-19        PIC X(40).                          
       01 PARM-ATTCH-INFO-20        PIC X(40).                          
      *                                                                         
       PROCEDURE DIVISION USING PARM-UPDATE-IND                         
                                PARM-TRANSFER-TYPE                      
                                PARM-CODE-UTIL-TYPE                     
                                PARM-COMPANY-NO                         
                                PARM-DEVICE-NO                          
                                PARM-XFR-TO-DEVICE-NO                   
                                PARM-XFR-TO-SERIAL-NO                   
                                PARM-ALLOW-OVERRIDE                     
                                PARM-TEST-SCHED-CD                      
                                PARM-CONSTANT                           
                                PARM-SECURITY-FLAG                      
                                PARM-COMMENTS                           
                                PARM-TRAN-COMMENTS                      
                                PARM-USER-ID                            
                                PARM-APPL-PROGRAM-ID                    
                                PARM-ATTCH-INFO-01                      
                                PARM-ATTCH-INFO-02                      
                                PARM-ATTCH-INFO-03                      
                                PARM-ATTCH-INFO-04                      
                                PARM-ATTCH-INFO-05                      
                                PARM-ATTCH-INFO-06                      
                                PARM-ATTCH-INFO-07                      
                                PARM-ATTCH-INFO-08                      
                                PARM-ATTCH-INFO-09                      
                                PARM-ATTCH-INFO-10                      
                                PARM-ATTCH-INFO-11                      
                                PARM-ATTCH-INFO-12                      
                                PARM-ATTCH-INFO-13                      
                                PARM-ATTCH-INFO-14                      
                                PARM-ATTCH-INFO-15                      
                                PARM-ATTCH-INFO-16                      
                                PARM-ATTCH-INFO-17                      
                                PARM-ATTCH-INFO-18                      
                                PARM-ATTCH-INFO-19                      
                                PARM-ATTCH-INFO-20.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                  :S-RETURN-CODE             AS RETURN_CODE             
                 ,:S-INFO-RETURN-CODE        AS INFO_RETURN_CODE        
                 ,:S-DEVICE-ATTACHD-TO-MTR   AS DEVICE_ATTACHD_TO_MTR   
                 ,:S-ROW-NUM                 AS ROW_NUM                 
             FROM                                                       
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*           :S-RETURN-CODE             AS RETURN_CODE                     
MFA-TR*          ,:S-INFO-RETURN-CODE        AS INFO_RETURN_CODE                
MFA-TR*          ,:S-DEVICE-ATTACHD-TO-MTR   AS DEVICE_ATTACHD_TO_MTR           
MFA-TR*          ,:S-ROW-NUM                 AS ROW_NUM                         
MFA-TR*      FROM                                                               
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS                        
                                          THRU 1200-EXIT.               
                                                                        
           MOVE PARM-UPDATE-IND           TO WS-IN-UPDATE-IND           
           MOVE PARM-TRANSFER-TYPE        TO WS-IN-TRANSFER-TYPE        
           MOVE PARM-CODE-UTIL-TYPE       TO WS-IN-CODE-UTIL-TYPE       
           MOVE PARM-COMPANY-NO           TO WS-IN-COMPANY-NO           
           MOVE PARM-DEVICE-NO            TO WS-IN-DEVICE-NO            
           MOVE PARM-XFR-TO-DEVICE-NO     TO WS-IN-XFR-TO-DEVICE-NO     
           MOVE PARM-XFR-TO-SERIAL-NO     TO WS-IN-XFR-TO-SERIAL-NO     
           MOVE PARM-ALLOW-OVERRIDE       TO WS-IN-ALLOW-OVERRIDE       
           MOVE PARM-TEST-SCHED-CD        TO WS-IN-TEST-SCHED-CD        
           MOVE PARM-CONSTANT             TO WS-IN-CONSTANT             
           MOVE PARM-SECURITY-FLAG        TO WS-IN-SECURITY-FLAG        
           MOVE PARM-COMMENTS             TO WS-IN-COMMENTS             
           MOVE PARM-TRAN-COMMENTS        TO WS-IN-TRAN-COMMENTS        
           MOVE PARM-USER-ID              TO WS-IN-USER-ID              
                                                                        
           IF PARM-APPL-PROGRAM-ID = SPACES                             
              MOVE PROGRAM-NAME           TO WS-IN-APPL-PROGRAM-ID      
           ELSE                                                         
              MOVE PARM-APPL-PROGRAM-ID   TO WS-IN-APPL-PROGRAM-ID      
           END-IF                                                       
                                                                        
           STRING PARM-ATTCH-INFO-01 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-02 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-03 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-04 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-05 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-06 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-07 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-08 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-09 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-10 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-11 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-12 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-13 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-14 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-15 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-16 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-17 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-18 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-19 DELIMITED BY SIZE                  
                 ,PARM-ATTCH-INFO-20 DELIMITED BY SIZE                  
                                       INTO WS-ALL-ATTCH-INFO.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1200-VALIDATE-INPUT-ARGUMENTS.                                 *        
      ******************************************************************        
      *                                                                         
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-COMPANY-NO     = SPACES OR                           
              PARM-CODE-UTIL-TYPE = SPACES OR                           
              PARM-UPDATE-IND     = SPACES OR                           
              PARM-DEVICE-NO      = SPACES OR                           
              (PARM-SECURITY-FLAG  NOT = 'Y' AND                        
              PARM-SECURITY-FLAG NOT = 'N')                             
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-1          
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-2          
              MOVE 'PARM-UPDATE-IND'        TO TABLE-ELEMENT-3          
              MOVE 'PARM-DEVICE-NO'         TO TABLE-ELEMENT-4          
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2        
              MOVE PARM-UPDATE-IND          TO HOSTVAR-ELEMENT-3        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *  PERFORMS THE FOLLOWING PROCESS WHEN                                    
      *                                                                         
      *  UPDATE INDICATOR IS                                                    
      *                                                                         
      *     'K' - TRANSFERS ATTACHMENTS FROM ONE METER TO ANOTHER               
      *           BASED ON THE TRASFER TYPE                                     
      *     'A' - ADDS ATTACHMENTS TO A METER WHICH ARE PASSED THRU             
      *           ATTACHMENT INFO INPUT ARGUMENT                                
      *     'D' - DELETES ALL THE ATTACHMENTS FROM A METER                      
      *     'U' - DELETES ONE OR MORE ATTACHMENTS FROM A METER BASED ON         
      *           THE ATTACHMENT INFO INPUT ARGUMENT                            
      *                                                                         
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7160-GET-CURRENT-TIMESTAMP                           
                                            THRU 7160-EXIT.             
                                                                        
           MOVE WS-IN-COMPANY-NO            TO EQ-COMPANY-NO.           
           MOVE WS-IN-CODE-UTIL-TYPE        TO EQ-CODE-UTIL-TYPE.       
           MOVE WS-IN-DEVICE-NO             TO EQ-DEVICE-NO.            
                                                                        
           PERFORM 7000-GET-EQUIP-DETIALS   THRU 7000-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE NOT-FOUND                TO RS-RETURN-CODE           
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           ELSE                                                         
              MOVE EQ-CODE-CRNT-LOC         TO WS-CODE-CRNT-LOC         
              MOVE EQ-CRNT-LOC-NO           TO WS-CRNT-LOC-NO           
              MOVE EQ-SERIAL-NO             TO WS-SERIAL-NO             
              MOVE EQ-LOCAL-OFFICE          TO WS-LOCAL-OFFICE          
           END-IF.                                                      
P00447*                                                                         
P00447     MOVE WS-IN-COMPANY-NO            TO EM-COMPANY-NO.           
P00447     MOVE WS-IN-CODE-UTIL-TYPE        TO EM-CODE-UTIL-TYPE.       
P00447     MOVE WS-IN-DEVICE-NO             TO EM-METER-NO.             
P00447                                                                  
P00447**** FIND CT_METER_FL IF 'Y' THEN CONSTANT = 0 ELSE 1                     
P00447     PERFORM 7200-GET-CONSTANT-DEFAULT                            
P00447        THRU 7200-EXIT                                            
P00447     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
P00447        MOVE NOT-FOUND                TO RS-RETURN-CODE           
P00447        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
P00447        PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
P00447     ELSE                                                         
P00447        IF U0-CT-METER-FL = 'Y' THEN                              
P00447           MOVE +0 TO WS-DEFAULT-CONSTANT                         
P00447        ELSE                                                      
P00447           MOVE +1 TO WS-DEFAULT-CONSTANT                         
P00447        END-IF                                                    
P00447     END-IF                                                       
P00447*                                                                         
                                                                        
           EVALUATE WS-IN-UPDATE-IND                                    
             WHEN WS-TRANSFER-K                                         
                PERFORM 2100-PROCESS-TRANSFER                           
                                            THRU 2100-EXIT              
             WHEN WS-ADD-A                                              
                PERFORM 2200-PROCESS-ADD-ATTACHMENTS                    
                                            THRU 2200-EXIT              
             WHEN WS-DELETE-D                                           
                PERFORM 2300-PROCESS-DELETE-ATTCHMNTS                   
                                            THRU 2300-EXIT              
             WHEN WS-UPDATE-U                                           
                PERFORM 2400-PROCESS-UPDATE-ATTCHMNTS                   
                                            THRU 2400-EXIT              
             WHEN OTHER                                                 
                MOVE 9999                   TO WS-ACTIVE-RETURN-CODE    
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
                MOVE '2000'                 TO ACTIVE-PARAGRAPH         
                MOVE 'EVALUATE'             TO ABEND-FUNCTION           
                MOVE 'WS-IN-UPDATE-IND'     TO TABLE-1                  
                MOVE 'WS-IN-UPDATE-IND'     TO TABLE-ELEMENT-1          
                MOVE WS-IN-UPDATE-IND       TO HOSTVAR-ELEMENT-1        
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
           IF CTR-ROWS = 0                                              
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              ADD +1                        TO CTR-ROWS                 
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT                                                        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE             TO S-RETURN-CODE             
           MOVE RS-INFO-RETURN-CODE        TO S-INFO-RETURN-CODE        
           MOVE RS-DEVICE-ATTACHD-TO-MTR   TO S-DEVICE-ATTACHD-TO-MTR   
           MOVE RS-ROW-NUM                 TO S-ROW-NUM                 
           ADD +1                          TO CTR-ROWS.                 
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      *2100-PROCESS-TRANSFER                                                    
      *                                                                         
      *  TRANSFERS ATTACHMENTS FROM ONE METER TO ANOTHER METER                  
      *                                                                         
      *  IF TRANSFER TYPE IS                                                    
      *                                                                         
      *     'A' - TRANSFER ALL THE TYPE FOR ATTACHMENTS                         
      *     'M' - TRANSFER ALL THE METER TYPE ATTACHMENTS                       
      *     'T' - TRANSFER ALL THE TRANSFORMER YPE ATTACHMENTS                  
      *                                                                         
      ******************************************************************        
      *                                                                         
       2100-PROCESS-TRANSFER.                                           
      *                                                                         
                                                                        
           PERFORM 2110-PROCESS-EQUIP-DETAILS                           
                                            THRU 2110-EXIT              
                                                                        
           EVALUATE WS-IN-TRANSFER-TYPE                                 
             WHEN WS-TRNSFR-ALL-A                                       
                PERFORM 2120-PROCESS-TRSFR-ALL                          
                                            THRU 2120-EXIT              
             WHEN WS-TRNSFR-METERS-M                                    
                PERFORM 2140-PROCESS-TRSFR-METERS                       
                                            THRU 2140-EXIT              
             WHEN WS-TRNSFR-TRANSFORMERS-T                              
                PERFORM 2160-PROCESS-TRSFR-XFORMRS                      
                                            THRU 2160-EXIT              
             WHEN OTHER                                                 
                MOVE 9999                   TO WS-ACTIVE-RETURN-CODE    
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
                MOVE '2110'                 TO ACTIVE-PARAGRAPH         
                MOVE 'EVALUATE'             TO ABEND-FUNCTION           
                MOVE 'WS-IN-TRANSFER-TYPE'  TO TABLE-1                  
                MOVE 'WS-IN-TRANSFER-TYPE'  TO TABLE-ELEMENT-1          
                MOVE WS-IN-TRANSFER-TYPE    TO HOSTVAR-ELEMENT-1        
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
                                                                        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2110-PROCESS-EQUIP-DETAILS.                                    *        
      ******************************************************************        
      *                                                                         
       2110-PROCESS-EQUIP-DETAILS.                                      
                                                                        
           MOVE WS-IN-COMPANY-NO               TO EQ-COMPANY-NO         
                                                  MA-COMPANY-NO.        
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE           TO EQ-CODE-UTIL-TYPE     
                                                  MA-CODE-UTIL-TYPE.    
                                                                        
           MOVE WS-IN-XFR-TO-DEVICE-NO         TO EQ-DEVICE-NO.         
                                                                        
           PERFORM 7000-GET-EQUIP-DETIALS      THRU 7000-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 4100                        TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           ELSE                                                         
              MOVE EQ-CODE-CRNT-LOC            TO WS-XFR-CODE-CRNT-LOC  
              MOVE EQ-CRNT-LOC-NO              TO WS-XFR-CRNT-LOC-NO    
              MOVE EQ-SERIAL-NO                TO WS-XFR-SERIAL-NO      
              MOVE EQ-LOCAL-OFFICE             TO WS-XFR-LOCAL-OFFICE   
           END-IF.                                                      
                                                                        
           IF WS-XFR-SERIAL-NO NOT = WS-IN-XFR-TO-SERIAL-NO             
              MOVE 4200                        TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
           MOVE 'N'                      TO WS-METER-ATTACHMTS-EXISTS.  
           MOVE WS-IN-XFR-TO-DEVICE-NO         TO MA-METER-NO.          
                                                                        
           PERFORM 7010-CHECK-METER-ATTACHEMENTS                        
                                               THRU 7010-EXIT.          
                                                                        
           IF WS-METER-ATTACHMTS-EXISTS = 'Y'                           
              MOVE 4300                        TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K OR              
              WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J              
                                                                        
              MOVE WS-CRNT-LOC-NO              TO CH-PREMISE-NO         
              PERFORM 7120-GET-ACCOUNT-DETAILS THRU 7120-EXIT           
           ELSE                                                         
              MOVE ZERO                        TO CH-ACCOUNT-NO         
                                                  CH-CUSTOMER-NO        
                                                  CH-PREMISE-NO         
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2120-PROCESS-TRSFR-ALL                                         *        
      ******************************************************************        
      *                                                                         
       2120-PROCESS-TRSFR-ALL.                                          
                                                                        
           MOVE WS-IN-COMPANY-NO               TO MC-COMPANY-NO         
                                                  MA-COMPANY-NO         
                                                  MV-COMPANY-NO         
                                                  EM-COMPANY-NO         
                                                  EQ-COMPANY-NO.        
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE           TO MC-CODE-UTIL-TYPE     
                                                  MA-CODE-UTIL-TYPE     
                                                  EM-CODE-UTIL-TYPE     
                                                  EQ-CODE-UTIL-TYPE.    
                                                                        
           MOVE WS-IN-DEVICE-NO                TO MC-METER-NO.          
                                                                        
           PERFORM 7020-GET-MTR-CAP-CONSTANT   THRU 7020-EXIT.          
                                                                        
      *** THIS CONSTANT WILL BE NEW CONSTANT FOR THE TO-METER                   
           MOVE MC-CONSTANT                    TO WS-NEW-CONSTANT.      
                                                                        
           MOVE WS-IN-XFR-TO-DEVICE-NO         TO MC-METER-NO.          
                                                                        
           PERFORM 7020-GET-MTR-CAP-CONSTANT   THRU 7020-EXIT.          
                                                                        
      *** THIS CONSTANT WILL THE OLD CONSTANT OF THE TO-METER                   
      *** WHICH WILL BE USED TO WRITE IN TRANSATION HISTORY                     
           MOVE MC-CONSTANT                    TO WS-OLD-CONSTANT.      
                                                                        
           SET WS-CONSTANT-NOT-CHANGED         TO TRUE                  
                                                                        
           MOVE WS-IN-DEVICE-NO                TO MA-METER-NO.          
                                                                        
           PERFORM 7040-OPEN-MTR-ATTCH-CUR     THRU 7040-EXIT.          
           PERFORM 7044-FETCH-MTR-ATTCH-CUR    THRU 7044-EXIT.          
                                                                        
           MOVE +1                             TO WS-TRAN-APPL-NO.      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              IF MA-CODE-DEVICE-TYPE = WS-TRNSFR-TRANSFORMERS-T         
      *** SET TO TRUE SINCE THIS METER HAS TRANSFORMER TYPE ATTACHMENT          
      *** SO THAT WE CAN UPDATE THE CONSTANT AFTER PROCESSING ALL THE           
      *** ATTACHMENTS BEFORE THAT CHECK USER HAS RELEVANT SECURITY              
                                                                        
                 IF WS-IN-SECURITY-FLAG = 'N' AND                       
                    NOT WS-CONSTANT-CHANGED                             
                                                                        
                    MOVE 6000                        TO RS-RETURN-CODE  
                    PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT     
                    PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT    
                    PERFORM 9999-END-PROGRAM         THRU 9999-EXIT     
                 END-IF                                                 
                                                                        
                 SET WS-CONSTANT-CHANGED       TO TRUE                  
                                                                        
              END-IF                                                    
                                                                        
              MOVE MA-DEVICE-NO                TO MV-DEVICE-NO          
              MOVE WS-CURRENT-DATE             TO MV-DATE-MOVE          
              MOVE WS-XFR-LOCAL-OFFICE         TO MV-LOCAL-OFFICE       
              MOVE WS-XFR-CRNT-LOC-NO          TO MV-LOC-NO             
              MOVE WS-LOCATION-ATTACHED-K      TO MV-CODE-CRNT-LOC      
              MOVE WS-CURRENT-TIMESTAMP        TO MV-MOVE-NO            
                                                                        
              IF MA-CODE-ATT-TYPE = WS-CURRENT-XFORMER-CT               
                OR MA-CODE-ATT-TYPE = WS-POTENTIAL-XFORMER-PT           
                 MOVE WS-UTIL-TYPE-XFORMER-X   TO MV-CODE-UTIL-TYPE     
                 MOVE WS-DEVICE-XFORMER-T      TO MV-CODE-DEVICE-TYPE   
              ELSE                                                      
                 MOVE WS-UTIL-TYPE-ELECTRIC-E  TO MV-CODE-UTIL-TYPE     
                 MOVE WS-DEVICE-METER-M        TO MV-CODE-DEVICE-TYPE   
              END-IF                                                    
                                                                        
              PERFORM 8000-INSERT-MOVEMNT-HIST THRU 8000-EXIT           
                                                                        
              MOVE MA-CODE-ATT-TYPE            TO WS-ATTCH-TYP-TX       
              MOVE MA-DEVICE-NO                TO WS-DEVICE-NO-TX       
                                                                        
              PERFORM 5350-UPDT-JRNL-XFR-ATTCH THRU 5350-EXIT           
                                                                        
              MOVE WS-IN-DEVICE-NO             TO MA-METER-NO           
                                                                        
              PERFORM 8020-DELETE-METER-ATTCHMTS                        
                                               THRU 8020-EXIT           
                                                                        
              IF MA-DATE-LAST-TESTED = SPACES                           
                 MOVE -1                       TO WS-DATE-LST-TST-NULL  
              ELSE                                                      
                 MOVE 0                        TO WS-DATE-LST-TST-NULL  
              END-IF                                                    
                                                                        
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO MA-METER-NO           
                                                                        
              PERFORM 8040-INSERT-METER-ATTCHMTS                        
                                               THRU 8040-EXIT           
                                                                        
              PERFORM 7044-FETCH-MTR-ATTCH-CUR THRU 7044-EXIT           
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7048-CLOSE-MTR-ATTCH-CUR    THRU 7048-EXIT.          
                                                                        
           IF WS-CONSTANT-CHANGED                                       
                                                                        
              MOVE WS-IN-DEVICE-NO             TO EM-METER-NO           
              MOVE 'N'                         TO EM-OVERRIDE-CONST-FL  
              MOVE WS-RANDOM-TESTING-R         TO EM-TEST-SCHED-CD      
              MOVE 'NNNNNN'                    TO EM-CODE-ATTACHMENTS   
                                                                        
              PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT           
                                                                        
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO EM-METER-NO           
              MOVE WS-IN-ALLOW-OVERRIDE        TO EM-OVERRIDE-CONST-FL  
              MOVE WS-IN-TEST-SCHED-CD         TO EM-TEST-SCHED-CD      
              MOVE SPACES                      TO EM-CODE-ATTACHMENTS   
                                                                        
              PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT           
                                                                        
              MOVE WS-NEW-CONSTANT             TO WS-PREV-CONSTANT      
P00447        MOVE WS-DEFAULT-CONSTANT         TO WS-CHNG-CONSTANT      
                                                                        
              PERFORM 5100-UPDATE-JOURNAL-CONSTANT                      
                                               THRU 5100-EXIT           
                                                                        
      *** DEFAULT THE CONSTANT OF FROM-METER SINCE THERE IS NO                  
      *** MORE ATTACHMENTS ATTACHED TO THIS METER                               
                                                                        
              MOVE WS-IN-DEVICE-NO             TO MC-METER-NO           
P00447        MOVE WS-DEFAULT-CONSTANT         TO MC-CONSTANT           
                                                                        
              PERFORM 8160-UPDATE-MTR-CAP-CONSTANT                      
                                               THRU 8160-EXIT           
                                                                        
              IF WS-XFR-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K OR       
                 WS-XFR-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J       
                                                                        
                 MOVE WS-XFR-CRNT-LOC-NO       TO CH-PREMISE-NO         
                 PERFORM 7120-GET-ACCOUNT-DETAILS                       
                                               THRU 7120-EXIT           
              ELSE                                                      
                 MOVE ZERO                     TO CH-ACCOUNT-NO         
                                                  CH-CUSTOMER-NO        
                                                  CH-PREMISE-NO         
              END-IF                                                    
                                                                        
              MOVE WS-OLD-CONSTANT             TO WS-PREV-CONSTANT      
              MOVE WS-NEW-CONSTANT             TO WS-CHNG-CONSTANT      
                                                                        
              PERFORM 5100-UPDATE-JOURNAL-CONSTANT                      
                                               THRU 5100-EXIT           
      *** UPDATE THE CONSTANT FOR THE TO-METER                                  
                                                                        
              MOVE 8100                        TO RS-INFO-RETURN-CODE   
                                                                        
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO MC-METER-NO           
              MOVE WS-NEW-CONSTANT             TO MC-CONSTANT           
                                                                        
              PERFORM 8160-UPDATE-MTR-CAP-CONSTANT                      
                                               THRU 8160-EXIT           
           ELSE                                                         
                                                                        
              MOVE WS-IN-DEVICE-NO             TO EM-METER-NO           
              MOVE WS-IN-ALLOW-OVERRIDE        TO EM-OVERRIDE-CONST-FL  
              MOVE WS-IN-TEST-SCHED-CD         TO EM-TEST-SCHED-CD      
              MOVE 'NNNNNN'                    TO EM-CODE-ATTACHMENTS   
                                                                        
              PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT           
                                                                        
           END-IF                                                       
                                                                        
           MOVE WS-IN-DEVICE-NO                TO EQ-DEVICE-NO.         
                                                                        
           PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                        
                                               THRU 8120-EXIT.          
                                                                        
           MOVE WS-IN-XFR-TO-DEVICE-NO         TO EQ-DEVICE-NO.         
                                                                        
           PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                        
                                               THRU 8120-EXIT.          
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2140-PROCESS-TRSFR-METERS                                      *        
      ******************************************************************        
       2140-PROCESS-TRSFR-METERS.                                       
                                                                        
           MOVE WS-IN-COMPANY-NO               TO MA-COMPANY-NO         
                                                  MV-COMPANY-NO         
                                                  EM-COMPANY-NO         
                                                  EQ-COMPANY-NO.        
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE           TO MA-CODE-UTIL-TYPE     
                                                  EM-CODE-UTIL-TYPE     
                                                  EQ-CODE-UTIL-TYPE.    
                                                                        
                                                                        
           SET WS-METER-NOT-FOUND              TO TRUE.                 
           MOVE SPACES                      TO WS-CODE-ATTACHMENT-FLAGS.
                                                                        
           MOVE WS-IN-DEVICE-NO                TO MA-METER-NO.          
                                                                        
           PERFORM 7040-OPEN-MTR-ATTCH-CUR     THRU 7040-EXIT.          
           PERFORM 7044-FETCH-MTR-ATTCH-CUR    THRU 7044-EXIT.          
                                                                        
           MOVE +1                             TO WS-TRAN-APPL-NO.      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              IF MA-CODE-DEVICE-TYPE = WS-TRNSFR-METERS-M               
                                                                        
                 SET WS-METER-FOUND            TO TRUE                  
                                                                        
                 MOVE MA-DEVICE-NO             TO MV-DEVICE-NO          
                 MOVE WS-CURRENT-DATE          TO MV-DATE-MOVE          
                 MOVE WS-XFR-LOCAL-OFFICE      TO MV-LOCAL-OFFICE       
                 MOVE WS-XFR-CRNT-LOC-NO       TO MV-LOC-NO             
                 MOVE WS-LOCATION-ATTACHED-K   TO MV-CODE-CRNT-LOC      
                 MOVE WS-CURRENT-TIMESTAMP     TO MV-MOVE-NO            
                                                                        
                 MOVE WS-UTIL-TYPE-ELECTRIC-E  TO MV-CODE-UTIL-TYPE     
                 MOVE WS-DEVICE-METER-M        TO MV-CODE-DEVICE-TYPE   
                                                                        
                 PERFORM 8000-INSERT-MOVEMNT-HIST                       
                                               THRU 8000-EXIT           
                                                                        
                 MOVE MA-CODE-ATT-TYPE         TO WS-ATTCH-TYP-TX       
                 MOVE MA-DEVICE-NO             TO WS-DEVICE-NO-TX       
                                                                        
                 PERFORM 5350-UPDT-JRNL-XFR-ATTCH                       
                                               THRU 5350-EXIT           
                                                                        
                 MOVE WS-IN-DEVICE-NO          TO MA-METER-NO           
                                                                        
                 PERFORM 8020-DELETE-METER-ATTCHMTS                     
                                               THRU 8020-EXIT           
                                                                        
                 IF MA-DATE-LAST-TESTED = SPACES                        
                    MOVE -1                    TO WS-DATE-LST-TST-NULL  
                 ELSE                                                   
                    MOVE 0                     TO WS-DATE-LST-TST-NULL  
                 END-IF                                                 
                                                                        
                 MOVE WS-IN-XFR-TO-DEVICE-NO   TO MA-METER-NO           
                 MOVE +0                       TO MA-CT-PT-RATIO        
                                                                        
                 PERFORM 8040-INSERT-METER-ATTCHMTS                     
                                               THRU 8040-EXIT           
                                                                        
              END-IF                                                    
                                                                        
              IF MA-CODE-DEVICE-TYPE = WS-TRNSFR-TRANSFORMERS-T         
                                                                        
                 EVALUATE MA-CODE-ATT-TYPE                              
                   WHEN WS-ATT-CT-RATED-CT                              
                      MOVE 'Y'              TO WS-ATT-CT-RATED          
                   WHEN WS-ATT-PT-RATED-PT                              
                      MOVE 'Y'              TO WS-ATT-PT-RATED          
                   WHEN WS-ATT-MAG-TAPE-MT                              
                      MOVE 'Y'              TO WS-ATT-MAG-TAPE          
                   WHEN WS-ATT-IDR-DEVC-ID                              
                      MOVE 'Y'              TO WS-ATT-IDR-DEVC          
                   WHEN WS-ATT-REACTIVE-MTR-RE                          
                      MOVE 'Y'              TO WS-ATT-REACTIVE-MTR      
                   WHEN WS-ATT-V2H-MTR-VH                               
                      MOVE 'Y'              TO WS-ATT-V2H-MTR           
                 END-EVALUATE                                           
                                                                        
              END-IF                                                    
                                                                        
              PERFORM 7044-FETCH-MTR-ATTCH-CUR THRU 7044-EXIT           
                                                                        
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7048-CLOSE-MTR-ATTCH-CUR THRU 7048-EXIT              
                                                                        
           IF WS-METER-FOUND                                            
                                                                        
              MOVE WS-IN-DEVICE-NO             TO EM-METER-NO           
              MOVE WS-IN-ALLOW-OVERRIDE        TO EM-OVERRIDE-CONST-FL  
              MOVE WS-IN-TEST-SCHED-CD         TO EM-TEST-SCHED-CD      
              MOVE WS-CODE-ATTACHMENT-FLAGS    TO EM-CODE-ATTACHMENTS   
                                                                        
              PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT           
                                                                        
              MOVE WS-IN-DEVICE-NO             TO EQ-DEVICE-NO          
                                                                        
              PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                     
                                               THRU 8120-EXIT           
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO EQ-DEVICE-NO          
                                                                        
              PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                     
                                               THRU 8120-EXIT           
           END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2160-PROCESS-TRSFR-XFORMRS                                     *        
      ******************************************************************        
       2160-PROCESS-TRSFR-XFORMRS.                                      
                                                                        
           MOVE WS-IN-COMPANY-NO               TO MA-COMPANY-NO         
                                                  MV-COMPANY-NO         
                                                  EM-COMPANY-NO         
                                                  EQ-COMPANY-NO         
                                                  MC-COMPANY-NO.        
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE           TO MA-CODE-UTIL-TYPE     
                                                  EM-CODE-UTIL-TYPE     
                                                  EQ-CODE-UTIL-TYPE     
                                                  MC-CODE-UTIL-TYPE.    
                                                                        
                                                                        
           SET WS-XFORMER-NOT-FOUND            TO TRUE.                 
           MOVE SPACES                      TO WS-CODE-ATTACHMENT-FLAGS.
                                                                        
           MOVE WS-IN-DEVICE-NO                TO MA-METER-NO.          
                                                                        
           PERFORM 7040-OPEN-MTR-ATTCH-CUR     THRU 7040-EXIT.          
           PERFORM 7044-FETCH-MTR-ATTCH-CUR    THRU 7044-EXIT.          
                                                                        
           MOVE +1                             TO WS-TRAN-APPL-NO.      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              IF MA-CODE-DEVICE-TYPE = WS-TRNSFR-TRANSFORMERS-T         
                                                                        
      *** SET TO TRUE SINCE THIS METER HAS TRANSFORMER TYPE ATTACHMENT          
      *** SO THAT WE CAN UPDATE THE CONSTANT AFTER PROCESSING ALL THE           
      *** ATTACHMENTS                                                           
                 IF WS-IN-SECURITY-FLAG = 'N' AND                       
                    NOT WS-XFORMER-FOUND                                
                                                                        
                    MOVE 6000                        TO RS-RETURN-CODE  
                    PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT     
                    PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT    
                    PERFORM 9999-END-PROGRAM         THRU 9999-EXIT     
                 END-IF                                                 
                                                                        
                 SET WS-XFORMER-FOUND          TO TRUE                  
                                                                        
                 MOVE MA-DEVICE-NO             TO MV-DEVICE-NO          
                 MOVE WS-CURRENT-DATE          TO MV-DATE-MOVE          
                 MOVE WS-XFR-LOCAL-OFFICE      TO MV-LOCAL-OFFICE       
                 MOVE WS-XFR-CRNT-LOC-NO       TO MV-LOC-NO             
                 MOVE WS-LOCATION-ATTACHED-K   TO MV-CODE-CRNT-LOC      
                 MOVE WS-CURRENT-TIMESTAMP     TO MV-MOVE-NO            
                 MOVE WS-UTIL-TYPE-XFORMER-X   TO MV-CODE-UTIL-TYPE     
                 MOVE WS-DEVICE-XFORMER-T      TO MV-CODE-DEVICE-TYPE   
                                                                        
                 PERFORM 8000-INSERT-MOVEMNT-HIST                       
                                               THRU 8000-EXIT           
                                                                        
                 MOVE MA-CODE-ATT-TYPE         TO WS-ATTCH-TYP-TX       
                 MOVE MA-DEVICE-NO             TO WS-DEVICE-NO-TX       
                                                                        
                 PERFORM 5350-UPDT-JRNL-XFR-ATTCH                       
                                               THRU 5350-EXIT           
                                                                        
                 MOVE WS-IN-DEVICE-NO          TO MA-METER-NO           
                                                                        
                 PERFORM 8020-DELETE-METER-ATTCHMTS                     
                                               THRU 8020-EXIT           
                                                                        
                 IF MA-DATE-LAST-TESTED = SPACES                        
                    MOVE -1                    TO WS-DATE-LST-TST-NULL  
                 ELSE                                                   
                    MOVE 0                     TO WS-DATE-LST-TST-NULL  
                 END-IF                                                 
                                                                        
                 MOVE WS-IN-XFR-TO-DEVICE-NO   TO MA-METER-NO           
                                                                        
                 PERFORM 8040-INSERT-METER-ATTCHMTS                     
                                               THRU 8040-EXIT           
                                                                        
                 EVALUATE MA-CODE-ATT-TYPE                              
                   WHEN WS-ATT-CT-RATED-CT                              
                      MOVE 'Y'              TO WS-ATT-CT-RATED          
                   WHEN WS-ATT-PT-RATED-PT                              
                      MOVE 'Y'              TO WS-ATT-PT-RATED          
                   WHEN WS-ATT-MAG-TAPE-MT                              
                      MOVE 'Y'              TO WS-ATT-MAG-TAPE          
                   WHEN WS-ATT-IDR-DEVC-ID                              
                      MOVE 'Y'              TO WS-ATT-IDR-DEVC          
                   WHEN WS-ATT-REACTIVE-MTR-RE                          
                      MOVE 'Y'              TO WS-ATT-REACTIVE-MTR      
                   WHEN WS-ATT-V2H-MTR-VH                               
                      MOVE 'Y'              TO WS-ATT-V2H-MTR           
                 END-EVALUATE                                           
                                                                        
              END-IF                                                    
                                                                        
              PERFORM 7044-FETCH-MTR-ATTCH-CUR THRU 7044-EXIT           
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7048-CLOSE-MTR-ATTCH-CUR    THRU 7048-EXIT           
                                                                        
           IF WS-XFORMER-FOUND                                          
                                                                        
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO EM-METER-NO           
              MOVE WS-IN-ALLOW-OVERRIDE        TO EM-OVERRIDE-CONST-FL  
              MOVE WS-IN-TEST-SCHED-CD         TO EM-TEST-SCHED-CD      
              MOVE SPACES                      TO EM-CODE-ATTACHMENTS   
                                                                        
              PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT           
                                                                        
              MOVE WS-IN-DEVICE-NO             TO MC-METER-NO           
                                                                        
              PERFORM 7020-GET-MTR-CAP-CONSTANT THRU 7020-EXIT          
                                                                        
      *** THIS CONSTANT WILL BE NEW CONSTANT FOR THE TO-METER                   
              MOVE MC-CONSTANT                 TO WS-NEW-CONSTANT       
                                                                        
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO MC-METER-NO           
                                                                        
              PERFORM 7020-GET-MTR-CAP-CONSTANT THRU 7020-EXIT          
                                                                        
      *** THIS CONSTANT WILL THE OLD CONSTANT OF THE TO-METER                   
      *** WHICH WILL BE USED TO WRITE IN TRANSATION HISTORY                     
              MOVE MC-CONSTANT                 TO WS-OLD-CONSTANT       
                                                                        
              MOVE WS-NEW-CONSTANT             TO WS-PREV-CONSTANT      
P00447        MOVE WS-DEFAULT-CONSTANT         TO WS-CHNG-CONSTANT      
                                                                        
              PERFORM 5100-UPDATE-JOURNAL-CONSTANT                      
                                               THRU 5100-EXIT           
                                                                        
      *** DEFAULT THE CONSTANT OF FROM-METER SINCE THERE IS NO                  
      *** MORE TRANSFORMER ATTACHED TO THIS METER                               
              MOVE WS-IN-DEVICE-NO             TO MC-METER-NO           
P00447        MOVE WS-DEFAULT-CONSTANT         TO MC-CONSTANT           
                                                                        
              PERFORM 8160-UPDATE-MTR-CAP-CONSTANT                      
                                               THRU 8160-EXIT           
                                                                        
              IF WS-XFR-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K OR       
                 WS-XFR-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J       
                                                                        
                 MOVE WS-XFR-CRNT-LOC-NO       TO CH-PREMISE-NO         
                 PERFORM 7120-GET-ACCOUNT-DETAILS                       
                                               THRU 7120-EXIT           
              ELSE                                                      
                 MOVE ZERO                     TO CH-ACCOUNT-NO         
                                                  CH-CUSTOMER-NO        
                                                  CH-PREMISE-NO         
              END-IF                                                    
                                                                        
              MOVE WS-OLD-CONSTANT             TO WS-PREV-CONSTANT      
              MOVE WS-NEW-CONSTANT             TO WS-CHNG-CONSTANT      
                                                                        
              PERFORM 5100-UPDATE-JOURNAL-CONSTANT                      
                                               THRU 5100-EXIT           
                                                                        
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO MC-METER-NO           
              MOVE WS-NEW-CONSTANT             TO MC-CONSTANT           
                                                                        
              MOVE 8100                        TO RS-INFO-RETURN-CODE   
      *** UPDATE THE CONSTANT FOR THE TO-METER                                  
              PERFORM 8160-UPDATE-MTR-CAP-CONSTANT                      
                                               THRU 8160-EXIT           
                                                                        
              MOVE WS-IN-DEVICE-NO             TO EM-METER-NO           
              MOVE 'N'                         TO EM-OVERRIDE-CONST-FL  
              MOVE WS-RANDOM-TESTING-R         TO EM-TEST-SCHED-CD      
              MOVE WS-CODE-ATTACHMENT-FLAGS    TO EM-CODE-ATTACHMENTS   
                                                                        
              PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT           
                                                                        
              MOVE WS-IN-DEVICE-NO             TO EQ-DEVICE-NO          
                                                                        
              PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                     
                                               THRU 8120-EXIT           
                                                                        
              MOVE WS-IN-XFR-TO-DEVICE-NO      TO EQ-DEVICE-NO          
                                                                        
              PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                     
                                               THRU 8120-EXIT           
           END-IF.                                                      
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2200-PROCESS-ADD-ATTACHMENTS                                  *        
      ******************************************************************        
        2200-PROCESS-ADD-ATTACHMENTS.                                   
                                                                        
           PERFORM 2210-VALIDATE-ATTACHMENTS     THRU 2210-EXIT.        
           PERFORM 2230-UPDATE-CONST-CODE-ATTCH  THRU 2230-EXIT.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2210-VALIDATE-ATTACHMENTS                                      *        
      ******************************************************************        
       2210-VALIDATE-ATTACHMENTS.                                       
                                                                        
           SET ATTCH-INDX                        TO +1.                 
           SET WS-CONSTANT-NOT-UPDATED           TO TRUE.               
           MOVE 'NNNNNN'                    TO WS-CODE-ATTACHMENT-FLAGS.
                                                                        
           IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K                 
               OR WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J          
                                                                        
              MOVE WS-CRNT-LOC-NO           TO CH-PREMISE-NO            
                                                                        
              PERFORM 7120-GET-ACCOUNT-DETAILS                          
                                               THRU 7120-EXIT           
           ELSE                                                         
              MOVE ZERO                        TO CH-ACCOUNT-NO         
                                                  CH-CUSTOMER-NO        
                                                  CH-PREMISE-NO         
           END-IF.                                                      
                                                                        
           PERFORM VARYING ATTCH-INDX FROM 1 BY 1                       
            UNTIL ATTCH-INDX > 20                                       
              OR  WS-ARRY-ATTCH-INFO(ATTCH-INDX) = SPACES               
                                                                        
              MOVE SPACES                         TO WS-RMT-RD-CODE     
                                                                        
              MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                      
                                                  TO MA-CODE-ATT-TYPE   
                                                     N5-CODE-ATT-TYPE   
                                                     LX-CODE-ATT-TYPE   
                                                                        
              MOVE WS-IN-DEVICE-NO                TO MA-METER-NO        
                                                     EM-METER-NO        
                                                                        
              MOVE WS-IN-COMPANY-NO               TO MA-COMPANY-NO      
                                                     EQ-COMPANY-NO      
                                                     IX-COMPANY-NO      
                                                     LX-COMPANY-NO      
                                                     EM-COMPANY-NO      
                                                                        
              MOVE WS-IN-CODE-UTIL-TYPE           TO MA-CODE-UTIL-TYPE  
                                                     EQ-CODE-UTIL-TYPE  
                                                     N5-CODE-UTIL-TYPE  
                                                     LX-CODE-UTIL-TYPE  
                                                     EM-CODE-UTIL-TYPE  
PRJ914        MOVE SPACE                TO WS-ATTACHMENT-TYPE           
P00462        MOVE 'N'                  TO WS-METER-ATT-TYPE-EXISTS     
P00462        PERFORM 7060-CHECK-MTR-ATT-TYP-EXISTS                     
P00462                                  THRU 7060-EXIT                  
P00462        IF WS-METER-ATT-TYPE-EXISTS = 'N'                         
P00462          MOVE 3600               TO RS-RETURN-CODE               
P00462          SET  RS-ROW-NUM         TO ATTCH-INDX                   
P00462          PERFORM 9000-SEND-ERROR-RESULT                          
P00462                                  THRU 9000-EXIT                  
P00462          PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT               
P00462          PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                
P00462        END-IF                                                    
P00462                                                                  
              EVALUATE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                  
                WHEN WS-ATT-MAG-TAPE-MT                                 
                WHEN WS-ATT-IDR-DEVC-ID                                 
                                                                        
                   MOVE ZERO                     TO WS-ATTCH-COUNT      
                   PERFORM 7078-GET-COUNT-ATT-TYP-TO-MTR                
                                                 THRU 7078-EXIT         
                                                                        
                   IF WS-ATTCH-COUNT > 0 THEN                           
                      MOVE 3790                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                WHEN WS-ATT-REACTIVE-MTR-RE                             
                                                                        
                   MOVE ZERO                     TO WS-ATTCH-COUNT      
                   PERFORM 7078-GET-COUNT-ATT-TYP-TO-MTR                
                                                 THRU 7078-EXIT         
                                                                        
                   IF WS-ATTCH-COUNT > 0 THEN                           
                      MOVE 3800                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                WHEN WS-ATT-V2H-MTR-VH                                  
                                                                        
                   MOVE ZERO                     TO WS-ATTCH-COUNT      
                   PERFORM 7078-GET-COUNT-ATT-TYP-TO-MTR                
                                                 THRU 7078-EXIT         
                                                                        
                   IF WS-ATTCH-COUNT > 0 THEN                           
                      MOVE 3820                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                WHEN WS-ATT-BACKUP-MTR                                  
                                                                        
                   MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                   
                                                 TO EQ-DEVICE-NO        
                                                                        
                   PERFORM 7000-GET-EQUIP-DETIALS  THRU 7000-EXIT       
                                                                        
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      MOVE 3100                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                   IF EQ-SERIAL-NO                                      
P00914                    NOT EQUAL WS-ARRY-SERIAL-NO(ATTCH-INDX)(15:11)
                      MOVE 3200                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                   IF EQ-CODE-CRNT-LOC NOT = WS-LOCATION-INVENTORY-A AND
                      EQ-CODE-CRNT-LOC NOT = WS-LOCATION-METER-SHOP-B   
                      MOVE 3300                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                WHEN WS-CURRENT-XFORMER-CT                              
                WHEN WS-POTENTIAL-XFORMER-PT                            
                                                                        
                   MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX) TO EQ-DEVICE-NO   
                   MOVE WS-UTIL-TYPE-XFORMER-X   TO EQ-CODE-UTIL-TYPE   
                                                                        
                   PERFORM 7000-GET-EQUIP-DETIALS THRU 7000-EXIT        
                                                                        
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      MOVE 3100                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                   IF EQ-SERIAL-NO                                      
P00914                    NOT EQUAL WS-ARRY-SERIAL-NO(ATTCH-INDX)(15:11)
                      MOVE 3200                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                   IF EQ-CODE-CRNT-LOC NOT = WS-LOCATION-INVENTORY-A AND
                      EQ-CODE-CRNT-LOC NOT = WS-LOCATION-METER-SHOP-B   
                      MOVE 3300                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                   MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                   
                                                 TO IX-XFORMER-NO       
                   MOVE WS-UTIL-TYPE-XFORMER-X   TO IX-CODE-UTIL-TYPE   
                                                                        
                   PERFORM 7050-GET-XFORMER-DETAILS THRU 7050-EXIT      
                                                                        
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      MOVE 3400                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
                                                                        
                   IF IX-XFORMER-TYPE-CD NOT =                          
                                 WS-ARRY-ATTACH-TYPE(ATTCH-INDX)        
                      MOVE 3500                  TO RS-RETURN-CODE      
                      SET  RS-ROW-NUM            TO ATTCH-INDX          
                      PERFORM 9000-SEND-ERROR-RESULT                    
                                                 THRU 9000-EXIT         
                      PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT        
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                   END-IF                                               
P00462             MOVE ZERO               TO WS-ATTCH-COUNT            
P00462             MOVE WS-ATT-TYPE-KBASE  TO MA-CODE-ATT-TYPE          
P00462             PERFORM 7078-GET-COUNT-ATT-TYP-TO-MTR                
P00462                                    THRU 7078-EXIT                
P00462                                                                  
P00462             IF WS-ATTCH-COUNT > 0 THEN                           
P00462               MOVE 3830                TO RS-RETURN-CODE         
P00462               SET  RS-ROW-NUM          TO ATTCH-INDX             
P00462               PERFORM 9000-SEND-ERROR-RESULT                     
P00462                                        THRU 9000-EXIT            
P00462               PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT          
POO462               PERFORM 9999-END-PROGRAM  THRU 9999-EXIT           
P00462             END-IF                                               
P00462             MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                 
P00462                                     TO MA-CODE-ATT-TYPE          
                                                                        
                WHEN OTHER                                              
PRJ914           IF Q-TYPE-ATTACHMENT                                   
PRJ914              PERFORM 2215-VALIDATE-Q-ATTCH  THRU 2215-EXIT       
PRJ914           ELSE                                                   
                   MOVE 9999                    TO WS-ACTIVE-RETURN-CODE
                   SET  RS-ROW-NUM               TO ATTCH-INDX          
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '2210'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'EVALUATE'               TO ABEND-FUNCTION      
                   MOVE 'WS-ARRY-ATTACH-TYPE'    TO TABLE-1             
                   MOVE 'WS-ARRY-ATTACH-TYPE'    TO TABLE-ELEMENT-1     
                   MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                 
                                                 TO HOSTVAR-ELEMENT-1   
                   MOVE 'DEVICE-NO'              TO TABLE-ELEMENT-2     
                   MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                   
                                                 TO HOSTVAR-ELEMENT-2   
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
PRJ914           END-IF                                                 
              END-EVALUATE                                              
                                                                        
PRJ914        MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX) TO MA-CODE-ATT-TYPE  
              MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)  TO MA-DEVICE-NO       
                                                                        
              PERFORM 7074-CHECK-DEVICE-ATTCH-TO-MTR                    
                                                 THRU 7074-EXIT         
                                                                        
              IF WS-DEVICE-ATTCHED = 'Y'                                
                 MOVE 3780                        TO RS-RETURN-CODE     
                 SET  RS-ROW-NUM                  TO ATTCH-INDX         
                 PERFORM 9000-SEND-ERROR-RESULT                         
                                                 THRU 9000-EXIT         
                 PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT       
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
                                                                        
              PERFORM 2220-INSERT-ATTACHMENTS     THRU 2220-EXIT        
                                                                        
           END-PERFORM.                                                 
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
PRJ914******************************************************************        
PRJ914* 2215-VALIDATE-Q-ATTCH                                          *        
PRJ914******************************************************************        
PRJ914*                                                                         
PRJ914 2215-VALIDATE-Q-ATTCH.                                           
PRJ914                                                                  
PRJ914*** CHECK IF THE GIVEN ATTACHMENT IS ATTACHED TO ANY METER                
PRJ914     MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX) TO MA-DEVICE-NO.          
PRJ914     PERFORM 7070-GET-MTR-NO-ATTCH-DEVICE  THRU 7070-EXIT.        
PRJ914     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ914        MOVE 3650                       TO RS-RETURN-CODE         
PRJ914        SET  RS-ROW-NUM                 TO ATTCH-INDX             
PRJ914        MOVE MA-METER-NO               TO RS-DEVICE-ATTACHD-TO-MTR
PRJ914        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
PRJ914        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
PRJ914        PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
PRJ914     END-IF.                                                      
PRJ914                                                                  
PRJ914*** CHECK IF THE ATTACHMENT EXISTS IN CSS_EQUIP_ATTCHMTS TABLE            
PRJ914     MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX) TO LX-DEVICE-NO.          
PRJ914     MOVE 'N'                           TO WS-EQUIP-ATTACH-EXISTS.
PRJ914     PERFORM 7090-CHECK-EQUIP-ATTCH-EXISTS THRU 7090-EXIT.        
PRJ914     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
PRJ914        MOVE 3700                       TO RS-RETURN-CODE         
PRJ914        SET  RS-ROW-NUM                 TO ATTCH-INDX             
PRJ914        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
PRJ914        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
PRJ914        PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
PRJ914     END-IF.                                                      
PRJ914                                                                  
PRJ914*** GET REMOTE READ CODE FROM CSS_ELEC_MTR_SPEC FOR THE METER             
PRJ914     PERFORM 7100-GET-REMOTE-READ-CODE     THRU 7100-EXIT.        
PRJ914     MOVE U5-REMOTE-READ-CODE           TO WS-RMT-RD-CODE.        
PRJ914                                                                  
PRJ914     IF WS-ARRY-ATTACH-TYPE(ATTCH-INDX) = WS-ATT-TYPE-ERT         
PRJ914        IF WS-RMT-RD-CODE NOT = 'A' AND                           
PRJ914           WS-RMT-RD-CODE NOT = 'M'                               
PRJ914           MOVE 3710                    TO RS-RETURN-CODE         
PRJ914           SET  RS-ROW-NUM              TO ATTCH-INDX             
PRJ914           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ914           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
PRJ914           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
PRJ914        END-IF                                                    
PRJ914     END-IF.                                                      
PRJ914                                                                  
PRJ914     IF WS-ARRY-ATTACH-TYPE(ATTCH-INDX) = WS-ATT-TYPE-SMARTSYNCH  
PRJ914        IF WS-RMT-RD-CODE NOT = 'Z'                               
PRJ914           MOVE 3710                    TO RS-RETURN-CODE         
PRJ914           SET  RS-ROW-NUM              TO ATTCH-INDX             
PRJ914           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ914           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
PRJ914           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
PRJ914        END-IF                                                    
PRJ914     END-IF.                                                      
PRJ914                                                                  
PRJ914     IF WS-ARRY-ATTACH-TYPE(ATTCH-INDX) = WS-ATT-TYPE-OPENWAY     
PRJ914        IF WS-RMT-RD-CODE NOT = 'C'                               
PRJ914           MOVE 3710                    TO RS-RETURN-CODE         
PRJ914           SET  RS-ROW-NUM              TO ATTCH-INDX             
PRJ914           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ914           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
PRJ914           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
PRJ914        END-IF                                                    
PRJ914     END-IF.                                                      
PRJ914                                                                  
PRJ914*** CHECK THE NO OF ATTACHMENTS EACH ATTACHMENT TYPE CAN HOLD             
PRJ914     MOVE ZERO                          TO WS-ATTCH-COUNT.        
PRJ914     PERFORM 7078-GET-COUNT-ATT-TYP-TO-MTR THRU 7078-EXIT.        
PRJ914                                                                  
PRJ914     IF ( WS-ARRY-ATTACH-TYPE(ATTCH-INDX) = WS-ATT-TYPE-ERT AND   
PRJ914          WS-RMT-RD-CODE = 'M' )                                  
PRJ914        IF WS-ATTCH-COUNT > 2                                     
PRJ914           MOVE 3810                    TO RS-RETURN-CODE         
PRJ914           SET  RS-ROW-NUM              TO ATTCH-INDX             
PRJ914           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ914           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
PRJ914           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
PRJ914        END-IF                                                    
PRJ914     ELSE                                                         
PRJ914        IF WS-ATTCH-COUNT > 0                                     
PRJ914           MOVE 3810                    TO RS-RETURN-CODE         
PRJ914           SET  RS-ROW-NUM              TO ATTCH-INDX             
PRJ914           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ914           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
PRJ914           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
PRJ914        END-IF                                                    
PRJ914     END-IF.                                                      
PRJ914                                                                  
PRJ914     IF WS-ARRY-ATTACH-TYPE(ATTCH-INDX) = WS-ATT-TYPE-KBASE       
PRJ914        MOVE ZERO                       TO WS-ATTCH-COUNT         
PRJ914        MOVE WS-CURRENT-XFORMER-CT      TO MA-CODE-ATT-TYPE       
PRJ914        PERFORM 7078-GET-COUNT-ATT-TYP-TO-MTR THRU 7078-EXIT      
PRJ914        IF WS-ATTCH-COUNT > 0                                     
PRJ914           MOVE 3830                    TO RS-RETURN-CODE         
PRJ914           SET  RS-ROW-NUM              TO ATTCH-INDX             
PRJ914           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ914           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
PRJ914           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
PRJ914        END-IF                                                    
PRJ914                                                                  
PRJ914        MOVE ZERO                       TO WS-ATTCH-COUNT         
PRJ914        MOVE WS-POTENTIAL-XFORMER-PT    TO MA-CODE-ATT-TYPE       
PRJ914        PERFORM 7078-GET-COUNT-ATT-TYP-TO-MTR THRU 7078-EXIT      
PRJ914        IF WS-ATTCH-COUNT > 0                                     
PRJ914           MOVE 3830                    TO RS-RETURN-CODE         
PRJ914           SET  RS-ROW-NUM              TO ATTCH-INDX             
PRJ914           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ914           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
PRJ914           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
PRJ914       END-IF                                                     
PRJ914     END-IF.                                                      
PRJ914                                                                  
PRJ914 2215-EXIT.                                                       
PRJ914     EXIT.                                                        
PRJ914*                                                                         
      ******************************************************************        
      * 2220-INSERT-ATTACHMENTS                                        *        
      ******************************************************************        
      *                                                                         
       2220-INSERT-ATTACHMENTS.                                         
                                                                        
                                                                        
           MOVE WS-IN-COMPANY-NO                 TO EQ-COMPANY-NO       
                                                    LX-COMPANY-NO       
                                                    MV-COMPANY-NO       
                                                    MA-COMPANY-NO       
                                                    MP-COMPANY-NO.      
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE             TO LX-CODE-UTIL-TYPE   
                                                    MP-CODE-UTIL-TYPE.  
                                                                        
                                                                        
           IF WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                           
                                         = WS-CURRENT-XFORMER-CT        
              OR WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                        
                                         = WS-POTENTIAL-XFORMER-PT      
              MOVE WS-UTIL-TYPE-XFORMER-X    TO WS-CODE-UTIL-TYPE       
              MOVE WS-DEVICE-XFORMER-T       TO WS-CODE-DEVICE-TYPE     
      *** SET TO TRUE SINCE WE ADDING A TRANSFORMER TYPE ATTACHMENT             
      *** SO THAT WE NEED TO UPDATE THE CONSTANT FOR THIS METER                 
      *** BEFORE THAT CHECK IF USER HAS RELAVANT SECURITY                       
                                                                        
              IF WS-IN-SECURITY-FLAG = 'N' AND                          
                 NOT WS-CONSTANT-UPDATE                                 
                                                                        
                 MOVE 6000                        TO RS-RETURN-CODE     
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
                 PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT       
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
                                                                        
              SET WS-CONSTANT-UPDATE         TO TRUE                    
                                                                        
           ELSE                                                         
              MOVE WS-UTIL-TYPE-ELECTRIC-E   TO WS-CODE-UTIL-TYPE       
              MOVE WS-DEVICE-METER-M         TO WS-CODE-DEVICE-TYPE     
           END-IF                                                       
                                                                        
PRJ914     IF NOT Q-TYPE-ATTACHMENT                                     
              MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX) TO MV-DEVICE-NO        
              MOVE WS-CURRENT-DATE               TO MV-DATE-MOVE        
              MOVE WS-LOCAL-OFFICE               TO MV-LOCAL-OFFICE     
              MOVE WS-CRNT-LOC-NO                TO MV-LOC-NO           
              MOVE WS-LOCATION-ATTACHED-K        TO MV-CODE-CRNT-LOC    
              MOVE WS-CURRENT-TIMESTAMP          TO MV-MOVE-NO          
              MOVE WS-CODE-UTIL-TYPE             TO MV-CODE-UTIL-TYPE   
              MOVE WS-CODE-DEVICE-TYPE           TO MV-CODE-DEVICE-TYPE 
                                                                        
              PERFORM 8000-INSERT-MOVEMNT-HIST THRU 8000-EXIT           
                                                                        
              MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX) TO EQ-DEVICE-NO        
              MOVE WS-CODE-UTIL-TYPE             TO EQ-CODE-UTIL-TYPE   
              MOVE WS-LOCATION-ATTACHED-K        TO EQ-CODE-CRNT-LOC    
              MOVE WS-CRNT-LOC-NO                TO EQ-CRNT-LOC-NO      
                                                                        
              PERFORM 8130-UPDATE-EQUIP-CRNT-LOC THRU 8130-EXIT         
           END-IF                                                       
                                                                        
           MOVE WS-UTIL-TYPE-ELECTRIC-E     TO MA-CODE-UTIL-TYPE        
           MOVE WS-IN-DEVICE-NO             TO MA-METER-NO              
           MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                         
                                            TO MA-CODE-ATT-TYPE         
           MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                           
                                            TO MA-DEVICE-NO             
           MOVE WS-CODE-DEVICE-TYPE         TO MA-CODE-DEVICE-TYPE      
           MOVE +0                          TO MA-CT-PT-RATIO           
           MOVE SPACES                      TO MA-DATE-LAST-TESTED      
           MOVE -1                          TO WS-DATE-LST-TST-NULL     
           MOVE WS-IN-TEST-SCHED-CD         TO MA-TEST-SCHED-CD         
           MOVE WS-ARRY-HOW-ATTCH(ATTCH-INDX)                           
                                            TO MA-HOW-ATTACHED-CD       
                                                                        
           PERFORM 8040-INSERT-METER-ATTCHMTS                           
                                            THRU 8040-EXIT              
                                                                        
           MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                           
                                            TO LX-DEVICE-NO             
           MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                         
                                            TO LX-CODE-ATT-TYPE         
                                                                        
           PERFORM 7110-GET-EQUIP-ATTCH-DETAILS                         
                                            THRU 7110-EXIT              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              IF WS-LX-DT-LST-MOVE-NULL-IND = -1                        
P00462          IF WS-LX-DT-PURCHASE-NULL-IND  = -1                     
                   MOVE 0                TO WS-LX-DT-LST-MOVE-NULL-IND  
                   MOVE '1900-01-01'     TO MP-DATE-MOVE                
P00462          ELSE                                                    
P00462             MOVE LX-DATE-PURCHASED     TO MP-DATE-MOVE           
P00462          END-IF                                                  
              ELSE                                                      
                 MOVE LX-DATE-LAST-MOVE     TO MP-DATE-MOVE             
              END-IF                                                    
                                                                        
              MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                        
                                            TO MP-DEVICE-NO             
              MOVE LX-CODE-ATT-TYPE         TO MP-CODE-ATT-TYPE         
              MOVE WS-CURRENT-TIMESTAMP     TO MP-MOVE-NO               
              MOVE LX-MTR-STORAGE-FAC-CD    TO MP-MTR-STORAGE-FAC-CD    
              MOVE SPACES                   TO MP-METER-NO              
              MOVE LX-EQUIP-LOC-ID          TO MP-EQUIP-LOC-ID          
                                                                        
              PERFORM 8050-INSERT-EQUIP-ATT-MOVE                        
                                            THRU 8050-EXIT              
                                                                        
              MOVE WS-LOCATION-ATTACHED-K   TO LX-EQUIP-LOC-ID          
              MOVE WS-CURRENT-DATE          TO LX-DATE-LAST-MOVE        
              MOVE WS-CURRENT-DATE          TO LX-DATE-LAST-TRAN        
A00631                                         LX-EQUIP-ATTACH-DT       
A00631        MOVE ZEROS                   TO WS-EQUIP-ATTACH-DT-NULL   
              MOVE WS-LOCAL-OFFICE          TO LX-MTR-STORAGE-FAC-CD    
                                                                        
              PERFORM 8170-UPDATE-EQUIP-ATTCH-DTLS                      
                                            THRU 8170-EXIT              
           END-IF                                                       
                                                                        
           IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K                 
            OR WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J             
                                                                        
              PERFORM 5200-UPDT-JRNL-ADD-ATTCH                          
                                            THRU 5200-EXIT              
           END-IF.                                                      
                                                                        
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2230-UPDATE-CONST-CODE-ATTCH                                   *        
      ******************************************************************        
       2230-UPDATE-CONST-CODE-ATTCH.                                    
                                                                        
           MOVE WS-IN-COMPANY-NO            TO MC-COMPANY-NO            
                                               EQ-COMPANY-NO            
                                               EM-COMPANY-NO.           
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE        TO EQ-CODE-UTIL-TYPE        
                                               MC-CODE-UTIL-TYPE        
                                               EM-CODE-UTIL-TYPE.       
                                                                        
           IF WS-CONSTANT-UPDATE                                        
                                                                        
              MOVE WS-IN-DEVICE-NO          TO MC-METER-NO              
                                                                        
              PERFORM 7020-GET-MTR-CAP-CONSTANT                         
                                            THRU 7020-EXIT              
                                                                        
              MOVE MC-CONSTANT              TO WS-OLD-CONSTANT          
                                                                        
                                                                        
              MOVE 8100                     TO RS-INFO-RETURN-CODE      
                                                                        
              IF WS-IN-ALLOW-OVERRIDE = 'Y'                             
                                                                        
                 MOVE WS-IN-CONSTANT        TO WS-NEW-CONSTANT          
                                                                        
              ELSE                                                      
                                                                        
**************CPD00526***CPD00526***CPD00526***CPD00526***CPD00526****          
                                                                        
                 MOVE WS-IN-DEVICE-NO       TO EQ-DEVICE-NO             
      *** PASS THE INPUT CONSTANT TO CPD526 WHICH WILL BE COMPARED              
      *** WITH THE COMPUTED CONSTANT                                            
                 MOVE WS-IN-CONSTANT        TO WS-526-IN-CONSTANT       
                                                                        
                 PERFORM 5400-LOAD-CONSTANT-COMPUTE                     
                                            THRU 5400-EXIT              
                                                                        
                 PERFORM 6200-COMPUTE-MTR-CAP-CONSTANT                  
                                            THRU 6200-EXIT              
                                                                        
                 MOVE WS-526-NEW-CONSTANT   TO WS-NEW-CONSTANT          
**************CPD00526***CPD00526***CPD00526***CPD00526***CPD00526****          
                                                                        
      *** IF THE RATIO DIFFERS B/W THE SAME TRANSFORMER TYPE THEN               
      *** SEND THE ERROR CODE AS 8200                                           
                 IF WS-526-RATIO-DIFFERS                                
                    MOVE 8200               TO RS-INFO-RETURN-CODE      
                 ELSE                                                   
                    IF WS-526-CONSTANT-MISMATCH                         
                       CONTINUE                                         
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
                                                                        
              IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K              
               OR WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J          
                                                                        
                 MOVE WS-CRNT-LOC-NO        TO CH-PREMISE-NO            
                                                                        
                 PERFORM 7120-GET-ACCOUNT-DETAILS                       
                                            THRU 7120-EXIT              
              ELSE                                                      
                 MOVE ZERO                  TO CH-ACCOUNT-NO            
                                               CH-CUSTOMER-NO           
                                               CH-PREMISE-NO            
              END-IF                                                    
                                                                        
              MOVE WS-OLD-CONSTANT          TO WS-PREV-CONSTANT         
              MOVE WS-NEW-CONSTANT          TO WS-CHNG-CONSTANT         
                                                                        
              PERFORM 5100-UPDATE-JOURNAL-CONSTANT                      
                                            THRU 5100-EXIT              
                                                                        
      *** UPDATE THE CONSTANT FOR THE GIVEN METER                               
              MOVE WS-IN-DEVICE-NO          TO MC-METER-NO              
              MOVE WS-NEW-CONSTANT          TO MC-CONSTANT              
                                                                        
              PERFORM 8160-UPDATE-MTR-CAP-CONSTANT                      
                                            THRU 8160-EXIT              
           END-IF.                                                      
                                                                        
           MOVE 'NNNNNN'                    TO WS-CODE-ATTACHMENT-FLAGS.
                                                                        
           MOVE WS-IN-DEVICE-NO             TO MA-METER-NO.             
           MOVE WS-IN-COMPANY-NO            TO MA-COMPANY-NO.           
           MOVE WS-IN-CODE-UTIL-TYPE        TO MA-CODE-UTIL-TYPE.       
                                                                        
           PERFORM 7140-OPEN-CODE-ATTCH-CUR    THRU 7140-EXIT.          
           PERFORM 7144-FETCH-CODE-ATTCH-CUR   THRU 7144-EXIT.          
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              EVALUATE MA-CODE-ATT-TYPE                                 
                WHEN WS-ATT-CT-RATED-CT                                 
                   MOVE 'Y'                 TO WS-ATT-CT-RATED          
                WHEN WS-ATT-PT-RATED-PT                                 
                   MOVE 'Y'                 TO WS-ATT-PT-RATED          
                WHEN WS-ATT-MAG-TAPE-MT                                 
                   MOVE 'Y'                 TO WS-ATT-MAG-TAPE          
                WHEN WS-ATT-IDR-DEVC-ID                                 
                   MOVE 'Y'                 TO WS-ATT-IDR-DEVC          
                WHEN WS-ATT-REACTIVE-MTR-RE                             
                   MOVE 'Y'                 TO WS-ATT-REACTIVE-MTR      
                WHEN WS-ATT-V2H-MTR-VH                                  
                   MOVE 'Y'                 TO WS-ATT-V2H-MTR           
              END-EVALUATE                                              
                                                                        
              PERFORM 7144-FETCH-CODE-ATTCH-CUR THRU 7144-EXIT          
                                                                        
            END-PERFORM.                                                
                                                                        
            PERFORM 7148-CLOSE-CODE-ATTCH-CUR  THRU 7148-EXIT.          
                                                                        
            MOVE WS-IN-DEVICE-NO               TO EM-METER-NO.          
            MOVE WS-IN-ALLOW-OVERRIDE          TO EM-OVERRIDE-CONST-FL  
            MOVE WS-IN-TEST-SCHED-CD           TO EM-TEST-SCHED-CD.     
            MOVE WS-CODE-ATTACHMENT-FLAGS      TO EM-CODE-ATTACHMENTS.  
                                                                        
            PERFORM 8060-UPDATE-ELEC-METER     THRU 8060-EXIT.          
                                                                        
            MOVE WS-IN-DEVICE-NO               TO EQ-DEVICE-NO.         
                                                                        
            PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                       
                                               THRU 8120-EXIT.          
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-DELETE-ATTCHMNTS                                  *        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-DELETE-ATTCHMNTS.                                   
                                                                        
           SET WS-XFORMER-NOT-REMOVED            TO TRUE.               
                                                                        
           MOVE WS-IN-COMPANY-NO                 TO MA-COMPANY-NO       
                                                    EQ-COMPANY-NO       
                                                    MV-COMPANY-NO       
                                                    MC-COMPANY-NO       
                                                    EM-COMPANY-NO       
                                                    LX-COMPANY-NO.      
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE             TO MA-CODE-UTIL-TYPE   
                                                    MC-CODE-UTIL-TYPE   
                                                    EM-CODE-UTIL-TYPE   
                                                    LX-CODE-UTIL-TYPE.  
                                                                        
           MOVE WS-IN-DEVICE-NO                  TO MA-METER-NO.        
                                                                        
           PERFORM 7190-OPEN-MTR-ATTCH-DEL       THRU 7190-EXIT.        
           PERFORM 7194-FETCH-MTR-ATTCH-DEL      THRU 7194-EXIT.        
                                                                        
           MOVE +1                             TO WS-TRAN-APPL-NO.      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              IF MA-CODE-DEVICE-TYPE = WS-TRNSFR-TRANSFORMERS-T         
      *** SET TO TRUE SINCE THIS METER HAD TRANSFORMER TYPE ATTACHMENT          
      *** SO THAT WE NEED TO UPDATE THE CONSTANT BEFORE THAT CHECK              
      *** USER HAS RELAVANT SECURITY                                            
                                                                        
                 IF WS-IN-SECURITY-FLAG = 'N' AND                       
                    NOT WS-XFORMER-REMOVED                              
                                                                        
                    MOVE 6000                        TO RS-RETURN-CODE  
                    PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT     
                    PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT    
                    PERFORM 9999-END-PROGRAM         THRU 9999-EXIT     
                 END-IF                                                 
                                                                        
                 SET WS-XFORMER-REMOVED          TO TRUE                
              END-IF                                                    
                                                                        
              IF MA-CODE-ATT-TYPE = WS-CURRENT-XFORMER-CT               
                OR MA-CODE-ATT-TYPE = WS-POTENTIAL-XFORMER-PT           
                                                                        
                 MOVE MA-DEVICE-NO               TO MV-DEVICE-NO        
                 MOVE WS-CURRENT-DATE            TO MV-DATE-MOVE        
                 MOVE EQ-LOCAL-OFFICE            TO MV-LOCAL-OFFICE     
                 MOVE +0                         TO MV-LOC-NO           
                 MOVE WS-LOCATION-INVENTORY-A    TO MV-CODE-CRNT-LOC    
                 MOVE WS-CURRENT-TIMESTAMP       TO MV-MOVE-NO          
                 MOVE WS-UTIL-TYPE-XFORMER-X     TO MV-CODE-UTIL-TYPE   
                 MOVE WS-DEVICE-XFORMER-T        TO MV-CODE-DEVICE-TYPE 
                                                                        
                 PERFORM 8000-INSERT-MOVEMNT-HIST THRU 8000-EXIT        
                                                                        
                 MOVE MA-DEVICE-NO               TO EQ-DEVICE-NO        
                 MOVE WS-UTIL-TYPE-XFORMER-X     TO EQ-CODE-UTIL-TYPE   
                 MOVE WS-LOCATION-INVENTORY-A    TO EQ-CODE-CRNT-LOC    
                 MOVE +0                         TO EQ-CRNT-LOC-NO      
                                                                        
                 PERFORM 8130-UPDATE-EQUIP-CRNT-LOC                     
                                                 THRU 8130-EXIT         
                                                                        
              END-IF                                                    
                                                                        
              MOVE WS-IN-COMPANY-NO              TO MA-COMPANY-NO       
              MOVE WS-IN-CODE-UTIL-TYPE          TO MA-CODE-UTIL-TYPE   
              MOVE WS-IN-DEVICE-NO               TO MA-METER-NO         
                                                                        
              PERFORM 8020-DELETE-METER-ATTCHMTS THRU 8020-EXIT         
                                                                        
              MOVE MA-DEVICE-NO                  TO LX-DEVICE-NO        
              MOVE MA-CODE-ATT-TYPE              TO LX-CODE-ATT-TYPE    
                                                                        
              PERFORM 7110-GET-EQUIP-ATTCH-DETAILS                      
                                                 THRU 7110-EXIT         
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-LX-DT-LST-MOVE-NULL-IND= -1                      
P00462             IF WS-LX-DT-PURCHASE-NULL-IND  = -1                  
                    MOVE 0                TO WS-LX-DT-LST-MOVE-NULL-IND 
                    MOVE '1900-01-01'     TO MP-DATE-MOVE               
P00462             ELSE                                                 
P00462               MOVE LX-DATE-PURCHASED     TO MP-DATE-MOVE         
P00462             END-IF                                               
                 ELSE                                                   
                    MOVE LX-DATE-LAST-MOVE       TO MP-DATE-MOVE        
                 END-IF                                                 
                                                                        
                 MOVE MA-DEVICE-NO               TO MP-DEVICE-NO        
                 MOVE LX-CODE-ATT-TYPE           TO MP-CODE-ATT-TYPE    
                 MOVE WS-IN-COMPANY-NO           TO MP-COMPANY-NO       
                 MOVE WS-UTIL-TYPE-ELECTRIC-E    TO MP-CODE-UTIL-TYPE   
                 MOVE WS-CURRENT-TIMESTAMP       TO MP-MOVE-NO          
                 MOVE LX-MTR-STORAGE-FAC-CD    TO MP-MTR-STORAGE-FAC-CD 
                 MOVE WS-IN-DEVICE-NO            TO MP-METER-NO         
                 MOVE LX-EQUIP-LOC-ID            TO MP-EQUIP-LOC-ID     
                                                                        
                 PERFORM 8050-INSERT-EQUIP-ATT-MOVE                     
                                                 THRU 8050-EXIT         
                                                                        
                 IF WS-CODE-CRNT-LOC = 'B'                              
                    MOVE 'B'                     TO LX-EQUIP-LOC-ID     
                 ELSE                                                   
                    MOVE 'A'                     TO LX-EQUIP-LOC-ID     
                 END-IF                                                 
                                                                        
A00631           MOVE SPACES                  TO LX-EQUIP-ATTACH-DT     
A00631           MOVE -1                      TO WS-EQUIP-ATTACH-DT-NULL
                 MOVE WS-CURRENT-DATE            TO LX-DATE-LAST-MOVE   
                 MOVE ZERO                       TO WS-DT-LST-MOVE-NULL 
                 MOVE WS-CURRENT-DATE            TO LX-DATE-LAST-TRAN   
                                                                        
                 PERFORM 8170-UPDATE-EQUIP-ATTCH-DTLS                   
                                                 THRU 8170-EXIT         
              END-IF                                                    
                                                                        
              IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K              
               OR WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J          
                                                                        
                 MOVE WS-CRNT-LOC-NO           TO CH-PREMISE-NO         
                                                                        
                 PERFORM 7120-GET-ACCOUNT-DETAILS                       
                                               THRU 7120-EXIT           
                                                                        
                 MOVE MA-CODE-ATT-TYPE         TO WS-ATTCH-TYP-TX       
                 MOVE MA-DEVICE-NO             TO WS-DEVICE-NO-TX       
                                                                        
                 PERFORM 5300-UPDT-JRNL-DEL-ATTCH                       
                                               THRU 5300-EXIT           
              END-IF                                                    
              PERFORM 7194-FETCH-MTR-ATTCH-DEL THRU 7194-EXIT           
           END-PERFORM.                                                 
           PERFORM 7198-CLOSE-MTR-ATTCH-DEL    THRU 7198-EXIT           
                                                                        
           IF WS-XFORMER-REMOVED                                        
                                                                        
              MOVE WS-IN-DEVICE-NO             TO MC-METER-NO           
                                                                        
              PERFORM 7020-GET-MTR-CAP-CONSTANT THRU 7020-EXIT          
                                                                        
P00447        IF MC-CONSTANT NOT = WS-DEFAULT-CONSTANT                  
                                                                        
                 IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K           
                  OR WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J       
                                                                        
                    MOVE WS-CRNT-LOC-NO        TO CH-PREMISE-NO         
                                                                        
                    PERFORM 7120-GET-ACCOUNT-DETAILS                    
                                               THRU 7120-EXIT           
                 ELSE                                                   
                    MOVE ZERO                  TO CH-ACCOUNT-NO         
                                                  CH-CUSTOMER-NO        
                                                  CH-PREMISE-NO         
                 END-IF                                                 
                                                                        
                 MOVE MC-CONSTANT              TO WS-PREV-CONSTANT      
P00447           MOVE WS-DEFAULT-CONSTANT      TO WS-CHNG-CONSTANT      
                                                                        
                 PERFORM 5100-UPDATE-JOURNAL-CONSTANT                   
                                               THRU 5100-EXIT           
                                                                        
                 MOVE 8100                     TO RS-INFO-RETURN-CODE   
      *** SINCE ALL THE TRANSFORMER ARE REMVOED, CONSTANT IS SET TO             
      *** THE DEFAULT                                                           
                                                                        
                 MOVE WS-IN-DEVICE-NO          TO MC-METER-NO           
P00447           MOVE WS-DEFAULT-CONSTANT      TO MC-CONSTANT           
                                                                        
                 PERFORM 8160-UPDATE-MTR-CAP-CONSTANT                   
                                               THRU 8160-EXIT           
              END-IF                                                    
                                                                        
              MOVE WS-IN-DEVICE-NO             TO EM-METER-NO           
              MOVE 'N'                         TO EM-OVERRIDE-CONST-FL  
              MOVE WS-RANDOM-TESTING-R         TO EM-TEST-SCHED-CD      
              MOVE SPACES                      TO EM-CODE-ATTACHMENTS   
                                                                        
              PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT           
           END-IF.                                                      
                                                                        
           MOVE WS-IN-DEVICE-NO                TO EQ-DEVICE-NO.         
           MOVE WS-IN-CODE-UTIL-TYPE           TO EQ-CODE-UTIL-TYPE.    
                                                                        
           PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                        
                                               THRU 8120-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2400-PROCESS-UPDATE-ATTCHMNTS                                 *         
      *****************************************************************         
      *                                                                         
       2400-PROCESS-UPDATE-ATTCHMNTS.                                   
      *                                                                         
           SET ATTCH-INDX                   TO +1.                      
                                                                        
           MOVE WS-IN-COMPANY-NO            TO EQ-COMPANY-NO            
                                               LX-COMPANY-NO            
                                               MA-COMPANY-NO            
                                               MC-COMPANY-NO            
                                               EM-COMPANY-NO            
                                               MV-COMPANY-NO.           
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE        TO LX-CODE-UTIL-TYPE        
                                               MC-CODE-UTIL-TYPE        
                                               EM-CODE-UTIL-TYPE        
                                               MA-CODE-UTIL-TYPE.       
                                                                        
           MOVE 'NNNNNN'                    TO WS-CODE-ATTACHMENT-FLAGS.
                                                                        
           SET WS-XFORMER-NOT-REMOVED            TO TRUE                
                                                                        
           PERFORM VARYING ATTCH-INDX FROM 1 BY 1                       
             UNTIL ATTCH-INDX > 20                                      
                OR WS-ARRY-ATTCH-INFO(ATTCH-INDX) = SPACES              
                                                                        
              IF WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                        
                                            = WS-CURRENT-XFORMER-CT     
                OR WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                      
                                            = WS-POTENTIAL-XFORMER-PT   
                 MOVE WS-UTIL-TYPE-XFORMER-X    TO WS-CODE-UTIL-TYPE    
                 MOVE WS-DEVICE-XFORMER-T       TO WS-CODE-DEVICE-TYPE  
      *** SET TO TRUE SINCE THIS METER HAD TRANSFORMER TYPE ATTACHMENT          
      *** SO THAT WE NEED TO UPDATE THE CONSTANT                                
                 SET WS-XFORMER-REMOVED         TO TRUE                 
                                                                        
              ELSE                                                      
                 MOVE WS-UTIL-TYPE-ELECTRIC-E   TO WS-CODE-UTIL-TYPE    
                 MOVE WS-DEVICE-METER-M         TO WS-CODE-DEVICE-TYPE  
              END-IF                                                    
                                                                        
              IF WS-ARRY-ATTACH-TYPE(ATTCH-INDX) NOT = WS-ATT-TYPE-ERT  
P00462          AND WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                     
P00462                                NOT = WS-ATT-TYPE-SMARTSYNCH      
P00462          AND WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                     
P00462                                NOT = WS-ATT-TYPE-KBASE           
                                                                        
                 MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX) TO MV-DEVICE-NO     
                 MOVE WS-CURRENT-DATE               TO MV-DATE-MOVE     
                 MOVE WS-LOCAL-OFFICE               TO MV-LOCAL-OFFICE  
                 MOVE +0                            TO MV-LOC-NO        
                 MOVE WS-CODE-CRNT-LOC              TO MV-CODE-CRNT-LOC 
                 MOVE WS-CURRENT-TIMESTAMP          TO MV-MOVE-NO       
                 MOVE WS-CODE-UTIL-TYPE             TO MV-CODE-UTIL-TYPE
                 MOVE WS-CODE-DEVICE-TYPE         TO MV-CODE-DEVICE-TYPE
                                                                        
                 PERFORM 8000-INSERT-MOVEMNT-HIST THRU 8000-EXIT        
                                                                        
                 MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX) TO EQ-DEVICE-NO     
                 MOVE WS-CODE-UTIL-TYPE             TO EQ-CODE-UTIL-TYPE
                 MOVE WS-LOCATION-INVENTORY-A       TO EQ-CODE-CRNT-LOC 
                 MOVE +0                            TO EQ-CRNT-LOC-NO   
                                                                        
                 PERFORM 8130-UPDATE-EQUIP-CRNT-LOC THRU 8130-EXIT      
                                                                        
              END-IF                                                    
                                                                        
              MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                        
                                                    TO LX-DEVICE-NO     
              MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)  TO LX-CODE-ATT-TYPE 
                                                                        
              PERFORM 7110-GET-EQUIP-ATTCH-DETAILS                      
                                               THRU 7110-EXIT           
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-LX-DT-LST-MOVE-NULL-IND = -1                     
P00462             IF WS-LX-DT-PURCHASE-NULL-IND  = -1                  
                    MOVE 0                TO WS-LX-DT-LST-MOVE-NULL-IND 
                    MOVE '1900-01-01'     TO MP-DATE-MOVE               
P00462             ELSE                                                 
P00462               MOVE LX-DATE-PURCHASED     TO MP-DATE-MOVE         
P00462             END-IF                                               
                 ELSE                                                   
                    MOVE LX-DATE-LAST-MOVE     TO MP-DATE-MOVE          
                 END-IF                                                 
                                                                        
                 MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                     
                                               TO MP-DEVICE-NO          
                 MOVE LX-CODE-ATT-TYPE         TO MP-CODE-ATT-TYPE      
                 MOVE WS-IN-COMPANY-NO         TO MP-COMPANY-NO         
                 MOVE WS-IN-CODE-UTIL-TYPE     TO MP-CODE-UTIL-TYPE     
                 MOVE WS-CURRENT-TIMESTAMP     TO MP-MOVE-NO            
                 MOVE LX-MTR-STORAGE-FAC-CD    TO MP-MTR-STORAGE-FAC-CD 
                 MOVE SPACES                   TO MP-METER-NO           
                 MOVE LX-EQUIP-LOC-ID          TO MP-EQUIP-LOC-ID       
                                                                        
                 PERFORM 8050-INSERT-EQUIP-ATT-MOVE                     
                                               THRU 8050-EXIT           
                                                                        
                 IF WS-CODE-CRNT-LOC = 'B'                              
                    MOVE 'B'                   TO LX-EQUIP-LOC-ID       
                 ELSE                                                   
                    MOVE 'A'                   TO LX-EQUIP-LOC-ID       
                 END-IF                                                 
                                                                        
A00631           MOVE SPACES               TO LX-EQUIP-ATTACH-DT        
A00631           MOVE -1                   TO WS-EQUIP-ATTACH-DT-NULL   
                 MOVE WS-CURRENT-DATE          TO LX-DATE-LAST-MOVE     
                 MOVE WS-CURRENT-DATE          TO LX-DATE-LAST-TRAN     
                                                                        
                 PERFORM 8170-UPDATE-EQUIP-ATTCH-DTLS                   
                                               THRU 8170-EXIT           
                                                                        
              END-IF                                                    
                                                                        
              MOVE WS-IN-DEVICE-NO             TO MA-METER-NO           
              MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                        
                                               TO MA-DEVICE-NO          
                                                                        
              PERFORM 8020-DELETE-METER-ATTCHMTS                        
                                               THRU 8020-EXIT           
              IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K              
               OR WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J          
                                                                        
                 MOVE WS-CRNT-LOC-NO           TO CH-PREMISE-NO         
                                                                        
                 PERFORM 7120-GET-ACCOUNT-DETAILS                       
                                               THRU 7120-EXIT           
                                                                        
                 MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                   
                                               TO WS-ATTCH-TYP-TX       
                 MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                     
                                               TO WS-DEVICE-NO-TX       
                                                                        
                 PERFORM 5300-UPDT-JRNL-DEL-ATTCH                       
                                               THRU 5300-EXIT           
              END-IF                                                    
                                                                        
           END-PERFORM.                                                 
                                                                        
           IF WS-XFORMER-REMOVED OR WS-IN-ALLOW-OVERRIDE = 'Y'          
                                                                        
              IF WS-IN-SECURITY-FLAG = 'N'                              
                 MOVE 6000                      TO RS-RETURN-CODE       
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
              END-IF                                                    
                                                                        
              MOVE WS-IN-DEVICE-NO             TO MC-METER-NO           
                                                                        
              PERFORM 7020-GET-MTR-CAP-CONSTANT THRU 7020-EXIT          
                                                                        
              MOVE MC-CONSTANT                 TO WS-OLD-CONSTANT       
                                                                        
              MOVE 8100                        TO RS-INFO-RETURN-CODE   
                                                                        
              IF WS-IN-ALLOW-OVERRIDE = 'Y'                             
                                                                        
                 MOVE WS-IN-CONSTANT        TO WS-NEW-CONSTANT          
                                                                        
              ELSE                                                      
                                                                        
**************CPD00526***CPD00526***CPD00526***CPD00526***CPD00526****          
                                                                        
                 MOVE WS-IN-DEVICE-NO       TO EQ-DEVICE-NO             
      *** PASS THE INPUT CONSTANT TO CPD526 WHICH WILL BE COMPARED              
      *** WITH THE COMPUTED CONSTANT                                            
                 MOVE WS-IN-CONSTANT        TO WS-526-IN-CONSTANT       
                                                                        
                 PERFORM 5400-LOAD-CONSTANT-COMPUTE                     
                                            THRU 5400-EXIT              
                                                                        
                 PERFORM 6200-COMPUTE-MTR-CAP-CONSTANT                  
                                            THRU 6200-EXIT              
                                                                        
                 MOVE WS-526-NEW-CONSTANT   TO WS-NEW-CONSTANT          
**************CPD00526***CPD00526***CPD00526***CPD00526***CPD00526****          
                                                                        
      *** IF THE RATIO DIFFERS B/W THE SAME TRANSFORMER TYPE THEN               
      *** SEND THE ERROR CODE AS 8200                                           
                 IF WS-526-RATIO-DIFFERS                                
                    MOVE 8200               TO RS-INFO-RETURN-CODE      
                 ELSE                                                   
                    IF WS-526-CONSTANT-MISMATCH                         
                       CONTINUE                                         
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-CODE-CRNT-LOC = WS-LOCATION-ATTACHED-K              
               OR WS-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER-J          
                                                                        
                 MOVE WS-CRNT-LOC-NO           TO CH-PREMISE-NO         
                                                                        
                 PERFORM 7120-GET-ACCOUNT-DETAILS                       
                                               THRU 7120-EXIT           
              ELSE                                                      
                 MOVE ZERO                     TO CH-ACCOUNT-NO         
                                                  CH-CUSTOMER-NO        
                                                  CH-PREMISE-NO         
              END-IF                                                    
                                                                        
              MOVE WS-OLD-CONSTANT             TO WS-PREV-CONSTANT      
              MOVE WS-NEW-CONSTANT             TO WS-CHNG-CONSTANT      
                                                                        
              PERFORM 5100-UPDATE-JOURNAL-CONSTANT                      
                                               THRU 5100-EXIT           
                                                                        
              MOVE WS-IN-DEVICE-NO             TO MC-METER-NO           
              MOVE WS-NEW-CONSTANT             TO MC-CONSTANT           
                                                                        
      *** UPDATE THE CONSTANT FOR THE GIVEN METER                               
              PERFORM 8160-UPDATE-MTR-CAP-CONSTANT                      
                                               THRU 8160-EXIT           
           END-IF.                                                      
                                                                        
           MOVE WS-IN-DEVICE-NO                TO EM-METER-NO           
           MOVE WS-IN-ALLOW-OVERRIDE           TO EM-OVERRIDE-CONST-FL  
           MOVE WS-IN-TEST-SCHED-CD            TO EM-TEST-SCHED-CD      
           MOVE SPACES                         TO EM-CODE-ATTACHMENTS   
                                                                        
           PERFORM 8060-UPDATE-ELEC-METER   THRU 8060-EXIT.             
                                                                        
           MOVE WS-IN-DEVICE-NO                TO EQ-DEVICE-NO.         
           MOVE WS-IN-CODE-UTIL-TYPE           TO EQ-CODE-UTIL-TYPE.    
                                                                        
           PERFORM 8120-UPDATE-EQUIP-LST-TRAN-DT                        
                                               THRU 8120-EXIT.          
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      * 5000-GET-STRING-LENGTH                                        *         
      *****************************************************************         
      *                                                                         
       5000-GET-STRING-LENGTH.                                          
      *                                                                         
           UNSTRING WS-LEN-OF-COMMENTS DELIMITED BY '  ' INTO           
                   WS-CMNTS                                             
            COUNT IN WS-COMMENTS-LEN.                                   
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5100-UPDATE-JOURNAL-CONSTANT                                  *         
      *****************************************************************         
      *                                                                         
       5100-UPDATE-JOURNAL-CONSTANT.                                    
      *                                                                         
           PERFORM 7180-GET-TRANSHIST-SEQ-NO   THRU 7180-EXIT.          
                                                                        
           MOVE WS-TRANSHIST-SEQ-NO            TO MH-TRANS-HIST-SEQ-NO. 
           MOVE WS-TRANSHIST-SEQ-NO(1:10)      TO MH-DATE-TRANS.        
           MOVE 'F'                            TO MH-CODE-TRAN-TYPE.    
           MOVE 161                            TO MH-RESP-AREA-ID.      
           MOVE CH-ACCOUNT-NO                  TO MH-ACCOUNT-NO.        
           MOVE CH-PREMISE-NO                  TO MH-PREMISE-NO.        
           MOVE CH-CUSTOMER-NO                 TO MH-CUSTOMER-NO.       
           MOVE WS-IN-USER-ID                  TO MH-USER-ID.           
                                                                        
           MOVE SPACES                         TO MH-TRAN-COMMENT-TEXT  
                                                  WS-LEN-OF-COMMENTS.   
           IF WS-IN-UPDATE-IND = 'D'                                    
              MOVE WS-IN-TRAN-COMMENTS        TO WS-IN-CONST-USR-CMT-D  
              MOVE WS-IN-DEVICE-NO            TO WS-CMNT-CNST-DEV-NO-D  
              MOVE WS-TRANS-CMNT-CONST-DEL    TO MH-TRAN-COMMENT-TEXT   
                                                 WS-LEN-OF-COMMENTS     
           ELSE                                                         
              MOVE WS-IN-TRAN-COMMENTS        TO WS-IN-CONST-USR-CMT    
              MOVE WS-IN-DEVICE-NO            TO WS-CMNT-CNST-DEV-NO-C  
              MOVE WS-TRANS-CMNT-CONSTANT     TO MH-TRAN-COMMENT-TEXT   
                                                 WS-LEN-OF-COMMENTS     
           END-IF.                                                      
                                                                        
           PERFORM 5000-GET-STRING-LENGTH      THRU 5000-EXIT.          
           MOVE WS-COMMENTS-LEN                TO MH-TRAN-COMMENT-LEN   
                                                                        
           MOVE WS-IN-APPL-PROGRAM-ID          TO MH-APPL-PROGRAM-ID.   
           MOVE +1                             TO WS-TRAN-APPL-NO.      
                                                                        
           PERFORM 5120-UPDATE-JRNL-CONST-DETAIL                        
                                               THRU 5120-EXIT.          
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5120-UPDATE-JRNL-CONST-DETAIL                                *          
      *                                                              *          
      ****************************************************************          
       5120-UPDATE-JRNL-CONST-DETAIL.                                   
      *                                                                         
           IF WS-PREV-CONSTANT NOT = WS-CHNG-CONSTANT                   
              MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'CONSTANT'              TO MI-COLUMN-DESC            
                                                                        
              MOVE +11                     TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE WS-PREV-CONSTANT        TO WS-CONSTANT-DISP          
              MOVE WS-CONSTANT-DISP        TO MI-PRV-COLUMN-VALUE-TEXT  
                                                                        
              MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE WS-CHNG-CONSTANT        TO WS-CONSTANT-DISP          
              MOVE WS-CONSTANT-DISP        TO MI-CHG-COLUMN-VALUE-TEXT  
                                                                        
              MOVE 'MC'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
      *                                                                         
       5120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5200-UPDT-JRNL-ADD-ATTCH                                      *         
      *****************************************************************         
      *                                                                         
       5200-UPDT-JRNL-ADD-ATTCH.                                        
      *                                                                         
           IF WS-TRAN-APPL-NO <= 1                                      
                                                                        
              PERFORM 7180-GET-TRANSHIST-SEQ-NO THRU 7180-EXIT          
                                                                        
              MOVE WS-TRANSHIST-SEQ-NO          TO MH-TRANS-HIST-SEQ-NO 
              MOVE WS-TRANSHIST-SEQ-NO(1:10)    TO MH-DATE-TRANS        
              MOVE 'F'                          TO MH-CODE-TRAN-TYPE    
              MOVE 161                          TO MH-RESP-AREA-ID      
              MOVE CH-ACCOUNT-NO                TO MH-ACCOUNT-NO        
              MOVE CH-PREMISE-NO                TO MH-PREMISE-NO        
              MOVE CH-CUSTOMER-NO               TO MH-CUSTOMER-NO       
              MOVE WS-IN-USER-ID                TO MH-USER-ID           
                                                                        
              MOVE SPACES                       TO MH-TRAN-COMMENT-TEXT 
                                                   WS-LEN-OF-COMMENTS   
                                                                        
              MOVE WS-IN-TRAN-COMMENTS         TO WS-IN-ATTCH-USR-CMT-A 
              MOVE WS-IN-DEVICE-NO              TO WS-CMNT-DEVICE-NO-A  
              MOVE WS-TRANS-CMNT-ADD-ATTCH      TO MH-TRAN-COMMENT-TEXT 
                                                   WS-LEN-OF-COMMENTS   
                                                                        
              PERFORM 5000-GET-STRING-LENGTH    THRU 5000-EXIT          
              MOVE WS-COMMENTS-LEN              TO MH-TRAN-COMMENT-LEN  
                                                                        
              MOVE WS-IN-APPL-PROGRAM-ID        TO MH-APPL-PROGRAM-ID   
              MOVE +1                           TO WS-TRAN-APPL-NO      
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 5220-UPDT-JRNL-ADD-ATTCH-DETL THRU 5220-EXIT.        
                                                                        
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5220-UPDT-JRNL-ADD-ATTCH-DETL                                *          
      *                                                              *          
      ****************************************************************          
       5220-UPDT-JRNL-ADD-ATTCH-DETL.                                   
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE 'ATTACHMENT'            TO MI-COLUMN-DESC.              
                                                                        
           MOVE +05                     TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
                                                                        
           MOVE +15                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE WS-ARRY-ATTACH-TYPE(ATTCH-INDX)                         
                                        TO WS-ATTCH-TYP-TX.             
           MOVE WS-ARRY-DEVICE-NO(ATTCH-INDX)                           
                                        TO WS-DEVICE-NO-TX.             
           MOVE WS-ATTCH-TYP-DEVICE-TX  TO MI-CHG-COLUMN-VALUE-TEXT.    
                                                                        
           MOVE SPACES                  TO MI-TABLE-ID.                 
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD 1                        TO WS-TRAN-APPL-NO.             
      *                                                                         
       5220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5300-UPDT-JRNL-DEL-ATTCH                                      *         
      *****************************************************************         
      *                                                                         
       5300-UPDT-JRNL-DEL-ATTCH.                                        
      *                                                                         
           IF WS-TRAN-APPL-NO <= 1                                      
                                                                        
              PERFORM 7180-GET-TRANSHIST-SEQ-NO THRU 7180-EXIT          
                                                                        
              MOVE WS-TRANSHIST-SEQ-NO          TO MH-TRANS-HIST-SEQ-NO 
              MOVE WS-TRANSHIST-SEQ-NO(1:10)    TO MH-DATE-TRANS        
              MOVE 'F'                          TO MH-CODE-TRAN-TYPE    
              MOVE CH-ACCOUNT-NO                TO MH-ACCOUNT-NO        
              MOVE CH-PREMISE-NO                TO MH-PREMISE-NO        
              MOVE CH-CUSTOMER-NO               TO MH-CUSTOMER-NO       
              MOVE WS-IN-USER-ID                TO MH-USER-ID           
                                                   C1-USER-ID           
              PERFORM 7130-GET-RESP-AREA-ID     THRU 7130-EXIT          
              MOVE C1-RESP-AREA-ID              TO MH-RESP-AREA-ID      
              MOVE SPACES                       TO MH-TRAN-COMMENT-TEXT 
                                                   WS-LEN-OF-COMMENTS   
                                                                        
              MOVE WS-IN-TRAN-COMMENTS         TO WS-IN-ATTCH-USR-CMT-D 
              MOVE WS-IN-DEVICE-NO              TO WS-CMNT-DEVICE-NO-D  
              MOVE WS-TRANS-CMNT-DEL-ATTCH      TO MH-TRAN-COMMENT-TEXT 
                                                   WS-LEN-OF-COMMENTS   
                                                                        
              PERFORM 5000-GET-STRING-LENGTH    THRU 5000-EXIT          
              MOVE WS-COMMENTS-LEN              TO MH-TRAN-COMMENT-LEN  
                                                                        
              MOVE WS-IN-APPL-PROGRAM-ID        TO MH-APPL-PROGRAM-ID   
              MOVE +1                           TO WS-TRAN-APPL-NO      
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 5320-UPDT-JRNL-DEL-ATTCH-DETL THRU 5320-EXIT.        
                                                                        
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5320-UPDT-JRNL-DEL-ATTCH-DETL                                *          
      *                                                              *          
      ****************************************************************          
       5320-UPDT-JRNL-DEL-ATTCH-DETL.                                   
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE 'ATT TYPE DEVICE'       TO MI-COLUMN-DESC.              
                                                                        
           MOVE WS-ATTCH-TYP-DEVICE-TX  TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN.     
                                                                        
           MOVE +09                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT.    
                                                                        
           MOVE SPACES                  TO MI-TABLE-ID.                 
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD 1                        TO WS-TRAN-APPL-NO.             
      *                                                                         
       5320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5350-UPDT-JRNL-XFR-ATTCH                                      *         
      *****************************************************************         
      *                                                                         
       5350-UPDT-JRNL-XFR-ATTCH.                                        
      *                                                                         
           IF WS-TRAN-APPL-NO <= 1                                      
                                                                        
              PERFORM 7180-GET-TRANSHIST-SEQ-NO THRU 7180-EXIT          
                                                                        
              MOVE WS-TRANSHIST-SEQ-NO          TO MH-TRANS-HIST-SEQ-NO 
              MOVE WS-TRANSHIST-SEQ-NO(1:10)    TO MH-DATE-TRANS        
              MOVE 'F'                          TO MH-CODE-TRAN-TYPE    
              MOVE CH-ACCOUNT-NO                TO MH-ACCOUNT-NO        
              MOVE CH-PREMISE-NO                TO MH-PREMISE-NO        
              MOVE CH-CUSTOMER-NO               TO MH-CUSTOMER-NO       
              MOVE WS-IN-USER-ID                TO MH-USER-ID           
                                                   C1-USER-ID           
              PERFORM 7130-GET-RESP-AREA-ID     THRU 7130-EXIT          
              MOVE C1-RESP-AREA-ID              TO MH-RESP-AREA-ID      
              MOVE SPACES                       TO MH-TRAN-COMMENT-TEXT 
                                                   WS-LEN-OF-COMMENTS   
                                                                        
              MOVE WS-IN-TRAN-COMMENTS         TO WS-IN-ATTCH-USR-CMT-X 
              MOVE WS-IN-DEVICE-NO            TO WS-CMNT-FRM-METER-NO-X 
              MOVE WS-IN-XFR-TO-DEVICE-NO     TO WS-CMNT-TO-METER-NO-X  
              MOVE WS-TRANS-CMNT-XFR-ATTCH      TO MH-TRAN-COMMENT-TEXT 
                                                   WS-LEN-OF-COMMENTS   
                                                                        
              PERFORM 5000-GET-STRING-LENGTH    THRU 5000-EXIT          
              MOVE WS-COMMENTS-LEN              TO MH-TRAN-COMMENT-LEN  
                                                                        
              MOVE WS-IN-APPL-PROGRAM-ID        TO MH-APPL-PROGRAM-ID   
              MOVE +1                           TO WS-TRAN-APPL-NO      
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 5370-UPDT-JRNL-XFR-ATTCH-DETL THRU 5370-EXIT.        
                                                                        
      *                                                                         
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5370-UPDT-JRNL-XFR-ATTCH-DETL                                *          
      *                                                              *          
      ****************************************************************          
       5370-UPDT-JRNL-XFR-ATTCH-DETL.                                   
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE 'ATT TYPE DEVICE'       TO MI-COLUMN-DESC.              
                                                                        
           MOVE WS-ATTCH-TYP-DEVICE-TX  TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN.     
                                                                        
           MOVE +13                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE '*TRANSFERRED*'         TO MI-CHG-COLUMN-VALUE-TEXT.    
                                                                        
           MOVE SPACES                  TO MI-TABLE-ID.                 
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD 1                        TO WS-TRAN-APPL-NO.             
      *                                                                         
       5370-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 5400-LOAD-CONSTANT-COMPUTE.                                  *          
      *                                                              *          
      ****************************************************************          
       5400-LOAD-CONSTANT-COMPUTE.                                      
      *                                                                         
           SET ATTCH-526-INDX                    TO +1.                 
           MOVE WS-IN-DEVICE-NO                  TO EQ-DEVICE-NO.       
           MOVE WS-IN-COMPANY-NO                 TO EQ-COMPANY-NO.      
           MOVE WS-IN-CODE-UTIL-TYPE             TO EQ-CODE-UTIL-TYPE.  
           PERFORM 7150-OPEN-MTR-CAP-CNST-CUR    THRU 7150-EXIT.        
           PERFORM 7154-FETCH-MTR-CAP-CNST-CUR   THRU 7154-EXIT.        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE MA-CODE-ATT-TYPE              TO                     
                            WS-526-ARRY-ATTACH-TYPE(ATTCH-526-INDX)     
              MOVE MC-CONSTANT                   TO                     
                            WS-526-ARRY-CONSTANT(ATTCH-526-INDX)        
              MOVE MA-DEVICE-NO                  TO                     
                            WS-526-ARRY-DEVICE-NO(ATTCH-526-INDX)       
              MOVE MA-CT-PT-RATIO                TO                     
                            WS-526-ARRY-CT-PT-RATIO(ATTCH-526-INDX)     
              MOVE IX-RTO-UPPER-FRACTION         TO                     
                            WS-526-ARRY-RTO-UPR(ATTCH-526-INDX)         
              MOVE IX-RTO-LOWER-FRACTION         TO                     
                            WS-526-ARRY-RTO-LWR(ATTCH-526-INDX)         
              SET ATTCH-526-INDX                 UP BY +1               
              PERFORM 7154-FETCH-MTR-CAP-CNST-CUR THRU 7154-EXIT        
           END-PERFORM.                                                 
           PERFORM 7158-CLOSE-MTR-CAP-CNST-CUR   THRU 7158-EXIT.        
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6200-COMPUTE-MTR-CAP-CONSTANT                                  *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00526                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      * 7000-GET-EQUIP-DETIALS                                         *        
      ******************************************************************        
      *                                                                         
       7000-GET-EQUIP-DETIALS.                                          
      *                                                                         
            MOVE '7000'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                    CODE_CRNT_LOC                                       
                   ,CRNT_LOC_NO                                         
                   ,SERIAL_NO                                           
                   ,LOCAL_OFFICE                                        
                INTO                                                    
                    :EQ-CODE-CRNT-LOC                                   
                   ,:EQ-CRNT-LOC-NO                                     
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-LOCAL-OFFICE                                    
                FROM                                                    
                    CSS_EQUIPMENT WITH(READUNCOMMITTED)                         
                WHERE                                                   
                    COMPANY_NO     = :EQ-COMPANY-NO                     
                AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                 
                AND DEVICE_NO      = :EQ-DEVICE-NO                      
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*             CODE_CRNT_LOC                                               
MFA-TR*            ,CRNT_LOC_NO                                                 
MFA-TR*            ,SERIAL_NO                                                   
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*         INTO                                                            
MFA-TR*             :EQ-CODE-CRNT-LOC                                           
MFA-TR*            ,:EQ-CRNT-LOC-NO                                             
MFA-TR*            ,:EQ-SERIAL-NO                                               
MFA-TR*            ,:EQ-LOCAL-OFFICE                                            
MFA-TR*         FROM                                                            
MFA-TR*             CSS_EQUIPMENT                                               
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO     = :EQ-COMPANY-NO                             
MFA-TR*         AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                         
MFA-TR*         AND DEVICE_NO      = :EQ-DEVICE-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7010-CHECK-METER-ATTACHEMENTS.                                 *        
      ******************************************************************        
      *                                                                         
       7010-CHECK-METER-ATTACHEMENTS.                                   
      *                                                                         
            MOVE '7010'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) 'Y'                                               
                INTO                                                    
                    :WS-METER-ATTACHMTS-EXISTS                          
                FROM                                                    
                    CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                 
                WHERE                                                   
                    MA.METER_NO        = :MA-METER-NO                   
                AND MA.COMPANY_NO      = :MA-COMPANY-NO                 
                AND MA.CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE             
                AND MA.HOW_ATTACHED_CD <> 'I'                           
P00914          AND CODE_ATT_TYPE NOT  IN ( 'IT', 'DC','SS', 'VZ')      
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*             'Y'                                                         
MFA-TR*         INTO                                                            
MFA-TR*             :WS-METER-ATTACHMTS-EXISTS                                  
MFA-TR*         FROM                                                            
MFA-TR*             CSS_METER_ATTCHMTS MA                                       
MFA-TR*         WHERE                                                           
MFA-TR*             MA.METER_NO        = :MA-METER-NO                           
MFA-TR*         AND MA.COMPANY_NO      = :MA-COMPANY-NO                         
MFA-TR*         AND MA.CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE                     
MFA-TR*         AND MA.HOW_ATTACHED_CD <> 'I'                                   
MFA-TR*         AND CODE_ATT_TYPE NOT  IN ( 'IT', 'DC','SS', 'VZ')              
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTACHMTS' TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7020-GET-MTR-CAP-CONSTANT.                                     *        
      ******************************************************************        
      *                                                                         
       7020-GET-MTR-CAP-CONSTANT.                                       
      *                                                                         
            MOVE '7020'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) CONSTANT                                          
                INTO                                                    
                    :MC-CONSTANT                                        
                FROM                                                    
                    CSS_MTR_CAP MC WITH(READUNCOMMITTED)                        
                WHERE                                                   
                    COMPANY_NO     = :MC-COMPANY-NO                     
                AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                 
                AND METER_NO       = :MC-METER-NO                       
                ORDER BY REG_ID_NO                                      
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*             CONSTANT                                                    
MFA-TR*         INTO                                                            
MFA-TR*             :MC-CONSTANT                                                
MFA-TR*         FROM                                                            
MFA-TR*             CSS_MTR_CAP MC                                              
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO     = :MC-COMPANY-NO                             
MFA-TR*         AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                         
MFA-TR*         AND METER_NO       = :MC-METER-NO                               
MFA-TR*         ORDER BY REG_ID_NO                                              
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7020                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7040-OPEN-MTR-ATTCH-CUR                                        *        
      ******************************************************************        
      *                                                                         
       7040-OPEN-MTR-ATTCH-CUR.                                         
      *                                                                         
            MOVE '7040'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN CSS_MTR_ATTCH_CUR                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_ATTCH_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7044-FETCH-MTR-ATTCH-CUR                                       *        
      ******************************************************************        
      *                                                                         
       7044-FETCH-MTR-ATTCH-CUR.                                        
      *                                                                         
            MOVE '7044'                   TO ACTIVE-PARAGRAPH.          
            MOVE ZERO                     TO WS-DATE-LST-TST-NULL.      
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                   CSS_MTR_ATTCH_CUR                                    
                INTO                                                    
                   :MA-CODE-UTIL-TYPE                                   
                  ,:MA-METER-NO                                         
                  ,:MA-CODE-DEVICE-TYPE                                 
                  ,:MA-DEVICE-NO                                        
                  ,:MA-CODE-ATT-TYPE                                    
                  ,:MA-DATE-LAST-TESTED :WS-DATE-LST-TST-NULL            
                  ,:MA-TEST-SCHED-CD                                    
                  ,:EQ-LOCAL-OFFICE                                     
                  ,:EQ-CODE-CRNT-LOC                                    
                  ,:MA-CT-PT-RATIO                                      
                  ,:MA-HOW-ATTACHED-CD                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-DATE-LST-TST-NULL = -1                             
                  MOVE SPACES             TO MA-DATE-LAST-TESTED        
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_ATTCH_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7044-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7048-CLOSE-MTR-ATTCH-CUR                                       *        
      ******************************************************************        
      *                                                                         
       7048-CLOSE-MTR-ATTCH-CUR.                                        
      *                                                                         
            MOVE '7048'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                CLOSE CSS_MTR_ATTCH_CUR                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_ATTCH_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7048-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7050-GET-XFORMER-DETAILS.                                      *        
      ******************************************************************        
      *                                                                         
       7050-GET-XFORMER-DETAILS.                                        
      *                                                                         
            MOVE '7050'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                   XFORMER_TYPE_CD                                      
                INTO                                                    
                   :IX-XFORMER-TYPE-CD                                  
                FROM                                                    
                    CSS_INSTR_XFORMER WITH(READUNCOMMITTED)                     
                WHERE                                                   
                    COMPANY_NO       = :IX-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :IX-CODE-UTIL-TYPE               
                AND XFORMER_NO       = :IX-XFORMER-NO                   
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            XFORMER_TYPE_CD                                              
MFA-TR*         INTO                                                            
MFA-TR*            :IX-XFORMER-TYPE-CD                                          
MFA-TR*         FROM                                                            
MFA-TR*             CSS_INSTR_XFORMER                                           
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO       = :IX-COMPANY-NO                           
MFA-TR*         AND CODE_UTIL_TYPE   = :IX-CODE-UTIL-TYPE                       
MFA-TR*         AND XFORMER_NO       = :IX-XFORMER-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_INSTR_XFORMER'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_NO'          TO TABLE-ELEMENT-3            
               MOVE IX-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE IX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-NO         TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7060-CHECK-MTR-ATT-TYP-EXISTS                                  *        
      ******************************************************************        
      *                                                                         
        7060-CHECK-MTR-ATT-TYP-EXISTS.                                  
      *                                                                         
            MOVE '7060'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                   'Y'                                                  
PRJ914            ,CODE_DEVICE_TYPE                                     
                INTO                                                    
                   :WS-METER-ATT-TYPE-EXISTS                            
PRJ914            ,:WS-ATTACHMENT-TYPE                                  
                FROM                                                    
                    CSS_MTR_ATT_TYPE WITH(READUNCOMMITTED)                      
                WHERE                                                   
                    CODE_ATT_TYPE    = :N5-CODE-ATT-TYPE                
                AND CODE_UTIL_TYPE   = :N5-CODE-UTIL-TYPE               
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            'Y'                                                          
MFA-TR*           ,CODE_DEVICE_TYPE                                             
MFA-TR*         INTO                                                            
MFA-TR*            :WS-METER-ATT-TYPE-EXISTS                                    
MFA-TR*           ,:WS-ATTACHMENT-TYPE                                          
MFA-TR*         FROM                                                            
MFA-TR*             CSS_MTR_ATT_TYPE                                            
MFA-TR*         WHERE                                                           
MFA-TR*             CODE_ATT_TYPE    = :N5-CODE-ATT-TYPE                        
MFA-TR*         AND CODE_UTIL_TYPE   = :N5-CODE-UTIL-TYPE                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_ATT_TYPE'    TO TABLE-1                    
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE N5-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-1          
               MOVE N5-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7070-GET-MTR-NO-ATTCH-DEVICE                                   *        
      ******************************************************************        
      *                                                                         
        7070-GET-MTR-NO-ATTCH-DEVICE.                                   
      *                                                                         
            MOVE '7070'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) METER_NO                                          
                INTO                                                    
                   :MA-METER-NO                                         
                FROM                                                    
                    CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    DEVICE_NO        = :MA-DEVICE-NO                    
                AND COMPANY_NO       = :MA-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE               
                AND CODE_ATT_TYPE    = :MA-CODE-ATT-TYPE                
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            METER_NO                                                     
MFA-TR*         INTO                                                            
MFA-TR*            :MA-METER-NO                                                 
MFA-TR*         FROM                                                            
MFA-TR*             CSS_METER_ATTCHMTS                                          
MFA-TR*         WHERE                                                           
MFA-TR*             DEVICE_NO        = :MA-DEVICE-NO                            
MFA-TR*         AND COMPANY_NO       = :MA-COMPANY-NO                           
MFA-TR*         AND CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                       
MFA-TR*         AND CODE_ATT_TYPE    = :MA-CODE-ATT-TYPE                        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7070                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                    
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1            
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3            
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-4            
               MOVE MA-DEVICE-NO          TO HOSTVAR-ELEMENT-1          
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-2          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3          
               MOVE MA-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7070-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7074-CHECK-DEVICE-ATTCH-TO-MTR                                 *        
      ******************************************************************        
      *                                                                         
        7074-CHECK-DEVICE-ATTCH-TO-MTR.                                 
      *                                                                         
            MOVE '7074'                   TO ACTIVE-PARAGRAPH.          
            MOVE 'N'                      TO WS-DEVICE-ATTCHED.         
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) 'Y'                                               
                INTO                                                    
                   :WS-DEVICE-ATTCHED                                   
                FROM                                                    
                    CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    METER_NO         = :MA-METER-NO                     
                AND DEVICE_NO        = :MA-DEVICE-NO                    
                AND CODE_ATT_TYPE    = :MA-CODE-ATT-TYPE                
                AND COMPANY_NO       = :MA-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE               
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            'Y'                                                          
MFA-TR*         INTO                                                            
MFA-TR*            :WS-DEVICE-ATTCHED                                           
MFA-TR*         FROM                                                            
MFA-TR*             CSS_METER_ATTCHMTS                                          
MFA-TR*         WHERE                                                           
MFA-TR*             METER_NO         = :MA-METER-NO                             
MFA-TR*         AND DEVICE_NO        = :MA-DEVICE-NO                            
MFA-TR*         AND CODE_ATT_TYPE    = :MA-CODE-ATT-TYPE                        
MFA-TR*         AND COMPANY_NO       = :MA-COMPANY-NO                           
MFA-TR*         AND CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7074                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                    
               MOVE 'METER_NO'            TO TABLE-ELEMENT-1            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-2            
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-3            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4            
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-1          
               MOVE MA-DEVICE-NO          TO HOSTVAR-ELEMENT-2          
               MOVE MA-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-3          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7074-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7078-GET-COUNT-ATT-TYP-TO-MTR                                  *        
      ******************************************************************        
      *                                                                         
        7078-GET-COUNT-ATT-TYP-TO-MTR.                                  
      *                                                                         
            MOVE '7078'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                   COUNT(1)                                             
                INTO                                                    
                   :WS-ATTCH-COUNT                                      
                FROM                                                    
                    CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    METER_NO         = :MA-METER-NO                     
                AND CODE_ATT_TYPE    = :MA-CODE-ATT-TYPE                
                AND COMPANY_NO       = :MA-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE               
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            COUNT(1)                                                     
MFA-TR*         INTO                                                            
MFA-TR*            :WS-ATTCH-COUNT                                              
MFA-TR*         FROM                                                            
MFA-TR*             CSS_METER_ATTCHMTS                                          
MFA-TR*         WHERE                                                           
MFA-TR*             METER_NO         = :MA-METER-NO                             
MFA-TR*         AND CODE_ATT_TYPE    = :MA-CODE-ATT-TYPE                        
MFA-TR*         AND COMPANY_NO       = :MA-COMPANY-NO                           
MFA-TR*         AND CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7078                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE ZERO               TO WS-ATTCH-COUNT             
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                    
               MOVE 'METER_NO'            TO TABLE-ELEMENT-1            
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-2            
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4            
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-2          
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-3          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7078-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7080-CHECK-METER-MOVEMNT-HIST.                                 *        
      ******************************************************************        
      *                                                                         
       7080-CHECK-METER-MOVEMNT-HIST.                                   
      *                                                                         
            MOVE '7080'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                   'Y'                                                  
                INTO                                                    
                   :WS-METER-MOVEMNT-EXISTS                             
                FROM                                                    
                    CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                     
                WHERE                                                   
                    COMPANY_NO       = :MV-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE               
                AND DEVICE_NO        = :MV-DEVICE-NO                    
                AND CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE             
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            'Y'                                                          
MFA-TR*         INTO                                                            
MFA-TR*            :WS-METER-MOVEMNT-EXISTS                                     
MFA-TR*         FROM                                                            
MFA-TR*             CSS_MOVEMENT_HIST                                           
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO       = :MV-COMPANY-NO                           
MFA-TR*         AND CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE                       
MFA-TR*         AND DEVICE_NO        = :MV-DEVICE-NO                            
MFA-TR*         AND CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7080                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MOVEMENT_HIST'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE 'CODE_DEVICE_TYPE'    TO TABLE-ELEMENT-4            
               MOVE MV-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MV-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MV-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               MOVE MV-CODE-DEVICE-TYPE   TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7090-CHECK-EQUIP-ATTCH-EXISTS                                  *        
      ******************************************************************        
      *                                                                         
       7090-CHECK-EQUIP-ATTCH-EXISTS.                                   
      *                                                                         
            MOVE '7090'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                   'Y'                                                  
                INTO                                                    
                   :WS-EQUIP-ATTACH-EXISTS                              
                FROM                                                    
                    CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    DEVICE_NO        = :LX-DEVICE-NO                    
                AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                
                AND COMPANY_NO       = :LX-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE               
                AND EQUIP_LOC_ID     IN ('A', 'B', 'C')                 
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            'Y'                                                          
MFA-TR*         INTO                                                            
MFA-TR*            :WS-EQUIP-ATTACH-EXISTS                                      
MFA-TR*         FROM                                                            
MFA-TR*             CSS_EQUIP_ATTCHMTS                                          
MFA-TR*         WHERE                                                           
MFA-TR*             DEVICE_NO        = :LX-DEVICE-NO                            
MFA-TR*         AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                        
MFA-TR*         AND COMPANY_NO       = :LX-COMPANY-NO                           
MFA-TR*         AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE                       
MFA-TR*         AND EQUIP_LOC_ID     IN ('A', 'B', 'C')                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7090                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                    
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1            
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-2            
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4            
               MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-1          
               MOVE LX-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-2          
               MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-3          
               MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7090-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7100-GET-REMOTE-READ-CODE                                      *        
      ******************************************************************        
      *                                                                         
       7100-GET-REMOTE-READ-CODE.                                       
      *                                                                         
            MOVE '7100'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) U5.REMOTE_READ_CODE                               
                INTO                                                    
                   :U5-REMOTE-READ-CODE                                 
                FROM                                                    
                    CSS_ELEC_METER    EM WITH(READUNCOMMITTED)                  
                   ,CSS_ELEC_MTR_SPEC U5 WITH(READUNCOMMITTED)                  
                WHERE                                                   
                    EM.COMPANY_NO       = :EM-COMPANY-NO                
                AND EM.CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE            
                AND EM.METER_NO         = :EM-METER-NO                  
                AND EM.ELEC_MTR_SPEC_CD = U5.ELEC_MTR_SPEC_CD           
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            U5.REMOTE_READ_CODE                                          
MFA-TR*         INTO                                                            
MFA-TR*            :U5-REMOTE-READ-CODE                                         
MFA-TR*         FROM                                                            
MFA-TR*             CSS_ELEC_METER    EM                                        
MFA-TR*            ,CSS_ELEC_MTR_SPEC U5                                        
MFA-TR*         WHERE                                                           
MFA-TR*             EM.COMPANY_NO       = :EM-COMPANY-NO                        
MFA-TR*         AND EM.CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE                    
MFA-TR*         AND EM.METER_NO         = :EM-METER-NO                          
MFA-TR*         AND EM.ELEC_MTR_SPEC_CD = U5.ELEC_MTR_SPEC_CD                   
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES             TO U5-REMOTE-READ-CODE        
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ELEC_METER'      TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE EM-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EM-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EM-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7110-GET-EQUIP-ATTCH-DETAILS                                   *        
      ******************************************************************        
      *                                                                         
       7110-GET-EQUIP-ATTCH-DETAILS.                                    
      *                                                                         
            MOVE '7110'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                   DATE_LAST_MOVE                                       
                  ,CODE_ATT_TYPE                                        
                  ,EQUIP_LOC_ID                                         
                  ,MTR_STORAGE_FAC_CD                                   
                  ,DATE_PURCHASED                                       
                INTO                                                    
                   :LX-DATE-LAST-MOVE :WS-LX-DT-LST-MOVE-NULL-IND        
                  ,:LX-CODE-ATT-TYPE                                    
                  ,:LX-EQUIP-LOC-ID                                     
                  ,:LX-MTR-STORAGE-FAC-CD                               
                  ,:LX-DATE-PURCHASED :WS-LX-DT-PURCHASE-NULL-IND        
                FROM                                                    
                    CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                    
                WHERE                                                   
                    DEVICE_NO        = :LX-DEVICE-NO                    
                AND COMPANY_NO       = :LX-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE               
                AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*            DATE_LAST_MOVE                                               
MFA-TR*           ,CODE_ATT_TYPE                                                
MFA-TR*           ,EQUIP_LOC_ID                                                 
MFA-TR*           ,MTR_STORAGE_FAC_CD                                           
MFA-TR*           ,DATE_PURCHASED                                               
MFA-TR*         INTO                                                            
MFA-TR*            :LX-DATE-LAST-MOVE:WS-LX-DT-LST-MOVE-NULL-IND                
MFA-TR*           ,:LX-CODE-ATT-TYPE                                            
MFA-TR*           ,:LX-EQUIP-LOC-ID                                             
MFA-TR*           ,:LX-MTR-STORAGE-FAC-CD                                       
MFA-TR*           ,:LX-DATE-PURCHASED:WS-LX-DT-PURCHASE-NULL-IND                
MFA-TR*         FROM                                                            
MFA-TR*             CSS_EQUIP_ATTCHMTS                                          
MFA-TR*         WHERE                                                           
MFA-TR*             DEVICE_NO        = :LX-DEVICE-NO                            
MFA-TR*         AND COMPANY_NO       = :LX-COMPANY-NO                           
MFA-TR*         AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE                       
MFA-TR*         AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                    
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1            
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3            
               MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-1          
               MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-2          
               MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
      *                                                                         
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7120-GET-ACCOUNT-DETAILS.                                      *        
      ******************************************************************        
      *                                                                         
       7120-GET-ACCOUNT-DETAILS.                                        
      *                                                                         
            MOVE '7120'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) CH.ACCOUNT_NO,
              AT.CUSTOMER_NO,
              AT.LOCAL_OFFICE                                     
                INTO                                                    
                    :CH-ACCOUNT-NO                                      
                   ,:CH-CUSTOMER-NO                                     
                   ,:AT-LOCAL-OFFICE                                    
                FROM                                                    
                    CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                 
                   ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                 
                WHERE                                                   
                    CH.ACCOUNT_NO    = AT.ACCOUNT_NO                    
                AND CH.PREMISE_NO    = :CH-PREMISE-NO                   
                ORDER BY CH.DATE_UTIL_SVC_STRT DESC                     
                                             
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*             CH.ACCOUNT_NO                                               
MFA-TR*            ,AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.LOCAL_OFFICE                                             
MFA-TR*         INTO                                                            
MFA-TR*             :CH-ACCOUNT-NO                                              
MFA-TR*            ,:CH-CUSTOMER-NO                                             
MFA-TR*            ,:AT-LOCAL-OFFICE                                            
MFA-TR*         FROM                                                            
MFA-TR*             CSS_CUST_PREM_HIST CH                                       
MFA-TR*            ,CSS_ACCOUNT        AT                                       
MFA-TR*         WHERE                                                           
MFA-TR*             CH.ACCOUNT_NO    = AT.ACCOUNT_NO                            
MFA-TR*         AND CH.PREMISE_NO    = :CH-PREMISE-NO                           
MFA-TR*         ORDER BY CH.DATE_UTIL_SVC_STRT DESC                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE ZERO               TO CH-ACCOUNT-NO              
                                             CH-CUSTOMER-NO             
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-1                    
               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1            
               MOVE CH-PREMISE-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7130-GET-RESP-AREA-ID.                                         *        
      ******************************************************************        
      *                                                                         
       7130-GET-RESP-AREA-ID.                                           
      *                                                                         
            MOVE '7130'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) C1.RESP_AREA_ID                                   
                INTO                                                    
                    :C1-RESP-AREA-ID                                    
                FROM                                                    
                    CSS_RESP_AREA C1 WITH(READUNCOMMITTED)                      
                WHERE                                                   
                    C1.USER_ID  = :C1-USER-ID                           
                                             
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*             C1.RESP_AREA_ID                                             
MFA-TR*         INTO                                                            
MFA-TR*             :C1-RESP-AREA-ID                                            
MFA-TR*         FROM                                                            
MFA-TR*             CSS_RESP_AREA C1                                            
MFA-TR*         WHERE                                                           
MFA-TR*             C1.USER_ID  = :C1-USER-ID                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7130                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACES             TO C1-RESP-AREA-ID            
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_RESP_AREA'       TO TABLE-1                    
               MOVE 'USER_ID'             TO TABLE-ELEMENT-1            
               MOVE C1-USER-ID            TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7140-OPEN-CODE-ATTCH-CUR                                       *        
      ******************************************************************        
      *                                                                         
       7140-OPEN-CODE-ATTCH-CUR.                                        
      *                                                                         
            MOVE '7140'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN CSS_CODE_ATTCH_CUR                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CSS_CODE_ATTCH_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7144-FETCH-CODE-ATTCH-CUR.                                     *        
      ******************************************************************        
      *                                                                         
       7144-FETCH-CODE-ATTCH-CUR.                                       
      *                                                                         
            MOVE '7144'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                   CSS_CODE_ATTCH_CUR                                   
                INTO                                                    
                   :MA-CODE-ATT-TYPE                                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'CSS_CODE_ATTCH_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7144-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7148-CLOSE-CODE-ATTCH-CUR.                                     *        
      ******************************************************************        
      *                                                                         
       7148-CLOSE-CODE-ATTCH-CUR.                                       
      *                                                                         
            MOVE '7148'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                CLOSE CSS_CODE_ATTCH_CUR                                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CSS_CODE_ATTCH_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7148-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7150-OPEN-MTR-CAP-CNST-CUR                                     *        
      ******************************************************************        
      *                                                                         
       7150-OPEN-MTR-CAP-CNST-CUR.                                      
      *                                                                         
            MOVE '7150'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN CSS_MTR_CAP_CNST_CUR                               
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP_CNST_CUR' TO TABLE-1                   
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7150-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 7154-FETCH-MTR-CAP-CNST-CUR                                   *         
      *****************************************************************         
      *                                                                         
       7154-FETCH-MTR-CAP-CNST-CUR.                                     
      *                                                                         
            MOVE '7154'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                   CSS_MTR_CAP_CNST_CUR                                 
                INTO                                                    
                   :MC-CONSTANT                                         
                  ,:MA-CODE-ATT-TYPE                                    
                  ,:EM-METER-NO                                         
                  ,:MA-CT-PT-RATIO                                      
                  ,:MA-DEVICE-NO                                        
                  ,:IX-RTO-UPPER-FRACTION                               
                  ,:IX-RTO-LOWER-FRACTION                               
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP_CNST_CUR' TO TABLE-1                   
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7154-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 7158-CLOSE-MTR-CAP-CNST-CUR                                   *         
      *****************************************************************         
      *                                                                         
       7158-CLOSE-MTR-CAP-CNST-CUR.                                     
      *                                                                         
            MOVE '7158'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                CLOSE CSS_MTR_CAP_CNST_CUR                              
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP_CNST_CUR' TO TABLE-1                   
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7158-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7160-GET-CURRENT-TIMESTAMP                                     *        
      ******************************************************************        
      *                                                                         
       7160-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
            MOVE '7160'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*            ,:WS-CURRENT-DATE      = CURRENT DATE                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'SYSDUMMY1'           TO TABLE-1                    
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7160-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7180-GET-TRANSHIST-SEQ-NO                                      *        
      ******************************************************************        
      *                                                                         
       7180-GET-TRANSHIST-SEQ-NO.                                       
      *                                                                         
            MOVE '7180'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRANSHIST-SEQ-NO            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET :WS-TRANSHIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'SYSDUMMY1'           TO TABLE-1                    
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7180-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7190-OPEN-MTR-ATTCH-DEL                                        *        
      ******************************************************************        
      *                                                                         
       7190-OPEN-MTR-ATTCH-DEL.                                         
      *                                                                         
            MOVE '7190'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN CSS_MTR_ATTCH_DEL                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_ATTCH_DEL'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7190-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7194-FETCH-MTR-ATTCH-DEL                                       *        
      ******************************************************************        
      *                                                                         
       7194-FETCH-MTR-ATTCH-DEL.                                        
      *                                                                         
            MOVE '7194'                   TO ACTIVE-PARAGRAPH.          
            MOVE ZERO                     TO WS-DATE-LST-TST-NULL.      
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                   CSS_MTR_ATTCH_DEL                                    
                INTO                                                    
                   :MA-CODE-UTIL-TYPE                                   
                  ,:MA-METER-NO                                         
                  ,:MA-CODE-DEVICE-TYPE                                 
                  ,:MA-DEVICE-NO                                        
                  ,:MA-CODE-ATT-TYPE                                    
                  ,:MA-DATE-LAST-TESTED :WS-DATE-LST-TST-NULL            
                  ,:MA-TEST-SCHED-CD                                    
                  ,:EQ-LOCAL-OFFICE                                     
                  ,:EQ-CODE-CRNT-LOC                                    
                  ,:MA-CT-PT-RATIO                                      
                  ,:MA-HOW-ATTACHED-CD                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-DATE-LST-TST-NULL = -1                             
                  MOVE SPACES             TO MA-DATE-LAST-TESTED        
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_ATTCH_DEL'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7194-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7198-CLOSE-MTR-ATTCH-DEL                                       *        
      ******************************************************************        
      *                                                                         
       7198-CLOSE-MTR-ATTCH-DEL.                                        
      *                                                                         
            MOVE '7198'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                CLOSE CSS_MTR_ATTCH_DEL                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_ATTCH_DEL'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7198-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00447******************************************************************        
P00447*7200-GET-CONSTANT-DEFAULT                                       *        
P00447******************************************************************        
P00447*                                                                         
P00447 7200-GET-CONSTANT-DEFAULT.                                       
P00447                                                                  
P00447      EXEC SQL                                                    
P00447           SELECT  CT_METER_FL                                    
P00447             INTO  :U0-CT-METER-FL                                
P00447           FROM   CSS_ELEC_METER   EM WITH(READUNCOMMITTED)               
P00447                 ,CSS_ELEC_CL_SPEC U0 WITH(READUNCOMMITTED)               
P00447           WHERE  EM.CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE      
P00447             AND  EM.COMPANY_NO         = :EM-COMPANY-NO          
P00447             AND  EM.METER_NO           = :EM-METER-NO            
P00447             AND  U0.ELEC_MTR_CLASS_CD  = EM.ELEC_MTR_CLASS_CD    
P00447             AND  U0.ELEC_MTR_SPEC_CD   = EM.ELEC_MTR_SPEC_CD     
P00447                                                           
P00447                                                      
P00447      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT  CT_METER_FL                                            
MFA-TR*            INTO  :U0-CT-METER-FL                                        
MFA-TR*          FROM   CSS_ELEC_METER   EM                                     
MFA-TR*                ,CSS_ELEC_CL_SPEC U0                                     
MFA-TR*          WHERE  EM.CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE              
MFA-TR*            AND  EM.COMPANY_NO         = :EM-COMPANY-NO                  
MFA-TR*            AND  EM.METER_NO           = :EM-METER-NO                    
MFA-TR*            AND  U0.ELEC_MTR_CLASS_CD  = EM.ELEC_MTR_CLASS_CD            
MFA-TR*            AND  U0.ELEC_MTR_SPEC_CD   = EM.ELEC_MTR_SPEC_CD             
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00447                                                                  
P00447      MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
P00447                                                                  
P00447      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
P00447         CONTINUE                                                 
P00447      ELSE                                                        
P00447         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00447         MOVE '7200'                  TO ACTIVE-PARAGRAPH         
P00447         MOVE 'SELECT'                TO ABEND-FUNCTION           
P00447         MOVE 'CSS_ELEC_CL_SPEC'      TO TABLE-1                  
P00447         MOVE 'ELEC-MTR-CLASS-CD'     TO TABLE-ELEMENT-1          
P00447         MOVE U0-ELEC-MTR-CLASS-CD    TO HOSTVAR-ELEMENT-1        
P00447         MOVE 'ELEC-MTR-SPEC-CD'      TO TABLE-ELEMENT-2          
P00447         MOVE U0-ELEC-MTR-SPEC-CD     TO HOSTVAR-ELEMENT-2        
P00447         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00447         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00447      END-IF.                                                     
P00447                                                                  
P00447 7200-EXIT.                                                       
P00447      EXIT.                                                       
      ******************************************************************        
      * 8000-INSERT-MOVEMNT-HIST                                       *        
      ******************************************************************        
      *                                                                         
       8000-INSERT-MOVEMNT-HIST.                                        
      *                                                                         
            MOVE '8000'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                INSERT INTO CSS_MOVEMENT_HIST                           
                (                                                       
                    CODE_UTIL_TYPE                                      
                   ,DEVICE_NO                                           
                   ,DATE_MOVE                                           
                   ,MOVE_NO                                             
                   ,CODE_DEVICE_TYPE                                    
                   ,COMPANY_NO                                          
                   ,LOCAL_OFFICE                                        
                   ,LOC_NO                                              
                   ,CODE_CRNT_LOC                                       
                )                                                       
                VALUES                                                  
                (                                                       
                    :MV-CODE-UTIL-TYPE                                  
                   ,:MV-DEVICE-NO                                       
                   ,IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                                
                   ,CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)                             
                   ,:MV-CODE-DEVICE-TYPE                                
                   ,:MV-COMPANY-NO                                      
                   ,:MV-LOCAL-OFFICE                                    
                   ,:MV-LOC-NO                                          
                   ,:MV-CODE-CRNT-LOC                                   
                )                                                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         INSERT INTO CSS_MOVEMENT_HIST                                   
MFA-TR*         (                                                               
MFA-TR*             CODE_UTIL_TYPE                                              
MFA-TR*            ,DEVICE_NO                                                   
MFA-TR*            ,DATE_MOVE                                                   
MFA-TR*            ,MOVE_NO                                                     
MFA-TR*            ,CODE_DEVICE_TYPE                                            
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,LOCAL_OFFICE                                                
MFA-TR*            ,LOC_NO                                                      
MFA-TR*            ,CODE_CRNT_LOC                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :MV-CODE-UTIL-TYPE                                          
MFA-TR*            ,:MV-DEVICE-NO                                               
MFA-TR*            ,:MV-DATE-MOVE                                               
MFA-TR*            ,:MV-MOVE-NO                                                 
MFA-TR*            ,:MV-CODE-DEVICE-TYPE                                        
MFA-TR*            ,:MV-COMPANY-NO                                              
MFA-TR*            ,:MV-LOCAL-OFFICE                                            
MFA-TR*            ,:MV-LOC-NO                                                  
MFA-TR*            ,:MV-CODE-CRNT-LOC                                           
MFA-TR*         )                                                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MOVEMENT_HIST'   TO TABLE-1                    
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-2            
               MOVE MV-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1          
               MOVE MV-DEVICE-NO          TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8020-DELETE-METER-ATTCHMTS                                     *        
      ******************************************************************        
      *                                                                         
       8020-DELETE-METER-ATTCHMTS.                                      
      *                                                                         
            MOVE '8020'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                DELETE FROM                                             
                    CSS_METER_ATTCHMTS                                  
                WHERE                                                   
                    COMPANY_NO     = :MA-COMPANY-NO                     
                AND CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                 
                AND METER_NO       = :MA-METER-NO                       
                AND DEVICE_NO      = :MA-DEVICE-NO                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-4            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE MA-DEVICE-NO          TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8040-INSERT-METER-ATTCHMTS                                     *        
      ******************************************************************        
      *                                                                         
       8040-INSERT-METER-ATTCHMTS.                                      
      *                                                                         
            MOVE '8040'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                INSERT INTO CSS_METER_ATTCHMTS                          
                (                                                       
                    CODE_UTIL_TYPE                                      
                   ,METER_NO                                            
                   ,CODE_DEVICE_TYPE                                    
                   ,DEVICE_NO                                           
                   ,CODE_ATT_TYPE                                       
                   ,CT_PT_RATIO                                         
                   ,COMPANY_NO                                          
                   ,DATE_LAST_TESTED                                    
                   ,TEST_SCHED_CD                                       
                   ,HOW_ATTACHED_CD                                     
                )                                                       
                VALUES                                                  
                (                                                       
                    :MA-CODE-UTIL-TYPE                                  
                   ,:MA-METER-NO                                        
                   ,:MA-CODE-DEVICE-TYPE                                
                   ,:MA-DEVICE-NO                                       
                   ,:MA-CODE-ATT-TYPE                                   
                   ,:MA-CT-PT-RATIO                                     
                   ,:MA-COMPANY-NO                                      
                   ,IIF(TRY_CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                          :WS-DATE-LST-TST-NULL
              ) IS NULL OR (PATINDEX('%.%', :MA-DATE-LAST-TESTED 
                                                  :WS-DATE-LST-TST-NULL
              ) <> 0) OR (LEN(:MA-DATE-LAST-TESTED 
                                                  :WS-DATE-LST-TST-NULL
              ) <> 10), CIS.CHAR2DATE(:MA-DATE-LAST-TESTED 
                                                  :WS-DATE-LST-TST-NULL
              ), CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                                  :WS-DATE-LST-TST-NULL
              ) )           
                   ,:MA-TEST-SCHED-CD                                   
                   ,:MA-HOW-ATTACHED-CD                                 
                )                                                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         INSERT INTO CSS_METER_ATTCHMTS                                  
MFA-TR*         (                                                               
MFA-TR*             CODE_UTIL_TYPE                                              
MFA-TR*            ,METER_NO                                                    
MFA-TR*            ,CODE_DEVICE_TYPE                                            
MFA-TR*            ,DEVICE_NO                                                   
MFA-TR*            ,CODE_ATT_TYPE                                               
MFA-TR*            ,CT_PT_RATIO                                                 
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,DATE_LAST_TESTED                                            
MFA-TR*            ,TEST_SCHED_CD                                               
MFA-TR*            ,HOW_ATTACHED_CD                                             
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :MA-CODE-UTIL-TYPE                                          
MFA-TR*            ,:MA-METER-NO                                                
MFA-TR*            ,:MA-CODE-DEVICE-TYPE                                        
MFA-TR*            ,:MA-DEVICE-NO                                               
MFA-TR*            ,:MA-CODE-ATT-TYPE                                           
MFA-TR*            ,:MA-CT-PT-RATIO                                             
MFA-TR*            ,:MA-COMPANY-NO                                              
MFA-TR*            ,:MA-DATE-LAST-TESTED:WS-DATE-LST-TST-NULL                   
MFA-TR*            ,:MA-TEST-SCHED-CD                                           
MFA-TR*            ,:MA-HOW-ATTACHED-CD                                         
MFA-TR*         )                                                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-4            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE MA-DEVICE-NO          TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * H050-INSERT-EQUIP-ATT-MOVE                                     *        
      ******************************************************************        
      *                                                                         
       8050-INSERT-EQUIP-ATT-MOVE.                                      
      *                                                                         
            MOVE '8050'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                INSERT INTO CSS_EQUIP_ATT_MOVE                          
                (                                                       
                    DEVICE_NO                                           
                   ,CODE_ATT_TYPE                                       
                   ,COMPANY_NO                                          
                   ,CODE_UTIL_TYPE                                      
                   ,DATE_MOVE                                           
                   ,MOVE_NO                                             
                   ,MTR_STORAGE_FAC_CD                                  
                   ,METER_NO                                            
                   ,EQUIP_LOC_ID                                        
                )                                                       
                VALUES                                                  
                (                                                       
                    :MP-DEVICE-NO                                       
                   ,:MP-CODE-ATT-TYPE                                   
                   ,:MP-COMPANY-NO                                      
                   ,:MP-CODE-UTIL-TYPE                                  
                   ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE 
                                          :WS-DT-LST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE 
                                                   :WS-DT-LST-MOVE-NULL
              ) <> 0) OR (LEN(:MP-DATE-MOVE :WS-DT-LST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:MP-DATE-MOVE 
                                                   :WS-DT-LST-MOVE-NULL
              ), CONVERT(DATE, :MP-DATE-MOVE :WS-DT-LST-MOVE-NULL) )           
                   ,CIS.CHAR2TIMESTAMP(:MP-MOVE-NO)                             
                   ,:MP-MTR-STORAGE-FAC-CD                              
                   ,:MP-METER-NO                                        
                   ,:MP-EQUIP-LOC-ID                                    
                )                                                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         INSERT INTO CSS_EQUIP_ATT_MOVE                                  
MFA-TR*         (                                                               
MFA-TR*             DEVICE_NO                                                   
MFA-TR*            ,CODE_ATT_TYPE                                               
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,DATE_MOVE                                                   
MFA-TR*            ,MOVE_NO                                                     
MFA-TR*            ,MTR_STORAGE_FAC_CD                                          
MFA-TR*            ,METER_NO                                                    
MFA-TR*            ,EQUIP_LOC_ID                                                
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :MP-DEVICE-NO                                               
MFA-TR*            ,:MP-CODE-ATT-TYPE                                           
MFA-TR*            ,:MP-COMPANY-NO                                              
MFA-TR*            ,:MP-CODE-UTIL-TYPE                                          
MFA-TR*            ,:MP-DATE-MOVE:WS-DT-LST-MOVE-NULL                           
MFA-TR*            ,:MP-MOVE-NO                                                 
MFA-TR*            ,:MP-MTR-STORAGE-FAC-CD                                      
MFA-TR*            ,:MP-METER-NO                                                
MFA-TR*            ,:MP-EQUIP-LOC-ID                                            
MFA-TR*         )                                                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIP_ATT_MOVE'  TO TABLE-1                    
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1            
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-2            
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4            
               MOVE MP-DEVICE-NO          TO HOSTVAR-ELEMENT-1          
               MOVE MP-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-2          
               MOVE MP-COMPANY-NO         TO HOSTVAR-ELEMENT-3          
               MOVE MP-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8050-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8060-UPDATE-ELEC-METER                                         *        
      ******************************************************************        
      *                                                                         
       8060-UPDATE-ELEC-METER.                                          
      *                                                                         
            MOVE '8060'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                    CSS_ELEC_METER                                      
                SET                                                     
                    CODE_ATTACHMENTS  = :EM-CODE-ATTACHMENTS            
                   ,TEST_SCHED_CD     = :EM-TEST-SCHED-CD               
                   ,OVERRIDE_CONST_FL = :EM-OVERRIDE-CONST-FL           
                WHERE                                                   
                    COMPANY_NO     = :EM-COMPANY-NO                     
                AND CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                 
                AND METER_NO       = :EM-METER-NO                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_ELEC_METER'      TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE EM-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EM-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EM-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8080-DELETE-METER-CAP-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8080-DELETE-METER-CAP-DETAILS.                                   
      *                                                                         
            MOVE '8080'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                DELETE FROM                                             
                    CSS_MTR_CAP                                         
                WHERE                                                   
                    COMPANY_NO     = :MC-COMPANY-NO                     
                AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                 
                AND METER_NO       = :MC-METER-NO                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8120-UPDATE-EQUIP-LST-TRAN-DT                                  *        
      ******************************************************************        
      *                                                                         
       8120-UPDATE-EQUIP-LST-TRAN-DT.                                   
      *                                                                         
            MOVE '8120'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                    CSS_EQUIPMENT                                       
                SET                                                     
                    DATE_LAST_TRAN     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                WHERE                                                   
                    COMPANY_NO         = :EQ-COMPANY-NO                 
                AND CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE             
                AND DEVICE_NO          = :EQ-DEVICE-NO                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE                                                          
MFA-TR*             CSS_EQUIPMENT                                               
MFA-TR*         SET                                                             
MFA-TR*             DATE_LAST_TRAN     = CURRENT_DATE                           
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO         = :EQ-COMPANY-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE                     
MFA-TR*         AND DEVICE_NO          = :EQ-DEVICE-NO                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8120-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 8130-UPDATE-EQUIP-CRNT-LOC                                     *        
      ******************************************************************        
      *                                                                         
       8130-UPDATE-EQUIP-CRNT-LOC.                                      
      *                                                                         
            MOVE '8130'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                    CSS_EQUIPMENT                                       
                SET                                                     
                    DATE_LAST_MOVE     = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                   ,CRNT_LOC_NO        = :EQ-CRNT-LOC-NO                
                   ,CODE_CRNT_LOC      = :EQ-CODE-CRNT-LOC              
                WHERE                                                   
                    COMPANY_NO         = :EQ-COMPANY-NO                 
                AND CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE             
                AND DEVICE_NO          = :EQ-DEVICE-NO                  
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE                                                          
MFA-TR*             CSS_EQUIPMENT                                               
MFA-TR*         SET                                                             
MFA-TR*             DATE_LAST_MOVE     = CURRENT_DATE                           
MFA-TR*            ,CRNT_LOC_NO        = :EQ-CRNT-LOC-NO                        
MFA-TR*            ,CODE_CRNT_LOC      = :EQ-CODE-CRNT-LOC                      
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO         = :EQ-COMPANY-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE                     
MFA-TR*         AND DEVICE_NO          = :EQ-DEVICE-NO                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8130-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8160-UPDATE-MTR-CAP-CONSTANT                                   *        
      ******************************************************************        
      *                                                                         
       8160-UPDATE-MTR-CAP-CONSTANT.                                    
                                                                        
            MOVE '8160'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                    CSS_MTR_CAP                                         
                SET                                                     
                    CONSTANT           = :MC-CONSTANT                   
                WHERE                                                   
                    COMPANY_NO         = :MC-COMPANY-NO                 
                AND CODE_UTIL_TYPE     = :MC-CODE-UTIL-TYPE             
                AND METER_NO           = :MC-METER-NO                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8160-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8170-UPDATE-EQUIP-ATTCH-DTLS                                   *        
      ******************************************************************        
      *                                                                         
       8170-UPDATE-EQUIP-ATTCH-DTLS.                                    
      *                                                                         
            MOVE '8170'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                    CSS_EQUIP_ATTCHMTS                                  
                SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID               
                   ,DATE_LAST_MOVE     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE) )             
                   ,DATE_LAST_TRAN     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN) )             
                   ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD         
A00631             ,EQUIP_ATTACH_DT    = IIF(TRY_CONVERT(DATE, 
                                                   :LX-EQUIP-ATTACH-DT 
                                               :WS-EQUIP-ATTACH-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT 
                                               :WS-EQUIP-ATTACH-DT-NULL
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT 
                                               :WS-EQUIP-ATTACH-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT 
                                               :WS-EQUIP-ATTACH-DT-NULL
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                               :WS-EQUIP-ATTACH-DT-NULL
              ) )       
                WHERE                                                   
                    COMPANY_NO         = :LX-COMPANY-NO                 
                AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE             
                AND DEVICE_NO          = :LX-DEVICE-NO                  
                AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE              
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE                                                          
MFA-TR*             CSS_EQUIP_ATTCHMTS                                          
MFA-TR*         SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                       
MFA-TR*            ,DATE_LAST_MOVE     = :LX-DATE-LAST-MOVE                     
MFA-TR*            ,DATE_LAST_TRAN     = :LX-DATE-LAST-TRAN                     
MFA-TR*            ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD                 
MFA-TR*            ,EQUIP_ATTACH_DT    = :LX-EQUIP-ATTACH-DT            16420000
MFA-TR*                                  :WS-EQUIP-ATTACH-DT-NULL       16420000
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO         = :LX-COMPANY-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE                     
MFA-TR*         AND DEVICE_NO          = :LX-DEVICE-NO                          
MFA-TR*         AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-4            
               MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               MOVE LX-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8170-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
