       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04227.                                         
COB303 DATE-WRITTEN.  FEB 09 2009.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR GAS TRANSFER   *        
      *  AND MOVEMENT SCREENS                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/09/09  SJ94244    PROCEDURE ORIGINALLY CODED.              *        
C14744*  05/26/10  SB40505    ADDED INTRANSIT EMPLOYEE ID FOR BAR CODE *        
      *                                                                         
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04227'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                     PIC X(40) VALUE                  
          'WORKING STORAGE FOR CSR04227 STARTS HERE'.                   
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01 WS-COUNTER-FIELDS.                                            
          05 CTR-ROWS                  PIC S9(9) COMP VALUE 1.          
                                                                        
       01 WS-DATE-TIMESTAMP.                                            
          05 WS-CURRENT-DATE           PIC X(10) VALUE SPACES.          
          05 WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.          
          05 WS-DATE-MOVE              PIC X(10) VALUE SPACES.          
                                                                        
       01 WS-CONSTANTS.                                                 
          05 WS-LOCATION-RETIRE        PIC X(01) VALUE 'I'.             
          05 WS-LOCATION-EMPLOYEE      PIC X(01) VALUE 'C'.             
          05 WS-DEVICE-TYPE-METER      PIC X(01) VALUE 'M'.             
                                                                        
       01 WS-NULL-IND.                                                  
          05 WS-EQ-DATE-DIS-OF-NULL    PIC S9(04) COMP VALUE 0.         
          05 WS-EQ-DATE-DIS-OF-NUL-TMP PIC S9(04) COMP VALUE 0.         
          05 WS-LX-DATE-LAST-MOVE-NULL PIC S9(04) COMP VALUE 0.         
          05 WS-LX-DATE-LAST-TRAN-NULL PIC S9(04) COMP VALUE 0.         
          05 WS-EQ-DATE-LAST-MOVE-NULL PIC S9(04) COMP VALUE 0.         
          05 WS-EQ-DATE-LAST-TRAN-NULL PIC S9(04) COMP VALUE 0.         
          05 WS-LX-MTR-STORAGE-NULL    PIC S9(04) COMP VALUE 0.         
                                                                        
       01 WS-INPUT-MISC.                                                
          05 PROGRAM-NAME              PIC X(08) VALUE 'CSR04227'.      
          05 WS-IN-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.          
          05 WS-IN-COMPANY-NO          PIC X(02) VALUE SPACES.          
          05 WS-IN-DEVICE-NO           PIC X(09) VALUE SPACES.          
          05 WS-IN-SERIAL-NO           PIC X(11) VALUE SPACES.          
          05 WS-IN-MOVE-DATE           PIC X(10) VALUE SPACES.          
          05 WS-IN-EQUIP-LOC-ID        PIC X(01) VALUE SPACES.          
          05 WS-IN-MSF-CD              PIC X(03) VALUE SPACES.          
          05 WS-IN-COMMENTS            PIC X(255) VALUE SPACES.         
          05 WS-DATE-DISPSD-OF-TMP     PIC X(10) VALUE SPACES.          
C14744    05 WS-IN-TRANSIT-EMP-ID      PIC X(07) VALUE SPACES.          
                                                                        
      ******************** THIS IS THE ROW RETURN AREA ****************         
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01) VALUE 'Y'.             
             88 SEND-DONE-ERROR                  VALUE 'N'.             
             88 SEND-DONE-OK                     VALUE 'Y'.             
                                                                        
          05 WS-CALL-TYPE-SW           PIC X(01) VALUE SPACES.          
             88 WS-MOVEMENT-M                    VALUE 'M'.             
             88 WS-TRANSFER-T                    VALUE 'T'.             
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIPMENT - EQ                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATTCHMTS - LX                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQATTH                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATT_MOVE - MP                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQMOVE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS - MA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MOVEMENT_HIST - MV                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    MTR_ATTCH CURSOR FOR SELECTING THE ATTACHED CODE,         *          
      *    DEVICE NUMBER AND CODE ATT TYPE                           *          
      ****************************************************************          
                                                                        
           EXEC SQL                                                     
              DECLARE CSS_MTR_ATTCH_CUR CURSOR FOR                      
              SELECT MA.HOW_ATTACHED_CD                                 
                    ,MA.DEVICE_NO                                       
                    ,MA.CODE_ATT_TYPE                                   
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                    ,CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                
               WHERE MA.DEVICE_NO        = LX.DEVICE_NO                 
                 AND MA.COMPANY_NO       = LX.COMPANY_NO                
                 AND MA.CODE_UTIL_TYPE   = LX.CODE_UTIL_TYPE            
                 AND MA.CODE_ATT_TYPE    = LX.CODE_ATT_TYPE             
                 AND MA.METER_NO         = :MA-METER-NO                 
                 AND MA.COMPANY_NO       = :MA-COMPANY-NO               
                 AND MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CSS_MTR_ATTCH_CUR CURSOR FOR                              
MFA-TR*       SELECT MA.HOW_ATTACHED_CD                                         
MFA-TR*             ,MA.DEVICE_NO                                               
MFA-TR*             ,MA.CODE_ATT_TYPE                                           
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                                      
MFA-TR*             ,CSS_EQUIP_ATTCHMTS LX                                      
MFA-TR*        WHERE MA.DEVICE_NO        = LX.DEVICE_NO                         
MFA-TR*          AND MA.COMPANY_NO       = LX.COMPANY_NO                        
MFA-TR*          AND MA.CODE_UTIL_TYPE   = LX.CODE_UTIL_TYPE                    
MFA-TR*          AND MA.CODE_ATT_TYPE    = LX.CODE_ATT_TYPE                     
MFA-TR*          AND MA.METER_NO         = :MA-METER-NO                         
MFA-TR*          AND MA.COMPANY_NO       = :MA-COMPANY-NO                       
MFA-TR*          AND MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                   
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-CALL-TYPE                PIC X(01).                      
       01 PARM-CODE-UTIL-TYPE           PIC X(01).                      
       01 PARM-COMPANY-NO               PIC X(02).                      
       01 PARM-DEVICE-NO                PIC X(09).                      
       01 PARM-SERIAL-NO                PIC X(11).                      
       01 PARM-MOVE-DATE                PIC X(10).                      
       01 PARM-EQUIP-LOC-ID             PIC X(01).                      
       01 PARM-MSF-CD                   PIC X(03).                      
       01 PARM-COMMENTS                 PIC X(255).                     
C14744 01 PARM-IN-TRANSIT-EMP-ID        PIC X(07).                      
      *                                                                         
                                                                        
       PROCEDURE DIVISION USING  PARM-CALL-TYPE                         
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-COMPANY-NO                        
                                 PARM-DEVICE-NO                         
                                 PARM-SERIAL-NO                         
                                 PARM-MOVE-DATE                         
                                 PARM-EQUIP-LOC-ID                      
                                 PARM-MSF-CD                            
                                 PARM-COMMENTS                          
C14744                           PARM-IN-TRANSIT-EMP-ID.                
                                                                        
      ******************************************************************        
      *0000-MAINLINE                                                   *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE                                                 *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE     AS RETURN_CODE                      
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          :S-RETURN-CODE     AS RETURN_CODE                              
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
           PERFORM 7000-SELECT-CURR-DATE-AND-TIME THRU 7000-EXIT.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *1000-PROCESS-INPUT                                              *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS  THRU 1200-EXIT.       
           MOVE PARM-CALL-TYPE        TO WS-CALL-TYPE-SW.               
           MOVE PARM-CODE-UTIL-TYPE   TO WS-IN-CODE-UTIL-TYPE.          
           MOVE PARM-COMPANY-NO       TO WS-IN-COMPANY-NO.              
           MOVE PARM-DEVICE-NO        TO WS-IN-DEVICE-NO.               
           MOVE PARM-SERIAL-NO        TO WS-IN-SERIAL-NO.               
           MOVE PARM-MOVE-DATE        TO WS-IN-MOVE-DATE.               
           MOVE PARM-EQUIP-LOC-ID     TO WS-IN-EQUIP-LOC-ID.            
           MOVE PARM-MSF-CD           TO WS-IN-MSF-CD.                  
           MOVE PARM-COMMENTS         TO WS-IN-COMMENTS.                
C14744     MOVE PARM-IN-TRANSIT-EMP-ID TO WS-IN-TRANSIT-EMP-ID.         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-CODE-UTIL-TYPE NOT = 'G'           OR                
              PARM-COMPANY-NO         = SPACES        OR                
              PARM-CALL-TYPE      NOT = ('M' AND 'T') OR                
              PARM-DEVICE-NO          = SPACES                          
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-2          
              MOVE 'PARM-CALL-TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'PARM-DEVICE-NO'         TO TABLE-ELEMENT-4          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-2        
              MOVE PARM-CALL-TYPE           TO HOSTVAR-ELEMENT-3        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000-PROCESS-OUTPUT                                             *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2050-PROCESS-MVMNT-HST-INST  THRU 2050-EXIT.         
                                                                        
           IF WS-IN-COMMENTS > SPACES                                   
            MOVE LENGTH OF WS-IN-COMMENTS TO EQ-EQUIP-COMMENTS-TX-LEN   
            MOVE WS-IN-COMMENTS TO EQ-EQUIP-COMMENTS-TX-TEXT            
           END-IF                                                       
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-MOVEMENT-M                                        
                 PERFORM 2100-METER-MOVEMENT    THRU 2100-EXIT          
                                                                        
              WHEN WS-TRANSFER-T                                        
                 PERFORM 2200-METER-TRANSFER    THRU 2200-EXIT          
                                                                        
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2050-PROCESS-MVMNT-HST-INST.                                    *        
      ******************************************************************        
       2050-PROCESS-MVMNT-HST-INST.                                     
                                                                        
           MOVE WS-IN-DEVICE-NO           TO EQ-DEVICE-NO               
                                             MV-DEVICE-NO               
                                             MA-METER-NO.               
           MOVE WS-IN-COMPANY-NO          TO EQ-COMPANY-NO              
                                             MV-COMPANY-NO              
                                             MA-COMPANY-NO.             
           MOVE WS-IN-CODE-UTIL-TYPE      TO EQ-CODE-UTIL-TYPE          
                                             MV-CODE-UTIL-TYPE          
                                             MA-CODE-UTIL-TYPE.         
                                                                        
           PERFORM 7310-SELECT-EQUIPMENT     THRU 7310-EXIT.            
                                                                        
           MOVE EQ-DATE-DISPOSED-OF       TO WS-DATE-DISPSD-OF-TMP      
                                                                        
           IF WS-EQ-DATE-LAST-MOVE-NULL = -1                            
              MOVE '1900-01-01'           TO MV-DATE-MOVE               
           ELSE                                                         
              MOVE EQ-DATE-LAST-MOVE      TO MV-DATE-MOVE               
           END-IF                                                       
                                                                        
           MOVE WS-DEVICE-TYPE-METER      TO MV-CODE-DEVICE-TYPE        
                                             EQ-EQUIP-TYPE-CD.          
           MOVE EQ-LOCAL-OFFICE           TO MV-LOCAL-OFFICE.           
           MOVE EQ-CRNT-LOC-NO            TO MV-LOC-NO.                 
           MOVE WS-CURRENT-TIMESTAMP      TO MV-MOVE-NO.                
           MOVE EQ-CODE-CRNT-LOC          TO MV-CODE-CRNT-LOC.          
C14744     MOVE EQ-IN-TRANSIT-EMP-ID      TO MV-IN-TRANSIT-EMP-ID.      
                                                                        
           PERFORM 8410-INSERT-MOVEMENT-HIST THRU 8410-EXIT.            
                                                                        
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2100-METER-MOVEMENT                                             *        
      ******************************************************************        
       2100-METER-MOVEMENT.                                             
                                                                        
           MOVE WS-IN-MOVE-DATE           TO EQ-DATE-LAST-MOVE          
                                             EQ-DATE-DISPOSED-OF.       
           MOVE WS-IN-MSF-CD              TO EQ-LOCAL-OFFICE.           
           MOVE WS-CURRENT-DATE           TO EQ-DATE-LAST-TRAN.         
           MOVE WS-IN-EQUIP-LOC-ID        TO EQ-CODE-CRNT-LOC.          
           MOVE WS-IN-TRANSIT-EMP-ID      TO EQ-IN-TRANSIT-EMP-ID.      
                                                                        
           IF WS-IN-MOVE-DATE = SPACES                                  
               MOVE -1                    TO WS-EQ-DATE-DIS-OF-NULL     
                                             WS-EQ-DATE-LAST-MOVE-NULL  
           END-IF                                                       
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-RETIRE                   
                                                                        
              PERFORM 8420-UPDATE-EQUIPMENT          THRU 8420-EXIT     
           ELSE                                                         
              MOVE WS-DATE-DISPSD-OF-TMP  TO EQ-DATE-DISPOSED-OF        
              MOVE WS-EQ-DATE-DIS-OF-NUL-TMP                            
                                          TO WS-EQ-DATE-DIS-OF-NULL     
              PERFORM 8420-UPDATE-EQUIPMENT          THRU 8420-EXIT     
                                                                        
              PERFORM 7110-OPEN-METER-ATTCH-CURSOR   THRU 7110-EXIT     
              PERFORM 7120-FETCH-METER-ATTCH-CURSOR  THRU 7120-EXIT     
              PERFORM 2300-PROCESS-MTR-ATTCH-CURSOR  THRU 2300-EXIT     
                          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND       
              PERFORM 7130-CLOSE-METER-ATTCH-CURSOR  THRU 7130-EXIT     
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2200-METER-TRANSFER.                                            *        
      ******************************************************************        
       2200-METER-TRANSFER.                                             
                                                                        
           MOVE WS-IN-MOVE-DATE            TO EQ-DATE-LAST-MOVE         
                                              EQ-DATE-DISPOSED-OF.      
           MOVE WS-IN-MSF-CD               TO EQ-LOCAL-OFFICE.          
           MOVE WS-CURRENT-DATE            TO EQ-DATE-LAST-TRAN.        
           MOVE WS-IN-EQUIP-LOC-ID         TO EQ-CODE-CRNT-LOC.         
C14744     MOVE WS-IN-TRANSIT-EMP-ID       TO EQ-IN-TRANSIT-EMP-ID.     
                                                                        
           IF WS-IN-MOVE-DATE = SPACES                                  
              MOVE -1                      TO WS-EQ-DATE-LAST-MOVE-NULL 
                                              WS-EQ-DATE-DIS-OF-NULL    
           END-IF                                                       
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-RETIRE                   
                                                                        
              PERFORM 8420-UPDATE-EQUIPMENT        THRU 8420-EXIT       
           ELSE                                                         
              IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-EMPLOYEE              
                 MOVE WS-DATE-DISPSD-OF-TMP                             
                                           TO EQ-DATE-DISPOSED-OF       
                 MOVE WS-EQ-DATE-DIS-OF-NUL-TMP                         
                                           TO WS-EQ-DATE-DIS-OF-NULL    
                 PERFORM 8420-UPDATE-EQUIPMENT     THRU 8420-EXIT       
              ELSE                                                      
                                                                        
                 MOVE WS-DATE-DISPSD-OF-TMP                             
                                           TO EQ-DATE-DISPOSED-OF       
                 MOVE WS-EQ-DATE-DIS-OF-NUL-TMP                         
                                           TO WS-EQ-DATE-DIS-OF-NULL    
                 PERFORM 8420-UPDATE-EQUIPMENT     THRU 8420-EXIT       
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7110-OPEN-METER-ATTCH-CURSOR    THRU 7110-EXIT       
           PERFORM 7120-FETCH-METER-ATTCH-CURSOR   THRU 7120-EXIT       
           PERFORM 2300-PROCESS-MTR-ATTCH-CURSOR   THRU 2300-EXIT       
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
           PERFORM 7130-CLOSE-METER-ATTCH-CURSOR   THRU 7130-EXIT.      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2300-PROCESS-MTR-ATTCH-CURSOR                                   *        
      ******************************************************************        
       2300-PROCESS-MTR-ATTCH-CURSOR.                                   
                                                                        
           MOVE MA-DEVICE-NO             TO LX-DEVICE-NO                
                                            MP-DEVICE-NO.               
           MOVE MA-CODE-ATT-TYPE         TO LX-CODE-ATT-TYPE            
                                            MP-CODE-ATT-TYPE.           
           MOVE WS-IN-CODE-UTIL-TYPE     TO LX-CODE-UTIL-TYPE           
                                            MP-CODE-UTIL-TYPE.          
           MOVE WS-IN-COMPANY-NO         TO LX-COMPANY-NO               
                                            MP-COMPANY-NO.              
                                                                        
           PERFORM 7410-SELECT-EQUIP-ATTCHMTS      THRU 7410-EXIT.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-LX-DATE-LAST-MOVE-NULL = -1                         
                 MOVE '1900-01-01'       TO WS-DATE-MOVE                
              ELSE                                                      
                 MOVE LX-DATE-LAST-MOVE  TO WS-DATE-MOVE                
              END-IF                                                    
                                                                        
              MOVE WS-DATE-MOVE          TO MP-DATE-MOVE                
              MOVE WS-CURRENT-TIMESTAMP  TO MP-MOVE-NO                  
              MOVE LX-MTR-STORAGE-FAC-CD TO MP-MTR-STORAGE-FAC-CD       
              MOVE LX-EQUIP-LOC-ID       TO MP-EQUIP-LOC-ID             
              MOVE WS-IN-DEVICE-NO       TO MP-METER-NO                 
                                                                        
              PERFORM 8450-INSERT-EQUIP-ATT-MOVE   THRU 8450-EXIT       
                                                                        
              MOVE 'K'                   TO LX-EQUIP-LOC-ID             
              MOVE WS-IN-MOVE-DATE       TO LX-DATE-LAST-MOVE           
                                                                        
              IF WS-IN-MOVE-DATE = SPACES                               
                 MOVE -1 TO WS-LX-DATE-LAST-MOVE-NULL                   
              END-IF                                                    
                                                                        
              MOVE WS-CURRENT-DATE       TO LX-DATE-LAST-TRAN           
              MOVE WS-IN-MSF-CD          TO LX-MTR-STORAGE-FAC-CD       
                                                                        
              IF WS-IN-MSF-CD = SPACES                                  
                 MOVE -1 TO WS-LX-MTR-STORAGE-NULL                      
              END-IF                                                    
                                                                        
              PERFORM 8460-UPDATE-EQUIP-ATTCHMTS   THRU 8460-EXIT       
           END-IF                                                       
                                                                        
           PERFORM 7120-FETCH-METER-ATTCH-CURSOR   THRU 7120-EXIT.      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7000-SELECT-CURR-DATE-AND-TIME                                  *        
      ******************************************************************        
       7000-SELECT-CURR-DATE-AND-TIME.                                  
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7000'             TO ACTIVE-PARAGRAPH               
              MOVE 'SET'              TO ABEND-FUNCTION                 
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7110-OPEN-METER-ATTCH-CURSOR                                    *        
      ******************************************************************        
       7110-OPEN-METER-ATTCH-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN CSS_MTR_ATTCH_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7110'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_MTR_ATTCH_CUR'  TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7120-FETCH-METER-ATTCH-CURSOR.                                  *        
      ******************************************************************        
       7120-FETCH-METER-ATTCH-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH CSS_MTR_ATTCH_CUR                                   
               INTO :MA-HOW-ATTACHED-CD                                 
                   ,:MA-DEVICE-NO                                       
                   ,:MA-CODE-ATT-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_MTR_ATTCH_CUR'  TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7130-CLOSE-METER-ATTCH-CURSOR                                   *        
      ******************************************************************        
       7130-CLOSE-METER-ATTCH-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE CSS_MTR_ATTCH_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7130'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_MTR_ATTCH_CUR'  TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7310-SELECT-EQUIPMENT                                           *        
      ******************************************************************        
       7310-SELECT-EQUIPMENT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE                                       
                    ,CODE_CRNT_LOC                                      
                    ,SERIAL_NO                                          
                    ,CRNT_LOC_NO                                        
                    ,DATE_LAST_MOVE                                     
                    ,DATE_DISPOSED_OF                                   
                    ,EQUIP_COMMENTS_TX                                  
C14744              ,IN_TRANSIT_EMP_ID                                  
                INTO :EQ-LOCAL-OFFICE                                   
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-SERIAL-NO                                      
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EQ-DATE-LAST-MOVE :WS-EQ-DATE-LAST-MOVE-NULL      
                    ,:EQ-DATE-DISPOSED-OF :WS-EQ-DATE-DIS-OF-NUL-TMP    
                    ,:EQ-EQUIP-COMMENTS-TX                              
C14744              ,:EQ-IN-TRANSIT-EMP-ID                              
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO      = :EQ-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE               
                 AND DEVICE_NO       = :EQ-DEVICE-NO                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*             ,CODE_CRNT_LOC                                              
MFA-TR*             ,SERIAL_NO                                                  
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*             ,DATE_LAST_MOVE                                             
MFA-TR*             ,DATE_DISPOSED_OF                                           
MFA-TR*             ,EQUIP_COMMENTS_TX                                          
MFA-TR*             ,IN_TRANSIT_EMP_ID                                          
MFA-TR*         INTO :EQ-LOCAL-OFFICE                                           
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-SERIAL-NO                                              
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*             ,:EQ-DATE-LAST-MOVE :WS-EQ-DATE-LAST-MOVE-NULL              
MFA-TR*             ,:EQ-DATE-DISPOSED-OF :WS-EQ-DATE-DIS-OF-NUL-TMP            
MFA-TR*             ,:EQ-EQUIP-COMMENTS-TX                                      
MFA-TR*             ,:EQ-IN-TRANSIT-EMP-ID                                      
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE COMPANY_NO      = :EQ-COMPANY-NO                           
MFA-TR*          AND CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                       
MFA-TR*          AND DEVICE_NO       = :EQ-DEVICE-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7310'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7410-SELECT-EQUIP-ATTCHMTS                                      *        
      ******************************************************************        
       7410-SELECT-EQUIP-ATTCHMTS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT DATE_LAST_MOVE                                     
                    ,COMPANY_NO                                         
                    ,MTR_STORAGE_FAC_CD                                 
                    ,EQUIP_LOC_ID                                       
                INTO :LX-DATE-LAST-MOVE :WS-LX-DATE-LAST-MOVE-NULL       
                    ,:LX-COMPANY-NO                                     
                    ,:LX-MTR-STORAGE-FAC-CD :WS-LX-MTR-STORAGE-NULL      
                    ,:LX-EQUIP-LOC-ID                                   
                FROM CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO      = :LX-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE               
                 AND DEVICE_NO       = :LX-DEVICE-NO                    
                 AND CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_LAST_MOVE                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,MTR_STORAGE_FAC_CD                                         
MFA-TR*             ,EQUIP_LOC_ID                                               
MFA-TR*         INTO :LX-DATE-LAST-MOVE:WS-LX-DATE-LAST-MOVE-NULL               
MFA-TR*             ,:LX-COMPANY-NO                                             
MFA-TR*             ,:LX-MTR-STORAGE-FAC-CD:WS-LX-MTR-STORAGE-NULL              
MFA-TR*             ,:LX-EQUIP-LOC-ID                                           
MFA-TR*         FROM CSS_EQUIP_ATTCHMTS                                         
MFA-TR*        WHERE COMPANY_NO      = :LX-COMPANY-NO                           
MFA-TR*          AND CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE                       
MFA-TR*          AND DEVICE_NO       = :LX-DEVICE-NO                            
MFA-TR*          AND CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7410'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-4              
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              MOVE LX-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8410-INSERT-MOVEMENT-HIST                                       *        
      ******************************************************************        
       8410-INSERT-MOVEMENT-HIST.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MOVEMENT_HIST                             
              (                                                         
                 CODE_DEVICE_TYPE                                       
                ,CODE_UTIL_TYPE                                         
                ,DEVICE_NO                                              
                ,DATE_MOVE                                              
                ,LOCAL_OFFICE                                           
                ,COMPANY_NO                                             
                ,LOC_NO                                                 
                ,MOVE_NO                                                
                ,CODE_CRNT_LOC                                          
C14744          ,IN_TRANSIT_EMP_ID                                      
              )                                                         
              VALUES                                                    
              (                                                         
                 :MV-CODE-DEVICE-TYPE                                   
                ,:MV-CODE-UTIL-TYPE                                     
                ,:MV-DEVICE-NO                                          
                ,IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                                
                ,:MV-LOCAL-OFFICE                                       
                ,:MV-COMPANY-NO                                         
                ,:MV-LOC-NO                                             
                ,CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)                                
                ,:MV-CODE-CRNT-LOC                                      
C14744          ,:MV-IN-TRANSIT-EMP-ID                                  
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MOVEMENT_HIST                                     
MFA-TR*       (                                                                 
MFA-TR*          CODE_DEVICE_TYPE                                               
MFA-TR*         ,CODE_UTIL_TYPE                                                 
MFA-TR*         ,DEVICE_NO                                                      
MFA-TR*         ,DATE_MOVE                                                      
MFA-TR*         ,LOCAL_OFFICE                                                   
MFA-TR*         ,COMPANY_NO                                                     
MFA-TR*         ,LOC_NO                                                         
MFA-TR*         ,MOVE_NO                                                        
MFA-TR*         ,CODE_CRNT_LOC                                                  
MFA-TR*         ,IN_TRANSIT_EMP_ID                                              
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*          :MV-CODE-DEVICE-TYPE                                           
MFA-TR*         ,:MV-CODE-UTIL-TYPE                                             
MFA-TR*         ,:MV-DEVICE-NO                                                  
MFA-TR*         ,:MV-DATE-MOVE                                                  
MFA-TR*         ,:MV-LOCAL-OFFICE                                               
MFA-TR*         ,:MV-COMPANY-NO                                                 
MFA-TR*         ,:MV-LOC-NO                                                     
MFA-TR*         ,:MV-MOVE-NO                                                    
MFA-TR*         ,:MV-CODE-CRNT-LOC                                              
MFA-TR*         ,:MV-IN-TRANSIT-EMP-ID                                          
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8410'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_MOVEMENT_HIST'  TO TABLE-1                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-2              
              MOVE 'DATE_MOVE'          TO TABLE-ELEMENT-3              
              MOVE 'MOVE_NO'            TO TABLE-ELEMENT-4              
              MOVE MV-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE MV-DEVICE-NO         TO HOSTVAR-ELEMENT-2            
              MOVE MV-DATE-MOVE         TO HOSTVAR-ELEMENT-3            
              MOVE MV-MOVE-NO           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8420-UPDATE-EQUIPMENT                                           *        
      ******************************************************************        
       8420-UPDATE-EQUIPMENT.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
                 SET                                                    
                     CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                
                    ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC              
                    ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE               
                    ,DATE_LAST_TRAN    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) )     
                    ,DATE_LAST_MOVE    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) )     
                    ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX          
                    ,DATE_DISPOSED_OF  = IIF(TRY_CONVERT(DATE, 
                                                  :EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) <> 0) OR (LEN(:EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ), CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) )        
C14744              ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID          
               WHERE COMPANY_NO        = :EQ-COMPANY-NO                 
                 AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE             
                 AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD              
                 AND DEVICE_NO         = :EQ-DEVICE-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIPMENT                                              
MFA-TR*          SET                                                            
MFA-TR*              CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                        
MFA-TR*             ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC                      
MFA-TR*             ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                       
MFA-TR*             ,DATE_LAST_TRAN    = :EQ-DATE-LAST-TRAN                     
MFA-TR*                                  :WS-EQ-DATE-LAST-TRAN-NULL             
MFA-TR*             ,DATE_LAST_MOVE    = :EQ-DATE-LAST-MOVE                     
MFA-TR*                                  :WS-EQ-DATE-LAST-MOVE-NULL             
MFA-TR*             ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX                  
MFA-TR*             ,DATE_DISPOSED_OF  = :EQ-DATE-DISPOSED-OF                   
MFA-TR*                                  :WS-EQ-DATE-DIS-OF-NULL                
MFA-TR*             ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID                  
MFA-TR*        WHERE COMPANY_NO        = :EQ-COMPANY-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD                      
MFA-TR*          AND DEVICE_NO         = :EQ-DEVICE-NO                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8420'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'EQUIP_TYPE_CD'      TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-EQUIP-TYPE-CD     TO HOSTVAR-ELEMENT-3            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8450-INSERT-EQUIP-ATT-MOVE                                      *        
      ******************************************************************        
       8450-INSERT-EQUIP-ATT-MOVE.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIP_ATT_MOVE                            
              (                                                         
                 DEVICE_NO                                              
                ,CODE_ATT_TYPE                                          
                ,COMPANY_NO                                             
                ,CODE_UTIL_TYPE                                         
                ,DATE_MOVE                                              
                ,MOVE_NO                                                
                ,MTR_STORAGE_FAC_CD                                     
                ,EQUIP_LOC_ID                                           
                ,METER_NO                                               
              )                                                         
              VALUES                                                    
              (                                                         
                 :MP-DEVICE-NO                                          
                ,:MP-CODE-ATT-TYPE                                      
                ,:MP-COMPANY-NO                                         
                ,:MP-CODE-UTIL-TYPE                                     
                ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) )                                
                ,CIS.CHAR2TIMESTAMP(:MP-MOVE-NO)                                
                ,:MP-MTR-STORAGE-FAC-CD                                 
                ,:MP-EQUIP-LOC-ID                                       
                ,:MP-METER-NO                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EQUIP_ATT_MOVE                                    
MFA-TR*       (                                                                 
MFA-TR*          DEVICE_NO                                                      
MFA-TR*         ,CODE_ATT_TYPE                                                  
MFA-TR*         ,COMPANY_NO                                                     
MFA-TR*         ,CODE_UTIL_TYPE                                                 
MFA-TR*         ,DATE_MOVE                                                      
MFA-TR*         ,MOVE_NO                                                        
MFA-TR*         ,MTR_STORAGE_FAC_CD                                             
MFA-TR*         ,EQUIP_LOC_ID                                                   
MFA-TR*         ,METER_NO                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*          :MP-DEVICE-NO                                                  
MFA-TR*         ,:MP-CODE-ATT-TYPE                                              
MFA-TR*         ,:MP-COMPANY-NO                                                 
MFA-TR*         ,:MP-CODE-UTIL-TYPE                                             
MFA-TR*         ,:MP-DATE-MOVE                                                  
MFA-TR*         ,:MP-MOVE-NO                                                    
MFA-TR*         ,:MP-MTR-STORAGE-FAC-CD                                         
MFA-TR*         ,:MP-EQUIP-LOC-ID                                               
MFA-TR*         ,:MP-METER-NO                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8450'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATT_MOVE' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'DATE_MOVE'          TO TABLE-ELEMENT-2              
              MOVE 'MOVE_NO'            TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MP-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MP-DATE-MOVE         TO HOSTVAR-ELEMENT-2            
              MOVE MP-MOVE-NO           TO HOSTVAR-ELEMENT-3            
              MOVE MP-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8460-UPDATE-EQUIP-ATTCHMTS                                      *        
      ******************************************************************        
       8460-UPDATE-EQUIP-ATTCHMTS.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIP_ATTCHMTS                                 
                 SET                                                    
                     DATE_LAST_MOVE     = IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) )    
                    ,DATE_LAST_TRAN     = IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) )    
                    ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD 
                                          :WS-LX-MTR-STORAGE-NULL       
                    ,EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID              
               WHERE DEVICE_NO          = :LX-DEVICE-NO                 
                 AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE             
                 AND COMPANY_NO         = :LX-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIP_ATTCHMTS                                         
MFA-TR*          SET                                                            
MFA-TR*              DATE_LAST_MOVE     = :LX-DATE-LAST-MOVE                    
MFA-TR*                                   :WS-LX-DATE-LAST-MOVE-NULL            
MFA-TR*             ,DATE_LAST_TRAN     = :LX-DATE-LAST-TRAN                    
MFA-TR*                                   :WS-LX-DATE-LAST-TRAN-NULL            
MFA-TR*             ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD                
MFA-TR*                                   :WS-LX-MTR-STORAGE-NULL               
MFA-TR*             ,EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                      
MFA-TR*        WHERE DEVICE_NO          = :LX-DEVICE-NO                         
MFA-TR*          AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                     
MFA-TR*          AND COMPANY_NO         = :LX-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8460'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-1              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-3              
              MOVE 'CODE-UTIL-TYPE'     TO TABLE-ELEMENT-4              
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-3            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9900- ERROR HANDLING INCLUDE                                  *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE                                                *         
      * 9000-SEND-ERROR-RESULT                                        *         
      * 9999-END-PROGRAM                                              *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
