       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04226.                                         
COB303 DATE-WRITTEN.  JAN 27 2009                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  SP CALLED BY METER INVENTORY SYSTEM TO PERFORM VALIDATION     *        
      *  FOR GAS TRANSFER AND MOVEMENT SCREENS                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/27/09  MN90523    PROCEDURE ORIGINALLY CODED.              *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04226'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04226 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05  CTR-ROWS                PIC S9(9) COMP VALUE 1.          
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04226'.      
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-CALL-TYPE              PIC X(01).                      
           05 WS-CODE-UTIL-TYPE         PIC X(01).                      
           05 WS-COMPANY-NO             PIC X(02).                      
           05 WS-DEVICE-NO              PIC X(09).                      
           05 WS-SERIAL-NO              PIC X(11).                      
           05 WS-MOVE-DATE              PIC X(10).                      
           05 WS-EQUIP-LOC-ID           PIC X(01).                      
           05 WS-MSF-CD                 PIC X(03).                      
           05 WS-EMP-ID-CHAR            PIC X(10).                      
           05 WS-EMP-ID-NUM   REDEFINES WS-EMP-ID-CHAR PIC 9(10).       
COB305     05 WS-EMP-ID        PIC S9(10)V COMP-3 VALUE 0.             
           05 WS-TRANSFER               PIC X(01) VALUE 'T'.            
           05 WS-MOVEMENT               PIC X(01) VALUE 'M'.            
           05 WS-EQ-LOC-INVENTORY-A     PIC X(01) VALUE 'A'.            
           05 WS-EQ-LOC-RETIRE-I        PIC X(01) VALUE 'I'.            
           05 WS-EQ-LOC-METER-SHOP-B    PIC X(01) VALUE 'B'.            
           05 WS-EQ-LOC-UNKNOWN-U       PIC X(01) VALUE 'U'.            
           05 WS-EQ-LOC-EMPLOYEE-C      PIC X(01) VALUE 'C'.            
           05 WS-EQ-LOC-AT-CUSTOMER-J   PIC X(01) VALUE 'J'.            
           05 WS-EQ-LOC-ATTACHED-K      PIC X(01) VALUE 'K'.            
           05 WS-EQ-LOC-OLD-ACCT-X      PIC X(01) VALUE 'X'.            
           05 WS-EQ-LOC-ONSITE-S        PIC X(01) VALUE 'S'.            
           05 WS-MTR-ATTCH-EXISTS       PIC X(01) VALUE 'N'.            
           05 WS-MTR-ATT-TYPE-EXISTS    PIC X(01) VALUE 'N'.            
           05 WS-CURRENT-DATE           PIC X(10).                      
           05 WS-MIN-LOC-NO             PIC S9(10)V COMP-3              
                                              VALUE 2397000000.         
           05 WS-MAX-LOC-NO             PIC S9(10)V COMP-3              
                                              VALUE 2397999999.         
           05 WS-GT-DATE-TEST-1         PIC X(10).                      
           05 WS-GT-DATE-TEST-2         PIC X(10).                      
           05 WS-NUM-TEST-RECORDS       PIC S9(9) COMP VALUE 0.         
           05 WS-ERR-CONDEMN-WO-TEST    PIC X(10) VALUE 'MT199'.        
                                                                        
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-LAST-REMOVAL         PIC X(01) VALUE 'N'.             
               88 WS-LAST-REMOVAL-FOUND          VALUE 'Y'.             
               88 WS-LAST-REMOVAL-NOT-FOUND      VALUE 'N'.             
                                                                        
      *********************'THIS IS THE ROW RETURN AREA'****************        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
           05  RS-ADDITIONAL-MSG         PIC X(30)  VALUE SPACES.       
           05  RS-PROMPT                 PIC X(30)  VALUE SPACES.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
           05  S-ADDITIONAL-MSG          PIC X(30)  VALUE SPACES.       
           05  S-PROMPT                  PIC X(30)  VALUE SPACES.       
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_EQUIPMENT       - EQ                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATTCHMTS  -  LX                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQATTH                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GAS_METER       - GM                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GAS_MTR_TEST    - GT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS  - MA                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MOVEMENT_HIST   - MV                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_ATT_TYPE    - N5                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * CURSOR DECLARATIONS                                                     
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                     
             DECLARE MOVMNT_HIST_CUR CURSOR FOR                         
             SELECT                                                     
                    MV.CODE_CRNT_LOC                                    
                   ,MV.DATE_MOVE                                        
               FROM                                                     
                    CSS_MOVEMENT_HIST MV WITH(READUNCOMMITTED)                  
              WHERE                                                     
                    COMPANY_NO     = :MV-COMPANY-NO                     
                AND CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                 
                AND DEVICE_NO      = :MV-DEVICE-NO                      
              ORDER BY                                                  
                    MV.DATE_MOVE DESC                                   
                   ,MV.MOVE_NO DESC                                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE MOVMNT_HIST_CUR CURSOR FOR                                 
MFA-TR*      SELECT                                                             
MFA-TR*             MV.CODE_CRNT_LOC                                            
MFA-TR*            ,MV.DATE_MOVE                                                
MFA-TR*        FROM                                                             
MFA-TR*             CSS_MOVEMENT_HIST MV                                        
MFA-TR*       WHERE                                                             
MFA-TR*             COMPANY_NO     = :MV-COMPANY-NO                             
MFA-TR*         AND CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                         
MFA-TR*         AND DEVICE_NO      = :MV-DEVICE-NO                              
MFA-TR*       ORDER BY                                                          
MFA-TR*             MV.DATE_MOVE DESC                                           
MFA-TR*            ,MV.MOVE_NO DESC                                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-CALL-TYPE            PIC X(01).                          
       01 PARM-CODE-UTIL-TYPE       PIC X(01).                          
       01 PARM-COMPANY-NO           PIC X(02).                          
       01 PARM-DEVICE-NO            PIC X(09).                          
       01 PARM-SERIAL-NO            PIC X(11).                          
       01 PARM-MOVE-DATE            PIC X(10).                          
       01 PARM-EQUIP-LOC-ID         PIC X(01).                          
       01 PARM-MSF-CD               PIC X(03).                          
       01 PARM-EMP-ID               PIC X(10).                          
      *                                                                         
       PROCEDURE DIVISION USING PARM-CALL-TYPE                          
                                PARM-CODE-UTIL-TYPE                     
                                PARM-COMPANY-NO                         
                                PARM-DEVICE-NO                          
                                PARM-SERIAL-NO                          
                                PARM-MOVE-DATE                          
                                PARM-EQUIP-LOC-ID                       
                                PARM-MSF-CD                             
                                PARM-EMP-ID.                            
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                    :S-RETURN-CODE          AS RETURN_CODE              
                   ,:S-ADDITIONAL-MSG       AS ADDITIONAL_MSG           
                   ,:S-PROMPT               AS [PROMPT]                   
               FROM                                                     
                    CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*             :S-RETURN-CODE          AS RETURN_CODE                      
MFA-TR*            ,:S-ADDITIONAL-MSG       AS ADDITIONAL_MSG                   
MFA-TR*            ,:S-PROMPT               AS PROMPT                           
MFA-TR*        FROM                                                             
MFA-TR*             SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS                        
                                            THRU 1200-EXIT.             
                                                                        
           MOVE PARM-CALL-TYPE              TO WS-CALL-TYPE             
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE.       
           MOVE PARM-COMPANY-NO             TO WS-COMPANY-NO            
           MOVE PARM-DEVICE-NO              TO WS-DEVICE-NO             
           MOVE PARM-SERIAL-NO              TO WS-SERIAL-NO             
           MOVE PARM-MOVE-DATE              TO WS-MOVE-DATE             
           MOVE PARM-EQUIP-LOC-ID           TO WS-EQUIP-LOC-ID          
           MOVE PARM-MSF-CD                 TO WS-MSF-CD                
           MOVE PARM-EMP-ID                 TO WS-EMP-ID-CHAR           
           MOVE WS-EMP-ID-NUM               TO WS-EMP-ID.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1200-VALIDATE-INPUT-ARGUMENTS.                                 *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-COMPANY-NO  = SPACES  OR                             
              PARM-CODE-UTIL-TYPE NOT = 'G' OR (                        
              PARM-CALL-TYPE NOT = 'M' AND                              
              PARM-CALL-TYPE NOT = 'T' ) OR                             
              PARM-DEVICE-NO   = SPACES                                 
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-1          
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-2          
              MOVE 'PARM-CALL-TYPE'         TO TABLE-ELEMENT-3          
              MOVE 'PARM-DEVICE-NO'         TO TABLE-ELEMENT-4          
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2        
              MOVE PARM-CALL-TYPE           TO HOSTVAR-ELEMENT-3        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7160-GET-CURRENT-TIMESTAMP  THRU 7160-EXIT.          
                                                                        
           PERFORM 2100-PROCESS-TRSFR-MVMNT    THRU 2100-EXIT.          
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT                                                        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE                 TO S-RETURN-CODE.        
           MOVE RS-ADDITIONAL-MSG              TO S-ADDITIONAL-MSG.     
           MOVE RS-PROMPT                      TO S-PROMPT.             
           ADD +1                              TO CTR-ROWS.             
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-TRSFR-MVMNT                                       *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-TRSFR-MVMNT.                                        
                                                                        
           MOVE WS-COMPANY-NO               TO EQ-COMPANY-NO            
                                               MA-COMPANY-NO.           
                                                                        
           MOVE WS-CODE-UTIL-TYPE           TO EQ-CODE-UTIL-TYPE        
                                               MA-CODE-UTIL-TYPE.       
                                                                        
           MOVE WS-DEVICE-NO                TO EQ-DEVICE-NO             
                                               MA-METER-NO.             
                                                                        
           PERFORM 7000-GET-EQUIPMENT-DETAILS  THRU 7000-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 6400                     TO RS-RETURN-CODE           
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF EQ-SERIAL-NO NOT = WS-SERIAL-NO                           
              MOVE 5100                     TO RS-RETURN-CODE           
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-MOVE-DATE < EQ-DATE-LAST-MOVE AND                      
              EQ-DATE-LAST-MOVE > SPACES                                
              MOVE 5200                     TO RS-RETURN-CODE           
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-MOVE-DATE > WS-CURRENT-DATE                            
              MOVE 5400                     TO RS-RETURN-CODE           
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-EQUIP-LOC-ID = WS-EQ-LOC-RETIRE-I                      
                                                                        
              IF WS-CALL-TYPE = WS-MOVEMENT                             
                                                                        
                 MOVE 'N'                   TO WS-MTR-ATTCH-EXISTS      
                 PERFORM 7020-GET-METER-ATTCH-DTLS                      
                                            THRU 7020-EXIT              
                                                                        
                 IF WS-MTR-ATTCH-EXISTS = 'Y'                           
                    MOVE 5300                 TO RS-RETURN-CODE         
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 9999-END-PROGRAM  THRU 9999-EXIT            
                 END-IF                                                 
                                                                        
              ELSE                                                      
                                                                        
                 MOVE 'N'                     TO WS-MTR-ATT-TYPE-EXISTS 
                 PERFORM 7120-CHECK-MTR-ATT-TYPE                        
                                              THRU 7120-EXIT            
                                                                        
                 IF WS-MTR-ATT-TYPE-EXISTS = 'Y'                        
                    MOVE 6500                 TO RS-RETURN-CODE         
                    PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 9999-END-PROGRAM  THRU 9999-EXIT            
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CALL-TYPE = WS-MOVEMENT                                
              IF EQ-CODE-CRNT-LOC = WS-EQ-LOC-AT-CUSTOMER-J             
                 AND WS-EQUIP-LOC-ID NOT = WS-EQ-LOC-INVENTORY-A        
                 AND (EQ-CRNT-LOC-NO < WS-MIN-LOC-NO                    
                  OR EQ-CRNT-LOC-NO > WS-MAX-LOC-NO)                    
                       MOVE 5500                    TO RS-RETURN-CODE   
                       PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT     
                       PERFORM 9999-END-PROGRAM     THRU 9999-EXIT      
               ELSE                                                     
                       PERFORM 2300-CHECK-MOVEMENT-HIST THRU 2300-EXIT  
                       IF EQ-CODE-CRNT-LOC = WS-EQ-LOC-INVENTORY-A      
                          AND WS-EQUIP-LOC-ID = WS-EQ-LOC-RETIRE-I      
                          AND WS-NUM-TEST-RECORDS = 0                   
                          MOVE 5600              TO RS-RETURN-CODE      
                          MOVE WS-ERR-CONDEMN-WO-TEST TO RS-PROMPT      
                          PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT     
                          PERFORM 9999-END-PROGRAM  THRU 9999-EXIT      
                       END-IF                                           
                       PERFORM 2400-VALIDATE-TRSFR-MVMNT  THRU 2400-EXIT
               END-IF                                                   
           ELSE                                                         
                                                                        
              PERFORM 2400-VALIDATE-TRSFR-MVMNT  THRU 2400-EXIT         
                                                                        
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-CHECK-MOVEMENT-HIST.                                      *        
      ******************************************************************        
       2300-CHECK-MOVEMENT-HIST.                                        
                                                                        
           MOVE +0                             TO WS-NUM-TEST-RECORDS.  
           SET WS-LAST-REMOVAL-NOT-FOUND       TO TRUE.                 
                                                                        
           MOVE WS-COMPANY-NO                  TO MV-COMPANY-NO         
                                                  GT-COMPANY-NO.        
                                                                        
           MOVE WS-CODE-UTIL-TYPE              TO MV-CODE-UTIL-TYPE     
                                                  GT-CODE-UTIL-TYPE.    
                                                                        
           MOVE WS-DEVICE-NO                   TO MV-DEVICE-NO          
                                                  GT-METER-NO.          
                                                                        
           PERFORM 7060-OPEN-MOVMNT-HIST-CUR   THRU 7060-EXIT.          
                                                                        
           PERFORM 7064-FETCH-MOVMNT-HIST-CUR  THRU 7064-EXIT.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              WS-EQUIP-LOC-ID = WS-EQ-LOC-AT-CUSTOMER-J                 
                                                                        
              MOVE 5500                        TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           ELSE                                                         
                                                                        
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 IF MV-CODE-CRNT-LOC = WS-EQ-LOC-AT-CUSTOMER-J          
                    MOVE MV-DATE-MOVE          TO WS-GT-DATE-TEST-1     
                    SET WS-LAST-REMOVAL-FOUND  TO TRUE                  
                    MOVE NOT-FOUND             TO WS-ACTIVE-RETURN-CODE 
                 ELSE                                                   
                    PERFORM 7064-FETCH-MOVMNT-HIST-CUR                  
                                               THRU 7064-EXIT           
                 END-IF                                                 
              END-PERFORM                                               
           END-IF                                                       
                                                                        
           PERFORM 7068-CLOSE-MOVMNT-HIST-CUR  THRU 7068-EXIT.          
                                                                        
           IF WS-LAST-REMOVAL-FOUND                                     
              MOVE WS-MOVE-DATE                TO WS-GT-DATE-TEST-2     
              PERFORM 7080-GET-COUNT-GAS-MTR-TEST                       
                                               THRU 7080-EXIT           
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-VALIDATE-TRSFR-MVMNT                                      *        
      ******************************************************************        
       2400-VALIDATE-TRSFR-MVMNT.                                       
                                                                        
           EVALUATE EQ-CODE-CRNT-LOC                                    
                                                                        
             WHEN WS-EQ-LOC-INVENTORY-A                                 
               PERFORM 2500-TRSFR-MVNT-FROM-INVENTORY                   
                                            THRU 2500-EXIT              
             WHEN WS-EQ-LOC-METER-SHOP-B                                
               PERFORM 2510-TRSFR-MVNT-FROM-MTR-SHOP                    
                                            THRU 2510-EXIT              
             WHEN WS-EQ-LOC-EMPLOYEE-C                                  
               PERFORM 2520-TRSFR-MVNT-FROM-EMPLOYEE                    
                                            THRU 2520-EXIT              
             WHEN WS-EQ-LOC-AT-CUSTOMER-J                               
               PERFORM 2530-TRSFR-MVNT-FROM-CUSTOMER                    
                                            THRU 2530-EXIT              
             WHEN WS-EQ-LOC-RETIRE-I                                    
               PERFORM 2540-TRSFR-MVNT-FROM-RETIRE                      
                                            THRU 2540-EXIT              
             WHEN WS-EQ-LOC-UNKNOWN-U                                   
               PERFORM 2550-TRSFR-MVNT-FROM-UNKNOWN                     
                                            THRU 2550-EXIT              
             WHEN WS-EQ-LOC-OLD-ACCT-X                                  
               PERFORM 2560-TRSFR-MVNT-FROM-OLD-ACCT                    
                                            THRU 2560-EXIT              
             WHEN WS-EQ-LOC-ATTACHED-K                                  
               PERFORM 2570-TRSFR-MVNT-FROM-ATTACHED                    
                                            THRU 2570-EXIT              
             WHEN WS-EQ-LOC-ONSITE-S                                    
               PERFORM 2580-TRSFR-MVNT-FROM-ONSITE                      
                                            THRU 2580-EXIT              
             WHEN OTHER                                                 
               IF WS-CALL-TYPE = WS-TRANSFER                            
                  MOVE 7400                 TO RS-RETURN-CODE           
                  MOVE EQ-LOCAL-OFFICE      TO RS-ADDITIONAL-MSG        
                  PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT             
                  PERFORM 9999-END-PROGRAM  THRU 9999-EXIT              
               END-IF                                                   
           END-EVALUATE.                                                
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-TRSFR-MVNT-FROM-INVENTORY                                 *        
      ******************************************************************        
       2500-TRSFR-MVNT-FROM-INVENTORY.                                  
                                                                        
           EVALUATE WS-EQUIP-LOC-ID                                     
                                                                        
             WHEN WS-EQ-LOC-INVENTORY-A                                 
                                                                        
               IF EQ-LOCAL-OFFICE = WS-MSF-CD                           
                  MOVE 5700                      TO RS-RETURN-CODE      
                  PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT        
                  PERFORM 9999-END-PROGRAM       THRU 9999-EXIT         
               END-IF                                                   
                                                                        
             WHEN WS-EQ-LOC-RETIRE-I                                    
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  PERFORM 2300-CHECK-MOVEMENT-HIST THRU 2300-EXIT       
                  IF WS-NUM-TEST-RECORDS = 0                            
                     MOVE WS-ERR-CONDEMN-WO-TEST TO RS-PROMPT           
                  END-IF                                                
               ELSE                                                     
                                                                        
                  IF EQ-LOCAL-OFFICE NOT = WS-MSF-CD                    
                     MOVE 6600                   TO RS-RETURN-CODE      
                     PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT        
                     PERFORM 9999-END-PROGRAM    THRU 9999-EXIT         
                  END-IF                                                
               END-IF                                                   
                                                                        
             WHEN WS-EQ-LOC-EMPLOYEE-C                                  
             WHEN WS-EQ-LOC-METER-SHOP-B                                
             WHEN WS-EQ-LOC-UNKNOWN-U                                   
                                                                        
               CONTINUE                                                 
                                                                        
             WHEN OTHER                                                 
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  MOVE 6000                      TO RS-RETURN-CODE      
                  PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT        
                  PERFORM 9999-END-PROGRAM       THRU 9999-EXIT         
               ELSE                                                     
                                                                        
                  MOVE 6700                      TO RS-RETURN-CODE      
                  MOVE EQ-LOCAL-OFFICE           TO RS-ADDITIONAL-MSG   
                  PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT        
                  PERFORM 9999-END-PROGRAM       THRU 9999-EXIT         
               END-IF                                                   
                                                                        
           END-EVALUATE.                                                
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2510-TRSFR-MVNT-FROM-MTR-SHOP                                  *        
      ******************************************************************        
      *                                                                         
       2510-TRSFR-MVNT-FROM-MTR-SHOP.                                   
                                                                        
           EVALUATE WS-EQUIP-LOC-ID                                     
                                                                        
             WHEN WS-EQ-LOC-METER-SHOP-B                                
                                                                        
               IF EQ-LOCAL-OFFICE = WS-MSF-CD                           
                  MOVE 5700                    TO RS-RETURN-CODE        
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               END-IF                                                   
                                                                        
             WHEN WS-EQ-LOC-RETIRE-I                                    
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  PERFORM 2300-CHECK-MOVEMENT-HIST  THRU 2300-EXIT      
                  IF WS-NUM-TEST-RECORDS = 0                            
                     MOVE WS-ERR-CONDEMN-WO-TEST    TO RS-PROMPT        
                  END-IF                                                
               ELSE                                                     
                                                                        
                 IF EQ-LOCAL-OFFICE NOT = WS-MSF-CD                     
                    MOVE 6600                    TO RS-RETURN-CODE      
                    PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT        
                    PERFORM 9999-END-PROGRAM     THRU 9999-EXIT         
                 END-IF                                                 
                                                                        
               END-IF                                                   
                                                                        
             WHEN WS-EQ-LOC-EMPLOYEE-C                                  
             WHEN WS-EQ-LOC-INVENTORY-A                                 
             WHEN WS-EQ-LOC-UNKNOWN-U                                   
               CONTINUE                                                 
                                                                        
             WHEN OTHER                                                 
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  MOVE 6000                    TO RS-RETURN-CODE        
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               ELSE                                                     
                  MOVE 6800                    TO RS-RETURN-CODE        
                  MOVE EQ-LOCAL-OFFICE         TO RS-ADDITIONAL-MSG     
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               END-IF                                                   
                                                                        
           END-EVALUATE.                                                
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2520-TRSFR-MVNT-FROM-EMPLOYEE                                  *        
      ******************************************************************        
       2520-TRSFR-MVNT-FROM-EMPLOYEE.                                   
                                                                        
           EVALUATE WS-EQUIP-LOC-ID                                     
                                                                        
             WHEN WS-EQ-LOC-EMPLOYEE-C                                  
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                 IF EQ-CODE-CRNT-LOC = WS-EQ-LOC-EMPLOYEE-C             
                   AND WS-EQUIP-LOC-ID = WS-EQ-LOC-EMPLOYEE-C           
                    IF EQ-CRNT-LOC-NO = WS-EMP-ID                       
                       MOVE 6100                    TO RS-RETURN-CODE   
                       PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT     
                       PERFORM 9999-END-PROGRAM     THRU 9999-EXIT      
                    END-IF                                              
                 END-IF                                                 
               ELSE                                                     
                                                                        
                 IF EQ-CRNT-LOC-NO = WS-EMP-ID                          
                    MOVE 6100                    TO RS-RETURN-CODE      
                    PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT        
                    PERFORM 9999-END-PROGRAM     THRU 9999-EXIT         
                 END-IF                                                 
               END-IF                                                   
                                                                        
             WHEN WS-EQ-LOC-UNKNOWN-U                                   
             WHEN WS-EQ-LOC-INVENTORY-A                                 
             WHEN WS-EQ-LOC-METER-SHOP-B                                
             WHEN WS-EQ-LOC-RETIRE-I                                    
                 CONTINUE                                               
                                                                        
             WHEN OTHER                                                 
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  MOVE 6000                    TO RS-RETURN-CODE        
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               ELSE                                                     
                  MOVE 6900                    TO RS-RETURN-CODE        
                  MOVE EQ-LOCAL-OFFICE         TO RS-ADDITIONAL-MSG     
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               END-IF                                                   
                                                                        
           END-EVALUATE.                                                
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2530-TRSFR-MVNT-FROM-CUSTOMER                                  *        
      ******************************************************************        
       2530-TRSFR-MVNT-FROM-CUSTOMER.                                   
                                                                        
           IF WS-CALL-TYPE = WS-TRANSFER                                
                                                                        
              MOVE 7100                    TO RS-RETURN-CODE            
              MOVE EQ-CRNT-LOC-NO          TO RS-ADDITIONAL-MSG         
              PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 9999-END-PROGRAM     THRU 9999-EXIT               
           ELSE                                                         
                                                                        
              IF WS-EQUIP-LOC-ID =                                      
                   WS-EQ-LOC-EMPLOYEE-C   OR                            
                   WS-EQ-LOC-INVENTORY-A  OR                            
                   WS-EQ-LOC-METER-SHOP-B OR                            
                   WS-EQ-LOC-UNKNOWN-U                                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 6000                    TO RS-RETURN-CODE         
                 PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2540-TRSFR-MVNT-FROM-RETIRE.                                   *        
      ******************************************************************        
       2540-TRSFR-MVNT-FROM-RETIRE.                                     
                                                                        
           IF WS-CALL-TYPE = WS-MOVEMENT                                
                                                                        
              IF WS-EQUIP-LOC-ID NOT = WS-EQ-LOC-INVENTORY-A            
                AND WS-EQUIP-LOC-ID NOT = WS-EQ-LOC-METER-SHOP-B        
                 MOVE 6000                    TO RS-RETURN-CODE         
                 PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
              END-IF                                                    
                                                                        
           ELSE                                                         
                                                                        
              IF WS-EQUIP-LOC-ID =                                      
                   WS-EQ-LOC-INVENTORY-A OR                             
                   WS-EQ-LOC-METER-SHOP-B                               
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 7000                    TO RS-RETURN-CODE         
                 MOVE EQ-LOCAL-OFFICE         TO RS-ADDITIONAL-MSG      
                 PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
                 PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2550-TRSFR-MVNT-FROM-UNKNOWN.                                  *        
      ******************************************************************        
      *                                                                         
       2550-TRSFR-MVNT-FROM-UNKNOWN.                                    
                                                                        
           EVALUATE WS-EQUIP-LOC-ID                                     
                                                                        
             WHEN WS-EQ-LOC-RETIRE-I                                    
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                                                                        
                  PERFORM 2300-CHECK-MOVEMENT-HIST  THRU 2300-EXIT      
                                                                        
                  IF WS-NUM-TEST-RECORDS = 0                            
                     MOVE WS-ERR-CONDEMN-WO-TEST    TO RS-PROMPT        
                  END-IF                                                
               ELSE                                                     
                                                                        
                  CONTINUE                                              
               END-IF                                                   
                                                                        
             WHEN WS-EQ-LOC-EMPLOYEE-C                                  
             WHEN WS-EQ-LOC-INVENTORY-A                                 
             WHEN WS-EQ-LOC-METER-SHOP-B                                
             WHEN WS-EQ-LOC-UNKNOWN-U                                   
                 CONTINUE                                               
                                                                        
             WHEN OTHER                                                 
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  MOVE 6000                    TO RS-RETURN-CODE        
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               ELSE                                                     
                                                                        
                  MOVE 7000                    TO RS-RETURN-CODE        
                  MOVE EQ-LOCAL-OFFICE         TO RS-ADDITIONAL-MSG     
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               END-IF                                                   
                                                                        
           END-EVALUATE.                                                
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2560-TRSFR-MVNT-FROM-OLD-ACCT.                                 *        
      ******************************************************************        
      *                                                                         
       2560-TRSFR-MVNT-FROM-OLD-ACCT.                                   
                                                                        
           EVALUATE WS-EQUIP-LOC-ID                                     
                                                                        
             WHEN WS-EQ-LOC-RETIRE-I                                    
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  PERFORM 2300-CHECK-MOVEMENT-HIST  THRU 2300-EXIT      
                  IF WS-NUM-TEST-RECORDS = 0                            
                     MOVE WS-ERR-CONDEMN-WO-TEST    TO RS-PROMPT        
                  END-IF                                                
               ELSE                                                     
                  CONTINUE                                              
               END-IF                                                   
                                                                        
             WHEN WS-EQ-LOC-EMPLOYEE-C                                  
             WHEN WS-EQ-LOC-INVENTORY-A                                 
             WHEN WS-EQ-LOC-METER-SHOP-B                                
             WHEN WS-EQ-LOC-UNKNOWN-U                                   
               CONTINUE                                                 
                                                                        
             WHEN OTHER                                                 
                                                                        
               IF WS-CALL-TYPE = WS-MOVEMENT                            
                  MOVE 6000                    TO RS-RETURN-CODE        
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               ELSE                                                     
                                                                        
                  MOVE 7000                    TO RS-RETURN-CODE        
                  MOVE EQ-LOCAL-OFFICE         TO RS-ADDITIONAL-MSG     
                  PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT          
                  PERFORM 9999-END-PROGRAM     THRU 9999-EXIT           
               END-IF                                                   
           END-EVALUATE.                                                
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2570-TRSFR-MVNT-FROM-ATTACHED.                                 *        
      ******************************************************************        
      *                                                                         
       2570-TRSFR-MVNT-FROM-ATTACHED.                                   
                                                                        
           IF WS-CALL-TYPE = WS-TRANSFER                                
              MOVE 7200                    TO RS-RETURN-CODE            
              MOVE EQ-CRNT-LOC-NO          TO RS-ADDITIONAL-MSG         
              PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 9999-END-PROGRAM     THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
       2570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2580-TRSFR-MVNT-FROM-ONSITE.                                   *        
      ******************************************************************        
      *                                                                         
       2580-TRSFR-MVNT-FROM-ONSITE.                                     
                                                                        
           IF WS-CALL-TYPE = WS-TRANSFER                                
              MOVE 7300                    TO RS-RETURN-CODE            
              MOVE EQ-CRNT-LOC-NO          TO RS-ADDITIONAL-MSG         
              PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 9999-END-PROGRAM     THRU 9999-EXIT               
           END-IF.                                                      
                                                                        
       2580-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-GET-EQUIPMENT-DETAILS                                     *        
      ******************************************************************        
      *                                                                         
       7000-GET-EQUIPMENT-DETAILS.                                      
      *                                                                         
            MOVE '7000'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       CODE_CRNT_LOC                                    
                      ,CRNT_LOC_NO                                      
                      ,DATE_LAST_MOVE                                   
                      ,EQUIP_COMMENTS_TX                                
                      ,LOCAL_OFFICE                                     
                      ,SERIAL_NO                                        
                  INTO                                                  
                       :EQ-CODE-CRNT-LOC                                
                      ,:EQ-CRNT-LOC-NO                                  
                      ,:EQ-DATE-LAST-MOVE                               
                      ,:EQ-EQUIP-COMMENTS-TX                            
                      ,:EQ-LOCAL-OFFICE                                 
                      ,:EQ-SERIAL-NO                                    
                  FROM                                                  
                       CSS_EQUIPMENT WITH(READUNCOMMITTED)                      
                 WHERE                                                  
                       COMPANY_NO     = :EQ-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                   AND DEVICE_NO      = :EQ-DEVICE-NO                   
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                CODE_CRNT_LOC                                            
MFA-TR*               ,CRNT_LOC_NO                                              
MFA-TR*               ,DATE_LAST_MOVE                                           
MFA-TR*               ,EQUIP_COMMENTS_TX                                        
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,SERIAL_NO                                                
MFA-TR*           INTO                                                          
MFA-TR*                :EQ-CODE-CRNT-LOC                                        
MFA-TR*               ,:EQ-CRNT-LOC-NO                                          
MFA-TR*               ,:EQ-DATE-LAST-MOVE                                       
MFA-TR*               ,:EQ-EQUIP-COMMENTS-TX                                    
MFA-TR*               ,:EQ-LOCAL-OFFICE                                         
MFA-TR*               ,:EQ-SERIAL-NO                                            
MFA-TR*           FROM                                                          
MFA-TR*                CSS_EQUIPMENT                                            
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO     = :EQ-COMPANY-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                      
MFA-TR*            AND DEVICE_NO      = :EQ-DEVICE-NO                           
MFA-TR*           WITH UR                                                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7020-GET-METER-ATTCH-DTLS                                      *        
      ******************************************************************        
      *                                                                         
       7020-GET-METER-ATTCH-DTLS.                                       
      *                                                                         
            MOVE '7020'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-MTR-ATTCH-EXISTS                             
                  FROM                                                  
                       CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)              
                      ,CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)              
                 WHERE                                                  
                       MA.COMPANY_NO     = :MA-COMPANY-NO               
                   AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           
                   AND MA.METER_NO       = :MA-METER-NO                 
                   AND LX.COMPANY_NO     = MA.COMPANY_NO                
                   AND LX.CODE_UTIL_TYPE = MA.CODE_UTIL_TYPE            
                   AND LX.DEVICE_NO      = MA.DEVICE_NO                 
                   AND LX.CODE_ATT_TYPE  = MA.CODE_ATT_TYPE             
                                                    
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-MTR-ATTCH-EXISTS                                     
MFA-TR*           FROM                                                          
MFA-TR*                CSS_METER_ATTCHMTS MA                                    
MFA-TR*               ,CSS_EQUIP_ATTCHMTS LX                                    
MFA-TR*          WHERE                                                          
MFA-TR*                MA.COMPANY_NO     = :MA-COMPANY-NO                       
MFA-TR*            AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                   
MFA-TR*            AND MA.METER_NO       = :MA-METER-NO                         
MFA-TR*            AND LX.COMPANY_NO     = MA.COMPANY_NO                        
MFA-TR*            AND LX.CODE_UTIL_TYPE = MA.CODE_UTIL_TYPE                    
MFA-TR*            AND LX.DEVICE_NO      = MA.DEVICE_NO                         
MFA-TR*            AND LX.CODE_ATT_TYPE  = MA.CODE_ATT_TYPE                     
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7060-OPEN-MOVMNT-HIST-CUR.                                     *        
      ******************************************************************        
      *                                                                         
       7060-OPEN-MOVMNT-HIST-CUR.                                       
      *                                                                         
            MOVE '7060'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN MOVMNT_HIST_CUR                                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'MOVMNT_HIST_CUR'     TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE MV-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MV-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MV-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7064-FETCH-MOVMNT-HIST-CUR.                                    *        
      ******************************************************************        
      *                                                                         
       7064-FETCH-MOVMNT-HIST-CUR.                                      
      *                                                                         
            MOVE '7064'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                      MOVMNT_HIST_CUR                                   
                 INTO                                                   
                      :MV-CODE-CRNT-LOC                                 
                     ,:MV-DATE-MOVE                                     
                                                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'MOVMNT_HIST_CUR'     TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE MV-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MV-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MV-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7064-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7068-CLOSE-MOVMNT-HIST-CUR.                                    *        
      ******************************************************************        
      *                                                                         
       7068-CLOSE-MOVMNT-HIST-CUR.                                      
      *                                                                         
            MOVE '7068'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               CLOSE MOVMNT_HIST_CUR                                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'MOVMNT_HIST_CUR'     TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE MV-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MV-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MV-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7068-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7080-GET-COUNT-GAS-MTR-TEST.                                   *        
      ******************************************************************        
      *                                                                         
       7080-GET-COUNT-GAS-MTR-TEST.                                     
      *                                                                         
            MOVE '7080'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       COUNT(*)                                         
                  INTO                                                  
                       :WS-NUM-TEST-RECORDS                             
                  FROM                                                  
                       CSS_GAS_MTR_TEST WITH(READUNCOMMITTED)                   
                 WHERE                                                  
                       COMPANY_NO       = :GT-COMPANY-NO                
                   AND CODE_UTIL_TYPE   = :GT-CODE-UTIL-TYPE            
                   AND METER_NO         = :GT-METER-NO                  
                   AND DATE_TEST        > IIF(TRY_CONVERT(DATE, 
                                                     :WS-GT-DATE-TEST-1
              ) IS NULL OR (PATINDEX('%.%', :WS-GT-DATE-TEST-1
              ) <> 0) OR (LEN(:WS-GT-DATE-TEST-1
              ) <> 10), CIS.CHAR2DATE(:WS-GT-DATE-TEST-1
              ), CONVERT(DATE, :WS-GT-DATE-TEST-1) )            
                   AND DATE_TEST        < IIF(TRY_CONVERT(DATE, 
                                                     :WS-GT-DATE-TEST-2
              ) IS NULL OR (PATINDEX('%.%', :WS-GT-DATE-TEST-2
              ) <> 0) OR (LEN(:WS-GT-DATE-TEST-2
              ) <> 10), CIS.CHAR2DATE(:WS-GT-DATE-TEST-2
              ), CONVERT(DATE, :WS-GT-DATE-TEST-2) )            
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                COUNT(*)                                                 
MFA-TR*           INTO                                                          
MFA-TR*                :WS-NUM-TEST-RECORDS                                     
MFA-TR*           FROM                                                          
MFA-TR*                CSS_GAS_MTR_TEST                                         
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO       = :GT-COMPANY-NO                        
MFA-TR*            AND CODE_UTIL_TYPE   = :GT-CODE-UTIL-TYPE                    
MFA-TR*            AND METER_NO         = :GT-METER-NO                          
MFA-TR*            AND DATE_TEST        > :WS-GT-DATE-TEST-1                    
MFA-TR*            AND DATE_TEST        < :WS-GT-DATE-TEST-2                    
MFA-TR*           WITH UR                                                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GAS_MTR_TEST'    TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE GT-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE GT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE GT-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7120-CHECK-MTR-ATT-TYPE.                                       *        
      ******************************************************************        
      *                                                                         
       7120-CHECK-MTR-ATT-TYPE.                                         
      *                                                                         
            MOVE '7120'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       'Y'                                              
                  INTO                                                  
                       :WS-MTR-ATT-TYPE-EXISTS                          
                  FROM                                                  
                       CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)              
                      ,CSS_MTR_ATT_TYPE   N5 WITH(READUNCOMMITTED)              
                 WHERE                                                  
                       MA.METER_NO         = :MA-METER-NO               
                   AND MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE         
                   AND MA.COMPANY_NO       = :MA-COMPANY-NO             
                   AND N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE          
                   AND N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE           
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-MTR-ATT-TYPE-EXISTS                                  
MFA-TR*           FROM                                                          
MFA-TR*                CSS_METER_ATTCHMTS MA                                    
MFA-TR*               ,CSS_MTR_ATT_TYPE   N5                                    
MFA-TR*          WHERE                                                          
MFA-TR*                MA.METER_NO         = :MA-METER-NO                       
MFA-TR*            AND MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                 
MFA-TR*            AND MA.COMPANY_NO       = :MA-COMPANY-NO                     
MFA-TR*            AND N5.CODE_UTIL_TYPE   = MA.CODE_UTIL_TYPE                  
MFA-TR*            AND N5.CODE_ATT_TYPE    = MA.CODE_ATT_TYPE                   
MFA-TR*           WITH UR                                                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7160-GET-CURRENT-TIMESTAMP                                     *        
      ******************************************************************        
      *                                                                         
       7160-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
            MOVE '7160'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SET'                 TO ABEND-FUNCTION             
               MOVE 'SYSDUMMY1'           TO TABLE-1                    
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7160-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
