       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04225.                                         
COB303 DATE-WRITTEN.  JAN 15 2009.                                      
       DATE-COMPILED.                                                   
      *                                                                 00000500
      ******************************************************************00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      *                                                                *00001000
      ******************************************************************00001100
      *                 P R O G R A M  S U M M A R Y                   *00001200
      *                                                                *00001300
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR TRANSFORMER    *00001400
      *  TRANSFER AND MOVEMENT SCREENS                                 *00001500
      *                                                                *00001600
      ******************************************************************00001700
      *                                                                *00001800
      *                     PROGRAM MODIFICATION LOG                   *00001900
      *                                                                *00002000
      *    DATE    INITIALS   COMMENTS                                 *00002100
      *  --------  --------   ---------------------------------------  *00002200
      *  01/15/09  DK98653    INITIAL VERSION.                         *00002300
      *                                                                *00002400
      ******************************************************************00002500
      ******************************************************************00002600
      *                                                                *00002700
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00002800
      *                                                                *00002900
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00003000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00003100
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00003200
      *  3000 - 4999  NOT USED                                         *00003300
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00003400
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00003500
      *  7000 - 7999  INPUT MODULES                                    *00003600
      *  8000 - 8999  OUTPUT MODULES                                   *00003700
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00003800
      *                                                                *00003900
      ******************************************************************00004000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04225'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************00004600
      *    WORK AREAS                                                  *00004700
      ******************************************************************00004800
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04225 STARTS HERE'.                  
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-WORK-FIELDS.                                              
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
           05  WS-DATE-DISPOSED-IND    PIC S9(1)  COMP VALUE 0.         
           05  WS-DATE-LAST-MOVE-IND   PIC S9(1)  COMP VALUE 0.         
           05  WS-SELECT-VAL           PIC X(01)  VALUE SPACES.         
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04225'.     
                                                                        
           05  WS-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.         
           05  WS-COMPANY-NO           PIC X(02)  VALUE SPACES.         
           05  WS-DEVICE-NO            PIC X(09)  VALUE SPACES.         
           05  WS-SERIAL-NO            PIC X(11)  VALUE SPACES.         
           05  WS-MOVE-DATE            PIC X(10)  VALUE SPACES.         
           05  WS-EQUIP-LOC-ID         PIC X(01)  VALUE SPACES.         
           05  WS-MSF-CD               PIC X(03)  VALUE SPACES.         
                                                                        
           05  WS-DEVICE-TYPE-XFORMER  PIC X(01)  VALUE 'T'.            
                                                                        
                                                                        
      *************************THIS IS THE ROW RETURN AREA**************00008500
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
           05  S-ADDITIONAL-MSG        PIC X(30)  VALUE SPACES          
                                                  JUSTIFIED RIGHT.      
                                                                        
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW            PIC X(01)  VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-MET-LOCATION-CUR     PIC X(01)  VALUE SPACES.         
               88  WS-LOC-INVENTORY-CUR           VALUE 'A'.            
               88  WS-LOC-RETIRE-CUR              VALUE 'I'.            
               88  WS-LOC-METER-SHOP-CUR          VALUE 'B'.            
               88  WS-LOC-UNKNOWN-CUR             VALUE 'U'.            
               88  WS-LOC-EMPLOYEE-CUR            VALUE 'C'.            
               88  WS-LOC-AT-CUSTOMER-CUR         VALUE 'J'.            
               88  WS-LOC-ATTACHED-CUR            VALUE 'K'.            
               88  WS-LOC-OLD-ACCT-CUR            VALUE 'X'.            
                                                                        
           05  WS-MET-LOCATION-NEW     PIC X(01)  VALUE SPACES.         
               88  WS-LOC-INVENTORY-NEW           VALUE 'A'.            
               88  WS-LOC-RETIRE-NEW              VALUE 'I'.            
               88  WS-LOC-METER-SHOP-NEW          VALUE 'B'.            
               88  WS-LOC-UNKNOWN-NEW             VALUE 'U'.            
               88  WS-LOC-EMPLOYEE-NEW            VALUE 'C'.            
               88  WS-LOC-AT-CUSTOMER-NEW         VALUE 'J'.            
               88  WS-LOC-ATTACHED-NEW            VALUE 'K'.            
               88  WS-LOC-OLD-ACCT-NEW            VALUE 'X'.            
                                                                        
           05  WS-CALL-TYPE            PIC X(01)  VALUE SPACES.         
               88 WS-MOVEMENT                     VALUE 'M'.            
               88 WS-TRANSFER                     VALUE 'T'.            
      ******************************************************************00009800
      * DB2 INCLUDES                                                   *00009900
      ******************************************************************00010000
           EXEC SQL                                                     00010100
              INCLUDE SQLCA                                             00010200
           END-EXEC.                                                    00010300
                                                                        
      **************************************************************    00010500
      * CSS_EQUIPMENT  - EQ                                             00010600
      **************************************************************    00010700
           EXEC SQL                                                     00010800
              INCLUDE TBEQUIP                                           00010900
           END-EXEC.                                                    00011000
      *                                                                *00011100
      ******************************************************************00011200
      *CSS_MOVEMENT_HIST, MV                                           *00011300
      ******************************************************************00011400
           EXEC SQL                                                     00011500
              INCLUDE TBMVHIST                                          00011600
           END-EXEC.                                                    00011700
      *                                                                 00011800
                                                                        
      ******************************************************************00012000
           COPY CWS00303.                                               00012100
                                                                        
           EXEC SQL                                                     00012300
              INCLUDE CWSX0010                                          00012400
           END-EXEC.                                                    00012500
                                                                        
      *                                                                 00012700
HPCCDM*EJECT                                                            00012800
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                 00013100
       01 PARM-CALL-TYPE               PIC X(01).                       
       01 PARM-CODE-UTIL-TYPE          PIC X(01).                       
       01 PARM-COMPANY-NO              PIC X(02).                       
       01 PARM-DEVICE-NO               PIC X(09).                       
       01 PARM-SERIAL-NO               PIC X(11).                       
       01 PARM-MOVE-DATE               PIC X(10).                       
       01 PARM-EQUIP-LOC-ID            PIC X(01).                       
       01 PARM-MSF-CD                  PIC X(03).                       
      *                                                                 00014000
       PROCEDURE DIVISION USING  PARM-CALL-TYPE                         
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-COMPANY-NO                        
                                 PARM-DEVICE-NO                         
                                 PARM-SERIAL-NO                         
                                 PARM-MOVE-DATE                         
                                 PARM-EQUIP-LOC-ID                      
                                 PARM-MSF-CD.                           
                                                                        
                                                                        
      ******************************************************************00015100
      * 0000-MAINLINE                                                  *00015200
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00015300
      ******************************************************************00015400
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00016400
      ******************************************************************00016500
      * 0100-INITIALIZE                                                *00016600
      *                                                                *00016700
      ******************************************************************00016800
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE     AS RETURN_CODE                      
                ,:S-ADDITIONAL-MSG  AS ADDITIONAL_MESSAGE               
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     00017500
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         00017600
MFA-TR*       SELECT                                                    00017700
MFA-TR*          :S-RETURN-CODE     AS RETURN_CODE                      00017800
MFA-TR*         ,:S-ADDITIONAL-MSG  AS ADDITIONAL_MESSAGE               00017900
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                     00018000
MFA-TR*    END-EXEC.                                                    00018100
                                                                        
           PERFORM 7100-SELECT-DATE-TIME THRU 7100-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00018700
      ******************************************************************00018800
      * 1000-PROCESS-INPUT                                             *00018900
      *                                                                *00019000
      ******************************************************************00019100
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE PARM-CALL-TYPE          TO  WS-CALL-TYPE.               
           MOVE PARM-CODE-UTIL-TYPE     TO  WS-CODE-UTIL-TYPE.          
           MOVE PARM-COMPANY-NO         TO  WS-COMPANY-NO.              
           MOVE PARM-DEVICE-NO          TO  WS-DEVICE-NO.               
           MOVE PARM-SERIAL-NO          TO  WS-SERIAL-NO.               
           MOVE PARM-MOVE-DATE          TO  WS-MOVE-DATE.               
           MOVE PARM-EQUIP-LOC-ID       TO  WS-EQUIP-LOC-ID.            
           MOVE PARM-MSF-CD             TO  WS-MSF-CD.                  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00020700
      * 1200-VALIDATE-INPUT-ARGUMENTS.                                 *00020800
      ******************************************************************00020900
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF (PARM-CALL-TYPE  NOT = 'M' AND                            
               PARM-CALL-TYPE  NOT = 'T')  OR                           
              PARM-CODE-UTIL-TYPE = SPACES OR                           
              PARM-COMPANY-NO     = SPACES OR                           
              PARM-DEVICE-NO      = SPACES OR                           
              PARM-MSF-CD         = SPACES                              
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-2          
              MOVE 'PARM-DEVICE-NO'         TO TABLE-ELEMENT-3          
              MOVE 'PARM-CALL-TYPE'         TO TABLE-ELEMENT-4          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-2        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-3        
              MOVE PARM-CALL-TYPE           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00024000
      ******************************************************************00024100
      * 2000-PROCESS-OUTPUT.                                           *00024200
      *                                                                *00024300
      ******************************************************************00024400
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-PROCESS-EQUIP-VAL     THRU 2100-EXIT.           
           PERFORM 2200-PROCESS-INS-MOVE-HIST THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00027300
      *2100-PROCESS-EQUIP-VAL                                          *00027400
      ******************************************************************00027500
       2100-PROCESS-EQUIP-VAL.                                          
                                                                        
           IF WS-MOVE-DATE > WS-CURRENT-DATE                            
              ADD 1     TO CTR-ROWS                                     
              MOVE 5500 TO S-RETURN-CODE                                
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
           MOVE WS-COMPANY-NO                    TO  EQ-COMPANY-NO.     
           MOVE WS-CODE-UTIL-TYPE                TO  EQ-CODE-UTIL-TYPE. 
           MOVE WS-DEVICE-NO                     TO  EQ-DEVICE-NO.      
           PERFORM  7500-SELECT-EQUIPMENT        THRU 7500-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              ADD 1     TO CTR-ROWS                                     
              MOVE 6200 TO S-RETURN-CODE                                
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF                                                       
                                                                        
                                                                        
           IF WS-MOVE-DATE < EQ-DATE-LAST-MOVE                          
              ADD 1     TO CTR-ROWS                                     
              MOVE 5600 TO S-RETURN-CODE                                
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-SERIAL-NO NOT EQUAL TO EQ-SERIAL-NO                    
              ADD 1     TO CTR-ROWS                                     
              MOVE 5100 TO S-RETURN-CODE                                
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
           MOVE EQ-CODE-CRNT-LOC             TO  WS-MET-LOCATION-CUR.   
           MOVE WS-EQUIP-LOC-ID              TO  WS-MET-LOCATION-NEW.   
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-LOC-INVENTORY-CUR                                 
                    PERFORM   2110-CRNT-LOC-INVENTORY   THRU 2110-EXIT  
              WHEN WS-LOC-METER-SHOP-CUR                                
                    PERFORM   2120-CRNT-LOC-METERSHOP   THRU 2120-EXIT  
                                                                        
              WHEN WS-LOC-EMPLOYEE-CUR                                  
              WHEN WS-LOC-RETIRE-CUR                                    
                    PERFORM   2130-CRNT-LOC-EMPL-RETIRE THRU 2130-EXIT  
                                                                        
              WHEN WS-LOC-AT-CUSTOMER-CUR                               
              WHEN WS-LOC-ATTACHED-CUR                                  
                    ADD 1                          TO CTR-ROWS          
                    MOVE 5400                      TO S-RETURN-CODE     
                    MOVE EQ-CRNT-LOC-NO            TO S-ADDITIONAL-MSG  
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                                                                        
              WHEN WS-LOC-UNKNOWN-CUR                                   
              WHEN WS-LOC-OLD-ACCT-CUR                                  
                    PERFORM   2160-CRNT-LOC-OLDACCT     THRU 2160-EXIT  
                                                                        
              WHEN OTHER                                                
                    ADD 1                          TO CTR-ROWS          
                    MOVE 5800                      TO S-RETURN-CODE     
                    MOVE EQ-LOCAL-OFFICE           TO S-ADDITIONAL-MSG  
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                                                                        
           END-EVALUATE.                                                
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00047801
      * 2110-CRNT-LOC-INVENTORY                                        *00047802
      ******************************************************************00047803
       2110-CRNT-LOC-INVENTORY.                                         
           EVALUATE TRUE                                                
              WHEN WS-LOC-INVENTORY-NEW                                 
      *          'CHECK DIFF LOC OFF (2134)                             00047830
                 IF EQ-LOCAL-OFFICE = WS-MSF-CD                         
                    ADD 1     TO CTR-ROWS                               
                    MOVE 5200 TO S-RETURN-CODE                          
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                 END-IF                                                 
              WHEN WS-LOC-RETIRE-NEW                                    
      *          'CHECK SAME LOC OFF (2132)                             00047891
                 IF EQ-LOCAL-OFFICE NOT EQUAL TO WS-MSF-CD              
                    ADD 1     TO CTR-ROWS                               
                    MOVE 5300 TO S-RETURN-CODE                          
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                 END-IF                                                 
              WHEN WS-LOC-METER-SHOP-NEW                                
              WHEN WS-LOC-UNKNOWN-NEW                                   
              WHEN WS-LOC-EMPLOYEE-NEW                                  
                 CONTINUE                                               
              WHEN OTHER                                                
                 ADD 1     TO CTR-ROWS                                  
                 MOVE 5400 TO S-RETURN-CODE                             
                 MOVE EQ-LOCAL-OFFICE      TO  S-ADDITIONAL-MSG         
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
           END-EVALUATE.                                                
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00047912
      ******************************************************************00047913
      * 2120-CRNT-LOC-METERSHOP                                        *00047914
      ******************************************************************00047915
       2120-CRNT-LOC-METERSHOP.                                         
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-LOC-METER-SHOP-NEW                                
      *          'CHECK DIFF LOC OFF (2134)                             00047920
                 IF EQ-LOCAL-OFFICE = WS-MSF-CD                         
                    ADD 1     TO CTR-ROWS                               
                    MOVE 5200 TO S-RETURN-CODE                          
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                 END-IF                                                 
              WHEN WS-LOC-RETIRE-NEW                                    
      *          'CHECK SAME LOC OFF (2132)                             00047927
                 IF EQ-LOCAL-OFFICE NOT EQUAL TO WS-MSF-CD              
                    ADD 1     TO CTR-ROWS                               
                    MOVE 5300 TO S-RETURN-CODE                          
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                 END-IF                                                 
                                                                        
              WHEN WS-LOC-INVENTORY-NEW                                 
              WHEN WS-LOC-UNKNOWN-NEW                                   
              WHEN WS-LOC-EMPLOYEE-NEW                                  
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 ADD 1     TO CTR-ROWS                                  
                 MOVE 5400 TO S-RETURN-CODE                             
                 MOVE EQ-LOCAL-OFFICE      TO  S-ADDITIONAL-MSG         
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
           END-EVALUATE.                                                
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00047947
      ******************************************************************00047948
      *2130-CRNT-LOC-EMPL-RETIRE                                       *00047949
      ******************************************************************00047950
       2130-CRNT-LOC-EMPL-RETIRE.                                       
           EVALUATE TRUE                                                
              WHEN WS-LOC-INVENTORY-NEW                                 
              WHEN WS-LOC-METER-SHOP-NEW                                
      *          'CHECK SAME LOC OFF (2132)                             00047961
                 IF EQ-LOCAL-OFFICE NOT EQUAL TO WS-MSF-CD              
                    ADD 1     TO CTR-ROWS                               
                    MOVE 5300 TO S-RETURN-CODE                          
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                 END-IF                                                 
              WHEN WS-LOC-UNKNOWN-NEW                                   
                 CONTINUE                                               
              WHEN OTHER                                                
                 ADD 1        TO CTR-ROWS                               
                 MOVE 5400    TO S-RETURN-CODE                          
                 IF WS-LOC-EMPLOYEE-CUR                                 
                    MOVE EQ-LOCAL-OFFICE      TO  S-ADDITIONAL-MSG      
                 END-IF                                                 
                 PERFORM 9999-END-PROGRAM     THRU 9999-EXIT            
           END-EVALUATE.                                                
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00047981
      *                                                                 00047993
      *                                                                 00048012
      ******************************************************************00048013
      * 2160-CRNT-LOC-OLDACCT                                          *00048014
      ******************************************************************00048015
       2160-CRNT-LOC-OLDACCT.                                           
                                                                        
           IF WS-LOC-INVENTORY-NEW  OR                                  
              WS-LOC-METER-SHOP-NEW OR                                  
              WS-LOC-EMPLOYEE-NEW   OR                                  
              WS-LOC-RETIRE-NEW     OR                                  
              (WS-LOC-OLD-ACCT-CUR AND WS-LOC-UNKNOWN-NEW)              
              CONTINUE                                                  
           ELSE                                                         
              ADD 1     TO CTR-ROWS                                     
              MOVE 5400 TO S-RETURN-CODE                                
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
       2160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00048042
      ******************************************************************00048043
      *2200-PROCESS-INS-MOVE-HIST                                      *00048050
      ******************************************************************00048100
       2200-PROCESS-INS-MOVE-HIST.                                      
                                                                        
           MOVE WS-DEVICE-TYPE-XFORMER       TO MV-CODE-DEVICE-TYPE.    
                                                                        
           MOVE WS-CODE-UTIL-TYPE            TO MV-CODE-UTIL-TYPE       
                                                EQ-CODE-UTIL-TYPE.      
           MOVE WS-DEVICE-NO                 TO MV-DEVICE-NO            
                                                EQ-DEVICE-NO.           
           MOVE EQ-DATE-LAST-MOVE            TO MV-DATE-MOVE.           
           MOVE WS-MOVE-DATE                 TO EQ-DATE-LAST-MOVE.      
           MOVE EQ-LOCAL-OFFICE              TO MV-LOCAL-OFFICE.        
           MOVE WS-COMPANY-NO                TO MV-COMPANY-NO           
                                                EQ-COMPANY-NO.          
           MOVE EQ-CRNT-LOC-NO               TO MV-LOC-NO.              
           MOVE WS-CURRENT-TIMESTAMP         TO MV-MOVE-NO.             
           MOVE EQ-CODE-CRNT-LOC             TO MV-CODE-CRNT-LOC.       
           MOVE WS-MSF-CD                    TO EQ-LOCAL-OFFICE.        
           MOVE WS-CURRENT-DATE              TO EQ-DATE-LAST-TRAN.      
           MOVE WS-EQUIP-LOC-ID              TO EQ-CODE-CRNT-LOC.       
                                                                        
           PERFORM 8200-INSERT-IN-MV         THRU 8200-EXIT.            
                                                                        
           IF WS-LOC-RETIRE-NEW                                         
                                                                        
              MOVE WS-MOVE-DATE              TO EQ-DATE-DISPOSED-OF     
              IF EQ-DATE-DISPOSED-OF EQUAL SPACES                       
                 MOVE -1                     TO WS-DATE-DISPOSED-IND    
              ELSE                                                      
                 MOVE 0                      TO WS-DATE-DISPOSED-IND    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF EQ-DATE-LAST-MOVE      EQUAL SPACES                       
              MOVE -1                        TO WS-DATE-LAST-MOVE-IND   
           END-IF.                                                      
           PERFORM 8300-UPDATE-EQUIP         THRU 8300-EXIT.            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00052800
      *7100-SELECT-DATE-TIME                                           *00052900
      ******************************************************************00053000
       7100-SELECT-DATE-TIME.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00053300
MFA-TR*       SET :WS-CURRENT-DATE        = CURRENT DATE                00053400
MFA-TR*          ,:WS-CURRENT-TIMESTAMP   = CURRENT TIMESTAMP           00053500
MFA-TR*    END-EXEC.                                                    00053600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7100'             TO ACTIVE-PARAGRAPH              
               MOVE 'SET'              TO ABEND-FUNCTION                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00055200
                                                                        
      ******************************************************************00059200
      *7500-SELECT-EQUIPMENT        - QUERY3                           *00059300
      ******************************************************************00059400
       7500-SELECT-EQUIPMENT.                                           
           EXEC SQL                                                     
               SELECT LOCAL_OFFICE                                      
                     ,CODE_CRNT_LOC                                     
                     ,SERIAL_NO                                         
                     ,CRNT_LOC_NO                                       
                     ,DATE_LAST_MOVE                                    
                     ,EQUIP_COMMENTS_TX                                 
                     ,DATE_DISPOSED_OF                                  
               INTO  :EQ-LOCAL-OFFICE                                   
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-SERIAL-NO                                      
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND           
                    ,:EQ-EQUIP-COMMENTS-TX                              
                    ,:EQ-DATE-DISPOSED-OF :WS-DATE-DISPOSED-IND          
               FROM                                                     
                    CSS_EQUIPMENT WITH(READUNCOMMITTED)                         
               WHERE COMPANY_NO       = :EQ-COMPANY-NO                  
                 AND CODE_UTIL_TYPE   = :EQ-CODE-UTIL-TYPE              
                 AND DEVICE_NO        = :EQ-DEVICE-NO                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00059600
MFA-TR*        SELECT LOCAL_OFFICE                                      00059700
MFA-TR*              ,CODE_CRNT_LOC                                     00059800
MFA-TR*              ,SERIAL_NO                                         00059900
MFA-TR*              ,CRNT_LOC_NO                                       00060000
MFA-TR*              ,DATE_LAST_MOVE                                    00060100
MFA-TR*              ,EQUIP_COMMENTS_TX                                 00060200
MFA-TR*              ,DATE_DISPOSED_OF                                  00060210
MFA-TR*        INTO  :EQ-LOCAL-OFFICE                                   00060300
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                  00060400
MFA-TR*             ,:EQ-SERIAL-NO                                      00060500
MFA-TR*             ,:EQ-CRNT-LOC-NO                                    00060600
MFA-TR*             ,:EQ-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-IND           00060700
MFA-TR*             ,:EQ-EQUIP-COMMENTS-TX                              00060800
MFA-TR*             ,:EQ-DATE-DISPOSED-OF:WS-DATE-DISPOSED-IND          00060810
MFA-TR*        FROM                                                     00060900
MFA-TR*             CSS_EQUIPMENT                                       00061000
MFA-TR*        WHERE COMPANY_NO       = :EQ-COMPANY-NO                  00061100
MFA-TR*          AND CODE_UTIL_TYPE   = :EQ-CODE-UTIL-TYPE              00061200
MFA-TR*          AND DEVICE_NO        = :EQ-DEVICE-NO                   00061300
MFA-TR*        WITH UR                                                  00061400
MFA-TR*    END-EXEC.                                                    00061500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 00063900
      ******************************************************************00064000
      * 8200-INSERT-IN-MV              - QUERY4                        *00064100
      ******************************************************************00064200
       8200-INSERT-IN-MV.                                               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MOVEMENT_HIST                             
              (                                                         
               CODE_DEVICE_TYPE                                         
              ,CODE_UTIL_TYPE                                           
              ,DEVICE_NO                                                
              ,DATE_MOVE                                                
              ,LOCAL_OFFICE                                             
              ,COMPANY_NO                                               
              ,LOC_NO                                                   
              ,MOVE_NO                                                  
              ,CODE_CRNT_LOC                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :MV-CODE-DEVICE-TYPE                                     
              ,:MV-CODE-UTIL-TYPE                                       
              ,:MV-DEVICE-NO                                            
              ,IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                                
              ,:MV-LOCAL-OFFICE                                         
              ,:MV-COMPANY-NO                                           
              ,:MV-LOC-NO                                               
              ,CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)                                  
              ,:MV-CODE-CRNT-LOC                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00064500
MFA-TR*       INSERT INTO CSS_MOVEMENT_HIST                             00064600
MFA-TR*       (                                                         00064700
MFA-TR*        CODE_DEVICE_TYPE                                         00064800
MFA-TR*       ,CODE_UTIL_TYPE                                           00064900
MFA-TR*       ,DEVICE_NO                                                00065000
MFA-TR*       ,DATE_MOVE                                                00065100
MFA-TR*       ,LOCAL_OFFICE                                             00065200
MFA-TR*       ,COMPANY_NO                                               00065300
MFA-TR*       ,LOC_NO                                                   00065400
MFA-TR*       ,MOVE_NO                                                  00065500
MFA-TR*       ,CODE_CRNT_LOC                                            00065600
MFA-TR*       )                                                         00065700
MFA-TR*       VALUES                                                    00065800
MFA-TR*       (                                                         00065900
MFA-TR*        :MV-CODE-DEVICE-TYPE                                     00066000
MFA-TR*       ,:MV-CODE-UTIL-TYPE                                       00066100
MFA-TR*       ,:MV-DEVICE-NO                                            00066200
MFA-TR*       ,:MV-DATE-MOVE                                            00066300
MFA-TR*       ,:MV-LOCAL-OFFICE                                         00066400
MFA-TR*       ,:MV-COMPANY-NO                                           00066500
MFA-TR*       ,:MV-LOC-NO                                               00066600
MFA-TR*       ,:MV-MOVE-NO                                              00066700
MFA-TR*       ,:MV-CODE-CRNT-LOC                                        00066800
MFA-TR*       )                                                         00066900
MFA-TR*    END-EXEC.                                                    00067000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD 1                        TO CTR-ROWS                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_MOVEMENT_HIST'     TO TABLE-1                  
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-2          
               MOVE 'DATE_MOVE'             TO TABLE-ELEMENT-3          
               MOVE 'MOVE_NO'               TO TABLE-ELEMENT-4          
               MOVE MV-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
               MOVE MV-DEVICE-NO            TO HOSTVAR-ELEMENT-2        
               MOVE MV-DATE-MOVE            TO HOSTVAR-ELEMENT-3        
               MOVE MV-MOVE-NO              TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************00069800
      * 8300-UPDATE-EQUIP               - QUERY5                       *00069900
      ******************************************************************00070000
       8300-UPDATE-EQUIP.                                               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
              SET                                                       
               CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                      
              ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC                    
              ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                     
              ,DATE_LAST_TRAN    = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN) )                   
              ,DATE_LAST_MOVE    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-LAST-MOVE 
                                                 :WS-DATE-LAST-MOVE-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                                 :WS-DATE-LAST-MOVE-IND
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                                 :WS-DATE-LAST-MOVE-IND
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                                 :WS-DATE-LAST-MOVE-IND
              ) )               
              ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX                
              ,DATE_DISPOSED_OF  = IIF(TRY_CONVERT(DATE, 
                                                  :EQ-DATE-DISPOSED-OF 
                                                  :WS-DATE-DISPOSED-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-DISPOSED-OF 
                                                  :WS-DATE-DISPOSED-IND
              ) <> 0) OR (LEN(:EQ-DATE-DISPOSED-OF 
                                                  :WS-DATE-DISPOSED-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-DISPOSED-OF 
                                                  :WS-DATE-DISPOSED-IND
              ), CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                                  :WS-DATE-DISPOSED-IND
              ) )                
              WHERE                                                     
                  COMPANY_NO     = :EQ-COMPANY-NO                       
              AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                   
              AND DEVICE_NO      = :EQ-DEVICE-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00070300
MFA-TR*       UPDATE CSS_EQUIPMENT                                      00070400
MFA-TR*       SET                                                       00070500
MFA-TR*        CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                      00070600
MFA-TR*       ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC                    00070700
MFA-TR*       ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                     00070800
MFA-TR*       ,DATE_LAST_TRAN    = :EQ-DATE-LAST-TRAN                   00070900
MFA-TR*       ,DATE_LAST_MOVE    = :EQ-DATE-LAST-MOVE                   00071000
MFA-TR*                            :WS-DATE-LAST-MOVE-IND               00071010
MFA-TR*       ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX                00071100
MFA-TR*       ,DATE_DISPOSED_OF  = :EQ-DATE-DISPOSED-OF                 00071200
MFA-TR*                            :WS-DATE-DISPOSED-IND                00071300
MFA-TR*       WHERE                                                     00071400
MFA-TR*           COMPANY_NO     = :EQ-COMPANY-NO                       00071500
MFA-TR*       AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                   00071600
MFA-TR*       AND DEVICE_NO      = :EQ-DEVICE-NO                        00071800
MFA-TR*    END-EXEC.                                                    00071900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD 1                        TO CTR-ROWS                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
                                                                        
       8300-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ***************************************************************** 00079400
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     * 00079500
      ***************************************************************** 00079600
           EXEC SQL                                                     00079700
              INCLUDE CPDSP300                                          00079800
           END-EXEC.                                                    00079900
                                                                        
           EXEC SQL                                                     00080600
              INCLUDE CPD00321                                          00080700
           END-EXEC.                                                    00080800
