       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04224.                                         
COB303 DATE-WRITTEN.  FEB 02 2009.                                      
       DATE-COMPILED.                                                   
      *                                                                 00050024
      ******************************************************************00060024
      *                                                                *00070024
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080024
      *                                                                *00090024
      *                                                                *00100024
      ******************************************************************00110024
      *                 P R O G R A M  S U M M A R Y                   *00120024
      *                                                                *00130024
      * UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC        *00140024
      * METER EQUIPMENT TEST SCREENS WHICH UPDATE,ADD OR DELETE        *00150024
      * ELECTRIC METER TEST DETAILS.                                   *00160024
      *                                                                *00160025
      ******************************************************************00170024
      *                                                                *00180024
      *                     PROGRAM MODIFICATION LOG                   *00190024
      *                                                                *00200024
      *    DATE    INITIALS   COMMENTS                                 *00210024
      *  --------  --------   ---------------------------------------  *00220024
      *  01/20/09  MH94819    INITIAL VERSION.                         *00230024
      *  06/22/09  SV85244    REMOVED RETURN CODE 6300 PER SUE'S EMAIL *00240024
A04860** 03/04/16  MR7E794    REPLACE CSS_WQ_ITEMS_MF WITH             *        
A04860**           ACT072     CSS_WQ_ITEMS.                            *        
      ******************************************************************00250024
      ******************************************************************00260024
      *                                                                *00270024
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00280024
      *                                                                *00290024
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00300024
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00310024
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00320024
      *  3000 - 4999  NOT USED                                         *00330024
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00340024
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00350024
      *  7000 - 7999  INPUT MODULES                                    *00360024
      *  8000 - 8999  OUTPUT MODULES                                   *00370024
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00380024
      *                                                                *00390024
      ******************************************************************00400024
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04224'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04218 STARTS HERE'.                  
                                                                        
      ******************************************************************01380024
      * WORK AREAS                                                     *01390024
      ******************************************************************01400024
                                                                        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
      *****************************PARM FIELDS**************************01520024
                                                                        
       01  WORK-FIELDS.                                                 
           05  WS-SELECT-VAL           PIC S9(1)  COMP VALUE 0.         
           05  WS-TRIAL-TEXT           PIC X(250) VALUE SPACES.         
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-DATE-TEST            PIC X(10)  VALUE SPACES.         
           05  WS-DATE-LAST-TESTED     PIC X(10)  VALUE SPACES.         
           05  WS-LAST-TEST-SEL-DT.                                     
               10 WS-SEL-DT-YYYY       PIC X(04).                       
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-SEL-DT-MM         PIC X(02).                       
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-SEL-DT-DD         PIC X(02).                       
           05  WS-LAST-TEST-SEL-CD     PIC X(02)  VALUE SPACES.         
           05  WS-TEST-GROUP-CODE      PIC X(02)  VALUE SPACES.         
           05  WS-INSTALL-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-PREMISE-NO           PIC S9(10)V USAGE COMP-3         
                                                  VALUE 0.              
           05  WS-TESTED-QTY           PIC S9(9) USAGE COMP VALUE 0.    
           05  WS-STATUS-CD            PIC X(01)  VALUE SPACES.         
           05  WS-TEST-YEAR            PIC X(04)  VALUE SPACES.         
           05  WS-TEST-SCHED-CD        PIC X(01)  VALUE SPACES.         
           05  WS-ACCURACY             PIC S9(3)V9(3) USAGE COMP-3      
                                                  VALUE 0.              
ACT072     05  WS-INPUT-TS.                                             
ACT072         10 WS-INPUT-DATE-PT     PIC X(10).                       
ACT072         10 WS-INPUT-TIME-PT     PIC X(16)  VALUE                 
ACT072                                           '-00.00.00.000000'.    
       01  WS-NULL-INDICATORS.                                          
           05  WS-EQ-INSTALL-DATE-IND     PIC S9(04) COMP VALUE 0.      
           05  WS-EM-DATE-LAST-T-IND      PIC S9(04) COMP VALUE 0.      
           05  WS-EM-LAST-T-SEL-DT-IND    PIC S9(04) COMP VALUE 0.      
           05  WS-MV-LOC-NO-IND           PIC S9(04) COMP VALUE 0.      
           05  WS-ET-DATE-TEST-IND        PIC S9(04) COMP VALUE 0.      
                                                                        
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-IS-SCH-AREA-NULL     PIC X(01) VALUE 'Y'.             
           05  WS-IS-GRP-AREA-NULL     PIC X(01) VALUE 'Y'.             
                                                                        
       01  WS-PROGRAM.                                                  
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04224'.     
ACT072     05  MCSCB077                PIC X(08)  VALUE 'MCSCB077'.     
ACT072 01  WS-MCSCB077-OUTPUT.                                          
ACT072     05  WS-MCSCB077-RET-CODE    PIC S9(04) COMP VALUE 0.         
                                                                        
       01  WS-INPUT.                                                    
           05  WS-IN-UPDATE-IND          PIC X(01)  VALUE SPACES.       
           05  WS-IN-CODE-REPAIR         PIC X(01)  VALUE SPACES.       
           05  WS-IN-CODE-TEST-LOC       PIC X(01)  VALUE SPACES.       
           05  WS-IN-CODE-TEST-TYPE      PIC X(01)  VALUE SPACES.       
           05  WS-IN-CODE-UTIL-TYPE      PIC X(01)  VALUE SPACES.       
           05  WS-IN-COMPANY-NO          PIC X(02)  VALUE SPACES.       
           05  WS-IN-DATE-TEST           PIC X(10)  VALUE SPACES.       
           05  WS-IN-DEM-READ-AF         PIC S9(8)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-DEM-READ-AL         PIC S9(8)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-EQ-TESTER-ID        PIC X(5)   VALUE SPACES.       
           05  WS-IN-FULL-LOAD-ACCU-AF   PIC S9(3)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-FULL-LOAD-ACCU-AL   PIC S9(3)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-IN-CONSTANT         PIC S9(6)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-LIGHT-LOAD-ACCU-AF  PIC S9(3)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-LIGHT-LOAD-ACCU-AL  PIC S9(3)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-METER-NO            PIC X(09)  VALUE SPACES.       
           05  WS-IN-POWER-FCTR-ACCU-AF  PIC S9(3)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-POWER-FCTR-ACCU-AL  PIC S9(3)V9(3) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-READ-AF             PIC S9(11)V USAGE COMP-3       
                                                    VALUE 0.            
           05  WS-IN-REPAIR-DESC         PIC X(44)  VALUE SPACES.       
           05  WS-IN-TEST-BENCH-ID       PIC X(06)  VALUE SPACES.       
           05  WS-IN-TIME-TEST           PIC X(08)  VALUE SPACES.       
           05  WS-IN-SERIAL-NO           PIC X(11)  VALUE SPACES.       
           05  WS-IN-READ-AL             PIC S9(11)V USAGE COMP-3       
                                                    VALUE 0.            
           05  WS-IN-USER-ID             PIC X(07)  VALUE SPACES.       
           05  WS-IN-COMMENTS.                                          
               49 WS-IN-COMMENTS-LEN      PIC S9(4) USAGE COMP          
                                                    VALUE 0.            
               49 WS-IN-COMMENTS-TEXT     PIC X(250) VALUE SPACES.      
                                                                        
       01  WS-CONSTANTS.                                                
           05  WS-DEFAULT-CAP-TYPE     PIC X(01)  VALUE 'A'.            
           05  WS-TEST-SCHEDULE-RANDOM PIC X(01)  VALUE 'R'.            
           05  WS-DEFAULT-TIME-PERIOD  PIC S9(4) USAGE COMP VALUE 0.    
           05  WS-DEFAULT-TEST-RESULT  PIC X(01)  VALUE 'A'.            
           05  WS-ACCURACY-THRESHHOLD  PIC S9(3)V9(3) USAGE COMP-3      
                                                  VALUE 102.            
           05  WS-LOC-AT-CUSTOMER      PIC X(01)  VALUE 'J'.            
           05  WS-STATUS-C             PIC X(01)  VALUE 'C'.            
           05  WS-STATUS-B             PIC X(01)  VALUE 'B'.            
           05  WS-STATUS-D             PIC X(01)  VALUE 'D'.            
                                                                        
                                                                        
      **************************THIS IS THE ROW RETURN AREA*************02520024
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-INFO-RETURN-CODE     PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
           05  S-INFO-RETURN-CODE      PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-CONST-FLAG           PIC X(01) VALUE 'N'.             
               88 WS-CONST-CHANGED               VALUE 'Y'.             
               88 WS-CONST-NOCHANGED             VALUE 'N'.             
                                                                        
      ******************************************************************02860025
      * DB2 INCLUDES                                                   *02860026
      ******************************************************************02860027
           EXEC SQL                                                     02860028
              INCLUDE SQLCA                                             02860029
           END-EXEC.                                                    02860030
                                                                        
      ******************************************************************02860050
      * CSS_EQUIPMENT  - EQ                                            *02860060
      ******************************************************************02860070
           EXEC SQL                                                     02860080
              INCLUDE TBEQUIP                                           02860090
           END-EXEC.                                                    02860100
                                                                        
      *                                                                *02860300
      ******************************************************************02860400
      *CSS_ACCOUNT    - AT                                             *02860500
      ******************************************************************02860600
           EXEC SQL                                                     02860700
              INCLUDE TBACCT                                            02860800
           END-EXEC.                                                    02860900
      *                                                                 02861000
                                                                        
      ******************************************************************02861200
      *CSS_CUST_PREM_HIST  - CH                                        *02861300
      ******************************************************************02861400
           EXEC SQL                                                     02861500
              INCLUDE TBCSTPRM                                          02861600
           END-EXEC.                                                    02861700
      *                                                                 02861800
                                                                        
      ******************************************************************02862000
      *CSS_ELEC_METER    - EM                                          *02862100
      ******************************************************************02862200
           EXEC SQL                                                     02862300
              INCLUDE TBELMTR                                           02862400
           END-EXEC.                                                    02862500
      *                                                                 02862600
                                                                        
      ******************************************************************02862800
      *CSS_MTR_CAP     - MC                                            *02862900
      ******************************************************************02863000
           EXEC SQL                                                     02863100
              INCLUDE TBMTRCAP                                          02863200
           END-EXEC.                                                    02863300
      *                                                                 02863400
                                                                        
      ******************************************************************02863600
      *CSS_ELEC_MTR_TEST  - ET                                         *02863700
      ******************************************************************02863800
           EXEC SQL                                                     02863900
              INCLUDE TBEMTEST                                          02864000
           END-EXEC.                                                    02864100
      *                                                                 02864200
                                                                        
      ******************************************************************02864400
      *CSS_MTR_TEST_HIST   - MQ                                        *02864500
      ******************************************************************02864600
           EXEC SQL                                                     02864700
              INCLUDE TBMTRTST                                          02864800
           END-EXEC.                                                    02864900
      *                                                                 02865000
                                                                        
      ******************************************************************02865200
      *CSS_MOVEMENT_HIST   - MV                                        *02865300
      ******************************************************************02865400
           EXEC SQL                                                     02865500
              INCLUDE TBMVHIST                                          02865600
           END-EXEC.                                                    02865700
      *                                                                 02865800
      ******************************************************************02866700
      *    COBOL WORKING STORAGE COPY BOOKS                            *02866800
      ******************************************************************02866900
                                                                        
           COPY CWS00303.                                               02867100
                                                                        
           EXEC SQL                                                     02867300
              INCLUDE CWSX0010                                          02867400
           END-EXEC.                                                    02867500
ACT072*                                                                 02867600
ACT072******************************************************************        
ACT072* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
ACT072******************************************************************        
ACT072*                                                                         
ACT072     EXEC SQL                                                             
ACT072        INCLUDE CWS00077                                                  
ACT072     END-EXEC.                                                            
ACT072*                                                                         
                                                                        
      *                                                                 02880024
HPCCDM*EJECT                                                            02890024
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                 02920024
       01 PARM-IN-UPDATE-IND                PIC X(01).                  
       01 PARM-IN-CODE-REPAIR               PIC X(01).                  
       01 PARM-IN-CODE-TEST-LOC             PIC X(01).                  
       01 PARM-IN-CODE-TEST-TYPE            PIC X(01).                  
       01 PARM-IN-CODE-UTIL-TYPE            PIC X(01).                  
       01 PARM-IN-COMPANY-NO                PIC X(02).                  
       01 PARM-IN-DATE-TEST                 PIC X(10).                  
COB305 01 PARM-IN-DEM-READ-AF        PIC S9(8)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
COB305 01 PARM-IN-DEM-READ-AL        PIC S9(8)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
       01 PARM-IN-EQ-TESTER-ID              PIC X(5).                   
COB305 01 PARM-IN-FULL-LOAD-ACCU-AF        PIC S9(3)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
COB305 01 PARM-IN-FULL-LOAD-ACCU-AL        PIC S9(3)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
COB305 01 PARM-IN-IN-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
COB305 01 PARM-IN-LIGHT-LOAD-ACCU-AF        PIC S9(3)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
COB305 01 PARM-IN-LIGHT-LOAD-ACCU-AL        PIC S9(3)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
       01 PARM-IN-METER-NO                  PIC X(09).                  
COB305 01 PARM-IN-POWER-FCTR-ACCU-AF        PIC S9(3)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
COB305 01 PARM-IN-POWER-FCTR-ACCU-AL        PIC S9(3)V9(3) USAGE COMP-3 
COB305       VALUE 0.
                                                                        
COB305 01 PARM-IN-READ-AF        PIC S9(11)V USAGE COMP-3 VALUE 0.   
                                                                        
       01 PARM-IN-REPAIR-DESC               PIC X(44).                  
       01 PARM-IN-TEST-BENCH-ID             PIC X(06).                  
       01 PARM-IN-TIME-TEST                 PIC X(08).                  
       01 PARM-IN-SERIAL-NO                 PIC X(11).                  
COB305 01 PARM-IN-READ-AL        PIC S9(11)V USAGE COMP-3 VALUE 0.   
                                                                        
       01 PARM-IN-USER-ID                   PIC X(07).                  
       01 PARM-IN-COMMENTS                  PIC X(250).                 
                                                                        
                                                                        
       PROCEDURE DIVISION USING  PARM-IN-UPDATE-IND                     
                                ,PARM-IN-CODE-REPAIR                    
                                ,PARM-IN-CODE-TEST-LOC                  
                                ,PARM-IN-CODE-TEST-TYPE                 
                                ,PARM-IN-CODE-UTIL-TYPE                 
                                ,PARM-IN-COMPANY-NO                     
                                ,PARM-IN-DATE-TEST                      
                                ,PARM-IN-DEM-READ-AF                    
                                ,PARM-IN-DEM-READ-AL                    
                                ,PARM-IN-EQ-TESTER-ID                   
                                ,PARM-IN-FULL-LOAD-ACCU-AF              
                                ,PARM-IN-FULL-LOAD-ACCU-AL              
                                ,PARM-IN-IN-CONSTANT                    
                                ,PARM-IN-LIGHT-LOAD-ACCU-AF             
                                ,PARM-IN-LIGHT-LOAD-ACCU-AL             
                                ,PARM-IN-METER-NO                       
                                ,PARM-IN-POWER-FCTR-ACCU-AF             
                                ,PARM-IN-POWER-FCTR-ACCU-AL             
                                ,PARM-IN-READ-AF                        
                                ,PARM-IN-REPAIR-DESC                    
                                ,PARM-IN-TEST-BENCH-ID                  
                                ,PARM-IN-TIME-TEST                      
                                ,PARM-IN-SERIAL-NO                      
                                ,PARM-IN-READ-AL                        
                                ,PARM-IN-USER-ID                        
                                ,PARM-IN-COMMENTS.                      
                                                                        
      ******************************************************************03620024
      * 0000-MAINLINE                                                  *03630024
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03640024
      ******************************************************************03650024
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03750024
      ******************************************************************03760024
      * 0100-INITIALIZE                                                *03770024
      *                                                                *03780024
      ******************************************************************03790024
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE      AS RETURN_CODE                     
                ,:S-INFO-RETURN-CODE AS INFO_RETURN_CODE                
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     03860024
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         03870024
MFA-TR*       SELECT                                                    03880024
MFA-TR*          :S-RETURN-CODE      AS RETURN_CODE                     03890027
MFA-TR*         ,:S-INFO-RETURN-CODE AS INFO_RETURN_CODE                03891027
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                     03900024
MFA-TR*    END-EXEC.                                                    03910024
                                                                        
           PERFORM 7000-SELECT-CURR-DATE THRU 7000-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03970024
      ******************************************************************03980024
      * 1000-PROCESS-INPUT                                             *03990024
      *                                                                *04000024
      ******************************************************************04010024
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-IN-UPDATE-IND         TO  WS-IN-UPDATE-IND.        
           MOVE PARM-IN-CODE-REPAIR        TO  WS-IN-CODE-REPAIR.       
           MOVE PARM-IN-CODE-TEST-LOC      TO  WS-IN-CODE-TEST-LOC.     
           MOVE PARM-IN-CODE-TEST-TYPE     TO  WS-IN-CODE-TEST-TYPE.    
           MOVE PARM-IN-CODE-UTIL-TYPE     TO  WS-IN-CODE-UTIL-TYPE.    
           MOVE PARM-IN-COMPANY-NO         TO  WS-IN-COMPANY-NO.        
           MOVE PARM-IN-DATE-TEST          TO  WS-IN-DATE-TEST.         
           MOVE PARM-IN-DEM-READ-AF        TO  WS-IN-DEM-READ-AF.       
           MOVE PARM-IN-DEM-READ-AL        TO  WS-IN-DEM-READ-AL.       
           MOVE PARM-IN-EQ-TESTER-ID       TO  WS-IN-EQ-TESTER-ID.      
           MOVE PARM-IN-FULL-LOAD-ACCU-AF  TO  WS-IN-FULL-LOAD-ACCU-AF. 
           MOVE PARM-IN-FULL-LOAD-ACCU-AL  TO  WS-IN-FULL-LOAD-ACCU-AL. 
           MOVE PARM-IN-IN-CONSTANT        TO  WS-IN-IN-CONSTANT.       
           MOVE PARM-IN-LIGHT-LOAD-ACCU-AF TO  WS-IN-LIGHT-LOAD-ACCU-AF.
           MOVE PARM-IN-LIGHT-LOAD-ACCU-AL TO  WS-IN-LIGHT-LOAD-ACCU-AL.
           MOVE PARM-IN-METER-NO           TO  WS-IN-METER-NO.          
           MOVE PARM-IN-POWER-FCTR-ACCU-AF TO  WS-IN-POWER-FCTR-ACCU-AF.
           MOVE PARM-IN-POWER-FCTR-ACCU-AL TO  WS-IN-POWER-FCTR-ACCU-AL.
           MOVE PARM-IN-READ-AF            TO  WS-IN-READ-AF.           
           MOVE PARM-IN-REPAIR-DESC        TO  WS-IN-REPAIR-DESC.       
           MOVE PARM-IN-TEST-BENCH-ID      TO  WS-IN-TEST-BENCH-ID.     
           MOVE PARM-IN-TIME-TEST          TO  WS-IN-TIME-TEST.         
           MOVE PARM-IN-SERIAL-NO          TO  WS-IN-SERIAL-NO.         
           MOVE PARM-IN-READ-AL            TO  WS-IN-READ-AL.           
           MOVE PARM-IN-USER-ID            TO  WS-IN-USER-ID.           
           IF PARM-IN-COMMENTS > SPACES                                 
              PERFORM 1000A-CALCULATE-LENGTH     THRU 1000A-EXIT        
           END-IF.                                                      
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04331030
      * 1000A-CALCULATE-LENGTH                                         *04332030
      *                                                                *04333030
      ******************************************************************04334030
       1000A-CALCULATE-LENGTH.                                          
           MOVE PARM-IN-COMMENTS           TO WS-TRIAL-TEXT.            
           UNSTRING WS-TRIAL-TEXT DELIMITED BY '  ' INTO                
                    WS-IN-COMMENTS-TEXT                                 
                    COUNT IN WS-IN-COMMENTS-LEN.                        
                                                                        
       1000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04339431
      * 1200-VALIDATE-INPUT-ARGUMENTS                                  *04339432
      ******************************************************************04339433
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
           IF PARM-IN-CODE-UTIL-TYPE = SPACES                           
              MOVE 9998                      TO WS-ACTIVE-RETURN-CODE   
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'VALIDATE'                TO ABEND-FUNCTION          
              MOVE 'PARM-IN-CODE-UTIL-TYPE'  TO TABLE-1                 
              MOVE 'PARM-IN-CODE-UTIL-TYPE'  TO TABLE-ELEMENT-1         
              MOVE PARM-IN-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                                                                        
           IF PARM-IN-COMPANY-NO = SPACES                               
              MOVE 9997                 TO WS-ACTIVE-RETURN-CODE        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '1200'               TO ACTIVE-PARAGRAPH             
              MOVE 'VALIDATE'           TO ABEND-FUNCTION               
              MOVE 'PARM-IN-COMPANY-NO' TO TABLE-1                      
              MOVE 'PARM-IN-COMPANY-NO' TO TABLE-ELEMENT-1              
              MOVE PARM-IN-COMPANY-NO   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                .                                                       
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 04339470
      ******************************************************************04340024
      * 2000-PROCESS-OUTPUT.                                           *04350024
      *                                                                *04360024
      ******************************************************************04370024
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-IN-CODE-UTIL-TYPE NOT EQUAL TO 'E'                     
              MOVE 6200                      TO RS-RETURN-CODE          
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-IN-UPDATE-IND = 'I'                                    
              PERFORM 2100-PROCESS-IND-I      THRU 2100-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-IN-UPDATE-IND = 'D'                                    
              PERFORM 2200-PROCESS-IND-D      THRU 2200-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-IN-UPDATE-IND = 'U'                                    
              PERFORM 2300-PROCESS-IND-U      THRU 2300-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04611027
      *2000A-MOVE-RESULT                                               *04612027
      ******************************************************************04613027
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
           MOVE RS-INFO-RETURN-CODE      TO S-INFO-RETURN-CODE.         
           ADD +1                        TO CTR-ROWS.                   
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04620024
      *2100-PROCESS-IND-I                                              *04630024
      ******************************************************************04640024
       2100-PROCESS-IND-I.                                              
                                                                        
           PERFORM 2400-PERFORM-ELCMTR-VAL      THRU 2400-EXIT.         
                                                                        
           MOVE WS-IN-COMPANY-NO          TO ET-COMPANY-NO.             
           MOVE WS-IN-CODE-UTIL-TYPE      TO ET-CODE-UTIL-TYPE.         
           MOVE WS-IN-METER-NO            TO ET-METER-NO.               
           MOVE WS-IN-DATE-TEST           TO ET-DATE-TEST.              
           PERFORM 7800-SELECT-ELEC-MTR-TEST    THRU 7800-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-IN-DATE-TEST < ET-DATE-TEST                         
                 MOVE 5400                      TO RS-RETURN-CODE       
                 PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
              ELSE                                                      
                 IF WS-IN-DATE-TEST = ET-DATE-TEST  AND                 
                                       WS-IN-TIME-TEST <= ET-TIME-TEST  
                       MOVE 5500                      TO RS-RETURN-CODE 
                       PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT   
                       PERFORM 9999-END-PROGRAM       THRU 9999-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-IN-COMPANY-NO           TO MC-COMPANY-NO.            
           MOVE WS-IN-CODE-UTIL-TYPE       TO MC-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO MC-METER-NO.              
           PERFORM 7400-SELECT-CSS-MTR-CAP      THRU 7400-EXIT.         
                                                                        
           IF MC-CONSTANT NOT EQUAL TO WS-IN-IN-CONSTANT                
              SET WS-CONST-CHANGED   TO TRUE                            
           END-IF.                                                      
                                                                        
           PERFORM 2500-PERFORM-DEL-ELECMTR     THRU 2500-EXIT.         
                                                                        
           MOVE WS-CURRENT-DATE            TO EQ-DATE-LAST-TRAN.        
           MOVE WS-IN-CODE-UTIL-TYPE       TO EQ-CODE-UTIL-TYPE.        
           MOVE WS-IN-COMPANY-NO           TO EQ-COMPANY-NO.            
           PERFORM 8100-UPDATE-CSS-EQUIP        THRU 8100-EXIT.         
                                                                        
           MOVE WS-IN-DATE-TEST            TO WS-DATE-TEST.             
           MOVE WS-DATE-TEST               TO EM-DATE-LAST-TESTED.      
           MOVE WS-IN-COMPANY-NO           TO EM-COMPANY-NO.            
           MOVE WS-IN-CODE-UTIL-TYPE       TO EM-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO EM-METER-NO.              
           PERFORM 8500-UPDATE-ELEC-METER       THRU 8500-EXIT.         
           MOVE 0                          TO WS-EM-DATE-LAST-T-IND.    
                                                                        
           MOVE WS-DEFAULT-TIME-PERIOD     TO ET-CODE-TIME-PERIOD.      
           MOVE WS-DEFAULT-CAP-TYPE        TO ET-CODE-CAP-TYPE.         
           MOVE WS-DEFAULT-TEST-RESULT     TO ET-CODE-TEST-RESULT.      
           MOVE WS-IN-CODE-UTIL-TYPE       TO ET-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO ET-METER-NO.              
           MOVE WS-IN-DATE-TEST            TO ET-DATE-TEST.             
           MOVE WS-IN-TIME-TEST            TO ET-TIME-TEST.             
           MOVE WS-IN-CODE-REPAIR          TO ET-CODE-REPAIR.           
           MOVE WS-IN-REPAIR-DESC          TO ET-REPAIR-DESC.           
           MOVE WS-IN-CODE-TEST-TYPE       TO ET-CODE-TEST-TYPE.        
           MOVE WS-IN-CODE-TEST-LOC        TO ET-CODE-TEST-LOC.         
           MOVE WS-IN-IN-CONSTANT          TO ET-IN-CONSTANT.           
           MOVE WS-IN-READ-AF              TO ET-READ-AF.               
           MOVE WS-IN-DEM-READ-AF          TO ET-DEM-READ-AF.           
           MOVE WS-IN-LIGHT-LOAD-ACCU-AF   TO ET-LIGHT-LOAD-ACCU-AF.    
           MOVE WS-IN-FULL-LOAD-ACCU-AF    TO ET-FULL-LOAD-ACCU-AF.     
           MOVE WS-IN-LIGHT-LOAD-ACCU-AL   TO ET-LIGHT-LOAD-ACCU-AL.    
           MOVE WS-IN-FULL-LOAD-ACCU-AL    TO ET-FULL-LOAD-ACCU-AL.     
           MOVE WS-IN-POWER-FCTR-ACCU-AF   TO ET-POWER-FCTR-ACCU-AF.    
           MOVE WS-IN-POWER-FCTR-ACCU-AL   TO ET-POWER-FCTR-ACCU-AL.    
           MOVE WS-IN-EQ-TESTER-ID         TO ET-EQ-TESTER-ID.          
           MOVE WS-IN-TEST-BENCH-ID        TO ET-TEST-BENCH-ID.         
           MOVE WS-IN-READ-AL              TO ET-READ-AL.               
           MOVE WS-IN-COMPANY-NO           TO ET-COMPANY-NO.            
           MOVE WS-IN-DEM-READ-AL          TO ET-DEM-READ-AL.           
           PERFORM 8600-INSERT-ELEC-MTR-TEST    THRU 8600-EXIT.         
                                                                        
           COMPUTE WS-ACCURACY =                                        
                   ((4 * WS-IN-FULL-LOAD-ACCU-AL)                       
                                 + WS-IN-LIGHT-LOAD-ACCU-AL) / 5.       
           IF WS-ACCURACY > WS-ACCURACY-THRESHHOLD                      
              PERFORM 2600-PERFORM-INS-WQITEMS  THRU 2600-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-CONST-CHANGED                                          
              MOVE 6100                      TO RS-INFO-RETURN-CODE     
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           ELSE                                                         
              MOVE 0                         TO RS-RETURN-CODE          
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05740024
      *2200-PROCESS-IND-D                                              *05750024
      ******************************************************************05760024
       2200-PROCESS-IND-D.                                              
                                                                        
           PERFORM 2400-PERFORM-ELCMTR-VAL      THRU 2400-EXIT.         
                                                                        
           PERFORM 2500-PERFORM-DEL-ELECMTR     THRU 2500-EXIT.         
                                                                        
           MOVE WS-IN-COMPANY-NO           TO ET-COMPANY-NO.            
           MOVE WS-IN-CODE-UTIL-TYPE       TO ET-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO ET-METER-NO.              
           PERFORM 7700-SELECT-ELEC-MTR-TEST    THRU 7700-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-ET-DATE-TEST-IND = -1                               
                 MOVE WS-CURRENT-DATE     TO WS-DATE-TEST               
              ELSE                                                      
                 MOVE ET-DATE-TEST        TO WS-DATE-TEST               
              END-IF                                                    
           ELSE                                                         
              MOVE WS-CURRENT-DATE        TO WS-DATE-TEST               
           END-IF.                                                      
                                                                        
           MOVE WS-DATE-TEST               TO EM-DATE-LAST-TESTED.      
           MOVE WS-IN-COMPANY-NO           TO EM-COMPANY-NO.            
           MOVE WS-IN-CODE-UTIL-TYPE       TO EM-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO EM-METER-NO.              
           PERFORM 8500-UPDATE-ELEC-METER       THRU 8500-EXIT.         
                                                                        
           MOVE 0                        TO RS-RETURN-CODE.             
           PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT.              
           PERFORM 9999-END-PROGRAM       THRU 9999-EXIT.               
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06150024
      *2300-PROCESS-IND-U                                              *06160024
      ******************************************************************06170024
       2300-PROCESS-IND-U.                                              
                                                                        
           PERFORM 2400-PERFORM-ELCMTR-VAL      THRU 2400-EXIT.         
                                                                        
           MOVE WS-IN-COMPANY-NO           TO MC-COMPANY-NO.            
           MOVE WS-IN-CODE-UTIL-TYPE       TO MC-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO MC-METER-NO.              
           PERFORM 7400-SELECT-CSS-MTR-CAP      THRU 7400-EXIT.         
                                                                        
           IF MC-CONSTANT NOT EQUAL TO WS-IN-IN-CONSTANT                
              SET WS-CONST-CHANGED   TO TRUE                            
           END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-DATE            TO EQ-DATE-LAST-TRAN.        
           MOVE WS-IN-CODE-UTIL-TYPE       TO EQ-CODE-UTIL-TYPE.        
           MOVE WS-IN-COMPANY-NO           TO EQ-COMPANY-NO.            
           PERFORM 8100-UPDATE-CSS-EQUIP        THRU 8100-EXIT.         
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE       TO ET-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO ET-METER-NO.              
           MOVE WS-IN-DATE-TEST            TO ET-DATE-TEST.             
           MOVE WS-IN-TIME-TEST            TO ET-TIME-TEST.             
           MOVE WS-IN-CODE-REPAIR          TO ET-CODE-REPAIR.           
           MOVE WS-IN-REPAIR-DESC          TO ET-REPAIR-DESC.           
           MOVE WS-IN-CODE-TEST-TYPE       TO ET-CODE-TEST-TYPE.        
           MOVE WS-IN-CODE-TEST-LOC        TO ET-CODE-TEST-LOC.         
           MOVE WS-IN-IN-CONSTANT          TO ET-IN-CONSTANT.           
           MOVE WS-IN-READ-AF              TO ET-READ-AF.               
           MOVE WS-IN-DEM-READ-AF          TO ET-DEM-READ-AF.           
           MOVE WS-IN-LIGHT-LOAD-ACCU-AF   TO ET-LIGHT-LOAD-ACCU-AF.    
           MOVE WS-IN-FULL-LOAD-ACCU-AF    TO ET-FULL-LOAD-ACCU-AF.     
           MOVE WS-IN-LIGHT-LOAD-ACCU-AL   TO ET-LIGHT-LOAD-ACCU-AL.    
           MOVE WS-IN-FULL-LOAD-ACCU-AL    TO ET-FULL-LOAD-ACCU-AL.     
           MOVE WS-IN-POWER-FCTR-ACCU-AF   TO ET-POWER-FCTR-ACCU-AF.    
           MOVE WS-IN-POWER-FCTR-ACCU-AL   TO ET-POWER-FCTR-ACCU-AL.    
           MOVE WS-IN-EQ-TESTER-ID         TO ET-EQ-TESTER-ID.          
           MOVE WS-IN-TEST-BENCH-ID        TO ET-TEST-BENCH-ID.         
           MOVE WS-IN-COMPANY-NO           TO ET-COMPANY-NO.            
           MOVE WS-IN-DEM-READ-AL          TO ET-DEM-READ-AL.           
           PERFORM 8200-UPDATE-ELEC-MTR-TEST    THRU 8200-EXIT.         
                                                                        
           IF WS-CONST-CHANGED                                          
              MOVE 6100                      TO RS-INFO-RETURN-CODE     
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           ELSE                                                         
              MOVE 0                         TO RS-RETURN-CODE          
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06800024
      *2400-PERFORM-ELCMTR-VAL                                         *06810024
      ******************************************************************06820024
       2400-PERFORM-ELCMTR-VAL.                                         
                                                                        
           MOVE WS-IN-COMPANY-NO           TO EQ-COMPANY-NO.            
           MOVE WS-IN-CODE-UTIL-TYPE       TO EQ-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO EQ-DEVICE-NO.             
           PERFORM 7100-SELECT-CSS-EQUIPMENT    THRU 7100-EXIT.         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL TO SUCCESSFUL-CALL        
              MOVE 5100                      TO RS-RETURN-CODE          
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
           MOVE WS-IN-COMPANY-NO           TO EM-COMPANY-NO.            
           MOVE WS-IN-CODE-UTIL-TYPE       TO EM-CODE-UTIL-TYPE.        
           MOVE WS-IN-METER-NO             TO EM-METER-NO.              
           PERFORM 7300-SELECT-CSS-ELEC-METER   THRU 7300-EXIT.         
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL TO SUCCESSFUL-CALL        
              MOVE 5200                      TO RS-RETURN-CODE          
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
           IF EQ-SERIAL-NO NOT EQUAL TO WS-IN-SERIAL-NO                 
              MOVE 5300                      TO RS-RETURN-CODE          
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07200024
      *2500-PERFORM-DEL-ELECMTR                                        *07210024
      ******************************************************************07220024
       2500-PERFORM-DEL-ELECMTR.                                        
                                                                        
           IF WS-IN-UPDATE-IND = 'D'                                    
              MOVE WS-IN-COMPANY-NO           TO ET-COMPANY-NO          
              MOVE WS-IN-CODE-UTIL-TYPE       TO ET-CODE-UTIL-TYPE      
              MOVE WS-IN-METER-NO             TO ET-METER-NO            
              MOVE WS-IN-DATE-TEST            TO ET-DATE-TEST           
              MOVE WS-IN-TIME-TEST            TO ET-TIME-TEST           
              PERFORM 8300-DELETE-ELEC-MTR-TEST    THRU 8300-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-EM-DATE-LAST-T-IND = -1                                
              MOVE '0001-01-01'        TO WS-DATE-LAST-TESTED           
           ELSE                                                         
              MOVE EM-DATE-LAST-TESTED TO WS-DATE-LAST-TESTED           
           END-IF.                                                      
                                                                        
           IF WS-EM-LAST-T-SEL-DT-IND = -1                              
              MOVE '0001-01-01'        TO WS-LAST-TEST-SEL-DT           
           ELSE                                                         
              MOVE EM-LAST-TEST-SEL-DT TO WS-LAST-TEST-SEL-DT           
           END-IF.                                                      
                                                                        
           MOVE EM-LAST-TEST-SEL-CD    TO WS-LAST-TEST-SEL-CD.          
                                                                        
           IF ((WS-LAST-TEST-SEL-CD NOT EQUAL TO SPACES)                
               AND (WS-LAST-TEST-SEL-DT > WS-DATE-LAST-TESTED))         
              MOVE WS-LAST-TEST-SEL-DT        TO ET-DATE-TEST           
              MOVE WS-IN-COMPANY-NO           TO ET-COMPANY-NO          
              MOVE WS-IN-CODE-UTIL-TYPE       TO ET-CODE-UTIL-TYPE      
              MOVE WS-IN-METER-NO             TO ET-METER-NO            
              PERFORM 7500-SELECT-1-ELEC-MTR-TEST  THRU 7500-EXIT       
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE EM-TEST-SCHED-CD        TO WS-TEST-SCHED-CD       
                                                                        
                 IF WS-TEST-SCHED-CD = WS-TEST-SCHEDULE-RANDOM          
                    MOVE WS-LAST-TEST-SEL-CD  TO WS-TEST-GROUP-CODE     
                 ELSE                                                   
                    MOVE SPACES               TO WS-TEST-GROUP-CODE     
                 END-IF                                                 
                                                                        
                 MOVE WS-SEL-DT-YYYY          TO WS-TEST-YEAR           
                                                                        
                 IF WS-TEST-SCHED-CD NOT EQUAL TO SPACES                
                    MOVE 'N'                  TO WS-IS-SCH-AREA-NULL    
                 END-IF                                                 
                 IF WS-TEST-GROUP-CODE NOT EQUAL TO SPACES              
                    MOVE 'N'                  TO WS-IS-GRP-AREA-NULL    
                 END-IF                                                 
                 MOVE WS-TEST-SCHED-CD        TO MQ-TEST-SCHED-CD       
                 MOVE WS-TEST-GROUP-CODE      TO MQ-MTR-TEST-GRP-CD     
                 MOVE WS-TEST-YEAR            TO MQ-TEST-YEAR           
                 MOVE WS-IN-CODE-UTIL-TYPE    TO MQ-CODE-UTIL-TYPE      
                 MOVE WS-IN-COMPANY-NO        TO MQ-COMPANY-NO          
                 PERFORM 7600-SELECT-MTR-TEST-HIST THRU 7600-EXIT       
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2510-PERFORM-Q9-SUCCESS    THRU 2510-EXIT   
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07951027
      *2510-PERFORM-Q9-SUCCESS                                         *07952027
      ******************************************************************07953027
       2510-PERFORM-Q9-SUCCESS.                                         
                                                                        
           MOVE MQ-STATUS-CD              TO WS-STATUS-CD               
           IF WS-STATUS-CD = WS-STATUS-B                                
              MOVE WS-STATUS-C            TO WS-STATUS-CD               
           END-IF                                                       
                                                                        
                                                                        
           MOVE MQ-TESTED-QT                 TO WS-TESTED-QTY.          
           ADD 1                             TO WS-TESTED-QTY.          
                                                                        
           IF  ( EM-TEST-SCHED-CD NOT EQUAL TO WS-TEST-SCHEDULE-RANDOM  
                 AND  WS-TESTED-QTY >= MQ-SELECTED-QT )                 
               OR ( EM-TEST-SCHED-CD = WS-TEST-SCHEDULE-RANDOM          
                    AND  WS-TESTED-QTY >= MQ-SAMPLE-MIN-QT )            
              MOVE WS-STATUS-D               TO WS-STATUS-CD            
           END-IF.                                                      
                                                                        
           MOVE WS-TESTED-QTY             TO MQ-TESTED-QT.              
           MOVE WS-IN-COMPANY-NO          TO MQ-COMPANY-NO.             
           MOVE WS-IN-CODE-UTIL-TYPE      TO MQ-CODE-UTIL-TYPE.         
           MOVE WS-TEST-YEAR              TO MQ-TEST-YEAR.              
           MOVE WS-TEST-GROUP-CODE        TO MQ-MTR-TEST-GRP-CD.        
           MOVE EM-TEST-SCHED-CD          TO MQ-TEST-SCHED-CD.          
           PERFORM 8400-UPDATE-MTR-TEST-HIST    THRU 8400-EXIT.         
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07962024
      *2600-PERFORM-INS-WQITEMS                                        *07970024
      ******************************************************************07980024
       2600-PERFORM-INS-WQITEMS.                                        
                                                                        
           IF WS-EQ-INSTALL-DATE-IND = -1                               
              MOVE '0001-01-01'         TO WS-INSTALL-DATE              
           ELSE                                                         
              MOVE EQ-INSTALL-DT        TO WS-INSTALL-DATE              
           END-IF.                                                      
                                                                        
           IF EQ-CODE-CRNT-LOC = WS-LOC-AT-CUSTOMER  AND                
                               (WS-EQ-INSTALL-DATE-IND = -1 OR          
                                WS-IN-DATE-TEST > WS-INSTALL-DATE )     
              MOVE EQ-CRNT-LOC-NO        TO WS-PREMISE-NO               
           ELSE                                                         
              MOVE WS-IN-COMPANY-NO      TO MV-COMPANY-NO               
              MOVE WS-IN-CODE-UTIL-TYPE  TO MV-CODE-UTIL-TYPE           
              MOVE WS-IN-METER-NO     TO MV-DEVICE-NO                   
              MOVE WS-IN-DATE-TEST    TO MV-DATE-MOVE                   
              MOVE WS-LOC-AT-CUSTOMER TO MV-CODE-CRNT-LOC               
              PERFORM 7900-SELECT-MOVEMENT-HIST  THRU 7900-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
                                     WS-MV-LOC-NO-IND NOT EQUAL TO -1   
                 MOVE MV-LOC-NO TO WS-PREMISE-NO                        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-PREMISE-NO            TO CH-PREMISE-NO.              
           PERFORM 7200-SELECT-ACCT-AND-CH          THRU 7200-EXIT.     
ACT072     INITIALIZE CWS00077-FIELDS.                                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT072        MOVE CH-ACCOUNT-NO         TO WS-77-ACCOUNT-NO            
ACT072        MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO           
ACT072        MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE          
           ELSE                                                         
ACT072        MOVE 0                     TO WS-77-ACCOUNT-NO            
ACT072        MOVE 0                     TO WS-77-CUSTOMER-NO           
ACT072        MOVE SPACES                TO WS-77-LOCAL-OFFICE          
           END-IF.                                                      
                                                                        
ACT072     MOVE 0                     TO WS-77-SERV-ORDER-NO.           
ACT072     MOVE WS-CURRENT-DATE       TO WS-77-DATE-REQUIRED.           
ACT072     MOVE 133                   TO WS-77-CATEGORY-ID.             
ACT072     MOVE WS-PREMISE-NO         TO WS-77-PREMISE-NO.              
ACT072     MOVE WS-IN-USER-ID         TO WS-77-USER-ID-ORIG.            
ACT072     MOVE SPACES                TO WS-77-RESP-AREA-ID.            
ACT072     MOVE '4'                   TO WS-77-ROUTE-CATEGORY.          
ACT072     MOVE 'N'                   TO WS-77-PRIORITY.                
ACT072     MOVE WS-CURRENT-DATE       TO WS-INPUT-DATE-PT.              
ACT072     MOVE WS-INPUT-TS           TO WS-77-DATE-CREATED.            
ACT072     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY.              
ACT072     MOVE WS-IN-COMMENTS        TO WS-77-COMMENTS.                
ACT072     MOVE 0                     TO WS-77-FREE-FORM-LEN.           
ACT072     MOVE SPACES                TO WS-77-FREE-FORM-TXT.           
ACT072     PERFORM 8700-INSERT-CSS-WQ-ITEMS  THRU 8700-EXIT.            
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09000024
      *7000-SELECT-CURR-DATE                                           *09010024
      ******************************************************************09020024
       7000-SELECT-CURR-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     09050024
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                  09060024
MFA-TR*    END-EXEC.                                                    09080024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7000'             TO ACTIVE-PARAGRAPH              
               MOVE 'CUR.DATE'         TO ABEND-FUNCTION                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09260024
      *7100-SELECT-CSS-EQUIPMENT    - QUERY1                           *09270024
      ******************************************************************09280024
       7100-SELECT-CSS-EQUIPMENT.                                       
                                                                        
           EXEC SQL                                                     
               SELECT SERIAL_NO                                         
                      ,CODE_CRNT_LOC                                    
                      ,INSTALL_DT                                       
                      ,CRNT_LOC_NO                                      
                      ,DEVICE_NO                                        
                 INTO  :EQ-SERIAL-NO                                    
                      ,:EQ-CODE-CRNT-LOC                                
                      ,:EQ-INSTALL-DT :WS-EQ-INSTALL-DATE-IND           
                      ,:EQ-CRNT-LOC-NO                                  
                      ,:EQ-DEVICE-NO                                    
                 FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                       
                WHERE                                                   
                      COMPANY_NO      = :EQ-COMPANY-NO                  
                  AND CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE              
                  AND DEVICE_NO       = :EQ-DEVICE-NO                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09310024
MFA-TR*        SELECT SERIAL_NO                                         09320024
MFA-TR*               ,CODE_CRNT_LOC                                    09330024
MFA-TR*               ,INSTALL_DT                                       09340024
MFA-TR*               ,CRNT_LOC_NO                                      09350024
MFA-TR*               ,DEVICE_NO                                        09360024
MFA-TR*          INTO  :EQ-SERIAL-NO                                    09370024
MFA-TR*               ,:EQ-CODE-CRNT-LOC                                09380024
MFA-TR*               ,:EQ-INSTALL-DT :WS-EQ-INSTALL-DATE-IND           09390024
MFA-TR*               ,:EQ-CRNT-LOC-NO                                  09400024
MFA-TR*               ,:EQ-DEVICE-NO                                    09410024
MFA-TR*          FROM CSS_EQUIPMENT                                     09420024
MFA-TR*         WHERE                                                   09430024
MFA-TR*               COMPANY_NO      = :EQ-COMPANY-NO                  09440024
MFA-TR*           AND CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE              09450024
MFA-TR*           AND DEVICE_NO       = :EQ-DEVICE-NO                   09460024
MFA-TR*          WITH UR                                                09470024
MFA-TR*    END-EXEC.                                                    09480024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09530024
      *7200-SELECT-ACCT-AND-CH    - QUERY2                             *09540024
      ******************************************************************09550024
       7200-SELECT-ACCT-AND-CH.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CH.ACCOUNT_NO,
              AT.CUSTOMER_NO,
              AT.LOCAL_OFFICE                                  
                 INTO  :CH-ACCOUNT-NO                                   
                      ,:AT-CUSTOMER-NO                                  
                      ,:AT-LOCAL-OFFICE                                 
                 FROM  CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)              
                      ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)              
                WHERE                                                   
                      CH.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND CH.PREMISE_NO = :CH-PREMISE-NO                    
                ORDER BY CH.DATE_UTIL_SVC_STRT DESC                     
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09580024
MFA-TR*        SELECT CH.ACCOUNT_NO                                     09590024
MFA-TR*               ,AT.CUSTOMER_NO                                   09600024
MFA-TR*               ,AT.LOCAL_OFFICE                                  09610024
MFA-TR*          INTO  :CH-ACCOUNT-NO                                   09620024
MFA-TR*               ,:AT-CUSTOMER-NO                                  09630024
MFA-TR*               ,:AT-LOCAL-OFFICE                                 09640024
MFA-TR*          FROM  CSS_CUST_PREM_HIST CH                            09650024
MFA-TR*               ,CSS_ACCOUNT        AT                            09660024
MFA-TR*         WHERE                                                   09670024
MFA-TR*               CH.ACCOUNT_NO = AT.ACCOUNT_NO                     09680024
MFA-TR*           AND CH.PREMISE_NO = :CH-PREMISE-NO                    09690034
MFA-TR*         ORDER BY CH.DATE_UTIL_SVC_STRT DESC                     09700024
MFA-TR*         FETCH FIRST ROW ONLY                                    09710024
MFA-TR*          WITH UR                                                09720024
MFA-TR*    END-EXEC.                                                    09730024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CUST_PREM_HIST'    TO TABLE-1                  
               MOVE 'CSS_ACCOUNT'           TO TABLE-2                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE CH-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09791024
      *7300-SELECT-CSS-ELEC-METER     - QUERY3                         *09800024
      ******************************************************************09810024
       7300-SELECT-CSS-ELEC-METER.                                      
           EXEC SQL                                                     
               SELECT DATE_LAST_TESTED                                  
                     ,LAST_TEST_SEL_DT                                  
                     ,LAST_TEST_SEL_CD                                  
                     ,TEST_SCHED_CD                                     
                 INTO :EM-DATE-LAST-TESTED :WS-EM-DATE-LAST-T-IND       
                     ,:EM-LAST-TEST-SEL-DT :WS-EM-LAST-T-SEL-DT-IND     
                     ,:EM-LAST-TEST-SEL-CD                              
                     ,:EM-TEST-SCHED-CD                                 
                 FROM                                                   
                      CSS_ELEC_METER WITH(READUNCOMMITTED)                      
                WHERE COMPANY_NO       = :EM-COMPANY-NO                 
                  AND CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE             
                  AND METER_NO         = :EM-METER-NO                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09830024
MFA-TR*        SELECT DATE_LAST_TESTED                                  09840024
MFA-TR*              ,LAST_TEST_SEL_DT                                  09850024
MFA-TR*              ,LAST_TEST_SEL_CD                                  09860024
MFA-TR*              ,TEST_SCHED_CD                                     09870024
MFA-TR*          INTO :EM-DATE-LAST-TESTED :WS-EM-DATE-LAST-T-IND       09880024
MFA-TR*              ,:EM-LAST-TEST-SEL-DT :WS-EM-LAST-T-SEL-DT-IND     09890024
MFA-TR*              ,:EM-LAST-TEST-SEL-CD                              09900024
MFA-TR*              ,:EM-TEST-SCHED-CD                                 09910024
MFA-TR*          FROM                                                   09920024
MFA-TR*               CSS_ELEC_METER                                    09930024
MFA-TR*         WHERE COMPANY_NO       = :EM-COMPANY-NO                 09940036
MFA-TR*           AND CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE             09950036
MFA-TR*           AND METER_NO         = :EM-METER-NO                   09960036
MFA-TR*          WITH UR                                                09970024
MFA-TR*    END-EXEC.                                                    09980024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_METER'        TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EM-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10050024
      * 7400-SELECT-CSS-MTR-CAP        - QUERY4                        *10060024
      ******************************************************************10070024
       7400-SELECT-CSS-MTR-CAP.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CONSTANT                                           
                INTO :MC-CONSTANT                                       
                FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                          
               WHERE                                                    
                     COMPANY_NO     = :MC-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                
                 AND METER_NO       = :MC-METER-NO                      
               ORDER BY REG_ID_NO                                       
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10100024
MFA-TR*       SELECT CONSTANT                                           10110024
MFA-TR*         INTO :MC-CONSTANT                                       10120024
MFA-TR*         FROM CSS_MTR_CAP                                        10130024
MFA-TR*        WHERE                                                    10140024
MFA-TR*              COMPANY_NO     = :MC-COMPANY-NO                    10150024
MFA-TR*          AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                10160024
MFA-TR*          AND METER_NO       = :MC-METER-NO                      10170024
MFA-TR*        ORDER BY REG_ID_NO                                       10180024
MFA-TR*        FETCH FIRST ROW ONLY                                     10190024
MFA-TR*         WITH UR                                                 10200024
MFA-TR*    END-EXEC.                                                    10210024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_MTR_CAP'           TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE MC-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MC-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MC-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************10450024
      *7500-SELECT-1-ELEC-MTR-TEST     - QUERY8                        *10460024
      ******************************************************************10470024
       7500-SELECT-1-ELEC-MTR-TEST.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 1                                                  
                INTO  :WS-SELECT-VAL                                    
                FROM  CSS_ELEC_MTR_TEST WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     COMPANY_NO       = :ET-COMPANY-NO                  
                 AND CODE_UTIL_TYPE   = :ET-CODE-UTIL-TYPE              
                 AND METER_NO         = :ET-METER-NO                    
                 AND DATE_TEST       >= IIF(TRY_CONVERT(DATE, 
                                                          :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                   
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10500024
MFA-TR*       SELECT 1                                                  10510024
MFA-TR*         INTO  :WS-SELECT-VAL                                    10520024
MFA-TR*         FROM  CSS_ELEC_MTR_TEST                                 10530024
MFA-TR*        WHERE                                                    10540024
MFA-TR*              COMPANY_NO       = :ET-COMPANY-NO                  10550024
MFA-TR*          AND CODE_UTIL_TYPE   = :ET-CODE-UTIL-TYPE              10560024
MFA-TR*          AND METER_NO         = :ET-METER-NO                    10570024
MFA-TR*          AND DATE_TEST       >= :ET-DATE-TEST                   10580024
MFA-TR*        FETCH FIRST ROW ONLY                                     10590024
MFA-TR*         WITH UR                                                 10600024
MFA-TR*    END-EXEC.                                                    10610024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_MTR_TEST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'DATE_TEST'             TO TABLE-ELEMENT-4          
               MOVE ET-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE ET-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE ET-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE ET-DATE-TEST            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************10660024
      *7600-SELECT-MTR-TEST-HIST          - QUERY9                     *10670024
      ******************************************************************10680024
       7600-SELECT-MTR-TEST-HIST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                      MQ.SELECTED_QT                                    
                     ,MQ.STATUS_CD                                      
                     ,MQ.SAMPLE_MIN_QT                                  
                     ,MQ.TESTED_QT                                      
                INTO  :MQ-SELECTED-QT                                   
                     ,:MQ-STATUS-CD                                     
                     ,:MQ-SAMPLE-MIN-QT                                 
                     ,:MQ-TESTED-QT                                     
                FROM  CSS_MTR_TEST_HIST MQ WITH(READUNCOMMITTED)                
               WHERE MQ.COMPANY_NO     = :MQ-COMPANY-NO                 
                 AND MQ.CODE_UTIL_TYPE = :MQ-CODE-UTIL-TYPE             
                 AND MQ.TEST_YEAR      = :MQ-TEST-YEAR                  
                 AND ( :WS-IS-SCH-AREA-NULL     = 'Y'                   
                      OR ( :WS-IS-SCH-AREA-NULL = 'N'                   
                      AND MQ.TEST_SCHED_CD      = :MQ-TEST-SCHED-CD ))  
                 AND  ( :WS-IS-GRP-AREA-NULL    = 'Y'                   
                      OR ( :WS-IS-GRP-AREA-NULL = 'N'                   
                      AND MQ.MTR_TEST_GRP_CD    = :MQ-MTR-TEST-GRP-CD ))
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10710024
MFA-TR*       SELECT                                                    10720024
MFA-TR*               MQ.SELECTED_QT                                    10730035
MFA-TR*              ,MQ.STATUS_CD                                      10740035
MFA-TR*              ,MQ.SAMPLE_MIN_QT                                  10750035
MFA-TR*              ,MQ.TESTED_QT                                      10760035
MFA-TR*         INTO  :MQ-SELECTED-QT                                   10770024
MFA-TR*              ,:MQ-STATUS-CD                                     10780024
MFA-TR*              ,:MQ-SAMPLE-MIN-QT                                 10790024
MFA-TR*              ,:MQ-TESTED-QT                                     10800024
MFA-TR*         FROM  CSS_MTR_TEST_HIST MQ                              10810034
MFA-TR*        WHERE MQ.COMPANY_NO     = :MQ-COMPANY-NO                 10820034
MFA-TR*          AND MQ.CODE_UTIL_TYPE = :MQ-CODE-UTIL-TYPE             10830034
MFA-TR*          AND MQ.TEST_YEAR      = :MQ-TEST-YEAR                  10840034
MFA-TR*          AND ( :WS-IS-SCH-AREA-NULL     = 'Y'                   10850024
MFA-TR*               OR ( :WS-IS-SCH-AREA-NULL = 'N'                   10860024
MFA-TR*               AND MQ.TEST_SCHED_CD      = :MQ-TEST-SCHED-CD ))  10870037
MFA-TR*          AND  ( :WS-IS-GRP-AREA-NULL    = 'Y'                   10880024
MFA-TR*               OR ( :WS-IS-GRP-AREA-NULL = 'N'                   10890024
MFA-TR*               AND MQ.MTR_TEST_GRP_CD    = :MQ-MTR-TEST-GRP-CD ))10900037
MFA-TR*          WITH UR                                                10901032
MFA-TR*    END-EXEC.                                                    10910024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_MTR_TEST_HIST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'TEST_YEAR'             TO TABLE-ELEMENT-3          
               MOVE MQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MQ-TEST-YEAR            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************10960024
      *7700-SELECT-ELEC-MTR-TEST        - QUERY11                      *10970024
      ******************************************************************10980024
       7700-SELECT-ELEC-MTR-TEST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DATE_TEST                                          
                INTO :ET-DATE-TEST :WS-ET-DATE-TEST-IND                 
                FROM CSS_ELEC_MTR_TEST WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO     = :ET-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE                
                 AND METER_NO       = :ET-METER-NO                      
               ORDER BY DATE_TEST DESC, TIME_TEST DESC                  
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11010024
MFA-TR*       SELECT                                                    11020024
MFA-TR*              DATE_TEST                                          11030024
MFA-TR*         INTO :ET-DATE-TEST :WS-ET-DATE-TEST-IND                 11040024
MFA-TR*         FROM CSS_ELEC_MTR_TEST                                  11050024
MFA-TR*        WHERE COMPANY_NO     = :ET-COMPANY-NO                    11060024
MFA-TR*          AND CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE                11070024
MFA-TR*          AND METER_NO       = :ET-METER-NO                      11080024
MFA-TR*        ORDER BY DATE_TEST DESC, TIME_TEST DESC                  11090024
MFA-TR*        FETCH FIRST ROW ONLY                                     11100024
MFA-TR*         WITH UR                                                 11110024
MFA-TR*    END-EXEC.                                                    11120024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7700'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_MTR_TEST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE ET-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE ET-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE ET-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************11170024
      *7800-SELECT-ELEC-MTR-TEST              - QUERY13                *11180024
      ******************************************************************11190024
       7800-SELECT-ELEC-MTR-TEST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DATE_TEST,
              REPLACE(CONVERT(CHAR(8), TIME_TEST, 108), ':', '.') 
           TIME_TEST                                         
                INTO  :ET-DATE-TEST                                     
                     ,:ET-TIME-TEST                                     
                FROM  CSS_ELEC_MTR_TEST WITH(READUNCOMMITTED)                   
               WHERE COMPANY_NO     = :ET-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE                
                 AND METER_NO       = :ET-METER-NO                      
                 AND DATE_TEST     <= IIF(TRY_CONVERT(DATE, 
                                                          :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                     
               ORDER BY DATE_TEST DESC, TIME_TEST DESC                  
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     11220024
MFA-TR*       SELECT                                                    11230024
MFA-TR*               DATE_TEST                                         11240024
MFA-TR*              ,TIME_TEST                                         11250024
MFA-TR*         INTO  :ET-DATE-TEST                                     11260024
MFA-TR*              ,:ET-TIME-TEST                                     11270024
MFA-TR*         FROM  CSS_ELEC_MTR_TEST                                 11280024
MFA-TR*        WHERE COMPANY_NO     = :ET-COMPANY-NO                    11290024
MFA-TR*          AND CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE                11300024
MFA-TR*          AND METER_NO       = :ET-METER-NO                      11310024
MFA-TR*          AND DATE_TEST     <= :ET-DATE-TEST                     11320024
MFA-TR*        ORDER BY DATE_TEST DESC, TIME_TEST DESC                  11330024
MFA-TR*        FETCH FIRST ROW ONLY                                     11340024
MFA-TR*         WITH UR                                                 11350024
MFA-TR*    END-EXEC.                                                    11360024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7800'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_MTR_TEST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'DATE_TEST'             TO TABLE-ELEMENT-4          
               MOVE ET-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE ET-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE ET-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE ET-DATE-TEST            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************11620024
      *7900-SELECT-MOVEMENT-HIST        - QUERY15                      *11630024
      ******************************************************************11640024
       7900-SELECT-MOVEMENT-HIST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOC_NO                                             
                INTO :MV-LOC-NO :WS-MV-LOC-NO-IND                        
                FROM CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO     = :MV-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :MV-DEVICE-NO                     
                 AND CODE_CRNT_LOC  = :MV-CODE-CRNT-LOC                 
                 AND DATE_MOVE      <= IIF(TRY_CONVERT(DATE, 
                                                          :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                    
               ORDER BY MOVE_NO DESC                                    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11670024
MFA-TR*       SELECT                                                    11680024
MFA-TR*              LOC_NO                                             11690024
MFA-TR*         INTO :MV-LOC-NO:WS-MV-LOC-NO-IND                        11700024
MFA-TR*         FROM CSS_MOVEMENT_HIST                                  11710024
MFA-TR*        WHERE COMPANY_NO     = :MV-COMPANY-NO                    11720024
MFA-TR*          AND CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                11730024
MFA-TR*          AND DEVICE_NO      = :MV-DEVICE-NO                     11740024
MFA-TR*          AND CODE_CRNT_LOC  = :MV-CODE-CRNT-LOC                 11750024
MFA-TR*          AND DATE_MOVE      <= :MV-DATE-MOVE                    11760024
MFA-TR*        ORDER BY MOVE_NO DESC                                    11770024
MFA-TR*        FETCH FIRST ROW ONLY                                     11780024
MFA-TR*         WITH UR                                                 11790024
MFA-TR*    END-EXEC.                                                    11800024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7900'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_MOVEMENT_HIST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE 'DATE_MOVE'             TO TABLE-ELEMENT-4          
               MOVE MV-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MV-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MV-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               MOVE MV-DATE-MOVE            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************11850024
      * 8100-UPDATE-CSS-EQUIP                - QUERY5                  *11860024
      ******************************************************************11870024
       8100-UPDATE-CSS-EQUIP.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
                 SET                                                    
                     DATE_LAST_TRAN    = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN) )             
               WHERE                                                    
                     COMPANY_NO        = :EQ-COMPANY-NO                 
                 AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE             
                 AND DEVICE_NO         = :EQ-DEVICE-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11900024
MFA-TR*       UPDATE CSS_EQUIPMENT                                      11910024
MFA-TR*          SET                                                    11920024
MFA-TR*              DATE_LAST_TRAN    = :EQ-DATE-LAST-TRAN             11930024
MFA-TR*        WHERE                                                    11950024
MFA-TR*              COMPANY_NO        = :EQ-COMPANY-NO                 11960024
MFA-TR*          AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE             11970024
MFA-TR*          AND DEVICE_NO         = :EQ-DEVICE-NO                  11980024
MFA-TR*    END-EXEC.                                                    11990024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'DATE_LAST_TRAN'        TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-4          
               MOVE EQ-DATE-LAST-TRAN       TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-3        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************12260024
      * 8200-UPDATE-ELEC-MTR-TEST             - QUERY6                 *12270024
      ******************************************************************12280024
       8200-UPDATE-ELEC-MTR-TEST.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ELEC_MTR_TEST                                  
                 SET                                                    
                     CODE_REPAIR          = :ET-CODE-REPAIR             
                    ,REPAIR_DESC          = :ET-REPAIR-DESC             
                    ,CODE_TEST_TYPE       = :ET-CODE-TEST-TYPE          
                    ,CODE_TEST_LOC        = :ET-CODE-TEST-LOC           
                    ,IN_CONSTANT          = :ET-IN-CONSTANT             
                    ,READ_AF              = :ET-READ-AF                 
                    ,DEM_READ_AF          = :ET-DEM-READ-AF             
                    ,LIGHT_LOAD_ACCU_AF   = :ET-LIGHT-LOAD-ACCU-AF      
                    ,FULL_LOAD_ACCU_AF    = :ET-FULL-LOAD-ACCU-AF       
                    ,LIGHT_LOAD_ACCU_AL   = :ET-LIGHT-LOAD-ACCU-AL      
                    ,FULL_LOAD_ACCU_AL    = :ET-FULL-LOAD-ACCU-AL       
                    ,POWER_FCTR_ACCU_AF   = :ET-POWER-FCTR-ACCU-AF      
                    ,POWER_FCTR_ACCU_AL   = :ET-POWER-FCTR-ACCU-AL      
                    ,EQ_TESTER_ID         = :ET-EQ-TESTER-ID            
                    ,TEST_BENCH_ID        = :ET-TEST-BENCH-ID           
                    ,DEM_READ_AL          = :ET-DEM-READ-AL             
               WHERE                                                    
                     CODE_UTIL_TYPE     = :ET-CODE-UTIL-TYPE            
                 AND COMPANY_NO         = :ET-COMPANY-NO                
                 AND METER_NO           = :ET-METER-NO                  
                 AND DATE_TEST          = IIF(TRY_CONVERT(DATE, 
                                                          :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                 
                 AND TIME_TEST          = CIS.CHAR2TIME(:ET-TIME-TEST)          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12310024
MFA-TR*       UPDATE CSS_ELEC_MTR_TEST                                  12320024
MFA-TR*          SET                                                    12330024
MFA-TR*              CODE_REPAIR          = :ET-CODE-REPAIR             12340024
MFA-TR*             ,REPAIR_DESC          = :ET-REPAIR-DESC             12350024
MFA-TR*             ,CODE_TEST_TYPE       = :ET-CODE-TEST-TYPE          12360024
MFA-TR*             ,CODE_TEST_LOC        = :ET-CODE-TEST-LOC           12370024
MFA-TR*             ,IN_CONSTANT          = :ET-IN-CONSTANT             12380024
MFA-TR*             ,READ_AF              = :ET-READ-AF                 12390024
MFA-TR*             ,DEM_READ_AF          = :ET-DEM-READ-AF             12400024
MFA-TR*             ,LIGHT_LOAD_ACCU_AF   = :ET-LIGHT-LOAD-ACCU-AF      12410024
MFA-TR*             ,FULL_LOAD_ACCU_AF    = :ET-FULL-LOAD-ACCU-AF       12420024
MFA-TR*             ,LIGHT_LOAD_ACCU_AL   = :ET-LIGHT-LOAD-ACCU-AL      12430024
MFA-TR*             ,FULL_LOAD_ACCU_AL    = :ET-FULL-LOAD-ACCU-AL       12440024
MFA-TR*             ,POWER_FCTR_ACCU_AF   = :ET-POWER-FCTR-ACCU-AF      12450024
MFA-TR*             ,POWER_FCTR_ACCU_AL   = :ET-POWER-FCTR-ACCU-AL      12460024
MFA-TR*             ,EQ_TESTER_ID         = :ET-EQ-TESTER-ID            12470024
MFA-TR*             ,TEST_BENCH_ID        = :ET-TEST-BENCH-ID           12480024
MFA-TR*             ,DEM_READ_AL          = :ET-DEM-READ-AL             12490024
MFA-TR*        WHERE                                                    12500024
MFA-TR*              CODE_UTIL_TYPE     = :ET-CODE-UTIL-TYPE            12510024
MFA-TR*          AND COMPANY_NO         = :ET-COMPANY-NO                12520024
MFA-TR*          AND METER_NO           = :ET-METER-NO                  12530024
MFA-TR*          AND DATE_TEST          = :ET-DATE-TEST                 12540024
MFA-TR*          AND TIME_TEST          = :ET-TIME-TEST                 12550024
MFA-TR*    END-EXEC.                                                    12560024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_MTR_TEST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'DATE_TEST'             TO TABLE-ELEMENT-4          
               MOVE ET-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE ET-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE ET-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE ET-DATE-TEST            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************12840024
      * 8300-DELETE-ELEC-MTR-TEST             - QUERY7                 *12850024
      ******************************************************************12860024
       8300-DELETE-ELEC-MTR-TEST.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ELEC_MTR_TEST                             
               WHERE                                                    
                     COMPANY_NO     = :ET-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE                
                 AND METER_NO       = :ET-METER-NO                      
                 AND DATE_TEST      = IIF(TRY_CONVERT(DATE, 
                                                          :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                     
                 AND TIME_TEST      = CIS.CHAR2TIME(:ET-TIME-TEST)              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12890024
MFA-TR*       DELETE FROM CSS_ELEC_MTR_TEST                             12900024
MFA-TR*        WHERE                                                    12910024
MFA-TR*              COMPANY_NO     = :ET-COMPANY-NO                    12920024
MFA-TR*          AND CODE_UTIL_TYPE = :ET-CODE-UTIL-TYPE                12930024
MFA-TR*          AND METER_NO       = :ET-METER-NO                      12940024
MFA-TR*          AND DATE_TEST      = :ET-DATE-TEST                     12950024
MFA-TR*          AND TIME_TEST      = :ET-TIME-TEST                     12960024
MFA-TR*    END-EXEC.                                                    12970024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_MTR_TEST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'DATE_TEST'             TO TABLE-ELEMENT-4          
               MOVE ET-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE ET-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE ET-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE ET-DATE-TEST            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************13250024
      * 8400-UPDATE-MTR-TEST-HIST        - QUERY10                     *13260024
      ******************************************************************13270024
       8400-UPDATE-MTR-TEST-HIST.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_MTR_TEST_HIST                                  
                 SET TESTED_QT         = :MQ-TESTED-QT                  
               WHERE                                                    
                     COMPANY_NO        = :MQ-COMPANY-NO                 
                 AND CODE_UTIL_TYPE    = :MQ-CODE-UTIL-TYPE             
                 AND TEST_YEAR         = :MQ-TEST-YEAR                  
                 AND TEST_SCHED_CD     = :MQ-TEST-SCHED-CD              
                 AND MTR_TEST_GRP_CD   = :MQ-MTR-TEST-GRP-CD            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_MTR_TEST_HIST'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'TEST_YEAR'             TO TABLE-ELEMENT-3          
               MOVE 'TEST_SCHED_CD'         TO TABLE-ELEMENT-4          
               MOVE MQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MQ-TEST-YEAR            TO HOSTVAR-ELEMENT-3        
               MOVE MQ-TEST-SCHED-CD        TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************13670024
      * 8500-UPDATE-ELEC-METER          - QUERY12                      *13680024
      ******************************************************************13690024
       8500-UPDATE-ELEC-METER.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ELEC_METER                                     
                 SET DATE_LAST_TESTED = IIF(TRY_CONVERT(DATE, 
                                                   :EM-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :EM-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:EM-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:EM-DATE-LAST-TESTED
              ), CONVERT(DATE, :EM-DATE-LAST-TESTED) )            
               WHERE                                                    
                     COMPANY_NO       = :EM-COMPANY-NO                  
                 AND CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE              
                 AND METER_NO         = :EM-METER-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13720024
MFA-TR*       UPDATE CSS_ELEC_METER                                     13730024
MFA-TR*          SET DATE_LAST_TESTED = :EM-DATE-LAST-TESTED            13740024
MFA-TR*        WHERE                                                    13760024
MFA-TR*              COMPANY_NO       = :EM-COMPANY-NO                  13770024
MFA-TR*          AND CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE              13780024
MFA-TR*          AND METER_NO         = :EM-METER-NO                    13790024
MFA-TR*    END-EXEC.                                                    13800024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_METER'        TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EM-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************14060024
      * 8600-INSERT-ELEC-MTR-TEST               - QUERY14              *14070024
      ******************************************************************14080024
       8600-INSERT-ELEC-MTR-TEST.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ELEC_MTR_TEST                             
              (                                                         
                  CODE_UTIL_TYPE                                        
                 ,METER_NO                                              
                 ,DATE_TEST                                             
                 ,TIME_TEST                                             
                 ,CODE_TIME_PERIOD                                      
                 ,CODE_CAP_TYPE                                         
                 ,CODE_REPAIR                                           
                 ,REPAIR_DESC                                           
                 ,CODE_TEST_TYPE                                        
                 ,CODE_TEST_LOC                                         
                 ,CODE_TEST_RESULT                                      
                 ,IN_CONSTANT                                           
                 ,READ_AF                                               
                 ,DEM_READ_AF                                           
                 ,LIGHT_LOAD_ACCU_AF                                    
                 ,FULL_LOAD_ACCU_AF                                     
                 ,LIGHT_LOAD_ACCU_AL                                    
                 ,FULL_LOAD_ACCU_AL                                     
                 ,POWER_FCTR_ACCU_AF                                    
                 ,POWER_FCTR_ACCU_AL                                    
                 ,EQ_TESTER_ID                                          
                 ,TEST_BENCH_ID                                         
                 ,READ_AL                                               
                 ,COMPANY_NO                                            
                 ,DEM_READ_AL                                           
               )                                                        
               VALUES                                                   
               (                                                        
                  :ET-CODE-UTIL-TYPE                                    
                 ,:ET-METER-NO                                          
                 ,IIF(TRY_CONVERT(DATE, :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                                
                 ,CIS.CHAR2TIME(:ET-TIME-TEST)                                  
                 ,:ET-CODE-TIME-PERIOD                                  
                 ,:ET-CODE-CAP-TYPE                                     
                 ,:ET-CODE-REPAIR                                       
                 ,:ET-REPAIR-DESC                                       
                 ,:ET-CODE-TEST-TYPE                                    
                 ,:ET-CODE-TEST-LOC                                     
                 ,:ET-CODE-TEST-RESULT                                  
                 ,:ET-IN-CONSTANT                                       
                 ,:ET-READ-AF                                           
                 ,:ET-DEM-READ-AF                                       
                 ,:ET-LIGHT-LOAD-ACCU-AF                                
                 ,:ET-FULL-LOAD-ACCU-AF                                 
                 ,:ET-LIGHT-LOAD-ACCU-AL                                
                 ,:ET-FULL-LOAD-ACCU-AL                                 
                 ,:ET-POWER-FCTR-ACCU-AF                                
                 ,:ET-POWER-FCTR-ACCU-AL                                
                 ,:ET-EQ-TESTER-ID                                      
                 ,:ET-TEST-BENCH-ID                                     
                 ,:ET-READ-AL                                           
                 ,:ET-COMPANY-NO                                        
                 ,:ET-DEM-READ-AL                                       
               )                                                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14110024
MFA-TR*       INSERT INTO CSS_ELEC_MTR_TEST                             14120024
MFA-TR*       (                                                         14130024
MFA-TR*           CODE_UTIL_TYPE                                        14140024
MFA-TR*          ,METER_NO                                              14150024
MFA-TR*          ,DATE_TEST                                             14160024
MFA-TR*          ,TIME_TEST                                             14170024
MFA-TR*          ,CODE_TIME_PERIOD                                      14180024
MFA-TR*          ,CODE_CAP_TYPE                                         14190024
MFA-TR*          ,CODE_REPAIR                                           14200024
MFA-TR*          ,REPAIR_DESC                                           14210024
MFA-TR*          ,CODE_TEST_TYPE                                        14220024
MFA-TR*          ,CODE_TEST_LOC                                         14230024
MFA-TR*          ,CODE_TEST_RESULT                                      14240024
MFA-TR*          ,IN_CONSTANT                                           14250024
MFA-TR*          ,READ_AF                                               14260024
MFA-TR*          ,DEM_READ_AF                                           14270024
MFA-TR*          ,LIGHT_LOAD_ACCU_AF                                    14280024
MFA-TR*          ,FULL_LOAD_ACCU_AF                                     14290024
MFA-TR*          ,LIGHT_LOAD_ACCU_AL                                    14300024
MFA-TR*          ,FULL_LOAD_ACCU_AL                                     14310024
MFA-TR*          ,POWER_FCTR_ACCU_AF                                    14310025
MFA-TR*          ,POWER_FCTR_ACCU_AL                                    14320024
MFA-TR*          ,EQ_TESTER_ID                                          14340024
MFA-TR*          ,TEST_BENCH_ID                                         14350024
MFA-TR*          ,READ_AL                                               14360024
MFA-TR*          ,COMPANY_NO                                            14370024
MFA-TR*          ,DEM_READ_AL                                           14380024
MFA-TR*        )                                                        14390024
MFA-TR*        VALUES                                                   14400024
MFA-TR*        (                                                        14410024
MFA-TR*           :ET-CODE-UTIL-TYPE                                    14420024
MFA-TR*          ,:ET-METER-NO                                          14430024
MFA-TR*          ,:ET-DATE-TEST                                         14440024
MFA-TR*          ,:ET-TIME-TEST                                         14450024
MFA-TR*          ,:ET-CODE-TIME-PERIOD                                  14460024
MFA-TR*          ,:ET-CODE-CAP-TYPE                                     14470024
MFA-TR*          ,:ET-CODE-REPAIR                                       14480024
MFA-TR*          ,:ET-REPAIR-DESC                                       14490024
MFA-TR*          ,:ET-CODE-TEST-TYPE                                    14500024
MFA-TR*          ,:ET-CODE-TEST-LOC                                     14510024
MFA-TR*          ,:ET-CODE-TEST-RESULT                                  14520024
MFA-TR*          ,:ET-IN-CONSTANT                                       14530024
MFA-TR*          ,:ET-READ-AF                                           14540024
MFA-TR*          ,:ET-DEM-READ-AF                                       14550024
MFA-TR*          ,:ET-LIGHT-LOAD-ACCU-AF                                14560024
MFA-TR*          ,:ET-FULL-LOAD-ACCU-AF                                 14570024
MFA-TR*          ,:ET-LIGHT-LOAD-ACCU-AL                                14580024
MFA-TR*          ,:ET-FULL-LOAD-ACCU-AL                                 14590024
MFA-TR*          ,:ET-POWER-FCTR-ACCU-AF                                14600024
MFA-TR*          ,:ET-POWER-FCTR-ACCU-AL                                14610024
MFA-TR*          ,:ET-EQ-TESTER-ID                                      14620024
MFA-TR*          ,:ET-TEST-BENCH-ID                                     14630024
MFA-TR*          ,:ET-READ-AL                                           14640024
MFA-TR*          ,:ET-COMPANY-NO                                        14650024
MFA-TR*          ,:ET-DEM-READ-AL                                       14660024
MFA-TR*        )                                                        14670024
MFA-TR*     END-EXEC.                                                   14680024

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_MTR_TEST'     TO TABLE-1                  
               MOVE 'METER_NO'              TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3          
               MOVE 'DATE_TEST'             TO TABLE-ELEMENT-4          
               MOVE ET-METER-NO             TO HOSTVAR-ELEMENT-1        
               MOVE ET-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE ET-COMPANY-NO           TO HOSTVAR-ELEMENT-3        
               MOVE ET-DATE-TEST            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
            EXIT.                                                       
ACT072*                                                                         
      ******************************************************************        
ACT072* 8700-INSERT-CSS-WQ-ITEMS                                       *        
      ******************************************************************        
ACT072 8700-INSERT-CSS-WQ-ITEMS.                                        
ACT072     INITIALIZE   WS-MCSCB077-OUTPUT.                             
ACT072     INITIALIZE   ABEND-FUNCTION.                                 
ACT072                                                                  
ACT072     CALL MCSCB077 USING CWS00077-FIELDS                          
ACT072                        ,ABEND-FILE                               
ACT072                        ,WS-MCSCB077-RET-CODE.                    
ACT072                                                                  
ACT072     MOVE WS-MCSCB077-RET-CODE         TO WS-ACTIVE-RETURN-CODE.  
ACT072                                                                  
ACT072     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT072         CONTINUE                                                 
ACT072     ELSE                                                         
ACT072         DISPLAY '8700-INSERT-CSS-WQ-ITEMS'                       
ACT072         DISPLAY 'CALL MCSCB077         '                         
ACT072         MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
ACT072         MOVE '8700'             TO ACTIVE-PARAGRAPH              
ACT072         MOVE 'CALL'             TO ABEND-FUNCTION                
ACT072         MOVE 'MCSCB077'         TO TABLE-1                       
ACT072         MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
ACT072         MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-2               
ACT072         MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3               
ACT072         MOVE WS-77-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1             
ACT072         MOVE WS-77-PREMISE-NO   TO HOSTVAR-ELEMENT-2             
ACT072         MOVE WS-77-CUSTOMER-NO  TO HOSTVAR-ELEMENT-3             
ACT072         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
ACT072         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
ACT072     END-IF.                                                      
ACT072                                                                  
ACT072 8700-EXIT.                                                       
ACT072     EXIT.                                                        
                                                                        
      ***************************************************************** 15660024
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     * 15670024
      ***************************************************************** 15680024
           EXEC SQL                                                     15690024
              INCLUDE CPDSP300                                          15700024
           END-EXEC.                                                    15710024
                                                                        
      ***************************************************************** 15730024
      * 8900-SEND-DONE                                                * 15740024
      * 9000-SEND-ERROR-RESULT                                        * 15750024
      * 9999-END-PROGRAM                                              * 15760024
      ***************************************************************** 15770024
           EXEC SQL                                                     15780024
              INCLUDE CPD00321                                          15790024
           END-EXEC.                                                    15800024
