       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04223.                                         
COB303 DATE-WRITTEN.  JAN 16 2009                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR GAS UPDATE,    *        
      *  ADD AND DELETE SCREENS.                                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/17/09  MN90523    PROCEDURE ORIGINALLY CODED.              *        
A01922*  12/31/09  SB93596    TOTAL DIALS & READ DIALS WILL BE DERIVED *        
A01922*                       FROM THE DATABASE INSTEAD OF GETTING FROM*        
A01922*                       FRONTEND SCREENS.                        *        
P00251*  04/19/10  SS95855    Net Metering Changes.                    *        
P00251*                       Meter capability split for SCEG & PSNC.  *        
P00251*                       SCEG can have one capabilty compared to  *        
P00251*                       PSNC which has multiple capabilities(7). *        
A00631*  07/01/10  SJ91749    MOVING CORRECT NO-DIALS WHILE WRITING    *        
A00631*                       INTO CSS_MT_TRN_HST_DET TABLE FOR PRV    *        
A00631*                       PRV_COLUMN_VALUE AND CHG_COLUMN_VALUE    *        
A00631*                       AND ALSO ADDING QUERY NOS TO SQL         *        
ACT175*  09/01/11  bd09555    Fix bug in transaction history that does *        
ACT175*  A03082               not accurately show previous number of   *        
ACT175*  A03082               dials                                    *        
      ******************************************************************        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04223'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04223 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05  CTR-ROWS                PIC S9(9) COMP VALUE 1.          
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04223'.      
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-DATE-PURCHASED         PIC X(10).                      
           05 WS-EQUIP-COMMENTS-TX      PIC X(255).                     
           05 WS-DATE-LAST-TRAN         PIC X(10).                      
           05 WS-USER-ID                PIC X(07).                      
           05 WS-METER-EXISTS           PIC X(01) VALUE 'N'.            
           05 WS-EQUIP-EXISTS           PIC X(01) VALUE 'N'.            
           05 WS-METER-ATTACHMTS-EXISTS PIC X(01) VALUE 'N'.            
           05 WS-METER-MOVEMNT-EXISTS   PIC X(01) VALUE 'N'.            
           05 WS-GAS-MTR-TEST-EXISTS    PIC X(01) VALUE 'N'.            
           05 WS-TRAN-APPL-NO           PIC S9(04) COMP VALUE +0.       
           05 WS-CURRENT-TIMESTAMP      PIC X(26).                      
           05 WS-CURRENT-DATE           PIC X(10).                      
           05 WS-FULL-SCALE-DISP        PIC -ZZ,ZZ9.9999.               
           05 WS-CONSTANT-DISP          PIC -ZZZ,ZZ9.999.               
           05 WS-NUMBER-DISP            PIC ZZZ9.                       
           05 WS-FULL-SCALE-999         PIC S9(09).                     
           05 WS-FULL-SCALE-NUM   REDEFINES WS-FULL-SCALE-999           
                                        PIC S9(05)V9(04).               
           05 WS-CONSTANT-999           PIC S9(09).                     
           05 WS-CONSTANT-NUM     REDEFINES WS-CONSTANT-999             
                                        PIC S9(06)V9(03).               
                                                                        
P00251     05 WS-DATABASE-FL            PIC 9(01) VALUE 0.              
P00251        88 CSR-DATABASE                     VALUE 1.              
P00251        88 SEB-DATABASE                     VALUE 2.              
P00251                                                                  
P00251     05 WS-DATABASE               PIC X(08) VALUE                 
P00251        'DATABASE'.                                               
P00251                                                                  
P00251     05 WS-COLUMN-NAME            PIC X(18) VALUE                 
P00251        'REG_ID_NO_CODE_CAP'.                                     
P00251                                                                  
P00251     05 WS-TABLE-NAME             PIC X(18) VALUE                 
P00251        'CSS_MTR_RD_FMT'.                                         
P00251                                                                  
P00251     05 WS-CODE-VALUE.                                            
P00251        10 WS-CODE-UTIL-TYPE      PIC X(01) VALUE SPACE.          
P00251        10 WS-CODE-CAP-TYPE       PIC X(01) VALUE SPACE.          
P00251                                                                  
P00251     05 WS-COMP-SCEG              PIC X(02) VALUE '01'.           
P00251     05 WS-A                      PIC X(01) VALUE 'A'.            
P00251     05 WS-ONE                    PIC S9(04) COMP VALUE +1.       
P00251     05 WS-TEMP-NO-DIALS          PIC 9(04) VALUE 0.              
A00631     05 WS-NO-DIALS               PIC 9(01) VALUE 0.              
P00251     05 WS-TEMP-NO-READ-DIALS     PIC 9(04) VALUE 0.              
P00251     05 WS-CAPABILITY-COUNT       PIC S9(04) COMP VALUE +0.       
P00251     05 WS-NEW-REG-ID-NO          PIC 9(04) VALUE 0.              
P00251                                                                  
P00251     05 WS-TRNS-COMMENT.                                          
P00251        10 WS-TRNS-COMMENT-TXT    PIC X(34) VALUE SPACES.         
P00251        10 WS-TRNS-METER-NO       PIC X(09) VALUE SPACES.         
P00251                                                                  
P00251     05 WS-TRNS-COMMENT-CHG       PIC X(34) VALUE                 
P00251        'Changed Capability for GAS Meter: '.                     
P00251                                                                  
P00251     05 WS-TRNS-COMMENT-ADD       PIC X(34) VALUE                 
P00251        'Added   Capability for GAS Meter: '.                     
P00251                                                                  
P00251     05 WS-TRNS-COMMENT-DEL       PIC X(34) VALUE                 
P00251        'Deleted Capability for GAS Meter: '.                     
P00251                                                                  
P00251 01  WS-ALL-MTR-CAP-INFO          PIC X(224) VALUE SPACES.        
       01  WS-MTR-CAP-INFO-TABLE        REDEFINES WS-ALL-MTR-CAP-INFO.  
P00251     05 WS-MTR-CAP-INFO-REC OCCURS 7 TIMES                        
                                      INDEXED BY MTR-CAP-INDX.          
             10 WS-MTR-CAP-INFO.                                        
                15 WS-MC-UPDATE-IND    PIC X(01).                       
                15 WS-MC-FULL-SCALE    PIC 9(09).                       
                15 WS-MC-CONSTANT      PIC 9(09).                       
                15 WS-MC-CODE-CAP-TYPE PIC X(01).                       
                15 WS-MC-NO-DIALS      PIC 9(04).                       
                15 WS-MC-NO-READ-DIALS PIC 9(04).                       
                15 WS-MC-REG-ID-NO     PIC 9(04).                       
                                                                        
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-UPDATE-IND-SW        PIC X(01) VALUE ' '.             
               88 WS-INSERT-I                    VALUE 'I'.             
               88 WS-UPDATE-U                    VALUE 'U'.             
               88 WS-DELETE-D                    VALUE 'D'.             
           05  WS-EQ-LOCATION-CODE-SW  PIC X(01) VALUE ' '.             
               88 WS-LOCATION-ATTACHED           VALUE 'K'.             
               88 WS-LOCATION-AT-CUSTOMER        VALUE 'J'.             
                                                                        
      *******************'THIS IS THE ROW RETURN AREA'******************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
                                                                        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-EQ-DT-PURCHASE-NULL-IND PIC S9(04) COMP VALUE 0.       
           05 WS-EQ-DT-LST-MOVE-NULL-IND PIC S9(04) COMP VALUE 0.       
           05 WS-EQ-DT-LST-TRAN-NULL-IND PIC S9(04) COMP VALUE 0.       
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    CSS_GAS_METER_SIZE-M5                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT - AT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CUST_PREM_HIST - CH                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIPMENT - EQ                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GAS_METER - GM                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GAS_MTR_TEST - GT                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS - MA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MOVEMENT_HIST  - MV                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_CAP        - MC                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MNT_TRANS_HIST  - MH                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MT_TRN_HST_DET  -  MI                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
P00251******************************************************************        
P00251* CSS_CODE_VALUE      -  UV                                      *        
P00251******************************************************************        
P00251     EXEC SQL                                                             
P00251        INCLUDE TBCDVALU                                                  
P00251     END-EXEC.                                                            
P00251*                                                                         
P00251*****************************************************************         
P00251* CSS_DELINQUENCY     -  C8                                     *         
P00251*****************************************************************         
P00251     EXEC SQL                                                             
P00251         INCLUDE TBDELQ                                                   
P00251     END-EXEC.                                                            
P00251*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-UPDATE-IND           PIC X(01).                          
       01 PARM-CODE-UTIL-TYPE       PIC X(01).                          
       01 PARM-DEVICE-NO            PIC X(09).                          
       01 PARM-CODE-MAKE            PIC X(02).                          
       01 PARM-EQUIP-TYPE-CD        PIC X(01).                          
       01 PARM-DATE-PURCHASED       PIC X(10).                          
       01 PARM-SERIAL-NO            PIC X(11).                          
       01 PARM-CODE-CRNT-LOC        PIC X(01).                          
       01 PARM-EQUIP-COMMENTS-TX    PIC X(255).                         
       01 PARM-COMPANY-NO           PIC X(02).                          
       01 PARM-LOCAL-OFFICE         PIC X(03).                          
       01 PARM-DATE-LAST-TRAN       PIC X(10).                          
       01 PARM-CODE-ATTACHMENTS     PIC X(06).                          
       01 PARM-CASE-PRESSURE        PIC S9(09) COMP.                    
       01 PARM-CCF-CAP-PER-HR       PIC S9(09) COMP.                    
       01 PARM-CODE-METER-TYPE      PIC X(01).                          
       01 PARM-METER-SIZE-ID        PIC X(08).                          
       01 PARM-MODEL-CD             PIC X(01).                          
       01 PARM-CONNECTION-TYPE-CD   PIC X(02).                          
       01 PARM-ALLOW-CONSTANT-FL    PIC X(01).                          
       01 PARM-TEST-SCHED-CD        PIC X(01).                          
       01 PARM-DEVICE-TYPE-CD       PIC X(01).                          
       01 PARM-DIGTL-MTR-TYPE       PIC X(03).                          
       01 PARM-NUMBER-OF-DRIVE      PIC S9(04) COMP.                    
       01 PARM-PROGRAM-ID           PIC X(02).                          
       01 PARM-CODE-DEVICE-TYPE     PIC X(01).                          
       01 PARM-USER-ID              PIC X(07).                          
       01 PARM-MTR-CAP-INFO-01      PIC X(32).                          
       01 PARM-MTR-CAP-INFO-02      PIC X(32).                          
       01 PARM-MTR-CAP-INFO-03      PIC X(32).                          
       01 PARM-MTR-CAP-INFO-04      PIC X(32).                          
       01 PARM-MTR-CAP-INFO-05      PIC X(32).                          
       01 PARM-MTR-CAP-INFO-06      PIC X(32).                          
P00251 01 PARM-MTR-CAP-INFO-07      PIC X(32).                          
      *                                                                         
       PROCEDURE DIVISION USING PARM-UPDATE-IND                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-DEVICE-NO                          
                                PARM-CODE-MAKE                          
                                PARM-EQUIP-TYPE-CD                      
                                PARM-DATE-PURCHASED                     
                                PARM-SERIAL-NO                          
                                PARM-CODE-CRNT-LOC                      
                                PARM-EQUIP-COMMENTS-TX                  
                                PARM-COMPANY-NO                         
                                PARM-LOCAL-OFFICE                       
                                PARM-DATE-LAST-TRAN                     
                                PARM-CODE-ATTACHMENTS                   
                                PARM-CASE-PRESSURE                      
                                PARM-CCF-CAP-PER-HR                     
                                PARM-CODE-METER-TYPE                    
                                PARM-METER-SIZE-ID                      
                                PARM-MODEL-CD                           
                                PARM-CONNECTION-TYPE-CD                 
                                PARM-ALLOW-CONSTANT-FL                  
                                PARM-TEST-SCHED-CD                      
                                PARM-DEVICE-TYPE-CD                     
                                PARM-DIGTL-MTR-TYPE                     
                                PARM-NUMBER-OF-DRIVE                    
                                PARM-PROGRAM-ID                         
                                PARM-CODE-DEVICE-TYPE                   
                                PARM-USER-ID                            
                                PARM-MTR-CAP-INFO-01                    
                                PARM-MTR-CAP-INFO-02                    
                                PARM-MTR-CAP-INFO-03                    
                                PARM-MTR-CAP-INFO-04                    
                                PARM-MTR-CAP-INFO-05                    
                                PARM-MTR-CAP-INFO-06                    
P00251                          PARM-MTR-CAP-INFO-07.                   
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
            MOVE '0100'                   TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                    :S-RETURN-CODE             AS RETURN_CODE           
               FROM                                                     
                    CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*             :S-RETURN-CODE             AS RETURN_CODE                   
MFA-TR*        FROM                                                             
MFA-TR*             SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-UPDATE-IND        TO WS-UPDATE-IND-SW.             
                                                                        
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS                        
                                       THRU 1200-EXIT.                  
                                                                        
                                                                        
           MOVE PARM-CODE-UTIL-TYPE    TO GM-CODE-UTIL-TYPE             
                                          MC-CODE-UTIL-TYPE             
                                          EQ-CODE-UTIL-TYPE             
                                          MV-CODE-UTIL-TYPE             
                                          GT-CODE-UTIL-TYPE             
P00251                                    WS-CODE-UTIL-TYPE             
                                          MA-CODE-UTIL-TYPE.            
                                                                        
                                                                        
           MOVE PARM-DEVICE-NO         TO GM-METER-NO                   
                                          MC-METER-NO                   
                                          EQ-DEVICE-NO                  
                                          MV-DEVICE-NO                  
                                          GT-METER-NO                   
P00251                                    WS-TRNS-METER-NO              
                                          MA-METER-NO.                  
                                                                        
           MOVE PARM-CODE-MAKE         TO EQ-CODE-MAKE.                 
                                                                        
           MOVE PARM-EQUIP-TYPE-CD     TO EQ-EQUIP-TYPE-CD.             
                                                                        
           MOVE PARM-DATE-PURCHASED    TO WS-DATE-PURCHASED.            
                                                                        
           MOVE PARM-SERIAL-NO         TO EQ-SERIAL-NO.                 
                                                                        
           MOVE PARM-CODE-CRNT-LOC     TO EQ-CODE-CRNT-LOC.             
                                                                        
           MOVE PARM-EQUIP-COMMENTS-TX TO WS-EQUIP-COMMENTS-TX.         
                                                                        
           MOVE PARM-COMPANY-NO        TO GM-COMPANY-NO                 
                                          MC-COMPANY-NO                 
                                          EQ-COMPANY-NO                 
                                          MV-COMPANY-NO                 
                                          GT-COMPANY-NO                 
                                          MA-COMPANY-NO                 
P00251                                    UV-COMPANY-NO                 
P00251                                    C8-COMPANY-NO                 
A01922                                    M5-COMPANY-NO.                
                                                                        
P00251     MOVE WS-DATABASE            TO C8-DELINQ-CD.                 
P00251     PERFORM 7010-GET-DATABASE   THRU 7010-EXIT.                  
P00251     MOVE C8-DELINQ-VALUE        TO  WS-DATABASE-FL.              
                                                                        
           MOVE PARM-LOCAL-OFFICE      TO EQ-LOCAL-OFFICE.              
                                                                        
           MOVE PARM-DATE-LAST-TRAN    TO WS-DATE-LAST-TRAN.            
                                                                        
           MOVE PARM-CODE-ATTACHMENTS  TO GM-CODE-ATTACHMENTS.          
                                                                        
           MOVE PARM-CASE-PRESSURE     TO GM-CASE-PRESSURE.             
                                                                        
           MOVE PARM-CCF-CAP-PER-HR    TO GM-CCF-CAP-PER-HR.            
                                                                        
           MOVE PARM-CODE-METER-TYPE   TO GM-CODE-METER-TYPE.           
                                                                        
           MOVE PARM-METER-SIZE-ID     TO GM-METER-SIZE-ID              
A01922                                    M5-METER-SIZE-ID.             
                                                                        
           MOVE PARM-MODEL-CD          TO GM-MODEL-CD.                  
                                                                        
           MOVE PARM-CONNECTION-TYPE-CD TO GM-CONNECTION-TYPE-CD.       
                                                                        
           MOVE PARM-ALLOW-CONSTANT-FL TO GM-ALLOW-CONSTANT-FL.         
                                                                        
           MOVE PARM-TEST-SCHED-CD     TO GM-TEST-SCHED-CD.             
                                                                        
           MOVE PARM-DEVICE-TYPE-CD    TO GM-DEVICE-TYPE-CD.            
                                                                        
           MOVE PARM-DIGTL-MTR-TYPE    TO GM-DIGTL-MTR-TYPE.            
                                                                        
           MOVE PARM-NUMBER-OF-DRIVE   TO GM-NUMBER-OF-DRIVE.           
                                                                        
           MOVE PARM-PROGRAM-ID        TO GM-PROGRAM-ID.                
                                                                        
           MOVE PARM-CODE-DEVICE-TYPE  TO MV-CODE-DEVICE-TYPE.          
                                                                        
           MOVE PARM-USER-ID           TO WS-USER-ID.                   
                                                                        
           STRING PARM-MTR-CAP-INFO-01 DELIMITED BY SIZE                
                 , PARM-MTR-CAP-INFO-02 DELIMITED BY SIZE               
                 , PARM-MTR-CAP-INFO-03 DELIMITED BY SIZE               
                 , PARM-MTR-CAP-INFO-04 DELIMITED BY SIZE               
                 , PARM-MTR-CAP-INFO-05 DELIMITED BY SIZE               
                 , PARM-MTR-CAP-INFO-06 DELIMITED BY SIZE               
P00251           , PARM-MTR-CAP-INFO-07 DELIMITED BY SIZE               
                                       INTO WS-ALL-MTR-CAP-INFO.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1200-VALIDATE-INPUT-ARGUMENTS.                                 *        
      ******************************************************************        
      *                                                                         
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-COMPANY-NO     = SPACES OR                           
              PARM-CODE-UTIL-TYPE = SPACES OR                           
              PARM-DEVICE-NO      = SPACES OR (                         
              ( NOT WS-INSERT-I ) AND ( NOT WS-DELETE-D ) AND           
              ( NOT WS-UPDATE-U ) )                                     
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-1          
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-2          
              MOVE 'PARM-DEVICE-NO'         TO TABLE-ELEMENT-3          
              MOVE 'PARM-UPDATE-IND'        TO TABLE-ELEMENT-4          
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-3        
              MOVE PARM-UPDATE-IND          TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           EVALUATE TRUE                                                
             WHEN WS-INSERT-I                                           
               PERFORM 2100-PROCESS-INSERT-DETAILS                      
                                            THRU 2100-EXIT              
             WHEN WS-DELETE-D                                           
               PERFORM 2200-PROCESS-DELETE-DETAILS                      
                                            THRU 2200-EXIT              
             WHEN WS-UPDATE-U                                           
               PERFORM 2300-PROCESS-UPDATE-DETAILS                      
                                            THRU 2300-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT                                                        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE                      TO S-RETURN-CODE.   
           ADD +1                                   TO CTR-ROWS.        
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-INSERT-DETAILS                                    *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-INSERT-DETAILS.                                     
                                                                        
           MOVE 'N'                            TO WS-METER-EXISTS.      
           PERFORM 7000-CHECK-METER-EXISTS     THRU 7000-EXIT.          
                                                                        
           IF WS-METER-EXISTS = 'Y'                                     
              MOVE 5100                        TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           MOVE 'N'                            TO WS-EQUIP-EXISTS.      
           PERFORM 7020-CHECK-EQUIP-EXISTS     THRU 7020-EXIT.          
                                                                        
           IF WS-EQUIP-EXISTS = 'Y'                                     
              MOVE 5200                        TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           IF WS-DATE-PURCHASED > SPACES                                
              MOVE WS-DATE-PURCHASED           TO EQ-DATE-PURCHASED     
                                                  EQ-DATE-LAST-MOVE     
                                                  EQ-DATE-LAST-TRAN     
           ELSE                                                         
              MOVE -1                          TO                       
                                            WS-EQ-DT-PURCHASE-NULL-IND  
                                            WS-EQ-DT-LST-MOVE-NULL-IND  
                                            WS-EQ-DT-LST-TRAN-NULL-IND  
              MOVE SPACES                      TO EQ-DATE-PURCHASED     
                                                  EQ-DATE-LAST-MOVE     
                                                  EQ-DATE-LAST-TRAN     
           END-IF.                                                      
                                                                        
           PERFORM 8000-INSERT-EQUIP-DETAILS   THRU 8000-EXIT.          
                                                                        
           PERFORM 8020-INSERT-GAS-METER-DETAILS                        
                                               THRU 8020-EXIT.          
                                                                        
P00251     PERFORM 3000-SET-UP-MTR-CAP         THRU 3000-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-DELETE-DETAILS                                    *        
      ******************************************************************        
       2200-PROCESS-DELETE-DETAILS.                                     
                                                                        
           PERFORM 7040-CHECK-CURR-METER-LOCATION THRU 7040-EXIT.       
                                                                        
           IF WS-LOCATION-ATTACHED OR WS-LOCATION-AT-CUSTOMER           
              MOVE 5100                           TO RS-RETURN-CODE     
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 9999-END-PROGRAM            THRU 9999-EXIT        
           END-IF                                                       
                                                                        
           MOVE 'N'                        TO WS-METER-ATTACHMTS-EXISTS.
           PERFORM 7060-CHECK-METER-ATTACHEMENTS  THRU 7060-EXIT.       
                                                                        
           IF WS-METER-ATTACHMTS-EXISTS = 'Y'                           
              MOVE 5200                           TO RS-RETURN-CODE     
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 9999-END-PROGRAM            THRU 9999-EXIT        
           END-IF                                                       
                                                                        
           MOVE 'N'                        TO WS-METER-ATTACHMTS-EXISTS.
           PERFORM 7080-CHECK-METER-MOVEMNT-HIST  THRU 7080-EXIT.       
                                                                        
           IF WS-METER-MOVEMNT-EXISTS = 'Y'                             
              MOVE 5300                           TO RS-RETURN-CODE     
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 9999-END-PROGRAM            THRU 9999-EXIT        
           END-IF                                                       
                                                                        
           MOVE 'N'                         TO WS-GAS-MTR-TEST-EXISTS.  
           PERFORM 7100-CHECK-GAS-MTR-TEST-HIST   THRU 7100-EXIT.       
                                                                        
           IF WS-GAS-MTR-TEST-EXISTS = 'Y'                              
              MOVE 5400                           TO RS-RETURN-CODE     
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 9999-END-PROGRAM            THRU 9999-EXIT        
           END-IF                                                       
                                                                        
           PERFORM 8060-DELETE-GAS-METER-DETAILS  THRU 8060-EXIT.       
                                                                        
           PERFORM 8080-DELETE-METER-CAP-DETAILS  THRU 8080-EXIT.       
                                                                        
           PERFORM 8100-DELETE-EQUIPMENT-DETAILS  THRU 8100-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-UPDATE-DETAILS                                    *        
      ******************************************************************        
       2300-PROCESS-UPDATE-DETAILS.                                     
                                                                        
           IF WS-DATE-PURCHASED > SPACES                                
              MOVE WS-DATE-PURCHASED        TO EQ-DATE-PURCHASED        
           ELSE                                                         
              MOVE -1                     TO WS-EQ-DT-PURCHASE-NULL-IND 
              MOVE SPACES                   TO EQ-DATE-PURCHASED        
           END-IF.                                                      
                                                                        
           MOVE LENGTH OF WS-EQUIP-COMMENTS-TX                          
                                            TO EQ-EQUIP-COMMENTS-TX-LEN 
           MOVE WS-EQUIP-COMMENTS-TX        TO EQ-EQUIP-COMMENTS-TX-TEXT
                                                                        
           PERFORM 8120-UPDATE-EQUIPMENT-DETAILS                        
                                            THRU 8120-EXIT              
                                                                        
           PERFORM 8140-UPDATE-GAS-METER-DETAILS                        
                                            THRU 8140-EXIT.             
                                                                        
           PERFORM 7040-CHECK-CURR-METER-LOCATION                       
                                            THRU 7040-EXIT.             
                                                                        
           IF WS-LOCATION-AT-CUSTOMER                                   
              MOVE EQ-CRNT-LOC-NO           TO CH-PREMISE-NO            
              PERFORM 7120-GET-ACCOUNT-DETAILS                          
                                            THRU 7120-EXIT              
           END-IF.                                                      
                                                                        
P00251     SET MTR-CAP-INDX TO +1.                                      
P00251                                                                  
P00251*** Meter capability being changed for SCEG gas Meter                     
P00251     IF MC-COMPANY-NO = WS-COMP-SCEG                              
P00251                                                                  
P00251        IF WS-MC-UPDATE-IND(MTR-CAP-INDX) = 'C'                   
P00251                                                                  
P00251          IF WS-MC-REG-ID-NO(MTR-CAP-INDX) > 0                    
P00251*** NO-READ-DIALS and NO-DIALS will be always defaulted from              
P00251*** GAS_METER_SIZE for SCEG irrescpective of what is                      
P00251*** received from the Front End.                                          
P00251            IF CSR-DATABASE                                       
P00251               MOVE ZERO              TO M5-NO-DIALS              
P00251               PERFORM 7150-SELECT-NO-DIALS  THRU 7150-EXIT       
P00251                                                                  
P00251               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL         
P00251                  MOVE M5-NO-DIALS    TO WS-TEMP-NO-DIALS         
P00251                                         WS-TEMP-NO-READ-DIALS    
P00251               ELSE                                               
P00251                  MOVE 5500           TO RS-RETURN-CODE           
P00251                  PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT      
P00251                  PERFORM 9000-SEND-ERROR-RESULT                  
P00251                                             THRU 9000-EXIT       
P00251                  PERFORM 9999-END-PROGRAM   THRU 9999-EXIT       
P00251               END-IF                                             
P00251                                                                  
P00251            ELSE                                                  
P00251               MOVE WS-MC-NO-READ-DIALS(MTR-CAP-INDX)             
P00251                                      TO WS-TEMP-NO-READ-DIALS    
P00251               MOVE WS-MC-NO-DIALS(MTR-CAP-INDX)                  
P00251                                      TO WS-TEMP-NO-DIALS         
P00251            END-IF                                                
P00251                                                                  
P00251            MOVE WS-MC-FULL-SCALE(MTR-CAP-INDX)                   
P00251                                      TO WS-FULL-SCALE-999        
P00251            MOVE WS-MC-CONSTANT(MTR-CAP-INDX)                     
P00251                                      TO WS-CONSTANT-999          
P00251                                                                  
P00251            MOVE WS-MC-REG-ID-NO(MTR-CAP-INDX)                    
P00251                                      TO MC-REG-ID-NO             
P00251            PERFORM 7140-GET-MTR-CAP-DETAILS                      
P00251                                      THRU 7140-EXIT              
P00251                                                                  
P00251            IF (WS-FULL-SCALE-NUM     NOT = MC-FULL-SCALE         
P00251                OR WS-CONSTANT-NUM    NOT = MC-CONSTANT           
P00251                OR WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)              
P00251                                      NOT = MC-CODE-CAP-TYPE      
P00251                OR WS-TEMP-NO-READ-DIALS                          
P00251                                      NOT = MC-NO-READ-DIALS      
P00251                OR WS-TEMP-NO-DIALS   NOT = MC-NO-DIALS)          
P00251                                                                  
P00251                IF WS-LOCATION-AT-CUSTOMER                        
P00251                   MOVE WS-TRNS-COMMENT-CHG                       
P00251                                      TO WS-TRNS-COMMENT-TXT      
P00251                   PERFORM 5100-UPDATE-JOURNAL                    
P00251                                      THRU 5100-EXIT              
P00251                END-IF                                            
P00251                                                                  
P00251                MOVE WS-FULL-SCALE-NUM     TO MC-FULL-SCALE       
P00251                MOVE WS-CONSTANT-NUM       TO MC-CONSTANT         
P00251                MOVE WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)            
P00251                                           TO MC-CODE-CAP-TYPE    
P00251                MOVE WS-TEMP-NO-READ-DIALS TO MC-NO-READ-DIALS    
P00251                MOVE WS-TEMP-NO-DIALS      TO MC-NO-DIALS         
P00251                                                                  
P00251                PERFORM 8160-UPDATE-MTR-CAP-DETAILS               
P00251                                           THRU 8160-EXIT         
P00251            END-IF                                                
P00251                                                                  
P00251          END-IF                                                  
P00251          SET MTR-CAP-INDX to +7                                  
P00251        END-IF                                                    
P00251     ELSE                                                         
P00251*** Meter capability being changed for PSNC gas Meter                     
P00251        PERFORM UNTIL MTR-CAP-INDX > +7                           
P00251                                                                  
ACT175          MOVE WS-MC-NO-READ-DIALS(MTR-CAP-INDX)                  
ACT175                                      TO WS-TEMP-NO-READ-DIALS    
ACT175          MOVE WS-MC-NO-DIALS(MTR-CAP-INDX)                       
ACT175                                      TO WS-TEMP-NO-DIALS         
P00251          IF WS-MC-REG-ID-NO(MTR-CAP-INDX) > 0                    
P00251                                                                  
P00251             EVALUATE WS-MC-UPDATE-IND(MTR-CAP-INDX)              
P00251                                                                  
P00251*** New Capability added                                                  
P00251                WHEN 'A'                                          
P00251                  MOVE WS-MC-FULL-SCALE(MTR-CAP-INDX)             
P00251                                           TO WS-FULL-SCALE-999   
P00251                  MOVE WS-FULL-SCALE-NUM   TO MC-FULL-SCALE       
P00251                  MOVE WS-MC-CONSTANT(MTR-CAP-INDX)               
P00251                                           TO WS-CONSTANT-999     
P00251                  MOVE WS-CONSTANT-NUM     TO MC-CONSTANT         
P00251                  MOVE WS-MC-NO-READ-DIALS(MTR-CAP-INDX)          
P00251                                           TO MC-NO-READ-DIALS    
P00251                  MOVE WS-MC-NO-DIALS(MTR-CAP-INDX)               
P00251                                           TO MC-NO-DIALS         
P00251                                              WS-TEMP-NO-DIALS    
P00251                  MOVE WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)          
P00251                                           TO MC-CODE-CAP-TYPE    
P00251                                              WS-CODE-CAP-TYPE    
P00251                  MOVE ZEROES              TO WS-NEW-REG-ID-NO    
P00251                                              MC-REG-ID-NO        
P00251                  PERFORM 3100-GET-REG-ID-NO THRU 3100-EXIT       
P00251                  MOVE UV-CODE-SHORT-DESC-TEXT(1:2)               
P00251                                           TO WS-NEW-REG-ID-NO    
P00251                  MOVE WS-NEW-REG-ID-NO    TO MC-REG-ID-NO        
P00251                                                                  
P00251                  PERFORM 8040-INSERT-METER-CAP-DETAILS           
P00251                                           THRU 8040-EXIT         
P00251                                                                  
P00251                  IF WS-LOCATION-AT-CUSTOMER                      
P00251                     MOVE WS-TRNS-COMMENT-ADD                     
P00251                                           TO WS-TRNS-COMMENT-TXT 
P00251                     PERFORM 5100-UPDATE-JOURNAL                  
P00251                                           THRU 5100-EXIT         
P00251                  END-IF                                          
P00251                                                                  
P00251*** Capability change                                                     
P00251                WHEN 'C'                                          
P00251                  PERFORM 3200-CHANGE-MTR-CAP                     
P00251                                           THRU 3200-EXIT         
P00251*** Capability being deleted                                              
P00251                WHEN 'D'                                          
P00251                  PERFORM 7180-GET-NO-OF-CAPABILTY                
P00251                                           THRU 7180-EXIT         
P00251                  IF WS-CAPABILITY-COUNT > 1                      
P00251                     MOVE WS-MC-REG-ID-NO(MTR-CAP-INDX)           
P00251                                           TO MC-REG-ID-NO        
P00251                     PERFORM 7140-GET-MTR-CAP-DETAILS             
P00251                                           THRU 7140-EXIT         
P00251                     PERFORM 8180-DELETE-A-MTR-CAP-DTL            
P00251                                           THRU 8180-EXIT         
P00251                     MOVE MC-CODE-CAP-TYPE TO WS-CODE-CAP-TYPE    
P00251                     MOVE MC-CONSTANT      TO WS-CONSTANT-NUM     
P00251                     MOVE MC-NO-DIALS      TO WS-TEMP-NO-DIALS    
P00251                                                                  
P00251                     IF WS-LOCATION-AT-CUSTOMER                   
P00251                        MOVE WS-TRNS-COMMENT-DEL                  
P00251                                           TO WS-TRNS-COMMENT-TXT 
P00251                        PERFORM 5100-UPDATE-JOURNAL               
P00251                                           THRU 5100-EXIT         
P00251                     END-IF                                       
P00251                  END-IF                                          
P00251                                                                  
P00251             END-EVALUATE                                         
P00251                                                                  
P00251          END-IF                                                  
P00251          SET MTR-CAP-INDX UP BY +1                               
P00251        END-PERFORM                                               
P00251     END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
P00251*                                                                         
P00251*                                                                         
P00251******************************************************************        
P00251*3000-SET-UP-MTR-CAP.                                            *        
P00251******************************************************************        
P00251 3000-SET-UP-MTR-CAP.                                             
P00251*                                                                         
P00251*** New capability being added for SCEG gas Meter                         
P00251     IF MC-COMPANY-NO = WS-COMP-SCEG                              
P00251        MOVE WS-ONE                      TO MC-CONSTANT           
P00251                                            MC-REG-ID-NO          
P00251        MOVE WS-A                        TO MC-CODE-CAP-TYPE      
P00251        MOVE ZERO                        TO MC-FULL-SCALE         
P00251                                            M5-NO-DIALS           
P00251        PERFORM 7150-SELECT-NO-DIALS     THRU 7150-EXIT           
P00251                                                                  
P00251        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00251           MOVE M5-NO-DIALS              TO MC-NO-DIALS           
P00251                                            MC-NO-READ-DIALS      
P00251        ELSE                                                      
P00251           MOVE 5500                     TO RS-RETURN-CODE        
P00251           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT          
P00251           PERFORM 9000-SEND-ERROR-RESULT                         
P00251                                         THRU 9000-EXIT           
P00251           PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
P00251        END-IF                                                    
P00251                                                                  
P00251        PERFORM 8040-INSERT-METER-CAP-DETAILS                     
P00251                                         THRU 8040-EXIT           
P00251     ELSE                                                         
P00251*** New capabilities being added for PSNC gas Meter                       
P00251        SET MTR-CAP-INDX TO +1                                    
P00251                                                                  
P00251        PERFORM UNTIL MTR-CAP-INDX > +7                           
P00251                                                                  
P00251           IF WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX) > SPACES          
P00251              MOVE WS-MC-FULL-SCALE(MTR-CAP-INDX)                 
P00251                                         TO WS-FULL-SCALE-999     
P00251              MOVE WS-FULL-SCALE-NUM     TO MC-FULL-SCALE         
P00251              MOVE WS-MC-CONSTANT(MTR-CAP-INDX)                   
P00251                                         TO WS-CONSTANT-999       
P00251              MOVE WS-CONSTANT-NUM       TO MC-CONSTANT           
P00251              MOVE WS-MC-NO-READ-DIALS(MTR-CAP-INDX)              
P00251                                         TO MC-NO-READ-DIALS      
P00251              MOVE WS-MC-NO-DIALS(MTR-CAP-INDX)                   
P00251                                         TO MC-NO-DIALS           
P00251              MOVE WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)              
P00251                                         TO MC-CODE-CAP-TYPE      
P00251                                            WS-CODE-CAP-TYPE      
P00251                                                                  
P00251              MOVE ZEROES                TO WS-NEW-REG-ID-NO      
P00251                                            MC-REG-ID-NO          
P00251              PERFORM 3100-GET-REG-ID-NO THRU 3100-EXIT           
P00251              MOVE UV-CODE-SHORT-DESC-TEXT(1:2)                   
P00251                                         TO WS-NEW-REG-ID-NO      
P00251              MOVE WS-NEW-REG-ID-NO      TO MC-REG-ID-NO          
P00251              PERFORM 8040-INSERT-METER-CAP-DETAILS               
P00251                                         THRU 8040-EXIT           
P00251           END-IF                                                 
P00251                                                                  
P00251           SET MTR-CAP-INDX UP BY +1                              
P00251        END-PERFORM                                               
P00251     END-IF.                                                      
P00251*                                                                         
P00251 3000-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
P00251******************************************************************        
P00251* 3100-GET-REG-ID-NO.                                            *        
P00251******************************************************************        
P00251*                                                                         
P00251 3100-GET-REG-ID-NO.                                              
P00251                                                                  
P00251     MOVE WS-COLUMN-NAME               TO UV-COLUMN-NA-TEXT.      
P00251     MOVE LENGTH OF UV-COLUMN-NA-TEXT  TO UV-COLUMN-NA-LEN.       
P00251     MOVE WS-TABLE-NAME                TO UV-TABLE-NA-TEXT.       
P00251     MOVE LENGTH OF UV-TABLE-NA-TEXT   TO UV-TABLE-NA-LEN.        
P00251     MOVE WS-CODE-VALUE                TO UV-CODE-VALUE-TEXT.     
P00251     MOVE LENGTH OF UV-CODE-VALUE-TEXT TO UV-CODE-VALUE-LEN.      
P00251                                                                  
P00251     PERFORM 7170-SELECT-REG-ID-NO     THRU 7170-EXIT.            
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251        MOVE 5600                      TO RS-RETURN-CODE          
P00251        PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
P00251        PERFORM 9000-SEND-ERROR-RESULT                            
P00251                                       THRU 9000-EXIT             
P00251        PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
P00251     END-IF.                                                      
P00251                                                                  
P00251 3100-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
P00251******************************************************************        
P00251* 3200-CHANGE-MTR-CAP.                                           *        
P00251******************************************************************        
P00251*                                                                         
P00251 3200-CHANGE-MTR-CAP.                                             
P00251*                                                                         
P00251*** WS-MC-REG-ID-NO(MTR-CAP-INDX) is the Old register id                  
P00251*** Deletes and inserts capability when reg id change occurs              
P00251*** and Updates otherwise.                                                
P00251     MOVE WS-MC-REG-ID-NO(MTR-CAP-INDX)  TO MC-REG-ID-NO.         
P00251     PERFORM 7140-GET-MTR-CAP-DETAILS    THRU 7140-EXIT.          
P00251                                                                  
P00251*** Get New register id based on the Code Cap type.                       
P00251     MOVE WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)                       
P00251                                         TO WS-CODE-CAP-TYPE.     
P00251     MOVE ZEROES                         TO WS-NEW-REG-ID-NO.     
P00251     PERFORM 3100-GET-REG-ID-NO          THRU 3100-EXIT.          
P00251     MOVE UV-CODE-SHORT-DESC-TEXT(1:2)   TO WS-NEW-REG-ID-NO.     
P00251                                                                  
P00251     MOVE WS-MC-FULL-SCALE(MTR-CAP-INDX) TO WS-FULL-SCALE-999.    
P00251     MOVE WS-MC-CONSTANT(MTR-CAP-INDX)   TO WS-CONSTANT-999.      
P00251                                                                  
P00251     IF (WS-FULL-SCALE-NUM     NOT = MC-FULL-SCALE                
P00251         OR WS-CONSTANT-NUM    NOT = MC-CONSTANT                  
P00251         OR WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)                     
P00251                               NOT = MC-CODE-CAP-TYPE             
P00251         OR WS-MC-NO-READ-DIALS(MTR-CAP-INDX)                     
P00251                               NOT = MC-NO-READ-DIALS             
P00251         OR WS-MC-NO-DIALS(MTR-CAP-INDX)                          
P00251                               NOT = MC-NO-DIALS                  
P00251         OR WS-NEW-REG-ID-NO   NOT = MC-REG-ID-NO)                
P00251                                                                  
P00251         IF WS-LOCATION-AT-CUSTOMER                               
P00251            MOVE WS-TRNS-COMMENT-CHG    TO WS-TRNS-COMMENT-TXT    
P00251            PERFORM 5100-UPDATE-JOURNAL THRU 5100-EXIT            
P00251         END-IF                                                   
P00251                                                                  
P00251         MOVE WS-FULL-SCALE-NUM         TO MC-FULL-SCALE          
P00251         MOVE WS-CONSTANT-NUM           TO MC-CONSTANT            
P00251         MOVE WS-MC-NO-READ-DIALS(MTR-CAP-INDX)                   
P00251                                        TO MC-NO-READ-DIALS       
P00251         MOVE WS-MC-NO-DIALS(MTR-CAP-INDX)                        
P00251                                        TO MC-NO-DIALS            
P00251         MOVE WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)                   
P00251                                        TO MC-CODE-CAP-TYPE       
P00251         IF WS-NEW-REG-ID-NO   NOT = MC-REG-ID-NO                 
P00251            PERFORM 8180-DELETE-A-MTR-CAP-DTL                     
P00251                                        THRU 8180-EXIT            
P00251            MOVE WS-NEW-REG-ID-NO       TO MC-REG-ID-NO           
P00251            PERFORM 8040-INSERT-METER-CAP-DETAILS                 
P00251                                        THRU 8040-EXIT            
P00251         ELSE                                                     
P00251            PERFORM 8160-UPDATE-MTR-CAP-DETAILS                   
P00251                                        THRU 8160-EXIT            
P00251         END-IF                                                   
P00251     END-IF.                                                      
P00251                                                                  
P00251 3200-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
      **************************************************************            
      * 5100-UPDATE-JOURNAL                                                     
      *                                                                         
      **************************************************************            
       5100-UPDATE-JOURNAL.                                             
      *                                                                         
           PERFORM 7160-GET-CURRENT-TIMESTAMP  THRU 7160-EXIT.          
           MOVE WS-CURRENT-TIMESTAMP           TO MH-TRANS-HIST-SEQ-NO. 
           MOVE WS-CURRENT-DATE                TO MH-DATE-TRANS.        
           MOVE 'F'                            TO MH-CODE-TRAN-TYPE.    
           MOVE 293                            TO MH-RESP-AREA-ID.      
           MOVE CH-ACCOUNT-NO                  TO MH-ACCOUNT-NO.        
           MOVE CH-PREMISE-NO                  TO MH-PREMISE-NO.        
           MOVE CH-CUSTOMER-NO                 TO MH-CUSTOMER-NO.       
           MOVE WS-USER-ID                     TO MH-USER-ID.           
P00251     MOVE WS-TRNS-COMMENT                TO MH-TRAN-COMMENT-TEXT. 
P00251     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.  
P00251     MOVE PROGRAM-NAME                   TO MH-APPL-PROGRAM-ID.   
           MOVE +1                             TO WS-TRAN-APPL-NO.      
                                                                        
P00251     IF WS-MC-UPDATE-IND(MTR-CAP-INDX) = 'A' OR 'D'               
P00251        PERFORM 5300-ADD-DEL-JRNL-MTR-CAP THRU 5300-EXIT          
P00251     ELSE                                                         
              PERFORM 5200-UPDATE-JRNL-MTR-CAP THRU 5200-EXIT           
P00251     END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * 5200-UPDATE-JRNL-MTR-CAP                                                
      *                                                                         
      **************************************************************            
       5200-UPDATE-JRNL-MTR-CAP.                                        
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
P00251     MOVE 'MC'                       TO MI-TABLE-ID.              
                                                                        
           IF WS-CONSTANT-NUM             NOT = MC-CONSTANT             
              MOVE 'CONSTANT'              TO MI-COLUMN-DESC            
              MOVE +11                     TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE MC-CONSTANT             TO WS-CONSTANT-DISP          
              MOVE WS-CONSTANT-DISP        TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE WS-CONSTANT-NUM         TO WS-CONSTANT-DISP          
              MOVE WS-CONSTANT-DISP        TO MI-CHG-COLUMN-VALUE-TEXT  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX) NOT = MC-CODE-CAP-TYPE  
              MOVE 'CODE CAP TYPE'         TO MI-COLUMN-DESC            
              MOVE +1                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE MC-CODE-CAP-TYPE        TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE WS-MC-CODE-CAP-TYPE(MTR-CAP-INDX)                    
                                           TO MI-CHG-COLUMN-VALUE-TEXT  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
           END-IF.                                                      
P00251                                                                  
P00251     IF (MC-COMPANY-NO = WS-COMP-SCEG                             
P00251         AND WS-TEMP-NO-DIALS NOT = MC-NO-DIALS)                  
P00251         OR  (WS-MC-NO-DIALS(MTR-CAP-INDX) NOT = MC-NO-DIALS)     
P00251         MOVE 'NO. OF DIALS'          TO MI-COLUMN-DESC           
A00631         MOVE +1                      TO MI-PRV-COLUMN-VALUE-LEN  
A00631         MOVE MC-NO-DIALS             TO WS-NO-DIALS              
A00631         MOVE WS-NO-DIALS             TO MI-PRV-COLUMN-VALUE-TEXT 
A00631         MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN  
A00631         MOVE WS-TEMP-NO-DIALS       TO WS-NO-DIALS               
A00631         MOVE WS-NO-DIALS       TO MI-CHG-COLUMN-VALUE-TEXT       
P00251         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
P00251         ADD 1                        TO WS-TRAN-APPL-NO          
P00251         MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
P00251     END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
P00251 5300-ADD-DEL-JRNL-MTR-CAP.                                       
P00251*                                                                         
P00251     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
P00251     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
P00251     MOVE 'MC'                    TO MI-TABLE-ID.                 
P00251                                                                  
P00251     IF WS-MC-UPDATE-IND(MTR-CAP-INDX) = 'A'                      
P00251        MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
P00251        MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
P00251     ELSE                                                         
P00251        MOVE +11                  TO MI-PRV-COLUMN-VALUE-LEN      
P00251        MOVE '*DELETED*'          TO MI-PRV-COLUMN-VALUE-TEXT     
P00251     END-IF.                                                      
P00251                                                                  
P00251     MOVE 'CONSTANT'              TO MI-COLUMN-DESC.              
P00251     MOVE +11                     TO MI-CHG-COLUMN-VALUE-LEN.     
P00251     MOVE WS-CONSTANT-NUM         TO WS-CONSTANT-DISP.            
P00251     MOVE WS-CONSTANT-DISP        TO MI-CHG-COLUMN-VALUE-TEXT.    
P00251     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
P00251     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00251     ADD 1                        TO WS-TRAN-APPL-NO.             
P00251                                                                  
P00251     MOVE 'CODE CAP TYPE'         TO MI-COLUMN-DESC.              
P00251     MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN.     
P00251     MOVE WS-CODE-CAP-TYPE        TO MI-CHG-COLUMN-VALUE-TEXT.    
P00251     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
P00251     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00251     ADD 1                        TO WS-TRAN-APPL-NO.             
P00251                                                                  
P00251     MOVE 'NO. OF DIALS'          TO MI-COLUMN-DESC.              
P00251     MOVE WS-TEMP-NO-DIALS        TO MI-CHG-COLUMN-VALUE-TEXT.    
P00251     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
P00251                                  TO MI-CHG-COLUMN-VALUE-LEN.     
P00251     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
P00251     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00251     ADD 1                        TO WS-TRAN-APPL-NO.             
P00251                                                                  
P00251 5300-EXIT.                                                       
P00251     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-CHECK-METER-EXISTS                                        *        
      ******************************************************************        
      *                                                                         
       7000-CHECK-METER-EXISTS.                                         
      *                                                                         
            MOVE '7000'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       'Y'                                              
                  INTO                                                  
                       :WS-METER-EXISTS                                 
                  FROM                                                  
                       CSS_GAS_METER WITH(READUNCOMMITTED)                      
                 WHERE                                                  
                       COMPANY_NO     = :GM-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE              
                   AND METER_NO       = :GM-METER-NO                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-METER-EXISTS                                         
MFA-TR*           FROM                                                          
MFA-TR*                CSS_GAS_METER                                            
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO     = :GM-COMPANY-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                      
MFA-TR*            AND METER_NO       = :GM-METER-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GAS_METER'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE GM-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE GM-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE GM-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00251******************************************************************        
P00251* GET DATABASE                                                   *        
P00251******************************************************************        
P00251 7010-GET-DATABASE.                                               
P00251*                                                                         
P00251     EXEC SQL                                                     
P00251         SELECT DELINQ_VALUE                                      
P00251           INTO :C8-DELINQ-VALUE                                  
P00251           FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
P00251          WHERE COMPANY_NO = :C8-COMPANY-NO                       
P00251            AND DELINQ_CD  = :C8-DELINQ-CD                        
P00251                                                           
A00631                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*           AND DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251*                                                                         
P00251     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00251*                                                                         
P00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00251        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00251        MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
P00251        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
P00251        MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-2             
P00251        MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
P00251        MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-2           
P00251        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00251        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00251     END-IF.                                                      
P00251*                                                                         
P00251 7010-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
      ******************************************************************        
      * 7020-CHECK-EQUIP-EXISTS                                        *        
      ******************************************************************        
      *                                                                         
       7020-CHECK-EQUIP-EXISTS.                                         
      *                                                                         
            MOVE '7020'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       'Y'                                              
                  INTO                                                  
                       :WS-EQUIP-EXISTS                                 
                  FROM                                                  
                       CSS_EQUIPMENT WITH(READUNCOMMITTED)                      
                 WHERE                                                  
                       COMPANY_NO     = :EQ-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                   AND DEVICE_NO      = :EQ-DEVICE-NO                   
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-EQUIP-EXISTS                                         
MFA-TR*           FROM                                                          
MFA-TR*                CSS_EQUIPMENT                                            
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO     = :EQ-COMPANY-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                      
MFA-TR*            AND DEVICE_NO      = :EQ-DEVICE-NO                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7020                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7040-CHECK-CURR-METER-LOCATION.                                *        
      ******************************************************************        
      *                                                                         
       7040-CHECK-CURR-METER-LOCATION.                                  
      *                                                                         
            MOVE '7040'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       CODE_CRNT_LOC                                    
                      ,CRNT_LOC_NO                                      
                  INTO                                                  
                       :EQ-CODE-CRNT-LOC                                
                      ,:EQ-CRNT-LOC-NO                                  
                  FROM                                                  
                       CSS_EQUIPMENT WITH(READUNCOMMITTED)                      
                 WHERE                                                  
                       COMPANY_NO     = :EQ-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                   AND DEVICE_NO      = :EQ-DEVICE-NO                   
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                CODE_CRNT_LOC                                            
MFA-TR*               ,CRNT_LOC_NO                                              
MFA-TR*           INTO                                                          
MFA-TR*                :EQ-CODE-CRNT-LOC                                        
MFA-TR*               ,:EQ-CRNT-LOC-NO                                          
MFA-TR*           FROM                                                          
MFA-TR*                CSS_EQUIPMENT                                            
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO     = :EQ-COMPANY-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                      
MFA-TR*            AND DEVICE_NO      = :EQ-DEVICE-NO                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7040                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               MOVE EQ-CODE-CRNT-LOC      TO WS-EQ-LOCATION-CODE-SW     
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7060-CHECK-METER-ATTACHEMENTS.                                 *        
      ******************************************************************        
      *                                                                         
       7060-CHECK-METER-ATTACHEMENTS.                                   
      *                                                                         
            MOVE '7060'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-METER-ATTACHMTS-EXISTS                       
                  FROM                                                  
                       CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                 
                 WHERE                                                  
                       COMPANY_NO     = :MA-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE              
                   AND METER_NO       = :MA-METER-NO                    
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-METER-ATTACHMTS-EXISTS                               
MFA-TR*           FROM                                                          
MFA-TR*                CSS_METER_ATTCHMTS                                       
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO     = :MA-COMPANY-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                      
MFA-TR*            AND METER_NO       = :MA-METER-NO                            
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7060                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_METER_ATTACHMTS' TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MA-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MA-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7080-CHECK-METER-MOVEMNT-HIST.                                 *        
      ******************************************************************        
      *                                                                         
       7080-CHECK-METER-MOVEMNT-HIST.                                   
      *                                                                         
            MOVE '7080'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-METER-MOVEMNT-EXISTS                         
                  FROM                                                  
                       CSS_MOVEMENT_HIST WITH(READUNCOMMITTED)                  
                 WHERE                                                  
                       COMPANY_NO       = :MV-COMPANY-NO                
                   AND CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE            
                   AND DEVICE_NO        = :MV-DEVICE-NO                 
                   AND CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE          
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-METER-MOVEMNT-EXISTS                                 
MFA-TR*           FROM                                                          
MFA-TR*                CSS_MOVEMENT_HIST                                        
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO       = :MV-COMPANY-NO                        
MFA-TR*            AND CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE                    
MFA-TR*            AND DEVICE_NO        = :MV-DEVICE-NO                         
MFA-TR*            AND CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE                  
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7080                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MOVEMENT_HIST'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE 'CODE_DEVICE_TYPE'    TO TABLE-ELEMENT-4            
               MOVE MV-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MV-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MV-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               MOVE MV-CODE-DEVICE-TYPE   TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7100-CHECK-GAS-MTR-TEST-HIST.                                  *        
      ******************************************************************        
      *                                                                         
       7100-CHECK-GAS-MTR-TEST-HIST.                                    
      *                                                                         
            MOVE '7100'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) 'Y'                                              
                  INTO                                                  
                       :WS-GAS-MTR-TEST-EXISTS                          
                  FROM                                                  
                       CSS_GAS_MTR_TEST WITH(READUNCOMMITTED)                   
                 WHERE                                                  
                       COMPANY_NO       = :GT-COMPANY-NO                
                   AND CODE_UTIL_TYPE   = :GT-CODE-UTIL-TYPE            
                   AND METER_NO         = :GT-METER-NO                  
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                'Y'                                                      
MFA-TR*           INTO                                                          
MFA-TR*                :WS-GAS-MTR-TEST-EXISTS                                  
MFA-TR*           FROM                                                          
MFA-TR*                CSS_GAS_MTR_TEST                                         
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO       = :GT-COMPANY-NO                        
MFA-TR*            AND CODE_UTIL_TYPE   = :GT-CODE-UTIL-TYPE                    
MFA-TR*            AND METER_NO         = :GT-METER-NO                          
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GAS_MTR_TEST'    TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE GT-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE GT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE GT-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7120-GET-ACCOUNT-DETAILS.                                      *        
      ******************************************************************        
      *                                                                         
       7120-GET-ACCOUNT-DETAILS.                                        
      *                                                                         
            MOVE '7120'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) CH.ACCOUNT_NO,
              AT.CUSTOMER_NO,
              AT.LOCAL_OFFICE                                  
                  INTO                                                  
                       :CH-ACCOUNT-NO                                   
                      ,:CH-CUSTOMER-NO                                  
                      ,:AT-LOCAL-OFFICE                                 
                  FROM                                                  
                       CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)              
                      ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)              
                 WHERE                                                  
                       CH.ACCOUNT_NO    = AT.ACCOUNT_NO                 
                   AND CH.PREMISE_NO    = :CH-PREMISE-NO                
                 ORDER BY                                               
                       CH.DATE_UTIL_SVC_STRT DESC                       
                                                    
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                CH.ACCOUNT_NO                                            
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*           INTO                                                          
MFA-TR*                :CH-ACCOUNT-NO                                           
MFA-TR*               ,:CH-CUSTOMER-NO                                          
MFA-TR*               ,:AT-LOCAL-OFFICE                                         
MFA-TR*           FROM                                                          
MFA-TR*                CSS_CUST_PREM_HIST CH                                    
MFA-TR*               ,CSS_ACCOUNT        AT                                    
MFA-TR*          WHERE                                                          
MFA-TR*                CH.ACCOUNT_NO    = AT.ACCOUNT_NO                         
MFA-TR*            AND CH.PREMISE_NO    = :CH-PREMISE-NO                        
MFA-TR*          ORDER BY                                                       
MFA-TR*                CH.DATE_UTIL_SVC_STRT DESC                               
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7120                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-4            
               MOVE GT-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE GT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE GT-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE CH-PREMISE-NO         TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7140-GET-MTR-CAP-DETAILS.                                      *        
      ******************************************************************        
      *                                                                         
       7140-GET-MTR-CAP-DETAILS.                                        
      *                                                                         
            MOVE '7140'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       CONSTANT                                         
                      ,NO_DIALS                                         
                      ,NO_READ_DIALS                                    
                      ,FULL_SCALE                                       
                      ,CODE_CAP_TYPE                                    
                  INTO                                                  
                       :MC-CONSTANT                                     
                      ,:MC-NO-DIALS                                     
                      ,:MC-NO-READ-DIALS                                
                      ,:MC-FULL-SCALE                                   
                      ,:MC-CODE-CAP-TYPE                                
                  FROM                                                  
                       CSS_MTR_CAP WITH(READUNCOMMITTED)                        
                 WHERE                                                  
                       COMPANY_NO     = :MC-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE              
                   AND METER_NO       = :MC-METER-NO                    
                   AND REG_ID_NO      = :MC-REG-ID-NO                   
                                                                 
A00631                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*                CONSTANT                                                 
MFA-TR*               ,NO_DIALS                                                 
MFA-TR*               ,NO_READ_DIALS                                            
MFA-TR*               ,FULL_SCALE                                               
MFA-TR*               ,CODE_CAP_TYPE                                            
MFA-TR*           INTO                                                          
MFA-TR*                :MC-CONSTANT                                             
MFA-TR*               ,:MC-NO-DIALS                                             
MFA-TR*               ,:MC-NO-READ-DIALS                                        
MFA-TR*               ,:MC-FULL-SCALE                                           
MFA-TR*               ,:MC-CODE-CAP-TYPE                                        
MFA-TR*           FROM                                                          
MFA-TR*                CSS_MTR_CAP                                              
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO     = :MC-COMPANY-NO                          
MFA-TR*            AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                      
MFA-TR*            AND METER_NO       = :MC-METER-NO                            
MFA-TR*            AND REG_ID_NO      = :MC-REG-ID-NO                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7140                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'CODE_CAP_TYPE'       TO TABLE-ELEMENT-4            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE MC-CODE-CAP-TYPE      TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
A01922******************************************************************        
A01922* 7150-SELECT-NO-DIALS.                                          *        
A01922******************************************************************        
A01922*                                                                         
A01922 7150-SELECT-NO-DIALS.                                            
A01922*                                                                         
A01922      MOVE '7150'                   TO ACTIVE-PARAGRAPH.          
A01922                                                                  
A01922      EXEC SQL                                                    
A01922          SELECT NO_DIALS                                         
A01922            INTO :M5-NO-DIALS                                     
A01922            FROM CSS_GAS_METER_SIZE WITH(READUNCOMMITTED)                 
A01922           WHERE COMPANY_NO     = :M5-COMPANY-NO                  
A01922             AND METER_SIZE_ID  = :M5-METER-SIZE-ID               
A01922                                                           
A00631                                                      
A01922      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT NO_DIALS                                                 
MFA-TR*           INTO :M5-NO-DIALS                                             
MFA-TR*           FROM CSS_GAS_METER_SIZE                                       
MFA-TR*          WHERE COMPANY_NO     = :M5-COMPANY-NO                          
MFA-TR*            AND METER_SIZE_ID  = :M5-METER-SIZE-ID                       
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7150                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01922                                                                  
A01922      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
A01922                                                                  
A01922      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
A01922         CONTINUE                                                 
A01922      ELSE                                                        
A01922            MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
A01922            MOVE 'SELECT'              TO ABEND-FUNCTION          
A01922            MOVE 'CSS_GAS_METER_SIZE'  TO TABLE-1                 
A01922            MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1         
A01922            MOVE 'METER_SIZE_ID'       TO TABLE-ELEMENT-2         
A01922            MOVE M5-COMPANY-NO         TO HOSTVAR-ELEMENT-1       
A01922            MOVE M5-METER-SIZE-ID      TO HOSTVAR-ELEMENT-2       
A01922            PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT       
A01922            PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT       
A01922      END-IF.                                                     
A01922                                                                  
A01922 7150-EXIT.                                                       
A01922      EXIT.                                                       
      ******************************************************************        
      * 7160-GET-CURRENT-TIMESTAMP                                     *        
      ******************************************************************        
      *                                                                         
       7160-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
            MOVE '7160'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*            ,:WS-CURRENT-DATE      = CURRENT DATE                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7160-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00251******************************************************************        
P00251* 7170-SELECT-REG-ID-NO.                                         *        
P00251******************************************************************        
P00251*                                                                         
P00251 7170-SELECT-REG-ID-NO.                                           
P00251*                                                                         
P00251      MOVE '7170'                   TO ACTIVE-PARAGRAPH.          
P00251                                                                  
P00251      EXEC SQL                                                    
P00251           SELECT CODE_SHORT_DESC                                 
P00251            INTO :UV-CODE-SHORT-DESC                              
P00251           FROM   CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                 
P00251           WHERE  COLUMN_NA    = :UV-COLUMN-NA                    
P00251           AND    TABLE_NA     = :UV-TABLE-NA                     
P00251           AND    COMPANY_NO   = :UV-COMPANY-NO                   
P00251           AND    CODE_VALUE   = :UV-CODE-VALUE                   
P00251                                                           
A00631                                                      
P00251      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT CODE_SHORT_DESC                                         
MFA-TR*           INTO :UV-CODE-SHORT-DESC                                      
MFA-TR*          FROM   CSS_CODE_VALUE UV                                       
MFA-TR*          WHERE  COLUMN_NA    = :UV-COLUMN-NA                            
MFA-TR*          AND    TABLE_NA     = :UV-TABLE-NA                             
MFA-TR*          AND    COMPANY_NO   = :UV-COMPANY-NO                           
MFA-TR*          AND    CODE_VALUE   = :UV-CODE-VALUE                           
MFA-TR*          WITH UR                                                        
MFA-TR*           QUERYNO 7170                                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
P00251                                                                  
P00251      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00251         CONTINUE                                                 
P00251      ELSE                                                        
P00251         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
P00251         MOVE 'SELECT'              TO ABEND-FUNCTION             
P00251         MOVE 'CSS_CODE_VALUE'      TO TABLE-1                    
P00251         MOVE 'COLUMN-NA'           TO TABLE-ELEMENT-1            
P00251         MOVE 'TABLE-NA  '          TO TABLE-ELEMENT-2            
P00251         MOVE 'COMPANY-NO'          TO TABLE-ELEMENT-3            
P00251         MOVE 'CODE-VALUE'          TO TABLE-ELEMENT-4            
P00251         MOVE UV-COLUMN-NA          TO HOSTVAR-ELEMENT-1          
P00251         MOVE UV-TABLE-NA           TO HOSTVAR-ELEMENT-2          
P00251         MOVE UV-COMPANY-NO         TO HOSTVAR-ELEMENT-3          
P00251         MOVE UV-CODE-VALUE         TO HOSTVAR-ELEMENT-4          
P00251         PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
P00251         PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
P00251      END-IF.                                                     
P00251                                                                  
P00251 7170-EXIT.                                                       
P00251      EXIT.                                                       
P00251*                                                                         
P00251*                                                                         
P00251******************************************************************        
P00251* 7180-GET-NO-OF-CAPABILTY.                                      *        
P00251******************************************************************        
P00251*                                                                         
P00251 7180-GET-NO-OF-CAPABILTY.                                        
P00251*                                                                         
P00251      MOVE '7180'                   TO ACTIVE-PARAGRAPH.          
P00251                                                                  
P00251      EXEC SQL                                                    
P00251           SELECT COUNT(*)                                        
P00251            INTO  :WS-CAPABILITY-COUNT                            
P00251           FROM   CSS_MTR_CAP WITH(READUNCOMMITTED)                       
P00251           WHERE  CODE_UTIL_TYPE  = :MC-CODE-UTIL-TYPE            
P00251           AND    METER_NO        = :MC-METER-NO                  
P00251           AND    COMPANY_NO      = :MC-COMPANY-NO                
P00251                                                           
A00631                                                      
P00251      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT COUNT(*)                                                
MFA-TR*           INTO  :WS-CAPABILITY-COUNT                                    
MFA-TR*          FROM   CSS_MTR_CAP                                             
MFA-TR*          WHERE  CODE_UTIL_TYPE  = :MC-CODE-UTIL-TYPE                    
MFA-TR*          AND    METER_NO        = :MC-METER-NO                          
MFA-TR*          AND    COMPANY_NO      = :MC-COMPANY-NO                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7180                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
P00251                                                                  
P00251      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00251         CONTINUE                                                 
P00251      ELSE                                                        
P00251         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
P00251         MOVE 'SELECT'              TO ABEND-FUNCTION             
P00251         MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
P00251         MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1            
P00251         MOVE 'METER_NO'            TO TABLE-ELEMENT-2            
P00251         MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3            
P00251         MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1          
P00251         MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-2          
P00251         MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-3          
P00251         PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
P00251         PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
P00251      END-IF.                                                     
P00251                                                                  
P00251 7180-EXIT.                                                       
P00251      EXIT.                                                       
P00251*                                                                         
      ******************************************************************        
      * 8000-INSERT-EQUIP-DETAILS                                      *        
      ******************************************************************        
      *                                                                         
       8000-INSERT-EQUIP-DETAILS.                                       
      *                                                                         
            MOVE '8000'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                INSERT INTO CSS_EQUIPMENT                               
                (                                                       
                       CODE_UTIL_TYPE                                   
                      ,DEVICE_NO                                        
                      ,CODE_MAKE                                        
                      ,EQUIP_TYPE_CD                                    
                      ,DATE_PURCHASED                                   
                      ,SERIAL_NO                                        
                      ,CODE_CRNT_LOC                                    
                      ,DATE_LAST_TRAN                                   
                      ,DATE_LAST_MOVE                                   
                      ,LOCAL_OFFICE                                     
                      ,COMPANY_NO                                       
                )                                                       
                VALUES                                                  
                (                                                       
                       :EQ-CODE-UTIL-TYPE                               
                      ,:EQ-DEVICE-NO                                    
                      ,:EQ-CODE-MAKE                                    
                      ,:EQ-EQUIP-TYPE-CD                                
                      ,IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED 
                                             :WS-EQ-DT-PURCHASE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ) )    
                      ,:EQ-SERIAL-NO                                    
                      ,:EQ-CODE-CRNT-LOC                                
                      ,IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DT-LST-TRAN-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN 
                                            :WS-EQ-DT-LST-TRAN-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN 
                                            :WS-EQ-DT-LST-TRAN-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN 
                                            :WS-EQ-DT-LST-TRAN-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                            :WS-EQ-DT-LST-TRAN-NULL-IND
              ) )    
                      ,IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DT-LST-MOVE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                            :WS-EQ-DT-LST-MOVE-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE 
                                            :WS-EQ-DT-LST-MOVE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                            :WS-EQ-DT-LST-MOVE-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                            :WS-EQ-DT-LST-MOVE-NULL-IND
              ) )    
                      ,:EQ-LOCAL-OFFICE                                 
                      ,:EQ-COMPANY-NO                                   
                )                                                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         INSERT INTO CSS_EQUIPMENT                                       
MFA-TR*         (                                                               
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*               ,DEVICE_NO                                                
MFA-TR*               ,CODE_MAKE                                                
MFA-TR*               ,EQUIP_TYPE_CD                                            
MFA-TR*               ,DATE_PURCHASED                                           
MFA-TR*               ,SERIAL_NO                                                
MFA-TR*               ,CODE_CRNT_LOC                                            
MFA-TR*               ,DATE_LAST_TRAN                                           
MFA-TR*               ,DATE_LAST_MOVE                                           
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,COMPANY_NO                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*                :EQ-CODE-UTIL-TYPE                                       
MFA-TR*               ,:EQ-DEVICE-NO                                            
MFA-TR*               ,:EQ-CODE-MAKE                                            
MFA-TR*               ,:EQ-EQUIP-TYPE-CD                                        
MFA-TR*               ,:EQ-DATE-PURCHASED:WS-EQ-DT-PURCHASE-NULL-IND            
MFA-TR*               ,:EQ-SERIAL-NO                                            
MFA-TR*               ,:EQ-CODE-CRNT-LOC                                        
MFA-TR*               ,:EQ-DATE-LAST-TRAN:WS-EQ-DT-LST-TRAN-NULL-IND            
MFA-TR*               ,:EQ-DATE-LAST-MOVE:WS-EQ-DT-LST-MOVE-NULL-IND            
MFA-TR*               ,:EQ-LOCAL-OFFICE                                         
MFA-TR*               ,:EQ-COMPANY-NO                                           
MFA-TR*         )                                                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE 'EQUIP_TYPE_CD'       TO TABLE-ELEMENT-4            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               MOVE EQ-EQUIP-TYPE-CD      TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8020-INSERT-GAS-METER-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8020-INSERT-GAS-METER-DETAILS.                                   
      *                                                                         
            MOVE '8020'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                INSERT INTO CSS_GAS_METER                               
                (                                                       
                       CODE_UTIL_TYPE                                   
                      ,METER_NO                                         
                      ,CODE_ATTACHMENTS                                 
                      ,CASE_PRESSURE                                    
                      ,CCF_CAP_PER_HR                                   
                      ,CODE_METER_TYPE                                  
                      ,METER_SIZE_ID                                    
                      ,MODEL_CD                                         
                      ,CONNECTION_TYPE_CD                               
                      ,ALLOW_CONSTANT_FL                                
                      ,TEST_SCHED_CD                                    
                      ,DEVICE_TYPE_CD                                   
                      ,DIGTL_MTR_TYPE                                   
                      ,NUMBER_OF_DRIVE                                  
                      ,COMPANY_NO                                       
                      ,PROGRAM_ID                                       
                )                                                       
                VALUES                                                  
                (                                                       
                       :GM-CODE-UTIL-TYPE                               
                      ,:GM-METER-NO                                     
                      ,:GM-CODE-ATTACHMENTS                             
                      ,:GM-CASE-PRESSURE                                
                      ,:GM-CCF-CAP-PER-HR                               
                      ,:GM-CODE-METER-TYPE                              
                      ,:GM-METER-SIZE-ID                                
                      ,:GM-MODEL-CD                                     
                      ,:GM-CONNECTION-TYPE-CD                           
                      ,:GM-ALLOW-CONSTANT-FL                            
                      ,:GM-TEST-SCHED-CD                                
                      ,:GM-DEVICE-TYPE-CD                               
                      ,:GM-DIGTL-MTR-TYPE                               
                      ,:GM-NUMBER-OF-DRIVE                              
                      ,:GM-COMPANY-NO                                   
                      ,:GM-PROGRAM-ID                                   
                )                                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GAS_METER'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'DEVICE_TYPE_CD'      TO TABLE-ELEMENT-4            
               MOVE GM-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE GM-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE GM-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE GM-DEVICE-TYPE-CD     TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8020-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8040-INSERT-METER-CAP-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8040-INSERT-METER-CAP-DETAILS.                                   
      *                                                                         
            MOVE '8040'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                INSERT INTO CSS_MTR_CAP                                 
                (                                                       
                       FULL_SCALE                                       
                      ,CONSTANT                                         
                      ,CODE_CAP_TYPE                                    
                      ,NO_READ_DIALS                                    
                      ,NO_DIALS                                         
                      ,CODE_UTIL_TYPE                                   
                      ,METER_NO                                         
                      ,REG_ID_NO                                        
                      ,COMPANY_NO                                       
                )                                                       
                VALUES                                                  
                (                                                       
                       :MC-FULL-SCALE                                   
                      ,:MC-CONSTANT                                     
                      ,:MC-CODE-CAP-TYPE                                
                      ,:MC-NO-READ-DIALS                                
                      ,:MC-NO-DIALS                                     
                      ,:MC-CODE-UTIL-TYPE                               
                      ,:MC-METER-NO                                     
                      ,:MC-REG-ID-NO                                    
                      ,:MC-COMPANY-NO                                   
                )                                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'REG_ID_NO'           TO TABLE-ELEMENT-4            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE MC-REG-ID-NO          TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8060-DELETE-GAS-METER-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8060-DELETE-GAS-METER-DETAILS.                                   
      *                                                                         
            MOVE '8060'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM                                                  
                       CSS_GAS_METER                                    
                 WHERE                                                  
                       COMPANY_NO     = :GM-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE              
                   AND METER_NO       = :GM-METER-NO                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_GAS_METER'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE GM-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE GM-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE GM-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8060-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8080-DELETE-METER-CAP-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8080-DELETE-METER-CAP-DETAILS.                                   
      *                                                                         
            MOVE '8080'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM                                                  
                       CSS_MTR_CAP                                      
                 WHERE                                                  
                       COMPANY_NO     = :MC-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE              
                   AND METER_NO       = :MC-METER-NO                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-DELETE-EQUIPMENT-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8100-DELETE-EQUIPMENT-DETAILS.                                   
      *                                                                         
            MOVE '8100'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM                                                  
                       CSS_EQUIPMENT                                    
                 WHERE                                                  
                       COMPANY_NO     = :EQ-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                   AND DEVICE_NO      = :EQ-DEVICE-NO                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8120-UPDATE-EQUIPMENT-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8120-UPDATE-EQUIPMENT-DETAILS.                                   
      *                                                                         
            MOVE '8120'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                       CSS_EQUIPMENT                                    
                   SET                                                  
                       CODE_MAKE          = :EQ-CODE-MAKE               
                      ,DATE_PURCHASED                                   
                      = IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-PURCHASED 
                                            :WS-EQ-DT-PURCHASE-NULL-IND
              ) )   
                      ,SERIAL_NO          = :EQ-SERIAL-NO               
                      ,CODE_CRNT_LOC      = :EQ-CODE-CRNT-LOC           
                      ,EQUIP_COMMENTS_TX  = :EQ-EQUIP-COMMENTS-TX       
                      ,LOCAL_OFFICE       = :EQ-LOCAL-OFFICE            
                 WHERE                                                  
                       COMPANY_NO         = :EQ-COMPANY-NO              
                   AND CODE_UTIL_TYPE     = 'G'                         
                   AND DEVICE_NO          = :EQ-DEVICE-NO               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE                                                          
MFA-TR*                CSS_EQUIPMENT                                            
MFA-TR*            SET                                                          
MFA-TR*                CODE_MAKE          = :EQ-CODE-MAKE                       
MFA-TR*               ,DATE_PURCHASED                                           
MFA-TR*               = :EQ-DATE-PURCHASED:WS-EQ-DT-PURCHASE-NULL-IND           
MFA-TR*               ,SERIAL_NO          = :EQ-SERIAL-NO                       
MFA-TR*               ,CODE_CRNT_LOC      = :EQ-CODE-CRNT-LOC                   
MFA-TR*               ,EQUIP_COMMENTS_TX  = :EQ-EQUIP-COMMENTS-TX               
MFA-TR*               ,LOCAL_OFFICE       = :EQ-LOCAL-OFFICE                    
MFA-TR*          WHERE                                                          
MFA-TR*                COMPANY_NO         = :EQ-COMPANY-NO                      
MFA-TR*            AND CODE_UTIL_TYPE     = 'G'                                 
MFA-TR*            AND DEVICE_NO          = :EQ-DEVICE-NO                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8120-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8140-UPDATE-GAS-METER-DETAILS                                  *        
      ******************************************************************        
      *                                                                         
       8140-UPDATE-GAS-METER-DETAILS.                                   
                                                                        
            MOVE '8140'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                       CSS_GAS_METER                                    
                   SET                                                  
                       CASE_PRESSURE      = :GM-CASE-PRESSURE           
                      ,CCF_CAP_PER_HR     = :GM-CCF-CAP-PER-HR          
                      ,CODE_METER_TYPE    = :GM-CODE-METER-TYPE         
                      ,METER_SIZE_ID      = :GM-METER-SIZE-ID           
                      ,MODEL_CD           = :GM-MODEL-CD                
                      ,CONNECTION_TYPE_CD = :GM-CONNECTION-TYPE-CD      
                      ,ALLOW_CONSTANT_FL  = :GM-ALLOW-CONSTANT-FL       
                      ,TEST_SCHED_CD      = :GM-TEST-SCHED-CD           
                      ,NUMBER_OF_DRIVE    = :GM-NUMBER-OF-DRIVE         
                      ,PROGRAM_ID         = :GM-PROGRAM-ID              
                 WHERE                                                  
                       COMPANY_NO         = :GM-COMPANY-NO              
                   AND CODE_UTIL_TYPE     = 'G'                         
                   AND METER_NO           = :GM-METER-NO                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_GAS_METER'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE GM-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE GM-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE GM-METER-NO           TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8140-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8160-UPDATE-MTR-CAP-DETAILS                                    *        
      ******************************************************************        
      *                                                                         
       8160-UPDATE-MTR-CAP-DETAILS.                                     
                                                                        
            MOVE '8160'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                UPDATE                                                  
                       CSS_MTR_CAP                                      
                   SET                                                  
                       CONSTANT           = :MC-CONSTANT                
                      ,NO_DIALS           = :MC-NO-DIALS                
                      ,NO_READ_DIALS      = :MC-NO-READ-DIALS           
                      ,FULL_SCALE         = :MC-FULL-SCALE              
                      ,CODE_CAP_TYPE      = :MC-CODE-CAP-TYPE           
                 WHERE                                                  
                       COMPANY_NO         = :MC-COMPANY-NO              
                   AND CODE_UTIL_TYPE     = 'G'                         
                   AND METER_NO           = :MC-METER-NO                
                   AND REG_ID_NO          = :MC-REG-ID-NO               
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'REG_ID_NO'           TO TABLE-ELEMENT-4            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE MC-REG-ID-NO          TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8160-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8180-DELETE-A-METER-CAP-DTL                                    *        
      ******************************************************************        
      *                                                                         
       8180-DELETE-A-MTR-CAP-DTL.                                       
      *                                                                         
            MOVE '8180'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                DELETE                                                  
                  FROM                                                  
                       CSS_MTR_CAP                                      
                 WHERE                                                  
                       COMPANY_NO     = :MC-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE              
                   AND METER_NO       = :MC-METER-NO                    
                   AND REG_ID_NO      = :MC-REG-ID-NO                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_MTR_CAP'         TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'METER_NO'            TO TABLE-ELEMENT-3            
               MOVE 'REG_ID_NO'           TO TABLE-ELEMENT-4            
               MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3          
               MOVE MC-REG-ID-NO          TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       8180-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
