       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04222.                                         
COB303 DATE-WRITTEN.                                                    
COB303            DEC 10, 2008.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR GAS METER       *        
      * EQUIPMENT TEST SCREENS WHICH IS USED TO UPDATE, ADD OR DELETE  *        
      * GAS METER TEST DETAILS                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/10/08   VY95550   INITIAL VERSION.                         *        
A01209*  11/02/09   SV95326   FIX FOR CSS_MTR_TEST_HIST UPDATE ISSUE.  *        
A01209*             ACT-010                                            *        
ACT084*  03/04/16   MC95456  REPLACE CSS_WQ_ITEMS_MF WITH              *        
ACT084*  APPL5460            CSS_WQ_ITEMS BY CALLING MCSCB077          *        
ACT084*                      REMOVE UNUSED COPYBOOKS.                  *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04222'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04222 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-COUNTER-FIELDS.                                           
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
ACT084 01  MCSCB077                    PIC X(08) VALUE 'MCSCB077'.      
ACT084 01  WS-MCSCB077-OUTPUT.                                          
ACT084     05  WS-MCSCB077-RET-CODE    PIC S9(09) COMP VALUE 0.         
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04222'.      
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-DATE-LAST-TESTED     PIC X(10) VALUE SPACES.          
           05  WS-LAST-TEST-SEL-DT     PIC X(10) VALUE SPACES.          
           05  WS-NEW-DATE-TEST        PIC X(10) VALUE SPACES.          
           05  WS-INSTALL-DT           PIC X(10) VALUE SPACES.          
           05  WS-STATUS-CODE          PIC X(01) VALUE SPACES.          
           05  WS-GROUP-CODE           PIC X(02) VALUE SPACES.          
COB305     05 WS-DEC-ACCURACY        PIC S9(3)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-TESTED-QTY           PIC S9(9) USAGE COMP.            
           05  WS-PREMISE-NO           PIC 9(10) VALUE 0.               
           05  WS-TEST-DATE.                                            
               10  WS-TEST-DATE-YYYY   PIC X(4) VALUE SPACES.           
               10  FILLER              PIC X(1).                        
               10  WS-TEST-MM          PIC X(2) VALUE SPACES.           
               10  FILLER              PIC X(1).                        
               10  WS-TEST-DD          PIC X(2) VALUE SPACES.           
      *                                                                         
       01  WS-FLAGS.                                                    
           05  WS-MTR-TEST-EXISTS      PIC X(01)  VALUE 'N'.            
               88 MTR-TEST-EXISTS                 VALUE 'Y'.            
           05  WS-FUTURE-DT-TEST-EXISTS PIC X(01) VALUE 'N'.            
               88 FUTURE-DT-TEST-EXISTS           VALUE 'Y'.            
      *                                                                         
       01  WS-NULL-IND.                                                 
           05 WS-DATE-LAST-TESTED-IND  PIC S9(4) COMP.                  
           05 WS-LAST-TEST-SEL-DT-IND  PIC S9(4) COMP.                  
           05 WS-INSTALL-DT-IND        PIC S9(4) COMP.                  
           05 WS-LOC-NO-IND            PIC S9(4) COMP.                  
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-LOCATION-RETIRED     PIC X(1) VALUE 'I'.              
           05  WS-DEFAULT-TIME-PERIOD  PIC S9(4) USAGE COMP VALUE 0.    
           05  WS-DEFAULT-CAP-TYPE     PIC X(1) VALUE 'A'.              
           05  WS-DEFAULT-TEST-TYPE    PIC X(1) VALUE 'A'.              
           05  WS-TEST-TYPE-N          PIC X(1) VALUE 'N'.              
           05  WS-TEST-RANDOM          PIC X(1) VALUE 'R'.              
           05  WS-DEFAULT-TEST-RESULT  PIC X(1) VALUE 'B'.              
           05  WS-OUT-INTER-RATE       PIC 9(1) VALUE 0.                
           05  WS-IN-INTER-RATE        PIC 9(1) VALUE 0.                
           05  WS-ACCURACY-THRESHHOLD  PIC S9(3)V9(2) USAGE COMP-3      
                                                VALUE 102.00.           
           05  WS-LOCATION-AT-CUSTOMER PIC X(1) VALUE 'J'.              
           05  WS-STATUS-B             PIC X(1) VALUE 'B'.              
           05  WS-STATUS-C             PIC X(1) VALUE 'C'.              
           05  WS-STATUS-D             PIC X(1) VALUE 'D'.              
           05  WS-NULL                 PIC S9(4) COMP VALUE -1.         
      *                                                                         
       01  WS-WQ-COMMENT.                                               
           05  WS-WQ-COMMENTS-TEXT     PIC X(55) VALUE                  
             'THE GAS METER HAS FAILED THE 2% HI/LO TEST - PERCENT = '. 
           05  WS-WQ-DEC-ACCURACY      PIC ZZ9.99.                      
           05  WS-WQ-DEVICE-NO         PIC X(09) VALUE SPACES.          
      *                                                                         
      **************************THIS IS THE ROW RETURN AREA*************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-UPDATE-IND           PIC X(01)  VALUE SPACES.         
               88 WS-INS-IND                      VALUE 'I'.            
               88 WS-UPD-IND                      VALUE 'U'.            
               88 WS-DEL-IND                      VALUE 'D'.            
           05  SEND-DONE-SW            PIC X(01)  VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT, AT                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CUST_PREM_HIST, CH                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIPMENT, EQ                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GAS_METER, GM                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_GAS_MTR_TEST, GT                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_TEST_HIST, MQ                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRTST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MOVEMENT_HIST, MV                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
ACT084*                                                                         
ACT084/***** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR MCSCB077              
ACT084     EXEC SQL                                                             
ACT084          INCLUDE CWS00077                                                
ACT084     END-EXEC.                                                            
ACT084                                                                  
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-UPDATE-IND              PIC X(01).                       
       01 PARM-CODE-UTIL-TYPE          PIC X(01).                       
       01 PARM-METER-NO                PIC X(09).                       
       01 PARM-SERIAL-NO               PIC X(11).                       
       01 PARM-DATE-TEST               PIC X(10).                       
       01 PARM-TIME-TEST               PIC X(08).                       
       01 PARM-CODE-REPAIR             PIC X(01).                       
       01 PARM-REPAIR-DESC             PIC X(44).                       
       01 PARM-CODE-TEST-TYPE          PIC X(01).                       
       01 PARM-CODE-TEST-LOC           PIC X(01).                       
COB305 01 PARM-IN-CHECK-RATE        PIC S9(3)V9(2) USAGE COMP-3 VALUE 0.     
COB305 01 PARM-IN-OPEN-RATE        PIC S9(3)V9(2) USAGE COMP-3 VALUE 0.     
COB305 01 PARM-IN-READ        PIC S9(9)V USAGE COMP-3 VALUE 0.     
COB305 01 PARM-OUT-CHECK-RATE        PIC S9(3)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
COB305 01 PARM-OUT-OPEN-RATE        PIC S9(3)V9(2) USAGE COMP-3 VALUE 0.     
COB305 01 PARM-OUT-READ        PIC S9(9)V USAGE COMP-3 VALUE 0.     
       01 PARM-EQ-TESTER-ID            PIC X(05).                       
       01 PARM-TEST-PROVER-ID          PIC X(06).                       
       01 PARM-COMPANY-NO              PIC X(02).                       
       01 PARM-USER-ID                 PIC X(07).                       
      *                                                                         
       PROCEDURE DIVISION USING                                         
                                  PARM-UPDATE-IND                       
                                , PARM-CODE-UTIL-TYPE                   
                                , PARM-METER-NO                         
                                , PARM-SERIAL-NO                        
                                , PARM-DATE-TEST                        
                                , PARM-TIME-TEST                        
                                , PARM-CODE-REPAIR                      
                                , PARM-REPAIR-DESC                      
                                , PARM-CODE-TEST-TYPE                   
                                , PARM-CODE-TEST-LOC                    
                                , PARM-IN-CHECK-RATE                    
                                , PARM-IN-OPEN-RATE                     
                                , PARM-IN-READ                          
                                , PARM-OUT-CHECK-RATE                   
                                , PARM-OUT-OPEN-RATE                    
                                , PARM-OUT-READ                         
                                , PARM-EQ-TESTER-ID                     
                                , PARM-TEST-PROVER-ID                   
                                , PARM-COMPANY-NO                       
                                , PARM-USER-ID.                         
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE           AS    RETURN_CODE                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE           AS    RETURN_CODE                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           PERFORM 7000-SELECT-CURR-DATE      THRU 7000-EXIT            
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE PARM-UPDATE-IND        TO WS-UPDATE-IND                 
           MOVE PARM-CODE-UTIL-TYPE    TO EQ-CODE-UTIL-TYPE             
                                          GM-CODE-UTIL-TYPE             
                                          GT-CODE-UTIL-TYPE             
                                          MQ-CODE-UTIL-TYPE             
                                          MV-CODE-UTIL-TYPE             
                                                                        
           MOVE PARM-METER-NO          TO GM-METER-NO                   
                                          GT-METER-NO                   
                                          EQ-DEVICE-NO                  
                                          MV-DEVICE-NO                  
                                                                        
           MOVE PARM-DATE-TEST         TO GT-DATE-TEST                  
           MOVE PARM-TIME-TEST         TO GT-TIME-TEST                  
           MOVE PARM-CODE-REPAIR       TO GT-CODE-REPAIR                
           MOVE PARM-REPAIR-DESC       TO GT-REPAIR-DESC                
           MOVE PARM-CODE-TEST-TYPE    TO GT-CODE-TEST-TYPE             
           MOVE PARM-CODE-TEST-LOC     TO GT-CODE-TEST-LOC              
           MOVE PARM-IN-CHECK-RATE     TO GT-IN-CHECK-RATE              
           MOVE PARM-IN-OPEN-RATE      TO GT-IN-OPEN-RATE               
           MOVE PARM-IN-READ           TO GT-IN-READ                    
           MOVE PARM-OUT-CHECK-RATE    TO GT-OUT-CHECK-RATE             
           MOVE PARM-OUT-OPEN-RATE     TO GT-OUT-OPEN-RATE              
           MOVE PARM-OUT-READ          TO GT-OUT-READ                   
           MOVE PARM-EQ-TESTER-ID      TO GT-EQ-TESTER-ID               
           MOVE PARM-TEST-PROVER-ID    TO GT-TEST-PROVER-ID             
                                                                        
           MOVE PARM-COMPANY-NO        TO EQ-COMPANY-NO                 
                                          GM-COMPANY-NO                 
                                          GT-COMPANY-NO                 
                                          MQ-COMPANY-NO                 
ACT084                                    MV-COMPANY-NO.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1200-VALIDATE-INPUT-ARGUMENTS                                  *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
           IF PARM-CODE-UTIL-TYPE NOT EQUAL TO 'G' OR                   
              PARM-COMPANY-NO     = SPACES         OR                   
              PARM-METER-NO       = SPACES         OR                   
              PARM-UPDATE-IND     = SPACES         OR                   
              (                                                         
              PARM-UPDATE-IND     NOT EQUAL TO 'I' AND                  
              PARM-UPDATE-IND     NOT EQUAL TO 'D' AND                  
              PARM-UPDATE-IND     NOT EQUAL TO 'U'                      
              )                                                         
                                                                        
              MOVE 9998                   TO WS-ACTIVE-RETURN-CODE      
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '1200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'VALIDATE'             TO ABEND-FUNCTION             
              MOVE 'N/A'                  TO TABLE-1                    
              MOVE 'PARM-CODE-UTIL-TYPE'  TO TABLE-ELEMENT-1            
              MOVE 'PARM-COMPANY-NO'      TO TABLE-ELEMENT-2            
              MOVE 'PARM-METER-NO'        TO TABLE-ELEMENT-3            
              MOVE 'PARM-UPDATE-IND'      TO TABLE-ELEMENT-4            
              MOVE PARM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1          
              MOVE PARM-COMPANY-NO        TO HOSTVAR-ELEMENT-2          
              MOVE PARM-METER-NO          TO HOSTVAR-ELEMENT-3          
              MOVE PARM-UPDATE-IND        TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                .                                                       
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7100-GET-EQUIP-DETAIL       THRU 7100-EXIT           
                                                                        
           IF EQ-SERIAL-NO NOT = PARM-SERIAL-NO                         
              MOVE    5100             TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           IF EQ-CODE-CRNT-LOC = WS-LOCATION-RETIRED                    
              MOVE    5200             TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-INS-IND                                           
                 PERFORM 2200-INSERT-PROCESS     THRU 2200-EXIT         
              WHEN WS-DEL-IND                                           
                 PERFORM 2300-DELETE-PROCESS     THRU 2300-EXIT         
              WHEN WS-UPD-IND                                           
                 PERFORM 2400-UPDATE-PROCESS     THRU 2400-EXIT         
           END-EVALUATE.                                                
                                                                        
           MOVE RS-RETURN-CODE          TO S-RETURN-CODE.               
           ADD 1                        TO CTR-ROWS.                    
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-INSERT-PROCESS.                                           *        
      ******************************************************************        
       2200-INSERT-PROCESS.                                             
                                                                        
           PERFORM 2500-PROCESS-GASMTR-VAL     THRU 2500-EXIT           
A01209     IF  WS-DATE-LAST-TESTED-IND = WS-NULL                        
A01209         MOVE SPACES               TO GM-DATE-LAST-TESTED         
A01209     END-IF.                                                      
      *                                                                         
A01209     IF  WS-LAST-TEST-SEL-DT-IND = WS-NULL                        
A01209         CONTINUE                                                 
A01209     ELSE                                                         
A01209        IF GM-LAST-TEST-SEL-CD NOT = SPACES AND                   
A01209           GM-LAST-TEST-SEL-DT > GM-DATE-LAST-TESTED              
A01209              PERFORM 2700-PROCESS-MTR-HIST THRU 2700-EXIT        
A01209     END-IF
           END-IF.                                                      
           MOVE WS-CURRENT-DATE        TO EQ-DATE-LAST-TRAN             
           PERFORM 8200-UPDATE-LAST-TRAN       THRU 8200-EXIT           
                                                                        
           MOVE PARM-DATE-TEST         TO GM-DATE-LAST-TESTED           
           IF GM-DATE-LAST-TESTED = SPACES                              
              MOVE -1                  TO WS-DATE-LAST-TESTED-IND       
           ELSE                                                         
              MOVE 0                   TO WS-DATE-LAST-TESTED-IND       
           END-IF                                                       
           PERFORM 8300-UPDATE-LAST-TESTED     THRU 8300-EXIT           
           MOVE WS-DATE-LAST-TESTED    TO GM-DATE-LAST-TESTED           
                                                                        
           MOVE WS-IN-INTER-RATE       TO GT-IN-INTER-RATE              
           MOVE WS-OUT-INTER-RATE      TO GT-OUT-INTER-RATE             
           MOVE WS-DEFAULT-TEST-RESULT TO GT-CODE-TEST-RESULT           
                                                                        
           PERFORM 8400-INSERT-GAS-MTR-TEST    THRU 8400-EXIT           
                                                                        
           COMPUTE WS-DEC-ACCURACY = ( PARM-IN-CHECK-RATE +             
                                       PARM-IN-OPEN-RATE ) / 2          
                                                                        
           IF WS-DEC-ACCURACY > WS-ACCURACY-THRESHHOLD                  
              PERFORM 2800-PROCESS-INS-WQITEMS THRU 2800-EXIT           
           END-IF                                                       
                                                                        
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-DELETE-PROCESS.                                           *        
      ******************************************************************        
       2300-DELETE-PROCESS.                                             
                                                                        
           PERFORM 8600-DELETE-GM-TEST         THRU 8600-EXIT           
           PERFORM 7850-SELECT-DATE-TEST       THRU 7850-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01209        MOVE GT-DATE-TEST        TO GM-DATE-LAST-TESTED           
A01209        MOVE ZERO                TO WS-DATE-LAST-TESTED-IND       
           ELSE                                                         
A01209        MOVE -1                  TO WS-DATE-LAST-TESTED-IND       
           END-IF                                                       
                                                                        
           PERFORM 8300-UPDATE-LAST-TESTED     THRU 8300-EXIT           
A01209     PERFORM 7300-GET-GAS-MTR-DETAIL     THRU 7300-EXIT           
A01209     IF  WS-DATE-LAST-TESTED-IND = WS-NULL                        
A01209         MOVE SPACES               TO GM-DATE-LAST-TESTED         
A01209     END-IF.                                                      
A01209     IF  WS-LAST-TEST-SEL-DT-IND = WS-NULL                        
A01209         CONTINUE                                                 
A01209     ELSE                                                         
A01209        IF GM-LAST-TEST-SEL-CD NOT = SPACES AND                   
A01209           GM-LAST-TEST-SEL-DT > GM-DATE-LAST-TESTED              
A01209              PERFORM 2700-PROCESS-MTR-HIST THRU 2700-EXIT        
A01209     END-IF
           END-IF.                                                      
                                                                        
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-UPDATE-PROCESS.                                           *        
      ******************************************************************        
       2400-UPDATE-PROCESS.                                             
                                                                        
           IF PARM-TIME-TEST = SPACES                                   
              PERFORM 7900-GET-GMTEST-WITH-DATE THRU 7900-EXIT          
           ELSE                                                         
              PERFORM 7950-GET-GMTEST-WITH-TIME THRU 7950-EXIT          
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE    5300             TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           IF (GT-CODE-TEST-TYPE   = PARM-CODE-TEST-TYPE  AND           
               GT-CODE-TEST-LOC    = PARM-CODE-TEST-LOC   AND           
               GT-EQ-TESTER-ID     = PARM-EQ-TESTER-ID    AND           
               GT-IN-READ          = PARM-IN-READ         AND           
               GT-IN-CHECK-RATE    = PARM-IN-CHECK-RATE   AND           
               GT-IN-OPEN-RATE     = PARM-IN-OPEN-RATE    AND           
               GT-TEST-PROVER-ID   = PARM-TEST-PROVER-ID  AND           
               GT-OUT-READ         = PARM-OUT-READ        AND           
               GT-OUT-CHECK-RATE   = PARM-OUT-CHECK-RATE  AND           
               GT-OUT-OPEN-RATE    = PARM-OUT-OPEN-RATE   AND           
               GT-CODE-REPAIR      = PARM-CODE-REPAIR     AND           
               GT-REPAIR-DESC      = PARM-REPAIR-DESC )                 
                                                                        
               MOVE    5400             TO S-RETURN-CODE                
               ADD 1                    TO CTR-ROWS                     
               PERFORM 9999-END-PROGRAM        THRU 9999-EXIT           
           ELSE                                                         
                                                                        
               MOVE WS-IN-INTER-RATE       TO GT-IN-INTER-RATE          
               MOVE WS-OUT-INTER-RATE      TO GT-OUT-INTER-RATE         
               MOVE PARM-CODE-REPAIR       TO GT-CODE-REPAIR            
               MOVE PARM-REPAIR-DESC       TO GT-REPAIR-DESC            
               MOVE PARM-CODE-TEST-TYPE    TO GT-CODE-TEST-TYPE         
               MOVE PARM-CODE-TEST-LOC     TO GT-CODE-TEST-LOC          
               MOVE PARM-IN-CHECK-RATE     TO GT-IN-CHECK-RATE          
               MOVE PARM-IN-OPEN-RATE      TO GT-IN-OPEN-RATE           
               MOVE PARM-IN-READ           TO GT-IN-READ                
               MOVE PARM-OUT-CHECK-RATE    TO GT-OUT-CHECK-RATE         
               MOVE PARM-OUT-OPEN-RATE     TO GT-OUT-OPEN-RATE          
               MOVE PARM-OUT-READ          TO GT-OUT-READ               
               MOVE PARM-EQ-TESTER-ID      TO GT-EQ-TESTER-ID           
               MOVE PARM-TEST-PROVER-ID    TO GT-TEST-PROVER-ID         
                                                                        
               PERFORM 8700-UPDATE-GAS-MTR-TEST THRU 8700-EXIT          
                                                                        
               IF GT-CODE-TEST-RESULT = WS-DEFAULT-TEST-RESULT          
                                                                        
                  COMPUTE WS-DEC-ACCURACY = ( PARM-IN-CHECK-RATE +      
                                              PARM-IN-OPEN-RATE ) / 2   
                                                                        
                  IF WS-DEC-ACCURACY > WS-ACCURACY-THRESHHOLD           
                     PERFORM 2800-PROCESS-INS-WQITEMS THRU 2800-EXIT    
                  END-IF                                                
               END-IF                                                   
               MOVE WS-CURRENT-DATE        TO EQ-DATE-LAST-TRAN         
               PERFORM 8200-UPDATE-LAST-TRAN    THRU 8200-EXIT          
                                                                        
           END-IF                                                       
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-PROCESS-GASMTR-VAL                                        *        
      ******************************************************************        
       2500-PROCESS-GASMTR-VAL.                                         
                                                                        
           MOVE WS-CURRENT-DATE        TO GM-DATE-LAST-TESTED           
                                          GT-DATE-TEST                  
           PERFORM 7300-GET-GAS-MTR-DETAIL     THRU 7300-EXIT           
                                                                        
           IF WS-DATE-LAST-TESTED-IND = 0                               
              MOVE GM-DATE-LAST-TESTED TO WS-DATE-LAST-TESTED           
           ELSE                                                         
              MOVE WS-CURRENT-DATE     TO WS-DATE-LAST-TESTED           
           END-IF                                                       
                                                                        
           IF PARM-DATE-TEST < WS-DATE-LAST-TESTED AND                  
              WS-DATE-LAST-TESTED-IND = 0                               
              MOVE    5300             TO S-RETURN-CODE                 
              ADD 1                    TO CTR-ROWS                      
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 7200-CHECK-GAS-MTR-TEST     THRU 7200-EXIT           
           IF MTR-TEST-EXISTS AND PARM-CODE-TEST-TYPE = WS-TEST-TYPE-N  
                 MOVE    5400          TO S-RETURN-CODE                 
                 ADD 1                 TO CTR-ROWS                      
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
           END-IF                                                       
                                                                        
           MOVE PARM-DATE-TEST         TO GT-DATE-TEST                  
           IF PARM-TIME-TEST = SPACES                                   
              PERFORM 7900-GET-GMTEST-WITH-DATE THRU 7900-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE    5500          TO S-RETURN-CODE                 
                 ADD 1                 TO CTR-ROWS                      
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
           ELSE                                                         
              PERFORM 7950-GET-GMTEST-WITH-TIME THRU 7950-EXIT          
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE    5600          TO S-RETURN-CODE                 
                 ADD 1                 TO CTR-ROWS                      
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
           END-IF                                                       
                                                                        
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-PROCESS-MTR-HIST.                                         *        
      ******************************************************************        
       2700-PROCESS-MTR-HIST.                                           
                                                                        
A01209     MOVE GM-TEST-SCHED-CD           TO MQ-TEST-SCHED-CD          
A01209     MOVE GM-LAST-TEST-SEL-DT(1:4)   TO MQ-TEST-YEAR              
A01209     IF GM-TEST-SCHED-CD = WS-TEST-RANDOM                         
A01209        MOVE GM-LAST-TEST-SEL-CD    TO MQ-MTR-TEST-GRP-CD         
A01209     ELSE                                                         
A01209        MOVE SPACES                 TO MQ-MTR-TEST-GRP-CD         
A01209     END-IF                                                       
                                                                        
A01209     PERFORM 7600-GET-MTR-TEST-HIST   THRU 7600-EXIT              
A01209     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A01209        GO TO 2700-EXIT                                           
A01209     END-IF                                                       
                                                                        
           IF MQ-STATUS-CD = WS-STATUS-B                                
              MOVE WS-STATUS-C         TO WS-STATUS-CODE                
           ELSE                                                         
              MOVE MQ-STATUS-CD        TO WS-STATUS-CODE                
           END-IF                                                       
                                                                        
           MOVE MQ-TESTED-QT           TO WS-TESTED-QTY                 
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-INS-IND                                           
                 ADD      1            TO WS-TESTED-QTY                 
              WHEN WS-DEL-IND                                           
                 SUBTRACT 1            FROM WS-TESTED-QTY               
           END-EVALUATE.                                                
                                                                        
           IF ( MQ-TEST-SCHED-CD NOT = WS-TEST-RANDOM                   
                AND WS-TESTED-QTY >= MQ-SELECTED-QT )  OR               
              ( GM-TEST-SCHED-CD   = WS-TEST-RANDOM                     
                AND WS-TESTED-QTY >= MQ-SAMPLE-MIN-QT)                  
                                                                        
              MOVE WS-STATUS-D         TO WS-STATUS-CODE                
           END-IF                                                       
                                                                        
           MOVE  WS-TESTED-QTY         TO MQ-TESTED-QT                  
           MOVE  WS-STATUS-CODE        TO MQ-STATUS-CD                  
                                                                        
           PERFORM 8100-UPDATE-TEST-HIST       THRU 8100-EXIT           
                                                                        
           .                                                            
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800-PROCESS-INS-WQITEMS.                                      *        
      ******************************************************************        
       2800-PROCESS-INS-WQITEMS.                                        
                                                                        
           IF WS-INSTALL-DT-IND = WS-NULL                               
              MOVE WS-CURRENT-DATE     TO WS-INSTALL-DT                 
           ELSE                                                         
              MOVE EQ-INSTALL-DT       TO WS-INSTALL-DT                 
           END-IF                                                       
                                                                        
           IF WS-INSTALL-DT-IND = WS-NULL AND                           
              EQ-CODE-CRNT-LOC  = WS-LOCATION-AT-CUSTOMER               
                                                                        
              MOVE EQ-CRNT-LOC-NO      TO WS-PREMISE-NO                 
                                                                        
           ELSE                                                         
                IF PARM-DATE-TEST  > WS-INSTALL-DT AND                  
                   EQ-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER           
                                                                        
                   MOVE EQ-CRNT-LOC-NO TO WS-PREMISE-NO                 
                ELSE                                                    
                   MOVE PARM-DATE-TEST TO MV-DATE-MOVE                  
                   MOVE WS-LOCATION-AT-CUSTOMER TO MV-CODE-CRNT-LOC     
                   PERFORM 7700-GET-MOVE-HIST  THRU 7700-EXIT           
                                                                        
                   IF WS-LOC-NO-IND NOT = WS-NULL                       
                      MOVE MV-LOC-NO   TO WS-PREMISE-NO                 
                   END-IF                                               
                END-IF                                                  
           END-IF                                                       
                                                                        
           PERFORM 5100-CREATE-WORK-QUEUE      THRU 5100-EXIT           
                                                                        
           .                                                            
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-CREATE-WORK-QUEUE.                                        *        
      ******************************************************************        
       5100-CREATE-WORK-QUEUE.                                          
                                                                        
ACT084     INITIALIZE CWS00077-FIELDS.                                  
ACT084     MOVE ZERO                   TO WS-77-SERV-ORDER-NO           
ACT084     MOVE 133                    TO WS-77-CATEGORY-ID             
                                                                        
           MOVE WS-PREMISE-NO          TO CH-PREMISE-NO                 
ACT084                                    WS-77-PREMISE-NO              
                                                                        
           PERFORM 7800-SELECT-ACCOUNT-DETAIL  THRU 7800-EXIT           
                                                                        
ACT084     MOVE CH-ACCOUNT-NO          TO WS-77-ACCOUNT-NO              
ACT084     MOVE AT-CUSTOMER-NO         TO WS-77-CUSTOMER-NO             
ACT084     MOVE AT-LOCAL-OFFICE        TO WS-77-LOCAL-OFFICE            
ACT084     MOVE PARM-USER-ID           TO WS-77-USER-ID-ORIG            
ACT084     MOVE SPACES                 TO WS-77-RESP-AREA-ID            
ACT084     MOVE 4                      TO WS-77-ROUTE-CATEGORY          
ACT084     MOVE 'N'                    TO WS-77-PRIORITY                
ACT084     MOVE ZERO                   TO WS-77-FREE-FORM-LEN           
ACT084     MOVE LOW-VALUES             TO WS-77-FREE-FORM-TXT           
                                                                        
           MOVE EQ-DEVICE-NO           TO WS-WQ-DEVICE-NO               
           MOVE WS-DEC-ACCURACY        TO WS-WQ-DEC-ACCURACY            
                                                                        
ACT084     MOVE WS-WQ-COMMENT          TO WS-77-COMMENTS-TEXT           
ACT084     MOVE LENGTH OF WS-77-COMMENTS-TEXT                           
ACT084                                 TO WS-77-COMMENTS-LEN            
                                                                        
ACT084     MOVE WS-CURRENT-DATE        TO WS-77-DATE-REQUIRED           
ACT084                                    WS-77-DATE-CREATED            
ACT084     MOVE PROGRAM-NAME           TO WS-77-CREATED-BY              
           PERFORM 8500-INSERT-WQ-ITEM         THRU 8500-EXIT           
                                                                        
           .                                                            
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-CURR-DATE.                                         *        
      ******************************************************************        
       7000-SELECT-CURR-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7000'             TO ACTIVE-PARAGRAPH              
               MOVE 'SET'              TO ABEND-FUNCTION                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-GET-EQUIP-DETAIL.                                         *        
      ******************************************************************        
       7100-GET-EQUIP-DETAIL.                                           
                                                                        
           EXEC SQL                                                     
               SELECT EQ.SERIAL_NO                                      
                     ,EQ.CODE_CRNT_LOC                                  
                     ,EQ.INSTALL_DT                                     
                     ,EQ.CRNT_LOC_NO                                    
                     ,EQ.DEVICE_NO                                      
                 INTO                                                   
                      :EQ-SERIAL-NO                                     
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-INSTALL-DT :WS-INSTALL-DT-IND                  
                     ,:EQ-CRNT-LOC-NO                                   
                     ,:EQ-DEVICE-NO                                     
                 FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                    
                WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                
                  AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE            
                  AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EQ.SERIAL_NO                                              
MFA-TR*              ,EQ.CODE_CRNT_LOC                                          
MFA-TR*              ,EQ.INSTALL_DT                                             
MFA-TR*              ,EQ.CRNT_LOC_NO                                            
MFA-TR*              ,EQ.DEVICE_NO                                              
MFA-TR*          INTO                                                           
MFA-TR*               :EQ-SERIAL-NO                                             
MFA-TR*              ,:EQ-CODE-CRNT-LOC                                         
MFA-TR*              ,:EQ-INSTALL-DT:WS-INSTALL-DT-IND                          
MFA-TR*              ,:EQ-CRNT-LOC-NO                                           
MFA-TR*              ,:EQ-DEVICE-NO                                             
MFA-TR*          FROM CSS_EQUIPMENT EQ                                          
MFA-TR*         WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                        
MFA-TR*           AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                    
MFA-TR*           AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7100'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_EQUIPMENT'    TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
               MOVE 'DEVICE_NO'        TO TABLE-ELEMENT-3               
               MOVE EQ-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE EQ-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
               MOVE EQ-DEVICE-NO       TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CHECK-GAS-MTR-TEST.                                       *        
      ******************************************************************        
       7200-CHECK-GAS-MTR-TEST.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-MTR-TEST-EXISTS                               
                 FROM CSS_GAS_MTR_TEST GT WITH(READUNCOMMITTED)                 
                WHERE GT.COMPANY_NO       = :GT-COMPANY-NO              
                  AND GT.CODE_UTIL_TYPE   = :GT-CODE-UTIL-TYPE          
                  AND GT.METER_NO         = :GT-METER-NO                
                  AND GT.DATE_TEST       <= IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )               
                  AND GT.CODE_TIME_PERIOD = :WS-DEFAULT-TIME-PERIOD     
                  AND GT.CODE_CAP_TYPE    = :WS-DEFAULT-CAP-TYPE        
                  AND GT.CODE_TEST_TYPE   = :WS-DEFAULT-TEST-TYPE       
                ORDER BY GT.DATE_TEST DESC                              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-MTR-TEST-EXISTS                                       
MFA-TR*          FROM CSS_GAS_MTR_TEST GT                                       
MFA-TR*         WHERE GT.COMPANY_NO       = :GT-COMPANY-NO                      
MFA-TR*           AND GT.CODE_UTIL_TYPE   = :GT-CODE-UTIL-TYPE                  
MFA-TR*           AND GT.METER_NO         = :GT-METER-NO                        
MFA-TR*           AND GT.DATE_TEST       <= :GT-DATE-TEST                       
MFA-TR*           AND GT.CODE_TIME_PERIOD = :WS-DEFAULT-TIME-PERIOD             
MFA-TR*           AND GT.CODE_CAP_TYPE    = :WS-DEFAULT-CAP-TYPE                
MFA-TR*           AND GT.CODE_TEST_TYPE   = :WS-DEFAULT-TEST-TYPE               
MFA-TR*         ORDER BY GT.DATE_TEST DESC                                      
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7200'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-3               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-GAS-MTR-DETAIL.                                       *        
      ******************************************************************        
       7300-GET-GAS-MTR-DETAIL.                                         
                                                                        
           EXEC SQL                                                     
               SELECT GM.DATE_LAST_TESTED                               
                     ,GM.TEST_SCHED_CD                                  
                     ,GM.LAST_TEST_SEL_CD                               
                     ,GM.LAST_TEST_SEL_DT                               
                 INTO :GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND      
                     ,:GM-TEST-SCHED-CD                                 
                     ,:GM-LAST-TEST-SEL-CD                              
                     ,:GM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-DT-IND      
                 FROM CSS_GAS_METER GM WITH(READUNCOMMITTED)                    
                WHERE GM.COMPANY_NO     = :GM-COMPANY-NO                
                  AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE            
                  AND GM.METER_NO       = :GM-METER-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GM.DATE_LAST_TESTED                                       
MFA-TR*              ,GM.TEST_SCHED_CD                                          
MFA-TR*              ,GM.LAST_TEST_SEL_CD                                       
MFA-TR*              ,GM.LAST_TEST_SEL_DT                                       
MFA-TR*          INTO :GM-DATE-LAST-TESTED:WS-DATE-LAST-TESTED-IND              
MFA-TR*              ,:GM-TEST-SCHED-CD                                         
MFA-TR*              ,:GM-LAST-TEST-SEL-CD                                      
MFA-TR*              ,:GM-LAST-TEST-SEL-DT:WS-LAST-TEST-SEL-DT-IND              
MFA-TR*          FROM CSS_GAS_METER GM                                          
MFA-TR*         WHERE GM.COMPANY_NO     = :GM-COMPANY-NO                        
MFA-TR*           AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE                    
MFA-TR*           AND GM.METER_NO       = :GM-METER-NO                          
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 CONTINUE                                               
           ELSE                                                         
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7300'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_GAS_METER'    TO TABLE-1                     
                 MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1             
                 MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2             
                 MOVE 'METER_NO'         TO TABLE-ELEMENT-3             
                 MOVE GM-COMPANY-NO      TO HOSTVAR-ELEMENT-1           
                 MOVE GM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2           
                 MOVE GM-METER-NO        TO HOSTVAR-ELEMENT-3           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-CHECK-GT-LAST-TEST-SEL.                                   *        
      ******************************************************************        
       7400-CHECK-GT-LAST-TEST-SEL.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-FUTURE-DT-TEST-EXISTS                         
                 FROM CSS_GAS_MTR_TEST GT WITH(READUNCOMMITTED)                 
                WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                
                  AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE            
                  AND GT.METER_NO       = :GT-METER-NO                  
                  AND GT.DATE_TEST     >= IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                 
                ORDER BY GT.DATE_TEST DESC                              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-FUTURE-DT-TEST-EXISTS                                 
MFA-TR*          FROM CSS_GAS_MTR_TEST GT                                       
MFA-TR*         WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                        
MFA-TR*           AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                    
MFA-TR*           AND GT.METER_NO       = :GT-METER-NO                          
MFA-TR*           AND GT.DATE_TEST     >= :GT-DATE-TEST                         
MFA-TR*         ORDER BY GT.DATE_TEST DESC                                      
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7400'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-3               
               MOVE 'DATE_TEST'        TO TABLE-ELEMENT-4               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-3             
               MOVE GT-DATE-TEST       TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7600-GET-MTR-TEST-HIST.                                        *        
      ******************************************************************        
       7600-GET-MTR-TEST-HIST.                                          
                                                                        
           EXEC SQL                                                     
               SELECT MQ.SELECTED_QT                                    
                     ,MQ.STATUS_CD                                      
                     ,MQ.SAMPLE_MIN_QT                                  
                     ,MQ.TESTED_QT                                      
                     ,MQ.TEST_SCHED_CD                                  
                 INTO :MQ-SELECTED-QT                                   
                     ,:MQ-STATUS-CD                                     
                     ,:MQ-SAMPLE-MIN-QT                                 
                     ,:MQ-TESTED-QT                                     
                     ,:MQ-TEST-SCHED-CD                                 
                 FROM CSS_MTR_TEST_HIST MQ WITH(READUNCOMMITTED)                
                WHERE MQ.COMPANY_NO      = :MQ-COMPANY-NO               
                  AND MQ.CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE           
                  AND MQ.TEST_YEAR       = :MQ-TEST-YEAR                
                  AND MQ.TEST_SCHED_CD  =  :MQ-TEST-SCHED-CD            
                  AND MQ.MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MQ.SELECTED_QT                                            
MFA-TR*              ,MQ.STATUS_CD                                              
MFA-TR*              ,MQ.SAMPLE_MIN_QT                                          
MFA-TR*              ,MQ.TESTED_QT                                              
MFA-TR*              ,MQ.TEST_SCHED_CD                                          
MFA-TR*          INTO :MQ-SELECTED-QT                                           
MFA-TR*              ,:MQ-STATUS-CD                                             
MFA-TR*              ,:MQ-SAMPLE-MIN-QT                                         
MFA-TR*              ,:MQ-TESTED-QT                                             
MFA-TR*              ,:MQ-TEST-SCHED-CD                                         
MFA-TR*          FROM CSS_MTR_TEST_HIST MQ                                      
MFA-TR*         WHERE MQ.COMPANY_NO      = :MQ-COMPANY-NO                       
MFA-TR*           AND MQ.CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE                   
MFA-TR*           AND MQ.TEST_YEAR       = :MQ-TEST-YEAR                        
MFA-TR*           AND MQ.TEST_SCHED_CD  =  :MQ-TEST-SCHED-CD                    
MFA-TR*           AND MQ.MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD                  
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '7600'              TO ACTIVE-PARAGRAPH             
               MOVE 'SELECT'            TO ABEND-FUNCTION               
               MOVE 'CSS_MTR_TEST_HIST' TO TABLE-1                      
               MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1              
               MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2              
               MOVE 'TEST_YEAR'         TO TABLE-ELEMENT-3              
               MOVE 'MTR_TEST_GRP_CD'   TO TABLE-ELEMENT-4              
               MOVE MQ-COMPANY-NO       TO HOSTVAR-ELEMENT-1            
               MOVE MQ-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2            
               MOVE MQ-TEST-YEAR        TO HOSTVAR-ELEMENT-3            
               MOVE MQ-MTR-TEST-GRP-CD  TO HOSTVAR-ELEMENT-4            
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-GET-MOVE-HIST.                                            *        
      ******************************************************************        
       7700-GET-MOVE-HIST.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MV.LOC_NO                                         
                 INTO :MV-LOC-NO :WS-LOC-NO-IND                          
                 FROM CSS_MOVEMENT_HIST MV WITH(READUNCOMMITTED)                
                WHERE MV.COMPANY_NO     = :MV-COMPANY-NO                
                  AND MV.CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE            
                  AND MV.DEVICE_NO      = :MV-DEVICE-NO                 
                  AND MV.CODE_CRNT_LOC  = :MV-CODE-CRNT-LOC             
                  AND MV.DATE_MOVE     <= IIF(TRY_CONVERT(DATE, 
                                                          :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                 
                ORDER BY MV.DATE_MOVE DESC                              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MV.LOC_NO                                                 
MFA-TR*          INTO :MV-LOC-NO:WS-LOC-NO-IND                                  
MFA-TR*          FROM CSS_MOVEMENT_HIST MV                                      
MFA-TR*         WHERE MV.COMPANY_NO     = :MV-COMPANY-NO                        
MFA-TR*           AND MV.CODE_UTIL_TYPE = :MV-CODE-UTIL-TYPE                    
MFA-TR*           AND MV.DEVICE_NO      = :MV-DEVICE-NO                         
MFA-TR*           AND MV.CODE_CRNT_LOC  = :MV-CODE-CRNT-LOC                     
MFA-TR*           AND MV.DATE_MOVE     <= :MV-DATE-MOVE                         
MFA-TR*         ORDER BY MV.DATE_MOVE DESC                                      
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7700'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_MOVEMENT_HIST' TO TABLE-1                      
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'DEVICE_NO'        TO TABLE-ELEMENT-2               
               MOVE 'CODE_CRNT_LOC'    TO TABLE-ELEMENT-3               
               MOVE 'DATE_MOVE'        TO TABLE-ELEMENT-4               
               MOVE MV-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE MV-DEVICE-NO       TO HOSTVAR-ELEMENT-2             
               MOVE MV-CODE-CRNT-LOC                                    
                                       TO HOSTVAR-ELEMENT-3             
               MOVE MV-DATE-MOVE       TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7800-SELECT-ACCOUNT-DETAIL.                                    *        
      ******************************************************************        
       7800-SELECT-ACCOUNT-DETAIL.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CH.ACCOUNT_NO,
              AT.CUSTOMER_NO,
              AT.LOCAL_OFFICE                                   
                 INTO :CH-ACCOUNT-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-LOCAL-OFFICE                                  
                 FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               
                     ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE CH.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND CH.PREMISE_NO = :CH-PREMISE-NO                    
                ORDER BY CH.DATE_UTIL_SVC_STRT DESC                     
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CH.ACCOUNT_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*          INTO :CH-ACCOUNT-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_CUST_PREM_HIST CH                                     
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*         WHERE CH.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND CH.PREMISE_NO = :CH-PREMISE-NO                            
MFA-TR*         ORDER BY CH.DATE_UTIL_SVC_STRT DESC                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7800'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                     
               MOVE 'CSS_ACCOUNT'      TO TABLE-2                       
               MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1               
               MOVE CH-PREMISE-NO      TO HOSTVAR-ELEMENT-1             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7850-SELECT-DATE-TEST.                                         *        
      ******************************************************************        
       7850-SELECT-DATE-TEST.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) GT.DATE_TEST                                      
                 INTO :GT-DATE-TEST                                     
                 FROM CSS_GAS_MTR_TEST GT WITH(READUNCOMMITTED)                 
                WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                
                  AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE            
                  AND GT.METER_NO       = :GT-METER-NO                  
                ORDER BY GT.DATE_TEST DESC                              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GT.DATE_TEST                                              
MFA-TR*          INTO :GT-DATE-TEST                                             
MFA-TR*          FROM CSS_GAS_MTR_TEST GT                                       
MFA-TR*         WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                        
MFA-TR*           AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                    
MFA-TR*           AND GT.METER_NO       = :GT-METER-NO                          
MFA-TR*         ORDER BY GT.DATE_TEST DESC                                      
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7850'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-3               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7900-GET-GMTEST-WITH-DATE.                                     *        
      ******************************************************************        
       7900-GET-GMTEST-WITH-DATE.                                       
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                      CODE_TEST_TYPE                                    
                     ,CODE_TEST_LOC                                     
                     ,CODE_TEST_RESULT                                  
                     ,EQ_TESTER_ID                                      
                     ,IN_READ                                           
                     ,IN_CHECK_RATE                                     
                     ,IN_OPEN_RATE                                      
                     ,TEST_PROVER_ID                                    
                     ,OUT_READ                                          
                     ,OUT_CHECK_RATE                                    
                     ,OUT_OPEN_RATE                                     
                     ,CODE_REPAIR                                       
                     ,REPAIR_DESC                                       
                 INTO                                                   
                      :GT-CODE-TEST-TYPE                                
                     ,:GT-CODE-TEST-LOC                                 
                     ,:GT-CODE-TEST-RESULT                              
                     ,:GT-EQ-TESTER-ID                                  
                     ,:GT-IN-READ                                       
                     ,:GT-IN-CHECK-RATE                                 
                     ,:GT-IN-OPEN-RATE                                  
                     ,:GT-TEST-PROVER-ID                                
                     ,:GT-OUT-READ                                      
                     ,:GT-OUT-CHECK-RATE                                
                     ,:GT-OUT-OPEN-RATE                                 
                     ,:GT-CODE-REPAIR                                   
                     ,:GT-REPAIR-DESC                                   
                 FROM CSS_GAS_MTR_TEST GT WITH(READUNCOMMITTED)                 
                WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                
                  AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE            
                  AND GT.METER_NO       = :GT-METER-NO                  
                  AND GT.DATE_TEST      = IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               CODE_TEST_TYPE                                            
MFA-TR*              ,CODE_TEST_LOC                                             
MFA-TR*              ,CODE_TEST_RESULT                                          
MFA-TR*              ,EQ_TESTER_ID                                              
MFA-TR*              ,IN_READ                                                   
MFA-TR*              ,IN_CHECK_RATE                                             
MFA-TR*              ,IN_OPEN_RATE                                              
MFA-TR*              ,TEST_PROVER_ID                                            
MFA-TR*              ,OUT_READ                                                  
MFA-TR*              ,OUT_CHECK_RATE                                            
MFA-TR*              ,OUT_OPEN_RATE                                             
MFA-TR*              ,CODE_REPAIR                                               
MFA-TR*              ,REPAIR_DESC                                               
MFA-TR*          INTO                                                           
MFA-TR*               :GT-CODE-TEST-TYPE                                        
MFA-TR*              ,:GT-CODE-TEST-LOC                                         
MFA-TR*              ,:GT-CODE-TEST-RESULT                                      
MFA-TR*              ,:GT-EQ-TESTER-ID                                          
MFA-TR*              ,:GT-IN-READ                                               
MFA-TR*              ,:GT-IN-CHECK-RATE                                         
MFA-TR*              ,:GT-IN-OPEN-RATE                                          
MFA-TR*              ,:GT-TEST-PROVER-ID                                        
MFA-TR*              ,:GT-OUT-READ                                              
MFA-TR*              ,:GT-OUT-CHECK-RATE                                        
MFA-TR*              ,:GT-OUT-OPEN-RATE                                         
MFA-TR*              ,:GT-CODE-REPAIR                                           
MFA-TR*              ,:GT-REPAIR-DESC                                           
MFA-TR*          FROM CSS_GAS_MTR_TEST GT                                       
MFA-TR*         WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                        
MFA-TR*           AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                    
MFA-TR*           AND GT.METER_NO       = :GT-METER-NO                          
MFA-TR*           AND GT.DATE_TEST      = :GT-DATE-TEST                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7900'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-3               
               MOVE 'DATE_TEST'        TO TABLE-ELEMENT-4               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-3             
               MOVE GT-DATE-TEST       TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7950-GET-GMTEST-WITH-TIME.                                     *        
      ******************************************************************        
       7950-GET-GMTEST-WITH-TIME.                                       
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                      CODE_TEST_TYPE                                    
                     ,CODE_TEST_LOC                                     
                     ,CODE_TEST_RESULT                                  
                     ,EQ_TESTER_ID                                      
                     ,IN_READ                                           
                     ,IN_CHECK_RATE                                     
                     ,IN_OPEN_RATE                                      
                     ,TEST_PROVER_ID                                    
                     ,OUT_READ                                          
                     ,OUT_CHECK_RATE                                    
                     ,OUT_OPEN_RATE                                     
                     ,CODE_REPAIR                                       
                     ,REPAIR_DESC                                       
                 INTO                                                   
                      :GT-CODE-TEST-TYPE                                
                     ,:GT-CODE-TEST-LOC                                 
                     ,:GT-CODE-TEST-RESULT                              
                     ,:GT-EQ-TESTER-ID                                  
                     ,:GT-IN-READ                                       
                     ,:GT-IN-CHECK-RATE                                 
                     ,:GT-IN-OPEN-RATE                                  
                     ,:GT-TEST-PROVER-ID                                
                     ,:GT-OUT-READ                                      
                     ,:GT-OUT-CHECK-RATE                                
                     ,:GT-OUT-OPEN-RATE                                 
                     ,:GT-CODE-REPAIR                                   
                     ,:GT-REPAIR-DESC                                   
                 FROM CSS_GAS_MTR_TEST GT WITH(READUNCOMMITTED)                 
                WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                
                  AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE            
                  AND GT.METER_NO       = :GT-METER-NO                  
                  AND GT.DATE_TEST      = IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                 
                  AND GT.TIME_TEST      = CIS.CHAR2TIME(:GT-TIME-TEST)          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               CODE_TEST_TYPE                                            
MFA-TR*              ,CODE_TEST_LOC                                             
MFA-TR*              ,CODE_TEST_RESULT                                          
MFA-TR*              ,EQ_TESTER_ID                                              
MFA-TR*              ,IN_READ                                                   
MFA-TR*              ,IN_CHECK_RATE                                             
MFA-TR*              ,IN_OPEN_RATE                                              
MFA-TR*              ,TEST_PROVER_ID                                            
MFA-TR*              ,OUT_READ                                                  
MFA-TR*              ,OUT_CHECK_RATE                                            
MFA-TR*              ,OUT_OPEN_RATE                                             
MFA-TR*              ,CODE_REPAIR                                               
MFA-TR*              ,REPAIR_DESC                                               
MFA-TR*          INTO                                                           
MFA-TR*               :GT-CODE-TEST-TYPE                                        
MFA-TR*              ,:GT-CODE-TEST-LOC                                         
MFA-TR*              ,:GT-CODE-TEST-RESULT                                      
MFA-TR*              ,:GT-EQ-TESTER-ID                                          
MFA-TR*              ,:GT-IN-READ                                               
MFA-TR*              ,:GT-IN-CHECK-RATE                                         
MFA-TR*              ,:GT-IN-OPEN-RATE                                          
MFA-TR*              ,:GT-TEST-PROVER-ID                                        
MFA-TR*              ,:GT-OUT-READ                                              
MFA-TR*              ,:GT-OUT-CHECK-RATE                                        
MFA-TR*              ,:GT-OUT-OPEN-RATE                                         
MFA-TR*              ,:GT-CODE-REPAIR                                           
MFA-TR*              ,:GT-REPAIR-DESC                                           
MFA-TR*          FROM CSS_GAS_MTR_TEST GT                                       
MFA-TR*         WHERE GT.COMPANY_NO     = :GT-COMPANY-NO                        
MFA-TR*           AND GT.CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                    
MFA-TR*           AND GT.METER_NO       = :GT-METER-NO                          
MFA-TR*           AND GT.DATE_TEST      = :GT-DATE-TEST                         
MFA-TR*           AND GT.TIME_TEST      = :GT-TIME-TEST                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7950'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-2               
               MOVE 'DATE_TEST'        TO TABLE-ELEMENT-3               
               MOVE 'TIME_TEST'        TO TABLE-ELEMENT-4               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-2             
               MOVE GT-DATE-TEST       TO HOSTVAR-ELEMENT-3             
               MOVE GT-TIME-TEST       TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 8100-UPDATE-TEST-HIST.                                         *        
      ******************************************************************        
       8100-UPDATE-TEST-HIST.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_MTR_TEST_HIST                                  
                 SET TESTED_QT       = :MQ-TESTED-QT                    
                    ,STATUS_CD       = :MQ-STATUS-CD                    
               WHERE COMPANY_NO      = :MQ-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE               
                 AND TEST_YEAR       = :MQ-TEST-YEAR                    
                 AND TEST_SCHED_CD   = :MQ-TEST-SCHED-CD                
                 AND MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '8100'             TO ACTIVE-PARAGRAPH              
               MOVE 'UPDATE'           TO ABEND-FUNCTION                
               MOVE 'CSS_MTR_TEST_HIST' TO TABLE-1                      
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'TEST_YEAR'        TO TABLE-ELEMENT-2               
               MOVE 'TEST_SCHED_CD'    TO TABLE-ELEMENT-3               
               MOVE 'MTR_TEST_GRP_CD'  TO TABLE-ELEMENT-4               
               MOVE MQ-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE MQ-TEST-YEAR       TO HOSTVAR-ELEMENT-2             
               MOVE MQ-TEST-SCHED-CD   TO HOSTVAR-ELEMENT-3             
               MOVE MQ-MTR-TEST-GRP-CD TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-UPDATE-LAST-TRAN.                                         *        
      ******************************************************************        
       8200-UPDATE-LAST-TRAN.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
                  SET DATE_LAST_TRAN = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN) )               
                WHERE COMPANY_NO     = :EQ-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE               
                  AND DEVICE_NO      = :EQ-DEVICE-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*           SET DATE_LAST_TRAN = :EQ-DATE-LAST-TRAN                       
MFA-TR*         WHERE COMPANY_NO     = :EQ-COMPANY-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                       
MFA-TR*           AND DEVICE_NO      = :EQ-DEVICE-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '8200'             TO ACTIVE-PARAGRAPH              
               MOVE 'UPDATE'           TO ABEND-FUNCTION                
               MOVE 'CSS_EQUIPMENT'    TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
               MOVE 'DEVICE_NO'        TO TABLE-ELEMENT-3               
               MOVE EQ-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE EQ-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
               MOVE EQ-DEVICE-NO       TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-UPDATE-LAST-TESTED.                                       *        
      ******************************************************************        
       8300-UPDATE-LAST-TESTED.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_GAS_METER                                     
                  SET DATE_LAST_TESTED = IIF(TRY_CONVERT(DATE, 
                                                  :GM-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) IS NULL OR (PATINDEX('%.%', :GM-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) <> 0) OR (LEN(:GM-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) <> 10), CIS.CHAR2DATE(:GM-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ), CONVERT(DATE, :GM-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) )       
                WHERE COMPANY_NO       = :GM-COMPANY-NO                 
                  AND CODE_UTIL_TYPE   = :GM-CODE-UTIL-TYPE             
                  AND METER_NO         = :GM-METER-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_GAS_METER                                             
MFA-TR*           SET DATE_LAST_TESTED = :GM-DATE-LAST-TESTED                   
MFA-TR*                                  :WS-DATE-LAST-TESTED-IND               
MFA-TR*         WHERE COMPANY_NO       = :GM-COMPANY-NO                         
MFA-TR*           AND CODE_UTIL_TYPE   = :GM-CODE-UTIL-TYPE                     
MFA-TR*           AND METER_NO         = :GM-METER-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '8300'             TO ACTIVE-PARAGRAPH              
               MOVE 'UPDATE'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_METER'    TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-2               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-3               
               MOVE GM-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2             
               MOVE GM-METER-NO        TO HOSTVAR-ELEMENT-3             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-INSERT-GAS-MTR-TEST.                                      *        
      ******************************************************************        
       8400-INSERT-GAS-MTR-TEST.                                        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_GAS_MTR_TEST                             
                      (                                                 
                      CODE_UTIL_TYPE                                    
                     ,METER_NO                                          
                     ,DATE_TEST                                         
                     ,TIME_TEST                                         
                     ,CODE_TIME_PERIOD                                  
                     ,CODE_CAP_TYPE                                     
                     ,CODE_REPAIR                                       
                     ,REPAIR_DESC                                       
                     ,CODE_TEST_TYPE                                    
                     ,CODE_TEST_LOC                                     
                     ,CODE_TEST_RESULT                                  
                     ,IN_CHECK_RATE                                     
                     ,IN_INTER_RATE                                     
                     ,IN_OPEN_RATE                                      
                     ,IN_READ                                           
                     ,OUT_CHECK_RATE                                    
                     ,OUT_INTER_RATE                                    
                     ,OUT_OPEN_RATE                                     
                     ,OUT_READ                                          
                     ,EQ_TESTER_ID                                      
                     ,TEST_PROVER_ID                                    
                     ,COMPANY_NO                                        
                      )                                                 
               VALUES                                                   
                      (                                                 
                      :GT-CODE-UTIL-TYPE                                
                     ,:GT-METER-NO                                      
                     ,IIF(TRY_CONVERT(DATE, :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                                
                     ,CIS.CHAR2TIME(:GT-TIME-TEST)                              
                     ,:GT-CODE-TIME-PERIOD                              
                     ,:GT-CODE-CAP-TYPE                                 
                     ,:GT-CODE-REPAIR                                   
                     ,:GT-REPAIR-DESC                                   
                     ,:GT-CODE-TEST-TYPE                                
                     ,:GT-CODE-TEST-LOC                                 
                     ,:GT-CODE-TEST-RESULT                              
                     ,:GT-IN-CHECK-RATE                                 
                     ,:GT-IN-INTER-RATE                                 
                     ,:GT-IN-OPEN-RATE                                  
                     ,:GT-IN-READ                                       
                     ,:GT-OUT-CHECK-RATE                                
                     ,:GT-OUT-INTER-RATE                                
                     ,:GT-OUT-OPEN-RATE                                 
                     ,:GT-OUT-READ                                      
                     ,:GT-EQ-TESTER-ID                                  
                     ,:GT-TEST-PROVER-ID                                
                     ,:GT-COMPANY-NO                                    
                      )                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_GAS_MTR_TEST                                     
MFA-TR*               (                                                         
MFA-TR*               CODE_UTIL_TYPE                                            
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,DATE_TEST                                                 
MFA-TR*              ,TIME_TEST                                                 
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,CODE_CAP_TYPE                                             
MFA-TR*              ,CODE_REPAIR                                               
MFA-TR*              ,REPAIR_DESC                                               
MFA-TR*              ,CODE_TEST_TYPE                                            
MFA-TR*              ,CODE_TEST_LOC                                             
MFA-TR*              ,CODE_TEST_RESULT                                          
MFA-TR*              ,IN_CHECK_RATE                                             
MFA-TR*              ,IN_INTER_RATE                                             
MFA-TR*              ,IN_OPEN_RATE                                              
MFA-TR*              ,IN_READ                                                   
MFA-TR*              ,OUT_CHECK_RATE                                            
MFA-TR*              ,OUT_INTER_RATE                                            
MFA-TR*              ,OUT_OPEN_RATE                                             
MFA-TR*              ,OUT_READ                                                  
MFA-TR*              ,EQ_TESTER_ID                                              
MFA-TR*              ,TEST_PROVER_ID                                            
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*               )                                                         
MFA-TR*        VALUES                                                           
MFA-TR*               (                                                         
MFA-TR*               :GT-CODE-UTIL-TYPE                                        
MFA-TR*              ,:GT-METER-NO                                              
MFA-TR*              ,:GT-DATE-TEST                                             
MFA-TR*              ,:GT-TIME-TEST                                             
MFA-TR*              ,:GT-CODE-TIME-PERIOD                                      
MFA-TR*              ,:GT-CODE-CAP-TYPE                                         
MFA-TR*              ,:GT-CODE-REPAIR                                           
MFA-TR*              ,:GT-REPAIR-DESC                                           
MFA-TR*              ,:GT-CODE-TEST-TYPE                                        
MFA-TR*              ,:GT-CODE-TEST-LOC                                         
MFA-TR*              ,:GT-CODE-TEST-RESULT                                      
MFA-TR*              ,:GT-IN-CHECK-RATE                                         
MFA-TR*              ,:GT-IN-INTER-RATE                                         
MFA-TR*              ,:GT-IN-OPEN-RATE                                          
MFA-TR*              ,:GT-IN-READ                                               
MFA-TR*              ,:GT-OUT-CHECK-RATE                                        
MFA-TR*              ,:GT-OUT-INTER-RATE                                        
MFA-TR*              ,:GT-OUT-OPEN-RATE                                         
MFA-TR*              ,:GT-OUT-READ                                              
MFA-TR*              ,:GT-EQ-TESTER-ID                                          
MFA-TR*              ,:GT-TEST-PROVER-ID                                        
MFA-TR*              ,:GT-COMPANY-NO                                            
MFA-TR*               )                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '8400'             TO ACTIVE-PARAGRAPH              
               MOVE 'INSERT'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-2               
               MOVE 'DATE_TEST'        TO TABLE-ELEMENT-3               
               MOVE 'TIME_TEST'        TO TABLE-ELEMENT-4               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-2             
               MOVE GT-DATE-TEST       TO HOSTVAR-ELEMENT-3             
               MOVE GT-TIME-TEST       TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8500-INSERT-WQ-ITEM.                                           *        
      ******************************************************************        
       8500-INSERT-WQ-ITEM.                                             
                                                                        
ACT084     INITIALIZE   WS-MCSCB077-OUTPUT.                             
ACT084     INITIALIZE   ABEND-FUNCTION.                                 
                                                                        
ACT084     CALL MCSCB077 USING CWS00077-FIELDS,                         
ACT084                         ABEND-FILE,                              
ACT084                         WS-MCSCB077-RET-CODE.                    
                                                                        
ACT084     MOVE WS-MCSCB077-RET-CODE     TO WS-ACTIVE-RETURN-CODE       
ACT084                                                                  
ACT084     IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
ACT084        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT084        MOVE '8500'                TO ACTIVE-PARAGRAPH            
ACT084        MOVE 'CALL'                TO ABEND-FUNCTION              
ACT084        MOVE 'MCSCB077'            TO TABLE-1                     
ACT084        MOVE 'CUSTOMER NO'         TO TABLE-ELEMENT-1             
ACT084        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT084        MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-3             
ACT084        MOVE WS-77-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1           
ACT084        MOVE WS-77-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
ACT084        MOVE WS-77-PREMISE-NO      TO HOSTVAR-ELEMENT-3           
ACT084        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
ACT084        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
ACT084     END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8600-DELETE-GM-TEST.                                           *        
      ******************************************************************        
       8600-DELETE-GM-TEST.                                             
                                                                        
           EXEC SQL                                                     
               DELETE FROM GT                           
               FROM CSS_GAS_MTR_TEST GT
                WHERE COMPANY_NO     = :GT-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE               
                  AND METER_NO       = :GT-METER-NO                     
                  AND DATE_TEST      = IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                    
                  AND TIME_TEST      = CIS.CHAR2TIME(:GT-TIME-TEST)             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_GAS_MTR_TEST GT                                  
MFA-TR*         WHERE COMPANY_NO     = :GT-COMPANY-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO       = :GT-METER-NO                             
MFA-TR*           AND DATE_TEST      = :GT-DATE-TEST                            
MFA-TR*           AND TIME_TEST      = :GT-TIME-TEST                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '8600'             TO ACTIVE-PARAGRAPH              
               MOVE 'DELETE'           TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-2               
               MOVE 'DATE_TEST'        TO TABLE-ELEMENT-3               
               MOVE 'TIME_TEST'        TO TABLE-ELEMENT-4               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-2             
               MOVE GT-DATE-TEST       TO HOSTVAR-ELEMENT-3             
               MOVE GT-TIME-TEST       TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8700-UPDATE-GAS-MTR-TEST.                                     *         
      ******************************************************************        
       8700-UPDATE-GAS-MTR-TEST.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_GAS_MTR_TEST                                  
                  SET CODE_REPAIR    = :GT-CODE-REPAIR                  
                     ,REPAIR_DESC    = :GT-REPAIR-DESC                  
                     ,CODE_TEST_TYPE = :GT-CODE-TEST-TYPE               
                     ,CODE_TEST_LOC  = :GT-CODE-TEST-LOC                
                     ,IN_CHECK_RATE  = :GT-IN-CHECK-RATE                
                     ,IN_INTER_RATE  = :GT-IN-INTER-RATE                
                     ,IN_OPEN_RATE   = :GT-IN-OPEN-RATE                 
                     ,IN_READ        = :GT-IN-READ                      
                     ,OUT_CHECK_RATE = :GT-OUT-CHECK-RATE               
                     ,OUT_INTER_RATE = :GT-OUT-INTER-RATE               
                     ,OUT_OPEN_RATE  = :GT-OUT-OPEN-RATE                
                     ,OUT_READ       = :GT-OUT-READ                     
                     ,EQ_TESTER_ID   = :GT-EQ-TESTER-ID                 
                     ,TEST_PROVER_ID = :GT-TEST-PROVER-ID               
                WHERE COMPANY_NO     = :GT-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE               
                  AND METER_NO       = :GT-METER-NO                     
                  AND DATE_TEST      = IIF(TRY_CONVERT(DATE, 
                                                          :GT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :GT-DATE-TEST
              ) <> 0) OR (LEN(:GT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :GT-DATE-TEST
              ), CONVERT(DATE, :GT-DATE-TEST) )                    
                  AND TIME_TEST      = CIS.CHAR2TIME(:GT-TIME-TEST)             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_GAS_MTR_TEST                                          
MFA-TR*           SET CODE_REPAIR    = :GT-CODE-REPAIR                          
MFA-TR*              ,REPAIR_DESC    = :GT-REPAIR-DESC                          
MFA-TR*              ,CODE_TEST_TYPE = :GT-CODE-TEST-TYPE                       
MFA-TR*              ,CODE_TEST_LOC  = :GT-CODE-TEST-LOC                        
MFA-TR*              ,IN_CHECK_RATE  = :GT-IN-CHECK-RATE                        
MFA-TR*              ,IN_INTER_RATE  = :GT-IN-INTER-RATE                        
MFA-TR*              ,IN_OPEN_RATE   = :GT-IN-OPEN-RATE                         
MFA-TR*              ,IN_READ        = :GT-IN-READ                              
MFA-TR*              ,OUT_CHECK_RATE = :GT-OUT-CHECK-RATE                       
MFA-TR*              ,OUT_INTER_RATE = :GT-OUT-INTER-RATE                       
MFA-TR*              ,OUT_OPEN_RATE  = :GT-OUT-OPEN-RATE                        
MFA-TR*              ,OUT_READ       = :GT-OUT-READ                             
MFA-TR*              ,EQ_TESTER_ID   = :GT-EQ-TESTER-ID                         
MFA-TR*              ,TEST_PROVER_ID = :GT-TEST-PROVER-ID                       
MFA-TR*         WHERE COMPANY_NO     = :GT-COMPANY-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = :GT-CODE-UTIL-TYPE                       
MFA-TR*           AND METER_NO       = :GT-METER-NO                             
MFA-TR*           AND DATE_TEST      = :GT-DATE-TEST                            
MFA-TR*           AND TIME_TEST      = :GT-TIME-TEST                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '8700'             TO ACTIVE-PARAGRAPH              
               MOVE 'UPDATE'           TO ABEND-FUNCTION                
               MOVE 'CSS_GAS_MTR_TEST' TO TABLE-1                       
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1               
               MOVE 'METER_NO'         TO TABLE-ELEMENT-2               
               MOVE 'DATE_TEST'        TO TABLE-ELEMENT-3               
               MOVE 'TIME_TEST'        TO TABLE-ELEMENT-4               
               MOVE GT-COMPANY-NO      TO HOSTVAR-ELEMENT-1             
               MOVE GT-METER-NO        TO HOSTVAR-ELEMENT-2             
               MOVE GT-DATE-TEST       TO HOSTVAR-ELEMENT-3             
               MOVE GT-TIME-TEST       TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT                                        *         
      * 9999-END-PROGRAM                                              *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
