       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04221.                                         
COB303 DATE-WRITTEN.  DEC 18 2008.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00100000
      *                 P R O G R A M  S U M M A R Y                   *00110000
      *                                                                *00120000
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR METER TEST     *00130000
      *  DETAILS UPDATE                                                *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                     PROGRAM MODIFICATION LOG                   *00180000
      *                                                                *00190000
      *    DATE    INITIALS   COMMENTS                                 *00200000
      *  --------  --------   ---------------------------------------  *00210000
      *  12/18/08  SJ94244    PROCEDURE ORIGINALLY CODED.              *00220000
      *                                                                *00230000
      ******************************************************************00240000
      ******************************************************************00250000
      *                                                                *00260000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00270000
      *                                                                *00280000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00290000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00300000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00310000
      *  3000 - 4999  NOT USED                                         *00320000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00330000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00340000
      *  7000 - 7999  INPUT MODULES                                    *00350000
      *  8000 - 8999  OUTPUT MODULES                                   *00360000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00370000
      *                                                                *00380000
      ******************************************************************00390000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04221'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04221 STARTS HERE'.                  
                                                                        
      ******************************************************************00480000
      *    WORK AREAS                                                  *00490000
      ******************************************************************00500000
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-TEST-VARIABLE        PIC X(01) VALUE SPACES.          
                                                                        
       01  WS-VARIABLES.                                                
           05  WS-LOCATION-RETIRED     PIC X(01) VALUE 'I'.             
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-LASTTESTDATE         PIC X(10) VALUE SPACES.          
                                                                        
       01  WS-NULL-IND.                                                 
           05 WS-NULL-IND-1            PIC S9(4) COMP.                  
           05 WS-NULL-IND-2            PIC S9(4) COMP.                  
                                                                        
       01  WS-INPUT-MISC.                                               
           05  WS-IN-UPDATE-IND        PIC X(01) VALUE SPACES.          
           05  WS-IN-COMPANY-NO        PIC X(02) VALUE SPACES.          
           05  WS-IN-CODE-UTIL-TYPE    PIC X(01) VALUE SPACES.          
           05  WS-IN-CODE-ATT-TYPE     PIC X(02) VALUE SPACES.          
           05  WS-IN-DEVICE-NO         PIC X(12) VALUE SPACES.          
           05  WS-IN-DATE-TEST         PIC X(10) VALUE SPACES.          
           05  WS-IN-TIME-TEST         PIC X(08) VALUE SPACES.          
           05  WS-IN-CODE-TEST-TYPE    PIC X(01) VALUE SPACES.          
           05  WS-IN-CODE-REPAIR       PIC X(01) VALUE SPACES.          
           05  WS-IN-REPAIR-DESC       PIC X(44) VALUE SPACES.          
                                                                        
      ******************** THIS IS THE ROW RETURN AREA **************** 00770000
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04221'.      
                                                                        
      ******************************************************************00930000
      *    DB2 INCLUDES                                                *00940000
      ******************************************************************00950000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE SQLCA                                             00980000
           END-EXEC.                                                    00990000
      *                                                                 01000000
      ******************************************************************01010000
      * CSS_EQUIP_ATT_TEST - LY                                        *01020000
      ******************************************************************01030000
           EXEC SQL                                                     01040000
              INCLUDE TBEQTEST                                          01050000
           END-EXEC.                                                    01060000
      *                                                                 01070000
      ******************************************************************01080000
      * CSS_EQUIP_ATTCHMTS - LX                                        *01090000
      ******************************************************************01100000
           EXEC SQL                                                     01110000
              INCLUDE TBEQATTH                                          01120000
           END-EXEC.                                                    01130000
      *                                                                 01140000
      ******************************************************************01150000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01160000
      ******************************************************************01170000
                                                                        
           COPY CWS00303.                                               01190000
                                                                        
           EXEC SQL                                                     01210000
              INCLUDE CWSX0010                                          01220000
           END-EXEC.                                                    01230000
                                                                        
HPCCDM*EJECT                                                            01250000
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01 PARM-IN-UPDATE-IND           PIC X(01) VALUE SPACES.          
       01 PARM-IN-COMPANY-NO           PIC X(02) VALUE SPACES.          
       01 PARM-IN-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.          
       01 PARM-IN-CODE-ATT-TYPE        PIC X(02) VALUE SPACES.          
       01 PARM-IN-DEVICE-NO            PIC X(12) VALUE SPACES.          
       01 PARM-IN-DATE-TEST            PIC X(10) VALUE SPACES.          
       01 PARM-IN-TIME-TEST            PIC X(08) VALUE SPACES.          
       01 PARM-IN-CODE-TEST-TYPE       PIC X(01) VALUE SPACES.          
       01 PARM-IN-CODE-REPAIR          PIC X(01) VALUE SPACES.          
       01 PARM-IN-REPAIR-DESC          PIC X(44) VALUE SPACES.          
                                                                        
                                                                        
       PROCEDURE DIVISION USING PARM-IN-UPDATE-IND                      
                                PARM-IN-COMPANY-NO                      
                                PARM-IN-CODE-UTIL-TYPE                  
                                PARM-IN-CODE-ATT-TYPE                   
                                PARM-IN-DEVICE-NO                       
                                PARM-IN-DATE-TEST                       
                                PARM-IN-TIME-TEST                       
                                PARM-IN-CODE-TEST-TYPE                  
                                PARM-IN-CODE-REPAIR                     
                                PARM-IN-REPAIR-DESC.                    
                                                                        
      ******************************************************************01520000
      *0000-MAINLINE                                                   *01530000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01540000
      ******************************************************************01550000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************01670000
      *0100-INITIALIZE                                                 *01680000
      *                                                                *01690000
      ******************************************************************01700000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE AS RETURN_CODE                          
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     01770000
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         01780000
MFA-TR*       SELECT                                                    01790000
MFA-TR*          :S-RETURN-CODE AS RETURN_CODE                          01800000
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                     01810000
MFA-TR*    END-EXEC.                                                    01820000
                                                                        
           PERFORM 7100-SELECT-CURR-DATE THRU 7100-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01890000
      *1000-PROCESS-INPUT                                              *01900000
      ******************************************************************01910000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-IN-UPDATE-IND     TO   WS-IN-UPDATE-IND.           
           MOVE PARM-IN-COMPANY-NO     TO   WS-IN-COMPANY-NO            
                                            LY-COMPANY-NO               
                                            LX-COMPANY-NO.              
                                                                        
           MOVE PARM-IN-CODE-UTIL-TYPE TO   WS-IN-CODE-UTIL-TYPE        
                                            LY-CODE-UTIL-TYPE           
                                            LX-CODE-UTIL-TYPE.          
                                                                        
           MOVE PARM-IN-CODE-ATT-TYPE  TO   WS-IN-CODE-ATT-TYPE         
                                            LY-CODE-ATT-TYPE            
                                            LX-CODE-ATT-TYPE.           
                                                                        
           MOVE PARM-IN-DEVICE-NO      TO   WS-IN-DEVICE-NO             
                                            LY-DEVICE-NO                
                                            LX-DEVICE-NO.               
                                                                        
           MOVE PARM-IN-DATE-TEST      TO   WS-IN-DATE-TEST             
                                            LY-DATE-TEST.               
                                                                        
           MOVE PARM-IN-TIME-TEST      TO   WS-IN-TIME-TEST.            
           MOVE PARM-IN-CODE-TEST-TYPE TO   WS-IN-CODE-TEST-TYPE.       
           MOVE PARM-IN-CODE-REPAIR    TO   WS-IN-CODE-REPAIR.          
           MOVE PARM-IN-REPAIR-DESC    TO   WS-IN-REPAIR-DESC.          
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS  THRU 1200-EXIT.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *02240000
      ******************************************************************02250000
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-IN-CODE-UTIL-TYPE = SPACES                           
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'PARM-IN-CODE-UTIL-TYPE' TO TABLE-1                  
              MOVE 'PARM-IN-CODE-UTIL-TYPE' TO TABLE-ELEMENT-1          
              MOVE PARM-IN-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF PARM-IN-COMPANY-NO = SPACES                               
              MOVE 9997                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'PARM-IN-COMPANY-NO'     TO TABLE-1                  
              MOVE 'PARM-IN-COMPANY-NO'     TO TABLE-ELEMENT-1          
              MOVE PARM-IN-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02550000
      *2000-PROCESS-OUTPUT                                             *02560000
      ******************************************************************02570000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-IN-UPDATE-IND = 'I'                                    
              PERFORM 7200-SELECT-EQUIP-LOCATION  THRU 7200-EXIT        
              PERFORM 2100-VALIDATION-PROCESS     THRU 2100-EXIT        
              PERFORM 7300-CHECK-EXISTENCE        THRU 7300-EXIT        
              IF WS-TEST-VARIABLE  = 'Y'                                
                 MOVE 5300 TO RS-RETURN-CODE                            
                 PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT       
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
              PERFORM 2200-UPDATE-PROCESS         THRU 2200-EXIT        
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02750000
      *2000A-MOVE-RESULT                                               *02760000
      ******************************************************************02770000
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
           ADD +1                        TO CTR-ROWS.                   
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************02860000
      *2100-VALIDATION-PROCESS                                         *02870000
      ******************************************************************02880000
       2100-VALIDATION-PROCESS.                                         
                                                                        
           IF LX-EQUIP-LOC-ID = WS-LOCATION-RETIRED                     
              MOVE 5100 TO RS-RETURN-CODE                               
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND-1 = 0                                         
              MOVE LX-DATE-LAST-TESTED    TO WS-LASTTESTDATE            
           ELSE                                                         
              MOVE WS-CURRENT-DATE        TO WS-LASTTESTDATE            
           END-IF.                                                      
                                                                        
           IF WS-IN-DATE-TEST < WS-LASTTESTDATE                         
              MOVE 5200 TO RS-RETURN-CODE                               
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03120000
      *2200-UPDATE-PROCESS                                             *03130000
      ******************************************************************03140000
       2200-UPDATE-PROCESS.                                             
                                                                        
           PERFORM 7400-SELECT-DATE-TEST        THRU 7400-EXIT.         
           PERFORM 8100-UPDATE-LAST-TEST-DATE   THRU 8100-EXIT.         
           MOVE WS-IN-COMPANY-NO     TO  LY-COMPANY-NO.                 
           MOVE WS-IN-CODE-UTIL-TYPE TO  LY-CODE-UTIL-TYPE.             
           MOVE WS-IN-CODE-ATT-TYPE  TO  LY-CODE-ATT-TYPE.              
           MOVE WS-IN-DEVICE-NO      TO  LY-DEVICE-NO.                  
           MOVE WS-IN-DATE-TEST      TO  LY-DATE-TEST.                  
           MOVE WS-IN-TIME-TEST      TO  LY-TIME-TEST.                  
           MOVE WS-IN-CODE-TEST-TYPE TO  LY-CODE-TEST-TYPE.             
           MOVE WS-IN-CODE-REPAIR    TO  LY-CODE-REPAIR.                
           MOVE WS-IN-REPAIR-DESC    TO  LY-REPAIR-DESC.                
           PERFORM 8200-INSERT-TEST-DETAILS     THRU 8200-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03330000
      *7100-SELECT-CURR-DATE                                           *03340000
      ******************************************************************03350000
       7100-SELECT-CURR-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     03380000
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                  03390000
MFA-TR*    END-EXEC.                                                    03400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7100'             TO ACTIVE-PARAGRAPH              
               MOVE 'SET'              TO ABEND-FUNCTION                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03570000
      *7200-SELECT-EQUIP-LOCATION                                      *03580000
      ******************************************************************03590000
       7200-SELECT-EQUIP-LOCATION.                                      
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                     EQUIP_LOC_ID                                       
                    ,DATE_LAST_TESTED                                   
                INTO                                                    
                     :LX-EQUIP-LOC-ID                                   
                    ,:LX-DATE-LAST-TESTED :WS-NULL-IND-1                 
                FROM                                                    
                     CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     COMPANY_NO     = :LX-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :LX-DEVICE-NO                     
                 AND CODE_ATT_TYPE  = :LX-CODE-ATT-TYPE                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03620000
MFA-TR*       SELECT                                                    03630000
MFA-TR*              EQUIP_LOC_ID                                       03640001
MFA-TR*             ,DATE_LAST_TESTED                                   03650001
MFA-TR*         INTO                                                    03660001
MFA-TR*              :LX-EQUIP-LOC-ID                                   03670001
MFA-TR*             ,:LX-DATE-LAST-TESTED:WS-NULL-IND-1                 03680001
MFA-TR*         FROM                                                    03690001
MFA-TR*              CSS_EQUIP_ATTCHMTS                                 03700001
MFA-TR*        WHERE                                                    03710001
MFA-TR*              COMPANY_NO     = :LX-COMPANY-NO                    03720001
MFA-TR*          AND CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                03730001
MFA-TR*          AND DEVICE_NO      = :LX-DEVICE-NO                     03740001
MFA-TR*          AND CODE_ATT_TYPE  = :LX-CODE-ATT-TYPE                 03750001
MFA-TR*         WITH UR                                                 03760001
MFA-TR*    END-EXEC.                                                    03770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                NEXT SENTENCE                                           
           ELSE                                                         
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7200'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                   
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1           
                MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2           
                MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3           
                MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-4           
                MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
                MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2         
                MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-3         
                MOVE LX-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-4         
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04020000
      *7300-CHECK-EXISTENCE                                            *04030000
      ******************************************************************04040000
       7300-CHECK-EXISTENCE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO                                                    
                     :WS-TEST-VARIABLE                                  
                FROM                                                    
                     CSS_EQUIP_ATT_TEST WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     COMPANY_NO     = :LY-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :LY-CODE-UTIL-TYPE                
                 AND CODE_ATT_TYPE  = :LY-CODE-ATT-TYPE                 
                 AND DATE_TEST      = IIF(TRY_CONVERT(DATE, 
                                                          :LY-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :LY-DATE-TEST
              ) <> 0) OR (LEN(:LY-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :LY-DATE-TEST
              ), CONVERT(DATE, :LY-DATE-TEST) )                     
                 AND DEVICE_NO      = :LY-DEVICE-NO                     
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04070000
MFA-TR*       SELECT                                                    04080000
MFA-TR*              'Y'                                                04090001
MFA-TR*         INTO                                                    04100001
MFA-TR*              :WS-TEST-VARIABLE                                  04110001
MFA-TR*         FROM                                                    04120001
MFA-TR*              CSS_EQUIP_ATT_TEST                                 04130001
MFA-TR*        WHERE                                                    04140001
MFA-TR*              COMPANY_NO     = :LY-COMPANY-NO                    04150001
MFA-TR*          AND CODE_UTIL_TYPE = :LY-CODE-UTIL-TYPE                04160001
MFA-TR*          AND CODE_ATT_TYPE  = :LY-CODE-ATT-TYPE                 04170001
MFA-TR*          AND DATE_TEST      = :LY-DATE-TEST                     04180001
MFA-TR*          AND DEVICE_NO      = :LY-DEVICE-NO                     04190001
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                           04200001
MFA-TR*    END-EXEC.                                                    04210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                 NEXT SENTENCE                                          
           ELSE                                                         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7300'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_EQUIP_ATT_TEST'  TO TABLE-1                  
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1          
                 MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2          
                 MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3          
                 MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-4          
                 MOVE LY-COMPANY-NO         TO HOSTVAR-ELEMENT-1        
                 MOVE LY-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2        
                 MOVE LY-DEVICE-NO          TO HOSTVAR-ELEMENT-3        
                 MOVE LY-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-4        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04470000
      *7400-SELECT-DATE-TEST                                           *04480000
      ******************************************************************04490000
       7400-SELECT-DATE-TEST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DATE_TEST                                          
                INTO                                                    
                     :LY-DATE-TEST :WS-NULL-IND-2                        
                FROM                                                    
                     CSS_EQUIP_ATT_TEST WITH(READUNCOMMITTED)                   
               WHERE                                                    
                     COMPANY_NO     = :LY-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :LY-CODE-UTIL-TYPE                
                 AND CODE_ATT_TYPE  = :LY-CODE-ATT-TYPE                 
                 AND DEVICE_NO      = :LY-DEVICE-NO                     
               ORDER BY DATE_TEST DESC                                  
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04520000
MFA-TR*       SELECT                                                    04530000
MFA-TR*              DATE_TEST                                          04540001
MFA-TR*         INTO                                                    04550001
MFA-TR*              :LY-DATE-TEST:WS-NULL-IND-2                        04560001
MFA-TR*         FROM                                                    04570001
MFA-TR*              CSS_EQUIP_ATT_TEST                                 04580001
MFA-TR*        WHERE                                                    04590001
MFA-TR*              COMPANY_NO     = :LY-COMPANY-NO                    04600001
MFA-TR*          AND CODE_UTIL_TYPE = :LY-CODE-UTIL-TYPE                04610001
MFA-TR*          AND CODE_ATT_TYPE  = :LY-CODE-ATT-TYPE                 04620001
MFA-TR*          AND DEVICE_NO      = :LY-DEVICE-NO                     04630001
MFA-TR*        ORDER BY DATE_TEST DESC                                  04640001
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                           04650001
MFA-TR*    END-EXEC.                                                    04670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-IND-2 = -1 OR LY-DATE-TEST = SPACES            
                 MOVE WS-CURRENT-DATE TO LX-DATE-LAST-TESTED            
              ELSE                                                      
                 MOVE LY-DATE-TEST    TO LX-DATE-LAST-TESTED            
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-CURRENT-DATE TO LX-DATE-LAST-TESTED            
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7400'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_EQUIP_ATT_TEST'  TO TABLE-1                  
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1          
                 MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2          
                 MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3          
                 MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-4          
                 MOVE LY-COMPANY-NO         TO HOSTVAR-ELEMENT-1        
                 MOVE LY-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2        
                 MOVE LY-DEVICE-NO          TO HOSTVAR-ELEMENT-3        
                 MOVE LY-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-4        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05020000
      *8100-UPDATE-LAST-TEST-DATE                                      *05030000
      ******************************************************************05040000
       8100-UPDATE-LAST-TEST-DATE.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE                                                    
                     CSS_EQUIP_ATTCHMTS                                 
                 SET                                                    
                     DATE_LAST_TESTED = IIF(TRY_CONVERT(DATE, 
                                                   :LX-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:LX-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TESTED
              ), CONVERT(DATE, :LX-DATE-LAST-TESTED) )            
               WHERE                                                    
                     COMPANY_NO       = :LX-COMPANY-NO                  
                 AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE              
                 AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE               
                 AND DEVICE_NO        = :LX-DEVICE-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05070000
MFA-TR*       UPDATE                                                    05080000
MFA-TR*              CSS_EQUIP_ATTCHMTS                                 05090001
MFA-TR*          SET                                                    05100001
MFA-TR*              DATE_LAST_TESTED = :LX-DATE-LAST-TESTED            05110001
MFA-TR*        WHERE                                                    05120001
MFA-TR*              COMPANY_NO       = :LX-COMPANY-NO                  05130001
MFA-TR*          AND CODE_UTIL_TYPE   = :LX-CODE-UTIL-TYPE              05140001
MFA-TR*          AND CODE_ATT_TYPE    = :LX-CODE-ATT-TYPE               05150001
MFA-TR*          AND DEVICE_NO        = :LX-DEVICE-NO                   05160001
MFA-TR*    END-EXEC.                                                    05170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8100'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-3            
               MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-4            
               MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-3          
               MOVE LX-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05430000
      *8200-INSERT-TEST-DETAILS                                        *05440000
      ******************************************************************05450000
       8200-INSERT-TEST-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIP_ATT_TEST                           
               (                                                        
                   COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,CODE_ATT_TYPE                                        
                  ,DEVICE_NO                                            
                  ,DATE_TEST                                            
                  ,TIME_TEST                                            
                  ,CODE_TEST_TYPE                                       
                  ,CODE_REPAIR                                          
                  ,REPAIR_DESC                                          
               )                                                        
               VALUES                                                   
               (                                                        
                  :LY-COMPANY-NO,                                       
                  :LY-CODE-UTIL-TYPE,                                   
                  :LY-CODE-ATT-TYPE,                                    
                  :LY-DEVICE-NO,                                        
                  IIF(TRY_CONVERT(DATE, :LY-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :LY-DATE-TEST
              ) <> 0) OR (LEN(:LY-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :LY-DATE-TEST
              ), CONVERT(DATE, :LY-DATE-TEST) ),                               
                  CIS.CHAR2TIME(:LY-TIME-TEST),                                 
                  :LY-CODE-TEST-TYPE,                                   
                  :LY-CODE-REPAIR,                                      
                  :LY-REPAIR-DESC                                       
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05480000
MFA-TR*        INSERT INTO CSS_EQUIP_ATT_TEST                           05490000
MFA-TR*        (                                                        05500000
MFA-TR*            COMPANY_NO                                           05510000
MFA-TR*           ,CODE_UTIL_TYPE                                       05520000
MFA-TR*           ,CODE_ATT_TYPE                                        05530000
MFA-TR*           ,DEVICE_NO                                            05540000
MFA-TR*           ,DATE_TEST                                            05550000
MFA-TR*           ,TIME_TEST                                            05560000
MFA-TR*           ,CODE_TEST_TYPE                                       05570000
MFA-TR*           ,CODE_REPAIR                                          05580000
MFA-TR*           ,REPAIR_DESC                                          05590000
MFA-TR*        )                                                        05600000
MFA-TR*        VALUES                                                   05610000
MFA-TR*        (                                                        05620000
MFA-TR*           :LY-COMPANY-NO,                                       05630000
MFA-TR*           :LY-CODE-UTIL-TYPE,                                   05640000
MFA-TR*           :LY-CODE-ATT-TYPE,                                    05650000
MFA-TR*           :LY-DEVICE-NO,                                        05660000
MFA-TR*           :LY-DATE-TEST,                                        05670000
MFA-TR*           :LY-TIME-TEST,                                        05680000
MFA-TR*           :LY-CODE-TEST-TYPE,                                   05690000
MFA-TR*           :LY-CODE-REPAIR,                                      05700000
MFA-TR*           :LY-REPAIR-DESC                                       05710000
MFA-TR*        )                                                        05720000
MFA-TR*    END-EXEC.                                                    05730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD 1 TO CTR-ROWS                                        
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIP_ATT_TEST'    TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE 'CODE_ATT_TYPE'         TO TABLE-ELEMENT-4          
               MOVE LY-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE LY-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE LY-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               MOVE LY-CODE-ATT-TYPE        TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05990000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     * 06000000
      ***************************************************************** 06010000
           EXEC SQL                                                     06020000
              INCLUDE CPDSP300                                          06030000
           END-EXEC.                                                    06040000
                                                                        
      ***************************************************************** 06060000
      * 8900-SEND-DONE                                                * 06070000
      * 9000-SEND-ERROR-RESULT                                        * 06080000
      * 9999-END-PROGRAM                                              * 06090000
      ***************************************************************** 06100000
           EXEC SQL                                                     06110000
              INCLUDE CPD00321                                          06120000
           END-EXEC.                                                    06130000
